package Bencher::Scenario::PERLANCARParseArithmetic::parse_arithmetic;

our $DATE = '2016-06-16'; # DATE
our $VERSION = '0.001'; # VERSION

our $scenario = {
    summary => 'Benchmark parse_arithmetic()',
    modules => {
    },
    participants => [
        {
            fcall_template => 'PERLANCAR::Parse::Arithmetic::parse_arithmetic(<expr>)',
        },
    ],
    datasets => [
        {
            args => {expr => '1'},
        },
        {
            args => {expr => '1' . ('*1' x (  2-1)) },
        },
        {
            args => {expr => '1' . ('*1' x (  5-1)) },
        },
        {
            name => '1*1*...*1 (10x)',
            args => {expr => '1' . ('*1' x ( 10-1)) } },
        {
            name => '1*1*...*1 (20x)',
            args => {expr => '1' . ('*1' x ( 20-1)) },
        },
        {
            name => '1*1*...*1 (100x)',
            args => {expr => '1' . ('*1' x (100-1)) },
        },
    ],
};

1;
# ABSTRACT: Benchmark parse_arithmetic()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PERLANCARParseArithmetic::parse_arithmetic - Benchmark parse_arithmetic()

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::PERLANCARParseArithmetic::parse_arithmetic (from Perl distribution Bencher-Scenarios-PERLANCARParseArithmetic), released on 2016-06-16.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PERLANCARParseArithmetic::parse_arithmetic

To run module startup overhead benchmark:

 % bencher --module-startup -m PERLANCARParseArithmetic::parse_arithmetic

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<PERLANCAR::Parse::Arithmetic>

=head1 BENCHMARK PARTICIPANTS

=over

=item * PERLANCAR::Parse::Arithmetic::parse_arithmetic (perl_code)

Function call template:

 PERLANCAR::Parse::Arithmetic::parse_arithmetic(<expr>)



=back

=head1 BENCHMARK DATASETS

=over

=item * 1

=item * 1*1

=item * 1*1*1*1*1

=item * 1*1*...*1 (10x)

=item * 1*1*...*1 (20x)

=item * 1*1*...*1 (100x)

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PERLANCARParseArithmetic::parse_arithmetic >>):

 +------------------+-----------+-----------+------------+---------+---------+
 | dataset          | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +------------------+-----------+-----------+------------+---------+---------+
 | 1*1*...*1 (100x) | 2.4e+03   | 4.2e+02   | 1          | 1.1e-06 | 20      |
 | 1*1*...*1 (20x)  | 1.1e+04   | 90        | 4.7        | 3.4e-07 | 21      |
 | 1*1*...*1 (10x)  | 2.1e+04   | 47        | 8.9        | 2.1e-07 | 20      |
 | 1*1*1*1*1        | 3.9e+04   | 26        | 16         | 5.3e-08 | 20      |
 | 1*1              | 7.89e+04  | 12.7      | 33.1       | 6e-09   | 25      |
 | 1                | 1.3e+05   | 7.7       | 54         | 1.4e-08 | 30      |
 +------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PERLANCARParseArithmetic>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PERLANCARParseArithmetic>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PERLANCARParseArithmetic>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
