package Bencher::Scenario::PERLANCAR::In;

our $DATE = '2016-04-13'; # DATE
our $VERSION = '0.05'; # VERSION

use 5.010001;
use strict;
use warnings;

@main::ary_100  = (1..100);
@main::ary_10k  = (1..10_000);
@main::ary_1mil = (1..1000_000);

eval "package main; use List::Util 'first'"; die if $@;

our $scenario = {
    summary => 'Benchmark the task of checking whether an item is in an array',
    participants => [
        {
            name => 'grep',
            code_template => 'grep { $_ <op:raw> <needle> } @main::<haystack:raw>',
        },
        {
            name => 'first',
            code_template => 'first { $_ <op:raw> <needle> } @main::<haystack:raw>',
        },
        {
            name => 'first (array)',
            fcall_template => 'Array::AllUtils::first(sub { $_ <op:raw> <needle> }, \\@main::<haystack:raw>)',
        },
        {
            name => 'smartmatch',
            code_template => 'use experimental "smartmatch"; <needle> ~~ @main::<haystack:raw>',
        },
    ],
    datasets => [
        {name => '100 items' , args => {'haystack'=>'ary_100' , op => '==', 'needle@' => [1, 50, 100]}},
        {name => '10k' , args => {'haystack'=>'ary_10k' , op => '==', 'needle@' => [1, 5000, 10_000]}},
        {name => '1mil', args => {'haystack'=>'ary_1mil', op => '==', 'needle@' => [1, 500_000, 1000_000]}},
    ],
};

1;
# ABSTRACT: Benchmark the task of checking whether an item is in an array

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PERLANCAR::In - Benchmark the task of checking whether an item is in an array

=head1 VERSION

This document describes version 0.05 of Bencher::Scenario::PERLANCAR::In (from Perl distribution Bencher-Scenarios-PERLANCAR), released on 2016-04-13.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PERLANCAR::In

To run module startup overhead benchmark:

 % bencher --module-startup -m PERLANCAR::In

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Array::AllUtils> 0.002

=head1 BENCHMARK PARTICIPANTS

=over

=item * grep (perl_code)

Code template:

 grep { $_ <op:raw> <needle> } @main::<haystack:raw>



=item * first (perl_code)

Code template:

 first { $_ <op:raw> <needle> } @main::<haystack:raw>



=item * first (array) (perl_code)

Function call template:

 Array::AllUtils::first(sub { $_ <op:raw> <needle> }, \@main::<haystack:raw>)



=item * smartmatch (perl_code)

Code template:

 use experimental "smartmatch"; <needle> ~~ @main::<haystack:raw>



=back

=head1 BENCHMARK DATASETS

=over

=item * 100 items

=item * 10k

=item * 1mil

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PERLANCAR::In >>):

 +---------------+-----------+------------+-------------+-------------+------------+---------+---------+
 | participant   | dataset   | arg_needle | rate (/s)   | time (ms)   | vs_slowest | errors  | samples |
 +---------------+-----------+------------+-------------+-------------+------------+---------+---------+
 | first (array) | 1mil      | 1000000    | 5.7         | 1.7e+02     | 1          | 0.0002  | 20      |
 | first (array) | 1mil      | 500000     | 11.6        | 86.6        | 2.01       | 7.4e-05 | 20      |
 | grep          | 1mil      | 1          | 40          | 25          | 7          | 3.9e-05 | 20      |
 | grep          | 1mil      | 1000000    | 41          | 25          | 7.1        | 3.8e-05 | 20      |
 | grep          | 1mil      | 500000     | 41          | 25          | 7.1        | 7.4e-05 | 20      |
 | first         | 1mil      | 1000000    | 43          | 23          | 7.5        | 6.3e-05 | 20      |
 | smartmatch    | 1mil      | 1000000    | 62          | 16          | 11         | 6e-05   | 20      |
 | first         | 1mil      | 500000     | 82          | 12          | 14         | 2.7e-05 | 20      |
 | smartmatch    | 1mil      | 500000     | 125         | 7.97        | 21.8       | 7.1e-06 | 20      |
 | first         | 1mil      | 1          | 3e+02       | 3.3         | 52         | 1.3e-05 | 20      |
 | first (array) | 10k       | 10000      | 5.9e+02     | 1.7         | 1e+02      | 3.4e-06 | 20      |
 | first (array) | 10k       | 5000       | 1.19e+03    | 0.84        | 207        | 6.8e-07 | 21      |
 | grep          | 10k       | 10000      | 4.21e+03    | 0.238       | 732        | 5.2e-08 | 21      |
 | grep          | 10k       | 5000       | 4.22e+03    | 0.237       | 733        | 2.1e-07 | 20      |
 | grep          | 10k       | 1          | 4.34e+03    | 0.23        | 755        | 1.8e-07 | 27      |
 | first         | 10k       | 10000      | 5347.409    | 0.1870064   | 930.2025   | 1e-11   | 20      |
 | smartmatch    | 10k       | 10000      | 6253.44     | 0.159912    | 1087.81    | 4.3e-11 | 20      |
 | first         | 10k       | 5000       | 9.96e+03    | 0.1         | 1.73e+03   | 8e-08   | 20      |
 | smartmatch    | 10k       | 5000       | 12512.2     | 0.0799223   | 2176.54    | 1.2e-11 | 20      |
 | first (array) | 100 items | 100        | 59069       | 0.016929    | 10275      | 4.2e-11 | 20      |
 | first         | 10k       | 1          | 73670       | 0.013574    | 12815      | 7.7e-11 | 20      |
 | first (array) | 100 items | 50         | 1.2e+05     | 0.0087      | 2e+04      | 1.3e-08 | 20      |
 | grep          | 100 items | 100        | 4.1e+05     | 0.0024      | 7.1e+04    | 3.2e-09 | 22      |
 | grep          | 100 items | 50         | 4.129e+05   | 0.002422    | 7.182e+04  | 4.1e-11 | 31      |
 | grep          | 100 items | 1          | 4.152e+05   | 0.002408    | 7.223e+04  | 4.3e-11 | 21      |
 | first         | 100 items | 100        | 4.95e+05    | 0.00202     | 8.61e+04   | 7.2e-10 | 27      |
 | smartmatch    | 100 items | 100        | 6.05e+05    | 0.00165     | 1.05e+05   | 7.5e-10 | 25      |
 | first         | 100 items | 50         | 8.755e+05   | 0.001142    | 1.523e+05  | 5.8e-11 | 20      |
 | smartmatch    | 100 items | 50         | 1.164e+06   | 0.0008588   | 2.026e+05  | 4.5e-11 | 28      |
 | first (array) | 10k       | 1          | 2.36e+06    | 0.000425    | 4.1e+05    | 2.1e-10 | 20      |
 | first (array) | 100 items | 1          | 2.37342e+06 | 0.000421332 | 412866     | 0       | 20      |
 | first (array) | 1mil      | 1          | 2.376e+06   | 0.0004209   | 4.133e+05  | 1.2e-11 | 20      |
 | first         | 100 items | 1          | 3.5e+06     | 0.00028     | 6.1e+05    | 4.9e-10 | 23      |
 | smartmatch    | 1mil      | 1          | 1.4e+07     | 7.4e-05     | 2.4e+06    | 2.1e-10 | 20      |
 | smartmatch    | 10k       | 1          | 1.41e+07    | 7.07e-05    | 2.46e+06   | 5.2e-11 | 20      |
 | smartmatch    | 100 items | 1          | 1.43e+07    | 7.01e-05    | 2.48e+06   | 5.3e-11 | 20      |
 +---------------+-----------+------------+-------------+-------------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m PERLANCAR::In --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Array::AllUtils     | 6.2       | 1.2                    | 1          | 4.7e-05 | 21      |
 | perl -e1 (baseline) | 5         | 0                      | 1          | 8e-05   | 20      |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PERLANCAR>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PERLANCAR>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PERLANCAR>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
