package Bencher::Scenario::Exporters::Startup;

our $DATE = '2016-03-13'; # DATE
our $VERSION = '0.06'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark the startup overhead of some exporter modules',

    modules => {
        'PERLANCAR::Exporter::Lite' => {version=>0.02},
    },

    module_startup => 1,

    participants => [
        {module=>'Exporter'},
        {module=>'Exporter::Lite'},
        {module=>'Exporter::Tiny'},
        {module=>'Exporter::Tidy'},
        {module=>'Exporter::Rinci'},
        {module=>'PERLANCAR::Exporter::Lite'},
        {module=>'Sub::Exporter'},
    ],
};

1;
# ABSTRACT: Benchmark the startup overhead of some exporter modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Exporters::Startup - Benchmark the startup overhead of some exporter modules

=head1 VERSION

This document describes version 0.06 of Bencher::Scenario::Exporters::Startup (from Perl distribution Bencher-Scenarios-Exporters), released on 2016-03-13.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Exporters::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Exporter> 5.72

L<Exporter::Lite> 0.06

L<Exporter::Rinci> 0.02

L<Exporter::Tidy> 0.08

L<Exporter::Tiny> 0.042

L<PERLANCAR::Exporter::Lite> 0.02

L<Sub::Exporter> 0.987

=head1 BENCHMARK PARTICIPANTS

=over

=item * Exporter (perl_code)

L<Exporter>



=item * Exporter::Lite (perl_code)

L<Exporter::Lite>



=item * Exporter::Tiny (perl_code)

L<Exporter::Tiny>



=item * Exporter::Tidy (perl_code)

L<Exporter::Tidy>



=item * Exporter::Rinci (perl_code)

L<Exporter::Rinci>



=item * PERLANCAR::Exporter::Lite (perl_code)

L<PERLANCAR::Exporter::Lite>



=item * Sub::Exporter (perl_code)

L<Sub::Exporter>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Exporters::Startup >>):

 +---------------------------+-----------+------------------------+------------+---------+---------+
 | participant               | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------------+-----------+------------------------+------------+---------+---------+
 | Sub::Exporter             | 13        | 10.7                   | 1          | 4.9e-05 | 20      |
 | Exporter::Tiny            | 4.9       | 2.6                    | 2.6        | 1.4e-05 | 20      |
 | Exporter::Lite            | 4         | 1.7                    | 3.1        | 1.1e-05 | 20      |
 | Exporter::Rinci           | 3.3       | 1                      | 3.9        | 2.7e-05 | 20      |
 | Exporter                  | 2.8       | 0.5                    | 4.5        | 1.4e-05 | 20      |
 | PERLANCAR::Exporter::Lite | 2.8       | 0.5                    | 4.5        | 2.2e-05 | 20      |
 | Exporter::Tidy            | 2.7       | 0.4                    | 4.6        | 1.1e-05 | 20      |
 | perl -e1 (baseline)       | 2.3       | 0                      | 5.5        | 5.4e-06 | 20      |
 +---------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Some notes:

=over

=item * L<Exporter::Lite> not so lite

Despite the C<::Lite> in its name and having less features than L<Exporter>, the
startup overhead is worse than Exporter (mostly due to the use of L<warnings>).

Also, this module is no longer necessary since Exporter 5.57 (2004), since
Exporter can be used without subclassing, all you have to do is:

 use Exporter qw(import);

=back

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Exporters>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-StartupExporters>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Exporters>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
