package Bencher::Scenario::DataSahParams::Validate;

our $DATE = '2016-05-26'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Measure validation speed',
    participants => [
        {
            name => 'dsp',
            module => 'Data::Sah::Params',
            code_template => q(state $check = Data::Sah::Params::compile("int*", ["array*",of=>"int*"]); $check->(@{<args>})),
        },
        {
            name => 'tp',
            module => 'Type::Params',
            code_template => q(use Type::Params qw(compile); use Types::Standard qw(Int ArrayRef); state $check = compile(Int, ArrayRef[Int]); $check->(@{<args>})),
        },
    ],
    datasets => [
        {
            name => '1,[]',
            args => { args => [1,[]] },
        },
        {
            name => '1,[1..10]',
            args => { args => [1,[1..10]] },
        },
        {
            name => '1,[1..100]',
            args => { args => [1,[1..100]] },
        },
    ],
};

1;
# ABSTRACT: Measure validation speed

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSahParams::Validate - Measure validation speed

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::DataSahParams::Validate (from Perl distribution Bencher-Scenarios-DataSahParams), released on 2016-05-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSahParams::Validate

To run module startup overhead benchmark:

 % bencher --module-startup -m DataSahParams::Validate

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Data::Sah::Params> 0.001

L<Type::Params> 1.000005

=head1 BENCHMARK PARTICIPANTS

=over

=item * dsp (perl_code)

Code template:

 state $check = Data::Sah::Params::compile("int*", ["array*",of=>"int*"]); $check->(@{<args>})



=item * tp (perl_code)

Code template:

 use Type::Params qw(compile); use Types::Standard qw(Int ArrayRef); state $check = compile(Int, ArrayRef[Int]); $check->(@{<args>})



=back

=head1 BENCHMARK DATASETS

=over

=item * 1,[]

=item * 1,[1..10]

=item * 1,[1..100]

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with default options (C<< bencher -m DataSahParams::Validate >>):

 +-------------+------------+-----------+-----------+------------+---------+---------+
 | participant | dataset    | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +-------------+------------+-----------+-----------+------------+---------+---------+
 | dsp         | 1,[1..100] | 2.5e+04   | 40        | 1          | 4.7e-08 | 26      |
 | dsp         | 1,[1..10]  | 1.38e+05  | 7.25      | 5.5        | 3.1e-09 | 23      |
 | tp          | 1,[1..100] | 2.5e+05   | 4.1       | 9.8        | 6.7e-09 | 20      |
 | dsp         | 1,[]       | 3e+05     | 3.4       | 12         | 4.7e-09 | 23      |
 | tp          | 1,[1..10]  | 7e+05     | 1.43      | 27.9       | 3.6e-10 | 27      |
 | tp          | 1,[]       | 9.6e+05   | 1         | 38         | 1.4e-09 | 29      |
 +-------------+------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m DataSahParams::Validate --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Type::Params        | 39        | 34.7                   | 1          | 4.6e-05 | 20      |
 | Data::Sah::Params   | 7.6       | 3.3                    | 5.1        | 2.7e-05 | 20      |
 | perl -e1 (baseline) | 4.3       | 0                      | 9.1        | 1.5e-05 | 20      |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARK NOTES

In this benchmark case, code generated by Data::Sah performs significantly more
slowly because it is not particularly optimized. Future releases of Data::Sah
will add some optimizations.

To see the source code generated by Data::Sah, you can try on the command-line
(the CLI utility is part of L<App::SahUtils>):

 % validate-with-sah '"int*"' -r str -c

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSahParams>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-DataSahParams>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSahParams>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
