package Bencher::Scenario::Accessors::Construction;

our $DATE = '2016-09-09'; # DATE
our $VERSION = '0.10'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark object construction',
    modules => {
        # force minimum version
        'Perl::Examples::Accessors' => {version=>0.05},

        # include the generator modules here so we can show their versions in
        # sample benchmark results produced by PWP:Bencher::Scenario
        (map { $_=>0 } grep {defined} map { $classes->{$_}{generator} }
             keys %$classes),
    },
    participants => [
        map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "${_}->new",
            };
        } keys %$classes,
    ],
    include_result_size => 1,
};

1;
# ABSTRACT: Benchmark object construction

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Construction - Benchmark object construction

=head1 VERSION

This document describes version 0.10 of Bencher::Scenario::Accessors::Construction (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-09-09.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Construction

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Construction

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Class::Accessor> 0.34

L<Class::Accessor::Array> 0.02

L<Class::InsideOut> 1.13

L<Class::Tiny> 1.004

L<Class::XSAccessor> 1.19

L<Class::XSAccessor::Array> 1.19

L<Mo> 0.40

L<Mojo::Base>

L<Moo> 2.002004

L<Moose> 2.1805

L<Mouse> v2.4.5

L<Object::Simple> 3.1703

L<Perl::Examples::Accessors> 0.08

L<Perl::Examples::Accessors::Array> 0.08

L<Perl::Examples::Accessors::ClassAccessor> 0.08

L<Perl::Examples::Accessors::ClassAccessorArray> 0.08

L<Perl::Examples::Accessors::ClassInsideOut> 0.08

L<Perl::Examples::Accessors::ClassTiny> 0.08

L<Perl::Examples::Accessors::ClassXSAccessor> 0.08

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.08

L<Perl::Examples::Accessors::Hash> 0.08

L<Perl::Examples::Accessors::Mo> 0.08

L<Perl::Examples::Accessors::MojoBase> 0.08

L<Perl::Examples::Accessors::Moo> 0.08

L<Perl::Examples::Accessors::Moose> 0.08

L<Perl::Examples::Accessors::Mouse> 0.08

L<Perl::Examples::Accessors::ObjectSimple> 0.08

L<Perl::Examples::Accessors::Scalar> 0.08

L<Perl::Examples::Accessors::SimpleAccessor> 0.08

L<Simple::Accessor> 1.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * Simple::Accessor (perl_code)

Code template:

 Perl::Examples::Accessors::SimpleAccessor->new



=item * Mouse (perl_code)

Code template:

 Perl::Examples::Accessors::Mouse->new



=item * Mojo::Base (perl_code)

Code template:

 Perl::Examples::Accessors::MojoBase->new



=item * Class::Accessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessor->new



=item * no generator (hash-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Hash->new



=item * Moose (perl_code)

Code template:

 Perl::Examples::Accessors::Moose->new



=item * Moo (perl_code)

Code template:

 Perl::Examples::Accessors::Moo->new



=item * Class::XSAccessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessor->new



=item * no generator (scalar-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Scalar->new



=item * Class::Tiny (perl_code)

Code template:

 Perl::Examples::Accessors::ClassTiny->new



=item * Class::XSAccessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessorArray->new



=item * Class::Accessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessorArray->new



=item * no generator (array-based) (perl_code)

Code template:

 Perl::Examples::Accessors::Array->new



=item * Class::InsideOut (perl_code)

Code template:

 Perl::Examples::Accessors::ClassInsideOut->new



=item * Mo (perl_code)

Code template:

 Perl::Examples::Accessors::Mo->new



=item * Object::Simple (perl_code)

Code template:

 Perl::Examples::Accessors::ObjectSimple->new



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Construction >>):

 #table1#
 +-----------------------------+-----------+-----------+------------+---------+---------+
 | participant                 | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------+-----------+-----------+------------+---------+---------+
 | Class::InsideOut            |    188000 |    5.31   |       1    |   5e-09 |      20 |
 | Simple::Accessor            |    330000 |    3      |       1.8  | 1.3e-08 |      20 |
 | Class::Tiny                 |    380000 |    2.6    |       2    | 7.5e-09 |      20 |
 | Moose                       |    539000 |    1.86   |       2.86 | 8.3e-10 |      20 |
 | Mo                          |    810000 |    1.2    |       4.3  | 3.7e-09 |      20 |
 | Moo                         |   1030000 |    0.968  |       5.49 |   1e-10 |      20 |
 | Class::Accessor             |   1100000 |    0.88   |       6.1  | 1.7e-09 |      20 |
 | Mouse                       |   1500000 |    0.69   |       7.7  | 3.3e-09 |      20 |
 | no generator (array-based)  |   1780000 |    0.56   |       9.48 | 2.1e-10 |      20 |
 | no generator (hash-based)   |   2170000 |    0.4608 |      11.53 | 1.1e-11 |      28 |
 | Object::Simple              |   2200000 |    0.46   |      12    |   1e-09 |      20 |
 | Mojo::Base                  |   2190000 |    0.456  |      11.6  | 2.7e-10 |      24 |
 | Class::Accessor::Array      |   2390000 |    0.418  |      12.7  | 4.6e-11 |      25 |
 | no generator (scalar-based) |   2450000 |    0.409  |      13    | 2.1e-10 |      20 |
 | Class::XSAccessor           |   3400000 |    0.29   |      18    | 4.2e-10 |      20 |
 | Class::XSAccessor::Array    |   3600000 |    0.28   |      19    | 3.3e-10 |      32 |
 +-----------------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
