package Bencher::Scenario::Accessors::Set;

our $DATE = '2016-04-14'; # DATE
our $VERSION = '0.05'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark attribute write/set',
    modules => {
    },
    participants => [
        (map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "state \$o = do { my \$o = ${_}->new; \$o }; \$o->attr1(42)",
            };
        } grep { !$classes->{$_}{immutable} } keys %$classes),

        # also compare with raw hash & array access
        {
            name => 'raw hash access',
            module => 'Perl::Examples::Accessors::Hash',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Hash->new; \$o }; \$o->{attr1} = 42",
        },
        {
            name => 'raw array access',
            module => 'Perl::Examples::Accessors::Array',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Array->new; \$o }; \$o->[0] = 42",
        },
    ],
};

1;
# ABSTRACT: Benchmark attribute write/set

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Set - Benchmark attribute write/set

=head1 VERSION

This document describes version 0.05 of Bencher::Scenario::Accessors::Set (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-04-14.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Set

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Set

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors::Array> 0.04

L<Perl::Examples::Accessors::ClassAccessor> 0.04

L<Perl::Examples::Accessors::ClassAccessorArray> 0.04

L<Perl::Examples::Accessors::ClassInsideOut> 0.04

L<Perl::Examples::Accessors::ClassXSAccessor> 0.04

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.04

L<Perl::Examples::Accessors::Hash> 0.04

L<Perl::Examples::Accessors::Mo> 0.04

L<Perl::Examples::Accessors::Moo> 0.04

L<Perl::Examples::Accessors::Moose> 0.04

L<Perl::Examples::Accessors::Mouse> 0.04

=head1 BENCHMARK PARTICIPANTS

=over

=item * Class::XSAccessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessorArray->new; $o }; $o->attr1(42)



=item * Class::Accessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessorArray->new; $o }; $o->attr1(42)



=item * Class::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessor->new; $o }; $o->attr1(42)



=item * Moo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moo->new; $o }; $o->attr1(42)



=item * no generator (hash-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o }; $o->attr1(42)



=item * Class::XSAccessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessor->new; $o }; $o->attr1(42)



=item * Mouse (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mouse->new; $o }; $o->attr1(42)



=item * no generator (array-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o }; $o->attr1(42)



=item * Moose (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moose->new; $o }; $o->attr1(42)



=item * Mo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mo->new; $o }; $o->attr1(42)



=item * Class::InsideOut (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassInsideOut->new; $o }; $o->attr1(42)



=item * raw hash access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o }; $o->{attr1} = 42



=item * raw array access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o }; $o->[0] = 42



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Set >>):

 +----------------------------+-----------+-----------+------------+---------+---------+
 | participant                | rate (/s) | time (ns) | vs_slowest | errors  | samples |
 +----------------------------+-----------+-----------+------------+---------+---------+
 | Class::Accessor            | 1.89e+06  | 529       | 1          | 9.6e-12 | 20      |
 | Class::InsideOut           | 3.08e+06  | 325       | 1.63       | 2.9e-10 | 23      |
 | no generator (hash-based)  | 4.461e+06 | 224.2     | 2.36       | 1.1e-11 | 20      |
 | no generator (array-based) | 4.876e+06 | 205.1     | 2.58       | 9e-12   | 20      |
 | Moose                      | 5.123e+06 | 195.2     | 2.71       | 8.9e-12 | 20      |
 | Mo                         | 5.2e+06   | 1.9e+02   | 2.8        | 3e-10   | 21      |
 | Class::Accessor::Array     | 5.6e+06   | 1.8e+02   | 3          | 2.8e-10 | 25      |
 | Mouse                      | 1.1e+07   | 92        | 5.8        | 2.1e-10 | 20      |
 | Class::XSAccessor          | 1.18e+07  | 85.1      | 6.22       | 5.3e-11 | 20      |
 | Moo                        | 1.3e+07   | 78        | 6.8        | 2.1e-10 | 20      |
 | Class::XSAccessor::Array   | 1.4e+07   | 71        | 7.5        | 2e-10   | 21      |
 | raw hash access            | 2.33e+07  | 42.9      | 12.3       | 1.1e-11 | 20      |
 | raw array access           | 2.94e+07  | 34        | 15.6       | 1e-11   | 20      |
 +----------------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
