package Bencher::Scenario::Words2NumsModules;

our $DATE = '2016-07-12'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark various words-to-numbers modules '.
        'of different languages against one another',
    participants => [
        {
            fcall_template => 'Lingua::ID::Words2Nums::words2nums(<word>)',
            tags => ["id"],
        },
        {
            fcall_template => 'Lingua::EN::Words2Nums::words2nums(<word>)',
            tags => ["en"],
        },
    ],
    datasets => [
        {name=>"en_1"        , args=>{word=>"one"}, include_participant_tags => ["en"]},
        {name=>"en_123"      , args=>{word=>"one hundred and twenty three"}, include_participant_tags => ["en"]},
        {name=>"en_123456789", args=>{word=>"one hundred and twenty three million, four hundred and fifty six thousand, seven hundred and eighty nine"}, include_participant_tags => ["en"]},

        {name=>"id_1"        , args=>{word=>"satu"}, include_participant_tags => ["id"]},
        {name=>"id_123"      , args=>{word=>"seratus dua puluh tiga"}, include_participant_tags => ["id"]},
        {name=>"id_123456789", args=>{word=>"seratus dua puluh tiga juta empat ratus lima puluh enam ribu tujuh ratus delapan puluh sembilan"}, include_participant_tags => ["id"]},
    ],
};

1;
# ABSTRACT: Benchmark various words-to-numbers modules of different languages against one another

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Words2NumsModules - Benchmark various words-to-numbers modules of different languages against one another

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::Words2NumsModules (from Perl distribution Bencher-Scenario-Words2NumsModules), released on 2016-07-12.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Words2NumsModules

To run module startup overhead benchmark:

 % bencher --module-startup -m Words2NumsModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Lingua::ID::Words2Nums> 0.17

L<Lingua::EN::Words2Nums>

=head1 BENCHMARK PARTICIPANTS

=over

=item * Lingua::ID::Words2Nums::words2nums (perl_code) [id]

Function call template:

 Lingua::ID::Words2Nums::words2nums(<word>)



=item * Lingua::EN::Words2Nums::words2nums (perl_code) [en]

Function call template:

 Lingua::EN::Words2Nums::words2nums(<word>)



=back

=head1 BENCHMARK DATASETS

=over

=item * en_1

=item * en_123

=item * en_123456789

=item * id_1

=item * id_123

=item * id_123456789

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Words2NumsModules >>):

 #table1#
 +------------------------------------+--------------+-----------+-----------+------------+---------+---------+
 | participant                        | dataset      | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +------------------------------------+--------------+-----------+-----------+------------+---------+---------+
 | Lingua::ID::Words2Nums::words2nums | id_123456789 |    4700   |  210      |    1       | 2.4e-07 |      25 |
 | Lingua::EN::Words2Nums::words2nums | en_123456789 |   12843.9 |   77.8582 |    2.75887 | 4.5e-11 |      21 |
 | Lingua::ID::Words2Nums::words2nums | id_123       |   29000   |   35      |    6.1     | 1.1e-07 |      20 |
 | Lingua::EN::Words2Nums::words2nums | en_123       |   56000   |   18      |   12       | 2.7e-08 |      20 |
 | Lingua::ID::Words2Nums::words2nums | id_1         |   96700   |   10.3    |   20.8     | 9.5e-09 |      22 |
 | Lingua::EN::Words2Nums::words2nums | en_1         |  170000   |    5.7    |   37       | 1.7e-08 |      27 |
 +------------------------------------+--------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m Words2NumsModules --module-startup >>):

 #table2#
 +------------------------+-----------+------------------------+------------+---------+---------+
 | participant            | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +------------------------+-----------+------------------------+------------+---------+---------+
 | Lingua::ID::Words2Nums |      11   |                    6.3 |        1   | 2.9e-05 |      20 |
 | Lingua::EN::Words2Nums |       9.4 |                    4.7 |        1.1 | 3.6e-05 |      20 |
 | perl -e1 (baseline)    |       4.7 |                    0   |        2.2 | 2.4e-05 |      20 |
 +------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-Words2NumsModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-Words2NumsModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-Words2NumsModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
