package Bencher::Scenario::Textsprintfn;

our $DATE = '2016-06-28'; # DATE
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark Text::sprintfn vs sprintf()',
    participants => [
        {
            fcall_template => 'Text::sprintfn::sprintfn(<format>, @{<data>})',
            tags => ['sprintfn'],
        },
        {
            name => 'sprintf',
            code_template => 'sprintf(<format>, @{<data>})',
            tags => ['sprintf'],
        },
    ],
    datasets => [
        {
            args => {format => '%s', data => [1]},
        },
        {
            args => {format => '%s%d%f', data => [1,2,3]},
        },
        {
            args => {format => '%(a)s', data => [{a=>1}]},
            exclude_participant_tags => ['sprintf'],
        },
        {
            args => {format => '%(a)s%(b)d%(c)f', data => [{a=>1,b=>2,c=>3}]},
            exclude_participant_tags => ['sprintf'],
        },
    ],
};

1;
# ABSTRACT: Benchmark Text::sprintfn vs sprintf()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Textsprintfn - Benchmark Text::sprintfn vs sprintf()

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::Textsprintfn (from Perl distribution Bencher-Scenario-Textsprintfn), released on 2016-06-28.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Textsprintfn

To run module startup overhead benchmark:

 % bencher --module-startup -m Textsprintfn

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Text::sprintfn> 0.08

=head1 BENCHMARK PARTICIPANTS

=over

=item * Text::sprintfn::sprintfn (perl_code) [sprintfn]

Function call template:

 Text::sprintfn::sprintfn(<format>, @{<data>})



=item * sprintf (perl_code) [sprintf]

Code template:

 sprintf(<format>, @{<data>})



=back

=head1 BENCHMARK DATASETS

=over

=item * {data=>[1],format=>"%s"}

=item * {data=>[1,2,3],format=>"%s%d%f"}

=item * {data=>[{a=>1}],format=>"%(a)s"}

=item * {data=>[{a=>1,b=>2,c=>3}],format=>"%(a)s%(b)d%(c)f"}

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Textsprintfn >>):

 #table1#
 +--------------------------+------------------------------------------------------+-----------+-----------+------------+---------+---------+
 | participant              | dataset                                              | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +--------------------------+------------------------------------------------------+-----------+-----------+------------+---------+---------+
 | Text::sprintfn::sprintfn | {data=>[{a=>1,b=>2,c=>3}],format=>"%(a)s%(b)d%(c)f"} |     42000 |     24    |        1   | 1.1e-07 |      22 |
 | Text::sprintfn::sprintfn | {data=>[{a=>1}],format=>"%(a)s"}                     |    100000 |      9.9  |        2.4 | 1.3e-08 |      20 |
 | Text::sprintfn::sprintfn | {data=>[1,2,3],format=>"%s%d%f"}                     |    490000 |      2    |       12   | 3.3e-09 |      20 |
 | sprintf                  | {data=>[1,2,3],format=>"%s%d%f"}                     |    860000 |      1.2  |       20   |   1e-08 |      20 |
 | Text::sprintfn::sprintfn | {data=>[1],format=>"%s"}                             |   1200000 |      0.87 |       27   | 1.6e-09 |      22 |
 | sprintf                  | {data=>[1],format=>"%s"}                             |   2700000 |      0.36 |       65   | 8.3e-10 |      20 |
 +--------------------------+------------------------------------------------------+-----------+-----------+------------+---------+---------+


=begin HTML

<script src="https://code.jquery.com/jquery-3.0.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/sortable/0.8.0/js/sortable.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sortable/0.8.0/css/sortable-theme-bootstrap.min.css" />

<table data-sortable class="sortable-theme-bootstrap">
<thead>
 <tr>
  <th align="left">participant</th>
  <th align="left">dataset</th>
  <th align="right">rate (/s)</th>
  <th align="right">time (&mu;s)</th>
  <th align="right">vs_slowest</th>
  <th align="right">errors</th>
  <th align="right">samples</th>
 </tr>
</thead>
<tbody>
 <tr>
  <td align="left">Text::sprintfn::sprintfn</td>
  <td align="left">{data=&gt;[{a=&gt;1,b=&gt;2,c=&gt;3}],format=&gt;&quot;%(a)s%(b)d%(c)f&quot;}</td>
  <td align="right">42000</td>
  <td align="right">24</td>
  <td align="right">1</td>
  <td align="right">1.1e-07</td>
  <td align="right">22</td>
 </tr>
</tbody>
 <tr>
  <td align="left">Text::sprintfn::sprintfn</td>
  <td align="left">{data=&gt;[{a=&gt;1}],format=&gt;&quot;%(a)s&quot;}</td>
  <td align="right">100000</td>
  <td align="right">9.9</td>
  <td align="right">2.4</td>
  <td align="right">1.3e-08</td>
  <td align="right">20</td>
 </tr>
 <tr>
  <td align="left">Text::sprintfn::sprintfn</td>
  <td align="left">{data=&gt;[1,2,3],format=&gt;&quot;%s%d%f&quot;}</td>
  <td align="right">490000</td>
  <td align="right">2</td>
  <td align="right">12</td>
  <td align="right">3.3e-09</td>
  <td align="right">20</td>
 </tr>
 <tr>
  <td align="left">sprintf</td>
  <td align="left">{data=&gt;[1,2,3],format=&gt;&quot;%s%d%f&quot;}</td>
  <td align="right">860000</td>
  <td align="right">1.2</td>
  <td align="right">20</td>
  <td align="right">1e-08</td>
  <td align="right">20</td>
 </tr>
 <tr>
  <td align="left">Text::sprintfn::sprintfn</td>
  <td align="left">{data=&gt;[1],format=&gt;&quot;%s&quot;}</td>
  <td align="right">1200000</td>
  <td align="right">0.87</td>
  <td align="right">28</td>
  <td align="right">1.6e-09</td>
  <td align="right">22</td>
 </tr>
 <tr>
  <td align="left">sprintf</td>
  <td align="left">{data=&gt;[1],format=&gt;&quot;%s&quot;}</td>
  <td align="right">2700000</td>
  <td align="right">0.36</td>
  <td align="right">67</td>
  <td align="right">8.3e-10</td>
  <td align="right">20</td>
 </tr>
</table>

<script>$(document).ready(function () { $("pre:contains('#table1#')").remove() })</script>

=end HTML

Benchmark module startup overhead (C<< bencher -m Textsprintfn --module-startup >>):

 #table2#
 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Text::sprintfn      |       7.8 |                    3.6 |        1   | 7.9e-06 |      20 |
 | perl -e1 (baseline) |       4.2 |                    0   |        1.9 | 1.8e-05 |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+


=begin HTML


<table data-sortable class="sortable-theme-bootstrap">
<thead>
 <tr>
  <th align="left">participant</th>
  <th align="right">time (ms)</th>
  <th align="right">mod_overhead_time (ms)</th>
  <th align="right">vs_slowest</th>
  <th align="right">errors</th>
  <th align="right">samples</th>
 </tr>
</thead>
<tbody>
 <tr>
  <td align="left">Text::sprintfn</td>
  <td align="right">7.8</td>
  <td align="right">3.6</td>
  <td align="right">1</td>
  <td align="right">7.9e-06</td>
  <td align="right">20</td>
 </tr>
</tbody>
 <tr>
  <td align="left">perl -e1 (baseline)</td>
  <td align="right">4.2</td>
  <td align="right">0</td>
  <td align="right">1.8571</td>
  <td align="right">1.8e-05</td>
  <td align="right">20</td>
 </tr>
</table>

<script>$(document).ready(function () { $("pre:contains('#table2#')").remove() })</script>

=end HTML

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-Textsprintfn>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-Textsprintfn>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-Textsprintfn>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
