package Bencher::Scenario::CloneModules;

our $DATE = '2016-03-10'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark various data cloning modules',
    participants => [
        {fcall_template=>'Clone::clone(<data>)'},
        {fcall_template=>'Clone::PP::clone(<data>)'},
        {fcall_template=>'Data::Clone::clone(<data>)'},
        {fcall_template=>'Sereal::Dclone::dclone(<data>)'},
        {fcall_template=>'Storable::dclone(<data>)'},
    ],
    datasets => [
        {name=>'array0'   , args=>{data=>[]}},
        {name=>'array1'   , args=>{data=>[1]}},
        {name=>'array10'  , args=>{data=>[1..10]}},
        {name=>'array100' , args=>{data=>[1..100]}},
        {name=>'array1000', args=>{data=>[1..1000]}},
    ],
};

1;
# ABSTRACT: Benchmark various data cloning modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::CloneModules - Benchmark various data cloning modules

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::CloneModules (from Perl distribution Bencher-Scenario-CloneModules), released on 2016-03-10.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m CloneModules

To run module startup overhead benchmark:

 % bencher --module-startup -m CloneModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Clone> 0.38

L<Clone::PP> 1.06

L<Data::Clone> 0.004

L<Sereal::Dclone> 0.001

L<Storable> 2.53

=head1 BENCHMARK PARTICIPANTS

=over

=item * Clone::clone (perl_code)

Function call template:

 Clone::clone(<data>)



=item * Clone::PP::clone (perl_code)

Function call template:

 Clone::PP::clone(<data>)



=item * Data::Clone::clone (perl_code)

Function call template:

 Data::Clone::clone(<data>)



=item * Sereal::Dclone::dclone (perl_code)

Function call template:

 Sereal::Dclone::dclone(<data>)



=item * Storable::dclone (perl_code)

Function call template:

 Storable::dclone(<data>)



=back

=head1 BENCHMARK DATASETS

=over

=item * array0

=item * array1

=item * array10

=item * array100

=item * array1000

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark cloning a 1000-element array (C<< bencher -m CloneModules --include-datasets-json '["array1000"]' >>):

 +------------------------+-----------+-----------+------------+---------+---------+
 | participant            | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +------------------------+-----------+-----------+------------+---------+---------+
 | Clone::clone           | 3.48e+03  | 288       | 1          | 2.1e-07 | 20      |
 | Clone::PP::clone       | 5.94e+03  | 168       | 1.71       | 5.3e-08 | 20      |
 | Storable::dclone       | 8860.7    | 112.86    | 2.5489     | 1.8e-10 | 22      |
 | Sereal::Dclone::dclone | 17429     | 57.376    | 5.0138     | 1.1e-10 | 20      |
 | Data::Clone::clone     | 1.78e+04  | 56.1      | 5.13       | 2.7e-08 | 20      |
 +------------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m CloneModules --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Sereal::Dclone      | 14        | 9.4                    | 1          | 6.9e-05 | 20      |
 | Storable            | 14        | 9.4                    | 1          | 3.3e-05 | 24      |
 | Clone               | 11        | 6.4                    | 1.3        | 2.6e-05 | 20      |
 | Data::Clone         | 9         | 4.4                    | 1.6        | 3.2e-05 | 20      |
 | Clone::PP           | 8.5       | 3.9                    | 1.7        | 3e-05   | 20      |
 | perl -e1 (baseline) | 4.6       | 0                      | 3.1        | 3.1e-05 | 22      |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-CloneModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-CloneModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-CloneModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
