package App::lcpan::Cmd::namespaces;

our $DATE = '2015-10-09'; # DATE
our $VERSION = '0.54'; # VERSION

use 5.010;
use strict;
use warnings;

require App::lcpan;

our %SPEC;

$SPEC{handle_cmd} = $App::lcpan::SPEC{namespaces};
*handle_cmd = \&App::lcpan::namespaces;

1;
# ABSTRACT: List namespaces

__END__

=pod

=encoding UTF-8

=head1 NAME

App::lcpan::Cmd::namespaces - List namespaces

=head1 VERSION

This document describes version 0.54 of App::lcpan::Cmd::namespaces (from Perl distribution App-lcpan), released on 2015-10-09.

=head1 FUNCTIONS


=head2 handle_cmd(%args) -> [status, msg, result, meta]

List namespaces.

This function is not exportable.

Arguments ('*' denotes required arguments):

=over 4

=item * B<cpan> => I<str>

Location of your local CPAN mirror, e.g. /path/to/cpan.

Defaults to C<~/cpan>.

=item * B<detail> => I<bool>

=item * B<exact_match> => I<bool> (default: 0)

Match query with exact module names.

=item * B<from_level> => I<int>

=item * B<index_name> => I<str> (default: "index.db")

Filename of index.

=item * B<level> => I<int>

=item * B<or> => I<bool>

When there are more than one query, perform OR instead of AND logic.

=item * B<query> => I<array[str]>

Search query.

=item * B<sort> => I<str> (default: "name")

=item * B<to_level> => I<int>

=back

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (result) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-lcpan>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-lcpan>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-lcpan>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
