package App::lcpan::Cmd::mods_from_same_dist;

our $DATE = '2015-04-29'; # DATE
our $VERSION = '0.32'; # VERSION

use 5.010;
use strict;
use warnings;

require App::lcpan;

our %SPEC;

$SPEC{'handle_cmd'} = {
    v => 1.1,
    summary => 'Given a module, list all modules in the same distribution',
    args => {
        %App::lcpan::common_args,
        %App::lcpan::mods_args,
        %App::lcpan::flatest_args,
        detail => {
            schema => 'bool',
        },
    },
};
sub handle_cmd {
    my %args = @_;

    App::lcpan::_set_args_default(\%args);
    my $cpan = $args{cpan};
    my $index_name = $args{index_name};

    my $detail = $args{detail};

    my $dbh = App::lcpan::_connect_db('ro', $cpan, $index_name);

    my $emods = join(",", map {$dbh->quote($_)} @{ $args{modules} });
    my @where;
    push @where, "dist.name IN (SELECT name FROM dist WHERE file_id IN (SELECT file_id FROM module WHERE name IN ($emods)))";
    if ($args{latest}) {
        push @where, "dist.is_latest";
    } elsif (defined $args{latest}) {
        push @where, "NOT(dist.is_latest)";
    }
    my $sth = $dbh->prepare("SELECT
  module.name name,
  module.version version,
  dist.name dist,
  dist.version dist_version
FROM module
JOIN dist ON module.file_id=dist.file_id
WHERE ".join(" AND ", @where)."
ORDER BY name DESC");
    $sth->execute;
    my @res;
    while (my $row = $sth->fetchrow_hashref) {
        push @res, $detail ? $row : $row->{name};
    }
    my $resmeta = {};
    $resmeta->{format_options} = {any=>{table_column_orders=>[[qw/name version dist dist_version/]]}}
        if $detail;
    [200, "OK", \@res, $resmeta];
}

1;
# ABSTRACT: Given a module, list all modules in the same distribution

__END__

=pod

=encoding UTF-8

=head1 NAME

App::lcpan::Cmd::mods_from_same_dist - Given a module, list all modules in the same distribution

=head1 VERSION

This document describes version 0.32 of App::lcpan::Cmd::mods_from_same_dist (from Perl distribution App-lcpan), released on 2015-04-29.

=head1 FUNCTIONS


=head2 handle_cmd(%args) -> [status, msg, result, meta]

Given a module, list all modules in the same distribution.

Arguments ('*' denotes required arguments):

=over 4

=item * B<cpan> => I<str>

Location of your local CPAN mirror, e.g. /path/to/cpan.

Defaults to C<~/cpan>.

=item * B<detail> => I<bool>

=item * B<index_name> => I<str> (default: "index.db")

Filename of index.

=item * B<latest> => I<bool>

=item * B<modules>* => I<array[str]>

=back

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (result) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-lcpan>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-lcpan>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-lcpan>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
