package SmartCAT::Serge;
use parent Serge::Sync::Plugin::Base::TranslationService, Serge::Interface::SysCmdRunner;

use strict;

use Serge::Util qw(subst_macros);

sub name {
    return 'SmartCAT translation server (http://smartcat.ai/) .po synchronization plugin';
}

sub init {
    my $self = shift;

    $self->SUPER::init(@_);

    $self->{optimizations} = 1; # set to undef to disable optimizations

    $self->merge_schema({
        po_path        => 'STRING',
        project_id     => 'STRING',
        smartcat_sync_path  => 'STRING',
        token_id       => 'STRING',
        token          => 'STRING',
    });
}

sub validate_data {
    my ($self) = @_;

    $self->SUPER::validate_data;

    $self->{data}->{po_path} = subst_macros($self->{data}->{po_path});
    $self->{data}->{project_id} = subst_macros($self->{data}->{project_id});
    $self->{data}->{smartcat_sync_path } = subst_macros($self->{data}->{smartcat_sync_path });
    $self->{data}->{token_id} = subst_macros($self->{data}->{token_id});
    $self->{data}->{token} = subst_macros($self->{data}->{token});

    die "'po_path' not defined" unless defined $self->{data}->{po_path};
    die "'project_id' not defined" unless defined $self->{data}->{project_id};
    die "'smartcat_sync_path' not defined" unless defined $self->{data}->{smartcat_sync_path};
    die "'smartcat_sync_path', which is set to '$self->{data}->{smartcat_sync_path}', does not point to a valid file.\n" unless -f $self->{data}->{smartcat_sync_path};
    die "'token_id' not defined" unless defined $self->{data}->{token_id};
    die "'token' not defined" unless defined $self->{data}->{token};
}

sub run_manage_pl {
    my ($self, $action, $langs, $capture) = @_;

    my $command = $action.' --project='.$self->{data}->{project_id};

    if ($langs) {
        foreach my $lang (sort @$langs) {
            $lang =~ s/-(\w+)$/'_'.uc($1)/e; # convert e.g. 'pt-br' to 'pt_BR'
            $command .= " --language=$lang";
        }
    }

    $command .= " --token_id=".$self->{data}->{token_id};
    $command .= " --token=".$self->{data}->{token};
    $command .= " --po_path=".$self->{data}->{po_path};

    $command = 'perl '.$self->{data}->{smartcat_sync_path}.' '.$command;
    print "Running '$command'...\n";
    return $self->run_cmd($command, $capture);
}

sub pull_ts {
    my ($self, $langs) = @_;

    my $force = $self->{optimizations} ? '' : ' --overwrite';

    return $self->run_manage_pl('pull --skip-missing'.$force, $langs);
}

sub push_ts {
    my ($self, $langs) = @_;

    my $force = $self->{optimizations} ? '' : ' --force';

    $self->run_manage_pl('push'.$force, $langs);
}

1;
__END__

=head1 NAME

SmartCAT::Serge - Maintain tag 

=head1 DESCRIPTION

SmartCAT plugin for Serge

=cut