package WebService::PayPal::PaymentsAdvanced::Response::Authorization::PayPal;
$WebService::PayPal::PaymentsAdvanced::Response::Authorization::PayPal::VERSION = '0.000007';
use Moo;

extends 'WebService::PayPal::PaymentsAdvanced::Response::Authorization';

with 'WebService::PayPal::PaymentsAdvanced::Role::HasPayPal';

1;

=pod

=encoding UTF-8

=head1 NAME

WebService::PayPal::PaymentsAdvanced::Response::Authorization::PayPal - Response class for PayPal Authorization transactions

=head1 VERSION

version 0.000007

=head1 DESCRIPTION

Response class for Authorization transactions C<TRXTYPE=A>  You should not
create this response object directly. This class inherits from
L<WebService::PayPal::PaymentsAdvanced::Response::Authorization> and includes
the methods provided by
L<WebService::PayPal::PaymentsAdvanced::Role::HasPayPal>.

=head1 AUTHOR

Olaf Alders <olaf@wundercounter.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by MaxMind, Inc..

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut

__END__
# ABSTRACT: Response class for PayPal Authorization transactions

