'\"
.so man.macros
.TH callbacks n 4.0 Tk "Perl/Tk Constructs"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
callbacks \- Specifying code for Tk to call.
.SH SYNOPSIS
... => \e&\fIsubname\fR
.br
... => [\e&\fIsubname\fR?,\fIargs...\fR?]
.br
... => sub { \fI ... \fR }
.br
... => [sub { \fI ... \fR }\fR?,\fIargs...\fR?]
.br
... => '\fImethodname\fR'
.br
... => ['\fImethodname\fR'\fR?,\fIargs...\fR?]
.BE
.SH DESCRIPTION
Where Tcl/Tk has a command string (i.e. a fragment of Tcl to be executed),
perl/Tk has a callback. A callback can take one of the following basic forms:
.IP
Reference to a sub \f(CW\e&name\fR 
.IP
Anonymous subroutine (closure) \f(CWsub { ... }\fR
.IP
A method name \f(CW'name'\fR 
.PP
Any of these can be provided with arguments by enclosing them and the
arguments in \f(CW[]\fR. Here are some examples:
.PP
.nf
  $mw->bind($class,"<Delete>" => 'Delete');
.fi
This will call \f(CW$widget\fR\->Delete, the \f(CW$widget\fR being provided (by bind) as 
the one where the Delete key was pressed.
.PP
While having bind provide a widget object for you is ideal in many cases
it can be irritating in others. Using the list form this behaviour 
can be modified:
.PP
.nf
  $a->bind("<Delete>",[$b => 'Delete']);
.fi
because the first element \f(CW$b\fR is an object bind 
will call \f(CW$b\fR\->Delete.
.PP
Note that method/object ordering only matters for \f(CWbind\fR callbacks,
the auto-quoting in perl5.001 makes the first of these a little more readable:
.PP
.nf
 $w->configure(-yscrollcommand => [ set => $ysb]);
.br 
 $w->configure(-yscrollcommand => [ $ysb => 'set' ]);
.fi
but both will call \f(CW$ysb\fR\->set(args provided by Tk) 
.PP
Another use of arguments allows you to write generalized methods which are
easier to re-use:
.PP
.nf
 $a->bind("<Next>",['Next','Page']);
.br 
 $a->bind("<Down>",['Next','Line']);
.fi
This will call \f(CW$a\fR\->\fINext\fR('Page') or \f(CW$a\fR\->\fINext\fR('Line') respectively.
.PP
Note that the contents of the \f(CW[]\fR are evaluated by perl when the 
callback is created. It is often desirable for the arguments provided
to the callback to depend on the details of the event which caused 
it to be executed. To allow for this callbacks can be nested using the 
\f(CWEv(...)\fR \*(L"constructor\*(R". 
\f(CWEv(...)\fR inserts callback objects into the
argument list. When perl/Tk glue code is preparing the argument list for 
the callback it is about to call it spots these special objects and
recursively applies the callback process to them.
.SH BUGS
\fIThis mechanism was implemented before perl5.001 introduced anonymous\fR
\f(CWsub {}\fR \fIclosures. Such closures may be a more appropriate way of 
achieving the same effect.\fR
.SH EXAMPLES
.nf
$e->bind('<Return>' => [ $w , 'validate', Ev(['get']) ] ); 
.br
$topLevelWin->bind('all',"<Visibility>", [\e&unobscure, Ev('s')]);
.br
$mw->bind($class,"<Down>",['SetCursor',Ev('UpDownLine',1)]);
.fi
.SH "SEE ALSO"
bind
after
options
fileevent
.SH KEYWORDS
clallback, closure
