package CPAN::Cover::Results::Release;
$CPAN::Cover::Results::Release::VERSION = '0.02';
use Moo;

has 'distname'   => ( is => 'ro' );
has 'version'    => ( is => 'ro' );
has 'branch'     => ( is => 'ro' );
has 'condition'  => ( is => 'ro' );
has 'pod'        => ( is => 'ro' );
has 'statement'  => ( is => 'ro' );
has 'subroutine' => ( is => 'ro' );
has 'total'      => ( is => 'ro' );

1;

=head1 NAME

CPAN::Cover::Results::Release - CPAN coverage results for one release

=head1 SYNOPSIS

 use CPAN::Cover::Results::Release;
 my $release = CPAN::Cover::Results::Release->new(
                    distname   => 'Graph',
                    version    => '0.96_01',
                    branch     => '77.56',
                    condition  => '67.61',
                    pod        => '87.15',
                    statement  => '91.56',
                    subroutine => '94.98',
                    total      => '86.12',
               );

=head1 DESCRIPTION

This module holds the test coverage results for one release,
as generated by CPAN Cover.

=head1 SEE ALSO

L<CPAN::Cover::Results>

=head1 AUTHOR

Neil Bowers E<lt>neilb@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Neil Bowers <neilb@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

