# 📘 ClarID Codebook Documentation

## Overview

This codebook defines a standardized encoding system for species, biosample metadata, assay types, conditions, and other identifiers in the **ClarID** project. It provides a mapping between human-readable labels and compact codes or stub codes for use in structured identifiers and databases.

??? Example "See Codebook:"

    ```yaml
    --8<-- "../share/clarid-codebook.yaml"
    ```

??? Hint "About `species`:"

    > **Reference**: Based on Schrade et al., *Animals* 2024, Table 2.
 
 
    🧬 Component I: Species Information
 
    Each species entry is defined by two key elements:
 
    - **Element 1 (positions 1–3)**: `tax_code`  
      A 3-letter taxonomic classification code:
      - 1st letter: Class  
      - 2nd letter: Order  
      - 3rd letter: Family  
      - Example: `MPC` = *Mammalia | Primates | Cercopithecidae*
 
    - **Element 2 (positions 5–10)**: `code`  
      A 6-letter binomial acronym formed by:
      - 3 letters from the genus name  
      - 3 letters from the species name  
      - Example: `MacMul` = *Macaca mulatta*
 
    - **`stub_code`**: A 2-character Base-62 encoded unique species identifier  
    (e.g. `"01"` for *Homo sapiens*, `"0E"` for *Macaca mulatta*)
 
    Note: `tax_code` is provided as metadata and is not used in encode/decode logic.

---

## 📝 Metadata

Defines global codebook info:

```yaml
metadata:
  version: "0.01"         # 🏷️ version
  author: "M. Rueda"      # 👤 author
  center: "CNAG"          # 🏢 institution
  date: "2025-07-10"      # 📅 YYYY-MM-DD
  description: "ClarID codebook"  # 📝 summary
  repository: "https://github.com/cnag-biomedical-informatics/clarid-tools"  # 🔗 repo URL
```

---

## 🌐 Entities

All under `entities:`.

### 🔄 `_defaults`
Fallback when no match:

```yaml
entities:
  _defaults:
    Unknown:
      code:       UNK
      stub_code:  U
      label:      "Unknown"
      id:         "NCIT:C17998"
    "Not Available":
      code:       NAV
      stub_code:  n
      label:      "Not Available"
      id:         "NCIT:C126101"
```

---

## 🛠️ `biosample`

### 📁 project
```yaml
entities:
  biosample:
    project: &all_projects
      "TCGA-AML":
        code:      TCGA_AML
        stub_code: AML
        label:     "TCGA Acute Myeloid Leukemia"
        id:         "NCIT:C17998" # Unknown
```

### 🧬 species
```yaml
    species:
      Human:
        code: HomSap        # 🆔 binomial acronym
        stub_code: "01"     # 🔢 index
        label: "Homo sapiens"  # 📖 name
        id: "NCBITaxon:9606"  # 🔗 taxonomy
        tax_code: MPH       # 🏷️ class|order|family
```

### 🏥 tissue
```yaml
    tissue:
      Liver:
        code: LIV
        stub_code: L
        label: "Liver"
        id: "UBERON:0002107"
```

### 🧪 sample_type
```yaml
    sample_type:
      Tumor:
        code: TUM
        stub_code: T
        label: "Tumor"
        id: "NCIT:C4872"
```

### 🔬 assay
```yaml
    assay:
      RNA_seq:
        code:       RNA
        stub_code:  R
        label:      "RNA-seq"
        id:         "EFO:0008896"
```

### ⏰ timepoint
```yaml
    timepoint:
      Baseline:
        code:       BSL
        stub_code:  "B"
        label:      "Baseline"
        id:         "NCIT:C25213"
```

---

## 🔍 Patterns

Regex-based formats:

```yaml
    condition_pattern:
      regex: '^([A-Z]\d{2}(?:\.\d+)?)$'  # ✅ Letter+digits
      code_format: '%s'
      stub_format: '%s'
```

---

## 👥 Subject

### 🔄 study
Reuses `biosample.project`:

```yaml
  subject:
    study: *all_projects
```

### 🧑‍🤝‍🧑 type, sex, age_group
```yaml
      Case:
        code:       Case
        stub_code:  C
        label:      "Case Study"
        id:         "NCIT:C15362"
      sex:
      Male:
        code:       Male
        stub_code:  M
        label:      "Male"
        id:         "PATO:0000384"
      age_group:
        Age20to29:
          code:       A20_29
          stub_code:  A2
          label:      "Age 20-29"
          id:         "APOLLO:SV_00000241" # age range category

```
