# -*- Mode: CPerl -*-

$TEST_DIR = './t';
#use lib qw(../blib/lib ../blib/arch); $TEST_DIR = '.'; # for debugging

use DDC::XS;

# load common subs
do "$TEST_DIR/common.plt"
  or die("could not load $TEST_DIR/common.plt");

plan(test => 12);

##-- 1..2: rank
my ($f);
isok("ranksort:new", ($f=DDC::XS::CQFRankSort->new(DDC::XS::GreaterByRank)));
isok("ranksort:str", $f->toString =~ /^\#(?:DE?SC|GREATER)(?:_BY)?_RANK$/i);

##-- 3..4: date
isok("datesort:new", ($f=DDC::XS::CQFDateSort->new(DDC::XS::LessByDate, '1900-01-01', '2000')));
isok("datesort:str", $f->toString =~ /^\#(?:ASC|LESS)(?:_BY)?_DATE\[1900-01-01,2000\]$/i);

##-- 5..6: ctx : toString() buggy in ddc-2.0.37
isok("ctxsort:new", ($f=DDC::XS::CQFContextSort->new(DDC::XS::LessByLeftContext, 'w',1,-1,'A','zzz')));
isok("ctxsort:str", $f->toString =~ /^\#(?:ASC|LESS)(?:_BY)?_LEFT\[\'w\'\s*=1\s*-1,'A','zzz'\]$/i);

##-- 7..8: hasfield (negated)
isok("hasfield:new", ($f=DDC::XS::CQFHasField->new('author','kant',1)));
isok("hasfield:str", $f->toString =~ /^\!\#HAS(?:_FIELD)?\['author','kant'\]$/i);

##-- 9..10: hasregex
isok("hasregex:new", ($f=DDC::XS::CQFHasFieldRegex->new('author','kant',0)));
isok("hasregex:str", $f->toString =~ m{^\#HAS(?:_FIELD)?\['author',/kant/\]$}i);

##-- 11..12: hasset
isok("hasset:new", ($f=DDC::XS::CQFHasFieldSet->new('author',[qw(kant hegel)],0)));
isok("hasregex:str", $f->toString =~ m(^\#HAS(?:_FIELD)?\['author',\{'hegel','kant'\}\]$)i);

print "\n";

