#
#===============================================================================
#
#         FILE:  WxTypes.pm
#
#  DESCRIPTION:  Interface constants betwin Vtiger webservices & Wx
#
#        FILES:  ---
#         BUGS:  ---
#        NOTES:  ---
#       AUTHOR:  Ricardo Filipo (rf), ticardo.filipo@gmail.com
#      COMPANY:  Mito-Lógica design e soluções de comunicação ltda
#      VERSION:  1.0
#      CREATED:  20-01-2011 00:44:57
#     REVISION:  ---
#===============================================================================
package Vtiger::WxTypes;
use strict;
use warnings;

use constant DEBUG => 1; # yeah, we are debugging!!!

=head1

These constants maps Perl abstract, Wx input types and Vtiger

=cut

use constant MODULE_DESCRIPTION => qw(
    label
    name
    createable
    updateable
    deleteable
    retrieveable
    fields
);

use constant FIELD_DESCRIPTION => qw(
    name
    label
    mandatory
    type
    default
    nillable
    editable 
);

1;
 __END__

use constant {
    wxString => string, # A one line text field.
    text -# A multiline text field.
    integer - A non decimal number field.
    double - A field for for floating point numbers.
    boolean - A boolean field, can have the values true or false.
    time - A string of the format hh:mm, format is based on the user's settings time format.
    date - A string representing a date, the type map will contain another element called format which is the format in which the value of this field is expected, its based on the user's settings date format.
    datetime - A string representing the date and time, the format is base on the user's settings date format.
    autogenerated - Thes are fields for which the values are generated automatically by vtiger, this is usually an object's id field.
    reference - A field that shows a relation to another object, the type map will contain another element called refersTo which is an array containing the name of modules of which the field can point to.
    picklist - A field that can a hold one of a list of values, the map will contain two elements, picklistValues which is a list of possible values, and defaultValue which is the default value for the picklist.
    multipicklist - A picklist field where multiple values can be selected.
    phone - A field for storing phone numbers
    email - A field for storing email ids
    url - A field for storing urls
    skype - A field for storing skype ids or phone numbers.
    password - A field for storing passwords.
    owner - A field for defining the owner of the field. which could be a group or individual user.


};

}
