package MyTypes::Permission;
use strict;
use warnings;


our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Rights_of :ATTR(:get<Rights>);
my %Principal_of :ATTR(:get<Principal>);

__PACKAGE__->_factory(
    [ qw(        Rights
        Principal

    ) ],
    {
        'Rights' => \%Rights_of,
        'Principal' => \%Principal_of,
    },
    {
        'Rights' => 'MyTypes::ADDITIONAL_ROLES',
        'Principal' => 'MyTypes::Principal',
    },
    {

        'Rights' => 'Rights',
        'Principal' => 'Principal',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::Permission

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Permission from the namespace http://tempuri2.org/.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Rights


=item * Principal




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::Permission
   Rights => $some_value, # ADDITIONAL_ROLES
   Principal =>  { value => $some_value },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

