
package MyElements::AddTask;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://tempuri2.org/' }

__PACKAGE__->__set_name('AddTask');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %taskListName_of :ATTR(:get<taskListName>);
my %createData_of :ATTR(:get<createData>);
my %modifyData_of :ATTR(:get<modifyData>);

__PACKAGE__->_factory(
    [ qw(        taskListName
        createData
        modifyData

    ) ],
    {
        'taskListName' => \%taskListName_of,
        'createData' => \%createData_of,
        'modifyData' => \%modifyData_of,
    },
    {
        'taskListName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'createData' => 'MyTypes::ItemCreateData',
        'modifyData' => 'MyTypes::TaskModifyData',
    },
    {

        'taskListName' => 'taskListName',
        'createData' => 'createData',
        'modifyData' => 'modifyData',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

MyElements::AddTask

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
AddTask from the namespace http://tempuri2.org/.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * taskListName

 $element->set_taskListName($data);
 $element->get_taskListName();




=back
=item * createData

 $element->set_createData($data);
 $element->get_createData();




=back
=item * modifyData

 $element->set_modifyData($data);
 $element->get_modifyData();




=back


=head1 METHODS

=head2 new

 my $element = MyElements::AddTask->new($data);

Constructor. The following data structure may be passed to new():

 {
   taskListName =>  $some_value, # string
   createData =>  { # MyTypes::ItemCreateData
     Folder =>  { # MyTypes::Folders
       SubFolder =>  $some_value, # string
     },
     Author =>  { value => $some_value },
     GroupID =>  $some_value, # int
   },
   modifyData =>  { # MyTypes::TaskModifyData
     Status =>  $some_value, # string
     Description =>  $some_value, # string
     DueDate =>  $some_value, # dateTime
     AssignedTo =>  { value => $some_value },
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

