use strict;
use warnings;
use ExtUtils::MakeMaker;
use Config;

my @o_ltm_ltc = map { s/\.c$/.$Config{obj_ext}/; $_ } (
    glob('src/ltm/*.c'),
    glob('src/ltc/*/*.c'),
    glob('src/ltc/*/*/*.c'),
    glob('src/ltc/*/*/*/*.c'),
    glob('src/ltc/*/*/*/*/*.c'),
);
my $myextlib = "src/liballinone$Config{lib_ext}";

WriteMakefile(
    NAME      => 'CryptX',
    VERSION_FROM => 'lib/CryptX.pm',
    DEFINE    => '-DLTC_SOURCE -DLTC_NO_TEST -DLTC_NO_PROTOTYPES -DLTM_DESC',
    INC       => '-Isrc/ltc/headers -Isrc/ltm',
    clean     => {'FILES' => join(' ', @o_ltm_ltc) . "  $myextlib"},
    MYEXTLIB => $myextlib,
);

sub MY::postamble {
'
$(MYEXTLIB): src/Makefile
	cd src && $(MAKE) LIB_EXT=$(LIB_EXT) CCFLAGS="-DLTC_SOURCE -DLTC_NO_TEST -DLTC_NO_PROTOTYPES -DLTM_DESC"
';
}

