#! perl -w
# Copyright: 2001-2003 The Perl Foundation.  All Rights Reserved.
# $Id: config_pm.pl,v 1.3 2004/02/26 00:43:05 mikescott Exp $

=head1 NAME

config/gen/config_pm.pl - Parrot::Config

=head1 DESCRIPTION

Writes the C<Parrot::Config> Perl module.

=cut

package Configure::Step;

use strict;
use vars qw($description @args);
use Parrot::Configure::Step;
use Data::Dumper;

$description="Writing Parrot::Config module...";

@args=();

sub runstep {
  open(IN, "config/gen/config_pm/Config_pm.in") or die "Can't open Config_pm.in: $!";
  open(OUT, ">lib/Parrot/Config.pm") or die "Can't open lib/Parrot/Config.pm: $!";

  print OUT "# Generated by config/gen/config_pm.pl\n";

  while(<IN>) {
    s/<<HERE>>/Configure::Data->dump()/e;
    print OUT;
  }
 
  close IN  or die "Can't close Config_pm.in: $!";
  close OUT or die "Can't close Config.pm: $!";
}

1;
