#! perl -w

use strict;
use lib 'lib';
use Digest::Perl::MD5 qw(md5_hex);

my $compat_file = 'PBC_COMPAT';
open IN, $compat_file or die "Can't read $compat_file";
my @lines = <IN>;
close IN;

my $len = 10;
my $fingerprint = md5_hex join "\n", grep { ! /^#/ } @lines;

print << "EOF";
/*
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *
 * This file is generated automatically from '$compat_file'
 * by $0.
 *
 * Any changes made here will be lost!
 *
 */

#include <string.h>
#include <parrot/packfile.h>

EOF

if (-e 'DEVELOPING') {

print "/* $fingerprint */\n";
print "static const unsigned char fingerprint[] = {\n";
for my $i (0..$len-1) {
  print '    0x', substr ($fingerprint, $i*2, 2), ",\n";
}
print "};\n";

print << "EOF";

int
PackFile_check_fingerprint (void *cursor)
{
    return memcmp (cursor, fingerprint, $len) == 0;
}

size_t
PackFile_write_fingerprint (void *cursor)
{
    memcpy (cursor, fingerprint, $len);
    return $len;
}
EOF

} else { # !DEVELOPING

  print << "EOF";
/* fingerprint checking is only enabled in development versions */

int
PackFile_check_fingerprint (void *cursor)
{
    return 1;
}

size_t
PackFile_write_fingerprint (void *cursor)
{
    memset (cursor, 0, $len);
    return $len;
}
EOF

} # endif DEVELOPING
