package Kephra::App::MainToolBar;
our $VERSION = '0.08';

use strict;
use warnings;


sub _ref    { Kephra::App::ToolBar::_ref( _name(), $_[0]) }
sub _name   { 'main' }
sub _ID     { _name().'_toolbar' }
sub _config { $Kephra::config{app}{toolbar}{main} }

sub create {
	return until get_visibility();
	my $frame = Kephra::App::Window::_ref();
	my $bar = $frame->GetToolBar;
	# destroy old toolbar if there any
	Kephra::App::ToolBar::destroy( _name() ) if $bar;
	_ref( $frame->CreateToolBar );
	my $bar_def = Kephra::Config::File::load_from_node_data( _config() );
	unless ($bar_def) {
		$bar_def = Kephra::Config::Tree::get_subtree
			( Kephra::Config::Default::toolbars(), _ID() );
	}
	Kephra::App::ToolBar::create( _name(), $bar_def );
}
sub destroy { Kephra::App::ToolBar::destroy ( _name() ) }

sub get_visibility    { _config()->{visible} }
sub switch_visibility { _config()->{visible} ^= 1; show(); }
sub show {
	if ( get_visibility() ){
		create()
	} else {
		Kephra::App::ToolBar::destroy( _name() );
		Kephra::App::Window::_ref()->SetToolBar(undef);
	}
}

1;
