package # hide from PAUSE
App::YTDL::Data_Extract;

use warnings;
use strict;
use 5.010000;

use Exporter qw( import );
our @EXPORT_OK = qw( add_entry_to_info_hash json_to_hash );

use JSON               qw( decode_json );
use Term::Choose::Util qw( insert_sep );

use App::YTDL::Helper qw( sec_to_time );



sub add_entry_to_info_hash {
    my ( $opt, $info, $entry, $type, $list_id ) = @_;
    die '$entry node not defined!' if ! defined $entry;
    die 'empty $entry node!'       if ! $entry;
    my $video_id = $entry->{'media$group'}{'yt$videoid'}{'$t'};
    die 'no video_id!' if ! $video_id;
    my $ex = 'youtube';
    my $title       = $entry->{'title'}{'$t'};
    my $description = $entry->{'media$group'}{'media$description'}{'$t'};
    my $keywords    = $entry->{'media$group'}{'media$keywords'}{'$t'};
    my $author      = $entry->{'author'}[0]{'name'}{'$t'};
    my $author_uri  = $entry->{'author'}[0]{'uri'}{'$t'};
    my $user_id     = $entry->{'author'}[0]{'yt$userId'}{'$t'};
    #my $categories  = $entry->{'media$group'}{'media$category'}[0]{'$t'};
    my $published   = $entry->{'published'}{'$t'};
    my $seconds     = $entry->{'media$group'}{'yt$duration'}{'seconds'};
    my $avg_rating  = $entry->{'gd$rating'}{'average'};
    my $num_raters  = $entry->{'gd$rating'}{'num_raters'};
    my $view_count  = $entry->{'yt$statistics'}{'viewCount'};
    my $likes       = $entry->{'yt$rating'}{'numLikes'};
    my $dislikes    = $entry->{'yt$rating'}{'numDislikes'};
    $info->{$ex}{$video_id} = {
        uploader    => $author,
        author_uri  => $author_uri,
        user_id     => $user_id,
        avg_rating  => $avg_rating,
        #categories  => $categories,
        description => $description,
        keywords    => $keywords,
        duration    => $seconds,
        published   => $published,
        raters      => $num_raters,
        title       => $title,
        video_id    => $video_id,
        view_count  => $view_count,
        likes       => $likes,
        dislikes    => $dislikes,
    };
    if ( $info->{$ex}{$video_id}{author_uri} && $info->{$ex}{$video_id}{author_uri} =~ m|/users/([^$opt->{invalid_char}]+)| ) {
        $info->{$ex}{$video_id}{uploader_id} = $1;
    }
    if ( defined $type && $type eq 'PL' ) {
        $info->{$ex}{$video_id}{playlist_id} = $list_id;
    }
    _prepare_info_hash( $opt, $info, $ex, $video_id );
}


sub json_to_hash {
    my ( $opt, $tmp, $json ) = @_;
    my $h_ref = decode_json( $json );
    my $formats = {};
    my $c = 1;
    for my $format ( @{$h_ref->{formats}} ) {
        my $fmt = $format->{format_id} // 'unkown_fmt_' . $c++;
        $formats->{$fmt}{ext}         = $format->{ext};
        $formats->{$fmt}{format}      = $format->{format};
        $formats->{$fmt}{format_note} = $format->{format_note};
        $formats->{$fmt}{height}      = $format->{height};
        $formats->{$fmt}{width}       = $format->{width};
        $formats->{$fmt}{url}         = $format->{url};
    }
    my $ex = $h_ref->{extractor} // $h_ref->{extractor_key} // '';
    if ( $ex =~ /^youtube\z/i ) {
        $ex = 'youtube';
    }
    if ( ! length $ex ) {
        $ex = 'unkown_etractor';
    }
    my $video_id = $h_ref->{id} // $h_ref->{title};
    my @keys = ( qw( uploader uploader_id description format_id dislike_count dislike_count
                    duration extractor extractor_key like_count playlist_id title upload_date view_count ) );
                    # age_limit annotations fulltitle playlist stitle categories
    for my $key ( @keys ) {
        if ( defined $h_ref->{$key} ) {
            $tmp->{$ex}{$video_id}{$key} = $h_ref->{$key};
        }
    }
    if ( $tmp->{$ex}{$video_id}{upload_date} && $tmp->{$ex}{$video_id}{upload_date} =~ /^(\d{4})(\d{2})(\d{2})\z/ ) {
        $tmp->{$ex}{$video_id}{upload_date}     = $1 . '-' . $2 . '-' . $3;
        $tmp->{$ex}{$video_id}{upload_datetime} = $1 . '-' . $2 . '-' . $3 . 'T00:00:00';
    }
    $tmp->{$ex}{$video_id}{fmt_to_info} = $formats;
    _prepare_info_hash( $opt, $tmp, $ex, $video_id );
    return;
}


sub _prepare_info_hash {
    my ( $opt, $info, $ex, $video_id ) = @_;
    $info->{$ex}{$video_id}{title}           ||= time();
    $info->{$ex}{$video_id}{duration}        ||= '-:--:--';
    $info->{$ex}{$video_id}{upload_date}     ||= '0000-00-00';
    $info->{$ex}{$video_id}{upload_datetime} ||= '0000-00-00T00:00:00';
    $info->{$ex}{$video_id}{upload_id}   //= '';
    $info->{$ex}{$video_id}{playlist_id} //= '';
    $info->{$ex}{$video_id}{uploader}    //= $info->{$ex}{$video_id}{uploader_id} // '';
    #$info->{$ex}{$video_id}{extractor_key} //= $info->{$ex}{$video_id}{extractor} // '';
    if ( $info->{$ex}{$video_id}{published} && $info->{$ex}{$video_id}{published} =~ /^(\d\d\d\d-\d\d-\d\d)T(\d\d:\d\d:\d\d)/ ) {
        $info->{$ex}{$video_id}{upload_date} = $1;
        $info->{$ex}{$video_id}{upload_datetime} = $1 . 'T' . $2;
    }
    if ( $info->{$ex}{$video_id}{duration} =~ /^[0-9]+\z/ ) {
        $info->{$ex}{$video_id}{duration} = sec_to_time( $info->{$ex}{$video_id}{duration}, 1 );
    }
    if ( $info->{$ex}{$video_id}{like_count} && $info->{$ex}{$video_id}{dislike_count} ) {
        $info->{$ex}{$video_id}{raters}     ||= $info->{$ex}{$video_id}{like_count} + $info->{$ex}{$video_id}{dislike_count};
        $info->{$ex}{$video_id}{avg_rating} ||= $info->{$ex}{$video_id}{like_count} * 5 / $info->{$ex}{$video_id}{raters};
    }
    if ( $info->{$ex}{$video_id}{avg_rating} ) {
        $info->{$ex}{$video_id}{avg_rating} = sprintf "%.2f", $info->{$ex}{$video_id}{avg_rating};
    }
    if ( $info->{$ex}{$video_id}{raters} ) {
        $info->{$ex}{$video_id}{raters} = insert_sep( $info->{$ex}{$video_id}{raters} );
    }
    if ( $info->{$ex}{$video_id}{view_count} ) {
        $info->{$ex}{$video_id}{view_count_raw} = $info->{$ex}{$video_id}{view_count} // 0;
        $info->{$ex}{$video_id}{view_count} = insert_sep( $info->{$ex}{$video_id}{view_count} );
        if ( length $info->{$ex}{$video_id}{view_count} > $opt->{length_view_count} ) {
            $opt->{length_view_count} = length $info->{$ex}{$video_id}{view_count};
        }
    }
}





1;


__END__
