#!/usr/bin/perl -w

# Copyright 2015, 2016 Kevin Ryde
#
# This file is part of Graph-Maker-Other.
#
# Graph-Maker-Other is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 3, or (at your option) any later
# version.
#
# Graph-Maker-Other is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with Graph-Maker-Other.  If not, see <http://www.gnu.org/licenses/>.

use 5.005;
use strict;
use Math::BaseCnv 'cnv';
use MyGraphs;

use FindBin;
use lib "$FindBin::Bin/lib";
use Graph::Maker::Keller;

# uncomment this to run the ### lines
# use Smart::Comments;

{
  # hog trees and paths

  # Rpred high to low -- not
  # Lpred high to low, and reverse -- not
  # Rpred+Lpred for bridges -- not
  # complex plus boundary state machine and reversed -- not
  # C right boundary and reverse -- not
  # C doubles and reverse -- not
  # Terdragon Eboth -- not

  my @graphs;
  for (my $k = 2; @graphs < 1; $k++) {
    my $graph;

    # {
    #   # Terdragon 3-cycle k=1..2 not
    #   # neighbours6 shortcuts on boundary level=2,3 not
    #   #  level=1 https://hog.grinvin.org/ViewGraphInfo.action?id=28
    #   require Graph::Maker::PlanePath;
    #   $graph = Graph::Maker->new('planepath', level=>$k,
    #                              planepath=>'TerdragonCurve',
    #                              n_lo => 2 * 3**$k,
    #                              n_hi => 5 * 3**$k,
    #                             );
    # }
    # {
    #   # R5 quad-r5dragon 4-cycle k=1 not
    #   require Graph::Maker::R5Twindragon;
    #   $graph = Graph::Maker->new('r5twindragon', level=>$k, arms=>1,
    #                              undirected=>1);
    # }
    # {
    #   # Dragon blob k=5..6 not
    #   # k=4 single square https://hog.grinvin.org/ViewGraphInfo.action?id=674
    #   #
    # require Graph::Maker::Dragon;
    #   $graph = Graph::Maker->new('dragon', level=>$k,
    #                              part=>'blob',
    #                              undirected=>1);
    # }
    {
      # Dragon k=4,5 not
      # R5 k=2 not https://hog.grinvin.org/ViewGraphInfo.action?id=25149
      #    k=3 not https://hog.grinvin.org/ViewGraphInfo.action?id=25147
      # Terdragon
      #   k=2  https://hog.grinvin.org/ViewGraphInfo.action?id=21138
      #   k=3  https://hog.grinvin.org/ViewGraphInfo.action?id=21140
      #   cf k=2 not same as boat 8 vertices of Christophe et al Graphedron
      #        *---*
      #         \
      #      *---*
      #       \ / \
      #        *---*
      #         \
      #      *---*
      # AlternatePaper k=3..5 not
      # CCurve k=4..5 not
      require Graph::Maker::PlanePath;
      $graph = Graph::Maker->new('planepath',
                                 undirected=>1,
                                 level=>$k,
                                 planepath=>'R5DragonCurve');
    }

    # UlamWarburton depth=2..3 not
    # UlamWarburton,parts=2 depth=3..4 not
    #  depth=2 https://hog.grinvin.org/ViewGraphInfo.action?id=816
    # UlamWarburton,parts=1 depth=3..4 not
    #  depth=4 same as SierpinskiTriangle depth=4
    # UlamWarburton,parts=octant depth=5..6 not
    # LCornerTree,parts=2 depth=3..4 not
    #  depth=2 https://hog.grinvin.org/ViewGraphInfo.action?id=452
    # ToothpickUpist depth=6 not
    # ToothpickTree depth=3..5 not
    # ToothpickTree,parts=1 depth=4..5 not
    # ToothpickTree,parts=2 depth=4..5 not
    # ToothpickTree,parts=octant depth=5..7 not
    # ToothpickTree,parts=wedge depth=5..7 not
    # OneOfEightTree,parts=4 depth=2..3 not
    # OneOfEightTree,parts=1 depth=3..4 not
    #  depth=1 fork https://hog.grinvin.org/ViewGraphInfo.action?id=30
    # OneOfEightTree,parts=octant depth=4..5 not
    #  depth=3 https://hog.grinvin.org/ViewGraphInfo.action?id=792
    # ComplexPlus neighbours4 level=4 not
    #  level=3 https://hog.grinvin.org/ViewGraphInfo.action?id=700
    # Flowsnake neighbours6 level=1..2 not
    # FlowsnakeCentres neighbours6 level=1..2 not
    #   level=1 would be wheel 7
    # KochCurve neighbours6 level=2 not
    #   k=1 triangle+sides https://hog.grinvin.org/ViewGraphInfo.action?id=240
    #   also is SierpinskiTriangle rows 0 to 4 connected
    # SierpinskiTriangle depth=3,5,6,7 not
    #  depth=4 https://hog.grinvin.org/ViewGraphInfo.action?id=278 [done]
    #  neighbours6 level=2,3 not
    #  neighbours cf Hanoi graph H2
    # {
    #   $graph = Graph::Maker->new('planepath',
    #                              undirected=>1,
    #                              # level=>$k,
    #                              # depth=>$k,
    #                              planepath=>'R5DragonCurve',
    #                              # type => 'neighbours6',
    #                             );
    # }

    # {
    #   # BalancedTree
    #   # binary not 4,5
    #   #   height=3 https://hog.grinvin.org/ViewGraphInfo.action?id=498
    #   # ternary not 4
    #   #   height=3 https://hog.grinvin.org/ViewGraphInfo.action?id=662
    #   # quad tree not 4
    #   require Graph::Maker::BalancedTree;
    #   $graph = Graph::Maker->new('balanced_tree',
    #                              fan_out => 2, height => $k,
    #                             );
    # }
    # {
    #   # Hypercube
    #   # N=3 cubical https://hog.grinvin.org/ViewGraphInfo.action?id=1022
    #   # N=4 tesseract https://hog.grinvin.org/ViewGraphInfo.action?id=1340
    #   # N=5 not  32 nodes 80 edges
    #   require Graph::Maker::Hypercube;
    #   $graph = Graph::Maker->new('hypercube', N => $k, undirected=>1);
    # }
    # {
    #   # FibonacciTree not 5,6
    #   # k=4 six with a leaf off it
    #   #     https://hog.grinvin.org/ViewGraphInfo.action?id=934
    #   # zero_node=>1 not 4,5,6
    #   require Graph::Maker::FibonacciTree;
    #   $graph = Graph::Maker->new('fibonacci_tree',
    #                              height => $k,
    #                              # leaf_reduced => 1,
    #                              # series_reduced => 1,
    #                             );
    # }

    # Graph_branch_reduce($graph);
    # print "strip hanging cycles " . Graph_strip_hanging_cycles($graph) . "\n";

    # next if $graph->vertices == 0;
    last if $graph->vertices > 200;

    Graph_xy_print($graph);
    push @graphs, $graph;
  }
  hog_searches_html(@graphs);
  exit 0;
}
