MODULE = SWISH::3       PACKAGE = SWISH::3::Token

PROTOTYPES: enable

SV*
value (self)
	swish_Token *	self;
              
    CODE:
        RETVAL = newSVpvn( (char*)self->value, self->len );
        
    OUTPUT:
        RETVAL
        

swish_MetaName*
meta (self)
	swish_Token *	self;
    
    PREINIT:
        char* CLASS;
        
    CODE:
        CLASS  = METANAME_CLASS;
        RETVAL = self->meta;
        RETVAL->ref_cnt++;
        
    OUTPUT:
        RETVAL
       
SV*
meta_id (self)
        swish_Token *   self;
    CODE:
        RETVAL = newSViv( self->meta->id );
    OUTPUT:
        RETVAL

     
SV*
context (self)
	swish_Token *	self;
    CODE:
        RETVAL = newSVpvn( (char*)self->context, strlen((char*)self->context) );
        
    OUTPUT:
        RETVAL
        

SV*
pos (self)
	swish_Token *	self;
    CODE:
        RETVAL = newSViv( self->pos );
        
    OUTPUT:
        RETVAL


SV*
len(self)
	swish_Token *	self;
    CODE:
        RETVAL = newSViv( self->len );
        
    OUTPUT:
        RETVAL


void
DESTROY(self)
    swish_Token* self
    
    CODE:
        self->ref_cnt--;
                        
        if (SWISH_DEBUG & SWISH_DEBUG_MEMORY) {
            warn("DESTROYing swish_Token object %s  [%ld] [ref_cnt = %d]", 
                SvPV(ST(0), PL_na), (long)self, self->ref_cnt);
            warn("Token has swish_MetaName object ref_cnt = %d", 
                self->meta->ref_cnt);
        }
        
        if (self->ref_cnt > 0 && self->meta->ref_cnt == 0) {
            SWISH_WARN("Token's MetaName ref_cnt should not be less than Token");
        }
        
        if (self->ref_cnt < 1) {
            swish_token_free(self);
        }
        
