# This -*- perl -*- script makes the Makefile
# $Id: Makefile.PL,v 1.3 1997/03/04 09:21:12 gbarr Exp $

require 5.002;
use ExtUtils::MakeMaker;

#--- MY package

sub MY::libscan
{
 my($self,$path) = @_;

 return '' 
	if($path =~ m:/(RCS|CVS|SCCS)/: ||
	   $path =~ m:[~%]$: ||
	   $path =~ m:\.(orig|rej)$:
	  );
 
 $path;
}

WriteMakefile(
	      PREREQ_PM => {
			    builtin => .01,
			    IO => 1.19,
			    Test => 1,
			   },
	      VERSION_FROM	=> "Event.pm",
	      NAME      	=> "Event",
 
	'linkext' 	=> {LINKTYPE => 'dynamic' },
	'dist'    	=> {COMPRESS => 'gzip -9f',
			    SUFFIX   => 'gz', 
			    DIST_DEFAULT => 'all tardist',
			   },
 
	'clean'   	=> {FILES => join(" ",
					map { "$_ */$_ */*/$_" }
					qw(*% *.html *.b[ac]k *.old *.orig))
			   },
);
