package Paws::SecurityHub::ContainerDetails;
  use Moose;
  has ImageId => (is => 'ro', isa => 'Str');
  has ImageName => (is => 'ro', isa => 'Str');
  has LaunchedAt => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::ContainerDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::ContainerDetails object:

  $service_obj->Method(Att1 => { ImageId => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::ContainerDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->ImageId

=head1 DESCRIPTION

Container details related to a finding.

=head1 ATTRIBUTES


=head2 ImageId => Str

  The identifier of the image related to a finding.


=head2 ImageName => Str

  The name of the image related to a finding.


=head2 LaunchedAt => Str

  The date/time that the container was started.


=head2 Name => Str

  The name of the container related to a finding.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

