
package Paws::GameLift::CreateFleet;
  use Moose;
  has BuildId => (is => 'ro', isa => 'Str', required => 1);
  has Description => (is => 'ro', isa => 'Str');
  has EC2InboundPermissions => (is => 'ro', isa => 'ArrayRef[Paws::GameLift::IpPermission]');
  has EC2InstanceType => (is => 'ro', isa => 'Str', required => 1);
  has LogPaths => (is => 'ro', isa => 'ArrayRef[Str]');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has NewGameSessionProtectionPolicy => (is => 'ro', isa => 'Str');
  has ServerLaunchParameters => (is => 'ro', isa => 'Str');
  has ServerLaunchPath => (is => 'ro', isa => 'Str', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'CreateFleet');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::GameLift::CreateFleetOutput');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::CreateFleet - Arguments for method CreateFleet on Paws::GameLift

=head1 DESCRIPTION

This class represents the parameters used for calling the method CreateFleet on the 
Amazon GameLift service. Use the attributes of this class
as arguments to method CreateFleet.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to CreateFleet.

As an example:

  $service_obj->CreateFleet(Att1 => $value1, Att2 => $value2, ...);

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.

=head1 ATTRIBUTES


=head2 B<REQUIRED> BuildId => Str

Unique identifier for the build you want the new fleet to use.



=head2 Description => Str

Human-readable description of the fleet.



=head2 EC2InboundPermissions => ArrayRef[L<Paws::GameLift::IpPermission>]

Access limits for incoming traffic. Setting these values limits game
server access to incoming traffic using specified IP ranges and port
numbers. Some ports in a range may be restricted. You can provide one
or more sets of permissions for the fleet.



=head2 B<REQUIRED> EC2InstanceType => Str

Type of EC2 instances used in the fleet. EC2 instance types define the
CPU, memory, storage, and networking capacity of the fleetaposs hosts.
Amazon GameLift supports the EC2 instance types listed below. See
Amazon EC2 Instance Types for detailed descriptions of each.

Valid values are: C<"t2.micro">, C<"t2.small">, C<"t2.medium">, C<"t2.large">, C<"c3.large">, C<"c3.xlarge">, C<"c3.2xlarge">, C<"c3.4xlarge">, C<"c3.8xlarge">, C<"c4.large">, C<"c4.xlarge">, C<"c4.2xlarge">, C<"c4.4xlarge">, C<"c4.8xlarge">, C<"r3.large">, C<"r3.xlarge">, C<"r3.2xlarge">, C<"r3.4xlarge">, C<"r3.8xlarge">, C<"m3.medium">, C<"m3.large">, C<"m3.xlarge">, C<"m3.2xlarge">, C<"m4.large">, C<"m4.xlarge">, C<"m4.2xlarge">, C<"m4.4xlarge">, C<"m4.10xlarge">

=head2 LogPaths => ArrayRef[Str]

Path to game-session log files generated by your game server. Once a
game session has been terminated, Amazon GameLift captures and stores
the logs on Amazon S3. Use the GameLift console to access the stored
logs.



=head2 B<REQUIRED> Name => Str

Descriptive label associated with this fleet. Fleet names do not need
to be unique.



=head2 NewGameSessionProtectionPolicy => Str

Game session protection policy to apply to all instances created in
this fleet. If this parameter is not set, new instances in this fleet
will default to no protection. Protection can be set for individual
instances using UpdateGameSession.

=over

=item * NoProtection: The game session can be terminated during a
scale-down event.

=item * FullProtection: If the game session is in an ACTIVE status, it
cannot be terminated during a scale-down event.

=back


Valid values are: C<"NoProtection">, C<"FullProtection">

=head2 ServerLaunchParameters => Str

Parameters required to launch your game server. These parameters should
be expressed as a string of command-line parameters. Example: "+sv_port
33435 +start_lobby".



=head2 B<REQUIRED> ServerLaunchPath => Str

Path to the launch executable for the game server. A game server is
built into a C<C:\game> drive. This value must be expressed as
C<C:\game\[launchpath]>. Example: If, when built, your game server
files are in a folder called "MyGame", your log path should be
C<C:\game\MyGame\server.exe>.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method CreateFleet in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: https://github.com/pplu/aws-sdk-perl

Please report bugs to: https://github.com/pplu/aws-sdk-perl/issues

=cut

