package Locale::CLDR::Th v0.25.0;
# This file auto generated from Data\common\main\th.xml
#	on Tue 22 Apr 12:43:09 am GMT
# XML file generated 2014-02-28 23:57:43 -0600 (Fri, 28 Feb 2014)

use v5.18;
use mro 'c3';
use utf8;

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'อะฟาร์',
 				'ab' => 'อับคาซ',
 				'ace' => 'อาเจะห์',
 				'ach' => 'อาโคลิ',
 				'ada' => 'อาแดงมี',
 				'ady' => 'อะดืยเก',
 				'ae' => 'อเวสตะ',
 				'af' => 'แอฟริกานส์',
 				'afh' => 'แอฟริฮีลี',
 				'agq' => 'อักเฮม',
 				'ain' => 'ไอนุ',
 				'ak' => 'อาคัน',
 				'akk' => 'อักกาด',
 				'ale' => 'อาลิวต์',
 				'alt' => 'อัลไตใต้',
 				'am' => 'อัมฮารา',
 				'an' => 'อารากอน',
 				'ang' => 'อังกฤษโบราณ',
 				'anp' => 'อังคิกา',
 				'ar' => 'อาหรับ',
 				'ar_001' => 'อาหรับมาตรฐานสมัยใหม่',
 				'arc' => 'อราเมอิก',
 				'arn' => 'อาเราคาเนียน',
 				'arp' => 'อาราปาโฮ',
 				'arw' => 'อาราวัก',
 				'as' => 'อัสสัม',
 				'asa' => 'อาซู',
 				'ast' => 'อัสตูเรียส',
 				'av' => 'อาวาร์',
 				'awa' => 'อวธี',
 				'ay' => 'ไอย์มารา',
 				'az' => 'อาเซอร์ไบจาน',
 				'az@alt=short' => 'อะเซอรี',
 				'ba' => 'บัชคีร์',
 				'bal' => 'บาลูชิ',
 				'ban' => 'บาหลี',
 				'bas' => 'บาสา',
 				'bax' => 'บามัน',
 				'bbj' => 'โคมาลา',
 				'be' => 'เบลารุส',
 				'bej' => 'เบจา',
 				'bem' => 'เบมบา',
 				'bez' => 'เบนา',
 				'bfd' => 'บาฟัต',
 				'bg' => 'บัลแกเรีย',
 				'bho' => 'โภชปุรี',
 				'bi' => 'บิสลามา',
 				'bik' => 'บิกอล',
 				'bin' => 'บินี',
 				'bkm' => 'กม',
 				'bla' => 'สิกสิกา',
 				'bm' => 'บัมบารา',
 				'bn' => 'เบงกาลี',
 				'bo' => 'ทิเบต',
 				'br' => 'เบรตัน',
 				'bra' => 'พัรช',
 				'brx' => 'โพโฑ',
 				'bs' => 'บอสเนีย',
 				'bss' => 'อาโคซี',
 				'bua' => 'บูเรียต',
 				'bug' => 'บูกิส',
 				'bum' => 'บูลู',
 				'byn' => 'บลิน',
 				'byv' => 'เมดุมบา',
 				'ca' => 'กาตาลัง',
 				'cad' => 'คัดโด',
 				'car' => 'คาริบ',
 				'cay' => 'คายูกา',
 				'cch' => 'แอตแซม',
 				'ce' => 'เชเชน',
 				'ceb' => 'เซบู',
 				'cgg' => 'คีกา',
 				'ch' => 'ชามอร์โร',
 				'chb' => 'ชิบชา',
 				'chg' => 'ชะกะไต',
 				'chk' => 'ชูก',
 				'chm' => 'มารี',
 				'chn' => 'ชินุกจาร์กอน',
 				'cho' => 'ช็อกทอว์',
 				'chp' => 'ชิพิวยัน',
 				'chr' => 'เชอโรกี',
 				'chy' => 'เชเยนเน',
 				'ckb' => 'เคิร์ดโซรานี',
 				'co' => 'คอร์ซิกา',
 				'cop' => 'คอปติก',
 				'cr' => 'ครี',
 				'crh' => 'ตุรกีไครเมีย',
 				'cs' => 'เช็ก',
 				'csb' => 'คาซูเบียน',
 				'cu' => 'เชอร์ชสลาวิก',
 				'cv' => 'ชูวัช',
 				'cy' => 'เวลส์',
 				'da' => 'เดนมาร์ก',
 				'dak' => 'ดาโกทา',
 				'dar' => 'ดาร์กิน',
 				'dav' => 'ไททา',
 				'de' => 'เยอรมัน',
 				'de_AT' => 'เยอรมัน - ออสเตรีย',
 				'de_CH' => 'เยอรมันสูง (สวิส)',
 				'del' => 'เดลาแวร์',
 				'den' => 'สเลวี',
 				'dgr' => 'โดกริบ',
 				'din' => 'ดิงกา',
 				'dje' => 'ซาร์มา',
 				'doi' => 'โฑครี',
 				'dsb' => 'ซอร์บส์ตอนล่าง',
 				'dua' => 'ดัวลา',
 				'dum' => 'ดัตช์กลาง',
 				'dv' => 'ธิเวหิ',
 				'dyo' => 'โจลา-ฟอนยี',
 				'dyu' => 'ดิวลา',
 				'dz' => 'ซองคา',
 				'dzg' => 'ดาซากา',
 				'ebu' => 'เอ็มบู',
 				'ee' => 'เอเว',
 				'efi' => 'อีฟิก',
 				'egy' => 'อียิปต์โบราณ',
 				'eka' => 'อีกาจุก',
 				'el' => 'กรีก',
 				'elx' => 'อีลาไมต์',
 				'en' => 'อังกฤษ',
 				'en_AU' => 'อังกฤษ - ออสเตรเลีย',
 				'en_CA' => 'อังกฤษ - แคนาดา',
 				'en_GB' => 'อังกฤษ - สหราชอาณาจักร',
 				'en_GB@alt=short' => 'อังกฤษ - อังกฤษ',
 				'en_US' => 'อังกฤษ - อเมริกัน',
 				'en_US@alt=short' => 'อังกฤษ - อเมริกัน',
 				'enm' => 'อังกฤษกลาง',
 				'eo' => 'เอสเปอรันโต',
 				'es' => 'สเปน',
 				'es_ES' => 'สเปน (ยุโรป)',
 				'et' => 'เอสโตเนีย',
 				'eu' => 'บัสเก',
 				'ewo' => 'อีวันโด',
 				'fa' => 'เปอร์เซีย',
 				'fan' => 'ฟอง',
 				'fat' => 'ฟันติ',
 				'ff' => 'ฟูลาฮ์',
 				'fi' => 'ฟินแลนด์',
 				'fil' => 'ฟิลิปปินส์',
 				'fj' => 'ฟิจิ',
 				'fo' => 'แฟโร',
 				'fon' => 'ฟอน',
 				'fr' => 'ฝรั่งเศส',
 				'fr_CH' => 'ฝรั่งเศส (สวิส)',
 				'frm' => 'ฝรั่งเศสกลาง',
 				'fro' => 'ฝรั่งเศสโบราณ',
 				'frr' => 'ฟริเซียนเหนือ',
 				'frs' => 'ฟริเซียนตะวันออก',
 				'fur' => 'ฟรูลี',
 				'fy' => 'ฟริเซียนตะวันตก',
 				'ga' => 'ไอริช',
 				'gaa' => 'กา',
 				'gay' => 'กาโย',
 				'gba' => 'กบายา',
 				'gd' => 'สกอตส์กาลิก',
 				'gez' => 'กีซ',
 				'gil' => 'กิลเบอร์ต',
 				'gl' => 'กาลิเซีย',
 				'gmh' => 'เยอรมันสูงกลาง',
 				'gn' => 'กวารานี',
 				'goh' => 'เยอรมันสูงโบราณ',
 				'gon' => 'กอนดิ',
 				'gor' => 'กอรอนทาโล',
 				'got' => 'โกธิก',
 				'grb' => 'เกรโบ',
 				'grc' => 'กรีกโบราณ',
 				'gsw' => 'เยอรมันสวิส',
 				'gu' => 'คุชราต',
 				'guz' => 'กุซซี',
 				'gv' => 'มานซ์',
 				'gwi' => 'กวิชอิน',
 				'ha' => 'เฮาชา',
 				'hai' => 'ไฮดา',
 				'haw' => 'ฮาวาย',
 				'he' => 'ฮิบรู',
 				'hi' => 'ฮินดี',
 				'hil' => 'ฮีลีกัยนน',
 				'hit' => 'ฮิตไตต์',
 				'hmn' => 'ม้ง',
 				'ho' => 'ฮีรีโมตู',
 				'hr' => 'โครเอเชีย',
 				'hsb' => 'ซอร์บส์ตอนบน',
 				'ht' => 'เฮติ',
 				'hu' => 'ฮังการี',
 				'hup' => 'ฮูปา',
 				'hy' => 'อาร์เมเนีย',
 				'hz' => 'เฮเรโร',
 				'ia' => 'อินเตอร์ลิงกัว',
 				'iba' => 'อิบาน',
 				'ibb' => 'อิบิบิโอ',
 				'id' => 'อินโดนีเชีย',
 				'ie' => 'อินเตอร์ลิงกิว',
 				'ig' => 'อิกโบ',
 				'ii' => 'เสฉวนยิ',
 				'ik' => 'อีนูเปียก',
 				'ilo' => 'อีโลโก',
 				'inh' => 'อินกุช',
 				'io' => 'อีโด',
 				'is' => 'ไอซ์แลนด์',
 				'it' => 'อิตาลี',
 				'iu' => 'อินุกติตุต',
 				'ja' => 'ญี่ปุ่น',
 				'jbo' => 'โลชบัน',
 				'jgo' => 'อึนกอมบา',
 				'jmc' => 'มาชาเม',
 				'jpr' => 'ยิว-เปอร์เซีย',
 				'jrb' => 'ยิว-อาหรับ',
 				'jv' => 'ชวา',
 				'ka' => 'จอร์เจีย',
 				'kaa' => 'การา-กาลพาก',
 				'kab' => 'กาไบล',
 				'kac' => 'กะฉิ่น',
 				'kaj' => 'คจู',
 				'kam' => 'คัมบา',
 				'kaw' => 'กวี',
 				'kbd' => 'คาร์บาเดีย',
 				'kbl' => 'คาเนมบู',
 				'kcg' => 'ทีแยป',
 				'kde' => 'มาคอนเด',
 				'kea' => 'คาบูเวอร์เดียนู',
 				'kfo' => 'โคโร',
 				'kg' => 'คองโก',
 				'kha' => 'กาสี',
 				'kho' => 'โคตัน',
 				'khq' => 'โคย์ราชีนี',
 				'ki' => 'กีกูยู',
 				'kj' => 'กวนยามา',
 				'kk' => 'คาซัค',
 				'kkj' => 'คาโก',
 				'kl' => 'กรีนแลนด์',
 				'kln' => 'คาเลนจิน',
 				'km' => 'เขมร',
 				'kmb' => 'คิมบุนดู',
 				'kn' => 'กันนาดา',
 				'ko' => 'เกาหลี',
 				'kok' => 'กอนกานี',
 				'kos' => 'คูสไร',
 				'kpe' => 'กาแปล',
 				'kr' => 'คานูรี',
 				'krc' => 'คาราไช-บัลคาร์',
 				'krl' => 'แกรเลียน',
 				'kru' => 'กุรุข',
 				'ks' => 'กัศมีร์',
 				'ksb' => 'ชัมบาลา',
 				'ksf' => 'บาเฟีย',
 				'ksh' => 'โคโลญ',
 				'ku' => 'เคิร์ด',
 				'kum' => 'คูมืยค์',
 				'kut' => 'คูเทไน',
 				'kv' => 'โกมิ',
 				'kw' => 'คอร์นิช',
 				'ky' => 'คีร์กีซ',
 				'la' => 'ละติน',
 				'lad' => 'ลาดิโน',
 				'lag' => 'แลนจี',
 				'lah' => 'ลาฮ์นดา',
 				'lam' => 'แลมบา',
 				'lb' => 'ลักเซมเบิร์ก',
 				'lez' => 'เลซเกียน',
 				'lg' => 'ยูกันดา',
 				'li' => 'ลิมเบิร์ก',
 				'ln' => 'ลิงกาลา',
 				'lo' => 'ลาว',
 				'lol' => 'มองโก',
 				'loz' => 'โลซิ',
 				'lt' => 'ลิทัวเนีย',
 				'lu' => 'ลูบา-กาตองกา',
 				'lua' => 'ลูบา-ลูลัว',
 				'lui' => 'ลุยเซโน',
 				'lun' => 'ลันดา',
 				'luo' => 'ลัว',
 				'lus' => 'ลูไช',
 				'luy' => 'ลูเยีย',
 				'lv' => 'ลัตเวีย',
 				'mad' => 'มาดูรา',
 				'maf' => 'มาฟา',
 				'mag' => 'มคหี',
 				'mai' => 'ไมถิลี',
 				'mak' => 'มากาซาร์',
 				'man' => 'มันดิงกา',
 				'mas' => 'มาไซ',
 				'mde' => 'มาบา',
 				'mdf' => 'มอคชา',
 				'mdr' => 'มานดาร์',
 				'men' => 'เมนเด',
 				'mer' => 'เมรู',
 				'mfe' => 'มอริสเยน',
 				'mg' => 'มาลากาซี',
 				'mga' => 'ไอริชกลาง',
 				'mgh' => 'มากัววา-มีทโท',
 				'mgo' => 'เมตา',
 				'mh' => 'มาร์แชลลิส',
 				'mi' => 'เมารี',
 				'mic' => 'มิกแมก',
 				'min' => 'มีนังกาเบา',
 				'mk' => 'มาซิโดเนีย',
 				'ml' => 'มาลายาลัม',
 				'mn' => 'มองโกเลีย',
 				'mnc' => 'แมนจู',
 				'mni' => 'มณีปุระ',
 				'moh' => 'โมฮอว์ก',
 				'mos' => 'โมซี',
 				'mr' => 'มราฐี',
 				'ms' => 'มาเลย์',
 				'mt' => 'มอลตา',
 				'mua' => 'มันดัง',
 				'mul' => 'หลายภาษา',
 				'mus' => 'ครีก',
 				'mwl' => 'มีรันดา',
 				'mwr' => 'มารวาฑี',
 				'my' => 'พม่า',
 				'mye' => 'มยีน',
 				'myv' => 'เอียร์ซยา',
 				'na' => 'นาอูรู',
 				'nap' => 'นาโปลี',
 				'naq' => 'นามา',
 				'nb' => 'นอร์เวย์บุคมอล',
 				'nd' => 'เอ็นเดเบเลเหนือ',
 				'nds' => 'เยอรมันต่ำ - แซกซอนต่ำ',
 				'ne' => 'เนปาล',
 				'new' => 'เนวาร์',
 				'ng' => 'ดองกา',
 				'nia' => 'นีอัส',
 				'niu' => 'นีอู',
 				'nl' => 'ดัตช์',
 				'nl_BE' => 'เฟลมิช',
 				'nmg' => 'กวาซิโอ',
 				'nn' => 'นอร์เวย์นีนอสก์',
 				'nnh' => 'จีมบูน',
 				'no' => 'นอร์เวย์',
 				'nog' => 'โนไก',
 				'non' => 'นอร์สโบราณ',
 				'nqo' => 'เอ็นโก',
 				'nr' => 'เอ็นเดเบเลใต้',
 				'nso' => 'โซโทเหนือ',
 				'nus' => 'เนือร์',
 				'nv' => 'นาวาโฮ',
 				'nwc' => 'เนวาร์ดั้งเดิม',
 				'ny' => 'เนียนจา',
 				'nym' => 'เนียมเวซี',
 				'nyn' => 'เนียนโกเล',
 				'nyo' => 'นิโอโร',
 				'nzi' => 'นซิมา',
 				'oc' => 'อ็อกซิตัน',
 				'oj' => 'โอจิบวา',
 				'om' => 'โอโรโม',
 				'or' => 'โอริยา',
 				'os' => 'ออสเซเตีย',
 				'osa' => 'โอซากี',
 				'ota' => 'ตุรกีออตโตมัน',
 				'pa' => 'ปัญจาบ',
 				'pag' => 'ปางาซีนัน',
 				'pal' => 'ปะห์ลาวี',
 				'pam' => 'ปัมปางา',
 				'pap' => 'ปาเปียเมนโต',
 				'pau' => 'ปาเลา',
 				'peo' => 'เปอร์เซียโบราณ',
 				'phn' => 'ฟินิเชีย',
 				'pi' => 'บาลี',
 				'pl' => 'โปแลนด์',
 				'pon' => 'พอห์นเพ',
 				'pro' => 'โปรวองซาลโบราณ',
 				'ps' => 'พาชตู',
 				'ps@alt=variant' => 'พุชโต',
 				'pt' => 'โปรตุเกส',
 				'pt_BR' => 'โปรตุเกส - บราซิล',
 				'pt_PT' => 'โปรตุเกส​ (ยุโรป)',
 				'qu' => 'ควิชัว',
 				'raj' => 'ราชสถาน',
 				'rap' => 'ราปานู',
 				'rar' => 'ราโรทองกา',
 				'rm' => 'โรแมนซ์',
 				'rn' => 'บุรุนดี',
 				'ro' => 'โรมาเนีย',
 				'ro_MD' => 'มอลโดวา',
 				'rof' => 'รอมโบ',
 				'rom' => 'โรมานี',
 				'root' => 'รูท',
 				'ru' => 'รัสเซีย',
 				'rup' => 'อาโรมาเนียน',
 				'rw' => 'รวันดา',
 				'rwk' => 'รวา',
 				'sa' => 'สันสกฤต',
 				'sad' => 'ซันดาเว',
 				'sah' => 'ซาฮา',
 				'sam' => 'อราเมอิกซามาเรีย',
 				'saq' => 'แซมบูรู',
 				'sas' => 'ซาซัก',
 				'sat' => 'สันตาลี',
 				'sba' => 'กัมเบ',
 				'sbp' => 'แซงกู',
 				'sc' => 'ซาร์เดญา',
 				'scn' => 'ซิซิลี',
 				'sco' => 'สกอตส์',
 				'sd' => 'สินธุ',
 				'se' => 'ซามิเหนือ',
 				'see' => 'เซนิกา',
 				'seh' => 'เซนา',
 				'sel' => 'เซลคุป',
 				'ses' => 'โคย์ราโบโรเซนนี',
 				'sg' => 'แซงโก',
 				'sga' => 'ไอริชโบราณ',
 				'sh' => 'เซอร์โบ-โครเอเชีย',
 				'shi' => 'ทาเชลีห์ท',
 				'shn' => 'ไทใหญ่',
 				'shu' => 'อาหรับ-ชาด',
 				'si' => 'สิงหล',
 				'sid' => 'ซิดาโม',
 				'sk' => 'สโลวัก',
 				'sl' => 'สโลวีเนีย',
 				'sm' => 'ซามัว',
 				'sma' => 'ซามิใต้',
 				'smj' => 'ซามิลูเล',
 				'smn' => 'ซามิอีนารี',
 				'sms' => 'ซามิสคอลต์',
 				'sn' => 'โชนา',
 				'snk' => 'โซนีนเก',
 				'so' => 'โซมาลี',
 				'sog' => 'ซอกดีน',
 				'sq' => 'แอลเบเนีย',
 				'sr' => 'เซอร์เบีย',
 				'srn' => 'ซูรินาเม',
 				'srr' => 'เซแรร์',
 				'ss' => 'สวาติ',
 				'ssy' => 'ซาโฮ',
 				'st' => 'โซโทใต้',
 				'su' => 'ซุนดา',
 				'suk' => 'ซูคูมา',
 				'sus' => 'ซูซู',
 				'sux' => 'ซูเมอ',
 				'sv' => 'สวีเดน',
 				'sw' => 'สวาฮีลี',
 				'swb' => 'โคเมอเรียน',
 				'swc' => 'สวาฮีลี-คองโก',
 				'syc' => 'ซีเรียแบบดั้งเดิม',
 				'syr' => 'ซีเรีย',
 				'ta' => 'ทมิฬ',
 				'te' => 'เตลูกู',
 				'tem' => 'ทิมเน',
 				'teo' => 'เตโซ',
 				'ter' => 'เทเรโน',
 				'tet' => 'เตตุม',
 				'tg' => 'ทาจิก',
 				'th' => 'ไทย',
 				'ti' => 'ติกริญญา',
 				'tig' => 'ตีเกร',
 				'tiv' => 'ทิฟ',
 				'tk' => 'เติร์กเมนิสถาน',
 				'tkl' => 'โตเกเลา',
 				'tl' => 'ตากาล็อก',
 				'tlh' => 'คลิงกอน',
 				'tli' => 'ทลิงกิต',
 				'tmh' => 'ทามาเชก',
 				'tn' => 'บอตสวานา',
 				'to' => 'ตองกา',
 				'tog' => 'ไนอะซาตองกา',
 				'tpi' => 'ท็อกพิซิน',
 				'tr' => 'ตุรกี',
 				'trv' => 'ทาโรโก',
 				'ts' => 'ซิิตซองกา',
 				'tsi' => 'ซิมชีแอน',
 				'tt' => 'ตาตาร์',
 				'tum' => 'ทุมบูกา',
 				'tvl' => 'ตูวาลู',
 				'tw' => 'ทวิ',
 				'twq' => 'ตัสซาวัค',
 				'ty' => 'ตาฮิตี',
 				'tyv' => 'ตูวา',
 				'tzm' => 'เบอร์เบอร์-โมร็อกโกกลาง',
 				'udm' => 'อุดมูร์ต',
 				'ug' => 'อุยกัว',
 				'ug@alt=variant' => 'อุยกูร์',
 				'uga' => 'ยูการิต',
 				'uk' => 'ยูเครน',
 				'umb' => 'อุมบุนดู',
 				'und' => 'ภาษาที่ไม่รู้จัก',
 				'ur' => 'อูรดู',
 				'uz' => 'อุซเบก',
 				'vai' => 'ไว',
 				've' => 'เวนดา',
 				'vi' => 'เวียดนาม',
 				'vo' => 'โวลาพึค',
 				'vot' => 'โวทิก',
 				'vun' => 'วุนจู',
 				'wa' => 'วาโลนี',
 				'wae' => 'วัลเซอร์',
 				'wal' => 'วาลาโม',
 				'war' => 'วาเรย์',
 				'was' => 'วาโช',
 				'wo' => 'โวลอฟ',
 				'xal' => 'คัลมืยค์',
 				'xh' => 'คะห์โอซา',
 				'xog' => 'โซกา',
 				'yao' => 'เย้า',
 				'yap' => 'ยัป',
 				'yav' => 'แยงเบน',
 				'ybb' => 'เยมบา',
 				'yi' => 'ยิว',
 				'yo' => 'โยรูบา',
 				'yue' => 'กวางตุ้ง',
 				'za' => 'จ้วง',
 				'zap' => 'ซาโปเตก',
 				'zbl' => 'บลิสซิมโบลส์',
 				'zen' => 'เซนากา',
 				'zgh' => 'ทามาไซต์โมร็อกโกมาตรฐาน',
 				'zh' => 'จีน',
 				'zh_Hans' => 'จีนตัวย่อ',
 				'zh_Hant' => 'จีนตัวเต็ม',
 				'zu' => 'ซูลู',
 				'zun' => 'ซูนิ',
 				'zxx' => 'ไม่มีข้อมูลภาษา',
 				'zza' => 'ซาซา',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Afak' => 'อะฟาคา',
 			'Arab' => 'อาหรับ',
 			'Arab@alt=variant' => 'เปอร์เซีย-อาหรับ',
 			'Armi' => 'อิมพีเรียล อราเมอิก',
 			'Armn' => 'อาร์เมเนีย',
 			'Avst' => 'อเวสตะ',
 			'Bali' => 'บาหลี',
 			'Bamu' => 'บามุม',
 			'Bass' => 'บัสซา',
 			'Batk' => 'บาตัก',
 			'Beng' => 'เบงกาลี',
 			'Blis' => 'บลิสซิมโบลส์',
 			'Bopo' => 'ปอพอมอฟอ',
 			'Brah' => 'พราหมี',
 			'Brai' => 'เบรลล์',
 			'Bugi' => 'บูกิส',
 			'Buhd' => 'บูฮิด',
 			'Cakm' => 'ชากมา',
 			'Cans' => 'สัญลักษณ์ชนเผ่าพื้นเมืองแคนาดา',
 			'Cari' => 'คาเรีย',
 			'Cham' => 'จาม',
 			'Cher' => 'เชอโรกี',
 			'Cirt' => 'เซิร์ท',
 			'Copt' => 'คอปติก',
 			'Cprt' => 'ไซเปรียท',
 			'Cyrl' => 'ซีริลลิก',
 			'Cyrs' => 'เชอร์ชสลาโวนิกซีริลลิกโบราณ',
 			'Deva' => 'เทวนาครี',
 			'Dsrt' => 'เดเซเรท',
 			'Dupl' => 'ชวเลขดัปโลยัน',
 			'Egyd' => 'ดีโมติกอียิปต์',
 			'Egyh' => 'เฮียราติกอียิปต์',
 			'Egyp' => 'เฮียโรกลิฟส์อียิปต์',
 			'Ethi' => 'เอทิโอปิก',
 			'Geok' => 'คัตซูรีจอร์เจีย',
 			'Geor' => 'จอร์เจีย',
 			'Glag' => 'กลาโกลิติก',
 			'Goth' => 'โกธิก',
 			'Gran' => 'คฤณห์',
 			'Grek' => 'กรีก',
 			'Gujr' => 'คุชราต',
 			'Guru' => 'กูร์มูคี',
 			'Hang' => 'ฮันกูล',
 			'Hani' => 'ฮั่น',
 			'Hano' => 'ฮานูโนโอ',
 			'Hans' => 'ตัวย่อ',
 			'Hans@alt=stand-alone' => 'ฮั่นตัวย่อ',
 			'Hant' => 'ตัวเต็ม',
 			'Hant@alt=stand-alone' => 'ฮั่นตัวเต็ม',
 			'Hebr' => 'ฮีบรู',
 			'Hira' => 'ฮิระงะนะ',
 			'Hluw' => 'อักขระอานาโตเลีย',
 			'Hmng' => 'ปาเฮาห์ม้ง',
 			'Hrkt' => 'คะตะกะนะหรือฮิระงะนะ',
 			'Hung' => 'ฮังการีโบราณ',
 			'Inds' => 'อินดัส',
 			'Ital' => 'อิตาลีโบราณ',
 			'Java' => 'ชวา',
 			'Jpan' => 'ญี่ปุ่น',
 			'Jurc' => 'จูร์เชน',
 			'Kali' => 'คยาห์',
 			'Kana' => 'คะตะกะนะ',
 			'Khar' => 'ขโรษฐี',
 			'Khmr' => 'เขมร',
 			'Khoj' => 'คอจคี',
 			'Knda' => 'กันนาดา',
 			'Kore' => 'เกาหลี',
 			'Kpel' => 'เปลเล',
 			'Kthi' => 'กายติ',
 			'Lana' => 'ล้านนา',
 			'Laoo' => 'ลาว',
 			'Latf' => 'ลาติน - ฟรังเตอร์',
 			'Latg' => 'ลาติน - แกลิก',
 			'Latn' => 'ละติน',
 			'Lepc' => 'เลปชา',
 			'Limb' => 'ลิมบู',
 			'Lina' => 'ลีเนียร์เอ',
 			'Linb' => 'ลีเนียร์บี',
 			'Lisu' => 'เฟรเซอร์',
 			'Loma' => 'โลมา',
 			'Lyci' => 'ไลเซีย',
 			'Lydi' => 'ลีเดีย',
 			'Mand' => 'แมนเดียน',
 			'Mani' => 'มานิแชน',
 			'Maya' => 'มายาไฮโรกลิฟส์',
 			'Mend' => 'เมนเด',
 			'Merc' => 'เคอร์ซีฟ-เมโรอิติก',
 			'Mero' => 'เมโรติก',
 			'Mlym' => 'มาลายาลัม',
 			'Mong' => 'มองโกเลีย',
 			'Moon' => 'มูน',
 			'Mroo' => 'มโร',
 			'Mtei' => 'เมเทมาเยก',
 			'Mymr' => 'พม่า',
 			'Narb' => 'อาระเบียเหนือโบราณ',
 			'Nbat' => 'นาบาทาเอียน',
 			'Nkgb' => 'กีบา-นาซี',
 			'Nkoo' => 'เอ็นโก',
 			'Nshu' => 'นุซุ',
 			'Ogam' => 'โอคัม',
 			'Olck' => 'โอลชิกิ',
 			'Orkh' => 'ออร์คอน',
 			'Orya' => 'โอริยา',
 			'Osma' => 'ออสมันยา',
 			'Palm' => 'พาลไมรีน',
 			'Perm' => 'เปอร์มิกโบราณ',
 			'Phag' => 'ฟากส์-ปา',
 			'Phli' => 'ปะห์ลาวีอินสคริปชันแนล',
 			'Phlp' => 'ปะห์ลาวีซอลเตอร์',
 			'Phlv' => 'ปะห์ลาวีบุ๊ก',
 			'Phnx' => 'ฟินิเชีย',
 			'Plrd' => 'สัทศาสตร์พอลลาร์ด',
 			'Prti' => 'พาร์เทียอินสคริปชันแนล',
 			'Rjng' => 'เรจัง',
 			'Roro' => 'รองโกรองโก',
 			'Runr' => 'รูนิก',
 			'Samr' => 'ซามาเรีย',
 			'Sara' => 'ซาราติ',
 			'Sarb' => 'อาระเบียใต้โบราณ',
 			'Saur' => 'โสวรัสตระ',
 			'Sgnw' => 'ไซน์ไรติ้ง',
 			'Shaw' => 'ซอเวียน',
 			'Shrd' => 'ชาราดา',
 			'Sind' => 'คุดาวาดี',
 			'Sinh' => 'สิงหล',
 			'Sora' => 'โสราสมเป็ง',
 			'Sund' => 'ซุนดา',
 			'Sylo' => 'ซิโลตินากรี',
 			'Syrc' => 'ซีเรีย',
 			'Syre' => 'ซีเรียเอสทรานจีโล',
 			'Syrj' => 'ซีเรียตะวันตก',
 			'Syrn' => 'ซีเรียตะวันออก',
 			'Tagb' => 'ตักบันวา',
 			'Takr' => 'ทาครี',
 			'Tale' => 'ไทเล',
 			'Talu' => 'ไทลื้อใหม่',
 			'Taml' => 'ทมิฬ',
 			'Tang' => 'ตันกัท',
 			'Tavt' => 'ไทเวียต',
 			'Telu' => 'เทลูกู',
 			'Teng' => 'เทงกวาร์',
 			'Tfng' => 'ทิฟินาก',
 			'Tglg' => 'ตากาล็อก',
 			'Thaa' => 'ทานา',
 			'Thai' => 'ไทย',
 			'Tibt' => 'ทิเบต',
 			'Tirh' => 'เทอฮุทา',
 			'Ugar' => 'ยูการิต',
 			'Vaii' => 'ไว',
 			'Visp' => 'คำพูดที่มองเห็นได้',
 			'Wara' => 'วารังกสิติ',
 			'Wole' => 'โอลีเอ',
 			'Xpeo' => 'เปอร์เซียโบราณ',
 			'Xsux' => 'อักษรรูปลิ่มสุเมเรีย-อัคคาเดีย',
 			'Yiii' => 'ยิ',
 			'Zinh' => 'อินเฮอริต',
 			'Zmth' => 'เครื่องหมายทางคณิตศาสตร์',
 			'Zsym' => 'ซิมโบลส์',
 			'Zxxx' => 'ไม่มีภาษาเขียน',
 			'Zyyy' => 'สามัญ',
 			'Zzzz' => 'สคริปต์ที่ไม่รู้จัก',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'โลก',
 			'002' => 'แอฟริกา',
 			'003' => 'อเมริกาเหนือ',
 			'005' => 'อเมริกาใต้',
 			'009' => 'โอเชียเนีย',
 			'011' => 'แอฟริกาตะวันตก',
 			'013' => 'อเมริกากลาง',
 			'014' => 'แอฟริกาตะวันออก',
 			'015' => 'แอฟริกาเหนือ',
 			'017' => 'แอฟริกากลาง',
 			'018' => 'แอฟริกาตอนใต้',
 			'019' => 'อเมริกา',
 			'021' => 'อเมริกาตอนเหนือ',
 			'029' => 'แคริบเบียน',
 			'030' => 'เอเชียตะวันออก',
 			'034' => 'เอเชียใต้',
 			'035' => 'เอเชียตะวันออกเฉียงใต้',
 			'039' => 'ยุโรปใต้',
 			'053' => 'ออสตราเลเซีย',
 			'054' => 'เมลานีเซีย',
 			'057' => 'เขตไมโครนีเซีย',
 			'061' => 'โปลินีเซีย',
 			'142' => 'เอเชีย',
 			'143' => 'เอเชียกลาง',
 			'145' => 'เอเชียตะวันตก',
 			'150' => 'ยุโรป',
 			'151' => 'ยุโรปตะวันออก',
 			'154' => 'ยุโรปเหนือ',
 			'155' => 'ยุโรปตะวันตก',
 			'419' => 'ละตินอเมริกา',
 			'AC' => 'เกาะแอสเซนชัน',
 			'AD' => 'อันดอร์รา',
 			'AE' => 'สหรัฐอาหรับเอมิเรตส์',
 			'AF' => 'อัฟกานิสถาน',
 			'AG' => 'แอนติกาและบาร์บูดา',
 			'AI' => 'แองกวิลลา',
 			'AL' => 'แอลเบเนีย',
 			'AM' => 'อาร์เมเนีย',
 			'AN' => 'เนเธอร์แลนด์แอนทิลลิส',
 			'AO' => 'แองโกลา',
 			'AQ' => 'แอนตาร์กติกา',
 			'AR' => 'อาร์เจนตินา',
 			'AS' => 'อเมริกันซามัว',
 			'AT' => 'ออสเตรีย',
 			'AU' => 'ออสเตรเลีย',
 			'AW' => 'อารูบา',
 			'AX' => 'หมู่เกาะโอลันด์',
 			'AZ' => 'อาเซอร์ไบจาน',
 			'BA' => 'บอสเนียและเฮอร์เซโกวีนา',
 			'BB' => 'บาร์เบโดส',
 			'BD' => 'บังกลาเทศ',
 			'BE' => 'เบลเยียม',
 			'BF' => 'บูร์กินาฟาโซ',
 			'BG' => 'บัลแกเรีย',
 			'BH' => 'บาห์เรน',
 			'BI' => 'บุรุนดี',
 			'BJ' => 'เบนิน',
 			'BL' => 'เซนต์บาร์เธเลมี',
 			'BM' => 'เบอร์มิวดา',
 			'BN' => 'บรูไน',
 			'BO' => 'โบลิเวีย',
 			'BQ' => 'เนเธอร์แลนด์แคริบเบียน',
 			'BR' => 'บราซิล',
 			'BS' => 'บาฮามาส',
 			'BT' => 'ภูฏาน',
 			'BV' => 'เกาะบูเวต',
 			'BW' => 'บอตสวานา',
 			'BY' => 'เบลารุส',
 			'BZ' => 'เบลีซ',
 			'CA' => 'แคนาดา',
 			'CC' => 'หมู่เกาะโคโคส',
 			'CD' => 'คองโก-กินชาซา',
 			'CD@alt=variant' => 'คองโก (สาธารณรัฐประชาธิปไตย)',
 			'CF' => 'สาธารณรัฐแอฟริกากลาง',
 			'CG' => 'คองโก-บราซซาวิล',
 			'CG@alt=variant' => 'คองโก (สาธารณรัฐ)',
 			'CH' => 'สวิตเซอร์แลนด์',
 			'CI' => 'ไอวอรี่โคสต์',
 			'CK' => 'หมู่เกาะคุก',
 			'CL' => 'ชิลี',
 			'CM' => 'แคเมอรูน',
 			'CN' => 'จีน',
 			'CO' => 'โคลอมเบีย',
 			'CP' => 'เกาะคลิปเปอร์ตัน',
 			'CR' => 'คอสตาริกา',
 			'CU' => 'คิวบา',
 			'CV' => 'เคปเวิร์ด',
 			'CW' => 'คูราเซา',
 			'CX' => 'เกาะคริสต์มาส',
 			'CY' => 'ไซปรัส',
 			'CZ' => 'สาธารณรัฐเช็ก',
 			'DE' => 'เยอรมนี',
 			'DG' => 'ดิเอโกการ์เซีย',
 			'DJ' => 'จิบูตี',
 			'DK' => 'เดนมาร์ก',
 			'DM' => 'โดมินิกา',
 			'DO' => 'สาธารณรัฐโดมินิกัน',
 			'DZ' => 'แอลจีเรีย',
 			'EA' => 'ซีโอตาและเมลิลลา',
 			'EC' => 'เอกวาดอร์',
 			'EE' => 'เอสโตเนีย',
 			'EG' => 'อียิปต์',
 			'EH' => 'ซาฮาราตะวันตก',
 			'ER' => 'เอริเทรีย',
 			'ES' => 'สเปน',
 			'ET' => 'เอธิโอเปีย',
 			'EU' => 'สหภาพยุโรป',
 			'FI' => 'ฟินแลนด์',
 			'FJ' => 'ฟิจิ',
 			'FK' => 'หมู่เกาะฟอล์กแลนด์',
 			'FK@alt=variant' => 'หมู่เกาะฟอล์กแลนด์ (อิสลาส มาลวินาส)',
 			'FM' => 'ไมโครนีเซีย',
 			'FO' => 'หมู่เกาะแฟโร',
 			'FR' => 'ฝรั่งเศส',
 			'GA' => 'กาบอง',
 			'GB' => 'สหราชอาณาจักร',
 			'GB@alt=short' => 'อังกฤษ',
 			'GD' => 'เกรเนดา',
 			'GE' => 'จอร์เจีย',
 			'GF' => 'เฟรนช์เกียนา',
 			'GG' => 'เกิร์นซีย์',
 			'GH' => 'กานา',
 			'GI' => 'ยิบรอลตาร์',
 			'GL' => 'กรีนแลนด์',
 			'GM' => 'แกมเบีย',
 			'GN' => 'กินี',
 			'GP' => 'กวาเดอลูป',
 			'GQ' => 'อิเควทอเรียลกินี',
 			'GR' => 'กรีซ',
 			'GS' => 'เกาะเซาท์จอร์เจียและหมู่เกาะเซาท์แซนด์วิช',
 			'GT' => 'กัวเตมาลา',
 			'GU' => 'กวม',
 			'GW' => 'กินี-บิสเซา',
 			'GY' => 'กายอานา',
 			'HK' => 'เขตปกครองพิเศษฮ่องกงแห่งสาธารณรัฐประชาชนจีน',
 			'HK@alt=short' => 'ฮ่องกง',
 			'HM' => 'เกาะเฮิร์ดและหมู่เกาะแมกดอนัลด์',
 			'HN' => 'ฮอนดูรัส',
 			'HR' => 'โครเอเชีย',
 			'HT' => 'เฮติ',
 			'HU' => 'ฮังการี',
 			'IC' => 'หมู่เกาะคานารี',
 			'ID' => 'อินโดนีเซีย',
 			'IE' => 'ไอร์แลนด์',
 			'IL' => 'อิสราเอล',
 			'IM' => 'เกาะแมน',
 			'IN' => 'อินเดีย',
 			'IO' => 'บริติชอินเดียนโอเชียนเทร์ริทอรี',
 			'IQ' => 'อิรัก',
 			'IR' => 'อิหร่าน',
 			'IS' => 'ไอซ์แลนด์',
 			'IT' => 'อิตาลี',
 			'JE' => 'เจอร์ซีย์',
 			'JM' => 'จาเมกา',
 			'JO' => 'จอร์แดน',
 			'JP' => 'ญี่ปุ่น',
 			'KE' => 'เคนยา',
 			'KG' => 'คีร์กีซสถาน',
 			'KH' => 'กัมพูชา',
 			'KI' => 'คิริบาส',
 			'KM' => 'คอโมโรส',
 			'KN' => 'เซนต์คิตส์และเนวิส',
 			'KP' => 'เกาหลีเหนือ',
 			'KR' => 'เกาหลีใต้',
 			'KW' => 'คูเวต',
 			'KY' => 'หมู่เกาะเคย์แมน',
 			'KZ' => 'คาซัคสถาน',
 			'LA' => 'ลาว',
 			'LB' => 'เลบานอน',
 			'LC' => 'เซนต์ลูเซีย',
 			'LI' => 'ลิกเตนสไตน์',
 			'LK' => 'ศรีลังกา',
 			'LR' => 'ไลบีเรีย',
 			'LS' => 'เลโซโท',
 			'LT' => 'ลิทัวเนีย',
 			'LU' => 'ลักเซมเบิร์ก',
 			'LV' => 'ลัตเวีย',
 			'LY' => 'ลิเบีย',
 			'MA' => 'โมร็อกโก',
 			'MC' => 'โมนาโก',
 			'MD' => 'มอลโดวา',
 			'ME' => 'มอนเตเนโกร',
 			'MF' => 'เซนต์มาติน',
 			'MG' => 'มาดากัสการ์',
 			'MH' => 'หมู่เกาะมาร์แชลล์',
 			'MK' => 'มาซิโดเนีย',
 			'ML' => 'มาลี',
 			'MM' => 'เมียนม่าร์ (พม่า)',
 			'MN' => 'มองโกเลีย',
 			'MO' => 'เขตปกครองพิเศษมาเก๊าแห่งสาธารณรัฐประชาชนจีน',
 			'MO@alt=short' => 'มาเก๊า',
 			'MP' => 'หมู่เกาะนอร์เทิร์นมาเรียนา',
 			'MQ' => 'มาร์ตินีก',
 			'MR' => 'มอริเตเนีย',
 			'MS' => 'มอนต์เซอร์รัต',
 			'MT' => 'มอลตา',
 			'MU' => 'มอริเชียส',
 			'MV' => 'มัลดีฟส์',
 			'MW' => 'มาลาวี',
 			'MX' => 'เม็กซิโก',
 			'MY' => 'มาเลเซีย',
 			'MZ' => 'โมซัมบิก',
 			'NA' => 'นามิเบีย',
 			'NC' => 'นิวแคลิโดเนีย',
 			'NE' => 'ไนเจอร์',
 			'NF' => 'เกาะนอร์ฟอล์ก',
 			'NG' => 'ไนจีเรีย',
 			'NI' => 'นิการากัว',
 			'NL' => 'เนเธอร์แลนด์',
 			'NO' => 'นอร์เวย์',
 			'NP' => 'เนปาล',
 			'NR' => 'นาอูรู',
 			'NU' => 'นีอูเอ',
 			'NZ' => 'นิวซีแลนด์',
 			'OM' => 'โอมาน',
 			'PA' => 'ปานามา',
 			'PE' => 'เปรู',
 			'PF' => 'เฟรนช์โปลินีเซีย',
 			'PG' => 'ปาปัวนิวกินี',
 			'PH' => 'ฟิลิปปินส์',
 			'PK' => 'ปากีสถาน',
 			'PL' => 'โปแลนด์',
 			'PM' => 'แซงปีแยร์และมีเกอลง',
 			'PN' => 'หมู่เกาะพิตแคร์น',
 			'PR' => 'เปอร์โตริโก',
 			'PS' => 'ดินแดนปาเลสไตน์',
 			'PS@alt=short' => 'ปาเลสไตน์',
 			'PT' => 'โปรตุเกส',
 			'PW' => 'ปาเลา',
 			'PY' => 'ปารากวัย',
 			'QA' => 'กาตาร์',
 			'QO' => 'เอาต์ไลอิงโอเชียเนีย',
 			'RE' => 'เรอูนียง',
 			'RO' => 'โรมาเนีย',
 			'RS' => 'เซอร์เบีย',
 			'RU' => 'รัสเซีย',
 			'RW' => 'รวันดา',
 			'SA' => 'ซาอุดีอาระเบีย',
 			'SB' => 'หมู่เกาะโซโลมอน',
 			'SC' => 'เซเชลส์',
 			'SD' => 'ซูดาน',
 			'SE' => 'สวีเดน',
 			'SG' => 'สิงคโปร์',
 			'SH' => 'เซนต์เฮเลนา',
 			'SI' => 'สโลวีเนีย',
 			'SJ' => 'สฟาลบาร์และยานไมเอน',
 			'SK' => 'สโลวะเกีย',
 			'SL' => 'เซียร์ราลีโอน',
 			'SM' => 'ซานมารีโน',
 			'SN' => 'เซเนกัล',
 			'SO' => 'โซมาเลีย',
 			'SR' => 'ซูรินาเม',
 			'SS' => 'ซูดานใต้',
 			'ST' => 'เซาตูเมและปรินซิปี',
 			'SV' => 'เอลซัลวาดอร์',
 			'SX' => 'เซนต์มาร์ติน',
 			'SY' => 'ซีเรีย',
 			'SZ' => 'สวาซิแลนด์',
 			'TA' => 'ทริสตัน เดอ คูนา',
 			'TC' => 'หมู่เกาะเติกส์และหมู่เกาะเคคอส',
 			'TD' => 'ชาด',
 			'TF' => 'เฟรนช์เซาเทิร์นเทร์ริทอรีส์',
 			'TG' => 'โตโก',
 			'TH' => 'ไทย',
 			'TJ' => 'ทาจิกิสถาน',
 			'TK' => 'โตเกเลา',
 			'TL' => 'ติมอร์-เลสเต',
 			'TL@alt=variant' => 'ติมอร์ตะวันออก',
 			'TM' => 'เติร์กเมนิสถาน',
 			'TN' => 'ตูนิเซีย',
 			'TO' => 'ตองกา',
 			'TR' => 'ตุรกี',
 			'TT' => 'ตรินิแดดและโตเบโก',
 			'TV' => 'ตูวาลู',
 			'TW' => 'ไต้หวัน',
 			'TZ' => 'แทนซาเนีย',
 			'UA' => 'ยูเครน',
 			'UG' => 'ยูกันดา',
 			'UM' => 'หมู่เกาะรอบนอกของสหรัฐอเมริกา',
 			'US' => 'สหรัฐอเมริกา',
 			'US@alt=short' => 'สหรัฐฯ',
 			'UY' => 'อุรุกวัย',
 			'UZ' => 'อุซเบกิสถาน',
 			'VA' => 'นครวาติกัน',
 			'VC' => 'เซนต์วินเซนต์และเกรนาดีนส์',
 			'VE' => 'เวเนซุเอลา',
 			'VG' => 'หมู่เกาะบริติชเวอร์จิน',
 			'VI' => 'หมู่เกาะยูเอสเวอร์จิน',
 			'VN' => 'เวียดนาม',
 			'VU' => 'วานูอาตู',
 			'WF' => 'วาลลิสและฟุตูนา',
 			'WS' => 'ซามัว',
 			'XK' => 'โคโซโว',
 			'YE' => 'เยเมน',
 			'YT' => 'มายอต',
 			'ZA' => 'แอฟริกาใต้',
 			'ZM' => 'แซมเบีย',
 			'ZW' => 'ซิมบับเว',
 			'ZZ' => 'ภูมิภาคที่ไม่รู้จัก',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'เยอรมันออร์โธกราฟีดั้งเดิม',
 			'1994' => 'อักขระเรเซียนมาตราฐาน',
 			'1996' => 'เยอรมันออร์โธกราฟีปี 1996',
 			'1606NICT' => 'ปลายยุคกลางฝรั่งเศสถึงปี ค.ศ. 1606',
 			'1694ACAD' => 'ตอนต้นยุคใหม่ฝรั่งเศส',
 			'1959ACAD' => 'วิชาการ',
 			'ALALC97' => 'การถอดอักษรเป็นอักษรโรมันตามเกณฑ์ของสมาคมห้องสมุดอเมริกันและห้องสมุดรัฐสภา ฉบับพิมพ์ปี 1997',
 			'ALUKU' => 'ภาษาพื้นเมืองอลูคู',
 			'AREVELA' => 'อาร์เมเนียตะวันออก',
 			'AREVMDA' => 'อาร์เมเนียตะวันตก',
 			'BAKU1926' => 'ตัวอักษรละตินเตอร์กิกแบบครบวงจร',
 			'BAUDDHA' => 'พระพุทธเจ้า',
 			'BISCAYAN' => 'บิสคายัน',
 			'BISKE' => 'ภาษาพื้นเมืองซานจอร์โจ/บิลา',
 			'BOHORIC' => 'ตัวอักษรโบโฮริช',
 			'BOONT' => 'บูนทลิ่ง',
 			'DAJNKO' => 'ตัวอักษรดายนชิซา',
 			'EMODENG' => 'อังกฤษสมัยใหม่ตอนต้น',
 			'FONIPA' => 'สัทอักษรสากล',
 			'FONUPA' => 'สัทอักษร UPA',
 			'FONXSAMP' => 'ฟอนซ์แซมพ์',
 			'HEPBURN' => 'การถอดอักษรแบบเฮปเบิร์น',
 			'HOGNORSK' => 'ภาษานอร์วิเจียนสูง',
 			'ITIHASA' => 'อิติหาสะ',
 			'JAUER' => 'เยาเออร์',
 			'JYUTPING' => 'ระบบถอดอักษรแบบยวึดพิง',
 			'KKCOR' => 'อักขรวิธีสามัญ',
 			'KSCOR' => 'อักขรวิธีมาตรฐาน',
 			'LAUKIKA' => 'ลัวกิกา',
 			'LIPAW' => 'ภาษาพื้นเมืองลิโพวาซของเรเซียน',
 			'LUNA1918' => 'ลูน่า 1918',
 			'METELKO' => 'ตัวอักษรเมเตวชิซา',
 			'MONOTON' => 'โมโนโทนิก',
 			'NDYUKA' => 'ดิวคา',
 			'NEDIS' => 'ภาษาพื้นเมืองนาทิโซเน',
 			'NJIVA' => 'ภาษาพื้นเมืองจนีวา/นจีวา',
 			'NULIK' => 'โวลาพึคสมัยใหม่',
 			'OSOJS' => 'ภาษาพื้นเมืองโอเซียคโค/โอโซยาเน',
 			'PAMAKA' => 'ภาษาพื้นเมืองพามาคา',
 			'PETR1708' => 'พีท 1708',
 			'PINYIN' => 'พินอิน',
 			'POLYTON' => 'โพลีโทนิก',
 			'POSIX' => 'คอมพิวเตอร์',
 			'PUTER' => 'พิวเตอร์',
 			'REVISED' => 'ออร์โธกราฟิปรับปรุง',
 			'RIGIK' => 'โวลาพึคดั้งเดิม',
 			'ROZAJ' => 'เรเซียน',
 			'RUMGR' => 'รัมกร์',
 			'SAAHO' => 'ซาโฮ',
 			'SCOTLAND' => 'ภาษาอังกฤษมาตราฐานสก๊อต',
 			'SCOUSE' => 'สเกาส์',
 			'SOLBA' => 'ภาษาพื้นเมืองสโตวีซซา/โซลบีกา',
 			'SURMIRAN' => 'ซูร์มิราน',
 			'SURSILV' => 'ซูร์ซีลฟ์',
 			'SUTSILV' => 'ซุตซีลฟ์',
 			'TARASK' => 'ทาราซเคียวิซาออร์โธกราฟี',
 			'UCCOR' => 'อักขรวิธีแบบครบวงจร',
 			'UCRCOR' => 'อักขรวิธีแบบปรับปรุงครบวงจร',
 			'ULSTER' => 'อัลสเตอร์',
 			'VAIDIKA' => 'เวดิคา',
 			'VALENCIA' => 'วาเลนเซีย',
 			'VALLADER' => 'วัลลาเดอร์',
 			'WADEGILE' => 'การถอดอักษรแบบเวด-ไจลส์',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'ปฏิทิน',
 			'colalternate' => 'ละเว้นการจัดเรียงสัญลักษณ์',
 			'colbackwards' => 'การจัดเรียงเสียงหนักเบาในลำดับถอยหลัง',
 			'colcasefirst' => 'การเรียงลำดับตัวพิมพ์ใหญ่/ตัวพิมพ์เล็ก',
 			'colcaselevel' => 'การจัดเรียงตามความสำคัญของตัวพิมพ์อักษร',
 			'colhiraganaquaternary' => 'การจัดเรียงตัวอักษรคะนะ',
 			'collation' => 'ลำดับการจัดเรียง',
 			'colnormalization' => 'การจัดเรียงแบบที่เป็นปกติ',
 			'colnumeric' => 'การจัดเรียงตัวเลข',
 			'colstrength' => 'ความแม่นยำในการจัดเรียง',
 			'currency' => 'สกุลเงิน',
 			'numbers' => 'ตัวเลข',
 			'timezone' => 'เขตเวลา',
 			'va' => 'ตัวแปรภาษาถิ่น',
 			'variabletop' => 'จัดเรียงเป็นสัญลักษณ์',
 			'x' => 'ใช้งานส่วนบุคคล',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ปฏิทินพุทธ},
 				'chinese' => q{ปฏิทินจีน},
 				'coptic' => q{ปฏิทินคอปติก},
 				'dangi' => q{ปฏิทินทันกิ},
 				'ethiopic' => q{ปฏิทินเอธิโอเปีย},
 				'ethiopic-amete-alem' => q{ปฏิทินปีโลกเอธิโอเปีย},
 				'gregorian' => q{ปฏิทินเกรกอเรียน},
 				'hebrew' => q{ปฏิทินฮิบรู},
 				'indian' => q{ปฏิทินแห่งชาติอินเดีย},
 				'islamic' => q{ปฏิทินอิสลาม},
 				'islamic-civil' => q{ปฏิทินอิสลามซีวิล},
 				'islamic-rgsa' => q{ปฏิทินอิสลาม (ซาอุดีอาระเบีย แบบพระจันทร์เสี้ยว)},
 				'islamic-tbla' => q{ปฏิทินอิสลาม (แบบตาราง สมัยดาราศาสตร์)},
 				'islamic-umalqura' => q{ปฏิทินอิสลาม (อุมม์อัลกุรา)},
 				'iso8601' => q{ปฏิทิน ISO-8601},
 				'japanese' => q{ปฏิทินญี่ปุ่น},
 				'persian' => q{ปฏิทินเปอร์เชีย},
 				'roc' => q{ปฏิทินไต้หวัน},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{จัดเรียงสัญลักษณ์},
 				'shifted' => q{จัดเรียงสัญลักษณ์ที่ละไว้},
 			},
 			'colbackwards' => {
 				'no' => q{จัดเรียงเสียงหนักเบาตามปกติ},
 				'yes' => q{จัดเรียงเสียงหนักเบาในลำดับถอยหลัง},
 			},
 			'colcasefirst' => {
 				'lower' => q{จัดเรียงลำดับตัวพิมพ์เล็กก่อน},
 				'no' => q{จัดเรียงลำดับตามตัวพิมพ์ปกติ},
 				'upper' => q{จัดเรียงตัวพิมพ์ใหญ่ก่อน},
 			},
 			'colcaselevel' => {
 				'no' => q{จัดเรียงตามความสำคัญของตัวพิมพ์},
 				'yes' => q{จัดเรียงความสำคัญของตัวพิมพ์},
 			},
 			'colhiraganaquaternary' => {
 				'no' => q{จัดเรียงตัวอักษรคะนะแยกต่างหาก},
 				'yes' => q{จัดเรียงตัวอักษรคะนะในแบบอื่น},
 			},
 			'collation' => {
 				'big5han' => q{เรียงตามอักษรจีนดั้งเดิม},
 				'dictionary' => q{เรียงตามพจนานุกรม},
 				'ducet' => q{ลำดับการจัดเรียงตาม Unicode เริ่มต้น},
 				'eor' => q{กฎการเรียงลำดับตามแบบยุโรป},
 				'gb2312han' => q{เรียงตามอักษรจีนประยุกต์},
 				'phonebook' => q{เรียงตามสมุดโทรศัพท์},
 				'phonetic' => q{ลำดักการจัดเรียงตามคำอ่าน},
 				'pinyin' => q{เรียงตามการถอดเสียงภาษาจีน},
 				'reformed' => q{เรียงตามลำดับล่าสุด},
 				'search' => q{การค้นหาทั่วไป},
 				'searchjl' => q{ค้นหาตามพยัญชนะขึ้นต้นที่เป็นฮันกึล},
 				'standard' => q{ลำดับการจัดเรียงแบบมาตรฐาน},
 				'stroke' => q{เรียงตามการลากเส้น},
 				'traditional' => q{เรียงตามแบบดั้งเดิม},
 				'unihan' => q{เรียงลำดับตามจำนวนขีด},
 				'zhuyin' => q{จัดเรียงตามการสะกดแบบจู้อิน},
 			},
 			'colnormalization' => {
 				'no' => q{จัดเรียงโดยไม่ต้องทำให้เป็นแบบปกติ},
 				'yes' => q{จัดเรียงยูนิโค้ดแบบที่เป็นปกติ},
 			},
 			'colnumeric' => {
 				'no' => q{จัดเรียงตัวเลขแยก},
 				'yes' => q{จัดเรัยงตัวเลขตามลำดับตัวเลข},
 			},
 			'colstrength' => {
 				'identical' => q{จัดเรียงทั้งหมด},
 				'primary' => q{จัดเรียงตัวอักษรฐานเท่านั้น},
 				'quaternary' => q{จัดเรียงตามเสียงหนักเบา/ตัวพิมพ์/ความกว้าง/ตัวอักษรคะนะ},
 				'secondary' => q{จัดเรียงเสียงหนักเบา},
 				'tertiary' => q{จัดเรียงเสียงหนักเบา/ตัวพิมพ์/ความกว้าง},
 			},
 			'numbers' => {
 				'arab' => q{ตัวเลขอินเดีย-อารบิก},
 				'arabext' => q{ตัวเลขอินเดีย-อารบิกตัวเต็ม},
 				'armn' => q{ตัวเลขอาร์เมเนีย},
 				'armnlow' => q{ตัวเลขอาร์เมเนียพิมพ์เล็ก},
 				'bali' => q{ตัวเลขบาหลี},
 				'beng' => q{ตัวเลขบังกลาเทศ},
 				'brah' => q{ตัวเลขพราหมี},
 				'cakm' => q{ตัวเลขชากมา},
 				'cham' => q{ตัวเลขชาม},
 				'deva' => q{ตัวเลขเทวนาครี},
 				'ethi' => q{ตัวเลขเอธิโอเปีย},
 				'finance' => q{ตัวเลขทางการเงิน},
 				'fullwide' => q{ตัวเลขแบบเต็มขนาด},
 				'geor' => q{ตัวเลขจอร์เจีย},
 				'grek' => q{ตัวเลขกรีก},
 				'greklow' => q{ตัวเลขกรีกพิมพ์เล็ก},
 				'gujr' => q{ตัวเลขคุชราต},
 				'guru' => q{ตัวเลขกูร์มูคี},
 				'hanidec' => q{ตัวเลขทศนิยมจีน},
 				'hans' => q{ตัวเลขจีนตัวย่อ},
 				'hansfin' => q{ตัวเลขทางการเงินแบบตัวย่อของจีน},
 				'hant' => q{ตัวเลขจีนตัวเต็ม},
 				'hantfin' => q{ตัวเลขทางการเงินแบบตัวเต็มของจีน},
 				'hebr' => q{ตัวเลขฮิบรู},
 				'java' => q{ตัวเลขชวา},
 				'jpan' => q{ตัวเลขญี่ปุ่น},
 				'jpanfin' => q{ตัวเลขทางการเงินของญี่ปุ่น},
 				'kali' => q{ตัวเลขคยาห์},
 				'khmr' => q{ตัวเลขเขมร},
 				'knda' => q{ตัวเลขกันนาดา},
 				'lana' => q{ตัวเลขไททัมโฮรา},
 				'lanatham' => q{ตัวเลขไททัมทัม},
 				'laoo' => q{ตัวเลขลาว},
 				'latn' => q{ตัวเลขอารบิค},
 				'lepc' => q{ตัวเลขเลปชา},
 				'limb' => q{ตัวเลขลิมบู},
 				'mlym' => q{ตัวเลขมาลายาลัม},
 				'mong' => q{ตัวเลขมองโกเลีย},
 				'mtei' => q{ตัวเลขเมไตมาเยก},
 				'mymr' => q{ตัวเลขพม่า},
 				'mymrshan' => q{ตัวเลขชานพม่า},
 				'native' => q{ตัวเลขพื้นเมือง},
 				'nkoo' => q{ตัวเลขเอ็นโก},
 				'olck' => q{ตัวเลขโอลจิกิ},
 				'orya' => q{ตัวเลขโอริยา},
 				'osma' => q{ตัวเลขออสมันยา},
 				'roman' => q{ตัวเลขโรมัน},
 				'romanlow' => q{ตัวเลขโรมันพิมพ์เล็ก},
 				'saur' => q{ตัวเลขเศารัชธรา},
 				'shrd' => q{ตัวเลขชาราดา},
 				'sora' => q{ตัวเลขโสราสมเป็ง},
 				'sund' => q{ตัวเลขซุนดา},
 				'takr' => q{ตัวเลขทาครี},
 				'talu' => q{ตัวเลขไทลื้อใหม่},
 				'taml' => q{ตัวเลขทมิฬดั้งเดิม},
 				'tamldec' => q{ตัวเลขทมิฬ},
 				'telu' => q{ตัวเลขเตลูกู},
 				'thai' => q{ตัวเลขไทย},
 				'tibt' => q{ตัวเลขทิเบต},
 				'traditional' => q{ตัวเลขแบบดั้งเดิม},
 				'vaii' => q{ตัวเลขไว},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{เมตริก},
 			'UK' => q{สหราชอาณาจักร},
 			'US' => q{อเมริกัน},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'ชื่อมาตรฐานอังกฤษ (BGN)',
 			'numeric' => 'ตัวเลข',
 			'tone' => 'ระดับเสียง',
 			'ungegn' => 'ชื่อภูมิศาสตร์มาตรฐาน UN (UNGEGN)',
 			'x-accents' => 'สำเนียง',
 			'x-fullwidth' => 'ตัวเต็ม',
 			'x-halfwidth' => 'ตัวย่อ',
 			'x-jamo' => 'จาโม',
 			'x-pinyin' => 'พินอิน',
 			'x-publishing' => 'เพื่อเผยแพร่',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'ภาษา: {0}',
 			'script' => 'สคริปต์: {0}',
 			'territory' => 'ภูมิภาค: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[​])},
			index => ['ก', 'ข', 'ฃ', 'ค', 'ฅ', 'ฆ', 'ง', 'จ', 'ฉ', 'ช', 'ซ', 'ฌ', 'ญ', 'ฎ', 'ฏ', 'ฐ', 'ฑ', 'ฒ', 'ณ', 'ด', 'ต', 'ถ', 'ท', 'ธ', 'น', 'บ', 'ป', 'ผ', 'ฝ', 'พ', 'ฟ', 'ภ', 'ม', 'ย', 'ร', 'ฤ', 'ล', 'ฦ', 'ว', 'ศ', 'ษ', 'ส', 'ห', 'ฬ', 'อ', 'ฮ'],
			main => qr{(?^u:[๎ ็ ่ ้ ๊ ๋ ์ ํ ๆ ก ข ฃ ค ฅ ฆ ง จ ฉ ช ซ ฌ ญ ฎ ฏ ฐ ฑ ฒ ณ ด ต ถ ท ธ น บ ป ผ ฝ พ ฟ ภ ม ย ร ฤ ล ฦ ว ศ ษ ส ห ฬ อ ฮ ฯ ะ ั า ำ ิ ี ึ ื ุ ู ฺ เ แ โ ใ ไ ๅ])},
			punctuation => qr{(?^u:[\- ‐ – — , \: ! . … ' ‘ ’ " “ ” ( ) \[ \] @ * / # ′ ″])},
		};
	},
);

has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'other' => q({0} เอเคอร์),
					},
					'arc-minute' => {
						'other' => q({0} นาที),
					},
					'arc-second' => {
						'other' => q({0} วินาที),
					},
					'celsius' => {
						'other' => q({0} องศาเซลเซียส),
					},
					'centimeter' => {
						'other' => q({0} เซนติเมตร),
					},
					'cubic-kilometer' => {
						'other' => q({0} ลูกบาศก์กิโลเมตร),
					},
					'cubic-mile' => {
						'other' => q({0} ลูกบาศก์ไมล์),
					},
					'day' => {
						'other' => q({0} วัน),
					},
					'degree' => {
						'other' => q({0} องศา),
					},
					'fahrenheit' => {
						'other' => q({0} องศาฟาเรนไฮต์),
					},
					'foot' => {
						'other' => q({0} ฟุต),
					},
					'g-force' => {
						'other' => q({0} แรง G),
					},
					'gram' => {
						'other' => q({0} กรัม),
					},
					'hectare' => {
						'other' => q({0} เฮกตาร์),
					},
					'hectopascal' => {
						'other' => q({0} เฮกโตปาสกาล),
					},
					'horsepower' => {
						'other' => q({0} แรงม้า),
					},
					'hour' => {
						'other' => q({0} ชั่วโมง),
					},
					'inch' => {
						'other' => q({0} นิ้ว),
					},
					'inch-hg' => {
						'other' => q({0} นิ้วปรอท),
					},
					'kilogram' => {
						'other' => q({0} กิโลกรัม),
					},
					'kilometer' => {
						'other' => q({0} กิโลเมตร),
					},
					'kilometer-per-hour' => {
						'other' => q({0} กิโลเมตรต่อชั่วโมง),
					},
					'kilowatt' => {
						'other' => q({0} กิโลวัตต์),
					},
					'light-year' => {
						'other' => q({0} ปีแสง),
					},
					'liter' => {
						'other' => q({0} ลิตร),
					},
					'meter' => {
						'other' => q({0} เมตร),
					},
					'meter-per-second' => {
						'other' => q({0} เมตรต่อวินาที),
					},
					'mile' => {
						'other' => q({0} ไมล์),
					},
					'mile-per-hour' => {
						'other' => q({0} ไมล์ต่อชั่วโมง),
					},
					'millibar' => {
						'other' => q({0} มิลลิบาร์),
					},
					'millimeter' => {
						'other' => q({0} มิลลิเมตร),
					},
					'millisecond' => {
						'other' => q({0} มิลลิวินาที),
					},
					'minute' => {
						'other' => q({0} นาที),
					},
					'month' => {
						'other' => q({0} เดือน),
					},
					'ounce' => {
						'other' => q({0} ออนซ์),
					},
					'per' => {
						'' => q({0}ต่อ{1}),
					},
					'picometer' => {
						'other' => q({0} พิโกเมตร),
					},
					'pound' => {
						'other' => q({0} ปอนด์),
					},
					'second' => {
						'other' => q({0} วินาที),
					},
					'square-foot' => {
						'other' => q({0} ตารางฟุต),
					},
					'square-kilometer' => {
						'other' => q({0} ตารางกิโลเมตร),
					},
					'square-meter' => {
						'other' => q({0} ตารางเมตร),
					},
					'square-mile' => {
						'other' => q({0} ตารางไมล์),
					},
					'watt' => {
						'other' => q({0} วัตต์),
					},
					'week' => {
						'other' => q({0} สัปดาห์),
					},
					'yard' => {
						'other' => q({0} หลา),
					},
					'year' => {
						'other' => q({0} ปี),
					},
				},
				'narrow' => {
					'acre' => {
						'other' => q({0}เอเคอร์),
					},
					'arc-minute' => {
						'other' => q({0}นาที),
					},
					'arc-second' => {
						'other' => q({0}วิ),
					},
					'celsius' => {
						'other' => q({0}°),
					},
					'centimeter' => {
						'other' => q({0}ซม.),
					},
					'cubic-kilometer' => {
						'other' => q({0}ลบ.กม.),
					},
					'cubic-mile' => {
						'other' => q({0}ลบ.ไมล์),
					},
					'day' => {
						'other' => q({0}วัน),
					},
					'degree' => {
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'other' => q({0}°F),
					},
					'foot' => {
						'other' => q({0}′),
					},
					'g-force' => {
						'other' => q({0}G),
					},
					'gram' => {
						'other' => q({0}ก.),
					},
					'hectare' => {
						'other' => q({0}เฮกตาร์),
					},
					'hectopascal' => {
						'other' => q({0}hPa),
					},
					'horsepower' => {
						'other' => q({0}แรงม้า),
					},
					'hour' => {
						'other' => q({0}ชม.),
					},
					'inch' => {
						'other' => q({0}″),
					},
					'inch-hg' => {
						'other' => q({0}" Hg),
					},
					'kilogram' => {
						'other' => q({0}กก.),
					},
					'kilometer' => {
						'other' => q({0}กม.),
					},
					'kilometer-per-hour' => {
						'other' => q({0}กม./ชม.),
					},
					'kilowatt' => {
						'other' => q({0}กิโลวัตต์),
					},
					'light-year' => {
						'other' => q({0}ปีแสง),
					},
					'liter' => {
						'other' => q({0}ลิตร),
					},
					'meter' => {
						'other' => q({0}ม.),
					},
					'meter-per-second' => {
						'other' => q({0}ม./วิ),
					},
					'mile' => {
						'other' => q({0}ไมล์),
					},
					'mile-per-hour' => {
						'other' => q({0}ไมล์/ชม.),
					},
					'millibar' => {
						'other' => q({0}มิลลิบาร์),
					},
					'millimeter' => {
						'other' => q({0}มม.),
					},
					'millisecond' => {
						'other' => q({0} มิลลิวิ),
					},
					'minute' => {
						'other' => q({0}นาที),
					},
					'month' => {
						'other' => q({0}เดือน),
					},
					'ounce' => {
						'other' => q({0}ออนซ์),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'other' => q({0}พิโกเมตร),
					},
					'pound' => {
						'other' => q({0}#),
					},
					'second' => {
						'other' => q({0}วิ),
					},
					'square-foot' => {
						'other' => q({0}ตร.ฟุต),
					},
					'square-kilometer' => {
						'other' => q({0}ตร.กม.),
					},
					'square-meter' => {
						'other' => q({0}ตร.ม.),
					},
					'square-mile' => {
						'other' => q({0}ตร.ไมล์),
					},
					'watt' => {
						'other' => q({0}วัตต์),
					},
					'week' => {
						'other' => q({0}สัปดาห์),
					},
					'yard' => {
						'other' => q({0}หลา),
					},
					'year' => {
						'other' => q({0}ปี),
					},
				},
				'short' => {
					'acre' => {
						'other' => q({0} เอเคอร์),
					},
					'arc-minute' => {
						'other' => q({0} นาที),
					},
					'arc-second' => {
						'other' => q({0} วิ),
					},
					'celsius' => {
						'other' => q({0}°C),
					},
					'centimeter' => {
						'other' => q({0} ซม.),
					},
					'cubic-kilometer' => {
						'other' => q({0} ลบ.กม.),
					},
					'cubic-mile' => {
						'other' => q({0} ลบ.ไมล์),
					},
					'day' => {
						'other' => q({0} วัน),
					},
					'degree' => {
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'other' => q({0}°F),
					},
					'foot' => {
						'other' => q({0} ฟุต),
					},
					'g-force' => {
						'other' => q({0} G),
					},
					'gram' => {
						'other' => q({0} ก.),
					},
					'hectare' => {
						'other' => q({0} เฮกตาร์),
					},
					'hectopascal' => {
						'other' => q({0} เฮกโตปาสกาล),
					},
					'horsepower' => {
						'other' => q({0} แรงม้า),
					},
					'hour' => {
						'other' => q({0} ชม.),
					},
					'inch' => {
						'other' => q({0} นิ้ว),
					},
					'inch-hg' => {
						'other' => q({0} นิ้วปรอท),
					},
					'kilogram' => {
						'other' => q({0} กก.),
					},
					'kilometer' => {
						'other' => q({0} กม.),
					},
					'kilometer-per-hour' => {
						'other' => q({0} กม./ชม.),
					},
					'kilowatt' => {
						'other' => q({0} กิโลวัตต์),
					},
					'light-year' => {
						'other' => q({0} ปีแสง),
					},
					'liter' => {
						'other' => q({0} ลิตร),
					},
					'meter' => {
						'other' => q({0} ม.),
					},
					'meter-per-second' => {
						'other' => q({0} ม./วิ),
					},
					'mile' => {
						'other' => q({0} ไมล์),
					},
					'mile-per-hour' => {
						'other' => q({0} ไมล์/ชม.),
					},
					'millibar' => {
						'other' => q({0} มิลลิบาร์),
					},
					'millimeter' => {
						'other' => q({0} มม.),
					},
					'millisecond' => {
						'other' => q({0} มิลลิวินาที),
					},
					'minute' => {
						'other' => q({0} นาที),
					},
					'month' => {
						'other' => q({0} เดือน),
					},
					'ounce' => {
						'other' => q({0} ออนซ์),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'other' => q({0} พิโกเมตร),
					},
					'pound' => {
						'other' => q({0} ปอนด์),
					},
					'second' => {
						'other' => q({0} วิ),
					},
					'square-foot' => {
						'other' => q({0} ตร.ฟุต),
					},
					'square-kilometer' => {
						'other' => q({0} ตร.กม.),
					},
					'square-meter' => {
						'other' => q({0} ตร.ม.),
					},
					'square-mile' => {
						'other' => q({0} ตร.ไมล์),
					},
					'watt' => {
						'other' => q({0} วัตต์),
					},
					'week' => {
						'other' => q({0} สัปดาห์),
					},
					'yard' => {
						'other' => q({0} หลา),
					},
					'year' => {
						'other' => q({0} ปี),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ใช่|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ไม่ใช่|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0} {1}),
				middle => q({0} {1}),
				end => q({0} และ {1}),
				2 => q({0} {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'thai',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0.###',
				},
				'1000' => {
					'other' => '0 พ'.'',
				},
				'10000' => {
					'other' => '0 ม'.'',
				},
				'100000' => {
					'other' => '0 ส'.'',
				},
				'1000000' => {
					'other' => '0 ล'.'',
				},
				'10000000' => {
					'other' => '00 ล'.'',
				},
				'100000000' => {
					'other' => '000 ล'.'',
				},
				'1000000000' => {
					'other' => '0 พ'.'ล'.'',
				},
				'10000000000' => {
					'other' => '0 ม'.'ล'.'',
				},
				'100000000000' => {
					'other' => '0 ส'.'ล'.'',
				},
				'1000000000000' => {
					'other' => '0 ล'.'ล'.'',
				},
				'10000000000000' => {
					'other' => '00 ล'.'ล'.'',
				},
				'100000000000000' => {
					'other' => '000 ล'.'ล'.'',
				},
			},
			'long' => {
				'1000' => {
					'other' => '0 พัน',
				},
				'10000' => {
					'other' => '0 หมื่น',
				},
				'100000' => {
					'other' => '0 แสน',
				},
				'1000000' => {
					'other' => '0 ล้าน',
				},
				'10000000' => {
					'other' => '00 ล้าน',
				},
				'100000000' => {
					'other' => '000 ล้าน',
				},
				'1000000000' => {
					'other' => '0 พันล้าน',
				},
				'10000000000' => {
					'other' => '0 หมื่นล้าน',
				},
				'100000000000' => {
					'other' => '0 แสนล้าน',
				},
				'1000000000000' => {
					'other' => '0 ล้านล้าน',
				},
				'10000000000000' => {
					'other' => '00 ล้านล้าน',
				},
				'100000000000000' => {
					'other' => '000 ล้านล้าน',
				},
			},
			'short' => {
				'1000' => {
					'other' => '0 พ'.'',
				},
				'10000' => {
					'other' => '0 ม'.'',
				},
				'100000' => {
					'other' => '0 ส'.'',
				},
				'1000000' => {
					'other' => '0 ล'.'',
				},
				'10000000' => {
					'other' => '00 ล'.'',
				},
				'100000000' => {
					'other' => '000 ล'.'',
				},
				'1000000000' => {
					'other' => '0 พ'.'ล'.'',
				},
				'10000000000' => {
					'other' => '0 ม'.'ล'.'',
				},
				'100000000000' => {
					'other' => '0 ส'.'ล'.'',
				},
				'1000000000000' => {
					'other' => '0 ล'.'ล'.'',
				},
				'10000000000000' => {
					'other' => '00 ล'.'ล'.'',
				},
				'100000000000000' => {
					'other' => '000 ล'.'ล'.'',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'negative' => '¤#,##0.00',
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(เปเซตาอันดอร์รา),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(เดอร์แฮมสหรัฐอาหรับเอมิเรตส์),
				'other' => q(เดอร์แฮมสหรัฐอาหรับเอมิเรตส์),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(อัฟกานีอัฟกานิสถาน \(1927–2002\)),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(อัฟกานิอัฟกานิสถาน),
				'other' => q(อัฟกานิอัฟกานิสถาน),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(เลกแอลเบเนีย),
				'other' => q(เลกแอลเบเนีย),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(แดรมอาร์เมเนีย),
				'other' => q(แดรมอาร์เมเนีย),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(กิลเดอร์เนเธอร์แลนด์แอนทิลลิส),
				'other' => q(กิลเดอร์เนเธอร์แลนด์แอนทิลลิส),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(กวานซาแองโกลา),
				'other' => q(กวานซาแองโกลา),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(กวานซาแองโกลา \(1977–1990\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(นิวกวานซาแองโกลา \(1990–2000\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(กวานซารีจัสทาโดแองโกลา \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(ออสตรัลอาร์เจนตินา),
			},
		},
		'ARL' => {
			display_name => {
				'currency' => q(เปโซเลย์อาร์เจนตินา \(1970–1983\)),
			},
		},
		'ARM' => {
			display_name => {
				'currency' => q(เปโซอาร์เจนตินา \(1881–1970\)),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(เปโซอาร์เจนตินา \(1983–1985\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(เปโซอาร์เจนตินา),
				'other' => q(เปโซอาร์เจนตินา),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(ชิลลิงออสเตรีย),
			},
		},
		'AUD' => {
			symbol => 'AU$',
			display_name => {
				'currency' => q(ดอลลาร์ออสเตรเลีย),
				'other' => q(ดอลลาร์ออสเตรเลีย),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(ฟลอรินอารูบา),
				'other' => q(ฟลอรินอารูบา),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(มานัตอาเซอร์ไบจาน \(1993–2006\)),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(มานัตอาเซอร์ไบจาน),
				'other' => q(มานัตอาเซอร์ไบจาน),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(ดีนาร์บอสเนีย-เฮอร์เซโกวีนา),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(มาร์กบอสเนีย-เฮอร์เซโกวีนา),
				'other' => q(มาร์กบอสเนีย-เฮอร์เซโกวีนา),
			},
		},
		'BAN' => {
			display_name => {
				'currency' => q(ดีนาร์ใหม่บอสเนีย-เฮอร์เซโกวีนา \(1994–1997\)),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(ดอลลาร์บาร์เบโดส),
				'other' => q(ดอลลาร์บาร์เบโดส),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(ตากาบังกลาเทศ),
				'other' => q(ตากาบังกลาเทศ),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(ฟรังก์เบลเยียม \(เปลี่ยนแปลงได้\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(ฟรังก์เบลเยียม),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(ฟรังก์เบลเยียม \(การเงิน\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(ฮาร์ดเลฟบัลแกเรีย),
			},
		},
		'BGM' => {
			display_name => {
				'currency' => q(โซเชียลลิสต์เลฟบัลแกเรีย),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(เลฟบัลแกเรีย),
				'other' => q(เลฟบัลแกเรีย),
			},
		},
		'BGO' => {
			display_name => {
				'currency' => q(เลฟบัลเกเรีย \(1879–1952\)),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(ดีนาร์บาห์เรน),
				'other' => q(ดีนาร์บาห์เรน),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(ฟรังก์บุรุนดี),
				'other' => q(ฟรังก์บุรุนดี),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(ดอลลาร์เบอร์มิวดา),
				'other' => q(ดอลลาร์เบอร์มิวดา),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(ดอลลาร์บรูไน),
				'other' => q(ดอลลาร์บรูไน),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(โบลิเวียโนโบลิเวีย),
				'other' => q(โบลิเวียโนโบลิเวีย),
			},
		},
		'BOL' => {
			display_name => {
				'currency' => q(โบลิเวียโนโบลิเวีย \(1863–1963\)),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(เปโซโบลิเวีย),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(มฟดอลโบลิเวีย),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(ครูเซโรโนโวบราซิล \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(ครูซาโดบราซิล),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(ครูเซโรบราซิล \(1990–1993\)),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(เรียลบราซิล),
				'other' => q(เรียลบราซิล),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(ครูซาโดโนโวบราซิล),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(ครูเซโรบราซิล),
			},
		},
		'BRZ' => {
			display_name => {
				'currency' => q(ครูเซโรบราซิล \(1942–1967\)),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(ดอลลาร์บาฮามาส),
				'other' => q(ดอลลาร์บาฮามาส),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(เอ็งกุลตรัมภูฏาน),
				'other' => q(เอ็งกุลตรัมภูฏาน),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(จ๊าดพม่า),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(ปูลาบอตสวานา),
				'other' => q(ปูลาบอตสวานา),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(นิวรูเบิลเบลารุส \(1994–1999\)),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(รูเบิลเบลารุส),
				'other' => q(รูเบิลเบลารุส),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(ดอลลาร์เบลีซ),
				'other' => q(ดอลลาร์เบลีซ),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(ดอลลาร์แคนาดา),
				'other' => q(ดอลลาร์แคนาดา),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(ฟรังก์คองโก),
				'other' => q(ฟรังก์คองโก),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(ยูโรดับเบิลยูไออาร์),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(ฟรังก์สวิส),
				'other' => q(ฟรังก์สวิส),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(ฟรังก์ดับเบิลยูไออาร์),
			},
		},
		'CLE' => {
			display_name => {
				'currency' => q(เอสคูโดชิลี),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(ฟูเมนโตชิลี),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(เปโซชิลี),
				'other' => q(เปโซชิลี),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(หยวนจีน),
				'other' => q(หยวนจีน),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(เปโซโคลอมเบีย),
				'other' => q(เปโซโคลอมเบีย),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(วาเลอร์เรียลโคลอมเบีย),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(โกลองคอสตาริกา),
				'other' => q(โกลองคอสตาริกา),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(ดีนาร์เซอร์เบียเก่า),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(ฮาร์ดโครูนาเช็กโกสโลวัก),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(เปโซคิวบา \(แปลงสภาพ\)),
				'other' => q(เปโซคิวบา \(แปลงสภาพ\)),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(เปโซคิวบา),
				'other' => q(เปโซคิวบา),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(เอสคูโดเคปเวิร์ด),
				'other' => q(เอสคูโดเคปเวิร์ด),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(ปอนด์ไซปรัส),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(โครูนาสาธารณรัฐเช็ก),
				'other' => q(โครูนาสาธารณรัฐเช็ก),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(มาร์กเยอรมันตะวันออก),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(มาร์กเยอรมัน),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(ฟรังก์จิบูตี),
				'other' => q(ฟรังก์จิบูตี),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(โครนเดนมาร์ก),
				'other' => q(โครนเดนมาร์ก),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(เปโซโดมินิกัน),
				'other' => q(เปโซโดมินิกัน),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(ดีนาร์แอลจีเรีย),
				'other' => q(ดีนาร์แอลจีเรีย),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(ซูเกรเอกวาดอร์),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(วาเลอร์คอนสแตนต์เอกวาดอร์),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(ครูนเอสโตเนีย),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(ปอนด์อียิปต์),
				'other' => q(ปอนด์อียิปต์),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(แนกฟาเอริเทรีย),
				'other' => q(แนกฟาเอริเทรีย),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(เปเซตาสเปน \(บัญชีเอ\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(เปเซตาสเปน \(บัญชีที่เปลี่ยนแปลงได้\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(เปเซตาสเปน),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(เบอรร์เอธิโอเปีย),
				'other' => q(เบอรร์เอธิโอเปีย),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ยูโร),
				'other' => q(ยูโร),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(มาร์กกาฟินแลนด์),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(ดอลลาร์ฟิจิ),
				'other' => q(ดอลลาร์ฟิจิ),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(ปอนด์หมู่เกาะฟอล์กแลนด์),
				'other' => q(ปอนด์หมู่เกาะฟอล์กแลนด์),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(ฟรังก์ฝรั่งเศส),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ปอนด์สเตอร์ลิง \(สหราชอาณาจักร\)),
				'other' => q(ปอนด์สเตอร์ลิง \(สหราชอาณาจักร\)),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(คูปอนลาริตจอร์เจีย),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(ลารีจอร์เจีย),
				'other' => q(ลารีจอร์เจีย),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(เซดีกานา \(1979–2007\)),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(เซดีกานา),
				'other' => q(เซดีกานา),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(ปอนด์ยิบรอลตาร์),
				'other' => q(ปอนด์ยิบรอลตาร์),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(ดาลาซีแกมเบีย),
				'other' => q(ดาลาซีแกมเบีย),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(ฟรังก์กินี),
				'other' => q(ฟรังก์กินี),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(ไซลีกินี),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(เอ็กเวเลอิเควทอเรียลกินี),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(ดรัชมากรีก),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(เควตซัลกัวเตมาลา),
				'other' => q(เควตซัลกัวเตมาลา),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(เอสคูโดกินีโปรตุเกส),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(เปโซกินี-บิสเซา),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(ดอลลาร์กายอานา),
				'other' => q(ดอลลาร์กายอานา),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(ดอลลาร์ฮ่องกง),
				'other' => q(ดอลลาร์ฮ่องกง),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(เลมปิราฮอนดูรัส),
				'other' => q(เลมปิราฮอนดูรัส),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(ดีนาร์โครเอเชีย),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(คูนาโครเอเชีย),
				'other' => q(คูนาโครเอเชีย),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(กูร์ดเฮติ),
				'other' => q(กูร์ดเฮติ),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(ฟอรินต์ฮังการี),
				'other' => q(ฟอรินต์ฮังการี),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(รูเปียห์อินโดนีเซีย),
				'other' => q(รูเปียห์อินโดนีเซีย),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(ปอนด์ไอริช),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(ปอนด์อิสราเอล),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(นิวเชเกลอิสราเอล),
				'other' => q(นิวเชเกลอิสราเอล),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(รูปีอินเดีย),
				'other' => q(รูปีอินเดีย),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(ดีนาร์อิรัก),
				'other' => q(ดีนาร์อิรัก),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(เรียลอิหร่าน),
				'other' => q(เรียลอิหร่าน),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(โครนาไอซ์แลนด์),
				'other' => q(โครนาไอซ์แลนด์),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(ลีราอิตาลี),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(ดอลลาร์จาเมกา),
				'other' => q(ดอลลาร์จาเมกา),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(ดีนาร์จอร์แดน),
				'other' => q(ดีนาร์จอร์แดน),
			},
		},
		'JPY' => {
			symbol => '¥',
			display_name => {
				'currency' => q(เยนญี่ปุ่น),
				'other' => q(เยนญี่ปุ่น),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(ชิลลิ่งเคนยา),
				'other' => q(ชิลลิ่งเคนยา),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(ซอมคีร์กีซสถาน),
				'other' => q(ซอมคีร์กีซสถาน),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(เรียลกัมพูชา),
				'other' => q(เรียลกัมพูชา),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(ฟรังก์คอโมโรส),
				'other' => q(ฟรังก์คอโมโรส),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(วอนเกาหลีเหนือ),
				'other' => q(วอนเกาหลีเหนือ),
			},
		},
		'KRH' => {
			display_name => {
				'currency' => q(ฮวานเกาหลีใต้ \(1953–1962\)),
			},
		},
		'KRO' => {
			display_name => {
				'currency' => q(วอนเกาหลีใต้ \(1945–1953\)),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(วอนเกาหลีใต้),
				'other' => q(วอนเกาหลีใต้),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(ดีนาร์คูเวต),
				'other' => q(ดีนาร์คูเวต),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(ดอลลาร์หมู่เกาะเคย์แมน),
				'other' => q(ดอลลาร์หมู่เกาะเคย์แมน),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(เทงเจคาซัคสถาน),
				'other' => q(เทงเจคาซัคสถาน),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(กีบลาว),
				'other' => q(กีบลาว),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(ปอนด์เลบานอน),
				'other' => q(ปอนด์เลบานอน),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(รูปีศรีลังกา),
				'other' => q(รูปีศรีลังกา),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(ดอลลาร์ไลบีเรีย),
				'other' => q(ดอลลาร์ไลบีเรีย),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(โลตีเลโซโท),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(ลีตัสลิทัวเนีย),
				'other' => q(ลีตัสลิทัวเนีย),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(ทาโลนัสลิทัวเนีย),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(คอนเวอร์ทิเบิลฟรังก์ลักเซมเบิร์ก),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(ฟรังก์ลักเซมเบิร์ก),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(ไฟแนลเชียลฟรังก์ลักเซมเบิร์ก),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(ลัตส์ลัตเวีย),
				'other' => q(ลัตส์ลัตเวีย),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(รูเบิลลัตเวีย),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(ดีนาร์ลิเบีย),
				'other' => q(ดีนาร์ลิเบีย),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(ดีแรห์มโมร็อกโก),
				'other' => q(ดีแรห์มโมร็อกโก),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(ฟรังก์โมร็อกโก),
			},
		},
		'MCF' => {
			display_name => {
				'currency' => q(ฟรังก์โมนาโก),
			},
		},
		'MDC' => {
			display_name => {
				'currency' => q(บัตรปันส่วนมอลโดวา),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(ลิวมอลโดวา),
				'other' => q(ลิวมอลโดวา),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(อาเรียรีมาลากาซี),
				'other' => q(อาเรียรีมาลากาซี),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(ฟรังก์มาดากัสการ์),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(ดีนาร์มาซิโดเนีย),
				'other' => q(ดีนาร์มาซิโดเนีย),
			},
		},
		'MKN' => {
			display_name => {
				'currency' => q(ดีนาร์มาซิโดเนีย \(1992–1993\)),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(ฟรังก์มาลี),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(จ๊าตพม่า),
				'other' => q(จ๊าตพม่า),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(ทูกริกมองโกเลีย),
				'other' => q(ทูกริกมองโกเลีย),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(ปาตากามาเก๊า),
				'other' => q(ปาตากามาเก๊า),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(อูกียามอริเตเนีย),
				'other' => q(อูกียามอริเตเนีย),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(ลีรามอลตา),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(ปอนด์มอลตา),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(รูปีมอริเชียส),
				'other' => q(รูปีมอริเชียส),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(รูฟิยามัลดีฟส์),
				'other' => q(รูฟิยามัลดีฟส์),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(ควาชามาลาวี),
				'other' => q(ควาชามาลาวี),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(เปโซเม็กซิโก),
				'other' => q(เปโซเม็กซิโก),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(เงินเปโซเม็กซิโก \(1861–1992\)),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(ยูนิแดด ดี อินเวอร์ชั่น เม็กซิโก),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(ริงกิตมาเลเซีย),
				'other' => q(ริงกิตมาเลเซีย),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(เอสคูโดโมซัมบิก),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(เมติคัลโมซัมบิกเก่า),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(เมติคัลโมซัมบิก),
				'other' => q(เมติคัลโมซัมบิก),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(ดอลลาร์นามิเบีย),
				'other' => q(ดอลลาร์นามิเบีย),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(ไนราไนจีเรีย),
				'other' => q(ไนราไนจีเรีย),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(คอร์โดบานิการากัว),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(กอร์โดบานิการากัว),
				'other' => q(กอร์โดบานิการากัว),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(กิลเดอร์เนเธอร์แลนด์),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(โครนนอร์เวย์),
				'other' => q(โครนนอร์เวย์),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(รูปีเนปาล),
				'other' => q(รูปีเนปาล),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(ดอลลาร์นิวซีแลนด์),
				'other' => q(ดอลลาร์นิวซีแลนด์),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(เรียลโอมาน),
				'other' => q(เรียลโอมาน),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(บัลบัวปานามา),
				'other' => q(บัลบัวปานามา),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(อินตีเปรู),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(นูโวซอลเปรู),
				'other' => q(นูโวซอลเปรู),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(ซอลเปรู),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(กีนาปาปัวนิวกินี),
				'other' => q(กีนาปาปัวนิวกินี),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(เปโซฟิลิปปินส์),
				'other' => q(เปโซฟิลิปปินส์),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(รูปีปากีสถาน),
				'other' => q(รูปีปากีสถาน),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(ซลอตีโปแลนด์),
				'other' => q(ซลอตีโปแลนด์),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(ซลอตีโปแลนด์ \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(เอสคูโดโปรตุเกส),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(กวารานีปารากวัย),
				'other' => q(กวารานีปารากวัย),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(เรียลกาตาร์),
				'other' => q(เรียลกาตาร์),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(ดอลลาร์โรดีเซีย),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(ลิวโรมาเนียเก่า),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(ลิวโรมาเนีย),
				'other' => q(ลิวโรมาเนีย),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(ดีนาร์เซอร์เบีย),
				'other' => q(ดีนาร์เซอร์เบีย),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(รูเบิลรัสเซีย),
				'other' => q(รูเบิลรัสเซีย),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(รูเบิลรัสเซีย \(1991–1998\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(ฟรังก์รวันดา),
				'other' => q(ฟรังก์รวันดา),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(ริยัลซาอุดีอาระเบีย),
				'other' => q(ริยัลซาอุดีอาระเบีย),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(ดอลลาร์หมู่เกาะโซโลมอน),
				'other' => q(ดอลลาร์หมู่เกาะโซโลมอน),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(รูปีเซเชลส์),
				'other' => q(รูปีเซเชลส์),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(ดีนาร์ซูดานเก่า),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(ปอนด์ซูดาน),
				'other' => q(ปอนด์ซูดาน),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(ปอนด์ซูดานเก่า),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(โครนาสวีเดน),
				'other' => q(โครนาสวีเดน),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(ดอลลาร์สิงคโปร์),
				'other' => q(ดอลลาร์สิงคโปร์),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(ปอนด์เซนต์เฮเลนา),
				'other' => q(ปอนด์เซนต์เฮเลนา),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(ทอลาร์สโลวีเนีย),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(โครูนาสโลวัก),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(ลีโอนเซียร์ราลีโอน),
				'other' => q(ลีโอนเซียร์ราลีโอน),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(ชิลลิงโซมาเลีย),
				'other' => q(ชิลลิงโซมาเลีย),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(ดอลลาร์ซูรินาเม),
				'other' => q(ดอลลาร์ซูรินาเม),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(กิลเดอร์ซูรินาเม),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(ปอนด์ซูดานใต้),
				'other' => q(ปอนด์ซูดานใต้),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(ดอบราเซาตูเมและปรินซิปี),
				'other' => q(ดอบราเซาตูเมและปรินซิปี),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(รูเบิลโซเวียต),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(โคลอนเอลซัลวาดอร์),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(ปอนด์ซีเรีย),
				'other' => q(ปอนด์ซีเรีย),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(ลิลันเจนีสวาซิ),
				'other' => q(ลิลันเจนีสวาซิ),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(บาทไทย),
				'other' => q(บาทไทย),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(รูเบิลทาจิกิสถาน),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(โซโมนิทาจิกิสถาน),
				'other' => q(โซโมนิทาจิกิสถาน),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(มานัตเติร์กเมนิสถาน \(1993–2009\)),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(มานัตเติร์กเมนิสถาน),
				'other' => q(มานัตเติร์กเมนิสถาน),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(ดีนาร์ตูนิเซีย),
				'other' => q(ดีนาร์ตูนิเซีย),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(พาแองกาตองกา),
				'other' => q(พาแองกาตองกา),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(เอสคูโดติมอร์),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(ลีราตุรกีเก่า),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(ลีราตุรกี),
				'other' => q(ลีราตุรกี),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ดอลลาร์ตรินิแดดและโตเบโก),
				'other' => q(ดอลลาร์ตรินิแดดและโตเบโก),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(ดอลลาร์ไต้หวันใหม่),
				'other' => q(ดอลลาร์ไต้หวันใหม่),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(ชิลลิงแทนซาเนีย),
				'other' => q(ชิลลิงแทนซาเนีย),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(ฮรีฟเนียยูเครน),
				'other' => q(ฮรีฟเนียยูเครน),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(คาร์โบวาเนตซ์ยูเครน),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(ชิลลิงยูกันดา \(1966–1987\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(ชิลลิงยูกันดา),
				'other' => q(ชิลลิงยูกันดา),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(ดอลลาร์สหรัฐ),
				'other' => q(ดอลลาร์สหรัฐ),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(ดอลลาร์สหรัฐ \(วันถัดไป\)),
				'other' => q(ดอลลาร์สหรัฐ \(วันถัดไป\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(ดอลลาร์สหรัฐ \(วันเดียวกัน\)),
				'other' => q(ดอลลาร์สหรัฐ \(วันเดียวกัน\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(เปโซเอนยูนิแดดเซสอินเด็กซาแดสอุรุกวัย),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(เปโซอุรุกวัย \(1975–1993\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(เปโซอุรุกวัย),
				'other' => q(เปโซอุรุกวัย),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(ซอมอุซเบกิสถาน),
				'other' => q(ซอมอุซเบกิสถาน),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(โบลิวาร์เวเนซุเอลา \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(โบลิวาร์เวเนซุเอลา),
				'other' => q(โบลิวาร์เวเนซุเอลา),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ดองเวียดนาม),
				'other' => q(ดองเวียดนาม),
			},
		},
		'VNN' => {
			display_name => {
				'currency' => q(ดองเวียดนาม \(1978–1985\)),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(วาตูวานูอาตู),
				'other' => q(วาตูวานูอาตู),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(ทาลาซามัว),
				'other' => q(ทาลาซามัว),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(ฟรังก์เซฟาธนาคารรัฐแอฟริกากลาง),
				'other' => q(ฟรังก์เซฟาธนาคารรัฐแอฟริกากลาง),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(เงิน),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(ทอง),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(หน่วยคอมโพสิตยุโรป),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(หน่วยโมเนทารียุโรป),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(หน่วยบัญชียุโรป [XBC]),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(หน่วยบัญชียุโรป [XBD]),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(ดอลลาร์แคริบเบียนตะวันออก),
				'other' => q(ดอลลาร์แคริบเบียนตะวันออก),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(สิทธิถอนเงินพิเศษ),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(หน่วยสกุลเงินยุโรป),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(ฟรังก์ทองฝรั่งเศส),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(ฟรังก์ยูไอซีฝรั่งเศส),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(ฟรังก์เซฟาธนาคารกลางรัฐแอฟริกาตะวันตก),
				'other' => q(ฟรังก์เซฟาธนาคารกลางรัฐแอฟริกาตะวันตก),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(พัลเลเดียม),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(ฟรังก์ซีเอฟพี),
				'other' => q(ฟรังก์ซีเอฟพี),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(แพลตินัม),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(กองทุนไรเน็ต),
			},
		},
		'XSU' => {
			display_name => {
				'currency' => q(ซูเกร),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(รหัสทดสอบสกุลเงิน),
			},
		},
		'XUA' => {
			display_name => {
				'currency' => q(หน่วยบัญชี เอดีบี),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(สกุลเงินที่ไม่รู้จัก),
				'other' => q(\(สกุลเงินที่ไม่รู้จัก\)),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(ดีนาร์เยเมน),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(เรียลเยเมน),
				'other' => q(เรียลเยเมน),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(ฮาร์ดดีนาร์ยูโกสลาเวีย),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(โนวิย์ดีนาร์ยูโกสลาเวีย),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(คอนเวอร์ทิเบิลดีนาร์ยูโกสลาเวีย),
			},
		},
		'YUR' => {
			display_name => {
				'currency' => q(ดีนาร์ปฏิรูปยูโกสลาเวีย \(1992–1993\)),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(แรนด์แอฟริกาใต้ \(การเงิน\)),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(แรนด์แอฟริกาใต้),
				'other' => q(แรนด์แอฟริกาใต้),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(ควาชาแซมเบีย \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(ควาชาแซมเบีย),
				'other' => q(ควาชาแซมเบีย),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(นิวแซร์คองโก),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(แซร์คองโก),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(ดอลลาร์ซิมบับเว),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(ดอลลาร์ซิมบับเว \(2009\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(ดอลลาร์ซิมบับเว \(2008\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'chinese' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
				},
			},
			'coptic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'เทาท์',
							'บาบา',
							'ฮาเทอร์',
							'เคียฟ',
							'โทบา',
							'อัมเชอร์',
							'บารัมฮัท',
							'บาราเมาดา',
							'บาชันส์',
							'พาโอนา',
							'อีเปป',
							'เมสรา',
							'นาซี'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'เทาท์',
							'บาบา',
							'ฮาเทอร์',
							'เคียฟ',
							'โทบา',
							'อัมเชอร์',
							'บารัมฮัท',
							'บาราเมาดา',
							'บาชันส์',
							'พาโอนา',
							'อีเปป',
							'เมสรา',
							'นาซี'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'เทาท์',
							'บาบา',
							'ฮาเทอร์',
							'เคียฟ',
							'โทบา',
							'อัมเชอร์',
							'บารัมฮัท',
							'บาราเมาดา',
							'บาชันส์',
							'พาโอนา',
							'อีเปป',
							'เมสรา',
							'นาซี'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'เทาท์',
							'บาบา',
							'ฮาเทอร์',
							'เคียฟ',
							'โทบา',
							'อัมเชอร์',
							'บารัมฮัท',
							'บาราเมาดา',
							'บาชันส์',
							'พาโอนา',
							'อีเปป',
							'เมสรา',
							'นาซี'
						],
						leap => [
							
						],
					},
				},
			},
			'dangi' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'เมสเคอเรม',
							'เตเกมท',
							'เฮดาร์',
							'ทาฮ์ซัส',
							'เทอร์',
							'เยคาทิท',
							'เมกาบิต',
							'เมียเซีย',
							'เจนบอต',
							'เซเน',
							'ฮัมเล',
							'เนแฮซ',
							'พากูเมน'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'เมสเคอเรม',
							'เตเกมท',
							'เฮดาร์',
							'ทาฮ์ซัส',
							'เทอร์',
							'เยคาทิท',
							'เมกาบิต',
							'เมียเซีย',
							'เจนบอต',
							'เซเน',
							'ฮัมเล',
							'เนแฮซ',
							'พากูเมน'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'เมสเคอเรม',
							'เตเกมท',
							'เฮดาร์',
							'ทาฮ์ซัส',
							'เทอร์',
							'เยคาทิท',
							'เมกาบิต',
							'เมียเซีย',
							'เจนบอต',
							'เซเน',
							'ฮัมเล',
							'เนแฮซ',
							'พากูเมน'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'เมสเคอเรม',
							'เตเกมท',
							'เฮดาร์',
							'ทาฮ์ซัส',
							'เทอร์',
							'เยคาทิท',
							'เมกาบิต',
							'เมียเซีย',
							'เจนบอต',
							'เซเน',
							'ฮัมเล',
							'เนแฮซ',
							'พากูเมน'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ม.ค.',
							'ก.พ.',
							'มี.ค.',
							'เม.ย.',
							'พ.ค.',
							'มิ.ย.',
							'ก.ค.',
							'ส.ค.',
							'ก.ย.',
							'ต.ค.',
							'พ.ย.',
							'ธ.ค.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'มกราคม',
							'กุมภาพันธ์',
							'มีนาคม',
							'เมษายน',
							'พฤษภาคม',
							'มิถุนายน',
							'กรกฎาคม',
							'สิงหาคม',
							'กันยายน',
							'ตุลาคม',
							'พฤศจิกายน',
							'ธันวาคม'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ม.ค.',
							'ก.พ.',
							'มี.ค.',
							'เม.ย.',
							'พ.ค.',
							'มิ.ย.',
							'ก.ค.',
							'ส.ค.',
							'ก.ย.',
							'ต.ค.',
							'พ.ย.',
							'ธ.ค.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ม.ค.',
							'ก.พ.',
							'มี.ค.',
							'เม.ย.',
							'พ.ค.',
							'มิ.ย.',
							'ก.ค.',
							'ส.ค.',
							'ก.ย.',
							'ต.ค.',
							'พ.ย.',
							'ธ.ค.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'มกราคม',
							'กุมภาพันธ์',
							'มีนาคม',
							'เมษายน',
							'พฤษภาคม',
							'มิถุนายน',
							'กรกฎาคม',
							'สิงหาคม',
							'กันยายน',
							'ตุลาคม',
							'พฤศจิกายน',
							'ธันวาคม'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ทิชรี',
							'เฮวาน',
							'กีสเลฟ',
							'เตเวต',
							'เชวัต',
							'อาดาร์ I',
							'อาดาร์',
							'นิสซาน',
							'อิยาร์',
							'สีวัน',
							'ตามูซ',
							'อัฟ',
							'เอลอุล'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'อาดาร์ II'
						],
					},
					wide => {
						nonleap => [
							'ทิชรี',
							'เฮวาน',
							'กีสเลฟ',
							'เตเวต',
							'เชวัต',
							'อาดาร์ I',
							'อาดาร์',
							'นิสซาน',
							'อิยาร์',
							'สีวัน',
							'ตามูซ',
							'อัฟ',
							'เอลอุล'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'อาดาร์ II'
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ทิชรี',
							'เฮวาน',
							'กีสเลฟ',
							'เตเวต',
							'เชวัต',
							'อาดาร์ I',
							'อาดาร์',
							'นิสซาน',
							'อิยาร์',
							'สีวัน',
							'ตามูซ',
							'อัฟ',
							'เอลอุล'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'อาดาร์ II'
						],
					},
					wide => {
						nonleap => [
							'ทิชรี',
							'เฮวาน',
							'กีสเลฟ',
							'เตเวต',
							'เชวัต',
							'อาดาร์ I',
							'อาดาร์',
							'นิสซาน',
							'อิยาร์',
							'สีวัน',
							'ตามูซ',
							'อัฟ',
							'เอลอุล'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'อาดาร์ II'
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'จิตรา',
							'วิสาขา',
							'เชษฐา',
							'อัษฎา',
							'ศรวณา',
							'พัตรา',
							'อัศวิชา',
							'การติกา',
							'มฤคศิรา',
							'ปุษยา',
							'มาฆะ',
							'ผลคุณี'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'จิตรา',
							'วิสาขา',
							'เชษฐา',
							'อัษฎา',
							'ศรวณา',
							'พัตรา',
							'อัศวิชา',
							'การติกา',
							'มฤคศิรา',
							'ปุษยา',
							'มาฆะ',
							'ผลคุณี'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'จิตรา',
							'วิสาขา',
							'เชษฐา',
							'อัษฎา',
							'ศรวณา',
							'พัตรา',
							'อัศวิชา',
							'การติกา',
							'มฤคศิรา',
							'ปุษยา',
							'มาฆะ',
							'ผลคุณี'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'จิตรา',
							'วิสาขา',
							'เชษฐา',
							'อัษฎา',
							'ศรวณา',
							'พัตรา',
							'อัศวิชา',
							'การติกา',
							'มฤคศิรา',
							'ปุษยา',
							'มาฆะ',
							'ผลคุณี'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'มุฮัร.',
							'เศาะ.',
							'รอบี 1',
							'รอบี 2',
							'ญุมา 1',
							'ญุมา 2',
							'เราะ.',
							'ชะอ์.',
							'เราะมะ.',
							'เชาว.',
							'ซุลกิอฺ.',
							'ซุลหิจ.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'มุฮะร์รอม',
							'ซอฟาร์',
							'รอบี I',
							'รอบี II',
							'จุมาดา I',
							'จุมาดา II',
							'รอจับ',
							'ชะอะบาน',
							'รอมะดอน',
							'เชาวัล',
							'ดฮุุอัลกิดะห์',
							'ดฮุอัลฮิจจะห์'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'มุฮัร.',
							'เศาะ.',
							'รอบี 1',
							'รอบี 2',
							'ญุมา 1',
							'ญุมา 2',
							'เราะ.',
							'ชะอ์.',
							'เราะมะ.',
							'เชาว.',
							'ซุลกิอฺ.',
							'ซุลหิจ.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'มุฮะร์รอม',
							'ซอฟาร์',
							'รอบี I',
							'รอบี II',
							'จุมาดา I',
							'จุมาดา II',
							'รอจับ',
							'ชะอะบาน',
							'รอมะดอน',
							'เชาวัล',
							'ดฮุุอัลกิดะห์',
							'ดฮุอัลฮิจจะห์'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ฟาร์วาร์ดิน',
							'ออร์ดิเบเฮชต์',
							'คอร์แดด',
							'เตอร์',
							'มอร์แดด',
							'ชาหริวาร์',
							'เมฮร์',
							'อะบาน',
							'อะซาร์',
							'เดย์',
							'บาฮ์มาน',
							'เอสฟานด์'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ฟาร์วาร์ดิน',
							'ออร์ดิเบเฮชต์',
							'คอร์แดด',
							'เตอร์',
							'มอร์แดด',
							'ชาหริวาร์',
							'เมฮร์',
							'อะบาน',
							'อะซาร์',
							'เดย์',
							'บาฮ์มาน',
							'เอสฟานด์'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ฟาร์วาร์ดิน',
							'ออร์ดิเบเฮชต์',
							'คอร์แดด',
							'เตอร์',
							'มอร์แดด',
							'ชาหริวาร์',
							'เมฮร์',
							'อะบาน',
							'อะซาร์',
							'เดย์',
							'บาฮ์มาน',
							'เอสฟานด์'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ฟาร์วาร์ดิน',
							'ออร์ดิเบเฮชต์',
							'คอร์แดด',
							'เตอร์',
							'มอร์แดด',
							'ชาหริวาร์',
							'เมฮร์',
							'อะบาน',
							'อะซาร์',
							'เดย์',
							'บาฮ์มาน',
							'เอสฟานด์'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'จ.',
						tue => 'อ.',
						wed => 'พ.',
						thu => 'พฤ.',
						fri => 'ศ.',
						sat => 'ส.',
						sun => 'อา.'
					},
					narrow => {
						mon => 'จ',
						tue => 'อ',
						wed => 'พ',
						thu => 'พฤ',
						fri => 'ศ',
						sat => 'ส',
						sun => 'อา'
					},
					short => {
						mon => 'จ.',
						tue => 'อ.',
						wed => 'พ.',
						thu => 'พฤ.',
						fri => 'ศ.',
						sat => 'ส.',
						sun => 'อา.'
					},
					wide => {
						mon => 'วันจันทร์',
						tue => 'วันอังคาร',
						wed => 'วันพุธ',
						thu => 'วันพฤหัสบดี',
						fri => 'วันศุกร์',
						sat => 'วันเสาร์',
						sun => 'วันอาทิตย์'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'จ.',
						tue => 'อ.',
						wed => 'พ.',
						thu => 'พฤ.',
						fri => 'ศ.',
						sat => 'ส.',
						sun => 'อา.'
					},
					narrow => {
						mon => 'จ',
						tue => 'อ',
						wed => 'พ',
						thu => 'พฤ',
						fri => 'ศ',
						sat => 'ส',
						sun => 'อา'
					},
					short => {
						mon => 'จ.',
						tue => 'อ.',
						wed => 'พ.',
						thu => 'พฤ.',
						fri => 'ศ.',
						sat => 'ส.',
						sun => 'อา.'
					},
					wide => {
						mon => 'วันจันทร์',
						tue => 'วันอังคาร',
						wed => 'วันพุธ',
						thu => 'วันพฤหัสบดี',
						fri => 'วันศุกร์',
						sat => 'วันเสาร์',
						sun => 'วันอาทิตย์'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ไตรมาส 1',
						1 => 'ไตรมาส 2',
						2 => 'ไตรมาส 3',
						3 => 'ไตรมาส 4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'ไตรมาส 1',
						1 => 'ไตรมาส 2',
						2 => 'ไตรมาส 3',
						3 => 'ไตรมาส 4'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'ไตรมาส 1',
						1 => 'ไตรมาส 2',
						2 => 'ไตรมาส 3',
						3 => 'ไตรมาส 4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'ไตรมาส 1',
						1 => 'ไตรมาส 2',
						2 => 'ไตรมาส 3',
						3 => 'ไตรมาส 4'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'pm' => q{หลังเที่ยง},
					'am' => q{ก่อนเที่ยง},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'พ.ศ.'
			},
			wide => {
				'0' => 'พุทธศักราช'
			},
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'dangi' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ปีก่อน ค.ศ.',
				'1' => 'ค.ศ.'
			},
			narrow => {
				'0' => 'ก่อน ค.ศ.',
				'1' => 'ค.ศ.'
			},
			wide => {
				'0' => 'ปีก่อนคริสต์ศักราช',
				'1' => 'คริสต์ศักราช'
			},
		},
		'hebrew' => {
			abbreviated => {
				'0' => 'ย.ศ.'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'ม.ศ.'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'ฮ.ศ.'
			},
			wide => {
				'0' => 'ฮิจเราะห์ศักราช'
			},
		},
		'japanese' => {
			abbreviated => {
				'0' => 'ทะอิกะ (645-650)',
				'1' => 'ฮะกุชิ (650-671)',
				'2' => 'ฮากุโฮ (672-686)',
				'3' => 'ชุโช (686-701)',
				'4' => 'ทะอิโฮ (701-704)',
				'5' => 'เคอุง (704-708)',
				'6' => 'วะโด (708-715)',
				'7' => 'เรกิ (715-717)',
				'8' => 'โยโร (717-724)',
				'9' => 'จิงกิ (724-729)',
				'10' => 'เท็มเพียว (729-749)',
				'11' => 'เท็มเพียว-คัมโป (749-749)',
				'12' => 'เท็มเพียว-โชโฮ (749-757)',
				'13' => 'เท็มเพียว-โฮจิ (757-765)',
				'14' => 'เท็มเพียว-จิงโงะ (765-767)',
				'15' => 'จิงโงะ-เคอุง (767-770)',
				'16' => 'โฮกิ (770-780)',
				'17' => 'เท็นโอ (781-782)',
				'18' => 'เอ็นเรียะกุ (782-806)',
				'19' => 'ดะอิโด (806-810)',
				'20' => 'โคนิง (810-824)',
				'21' => 'เท็นโช (824-834)',
				'22' => 'โชวะ (834-848)',
				'23' => 'คะโจ (848-851)',
				'24' => 'นินจุ (851-854)',
				'25' => 'ซะอิโกะ (854-857)',
				'26' => 'เท็นนัง (857-859)',
				'27' => 'โจงัง (859-877)',
				'28' => 'เก็งเก (877-885)',
				'29' => 'นินนะ (885-889)',
				'30' => 'คัมเพียว (889-898)',
				'31' => 'โชตะอิ (898-901)',
				'32' => 'เอ็งงิ (901-923)',
				'33' => 'เอ็นโช (923-931)',
				'34' => 'โชเฮ (931-938)',
				'35' => 'เท็งเงียว (938-947)',
				'36' => 'เท็นเรียะกุ (947-957)',
				'37' => 'เท็นโตะกุ (957-961)',
				'38' => 'โอวะ (961-964)',
				'39' => 'โคโฮ (964-968)',
				'40' => 'อันนะ (968-970)',
				'41' => 'เท็นโระกุ (970-973)',
				'42' => 'เท็นเอ็ง (973-976)',
				'43' => 'โจเง็ง (976-978)',
				'44' => 'เท็งเง็ง (978-983)',
				'45' => 'เอกัง (983-985)',
				'46' => 'คันนะ (985-987)',
				'47' => 'เอเอ็ง (987-989)',
				'48' => 'เอโซ (989-990)',
				'49' => 'โชเรียะกุ (990-995)',
				'50' => 'โชโตะกุ (995-999)',
				'51' => 'โชโฮ (999-1004)',
				'52' => 'คันโก (1004-1012)',
				'53' => 'โชวะ (1012-1017)',
				'54' => 'คันนิง (1017-1021)',
				'55' => 'จิอัง (1021-1024)',
				'56' => 'มันจุ (1024-1028)',
				'57' => 'โชเง็ง (1028-1037)',
				'58' => 'โชเรียะกุ (1037-1040)',
				'59' => 'โชคีว (1040-1044)',
				'60' => 'คันโตะกุ (1044-1046)',
				'61' => 'เอโช (1046-1053)',
				'62' => 'เท็งงิ (1053-1058)',
				'63' => 'โคเฮ (1058-1065)',
				'64' => 'จิเรียะกุ (1065-1069)',
				'65' => 'เอ็งคีว (1069-1074)',
				'66' => 'โชโฮ (1074-1077)',
				'67' => 'โชเรียะกุ (1077-1081)',
				'68' => 'เอโฮะ (1081-1084)',
				'69' => 'โอโตะกุ (1084-1087)',
				'70' => 'คันจิ (1087-1094)',
				'71' => 'คะโฮะ (1094-1096)',
				'72' => 'เอโช (1096-1097)',
				'73' => 'โชโตะกุ (1097-1099)',
				'74' => 'โควะ (1099-1104)',
				'75' => 'โชจิ (1104-1106)',
				'76' => 'คะโช (1106-1108)',
				'77' => 'เท็นนิง (1108-1110)',
				'78' => 'เท็นเอ (1110-1113)',
				'79' => 'เอกีว (1113-1118)',
				'80' => 'เก็นเอ (1118-1120)',
				'81' => 'โฮะอัง (1120-1124)',
				'82' => 'เท็นจิ (1124-1126)',
				'83' => 'ดะอิจิ (1126-1131)',
				'84' => 'เท็นโช (1131-1132)',
				'85' => 'โชโช (1132-1135)',
				'86' => 'โฮะเอ็ง (1135-1141)',
				'87' => 'เอจิ (1141-1142)',
				'88' => 'โคจิ (1142-1144)',
				'89' => 'เท็นโย (1144-1145)',
				'90' => 'คีวอัง (1145-1151)',
				'91' => 'นิมเป (1151-1154)',
				'92' => 'คีวจุ (1154-1156)',
				'93' => 'โฮะเง็ง (1156-1159)',
				'94' => 'เฮจิ (1159-1160)',
				'95' => 'เอเรียะกุ (1160-1161)',
				'96' => 'โอโฮ (1161-1163)',
				'97' => 'โชกัง (1163-1165)',
				'98' => 'เอมัง (1165-1166)',
				'99' => 'นินอัง (1166-1169)',
				'100' => 'คะโอ (1169-1171)',
				'101' => 'โชอัง (1171-1175)',
				'102' => 'อังเง็ง (1175-1177)',
				'103' => 'จิโช (1177-1181)',
				'104' => 'โยวะ (1181-1182)',
				'105' => 'จุเอ (1182-1184)',
				'106' => 'เก็นเรียะกุ (1184-1185)',
				'107' => 'บุนจิ (1185-1190)',
				'108' => 'เค็งกีว (1190-1199)',
				'109' => 'โชจิ (1199-1201)',
				'110' => 'เค็นนิง (1201-1204)',
				'111' => 'เก็งกีว (1204-1206)',
				'112' => 'เค็นเอ (1206-1207)',
				'113' => 'โชเก็ง (1207-1211)',
				'114' => 'เค็นเรียะกุ (1211-1213)',
				'115' => 'เค็มโป (1213-1219)',
				'116' => 'โชกีว (1219-1222)',
				'117' => 'โจโอ (1222-1224)',
				'118' => 'เก็นนิง (1224-1225)',
				'119' => 'คะโระกุ (1225-1227)',
				'120' => 'อันเต (1227-1229)',
				'121' => 'คังกิ (1229-1232)',
				'122' => 'โจเอ (1232-1233)',
				'123' => 'เท็มปุกุ (1233-1234)',
				'124' => 'บุนเรียะกุ (1234-1235)',
				'125' => 'คะเต (1235-1238)',
				'126' => 'เรียะกุนิง (1238-1239)',
				'127' => 'เอ็นโอ (1239-1240)',
				'128' => 'นินจิ (1240-1243)',
				'129' => 'คังเง็ง (1243-1247)',
				'130' => 'โฮจิ (1247-1249)',
				'131' => 'เค็นโช (1249-1256)',
				'132' => 'โคเง็ง (1256-1257)',
				'133' => 'โชกะ (1257-1259)',
				'134' => 'โชเง็ง (1259-1260)',
				'135' => 'บุนโอ (1260-1261)',
				'136' => 'โคโช (1261-1264)',
				'137' => 'บุนเอ (1264-1275)',
				'138' => 'เค็นจิ (1275-1278)',
				'139' => 'โคอัง (1278-1288)',
				'140' => 'โชโอ (1288-1293)',
				'141' => 'เอนิง (1293-1299)',
				'142' => 'โชอัง (1299-1302)',
				'143' => 'เค็งเง็ง (1302-1303)',
				'144' => 'คะเง็ง (1303-1306)',
				'145' => 'โทะกุจิ (1306-1308)',
				'146' => 'เอ็งเก (1308-1311)',
				'147' => 'โอโช (1311-1312)',
				'148' => 'โชวะ (1312-1317)',
				'149' => 'บุมโป (1317-1319)',
				'150' => 'เก็นโอ (1319-1321)',
				'151' => 'เก็งเกียว (1321-1324)',
				'152' => 'โชชู (1324-1326)',
				'153' => 'คะเระกิ (1326-1329)',
				'154' => 'เก็นโตะกุ (1329-1331)',
				'155' => 'เก็งโก (1331-1334)',
				'156' => 'เค็มมุ (1334-1336)',
				'157' => 'เอ็งเง็ง (1336-1340)',
				'158' => 'โคโกะกุ (1340-1346)',
				'159' => 'โชเฮ (1346-1370)',
				'160' => 'เค็นโตะกุ (1370-1372)',
				'161' => 'บุนชู (1372-1375)',
				'162' => 'เท็นจุ (1375-1379)',
				'163' => 'โคเรียะกุ (1379-1381)',
				'164' => 'โควะ (1381-1384)',
				'165' => 'เก็นชู (1384-1392)',
				'166' => 'เมโตะกุ (1384-1387)',
				'167' => 'คะเค (1387-1389)',
				'168' => 'โคโอ (1389-1390)',
				'169' => 'เมโตะกุ (1390-1394)',
				'170' => 'โอเอ (1394-1428)',
				'171' => 'โชโช (1428-1429)',
				'172' => 'เอเกียว (1429-1441)',
				'173' => 'คะกิสึ (1441-1444)',
				'174' => 'บุนอัง (1444-1449)',
				'175' => 'โฮโตะกุ (1449-1452)',
				'176' => 'เคียวโตะกุ (1452-1455)',
				'177' => 'โคโช (1455-1457)',
				'178' => 'โชโระกุ (1457-1460)',
				'179' => 'คันโช (1460-1466)',
				'180' => 'บุนโช (1466-1467)',
				'181' => 'โอนิง (1467-1469)',
				'182' => 'บุมเม (1469-1487)',
				'183' => 'โชเกียว (1487-1489)',
				'184' => 'เอ็นโตะกุ (1489-1492)',
				'185' => 'เมโอ (1492-1501)',
				'186' => 'บุงกิ (1501-1504)',
				'187' => 'เอโช (1504-1521)',
				'188' => 'ทะอิเอ (1521-1528)',
				'189' => 'เคียวโระกุ (1528-1532)',
				'190' => 'เท็มมน (1532-1555)',
				'191' => 'โคจิ (1555-1558)',
				'192' => 'เอโระกุ (1558-1570)',
				'193' => 'เก็งกิ (1570-1573)',
				'194' => 'เท็นโช (1573-1592)',
				'195' => 'บุนโระกุ (1592-1596)',
				'196' => 'เคโช (1596-1615)',
				'197' => 'เก็งวะ (1615-1624)',
				'198' => 'คันเอ (1624-1644)',
				'199' => 'โชโฮ (1644-1648)',
				'200' => 'เคอัง (1648-1652)',
				'201' => 'โชโอ (1652-1655)',
				'202' => 'เมเรียะกุ (1655-1658)',
				'203' => 'มันจิ (1658-1661)',
				'204' => 'คัมบุง (1661-1673)',
				'205' => 'เอ็มโป (1673-1681)',
				'206' => 'เท็นวะ (1681-1684)',
				'207' => 'โจเกียว (1684-1688)',
				'208' => 'เก็นโระกุ (1688-1704)',
				'209' => 'โฮเอ (1704-1711)',
				'210' => 'โชโตะกุ (1711-1716)',
				'211' => 'เคียวโฮ (1716-1736)',
				'212' => 'เก็มบุง (1736-1741)',
				'213' => 'คัมโป (1741-1744)',
				'214' => 'เอ็งเกียว (1744-1748)',
				'215' => 'คันเอ็ง (1748-1751)',
				'216' => 'โฮเรียะกุ (1751-1764)',
				'217' => 'เมวะ (1764-1772)',
				'218' => 'อันเอ (1772-1781)',
				'219' => 'เท็มเม (1781-1789)',
				'220' => 'คันเซ (1789-1801)',
				'221' => 'เคียววะ (1801-1804)',
				'222' => 'บุงกะ (1804-1818)',
				'223' => 'บุนเซ (1818-1830)',
				'224' => 'เท็มโป (1830-1844)',
				'225' => 'โคกะ (1844-1848)',
				'226' => 'คะเอ (1848-1854)',
				'227' => 'อันเซ (1854-1860)',
				'228' => 'มันเอ็ง (1860-1861)',
				'229' => 'บุงกีว (1861-1864)',
				'230' => 'เก็นจิ (1864-1865)',
				'231' => 'เคโอ (1865-1868)',
				'232' => 'เมจิ',
				'233' => 'ทะอิโช',
				'234' => 'โชวะ',
				'235' => 'เฮเซ'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'ปีเปอร์เซีย'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'ปีก่อนไต้หวัน',
				'1' => 'ไต้หวัน'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			'full' => q{EEEEที่ d MMMM G y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{d/M/yy},
		},
		'chinese' => {
			'full' => q{EEEE, U MMMM d},
			'long' => q{U MMMM d},
			'medium' => q{U MMM d},
			'short' => q{y-M-d},
		},
		'coptic' => {
		},
		'dangi' => {
			'full' => q{EEEE, U MMMM d},
			'long' => q{U MMMM d},
			'medium' => q{U MMM d},
			'short' => q{y-M-d},
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEEที่ d MMMM G y},
			'long' => q{d MMMM G y},
			'medium' => q{d MMM G y},
			'short' => q{d/M/y G},
		},
		'gregorian' => {
			'full' => q{EEEEที่ d MMMM G y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{d/M/yy},
		},
		'hebrew' => {
			'full' => q{EEEEที่ d MMMM G y},
			'long' => q{d MMMM G y},
			'medium' => q{d MMM G y},
			'short' => q{d/M/y G},
		},
		'indian' => {
		},
		'islamic' => {
			'full' => q{EEEEที่ d MMMM G y},
			'long' => q{d MMMM G y},
			'medium' => q{d MMM G y},
			'short' => q{d/M/y G},
		},
		'japanese' => {
			'full' => q{EEEEที่ d MMMM ปีGที่ y},
			'long' => q{d MMMM ปีG y},
			'medium' => q{d MMM G y},
			'short' => q{d/M/yy G},
		},
		'persian' => {
		},
		'roc' => {
			'full' => q{EEEEที่ d MMMM ปีGที่ y},
			'long' => q{d MMMM ปีG y},
			'medium' => q{d MMM G y},
			'short' => q{d/M/yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'dangi' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{H นาฬิกา mm นาที ss วินาที zzzz},
			'long' => q{H นาฬิกา mm นาที ss วินาที z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'dangi' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			Ed => q{E d},
			Gy => q{G y},
			GyMMM => q{MMM G y},
			GyMMMEd => q{E d MMM G y},
			GyMMMd => q{d MMM G y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E d/M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMMEd => q{E d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			mmss => q{mm:ss},
			ms => q{mm:ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{M/y},
			yyyyMEd => q{E d/M/y},
			yyyyMMM => q{MMM y},
			yyyyMMMEd => q{E d MMM y},
			yyyyMMMM => q{MMMM y},
			yyyyMMMd => q{d MMM y},
			yyyyMd => q{d/M/y},
			yyyyQQQ => q{QQQ y},
			yyyyQQQQ => q{QQQQ y},
		},
		'japanese' => {
			Ed => q{E d},
			Gy => q{G y},
			GyMMM => q{MMM G y},
			GyMMMEd => q{E d MMM G y},
			GyMMMd => q{d MMM G y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{M/GGGGG y},
			yyyyMEd => q{E d/M/GGGGG y},
			yyyyMMM => q{MMM G y},
			yyyyMMMEd => q{E d MMM G y},
			yyyyMMMd => q{d MMM G y},
			yyyyMd => q{d/M/GGGGG y},
			yyyyQQQ => q{QQQ G y},
			yyyyQQQQ => q{QQQQ G y},
		},
		'gregorian' => {
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{MMM G y},
			GyMMMEd => q{E d MMM G y},
			GyMMMd => q{d MMM G y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E d/M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMMEd => q{E d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			mmss => q{mm:ss},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E d MMM y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
		'roc' => {
			Ed => q{E d},
			Gy => q{ปีGที่ y},
			GyMMM => q{MMM G y},
			GyMMMEd => q{E d MMM G y},
			GyMMMd => q{d MMM G y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{ปีGที่ y},
			yyyy => q{ปีGที่ y},
			yyyyM => q{M/GGGGG y},
			yyyyMEd => q{E d/M/GGGGG y},
			yyyyMMM => q{MMM G y},
			yyyyMMMEd => q{E d MMM G y},
			yyyyMMMd => q{d MMM G y},
			yyyyMd => q{d/M/GGGGG y},
			yyyyQQQ => q{QQQ G y},
		},
		'islamic' => {
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			y => q{G y},
		},
		'generic' => {
			Ed => q{E d},
			Gy => q{G y},
			GyMMM => q{MMM G y},
			GyMMMEd => q{E d MMM G y},
			GyMMMd => q{d MMM G y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E d/M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{M/y G},
			yyyyMEd => q{E d/M/y GGGGG},
			yyyyMMM => q{MMM G y},
			yyyyMMMEd => q{E d MMM G y},
			yyyyMMMd => q{d MMM G y},
			yyyyMd => q{d/M/y GGGGG},
			yyyyQQQ => q{QQQ G y},
			yyyyQQQQ => q{QQQQ G y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			H => {
				H => q{H-H},
			},
			Hm => {
				H => q{H:mm-H:mm},
				m => q{H:mm-H:mm},
			},
			Hmv => {
				H => q{H:mm-H:mm v},
				m => q{H:mm-H:mm v},
			},
			Hv => {
				H => q{H-H v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E d - E d/M},
				d => q{E d - E d/M},
			},
			MMM => {
				M => q{LLL-LLL},
			},
			MMMEd => {
				M => q{E d MMM - E d MMM},
				d => q{E d - E d MMM},
			},
			MMMd => {
				M => q{d MMM - d MMM},
				d => q{d - d MMM},
			},
			Md => {
				M => q{d/M - d/M},
				d => q{d/M - d/M},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{h a - h a},
				h => q{h-h a},
			},
			hm => {
				a => q{h:mm a - h:mm a},
				h => q{h:mm-h:mm a},
				m => q{h:mm-h:mm a},
			},
			hmv => {
				a => q{h:mm a - h:mm a v},
				h => q{h:mm-h:mm a v},
				m => q{h:mm-h:mm a v},
			},
			hv => {
				a => q{h a - h a v},
				h => q{h-h a v},
			},
			y => {
				y => q{y-y},
			},
			yM => {
				M => q{M/y - M/y},
				y => q{M/y - M/y},
			},
			yMEd => {
				M => q{E d/M/y - E d/M/y},
				d => q{E d - E d/M/y},
				y => q{E d/M/y - E d/M/y},
			},
			yMMM => {
				M => q{MMM-MMM y},
				y => q{MMM y - MMM y},
			},
			yMMMEd => {
				M => q{E d MMM - E d MMM y},
				d => q{E d - E d MMM y},
				y => q{E d MMM y - E d MMM y},
			},
			yMMMM => {
				M => q{MMMM-MMMM y},
				y => q{MMMM y - MMMM y},
			},
			yMMMd => {
				M => q{d MMM - d MMM y},
				d => q{d-d MMM y},
				y => q{d MMM y - d MMM y},
			},
			yMd => {
				M => q{d/M/y - d/M/y},
				d => q{d-d/M/y},
				y => q{d/M/y - d/M/y},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm-HH:mm},
				m => q{HH:mm-HH:mm},
			},
			Hmv => {
				H => q{H:mm-H:mm v},
				m => q{H:mm-H:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E d - E d/M},
				d => q{E d - E d/M},
			},
			MMM => {
				M => q{LLL-LLL},
			},
			MMMEd => {
				M => q{E d MMM - E d MMM},
				d => q{E d - E d MMM},
			},
			MMMd => {
				M => q{d MMM - d MMM},
				d => q{d - d MMM},
			},
			Md => {
				M => q{d/M - d/M},
				d => q{d/M - d/M},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a - h a},
				h => q{h-h a},
			},
			hm => {
				a => q{h:mm a - h:mm a},
				h => q{h:mm-h:mm a},
				m => q{h:mm-h:mm a},
			},
			hmv => {
				a => q{h:mm a - h:mm a v},
				h => q{h:mm-h:mm a v},
				m => q{h:mm-h:mm a v},
			},
			hv => {
				a => q{h a - h a v},
				h => q{h-h a v},
			},
			y => {
				y => q{y-y},
			},
			yM => {
				M => q{M/y - M/y},
				y => q{M/y - M/y},
			},
			yMEd => {
				M => q{E d/M/y - E d/M/y},
				d => q{E d - E d/M/y},
				y => q{E d/M/y - E d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y - MMM y},
			},
			yMMMEd => {
				M => q{E d MMM - E d MMM y},
				d => q{E d - E d MMM y},
				y => q{E d MMM y - E d MMM y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y - MMMM y},
			},
			yMMMd => {
				M => q{d MMM - d MMM y},
				d => q{d-d MMM y},
				y => q{d MMM y - d MMM y},
			},
			yMd => {
				M => q{d/M/y - d/M/y},
				d => q{d-d/M/y},
				y => q{d/M/y - d/M/y},
			},
		},
		'generic' => {
			H => {
				H => q{H-H},
			},
			Hm => {
				H => q{HH:mm-HH:mm},
				m => q{HH:mm-HH:mm},
			},
			Hmv => {
				H => q{H:mm-H:mm v},
				m => q{H:mm-H:mm v},
			},
			Hv => {
				H => q{H-H v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E d/M - E d/M},
				d => q{E d - E d/M},
			},
			MMM => {
				M => q{LLL-LLL},
			},
			MMMEd => {
				M => q{E d MMM - E d MMM},
				d => q{E d MMM - E d MMM},
			},
			MMMd => {
				M => q{d MMM - d MMM},
				d => q{d - d MMM},
			},
			Md => {
				M => q{d/M - d/M},
				d => q{d/M - d/M},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{h a - h a},
				h => q{h-h a},
			},
			hm => {
				a => q{h:mm a - h:mm a},
				h => q{h:mm-h:mm a},
				m => q{h:mm-h:mm a},
			},
			hmv => {
				a => q{h:mm a - h:mm a v},
				h => q{h:mm-h:mm a v},
				m => q{h:mm-h:mm a v},
			},
			hv => {
				a => q{h a - h a v},
				h => q{h-h a v},
			},
			y => {
				y => q{G y-y},
			},
			yM => {
				M => q{M/y - M/y G},
				y => q{M/y - M/y G},
			},
			yMEd => {
				M => q{E d/M/y - E d/M/y G},
				d => q{E d - E d/M/y G},
				y => q{E d/M/y - E d/M/y G},
			},
			yMMM => {
				M => q{MMM-MMM G y},
				y => q{MMM y - MMM G y},
			},
			yMMMEd => {
				M => q{E d MMM - E d MMM G y},
				d => q{E d - E d MMM G y},
				y => q{E d MMM y - E d MMM G y},
			},
			yMMMM => {
				M => q{MMMM – MMMM G y},
				y => q{MMMM y - MMMM G y},
			},
			yMMMd => {
				M => q{d MMM - d MMM G y},
				d => q{d-d MMM G y},
				y => q{d MMM y - d MMM G y},
			},
			yMd => {
				M => q{d/M/y - d/M/y G},
				d => q{d-d/M/y G},
				y => q{d/M/y - d/M/y G},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(เวลา{0}),
		regionFormat => q(เวลาออมแสง{0}),
		regionFormat => q(เวลามาตรฐาน{0}),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนอาเกร),
				'generic' => q(เวลาอาเกร),
				'standard' => q(เวลามาตรฐานอาเกร),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(เวลาอัฟกานิสถาน),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#อาบีจาน#,
		},
		'Africa/Accra' => {
			exemplarCity => q#อักกรา#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#แอดดิสอาบาบา#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#แอลเจียร์#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#แอสมารา#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#บามาโก#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#บังกี#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#บันจูล#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#บิสเซา#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#แบลนไทร์#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#บราซซาวิล#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#บูจุมบูรา#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#ไคโร#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#คาสซาบลางก้า#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#เซวตา#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#โกนากรี#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ดาการ์#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ดาร์เอสซาลาม#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#จิบูตี#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ดูอาลา#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#เอลไอย์อุง#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ฟรีทาวน์#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#กาโบโรเน#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ฮาราเร#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#โจฮันเนสเบอร์ก#,
		},
		'Africa/Juba' => {
			exemplarCity => q#จูบา#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#คัมพาลา#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#คาร์ทูม#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#คิกาลี#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#กินชาซา#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ลากอส#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ลีเบรอวิล#,
		},
		'Africa/Lome' => {
			exemplarCity => q#โลเม#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ลูอันดา#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ลูบัมบาชิ#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ลูซากา#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#มาลาโบ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#มาปูโต#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#มาเซรู#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#อัมบาบาเน#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#โมกาดิชู#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#มันโรเวีย#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#ไนโรเบีย#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#เอ็นจาเมนา#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#นีอาเมย์#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#นูแอกชอต#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#วากาดูกู#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#ปอร์โต-โนโว#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#เซาตูเม#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ตรีโปลี#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ตูนิส#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#วินด์ฮุก#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(เวลาแอฟริกากลาง),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(เวลาแอฟริกาตะวันออก),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(เวลาแอฟริกาใต้),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนแอฟริกาตะวันตก),
				'generic' => q(เวลาแอฟริกาตะวันตก),
				'standard' => q(เวลามาตรฐานแอฟริกาตะวันตก),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(เวลาออมแสงของอะแลสกา),
				'generic' => q(เวลาอะแลสกา),
				'standard' => q(เวลามาตรฐานอะแลสกา),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนอัลมาตี),
				'generic' => q(เวลาอัลมาตี),
				'standard' => q(เวลามาตรฐานอัลมาตี),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนอะเมซอน),
				'generic' => q(เวลาอะเมซอน),
				'standard' => q(เวลามาตรฐานอะเมซอน),
			},
		},
		'America/Adak' => {
			exemplarCity => q#เอดัก#,
		},
		'America/Anchorage' => {
			exemplarCity => q#แองเคอเรจ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#แองกิลลา#,
		},
		'America/Antigua' => {
			exemplarCity => q#แอนติกา#,
		},
		'America/Araguaina' => {
			exemplarCity => q#อารากัวนา#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ลาริโอจา#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ริโอกาลเลกอส#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#ซัลตา#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#ซานฮวน#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#ซันลูอิส#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ทูคูแมน#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#อูชูเอีย#,
		},
		'America/Aruba' => {
			exemplarCity => q#อารูบา#,
		},
		'America/Asuncion' => {
			exemplarCity => q#อะซุนซิออง#,
		},
		'America/Bahia' => {
			exemplarCity => q#บาเยีย#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#บาเอียบันเดรัส#,
		},
		'America/Barbados' => {
			exemplarCity => q#บาร์เบโดส#,
		},
		'America/Belem' => {
			exemplarCity => q#เบเลง#,
		},
		'America/Belize' => {
			exemplarCity => q#เบลีซ#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#บลังค์-ซาบลอน#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#บัววีชตา#,
		},
		'America/Bogota' => {
			exemplarCity => q#โบโกตา#,
		},
		'America/Boise' => {
			exemplarCity => q#บอยซี#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#บัวโนสไอเรส#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#อ่าวแคมบริดจ์#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#กัมปูกรันดี#,
		},
		'America/Cancun' => {
			exemplarCity => q#แคนคุน#,
		},
		'America/Caracas' => {
			exemplarCity => q#คาราคัส#,
		},
		'America/Catamarca' => {
			exemplarCity => q#กาตามาร์กา#,
		},
		'America/Cayenne' => {
			exemplarCity => q#กาแยน#,
		},
		'America/Cayman' => {
			exemplarCity => q#เคย์แมน#,
		},
		'America/Chicago' => {
			exemplarCity => q#ชิคาโก#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ชีวาวา#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#คอรัลฮาร์เบอร์#,
		},
		'America/Cordoba' => {
			exemplarCity => q#คอร์โดบา#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#คอสตาริกา#,
		},
		'America/Creston' => {
			exemplarCity => q#เครสตัน#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#กุยาบา#,
		},
		'America/Curacao' => {
			exemplarCity => q#คูราเซา#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ดานมาร์กสฮาวน์#,
		},
		'America/Dawson' => {
			exemplarCity => q#ดอว์สัน#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ดอว์สัน ครีก#,
		},
		'America/Denver' => {
			exemplarCity => q#เดนเวอร์#,
		},
		'America/Detroit' => {
			exemplarCity => q#ดีทรอยต์#,
		},
		'America/Dominica' => {
			exemplarCity => q#โดมินิกา#,
		},
		'America/Edmonton' => {
			exemplarCity => q#เอดมันตัน#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#เอรูเนเป#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#เอลซัลวาดอร์#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ฟอร์ตาเลซา#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#แกลซเบย์#,
		},
		'America/Godthab' => {
			exemplarCity => q#กอดแธบ#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#กูสเบย์#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#แกรนด์เติร์ก#,
		},
		'America/Grenada' => {
			exemplarCity => q#เกรนาดา#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#กวาเดอลูป#,
		},
		'America/Guatemala' => {
			exemplarCity => q#กัวเตมาลา#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#กัวยากิล#,
		},
		'America/Guyana' => {
			exemplarCity => q#กายอานา#,
		},
		'America/Halifax' => {
			exemplarCity => q#แฮลิแฟกซ์#,
		},
		'America/Havana' => {
			exemplarCity => q#ฮาวานา#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#เอร์โมซีโย#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#นอกซ์, อินดีแอนา#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#มาเรงโก, อินดีแอนา#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#ปีเตอร์สเบิร์ก, อินดีแอนา#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#เทลล์ซิตี, อินดีแอนา#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#วีเวย์, อินดีแอนา#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#วินเซนเนส, อินดีแอนา#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#วินาแมค, อินดีแอนา#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#อินเดียแนโพลิส#,
		},
		'America/Inuvik' => {
			exemplarCity => q#อินูวิก#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#อีกวาลิต#,
		},
		'America/Jamaica' => {
			exemplarCity => q#จาเมกา#,
		},
		'America/Jujuy' => {
			exemplarCity => q#จูจิว#,
		},
		'America/Juneau' => {
			exemplarCity => q#จูโน#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#มอนติเซลโล, เคนตักกี#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#คราเลนดิจค์#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ลาปาซ#,
		},
		'America/Lima' => {
			exemplarCity => q#ลิมา#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ลอสแองเจลิส#,
		},
		'America/Louisville' => {
			exemplarCity => q#ลูส์วิลล์#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#โลเวอร์พรินซ์ ควอเตอร์#,
		},
		'America/Maceio' => {
			exemplarCity => q#มาเซโอ#,
		},
		'America/Managua' => {
			exemplarCity => q#มานากัว#,
		},
		'America/Manaus' => {
			exemplarCity => q#มาเนาส์#,
		},
		'America/Marigot' => {
			exemplarCity => q#มาริโกต์#,
		},
		'America/Martinique' => {
			exemplarCity => q#มาร์ตินีก#,
		},
		'America/Matamoros' => {
			exemplarCity => q#มาตาโมรอส#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#มาซาทลาน#,
		},
		'America/Mendoza' => {
			exemplarCity => q#เมนดูซา#,
		},
		'America/Menominee' => {
			exemplarCity => q#เมโนมินี#,
		},
		'America/Merida' => {
			exemplarCity => q#เมรีดา#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#เมทลากาตละ#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#เม็กซิโกซิตี#,
		},
		'America/Miquelon' => {
			exemplarCity => q#มีเกอลง#,
		},
		'America/Moncton' => {
			exemplarCity => q#มองตัน#,
		},
		'America/Monterrey' => {
			exemplarCity => q#มอนเตร์เรย์#,
		},
		'America/Montevideo' => {
			exemplarCity => q#มอนเตวิเดโอ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#มอนเซอร์รัต#,
		},
		'America/Nassau' => {
			exemplarCity => q#แนสซอ#,
		},
		'America/New_York' => {
			exemplarCity => q#นิวยอร์ก#,
		},
		'America/Nipigon' => {
			exemplarCity => q#นิปิกอน#,
		},
		'America/Nome' => {
			exemplarCity => q#นอม#,
		},
		'America/Noronha' => {
			exemplarCity => q#โนรอนฮา#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#โบลาห์, นอร์ทดาโคตา#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#เซนเตอร์, นอร์ทดาโคตา#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#นิวเซเลม, นอร์ทดาโคตา#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#โอจินากา#,
		},
		'America/Panama' => {
			exemplarCity => q#ปานามา#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#พางนีทัง#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#ปารามาริโบ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ฟินิกซ์#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#ปอร์โตแปรงซ์#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#พอร์ทออฟสเปน#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#ปอร์ตูเวลโย#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#เปอโตริโก#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#เรนนี่ริเวอร์#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#แรงกินอินเล็ต#,
		},
		'America/Recife' => {
			exemplarCity => q#เรซีเฟ#,
		},
		'America/Regina' => {
			exemplarCity => q#ริไจนา#,
		},
		'America/Resolute' => {
			exemplarCity => q#เรโซลูท#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#รีโอบรังโก#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#ซานตาอิซาเบล#,
		},
		'America/Santarem' => {
			exemplarCity => q#ซันตาเรม#,
		},
		'America/Santiago' => {
			exemplarCity => q#ซันติอาโก#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#ซานโต โดมิงโก#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#เซาเปาลู#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#สกอเรสไบซันด์#,
		},
		'America/Sitka' => {
			exemplarCity => q#ซิตกา#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#เซนต์บาร์เธเลมี#,
		},
		'America/St_Johns' => {
			exemplarCity => q#เซนต์จอนส์#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#เซนต์คิตส์#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#เซนต์ลูเซีย#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#เซนต์โธมัส#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#เซนต์วินเซนต์#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#สวิฟต์เคอร์เรนต์#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#เตกูซิกัลปา#,
		},
		'America/Thule' => {
			exemplarCity => q#ทูเล#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#ทันเดอร์เบย์#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ทิฮัวนา#,
		},
		'America/Toronto' => {
			exemplarCity => q#โทรอนโต#,
		},
		'America/Tortola' => {
			exemplarCity => q#ตอร์โตลา#,
		},
		'America/Vancouver' => {
			exemplarCity => q#แวนคูเวอร์#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ไวต์ฮอร์ส#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#วินนิเพก#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ยากูทัต#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#เยลโลว์ไนฟ์#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(เวลาออมแสงทางตอนกลาง),
				'generic' => q(เวลาตอนกลาง),
				'standard' => q(เวลามาตรฐานตอนกลาง),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(เวลาออมแสงทางตะวันออก),
				'generic' => q(เวลาตะวันออก),
				'standard' => q(เวลามาตรฐานตะวันออก),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(เวลาออมแสงแถบภูเขา),
				'generic' => q(เวลาแถบภูเขา),
				'standard' => q(เวลามาตรฐานแถบภูเขา),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(เวลาออมแสงของแปซิฟิก),
				'generic' => q(เวลาแปซิฟิก),
				'standard' => q(เวลามาตรฐานแปซิฟิก),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนอะนาดีร์),
				'generic' => q(เวลาอะนาดีร์),
				'standard' => q(เวลามาตรฐานอะนาดีร์),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#เคซีย์#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ดาวีส์#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ดูมองต์ดูร์วิลล์#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#แมคควอรี#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#มาว์ซัน#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#แมคมัวโด#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#พาล์เมอร์#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#โรเทรา#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#เซียวา#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#วอสต็อค#,
		},
		'Aqtau' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนอัคตาอู),
				'generic' => q(เวลาอัคตาอู),
				'standard' => q(เวลามาตรฐานอัคตาอู),
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนอัคโทเบ),
				'generic' => q(เวลาอัคโทเบ),
				'standard' => q(เวลามาตรฐานอัคโทเบ),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(เวลาออมแสงอาหรับ),
				'generic' => q(เวลาอาหรับ),
				'standard' => q(เวลามาตรฐานอาหรับ),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ลองเยียร์เบียน#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนอาร์เจนตินา),
				'generic' => q(เวลาอาร์เจนตินา),
				'standard' => q(เวลามาตรฐานอาร์เจนตินา),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนทางตะวันตกของอาร์เจนตินา),
				'generic' => q(เวลาตะวันตกของอาร์เจนตินา),
				'standard' => q(เวลามาตรฐานทางตะวันตกของอาร์เจนตินา),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนอาร์เมเนีย),
				'generic' => q(เวลาอาร์เมเนีย),
				'standard' => q(เวลามาตรฐานอาร์เมเนีย),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#เอเดน#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#อัลมาตี#,
		},
		'Asia/Amman' => {
			exemplarCity => q#อัมมาน#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#อานาดีร์#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#อัคตาอู#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#อัคโทบี#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#อาชกาบัต#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#แบกแดด#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#บาห์เรน#,
		},
		'Asia/Baku' => {
			exemplarCity => q#บากู#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#กรุงเทพ#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#เบรุต#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#บิชเคก#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#บรูไน#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#โกลกาตา#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ชอยบาลซาน#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#ฉงชิ่ง#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#โคลัมโบ#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ดามัสกัส#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ดากา#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ดิลี#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ดูไบ#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ดูชานเบ#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#กาซา#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#ฮาร์บิน#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#เฮบรอน#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ฮ่องกง#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ฮอฟด์#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#อีร์คุตสค์#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#จาการ์ตา#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#จายาปุระ#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#เยรูซาเลม#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#คาบูล#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#คามชัตกา#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#การาจี#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#กัชการ์#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#กาตมันดุ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ฮันดืยกา#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ครัสโนยาร์สก์#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#กัวลาลัมเปอร์#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#กูชิง#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#คูเวต#,
		},
		'Asia/Macau' => {
			exemplarCity => q#มาเก๊า#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#มากาดาน#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#มากัสซาร์#,
		},
		'Asia/Manila' => {
			exemplarCity => q#มะนิลา#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#มัสกัต#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#นิโคเซีย#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#โนโวคุซเนตสค์#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#โนโวซิบิร์สก์#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#โอมสก์#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ออรัล#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#พนมเปญ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#พอนเทียนัก#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#เปียงยาง#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#กาตาร์#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ไคซีลอร์ดา#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#ย่างกุ้ง#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ริยาร์ด#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#นครโฮจิมินห์#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ซาคาลิน#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#ซามาร์กานด์#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#โซล#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#เซี่ยงไฮ้#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#สิงคโปร์#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ไทเป#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ทาชเคนต์#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#ทบิลิซิ#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#เตหะราน#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#ทิมพู#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#โตเกียว#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#อูลานบาตอร์#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#อุรุมชี#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#อุสต์เนรา#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#เวียงจันทน์#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#วลาดิโวสต็อก#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ยาคุตสค์#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#ยีคาเตอรินเบิร์ก#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#เยเรวาน#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(เวลาออมแสงของแอตแลนติก),
				'generic' => q(เวลาแอตแลนติก),
				'standard' => q(เวลามาตรฐานแอตแลนติก),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#อาซอเรส#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#เบอร์มิวดา#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#คะเนรี#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#เคปเวิร์ด#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#แฟโร#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#มาเดรา#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#เรคยาวิก#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#เซาท์ จอร์เจีย#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#เซนต์เฮเลนา#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#สแตนลีย์#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#แอดิเลด#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#บริสเบน#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#โบรกเคนฮิลล์#,
		},
		'Australia/Currie' => {
			exemplarCity => q#คูร์รี#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ดาร์วิน#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ยูคลา#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#โฮบาร์ต#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#ลินดีแมน#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ลอร์ดโฮวี#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#เมลเบิร์น#,
		},
		'Australia/Perth' => {
			exemplarCity => q#เพิิร์ท#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#ซิดนีย์#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(เวลาออมแสงทางตอนกลางของออสเตรเลีย),
				'generic' => q(เวลาออสเตรเลียกลาง),
				'standard' => q(เวลามาตรฐานทางตอนกลางของออสเตรเลีย),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(เวลาออมแสงทางตะวันตกตอนกลางของออสเตรเลีย),
				'generic' => q(เวลาทางตะวันตกตอนกลางของออสเตรเลีย),
				'standard' => q(เวลามาตรฐานทางตะวันตกตอนกลางของออสเตรเลีย),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(เวลาออมแสงทางตะวันออกของออสเตรเลีย),
				'generic' => q(เวลาออสเตรเลียตะวันออก),
				'standard' => q(เวลามาตรฐานทางตะวันออกของออสเตรเลีย),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(เวลาออมแสงทางตะวันตกของออสเตรเลีย),
				'generic' => q(เวลาออสเตรเลียตะวันตก),
				'standard' => q(เวลามาตรฐานทางตะวันตกของออสเตรเลีย),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนอาเซอร์ไบจาน),
				'generic' => q(เวลาอาเซอร์ไบจาน),
				'standard' => q(เวลามาตรฐานอาเซอร์ไบจาน),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนอะโซร์ส),
				'generic' => q(เวลาอะโซร์ส),
				'standard' => q(เวลามาตรฐานอะโซร์ส),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนบังกลาเทศ),
				'generic' => q(เวลาบังกลาเทศ),
				'standard' => q(เวลามาตรฐานบังกลาเทศ),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(เวลาภูฏาน),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(เวลาโบลิเวีย),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนบราซิเลีย),
				'generic' => q(เวลาบราซิเลีย),
				'standard' => q(เวลามาตรฐานบราซิเลีย),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(เวลาบรูไนดารุสซาลาม),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนเคปเวิร์ด),
				'generic' => q(เวลาเคปเวิร์ด),
				'standard' => q(เวลามาตรฐานเคปเวิร์ด),
			},
		},
		'Casey' => {
			long => {
				'standard' => q(เวลาเคซีย์),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(เวลาชามอร์โร),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(เวลาออมแสงแชทัม),
				'generic' => q(เวลาแชทัม),
				'standard' => q(เวลามาตรฐานแชทัม),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนชิลี),
				'generic' => q(เวลาชิลี),
				'standard' => q(เวลามาตรฐานชิลี),
			},
		},
		'China' => {
			long => {
				'daylight' => q(เวลาออมแสงจีน),
				'generic' => q(เวลาจีน),
				'standard' => q(เวลามาตรฐานจีน),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนชอยปาลชาน),
				'generic' => q(เวลาชอยปาลชาน),
				'standard' => q(เวลามาตรฐานชอยปาลชาน),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(เวลาเกาะคริสต์มาส),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(เวลาหมู่เกาะโคโคส),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนโคลอมเบีย),
				'generic' => q(เวลาโคลอมเบีย),
				'standard' => q(เวลามาตรฐานโคลอมเบีย),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(เวลาครึ่งฤดูร้อนหมู่เกาะคุก),
				'generic' => q(เวลาหมู่เกาะคุก),
				'standard' => q(เวลามาตรฐานหมู่เกาะคุก),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(เวลาออมแสงของคิวบา),
				'generic' => q(เวลาคิวบา),
				'standard' => q(เวลามาตรฐานคิวบา),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(เวลาเดวิส),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(เวลาดูมองต์ดูร์วิลล์),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(เวลาติมอร์ตะวันออก),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนเกาะอีสเตอร์),
				'generic' => q(เวลาเกาะอีสเตอร์),
				'standard' => q(เวลามาตรฐานเกาะอีสเตอร์),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(เวลาเอกวาดอร์),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#เมืองที่ไม่รู้จัก#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#อัมสเตอดัม#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#อันดอร์รา#,
		},
		'Europe/Athens' => {
			exemplarCity => q#เอเธนส์#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#เบลเกรด#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#เบอร์ลิน#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#บราติสลาวา#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#บรัสเซลส์#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#บูคาเรส#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#บูดาเปส#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#บุสซิงเง็น#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#คีชีเนา#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#โคเปนเฮเกน#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ดับบลิน#,
			long => {
				'daylight' => q(เวลาฤดูร้อนไอร์แลนด์),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ยิบรอลตาร์#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#เกิร์นซีย์#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#เฮลซิงกิ#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#เกาะแมน#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#อิสตันบูล#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#เจอร์ซีย์#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#คาลินิงกราด#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#เคียฟ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#ลิสบอน#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ลูบลิยานา#,
		},
		'Europe/London' => {
			exemplarCity => q#ลอนดอน#,
			long => {
				'daylight' => q(เวลาฤดูร้อนอังกฤษ),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ลักเซมเบิร์ก#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#มาดริด#,
		},
		'Europe/Malta' => {
			exemplarCity => q#มอลตา#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#มารีฮามน์#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#มินสก์#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#โมนาโก#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#มอสโก#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ออสโล#,
		},
		'Europe/Paris' => {
			exemplarCity => q#ปารีส#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#พอดกอรีตซา#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ปราก#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ริกา#,
		},
		'Europe/Rome' => {
			exemplarCity => q#โรม#,
		},
		'Europe/Samara' => {
			exemplarCity => q#ซามารา#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#ซานมารีโน#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#ซาราเยโว#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#ซิมเฟอโรโปล#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#สโกเปีย#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#โซเฟีย#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#สตอกโฮล์ม#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ทาลลินน์#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ติรานา#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#อัซโกร็อด#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#วาดุซ#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#วาติกัน#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#เวียนนา#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#วิลนีอุส#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#วอลโกกราด#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#วอร์ซอ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ซาเกร็บ#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ซาโปโรซี#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ซูริค#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนยุโรปกลาง),
				'generic' => q(เวลายุโรปกลาง),
				'standard' => q(เวลามาตรฐานยุโรปกลาง),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนยุโรปตะวันออก),
				'generic' => q(เวลายุโรปตะวันออก),
				'standard' => q(เวลามาตรฐานยุโรปตะวันออก),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนยุโรปตะวันตก),
				'generic' => q(เวลายุโรปตะวันตก),
				'standard' => q(เวลามาตรฐานยุโรปตะวันตก),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนหมู่เกาะฟอล์กแลนด์),
				'generic' => q(เวลาหมู่เกาะฟอล์กแลนด์),
				'standard' => q(เวลามาตรฐานหมู่เกาะฟอล์กแลนด์),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนฟิจิ),
				'generic' => q(เวลาฟิจิ),
				'standard' => q(เวลามาตรฐานฟิจิ),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(เวลาเฟรนช์เกียนา),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(เวลาเฟรนช์เซาเทิร์นและแอนตาร์กติก),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(เวลามาตรฐานกรีนิช),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(เวลากาลาปาโกส),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(เวลาแกมเบียร์),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนจอร์เจีย),
				'generic' => q(เวลาจอร์เจีย),
				'standard' => q(เวลามาตรฐานจอร์เจีย),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(เวลาหมู่เกาะกิลเบิร์ต),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนกรีนแลนด์ตะวันออก),
				'generic' => q(เวลากรีนแลนด์ตะวันออก),
				'standard' => q(เวลามาตรฐานกรีนแลนด์ตะวันออก),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนกรีนแลนด์ตะวันตก),
				'generic' => q(เวลากรีนแลนด์ตะวันตก),
				'standard' => q(เวลามาตรฐานกรีนแลนด์ตะวันตก),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(เวลากวม),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(เวลากัลฟ์),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(เวลากายอานา),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(เวลาออมแสงฮาวาย-อะลูเชียน),
				'generic' => q(เวลาฮาวาย-อะลูเชียน),
				'standard' => q(เวลามาตรฐานฮาวาย-อะลูเชียน),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนฮ่องกง),
				'generic' => q(เวลาฮ่องกง),
				'standard' => q(เวลามาตรฐานฮ่องกง),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนฮอฟด์),
				'generic' => q(เวลาฮอฟด์),
				'standard' => q(เวลามาตรฐานฮอฟด์),
			},
		},
		'India' => {
			long => {
				'standard' => q(เวลาอินเดีย),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#อันตานานาริโว#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ชากัส#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#คริสต์มาส#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#โคโคส#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#โคโมโร#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#แกร์เกอลอง#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#มาเอ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#มัลดีฟส์#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#มอริเชียส#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#มาโยเต#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#เรอูนียง#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(เวลามหาสมุทรอินเดีย),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(เวลาอินโดจีน),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(เวลาอินโดนีเซียตอนกลาง),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(เวลาอินโดนีเซียฝั่งตะวันออก),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(เวลาอินโดนีเซียฝั่งตะวันตก),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(เวลาออมแสงอิหร่าน),
				'generic' => q(เวลาอิหร่าน),
				'standard' => q(เวลามาตรฐานอิหร่าน),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนอีร์คุตสค์),
				'generic' => q(เวลาอีร์คุตสค์),
				'standard' => q(เวลามาตรฐานอีร์คุตสค์),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(เวลาออมแสงอิสราเอล),
				'generic' => q(เวลาอิสราเอล),
				'standard' => q(เวลามาตรฐานอิสราเอล),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(เวลาออมแสงญี่ปุ่น),
				'generic' => q(เวลาญี่ปุ่น),
				'standard' => q(เวลามาตรฐานญี่ปุ่น),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนเปโตรปัฟลอฟสค์-คัมชัตสกี),
				'generic' => q(เวลาคัมชัตคา),
				'standard' => q(เวลาเปโตรปัฟลอฟสค์-คัมชัตสกี),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(เวลาคาซัคสถานตะวันออก),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(เวลาคาซัคสถานตะวันตก),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(เวลาออมแสงเกาหลี),
				'generic' => q(เวลาเกาหลี),
				'standard' => q(เวลามาตรฐานเกาหลี),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(เวลาคอสไร),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนครัสโนยาสค์),
				'generic' => q(เวลาครัสโนยาสค์),
				'standard' => q(เวลามาตรฐานครัสโนยาสค์),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(เวลาคีร์กีซสถาน),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(เวลาลังกา),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(เวลาหมู่เกาะไลน์),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(เวลาออมแสงของลอร์ดโฮว์),
				'generic' => q(เวลาลอร์ดโฮว),
				'standard' => q(เวลามาตรฐานลอร์ดโฮว์),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนมาเก๊า),
				'generic' => q(เวลามาเก๊า),
				'standard' => q(เวลามาตรฐานมาเก๊า),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(เวลาเกาะแมกควอรี),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนมากาดาน),
				'generic' => q(เวลามากาดาน),
				'standard' => q(เวลามาตรฐานมากาดาน),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(เวลามาเลเซีย),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(เวลามัลดีฟส์),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(เวลามาร์เคซัส),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(เวลาหมู่เกาะมาร์แชลล์),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนของมอริเชียส),
				'generic' => q(เวลามอริเชียส),
				'standard' => q(เวลามาตรฐานมอริเชียส),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(เวลามอว์สัน),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนอูลานบาตอร์),
				'generic' => q(เวลาอูลานบาตอร์),
				'standard' => q(เวลามาตรฐานอูลานบาตอร์),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนมอสโก),
				'generic' => q(เวลามอสโก),
				'standard' => q(เวลามาตรฐานมอสโก),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(เวลาพม่า),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(เวลานาอูรู),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(เวลาเนปาล),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนนิวแคลิโดเนีย),
				'generic' => q(เวลานิวแคลิโดเนีย),
				'standard' => q(เวลามาตรฐานนิวแคลิโดเนีย),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(เวลาออมแสงนิวซีแลนด์),
				'generic' => q(เวลานิวซีแลนด์),
				'standard' => q(เวลามาตรฐานนิวซีแลนด์),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(เวลาออมแสงนิวฟันด์แลนด์),
				'generic' => q(เวลานิวฟันด์แลนด์),
				'standard' => q(เวลามาตรฐานนิวฟันด์แลนด์),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(เวลานีอูเอ),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(เวลาเกาะนอร์ฟอล์ก),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนของหมู่เกาะเฟอร์นันโด),
				'generic' => q(เวลาหมู่เกาะเฟอร์นันโด),
				'standard' => q(เวลามาตรฐานหมู่เกาะเฟอร์นันโด),
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q(เวลาหมู่เกาะมาเรียนาเหนือ),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนโนโวซีบีสค์),
				'generic' => q(เวลาโนโวซีบีสค์),
				'standard' => q(เวลามาตรฐานโนโวซีบีสค์),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนออมสค์),
				'generic' => q(เวลาออมสค์),
				'standard' => q(เวลามาตรฐานออมสค์),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#อาปีอา#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#โอคแลนด์#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#แชแทม#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#อีสเตอร์#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#เอฟาเต#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#เอนเดอร์เบอร์รี#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ฟาเคาโฟ#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ฟิจิ#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ฟูนะฟูตี#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#กาลาปาโกส#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#แกมเบียร์#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#กัวดัลคานัล#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#กวม#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#โฮโนลูลู#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#จอห์นสตัน#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#คิริทิมาตี#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#คอสแร#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ควาจาเลน#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#มาจูโร#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#มาร์เควซัส#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#มิดเวย์#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#นาอูรู#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#นีอูเอ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#นอร์ฟอล์ก#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#นูเมอา#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#ปาโก ปาโก#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#ปาเลา#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#พิตแคร์น#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#โปนาเป#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#พอร์ตมอร์สบี#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#ราโรตองกา#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#ไซปัน#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ทาฮิติ#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ตาระวา#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ตองกาตาปู#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ทรัก#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#เวก#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#วาลลิส#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนปากีสถาน),
				'generic' => q(เวลาปากีสถาน),
				'standard' => q(เวลามาตรฐานปากีสถาน),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(เวลาปาเลา),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(เวลาปาปัวนิวกินี),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนปารากวัย),
				'generic' => q(เวลาปารากวัย),
				'standard' => q(เวลามาตรฐานปารากวัย),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนเปรู),
				'generic' => q(เวลาเปรู),
				'standard' => q(เวลามาตรฐานเปรู),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนฟิลิปปินส์),
				'generic' => q(เวลาฟิลิปปินส์),
				'standard' => q(เวลามาตรฐานฟิลิปปินส์),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(เวลาหมู่เกาะฟินิกซ์),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(เวลาออมแสงของแซงปีแยร์และมีเกอลง),
				'generic' => q(เวลาแซงปีแยร์และมีเกอลง),
				'standard' => q(เวลามาตรฐานแซงปีแยร์และมีเกอลง),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(เวลาพิตแคร์น),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(เวลาโปเนป),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนคืยซิลออร์ดา),
				'generic' => q(เวลาคืยซิลออร์ดา),
				'standard' => q(เวลามาตรฐานคืยซิลออร์ดา),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(เวลาเรอูนียง),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(เวลาโรธีรา),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนซาคาลิน),
				'generic' => q(เวลาซาคาลิน),
				'standard' => q(เวลามาตรฐานซาคาลิน),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนซามารา),
				'generic' => q(เวลาซามารา),
				'standard' => q(เวลามาตรฐานซามารา),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนซามัว),
				'generic' => q(เวลาซามัว),
				'standard' => q(เวลามาตรฐานซามัว),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(เวลาเซเชลส์),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(เวลาสิงคโปร์),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(เวลาหมู่เกาะโซโลมอน),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(เวลาเซาท์จอร์เจีย),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(เวลาซูรินาเม),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(เวลาโซวา),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(เวลาตาฮีตี),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(เวลาออมแสงไทเป),
				'generic' => q(เวลาไทเป),
				'standard' => q(เวลามาตรฐานไทเป),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(เวลาทาจิกิสถาน),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(เวลาโตเกเลา),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนตองกา),
				'generic' => q(เวลาตองกา),
				'standard' => q(เวลามาตรฐานตองกา),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(เวลาชุก),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนเติร์กเมนิสถาน),
				'generic' => q(เวลาเติร์กเมนิสถาน),
				'standard' => q(เวลามาตรฐานเติร์กเมนิสถาน),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(เวลาตูวาลู),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนอุรุกวัย),
				'generic' => q(เวลาอุรุกวัย),
				'standard' => q(เวลามาตรฐานอุรุกวัย),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนอุซเบกิสถาน),
				'generic' => q(เวลาอุซเบกิสถาน),
				'standard' => q(เวลามาตรฐานอุซเบกิสถาน),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนวานูอาตู),
				'generic' => q(เวลาวานูอาตู),
				'standard' => q(เวลามาตรฐานวานูอาตู),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(เวลาเวเนซุเอลา),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนวลาดีวอสตอค),
				'generic' => q(เวลาวลาดีวอสตอค),
				'standard' => q(เวลามาตรฐานวลาดีวอสตอค),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนวอลโกกราด),
				'generic' => q(เวลาวอลโกกราด),
				'standard' => q(เวลามาตรฐานวอลโกกราด),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(เวลาวอสตอค),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(เวลาเกาะเวก),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(เวลาวาลลิสและฟุตูนา),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนยาคุตสค์),
				'generic' => q(เวลายาคุตสค์),
				'standard' => q(เวลามาตรฐานยาคุตสค์),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(เวลาฤดูร้อนเยคาเตรินบูร์ก),
				'generic' => q(เวลาเยคาเตรินบูร์ก),
				'standard' => q(เวลามาตรฐานเยคาเตรินบูร์ก),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
