=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Sat - Package for language Santali

=cut

package Locale::CLDR::Locales::Sat;
# This file auto generated from Data\common\main\sat.xml
#	on Fri 28 Jun  8:55:56 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.45.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'ab' => 'ᱟᱹᱵᱠᱷᱟᱡᱤᱭᱟᱹᱱ',
 				'ace' => 'ᱟᱠᱷᱤᱱᱤᱡᱽ',
 				'ada' => 'ᱟᱹᱰᱟᱱᱜᱽᱢᱮ',
 				'ady' => 'ᱟᱹᱰᱭᱜᱷᱮ',
 				'af' => 'ᱟᱯᱷᱨᱤᱠᱟᱱᱥ',
 				'agq' => 'ᱟᱜᱷᱮᱢ',
 				'ain' => 'ᱟᱭᱤᱱᱩ',
 				'ak' => 'ᱟᱠᱟᱱ',
 				'ale' => 'ᱟᱞᱮᱣᱴ',
 				'alt' => 'ᱠᱚᱸᱭᱮ ᱟᱹᱞᱴᱟᱭᱤ',
 				'am' => 'ᱟᱢᱦᱟᱨᱤᱠ',
 				'an' => 'ᱟᱨᱟᱜᱚᱱᱤᱡᱽ',
 				'ann' => 'ᱳᱵᱚᱞᱳ',
 				'anp' => 'ᱟᱹᱝᱜᱤᱠᱟ',
 				'apc' => 'ᱮᱯᱠ',
 				'ar' => 'ᱚᱨᱵᱤ',
 				'ar_001' => 'ᱟᱫᱷᱩᱱᱤᱠ ᱢᱟᱱᱚᱠ ᱚᱨᱵᱤ',
 				'arn' => 'ᱢᱟᱯᱩᱪᱷᱮ',
 				'arp' => 'ᱟᱨᱟᱯᱟᱦᱚ',
 				'ars' => 'ᱱᱟᱹᱡᱫᱤ ᱚᱨᱵᱤ',
 				'as' => 'ᱟᱥᱟᱢᱤᱡᱽ',
 				'asa' => 'ᱟᱥᱩ',
 				'ast' => 'ᱚᱥᱴᱨᱤᱭᱟᱹᱱ',
 				'atj' => 'ᱟᱹᱴᱤᱠᱟᱢᱮᱠᱟᱹᱣ',
 				'av' => 'ᱟᱣᱟᱨᱤᱠ',
 				'awa' => 'ᱟᱹᱣᱟᱹᱫᱷᱤ',
 				'ay' => 'ᱟᱭᱢᱟᱨᱟ',
 				'az' => 'ᱟᱹᱡᱟᱹᱨᱵᱮᱡᱟᱱᱤ',
 				'az@alt=short' => 'ᱟᱹᱡᱮᱨᱤ',
 				'ba' => 'ᱵᱟᱥᱠᱤᱨ',
 				'ban' => 'ᱵᱟᱞᱤᱱᱤᱡᱽ',
 				'bas' => 'ᱵᱟᱥᱟ',
 				'be' => 'ᱵᱮᱞᱟᱨᱩᱥᱤᱭᱟᱹᱱ',
 				'bem' => 'ᱵᱮᱢᱵᱟ',
 				'bez' => 'ᱵᱮᱱᱟ',
 				'bg' => 'ᱵᱩᱞᱜᱮᱨᱤ',
 				'bgc' => 'ᱦᱟᱹᱨᱭᱟᱱᱣᱤ',
 				'bho' => 'ᱵᱽᱷᱚᱡᱽᱯᱩᱨᱤ',
 				'bi' => 'ᱵᱤᱥᱞᱟᱢᱟ',
 				'bin' => 'ᱵᱤᱱᱤ',
 				'bla' => 'ᱥᱤᱠᱥᱤᱠᱟ',
 				'bm' => 'ᱵᱟᱢᱵᱟᱨᱟ',
 				'bn' => 'ᱵᱟᱝᱞᱟ',
 				'bo' => 'ᱛᱤᱵᱮᱛᱟᱱ',
 				'br' => 'ᱵᱽᱨᱚᱴᱚᱱ',
 				'brx' => 'ᱵᱳᱰᱳ',
 				'bs' => 'ᱵᱚᱥᱱᱤᱭᱟᱹᱱ',
 				'bug' => 'ᱵᱩᱜᱤᱱᱤᱡᱽ',
 				'byn' => 'ᱵᱞᱤᱱ',
 				'ca' => 'ᱠᱟᱴᱟᱞᱟᱱ',
 				'cay' => 'ᱠᱟᱭᱩᱜᱟ',
 				'ccp' => 'ᱪᱷᱚᱠᱢᱟ',
 				'ce' => 'ᱪᱷᱮᱪᱷᱮᱱ',
 				'ceb' => 'ᱥᱤᱵᱩᱣᱟᱱᱳ',
 				'cgg' => 'ᱪᱷᱤᱜᱟ',
 				'ch' => 'ᱪᱷᱟᱢᱳᱨᱳ',
 				'chk' => 'ᱪᱷᱩᱠᱤᱡᱽ',
 				'chm' => 'ᱢᱟᱨᱤ',
 				'cho' => 'ᱪᱷᱚᱠᱴᱟᱣ',
 				'chp' => 'ᱪᱤᱯᱮᱭᱟᱱ',
 				'chr' => 'ᱪᱷᱮᱨᱚᱠᱤ',
 				'chy' => 'ᱪᱷᱮᱭᱮᱱ',
 				'ckb' => 'ᱥᱮᱱᱴᱨᱟᱞ ᱠᱩᱨᱫᱤᱥ',
 				'ckb@alt=menu' => 'ᱠᱩᱨᱫᱤᱥ, ᱥᱮᱱᱴᱨᱟᱞ',
 				'ckb@alt=variant' => 'ᱠᱩᱨᱫᱤᱥ, ᱥᱚᱨᱟᱱᱤ',
 				'clc' => 'ᱪᱷᱤᱞᱠᱚᱴᱤᱱ',
 				'co' => 'ᱠᱚᱨᱥᱤᱠᱟᱱ',
 				'crg' => 'ᱢᱤᱪᱷᱤᱯᱷ',
 				'crj' => 'ᱠᱚᱸᱭᱮ ᱮᱛᱚᱢ ᱠᱨᱤ',
 				'crk' => 'ᱯᱞᱮᱱᱥ ᱠᱨᱤ',
 				'crl' => 'ᱮᱛᱚᱢ ᱥᱟᱢᱟᱝ ᱠᱨᱤ',
 				'crm' => 'ᱢᱩᱥ ᱠᱨᱤ',
 				'crr' => 'ᱠᱟᱨᱚᱞᱤᱱᱟ ᱟᱞᱜᱚᱱᱠᱣᱤᱭᱟᱱ',
 				'cs' => 'ᱪᱮᱠ',
 				'csw' => 'ᱥᱣᱟᱢᱯᱤ ᱠᱨᱤ',
 				'cu' => 'ᱪᱚᱨᱪ ᱥᱞᱟᱣᱤᱠ',
 				'cv' => 'ᱪᱷᱩᱣᱟᱥ',
 				'cy' => 'ᱣᱮᱞᱥ',
 				'da' => 'ᱰᱟᱱᱤᱥ',
 				'dak' => 'ᱰᱟᱠᱚᱴᱟ',
 				'dar' => 'ᱰᱟᱨᱜᱣᱟ',
 				'dav' => 'ᱴᱟᱭᱤᱴᱟ',
 				'de' => 'ᱡᱟᱨᱢᱟᱱ',
 				'de_AT' => 'ᱚᱥᱴᱨᱤᱭᱟ ᱡᱟᱨᱢᱟᱱ',
 				'de_CH' => 'ᱥᱩᱣᱤᱥ ᱦᱟᱤ ᱡᱟᱨᱢᱟᱱ',
 				'dgr' => 'ᱰᱚᱜᱽᱨᱤᱵᱽ',
 				'dje' => 'ᱡᱟᱨᱢᱟ',
 				'doi' => 'ᱰᱚᱜᱽᱨᱤ',
 				'dsb' => 'ᱞᱚᱣᱟᱹᱨ ᱥᱚᱨᱵᱤᱭᱟᱱ',
 				'dua' => 'ᱰᱩᱣᱟᱞᱟ',
 				'dv' => 'ᱰᱤᱣᱮᱦᱤ',
 				'dyo' => 'ᱡᱚᱞᱟᱼᱯᱷᱚᱱᱤ',
 				'dz' => 'ᱡᱚᱝᱠᱷᱟ',
 				'dzg' => 'ᱰᱟᱡᱟᱜᱟ',
 				'ebu' => 'ᱮᱢᱵᱩ',
 				'ee' => 'ᱤᱣ',
 				'efi' => 'ᱮᱯᱷᱤᱠ',
 				'eka' => 'ᱮᱠᱟᱡᱩᱠ',
 				'el' => 'ᱜᱽᱨᱤᱠ',
 				'en' => 'ᱟᱝᱜᱽᱨᱮᱡᱤ',
 				'en_AU' => 'ᱚᱥᱴᱨᱮᱞᱤᱭᱟᱱ ᱟᱝᱜᱽᱨᱮᱡᱤ',
 				'en_CA' => 'ᱠᱟᱱᱟᱰᱤᱭᱟᱱ ᱟᱝᱜᱽᱨᱮᱡᱤ',
 				'en_GB' => 'ᱵᱨᱤᱴᱤᱥ ᱟᱝᱜᱽᱨᱮᱡᱤ',
 				'en_GB@alt=short' => 'ᱭᱩᱠᱮ ᱟᱝᱜᱽᱨᱮᱡᱤ',
 				'en_US' => 'ᱟᱢᱮᱨᱤᱠᱟᱱ ᱟᱝᱜᱽᱨᱮᱡᱤ',
 				'en_US@alt=short' => 'ᱭᱩᱮᱥ ᱟᱝᱜᱽᱨᱮᱡᱤ',
 				'eo' => 'ᱮᱥᱯᱟᱹᱨᱟᱱᱴᱳ',
 				'es' => 'ᱥᱯᱮᱱᱤᱥ',
 				'es_419' => 'ᱞᱮᱴᱤᱱ ᱟᱢᱮᱨᱤᱠᱟᱱ ᱥᱯᱮᱱᱤᱥ',
 				'es_ES' => 'ᱨᱩᱥᱤᱭᱟᱱ ᱥᱯᱮᱱᱤᱥ',
 				'es_MX' => 'ᱢᱮᱠᱥᱤᱠᱟᱱ ᱥᱯᱮᱱᱤᱥ',
 				'et' => 'ᱮᱥᱴᱚᱱᱤᱭᱟᱭ',
 				'eu' => 'ᱵᱟᱥᱠ',
 				'ewo' => 'ᱤᱣᱚᱱᱰᱩ',
 				'fa' => 'ᱯᱟᱹᱨᱥᱤᱭᱟᱭ',
 				'fa_AF' => 'ᱰᱟᱨᱤ',
 				'ff' => 'ᱯᱷᱩᱞᱟ',
 				'fi' => 'ᱯᱷᱤᱱᱤᱥ',
 				'fil' => 'ᱯᱷᱤᱞᱤᱯᱟᱱᱳ',
 				'fj' => 'ᱯᱷᱤᱡᱤᱭᱟᱱ',
 				'fo' => 'ᱯᱷᱟᱨᱚᱤᱥ',
 				'fon' => 'ᱯᱷᱚᱱ',
 				'fr' => 'ᱯᱷᱨᱮᱧᱪ',
 				'fr_CA' => 'ᱠᱟᱱᱟᱰᱤᱭᱟᱱ ᱯᱷᱨᱮᱧᱪ',
 				'fr_CH' => 'ᱥᱩᱣᱤᱥ ᱯᱷᱨᱮᱧᱪ',
 				'frc' => 'ᱠᱟᱡᱩᱱ ᱯᱷᱨᱮᱧᱪ',
 				'fur' => 'ᱯᱷᱨᱤᱣᱞᱤᱭᱟᱱ',
 				'fy' => 'ᱯᱟᱪᱮ ᱯᱷᱨᱤᱥᱤᱭᱟᱭ',
 				'ga' => 'ᱤᱨᱤᱥ',
 				'gaa' => 'ᱜᱟ',
 				'gd' => 'ᱥᱠᱚᱴᱤᱥ ᱜᱮᱞᱤᱠ',
 				'gez' => 'ᱜᱤᱡᱽ',
 				'gil' => 'ᱜᱤᱞᱵᱟᱹᱨᱴᱤᱡᱽ',
 				'gl' => 'ᱜᱟᱞᱤᱥᱤᱭᱟᱱ',
 				'gn' => 'ᱜᱩᱟᱨᱟᱱᱤ',
 				'gor' => 'ᱜᱚᱨᱚᱱᱴᱟᱞᱳ',
 				'gsw' => 'ᱥᱣᱤᱥ ᱡᱚᱨᱢᱚᱱ',
 				'gu' => 'ᱜᱩᱡᱽᱨᱟᱴᱤ',
 				'guz' => 'ᱜᱩᱥᱤ',
 				'gv' => 'ᱢᱟᱱᱠᱥ',
 				'gwi' => 'ᱜᱣᱤᱪᱤᱱ',
 				'ha' => 'ᱦᱟᱣᱥᱟ',
 				'hai' => 'ᱦᱟᱭᱰᱟ',
 				'haw' => 'ᱦᱟᱣᱟᱭᱤᱭᱟᱭ',
 				'hax' => 'ᱠᱚᱸᱭᱮ ᱦᱟᱭᱤᱰᱟ',
 				'he' => 'ᱦᱮᱵᱽᱨᱤᱣ',
 				'hi' => 'ᱦᱤᱱᱫᱤ',
 				'hi_Latn@alt=variant' => 'ᱦᱤᱝᱜᱞᱤᱥ',
 				'hil' => 'ᱦᱤᱞᱤᱜᱟᱭᱱᱚᱱ',
 				'hmn' => 'ᱢᱟᱹᱝ',
 				'hr' => 'ᱠᱨᱚᱮᱥᱤᱭᱟᱹᱱ',
 				'hsb' => 'ᱪᱮᱛᱟᱱ ᱥᱚᱨᱵᱤᱭᱟᱭ',
 				'ht' => 'ᱦᱟᱭᱴᱤᱭᱟᱭ ᱠᱨᱮᱚᱞᱮ',
 				'hu' => 'ᱦᱚᱝᱜᱽᱨᱤᱭᱟᱭ',
 				'hup' => 'ᱦᱩᱯᱟ',
 				'hur' => 'ᱦᱟᱞᱠᱚᱢᱮᱞᱮᱢ',
 				'hy' => 'ᱟᱨᱢᱮᱱᱤᱭᱟᱹᱱ',
 				'hz' => 'ᱦᱮᱨᱮᱨᱚ',
 				'ia' => 'ᱤᱱᱴᱚᱨᱞᱤᱝᱜᱣᱟ',
 				'iba' => 'ᱤᱵᱟᱱ',
 				'ibb' => 'ᱤᱵᱤᱵᱤᱭᱚ',
 				'id' => 'ᱤᱱᱰᱚᱱᱮᱥᱤᱭᱟᱹᱱ',
 				'ig' => 'ᱤᱜᱽᱵᱚ',
 				'ii' => 'ᱥᱤᱪᱷᱩᱣᱟᱱ ᱭᱤ',
 				'ikt' => 'ᱯᱟᱪᱮ ᱠᱟᱱᱟᱰᱤᱭᱟᱭ ᱤᱱᱩᱠᱴᱤᱴᱩᱴ',
 				'ilo' => 'ᱤᱞᱚᱠᱚ',
 				'inh' => 'ᱤᱱᱜᱩᱥ',
 				'io' => 'ᱤᱰᱳ',
 				'is' => 'ᱟᱭᱞᱟᱱᱰᱤᱠ',
 				'it' => 'ᱤᱴᱟᱞᱤᱟᱱ',
 				'iu' => 'ᱤᱱᱩᱠᱴᱤᱭᱩᱴ',
 				'ja' => 'ᱡᱟᱯᱟᱱᱤ',
 				'jbo' => 'ᱞᱚᱡᱽᱵᱟᱱ',
 				'jgo' => 'ᱜᱚᱢᱵᱟ',
 				'jmc' => 'ᱢᱟᱹᱪᱢᱮ',
 				'jv' => 'ᱡᱟᱣᱟᱱᱤᱡᱽ',
 				'ka' => 'ᱡᱭᱚᱨᱡᱤᱭᱟᱱ',
 				'kab' => 'ᱠᱟᱵᱮᱞ',
 				'kac' => 'ᱠᱟᱪᱤᱱ',
 				'kaj' => 'ᱡᱩ',
 				'kam' => 'ᱠᱟᱢᱵᱟ',
 				'kbd' => 'ᱠᱟᱵᱟᱨᱰᱤᱭᱟᱭ',
 				'kcg' => 'ᱴᱭᱟᱯ',
 				'kde' => 'ᱢᱟᱠᱚᱱᱰᱮ',
 				'kea' => 'ᱠᱟᱵᱩᱣᱟᱹᱨᱰᱤᱭᱟᱹᱱᱩ',
 				'kfo' => 'ᱠᱚᱨᱚ',
 				'kgp' => 'ᱠᱟᱭᱮᱱᱜᱮᱝ',
 				'kha' => 'ᱠᱷᱟᱥᱤ',
 				'khq' => 'ᱠᱚᱭᱨᱟ ᱪᱷᱤᱱᱤ',
 				'ki' => 'ᱠᱤᱠᱩᱭᱩ',
 				'kj' => 'ᱠᱩᱣᱟᱱᱭᱟᱢᱟ',
 				'kk' => 'ᱠᱟᱡᱟᱠᱷ',
 				'kkj' => 'ᱠᱟᱠᱚ',
 				'kl' => 'ᱠᱟᱞᱟᱞᱤᱥᱩᱴ',
 				'kln' => 'ᱠᱟᱞᱮᱱᱡᱤᱱ',
 				'km' => 'ᱠᱷᱟᱹᱢᱮᱨ',
 				'kmb' => 'ᱠᱤᱢᱵᱩᱱᱰᱩ',
 				'kn' => 'ᱠᱟᱱᱟᱰᱟ',
 				'ko' => 'ᱠᱚᱨᱤᱭᱟᱹᱱ',
 				'kok' => 'ᱠᱚᱱᱠᱟᱱᱤ',
 				'kpe' => 'ᱯᱮᱞᱮ',
 				'kr' => 'ᱠᱟᱱᱩᱨᱤ',
 				'krc' => 'ᱠᱟᱨᱟᱪᱟᱭᱼᱵᱟᱞᱠᱟᱨ',
 				'krl' => 'ᱠᱟᱨᱮᱞᱤᱭᱟᱹᱱ',
 				'kru' => 'ᱠᱩᱨᱩᱠᱷ',
 				'ks' => 'ᱠᱟᱹᱥᱢᱤᱨᱤ',
 				'ksb' => 'ᱥᱟᱢᱵᱟᱞᱟ',
 				'ksf' => 'ᱵᱟᱯᱷᱤᱭᱟ',
 				'ksh' => 'ᱠᱚᱞᱚᱜᱱᱤᱭᱟᱹᱱ',
 				'ku' => 'ᱠᱩᱨᱫᱤᱥ',
 				'kum' => 'ᱠᱩᱢᱤᱠ',
 				'kv' => 'ᱠᱚᱢᱤ',
 				'kw' => 'ᱠᱚᱨᱱᱤᱥ',
 				'kwk' => 'ᱠᱣᱟᱠᱷᱣᱟᱞᱟ',
 				'ky' => 'ᱠᱭᱨᱜᱩᱡᱽ',
 				'la' => 'ᱞᱟᱴᱤᱱ',
 				'lad' => 'ᱞᱟᱰᱤᱱᱚ',
 				'lag' => 'ᱞᱟᱝᱜᱤ',
 				'lb' => 'ᱞᱩᱠᱥᱮᱢᱵᱚᱨᱜᱤᱥ',
 				'lez' => 'ᱞᱮᱡᱜᱷᱤᱭᱟᱱ',
 				'lg' => 'ᱜᱟᱱᱰᱟ',
 				'li' => 'ᱞᱤᱢᱵᱩᱨᱜᱤᱥ',
 				'lij' => 'ᱞᱤᱜᱩᱨᱤᱭᱟᱱ',
 				'lil' => 'ᱞᱤᱞᱚᱮᱴ',
 				'lkt' => 'ᱞᱟᱠᱚᱴᱟ',
 				'lmo' => 'ᱞᱚᱢᱵᱟᱨᱰ',
 				'ln' => 'ᱞᱤᱝᱜᱟᱞᱟ',
 				'lo' => 'ᱞᱟᱣ',
 				'lou' => 'ᱞᱚᱣᱤᱥᱤᱭᱟᱱᱟ ᱠᱨᱮᱚᱞᱮ',
 				'loz' => 'ᱞᱚᱡᱤ',
 				'lrc' => 'ᱮᱛᱚᱢ ᱞᱩᱨᱤ',
 				'lsm' => 'ᱥᱟᱢᱤᱭᱟ',
 				'lt' => 'ᱞᱤᱛᱷᱩᱣᱟᱱᱤᱭᱟᱭ',
 				'lu' => 'ᱞᱩᱵᱟᱼᱠᱟᱴᱟᱹᱝᱜᱟ',
 				'lua' => 'ᱞᱩᱵᱟᱼᱞᱩᱞᱟ',
 				'lun' => 'ᱞᱩᱱᱰᱟ',
 				'luo' => 'ᱞᱩᱣᱚ',
 				'lus' => 'ᱢᱤᱡᱚ',
 				'luy' => 'ᱞᱩᱭᱤᱭᱟ',
 				'lv' => 'ᱞᱟᱴᱤᱣᱟᱱ',
 				'mad' => 'ᱢᱟᱱᱰᱩᱨᱤᱡᱽ',
 				'mag' => 'ᱢᱟᱜᱟᱦᱤ',
 				'mai' => 'ᱢᱟᱭᱛᱷᱤᱞᱤ',
 				'mak' => 'ᱢᱟᱠᱟᱥᱟᱨ',
 				'mas' => 'ᱢᱟᱥᱟᱭᱤ',
 				'mdf' => 'ᱢᱚᱠᱥᱟ',
 				'men' => 'ᱢᱮᱱᱰᱮ',
 				'mer' => 'ᱢᱮᱨᱩ',
 				'mfe' => 'ᱢᱚᱨᱤᱥᱭᱮᱱ',
 				'mg' => 'ᱢᱟᱞᱟᱜᱟᱥᱭ',
 				'mgh' => 'ᱢᱟᱠᱷᱩᱣᱟᱼᱢᱤᱴᱳ',
 				'mgo' => 'ᱢᱮᱴᱟ',
 				'mh' => 'ᱢᱟᱨᱥᱟᱞᱤᱥ',
 				'mi' => 'ᱢᱟᱣᱨᱤ',
 				'mic' => 'ᱢᱤᱠᱢᱟᱠ',
 				'min' => 'ᱢᱤᱱᱟᱜᱠᱟᱵᱩ',
 				'mk' => 'ᱢᱟᱥᱮᱰᱚᱱᱤᱭᱟᱭ',
 				'ml' => 'ᱢᱟᱞᱟᱭᱟᱞᱟᱹᱢ',
 				'mn' => 'ᱢᱚᱱᱜᱚᱞᱤᱭᱟᱱ',
 				'mni' => 'ᱢᱟᱹᱱᱤᱯᱩᱨᱤ',
 				'moe' => 'ᱤᱱᱩᱼᱟᱭᱢᱩᱱ',
 				'moh' => 'ᱢᱚᱦᱟᱠ',
 				'mos' => 'ᱢᱚᱥᱤ',
 				'mr' => 'ᱢᱟᱨᱟᱴᱷᱤ',
 				'ms' => 'ᱢᱟᱞᱟᱮ',
 				'mt' => 'ᱢᱟᱞᱴᱤᱡᱽ',
 				'mua' => 'ᱢᱩᱱᱰᱟᱝ',
 				'mul' => 'ᱟᱭᱢᱟᱸ ᱯᱟᱹᱨᱥᱤ ᱠᱚ',
 				'mus' => 'ᱢᱩᱥᱠᱚᱜᱤ',
 				'mwl' => 'ᱢᱤᱨᱟᱱᱰᱮᱥᱮ',
 				'my' => 'ᱵᱩᱨᱢᱤᱡᱽ',
 				'myv' => 'ᱮᱨᱡᱭᱟ',
 				'mzn' => 'ᱢᱟᱡᱟᱱᱰᱮᱨᱟᱱᱤ',
 				'na' => 'ᱱᱟᱣᱨᱩ',
 				'nap' => 'ᱱᱤᱭᱟᱯᱚᱞᱤᱴᱟᱱ',
 				'naq' => 'ᱱᱟᱢᱟ',
 				'nb' => 'ᱱᱚᱨᱣᱮᱤᱭᱟᱭ ᱵᱚᱠᱢᱟᱞ',
 				'nd' => 'ᱮᱛᱚᱢ ᱱᱮᱫᱮᱵᱮᱞᱮ',
 				'nds' => 'ᱞᱚ ᱡᱟᱹᱨᱢᱟᱹᱱ',
 				'nds_NL' => 'ᱞᱚ ᱥᱟᱠᱥᱚᱱ',
 				'ne' => 'ᱱᱮᱯᱟᱞᱤ',
 				'new' => 'ᱱᱚᱣᱟᱨᱤ',
 				'ng' => 'ᱰᱚᱝᱜᱟ',
 				'nia' => 'ᱱᱤᱭᱟᱥ',
 				'niu' => 'ᱱᱤᱭᱩᱭᱤᱭᱮᱱ',
 				'nl' => 'ᱰᱚᱪ',
 				'nl_BE' => 'ᱯᱷᱞᱮᱢᱤᱥ',
 				'nmg' => 'ᱠᱣᱟᱥᱤᱭᱳ',
 				'nn' => 'ᱱᱚᱨᱣᱮᱤᱭᱟᱭ ᱱᱟᱭᱱᱚᱨᱥᱠ',
 				'nnh' => 'ᱜᱤᱭᱮᱢᱵᱩᱱ',
 				'no' => 'ᱱᱚᱨᱣᱮᱤᱭᱟᱭ',
 				'nog' => 'ᱱᱚᱜᱟᱭᱤ',
 				'nqo' => 'ᱮᱱᱠᱚ',
 				'nr' => 'ᱠᱚᱸᱭᱮ ᱱᱟᱹᱫᱮᱵᱮᱞᱮ',
 				'nso' => 'ᱮᱛᱚᱢ ᱥᱚᱛᱷᱚ',
 				'nus' => 'ᱱᱩᱣᱮᱨ',
 				'nv' => 'ᱱᱟᱣᱟᱡᱚ',
 				'ny' => 'ᱱᱭᱟᱱᱡᱟ',
 				'nyn' => 'ᱱᱭᱟᱱᱠᱚᱞᱮ',
 				'oc' => 'ᱳᱥᱤᱴᱟᱱ',
 				'ojb' => 'ᱮᱛᱚᱢᱯᱟᱪᱮ ᱚᱡᱤᱵᱣᱟ',
 				'ojc' => 'ᱥᱮᱱᱴᱨᱟᱞ ᱳᱡᱤᱵᱽᱣᱟ',
 				'ojs' => 'ᱳᱡᱤᱼᱠᱨᱤ',
 				'ojw' => 'ᱯᱟᱪᱮ ᱳᱡᱤᱵᱣᱟ',
 				'oka' => 'ᱳᱠᱟᱱᱟᱜᱟᱱ',
 				'om' => 'ᱳᱨᱳᱢᱚ',
 				'or' => 'ᱳᱰᱤᱭᱟ',
 				'os' => 'ᱳᱥᱮᱴᱤᱠ',
 				'pa' => 'ᱯᱚᱧᱡᱟᱵᱤ',
 				'pag' => 'ᱯᱟᱱᱜᱮᱥᱤᱱᱟᱱ',
 				'pam' => 'ᱯᱟᱢᱯᱟᱱᱜᱟ',
 				'pap' => 'ᱯᱟᱯᱤᱭᱟᱢᱮᱱᱴᱚ',
 				'pau' => 'ᱯᱟᱞᱟᱣᱟᱱ',
 				'pcm' => 'ᱱᱟᱭᱡᱮᱨᱤᱭᱟᱹᱭ ᱯᱤᱰᱜᱤᱱ',
 				'pis' => 'ᱯᱤᱡᱤᱱ',
 				'pl' => 'ᱯᱚᱞᱤᱥ',
 				'pqm' => 'ᱢᱟᱞᱤᱥᱮᱴᱼᱯᱟᱥᱟᱢᱟᱠᱣᱚᱰᱭ',
 				'prg' => 'ᱯᱨᱤᱥᱤᱭᱟᱭ',
 				'ps' => 'ᱯᱟᱥᱛᱚ',
 				'pt' => 'ᱯᱩᱨᱛᱜᱟᱞᱤ',
 				'pt_BR' => 'ᱵᱨᱟᱡᱤᱞᱤᱭᱟᱱ ᱯᱩᱨᱛᱜᱟᱞᱤ',
 				'pt_PT' => 'ᱭᱩᱨᱚᱯᱤᱭᱟᱱ ᱯᱩᱨᱛᱜᱟᱞᱤ',
 				'qu' => 'ᱠᱣᱮᱪᱷᱩᱣᱟ',
 				'raj' => 'ᱨᱟᱡᱚᱥᱛᱷᱟᱱᱤ',
 				'rap' => 'ᱨᱟᱯᱟᱱᱩᱣᱤ',
 				'rar' => 'ᱨᱟᱨᱚᱴᱚᱱᱜᱟᱱ',
 				'rhg' => 'ᱨᱚᱦᱤᱱᱭᱟ',
 				'rif' => 'ᱨᱤᱯᱷᱤᱭᱟᱱ',
 				'rm' => 'ᱨᱚᱢᱟᱱᱤᱥᱤᱭᱟᱹᱭ',
 				'rn' => 'ᱨᱩᱱᱰᱤ',
 				'ro' => 'ᱨᱚᱢᱟᱱᱤ',
 				'ro_MD' => 'ᱢᱚᱞᱰᱤᱣᱤ',
 				'rof' => 'ᱴᱚᱢᱵᱚ',
 				'ru' => 'ᱨᱩᱥᱤᱭᱟᱱ',
 				'rup' => 'ᱟᱨᱚᱢᱟᱱᱤᱭᱟᱹᱱ',
 				'rw' => 'ᱠᱤᱱᱭᱟᱨᱣᱟᱱᱰᱟ',
 				'rwk' => 'ᱨᱚᱣᱟ',
 				'sa' => 'ᱥᱟᱹᱱᱥᱠᱨᱤᱛ',
 				'sad' => 'ᱥᱟᱱᱰᱟᱣᱮ',
 				'sah' => 'ᱥᱟᱠᱷᱟ',
 				'saq' => 'ᱥᱟᱢᱵᱩᱨᱩ',
 				'sat' => 'ᱥᱟᱱᱛᱟᱲᱤ',
 				'sba' => 'ᱜᱟᱢᱵᱮ',
 				'sbp' => 'ᱥᱟᱱᱜᱩ',
 				'sc' => 'ᱥᱟᱨᱰᱤᱱᱤᱭᱟᱭ',
 				'scn' => 'ᱥᱤᱠᱤᱞᱤᱭᱟᱱ',
 				'sco' => 'ᱥᱠᱚᱴᱥ',
 				'sd' => 'ᱥᱤᱱᱫᱷᱤ',
 				'se' => 'ᱮᱛᱚᱢ ᱥᱟᱢᱤ',
 				'seh' => 'ᱥᱮᱱᱟ',
 				'ses' => 'ᱠᱚᱭᱨᱟᱵᱚᱨᱚ ᱥᱮᱱᱤ',
 				'sg' => 'ᱥᱟᱱᱜᱚ',
 				'shi' => 'ᱛᱟᱹᱪᱮᱞᱦᱤᱴ',
 				'shn' => 'ᱥᱟᱱ',
 				'si' => 'ᱥᱤᱱᱦᱟᱞᱟ',
 				'sk' => 'ᱥᱞᱚᱣᱟᱠ',
 				'sl' => 'ᱥᱞᱚᱣᱮᱱᱤᱭᱟᱭ',
 				'slh' => 'ᱠᱚᱸᱭᱮ ᱞᱩᱥᱚᱴᱷᱥᱤᱰ',
 				'sm' => 'ᱥᱟᱢᱚᱣᱟᱱ',
 				'smn' => 'ᱤᱱᱟᱨᱤ ᱥᱟᱢᱤ',
 				'sms' => 'ᱥᱠᱚᱞᱴ ᱥᱟᱢᱤ',
 				'sn' => 'ᱥᱚᱱᱟ',
 				'snk' => 'ᱥᱚᱱᱤᱱᱠᱮ',
 				'so' => 'ᱥᱚᱢᱟᱞᱤ',
 				'sq' => 'ᱟᱞᱵᱟᱱᱤᱭᱟᱹᱱ',
 				'sr' => 'ᱥᱟᱹᱨᱵᱤᱭᱟᱭ',
 				'srn' => 'ᱥᱨᱟᱱᱟᱱ ᱴᱚᱝᱜᱚ',
 				'ss' => 'ᱥᱣᱟᱛᱤ',
 				'st' => 'ᱠᱚᱸᱭᱮ ᱥᱚᱛᱷᱚ',
 				'str' => 'ᱥᱴᱨᱟᱭᱮᱴᱥ ᱥᱟᱞᱤᱥ',
 				'su' => 'ᱥᱩᱱᱥᱟᱱᱤᱥ',
 				'suk' => 'ᱥᱩᱠᱩᱢᱟ',
 				'sv' => 'ᱥᱣᱤᱫᱤᱥ',
 				'sw' => 'ᱥᱣᱟᱦᱤᱞᱤ',
 				'sw_CD' => 'ᱠᱚᱝᱜᱚ ᱥᱣᱟᱦᱤᱞᱤ',
 				'swb' => 'ᱠᱚᱢᱚᱨᱤᱭᱟᱹᱱ',
 				'syr' => 'ᱥᱭᱨᱤᱭᱟᱠ',
 				'ta' => 'ᱛᱟᱹᱢᱤᱞ',
 				'tce' => 'ᱠᱚᱸᱭᱮ ᱴᱩᱴᱪᱷᱚᱱ',
 				'te' => 'ᱛᱮᱞᱩᱜᱩ',
 				'tem' => 'ᱴᱤᱢᱱᱮ',
 				'teo' => 'ᱴᱮᱥᱳ',
 				'tet' => 'ᱴᱮᱴᱩᱢ',
 				'tg' => 'ᱛᱟᱡᱤᱠ',
 				'tgx' => 'ᱴᱟᱜᱤᱥ',
 				'th' => 'ᱛᱷᱟᱭᱤ',
 				'tht' => 'ᱛᱟᱦᱞᱴᱟᱱ',
 				'ti' => 'ᱴᱤᱜᱽᱨᱤᱭᱟᱱᱟ',
 				'tig' => 'ᱴᱤᱜᱽᱨᱮ',
 				'tk' => 'ᱛᱩᱨᱠᱢᱮᱱ',
 				'tlh' => 'ᱠᱞᱤᱝᱜᱚᱱ',
 				'tli' => 'ᱴᱞᱤᱱᱜᱤᱴ',
 				'tn' => 'ᱛᱥᱣᱟᱱᱟ',
 				'to' => 'ᱴᱚᱝᱜᱟᱱ',
 				'tok' => 'ᱴᱚᱠᱤ ᱯᱚᱱᱟ',
 				'tpi' => 'ᱴᱚᱠ ᱯᱤᱥᱤᱱ',
 				'tr' => 'ᱛᱩᱨᱠᱤᱥ',
 				'trv' => 'ᱴᱟᱨᱚᱠᱚ',
 				'ts' => 'ᱛᱥᱚᱝᱜᱟ',
 				'tt' => 'ᱴᱟᱴᱟᱨ',
 				'ttm' => 'ᱮᱛᱚᱢ ᱴᱩᱴᱠᱷᱚᱱ',
 				'tum' => 'ᱴᱩᱢᱵᱩᱠᱟ',
 				'tvl' => 'ᱴᱩᱣᱟᱞᱩ',
 				'twq' => 'ᱴᱟᱥᱟᱣᱟᱠ',
 				'ty' => 'ᱛᱟᱦᱤᱴᱤᱭᱟᱱ',
 				'tyv' => 'ᱴᱩᱣᱤᱱᱤᱭᱟᱭ',
 				'tzm' => 'ᱥᱮᱱᱴᱨᱟᱞ ᱮᱴᱞᱟᱥ ᱛᱟᱢᱟᱡᱟᱭᱮᱛ',
 				'udm' => 'ᱩᱰᱢᱩᱨᱛ',
 				'ug' => 'ᱩᱭᱜᱷᱩᱨ',
 				'uk' => 'ᱩᱠᱨᱮᱱᱤᱭᱟᱭ',
 				'umb' => 'ᱩᱢᱵᱩᱱᱰᱩ',
 				'und' => 'ᱵᱟᱝ ᱩᱨᱩᱢ ᱯᱟᱹᱨᱥᱤ',
 				'ur' => 'ᱩᱨᱫᱤ',
 				'uz' => 'ᱩᱡᱵᱮᱠ',
 				'vai' => 'ᱣᱟᱭ',
 				've' => 'ᱣᱮᱱᱰᱟ',
 				'vec' => 'ᱣᱮᱱᱮᱴᱤᱭᱟᱹᱱ',
 				'vi' => 'ᱣᱮᱭᱮᱛᱱᱟᱢᱤᱡᱽ',
 				'vo' => 'ᱵᱷᱚᱞᱟᱯᱩᱠ',
 				'vun' => 'ᱵᱷᱩᱱᱡᱚ',
 				'wa' => 'ᱣᱟᱞᱩᱱ',
 				'wae' => 'ᱣᱟᱞᱥᱟᱹᱨ',
 				'wal' => 'ᱣᱚᱞᱚᱭᱴᱟ',
 				'war' => 'ᱣᱟᱨᱮᱭ',
 				'wo' => 'ᱣᱚᱞᱚᱯᱷ',
 				'wuu' => 'ᱣᱩ ᱪᱟᱭᱱᱤᱡᱽ',
 				'xal' => 'ᱠᱟᱞᱢᱤᱠ',
 				'xh' => 'ᱥᱚᱥᱟ',
 				'xog' => 'ᱥᱚᱜᱟ',
 				'yav' => 'ᱭᱟᱝᱵᱮᱱ',
 				'ybb' => 'ᱭᱮᱢᱵᱟ',
 				'yi' => 'ᱭᱤᱫᱤᱥ',
 				'yo' => 'ᱭᱚᱨᱩᱵᱟ',
 				'yrl' => 'ᱱᱤᱱᱜᱟᱴᱩ',
 				'yue' => 'ᱠᱟᱱᱴᱚᱱᱤᱡᱽ',
 				'yue@alt=menu' => 'ᱪᱟᱭᱱᱤᱡᱽ, ᱠᱟᱱᱴᱚᱱᱤᱡᱽ',
 				'zgh' => 'ᱢᱟᱱᱚᱠ ᱢᱚᱨᱚᱠᱟᱱ ᱛᱟᱢᱟᱡᱤᱛ',
 				'zh' => 'ᱪᱟᱭᱱᱤᱡᱽ',
 				'zh@alt=menu' => 'ᱪᱟᱭᱱᱤᱡᱽ, ᱢᱟᱱᱰᱟᱨᱤᱱ',
 				'zh_Hans' => 'ᱟᱞᱜᱟᱣᱟᱠᱟᱱ ᱪᱟᱭᱱᱤᱡᱽ',
 				'zh_Hans@alt=long' => 'ᱟᱞᱜᱟᱣᱟᱠᱟᱱ ᱢᱟᱫᱟᱨᱤᱱ ᱪᱟᱭᱱᱤᱡᱽ',
 				'zh_Hant' => 'ᱴᱨᱮᱰᱤᱥᱱᱟᱞ ᱪᱟᱭᱱᱤᱡᱽ',
 				'zh_Hant@alt=long' => 'ᱴᱨᱮᱰᱤᱥᱱᱟᱞ ᱢᱟᱫᱟᱨᱤᱱ ᱪᱟᱭᱱᱤᱡᱽ',
 				'zu' => 'ᱡᱩᱞᱩ',
 				'zun' => 'ᱡᱩᱱᱤ',
 				'zxx' => 'ᱪᱮᱫ ᱯᱟᱹᱨᱥᱤ ᱡᱤᱱᱤᱥ ᱵᱟᱹᱱᱩᱜᱼᱟ',
 				'zza' => 'ᱡᱟᱡᱟ',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'ᱟᱰᱞᱟᱢ',
 			'Aghb' => 'ᱠᱟᱹᱣᱠᱮᱥᱤᱭᱟᱱ ᱟᱹᱞᱵᱮᱱᱤᱭᱟᱭ',
 			'Ahom' => 'ᱟᱹᱦᱚᱢ',
 			'Arab' => 'ᱟᱨᱵᱤᱠ',
 			'Aran' => 'ᱱᱟᱥᱛᱟᱞᱤᱠ',
 			'Armi' => 'ᱤᱢᱯᱮᱨᱤᱭᱮᱞ ᱟᱨᱟᱢᱟᱭᱤᱠ',
 			'Armn' => 'ᱟᱨᱢᱮᱱᱤᱭᱟᱭ',
 			'Avst' => 'ᱟᱹᱣᱮᱥᱛᱟᱱ',
 			'Bali' => 'ᱵᱟᱞᱤᱱᱤᱥ',
 			'Bamu' => 'ᱵᱟᱢᱩᱱ',
 			'Bass' => 'ᱵᱟᱥᱟ ᱣᱟᱦ',
 			'Batk' => 'ᱵᱟᱴᱟᱠ',
 			'Beng' => 'ᱵᱟᱝᱞᱟ',
 			'Bhks' => 'ᱵᱷᱟᱭᱤᱠ ᱥᱩᱠᱤ',
 			'Bopo' => 'ᱵᱚᱯᱚᱢᱚᱯᱷᱚ',
 			'Brah' => 'ᱵᱽᱨᱟᱢᱦᱤ',
 			'Brai' => 'ᱵᱽᱨᱟᱭᱞᱮ',
 			'Bugi' => 'ᱵᱩᱜᱤᱱᱤᱡᱽ',
 			'Buhd' => 'ᱵᱩᱦᱩᱤᱫ',
 			'Cakm' => 'ᱪᱟᱹᱠᱢᱟ',
 			'Cans' => 'ᱡᱩᱢᱤᱫ ᱠᱚᱱᱮᱰᱤᱭᱟᱭ ᱟᱫᱤᱵᱟᱥᱤ ᱥᱤᱞᱟᱵᱤᱠᱥ',
 			'Cari' => 'ᱠᱟᱨᱤᱭᱟᱱ',
 			'Cham' => 'ᱪᱷᱟᱢ',
 			'Cher' => 'ᱪᱷᱮᱨᱚᱠᱤ',
 			'Chrs' => 'ᱠᱷᱚᱨᱟᱥᱢᱤᱭᱟᱱ',
 			'Copt' => 'ᱠᱚᱯᱴᱤᱠ',
 			'Cpmn' => 'ᱥᱟᱭᱯᱨᱚᱼᱢᱤᱱᱚᱣᱟᱱ',
 			'Cprt' => 'ᱥᱟᱭᱯᱨᱤᱭᱚᱴ',
 			'Cyrl' => 'ᱥᱤᱨᱤᱞᱤᱠ',
 			'Deva' => 'ᱫᱮᱣᱟᱱᱟᱜᱟᱨᱤ',
 			'Diak' => 'ᱰᱤᱵᱷᱮᱥ ᱟᱠᱩᱨᱩ',
 			'Dogr' => 'ᱰᱚᱜᱽᱨᱟ',
 			'Dsrt' => 'ᱰᱮᱥᱮᱨᱮᱴ',
 			'Dupl' => 'ᱰᱩᱯᱞᱚᱭᱟᱱ ᱥᱚᱛᱷᱟᱱᱰ',
 			'Egyp' => 'ᱤᱡᱤᱯᱴᱤᱭᱟᱭ ᱦᱟᱭᱟᱹᱨᱚ ᱡᱷᱚᱞᱚᱠ',
 			'Elba' => 'ᱮᱞᱵᱟᱥᱟᱱ',
 			'Elym' => 'ᱮᱞᱤᱢᱟᱭᱤᱠ',
 			'Ethi' => 'ᱤᱛᱷᱤᱭᱚᱯᱤᱠ',
 			'Geor' => 'ᱡᱭᱚᱨᱡᱤᱭᱟᱭ',
 			'Glag' => 'ᱜᱞᱟᱜᱚᱞᱤᱴᱤᱠ',
 			'Gong' => 'ᱜᱩᱱᱡᱟ ᱜᱚᱱᱰᱤ',
 			'Gonm' => 'ᱢᱟᱥᱟᱨᱟᱢ ᱜᱚᱱᱰᱤ',
 			'Goth' => 'ᱜᱚᱛᱷᱤᱠ',
 			'Gran' => 'ᱜᱽᱨᱟᱱᱛᱷᱟᱹ',
 			'Grek' => 'ᱜᱽᱨᱤᱠ',
 			'Gujr' => 'ᱜᱩᱡᱽᱨᱟᱴᱤ',
 			'Guru' => 'ᱜᱩᱨᱩᱢᱩᱠᱷᱤ',
 			'Hanb' => 'ᱦᱟᱱ ᱥᱟᱶ ᱵᱚᱯᱚᱢᱚᱯᱷᱚ',
 			'Hang' => 'ᱦᱟᱱᱜᱩᱞ',
 			'Hani' => 'ᱦᱟᱱ',
 			'Hano' => 'ᱦᱟᱱᱩᱱᱳ',
 			'Hans' => 'ᱥᱤᱢᱯᱞᱤᱯᱟᱭᱤᱰ',
 			'Hans@alt=stand-alone' => 'ᱥᱤᱢᱯᱞᱤᱯᱟᱭᱤᱰ ᱦᱟᱱ',
 			'Hant' => 'ᱴᱨᱮᱰᱤᱥᱚᱱᱟᱞ',
 			'Hant@alt=stand-alone' => 'ᱴᱨᱮᱰᱤᱥᱚᱱ ᱦᱟᱱ',
 			'Hatr' => 'ᱦᱟᱴᱨᱟᱱ',
 			'Hebr' => 'ᱦᱮᱵᱽᱨᱤᱣ',
 			'Hira' => 'ᱦᱤᱨᱟᱜᱟᱱᱟ',
 			'Hluw' => 'ᱟᱱᱟᱴᱚᱞᱤᱭᱟᱱ ᱦᱟᱭᱨᱚ ᱡᱷᱟᱹᱞᱟᱹᱠ',
 			'Hmng' => 'ᱯᱟᱦ ᱦᱟᱹᱢᱚᱝ',
 			'Hmnp' => 'ᱱᱭᱟᱠᱮᱝ ᱯᱩᱣᱟᱪᱩ ᱦᱟᱹᱢᱚᱝᱜᱽ',
 			'Hrkt' => 'ᱡᱟᱯᱟᱱᱤᱡᱽ ᱥᱭᱞᱟᱵᱮᱞ',
 			'Hung' => 'ᱢᱟᱨᱮ ᱦᱚᱝᱜᱮᱨᱤᱭᱟᱭ',
 			'Ital' => 'ᱢᱟᱨᱮ ᱤᱴᱟᱞᱤᱠ',
 			'Jamo' => 'ᱡᱟᱢᱚ',
 			'Java' => 'ᱡᱟᱣᱟᱱᱤᱡᱽ',
 			'Jpan' => 'ᱡᱟᱯᱟᱱᱤᱡᱽ',
 			'Kali' => 'ᱠᱟᱭᱟᱦ ᱞᱤ',
 			'Kana' => 'ᱠᱟᱴᱟᱠᱟᱱᱟ',
 			'Kawi' => 'ᱠᱟᱣᱤ',
 			'Khar' => 'ᱠᱷᱟᱨᱚᱥᱴᱤ',
 			'Khmr' => 'ᱠᱷᱢᱮᱨ',
 			'Khoj' => 'ᱠᱷᱚᱡᱠᱤ',
 			'Kits' => 'ᱠᱷᱤᱛᱟᱱ ᱦᱩᱰᱤᱧ ᱪᱤᱠᱤ',
 			'Knda' => 'ᱠᱚᱱᱚᱰ',
 			'Kore' => 'ᱠᱚᱨᱤᱭᱟᱹᱱ',
 			'Kthi' => 'ᱠᱟᱹᱭᱛᱷᱤ',
 			'Lana' => 'ᱞᱟᱱᱟ',
 			'Laoo' => 'ᱞᱟᱣ',
 			'Latn' => 'ᱞᱮᱴᱤᱱ',
 			'Lepc' => 'ᱯᱮᱯᱟ',
 			'Limb' => 'ᱞᱤᱢᱵᱩ',
 			'Lina' => 'ᱞᱤᱱᱤᱭᱟᱹᱨ ᱮ',
 			'Linb' => 'ᱞᱤᱱᱤᱭᱟᱹᱨ ᱵᱤ',
 			'Lisu' => 'ᱯᱷᱨᱟᱥᱟᱹᱨ',
 			'Lyci' => 'ᱞᱟᱭᱥᱤᱭᱟᱱ',
 			'Lydi' => 'ᱞᱟᱭᱰᱤᱭᱟᱱ',
 			'Mahj' => 'ᱢᱟᱦᱟᱡᱟᱱᱤ',
 			'Maka' => 'ᱢᱟᱠᱟᱥᱟᱨ',
 			'Mand' => 'ᱢᱟᱱᱰᱟᱤᱭᱟᱱ',
 			'Mani' => 'ᱢᱟᱱᱤᱪᱷᱟᱤᱭᱟᱱ',
 			'Marc' => 'ᱢᱟᱨᱪᱷᱮᱱ',
 			'Medf' => 'ᱢᱮᱰᱮᱯᱷᱟᱭᱰᱨᱤᱱ',
 			'Mend' => 'ᱢᱮᱱᱰᱮ',
 			'Merc' => 'ᱢᱮᱨᱤᱭᱚᱴᱤᱠ ᱠᱚᱨᱥᱤᱣ',
 			'Mero' => 'ᱢᱮᱨᱚᱭᱤᱴᱤᱠ',
 			'Mlym' => 'ᱢᱟᱞᱟᱭᱟᱞᱟᱢ',
 			'Modi' => 'ᱢᱚᱰᱤ',
 			'Mong' => 'ᱢᱚᱝᱜᱚᱞᱤᱭᱟᱭ',
 			'Mroo' => 'ᱢᱨᱚ',
 			'Mtei' => 'ᱢᱮᱭᱴᱤ ᱢᱟᱭᱮᱠ',
 			'Mult' => 'ᱢᱩᱞᱛᱟᱱᱤ',
 			'Mymr' => 'ᱢᱭᱟᱱᱢᱟᱨ',
 			'Nagm' => 'ᱱᱟᱜ ᱢᱩᱱᱰᱟᱨᱤ',
 			'Nand' => 'ᱱᱟᱹᱱᱫᱤᱱᱟᱜᱤᱨᱤ',
 			'Narb' => 'ᱢᱟᱨᱮ ᱮᱛᱚᱢ ᱚᱨᱵᱤ',
 			'Nbat' => 'ᱱᱚᱵᱚᱴᱟᱤᱭᱟᱱ',
 			'Newa' => 'ᱱᱚᱣᱟ',
 			'Nkoo' => 'ᱮᱱᱠᱚᱥ',
 			'Nshu' => 'ᱱᱩᱥᱩ',
 			'Ogam' => 'ᱚᱜᱷᱟᱢ',
 			'Olck' => 'ᱚᱞ ᱪᱤᱠᱤ',
 			'Orkh' => 'ᱚᱨᱠᱷᱚᱱ',
 			'Orya' => 'ᱳᱰᱤᱭᱟ',
 			'Osge' => 'ᱳᱥᱟᱜᱮ',
 			'Osma' => 'ᱚᱥᱢᱟᱱᱭᱟ',
 			'Ougr' => 'ᱢᱟᱨᱮ ᱩᱭᱜᱷᱩᱨ',
 			'Palm' => 'ᱯᱟᱞᱢᱭᱨᱮᱱᱮ',
 			'Pauc' => 'ᱯᱟᱣ ᱪᱤᱱ ᱦᱟᱣ',
 			'Perm' => 'ᱢᱟᱨᱮ ᱯᱟᱹᱨᱢᱤᱠ',
 			'Phag' => 'ᱯᱷᱟᱜᱥᱼᱯᱟ',
 			'Phli' => 'ᱴᱷᱚᱠᱟᱣᱚᱞ ᱯᱟᱦᱞᱚᱣᱤ',
 			'Phlp' => 'ᱥᱟᱞᱴᱚᱨ ᱯᱟᱦᱟᱞᱣᱤ',
 			'Phnx' => 'ᱯᱷᱚᱮᱱᱥᱤᱭᱟᱱ',
 			'Plrd' => 'ᱯᱚᱞᱟᱰ ᱯᱷᱚᱱᱮᱴᱤᱠ',
 			'Prti' => 'ᱴᱷᱚᱠᱟᱣ ᱯᱟᱨᱛᱷᱤᱭᱟᱱ',
 			'Qaag' => 'ᱡᱟᱣᱜᱣᱤ',
 			'Rjng' => 'ᱨᱮᱡᱟᱝ',
 			'Rohg' => 'ᱦᱟᱱᱟᱯᱷᱤ',
 			'Runr' => 'ᱨᱩᱱᱤᱠ',
 			'Samr' => 'ᱥᱟᱢᱟᱨᱤᱴᱟᱱ',
 			'Sarb' => 'ᱠᱟᱨᱮ ᱠᱚᱸᱭᱮ ᱚᱨᱵᱤ',
 			'Saur' => 'ᱥᱟᱹᱣᱨᱟᱥᱴᱨᱚ',
 			'Sgnw' => 'ᱪᱤᱱᱦᱟᱹᱚᱞ',
 			'Shaw' => 'ᱥᱟᱣᱤᱭᱟᱱ',
 			'Shrd' => 'ᱥᱟᱨᱟᱰᱟ',
 			'Sidd' => 'ᱥᱤᱫᱷᱟᱹᱢ',
 			'Sind' => 'ᱠᱷᱩᱰᱟᱣᱟᱰᱤ',
 			'Sinh' => 'ᱥᱤᱱᱦᱟᱞᱟ',
 			'Sogd' => 'ᱥᱚᱜᱰᱤᱭᱟᱱ',
 			'Sogo' => 'ᱢᱟᱨᱮ ᱥᱚᱜᱰᱤᱭᱟᱱ',
 			'Sora' => 'ᱥᱚᱨᱟ ᱥᱚᱢᱯᱮᱝ',
 			'Soyo' => 'ᱥᱚᱭᱚᱢᱵᱚ',
 			'Sund' => 'ᱥᱩᱱᱫᱟᱱᱤᱥ',
 			'Sylo' => 'ᱥᱟᱭᱞᱚᱴᱤ ᱟᱱᱜᱽᱨᱤ',
 			'Syrc' => 'ᱥᱭᱨᱤᱭᱟᱠ',
 			'Tagb' => 'ᱴᱟᱜᱵᱟᱱᱣᱟ',
 			'Takr' => 'ᱴᱟᱠᱨᱤ',
 			'Tale' => 'ᱛᱟᱭᱤ ᱞᱮ',
 			'Talu' => 'ᱱᱚᱶᱟ ᱛᱟᱭᱤ ᱞᱩᱣᱮ',
 			'Taml' => 'ᱛᱟᱹᱢᱤᱞ',
 			'Tang' => 'ᱴᱟᱝᱜᱩᱴ',
 			'Tavt' => 'ᱛᱟᱭᱤ ᱣᱤᱭᱮᱛ',
 			'Telu' => 'ᱛᱮᱞᱩᱜᱩ',
 			'Tfng' => 'ᱴᱤᱯᱷᱤᱱᱟᱜᱷ',
 			'Tglg' => 'ᱴᱟᱜᱟᱞᱚᱜ',
 			'Thaa' => 'ᱛᱷᱟᱱᱟ',
 			'Thai' => 'ᱛᱷᱟᱭᱤ',
 			'Tibt' => 'ᱛᱤᱵᱮᱛᱟᱱ',
 			'Tirh' => 'ᱛᱤᱨᱦᱩᱛᱟ',
 			'Tnsa' => 'ᱴᱟᱝᱥᱟ',
 			'Toto' => 'ᱴᱚᱴᱚ',
 			'Ugar' => 'ᱩᱜᱟᱨᱤᱴᱤᱠ',
 			'Vaii' => 'ᱣᱟᱭᱤ',
 			'Vith' => 'ᱵᱷᱤᱛᱠᱷᱩᱠᱤ',
 			'Wara' => 'ᱣᱨᱟᱝ ᱠᱥᱤᱛᱤ',
 			'Wcho' => 'ᱣᱟᱱᱪᱷᱚ',
 			'Xpeo' => 'ᱢᱟᱨᱮ ᱯᱟᱹᱨᱥᱤᱭᱟᱭ',
 			'Xsux' => 'ᱥᱩᱢᱮᱨᱚᱼᱟᱠᱟᱰᱤᱭᱟᱱ ᱠᱩᱱᱮᱭᱯᱷᱚᱨᱢ',
 			'Yezi' => 'ᱭᱮᱡᱤᱫᱤ',
 			'Yiii' => 'ᱭᱤ',
 			'Zanb' => 'ᱡᱟᱱᱟᱵᱟᱡᱟᱨ ᱥᱠᱣᱮᱨ',
 			'Zinh' => 'ᱵᱚᱸᱥᱚ ᱞᱮᱠᱟᱛᱮ',
 			'Zmth' => 'ᱮᱞᱠᱷᱟ ᱩᱫᱩᱜ',
 			'Zsye' => 'ᱤᱢᱚᱡᱤ',
 			'Zsym' => 'ᱪᱤᱱᱦᱟᱹ ᱠᱚ',
 			'Zxxx' => 'ᱵᱟᱝ ᱚᱞ ᱟᱠᱟᱱ',
 			'Zyyy' => 'ᱥᱟᱫᱷᱨᱚᱱ',
 			'Zzzz' => 'ᱵᱟᱝ ᱩᱨᱩᱢ ᱪᱤᱠᱤ',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'ᱡᱮᱜᱮᱛ',
 			'002' => 'ᱟᱯᱷᱨᱤᱠᱟ',
 			'003' => 'ᱮᱛᱚᱢ ᱟᱢᱮᱨᱤᱠᱟ',
 			'005' => 'ᱠᱚᱸᱭᱮ ᱟᱢᱮᱨᱤᱠᱟ',
 			'009' => 'ᱚᱥᱮᱱᱤᱭᱟ',
 			'011' => 'ᱯᱟᱪᱮ ᱟᱯᱷᱨᱤᱠᱟ',
 			'013' => 'ᱛᱟᱞᱟ ᱟᱢᱮᱨᱤᱠᱟ',
 			'014' => 'ᱥᱟᱢᱟᱝ ᱟᱯᱷᱨᱤᱠᱟ',
 			'015' => 'ᱮᱛᱚᱢᱤᱭᱟᱹ ᱟᱯᱷᱨᱤᱠᱟ',
 			'017' => 'ᱛᱟᱞᱟ ᱟᱯᱷᱨᱤᱠᱟ',
 			'018' => 'ᱠᱚᱸᱭᱮᱤᱭᱟᱹ ᱟᱯᱷᱨᱤᱠᱟ',
 			'019' => 'ᱟᱹᱢᱮᱨᱤᱠᱟᱱᱥ',
 			'021' => 'ᱮᱛᱚᱢᱤᱭᱟᱹ ᱟᱢᱮᱨᱤᱠᱟ',
 			'029' => 'ᱠᱟᱹᱨᱮᱵᱤᱭᱟᱹᱱ',
 			'030' => 'ᱥᱟᱢᱟᱝ ᱮᱥᱤᱭᱟ',
 			'034' => 'ᱠᱚᱸᱭᱮᱤᱭᱟᱹ ᱮᱥᱤᱭᱟ',
 			'035' => 'ᱠᱚᱸᱭᱮᱥᱟᱢᱟᱝ ᱮᱥᱤᱭᱟ',
 			'039' => 'ᱠᱚᱸᱭᱮᱤᱭᱟᱹ ᱭᱩᱨᱚᱯ',
 			'053' => 'ᱚᱣᱥᱴᱨᱟᱞᱮᱥᱤᱭᱟ',
 			'054' => 'ᱢᱮᱞᱟᱱᱮᱥᱤᱟ',
 			'057' => 'ᱢᱟᱭᱠᱨᱚᱱᱮᱥᱤᱭᱟᱱ ᱡᱟᱭᱜᱟ',
 			'061' => 'ᱯᱚᱞᱭᱱᱮᱥᱤᱟ',
 			'142' => 'ᱮᱥᱤᱭᱟ',
 			'143' => 'ᱛᱟᱞᱟ ᱮᱥᱤᱭᱟ',
 			'145' => 'ᱯᱟᱪᱮᱤᱭᱟᱹ ᱮᱥᱤᱭᱟ',
 			'150' => 'ᱭᱩᱨᱚᱯ',
 			'151' => 'ᱥᱟᱢᱟᱝᱤᱭᱟ. ᱭᱩᱨᱚᱯ',
 			'154' => 'ᱮᱛᱚᱢᱤᱭᱟᱹ ᱭᱩᱨᱚᱯ',
 			'155' => 'ᱯᱟᱪᱮᱤᱭᱟ. ᱭᱩᱨᱚᱯ',
 			'202' => 'ᱦᱟᱹᱴᱤᱧᱼᱥᱟᱦᱟᱨᱟᱱ ᱟᱯᱷᱨᱤᱠᱟ',
 			'419' => 'ᱞᱟᱴᱤᱱ ᱟᱢᱮᱨᱤᱠᱟ',
 			'AC' => 'ᱟᱥᱮᱱᱥᱤᱭᱟᱹᱱ ᱟᱭᱞᱮᱸᱰ',
 			'AD' => 'ᱟᱱᱰᱚᱨᱟ',
 			'AE' => 'ᱡᱩᱢᱤᱫ ᱟᱨᱟᱹᱵ ᱮᱢᱤᱨᱮᱴᱥ',
 			'AF' => 'ᱟᱯᱷᱜᱟᱱᱤᱥᱛᱟᱱ',
 			'AG' => 'ᱟᱱᱴᱤᱜᱩᱣᱟ ᱟᱨ ᱵᱟᱹᱨᱢᱩᱱᱰᱟ',
 			'AI' => 'ᱟᱹᱱᱜᱩᱭᱞᱟ',
 			'AL' => 'ᱟᱞᱵᱟᱱᱤᱭᱟ',
 			'AM' => 'ᱟᱨᱢᱮᱱᱤᱭᱟ',
 			'AO' => 'ᱟᱹᱱᱜᱚᱞᱟ',
 			'AQ' => 'ᱟᱱᱴᱟᱨᱠᱴᱤᱠᱟ',
 			'AR' => 'ᱟᱨᱡᱮᱱᱴᱤᱱᱟ',
 			'AS' => 'ᱟᱢᱮᱨᱤᱠᱟᱹᱱ ᱥᱟᱢᱚᱣᱟ',
 			'AT' => 'ᱟᱥᱴᱨᱮᱞᱤᱭᱟ',
 			'AU' => 'ᱚᱥᱴᱨᱮᱞᱤᱭᱟ',
 			'AW' => 'ᱟᱹᱨᱩᱵᱟ',
 			'AX' => 'ᱮᱞᱮᱸᱰ ᱫᱣᱤᱯᱫᱳᱞ',
 			'AZ' => 'ᱟᱹᱡᱟᱹᱨᱵᱮᱭᱡᱟᱱ',
 			'BA' => 'ᱵᱚᱥᱱᱤᱭᱟ ᱟᱨ ᱦᱟᱹᱨᱡᱮᱜᱚᱣᱤᱭᱟ',
 			'BB' => 'ᱵᱟᱨᱵᱟᱰᱚᱥ',
 			'BD' => 'ᱵᱟᱝᱞᱟᱫᱮᱥ',
 			'BE' => 'ᱵᱮᱞᱡᱤᱭᱟᱹᱢ',
 			'BF' => 'ᱵᱩᱨᱠᱤᱱᱟ ᱯᱷᱟᱥᱚ',
 			'BG' => 'ᱵᱩᱞᱜᱟᱨᱤᱭᱟ',
 			'BH' => 'ᱵᱟᱦᱨᱮᱱ',
 			'BI' => 'ᱵᱩᱨᱩᱱᱰᱤ',
 			'BJ' => 'ᱵᱮᱱᱤᱱ',
 			'BL' => 'ᱮᱥ ᱴᱤ ᱵᱟᱨᱛᱷᱮᱞᱮᱢᱤ',
 			'BM' => 'ᱵᱟᱹᱨᱢᱩᱱᱰᱟ',
 			'BN' => 'ᱵᱽᱨᱩᱱᱮᱭ',
 			'BO' => 'ᱵᱚᱞᱤᱣᱤᱭᱟ',
 			'BQ' => 'ᱠᱟᱹᱨᱮᱱᱤᱭᱟᱹᱱ ᱱᱮᱫᱚᱨᱞᱮᱸᱰ',
 			'BR' => 'ᱵᱨᱟᱡᱤᱞ',
 			'BS' => 'ᱵᱟᱦᱟᱢᱟᱥ',
 			'BT' => 'ᱵᱷᱩᱴᱟᱱ',
 			'BV' => 'ᱵᱚᱣᱮᱴ ᱟᱭᱞᱮᱸᱰ',
 			'BW' => 'ᱵᱚᱴᱥᱣᱟᱱᱟ',
 			'BY' => 'ᱵᱮᱞᱟᱨᱩᱥ',
 			'BZ' => 'ᱵᱮᱞᱤᱡᱽ',
 			'CA' => 'ᱠᱟᱱᱟᱰᱟ',
 			'CC' => 'ᱠᱚᱠᱚᱥ (ᱠᱤᱞᱤᱝ) ᱟᱭᱞᱮᱸᱰ',
 			'CD' => 'ᱠᱚᱝᱜᱚ ᱼ ᱠᱤᱱᱥᱟᱥᱟ',
 			'CD@alt=variant' => 'ᱠᱚᱝᱜᱚ (ᱰᱤᱟᱨᱥᱤ)',
 			'CF' => 'ᱛᱟᱞᱟ ᱟᱯᱷᱨᱤᱠᱟ ᱟᱹᱯᱱᱟᱹᱛ',
 			'CG' => 'ᱠᱚᱝᱜᱚ ᱼ ᱵᱽᱨᱟᱡᱟᱣᱤᱞ',
 			'CG@alt=variant' => 'ᱠᱚᱝᱜᱚ (ᱟᱹᱯᱱᱟᱹᱛ)',
 			'CH' => 'ᱥᱮᱤᱡᱟᱹᱨᱞᱮᱸᱰ',
 			'CI' => 'ᱠᱚᱛᱮ ᱫᱤᱣᱚᱭᱮᱨ',
 			'CI@alt=variant' => 'ᱟᱭᱣᱚᱨᱤ ᱠᱚᱥᱴ',
 			'CK' => 'ᱠᱩᱠ ᱟᱭᱞᱮᱸᱰ',
 			'CL' => 'ᱪᱟᱭᱤᱞ',
 			'CM' => 'ᱠᱟᱢᱮᱨᱩᱱ',
 			'CN' => 'ᱪᱤᱱ',
 			'CO' => 'ᱠᱚᱞᱚᱢᱵᱤᱭᱟ',
 			'CP' => 'ᱠᱞᱤᱯᱮᱴᱨᱚᱱ ᱟᱭᱞᱮᱸᱰ',
 			'CR' => 'ᱠᱚᱥᱴᱟ ᱨᱤᱠᱟ',
 			'CU' => 'ᱠᱭᱩᱵᱟ',
 			'CV' => 'ᱠᱮᱯ ᱣᱟᱹᱨᱰᱮ',
 			'CW' => 'ᱠᱩᱨᱟᱠᱟᱣ',
 			'CX' => 'ᱠᱨᱤᱥᱢᱟᱹᱥ ᱟᱭᱞᱮᱸᱰ',
 			'CY' => 'ᱥᱟᱭᱯᱨᱟᱹᱥ',
 			'CZ' => 'ᱪᱮᱠᱤᱭᱟ',
 			'CZ@alt=variant' => 'ᱪᱮᱠ ᱨᱤᱯᱟᱹᱵᱞᱤᱠ',
 			'DE' => 'ᱡᱟᱨᱢᱟᱱᱤ',
 			'DG' => 'ᱰᱤᱭᱮᱜᱚ ᱜᱟᱨᱥᱤᱭᱟ',
 			'DJ' => 'ᱡᱤᱵᱩᱛᱤ',
 			'DK' => 'ᱰᱮᱱᱢᱟᱨᱠ',
 			'DM' => 'ᱰᱚᱢᱤᱱᱤᱠᱟ',
 			'DO' => 'ᱰᱚᱢᱤᱱᱤᱠᱟᱱ ᱨᱤᱯᱚᱵᱞᱤᱠ',
 			'DZ' => 'ᱟᱞᱡᱮᱨᱤᱭᱟ',
 			'EA' => 'ᱥᱮᱣᱴᱟ ᱟᱨ ᱢᱮᱞᱤᱞᱟ',
 			'EC' => 'ᱤᱠᱣᱟᱰᱚᱨ',
 			'EE' => 'ᱮᱥᱴᱚᱱᱤᱭᱟ',
 			'EG' => 'ᱤᱡᱤᱯᱴ',
 			'EH' => 'ᱯᱟᱪᱮ ᱥᱟᱦᱟᱨᱟ',
 			'ER' => 'ᱤᱨᱤᱴᱨᱤᱭᱟ',
 			'ES' => 'ᱥᱯᱮᱱ',
 			'ET' => 'ᱤᱛᱷᱤᱭᱚᱯᱤᱭᱟ',
 			'EU' => 'ᱭᱩᱨᱚᱯᱤᱭᱟᱹᱱ ᱡᱩᱢᱤᱫ',
 			'EZ' => 'ᱭᱩᱨᱚᱡᱚᱱ',
 			'FI' => 'ᱯᱷᱤᱱᱞᱮᱸᱰ',
 			'FJ' => 'ᱯᱷᱤᱡᱤ',
 			'FK' => 'ᱯᱷᱟᱞᱠᱞᱮᱸᱰ ᱟᱭᱞᱮᱸᱰ',
 			'FM' => 'ᱢᱟᱭᱠᱨᱚᱱᱮᱥᱤᱭᱟ',
 			'FO' => 'ᱯᱷᱮᱨᱚ ᱫᱣᱤᱯᱫᱳᱞ',
 			'FR' => 'ᱯᱷᱨᱟᱱᱥ',
 			'GA' => 'ᱜᱟᱵᱚᱱ',
 			'GB' => 'ᱭᱩᱱᱤᱭᱴᱮᱰ ᱠᱤᱝᱰᱚᱢ',
 			'GB@alt=short' => 'ᱭᱩ ᱠᱮ',
 			'GD' => 'ᱜᱽᱨᱮᱱᱟᱰᱟ',
 			'GE' => 'ᱡᱭᱚᱨᱡᱤᱭᱟ',
 			'GF' => 'ᱯᱷᱨᱮᱧᱪ ᱜᱩᱭᱟᱱᱟ',
 			'GG' => 'ᱜᱣᱮᱨᱱᱮᱥᱭ',
 			'GH' => 'ᱜᱷᱟᱱᱟ',
 			'GI' => 'ᱜᱤᱵᱽᱨᱟᱞᱴᱟᱹᱨ',
 			'GL' => 'ᱜᱽᱨᱤᱱᱞᱮᱸᱰ',
 			'GM' => 'ᱜᱟᱢᱵᱤᱭᱟ',
 			'GN' => 'ᱜᱩᱭᱱᱤᱭᱟ',
 			'GP' => 'ᱜᱩᱟᱰᱮᱞᱚᱣᱯ',
 			'GQ' => 'ᱤᱠᱣᱤᱴᱚᱨᱤᱭᱟᱹᱞ ᱜᱤᱱᱤ',
 			'GR' => 'ᱜᱽᱨᱤᱥ',
 			'GS' => 'ᱠᱚᱸᱭᱮ ᱡᱤᱭᱚᱨᱡᱤᱭᱟ ᱟᱨ ᱠᱚᱸᱭᱮ ᱥᱮᱸᱰᱣᱤᱪ ᱟᱭᱞᱮᱸᱰ',
 			'GT' => 'ᱜᱩᱣᱟᱴᱮᱢᱟᱞᱟ',
 			'GU' => 'ᱜᱩᱣᱟᱢ',
 			'GW' => 'ᱜᱩᱭᱱᱤᱭᱟᱼᱵᱤᱥᱟᱣ',
 			'GY' => 'ᱜᱩᱭᱟᱱᱟ',
 			'HK' => 'ᱦᱚᱝ ᱠᱚᱝ ᱥᱟᱨ ᱪᱟᱭᱱᱟ',
 			'HK@alt=short' => 'ᱦᱚᱝ ᱠᱚᱝ',
 			'HM' => 'ᱦᱟᱹᱰ ᱟᱨ ᱢᱮᱠᱰᱚᱱᱟᱹᱞᱰ ᱟᱭᱞᱮᱸᱰ',
 			'HN' => 'ᱦᱚᱱᱰᱩᱨᱟᱥ',
 			'HR' => 'ᱠᱨᱚᱮᱥᱤᱭᱟ',
 			'HT' => 'ᱦᱟᱭᱴᱤ',
 			'HU' => 'ᱦᱟᱹᱝᱜᱟᱨᱤ',
 			'IC' => 'ᱠᱟᱱᱟᱨᱭ ᱟᱭᱞᱮᱸᱰᱥ',
 			'ID' => 'ᱤᱱᱰᱚᱱᱮᱥᱤᱭᱟ',
 			'IE' => 'ᱟᱭᱟᱹᱨᱞᱮᱸᱰ',
 			'IL' => 'ᱤᱥᱨᱟᱭᱮᱞ',
 			'IM' => 'ᱟᱭᱞ ᱚᱯᱷ ᱢᱮᱱ',
 			'IN' => 'ᱤᱱᱰᱤᱭᱟ',
 			'IO' => 'ᱵᱽᱨᱤᱴᱤᱥ ᱵᱷᱟᱨᱚᱛ ᱢᱟᱦᱟᱥᱟᱜᱚᱨ ᱡᱟᱭᱜᱟ',
 			'IQ' => 'ᱤᱨᱟᱠ',
 			'IR' => 'ᱤᱨᱟᱱ',
 			'IS' => 'ᱟᱭᱥᱞᱮᱸᱰ',
 			'IT' => 'ᱤᱴᱞᱤ',
 			'JE' => 'ᱡᱟᱹᱨᱥᱤ',
 			'JM' => 'ᱡᱟᱢᱟᱭᱠᱟ',
 			'JO' => 'ᱡᱚᱨᱰᱟᱱ',
 			'JP' => 'ᱡᱟᱯᱟᱱ',
 			'KE' => 'ᱠᱮᱱᱭᱟ',
 			'KG' => 'ᱠᱤᱨᱜᱤᱥᱛᱟᱱ',
 			'KH' => 'ᱠᱟᱹᱢᱵᱚᱰᱤᱭᱟ',
 			'KI' => 'ᱠᱤᱨᱤᱵᱚᱛᱤ',
 			'KM' => 'ᱠᱚᱢᱚᱨᱚᱥ',
 			'KN' => 'ᱮᱥ ᱴᱤ ᱠᱤᱴᱥ ᱟᱨ ᱱᱮᱣᱤᱥ',
 			'KP' => 'ᱮᱛᱚᱢ ᱠᱚᱨᱤᱭᱟ',
 			'KR' => 'ᱠᱚᱧᱮ ᱠᱚᱨᱤᱭᱟ',
 			'KW' => 'ᱠᱩᱣᱟᱹᱭᱛ',
 			'KY' => 'ᱠᱮᱢᱮᱱ ᱟᱭᱞᱮᱸᱰᱥ',
 			'KZ' => 'ᱠᱟᱡᱟᱠᱷᱟᱥᱛᱷᱟᱱ',
 			'LA' => 'ᱞᱟᱣᱚᱥ',
 			'LB' => 'ᱞᱮᱵᱟᱱᱟᱱ',
 			'LC' => 'ᱮᱥ ᱴᱤ ᱞᱩᱥᱤᱭᱟ',
 			'LI' => 'ᱞᱤᱪᱮᱥᱴᱤᱱ',
 			'LK' => 'ᱥᱨᱤ ᱞᱚᱝᱟ',
 			'LR' => 'ᱞᱟᱭᱵᱮᱨᱤᱭᱟ',
 			'LS' => 'ᱞᱮᱥᱚᱛᱷᱚ',
 			'LT' => 'ᱞᱤᱛᱷᱩᱣᱟᱱᱤᱭᱟ',
 			'LU' => 'ᱞᱤᱠᱡᱟᱹᱢᱵᱟᱹᱨᱜᱽ',
 			'LV' => 'ᱞᱟᱛᱣᱤᱭᱟ',
 			'LY' => 'ᱞᱤᱵᱭᱟ',
 			'MA' => 'ᱢᱚᱨᱚᱠᱚ',
 			'MC' => 'ᱢᱚᱱᱟᱠᱚ',
 			'MD' => 'ᱢᱚᱞᱰᱚᱣᱟ',
 			'ME' => 'ᱢᱚᱱᱴᱮᱱᱜᱽᱨᱚ',
 			'MF' => 'ᱮᱥ ᱴᱤ ᱢᱟᱨᱴᱤᱱ',
 			'MG' => 'ᱢᱟᱰᱟᱜᱟᱥᱠᱚᱨ',
 			'MH' => 'ᱢᱟᱨᱥᱟᱞ ᱟᱭᱞᱮᱸᱰ',
 			'MK' => 'ᱮᱛᱚᱢ ᱢᱟᱥᱮᱰᱚᱱᱤᱭᱟ',
 			'ML' => 'ᱢᱟᱞᱤ',
 			'MM' => 'ᱢᱭᱟᱱᱢᱟᱨ (ᱵᱟᱹᱨᱢᱟ)',
 			'MN' => 'ᱢᱚᱝᱜᱚᱞᱤᱭᱟ',
 			'MO' => 'ᱢᱟᱠᱟᱣ ᱥᱟᱨ ᱪᱟᱭᱱᱟ',
 			'MO@alt=short' => 'ᱢᱟᱠᱟᱣ',
 			'MP' => 'ᱮᱛᱚᱢ ᱢᱟᱨᱤᱭᱟᱱᱟ ᱟᱭᱞᱮᱸᱰ',
 			'MQ' => 'ᱢᱟᱨᱴᱤᱱᱠᱤᱣ',
 			'MR' => 'ᱢᱟᱣᱨᱤᱴᱟᱱᱤᱭᱟ',
 			'MS' => 'ᱢᱚᱱᱴᱥᱮᱨᱟᱴ',
 			'MT' => 'ᱢᱟᱞᱴᱟ',
 			'MU' => 'ᱢᱚᱨᱤᱥᱟᱹᱥ',
 			'MV' => 'ᱢᱟᱞᱰᱤᱵᱷᱥ',
 			'MW' => 'ᱢᱟᱹᱞᱟᱣᱤ',
 			'MX' => 'ᱢᱮᱠᱥᱤᱠᱚ',
 			'MY' => 'ᱢᱟᱹᱞᱮᱥᱤᱭᱟ',
 			'MZ' => 'ᱢᱚᱡᱟᱢᱵᱤᱠ',
 			'NA' => 'ᱱᱟᱢᱤᱵᱤᱭᱟ',
 			'NC' => 'ᱱᱟᱶᱟ ᱠᱟᱞᱮᱰᱚᱱᱤᱭᱟ',
 			'NE' => 'ᱱᱟᱭᱡᱟᱹᱨ',
 			'NF' => 'ᱱᱚᱨᱯᱷᱚᱞᱠ ᱟᱭᱞᱮᱸᱰ',
 			'NG' => 'ᱱᱟᱭᱡᱮᱨᱤᱭᱟ',
 			'NI' => 'ᱱᱤᱠᱟᱨᱟᱜᱩᱣᱟ',
 			'NL' => 'ᱱᱮᱫᱚᱨᱞᱮᱸᱰ',
 			'NO' => 'ᱱᱚᱨᱣᱮ',
 			'NP' => 'ᱱᱮᱯᱟᱞ',
 			'NR' => 'ᱱᱟᱶᱨᱩ',
 			'NU' => 'ᱱᱟᱭᱩ',
 			'NZ' => 'ᱱᱤᱭᱩ ᱡᱤᱞᱮᱸᱰ',
 			'OM' => 'ᱳᱢᱟᱱ',
 			'PA' => 'ᱯᱟᱱᱟᱢᱟ',
 			'PE' => 'ᱯᱮᱨᱩ',
 			'PF' => 'ᱯᱷᱨᱮᱧᱪ ᱯᱚᱞᱤᱱᱮᱥᱤᱭᱟ',
 			'PG' => 'ᱯᱟᱹᱯᱩᱣᱟ ᱱᱟᱶᱟ ᱡᱤᱱᱤᱭᱟ',
 			'PH' => 'ᱯᱷᱤᱞᱤᱯᱤᱱᱥ',
 			'PK' => 'ᱯᱟᱠᱮᱥᱛᱟᱱ',
 			'PL' => 'ᱯᱚᱞᱮᱸᱰ',
 			'PM' => 'ᱮᱥ ᱴᱤ ᱯᱟᱭᱨᱮ ᱟᱨ ᱢᱤᱠᱣᱮᱞᱮᱱ',
 			'PN' => 'ᱯᱤᱴᱠᱮᱨᱱ ᱟᱭᱞᱮᱸᱰ',
 			'PR' => 'ᱯᱩᱣᱮᱨᱴᱚ ᱨᱤᱠᱚ',
 			'PS' => 'ᱯᱟᱞᱮᱥᱴᱤᱱᱤᱭᱟᱹᱱ ᱡᱟᱭᱜᱟ',
 			'PS@alt=short' => 'ᱯᱟᱞᱮᱥᱴᱤᱱ',
 			'PT' => 'ᱯᱚᱨᱛᱩᱜᱟᱞ',
 			'PW' => 'ᱯᱟᱞᱟᱣ',
 			'PY' => 'ᱯᱟᱨᱟᱜᱩᱣᱮ',
 			'QA' => 'ᱠᱚᱛᱚᱨ',
 			'QO' => 'ᱟᱩᱴᱞᱟᱭᱤᱱᱤᱜ ᱚᱥᱮᱱᱤᱟ',
 			'RE' => 'ᱨᱤᱭᱩᱱᱤᱭᱟᱹᱱ',
 			'RO' => 'ᱨᱚᱢᱟᱱᱤᱭᱟ',
 			'RS' => 'ᱥᱟᱹᱨᱵᱤᱭᱟ',
 			'RU' => 'ᱨᱩᱥ',
 			'RW' => 'ᱨᱟᱹᱣᱟᱹᱱᱰᱟ',
 			'SA' => 'ᱥᱟᱹᱣᱫᱤ ᱚᱨᱚᱵ',
 			'SB' => 'ᱥᱚᱞᱚᱢᱚᱱ ᱟᱭᱞᱮᱸᱰ',
 			'SC' => 'ᱥᱮᱥᱮᱞᱥ',
 			'SD' => 'ᱥᱩᱫᱟᱱ',
 			'SE' => 'ᱥᱣᱤᱰᱮᱱ',
 			'SG' => 'ᱥᱤᱝᱜᱟᱯᱩᱨ',
 			'SH' => 'ᱮᱥ ᱴᱤ ᱦᱮᱞᱮᱱᱟ',
 			'SI' => 'ᱥᱞᱚᱣᱮᱱᱤᱭᱟ',
 			'SJ' => 'ᱥᱣᱟᱞᱵᱟᱰ ᱟᱨ ᱡᱟᱱ ᱢᱟᱭᱮᱱ',
 			'SK' => 'ᱥᱞᱚᱣᱮᱠᱤᱭᱟ',
 			'SL' => 'ᱥᱟᱭᱨᱟ ᱞᱮᱭᱚᱱᱤ',
 			'SM' => 'ᱥᱟᱱ ᱢᱟᱨᱤᱱᱚ',
 			'SN' => 'ᱥᱮᱱᱮᱜᱚᱞ',
 			'SO' => 'ᱥᱚᱢᱟᱞᱤᱭᱟ',
 			'SR' => 'ᱥᱩᱨᱤᱱᱟᱢ',
 			'SS' => 'ᱠᱚᱧᱮ ᱥᱩᱫᱟᱱ',
 			'ST' => 'ᱥᱟᱣ ᱴᱚᱢ ᱟᱨ ᱯᱨᱤᱱᱥᱤᱯᱮ',
 			'SV' => 'ᱮᱞ ᱥᱟᱞᱣᱟᱰᱚᱨ',
 			'SX' => 'ᱥᱤᱱᱴ ᱢᱟᱨᱴᱮᱱ',
 			'SY' => 'ᱥᱤᱨᱤᱭᱟ',
 			'SZ' => 'ᱮᱥᱣᱟᱴᱤᱱᱟ',
 			'SZ@alt=variant' => 'ᱥᱣᱟᱡᱤᱞᱮᱸᱰ',
 			'TA' => 'ᱛᱨᱤᱥᱛᱟᱱ ᱰᱟ ᱠᱩᱱᱦᱟ',
 			'TC' => 'ᱛᱩᱨᱠᱥ ᱟᱨ ᱠᱟᱭᱠᱚᱥ ᱟᱭᱞᱮᱸᱰ',
 			'TD' => 'ᱪᱟᱰ',
 			'TF' => 'ᱯᱷᱨᱟᱱᱥᱤᱥ ᱠᱚᱧᱮ ᱡᱟᱭᱜᱟ',
 			'TG' => 'ᱴᱚᱜᱚ',
 			'TH' => 'ᱛᱷᱟᱭᱞᱮᱸᱰ',
 			'TJ' => 'ᱛᱟᱡᱤᱠᱤᱥᱛᱟᱱ',
 			'TK' => 'ᱴᱚᱠᱮᱞᱟᱣ',
 			'TL' => 'ᱴᱤᱢᱚᱨᱼᱞᱮᱥᱴᱮ',
 			'TL@alt=variant' => 'ᱥᱟᱢᱟᱝ ᱴᱤᱢᱚᱨ',
 			'TM' => 'ᱛᱩᱨᱠᱢᱮᱱᱤᱥᱛᱟᱱ',
 			'TN' => 'ᱴᱩᱱᱤᱥᱤᱭᱟ',
 			'TO' => 'ᱴᱚᱝᱜᱟ',
 			'TR' => 'ᱛᱟᱹᱨᱠᱤ',
 			'TT' => 'ᱴᱨᱤᱱᱤᱰᱟᱰ ᱟᱨ ᱴᱚᱵᱟᱜᱚ',
 			'TV' => 'ᱴᱩᱣᱟᱞᱩ',
 			'TW' => 'ᱛᱟᱭᱣᱟᱱ',
 			'TZ' => 'ᱛᱟᱹᱱᱡᱟᱱᱤᱭᱟ',
 			'UA' => 'ᱭᱩᱠᱨᱮᱱ',
 			'UG' => 'ᱩᱜᱟᱱᱰᱟ',
 			'UM' => 'ᱭᱩ ᱮᱥ ᱵᱟᱷᱨᱮ ᱟᱭᱞᱮᱸᱰ',
 			'UN' => 'ᱡᱩᱢᱤᱫ ᱫᱤᱥᱚᱢ',
 			'US' => 'ᱭᱩᱱᱟᱭᱴᱮᱰ ᱮᱥᱴᱮᱴ',
 			'US@alt=short' => 'ᱭᱩ ᱮᱥ',
 			'UY' => 'ᱩᱨᱩᱜᱩᱣᱮ',
 			'UZ' => 'ᱩᱡᱽᱵᱮᱠᱤᱥᱛᱟᱱ',
 			'VA' => 'ᱣᱟᱴᱤᱠᱟᱱ ᱥᱚᱦᱚᱨ',
 			'VC' => 'ᱮᱥ ᱴᱤ ᱵᱷᱤᱱᱥᱮᱴ ᱟᱨ ᱜᱽᱨᱮᱱᱟᱰᱤᱱᱥ',
 			'VE' => 'ᱣᱮᱱᱮᱡᱣᱮᱞᱟ',
 			'VG' => 'ᱵᱽᱨᱤᱴᱤᱥ ᱣᱟᱹᱨᱡᱤᱱ ᱟᱭᱞᱮᱸᱰ',
 			'VI' => 'ᱭᱩ ᱮᱥ ᱣᱟᱹᱨᱡᱤᱱ ᱟᱭᱞᱮᱸᱰ',
 			'VN' => 'ᱣᱤᱭᱮᱛᱱᱟᱢ',
 			'VU' => 'ᱵᱷᱟᱱᱩᱟᱴᱩ',
 			'WF' => 'ᱣᱟᱞᱤᱥ ᱟᱨ ᱯᱷᱩᱴᱩᱱᱟ',
 			'WS' => 'ᱥᱟᱢᱚᱣᱟ',
 			'XA' => 'ᱥᱤᱰᱚᱼᱟᱥᱮᱱᱴᱥ',
 			'XB' => 'ᱥᱤᱰᱚᱼᱵᱤᱰᱤ',
 			'XK' => 'ᱠᱚᱥᱚᱣᱚ',
 			'YE' => 'ᱭᱮᱢᱮᱱ',
 			'YT' => 'ᱢᱟᱭᱚᱴᱮ',
 			'ZA' => 'ᱠᱚᱧᱮ ᱟᱯᱷᱨᱤᱠᱟ',
 			'ZM' => 'ᱡᱟᱢᱵᱤᱭᱟ',
 			'ZW' => 'ᱡᱤᱢᱵᱟᱣᱮ',
 			'ZZ' => 'ᱵᱟᱝᱩᱨᱩᱢ ᱴᱚᱴᱷᱟ',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'POLYTON' => 'ᱯᱚᱞᱤᱴᱚᱱᱤᱠ',
 			'POSIX' => 'ᱠᱚᱢᱯᱩᱴᱚᱨ',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'ᱢᱟᱦᱮᱛᱟ',
 			'cf' => 'ᱯᱩᱭᱥᱟᱹ ᱯᱷᱚᱨᱢᱟᱴ',
 			'collation' => 'ᱛᱷᱟᱨ ᱟᱸᱫᱮ',
 			'currency' => 'ᱯᱩᱭᱥᱟᱹ',
 			'hc' => 'ᱴᱟᱰᱟᱝ ᱨᱮᱭᱟᱜ ᱪᱚᱠᱚᱨ (12 ᱵᱚᱱᱟᱢ 24)',
 			'lb' => 'ᱞᱟᱹᱭᱤᱱ ᱨᱟᱹᱯᱩᱫ ᱥᱟᱡᱟᱣ',
 			'ms' => 'ᱢᱟᱯ ᱰᱟᱦᱮᱨᱟ',
 			'numbers' => 'ᱞᱮᱠᱷᱟ',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ᱵᱚᱣᱫᱷ ᱢᱟᱦᱮᱛᱟ},
 				'chinese' => q{ᱪᱟᱭᱱᱤᱡᱽ ᱢᱟᱦᱮᱛᱟ},
 				'coptic' => q{ᱠᱚᱯᱴᱤᱠ ᱢᱟᱦᱮᱛᱟ},
 				'dangi' => q{ᱰᱟᱱᱜᱤ ᱢᱟᱦᱮᱛᱟ},
 				'ethiopic' => q{ᱤᱛᱷᱤᱭᱚᱯᱤᱠ ᱢᱟᱦᱮᱛᱟ},
 				'ethiopic-amete-alem' => q{ᱤᱛᱷᱤᱭᱚᱯᱤᱠ ᱟᱢᱮᱴᱮ ᱟᱞᱮᱢ ᱢᱟᱦᱮᱛᱟ},
 				'gregorian' => q{ᱜᱨᱮᱜᱚᱨᱤᱭᱟᱱ ᱠᱟᱞᱮᱱᱰᱟᱨ},
 				'hebrew' => q{ᱦᱮᱵᱽᱨᱤᱣ ᱢᱟᱦᱮᱛᱟ},
 				'indian' => q{ᱵᱷᱟᱨᱚᱛ ᱡᱟᱹᱛᱤᱭᱟᱹᱨᱤ ᱢᱟᱦᱮᱛᱟ},
 				'islamic' => q{ᱤᱥᱞᱟᱢᱤᱠ ᱢᱟᱦᱮᱛᱟ},
 				'islamic-civil' => q{ᱤᱥᱞᱟᱢᱤᱠ ᱱᱟᱜᱽᱨᱤᱠ ᱢᱟᱦᱮᱛᱟ},
 				'islamic-rgsa' => q{ᱤᱥᱞᱟᱢᱤᱠ ᱚᱨᱵᱤ ᱢᱟᱦᱮᱛᱟ},
 				'islamic-tbla' => q{ᱤᱥᱞᱟᱢᱤᱠ ᱛᱷᱚᱠ ᱢᱟᱦᱮᱛᱟ},
 				'islamic-umalqura' => q{ᱤᱥᱞᱟᱢᱤᱠ ᱩᱢ ᱟᱹᱞ ᱠᱩᱨᱟ ᱢᱟᱦᱮᱛᱟ},
 				'iso8601' => q{ᱟᱭᱮᱥᱚᱼ8601 ᱠᱮᱞᱮᱱᱰᱚᱨ},
 				'japanese' => q{ᱡᱟᱯᱟᱱᱤᱡᱽ ᱢᱟᱦᱮᱛᱟ},
 				'persian' => q{ᱯᱟᱨᱥᱤ ᱢᱟᱦᱮᱛᱟ},
 				'roc' => q{ᱢᱤᱱᱜᱩᱣᱚ ᱢᱟᱦᱮᱛᱟ},
 			},
 			'cf' => {
 				'account' => q{ᱯᱩᱭᱥᱟᱹ ᱠᱷᱟᱛᱟ ᱯᱷᱚᱨᱢᱟᱴ},
 				'standard' => q{ᱢᱩᱞ ᱯᱩᱭᱥᱟᱹ ᱯᱷᱚᱨᱢᱟᱴ},
 			},
 			'collation' => {
 				'big5han' => q{ᱫᱤᱥᱤ ᱪᱟᱭᱱᱤᱡᱽ ᱛᱷᱟᱨ ᱟᱸᱫᱮ},
 				'compat' => q{ᱢᱟᱲᱟᱝ ᱛᱷᱟᱨ ᱟᱸᱫᱮ},
 				'dictionary' => q{ᱥᱟᱵᱟᱫ ᱜᱟᱫᱮᱞ ᱛᱷᱟᱨ ᱟᱸᱫᱮ},
 				'ducet' => q{ᱢᱩᱞ ᱭᱩᱱᱤᱠᱳᱰ ᱛᱷᱟᱨ ᱟᱸᱫᱮ},
 				'emoji' => q{ᱤᱢᱚᱡᱤ ᱛᱷᱟᱨ ᱟᱸᱫᱮ},
 				'eor' => q{ᱭᱩᱨᱚᱯᱤᱭᱟᱹᱱ ᱛᱷᱟᱨ ᱟᱸᱫᱮ},
 				'gb2312han' => q{ᱥᱚᱦᱚᱡᱽ ᱪᱟᱭᱱᱤᱡᱽ ᱛᱷᱟᱨ ᱟᱸᱫᱮ},
 				'phonebook' => q{ᱯᱷᱚᱱᱯᱚᱛᱚᱵ ᱛᱷᱟᱨ ᱟᱸᱫᱮ},
 				'pinyin' => q{ᱯᱤᱱᱭᱟᱱ ᱛᱷᱟᱨ ᱟᱸᱫᱮ},
 				'reformed' => q{ᱫᱩᱦᱲᱟᱹ ᱛᱮᱭᱟᱨ ᱛᱷᱟᱨ ᱟᱸᱫᱮ},
 				'search' => q{ᱥᱟᱱᱟᱢ ᱠᱟᱹᱢᱤᱦᱚᱨᱟ ᱥᱮᱸᱫᱽᱨᱟ},
 				'searchjl' => q{ᱦᱟᱱᱜᱩᱞ ᱮᱛᱦᱚᱵ ᱠᱮᱪᱮᱫ ᱟᱲᱟᱝ ᱛᱮ ᱥᱮᱸᱫᱽᱨᱟ},
 				'standard' => q{ᱮᱥᱴᱮᱱᱰᱟᱨᱰ ᱛᱷᱟᱨ ᱟᱸᱫᱮ},
 				'stroke' => q{ᱥᱴᱨᱚᱠ ᱛᱷᱟᱨ ᱟᱸᱫᱮ},
 				'traditional' => q{ᱫᱤᱥᱤ ᱛᱷᱟᱨ ᱟᱸᱫᱮ},
 				'unihan' => q{ᱨᱮᱰᱤᱠᱟᱼᱥᱴᱨᱚᱠ ᱛᱷᱟᱨ ᱟᱸᱫᱮ},
 				'zhuyin' => q{ᱡᱷᱩᱣᱤᱱ ᱛᱷᱟᱨ ᱟᱸᱫᱮ},
 			},
 			'hc' => {
 				'h11' => q{12 ᱴᱟᱰᱟᱝ ᱰᱟᱦᱮᱨᱟ (0–11)},
 				'h12' => q{12 ᱴᱟᱰᱟᱝ ᱰᱟᱦᱮᱨᱟ (1–12)},
 				'h23' => q{24 ᱴᱟᱰᱟᱝ ᱰᱟᱦᱮᱨᱟ (0–23)},
 				'h24' => q{24 ᱴᱟᱰᱟᱝ ᱰᱟᱦᱮᱨᱟ (1–24)},
 			},
 			'lb' => {
 				'loose' => q{ᱰᱷᱤᱞ ᱞᱟᱹᱭᱤᱱ ᱨᱟᱹᱯᱩᱫ ᱥᱟᱡᱟᱣ},
 				'normal' => q{ᱥᱟᱫᱷᱨᱚᱬ ᱞᱟᱹᱭᱤᱱ ᱨᱟᱹᱯᱩᱫ ᱥᱟᱡᱟᱣ},
 				'strict' => q{ᱟᱸᱴ ᱞᱟᱹᱭᱤᱱ ᱨᱟᱹᱯᱩᱫ ᱥᱟᱡᱟᱣ},
 			},
 			'ms' => {
 				'metric' => q{ᱢᱮᱴᱨᱤᱠ ᱰᱟᱦᱮᱨᱟ},
 				'uksystem' => q{ᱤᱢᱯᱮᱨᱤᱭᱮᱞ ᱢᱟᱯ ᱰᱟᱦᱮᱨᱟ},
 				'ussystem' => q{ᱭᱩ ᱮᱥ ᱢᱟᱯ ᱰᱟᱦᱮᱨᱟ},
 			},
 			'numbers' => {
 				'ahom' => q{ᱟᱹᱦᱚᱢ ᱮᱞᱠᱷᱟ},
 				'arab' => q{ᱚᱨᱵᱤᱼᱚᱱᱰᱤᱠ ᱮᱞᱠᱷᱟ},
 				'arabext' => q{ᱯᱟᱥᱱᱟᱣ ᱠᱟᱱ ᱚᱨᱵᱤᱼᱤᱱᱰᱤᱠ ᱮᱞᱠᱷᱟ},
 				'armn' => q{ᱟᱨᱢᱮᱱᱤᱟᱭ ᱮᱞᱠᱷᱟ},
 				'armnlow' => q{ᱟᱨᱢᱮᱱᱤᱭᱟᱭ ᱦᱩᱰᱤᱧ ᱮᱞᱠᱷᱟ},
 				'bali' => q{ᱵᱟᱞᱤᱱᱮᱥ ᱮᱞᱠᱷᱟ},
 				'beng' => q{ᱵᱟᱝᱞᱟ ᱮᱞᱠᱷᱟ},
 				'brah' => q{ᱵᱽᱨᱟᱢᱦᱤ ᱮᱞᱠᱷᱟ},
 				'cakm' => q{ᱪᱷᱟᱠᱢᱟ ᱮᱞᱠᱷᱟ},
 				'cham' => q{ᱪᱷᱟᱢ ᱮᱞᱠᱷᱟ},
 				'cyrl' => q{ᱥᱟᱭᱠᱨᱤᱞᱤᱠ ᱮᱞᱠᱷᱟ},
 				'deva' => q{ᱫᱮᱣᱟᱹᱱᱟᱜᱽᱨᱤ ᱮᱞᱠᱷᱟ},
 				'diak' => q{ᱰᱤᱣᱮᱥ ᱟᱠᱨᱩ ᱮᱞᱠᱷᱟ},
 				'ethi' => q{ᱤᱛᱷᱤᱭᱚᱯᱤᱠ ᱮᱞᱠᱷᱟ},
 				'fullwide' => q{ᱯᱩᱨᱟᱹ ᱚᱥᱟᱨ ᱮᱞᱠᱷᱟ},
 				'geor' => q{ᱡᱭᱚᱨᱡᱤᱭᱟᱱ ᱮᱞᱠᱷᱟ},
 				'gong' => q{ᱜᱩᱧᱡᱟᱞᱟ ᱜᱚᱱᱰᱤ ᱮᱞᱠᱷᱟ},
 				'gonm' => q{ᱢᱟᱥᱟᱨᱟᱢ ᱜᱚᱱᱰᱤ ᱮᱞᱠᱷᱟ},
 				'grek' => q{ᱜᱽᱨᱤᱠ ᱮᱞᱠᱷᱟ},
 				'greklow' => q{ᱜᱽᱨᱤᱠ ᱦᱩᱰᱤᱧ ᱮᱞᱠᱷᱟ},
 				'gujr' => q{ᱜᱩᱡᱽᱨᱟᱴᱤ ᱮᱞᱠᱷᱟ},
 				'guru' => q{ᱜᱩᱨᱩᱢᱩᱠᱷᱤ ᱮᱞᱠᱷᱟ},
 				'hanidec' => q{ᱪᱟᱭᱱᱤᱡᱽ ᱰᱮᱥᱤᱢᱟᱹᱞ ᱮᱞᱠᱷᱟ},
 				'hans' => q{ᱥᱚᱦᱚᱡᱽ ᱪᱤᱱ ᱮᱞᱠᱷᱟ},
 				'hansfin' => q{ᱥᱚᱦᱚᱡᱽ ᱪᱤᱱ ᱯᱷᱟᱭᱱᱮᱱᱥᱤᱟᱹᱞ ᱮᱞᱠᱷᱟ},
 				'hebr' => q{ᱦᱮᱵᱽᱨᱤᱣ ᱮᱞᱠᱷᱟ},
 				'hmng' => q{ᱯᱟᱦᱟᱣ ᱢᱚᱝ ᱮᱞᱠᱷᱟ},
 				'hmnp' => q{ᱱᱤᱭᱟᱠᱮᱝ ᱯᱩᱣᱟᱪᱷᱮ ᱢᱚᱝ ᱮᱞᱠᱷᱟ},
 				'java' => q{ᱡᱟᱣᱟᱱᱤᱡᱽ ᱮᱞᱠᱷᱟ},
 				'jpan' => q{ᱡᱟᱯᱟᱱᱤᱡᱽ ᱮᱞᱠᱷᱟ},
 				'jpanfin' => q{ᱡᱟᱯᱟᱱᱤᱡᱽ ᱯᱷᱟᱭᱱᱮᱱᱥᱤᱟᱹᱞ ᱮᱞᱠᱷᱟ},
 				'kali' => q{ᱡᱟᱭᱟᱦ ᱞᱤ ᱮᱞᱠᱷᱟ},
 				'kawi' => q{ᱠᱟᱣᱤ ᱮᱞᱠᱷᱟ},
 				'khmr' => q{ᱠᱷᱟᱹᱢᱮᱨ ᱮᱞᱠᱷᱟ},
 				'knda' => q{ᱠᱚᱱᱚᱰ ᱮᱞᱠᱷᱟ},
 				'lana' => q{ᱛᱟᱭᱤ ᱛᱷᱟᱢ ᱦᱚᱨᱟ ᱮᱞᱠᱷᱟ},
 				'lanatham' => q{ᱛᱟᱭᱤ ᱛᱷᱟᱢ ᱛᱷᱟᱢ ᱮᱞᱠᱷᱟ},
 				'laoo' => q{ᱞᱟᱣ ᱮᱞᱠᱷᱟ},
 				'latn' => q{ᱣᱮᱥᱴᱟᱨᱱ ᱮᱞ},
 				'lepc' => q{ᱞᱮᱯᱪᱟ ᱮᱞᱠᱷᱟ},
 				'limb' => q{ᱞᱤᱢᱵᱩ ᱮᱞᱠᱷᱟ},
 				'mlym' => q{ᱢᱟᱹᱞᱭᱟᱞᱟᱹᱢ ᱮᱞᱠᱷᱟ},
 				'modi' => q{ᱢᱚᱰᱤ ᱮᱞᱠᱷᱟ},
 				'mong' => q{ᱢᱚᱱᱜᱚᱞᱤᱭᱟᱭ ᱮᱞᱠᱷᱟ},
 				'mroo' => q{ᱢᱨᱚ ᱮᱞᱠᱷᱟ},
 				'mtei' => q{ᱢᱤᱴᱮᱭᱤ ᱢᱮᱭᱟᱠ ᱮᱞᱠᱷᱟ},
 				'mymr' => q{ᱢᱭᱟᱱᱢᱟᱨ ᱮᱞᱠᱷᱟ},
 				'mymrshan' => q{ᱢᱭᱟᱱᱢᱟᱨ ᱥᱟᱱ ᱮᱞᱠᱷᱟ},
 				'mymrtlng' => q{ᱢᱭᱟᱱᱢᱟᱨ ᱴᱚᱭᱤ ᱞᱤᱭᱟᱝ ᱮᱞᱠᱷᱟ},
 				'nagm' => q{ᱱᱚᱜᱽ ᱢᱩᱱᱰᱟᱨᱤ ᱮᱞᱠᱷᱟ},
 				'nkoo' => q{ᱱᱚᱠᱚ ᱮᱞᱠᱷᱟ},
 				'olck' => q{ᱚᱞ ᱪᱤᱠᱤ ᱮᱞᱠᱷᱟ},
 				'orya' => q{ᱳᱰᱤᱭᱟ ᱮᱞᱠᱷᱟ},
 				'osma' => q{ᱚᱥᱢᱟᱱᱭᱟ ᱮᱞᱠᱷᱟ},
 				'rohg' => q{ᱦᱟᱱᱤᱯᱷᱤ ᱨᱚᱦᱤᱱᱭᱟ ᱮᱞᱠᱷᱟ},
 				'roman' => q{ᱨᱚᱢᱟᱱ ᱮᱞᱠᱷᱟ},
 				'romanlow' => q{ᱨᱚᱢᱟᱱ ᱦᱩᱰᱤᱧ ᱮᱞᱠᱷᱟ},
 				'saur' => q{ᱥᱟᱹᱣᱨᱟᱥᱴᱨᱚ ᱮᱞᱠᱷᱟ},
 				'shrd' => q{ᱥᱟᱨᱟᱰᱟ ᱮᱞᱠᱷᱟ},
 				'sind' => q{ᱠᱷᱩᱰᱟᱣᱟᱰᱤ ᱮᱞᱠᱷᱟ},
 				'sinh' => q{ᱥᱤᱱᱦᱟᱞᱟ ᱞᱤᱛᱷ ᱮᱞᱠᱷᱟ},
 				'sora' => q{ᱥᱚᱨᱟ ᱥᱚᱢᱯᱮᱝ ᱮᱞᱠᱷᱟ},
 				'sund' => q{ᱥᱩᱱᱰᱟᱱᱥ ᱮᱞᱠᱷᱟ},
 				'takr' => q{ᱴᱟᱠᱨᱤ ᱮᱞᱠᱷᱟ},
 				'talu' => q{ᱱᱟᱶᱟ ᱴᱟᱭᱤ ᱞᱩᱣᱮ ᱮᱞᱠᱷᱟ},
 				'tamldec' => q{ᱛᱟᱹᱢᱤᱞ ᱮᱞᱠᱷᱟ},
 				'telu' => q{ᱛᱮᱞᱩᱜᱩ ᱮᱞᱠᱷᱟ},
 				'thai' => q{ᱛᱷᱟᱤ ᱮᱞᱠᱷᱟ},
 				'tibt' => q{ᱛᱤᱵᱮᱛᱟᱱ ᱮᱞᱠᱷᱟ},
 				'tirh' => q{ᱛᱤᱨᱦᱩᱴᱟ ᱮᱞᱠᱷᱟ},
 				'tnsa' => q{ᱴᱟᱝᱥᱟ ᱮᱞᱠᱷᱟ},
 				'vaii' => q{ᱣᱟᱭ ᱮᱞᱠᱷᱟ},
 				'wara' => q{ᱨᱟᱝ ᱪᱤᱛᱤ ᱮᱞᱠᱷᱟ},
 				'wcho' => q{ᱣᱟᱱᱪᱩ ᱮᱞᱠᱷᱟ},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{ᱢᱮᱴᱨᱤᱠ},
 			'UK' => q{ᱭᱩᱠᱮ},
 			'US' => q{ᱭᱩᱮᱥ},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'ᱯᱟᱹᱨᱥᱤ: {0}',
 			'script' => 'ᱪᱤᱠᱤ/ᱦᱟᱨᱚᱯᱺ {0}',
 			'region' => 'ᱴᱚᱴᱷᱟᱺ {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			main => qr{[ᱚ ᱛ ᱜ ᱝ ᱞ ᱟ ᱠ ᱡ ᱢ ᱣ ᱤ ᱥ ᱦ ᱧ ᱨ ᱩ ᱪ ᱫ ᱬ ᱭ ᱮ ᱯ ᱰ ᱱ ᱲ ᱳ ᱴ ᱵ ᱶ ᱷ ᱸ ᱹ ᱺ ᱻ ᱼ ᱽ]},
			numbers => qr{[\- ‑ , . % + 0᱐ 1᱑ 2᱒ 3᱓ 4᱔ 5᱕ 6᱖ 7᱗ 8᱘ 9᱙]},
		};
	},
EOT
: sub {
		return {};
},
);


has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(ᱢᱩᱞ ᱟᱸᱫᱮ),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(ᱢᱩᱞ ᱟᱸᱫᱮ),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'one' => q({0}dsp-Imp),
						'other' => q({0} dstspn Imp),
						'two' => q({0} dstspn Imp),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'one' => q({0}dsp-Imp),
						'other' => q({0} dstspn Imp),
						'two' => q({0} dstspn Imp),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(ᱟᱸᱫᱮ),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(ᱟᱸᱫᱮ),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ᱦᱚᱸᱺᱦ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ᱵᱟᱝᱺᱵ|no|n)$' }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'olck',
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'BMD' => {
			display_name => {
				'currency' => q(ᱵᱟᱹᱨᱢᱩᱰᱟ ᱰᱚᱞᱟᱨ),
				'one' => q(ᱵᱟᱹᱨᱢᱩᱰᱟ ᱰᱚᱞᱟᱨ),
				'other' => q(ᱵᱟᱹᱨᱢᱩᱰᱟ ᱰᱚᱞᱟᱨ ᱠᱚ),
				'two' => q(ᱵᱟᱹᱨᱢᱩᱰᱟ ᱰᱚᱞᱟᱨ ᱠᱤᱱ),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(ᱵᱨᱟᱡᱤᱞᱤᱭᱟᱱ ᱨᱤᱭᱟᱹᱞ),
				'one' => q(ᱵᱨᱟᱡᱤᱞᱤᱭᱟᱱ ᱨᱤᱭᱟᱹᱞ),
				'other' => q(ᱵᱨᱟᱡᱤᱞᱤᱭᱟᱱ ᱨᱤᱭᱟᱹᱞᱥ),
				'two' => q(ᱵᱨᱟᱡᱤᱞᱤᱭᱟᱱ ᱨᱤᱭᱟᱹᱞᱥ),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(ᱪᱤᱱᱤ ᱭᱩᱣᱟᱱ),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(ᱭᱩᱨᱚ),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(ᱵᱨᱤᱴᱤᱥ ᱯᱟᱣᱩᱸᱰ),
				'one' => q(ᱵᱨᱤᱴᱤᱥ ᱯᱟᱣᱩᱸᱰ),
				'other' => q(ᱵᱨᱤᱴᱤᱥ ᱯᱟᱣᱩᱸᱰᱥ),
				'two' => q(ᱵᱨᱤᱴᱤᱥ ᱯᱟᱣᱩᱸᱰᱥ),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(ᱥᱤᱧᱚᱛ ᱨᱮᱱᱟᱜ ᱴᱟᱠᱟ),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(ᱡᱟᱯᱟᱱᱤ ᱭᱮᱱ),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(ᱨᱩᱥᱤ ᱨᱩᱵᱟᱹᱞ),
				'one' => q(ᱨᱩᱥᱤ ᱨᱩᱵᱟᱹᱞ),
				'other' => q(ᱨᱩᱥᱤ ᱨᱩᱵᱟᱹᱞᱥ),
				'two' => q(ᱨᱩᱥᱤ ᱨᱩᱵᱟᱹᱞᱥ),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(ᱭᱩᱮᱥ ᱰᱚᱞᱟᱨ),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(ᱵᱟᱝᱩᱨᱩᱢ ᱠᱟᱨᱮᱱᱥᱤ),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ᱡᱟᱱ',
							'ᱯᱷᱟ',
							'ᱢᱟᱨ',
							'ᱟᱯᱨ',
							'ᱢᱮ',
							'ᱡᱩᱱ',
							'ᱡᱩᱞ',
							'ᱟᱜᱟ',
							'ᱥᱮᱯ',
							'ᱚᱠᱴ',
							'ᱱᱟᱣ',
							'ᱫᱤᱥ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ᱡᱟᱱᱣᱟᱨᱤ',
							'ᱯᱷᱟᱨᱣᱟᱨᱤ',
							'ᱢᱟᱨᱪ',
							'ᱟᱯᱨᱮᱞ',
							'ᱢᱮ',
							'ᱡᱩᱱ',
							'ᱡᱩᱞᱟᱭ',
							'ᱟᱜᱟᱥᱛ',
							'ᱥᱮᱯᱴᱮᱢᱵᱟᱨ',
							'ᱚᱠᱴᱚᱵᱟᱨ',
							'ᱱᱟᱣᱟᱢᱵᱟᱨ',
							'ᱫᱤᱥᱟᱢᱵᱟᱨ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ᱡ',
							'ᱯ',
							'ᱢ',
							'ᱟ',
							'ᱢ',
							'ᱡ',
							'ᱡ',
							'ᱟ',
							'ᱥ',
							'ᱚ',
							'ᱱ',
							'ᱫ'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'ᱢᱟᱜᱽ',
							'ᱯᱷᱟ.ᱜᱩᱱ',
							'ᱪᱟ.ᱛ',
							'ᱵᱟ.ᱭᱥᱟ.ᱠ',
							'ᱡᱷᱮᱴ',
							'ᱟᱥᱟᱲ',
							'ᱥᱟᱱ',
							'ᱵᱷᱟᱫᱚᱨᱵ',
							'ᱫᱟᱥᱟᱸᱭ',
							'ᱥᱚᱦᱨᱟᱭ',
							'ᱟᱜᱷᱟᱲ',
							'ᱯᱩᱥ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'᱑',
							'᱒',
							'᱓',
							'᱔',
							'᱕',
							'᱖',
							'᱗',
							'᱘',
							'᱙',
							'᱑᱐',
							'᱑᱑',
							'᱑᱒'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ᱚᱛ',
						tue => 'ᱵᱟ',
						wed => 'ᱥᱟᱹ',
						thu => 'ᱥᱟᱹᱨ',
						fri => 'ᱡᱟᱹ',
						sat => 'ᱧᱩ',
						sun => 'ᱥᱤᱸ'
					},
					wide => {
						mon => 'ᱚᱛᱮ',
						tue => 'ᱵᱟᱞᱮ',
						wed => 'ᱥᱟᱹᱜᱩᱱ',
						thu => 'ᱥᱟᱹᱨᱫᱤ',
						fri => 'ᱡᱟᱹᱨᱩᱢ',
						sat => 'ᱧᱩᱦᱩᱢ',
						sun => 'ᱥᱤᱸᱜᱮ'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'ᱚ',
						tue => 'ᱵ',
						wed => 'ᱥ',
						thu => 'ᱥ',
						fri => 'ᱡ',
						sat => 'ᱧ',
						sun => 'ᱥ'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					wide => {0 => '᱑ᱟᱜ ᱯᱮ ᱪᱟᱸᱫᱚᱠᱤᱭᱟᱹ',
						1 => '᱒ᱟᱜ ᱯᱮ ᱪᱟᱸᱫᱚᱠᱤᱭᱟᱹ',
						2 => '᱓ᱭᱟᱜ ᱯᱮ ᱪᱟᱸᱫᱚᱠᱤᱭᱟᱹ',
						3 => '᱔ᱟᱜ ᱯᱮ ᱪᱟᱸᱫᱚᱠᱤᱭᱟᱹ'
					},
				},
				'stand-alone' => {
					narrow => {0 => '᱑',
						1 => '᱒',
						2 => '᱓',
						3 => '᱔'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'am' => q{ᱥᱮᱛᱟᱜ},
					'pm' => q{ᱧᱤᱫᱟᱹ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			abbreviated => {
				'0' => 'ᱥᱮᱨᱢᱟ ᱞᱟᱦᱟ',
				'1' => 'ᱤᱥᱣᱤ'
			},
			narrow => {
				'0' => 'ᱡᱤ',
				'1' => 'ᱥᱮ'
			},
			wide => {
				'0' => 'ᱡᱤᱥᱩ ᱢᱟᱲᱟᱝ',
				'1' => 'ᱥᱮᱨᱢᱟ ᱥᱚᱱ'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'ᱥᱟᱠᱟ'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'full' => q{EEEE, d MMMM y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{d/M/yy},
		},
		'indian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		gmtFormat => q(ᱡᱤᱮᱢᱴᱤ{0}),
		gmtZeroFormat => q(ᱡᱤᱮᱢᱴᱤ),
		regionFormat => q({0} ᱚᱠᱛᱚ),
		regionFormat => q({0} ᱫᱤᱱᱵᱮᱲᱟ ᱚᱠᱛᱚ),
		regionFormat => q({0} ᱢᱟᱱᱚᱠ ᱚᱠᱛᱚ),
		'Africa/Abidjan' => {
			exemplarCity => q#ᱟ.ᱵᱤᱰᱡᱟᱱ#,
		},
		'Alaska' => {
			long => {
				'daylight' => q#ᱟᱹᱞᱟᱥᱠᱟ ᱥᱤᱧᱟᱜ ᱚᱠᱛᱚ#,
				'generic' => q#ᱟᱹᱞᱟᱥᱠᱟ ᱚᱠᱛᱚ#,
				'standard' => q#ᱟᱹᱞᱟᱥᱠᱟ ᱮᱥᱴᱮᱱᱰᱟᱨᱰ ᱚᱠᱛᱚ#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#ᱟᱢᱟᱡᱚᱱ ᱥᱤᱛᱩᱝ ᱚᱠᱴᱚ#,
				'generic' => q#ᱟᱢᱟᱡᱚᱱ ᱚᱠᱴᱚ#,
				'standard' => q#ᱟᱢᱟᱡᱚᱱ ᱮᱴᱮᱱᱰᱟᱨᱰ ᱚᱠᱴᱚ#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#ᱟᱰᱟᱠ#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ᱟᱱᱠᱷᱚᱨᱮᱡᱽ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ᱟᱱᱜᱩᱭᱞᱟ#,
		},
		'America/Antigua' => {
			exemplarCity => q#ᱟᱱᱴᱤᱜᱩᱣᱟ#,
		},
		'America/Aruba' => {
			exemplarCity => q#ᱟᱨᱩᱵᱟ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#ᱵᱟᱦᱤᱭᱟ ᱵᱟᱱᱰᱮᱨᱟᱥ#,
		},
		'America/Barbados' => {
			exemplarCity => q#ᱵᱟᱨᱵᱟᱰᱚᱥ#,
		},
		'America/Belize' => {
			exemplarCity => q#ᱵᱮᱞᱤᱡᱮ#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ᱵᱞᱟᱱᱠᱼᱥᱟᱵᱞᱚᱱ#,
		},
		'America/Boise' => {
			exemplarCity => q#ᱵᱚᱭᱤᱥ#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#ᱠᱮᱢᱵᱽᱨᱮᱡᱽ ᱵᱮ#,
		},
		'America/Cancun' => {
			exemplarCity => q#ᱠᱟᱱᱠᱩᱱ#,
		},
		'America/Cayman' => {
			exemplarCity => q#ᱠᱚᱢᱟᱱ#,
		},
		'America/Chicago' => {
			exemplarCity => q#ᱪᱤᱠᱟᱜᱚ#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ᱪᱷᱤᱦᱩᱣᱟᱦᱩᱣᱟ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#ᱟᱴᱤᱠᱚᱠᱟᱱ#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#ᱠᱚᱥᱴᱟ ᱨᱤᱠᱟ#,
		},
		'America/Creston' => {
			exemplarCity => q#ᱠᱨᱮᱥᱴᱚᱱ#,
		},
		'America/Curacao' => {
			exemplarCity => q#ᱠᱭᱩᱨᱟᱠᱟᱣ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ᱰᱟᱱᱢᱟᱨᱠᱥᱟᱣᱱ#,
		},
		'America/Dawson' => {
			exemplarCity => q#ᱰᱟᱣᱥᱚᱱ#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ᱰᱟᱣᱥᱚᱱ ᱠᱨᱤᱠ#,
		},
		'America/Denver' => {
			exemplarCity => q#ᱰᱮᱱᱣᱮᱨ#,
		},
		'America/Detroit' => {
			exemplarCity => q#ᱰᱮᱴᱨᱚᱭᱮᱴ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ᱰᱚᱢᱤᱱᱤᱠᱟ#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ᱮᱰᱢᱚᱱᱴᱚᱱ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ᱮᱞ ᱥᱟᱞᱣᱮᱰᱚᱨ#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#ᱯᱷᱚᱴ ᱱᱮᱞᱥᱚᱱ#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ᱜᱞᱮᱥ ᱵᱮ#,
		},
		'America/Godthab' => {
			exemplarCity => q#ᱱᱩᱠ#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#ᱜᱩᱥ ᱵᱮ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ᱜᱽᱨᱟᱱᱰ ᱴᱩᱨᱠ#,
		},
		'America/Grenada' => {
			exemplarCity => q#ᱜᱽᱨᱮᱱᱟᱰᱟ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ᱜᱩᱣᱟᱰᱮᱞᱚᱯ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ᱜᱩᱣᱟᱴᱮᱢᱟᱞᱟ#,
		},
		'America/Halifax' => {
			exemplarCity => q#ᱦᱟᱞᱤᱯᱷᱟᱠᱥ#,
		},
		'America/Havana' => {
			exemplarCity => q#ᱦᱟᱣᱟᱱᱟ#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ᱦᱟᱹᱨᱢᱚᱥᱤᱞᱚ#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ᱱᱚᱠᱥ, ᱤᱱᱰᱤᱭᱟᱱᱟ#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#ᱢᱮᱨᱮᱝᱜᱚ, ᱤᱱᱰᱤᱭᱟᱱᱟ#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#ᱯᱤᱴᱚᱨᱥᱵᱚᱨᱜᱽ, ᱤᱱᱰᱤᱭᱟᱱᱟ#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ᱴᱚᱞ ᱥᱤᱴᱭ, ᱤᱱᱰᱤᱭᱟᱱᱟ#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ᱵᱷᱮᱵᱷᱟᱭ, ᱤᱱᱰᱤᱭᱟᱱᱟ#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ᱵᱷᱤᱱᱥᱮᱱᱥ, ᱤᱱᱰᱤᱭᱟᱱᱟ#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ᱣᱤᱱᱟᱢᱟᱠ, ᱤᱱᱰᱤᱭᱟᱱᱟ#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ᱤᱱᱰᱤᱭᱟᱱᱟᱯᱚᱞᱤᱥ#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ᱤᱱᱩᱣᱤᱠ#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ᱤᱠᱟᱞᱩᱣᱤᱛ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ᱡᱟᱢᱟᱭᱠᱟ#,
		},
		'America/Juneau' => {
			exemplarCity => q#ᱡᱩᱱᱮᱟᱹᱣ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#ᱢᱚᱱᱴᱤᱥᱮᱞᱚ, ᱠᱮᱱᱴᱩᱠᱭ#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ᱠᱨᱟᱞᱮᱱᱰᱤᱡᱽᱠᱚ#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ᱞᱮᱥ ᱮᱧᱡᱮᱞᱮᱥ#,
		},
		'America/Louisville' => {
			exemplarCity => q#ᱞᱩᱣᱤᱥᱣᱤᱞᱮ#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ᱞᱚᱣᱟᱹᱨ ᱯᱨᱤᱱᱥ ᱠᱣᱟᱴᱟᱹᱨ#,
		},
		'America/Managua' => {
			exemplarCity => q#ᱢᱟᱱᱟᱜᱩᱣᱟ#,
		},
		'America/Marigot' => {
			exemplarCity => q#ᱢᱟᱨᱤᱜᱚᱴ#,
		},
		'America/Martinique' => {
			exemplarCity => q#ᱢᱟᱨᱴᱤᱱᱠ#,
		},
		'America/Matamoros' => {
			exemplarCity => q#ᱢᱟᱴᱟᱢᱚᱨᱚᱥ#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#ᱢᱟᱡᱟᱴᱞᱟᱱ#,
		},
		'America/Menominee' => {
			exemplarCity => q#ᱢᱮᱱᱚᱢᱤᱱᱮ#,
		},
		'America/Merida' => {
			exemplarCity => q#ᱢᱮᱨᱤᱰᱟ#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#ᱢᱮᱴᱞᱟᱠᱟᱴᱞᱟ#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#ᱢᱮᱠᱥᱤᱠᱚ ᱥᱚᱦᱚᱨ#,
		},
		'America/Miquelon' => {
			exemplarCity => q#ᱢᱤᱠᱣᱮᱞᱚᱱ#,
		},
		'America/Moncton' => {
			exemplarCity => q#ᱢᱚᱱᱠᱴᱚᱱ#,
		},
		'America/Monterrey' => {
			exemplarCity => q#ᱢᱚᱱᱴᱮᱨᱮᱭ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#ᱢᱚᱱᱴᱥᱮᱨᱟᱴ#,
		},
		'America/Nassau' => {
			exemplarCity => q#ᱱᱟᱥᱟᱣ#,
		},
		'America/New_York' => {
			exemplarCity => q#ᱱᱤᱣ ᱭᱚᱨᱠ#,
		},
		'America/Nome' => {
			exemplarCity => q#ᱱᱚᱢᱮ#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ᱵᱮᱣᱞᱟᱦ, ᱮᱛᱚᱢ ᱰᱟᱠᱚᱴᱟ#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#ᱥᱮᱱᱴᱚᱨ, ᱮᱛᱚᱢ ᱰᱟᱠᱚᱴᱟ#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#ᱱᱤᱣ ᱥᱮᱞᱮᱢ, ᱮᱛᱚᱢ ᱰᱟᱠᱚᱴᱟ#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ᱚᱡᱤᱱᱟᱜᱟ#,
		},
		'America/Panama' => {
			exemplarCity => q#ᱯᱟᱱᱟᱢᱟ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ᱯᱷᱤᱱᱤᱠᱥ#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#ᱯᱚᱨᱴ ᱟᱣ ᱯᱨᱤᱱᱥ#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#ᱯᱚᱨᱴ ᱚᱯᱷ ᱥᱯᱮᱱ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#ᱯᱭᱩᱨᱴᱚ ᱨᱤᱠᱚ#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#ᱨᱟᱱᱠᱤᱱ ᱤᱱᱞᱮᱴ#,
		},
		'America/Regina' => {
			exemplarCity => q#ᱨᱮᱜᱤᱭᱟᱱᱟ#,
		},
		'America/Resolute' => {
			exemplarCity => q#ᱨᱤᱥᱚᱞᱭᱩᱴ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#ᱥᱟᱱᱴᱚ ᱰᱚᱢᱤᱱᱜᱚ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ᱤᱛᱚᱠᱚᱛᱚᱨᱢᱤᱛ#,
		},
		'America/Sitka' => {
			exemplarCity => q#ᱥᱤᱛᱠᱟ#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#ᱮᱥ ᱴᱤ ᱵᱟᱨᱛᱷᱮᱞᱢᱤ#,
		},
		'America/St_Johns' => {
			exemplarCity => q#ᱮᱥ ᱴᱤ ᱡᱚᱱᱥ#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#ᱮᱥ ᱴᱤ ᱠᱤᱴᱥ#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#ᱮᱥ ᱴᱤ ᱞᱩᱥᱤᱭᱟ#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#ᱮᱥ ᱴᱤ ᱛᱷᱚᱢᱟᱥ#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#ᱮᱥ ᱴᱤ ᱣᱤᱱᱥᱮᱴ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#ᱥᱣᱤᱯᱷᱴ ᱠᱚᱨᱮᱱᱴ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ᱛᱮᱜᱩᱪᱤᱜᱟᱞᱯᱟ#,
		},
		'America/Thule' => {
			exemplarCity => q#ᱛᱷᱩᱞᱮ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ᱴᱤᱡᱩᱣᱟᱱᱟ#,
		},
		'America/Toronto' => {
			exemplarCity => q#ᱴᱚᱨᱚᱱᱴᱚ#,
		},
		'America/Tortola' => {
			exemplarCity => q#ᱴᱚᱨᱴᱚᱞᱟ#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ᱣᱟᱱᱠᱚᱣᱟᱹᱨ#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ᱣᱟᱭᱤᱴᱦᱚᱨᱥ#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ᱣᱤᱱᱤᱯᱮᱜᱽ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ᱭᱟᱠᱩᱛᱟᱛ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#ᱛᱟᱱᱟᱞᱟ ᱥᱤᱧᱟᱜ ᱚᱠᱛᱚ#,
				'generic' => q#ᱛᱟᱱᱟᱞᱟ ᱚᱠᱛᱚ#,
				'standard' => q#ᱛᱟᱱᱟᱞᱟ ᱮᱥᱴᱮᱱᱰᱟᱨᱰ ᱚᱠᱛᱚ#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#ᱤᱥᱴᱟᱨᱱ ᱥᱤᱧᱟᱜ ᱵᱚᱠᱛᱚ#,
				'generic' => q#ᱤᱥᱴᱟᱨᱱ ᱚᱠᱛᱚ#,
				'standard' => q#ᱤᱥᱴᱟᱨᱱ ᱮᱥᱴᱮᱱᱰᱟᱨᱰ ᱚᱠᱛᱚ#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#ᱢᱟᱩᱱᱴᱮᱱ ᱥᱤᱧᱟᱜ ᱚᱠᱛᱚ#,
				'generic' => q#ᱢᱟᱩᱱᱴᱮᱱ ᱚᱠᱛᱚ#,
				'standard' => q#ᱢᱟᱩᱱᱴᱮᱱ ᱮᱥᱴᱮᱱᱰᱟᱨᱰ ᱚᱠᱛᱚ#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#ᱯᱮᱥᱤᱯᱷᱤᱠ ᱥᱤᱧᱟᱜ ᱚᱠᱛᱚ#,
				'generic' => q#ᱯᱮᱥᱤᱯᱷᱤᱠ ᱚᱠᱛᱚ#,
				'standard' => q#ᱯᱮᱥᱤᱯᱷᱤᱠ ᱮᱥᱴᱮᱱᱰᱟᱨᱰ ᱚᱠᱛᱚ#,
			},
		},
		'Argentina' => {
			long => {
				'daylight' => q#ᱟᱹᱨᱡᱮᱱᱴᱤᱱᱟ ᱥᱤᱛᱩᱝ ᱚᱠᱴᱚ#,
				'generic' => q#ᱟᱹᱨᱡᱮᱱᱴᱤᱱᱟ ᱚᱠᱴᱚ#,
				'standard' => q#ᱟᱹᱨᱡᱮᱱᱴᱤᱱᱟ ᱮᱴᱮᱱᱰᱟᱨᱰ ᱚᱠᱴᱚ#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#ᱯᱟᱪᱮ ᱟᱹᱨᱡᱮᱱᱴᱤᱱᱟ ᱥᱤᱛᱩᱝ ᱚᱠᱴᱚ#,
				'generic' => q#ᱯᱟᱪᱮ ᱟᱹᱨᱡᱮᱱᱴᱤᱱᱟ ᱚᱠᱴᱚ#,
				'standard' => q#ᱯᱟᱪᱮ ᱟᱹᱨᱡᱮᱱᱴᱤᱱᱟ ᱮᱥᱴᱮᱱᱰᱟᱨᱰ ᱚᱠᱴᱚ#,
			},
		},
		'Atlantic' => {
			long => {
				'daylight' => q#ᱮᱴᱞᱟᱱᱴᱤᱠ ᱥᱤᱧᱟᱜ ᱚᱠᱛᱚ#,
				'generic' => q#ᱮᱴᱞᱟᱱᱴᱤᱠ ᱚᱠᱛᱚ#,
				'standard' => q#ᱮᱴᱞᱟᱱᱴᱤᱠ ᱮᱥᱴᱮᱱᱰᱟᱨᱰ ᱚᱠᱛᱚ#,
			},
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ᱵᱟᱹᱨᱢᱩᱱᱰᱟ#,
		},
		'Cuba' => {
			long => {
				'daylight' => q#ᱠᱭᱩᱵᱟ ᱥᱤᱧᱟᱜ ᱚᱠᱛᱚ#,
				'generic' => q#ᱠᱭᱩᱵᱟ ᱚᱠᱛᱚ#,
				'standard' => q#ᱠᱭᱩᱵᱟ ᱢᱟᱱᱚᱠ ᱚᱠᱛᱚ#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#ᱠᱚᱨᱰᱤᱱᱮᱴᱮᱰ ᱭᱩᱱᱤᱣᱟᱨᱥᱟᱞ ᱚᱠᱛᱚ#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#ᱵᱟᱝ ᱪᱤᱱᱦᱟᱹᱣ ᱵᱟᱡᱟᱨ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#ᱥᱮᱱᱴᱨᱟᱞ ᱩᱨᱚᱯᱤᱭᱟᱱ ᱥᱟᱢᱟᱨ ᱚᱠᱛᱚ#,
				'generic' => q#ᱥᱮᱱᱴᱨᱟᱞ ᱩᱨᱚᱯᱤᱭᱟᱱ ᱚᱠᱛᱚ#,
				'standard' => q#ᱥᱮᱱᱴᱨᱟᱞ ᱩᱨᱚᱯᱤᱭᱟᱱ ᱮᱥᱴᱮᱱᱰᱟᱨᱰ ᱚᱠᱛᱚ#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#ᱤᱥᱴᱟᱨᱱ ᱩᱨᱚᱯᱤᱭᱟᱱ ᱥᱟᱢᱟᱨ ᱚᱠᱛᱚ#,
				'generic' => q#ᱤᱥᱴᱟᱨᱱ ᱩᱨᱚᱯᱤᱭᱟᱱ ᱚᱠᱛᱚ#,
				'standard' => q#ᱤᱥᱴᱟᱨᱱ ᱩᱨᱚᱯᱤᱭᱟᱱ ᱮᱥᱴᱮᱱᱰᱟᱨᱰ ᱚᱠᱛᱚ#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#ᱣᱮᱥᱴᱟᱨᱱ ᱩᱨᱚᱯᱤᱭᱟᱱ ᱥᱟᱢᱟᱨ ᱚᱠᱛᱚ#,
				'generic' => q#ᱣᱮᱥᱴᱟᱨᱱ ᱩᱨᱚᱯᱤᱭᱟᱱ ᱚᱠᱛᱚ#,
				'standard' => q#ᱣᱮᱥᱴᱟᱨᱱ ᱩᱨᱚᱯᱤᱭᱟᱱ ᱮᱥᱴᱮᱱᱰᱟᱨᱰ ᱚᱠᱛᱚ#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ᱜᱨᱤᱱᱣᱤᱪ ᱢᱤᱱ ᱚᱠᱛᱚ#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#ᱥᱟᱢᱟᱝ ᱜᱽᱨᱤᱱᱞᱮᱱᱰ ᱥᱤᱛᱩᱝ ᱚᱠᱛᱚ#,
				'generic' => q#ᱥᱟᱢᱟᱝ ᱜᱽᱨᱤᱱᱞᱮᱱᱰ ᱚᱠᱛᱚ#,
				'standard' => q#ᱥᱟᱢᱟᱝ ᱜᱽᱨᱤᱱᱞᱮᱱᱰ ᱢᱟᱱᱚᱠ ᱚᱠᱛᱚ#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#ᱯᱟᱪᱮ ᱜᱽᱨᱤᱱᱞᱮᱱᱰ ᱥᱤᱛᱩᱝ ᱚᱠᱛᱚ#,
				'generic' => q#ᱯᱟᱪᱮ ᱜᱽᱨᱤᱱᱞᱮᱱᱰ ᱚᱠᱛᱚ#,
				'standard' => q#ᱯᱟᱪᱮ ᱜᱽᱨᱤᱱᱞᱮᱱᱰ ᱢᱟᱱᱚᱠ ᱚᱠᱛᱚ#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#ᱦᱟᱣᱟᱭᱤᱼᱟᱞᱮᱣᱴᱤᱭᱟᱱ ᱥᱤᱧᱟᱜ ᱚᱠᱛᱚ#,
				'generic' => q#ᱦᱟᱣᱟᱭᱤᱼᱟᱞᱮᱣᱴᱤᱭᱟᱱ ᱚᱠᱛᱚ#,
				'standard' => q#ᱦᱟᱣᱟᱭᱤᱼᱟᱞᱮᱣᱴᱤᱭᱟᱱ ᱢᱟᱱᱚᱠ ᱚᱠᱛᱚ#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#ᱢᱮᱠᱥᱤᱠᱟᱱ ᱯᱨᱚᱥᱟᱱᱛ ᱥᱤᱧᱟᱜ ᱚᱠᱛᱚ#,
				'generic' => q#ᱢᱮᱠᱥᱤᱠᱟᱱ ᱯᱨᱚᱥᱟᱱᱛ ᱚᱠᱛᱚ#,
				'standard' => q#ᱢᱮᱠᱥᱤᱠᱟᱱ ᱯᱨᱚᱥᱟᱱᱛ ᱢᱟᱱᱚᱠ ᱚᱠᱛᱚ#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#ᱱᱤᱭᱩᱯᱷᱟᱩᱱᱰᱞᱮᱸᱰ ᱥᱤᱧᱟᱜ ᱚᱠᱛᱚ#,
				'generic' => q#ᱱᱤᱭᱩᱯᱷᱟᱩᱱᱰᱞᱮᱸᱰ ᱚᱠᱛᱚ#,
				'standard' => q#ᱱᱤᱭᱩᱯᱷᱟᱩᱱᱰᱞᱮᱸᱰ ᱢᱟᱱᱚᱠ ᱚᱠᱛᱚ#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#ᱮᱥ ᱴᱤ ᱯᱤᱭᱮᱨᱮ ᱟᱨ ᱢᱤᱠᱮᱞᱚᱱ ᱥᱤᱧᱟᱜ ᱚᱠᱛᱚ#,
				'generic' => q#ᱮᱥ ᱴᱤ ᱯᱤᱭᱮᱨᱮ ᱟᱨ ᱢᱤᱠᱮᱞᱚᱱ ᱚᱠᱛᱚ#,
				'standard' => q#ᱮᱥ ᱴᱤ ᱯᱤᱭᱮᱨᱮ ᱟᱨ ᱢᱤᱠᱮᱞᱚᱱ ᱢᱟᱱᱚᱠ ᱚᱠᱛᱚ#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#ᱭᱩᱠᱚᱱ ᱚᱠᱛᱚ#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
