=head1

Locale::CLDR::Locales::Mk - Package for language Macedonian

=cut

package Locale::CLDR::Locales::Mk;
# This file auto generated from Data\common\main\mk.xml
#	on Sun 24 Apr  8:41:23 am GMT

use version;

our $VERSION = version->declare('v0.29.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal-masculine','spellout-cardinal-neuter','spellout-cardinal-feminine' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => HashRef,
	init_arg => undef,
	default => sub { 
		use bignum;
		return {
		'spellout-cardinal-feminine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(една),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(две),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(дваесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(триесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четириесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шеесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седумдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осумдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← илјада[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милијарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← билион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← билијарда[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-masculine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(еден),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(два),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(три),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(четири),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(пет),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(шест),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(седум),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(осум),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(девет),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(десет),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(единаесет),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(дванаесет),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(тринаесет),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(четиринаесет),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(петнаесет),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(шеснаесет),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(седумнаесет),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(осумнаесет),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(деветнаесет),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(дваесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(триесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четириесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шеесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седумдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осумдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← илјада[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милијарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← билион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← билијарда[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-neuter' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(едно),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(два),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(дваесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(триесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четириесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шеесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седумдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осумдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← илјада[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милијарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← билион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← билијарда[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
			},
		},
	} },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'афарски',
 				'ab' => 'апхаски',
 				'ace' => 'ачешки',
 				'ach' => 'аколи',
 				'ada' => 'адангме',
 				'ady' => 'адигејски',
 				'ae' => 'авестански',
 				'aeb' => 'туниски арапски',
 				'af' => 'африканс',
 				'afh' => 'африхили',
 				'agq' => 'агемски',
 				'ain' => 'ајну',
 				'ak' => 'акански',
 				'akk' => 'акадски',
 				'akz' => 'алабамски',
 				'ale' => 'алеутски',
 				'aln' => 'гешки албански',
 				'alt' => 'јужноалтајски',
 				'am' => 'амхарски',
 				'an' => 'арагонски',
 				'ang' => 'староанглиски',
 				'anp' => 'ангика',
 				'ar' => 'арапски',
 				'ar_001' => 'литературен арапски',
 				'arc' => 'арамејски',
 				'arn' => 'мапучки',
 				'aro' => 'араона',
 				'arp' => 'арапахо',
 				'arq' => 'алжирски арапски',
 				'arw' => 'аравачки',
 				'ary' => 'марокански арапски',
 				'arz' => 'египетски арапски',
 				'as' => 'асамски',
 				'asa' => 'асу',
 				'ase' => 'американски знаковен јазик',
 				'ast' => 'астурски',
 				'av' => 'аварски',
 				'avk' => 'котава',
 				'awa' => 'авади',
 				'ay' => 'ајмарски',
 				'az' => 'азербејџански',
 				'az@alt=short' => 'азерски',
 				'ba' => 'башкирски',
 				'bal' => 'белуџиски',
 				'ban' => 'балиски',
 				'bar' => 'баварски',
 				'bas' => 'баса',
 				'bax' => 'бамунски',
 				'bbc' => 'тоба',
 				'bbj' => 'гомала',
 				'be' => 'белоруски',
 				'bej' => 'беџа',
 				'bem' => 'бемба',
 				'bew' => 'бетавски',
 				'bez' => 'бена',
 				'bfd' => 'бафут',
 				'bfq' => 'бадага',
 				'bg' => 'бугарски',
 				'bgn' => 'западен балочи',
 				'bho' => 'боџпури',
 				'bi' => 'бислама',
 				'bik' => 'биколски',
 				'bin' => 'бини',
 				'bjn' => 'банџарски',
 				'bkm' => 'ком',
 				'bla' => 'сиксика',
 				'bm' => 'бамбара',
 				'bn' => 'бенгалски',
 				'bo' => 'тибетски',
 				'bpy' => 'бишнуприја',
 				'bqi' => 'бахтијарски',
 				'br' => 'бретонски',
 				'bra' => 'брај',
 				'brh' => 'брахујски',
 				'brx' => 'бодо',
 				'bs' => 'босански',
 				'bss' => 'акосе',
 				'bua' => 'бурјатски',
 				'bug' => 'бугиски',
 				'bum' => 'булу',
 				'byn' => 'биленски',
 				'byv' => 'медумба',
 				'ca' => 'каталонски',
 				'cad' => 'кадо',
 				'car' => 'карипски',
 				'cay' => 'кајуга',
 				'cch' => 'ацам',
 				'ce' => 'чеченски',
 				'ceb' => 'себуански',
 				'cgg' => 'чига',
 				'ch' => 'чаморски',
 				'chb' => 'чибча',
 				'chg' => 'чагатајски',
 				'chk' => 'чучки',
 				'chm' => 'мариски',
 				'chn' => 'чинучки жаргон',
 				'cho' => 'чоктавски',
 				'chp' => 'чипевјански',
 				'chr' => 'черокиски',
 				'chy' => 'чејенски',
 				'ckb' => 'централен курдски',
 				'co' => 'корзикански',
 				'cop' => 'коптски',
 				'cps' => 'капизнон',
 				'cr' => 'кри',
 				'crh' => 'кримскотурски',
 				'cs' => 'чешки',
 				'csb' => 'кашупски',
 				'cu' => 'црковнословенски',
 				'cv' => 'чувашки',
 				'cy' => 'велшки',
 				'da' => 'дански',
 				'dak' => 'дакота',
 				'dar' => 'даргва',
 				'dav' => 'таита',
 				'de' => 'германски',
 				'del' => 'делавер',
 				'den' => 'слејви',
 				'dgr' => 'догрипски',
 				'din' => 'динка',
 				'dje' => 'зарма',
 				'doi' => 'догри',
 				'dsb' => 'долнолужички',
 				'dtp' => 'дусунски',
 				'dua' => 'дуала',
 				'dum' => 'среднохоландски',
 				'dv' => 'дивехи',
 				'dyo' => 'јола-фоњи',
 				'dyu' => 'џула',
 				'dz' => 'ѕонгка',
 				'dzg' => 'дазага',
 				'ebu' => 'ембу',
 				'ee' => 'еве',
 				'efi' => 'ефик',
 				'egl' => 'емилијански',
 				'egy' => 'староегипетски',
 				'eka' => 'екаџук',
 				'el' => 'грчки',
 				'elx' => 'еламски',
 				'en' => 'англиски',
 				'en_GB' => 'британски англиски',
 				'en_GB@alt=short' => 'англиски (во ОК)',
 				'en_US' => 'американски англиски',
 				'en_US@alt=short' => 'англиски (САД)',
 				'enm' => 'средноанглиски',
 				'eo' => 'есперанто',
 				'es' => 'шпански',
 				'es_ES' => 'шпански (во Европа)',
 				'esu' => 'централнојупички',
 				'et' => 'естонски',
 				'eu' => 'баскиски',
 				'ewo' => 'евондо',
 				'ext' => 'екстремадурски',
 				'fa' => 'персиски',
 				'fan' => 'фанг',
 				'fat' => 'фанти',
 				'ff' => 'фула',
 				'fi' => 'фински',
 				'fil' => 'филипински',
 				'fit' => 'турнедаленски фински',
 				'fj' => 'фиџиски',
 				'fo' => 'фарски',
 				'fon' => 'фон',
 				'fr' => 'француски',
 				'fr_CA' => 'француски (во Канада)',
 				'frc' => 'каџунски француски',
 				'frm' => 'среднофранцуски',
 				'fro' => 'старофранцуски',
 				'frp' => 'франкопровансалски',
 				'frr' => 'севернофризиски',
 				'frs' => 'источнофризиски',
 				'fur' => 'фурлански',
 				'fy' => 'западнофризиски',
 				'ga' => 'ирски',
 				'gaa' => 'га',
 				'gag' => 'гагауски',
 				'gan' => 'ган',
 				'gay' => 'гајо',
 				'gba' => 'гбаја',
 				'gbz' => 'зороастриски дари',
 				'gd' => 'шкотски гелски',
 				'gez' => 'гиз',
 				'gil' => 'гилбертански',
 				'gl' => 'галициски',
 				'glk' => 'гилански',
 				'gmh' => 'средногорногермански',
 				'gn' => 'гварански',
 				'goh' => 'старогорногермански',
 				'gom' => 'гоански конкани',
 				'gon' => 'гонди',
 				'gor' => 'горонтало',
 				'got' => 'готски',
 				'grb' => 'гребо',
 				'grc' => 'старогрчки',
 				'gsw' => 'швајцарски германски',
 				'gu' => 'гуџарати',
 				'guc' => 'гвахиро',
 				'gur' => 'фарефаре',
 				'guz' => 'гуси',
 				'gv' => 'манкс',
 				'gwi' => 'гвичински',
 				'ha' => 'хауса',
 				'hai' => 'хајда',
 				'hak' => 'хака',
 				'haw' => 'хавајски',
 				'he' => 'хебрејски',
 				'hi' => 'хинди',
 				'hif' => 'фиџиски хинди',
 				'hil' => 'хилигајнонски',
 				'hit' => 'хетитски',
 				'hmn' => 'хмонг',
 				'ho' => 'хири моту',
 				'hr' => 'хрватски',
 				'hsb' => 'горнолужички',
 				'hsn' => 'сјанг',
 				'ht' => 'хаитски',
 				'hu' => 'унгарски',
 				'hup' => 'хупа',
 				'hy' => 'ерменски',
 				'hz' => 'хереро',
 				'ia' => 'интерлингва',
 				'iba' => 'ибан',
 				'ibb' => 'ибибио',
 				'id' => 'индонезиски',
 				'ie' => 'окцидентал',
 				'ig' => 'игбо',
 				'ii' => 'сичуан ји',
 				'ik' => 'инупијачки',
 				'ilo' => 'илокански',
 				'inh' => 'ингушки',
 				'io' => 'идо',
 				'is' => 'исландски',
 				'it' => 'италијански',
 				'iu' => 'инуктитут',
 				'izh' => 'ижорски',
 				'ja' => 'јапонски',
 				'jam' => 'јамајски креолски',
 				'jbo' => 'ложбан',
 				'jgo' => 'нгомба',
 				'jmc' => 'мачаме',
 				'jpr' => 'еврејскоперсиски',
 				'jrb' => 'еврејскоарапски',
 				'jut' => 'јитски',
 				'jv' => 'јавански',
 				'ka' => 'грузиски',
 				'kaa' => 'каракалпачки',
 				'kab' => 'кабилски',
 				'kac' => 'качински',
 				'kaj' => 'каџе',
 				'kam' => 'камба',
 				'kaw' => 'кави',
 				'kbd' => 'кабардински',
 				'kbl' => 'канембу',
 				'kcg' => 'тјап',
 				'kde' => 'маконде',
 				'kea' => 'кабувердиану',
 				'ken' => 'кењанг',
 				'kfo' => 'коро',
 				'kg' => 'конго',
 				'kgp' => 'каинганшки',
 				'kha' => 'каси',
 				'kho' => 'хотански',
 				'khq' => 'којра чиини',
 				'khw' => 'коварски',
 				'ki' => 'кикују',
 				'kiu' => 'зазаки',
 				'kj' => 'квањама',
 				'kk' => 'казакстански',
 				'kkj' => 'како',
 				'kl' => 'калалисут',
 				'kln' => 'каленџин',
 				'km' => 'кмерски',
 				'kmb' => 'кимбунду',
 				'kn' => 'каннада',
 				'ko' => 'корејски',
 				'koi' => 'коми-пермјачки',
 				'kok' => 'конкани',
 				'kos' => 'козрејски',
 				'kpe' => 'кпеле',
 				'kr' => 'канури',
 				'krc' => 'карачаевско-балкарски',
 				'kri' => 'крио',
 				'krj' => 'кинарајски',
 				'krl' => 'карелски',
 				'kru' => 'курух',
 				'ks' => 'кашмирски',
 				'ksb' => 'шамбала',
 				'ksf' => 'бафија',
 				'ksh' => 'колоњски',
 				'ku' => 'курдски',
 				'kum' => 'кумички',
 				'kut' => 'кутенајски',
 				'kv' => 'коми',
 				'kw' => 'корнски',
 				'ky' => 'киргистански',
 				'la' => 'латински',
 				'lad' => 'ладино',
 				'lag' => 'ланги',
 				'lah' => 'ланда',
 				'lam' => 'ламба',
 				'lb' => 'луксембуршки',
 				'lez' => 'лезгински',
 				'lfn' => 'лингва франка нова',
 				'lg' => 'ганда',
 				'li' => 'лимбуршки',
 				'lij' => 'лигурски',
 				'liv' => 'ливонски',
 				'lkt' => 'лакотски',
 				'lmo' => 'ломбардски',
 				'ln' => 'лингала',
 				'lo' => 'лаошки',
 				'lol' => 'монго',
 				'loz' => 'лози',
 				'lrc' => 'севернолуриски',
 				'lt' => 'литвански',
 				'ltg' => 'латгалски',
 				'lu' => 'луба-катанга',
 				'lua' => 'луба-лулуа',
 				'lui' => 'лујсењски',
 				'lun' => 'лунда',
 				'luo' => 'луо',
 				'lus' => 'мизо',
 				'luy' => 'луја',
 				'lv' => 'латвиски',
 				'lzh' => 'книжевен кинески',
 				'lzz' => 'ласки',
 				'mad' => 'мадурски',
 				'maf' => 'мафа',
 				'mag' => 'магахи',
 				'mai' => 'маитили',
 				'mak' => 'макасарски',
 				'man' => 'мандинго',
 				'mas' => 'масајски',
 				'mde' => 'маба',
 				'mdf' => 'мокшански',
 				'mdr' => 'мандарски',
 				'men' => 'менде',
 				'mer' => 'меру',
 				'mfe' => 'морисјен',
 				'mg' => 'малгашки',
 				'mga' => 'средноирски',
 				'mgh' => 'макува-мито',
 				'mgo' => 'мета',
 				'mh' => 'маршалски',
 				'mi' => 'маорски',
 				'mic' => 'микмак',
 				'min' => 'минангкабау',
 				'mk' => 'македонски',
 				'ml' => 'малајалам',
 				'mn' => 'монголски',
 				'mnc' => 'манџурски',
 				'mni' => 'манипури',
 				'moh' => 'мохавски',
 				'mos' => 'моси',
 				'mr' => 'марати',
 				'mrj' => 'западномариски',
 				'ms' => 'малајски',
 				'mt' => 'малтешки',
 				'mua' => 'мунданг',
 				'mul' => 'повеќе јазици',
 				'mus' => 'крик',
 				'mwl' => 'мирандски',
 				'mwr' => 'марвари',
 				'my' => 'бурмански',
 				'mye' => 'мјене',
 				'myv' => 'ерзјански',
 				'mzn' => 'мазендерански',
 				'na' => 'науруански',
 				'nan' => 'јужномински',
 				'nap' => 'неаполски',
 				'naq' => 'нама',
 				'nb' => 'норвешки букмол',
 				'nd' => 'северен ндебеле',
 				'nds' => 'долногермански',
 				'ne' => 'непалски',
 				'new' => 'неварски',
 				'ng' => 'ндонга',
 				'nia' => 'нијас',
 				'niu' => 'ниуејски',
 				'njo' => 'ао',
 				'nl' => 'холандски',
 				'nl_BE' => 'фламански',
 				'nmg' => 'квазио',
 				'nn' => 'норвешки нинорск',
 				'nnh' => 'нгиембун',
 				'no' => 'норвешки',
 				'nog' => 'ногајски',
 				'non' => 'старонордиски',
 				'nov' => 'новијал',
 				'nqo' => 'нко',
 				'nr' => 'јужен ндебеле',
 				'nso' => 'северен сото',
 				'nus' => 'нуер',
 				'nv' => 'навахо',
 				'nwc' => 'класичен неварски',
 				'ny' => 'њанџа',
 				'nym' => 'њамвези',
 				'nyn' => 'њанколе',
 				'nyo' => 'њоро',
 				'nzi' => 'нзима',
 				'oc' => 'окситански',
 				'oj' => 'оџибва',
 				'om' => 'оромо',
 				'or' => 'орија',
 				'os' => 'осетски',
 				'osa' => 'осашки',
 				'ota' => 'отомански турски',
 				'pa' => 'пенџапски',
 				'pag' => 'пангасинански',
 				'pal' => 'средноперсиски',
 				'pam' => 'пампанга',
 				'pap' => 'папијаменто',
 				'pau' => 'палауански',
 				'pcd' => 'пикардски',
 				'pdc' => 'пенсилваниски германски',
 				'pdt' => 'менонитски долногермански',
 				'peo' => 'староперсиски',
 				'pfl' => 'фалечкогермански',
 				'phn' => 'феникиски',
 				'pi' => 'пали',
 				'pl' => 'полски',
 				'pms' => 'пиемонтски',
 				'pnt' => 'понтски',
 				'pon' => 'понпејски',
 				'prg' => 'пруски',
 				'pro' => 'старопровансалски',
 				'ps' => 'паштунски',
 				'pt' => 'португалски',
 				'pt_PT' => 'португалски (во Европа)',
 				'qu' => 'кечуански',
 				'quc' => 'киче',
 				'qug' => 'кичвански',
 				'raj' => 'раџастански',
 				'rap' => 'рапанујски',
 				'rar' => 'раротонгански',
 				'rgn' => 'ромањолски',
 				'rif' => 'рифски',
 				'rm' => 'реторомански',
 				'rn' => 'рунди',
 				'ro' => 'романски',
 				'ro_MD' => 'молдавски',
 				'rof' => 'ромбо',
 				'rom' => 'ромски',
 				'root' => 'корен',
 				'rtm' => 'ротумански',
 				'ru' => 'руски',
 				'rue' => 'русински',
 				'rug' => 'ровијански',
 				'rup' => 'влашки',
 				'rw' => 'руанда',
 				'rwk' => 'руа',
 				'sa' => 'санскрит',
 				'sad' => 'сандаве',
 				'sah' => 'јакутски',
 				'sam' => 'самарјански арамејски',
 				'saq' => 'самбуру',
 				'sas' => 'сасачки',
 				'sat' => 'сантали',
 				'saz' => 'саураштра',
 				'sba' => 'нгембеј',
 				'sbp' => 'сангу',
 				'sc' => 'сардински',
 				'scn' => 'сицилијански',
 				'sco' => 'шкотски германски',
 				'sd' => 'синди',
 				'sdc' => 'сасарски сардински',
 				'sdh' => 'јужнокурдски',
 				'se' => 'севернолапонски',
 				'see' => 'сенека',
 				'seh' => 'сена',
 				'sei' => 'сери',
 				'sel' => 'селкупски',
 				'ses' => 'којраборо сени',
 				'sg' => 'санго',
 				'sga' => 'староирски',
 				'sgs' => 'самогитски',
 				'sh' => 'српскохрватски',
 				'shi' => 'тачелхит',
 				'shn' => 'шан',
 				'shu' => 'чадски арапски',
 				'si' => 'синхалски',
 				'sid' => 'сидамо',
 				'sk' => 'словачки',
 				'sl' => 'словенечки',
 				'sli' => 'долношлезиски',
 				'sly' => 'селајарски',
 				'sm' => 'самоански',
 				'sma' => 'јужнолапонски',
 				'smj' => 'лулски лапонски',
 				'smn' => 'инарски лапонски',
 				'sms' => 'сколтски лапонски',
 				'sn' => 'шона',
 				'snk' => 'сонинке',
 				'so' => 'сомалиски',
 				'sog' => 'зогдијански',
 				'sq' => 'албански',
 				'sr' => 'српски',
 				'srn' => 'срански тонго',
 				'srr' => 'серер',
 				'ss' => 'свати',
 				'ssy' => 'сахо',
 				'st' => 'сесото',
 				'stq' => 'затерландски фризиски',
 				'su' => 'сундски',
 				'suk' => 'сукума',
 				'sus' => 'сусу',
 				'sux' => 'сумерски',
 				'sv' => 'шведски',
 				'sw' => 'свахили',
 				'sw_CD' => 'конгоански свахили',
 				'swb' => 'коморијански',
 				'syc' => 'класичен сириски',
 				'syr' => 'сириски',
 				'szl' => 'шлезиски',
 				'ta' => 'тамилски',
 				'tcy' => 'тулу',
 				'te' => 'телугу',
 				'tem' => 'тимне',
 				'teo' => 'тесо',
 				'ter' => 'терено',
 				'tet' => 'тетум',
 				'tg' => 'таџикистански',
 				'th' => 'тајландски',
 				'ti' => 'тигриња',
 				'tig' => 'тигре',
 				'tiv' => 'тив',
 				'tk' => 'туркменски',
 				'tkl' => 'токелауански',
 				'tkr' => 'цахурски',
 				'tl' => 'тагалог',
 				'tlh' => 'клингонски',
 				'tli' => 'тлингит',
 				'tly' => 'талишки',
 				'tmh' => 'тамашек',
 				'tn' => 'цвана',
 				'to' => 'тонгански',
 				'tog' => 'њаса тонга',
 				'tpi' => 'ток писин',
 				'tr' => 'турски',
 				'tru' => 'туројо',
 				'trv' => 'тароко',
 				'ts' => 'цонга',
 				'tsd' => 'цаконски',
 				'tsi' => 'цимшијански',
 				'tt' => 'татарски',
 				'ttt' => 'татски',
 				'tum' => 'тумбука',
 				'tvl' => 'тувалуански',
 				'tw' => 'тви',
 				'twq' => 'тазавак',
 				'ty' => 'тахитски',
 				'tyv' => 'тувански',
 				'tzm' => 'централно марокански тамазитски',
 				'udm' => 'удмуртски',
 				'ug' => 'ујгурски',
 				'uga' => 'угаритски',
 				'uk' => 'украински',
 				'umb' => 'умбунду',
 				'und' => 'непознат јазик',
 				'ur' => 'урду',
 				'uz' => 'узбекистански',
 				'vai' => 'вај',
 				've' => 'венда',
 				'vec' => 'венетски',
 				'vep' => 'вепшки',
 				'vi' => 'виетнамски',
 				'vls' => 'западнофламански',
 				'vmf' => 'мајнскофранконски',
 				'vo' => 'волапик',
 				'vot' => 'вотски',
 				'vro' => 'виру',
 				'vun' => 'вунџо',
 				'wa' => 'валонски',
 				'wae' => 'валсер',
 				'wal' => 'воламо',
 				'war' => 'варајски',
 				'was' => 'вашо',
 				'wbp' => 'варлпири',
 				'wo' => 'волофски',
 				'wuu' => 'ву',
 				'xal' => 'калмички',
 				'xh' => 'коса',
 				'xmf' => 'мегрелски',
 				'xog' => 'сога',
 				'yao' => 'јао',
 				'yap' => 'јапски',
 				'yav' => 'јенгбен',
 				'ybb' => 'јемба',
 				'yi' => 'јидиш',
 				'yo' => 'јорупски',
 				'yrl' => 'њенгату',
 				'yue' => 'кантонски',
 				'za' => 'џуаншки',
 				'zap' => 'запотечки',
 				'zbl' => 'блиссимболи',
 				'zea' => 'зеландски',
 				'zen' => 'зенага',
 				'zgh' => 'стандарден марокански тамазигтски',
 				'zh' => 'кинески',
 				'zh_Hans' => 'поедноставен кинески',
 				'zh_Hant' => 'традиционален кинески',
 				'zu' => 'зулу',
 				'zun' => 'зуни',
 				'zxx' => 'без лингвистичка содржина',
 				'zza' => 'заза',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Afak' => 'афака',
 			'Aghb' => 'кавкаскоалбански',
 			'Arab' => 'арапско писмо',
 			'Armi' => 'царскоарамејски',
 			'Armn' => 'ерменско писмо',
 			'Avst' => 'авестанско',
 			'Bali' => 'балиско',
 			'Bamu' => 'бамумско',
 			'Bass' => 'баса',
 			'Batk' => 'батачко',
 			'Beng' => 'бенгалско писмо',
 			'Blis' => 'блиссимболи',
 			'Bopo' => 'бопомофо',
 			'Brah' => 'брами',
 			'Brai' => 'брајово писмо',
 			'Bugi' => 'бугиско',
 			'Buhd' => 'бухидско',
 			'Cakm' => 'чакманско',
 			'Cans' => 'канадско слоговно',
 			'Cari' => 'кариско',
 			'Cham' => 'чамско',
 			'Cher' => 'черокиско',
 			'Cirt' => 'кирт',
 			'Copt' => 'коптско',
 			'Cprt' => 'кипарско',
 			'Cyrl' => 'кирилско писмо',
 			'Cyrs' => 'старословенска кирилица',
 			'Deva' => 'деванагари',
 			'Dsrt' => 'дезеретско',
 			'Dupl' => 'Диплојеево стенографско',
 			'Egyd' => 'египетско демотско',
 			'Egyh' => 'египетско хиератско',
 			'Egyp' => 'египетски хиероглифи',
 			'Elba' => 'елбасанско',
 			'Ethi' => 'етиопско писмо',
 			'Geok' => 'грузиски хуцури',
 			'Geor' => 'грузиско писмо',
 			'Glag' => 'глаголица',
 			'Goth' => 'готско',
 			'Gran' => 'гранта',
 			'Grek' => 'грчко писмо',
 			'Gujr' => 'гуџарати',
 			'Guru' => 'гурмуки',
 			'Hang' => 'хангул',
 			'Hani' => 'ханско писмо',
 			'Hano' => 'хануноовско',
 			'Hans' => 'поедноставено',
 			'Hans@alt=stand-alone' => 'поедноставено ханско писмо',
 			'Hant' => 'традиционално',
 			'Hant@alt=stand-alone' => 'традиционално ханско',
 			'Hebr' => 'хебрејско писмо',
 			'Hira' => 'хирагана',
 			'Hluw' => 'анадолски хиероглифи',
 			'Hmng' => 'пахауанско хмоншко',
 			'Hrkt' => 'јапонско слоговно',
 			'Hung' => 'староунгарско',
 			'Inds' => 'харапско',
 			'Ital' => 'староиталско',
 			'Java' => 'јаванско',
 			'Jpan' => 'јапонско писмо',
 			'Jurc' => 'џурченско',
 			'Kali' => 'каја ли',
 			'Kana' => 'катакана',
 			'Khar' => 'карошти',
 			'Khmr' => 'кмерско писмо',
 			'Khoj' => 'хоџки',
 			'Knda' => 'каннада',
 			'Kore' => 'корејско писмо',
 			'Kpel' => 'кпелско',
 			'Kthi' => 'кајти',
 			'Lana' => 'ланско',
 			'Laoo' => 'лаошко писмо',
 			'Latf' => 'фрактурна латиница',
 			'Latg' => 'гелска латиница',
 			'Latn' => 'латинично писмо',
 			'Lepc' => 'лепчанско',
 			'Limb' => 'лимбу',
 			'Lina' => 'линеарно А',
 			'Linb' => 'линеарно Б',
 			'Lisu' => 'Фрејзерово',
 			'Loma' => 'ломско',
 			'Lyci' => 'ликиско',
 			'Lydi' => 'лидиско',
 			'Mahj' => 'махаџани',
 			'Mand' => 'мандејско',
 			'Mani' => 'манихејско',
 			'Maya' => 'мајански хиероглифи',
 			'Mend' => 'мендско',
 			'Merc' => 'мероитско ракописно',
 			'Mero' => 'мероитско',
 			'Mlym' => 'малајаламско писмо',
 			'Modi' => 'моди',
 			'Mong' => 'монголско писмо',
 			'Moon' => 'Муново',
 			'Mroo' => 'мро',
 			'Mtei' => 'мејтејско',
 			'Mymr' => 'мјанмарско писмо',
 			'Narb' => 'старосеверноарапско',
 			'Nbat' => 'набатејско',
 			'Nkgb' => 'насиска геба',
 			'Nkoo' => 'нко',
 			'Nshu' => 'нишу',
 			'Ogam' => 'огам',
 			'Olck' => 'ол чики',
 			'Orkh' => 'старотурско',
 			'Orya' => 'оријанско писмо',
 			'Osma' => 'сомалиско',
 			'Palm' => 'палмирско',
 			'Pauc' => 'Паучинхауово',
 			'Perm' => 'старопермско',
 			'Phag' => 'пагспа',
 			'Phli' => 'натписно средноперсиско',
 			'Phlp' => 'псалтирско средноперсиско',
 			'Phlv' => 'книжевно староперсиско',
 			'Phnx' => 'феникиско',
 			'Plrd' => 'Полардово',
 			'Prti' => 'натписно партиско',
 			'Rjng' => 'реџаншко',
 			'Roro' => 'ронгоронго',
 			'Runr' => 'рунско',
 			'Samr' => 'самарјанско',
 			'Sara' => 'сарати',
 			'Sarb' => 'старојужноарапско',
 			'Saur' => 'саураштранско',
 			'Sgnw' => 'знаковно пишување',
 			'Shaw' => 'Шоово',
 			'Shrd' => 'шарада',
 			'Sidd' => 'сидам',
 			'Sind' => 'кудабади',
 			'Sinh' => 'синхалско писмо',
 			'Sora' => 'соранг сомпенг',
 			'Sund' => 'сунданско',
 			'Sylo' => 'силхетско нагари',
 			'Syrc' => 'сириско',
 			'Syre' => 'естрангелско сириско',
 			'Syrj' => 'западносириско',
 			'Syrn' => 'источносириско',
 			'Tagb' => 'тагбанванско',
 			'Takr' => 'такри',
 			'Tale' => 'тај ле',
 			'Talu' => 'ново тај луе',
 			'Taml' => 'тамилско писмо',
 			'Tang' => 'тангутско',
 			'Tavt' => 'тај вјет',
 			'Telu' => 'телугу',
 			'Teng' => 'тенгвар',
 			'Tfng' => 'тифинаг',
 			'Tglg' => 'тагалошко',
 			'Thaa' => 'тана',
 			'Thai' => 'тајландско писмо',
 			'Tibt' => 'тибетско писмо',
 			'Tirh' => 'тирхута',
 			'Ugar' => 'угаритско',
 			'Vaii' => 'вај',
 			'Visp' => 'видлив говор',
 			'Wara' => 'варанг кшити',
 			'Wole' => 'волеајско',
 			'Xpeo' => 'староперсиско',
 			'Xsux' => 'сумероакадско клинесто',
 			'Yiii' => 'ји',
 			'Zinh' => 'наследено',
 			'Zmth' => 'математичка нотација',
 			'Zsym' => 'симболи',
 			'Zxxx' => 'без писмо',
 			'Zyyy' => 'општо',
 			'Zzzz' => 'непознато писмо',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Свет',
 			'002' => 'Африка',
 			'003' => 'Северна Америка',
 			'005' => 'Јужна Америка',
 			'009' => 'Океанија',
 			'011' => 'Западна Африка',
 			'013' => 'Централна Америка',
 			'014' => 'Источна Африка',
 			'015' => 'Северна Африка',
 			'017' => 'Средна Африка',
 			'018' => 'Јужна Африка',
 			'019' => 'Америки',
 			'021' => 'Северна континентална Америка',
 			'029' => 'Кариби',
 			'030' => 'Источна Азија',
 			'034' => 'Јужна Азија',
 			'035' => 'Југоисточна Азија',
 			'039' => 'Јужна Европа',
 			'053' => 'Австралазија',
 			'054' => 'Меланезија',
 			'057' => 'Микронезиски регион',
 			'061' => 'Полинезија',
 			'142' => 'Азија',
 			'143' => 'Централна Азија',
 			'145' => 'Западна Азија',
 			'150' => 'Европа',
 			'151' => 'Источна Европа',
 			'154' => 'Северна Европа',
 			'155' => 'Западна Европа',
 			'419' => 'Латинска Америка',
 			'AC' => 'Остров Асенсион',
 			'AD' => 'Андора',
 			'AE' => 'Обединети Арапски Емирати',
 			'AF' => 'Авганистан',
 			'AG' => 'Антигва и Барбуда',
 			'AI' => 'Ангвила',
 			'AL' => 'Албанија',
 			'AM' => 'Ерменија',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктик',
 			'AR' => 'Аргентина',
 			'AS' => 'Американска Самоа',
 			'AT' => 'Австрија',
 			'AU' => 'Австралија',
 			'AW' => 'Аруба',
 			'AX' => 'Оландски острови',
 			'AZ' => 'Азербејџан',
 			'BA' => 'Босна и Херцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Белгија',
 			'BF' => 'Буркина Фасо',
 			'BG' => 'Бугарија',
 			'BH' => 'Бахреин',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Свети Вартоломеј',
 			'BM' => 'Бермуди',
 			'BN' => 'Брунеј',
 			'BO' => 'Боливија',
 			'BQ' => 'Карипска Холандија',
 			'BR' => 'Бразил',
 			'BS' => 'Бахами',
 			'BT' => 'Бутан',
 			'BV' => 'Остров Буве',
 			'BW' => 'Боцвана',
 			'BY' => 'Белорусија',
 			'BZ' => 'Белизе',
 			'CA' => 'Канада',
 			'CC' => 'Кокосови (Килиншки) Острови',
 			'CD' => 'Конго - Киншаса',
 			'CD@alt=variant' => 'Конго (Демократска Република Конго)',
 			'CF' => 'Централноафриканска Република',
 			'CG' => 'Конго - Бразавил',
 			'CG@alt=variant' => 'Конго (Република)',
 			'CH' => 'Швајцарија',
 			'CI' => 'Брегот на Слоновата Коска',
 			'CI@alt=variant' => 'Брег на Слонова Коска',
 			'CK' => 'Кукови Острови',
 			'CL' => 'Чиле',
 			'CM' => 'Камерун',
 			'CN' => 'Кина',
 			'CO' => 'Колумбија',
 			'CP' => 'Остров Клипертон',
 			'CR' => 'Костарика',
 			'CU' => 'Куба',
 			'CV' => 'Зелен ’Рт',
 			'CW' => 'Курасао',
 			'CX' => 'Божиќен Остров',
 			'CY' => 'Кипар',
 			'CZ' => 'Република Чешка',
 			'DE' => 'Германија',
 			'DG' => 'Диего Гарсија',
 			'DJ' => 'Џибути',
 			'DK' => 'Данска',
 			'DM' => 'Доминика',
 			'DO' => 'Доминиканска Република',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута и Мелиља',
 			'EC' => 'Еквадор',
 			'EE' => 'Естонија',
 			'EG' => 'Египет',
 			'EH' => 'Западна Сахара',
 			'ER' => 'Еритреја',
 			'ES' => 'Шпанија',
 			'ET' => 'Етиопија',
 			'EU' => 'Европска унија',
 			'FI' => 'Финска',
 			'FJ' => 'Фиџи',
 			'FK' => 'Фолкландски Острови',
 			'FK@alt=variant' => 'Фолкландски Острови (Малвински Острови)',
 			'FM' => 'Микронезија',
 			'FO' => 'Фарски Острови',
 			'FR' => 'Франција',
 			'GA' => 'Габон',
 			'GB' => 'Обединето Кралство',
 			'GB@alt=short' => 'ОК',
 			'GD' => 'Гренада',
 			'GE' => 'Грузија',
 			'GF' => 'Француска Гвајана',
 			'GG' => 'Гернзи',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренланд',
 			'GM' => 'Гамбија',
 			'GN' => 'Гвинеја',
 			'GP' => 'Гвадалупе',
 			'GQ' => 'Екваторска Гвинеја',
 			'GR' => 'Грција',
 			'GS' => 'Јужна Џорџија и Јужни Сендвички Острови',
 			'GT' => 'Гватемала',
 			'GU' => 'Гвам',
 			'GW' => 'Гвинеја-Бисау',
 			'GY' => 'Гвајана',
 			'HK' => 'Хонг Конг С.А.Р Кина',
 			'HK@alt=short' => 'Хонг Конг',
 			'HM' => 'Остров Херд и Острови Макдоналд',
 			'HN' => 'Хондурас',
 			'HR' => 'Хрватска',
 			'HT' => 'Хаити',
 			'HU' => 'Унгарија',
 			'IC' => 'Канарски Острови',
 			'ID' => 'Индонезија',
 			'IE' => 'Ирска',
 			'IL' => 'Израел',
 			'IM' => 'Остров Ман',
 			'IN' => 'Индија',
 			'IO' => 'Британска Индоокеанска Територија',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исланд',
 			'IT' => 'Италија',
 			'JE' => 'Џерси',
 			'JM' => 'Јамајка',
 			'JO' => 'Јордан',
 			'JP' => 'Јапонија',
 			'KE' => 'Кенија',
 			'KG' => 'Киргистан',
 			'KH' => 'Камбоџа',
 			'KI' => 'Кирибати',
 			'KM' => 'Коморски Острови',
 			'KN' => 'Свети Кристофер и Невис',
 			'KP' => 'Северна Кореја',
 			'KR' => 'Јужна Кореја',
 			'KW' => 'Кувајт',
 			'KY' => 'Кајмански Острови',
 			'KZ' => 'Казахстан',
 			'LA' => 'Лаос',
 			'LB' => 'Либан',
 			'LC' => 'Света Луција',
 			'LI' => 'Лихтенштајн',
 			'LK' => 'Шри Ланка',
 			'LR' => 'Либерија',
 			'LS' => 'Лесото',
 			'LT' => 'Литванија',
 			'LU' => 'Луксембург',
 			'LV' => 'Латвија',
 			'LY' => 'Либија',
 			'MA' => 'Мароко',
 			'MC' => 'Монако',
 			'MD' => 'Молдавија',
 			'ME' => 'Црна Гора',
 			'MF' => 'Сент Мартин',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршалски Острови',
 			'MK' => 'Македонија',
 			'MK@alt=variant' => 'Република Македонија',
 			'ML' => 'Мали',
 			'MM' => 'Мјанмар (Бурма)',
 			'MN' => 'Монголија',
 			'MO' => 'Макао С.А.Р Кина',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Северни Маријански Острови',
 			'MQ' => 'Мартиник',
 			'MR' => 'Мавританија',
 			'MS' => 'Монсерат',
 			'MT' => 'Малта',
 			'MU' => 'Маврициус',
 			'MV' => 'Малдиви',
 			'MW' => 'Малави',
 			'MX' => 'Мексико',
 			'MY' => 'Малезија',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибија',
 			'NC' => 'Нова Каледонија',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолшки Остров',
 			'NG' => 'Нигерија',
 			'NI' => 'Никарагва',
 			'NL' => 'Холандија',
 			'NO' => 'Норвешка',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуе',
 			'NZ' => 'Нов Зеланд',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Француска Полинезија',
 			'PG' => 'Папуа Нова Гвинеја',
 			'PH' => 'Филипини',
 			'PK' => 'Пакистан',
 			'PL' => 'Полска',
 			'PM' => 'Сент Пјер и Микелан',
 			'PN' => 'Питкернски Острови',
 			'PR' => 'Порторико',
 			'PS' => 'Палестински територии',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португалија',
 			'PW' => 'Палау',
 			'PY' => 'Парагвај',
 			'QA' => 'Катар',
 			'QO' => 'Зависни земји во Океанија',
 			'RE' => 'Ријунион',
 			'RO' => 'Романија',
 			'RS' => 'Србија',
 			'RU' => 'Русија',
 			'RW' => 'Руанда',
 			'SA' => 'Саудиска Арабија',
 			'SB' => 'Соломонски Острови',
 			'SC' => 'Сејшели',
 			'SD' => 'Судан',
 			'SE' => 'Шведска',
 			'SG' => 'Сингапур',
 			'SH' => 'Света Елена',
 			'SI' => 'Словенија',
 			'SJ' => 'Свалбард и Жан Мејен',
 			'SK' => 'Словачка',
 			'SL' => 'Сиера Леоне',
 			'SM' => 'Сан Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомалија',
 			'SR' => 'Суринам',
 			'SS' => 'Јужен Судан',
 			'ST' => 'Сао Томе и Принсипе',
 			'SV' => 'Ел Салвадор',
 			'SX' => 'Свети Мартин',
 			'SY' => 'Сирија',
 			'SZ' => 'Свазиленд',
 			'TA' => 'Тристан да Куња',
 			'TC' => 'Острови Туркс и Кајкос',
 			'TD' => 'Чад',
 			'TF' => 'Француски Јужни територии',
 			'TG' => 'Того',
 			'TH' => 'Тајланд',
 			'TJ' => 'Таџикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Источен Тимор (Тимор Лесте)',
 			'TL@alt=variant' => 'Источен Тимор',
 			'TM' => 'Туркменистан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Турција',
 			'TT' => 'Тринидад и Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тајван',
 			'TZ' => 'Танзанија',
 			'UA' => 'Украина',
 			'UG' => 'Уганда',
 			'UM' => 'Американски територии во Пацификот',
 			'US' => 'Соединети Американски Држави',
 			'US@alt=short' => 'САД',
 			'UY' => 'Уругвај',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан',
 			'VC' => 'Свети Винсент и Гренадините',
 			'VE' => 'Венецуела',
 			'VG' => 'Британски Девствени Острови',
 			'VI' => 'Американски Девствени Острови',
 			'VN' => 'Виетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Валис и Футуна',
 			'WS' => 'Самоа',
 			'XK' => 'Косово',
 			'YE' => 'Јемен',
 			'YT' => 'Мајот',
 			'ZA' => 'Јужноафриканска Република',
 			'ZM' => 'Замбија',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Непознат регион',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'PINYIN' => 'Пинјин романизација',
 			'WADEGILE' => 'Вејд-Џајлс романизација',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'Календар',
 			'collation' => 'Подредување',
 			'currency' => 'Валута',
 			'hc' => 'Часовен циклус (12 или 24)',
 			'lb' => 'Стил за разделување редови',
 			'ms' => 'Мерен систем',
 			'numbers' => 'Броеви',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{Будистички календар},
 				'chinese' => q{Кинески календар},
 				'coptic' => q{Коптски календар},
 				'dangi' => q{Дангиски календар},
 				'ethiopic' => q{Етиопски календар},
 				'ethiopic-amete-alem' => q{Етиопски Амет Алем календар},
 				'gregorian' => q{Грегоријански календар},
 				'hebrew' => q{Еврејски календар},
 				'indian' => q{Индиски национален календар},
 				'islamic' => q{Исламски календар},
 				'islamic-civil' => q{Исламски граѓански календар},
 				'iso8601' => q{Календар ISO-8601},
 				'japanese' => q{Јапонски календар},
 				'persian' => q{Персиски календар},
 				'roc' => q{Мингуо-календар},
 			},
 			'collation' => {
 				'big5han' => q{Традиционално кинеско сортирање},
 				'ducet' => q{Стандардно сортирање во уникод},
 				'gb2312han' => q{Поедноставено кинеско сортирање},
 				'phonebook' => q{Азбучен редослед},
 				'pinyin' => q{Сортирање Pinyin},
 				'search' => q{Општо пребарување},
 				'standard' => q{Стандардно сортирање},
 				'stroke' => q{Ритмички редослед},
 				'traditional' => q{Традиционално сортирање},
 			},
 			'hc' => {
 				'h11' => q{12-часовен систем (0-11)},
 				'h12' => q{12-часовен систем (1-12)},
 				'h23' => q{24-часовен систем (0-23)},
 				'h24' => q{24-часовен систем (1-24)},
 			},
 			'lb' => {
 				'loose' => q{Допустлив стил за разделување редови},
 				'normal' => q{Нормален стил за разделување редови},
 				'strict' => q{Строг стил за разделување редови},
 			},
 			'ms' => {
 				'metric' => q{Метрички систем},
 				'uksystem' => q{Империјален мерен систем},
 				'ussystem' => q{Американски мерен систем},
 			},
 			'numbers' => {
 				'arab' => q{Арапско-индиски цифри},
 				'arabext' => q{Проширени арапско-индиски цифри},
 				'armn' => q{Ерменски броеви},
 				'armnlow' => q{Ерменски мали броеви},
 				'beng' => q{Бенгалски цифри},
 				'deva' => q{деванагарски цифри},
 				'ethi' => q{Етиопски броеви},
 				'fullwide' => q{Цифри со целосна ширина},
 				'geor' => q{Грузиски броеви},
 				'grek' => q{Грчки броеви},
 				'greklow' => q{Грчки мали броеви},
 				'gujr' => q{Гуџарати цифри},
 				'guru' => q{Гурмуки цифри},
 				'hanidec' => q{Кинески децимални броеви},
 				'hans' => q{Поедноставени кинески броеви},
 				'hansfin' => q{Поедноставени кинески финансиски броеви},
 				'hant' => q{Традиционални кинески броеви},
 				'hantfin' => q{Традиционални кинески финансиски броеви},
 				'hebr' => q{Хебрејски броеви},
 				'jpan' => q{Јапонски броеви},
 				'jpanfin' => q{Јапонски финансиски броеви},
 				'khmr' => q{Кмерски цифри},
 				'knda' => q{Канада цифри},
 				'laoo' => q{Лаошки цифри},
 				'latn' => q{Арапски броеви},
 				'mlym' => q{Малајаламски цифри},
 				'mymr' => q{Мјанмарски цифри},
 				'orya' => q{Оријски цифри},
 				'roman' => q{Римски броеви},
 				'romanlow' => q{Римски мали броеви},
 				'taml' => q{Традиционални тамилски броеви},
 				'tamldec' => q{Тамилски цифри},
 				'telu' => q{Телугу цифри},
 				'thai' => q{Тајландски цифри},
 				'tibt' => q{Тибетски цифри},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{метрички},
 			'UK' => q{британски},
 			'US' => q{американски},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'Јазик: {0}',
 			'script' => 'Писмо: {0}',
 			'region' => 'Регион: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[ѐ ѝ])},
			index => ['А', 'Б', 'В', 'Г', 'Д', 'Ѓ', 'Е', 'Ж', 'З', 'Ѕ', 'И', 'Ј', 'К', 'Л', 'Љ', 'М', 'Н', 'Њ', 'О', 'П', 'Р', 'С', 'Т', 'Ќ', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Џ', 'Ш'],
			main => qr{(?^u:[а б в г д ѓ е ж з ѕ и ј к л љ м н њ о п р с т ќ у ф х ц ч џ ш])},
			punctuation => qr{(?^u:[\- ‐ – — , ; \: ! ? . … ‘ ‚ “ „ ( ) \[ \] \{ \}])},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Д', 'Ѓ', 'Е', 'Ж', 'З', 'Ѕ', 'И', 'Ј', 'К', 'Л', 'Љ', 'М', 'Н', 'Њ', 'О', 'П', 'Р', 'С', 'Т', 'Ќ', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Џ', 'Ш'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0}…',
			'word-initial' => '…{0}',
			'word-medial' => '{0}… {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{„},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‚},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'name' => q(акри),
						'one' => q({0} акр),
						'other' => q({0} акри),
					},
					'acre-foot' => {
						'name' => q(ар-стапка),
						'one' => q({0} ар-стапка),
						'other' => q({0} ар-стапки),
					},
					'ampere' => {
						'name' => q(ампери),
						'one' => q({0} ампер),
						'other' => q({0} ампери),
					},
					'arc-minute' => {
						'name' => q(минути),
						'one' => q({0} минута),
						'other' => q({0} минути),
					},
					'arc-second' => {
						'name' => q(секунди),
						'one' => q({0} секунда),
						'other' => q({0} секунди),
					},
					'astronomical-unit' => {
						'name' => q(астрономски единици),
						'one' => q({0} астрономска единица),
						'other' => q({0} астрономски единици),
					},
					'bit' => {
						'name' => q(битови),
						'one' => q({0} бит),
						'other' => q({0} битови),
					},
					'bushel' => {
						'name' => q(бушели),
						'one' => q({0} бушел),
						'other' => q({0} бушели),
					},
					'byte' => {
						'name' => q(бајти),
						'one' => q({0} бајт),
						'other' => q({0} бајти),
					},
					'calorie' => {
						'name' => q(калории),
						'one' => q({0} калорија),
						'other' => q({0} калории),
					},
					'carat' => {
						'name' => q(карати),
						'one' => q({0} карат),
						'other' => q({0} карати),
					},
					'celsius' => {
						'name' => q(целзиусови степени),
						'one' => q({0} целзиусов степен),
						'other' => q({0} целзиусови степени),
					},
					'centiliter' => {
						'name' => q(центилитри),
						'one' => q({0} центилитар),
						'other' => q({0} центилитри),
					},
					'centimeter' => {
						'name' => q(сантиметри),
						'one' => q({0} сантиметар),
						'other' => q({0} сантиметри),
						'per' => q({0} на сантиметар),
					},
					'century' => {
						'name' => q(векови),
						'one' => q({0} век),
						'other' => q({0} векови),
					},
					'coordinate' => {
						'east' => q({0}И),
						'north' => q({0}С),
						'south' => q({0}Ј),
						'west' => q({0}З),
					},
					'cubic-centimeter' => {
						'name' => q(кубни сантиметри),
						'one' => q({0} кубен сантиметар),
						'other' => q({0} кубни сантиметри),
						'per' => q({0} на кубен сантиметар),
					},
					'cubic-foot' => {
						'name' => q(кубни стапки),
						'one' => q({0} кубна стапка),
						'other' => q({0} кубни стапки),
					},
					'cubic-inch' => {
						'name' => q(кубни инчи),
						'one' => q({0} кубен инч),
						'other' => q({0} кубни инчи),
					},
					'cubic-kilometer' => {
						'name' => q(кубни километри),
						'one' => q({0} кубен километар),
						'other' => q({0} кубни километри),
					},
					'cubic-meter' => {
						'name' => q(кубни метри),
						'one' => q({0} кубен метар),
						'other' => q({0} кубни метри),
						'per' => q({0} на кубен метар),
					},
					'cubic-mile' => {
						'name' => q(кубни милји),
						'one' => q({0} кубна милја),
						'other' => q({0} кубни милји),
					},
					'cubic-yard' => {
						'name' => q(кубни јарди),
						'one' => q({0} кубен јард),
						'other' => q({0} кубни јарди),
					},
					'cup' => {
						'name' => q(шолји),
						'one' => q({0} шолја),
						'other' => q({0} шолји),
					},
					'cup-metric' => {
						'name' => q(метрички шолји),
						'one' => q({0} метричка шолја),
						'other' => q({0} метрички шолји),
					},
					'day' => {
						'name' => q(дена),
						'one' => q({0} ден),
						'other' => q({0} дена),
						'per' => q({0} дневно),
					},
					'deciliter' => {
						'name' => q(децилитри),
						'one' => q({0} децилитар),
						'other' => q({0} децилитри),
					},
					'decimeter' => {
						'name' => q(дециметри),
						'one' => q({0} дециметар),
						'other' => q({0} дециметри),
					},
					'degree' => {
						'name' => q(степени),
						'one' => q({0} степен),
						'other' => q({0} степени),
					},
					'fahrenheit' => {
						'name' => q(фаренхајтови степени),
						'one' => q({0} фаренхајтов степен),
						'other' => q({0} фаренхајтови степени),
					},
					'fathom' => {
						'name' => q(фатоми),
						'one' => q({0} фатом),
						'other' => q({0} фатоми),
					},
					'fluid-ounce' => {
						'name' => q(унци течност),
						'one' => q({0} унца течност),
						'other' => q({0} унци течност),
					},
					'foodcalorie' => {
						'name' => q(калории),
						'one' => q({0} калорија),
						'other' => q({0} калории),
					},
					'foot' => {
						'name' => q(стапки),
						'one' => q({0} стапка),
						'other' => q({0} стапки),
						'per' => q({0} на стапка),
					},
					'furlong' => {
						'name' => q(фурлонзи),
						'one' => q({0} фурлонг),
						'other' => q({0} фурлонзи),
					},
					'g-force' => {
						'name' => q(гравитациска сила),
						'one' => q({0} гравитациска сила),
						'other' => q({0} гравитациска сила),
					},
					'gallon' => {
						'name' => q(галони),
						'one' => q({0} галон),
						'other' => q({0} галони),
						'per' => q({0} по галон),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(гигабитови),
						'one' => q({0} гигабит),
						'other' => q({0} гигабитови),
					},
					'gigabyte' => {
						'name' => q(гигабајти),
						'one' => q({0} гигабајт),
						'other' => q({0} гигабајти),
					},
					'gigahertz' => {
						'name' => q(гигахерц),
						'one' => q({0} гигахерц),
						'other' => q({0} гигахерци),
					},
					'gigawatt' => {
						'name' => q(гигавати),
						'one' => q({0} гигават),
						'other' => q({0} гигавати),
					},
					'gram' => {
						'name' => q(грама),
						'one' => q({0} грам),
						'other' => q({0} грама),
						'per' => q({0} од грам),
					},
					'hectare' => {
						'name' => q(хектари),
						'one' => q({0} хектар),
						'other' => q({0} хектари),
					},
					'hectoliter' => {
						'name' => q(хектолитри),
						'one' => q({0} хектолитар),
						'other' => q({0} хектолитри),
					},
					'hectopascal' => {
						'name' => q(хектопаскали),
						'one' => q({0} хектопаскал),
						'other' => q({0} хектопаскали),
					},
					'hertz' => {
						'name' => q(херц),
						'one' => q({0} херц),
						'other' => q({0} херци),
					},
					'horsepower' => {
						'name' => q(коњски сили),
						'one' => q({0} коњска сила),
						'other' => q({0} коњски сили),
					},
					'hour' => {
						'name' => q(часа),
						'one' => q({0} час),
						'other' => q({0} часа),
						'per' => q({0} на час),
					},
					'inch' => {
						'name' => q(инчи),
						'one' => q({0} инч),
						'other' => q({0} инчи),
						'per' => q({0} на инч),
					},
					'inch-hg' => {
						'name' => q(инчи жива),
						'one' => q({0} инч жива),
						'other' => q({0} инчи жива),
					},
					'joule' => {
						'name' => q(џули),
						'one' => q({0} џул),
						'other' => q({0} џули),
					},
					'karat' => {
						'name' => q(карат),
						'one' => q({0} карат),
						'other' => q({0} карати),
					},
					'kelvin' => {
						'name' => q(келвини),
						'one' => q({0} келвин),
						'other' => q({0} келвини),
					},
					'kilobit' => {
						'name' => q(килобитови),
						'one' => q({0} килобит),
						'other' => q({0} килобитови),
					},
					'kilobyte' => {
						'name' => q(килобајти),
						'one' => q({0} килобајт),
						'other' => q({0} килобајти),
					},
					'kilocalorie' => {
						'name' => q(килокалории),
						'one' => q({0} килокалорија),
						'other' => q({0} килокалории),
					},
					'kilogram' => {
						'name' => q(килограми),
						'one' => q({0} килограм),
						'other' => q({0} килограми),
						'per' => q({0} од килограм),
					},
					'kilohertz' => {
						'name' => q(килохерц),
						'one' => q({0} килохерц),
						'other' => q({0} килохерци),
					},
					'kilojoule' => {
						'name' => q(килоџули),
						'one' => q({0} килоџул),
						'other' => q({0} килоџули),
					},
					'kilometer' => {
						'name' => q(километри),
						'one' => q({0} километар),
						'other' => q({0} километри),
						'per' => q({0} на километар),
					},
					'kilometer-per-hour' => {
						'name' => q(километри на час),
						'one' => q({0} километар на час),
						'other' => q({0} километри на час),
					},
					'kilowatt' => {
						'name' => q(киловати),
						'one' => q({0} киловат),
						'other' => q({0} киловати),
					},
					'kilowatt-hour' => {
						'name' => q(киловат-часови),
						'one' => q({0} киловат-час),
						'other' => q({0} киловат-часови),
					},
					'knot' => {
						'name' => q(јазол),
						'one' => q({0} јазол),
						'other' => q({0} јазли),
					},
					'light-year' => {
						'name' => q(светлосни години),
						'one' => q({0} светлосна година),
						'other' => q({0} светлосни години),
					},
					'liter' => {
						'name' => q(литри),
						'one' => q({0} литар),
						'other' => q({0} литри),
						'per' => q({0} по литар),
					},
					'liter-per-100kilometers' => {
						'name' => q(литри на 100 километри),
						'one' => q({0} литар на 100 километри),
						'other' => q({0} литри на 100 километри),
					},
					'liter-per-kilometer' => {
						'name' => q(литри на километар),
						'one' => q({0} литар на километар),
						'other' => q({0} литри на километар),
					},
					'lux' => {
						'name' => q(лукс),
						'one' => q({0} лукс),
						'other' => q({0} лукса),
					},
					'megabit' => {
						'name' => q(мегабитови),
						'one' => q({0} мегабит),
						'other' => q({0} мегабитови),
					},
					'megabyte' => {
						'name' => q(мегабајти),
						'one' => q({0} мегабајт),
						'other' => q({0} мегабајти),
					},
					'megahertz' => {
						'name' => q(мегахерц),
						'one' => q({0} мегахерц),
						'other' => q({0} мегахерци),
					},
					'megaliter' => {
						'name' => q(мегалитри),
						'one' => q({0} мегалитар),
						'other' => q({0} мегалитри),
					},
					'megawatt' => {
						'name' => q(мегавати),
						'one' => q({0} мегават),
						'other' => q({0} мегавати),
					},
					'meter' => {
						'name' => q(метри),
						'one' => q({0} метар),
						'other' => q({0} метри),
						'per' => q({0} на метар),
					},
					'meter-per-second' => {
						'name' => q(метри во секунда),
						'one' => q({0} метар во секунда),
						'other' => q({0} метри во секунда),
					},
					'meter-per-second-squared' => {
						'name' => q(метри во секунда на квадрат),
						'one' => q({0} метар во секунда на квадрат),
						'other' => q({0} метри во секунда на квадрат),
					},
					'metric-ton' => {
						'name' => q(метрички тони),
						'one' => q({0} метрички тон),
						'other' => q({0} метрички тони),
					},
					'microgram' => {
						'name' => q(микрограми),
						'one' => q({0} микрограм),
						'other' => q({0} микрограми),
					},
					'micrometer' => {
						'name' => q(микрометри),
						'one' => q({0} микрометар),
						'other' => q({0} микрометри),
					},
					'microsecond' => {
						'name' => q(микросекунди),
						'one' => q({0} микросекунда),
						'other' => q({0} микросекунди),
					},
					'mile' => {
						'name' => q(милји),
						'one' => q({0} милја),
						'other' => q({0} милји),
					},
					'mile-per-gallon' => {
						'name' => q(милји на галон),
						'one' => q({0} милја на галон),
						'other' => q({0} милји на галон),
					},
					'mile-per-hour' => {
						'name' => q(милји на час),
						'one' => q({0} милја на час),
						'other' => q({0} милји на час),
					},
					'mile-scandinavian' => {
						'name' => q(скандинавска милја),
						'one' => q({0} скандинавска милја),
						'other' => q({0} скандинавски милји),
					},
					'milliampere' => {
						'name' => q(милиампери),
						'one' => q({0} милиампер),
						'other' => q({0} милиампери),
					},
					'millibar' => {
						'name' => q(милибари),
						'one' => q({0} милибар),
						'other' => q({0} милибари),
					},
					'milligram' => {
						'name' => q(милиграми),
						'one' => q({0} милиграм),
						'other' => q({0} милиграми),
					},
					'milliliter' => {
						'name' => q(милилитри),
						'one' => q({0} милилитар),
						'other' => q({0} милилитри),
					},
					'millimeter' => {
						'name' => q(милиметри),
						'one' => q({0} милиметар),
						'other' => q({0} милиметри),
					},
					'millimeter-of-mercury' => {
						'name' => q(милиметри жива),
						'one' => q({0} милиметар жива),
						'other' => q({0} милиметри жива),
					},
					'millisecond' => {
						'name' => q(милисекунди),
						'one' => q({0} милисекунда),
						'other' => q({0} милисекунди),
					},
					'milliwatt' => {
						'name' => q(миливати),
						'one' => q({0} миливат),
						'other' => q({0} миливати),
					},
					'minute' => {
						'name' => q(минути),
						'one' => q({0} минута),
						'other' => q({0} минути),
						'per' => q({0} на минута),
					},
					'month' => {
						'name' => q(месеци),
						'one' => q({0} месец),
						'other' => q({0} месеци),
						'per' => q({0} месечно),
					},
					'nanometer' => {
						'name' => q(нанометри),
						'one' => q({0} нанометар),
						'other' => q({0} нанометри),
					},
					'nanosecond' => {
						'name' => q(наносекунди),
						'one' => q({0} наносекунда),
						'other' => q({0} наносекунди),
					},
					'nautical-mile' => {
						'name' => q(наутички милји),
						'one' => q({0} наутичка милја),
						'other' => q({0} наутички милји),
					},
					'ohm' => {
						'name' => q(оми),
						'one' => q({0} ом),
						'other' => q({0} оми),
					},
					'ounce' => {
						'name' => q(унци),
						'one' => q({0} унца),
						'other' => q({0} унци),
						'per' => q({0} од унца),
					},
					'ounce-troy' => {
						'name' => q(тројски унци),
						'one' => q({0} тројска унца),
						'other' => q({0} тројски унци),
					},
					'parsec' => {
						'name' => q(парсеци),
						'one' => q({0} парсек),
						'other' => q({0} парсеци),
					},
					'per' => {
						'1' => q({0} на {1}),
					},
					'picometer' => {
						'name' => q(пикометри),
						'one' => q({0} пикометар),
						'other' => q({0} пикометри),
					},
					'pint' => {
						'name' => q(пинти),
						'one' => q({0} пинта),
						'other' => q({0} пинти),
					},
					'pint-metric' => {
						'name' => q(метрички пинти),
						'one' => q({0} метричка пинта),
						'other' => q({0} метрички пинти),
					},
					'pound' => {
						'name' => q(фунти),
						'one' => q({0} фунта),
						'other' => q({0} фунти),
						'per' => q({0} од фунта),
					},
					'pound-per-square-inch' => {
						'name' => q(фунти на квадратен инч),
						'one' => q({0} фунта на квадратен инч),
						'other' => q({0} фунти на квадратен инч),
					},
					'quart' => {
						'name' => q(кварти),
						'one' => q({0} кварт),
						'other' => q({0} кварти),
					},
					'radian' => {
						'name' => q(радијани),
						'one' => q({0} радијан),
						'other' => q({0} радијани),
					},
					'revolution' => {
						'name' => q(револуција),
						'one' => q({0} револуција),
						'other' => q({0} револуции),
					},
					'second' => {
						'name' => q(секунди),
						'one' => q({0} секунда),
						'other' => q({0} секунди),
						'per' => q({0} во секунда),
					},
					'square-centimeter' => {
						'name' => q(квадратни сантиметри),
						'one' => q({0} квадратен сантиметар),
						'other' => q({0} квадратни сантиметри),
						'per' => q({0} по квадратен сантиметар),
					},
					'square-foot' => {
						'name' => q(квадратни стапки),
						'one' => q({0} квадратна стапка),
						'other' => q({0} квадратни стапки),
					},
					'square-inch' => {
						'name' => q(квадратни инчи),
						'one' => q({0} квадратен инч),
						'other' => q({0} квадратни инчи),
						'per' => q({0} по квадратен инч),
					},
					'square-kilometer' => {
						'name' => q(квадратни километри),
						'one' => q({0} квадратен километар),
						'other' => q({0} квадратни километри),
					},
					'square-meter' => {
						'name' => q(квадратни метри),
						'one' => q({0} квадратен метар),
						'other' => q({0} квадратни метри),
						'per' => q({0} по метар квадратен),
					},
					'square-mile' => {
						'name' => q(квадратни милји),
						'one' => q({0} квадратна милја),
						'other' => q({0} квадратни милји),
					},
					'square-yard' => {
						'name' => q(квадратни јарди),
						'one' => q({0} квадратен јард),
						'other' => q({0} квадратни јарди),
					},
					'stone' => {
						'name' => q(стоуни),
						'one' => q({0} стоун),
						'other' => q({0} стоуни),
					},
					'tablespoon' => {
						'name' => q(супени лажици),
						'one' => q({0} супена лажица),
						'other' => q({0} супени лажици),
					},
					'teaspoon' => {
						'name' => q(кафени лажици),
						'one' => q({0} кафена лажица),
						'other' => q({0} кафени лажици),
					},
					'terabit' => {
						'name' => q(терабитови),
						'one' => q({0} терабит),
						'other' => q({0} терабитови),
					},
					'terabyte' => {
						'name' => q(терабајти),
						'one' => q({0} терабајт),
						'other' => q({0} терабајти),
					},
					'ton' => {
						'name' => q(тони),
						'one' => q({0} тон),
						'other' => q({0} тони),
					},
					'volt' => {
						'name' => q(волти),
						'one' => q({0} волт),
						'other' => q({0} волти),
					},
					'watt' => {
						'name' => q(вати),
						'one' => q({0} ват),
						'other' => q({0} вати),
					},
					'week' => {
						'name' => q(седмици),
						'one' => q({0} седмица),
						'other' => q({0} седмици),
						'per' => q({0} неделно),
					},
					'yard' => {
						'name' => q(јарди),
						'one' => q({0} јард),
						'other' => q({0} јарди),
					},
					'year' => {
						'name' => q(години),
						'one' => q({0} година),
						'other' => q({0} години),
						'per' => q({0} годишно),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} акр),
						'other' => q({0} акри),
					},
					'acre-foot' => {
						'one' => q({0} ак ст),
						'other' => q({0} ак ст),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'astronomical-unit' => {
						'one' => q({0} ае),
						'other' => q({0} ае),
					},
					'bit' => {
						'name' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} битови),
					},
					'bushel' => {
						'name' => q(бу),
						'one' => q({0} бу),
						'other' => q({0} бу),
					},
					'carat' => {
						'one' => q({0} кар.),
						'other' => q({0} кар.),
					},
					'celsius' => {
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'one' => q({0} сл),
						'other' => q({0} сл),
					},
					'centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
					},
					'coordinate' => {
						'east' => q({0}И),
						'north' => q({0}С),
						'south' => q({0}Ј),
						'west' => q({0}З),
					},
					'cubic-centimeter' => {
						'one' => q({0} см³),
						'other' => q({0} см³),
					},
					'cubic-foot' => {
						'one' => q({0} ст³),
						'other' => q({0} ст³),
					},
					'cubic-inch' => {
						'one' => q({0} ин³),
						'other' => q({0} ин³),
					},
					'cubic-kilometer' => {
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-meter' => {
						'one' => q({0} м³),
						'other' => q({0} м³),
					},
					'cubic-mile' => {
						'one' => q({0} ми³),
						'other' => q({0} ми³),
					},
					'cubic-yard' => {
						'one' => q({0} јд³),
						'other' => q({0} јд³),
					},
					'day' => {
						'name' => q(ден),
						'one' => q({0} ден),
						'other' => q({0} дена),
					},
					'deciliter' => {
						'one' => q({0} дл),
						'other' => q({0} дл),
					},
					'decimeter' => {
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					'degree' => {
						'name' => q(степени),
						'one' => q({0} степ.),
						'other' => q({0} степ.),
					},
					'fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fathom' => {
						'name' => q(фатоми),
						'one' => q({0} фм),
						'other' => q({0} фм),
					},
					'fluid-ounce' => {
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					'foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'furlong' => {
						'name' => q(фурлонг),
						'one' => q({0} фур),
						'other' => q({0} фур),
					},
					'g-force' => {
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gallon' => {
						'one' => q({0} гал),
						'other' => q({0} гал),
					},
					'gigabit' => {
						'name' => q(Gb),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'name' => q(GB),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					'gram' => {
						'name' => q(грам),
						'one' => q({0}г),
						'other' => q({0}г),
					},
					'hectare' => {
						'one' => q({0} ха),
						'other' => q({0} ха),
					},
					'hectoliter' => {
						'one' => q({0} хл),
						'other' => q({0} хл),
					},
					'hectopascal' => {
						'one' => q({0} хПа),
						'other' => q({0} хПа),
					},
					'horsepower' => {
						'one' => q({0} кс),
						'other' => q({0} кс),
					},
					'hour' => {
						'name' => q(час),
						'one' => q({0} час),
						'other' => q({0} часа),
					},
					'inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'inch-hg' => {
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'karat' => {
						'one' => q({0} кт),
						'other' => q({0} кт),
					},
					'kelvin' => {
						'one' => q({0}°K),
						'other' => q({0}°K),
					},
					'kilobit' => {
						'name' => q(kb),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'name' => q(kB),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					'kilogram' => {
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
					},
					'kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
					},
					'kilometer-per-hour' => {
						'name' => q(км/ч),
						'one' => q({0} к/ч),
						'other' => q({0} к/ч),
					},
					'kilowatt' => {
						'name' => q(kW),
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'light-year' => {
						'one' => q({0} сг),
						'other' => q({0} сг),
					},
					'liter' => {
						'name' => q(литар),
						'one' => q({0} л),
						'other' => q({0} л),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					'liter-per-kilometer' => {
						'one' => q({0} л/км),
						'other' => q({0} л/км),
					},
					'lux' => {
						'one' => q({0} лк),
						'other' => q({0} лк),
					},
					'megabit' => {
						'name' => q(Mb),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'name' => q(MB),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					'megaliter' => {
						'one' => q({0} Мл),
						'other' => q({0} Мл),
					},
					'meter' => {
						'name' => q(метар),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'meter-per-second' => {
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					'meter-per-second-squared' => {
						'one' => q({0} м/с²),
						'other' => q({0} м/с²),
					},
					'metric-ton' => {
						'one' => q({0} т),
						'other' => q({0} т),
					},
					'microgram' => {
						'one' => q({0} µг),
						'other' => q({0} µг),
					},
					'micrometer' => {
						'one' => q({0} µм),
						'other' => q({0} µм),
					},
					'microsecond' => {
						'one' => q({0}μс),
						'other' => q({0}μс),
					},
					'mile' => {
						'one' => q({0} ми),
						'other' => q({0} ми),
					},
					'mile-per-gallon' => {
						'one' => q({0} ми/гал),
						'other' => q({0} ми/гал),
					},
					'mile-per-hour' => {
						'one' => q({0} ми/ч),
						'other' => q({0} ми/ч),
					},
					'millibar' => {
						'name' => q(мбар),
						'one' => q({0} мб),
						'other' => q({0} мб),
					},
					'milligram' => {
						'one' => q({0} мг),
						'other' => q({0} мг),
					},
					'milliliter' => {
						'one' => q({0} мл),
						'other' => q({0} мл),
					},
					'millimeter' => {
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millimeter-of-mercury' => {
						'one' => q({0}mm Hg),
						'other' => q({0}mm Hg),
					},
					'millisecond' => {
						'name' => q(мсек),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'minute' => {
						'name' => q(мин),
						'one' => q({0} мин.),
						'other' => q({0} мин.),
					},
					'month' => {
						'name' => q(месец),
						'one' => q({0} мес.),
						'other' => q({0} мес.),
					},
					'nanometer' => {
						'one' => q({0} нм),
						'other' => q({0} нм),
					},
					'nanosecond' => {
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					'nautical-mile' => {
						'one' => q({0} нми),
						'other' => q({0} нми),
					},
					'ounce' => {
						'one' => q({0} унца),
						'other' => q({0} унци),
					},
					'ounce-troy' => {
						'one' => q({0} oz t),
						'other' => q({0} oz t),
					},
					'parsec' => {
						'one' => q({0} пс),
						'other' => q({0} пс),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pint' => {
						'one' => q({0} пт),
						'other' => q({0} пт),
					},
					'pound' => {
						'one' => q({0} фунта),
						'other' => q({0} фунти),
					},
					'quart' => {
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					'radian' => {
						'one' => q({0} рад),
						'other' => q({0} рад),
					},
					'second' => {
						'name' => q(сек.),
						'one' => q({0} сек.),
						'other' => q({0} сек.),
					},
					'square-foot' => {
						'one' => q({0} стапка²),
						'other' => q({0} стапки²),
					},
					'square-inch' => {
						'one' => q({0} ин²),
						'other' => q({0} ин²),
					},
					'square-kilometer' => {
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					'square-meter' => {
						'name' => q(м²),
						'one' => q({0} м²),
						'other' => q({0} м²),
					},
					'square-mile' => {
						'one' => q({0} ми²),
						'other' => q({0} ми²),
					},
					'square-yard' => {
						'one' => q({0} јд²),
						'other' => q({0} јд²),
					},
					'stone' => {
						'name' => q(стоун),
						'one' => q({0} стоун),
						'other' => q({0} стоуни),
					},
					'tablespoon' => {
						'one' => q({0}tbsp),
						'other' => q({0}tbsp),
					},
					'teaspoon' => {
						'one' => q({0}tsp),
						'other' => q({0}tsp),
					},
					'terabit' => {
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'name' => q(TB),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					'ton' => {
						'name' => q(тони),
						'one' => q({0} тн),
						'other' => q({0} тн),
					},
					'watt' => {
						'one' => q({0} ват),
						'other' => q({0} вати),
					},
					'week' => {
						'name' => q(сед.),
						'one' => q({0} сед.),
						'other' => q({0} сед.),
					},
					'yard' => {
						'one' => q({0} јд),
						'other' => q({0} јд),
					},
					'year' => {
						'name' => q(год.),
						'one' => q({0} год.),
						'other' => q({0} год.),
					},
				},
				'short' => {
					'acre' => {
						'name' => q(акри),
						'one' => q({0} акр),
						'other' => q({0} акри),
					},
					'acre-foot' => {
						'name' => q(ар-ст.),
						'one' => q({0} ар-ст.),
						'other' => q({0} ар-ст.),
					},
					'ampere' => {
						'name' => q(амп.),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'name' => q(минути),
						'one' => q({0} мин.),
						'other' => q({0} мин),
					},
					'arc-second' => {
						'name' => q(секунди),
						'one' => q({0} сек),
						'other' => q({0} сек),
					},
					'astronomical-unit' => {
						'name' => q(ае),
						'one' => q({0} ае),
						'other' => q({0} ае),
					},
					'bit' => {
						'name' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} битови),
					},
					'bushel' => {
						'name' => q(бушели),
						'one' => q({0} бу),
						'other' => q({0} бу),
					},
					'byte' => {
						'name' => q(бајт),
						'one' => q({0} бајт),
						'other' => q({0} бајти),
					},
					'calorie' => {
						'name' => q(кал.),
						'one' => q({0} кал.),
						'other' => q({0} кал.),
					},
					'carat' => {
						'name' => q(карати),
						'one' => q({0} кар.),
						'other' => q({0} кар.),
					},
					'celsius' => {
						'name' => q(целзиусови степени),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'name' => q(cL),
						'one' => q({0} cL),
						'other' => q({0} cL),
					},
					'centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					'century' => {
						'name' => q(в.),
						'one' => q({0} в.),
						'other' => q({0} в.),
					},
					'coordinate' => {
						'east' => q({0}И),
						'north' => q({0}С),
						'south' => q({0}Ј),
						'west' => q({0}З),
					},
					'cubic-centimeter' => {
						'name' => q(см³),
						'one' => q({0} см³),
						'other' => q({0} см³),
						'per' => q({0}/см³),
					},
					'cubic-foot' => {
						'name' => q(стапки³),
						'one' => q({0} ст³),
						'other' => q({0} ст³),
					},
					'cubic-inch' => {
						'name' => q(инчи³),
						'one' => q({0} in³),
						'other' => q({0} in³),
					},
					'cubic-kilometer' => {
						'name' => q(км³),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-meter' => {
						'name' => q(м³),
						'one' => q({0} м³),
						'other' => q({0} м³),
						'per' => q({0}/м³),
					},
					'cubic-mile' => {
						'name' => q(ми³),
						'one' => q({0} ми³),
						'other' => q({0} ми³),
					},
					'cubic-yard' => {
						'name' => q(јарди³),
						'one' => q({0} јд³),
						'other' => q({0} јд³),
					},
					'cup' => {
						'name' => q(шолји),
						'one' => q({0} ш.),
						'other' => q({0} ш.),
					},
					'cup-metric' => {
						'name' => q(mcup),
						'one' => q({0} mc),
						'other' => q({0} mc),
					},
					'day' => {
						'name' => q(дена),
						'one' => q({0} ден),
						'other' => q({0} дена),
						'per' => q({0}/ден),
					},
					'deciliter' => {
						'name' => q(dL),
						'one' => q({0} dL),
						'other' => q({0} dL),
					},
					'decimeter' => {
						'name' => q(дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					'degree' => {
						'name' => q(степени),
						'one' => q({0} степ.),
						'other' => q({0} степ.),
					},
					'fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fathom' => {
						'name' => q(фатоми),
						'one' => q({0} фм),
						'other' => q({0} фм),
					},
					'fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					'foodcalorie' => {
						'name' => q(Кал.),
						'one' => q({0} кал.),
						'other' => q({0} кал.),
					},
					'foot' => {
						'name' => q(стапки),
						'one' => q({0} ст),
						'other' => q({0} ст),
						'per' => q({0}/ст),
					},
					'furlong' => {
						'name' => q(фурлонзи),
						'one' => q({0} фур),
						'other' => q({0} фур),
					},
					'g-force' => {
						'name' => q(гравитациска сила),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gallon' => {
						'name' => q(гал),
						'one' => q({0} гал),
						'other' => q({0} гал),
						'per' => q({0}/gal),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(Gb),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'name' => q(GB),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					'gigahertz' => {
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					'gigawatt' => {
						'name' => q(GW),
						'one' => q({0} GW),
						'other' => q({0} GW),
					},
					'gram' => {
						'name' => q(грама),
						'one' => q({0} г),
						'other' => q({0} г),
						'per' => q({0}/г),
					},
					'hectare' => {
						'name' => q(хектари),
						'one' => q({0} хектар),
						'other' => q({0} хектари),
					},
					'hectoliter' => {
						'name' => q(hL),
						'one' => q({0} hL),
						'other' => q({0} hL),
					},
					'hectopascal' => {
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'hertz' => {
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					'horsepower' => {
						'name' => q(коњски сили),
						'one' => q({0} кс),
						'other' => q({0} кс),
					},
					'hour' => {
						'name' => q(часа),
						'one' => q({0} час),
						'other' => q({0} часа),
						'per' => q({0}/ч),
					},
					'inch' => {
						'name' => q(инчи),
						'one' => q({0} инч),
						'other' => q({0} инчи),
						'per' => q({0}/ин),
					},
					'inch-hg' => {
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'joule' => {
						'name' => q(џули),
						'one' => q({0} J),
						'other' => q({0} J),
					},
					'karat' => {
						'name' => q(карати),
						'one' => q({0} kt),
						'other' => q({0} kt),
					},
					'kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					'kilobit' => {
						'name' => q(kbit),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'name' => q(kB),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					'kilocalorie' => {
						'name' => q(kcal),
						'one' => q({0} kcal),
						'other' => q({0} kcal),
					},
					'kilogram' => {
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
						'per' => q({0}/кг),
					},
					'kilohertz' => {
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					'kilojoule' => {
						'name' => q(килоџул),
						'one' => q({0} kJ),
						'other' => q({0} kJ),
					},
					'kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					'kilometer-per-hour' => {
						'name' => q(км/час),
						'one' => q({0} к/ч),
						'other' => q({0} к/ч),
					},
					'kilowatt' => {
						'name' => q(kW),
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'kilowatt-hour' => {
						'name' => q(kWh),
						'one' => q({0} kWh),
						'other' => q({0} kWh),
					},
					'knot' => {
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					'light-year' => {
						'name' => q(свет. год.),
						'one' => q({0} сг),
						'other' => q({0} сг),
					},
					'liter' => {
						'name' => q(литри),
						'one' => q({0} л),
						'other' => q({0} л),
						'per' => q({0}/л),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					'liter-per-kilometer' => {
						'name' => q(литри/км),
						'one' => q({0} L/km),
						'other' => q({0} L/km),
					},
					'lux' => {
						'name' => q(лукс),
						'one' => q({0} lx),
						'other' => q({0} lx),
					},
					'megabit' => {
						'name' => q(Mbit),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'name' => q(MByte),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					'megaliter' => {
						'name' => q(ML),
						'one' => q({0} ML),
						'other' => q({0} ML),
					},
					'megawatt' => {
						'name' => q(MW),
						'one' => q({0} MW),
						'other' => q({0} MW),
					},
					'meter' => {
						'name' => q(метри),
						'one' => q({0} м),
						'other' => q({0} м),
						'per' => q({0}/м),
					},
					'meter-per-second' => {
						'name' => q(метри/сек),
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					'meter-per-second-squared' => {
						'name' => q(метри/сек²),
						'one' => q({0} м/с²),
						'other' => q({0} м/с²),
					},
					'metric-ton' => {
						'name' => q(т),
						'one' => q({0} т),
						'other' => q({0} т),
					},
					'microgram' => {
						'name' => q(µg),
						'one' => q({0} µg),
						'other' => q({0} µg),
					},
					'micrometer' => {
						'name' => q(µm),
						'one' => q({0} µm),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'name' => q(μs),
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					'mile' => {
						'name' => q(милји),
						'one' => q({0} ми),
						'other' => q({0} ми),
					},
					'mile-per-gallon' => {
						'name' => q(милји/гал),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					'mile-per-hour' => {
						'name' => q(милји/час),
						'one' => q({0} ми/ч),
						'other' => q({0} ми/ч),
					},
					'mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
					},
					'milliampere' => {
						'name' => q(милиамп.),
						'one' => q({0} mA),
						'other' => q({0} mA),
					},
					'millibar' => {
						'name' => q(мбар),
						'one' => q({0} мбар),
						'other' => q({0} мб.),
					},
					'milligram' => {
						'name' => q(мг),
						'one' => q({0} мг),
						'other' => q({0} мг),
					},
					'milliliter' => {
						'name' => q(mL),
						'one' => q({0} mL),
						'other' => q({0} mL),
					},
					'millimeter' => {
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millimeter-of-mercury' => {
						'name' => q(мм жива),
						'one' => q({0} мм жива),
						'other' => q({0} мм жива),
					},
					'millisecond' => {
						'name' => q(ms),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'milliwatt' => {
						'name' => q(mW),
						'one' => q({0} mW),
						'other' => q({0} mW),
					},
					'minute' => {
						'name' => q(минути),
						'one' => q({0} мин.),
						'other' => q({0} мин.),
						'per' => q({0}/мин.),
					},
					'month' => {
						'name' => q(месеци),
						'one' => q({0} мес.),
						'other' => q({0} мес.),
						'per' => q({0}/мес.),
					},
					'nanometer' => {
						'name' => q(нм),
						'one' => q({0} нм),
						'other' => q({0} нм),
					},
					'nanosecond' => {
						'name' => q(наносек),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					'nautical-mile' => {
						'name' => q(нми),
						'one' => q({0} нми),
						'other' => q({0} нми),
					},
					'ohm' => {
						'name' => q(оми),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(унци),
						'one' => q({0} унца),
						'other' => q({0} унци),
						'per' => q({0}/oz),
					},
					'ounce-troy' => {
						'name' => q(тројска унца),
						'one' => q({0} oz t),
						'other' => q({0} oz t),
					},
					'parsec' => {
						'name' => q(парсеци),
						'one' => q({0} пс),
						'other' => q({0} пс),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'name' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pint' => {
						'name' => q(пинти),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					'pint-metric' => {
						'name' => q(mpt),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
					},
					'pound' => {
						'name' => q(фунти),
						'one' => q({0} фунта),
						'other' => q({0} фунти),
						'per' => q({0}/lb),
					},
					'pound-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					'quart' => {
						'name' => q(qt),
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					'radian' => {
						'name' => q(радијани),
						'one' => q({0} rad),
						'other' => q({0} rad),
					},
					'revolution' => {
						'name' => q(rev),
						'one' => q({0} rev),
						'other' => q({0} rev),
					},
					'second' => {
						'name' => q(секунди),
						'one' => q({0} сек.),
						'other' => q({0} сек.),
						'per' => q({0}/с),
					},
					'square-centimeter' => {
						'name' => q(см²),
						'one' => q({0} см²),
						'other' => q({0} см²),
						'per' => q({0}/см²),
					},
					'square-foot' => {
						'name' => q(квадратни стапки),
						'one' => q({0} кв. стапка),
						'other' => q({0} кв. ст.),
					},
					'square-inch' => {
						'name' => q(in²),
						'one' => q({0} in²),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					'square-kilometer' => {
						'name' => q(км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					'square-meter' => {
						'name' => q(метри²),
						'one' => q({0} м²),
						'other' => q({0} м²),
						'per' => q({0}/м²),
					},
					'square-mile' => {
						'name' => q(кв. милји),
						'one' => q({0} кв. милја),
						'other' => q({0} кв. милји),
					},
					'square-yard' => {
						'name' => q(јарди²),
						'one' => q({0} јд²),
						'other' => q({0} јд²),
					},
					'stone' => {
						'name' => q(стоуни),
						'one' => q({0} стоун),
						'other' => q({0} стоуни),
					},
					'tablespoon' => {
						'name' => q(tbsp),
						'one' => q({0} tbsp),
						'other' => q({0} tbsp),
					},
					'teaspoon' => {
						'name' => q(tsp),
						'one' => q({0} tsp),
						'other' => q({0} tsp),
					},
					'terabit' => {
						'name' => q(Tbit),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'name' => q(TByte),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					'ton' => {
						'name' => q(тони),
						'one' => q({0} тн),
						'other' => q({0} тн),
					},
					'volt' => {
						'name' => q(волти),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					'watt' => {
						'name' => q(вати),
						'one' => q({0} ват),
						'other' => q({0} вати),
					},
					'week' => {
						'name' => q(седмици),
						'one' => q({0} сед.),
						'other' => q({0} сед.),
						'per' => q({0}/сед.),
					},
					'yard' => {
						'name' => q(јарди),
						'one' => q({0} јард),
						'other' => q({0} јарди),
					},
					'year' => {
						'name' => q(години),
						'one' => q({0} год.),
						'other' => q({0} год.),
						'per' => q({0}/год.),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:да|д|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:не|н|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0} и {1}),
				2 => q({0} и {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q(.),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 илј'.'',
					'other' => '0 илј'.'',
				},
				'10000' => {
					'one' => '00 илј'.'',
					'other' => '00 илј'.'',
				},
				'100000' => {
					'one' => '000 илј'.'',
					'other' => '000 илј'.'',
				},
				'1000000' => {
					'one' => '0 мил'.'',
					'other' => '0 мил'.'',
				},
				'10000000' => {
					'one' => '00 мил'.'',
					'other' => '00 мил'.'',
				},
				'100000000' => {
					'one' => '000 М',
					'other' => '000 М',
				},
				'1000000000' => {
					'one' => '0 милј'.'',
					'other' => '0 милј'.'',
				},
				'10000000000' => {
					'one' => '00 милј'.'',
					'other' => '00 милј'.'',
				},
				'100000000000' => {
					'one' => '000 мј'.'',
					'other' => '000 милј'.'',
				},
				'1000000000000' => {
					'one' => '0 трил'.'',
					'other' => '0 трил'.'',
				},
				'10000000000000' => {
					'one' => '00 трил'.'',
					'other' => '00 трил'.'',
				},
				'100000000000000' => {
					'one' => '000 трил'.'',
					'other' => '000 трил'.'',
				},
				'standard' => {
					'' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 илјада',
					'other' => '0 илјади',
				},
				'10000' => {
					'one' => '00 илјади',
					'other' => '00 илјади',
				},
				'100000' => {
					'one' => '000 илјади',
					'other' => '000 илјади',
				},
				'1000000' => {
					'one' => '0 милион',
					'other' => '0 милиони',
				},
				'10000000' => {
					'one' => '00 милиони',
					'other' => '00 милиони',
				},
				'100000000' => {
					'one' => '000 милиони',
					'other' => '000 милиони',
				},
				'1000000000' => {
					'one' => '0 милијарда',
					'other' => '0 милијарди',
				},
				'10000000000' => {
					'one' => '00 милијарди',
					'other' => '00 милијарди',
				},
				'100000000000' => {
					'one' => '000 милијарди',
					'other' => '000 милијарди',
				},
				'1000000000000' => {
					'one' => '0 трилион',
					'other' => '0 трилиони',
				},
				'10000000000000' => {
					'one' => '00 трилиони',
					'other' => '00 трилиони',
				},
				'100000000000000' => {
					'one' => '000 трилиони',
					'other' => '000 трилиони',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 илј'.'',
					'other' => '0 илј'.'',
				},
				'10000' => {
					'one' => '00 илј'.'',
					'other' => '00 илј'.'',
				},
				'100000' => {
					'one' => '000 илј'.'',
					'other' => '000 илј'.'',
				},
				'1000000' => {
					'one' => '0 мил'.'',
					'other' => '0 мил'.'',
				},
				'10000000' => {
					'one' => '00 мил'.'',
					'other' => '00 мил'.'',
				},
				'100000000' => {
					'one' => '000 М',
					'other' => '000 М',
				},
				'1000000000' => {
					'one' => '0 милј'.'',
					'other' => '0 милј'.'',
				},
				'10000000000' => {
					'one' => '00 милј'.'',
					'other' => '00 милј'.'',
				},
				'100000000000' => {
					'one' => '000 мј'.'',
					'other' => '000 милј'.'',
				},
				'1000000000000' => {
					'one' => '0 трил'.'',
					'other' => '0 трил'.'',
				},
				'10000000000000' => {
					'one' => '00 трил'.'',
					'other' => '00 трил'.'',
				},
				'100000000000000' => {
					'one' => '000 трил'.'',
					'other' => '000 трил'.'',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '¤ #,##0.00',
					},
					'standard' => {
						'positive' => '¤ #,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(Андорска Пезета),
			},
		},
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(Обединети Арапски Емирати Дирхам),
				'one' => q(Обединети Арапски Емирати Дирхам),
				'other' => q(Обединети Арапски Емирати Дирхам),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(Авгани \(1927–2002\)),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(Авганистански авгани),
				'one' => q(Авгани),
				'other' => q(Авгани),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(Албански лек),
				'one' => q(Албански лек),
				'other' => q(Албански леки),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(Ермениски Драм),
				'one' => q(Ермениски Драм),
				'other' => q(Ермениски Драм),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(Холандски антилски гилдер),
				'one' => q(Холандски антилски гилдер),
				'other' => q(Холандски антилски гилдери),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(Анголска Кванза),
				'one' => q(Анголска Кванза),
				'other' => q(Анголски кванзи),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(Анголска Кванза \(1977–1990\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(Анголска нова Кванза \(1990–2000\)),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(Аргентински Пезос \(1983–1985\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(Аргентински Пезос),
				'one' => q(Аргентински пезоси),
				'other' => q(Аргентински пезоси),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(Австралиски Шилинг),
			},
		},
		'AUD' => {
			symbol => 'AUD',
			display_name => {
				'currency' => q(Австралиски долар),
				'one' => q(Австралиски Долар),
				'other' => q(Австралиски Долар),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(Арубиски флорин),
				'one' => q(Арубиски флорин),
				'other' => q(Арубиски флорин),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(Азербејџански манат),
				'one' => q(Азербејџански манат),
				'other' => q(Азербејџански манати),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(Босанско-Херцеговски Динар),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(Босанско-Херцеговска конвертибилна марка),
				'one' => q(Босанско-Херцеговска конвертибилна марка),
				'other' => q(Босанско-Херцеговски конвертибилни марки),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(Барбадоски долар),
				'one' => q(Барбадоски долар),
				'other' => q(Барбадоски долари),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(Бангладешка така),
				'one' => q(Бангладешка така),
				'other' => q(Бангладешки таки),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(Белгиски Франк \(конвертибилен\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(Белгиски Франк),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(Белгиски Франк \(финансиски\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(Бугарски цврст лев),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(Бугарски лев),
				'one' => q(Бугарски нов лев),
				'other' => q(Бугарски нов лев),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(Бахреински Динар),
				'one' => q(Бахреински Динар),
				'other' => q(Бахреински Динар),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(Бурундиски франк),
				'one' => q(Бурундиски франк),
				'other' => q(Бурундиски франци),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(Бермудски долар),
				'one' => q(Бермудски долари),
				'other' => q(Бермудски долари),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(Брунејски долар),
				'one' => q(Брунејски долар),
				'other' => q(Брунејски долар),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(Боливиски боливиано),
				'one' => q(Боливиски боливиани),
				'other' => q(Боливиски боливиани),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(Бразилски реал),
				'one' => q(Бразилски реал),
				'other' => q(Бразилски реали),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(Бахамски долар),
				'one' => q(Бахамски долари),
				'other' => q(Бахамски долари),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(Бутански нгултрум),
				'one' => q(Бутански нгултрум),
				'other' => q(Бутански нгултруми),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(Боцванска Пула),
				'one' => q(Боцванска Пула),
				'other' => q(Боцванска Пула),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(Белоруска нова рубља \(1994–1999\)),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(Белоруска рубља),
				'one' => q(Белоруска рубља),
				'other' => q(Белоруски рубљи),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(Белизиски Долар),
				'one' => q(Белизиски Долар),
				'other' => q(Белизиски Долар),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(Канадски долар),
				'one' => q(Канадски долари),
				'other' => q(Канадски долари),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(Конголски франк),
				'one' => q(Конголски франк),
				'other' => q(Конголски франци),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(Швајцарски Франк),
				'one' => q(Швајцарски Франк),
				'other' => q(Швајцарски франци),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(Чилеански пезос),
				'one' => q(Чилеански пезос),
				'other' => q(Чилеански пезос),
			},
		},
		'CNY' => {
			symbol => 'CNY',
			display_name => {
				'currency' => q(Кинески јуан),
				'one' => q(Кинески јуан),
				'other' => q(Кинески јуани),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(Колумбиски Пезос),
				'one' => q(Колумбиски Пезос),
				'other' => q(Колумбиски Пезос),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(Костарикански колон),
				'one' => q(Костарикански колони),
				'other' => q(Костарикански колони),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(Чехословачка цврста корона),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(Кубански пезос \(конвертибилен\)),
				'one' => q(Кубански пезос \(конвертибилен\)),
				'other' => q(Кубански пезоси \(конвертибилни\)),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(Кубански пезос),
				'one' => q(Кубански пезос),
				'other' => q(Кубански пезос),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(Зелено’ртски ескудо),
				'one' => q(Зелено’ртски ескудо),
				'other' => q(Зелено’ртски ескуди),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(Кипарска фунта),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(Чешка корона),
				'one' => q(Чешка корона),
				'other' => q(Чешка корона),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(Германска Марка),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(Џибути франк),
				'one' => q(Џибути франк),
				'other' => q(Џибути франци),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(Данска круна),
				'one' => q(Данска круна),
				'other' => q(Данска круна),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(Доминикански Пезос),
				'one' => q(Доминикански Пезос),
				'other' => q(Доминикански Пезос),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(Алжирски динар),
				'one' => q(Алжирски динар),
				'other' => q(Алжирски динари),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(Египетска фунта),
				'one' => q(Египетска фунта),
				'other' => q(Египетски фунти),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(Еритрејска накфа),
				'one' => q(Еритрејска накфа),
				'other' => q(Еритрејски Накфи),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(Шпанска Пезета),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(Етиописки бир),
				'one' => q(Етиописки бир),
				'other' => q(Етиописки бири),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(Евро),
				'one' => q(евро),
				'other' => q(евра),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(Финска марка),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(Фиџиски долар),
				'one' => q(Фиџиски долар),
				'other' => q(Фиџиски долар),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(Фолкландска фунта),
				'one' => q(Фолкландски фунти),
				'other' => q(Фолкландски фунти),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(Француски франк),
			},
		},
		'GBP' => {
			symbol => 'GBP',
			display_name => {
				'currency' => q(Британска Фунта),
				'one' => q(Британска Фунта),
				'other' => q(Британски фунти),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(Грузиски лари),
				'one' => q(Грузиски лари),
				'other' => q(Грузиски лари),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(Ганајски Седи),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(Гански седи),
				'one' => q(Гански седи),
				'other' => q(Гански седи),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(Гибралтарска фунта),
				'one' => q(Гибралтарска фунта),
				'other' => q(Гибралтарски фунти),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(Гамбиски даласи),
				'one' => q(Гамбиски Даласи),
				'other' => q(Гамбиски Даласи),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(Гвинејски франк),
				'one' => q(Гвинејски франк),
				'other' => q(Гвинејски франци),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(Грчка драхма),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(Гватемалски кветцал),
				'one' => q(Гватемалски кветцал),
				'other' => q(Гватемалски кветцал),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(Гвинејски Бисау пезос),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(Гвијански Долар),
				'one' => q(Гвијански Долар),
				'other' => q(Гвијански Долар),
			},
		},
		'HKD' => {
			symbol => 'HKD',
			display_name => {
				'currency' => q(Хонгконшки долар),
				'one' => q(Хонгконшки долар),
				'other' => q(Хонгконшки долар),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(Хондурска лемпира),
				'one' => q(Хондурски лемпири),
				'other' => q(Хондурски лемпири),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(Хрватски динар),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(Хрватска куна),
				'one' => q(Хрватска куна),
				'other' => q(Хрватски куни),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(Хаитски гурд),
				'one' => q(Хаитски гурд),
				'other' => q(Хаитски гурд),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(Унгарска форинта),
				'one' => q(Унгарска форинта),
				'other' => q(Унгарска форинта),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(Индонезиска рупија),
				'one' => q(Индонезиска рупија),
				'other' => q(Индонезиска рупија),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(Ирска фунта),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(Изрелска фунта),
			},
		},
		'ILS' => {
			symbol => 'ILS',
			display_name => {
				'currency' => q(Израелски нов шекел),
				'one' => q(Израелски нов шекел),
				'other' => q(Израелски нов шекел),
			},
		},
		'INR' => {
			symbol => 'INR',
			display_name => {
				'currency' => q(Индијска рупија),
				'one' => q(Индијска рупија),
				'other' => q(Индијска рупија),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(Ирачки динар),
				'one' => q(Ирачки динар),
				'other' => q(Ирачки динар),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(Ирански риал),
				'one' => q(Ирански риал),
				'other' => q(Ирански риал),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(Исландска крона),
				'one' => q(Исландска крона),
				'other' => q(Исландски крони),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(Италијанска лира),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(Јамајкански долар),
				'one' => q(Јамајкански долари),
				'other' => q(Јамајкански долари),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(Јордански динар),
				'one' => q(Јордански динар),
				'other' => q(Јордански динар),
			},
		},
		'JPY' => {
			symbol => 'JPY',
			display_name => {
				'currency' => q(Јапонски јен),
				'one' => q(Јапонски јен),
				'other' => q(Јапонски јен),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(Кениски шилинг),
				'one' => q(Кениски шилинг),
				'other' => q(Кениски шилинзи),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(Киргистански сом),
				'one' => q(Киргистански сом),
				'other' => q(Киргистански сом),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(Камбоџиски рел),
				'one' => q(Камбоџиски рел),
				'other' => q(Камбоџиски рел),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(Коморски франк),
				'one' => q(Коморски франк),
				'other' => q(Коморски франци),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(Северно корејски вон),
				'one' => q(Северно корејски вон),
				'other' => q(Северно корејски вон),
			},
		},
		'KRW' => {
			symbol => 'KRW',
			display_name => {
				'currency' => q(Јужно корејски вон),
				'one' => q(Јужно корејски вон),
				'other' => q(Јужно корејски вон),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(Кувајтски динар),
				'one' => q(Кувајтски динар),
				'other' => q(Кувајтски динар),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(Долар на кајмански острови),
				'one' => q(Долар на кајмански острови),
				'other' => q(Долари на кајмански острови),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(Казахстанска тенга),
				'one' => q(Казахстанска тенга),
				'other' => q(Казахстанска тенга),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(Лаоски кип),
				'one' => q(Лаоски кип),
				'other' => q(Лаоски кип),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(Либанска фунта),
				'one' => q(Либанска фунта),
				'other' => q(Либанска фунта),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(Шриланканска рупија),
				'one' => q(Шриланканска рупија),
				'other' => q(Шриланканска рупија),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(Либериски долар),
				'one' => q(Либериски долар),
				'other' => q(Либериски долари),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(Лесотско лоти),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(Литваниска лита),
				'one' => q(Литваниска лита),
				'other' => q(Литваниска лита),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(Литваниски литаз),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(Луксембуршки франк),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(Латвијски лат),
				'one' => q(Латвијски лат),
				'other' => q(Латвијски лат),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(Латвијска рубља),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(Либијски динар),
				'one' => q(Либијски динар),
				'other' => q(Либијски динари),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(Марокански Дирхам),
				'one' => q(Марокански Дирхам),
				'other' => q(Марокански дирхами),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(Марокански франк),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(Молдавски леу),
				'one' => q(Молдавски леу),
				'other' => q(Молдавски леу),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(Малагасиски ариари),
				'one' => q(Малагасиски ариари),
				'other' => q(Малагасиски ариари),
			},
		},
		'MKD' => {
			symbol => 'ден',
			display_name => {
				'currency' => q(Македонски денар),
				'one' => q(Македонски денар),
				'other' => q(Македонски денари),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(Малски франк),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(Мјанмарски киат),
				'one' => q(Мјанмарски киат),
				'other' => q(Мјанмарски киати),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(Монголиски тугрик),
				'one' => q(Монголиски тугрик),
				'other' => q(Монголиски тугрик),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(Макао патака),
				'one' => q(Макао патака),
				'other' => q(Макао патака),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(Мавританска угија),
				'one' => q(Мавританска угија),
				'other' => q(Мавритански угии),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(Малтешка лира),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(Малтешка фунта),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(Мавританска рупија),
				'one' => q(Мавританска рупија),
				'other' => q(Мавритански рупии),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(Малдивиска руфија),
				'one' => q(Малдивска руфија),
				'other' => q(Малдивски руфии),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(Малависка квача),
				'one' => q(Малависка квача),
				'other' => q(Малависки квачи),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(Мексикански пезос),
				'one' => q(Мексикански пезоси),
				'other' => q(Мексикански пезоси),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(Мексикански сребрен пезос \(1861–1992\)),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(Малазиски рингит),
				'one' => q(Малазиски рингит),
				'other' => q(Малазиски рингит),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(Мозамбиско ескудо),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(Стар мозамбиски метикал),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(Мозамбиски метикал),
				'one' => q(Мозамбиски метикал),
				'other' => q(Мозамбиски метикали),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(Намибиски долар),
				'one' => q(Намибиски долар),
				'other' => q(Намибиски долар),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(Нигериска наира),
				'one' => q(Нигериска наира),
				'other' => q(Нигериски наири),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(Никарагванска кордоба \(1988–1991\)),
				'one' => q(Никарагванска кордоба \(1988–1991\)),
				'other' => q(Никарагвански кордоби \(1988–1991\)),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(Никарагванска кордоба),
				'one' => q(Никарагванска кордоба),
				'other' => q(Никарагвански кордоби),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(Холандски гилдер),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(Норвешка круна),
				'one' => q(Норвешка круна),
				'other' => q(Норвешки круни),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(Непалска рупија),
				'one' => q(Непалска рупија),
				'other' => q(Непалска рупија),
			},
		},
		'NZD' => {
			symbol => 'NZD',
			display_name => {
				'currency' => q(Новозеландски долар),
				'one' => q(Новозеландски долар),
				'other' => q(Новозеландски долар),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(Омански риал),
				'one' => q(Омански риал),
				'other' => q(Омански риал),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(Панамска балбоа),
				'one' => q(Панамска балбоа),
				'other' => q(Панамска балбоа),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(Перуански нов сол),
				'one' => q(Перуански нов сол),
				'other' => q(Перуански нов сол),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(Перуански сол),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(Папуа новогвинејска кина),
				'one' => q(Папуа новогвинејска кина),
				'other' => q(Папуа новогвинејска кина),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(Филипински пезос),
				'one' => q(Филипински пезос),
				'other' => q(Филипински пезос),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(Пакистанска рупија),
				'one' => q(Пакистанска рупија),
				'other' => q(Пакистанска рупија),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(Полска злота),
				'one' => q(Полска злота),
				'other' => q(Полски злоти),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(Полска злота \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(Португалско ескудо),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(Парагвајска гуарана),
				'one' => q(Парагвајска гуарана),
				'other' => q(Парагвајска гуарана),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(Катарски риал),
				'one' => q(Катарски риал),
				'other' => q(Катарски риал),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(Романска леи \(1952–2006\)),
				'one' => q(Романска леи \(1952–2006\)),
				'other' => q(Романска леи \(1952–2006\)),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(Романска леи),
				'one' => q(Романски леи),
				'other' => q(Романски леи),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(Српски динар),
				'one' => q(Српски динар),
				'other' => q(Српски динари),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(Руска рубља),
				'one' => q(Руска рубља),
				'other' => q(Руски рубљи),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(Руска рубља \(1991–1998\)),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(Руандски франк),
				'one' => q(Руандски франк),
				'other' => q(Руандски франци),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(Саудиски ријал),
				'one' => q(Саудиски ријал),
				'other' => q(Саудиски ријал),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(Соломонски долар),
				'one' => q(Соломонски долар),
				'other' => q(Соломонски долар),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(Сејшелска рупија),
				'one' => q(Сејшелска рупија),
				'other' => q(Сејшелски рупии),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(Стар судански динар),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(Суданска фунта),
				'one' => q(Суданска фунта),
				'other' => q(Судански фунти),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(Стара суданска фунта),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(Шведска круна),
				'one' => q(Шведска круна),
				'other' => q(Шведски круни),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(Сингапурски долар),
				'one' => q(Сингапурски долар),
				'other' => q(Сингапурски долар),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(Фунта на Света Елена),
				'one' => q(Фунта на Света Елена),
				'other' => q(Фунти на Света Елена),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(Словенечки толар),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(Словачка круна),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(Сиералеонско леоне),
				'one' => q(Сиералеонско леоне),
				'other' => q(Сиералеонски леони),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(Сомалијски шилинг),
				'one' => q(Сомалијски шилинг),
				'other' => q(Сомалијски шилинзи),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(Суринамски долар),
				'one' => q(Суринамски долар),
				'other' => q(Суринамски долари),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(Суринамски гилдер),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(Јужносуданска фунта),
				'one' => q(Јужносуданска фунта),
				'other' => q(Јужносудански фунти),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(Добра на Сао Томе и Принсипе),
				'one' => q(Добра на Сао Томе и Принсипе),
				'other' => q(Добри на Сао Томе и Принсипе),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(Советска рубља),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(Салвадорски колон),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(Сиријска фунта),
				'one' => q(Сиријска фунта),
				'other' => q(Сиријска фунта),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(Свазилендски лиланген),
				'one' => q(Свазилендски лиланген),
				'other' => q(Свазилендски лиланген),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(Таи бат),
				'one' => q(Таи бат),
				'other' => q(Таи бат),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(Таџикистанска рубља),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(Таџикистански сомони),
				'one' => q(Таџикистански сомони),
				'other' => q(Таџикистански сомони),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(Туркменистански манат),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(Туркменист. манат),
				'one' => q(Туркменистански манати),
				'other' => q(Туркменистански манати),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(Тунизиски динар),
				'one' => q(Тунизиски динар),
				'other' => q(Тунизиски динари),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(Тонганска панга),
				'one' => q(Тонганска панга),
				'other' => q(Тонганска панга),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(Тиморски ескудо),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(Турска лира \(1922–2005\)),
				'one' => q(Турска лира \(1922–2005\)),
				'other' => q(Турска лира \(1922–2005\)),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(Турска лира),
				'one' => q(Турска лира),
				'other' => q(Турски лири),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(Долар на Тринидад и Тобаго),
				'one' => q(Долари на Тринидад и Тобаго),
				'other' => q(Долари на Тринидад и Тобаго),
			},
		},
		'TWD' => {
			symbol => 'TWD',
			display_name => {
				'currency' => q(Тајвански нов долар),
				'one' => q(Тајвански нов долар),
				'other' => q(Тајвански нов долар),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(Танзаниски шилинг),
				'one' => q(Танзаниски шилинг),
				'other' => q(Танзаниски шилинзи),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(Украинска хривнија),
				'one' => q(Украинска хривнија),
				'other' => q(Украински хривнии),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(Угандиски шилинг \(1966–1987\)),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(Угандиски шилинг),
				'one' => q(Угандиски шилинг),
				'other' => q(Угандиски шилинзи),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(Американски долар),
				'one' => q(Американски долари),
				'other' => q(Американски долари),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(САД долар \(Next day\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(САД долар \(Same day\)),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(Уругвајски пезос \(1975–1993\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(Уругвајски пезос),
				'one' => q(Уругвајски пезоси),
				'other' => q(Уругвајски пезоси),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(Узбекистански сом),
				'one' => q(Узбекистански сом),
				'other' => q(Узбекистански сом),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(Венецуелски боливар \(1871–2008\)),
				'one' => q(Венецуелски боливар \(1871–2008\)),
				'other' => q(Венецуелски боливар \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(Венецуелски боливар),
				'one' => q(Венецуелски боливар),
				'other' => q(Венецуелски боливари),
			},
		},
		'VND' => {
			symbol => 'VND',
			display_name => {
				'currency' => q(Виетнамски донг),
				'one' => q(Виетнамски донг),
				'other' => q(Виетнамски донг),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(Ванатски вату),
				'one' => q(Ванатски вату),
				'other' => q(Ванатски вату),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(Самоанска тала),
				'one' => q(Самоанска тала),
				'other' => q(Самоанска тала),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(Централноафрикански франк),
				'one' => q(Централноафрикански франк),
				'other' => q(Централноафрикански франци),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(Источно карибиски долар),
				'one' => q(Источно карибиски долар),
				'other' => q(Источно карибиски долар),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(Западноафрикански франк),
				'one' => q(Западноафрикански франк),
				'other' => q(Западноафрикански франци),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(ЦФП франк),
				'one' => q(ЦФП франк),
				'other' => q(ЦФП франци),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Непозната валута),
				'one' => q(Непозната валута),
				'other' => q(Непозната валута),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(Јеменски динар),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(Јеменски риал),
				'one' => q(Јеменски риал),
				'other' => q(Јеменски риал),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(Југословенски динар),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(Југословенски конвертибилен динар),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(Јужно афрички ранд\(финансиски\)),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(Јужно афрички ранд),
				'one' => q(Јужно афрички ранд),
				'other' => q(Јужно афрички ранд),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(Замбијска квача \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(Замбијска квача),
				'one' => q(Замбијска квача),
				'other' => q(Замбијски квачи),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(Заирско новозаире),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(Заирско заире),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(Зимбабвиски долар),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'јан.',
							'фев.',
							'мар.',
							'апр.',
							'мај',
							'јун.',
							'јул.',
							'авг.',
							'септ.',
							'окт.',
							'ноем.',
							'дек.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ј',
							'ф',
							'м',
							'а',
							'м',
							'ј',
							'ј',
							'а',
							'с',
							'о',
							'н',
							'д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'јануари',
							'февруари',
							'март',
							'април',
							'мај',
							'јуни',
							'јули',
							'август',
							'септември',
							'октомври',
							'ноември',
							'декември'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'јан.',
							'фев.',
							'мар.',
							'апр.',
							'мај',
							'јун.',
							'јул.',
							'авг.',
							'септ.',
							'окт.',
							'ноем.',
							'дек.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ј',
							'ф',
							'м',
							'а',
							'м',
							'ј',
							'ј',
							'а',
							'с',
							'о',
							'н',
							'д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'јануари',
							'февруари',
							'март',
							'април',
							'мај',
							'јуни',
							'јули',
							'август',
							'септември',
							'октомври',
							'ноември',
							'декември'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'пон.',
						tue => 'вт.',
						wed => 'сре.',
						thu => 'чет.',
						fri => 'пет.',
						sat => 'саб.',
						sun => 'нед.'
					},
					narrow => {
						mon => 'п',
						tue => 'в',
						wed => 'с',
						thu => 'ч',
						fri => 'п',
						sat => 'с',
						sun => 'н'
					},
					short => {
						mon => 'пон.',
						tue => 'вт.',
						wed => 'сре.',
						thu => 'чет.',
						fri => 'пет.',
						sat => 'саб.',
						sun => 'нед.'
					},
					wide => {
						mon => 'понеделник',
						tue => 'вторник',
						wed => 'среда',
						thu => 'четврток',
						fri => 'петок',
						sat => 'сабота',
						sun => 'недела'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'пон.',
						tue => 'вт.',
						wed => 'сре.',
						thu => 'чет.',
						fri => 'пет.',
						sat => 'саб.',
						sun => 'нед.'
					},
					narrow => {
						mon => 'п',
						tue => 'в',
						wed => 'с',
						thu => 'ч',
						fri => 'п',
						sat => 'с',
						sun => 'н'
					},
					short => {
						mon => 'пон.',
						tue => 'вто.',
						wed => 'сре.',
						thu => 'чет.',
						fri => 'пет.',
						sat => 'саб.',
						sun => 'нед.'
					},
					wide => {
						mon => 'понеделник',
						tue => 'вторник',
						wed => 'среда',
						thu => 'четврток',
						fri => 'петок',
						sat => 'сабота',
						sun => 'недела'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'јан-мар',
						1 => 'апр-јун',
						2 => 'јул-сеп',
						3 => 'окт-дек'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'прво тромесечје',
						1 => 'второ тромесечје',
						2 => 'трето тромесечје',
						3 => 'четврто тромесечје'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'јан-мар',
						1 => 'апр-јун',
						2 => 'јул-сеп',
						3 => 'окт-дек'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'прво тромесечје',
						1 => 'второ тромесечје',
						2 => 'трето тромесечје',
						3 => 'четврто тромесечје'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'generic') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'night1' if $time >= 0
						&& $time < 400;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'night1' if $time >= 0
						&& $time < 400;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'morning1' if $time >= 400
						&& $time < 1000;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1000;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'night1' if $time >= 0
						&& $time < 400;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'night1' if $time >= 0
						&& $time < 400;
					return 'morning2' if $time >= 1000
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'morning1' if $time >= 400
						&& $time < 1000;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
	my ($orig, $self) = @_;
	return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'midnight' => q{полноќ},
					'am' => q{претпладне},
					'noon' => q{на пладне},
					'evening1' => q{навечер},
					'morning2' => q{претпладне},
					'night1' => q{ноќе},
					'morning1' => q{наутро},
					'afternoon1' => q{попладне},
					'pm' => q{попладне},
				},
				'narrow' => {
					'midnight' => q{полн.},
					'am' => q{прет.},
					'evening1' => q{веч.},
					'noon' => q{напл.},
					'night1' => q{полн.},
					'morning2' => q{прет.},
					'pm' => q{попл.},
					'afternoon1' => q{попл.},
					'morning1' => q{утро},
				},
				'wide' => {
					'morning1' => q{наутро},
					'afternoon1' => q{попладне},
					'pm' => q{попладне},
					'night1' => q{по полноќ},
					'morning2' => q{претпладне},
					'noon' => q{на пладне},
					'evening1' => q{навечер},
					'am' => q{претпладне},
					'midnight' => q{полноќ},
				},
			},
			'stand-alone' => {
				'narrow' => {
					'midnight' => q{полноќ},
					'pm' => q{попл.},
					'afternoon1' => q{попладне},
					'morning1' => q{наутро},
					'night1' => q{по полноќ},
					'morning2' => q{претпладне},
					'evening1' => q{навечер},
					'noon' => q{пладне},
					'am' => q{прет.},
				},
				'wide' => {
					'midnight' => q{на полноќ},
					'morning2' => q{претпладне},
					'night1' => q{по полноќ},
					'pm' => q{попладне},
					'afternoon1' => q{попладне},
					'morning1' => q{наутро},
					'am' => q{претпладне},
					'evening1' => q{навечер},
					'noon' => q{напладне},
				},
				'abbreviated' => {
					'evening1' => q{навечер},
					'noon' => q{пладне},
					'am' => q{претпладне},
					'pm' => q{попладне},
					'afternoon1' => q{попладне},
					'morning1' => q{наутро},
					'morning2' => q{претпладне},
					'night1' => q{по полноќ},
					'midnight' => q{полноќ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'пр.н.е.',
				'1' => 'н.е.'
			},
			narrow => {
				'0' => 'пр.н.е.',
				'1' => 'н.е.'
			},
			wide => {
				'0' => 'пред нашата ера',
				'1' => 'од нашата ера'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, dd MMMM y 'г'. G},
			'long' => q{dd MMMM y 'г'. G},
			'medium' => q{dd.M.y G},
			'short' => q{dd.M.y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, dd MMMM y},
			'long' => q{dd MMMM y},
			'medium' => q{dd.M.y},
			'short' => q{dd.M.yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			E => q{E},
			Ed => q{d E},
			Gy => q{y 'г'. G},
			GyMMM => q{MMM y 'г'. G},
			GyMMMEd => q{E, dd MMM y 'г'. G},
			GyMMMd => q{dd MMM y 'г'. G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, dd.M},
			MMM => q{LLL},
			MMMEd => q{E, dd MMM},
			MMMMEd => q{E, dd MMMM},
			MMMMd => q{dd MMMM},
			MMMd => q{dd MMM},
			Md => q{dd.M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y 'г'. G},
			yyyy => q{y 'г'. G},
			yyyyM => q{M.y G},
			yyyyMEd => q{E, dd.M.y G},
			yyyyMMM => q{MMM y 'г'. G},
			yyyyMMMEd => q{E, dd MMM y 'г'. G},
			yyyyMMMM => q{MMMM y 'г'. G},
			yyyyMMMd => q{dd MMM y 'г'. G},
			yyyyMd => q{dd.M.y G},
			yyyyQQQ => q{G y QQQ},
			yyyyQQQQ => q{G y QQQQ},
		},
		'gregorian' => {
			E => q{ccc},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, dd MMM y G},
			GyMMMd => q{dd MMM y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E, d.M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMMEd => q{E d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d.M},
			Mdd => q{dd.M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M.y},
			yMEd => q{E, d.M.y},
			yMMM => q{MMM y 'г'.},
			yMMMEd => q{E, d MMM y 'г'.},
			yMMMM => q{MMMM y 'г'.},
			yMMMd => q{d MMM y 'г'.},
			yMd => q{d.M.y},
			yQQQ => q{QQQ y 'г'.},
			yQQQQ => q{QQQQ y 'г'.},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.M – E, dd.M},
				d => q{E, dd.M – E, dd.M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, dd MMM – E, dd MMM},
				d => q{E, dd – E, dd MMM},
			},
			MMMM => {
				M => q{LLLL–LLLL},
			},
			MMMd => {
				M => q{dd MMM – dd MMM},
				d => q{dd–dd MMM},
			},
			Md => {
				M => q{dd.M – dd.M},
				d => q{dd.M – dd.M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{M.y – M.y G},
				y => q{M.y – M.y G},
			},
			yMEd => {
				M => q{E, dd.M.y – E, dd.M.y G},
				d => q{E, dd.M.y – E, dd.M.y G},
				y => q{E, dd.M.y – E, dd.M.y G},
			},
			yMMM => {
				M => q{MMM–MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, dd MMM – E, dd MMM y G},
				d => q{E, dd – E, dd MMM y G},
				y => q{E, dd MMM y – E, dd MMM y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{dd MMM – dd MMM y G},
				d => q{dd–dd MMM y G},
				y => q{dd MMM y – dd MMM y G},
			},
			yMd => {
				M => q{dd.M.y – dd.M.y G},
				d => q{dd.M.y – dd.M.y G},
				y => q{dd.M.y – dd.M.y G},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.M – E, dd.M},
				d => q{E, dd.M – E, dd.M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, dd MMM – E, dd MMM},
				d => q{E, dd – E, dd MMM},
			},
			MMMM => {
				M => q{LLLL–LLLL},
			},
			MMMd => {
				M => q{dd MMM – dd MMM},
				d => q{dd–dd MMM},
			},
			Md => {
				M => q{dd.M – dd.M},
				d => q{dd.M – dd.M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M.y – M.y},
				y => q{M.y – M.y},
			},
			yMEd => {
				M => q{E, dd.M.y – E, dd.M.y},
				d => q{E, dd.M.y – E, dd.M.y},
				y => q{E, dd.M.y – E, dd.M.y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, dd MMM – E, dd MMM y},
				d => q{E, dd – E, dd MMM y},
				y => q{E, dd MMM y – E, dd MMM y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{dd MMM – dd MMM y},
				d => q{dd–dd MMM y},
				y => q{dd MMM y – dd MMM y},
			},
			yMd => {
				M => q{dd.M.y – dd.M.y},
				d => q{dd.M.y – dd.M.y},
				y => q{dd.M.y – dd.M.y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(Време во {0}),
		regionFormat => q({0} (+1)),
		regionFormat => q({0} (+0)),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q(Акре летно сметање на времето),
				'generic' => q(Акре време),
				'standard' => q(Акре стандардно време),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(Време во Авганистан),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиџан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Акра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Адис Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмара#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Банги#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банџул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантајр#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Бразавил#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Буџумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каиро#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Казабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар ес Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Џибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Ел Ајун#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Јоханесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Џуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Картум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либрвил#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуто#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишу#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровија#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Најроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нџамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Нијамеј#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сао Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(Средноафриканско време),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(Источноафриканско време),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(Време во Јужноафриканска Република),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(Западноафриканско летно сметање на времето),
				'generic' => q(Западноафриканско време),
				'standard' => q(Западноафриканско стандардно време),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(Летно сметање на времето во Аљаска),
				'generic' => q(Време во Аљаска),
				'standard' => q(Стандардно време во Аљаска),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(Летно сметање на времето во Амазон),
				'generic' => q(Време во Амазон),
				'standard' => q(Стандардно време во Амазон),
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Енкориџ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангилја#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигва#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагвајана#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио Галегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан Луис#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуаја#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсион#,
		},
		'America/Bahia' => {
			exemplarCity => q#Бахиа#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Бахија де Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белизе#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Сејблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бојзи#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буенос Аирес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кембриџ Беј#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампо Гранде#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кајена#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кајмански Острови#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чивава#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Корал Харбор#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордоба#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Костарика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Кујаба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Курасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмаркшан#,
		},
		'America/Dawson' => {
			exemplarCity => q#Досон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Досон Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детроит#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Едмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Еирунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Ел Салвадор#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глејс Беј#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нук#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус Беј#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Турк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гвадалупе#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гвајакил#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гвајана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Халифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Хавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Ермосиљо#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индијана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индијана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питерсбург, Индијана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Тел Сити, Индијана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вивеј, Индијана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Венсен, Индијана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Винамак, Индијана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индијанаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Икалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Јамајка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Хухуј#,
		},
		'America/Juneau' => {
			exemplarCity => q#Џуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичело, Кентаки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендајк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла Паз#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос Анџелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луизвил#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Долен Принс квортр#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масејо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагва#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиник#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Мазатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоза#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мексико Сити#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелан#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтереј#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсерат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Насау#,
		},
		'America/New_York' => {
			exemplarCity => q#Њујорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Нороња#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Бјула, Северна Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Центар, Северна Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Њу Салем, Северна Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангниртунг#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Феникс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт о Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт ов Спејн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порто Вељо#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Порторико#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рејни Ривер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ренкин Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифи#,
		},
		'America/Regina' => {
			exemplarCity => q#Реџајна#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резолут#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рио Бранко#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Света Изабела#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантијаго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сао Паоло#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Итокортормит#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сент Бартоломеј#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент Џонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Свети Кристофер#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Света Луција#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт Курент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигалпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Тандр Беј#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Вајтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Винипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Јакутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Јелоунајф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(Централно летно сметање на времето),
				'generic' => q(Централно време во Северна Америка),
				'standard' => q(Централно стандардно време во Северна Америка),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(Источно летно сметање на времето),
				'generic' => q(Источно време),
				'standard' => q(Источно стандардно време),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(Планинско летно сметање на времето),
				'generic' => q(Планинско време),
				'standard' => q(Планинско стандардно време),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(Пацифичко летно сметање на времето),
				'generic' => q(Пацифичко време),
				'standard' => q(Пацифичко стандардно време),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(Анадирско летно време),
				'generic' => q(Анадирско време),
				'standard' => q(Анадирско стандардно време),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кејси#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дејвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Димон Дирвил#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маквори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Мосон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Макмурдо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Сајова#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Трол#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q(Летно време во Апија),
				'generic' => q(Време во Апија),
				'standard' => q(Стандардно време во Апија),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(Арапски летно сметање на времето),
				'generic' => q(Арапско време),
				'standard' => q(Стандардно арапско време),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгјирбјен#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(Летно сметање на времето во Аргентина),
				'generic' => q(Време во Аргентина),
				'standard' => q(Стандардно време во Аргентина),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(Летно сметање на времето во западна Аргентина),
				'generic' => q(Време во западна Аргентина),
				'standard' => q(Стандардно време во западна Аргентина),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(Летно време во Ерменија),
				'generic' => q(Време во Ерменија),
				'standard' => q(Стандардно време во Ерменија),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алмати#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Аман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадир#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Актобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашкабад#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахреин#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бејрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Брунеј#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Колката#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Чита#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чојбалсан#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дака#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубаи#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеброн#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Хонг Конг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркутск#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Џакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Џајапура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Ерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандига#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Краснојарск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучинг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувајт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макасар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Мускат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никозија#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузњецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пном Пен#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтијанак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пјонгјанг#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кизилорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Ријад#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хо Ши Мин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сакалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шангај#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Среднеколимск#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тајпеј#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Техеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тимпу#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Урумчи#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Уст-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Виентијан#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Јакутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Екатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Ереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(Атлантско летно сметање на времето),
				'generic' => q(Атлантско време),
				'standard' => q(Атлантско стандардно време),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азорски Острови#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуди#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канарски Острови#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Зелен ‘Рт#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарски Острови#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадеира#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рејкјавик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Јужна Џорџија#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Света Елена#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стенли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Бризбејн#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен Хил#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Курие#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Јукла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд Хау#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мелбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сиднеј#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(Летно сметање на времето во Централна Австралија),
				'generic' => q(Време во Централна Австралија),
				'standard' => q(Стандардно време во Централна Австралија),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(Летно сметање на времето во Централна и Западна Австралија),
				'generic' => q(Време во Централна и Западна Австралија),
				'standard' => q(Стандардно време во Централна и Западна Австралија),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(Летно сметање на времето во Источна Австралија),
				'generic' => q(Време во Источна Австралија),
				'standard' => q(Стандардно време во Источна Австралија),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(Летно сметање на времето во Западна Австралија),
				'generic' => q(Време во Западна Австралија),
				'standard' => q(Стандардно време во Западна Австралија),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(Летно време во Азербејџан),
				'generic' => q(Време во Азербејџан),
				'standard' => q(Стандардно време во Азербејџан),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(Летно време во Азорес),
				'generic' => q(Време во Азорес),
				'standard' => q(Стандардно време во Азорес),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(Летно време во Бангладеш),
				'generic' => q(Време во Бангладеш),
				'standard' => q(Стандардно време во Бангладеш),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(Време во Бутан),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(Време во Боливија),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(Летно сметање на времето во Бразилија),
				'generic' => q(Време во Бразилија),
				'standard' => q(Стандардно време во Бразилија),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(Време во Брунеи Дарусалам),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(Летно време на Зелениот ‘Рт),
				'generic' => q(Време на Зелениот ‘Рт),
				'standard' => q(Стандардно време на Зелениот ‘Рт),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(Време во Чаморо),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(Летно сметање на времето во Четем),
				'generic' => q(Време во Четем),
				'standard' => q(Стандардно време во Четем),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(Летно сметање на времето во Чиле),
				'generic' => q(Време во Чиле),
				'standard' => q(Стандардно време во Чиле),
			},
		},
		'China' => {
			long => {
				'daylight' => q(Летно сметање на времето во Кина),
				'generic' => q(Време во Кина),
				'standard' => q(Стандардно време во Кина),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(Летно време во Чојбалсан),
				'generic' => q(Време во Чојбалсан),
				'standard' => q(Стандардно време во Чојбалсан),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(Време на Божиќниот остров),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(Време на Кокосовите Острови),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(Летно сметање на времето во Колумбија),
				'generic' => q(Време во Колумбија),
				'standard' => q(Стандардно време во Колумбија),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(Летно време на Островите Кук),
				'generic' => q(Време на островите Кук),
				'standard' => q(Стандардно време на Островите Кук),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(Летно сметање на времето во Куба),
				'generic' => q(Време во Куба),
				'standard' => q(Стандардно време во Куба),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(Време во Дејвис),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(Време во Димон-дурвил),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(Време во Источен Тимор),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(Летно време на Велигденскиот Остров),
				'generic' => q(Време на Велигденскиот Остров),
				'standard' => q(Стандардно време на Велигденскиот Остров),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(Време во Еквадор),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Непознат град#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андора#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Атина#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брисел#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Букурешт#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будимпешта#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бисинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинау#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенхаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Даблин#,
			long => {
				'daylight' => q(Ирско стандардно време),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернзи#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хелсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Остров Ман#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Истанбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Џерзи#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Киев#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лисабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Љубљана#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q(Британско летно време),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Луксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Малта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Маријехамен#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париз#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараево#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферопол#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопје#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Софија#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокхолм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Талин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужхород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуц#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Виена#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вилнус#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожје#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цирих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(Средноевропско летно време),
				'generic' => q(Средноевропско време),
				'standard' => q(Средноевропско стандардно време),
			},
			short => {
				'daylight' => q(CEST),
				'generic' => q(CET),
				'standard' => q(CET),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(Источноевропско летно време),
				'generic' => q(Источноевропско време),
				'standard' => q(Источноевропско стандардно време),
			},
			short => {
				'daylight' => q(EEST),
				'generic' => q(EET),
				'standard' => q(EET),
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q(Калининградско време),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(Западноевропско летно време),
				'generic' => q(Западноевропско време),
				'standard' => q(Западноевропско стандардно време),
			},
			short => {
				'daylight' => q(WEST),
				'generic' => q(WET),
				'standard' => q(WET),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(Летно сметање на времето на Фолкландските Острови),
				'generic' => q(Време на Фолкландските Острови),
				'standard' => q(Стандардно време на Фолкландските Острови),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(Летно време во Фиџи),
				'generic' => q(Време во Фиџи),
				'standard' => q(Стандардно време во Фиџи),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(Време во Француска Гвајана),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(Француско јужно и антарктичко време),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(Средно време по Гринич),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(Време во Галапагос),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(Време во Гамбе),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(Летно време во Грузија),
				'generic' => q(Време во Грузија),
				'standard' => q(Стандардно време во Грузија),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(Време на Островите Гилберт),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(Летно сметање на времето во Источен Гренланд),
				'generic' => q(Време во Источен Гренланд),
				'standard' => q(Стандардно време во Источен Гренланд),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(Летно сметање на времето во Западен Гренланд),
				'generic' => q(Време во Западен Гренланд),
				'standard' => q(Стандардно време во Западен Гренланд),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(Време на Мексиканскиот Залив),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(Време во Гвајана),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(Летно сметање на времето во Хаваи - Алеутски острови),
				'generic' => q(Време во Хаваи - Алеутски острови),
				'standard' => q(Стандардно време во Хаваи - Алеутски острови),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(Летно време во Хонг Конг),
				'generic' => q(Време во Хонг Конг),
				'standard' => q(Стандардно време во Хонг Конг),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(Летно време во Ховд),
				'generic' => q(Време во Ховд),
				'standard' => q(Стандардно време во Ховд),
			},
		},
		'India' => {
			long => {
				'standard' => q(Време во Индија),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариво#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Божиќен Остров#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокосови Острови#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморски Острови#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Махе#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Малдиви#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маврициус#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Мајот#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Ријунион#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(Време на Индиски океан),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(Време во Индокина),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(Време во Централна Индонезија),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(Време во Источна Индонезија),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(Време во Западна Индонезија),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(Летно сметање на времето во Иран),
				'generic' => q(Време во Иран),
				'standard' => q(Стандардно време во Иран),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(Летно време во Иркутск),
				'generic' => q(Време во Иркутск),
				'standard' => q(Стандардно време во Иркутск),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(Летно сметање на времето во Израел),
				'generic' => q(Време во Израел),
				'standard' => q(Стандардно време во Израел),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(Летно сметање на времето во Јапонија),
				'generic' => q(Време во Јапонија),
				'standard' => q(Стандардно време во Јапонија),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(Време во Источен Казахстан),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(Време во Западен Казахстан),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(Летно сметање на времето во Кореја),
				'generic' => q(Време во Кореја),
				'standard' => q(Стандардно време во Кореја),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(Време во Косра),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(Летно време во Краснојарск),
				'generic' => q(Време во Краснојарск),
				'standard' => q(Стандардно време во Краснојарск),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(Време во Киргистан),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(Време во Линиски Острови),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(Летно сметање на времето во Лорд Хау),
				'generic' => q(Време во Лорд Хау),
				'standard' => q(Стандардно време во Лорд Хау),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(Време на Островот Макуари),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(Летно време во Магадан),
				'generic' => q(Време во Магадан),
				'standard' => q(Стандардно време во Магадан),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(Време во Малезија),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(Време на Малдиви),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(Време во Маркесас),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(Време на Маршалски острови),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(Летно сметање на времето на Маврициус),
				'generic' => q(Време на Маврициус),
				'standard' => q(Стандардно време на Маврициус),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(Време во Мосон),
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q(Летно сметање на времето во северозападно Мексико),
				'generic' => q(Време во северозападно Мексико),
				'standard' => q(Стандардно време во северозападно Мексико),
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q(Летно тихоокеанско време во Мексико),
				'generic' => q(Тихоокеанско време во Мексико),
				'standard' => q(Стандардно тихоокеанско време во Мексико),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(Летно време во Улан Батор),
				'generic' => q(Време во Улан Батор),
				'standard' => q(Стандардно време во Улан Батор),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(Летно сметање на времето во Москва),
				'generic' => q(Време во Москва),
				'standard' => q(Стандардно време во Москва),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(Време во Мјанмар),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(Време во Науру),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(Време во Непал),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(Летно време во Нова Каледонија),
				'generic' => q(Време во Нова Каледонија),
				'standard' => q(Стандардно време во Нова Каледонија),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(Летно сметање на времето во Нов Зеланд),
				'generic' => q(Време во Нов Зеланд),
				'standard' => q(Стандардно време во Нов Зеланд),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(Летно сметање на времето на Њуфаундленд),
				'generic' => q(Време на Њуфаундленд),
				'standard' => q(Стандардно време на Њуфаундленд),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(Време во Ниуе),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(Време на Островите Норфолк),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(Летно сметање на времето на Фернандо де Нороња),
				'generic' => q(Време на Фернандо де Нороња),
				'standard' => q(Стандардно време на Фернандо де Нороња),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(Летно време во Новосибирск),
				'generic' => q(Време во Новосибирск),
				'standard' => q(Стандардно време во Новосибирск),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(Летно време во Омск),
				'generic' => q(Време во Омск),
				'standard' => q(Стандардно време во Омск),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апија#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окленд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Буганвил#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатам#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Велигденски Остров#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Ефате#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Ендербери#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фиџи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбије#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гвадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гвам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Хонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Џонстон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Косрае#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваџалејн#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Маџуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркески Острови#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидвеј#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуе#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкернски Острови#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понпеј#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт Морсби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сајпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Тахити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Чук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Вејк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Валис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(Летно време во Пакистан),
				'generic' => q(Време во Пакистан),
				'standard' => q(Стандардно време во Пакистан),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(Време во Палау),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(Време во Папуа Нова Гвинеја),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(Летно сметање на времето во Парагвај),
				'generic' => q(Време во Парагвај),
				'standard' => q(Стандардно време во Парагвај),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(Летно сметање на времето во Перу),
				'generic' => q(Време во Перу),
				'standard' => q(Стандардно време во Перу),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(Летно време во Филипини),
				'generic' => q(Време во Филипини),
				'standard' => q(Стандардно време во Филипини),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(Време на Островите Феникс),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(Летно сметање на времето на Сент Пјер и Микелан),
				'generic' => q(Време на на Сент Пјер и Микелан),
				'standard' => q(Стандардно време на Сент Пјер и Микелан),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(Време во Питкерн),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(Време во Понапе),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(Време на Ријунион),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(Време во Ротера),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(Летно време во Сакалин),
				'generic' => q(Време во Сакалин),
				'standard' => q(Стандардно време во Сакалин),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(Самара летно сметање на времето),
				'generic' => q(Самара време),
				'standard' => q(Самара стандардно време),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(Летно време во Самоа),
				'generic' => q(Време во Самоа),
				'standard' => q(Стандардно време во Самоа),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(Време на Сејшели),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(Време во Сингапур),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(Време на Соломонските острови),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(Време во Јужна Грузија),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(Време во Суринам),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(Време во Сајова),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(Време во Тахити),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(Летно сметање на времето во Таипеи),
				'generic' => q(Време во Таипеи),
				'standard' => q(Стандардно време во Таипеи),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(Време во Таџикистан),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(Време во Токелау),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(Летно време во Тонга),
				'generic' => q(Време во Тонга),
				'standard' => q(Стандардно време во Тонга),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(Време во Чуук),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(Летно време во Туркменистан),
				'generic' => q(Време во Туркменистан),
				'standard' => q(Стандардно време во Туркменистан),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(Време во Тувалу),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(Летно сметање на времето во Уругвај),
				'generic' => q(Време во Уругвај),
				'standard' => q(Стандардно време во Уругвај),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(Летно време во Узбекистан),
				'generic' => q(Време во Узбекистан),
				'standard' => q(Стандардно време во Узбекистан),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(Летно време во Вануату),
				'generic' => q(Време во Вануату),
				'standard' => q(Стандардно време во Вануату),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(Време во Венецуела),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(Летно време во Владивосток),
				'generic' => q(Време во Владивосток),
				'standard' => q(Стандардно време во Владивосток),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(Летно сметање на времето во Волгоград),
				'generic' => q(Време во Волгоград),
				'standard' => q(Стандардно време во Волгоград),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(Време во Восток),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(Време на островот Вејк),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(Време во Валис и Футуна),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(Летно време во Јакутск),
				'generic' => q(Време во Јакутск),
				'standard' => q(Стандардно време во Јакутск),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(Летно време во Екатеринбург),
				'generic' => q(Време во Екатеринбург),
				'standard' => q(Стандардно време во Екатеринбург),
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
