=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Lo - Package for language Lao

=cut

package Locale::CLDR::Locales::Lo;
# This file auto generated from Data\common\main\lo.xml
#	on Mon  1 Jan 10:25:01 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.40.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
    is => 'ro',
    isa => ArrayRef,
    init_arg => undef,
    default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal','spellout-ordinal','digits-ordinal' ]},
);

has 'algorithmic_number_format_data' => (
    is => 'ro',
    isa => HashRef,
    init_arg => undef,
    default => sub {
        use bigfloat;
        return {
		'alt-ones' => {
			'private' => {
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(ເອັດ),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'digits-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(ที่−→#,##0→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ที่​=#,##0=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ที่​=#,##0=),
				},
			},
		},
		'spellout-cardinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(ลบ​→→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ศูนย์),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←←​จุด​→→→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(ໜຶ່ງ),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(ສອງ),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(ສາມ),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(ສີ່),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(ຫ້າ),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(ຫົກ),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(ເຈັດ),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(ແປດ),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(ເກົ້າ),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(ສິບ[​→%%alt-ones→]),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(ຊາວ[​→%%alt-ones→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(←←​ສິບ[​→%%alt-ones→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←←​ร้อย[​→→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←←​พัน[​→→]),
				},
				'10000' => {
					base_value => q(10000),
					divisor => q(10000),
					rule => q(←←​หมื่น[​→→]),
				},
				'100000' => {
					base_value => q(100000),
					divisor => q(100000),
					rule => q(←←​แสน[​→→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←←​ล้าน[​→→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
			},
		},
		'spellout-ordinal' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ที่​=%spellout-cardinal=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,##0.#=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=#,##0.#=),
				},
			},
		},
    } },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'ອະຟາ',
 				'ab' => 'ແອບຄາຊຽນ',
 				'ace' => 'ແອັກຊີເນັສ',
 				'ach' => 'ອາໂຄລີ',
 				'ada' => 'ອາແດງມີ',
 				'ady' => 'ເອດີຮິ',
 				'ae' => 'ອາເວັສແຕນ',
 				'af' => 'ອາຟຣິການ',
 				'afh' => 'ແອຟີຮີລີ',
 				'agq' => 'ອາເຮັມ',
 				'ain' => 'ໄອນູ',
 				'ak' => 'ອາການ',
 				'akk' => 'ອັກກາດຽມ',
 				'ale' => 'ອາເລີດ',
 				'alt' => 'ອານໄຕໃຕ້',
 				'am' => 'ອຳຮາຣິກ',
 				'an' => 'ອາຣາໂກເນັດ',
 				'ang' => 'ອັງກິດໂບຮານ',
 				'anp' => 'ແອນຈີກາ',
 				'ar' => 'ອາຣັບ',
 				'ar_001' => 'ອາຣາບິກມາດຕະຖານສະໄໝໃໝ່',
 				'arc' => 'ອາລາມິກ',
 				'arn' => 'ມາພຸດຊີ',
 				'arp' => 'ອາຣາປາໂຮ',
 				'arw' => 'ອາຣາແວກ',
 				'as' => 'ອັສຊາມີສ',
 				'asa' => 'ອາຊູ',
 				'ast' => 'ອັສຕູຮຽນ',
 				'av' => 'ອາວາຣິກ',
 				'awa' => 'ອາວາຮິ',
 				'ay' => 'ອາຍມາລາ',
 				'az' => 'ອາເຊີໄບຈານິ',
 				'az@alt=short' => 'ອາ​ເຊີ​ຣີ',
 				'ba' => 'ບາຣກີ',
 				'bal' => 'ບາລູຊີ',
 				'ban' => 'ບາລີເນັດ',
 				'bas' => 'ບາຊາ',
 				'bax' => 'ບາມຸນ',
 				'bbj' => 'ໂຄມາລາ',
 				'be' => 'ເບລາຣັສຊຽນ',
 				'bej' => 'ບີເຈ',
 				'bem' => 'ເບັມບາ',
 				'bez' => 'ບີນາ',
 				'bfd' => 'ບາຟັດ',
 				'bg' => 'ບັງກາຣຽນ',
 				'bgn' => 'ບາໂລຈີ ພາກຕາເວັນຕົກ',
 				'bho' => 'ໂບພູຣິ',
 				'bi' => 'ບິສລະມາ',
 				'bik' => 'ບີຄອນ',
 				'bin' => 'ບີນີ',
 				'bkm' => 'ກົມ',
 				'bla' => 'ຊິກຊິກາ',
 				'bm' => 'ບາມບາຣາ',
 				'bn' => 'ເບັງກາລີ',
 				'bo' => 'ທິເບທັນ',
 				'br' => 'ເບຣຕັນ',
 				'bra' => 'ບຣາ',
 				'brx' => 'ໂບດູ',
 				'bs' => 'ບອສນຽນ',
 				'bss' => 'ອາຄຸດ',
 				'bua' => 'ບູຣຽດ',
 				'bug' => 'ບູຈີເນັດ',
 				'bum' => 'ບູລູ',
 				'byn' => 'ບລິນ',
 				'byv' => 'ເມດູມບາ',
 				'ca' => 'ຄາຕາລານ',
 				'cad' => 'ແຄດໂດ',
 				'car' => 'ຄາຣິບ',
 				'cay' => 'ຄາຢູກາ',
 				'cch' => 'ອາດແຊມ',
 				'ccp' => 'Chakma',
 				'ce' => 'ຊີເຄນ',
 				'ceb' => 'ຊີບູໂນ',
 				'cgg' => 'ຊີກາ',
 				'ch' => 'ຊາມໍໂຣ',
 				'chb' => 'ຊິບຊາ',
 				'chg' => 'ຊາກາໄຕ',
 				'chk' => 'ຊູເກດ',
 				'chm' => 'ມາຣິ',
 				'chn' => 'ຊີນຸກຈາກອນ',
 				'cho' => 'ຊອກຕິວ',
 				'chp' => 'ຊີພິວຢານ',
 				'chr' => 'ຊີໂຣກີ',
 				'chy' => 'ຊີເຢນນີ',
 				'ckb' => 'ໂຊຣານິ ເຄີດິຊ',
 				'co' => 'ຄໍຊິກາ',
 				'cop' => 'ຄອບຕິກ',
 				'cr' => 'ຄີ',
 				'crh' => 'ຄຣີເມນເຕີຄິຊ',
 				'crs' => 'ເຊເຊວາ ໂຄຣດ ຝຣັ່ງ',
 				'cs' => 'ເຊກ',
 				'csb' => 'ກາຊູບຽນ',
 				'cu' => 'ໂບດສລາວິກ',
 				'cv' => 'ຊູວາຊ',
 				'cy' => 'ເວວ',
 				'da' => 'ແດນິຊ',
 				'dak' => 'ດາໂກຕາ',
 				'dar' => 'ດາກວາ',
 				'dav' => 'ໄຕຕາ',
 				'de' => 'ເຢຍລະມັນ',
 				'de_AT' => 'ເຢຍລະມັນ (ໂອສຕຣິດ)',
 				'de_CH' => 'ສະວິສ ໄຮ ເຈີແມນ',
 				'del' => 'ເດລາວາ',
 				'den' => 'ຊີເລັບ',
 				'dgr' => 'ໂດກຣິບ',
 				'din' => 'ດິນກາ',
 				'dje' => 'ຊາມາ',
 				'doi' => 'ດອກຣີ',
 				'dsb' => 'ຊໍບຽນຕໍ່ກວ່າ',
 				'dua' => 'ດົວລາ',
 				'dum' => 'ດັກກາງ',
 				'dv' => 'ດີວີຮີ',
 				'dyo' => 'ໂຈລາ-ຟອນຢີ',
 				'dyu' => 'ດູລາ',
 				'dz' => 'ດີຊອງຄາ',
 				'dzg' => 'ດາຊາກາ',
 				'ebu' => 'ເອັມບູ',
 				'ee' => 'ອິວາ',
 				'efi' => 'ອີຟິກ',
 				'egy' => 'ອີຢິບບູຮານ',
 				'eka' => 'ອີກາຈັກ',
 				'el' => 'ກຣີກ',
 				'elx' => 'ອີລາໄມ',
 				'en' => 'ອັງກິດ',
 				'en_AU' => 'ອັງກິດ (ໂອດສະຕາລີ)',
 				'en_CA' => 'ອັງກິດແຄນາດາ',
 				'en_GB' => 'ອັງກິດ (ບຣິດທິຊ)',
 				'en_GB@alt=short' => 'ອັງກິດ (ສະຫະລາດຊະອານາຈັກ)',
 				'en_US' => 'ອັງກິດ (ອາເມລິກັນ)',
 				'en_US@alt=short' => 'ອັງກິດ (ສະຫະລັດອາເມລິກາ)',
 				'enm' => 'ອັງກິດກາງ',
 				'eo' => 'ເອສປາຍ',
 				'es' => 'ສະແປນນິຊ',
 				'es_419' => 'ລາຕິນ ອາເມຣິກັນ ສະແປນນິຊ',
 				'es_ES' => 'ສະເປັນ ຢຸໂຣບ',
 				'es_MX' => 'ເມັກຊິກັນ ສະແປນນິຊ',
 				'et' => 'ເອສໂຕນຽນ',
 				'eu' => 'ບັສກີ',
 				'ewo' => 'ອີວອນດູ',
 				'fa' => 'ເປີຊຽນ',
 				'fa_AF' => 'ດາຣີ',
 				'fan' => 'ແຟງ',
 				'fat' => 'ແຟນຕີ',
 				'ff' => 'ຟູລາ',
 				'fi' => 'ຟິນນິຊ',
 				'fil' => 'ຟີລິປີໂນ',
 				'fj' => 'ຟິຈຽນ',
 				'fo' => 'ຟາໂຣສ',
 				'fon' => 'ຟອນ',
 				'fr' => 'ຝຣັ່ງ',
 				'fr_CA' => 'ຟລັງ(ການາດາ)',
 				'fr_CH' => 'ຝຣັ່ງ (ສວິສ)',
 				'frm' => 'ຟຮັ່ງເສດກາງ',
 				'fro' => 'ຟຮັ່ງເສດໂບຮານ',
 				'frr' => 'ຟຣີຊຽນເໜືອ',
 				'frs' => 'ຟຣີຊຽນຕາເວັນອອກ',
 				'fur' => 'ຟຣີລຽນ',
 				'fy' => 'ຟຣິຊຽນ ຕາເວັນຕົກ',
 				'ga' => 'ໄອຣິສ',
 				'gaa' => 'ກາ',
 				'gag' => 'ກາກາອຸຊ',
 				'gay' => 'ກາໂຢ',
 				'gba' => 'ບາຍາ',
 				'gd' => 'ສະກັອດເກລິກ',
 				'gez' => 'ກີ',
 				'gil' => 'ກິນເບີເທັດ',
 				'gl' => 'ກາລິຊຽນ',
 				'gmh' => 'ເຢຍລະມັນສູງກາງ',
 				'gn' => 'ກົວຣານີ',
 				'goh' => 'ເຢຍລະມັນສູງໂບຮານ',
 				'gon' => 'ກອນດີ',
 				'gor' => 'ໂກຣອນຕາໂຣ',
 				'got' => 'ກອດຮິກ',
 				'grb' => 'ກຣີໂບ',
 				'grc' => 'ແອນຊຽນກຣີກ',
 				'gsw' => 'ສະວິສ ເຈີແມນ',
 				'gu' => 'ກູຈາຣາຕິ',
 				'guz' => 'ກູຊິ',
 				'gv' => 'ແມງຊ໌',
 				'gwi' => 'ວິດອິນ',
 				'ha' => 'ເຮົາຊາ',
 				'hai' => 'ໄຮດາ',
 				'haw' => 'ຮາໄວອຽນ',
 				'he' => 'ຮີບຣິວ',
 				'hi' => 'ຮິນດິ',
 				'hil' => 'ຮິຣິໄກນອນ',
 				'hit' => 'ຮິດໄຕ',
 				'hmn' => 'ມອງ',
 				'ho' => 'ຮິຣິໂມຕູ',
 				'hr' => 'ໂຄຣເອທຽນ',
 				'hsb' => 'ຊໍບຽນ ທາງຕອນເໜືອ',
 				'ht' => 'ໄຮຕຽນ',
 				'hu' => 'ຮັງກາຣຽນ',
 				'hup' => 'ຮູປາ',
 				'hy' => 'ອາເມນຽນ',
 				'hz' => 'ເຮິຮິໂຣ',
 				'ia' => 'ອິນເຕີລິງລົວ',
 				'iba' => 'ໄອບານ',
 				'ibb' => 'ໄອໄບໄບໂອ',
 				'id' => 'ອິນໂດເນຊຽນ',
 				'ie' => 'ອິນເຕີລິງກຣີ',
 				'ig' => 'ອິກໂບ',
 				'ii' => 'ເສສວນ ອີ',
 				'ik' => 'ອິນນູປຽກ',
 				'ilo' => 'ໄອໂລໂກ',
 				'inh' => 'ອິນກັຊ',
 				'io' => 'ອີໂດ',
 				'is' => 'ໄອສແລນດິກ',
 				'it' => 'ອິຕາລຽນ',
 				'iu' => 'ອິນນຸກຕິຕັດ',
 				'ja' => 'ຍີ່ປຸ່ນ',
 				'jbo' => 'ໂລບບັນ',
 				'jgo' => 'ງອມບາ',
 				'jmc' => 'ມາແຊມ',
 				'jpr' => 'ຈູແດວ-ເພີຊຽນ',
 				'jrb' => 'ຈູແດວ-ອາລາບິກ',
 				'jv' => 'ຈາແວນີສ',
 				'ka' => 'ຈໍຈຽນ',
 				'kaa' => 'ກາຣາ-ການປາກ',
 				'kab' => 'ກາໄບລ໌',
 				'kac' => 'ກາຊິນ',
 				'kaj' => 'ຈຣູ',
 				'kam' => 'ກາມບາ',
 				'kaw' => 'ກະວີ',
 				'kbd' => 'ກາບາດຽນ',
 				'kbl' => 'ຄາແນມບູ',
 				'kcg' => 'ຕີບ',
 				'kde' => 'ມາຄອນເດ',
 				'kea' => 'ຄາເວີເດຍນູ',
 				'kfo' => 'ໂຄໂລ',
 				'kg' => 'ຄອງໂກ',
 				'kha' => 'ຄາສິ',
 				'kho' => 'ໂຄຕັນ',
 				'khq' => 'ຄອຍຣາ ຊິນີ',
 				'ki' => 'ຄິຄູຢຸ',
 				'kj' => 'ກວນຍາມາ',
 				'kk' => 'ຄາຊັກ',
 				'kkj' => 'ຄາໂກ',
 				'kl' => 'ກຣີນແລນລິດ',
 				'kln' => 'ຄາເລັນຈິນ',
 				'km' => 'ຂະເໝນ',
 				'kmb' => 'ຄິມບັນດູ',
 				'kn' => 'ຄັນນາດາ',
 				'ko' => 'ເກົາຫລີ',
 				'koi' => 'ໂຄມີ-ເພີມຢັກ',
 				'kok' => 'ກອນການີ',
 				'kos' => 'ຄູສໄລ',
 				'kpe' => 'ກາແປຣ',
 				'kr' => 'ຄານຸລິ',
 				'krc' => 'ກາຣາໄຊ-ບານກາ',
 				'krl' => 'ກາເຣລຽນ',
 				'kru' => 'ກູຣູກ',
 				'ks' => 'ຄາສເມຍຣິ',
 				'ksb' => 'ຊຳບາລ້າ',
 				'ksf' => 'ບາເຟຍ',
 				'ksh' => 'ໂຄລອກນຽນ',
 				'ku' => 'ເຄີດິສ',
 				'kum' => 'ຄູມີກ',
 				'kut' => 'ຄູເທໄນ',
 				'kv' => 'ໂຄມິ',
 				'kw' => 'ຄໍນິຊ',
 				'ky' => 'ເກຍກີສ',
 				'la' => 'ລາຕິນ',
 				'lad' => 'ລາດີໂນ',
 				'lag' => 'ແລນກິ',
 				'lah' => 'ລານດາ',
 				'lam' => 'ແລມບາ',
 				'lb' => 'ລັກເຊມບວກກິຊ',
 				'lez' => 'ລີຊຽນ',
 				'lg' => 'ແກນດາ',
 				'li' => 'ລິມເບີກີຊ',
 				'lkt' => 'ລາໂກຕາ',
 				'ln' => 'ລິງກາລາ',
 				'lo' => 'ລາວ',
 				'lol' => 'ແມັງໂກ້',
 				'loz' => 'ໂລຊິ',
 				'lrc' => 'ລູຣິ ທາງຕອນເໜືອ',
 				'lt' => 'ລິທົວນຽນ',
 				'lu' => 'ລູບາ-ຄາຕັງກາ',
 				'lua' => 'ລູບາ-ລູລົວ',
 				'lui' => 'ລູເຊໂນ',
 				'lun' => 'ລຸນດາ',
 				'luo' => 'ລົວ',
 				'lus' => 'ລູໄຊ',
 				'luy' => 'ລູໄຍ',
 				'lv' => 'ລັດວຽນ',
 				'mad' => 'ມາດູລາ',
 				'maf' => 'ມາຟາ',
 				'mag' => 'ມາກາຮິ',
 				'mai' => 'ໄມທີລິ',
 				'mak' => 'ມາກາຊາຣ',
 				'man' => 'ມັນດິງກາ',
 				'mas' => 'ມາໄຊ',
 				'mde' => 'ມາບາ',
 				'mdf' => 'ມອກຊາ',
 				'mdr' => 'ມານດາຣ',
 				'men' => 'ເມນເດ',
 				'mer' => 'ເມຣູ',
 				'mfe' => 'ມໍຣິສເຢນ',
 				'mg' => 'ມາລາກາສຊີ',
 				'mga' => 'ໄອລິດກາງ',
 				'mgh' => 'ມາຄູວາ-ມີດໂຕ',
 				'mgo' => 'ເມທາ',
 				'mh' => 'ມາຊານເລັດ',
 				'mi' => 'ມາວຣິ',
 				'mic' => 'ມິກແມກ',
 				'min' => 'ທີແນງກາບູ',
 				'mk' => 'ແມຊິໂດນຽນ',
 				'ml' => 'ມາເລອາລຳ',
 				'mn' => 'ມອງໂກເລຍ',
 				'mnc' => 'ແມນຈູ',
 				'mni' => 'ມານີພູຣິ',
 				'moh' => 'ໂມຫາ',
 				'mos' => 'ມອສຊີ',
 				'mr' => 'ມາຣາທີ',
 				'ms' => 'ມາເລ',
 				'mt' => 'ມອລທີສ',
 				'mua' => 'ມັນດັງ',
 				'mul' => 'ຫລາຍພາສາ',
 				'mus' => 'ຄຣິກ',
 				'mwl' => 'ມີລັນດາ',
 				'mwr' => 'ມາວາຣິ',
 				'my' => 'ມຽນມາ',
 				'mye' => 'ມໍຢິນ',
 				'myv' => 'ເອີຍາ',
 				'mzn' => 'ມາແຊນເດີລັງ',
 				'na' => 'ນາຢູລູ',
 				'nap' => 'ນາໂປລີ',
 				'naq' => 'ນາມາ',
 				'nb' => 'ນໍເວຈຽນ ບັອກມອລ',
 				'nd' => 'ເອັນເດເບເລເໜືອ',
 				'nds' => 'ເຢຍລະມັນ ຕອນໄຕ້',
 				'nds_NL' => 'ຊາຊອນ ຕອນໄຕ',
 				'ne' => 'ເນປາລີ',
 				'new' => 'ນີວາຣິ',
 				'ng' => 'ເອັນດອງກາ',
 				'nia' => 'ນີ່ອັດ',
 				'niu' => 'ນີ່ອູ',
 				'nl' => 'ດັຊ',
 				'nl_BE' => 'ຟລີມິຊ',
 				'nmg' => 'ກວາຊີໂອ',
 				'nn' => 'ນໍເວຈຽນ ນີນອກ',
 				'nnh' => 'ຈີ່ມບູນ',
 				'no' => 'ນໍເວຍ',
 				'nog' => 'ນໍໄກ',
 				'non' => 'ນໍໂບຮານ',
 				'nqo' => 'ເອັນໂກ',
 				'nr' => 'ນີບີລີໃຕ້',
 				'nso' => 'ໂຊໂທເໜືອ',
 				'nus' => 'ເນີ',
 				'nv' => 'ນາວາໂຈ',
 				'nwc' => 'ເນວາດັ້ງເດີມ',
 				'ny' => 'ນານຈາ',
 				'nym' => 'ນາມວີຊິ',
 				'nyn' => 'ນານຄອນ',
 				'nyo' => 'ໂນໂຣ',
 				'nzi' => 'ນິມາ',
 				'oc' => 'ອັອກຊີຕານ',
 				'oj' => 'ໂອຈິບວາ',
 				'om' => 'ໂອໂຣໂມ',
 				'or' => 'ໂອຣິຢາ',
 				'os' => 'ອອດເຊຕິກ',
 				'osa' => 'ໂອແຊກ',
 				'ota' => 'ຕູກີອອດໂຕມັນ',
 				'pa' => 'ປັນຈາບີ',
 				'pag' => 'ປານກາຊີມານ',
 				'pal' => 'ພາລາວີ',
 				'pam' => 'ປາມປານກາ',
 				'pap' => 'ປາມເປຍເມັນໂທ',
 				'pau' => 'ປາລົວອານ',
 				'pcm' => 'ໄນຈີຣຽນພິດກິນ',
 				'peo' => 'ເປີເຊຍໂບຮານ',
 				'phn' => 'ຟີນີເຊຍ',
 				'pi' => 'ປາລີ',
 				'pl' => 'ໂປລິຊ',
 				'pon' => 'ພອນເພ',
 				'prg' => 'ປຣັສຊຽນ',
 				'pro' => 'ໂປວອງຊານໂບຮານ',
 				'ps' => 'ປາສໂຕ',
 				'pt' => 'ປອກຕຸຍກິສ',
 				'pt_BR' => 'ປອກຕຸຍກິສ ບະເລຊີ່ນ',
 				'pt_PT' => 'ປອກຕຸຍກິສ ຢຸໂຣບ',
 				'qu' => 'ຄີຊົວ',
 				'quc' => 'Kʼicheʼ',
 				'raj' => 'ຣາຈັສທານິ',
 				'rap' => 'ຣາປານຸຍ',
 				'rar' => 'ຣາໂຣທອນການ',
 				'rhg' => 'ໂຣຮິນຢາ',
 				'rm' => 'ໂຣແມນຊ໌',
 				'rn' => 'ຣຸນດິ',
 				'ro' => 'ໂຣແມນຽນ',
 				'ro_MD' => 'ໂມດາວຽນ',
 				'rof' => 'ຣົມໂບ',
 				'rom' => 'ໂຣເມນີ',
 				'ru' => 'ລັດເຊຍ',
 				'rup' => 'ອາໂຣມານຽນ',
 				'rw' => 'ຄິນຢາວານດາ',
 				'rwk' => 'ອາຣວາ',
 				'sa' => 'ສັນສະກຣິດ',
 				'sad' => 'ຊັນດາວ',
 				'sah' => 'ຊາກາ',
 				'sam' => 'ສາມາຣິແຕນ-',
 				'saq' => 'ຊຳບູຣູ',
 				'sas' => 'ຊາຊັກ',
 				'sat' => 'ຊານທາລິ',
 				'sba' => 'ກຳເບ',
 				'sbp' => 'ຊານກູ',
 				'sc' => 'ສາດີນຽນ',
 				'scn' => 'ຊີຊິລີນ',
 				'sco' => 'ສກອດ',
 				'sd' => 'ສິນທິ',
 				'sdh' => 'ພາກໄຕ້ ຂອງ ກູດິດ',
 				'se' => 'ຊາມິເໜືອ',
 				'see' => 'ຊີນີກາ',
 				'seh' => 'ຊີນາ',
 				'sel' => 'ເຊນຄັບ',
 				'ses' => 'ໂຄຍຣາໂບໂຣ ເຊນນິ',
 				'sg' => 'ແຊງໂກ',
 				'sga' => 'ອີຣິຊເກົ່າ',
 				'sh' => 'ເຊີໂບ-ໂກເຊຍ',
 				'shi' => 'ທາເຊວຫິດ',
 				'shn' => 'ຊານ',
 				'shu' => 'ອາລັບ-ຊາດ',
 				'si' => 'ສິນຫາລາ',
 				'sid' => 'ຊິດາໂມ',
 				'sk' => 'ສະໂລແວັກ',
 				'sl' => 'ສະໂລເວນຽນ',
 				'sm' => 'ຊາມົວ',
 				'sma' => 'ຊາມິໃຕ້',
 				'smj' => 'ລຸນຊາມິ',
 				'smn' => 'ອີນາຣິຊາມິ',
 				'sms' => 'ສກອດຊາມິ',
 				'sn' => 'ໂຊນາ',
 				'snk' => 'ໂຊນິນກີ',
 				'so' => 'ໂຊມາລີ',
 				'sog' => 'ຊອກດິນ',
 				'sq' => 'ອານບານຽນ',
 				'sr' => 'ເຊີບຽນ',
 				'srn' => 'ສຣານນານຕອນໂກ',
 				'srr' => 'ເຊເລີ',
 				'ss' => 'ຊຣາຕິ',
 				'ssy' => 'ຊາໂຮ',
 				'st' => 'ໂຊໂທໃຕ້',
 				'su' => 'ຊຸນແດນນີສ',
 				'suk' => 'ຊູຄູມ້າ',
 				'sus' => 'ຊູຊູ',
 				'sux' => 'ຊູເມີເລຍ',
 				'sv' => 'ສະວີດິຊ',
 				'sw' => 'ຊວາຮີລິ',
 				'sw_CD' => 'ຄອງໂກ ຊວາຮີລິ',
 				'swb' => 'ໂຄໂນຣຽນ',
 				'syc' => 'ຊີເລຍແບບດັ້ງເດີມ',
 				'syr' => 'ຊີເລຍ',
 				'ta' => 'ທາມິລ',
 				'te' => 'ເຕລູກູ',
 				'tem' => 'ທີມເນ',
 				'teo' => 'ເຕໂຊ',
 				'ter' => 'ເຕເລໂນ',
 				'tet' => 'ເຕຕູມ',
 				'tg' => 'ທາຈິກ',
 				'th' => 'ໄທ',
 				'ti' => 'ຕິກຣິນຢາ',
 				'tig' => 'ໄທກຣີ',
 				'tiv' => 'ຕີວ',
 				'tk' => 'ເທີກເມັນ',
 				'tkl' => 'ໂຕເກເລົາ',
 				'tl' => 'ຕາກາລອກ',
 				'tlh' => 'ຄຣິງກອນ',
 				'tli' => 'ທລີງກິດ',
 				'tmh' => 'ທາມາກເຊກ',
 				'tn' => 'ເຕສະວານາ',
 				'to' => 'ທອງການ',
 				'tog' => 'ນາຍອາຊາຕອງກາ',
 				'tpi' => 'ທອກພີຊິນ',
 				'tr' => 'ເທີຄິຊ',
 				'trv' => 'ຕາໂລໂກ',
 				'ts' => 'ເຕຊອງກາ',
 				'tsi' => 'ຊີມຊີແອນ',
 				'tt' => 'ທາທາ',
 				'tum' => 'ຕຳບູກາ',
 				'tvl' => 'ຕູວາລູ',
 				'tw' => 'ທວີ',
 				'twq' => 'ຕາຊາວັກ',
 				'ty' => 'ຕາຮີຕຽນ',
 				'tyv' => 'ຕູວີນຽນ',
 				'tzm' => 'ອັດລາສ ທາມາຊີກ ກາງ',
 				'udm' => 'ອຸດມັດ',
 				'ug' => 'ອຸຍເຄີ',
 				'uga' => 'ຢູກາລິກ',
 				'uk' => 'ຢູເຄຣນຽນ',
 				'umb' => 'ອຳບັນດູ',
 				'und' => 'ບໍ່ສາມາດລະບຸພາສາ',
 				'ur' => 'ອູຣດູ',
 				'uz' => 'ອຸສເບກ',
 				'vai' => 'ໄວ',
 				've' => 'ເວນດາ',
 				'vi' => 'ຫວຽດນາມ',
 				'vo' => 'ໂວລາພັກ',
 				'vot' => 'ໂວຕິກ',
 				'vun' => 'ວັນໂຈ',
 				'wa' => 'ວໍລູມ',
 				'wae' => 'ວາເຊີ',
 				'wal' => 'ວາລາໂມ',
 				'war' => 'ວາເລ',
 				'was' => 'ວາໂຊ',
 				'wbp' => 'ວາຣພິຣິ',
 				'wo' => 'ວໍລອບ',
 				'xal' => 'ການມິກ',
 				'xh' => 'ໂຮຊາ',
 				'xog' => 'ໂຊກາ',
 				'yao' => 'ເຢົ້າ',
 				'yap' => 'ຢັບ',
 				'yav' => 'ແຍງເບນ',
 				'ybb' => 'ແຢມບາ',
 				'yi' => 'ຢິວ',
 				'yo' => 'ໂຢຣູບາ',
 				'yue' => 'ກວາງຕຸ້ງ',
 				'yue@alt=menu' => 'ພາສາຈີນ, ຈີກວາງຕຸ້ງ',
 				'za' => 'ຊວາງ',
 				'zap' => 'ຊາໂປແຕບ',
 				'zbl' => 'ສັນຍາລັກບລີຊິມ',
 				'zen' => 'ເຊນາກາ',
 				'zgh' => 'ໂມຣັອກແຄນ ທາມາຊີກ ມາດຕະຖານ',
 				'zh' => 'ຈີນ',
 				'zh@alt=menu' => 'ພາສາຈີນ, ພາສາຈີນກາງ',
 				'zh_Hans' => 'ຈີນແບບຮຽບງ່າຍ',
 				'zh_Hans@alt=long' => 'ພາສາຈີນກາງ',
 				'zh_Hant' => 'ຈີນແບບດັ້ງເດີມ',
 				'zh_Hant@alt=long' => 'ພາສາຈີນແມນດາຣິນດັ້ງເດີມ',
 				'zu' => 'ຊູລູ',
 				'zun' => 'ຊູນີ',
 				'zxx' => 'ບໍ່ມີເນື້ອຫາພາສາ',
 				'zza' => 'ຊາຊາ',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Afak' => 'ອັບຟາກາ',
 			'Arab' => 'ອາຣາບິກ',
 			'Armi' => 'ອິມພີຮຽນ ອາເມອິກ',
 			'Armn' => 'ອາເມນຽນ',
 			'Avst' => 'ອະເວສຕະ',
 			'Bali' => 'ບາລີ',
 			'Bamu' => 'ບາມູມ',
 			'Bass' => 'ບັດຊາ',
 			'Batk' => 'ບາຕັກ',
 			'Beng' => 'ເບັງກາ',
 			'Blis' => 'ບລິກຊິມໂບລສ',
 			'Bopo' => 'ຈູ້ອິນ',
 			'Brah' => 'ພຮາຫມີ',
 			'Brai' => 'ເບຣວ',
 			'Bugi' => 'ບູກິສ',
 			'Buhd' => 'ບູຮິດ',
 			'Cakm' => 'ຊາກມາ',
 			'Cans' => 'ສັນຍາລັກຊົນເຜົ່າພື້ນເມືອງແຄນນາດາ',
 			'Cari' => 'ຄາເຮຍ',
 			'Cham' => 'ຈາມ',
 			'Cher' => 'ເຊໂຮກີ',
 			'Cirt' => 'ເຊີຮ',
 			'Copt' => 'ຄອບຕິກ',
 			'Cprt' => 'ໄຊເປຍ',
 			'Cyrl' => 'ຊີຣິວລິກ',
 			'Cyrs' => 'ເຊຮັດສລາ ໂວນິກຊີຮິກລິກໂບຮານ',
 			'Deva' => 'ດີວານາກາຣີ',
 			'Dsrt' => 'ເດເຊເຮ',
 			'Dupl' => 'ຊົວເລດັບໂລຍັນ',
 			'Egyd' => 'ດີໂມຕິກອີຍິບ',
 			'Egyh' => 'ເຮຍຮາຕິກອີຍິບ',
 			'Egyp' => 'ເຮຍໂຮກລິຟອີຍິບ',
 			'Ethi' => 'ອີທິໂອປິກ',
 			'Geok' => 'ຄອດຊູຮີຈໍເຈຍ',
 			'Geor' => 'ຈໍຈຽນ',
 			'Glag' => 'ກລາໂກລິຕິກ',
 			'Goth' => 'ໂກຮິກ',
 			'Gran' => 'ເຄນທາ',
 			'Grek' => 'ກຣີກ',
 			'Gujr' => 'ຈູຈາຣາທີ',
 			'Guru' => 'ກົວມູຄີ',
 			'Hanb' => 'ຮັນ',
 			'Hang' => 'ຮັນກູນ',
 			'Hani' => 'ຮານ',
 			'Hano' => 'ຮານູໂນໂອ',
 			'Hans' => 'ແບບຮຽບງ່າຍ',
 			'Hans@alt=stand-alone' => 'ຈີນ (ແບບງ່າຍ)',
 			'Hant' => 'ແບບດັ້ງເດີມ',
 			'Hant@alt=stand-alone' => 'ຈີນ (ດັ້ງເດີມ)',
 			'Hebr' => 'ຮີບຣິວ',
 			'Hira' => 'ຣິຣະງະນະ',
 			'Hluw' => 'ອັກລຮະອານາໂຕເລຍ',
 			'Hmng' => 'ປາເຮາເມັງ',
 			'Hrkt' => 'ຕາຕາລາງພະຍາງພາສາຍີ່ປຸ່ນ',
 			'Hung' => 'ຮັງກາຮີໂບຮານ',
 			'Inds' => 'ອິນດັດ',
 			'Ital' => 'ອີຕາລີໂບຮານ',
 			'Jamo' => 'ຈາໂມ',
 			'Java' => 'ຈາວາ',
 			'Jpan' => 'ຍີ່ປຸ່ນ',
 			'Jurc' => 'ຈູຮເຊັນ',
 			'Kali' => 'ຄຍາ',
 			'Kana' => 'ຄະຕະກະນະ',
 			'Khar' => 'ຂໍໂຮກສີ',
 			'Khmr' => 'ຂະແມ',
 			'Khoj' => 'ຄໍຈຄີ',
 			'Knda' => 'ຄັນນາດາ',
 			'Kore' => 'ເກົາຫຼີ',
 			'Kpel' => 'ເປລເລ',
 			'Kthi' => 'ກາຍຕິ',
 			'Lana' => 'ລ້ານນາ',
 			'Laoo' => 'ລາວ',
 			'Latf' => 'ລາຕິນ-ຟຮັ່ງເຕຣ',
 			'Latg' => 'ລາຕິນ-ແກລິກ',
 			'Latn' => 'ລາຕິນ',
 			'Lepc' => 'ເລຊາ',
 			'Limb' => 'ລິມບູ',
 			'Lina' => 'ລີເນຍ',
 			'Linb' => 'ລີເນຍຣ',
 			'Lisu' => 'ເຟຣເຊຮ',
 			'Loma' => 'ໂລມາ',
 			'Lyci' => 'ໄລເຊຍ',
 			'Lydi' => 'ລີເດຍ',
 			'Mand' => 'ແມນດຽນ',
 			'Mani' => 'ມານິແຊນ',
 			'Maya' => 'ມາຍາໄຮໂຮກລິບ',
 			'Mend' => 'ເມນເດ',
 			'Merc' => 'ເຄເລີຊີເມໂຮອິຕິກ',
 			'Mero' => 'ເມໂຮຕິກ',
 			'Mlym' => 'ມາເລຢາລາມ',
 			'Mong' => 'ມົງໂກນ',
 			'Moon' => 'ມູນ',
 			'Mroo' => 'ເມໂຮ',
 			'Mtei' => 'ເມເທມາເຍກ',
 			'Mymr' => 'ມຽນມາ',
 			'Narb' => 'ອາຮະເບຍເໜືອໂບຮານ',
 			'Nbat' => 'ນາບາທາທຽນ',
 			'Nkgb' => 'ກີບາ-ນາຊີ',
 			'Nkoo' => 'ເອັນໂກ',
 			'Nshu' => 'ນຸຊຸ',
 			'Ogam' => 'ອອກຄອນ',
 			'Olck' => 'ໂອຊິກິ',
 			'Orkh' => 'ອອກສມັນຍາ',
 			'Orya' => 'ໂອເດຍ',
 			'Palm' => 'ພາລໄມຮິນ',
 			'Perm' => 'ເພີມີໂບຮານ',
 			'Phag' => 'ຟາກສ-ປາ',
 			'Phli' => 'ປະຫລາວີອິນສຄິບຊັນແນລ',
 			'Phlp' => 'ປະຫລາວີຊອດເຕຮ໌',
 			'Phlv' => 'ປະຫລາວີບຸກ',
 			'Phnx' => 'ຟີນິເຊຍ',
 			'Plrd' => 'ສັດຕະສາດພໍຮລາ',
 			'Prti' => 'ພາຮ໌ເທຍອິນສຄຮິປຊັນແນລ',
 			'Rjng' => 'ເຮຈັງ',
 			'Roro' => 'ຮອງໂກຮອງໂກ',
 			'Runr' => 'ຮູນິກ',
 			'Samr' => 'ຊາມາເລຍ',
 			'Sara' => 'ຊາຮາຕິ',
 			'Sarb' => 'ອາລະເບຍໃຕ້ໂບຮານ',
 			'Saur' => 'ໂສຮັດຕຣະ',
 			'Sgnw' => 'ໄຊນ໌ໄຮຕີ້ງ',
 			'Shaw' => 'ຊອວຽນ',
 			'Shrd' => 'ຊາຮາດາ',
 			'Sind' => 'ດຸດາວາດີ',
 			'Sinh' => 'ສິນຫາລາ',
 			'Sora' => 'ໂສຮາສົມເປັງ',
 			'Sund' => 'ຊຸນດາ',
 			'Sylo' => 'ຊີໂລຕິນາກຣີ',
 			'Syrc' => 'ຊີເຮຍ',
 			'Syre' => 'ຊີເຮຍເອສທຮານຈີໂລ',
 			'Syrj' => 'ຊີເຮຍຕາເວັນຕົກ',
 			'Syrn' => 'ຊີເຮຍຕາເວັນອອກ',
 			'Tagb' => 'ຕັກບັນວາ',
 			'Takr' => 'ທາຄຮີ',
 			'Tale' => 'ໄທເລ',
 			'Talu' => 'ໄທລື້ໃໝ່',
 			'Taml' => 'ທາມິລ',
 			'Tang' => 'ຕັນກັນ',
 			'Tavt' => 'ໄທຫວຽດ',
 			'Telu' => 'ເທລູກູ',
 			'Teng' => 'ເທງກວາຮ',
 			'Tfng' => 'ທີຟີນາກ',
 			'Tglg' => 'ຕາກາລອກ',
 			'Thaa' => 'ທານາ',
 			'Thai' => 'ໄທ',
 			'Tibt' => 'ທິເບທັນ',
 			'Tirh' => 'ເທຮຸທາ',
 			'Ugar' => 'ຍູກາຮິດ',
 			'Vaii' => 'ໄວ',
 			'Visp' => 'ຄຳເວົ້າທີ່ເບີ່ງເຫັນໄດ້',
 			'Wara' => 'ວາຮັງກສິຕິ',
 			'Wole' => 'ໂອລີເອ',
 			'Xpeo' => 'ເປຮເຊຍໂບຮານ',
 			'Xsux' => 'ອັກສອນຮູບປລີ່ມສຸເມເຮຍ-ອັດຄາເດຍ',
 			'Yiii' => 'ຍີ',
 			'Zinh' => 'ອິນເຮຮິດ',
 			'Zmth' => 'ເຄື່ອງໝາຍທາງຄະນິດສາດ',
 			'Zsye' => 'ອີໂມຈິ',
 			'Zsym' => 'ສັນຍາລັກ',
 			'Zxxx' => 'ບໍ່ມີພາສາຂຽນ',
 			'Zyyy' => 'ສາມັນ',
 			'Zzzz' => 'ແບບຂຽນທີ່ບໍ່ຮູ້ຈັກ',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'ໂລກ',
 			'002' => 'ອາຟຣິກາ',
 			'003' => 'ອາເມລິກາເໜືອ',
 			'005' => 'ອາເມລິກາໃຕ້',
 			'009' => 'ໂອຊີອານີ',
 			'011' => 'ອາຟຣິກາຕາເວັນຕົກ',
 			'013' => 'ອາເມລິກາກາງ',
 			'014' => 'ອາຟຣິກາຕາເວັນອອກ',
 			'015' => 'ອາຟຣິກາເໜືອ',
 			'017' => 'ອາຟຣິກາກາງ',
 			'018' => 'ອາຟຣິກາຕອນໃຕ້',
 			'019' => 'ອາເມຣິກາ',
 			'021' => 'ພາກເໜືອອາເມລີກາ',
 			'029' => 'ຄາຣິບບຽນ',
 			'030' => 'ອາຊີຕາເວັນອອກ',
 			'034' => 'ອາຊີໄຕ້',
 			'035' => 'ອາຊີຕາເວັນອອກສ່ຽງໄຕ້',
 			'039' => 'ຢູໂຣບໃຕ້',
 			'053' => 'ໂອດສະຕາລີ',
 			'054' => 'ເມລານີເຊຍ',
 			'057' => 'ເຂດໄມໂຄຣເນຊຽນ',
 			'061' => 'ໂພລີນີເຊຍ',
 			'142' => 'ອາຊີ',
 			'143' => 'ອາຊີກາງ',
 			'145' => 'ອາຊີຕາເວັນຕົກ',
 			'150' => 'ຢູໂຣບ',
 			'151' => 'ຢູໂຣບຕາເວັນອອກ',
 			'154' => 'ຢູໂຣບເໜືອ',
 			'155' => 'ຢູໂຣບຕາເວັນຕົກ',
 			'202' => 'ຊັບ ຊາຮາຣານ ອາຟຣິກາ',
 			'419' => 'ລາຕິນ ອາເມລິກາ',
 			'AC' => 'ເກາະອາເຊນຊັນ',
 			'AD' => 'ອັນດໍຣາ',
 			'AE' => 'ສະຫະລັດອາຣັບເອມິເຣດ',
 			'AF' => 'ອາຟການິດສະຖານ',
 			'AG' => 'ແອນທິກົວ ແລະ ບາບູດາ',
 			'AI' => 'ແອນກຸຍລາ',
 			'AL' => 'ແອວເບເນຍ',
 			'AM' => 'ອາເມເນຍ',
 			'AO' => 'ແອງໂກລາ',
 			'AQ' => 'ແອນຕາດຕິກາ',
 			'AR' => 'ອາເຈນທິນາ',
 			'AS' => 'ອາເມຣິກາ ຊາມົວ',
 			'AT' => 'ອອສເທຣຍ',
 			'AU' => 'ອອສເຕຣເລຍ',
 			'AW' => 'ອາຣູບາ',
 			'AX' => 'ຫມູ່ເກາະໂອລັນ',
 			'AZ' => 'ອາເຊີໄບຈານ',
 			'BA' => 'ບອດສະເນຍ ແລະ ແຮສໂກວີນາ',
 			'BB' => 'ບາບາໂດສ',
 			'BD' => 'ບັງກະລາເທດ',
 			'BE' => 'ເບວຢຽມ',
 			'BF' => 'ເບີກິນາ ຟາໂຊ',
 			'BG' => 'ບັງກາເຣຍ',
 			'BH' => 'ບາເຣນ',
 			'BI' => 'ບູຣຸນດິ',
 			'BJ' => 'ເບນິນ',
 			'BL' => 'ເຊນ ບາເທເລມີ',
 			'BM' => 'ເບີມິວດາ',
 			'BN' => 'ບຣູໄນ',
 			'BO' => 'ໂບລິເວຍ',
 			'BQ' => 'ຄາຣິບບຽນ ເນເທີແລນ',
 			'BR' => 'ບຣາຊິວ',
 			'BS' => 'ບາຮາມາສ',
 			'BT' => 'ພູຖານ',
 			'BV' => 'ເກາະບູເວດ',
 			'BW' => 'ບອດສະວານາ',
 			'BY' => 'ເບລາຣຸສ',
 			'BZ' => 'ເບລີຊ',
 			'CA' => 'ແຄນາດາ',
 			'CC' => 'ຫມູ່ເກາະໂກໂກສ',
 			'CD' => 'ຄອງໂກ - ຄິນຊາຊາ',
 			'CD@alt=variant' => 'ຄອງໂກ (ສາທາລະນະລັດປະຊາທິປະໄຕ)',
 			'CF' => 'ສາທາລະນະລັດອາຟຣິກາກາງ',
 			'CG' => 'ຄອງໂກ - ບຣາຊາວິວ',
 			'CG@alt=variant' => 'ສາທາລະນະລັດຄອງໂກ',
 			'CH' => 'ສະວິດເຊີແລນ',
 			'CI' => 'ໂຄຕີ ວົວ',
 			'CI@alt=variant' => 'ໄອໂວຣີ ໂຄທ',
 			'CK' => 'ໝູ່ເກາະຄຸກ',
 			'CL' => 'ຊິລີ',
 			'CM' => 'ຄາເມຣູນ',
 			'CN' => 'ຈີນ',
 			'CO' => 'ໂຄລົມເບຍ',
 			'CP' => 'ເກາະຄລິບເປີຕັນ',
 			'CR' => 'ໂຄສຕາ ຣິກາ',
 			'CU' => 'ຄິວບາ',
 			'CV' => 'ເຄບ ເວີດ',
 			'CW' => 'ຄູຣາຊາວ',
 			'CX' => 'ເກາະຄຣິສມາດ',
 			'CY' => 'ໄຊປຣັສ',
 			'CZ' => 'ເຊັກເຊຍ',
 			'CZ@alt=variant' => 'ສາທາລະນະລັດເຊັກ',
 			'DE' => 'ເຢຍລະມັນ',
 			'DG' => 'ດິເອໂກ ກາເຊຍ',
 			'DJ' => 'ຈິບູຕິ',
 			'DK' => 'ເດນມາກ',
 			'DM' => 'ໂດມີນິຄາ',
 			'DO' => 'ສາທາລະນະລັດ ໂດມິນິກັນ',
 			'DZ' => 'ອັລຈິເຣຍ',
 			'EA' => 'ເຊວຕາ & ເມລິນລາ',
 			'EC' => 'ເອກວາດໍ',
 			'EE' => 'ເອສໂຕເນຍ',
 			'EG' => 'ອີຢິບ',
 			'EH' => 'ຊາຮາຣາຕາເວັນຕົກ',
 			'ER' => 'ເອຣິເທຣຍ',
 			'ES' => 'ສະເປນ',
 			'ET' => 'ອີທິໂອເປຍ',
 			'EU' => 'ສະຫະພາບຢູໂຣບ',
 			'EZ' => 'ເຂດຢູໂຣບ',
 			'FI' => 'ຟິນແລນ',
 			'FJ' => 'ຟິຈິ',
 			'FK' => 'ຫມູ່ເກາະຟອກແລນ',
 			'FK@alt=variant' => 'ໝູ່ເກາະຟອກແລນ (ອິສລາສ ມາວິນນາສ)',
 			'FM' => 'ໄມໂຄຣນີເຊຍ',
 			'FO' => 'ຫມູ່ເກາະແຟໂຣ',
 			'FR' => 'ຝຣັ່ງ',
 			'GA' => 'ກາບອນ',
 			'GB' => 'ສະຫະລາດຊະອະນາຈັກ',
 			'GB@alt=short' => 'ສະຫະລາດຊະອະນາຈັກຯ',
 			'GD' => 'ເກຣເນດາ',
 			'GE' => 'ຈໍເຈຍ',
 			'GF' => 'ເຟຣນຊ໌ ກຸຍອານາ',
 			'GG' => 'ເກີນຊີ',
 			'GH' => 'ການາ',
 			'GI' => 'ຈິບບຣອນທາ',
 			'GL' => 'ກຣີນແລນ',
 			'GM' => 'ສາທາລະນະລັດແກມເບຍ',
 			'GN' => 'ກິນີ',
 			'GP' => 'ກົວດາລູບ',
 			'GQ' => 'ເອຄົວໂທຣຽວ ກີນີ',
 			'GR' => 'ກຣີຊ',
 			'GS' => 'ໝູ່ເກາະ ຈໍເຈຍຕອນໃຕ້ ແລະ ແຊນວິດຕອນໃຕ້',
 			'GT' => 'ກົວເທມາລາ',
 			'GU' => 'ກວາມ',
 			'GW' => 'ກິນີ-ບິສເຊົາ',
 			'GY' => 'ກາຍຢານາ',
 			'HK' => 'ຮົງກົງ ເຂດປົກຄອງພິເສດ ຈີນ',
 			'HK@alt=short' => 'ຮົງກົງ',
 			'HM' => 'ໝູ່ເກາະເຮີດ & ແມັກໂດນອລ',
 			'HN' => 'ຮອນດູຣັສ',
 			'HR' => 'ໂຄຣເອເທຍ',
 			'HT' => 'ໄຮຕິ',
 			'HU' => 'ຮັງກາຣີ',
 			'IC' => 'ໝູ່ເກາະຄານາຣີ',
 			'ID' => 'ອິນໂດເນເຊຍ',
 			'IE' => 'ໄອແລນ',
 			'IL' => 'ອິສຣາເອວ',
 			'IM' => 'ເອວ ອອບ ແມນ',
 			'IN' => 'ອິນເດຍ',
 			'IO' => 'ເຂດແດນອັງກິດໃນມະຫາສະມຸດອິນເດຍ',
 			'IQ' => 'ອີຣັກ',
 			'IR' => 'ອີຣານ',
 			'IS' => 'ໄອສແລນ',
 			'IT' => 'ອິຕາລີ',
 			'JE' => 'ເຈີຊີ',
 			'JM' => 'ຈາໄມຄາ',
 			'JO' => 'ຈໍແດນ',
 			'JP' => 'ຍີ່ປຸ່ນ',
 			'KE' => 'ເຄນຢາ',
 			'KG' => 'ຄຽກກິດສະຖານ',
 			'KH' => 'ກຳປູເຈຍ',
 			'KI' => 'ຄິຣິບາທິ',
 			'KM' => 'ໂຄໂມໂຣສ',
 			'KN' => 'ເຊນ ຄິດ ແລະ ເນວິສ',
 			'KP' => 'ເກົາຫລີເໜືອ',
 			'KR' => 'ເກົາຫລີໃຕ້',
 			'KW' => 'ກູເວດ',
 			'KY' => 'ໝູ່ເກາະ ເຄແມນ',
 			'KZ' => 'ຄາຊັກສະຖານ',
 			'LA' => 'ລາວ',
 			'LB' => 'ເລບານອນ',
 			'LC' => 'ເຊນ ລູເຊຍ',
 			'LI' => 'ລິດເທນສະຕາຍ',
 			'LK' => 'ສີລັງກາ',
 			'LR' => 'ລິເບີເຣຍ',
 			'LS' => 'ເລໂຊໂທ',
 			'LT' => 'ລິທົວເນຍ',
 			'LU' => 'ລຸກແຊມເບີກ',
 			'LV' => 'ລັດເວຍ',
 			'LY' => 'ລິເບຍ',
 			'MA' => 'ໂມຣັອກໂຄ',
 			'MC' => 'ໂມນາໂຄ',
 			'MD' => 'ໂມນໂດວາ',
 			'ME' => 'ມອນເຕເນໂກຣ',
 			'MF' => 'ເຊນ ມາທິນ',
 			'MG' => 'ມາດາກາສະກາ',
 			'MH' => 'ຫມູ່ເກາະມາແຊວ',
 			'MK' => 'ແມຊິໂດເນຍເໜືອ',
 			'ML' => 'ມາລີ',
 			'MM' => 'ມຽນມາ (ເບີມາ)',
 			'MN' => 'ມອງໂກເລຍ',
 			'MO' => 'ມາກາວ ເຂດປົກຄອງພິເສດ ຈີນ',
 			'MO@alt=short' => 'ມາກາວ',
 			'MP' => 'ໝູ່ເກາະມາເຣຍນາຕອນເໜືອ',
 			'MQ' => 'ມາຕິນີກ',
 			'MR' => 'ມົວຣິເທເນຍ',
 			'MS' => 'ມອນເຊີຣາດ',
 			'MT' => 'ມອນທາ',
 			'MU' => 'ມົວຣິຊຽສ',
 			'MV' => 'ມັນດິຟ',
 			'MW' => 'ມາລາວີ',
 			'MX' => 'ເມັກຊິໂກ',
 			'MY' => 'ມາເລເຊຍ',
 			'MZ' => 'ໂມແຊມບິກ',
 			'NA' => 'ນາມີເບຍ',
 			'NC' => 'ນິວ ຄາເລໂດເນຍ',
 			'NE' => 'ນິເຈີ',
 			'NF' => 'ເກາະນໍໂຟກ',
 			'NG' => 'ໄນຈີເຣຍ',
 			'NI' => 'ນິກຄາຣາກົວ',
 			'NL' => 'ເນເທີແລນ',
 			'NO' => 'ນໍເວ',
 			'NP' => 'ເນປານ',
 			'NR' => 'ນາອູຣູ',
 			'NU' => 'ນີອູເອ',
 			'NZ' => 'ນິວຊີແລນ',
 			'OM' => 'ໂອມານ',
 			'PA' => 'ພານາມາ',
 			'PE' => 'ເປຣູ',
 			'PF' => 'ເຟຣນຊ໌ ໂພລິນີເຊຍ',
 			'PG' => 'ປາປົວນິວກີນີ',
 			'PH' => 'ຟິລິບປິນ',
 			'PK' => 'ປາກິດສະຖານ',
 			'PL' => 'ໂປແລນ',
 			'PM' => 'ເຊນ ປີແອ ມິເກວລອນ',
 			'PN' => 'ໝູ່ເກາະພິດແຄນ',
 			'PR' => 'ເພືອໂຕ ຣິໂກ',
 			'PS' => 'ດິນແດນປາເລດສະຕິນ',
 			'PS@alt=short' => 'ປາເລດສະຕິນ',
 			'PT' => 'ພອລທູໂກ',
 			'PW' => 'ປາລາວ',
 			'PY' => 'ພາຣາກວຍ',
 			'QA' => 'ກາຕາ',
 			'QO' => 'ເຂດຫ່າງໄກໂອຊີເນຍ',
 			'RE' => 'ເຣອູນິຍົງ',
 			'RO' => 'ໂຣແມເນຍ',
 			'RS' => 'ເຊີເບຍ',
 			'RU' => 'ຣັດເຊຍ',
 			'RW' => 'ຣວັນດາ',
 			'SA' => 'ຊາອຸດິ ອາຣາເບຍ',
 			'SB' => 'ຫມູ່ເກາະໂຊໂລມອນ',
 			'SC' => 'ເຊເຊວເລສ',
 			'SD' => 'ຊູດານ',
 			'SE' => 'ສະວີເດັນ',
 			'SG' => 'ສິງກະໂປ',
 			'SH' => 'ເຊນ ເຮເລນາ',
 			'SI' => 'ສະໂລເວເນຍ',
 			'SJ' => 'ສະວາບາ ແລະ ແຢນ ມາເຢນ',
 			'SK' => 'ສະໂລວາເກຍ',
 			'SL' => 'ເຊຍຣາ ລີໂອນ',
 			'SM' => 'ແຊນ ມາຣິໂນ',
 			'SN' => 'ເຊນີໂກລ',
 			'SO' => 'ໂຊມາເລຍ',
 			'SR' => 'ຊູຣິນາມ',
 			'SS' => 'ຊູດານໃຕ້',
 			'ST' => 'ເຊົາທູເມ ແລະ ພຣິນຊິບ',
 			'SV' => 'ເອວ ຊໍວາດໍ',
 			'SX' => 'ຊິນ ມາເທັນ',
 			'SY' => 'ຊີເຣຍ',
 			'SZ' => '​ເອ​ສະ​ວາ​ຕິ​ນີ',
 			'SZ@alt=variant' => 'ສະ​ວາ​ຊິ​ແລນ',
 			'TA' => 'ທຣິສຕັນ ດາ ກັນຮາ',
 			'TC' => 'ໝູ່ເກາະ ເທີກ ແລະ ໄຄໂຄສ',
 			'TD' => 'ຊາດ',
 			'TF' => 'ເຂດແດນທາງໃຕ້ຂອຝຮັ່ງ',
 			'TG' => 'ໂຕໂກ',
 			'TH' => 'ໄທ',
 			'TJ' => 'ທາຈິກິດສະຖານ',
 			'TK' => 'ໂຕເກເລົາ',
 			'TL' => 'ທິມໍ-ເລສເຕ',
 			'TL@alt=variant' => 'ທິມໍ ຕາເວັນອອກ',
 			'TM' => 'ເທີກເມນິສະຖານ',
 			'TN' => 'ຕູນິເຊຍ',
 			'TO' => 'ທອງກາ',
 			'TR' => 'ເທີຄີ',
 			'TT' => 'ທຣິນິແດດ ແລະ ໂທແບໂກ',
 			'TV' => 'ຕູວາລູ',
 			'TW' => 'ໄຕ້ຫວັນ',
 			'TZ' => 'ທານຊາເນຍ',
 			'UA' => 'ຢູເຄຣນ',
 			'UG' => 'ອູການດາ',
 			'UM' => 'ໝູ່ເກາະຮອບນອກຂອງສະຫະລັດຯ',
 			'UN' => 'ສະຫະປະຊາຊາດ',
 			'UN@alt=short' => 'ຢູເອັນ',
 			'US' => 'ສະຫະລັດ',
 			'US@alt=short' => 'ສະຫະລັດຯ',
 			'UY' => 'ອູຣຸກວຍ',
 			'UZ' => 'ອຸສເບກິສະຖານ',
 			'VA' => 'ນະຄອນ ວາຕິກັນ',
 			'VC' => 'ເຊນ ວິນເຊນ ແລະ ເກຣເນດິນ',
 			'VE' => 'ເວເນຊູເອລາ',
 			'VG' => 'ໝູ່ເກາະ ເວີຈິນຂອງອັງກິດ',
 			'VI' => 'ໝູ່ເກາະ ເວີຈິນ ຂອງສະຫະລັດ',
 			'VN' => 'ຫວຽດນາມ',
 			'VU' => 'ວານົວຕູ',
 			'WF' => 'ວາລລິສ ແລະ ຟູຕູນາ',
 			'WS' => 'ຊາມົວ',
 			'XA' => 'Pseudo-Accents',
 			'XB' => 'Pseudo-Bidi',
 			'XK' => 'ໂຄໂຊໂວ',
 			'YE' => 'ເຢເມນ',
 			'YT' => 'ມາຢັອດ',
 			'ZA' => 'ອາຟຣິກາໃຕ້',
 			'ZM' => 'ແຊມເບຍ',
 			'ZW' => 'ຊິມບັບເວ',
 			'ZZ' => 'ຂົງເຂດທີ່ບໍ່ຮູ້ຈັກ',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'1901' => 'ເຢຍລະມັນອໍໂທກຣາຟີດັ້ງເດີມ',
 			'1994' => 'ອັກສອນເຣຊ່ຽນມາດຕະຖານ',
 			'1996' => 'ເຢຍລະມັນອໍໂທກຣາຟີປີ1996',
 			'1606NICT' => 'ປາຍຍຸກກາງຝຣັ່ງເຖິງປີ ຄສ 1606',
 			'1694ACAD' => 'ຕອນຕົ້ນຍຸກໃໝ່ຝຣັ່ງ',
 			'1959ACAD' => 'ວິຊາການ',
 			'ALALC97' => 'ການຖອດອັກສອນເປັນອັກສອນໂຣມັນຕາມເກນຂອງສະມາຄົມຫ້ອງສະໝຸດອາເມລິກາແລະຫ້ອງສະໝຸດລັດຖະສະພາ ສະບັບພິມປີ 1997',
 			'ALUKU' => 'ພາສາພື້ນເມືອງອລູຄຸ',
 			'AREVELA' => 'ອາເມເນຍຕາເວັນອອກ',
 			'AREVMDA' => 'ອາເມເນຍຕາເວັນຕົກ',
 			'BAKU1926' => 'ຕົວອັກສອນລາຕິນເທີກິກແບບຄົບວົງຈອນ',
 			'BAUDDHA' => 'ພະພຸດທະເຈົ້າ',
 			'BISCAYAN' => 'ບິສຄາຍັນ',
 			'BISKE' => 'ພາສາພື້ນເມືອງຊານຈິໂອໂຈ/ບິລາ',
 			'BOONT' => 'ບູນທລິ່ງ',
 			'FONIPA' => 'ສັດທະສາດອັກສອນສາກົນ',
 			'FONUPA' => 'ສັດທະສາດອັກສອນ UPA',
 			'FONXSAMP' => 'ຟອນແຊມ',
 			'HEPBURN' => 'ການຖອດອັກສອນແບບເຮບເບິນ',
 			'HOGNORSK' => 'ພາສານໍວີຈ່ຽນສູງ',
 			'ITIHASA' => 'ອິຕິຫາສະ',
 			'JAUER' => 'ເຍົາເອີ',
 			'JYUTPING' => 'ການຖອດອັກສອນແບບຍູດພິງ',
 			'KKCOR' => 'ອັກຂະລະວິທີສາມັນ',
 			'LAUKIKA' => 'ລົວກິກາ',
 			'LIPAW' => 'ພາສາພື້ນເມືອງລິໂພວາຊ໌ຂອງເຣຊ່ຽນ',
 			'LUNA1918' => 'ລູນ່າ1918',
 			'MONOTON' => 'ໂມໂນໂທນິກ',
 			'NDYUKA' => 'ພາສາພື້ນເມືອງດິວຄາ',
 			'NEDIS' => 'ພາສາພື້ນເມືອງນາທິໂຊເນ',
 			'NJIVA' => 'ພາສາພື້ນເມືອງຈີວາ/ນີວາ',
 			'OSOJS' => 'ພາສາພື້ນເມືອງໂອຊຽກໂຄ/ໂອໂຊຍາເນ',
 			'PAMAKA' => 'ພາສາພື້ນເມືອງພາມາຄາ',
 			'PETR1708' => 'ພີທ໌1708',
 			'PINYIN' => 'ພິນຢິນ',
 			'POLYTON' => 'ໂພລີໂທນິກ',
 			'POSIX' => 'ຄອມພິວເຕີ',
 			'PUTER' => 'ພິວເຕີ',
 			'REVISED' => 'ອັກຂະລະວິທີສະບັບປັບປຸງ',
 			'ROZAJ' => 'ເຣຊ່ຽນ',
 			'RUMGR' => 'ຣຳກຣ໌',
 			'SAAHO' => 'ຊາໂຮ',
 			'SCOTLAND' => 'ພາສາອັງກິດມາດຕະຖານສະກັອດ',
 			'SCOUSE' => 'ສະເກົາສ໌',
 			'SOLBA' => 'ພາສາພື້ນເມືອງສະໂຕວິຊ໌ຊ່າ/ໂຊລ໌ບີກາ',
 			'SURMIRAN' => 'ຊູຣ໌ມິລານ',
 			'SURSILV' => 'ຊູຣ໌ຊີລ໌',
 			'SUTSILV' => 'ຊຸຕ໌ຊີລ໌',
 			'TARASK' => 'ອັກຂະລະວິທີທາຣາຊ໌ເຄຍວິກາ',
 			'UCCOR' => 'ອັກຂະລະວິທີແບບຄົບວົງຈອນ',
 			'UCRCOR' => 'ອັກຂະລະວິທີສະບັບປັບປຸງແບບຄົບວົງຈອນ',
 			'ULSTER' => 'ອັລສະເຕີ',
 			'VAIDIKA' => 'ເວດິກາ',
 			'VALENCIA' => 'ວາເລັນເຊຍ',
 			'VALLADER' => 'ວັລລາເດີ',
 			'WADEGILE' => 'ການຖອດອັກສອນແບບເວດ-ໄຈລ໌',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'ປະຕິທິນ',
 			'cf' => 'ຮູບແບບສະກຸນເງິນ',
 			'collation' => 'ຮຽງລຳດັບ',
 			'currency' => 'ສະກຸນເງິນ',
 			'hc' => 'ຮອບວຽນຊົ່ວໂມງ( 12 ຫຼື 24)',
 			'lb' => 'ຮູບແບບເສັ້ນຂັ້ນ',
 			'ms' => 'ລະບົບການວັດແທກ',
 			'numbers' => 'ຕົວເລກ',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ປະຕິທິນ ພຸດທະສັງກາດ},
 				'chinese' => q{ປະຕິທິນຈີນ},
 				'coptic' => q{ປະຕິທິນຄັອບຕິກ},
 				'dangi' => q{ປະ​ຕິ​ທິນ​ດັງ​ກີ},
 				'ethiopic' => q{ປະຕິທິນເອທິໂອເປຍ},
 				'ethiopic-amete-alem' => q{ປະຕິທິນປີໂອເອທິໂອເປຍ},
 				'gregorian' => q{ປະຕິທິນເກຣໂກຣຽນ},
 				'hebrew' => q{ປະ​ຕິ​ທິນ​ຮີບ​ຣິວ},
 				'indian' => q{ປະຕິທິນແຫ່ງຊາດອິນເດຍ},
 				'islamic' => q{ປະຕິທິນອິສະລາມ},
 				'islamic-civil' => q{ປະຕິທິນອິດສະລາມ},
 				'iso8601' => q{ປະ​ຕິ​ທິນ ISO-8601},
 				'japanese' => q{ປະຕິທິນຍີ່ປຸ່ນ},
 				'persian' => q{ປະຕິທິນເປີຊຽນ},
 				'roc' => q{ປະຕິທິນໄຕ້ຫວັນ},
 			},
 			'cf' => {
 				'account' => q{ຮູບແບບສະກຸນເງິນການບັນຊີ},
 				'standard' => q{ຮູບແບບສະກຸນເງິນມາດຕະຖານ},
 			},
 			'collation' => {
 				'big5han' => q{ລຽງຕາມອັກສອນຈີນດັ້ງເດີມ},
 				'dictionary' => q{ລຽງຕາມພົດຈະນານຸກົມ},
 				'ducet' => q{ຮຽງຕາມລຳດັບຢູນິໂຄດເລີ່ມຕົ້ນ},
 				'gb2312han' => q{ລຽງຕາມອັກສອນຈີນປະຍຸກ},
 				'phonebook' => q{ລຽງຕາມສະໝຸດໂທລະສັບ},
 				'pinyin' => q{ລຽງຕາມການອອກສຽງພາສາຈີນ},
 				'reformed' => q{ລຽງຕາມລຳດັບສຸດທ້າຍ},
 				'search' => q{ການຊອກຫາທົ່ວໄປ},
 				'searchjl' => q{ຄົ້ນຫາຕາມພະຍັນຊະນະຂຶ້ນຕົ້ນທີ່ເປັນຮັງກີຣ},
 				'standard' => q{ຮຽງຕາມມາດຕະຖານ},
 				'stroke' => q{ລຽງຕາມການລາກເສັ້ນ},
 				'traditional' => q{ລຽງຕາມແບບດັ້ງເດີມ},
 				'unihan' => q{ລຽງລຳດັບຕາມຈຳນວນຂີດ},
 			},
 			'hc' => {
 				'h11' => q{ຕາມລະບົບ 12 ຊົ່ວໂມງ (0–11)},
 				'h12' => q{ຕາມລະບົບ 12 ຊົ່ວໂມງ (1–12)},
 				'h23' => q{ຕາມລະບົບ 24 ຊົ່ວໂມງ (0–23)},
 				'h24' => q{ຕາມລະບົບ 24 ຊົ່ວໂມງ (1–24)},
 			},
 			'lb' => {
 				'loose' => q{ຮູບແບບເສັ້ນຂັ້ນແບບຫຼວມ},
 				'normal' => q{ຮູບແບບເສັ້ນຂັ້ນແບບປົກກະຕິ},
 				'strict' => q{ຮູບແບບເສັ້ນຂັ້ນແບບເຄັ່ງຄັດ},
 			},
 			'ms' => {
 				'metric' => q{ລະບົບເມທຣິກ},
 				'uksystem' => q{ລະບົບການວັດແທກແບບອິມເພີຣຽວ},
 				'ussystem' => q{ລະບົບການວັດແທກແບບສະຫະລັດ},
 			},
 			'numbers' => {
 				'arab' => q{ຕົວເລກອາຣາບິກ-ອິນດິກ},
 				'arabext' => q{ຕົວເລກອາຣາບິກ-ອິນດິກຕົວເຕັມ},
 				'armn' => q{ຕົວເລກອາເມນຽນ},
 				'armnlow' => q{ຕົວເລກອາເມນຽນຕົວພິມນ້ອຍ},
 				'bali' => q{ຕົວເລກບາລີ},
 				'beng' => q{ຕົວເລກບັງກລາ},
 				'cham' => q{ຕົວເລກຊຣາມ},
 				'deva' => q{ຕົວເລກເດວານາກາຣີ},
 				'ethi' => q{ຕົວເລກເອທິໂອປິກ},
 				'fullwide' => q{ຕົວເລກຄວາມກວ້າງເຕັມ},
 				'geor' => q{ຕົວເລກຈໍຈຽນ},
 				'grek' => q{ຕົວເລກກຣີກ},
 				'greklow' => q{ຕົວເລກກຣີກຕົວພິມນ້ອຍ},
 				'gujr' => q{ຕົວເລກກຸຈາຣາທີ},
 				'guru' => q{ຕົວເລກກົວມູຄິ},
 				'hanidec' => q{ຕົວເລກທົດສະນິຍົມຈີນ},
 				'hans' => q{ຕົວເລກຈີນແບບຮຽບງ່າຍ},
 				'hansfin' => q{ຕົວເລກທາງການເງິນແບບຮຽບງ່າຍຂອງຈີນ},
 				'hant' => q{ຕົວເລກຈີນແບບດັ້ງເດີມ},
 				'hantfin' => q{ຕົວເລກທາງການເງິນແບບດັ້ງເດີມຂອງຈີນ},
 				'hebr' => q{ຕົວເລກຮິບຣິວ},
 				'java' => q{ຕົວເລກຊົວ},
 				'jpan' => q{ຕົວເລກຍີ່ປຸ່ນ},
 				'jpanfin' => q{ຕົວເລກທາງການເງິນຂອງຍີ່ປຸ່ນ},
 				'kali' => q{ຕົວເລກກາຢາ},
 				'khmr' => q{ຕົວເລກຂະແມ},
 				'knda' => q{ຕົວເລກແຄນນາດາ},
 				'lana' => q{ຕົວເລກໄທທຳໂຮລາ},
 				'lanatham' => q{ຕົວເລກໄທທຳທຳ},
 				'laoo' => q{ຕົວເລກລາວ},
 				'latn' => q{ຕົວເລກຕາເວັນຕົກ},
 				'lepc' => q{ຕົວເລກເລຊາ},
 				'limb' => q{ຕົວເລກລິມບູ},
 				'mlym' => q{ຕົວເລກມາເລອາລຳ},
 				'mong' => q{ຕົວເລກມ່ອງໂກເລຍ},
 				'mtei' => q{ຕົວເລກເມໄຕມາເຢກ},
 				'mymr' => q{ຕົວເລກມຽນມາ},
 				'mymrshan' => q{ຕົວເລກຊານພະມ້າ},
 				'nkoo' => q{ຕົວເລກເອັນໂກ້},
 				'olck' => q{ຕົວເລກໂອລຈິກິ},
 				'orya' => q{ຕົວເລກໂອດິອາ},
 				'roman' => q{ຕົວເລກໂຣມັນ},
 				'romanlow' => q{ຕົວເລກໂຣມັນຕົວພິມນ້ອຍ},
 				'saur' => q{ຕົວເລກເສົາລັດທາ},
 				'sund' => q{ຕົວເລກຊຸນດາ},
 				'talu' => q{ຕົວເລກໄຕລື້ໃໝ່},
 				'taml' => q{ຕົວເລກທາມິລແບບດັ້ງເດີມ},
 				'tamldec' => q{ຕົວເລກທາມິວ},
 				'telu' => q{ຕົວເລກເຕລູກູ},
 				'thai' => q{ຕົວເລກໄທ},
 				'tibt' => q{ຕົວເລກທິເບດ},
 				'vaii' => q{ຕົວເລກໃນລະບົບໄວ},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{ເມທຣິກ},
 			'UK' => q{ສະຫະລາດຊະອານາຈັກອັງກິດ},
 			'US' => q{ສະຫະລັດອາເມລິກາ},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => '{0}',
 			'script' => '{0}',
 			'region' => '{0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[​ ໐ ໑ ໒ ໓ ໔ ໕ ໖ ໗ ໘ ໙]},
			index => ['ກ', 'ຂ', 'ຄ', 'ງ', 'ຈ', 'ສ', 'ຊ', 'ຍ', 'ດ', 'ຕ', 'ຖ', 'ທ', 'ນ', 'ບ', 'ປ', 'ຜ', 'ຝ', 'ພ', 'ຟ', 'ມ', 'ຢ', 'ຣ', 'ລ', 'ວ', 'ຫ', '{ຫງ}', '{ຫຍ}', '{ຫນ}', '{ຫມ}', '{ຫລ}', '{ຫວ}', 'ອ', 'ຮ'],
			main => qr{[່ ້ ໊ ໋ ໌ ໍ ໆ ກ ຂ ຄ ງ ຈ ສ ຊ ຍ ດ ຕ ຖ ທ ນ ບ ປ ຜ ຝ ພ ຟ ມ ຢ ຣ ລ ວ ຫ ໜ ໝ ອ ຮ ຯ ະ ັ າ ຳ ິ ີ ຶ ື ຸ ູ ົ ຼ ຽ ເ ແ ໂ ໃ ໄ]},
			numbers => qr{[\- ‑ , . % ‰ + 0 1 2 3 4 5 6 7 8 9]},
			punctuation => qr{[\- ‐ ‑ – — , ; \: ! ? . … ' ‘ ’ " “ ” ( ) \[ \] § @ * / \& # † ‡ ′ ″]},
		};
	},
EOT
: sub {
		return { index => ['ກ', 'ຂ', 'ຄ', 'ງ', 'ຈ', 'ສ', 'ຊ', 'ຍ', 'ດ', 'ຕ', 'ຖ', 'ທ', 'ນ', 'ບ', 'ປ', 'ຜ', 'ຝ', 'ພ', 'ຟ', 'ມ', 'ຢ', 'ຣ', 'ລ', 'ວ', 'ຫ', '{ຫງ}', '{ຫຍ}', '{ຫນ}', '{ຫມ}', '{ຫລ}', '{ຫວ}', 'ອ', 'ຮ'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(ທິດທາງຕາມລຳດັບ),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(ທິດທາງຕາມລຳດັບ),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(kibi{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(kibi{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(mebi{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(mebi{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(gibi{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(gibi{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(tebi{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(tebi{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(pebi{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(pebi{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(exbi{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(exbi{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(zebi{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(zebi{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(yobe{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(yobe{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(ເດຊີ{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(ເດຊີ{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(ປິໂກ{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(ປິໂກ{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ເຟມໂຕ{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ເຟມໂຕ{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(ອັດໂຕ{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(ອັດໂຕ{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(ຊັງຕີ{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(ຊັງຕີ{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(ເຊັບໂຕ{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(ເຊັບໂຕ{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(ຢັອກໂຕ{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(ຢັອກໂຕ{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(ມິນລິ{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(ມິນລິ{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(ໄມໂຄຣ{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(ໄມໂຄຣ{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(ນາໂນ{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(ນາໂນ{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ເດກາ{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ເດກາ{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(ເທຣາ{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(ເທຣາ{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(ເພຕາ{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(ເພຕາ{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(ເອັກຊາ{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(ເອັກຊາ{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(ເຮັກໂຕ{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(ເຮັກໂຕ{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(ເຊັດຕາ{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(ເຊັດຕາ{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(ຢັອດຕາ{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(ຢັອດຕາ{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(ກິໂລ{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(ກິໂລ{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(ເມກາ{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(ເມກາ{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(ກິກາ{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(ກິກາ{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(ແຮງຕົກຕາມລຳພັງ),
						'other' => q({0} ແຮງຕົກຕາມລຳພັງ),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(ແຮງຕົກຕາມລຳພັງ),
						'other' => q({0} ແຮງຕົກຕາມລຳພັງ),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(ແມັດຕໍ່ວິນາທີກໍາລັງສອງ),
						'other' => q({0} ແມັດຕໍ່ວິນາທີກໍາລັງສອງ),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(ແມັດຕໍ່ວິນາທີກໍາລັງສອງ),
						'other' => q({0} ແມັດຕໍ່ວິນາທີກໍາລັງສອງ),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(arcminutes),
						'other' => q({0} ນາທີ),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(arcminutes),
						'other' => q({0} ນາທີ),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(arcseconds),
						'other' => q({0} ວິນາທີ),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(arcseconds),
						'other' => q({0} ວິນາທີ),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(ອົງສາ),
						'other' => q({0} ອົງສາ),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(ອົງສາ),
						'other' => q({0} ອົງສາ),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(radians),
						'other' => q({0} radians),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(radians),
						'other' => q({0} radians),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(rev),
						'other' => q({0} rev),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(rev),
						'other' => q({0} rev),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(ເອເຄີ),
						'other' => q({0} ເອເຄີ),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(ເອເຄີ),
						'other' => q({0} ເອເຄີ),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(ດູ​ນຳ),
						'other' => q({0} ດູ​ນຳ),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(ດູ​ນຳ),
						'other' => q({0} ດູ​ນຳ),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(ເຮັກຕາ),
						'other' => q({0} ເຮັກຕາ),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(ເຮັກຕາ),
						'other' => q({0} ເຮັກຕາ),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(ຊັງຕີຕາແມັດ),
						'other' => q({0} ຊັງຕີຕາແມັດ),
						'per' => q({0} ຕໍ່ຊັງຕີຕາແມັດ),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(ຊັງຕີຕາແມັດ),
						'other' => q({0} ຊັງຕີຕາແມັດ),
						'per' => q({0} ຕໍ່ຊັງຕີຕາແມັດ),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(ຕາ​ຟຸດ),
						'other' => q({0} ຕາ​ຟຸດ),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(ຕາ​ຟຸດ),
						'other' => q({0} ຕາ​ຟຸດ),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(ຕານິ້ວ),
						'other' => q({0} ຕາລາງນິ້ວ),
						'per' => q({0} ຕໍ່ຕາລາງນິ້ວ),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(ຕານິ້ວ),
						'other' => q({0} ຕາລາງນິ້ວ),
						'per' => q({0} ຕໍ່ຕາລາງນິ້ວ),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(ກິໂລຕາແມັດ),
						'other' => q({0} ກິໂລຕາແມັດ),
						'per' => q({0} ຕໍ່ຕາກິໂລແມັດກ້ອນ),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(ກິໂລຕາແມັດ),
						'other' => q({0} ກິໂລຕາແມັດ),
						'per' => q({0} ຕໍ່ຕາກິໂລແມັດກ້ອນ),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(ຕາແມັດ),
						'other' => q({0} ຕາແມັດ),
						'per' => q({0} ຕໍ່ຕາແມັດ),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(ຕາແມັດ),
						'other' => q({0} ຕາແມັດ),
						'per' => q({0} ຕໍ່ຕາແມັດ),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(ຕາ​ລາງໄມລ໌),
						'other' => q({0} ຕາ​ລາງໄມລ໌),
						'per' => q({0}/mi²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(ຕາ​ລາງໄມລ໌),
						'other' => q({0} ຕາ​ລາງໄມລ໌),
						'per' => q({0}/mi²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(square yards),
						'other' => q({0} ຕາລາງຢາດ),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(square yards),
						'other' => q({0} ຕາລາງຢາດ),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(ອັນ),
						'other' => q({0} ອັນ),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(ອັນ),
						'other' => q({0} ອັນ),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(ກະຣັດ),
						'other' => q({0} ກະຣັດ),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(ກະຣັດ),
						'other' => q({0} ກະຣັດ),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(ມິລິກຣັມຕໍ່ເດຊິລິດ),
						'other' => q({0} mg/dL),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(ມິລິກຣັມຕໍ່ເດຊິລິດ),
						'other' => q({0} mg/dL),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ມິລິໂມລຕໍ່ລິດ),
						'other' => q({0} ມິລິໂມລຕໍ່ລິດ),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ມິລິໂມລຕໍ່ລິດ),
						'other' => q({0} ມິລິໂມລຕໍ່ລິດ),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(ໂມ​ລ),
						'other' => q({0} ໂມ​ລ),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(ໂມ​ລ),
						'other' => q({0} ໂມ​ລ),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(ເປີເຊັນ),
						'other' => q({0} ເປີເຊັນ),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(ເປີເຊັນ),
						'other' => q({0} ເປີເຊັນ),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(ຕໍ່ພັນ),
						'other' => q({0} ຕໍ່ພັນ),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(ຕໍ່ພັນ),
						'other' => q({0} ຕໍ່ພັນ),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ພາດຕໍ່ລ້ານ),
						'other' => q({0} ພາດຕໍ່ລ້ານ),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ພາດຕໍ່ລ້ານ),
						'other' => q({0} ພາດຕໍ່ລ້ານ),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(ເປີ​ມີ​ຣຽດ),
						'other' => q({0} ເປີ​ມີ​ຣຽດ),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(ເປີ​ມີ​ຣຽດ),
						'other' => q({0} ເປີ​ມີ​ຣຽດ),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ລິດ ຕໍ່ 100 ກິໂລເເມັດ),
						'other' => q({0} ລິດຕໍ່ 100 ກີໂລແມັດ),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ລິດ ຕໍ່ 100 ກິໂລເເມັດ),
						'other' => q({0} ລິດຕໍ່ 100 ກີໂລແມັດ),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(ລ/ກມ),
						'other' => q({0} ລິດຕໍ່ກິໂລແມັດ),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(ລ/ກມ),
						'other' => q({0} ລິດຕໍ່ກິໂລແມັດ),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(ໄມລ໌ຕໍ່ແກລອນ),
						'other' => q({0} ໄມລ໌ຕໍ່ແກລອນ),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(ໄມລ໌ຕໍ່ແກລອນ),
						'other' => q({0} ໄມລ໌ຕໍ່ແກລອນ),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(ໄມລ໌ຕໍ່ແກລລອນອັງກິດ),
						'other' => q({0} ໄມລ໌ຕໍ່ແກລລອນອັງກິດ),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(ໄມລ໌ຕໍ່ແກລລອນອັງກິດ),
						'other' => q({0} ໄມລ໌ຕໍ່ແກລລອນອັງກິດ),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(bit),
						'other' => q({0} bit),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(bit),
						'other' => q({0} bit),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(byte),
						'other' => q({0} byte),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(byte),
						'other' => q({0} byte),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(Gb),
						'other' => q({0} Gb),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(Gb),
						'other' => q({0} Gb),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(GB),
						'other' => q({0} GB),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(GB),
						'other' => q({0} GB),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(kb),
						'other' => q({0} kb),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(kb),
						'other' => q({0} kb),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(kB),
						'other' => q({0} kB),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(kB),
						'other' => q({0} kB),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Mb),
						'other' => q({0} Mb),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Mb),
						'other' => q({0} Mb),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(MB),
						'other' => q({0} MB),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(MB),
						'other' => q({0} MB),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(ເພຕາໄບຕ໌),
						'other' => q({0} ເພຕາໄບຕ໌),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(ເພຕາໄບຕ໌),
						'other' => q({0} ເພຕາໄບຕ໌),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Tb),
						'other' => q({0} Tb),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Tb),
						'other' => q({0} Tb),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(TB),
						'other' => q({0} TB),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(TB),
						'other' => q({0} TB),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(ສັດຕະວັດ),
						'other' => q({0} ສັດຕະວັດ),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(ສັດຕະວັດ),
						'other' => q({0} ສັດຕະວັດ),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(ມື້),
						'other' => q({0} ມື້),
						'per' => q({0} ຕໍ່ມື້),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(ມື້),
						'other' => q({0} ມື້),
						'per' => q({0} ຕໍ່ມື້),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(ທົດສະວັດ),
						'other' => q({0} ທົດສະວັດ),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(ທົດສະວັດ),
						'other' => q({0} ທົດສະວັດ),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ຊົ່ວໂມງ),
						'other' => q({0} ຊົ່ວໂມງ),
						'per' => q({0} ຕໍ່ຊົ່ວໂມງ),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ຊົ່ວໂມງ),
						'other' => q({0} ຊົ່ວໂມງ),
						'per' => q({0} ຕໍ່ຊົ່ວໂມງ),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(ໄມ​ໂຄຣ​ວິ​ນາ​ທີ),
						'other' => q({0} ໄມ​ໂຄຣ​ວິ​ນາ​ທີ),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(ໄມ​ໂຄຣ​ວິ​ນາ​ທີ),
						'other' => q({0} ໄມ​ໂຄຣ​ວິ​ນາ​ທີ),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ມິນລີວິນາທີ),
						'other' => q({0} ມິນລີວິນາທີ),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ມິນລີວິນາທີ),
						'other' => q({0} ມິນລີວິນາທີ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(ນາທີ),
						'other' => q({0} ນາທີ),
						'per' => q({0} ຕໍ່ນາທີ),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(ນາທີ),
						'other' => q({0} ນາທີ),
						'per' => q({0} ຕໍ່ນາທີ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(ເດືອນ),
						'other' => q({0} ເດືອນ),
						'per' => q({0}/ເດືອນ),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(ເດືອນ),
						'other' => q({0} ເດືອນ),
						'per' => q({0}/ເດືອນ),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(ນາ​ໂນ​ວິ​ນາ​ທີ),
						'other' => q({0} ນາ​ໂນ​ວິ​ນາ​ທີ),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(ນາ​ໂນ​ວິ​ນາ​ທີ),
						'other' => q({0} ນາ​ໂນ​ວິ​ນາ​ທີ),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ວິນາທີ),
						'other' => q({0} ວິນາທີ),
						'per' => q({0} ຕໍ່ວິນາທີ),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ວິນາທີ),
						'other' => q({0} ວິນາທີ),
						'per' => q({0} ຕໍ່ວິນາທີ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ອາທິດ),
						'other' => q({0} ອາທິດ),
						'per' => q({0} ຕໍ່ອາທິດ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ອາທິດ),
						'other' => q({0} ອາທິດ),
						'per' => q({0} ຕໍ່ອາທິດ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(ປີ),
						'other' => q({0} ປີ),
						'per' => q({0} /ປີ),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(ປີ),
						'other' => q({0} ປີ),
						'per' => q({0} /ປີ),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(amp),
						'other' => q({0} A),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(amp),
						'other' => q({0} A),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(mA),
						'other' => q({0} mA),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(mA),
						'other' => q({0} mA),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(ohm),
						'other' => q({0} Ω),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(ohm),
						'other' => q({0} Ω),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(ໂວລ),
						'other' => q({0} ໂວລ),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(ໂວລ),
						'other' => q({0} ໂວລ),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(ຫົວ​ໜ່ວຍ​ວັດ​ແທກ​ປະ​ລິ​ມານ​ຄວາມ​ຮ້ອນ​ຂ​ອງ​ອັງ​ກິດ),
						'other' => q({0} ຫົວ​ໜ່ວຍ​ວັດ​ແທກ​ປະ​ລິ​ມານ​ຄວາມ​ຮ້ອນ​ຂ​ອງ​ອັງ​ກິດ),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(ຫົວ​ໜ່ວຍ​ວັດ​ແທກ​ປະ​ລິ​ມານ​ຄວາມ​ຮ້ອນ​ຂ​ອງ​ອັງ​ກິດ),
						'other' => q({0} ຫົວ​ໜ່ວຍ​ວັດ​ແທກ​ປະ​ລິ​ມານ​ຄວາມ​ຮ້ອນ​ຂ​ອງ​ອັງ​ກິດ),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(ແຄລໍລີ່),
						'other' => q({0} ແຄລໍລີ່),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(ແຄລໍລີ່),
						'other' => q({0} ແຄລໍລີ່),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(ເອ​ເລັກ​ຕ​ຣົງ​ໂວນ),
						'other' => q({0} ເອ​ເລັກ​ຕ​ຣົງ​ໂວນ),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(ເອ​ເລັກ​ຕ​ຣົງ​ໂວນ),
						'other' => q({0} ເອ​ເລັກ​ຕ​ຣົງ​ໂວນ),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(ແຄລໍລີ່),
						'other' => q({0} ແຄລໍລີ່),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(ແຄລໍລີ່),
						'other' => q({0} ແຄລໍລີ່),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(joule),
						'other' => q({0} J),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(joule),
						'other' => q({0} J),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(ກິໂລແຄລໍລີ່),
						'other' => q({0} ກິໂລແຄລໍລີ່),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(ກິໂລແຄລໍລີ່),
						'other' => q({0} ກິໂລແຄລໍລີ່),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(kJ),
						'other' => q({0} kJ),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(kJ),
						'other' => q({0} kJ),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(kWh),
						'other' => q({0} kWh),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(kWh),
						'other' => q({0} kWh),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(ກິໂລວັດໂມງຕໍ່ 100 ກິໂລແມັດ),
						'other' => q({0} ກິໂລວັດໂມງຕໍ່ 100 ກິໂລແມັດ),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(ກິໂລວັດໂມງຕໍ່ 100 ກິໂລແມັດ),
						'other' => q({0} ກິໂລວັດໂມງຕໍ່ 100 ກິໂລແມັດ),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(ນິວ​ເຕິນ),
						'other' => q({0} ນິວ​ເຕິນ),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(ນິວ​ເຕິນ),
						'other' => q({0} ນິວ​ເຕິນ),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(ແຮງປ​ອນ),
						'other' => q({0} ແຮງປ​ອນ),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(ແຮງປ​ອນ),
						'other' => q({0} ແຮງປ​ອນ),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(GHz),
						'other' => q({0} GHz),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(GHz),
						'other' => q({0} GHz),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(Hz),
						'other' => q({0} Hz),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(Hz),
						'other' => q({0} Hz),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(kHz),
						'other' => q({0} kHz),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(kHz),
						'other' => q({0} kHz),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(MHz),
						'other' => q({0} MHz),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(MHz),
						'other' => q({0} MHz),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(ດັອດ),
						'other' => q({0} ດັອດ),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(ດັອດ),
						'other' => q({0} ດັອດ),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(astronomical units),
						'other' => q({0} astronomical units),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(astronomical units),
						'other' => q({0} astronomical units),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(ຊັງຕີແມັດ),
						'other' => q({0} ຊັງຕີແມັດ),
						'per' => q({0} ຕໍ່ຊັງຕີແມັດ),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(ຊັງຕີແມັດ),
						'other' => q({0} ຊັງຕີແມັດ),
						'per' => q({0} ຕໍ່ຊັງຕີແມັດ),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(ເດຊີແມັດ),
						'other' => q({0} ເດຊີແມັດ),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(ເດຊີແມັດ),
						'other' => q({0} ເດຊີແມັດ),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(ftm),
						'other' => q({0} ftm),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(ftm),
						'other' => q({0} ftm),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(ຟຸດ),
						'other' => q({0} ຟຸດ),
						'per' => q({0} ຕໍ່ຟຸດ),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(ຟຸດ),
						'other' => q({0} ຟຸດ),
						'per' => q({0} ຕໍ່ຟຸດ),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(ນິ້ວ),
						'other' => q({0} ນິ້ວ),
						'per' => q({0} ຕໍ່ນິ້ວ),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(ນິ້ວ),
						'other' => q({0} ນິ້ວ),
						'per' => q({0} ຕໍ່ນິ້ວ),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(ກິໂລແມັດ),
						'other' => q({0} ກິໂລແມັດ),
						'per' => q({0} ຕໍ່ກິໂລແມັດ),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(ກິໂລແມັດ),
						'other' => q({0} ກິໂລແມັດ),
						'per' => q({0} ຕໍ່ກິໂລແມັດ),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(ປີແສງ),
						'other' => q({0} ປີແສງ),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(ປີແສງ),
						'other' => q({0} ປີແສງ),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(ແມັດ),
						'other' => q({0} ແມັດ),
						'per' => q({0} ຕໍ່ແມັດ),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(ແມັດ),
						'other' => q({0} ແມັດ),
						'per' => q({0} ຕໍ່ແມັດ),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(micrometers),
						'other' => q({0} micrometers),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(micrometers),
						'other' => q({0} micrometers),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(ໄມລ໌),
						'other' => q({0} ໄມລ໌),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(ໄມລ໌),
						'other' => q({0} ໄມລ໌),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(ໄມລ໌ສະກັງດີນາວຽນ),
						'other' => q({0} ໄມລ໌ສະກັງດີນາວຽນ),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(ໄມລ໌ສະກັງດີນາວຽນ),
						'other' => q({0} ໄມລ໌ສະກັງດີນາວຽນ),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(ມິນລິແມັດ),
						'other' => q({0} ມິນລິແມັດ),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(ມິນລິແມັດ),
						'other' => q({0} ມິນລິແມັດ),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(ນາໂນແມັດ),
						'other' => q({0} ນາໂນແມັດ),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(ນາໂນແມັດ),
						'other' => q({0} ນາໂນແມັດ),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(ໄມລ໌ທະເລ),
						'other' => q({0} ໄມລ໌ທະເລ),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(ໄມລ໌ທະເລ),
						'other' => q({0} ໄມລ໌ທະເລ),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(parsecs),
						'other' => q({0} parsecs),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(parsecs),
						'other' => q({0} parsecs),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(ປິໂກແມັດ),
						'other' => q({0} ປິໂກແມັດ),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(ປິໂກແມັດ),
						'other' => q({0} ປິໂກແມັດ),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(ຈຸດ),
						'other' => q({0} ຈຸດ),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(ຈຸດ),
						'other' => q({0} ຈຸດ),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(ລັດ​ສະ​ໝີ​ດວງ​ຕາ​ເວັນ),
						'other' => q({0} ລັດ​ສະ​ໝີ​ດວງ​ຕາ​ເວັນ),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(ລັດ​ສະ​ໝີ​ດວງ​ຕາ​ເວັນ),
						'other' => q({0} ລັດ​ສະ​ໝີ​ດວງ​ຕາ​ເວັນ),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(ຫລາ),
						'other' => q({0} ຫລາ),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(ຫລາ),
						'other' => q({0} ຫລາ),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(ແຄນເດລາ),
						'other' => q({0} ແຄນເດລາ),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(ແຄນເດລາ),
						'other' => q({0} ແຄນເດລາ),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(ລູເມນ),
						'other' => q({0} ລູເມນ),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(ລູເມນ),
						'other' => q({0} ລູເມນ),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(lux),
						'other' => q({0} lux),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(lux),
						'other' => q({0} lux),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(ຄວາມ​ແຈ້ງດວງ​ຕາ​ເວັນ),
						'other' => q({0} ຄວາມ​ແຈ້ງດວງ​ຕາ​ເວັນ),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(ຄວາມ​ແຈ້ງດວງ​ຕາ​ເວັນ),
						'other' => q({0} ຄວາມ​ແຈ້ງດວງ​ຕາ​ເວັນ),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(CD),
						'other' => q({0} CD),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(CD),
						'other' => q({0} CD),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(ດໍ​ຕັນ),
						'other' => q({0} ດໍ​ຕັນ),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(ດໍ​ຕັນ),
						'other' => q({0} ດໍ​ຕັນ),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(ມວນ​ສານ​ໜ່ວຍ​ໂລກ),
						'other' => q({0} ມວນ​ສານ​ໜ່ວຍ​ໂລກ),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(ມວນ​ສານ​ໜ່ວຍ​ໂລກ),
						'other' => q({0} ມວນ​ສານ​ໜ່ວຍ​ໂລກ),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(ເກຣນ),
						'other' => q({0} ເກຣນ),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(ເກຣນ),
						'other' => q({0} ເກຣນ),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(ກຣາມ),
						'other' => q({0} ກຣາມ),
						'per' => q({0}/g),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(ກຣາມ),
						'other' => q({0} ກຣາມ),
						'per' => q({0}/g),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(ກິໂລກຣາມ),
						'other' => q({0} ກິໂລກຣາມ),
						'per' => q({0}/kg),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(ກິໂລກຣາມ),
						'other' => q({0} ກິໂລກຣາມ),
						'per' => q({0}/kg),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'name' => q(t),
						'other' => q({0} t),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'name' => q(t),
						'other' => q({0} t),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(μg),
						'other' => q({0} μg),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(μg),
						'other' => q({0} μg),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(ມິນລີກຣາມ),
						'other' => q({0} ມິນລີກຣາມ),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(ມິນລີກຣາມ),
						'other' => q({0} ມິນລີກຣາມ),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(ອອນສ),
						'other' => q({0} ອອນສ),
						'per' => q({0} ຕໍ່ ອອນສ),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(ອອນສ),
						'other' => q({0} ອອນສ),
						'per' => q({0} ຕໍ່ ອອນສ),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(oz t),
						'other' => q({0} oz t),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(oz t),
						'other' => q({0} oz t),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(ປອນ),
						'other' => q({0} ປອນ),
						'per' => q({0}/ປອນ),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(ປອນ),
						'other' => q({0} ປອນ),
						'per' => q({0}/ປອນ),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(ມວນ​ສານດວງ​ຕາ​ເວັນ),
						'other' => q({0} ມວນ​ສານດວງ​ຕາ​ເວັນ),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(ມວນ​ສານດວງ​ຕາ​ເວັນ),
						'other' => q({0} ມວນ​ສານດວງ​ຕາ​ເວັນ),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(stones),
						'other' => q({0} stones),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(stones),
						'other' => q({0} stones),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(ໂຕນ),
						'other' => q({0} ໂຕນ),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(ໂຕນ),
						'other' => q({0} ໂຕນ),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0} ຕໍ່ {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0} ຕໍ່ {1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(GW),
						'other' => q({0} GW),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(GW),
						'other' => q({0} GW),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(ແຮງມ້າ),
						'other' => q({0} ແຮງມ້າ),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(ແຮງມ້າ),
						'other' => q({0} ແຮງມ້າ),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(ກິໂລວັດ),
						'other' => q({0} ກິໂລວັດ),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(ກິໂລວັດ),
						'other' => q({0} ກິໂລວັດ),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(MW),
						'other' => q({0} MW),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(MW),
						'other' => q({0} MW),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(mW),
						'other' => q({0} mW),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(mW),
						'other' => q({0} mW),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(ວັດ),
						'other' => q({0} ວັດ),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(ວັດ),
						'other' => q({0} ວັດ),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q(ຕາ{0}),
						'other' => q(ຕາ{0}​),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q(ຕາ{0}),
						'other' => q(ຕາ{0}​),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q({0} ແມັດກ້ອນ),
						'other' => q({0}ກ້ອນ),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q({0} ແມັດກ້ອນ),
						'other' => q({0}ກ້ອນ),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(atmospheres),
						'other' => q({0} atmospheres),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(atmospheres),
						'other' => q({0} atmospheres),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(hectopascals),
						'other' => q({0} hectopascals),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(hectopascals),
						'other' => q({0} hectopascals),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(ນິ້ວໃນບາຫຼອດ),
						'other' => q({0} ນິ້ວໃນບາຫຼອດ),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(ນິ້ວໃນບາຫຼອດ),
						'other' => q({0} ນິ້ວໃນບາຫຼອດ),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(ກິ​ໂລ​ປາ​ສ​ການ),
						'other' => q({0} ກິ​ໂລ​ປາ​ສ​ການ),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(ກິ​ໂລ​ປາ​ສ​ການ),
						'other' => q({0} ກິ​ໂລ​ປາ​ສ​ການ),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(ເມ​ກາ​ປາ​ສ​ການ),
						'other' => q({0} ເມ​ກາ​ປາ​ສ​ການ),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(ເມ​ກາ​ປາ​ສ​ການ),
						'other' => q({0} ເມ​ກາ​ປາ​ສ​ການ),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(ມິນລິບາ),
						'other' => q({0} ມິນລິບາ),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(ມິນລິບາ),
						'other' => q({0} ມິນລິບາ),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(ມິນລີແມັດໃນບາຫຼອດ),
						'other' => q({0} ມິນລີແມັດໃນບາຫຼອດ),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(ມິນລີແມັດໃນບາຫຼອດ),
						'other' => q({0} ມິນລີແມັດໃນບາຫຼອດ),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(ປອນຕໍ່ຕະລາງນິ້້ວ),
						'other' => q({0} ປອນຕໍ່ຕະລາງນິ້້ວ),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(ປອນຕໍ່ຕະລາງນິ້້ວ),
						'other' => q({0} ປອນຕໍ່ຕະລາງນິ້້ວ),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(ກິໂລແມັດຕໍ່ຊົ່ວໂມງ),
						'other' => q({0} ກິໂລແມັດຕໍ່ຊົ່ວໂມງ),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(ກິໂລແມັດຕໍ່ຊົ່ວໂມງ),
						'other' => q({0} ກິໂລແມັດຕໍ່ຊົ່ວໂມງ),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(ນ໋ອດ),
						'other' => q({0} ນ໋ອດ),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(ນ໋ອດ),
						'other' => q({0} ນ໋ອດ),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(ແມັດຕໍ່ນາທີ),
						'other' => q({0} ແມັດຕໍ່ນາທີ),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(ແມັດຕໍ່ນາທີ),
						'other' => q({0} ແມັດຕໍ່ນາທີ),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(ໄມລ໌ຕໍ່ຊົ່ວໂມງ),
						'other' => q({0} ໄມລ໌ຕໍ່ຊົ່ວໂມງ),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(ໄມລ໌ຕໍ່ຊົ່ວໂມງ),
						'other' => q({0} ໄມລ໌ຕໍ່ຊົ່ວໂມງ),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(ອົງສາເຊວຊຽສ),
						'other' => q({0} ອົງສາ ຊີ.),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(ອົງສາເຊວຊຽສ),
						'other' => q({0} ອົງສາ ຊີ.),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(ອົງສາຟາເຣນຮາຍ),
						'other' => q({0} ອົງສາຟາເຣນຮາຍ),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(ອົງສາຟາເຣນຮາຍ),
						'other' => q({0} ອົງສາຟາເຣນຮາຍ),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(ອົງສາເຄວິນ),
						'other' => q({0} ອົງສາເຄວິນ),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(ອົງສາເຄວິນ),
						'other' => q({0} ອົງສາເຄວິນ),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(ນິວ​ເຕິນ​ແມັດ),
						'other' => q({0} ນິວ​ເຕິນ​ແມັດ),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(ນິວ​ເຕິນ​ແມັດ),
						'other' => q({0} ນິວ​ເຕິນ​ແມັດ),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(ປອນ​-ຟຸດ),
						'other' => q({0} ປອນ​-ຟຸດ),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(ປອນ​-ຟຸດ),
						'other' => q({0} ປອນ​-ຟຸດ),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(ac ft),
						'other' => q({0} ac ft),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(ac ft),
						'other' => q({0} ac ft),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(ບາ​ເຣວ),
						'other' => q({0} ບາ​ເຣວ),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(ບາ​ເຣວ),
						'other' => q({0} ບາ​ເຣວ),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(cL),
						'other' => q({0} cL),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(cL),
						'other' => q({0} cL),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(ft³),
						'other' => q({0} ft³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(ft³),
						'other' => q({0} ft³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(in³),
						'other' => q({0} in³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(in³),
						'other' => q({0} in³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(ກິໂລແມັດກ້ອນ),
						'other' => q({0} ກິໂລແມັດກ້ອນ),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(ກິໂລແມັດກ້ອນ),
						'other' => q({0} ກິໂລແມັດກ້ອນ),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(ແມັດກ້ອນ),
						'other' => q({0} ແມັດກ້ອນ),
						'per' => q({0} ຕໍ່ມ³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(ແມັດກ້ອນ),
						'other' => q({0} ແມັດກ້ອນ),
						'per' => q({0} ຕໍ່ມ³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(ໄມລ໌ກ້ອນ),
						'other' => q({0} ໄມລ໌ກ້ອນ),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(ໄມລ໌ກ້ອນ),
						'other' => q({0} ໄມລ໌ກ້ອນ),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(yd³),
						'other' => q({0} yd³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(yd³),
						'other' => q({0} yd³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(cup),
						'other' => q({0} c),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(cup),
						'other' => q({0} c),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(mcup),
						'other' => q({0} metric cups),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(mcup),
						'other' => q({0} metric cups),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(dL),
						'other' => q({0} dL),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(dL),
						'other' => q({0} dL),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ແດຣມ),
						'other' => q({0} ແດຣມ),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ແດຣມ),
						'other' => q({0} ແດຣມ),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(ຢອດ),
						'other' => q({0} ຢອດ),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(ຢອດ),
						'other' => q({0} ຢອດ),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(fl oz),
						'other' => q({0} fl oz),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(fl oz),
						'other' => q({0} fl oz),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(ແກລລອນ),
						'other' => q({0} ແກລລອນ),
						'per' => q({0} ຕໍ່ແກລລອນ),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(ແກລລອນ),
						'other' => q({0} ແກລລອນ),
						'per' => q({0} ຕໍ່ແກລລອນ),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(ແກລລອນອັງກິດ),
						'other' => q({0} ແກລລອນອັງກິດ),
						'per' => q({0}/gal Imp.),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(ແກລລອນອັງກິດ),
						'other' => q({0} ແກລລອນອັງກິດ),
						'per' => q({0}/gal Imp.),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(hL),
						'other' => q({0} hL),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(hL),
						'other' => q({0} hL),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(ລິດ),
						'other' => q({0} ລິດ),
						'per' => q({0} ຕໍ່ລິດ),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(ລິດ),
						'other' => q({0} ລິດ),
						'per' => q({0} ຕໍ່ລິດ),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(ML),
						'other' => q({0} ML),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(ML),
						'other' => q({0} ML),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(mL),
						'other' => q({0} mL),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(mL),
						'other' => q({0} mL),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(ຢິບ),
						'other' => q({0} ຢິບ),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(ຢິບ),
						'other' => q({0} ຢິບ),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(pt),
						'other' => q({0} pt),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(pt),
						'other' => q({0} pt),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(metric pints),
						'other' => q({0} metric pints),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(metric pints),
						'other' => q({0} metric pints),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(qt),
						'other' => q({0} qt),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(qt),
						'other' => q({0} qt),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(tbsp),
						'other' => q({0} tbsp),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(tbsp),
						'other' => q({0} tbsp),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(tsp),
						'other' => q({0} tsp),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(tsp),
						'other' => q({0} tsp),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'' => {
						'name' => q(ທິດທາງ),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(ທິດທາງ),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(ດຊ{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(ດຊ{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(ປກ{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(ປກ{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ຟຕ{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ຟຕ{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(ອຕ{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(ອຕ{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(ຊມ{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(ຊມ{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(ຊຕ{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(ຊຕ{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(ຢຕ{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(ຢຕ{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(ມມ{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(ມມ{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(ມຄ{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(ມຄ{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(ນນ{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(ນນ{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ດກ{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ດກ{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(ທຣ{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(ທຣ{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(ເພຕາ{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(ເພຕາ{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(ອຊ{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(ອຊ{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(ຮຕ{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(ຮຕ{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(ຊ{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(ຊ{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(ຢ{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(ຢ{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(ກມ{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(ກມ{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(ມກ{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(ມກ{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(ກກ{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(ກກ{0}),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'degree' => {
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'area-acre' => {
						'other' => q({0} ac),
					},
					# Core Unit Identifier
					'acre' => {
						'other' => q({0} ac),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'other' => q({0} ຮຕ),
					},
					# Core Unit Identifier
					'hectare' => {
						'other' => q({0} ຮຕ),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'other' => q({0} ft²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'other' => q({0} ft²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(ກມ²),
						'other' => q({0} ກມ²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(ກມ²),
						'other' => q({0} ກມ²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(ແມັດ²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(ແມັດ²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'other' => q({0} mi²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'other' => q({0} mi²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(ອັນ),
						'other' => q({0} ອັນ),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(ອັນ),
						'other' => q({0} ອັນ),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(%),
						'other' => q({0}%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(%),
						'other' => q({0}%),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ລ/ 100 ກມ),
						'other' => q({0} ລ / 100 ກມ),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ລ/ 100 ກມ),
						'other' => q({0} ລ / 100 ກມ),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(mpg UK),
						'other' => q({0} m/gUK),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(mpg UK),
						'other' => q({0} m/gUK),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(ມື້),
						'other' => q({0} ມ.),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(ມື້),
						'other' => q({0} ມ.),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ຊົ່ວໂມງ),
						'other' => q({0} ຊມ),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ຊົ່ວໂມງ),
						'other' => q({0} ຊມ),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ມລວ),
						'other' => q({0} ມລ. ວິ.),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ມລວ),
						'other' => q({0} ມລ. ວິ.),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(ນທ.),
						'other' => q({0} ນທ),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(ນທ.),
						'other' => q({0} ນທ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(ເດືອນ),
						'other' => q({0} ດ.),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(ເດືອນ),
						'other' => q({0} ດ.),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ວິ.),
						'other' => q({0} ວິ),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ວິ.),
						'other' => q({0} ວິ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ອທ.),
						'other' => q({0} ອທ.),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ອທ.),
						'other' => q({0} ອທ.),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(ປີ),
						'other' => q({0} ປ),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(ປີ),
						'other' => q({0} ປ),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'other' => q({0}kWh/100km),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'other' => q({0}kWh/100km),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(ຊມ),
						'other' => q({0} ຊມ),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(ຊມ),
						'other' => q({0} ຊມ),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(ຟຸດ),
						'other' => q({0} ຟ),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(ຟຸດ),
						'other' => q({0} ຟ),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(ນິ້ວ),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(ນິ້ວ),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(ກມ),
						'other' => q({0} ກມ),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(ກມ),
						'other' => q({0} ກມ),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(ປີແສງ),
						'other' => q({0} ປສ),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(ປີແສງ),
						'other' => q({0} ປສ),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(ແມັດ),
						'other' => q({0} ມ),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(ແມັດ),
						'other' => q({0} ມ),
					},
					# Long Unit Identifier
					'length-mile' => {
						'other' => q({0} ໄມ),
					},
					# Core Unit Identifier
					'mile' => {
						'other' => q({0} ໄມ),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(ມມ),
						'other' => q({0} ມມ),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(ມມ),
						'other' => q({0} ມມ),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(ຫລາ),
						'other' => q({0} ຫລາ),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(ຫລາ),
						'other' => q({0} ຫລາ),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(ກຣາມ),
						'other' => q({0} ກຼ),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(ກຣາມ),
						'other' => q({0} ກຼ),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(ກິໂລກຣາມ),
						'other' => q({0} ກລ),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(ກິໂລກຣາມ),
						'other' => q({0} ກລ),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'other' => q({0} ອ),
					},
					# Core Unit Identifier
					'ounce' => {
						'other' => q({0} ອ),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'other' => q({0} ປ),
					},
					# Core Unit Identifier
					'pound' => {
						'other' => q({0} ປ),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'other' => q({0} hp),
					},
					# Core Unit Identifier
					'horsepower' => {
						'other' => q({0} hp),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'other' => q({0} kW),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'other' => q({0} kW),
					},
					# Long Unit Identifier
					'power2' => {
						'other' => q({0}²),
					},
					# Core Unit Identifier
					'power2' => {
						'other' => q({0}²),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(hPA),
						'other' => q({0} hPA),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(hPA),
						'other' => q({0} hPA),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(in Hg),
						'other' => q({0} in Hg),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(in Hg),
						'other' => q({0} in Hg),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(mbar),
						'other' => q({0} mbar),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(mbar),
						'other' => q({0} mbar),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(ກມ/ຊມ),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(ກມ/ຊມ),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'other' => q({0} m/s),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'other' => q({0} m/s),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(°C),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(°C),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(°F),
						'other' => q({0}°F),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(°F),
						'other' => q({0}°F),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'other' => q({0} mi³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'other' => q({0} mi³),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'other' => q({0}dsp-Imp),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'other' => q({0}dsp-Imp),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'other' => q({0} fl oz Im),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'other' => q({0} fl oz Im),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'other' => q({0} galIm),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'other' => q({0} galIm),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(ລິດ),
						'other' => q({0}L),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(ລິດ),
						'other' => q({0}L),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(ທິດທາງ),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(ທິດທາງ),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(ດຊ{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(ດຊ{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(ປກ{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(ປກ{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ຟຕ{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ຟຕ{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(ອຕ{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(ອຕ{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(ຊມ{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(ຊມ{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(ຊຕ{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(ຊຕ{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(ຢຕ{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(ຢຕ{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(ມມ{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(ມມ{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(ມຄ{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(ມຄ{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(ນນ{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(ນນ{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ດກ{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ດກ{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(ທຣ{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(ທຣ{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(ເພຕາ{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(ເພຕາ{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(ອຊ{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(ອຊ{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(ຮຕ{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(ຮຕ{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(ຊ{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(ຊ{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(ຢ{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(ຢ{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(ກມ{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(ກມ{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(ມກ{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(ມກ{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(ກກ{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(ກກ{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(ແຮງຕົກຕາມລຳພັງ),
						'other' => q({0} G),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(ແຮງຕົກຕາມລຳພັງ),
						'other' => q({0} G),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(ແມັດ/ວິນາທີ²),
						'other' => q({0} ມ/ວນທ²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(ແມັດ/ວິນາທີ²),
						'other' => q({0} ມ/ວນທ²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(arcmins),
						'other' => q({0} arcmins),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(arcmins),
						'other' => q({0} arcmins),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(arcsecs),
						'other' => q({0} arcsecs),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(arcsecs),
						'other' => q({0} arcsecs),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(ອົງສາ),
						'other' => q({0} ອົງສາ),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(ອົງສາ),
						'other' => q({0} ອົງສາ),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(radians),
						'other' => q({0} rad),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(radians),
						'other' => q({0} rad),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(rev),
						'other' => q({0} rev),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(rev),
						'other' => q({0} rev),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(ເອເຄີ),
						'other' => q({0} ເອເຄີ),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(ເອເຄີ),
						'other' => q({0} ເອເຄີ),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(ດູ​ນຳ),
						'other' => q({0} ດູ​ນຳ),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(ດູ​ນຳ),
						'other' => q({0} ດູ​ນຳ),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(ເຮັກຕາ),
						'other' => q({0} ຮຕ.),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(ເຮັກຕາ),
						'other' => q({0} ຮຕ.),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(ຊມ²),
						'other' => q({0} ຊມ²),
						'per' => q({0}/ຊມ²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(ຊມ²),
						'other' => q({0} ຊມ²),
						'per' => q({0}/ຊມ²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(ຟຸດ²),
						'other' => q({0} ຟຸດ²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(ຟຸດ²),
						'other' => q({0} ຟຸດ²),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(ນິ້ວ²),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(ນິ້ວ²),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(ກມ²),
						'other' => q({0} ກມ²),
						'per' => q({0}/km²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(ກມ²),
						'other' => q({0} ກມ²),
						'per' => q({0}/km²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(ແມັດ²),
						'other' => q({0} ມ²),
						'per' => q({0}/ມ²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(ແມັດ²),
						'other' => q({0} ມ²),
						'per' => q({0}/ມ²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(sq miles),
						'other' => q({0} mi²),
						'per' => q({0}/mi²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(sq miles),
						'other' => q({0} mi²),
						'per' => q({0}/mi²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(yards²),
						'other' => q({0} yd²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(yards²),
						'other' => q({0} yd²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(ອັນ),
						'other' => q({0} ອັນ),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(ອັນ),
						'other' => q({0} ອັນ),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(ກະຣັດ),
						'other' => q({0} kt),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(ກະຣັດ),
						'other' => q({0} kt),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(mg/dL),
						'other' => q({0} mg/dL),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(mg/dL),
						'other' => q({0} mg/dL),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ມິລິໂມນ/ລິດ),
						'other' => q({0} mmol/L),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ມິລິໂມນ/ລິດ),
						'other' => q({0} mmol/L),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(ເປີເຊັນ),
						'other' => q({0}%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(ເປີເຊັນ),
						'other' => q({0}%),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(ຕໍ່ພັນ),
						'other' => q({0}‰),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(ຕໍ່ພັນ),
						'other' => q({0}‰),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ພາດ/ລ້ານ),
						'other' => q({0} ppm),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ພາດ/ລ້ານ),
						'other' => q({0} ppm),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ລ/ 100 ກມ),
						'other' => q({0} L/100km),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ລ/ 100 ກມ),
						'other' => q({0} L/100km),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(ລ/ກມ),
						'other' => q({0} ລ/ກມ),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(ລ/ກມ),
						'other' => q({0} ລ/ກມ),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(ໄມລ໌/ແກລ),
						'other' => q({0} mpg),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(ໄມລ໌/ແກລ),
						'other' => q({0} mpg),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(ໄມລ໌/ແກລລອນອັງກິດ),
						'other' => q({0} mpg Imp.),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(ໄມລ໌/ແກລລອນອັງກິດ),
						'other' => q({0} mpg Imp.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(bit),
						'other' => q({0} bit),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(bit),
						'other' => q({0} bit),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(byte),
						'other' => q({0} byte),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(byte),
						'other' => q({0} byte),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(Gb),
						'other' => q({0} Gb),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(Gb),
						'other' => q({0} Gb),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(GB),
						'other' => q({0} GB),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(GB),
						'other' => q({0} GB),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(kb),
						'other' => q({0} kb),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(kb),
						'other' => q({0} kb),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(kB),
						'other' => q({0} kB),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(kB),
						'other' => q({0} kB),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Mb),
						'other' => q({0} Mb),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Mb),
						'other' => q({0} Mb),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(MB),
						'other' => q({0} MB),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(MB),
						'other' => q({0} MB),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(PByte),
						'other' => q({0} PB),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(PByte),
						'other' => q({0} PB),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Tb),
						'other' => q({0} Tb),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Tb),
						'other' => q({0} Tb),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(TB),
						'other' => q({0} TB),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(TB),
						'other' => q({0} TB),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(c),
						'other' => q({0} c),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(c),
						'other' => q({0} c),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(ມື້),
						'other' => q({0} ມື້),
						'per' => q({0}/ມື້),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(ມື້),
						'other' => q({0} ມື້),
						'per' => q({0}/ມື້),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(ທົດສະວັດ),
						'other' => q({0} ທົດສະວັດ),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(ທົດສະວັດ),
						'other' => q({0} ທົດສະວັດ),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ຊົ່ວໂມງ),
						'other' => q({0} ຊມ),
						'per' => q({0}/ຊມ),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ຊົ່ວໂມງ),
						'other' => q({0} ຊມ),
						'per' => q({0}/ຊມ),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(μວິ),
						'other' => q({0} μວິ),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(μວິ),
						'other' => q({0} μວິ),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ມິນລີວິ),
						'other' => q({0} ມລວ),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ມິນລີວິ),
						'other' => q({0} ມລວ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(ນທ.),
						'other' => q({0} ນທ),
						'per' => q({0}/ນາທີ),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(ນທ.),
						'other' => q({0} ນທ),
						'per' => q({0}/ນາທີ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(ເດືອນ),
						'other' => q({0} ດ.),
						'per' => q({0}/ເດືອນ),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(ເດືອນ),
						'other' => q({0} ດ.),
						'per' => q({0}/ເດືອນ),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(ນາ​ໂນ​ວິ​),
						'other' => q({0} ນນ​ວິ),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(ນາ​ໂນ​ວິ​),
						'other' => q({0} ນນ​ວິ),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ວິ.),
						'other' => q({0} ວິ),
						'per' => q({0}/ວິ),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ວິ.),
						'other' => q({0} ວິ),
						'per' => q({0}/ວິ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ອາທິດ),
						'other' => q({0} ອທ.),
						'per' => q({0}/ອາທິດ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ອາທິດ),
						'other' => q({0} ອທ.),
						'per' => q({0}/ອາທິດ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(ປີ),
						'other' => q({0} ປີ),
						'per' => q({0}/ປີ),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(ປີ),
						'other' => q({0} ປີ),
						'per' => q({0}/ປີ),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(amp),
						'other' => q({0} A),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(amp),
						'other' => q({0} A),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(mA),
						'other' => q({0} mA),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(mA),
						'other' => q({0} mA),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(ohm),
						'other' => q({0} Ω),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(ohm),
						'other' => q({0} Ω),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(ໂວລ),
						'other' => q({0} ໂວລ),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(ໂວລ),
						'other' => q({0} ໂວລ),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(ຄລ),
						'other' => q({0} ຄລ),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(ຄລ),
						'other' => q({0} ຄລ),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(ຄລ),
						'other' => q({0} ຄລ),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(ຄລ),
						'other' => q({0} ຄລ),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(joule),
						'other' => q({0} J),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(joule),
						'other' => q({0} J),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(ກິໂລແຄລໍລີ່),
						'other' => q({0} ກິໂລແຄລໍລີ່),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(ກິໂລແຄລໍລີ່),
						'other' => q({0} ກິໂລແຄລໍລີ່),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(kJ),
						'other' => q({0} kJ),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(kJ),
						'other' => q({0} kJ),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(kWh),
						'other' => q({0} kWh),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(kWh),
						'other' => q({0} kWh),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(GHz),
						'other' => q({0} GHz),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(GHz),
						'other' => q({0} GHz),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(Hz),
						'other' => q({0} Hz),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(Hz),
						'other' => q({0} Hz),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(kHz),
						'other' => q({0} kHz),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(kHz),
						'other' => q({0} kHz),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(MHz),
						'other' => q({0} MHz),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(MHz),
						'other' => q({0} MHz),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(ດັອດ),
						'other' => q({0} ດັອດ),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(ດັອດ),
						'other' => q({0} ດັອດ),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(au),
						'other' => q({0} au),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(au),
						'other' => q({0} au),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(ຊມ),
						'other' => q({0} ຊມ),
						'per' => q({0}/ຊັງຕີແມັດ),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(ຊມ),
						'other' => q({0} ຊມ),
						'per' => q({0}/ຊັງຕີແມັດ),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(ດມ),
						'other' => q({0} ດມ),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(ດມ),
						'other' => q({0} ດມ),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(ftm),
						'other' => q({0} ftm),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(ftm),
						'other' => q({0} ftm),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(ຟຸດ),
						'other' => q({0} ຟ),
						'per' => q({0}/ຟ),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(ຟຸດ),
						'other' => q({0} ຟ),
						'per' => q({0}/ຟ),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(ນິ້ວ),
						'other' => q({0} ນິ),
						'per' => q({0}/ນິ),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(ນິ້ວ),
						'other' => q({0} ນິ),
						'per' => q({0}/ນິ),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(ກມ),
						'other' => q({0} ກມ),
						'per' => q({0}/ກມ),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(ກມ),
						'other' => q({0} ກມ),
						'per' => q({0}/ກມ),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(ປີແສງ),
						'other' => q({0} ປສ),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(ປີແສງ),
						'other' => q({0} ປສ),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(ແມັດ),
						'other' => q({0} ມ),
						'per' => q({0}/ມ),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(ແມັດ),
						'other' => q({0} ມ),
						'per' => q({0}/ມ),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(μm),
						'other' => q({0} μm),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(μm),
						'other' => q({0} μm),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(ໄມລ໌),
						'other' => q({0} ໄມ),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(ໄມລ໌),
						'other' => q({0} ໄມ),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(smi),
						'other' => q({0} smi),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(smi),
						'other' => q({0} smi),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(ມມ),
						'other' => q({0} ມມ),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(ມມ),
						'other' => q({0} ມມ),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(ນມ),
						'other' => q({0} ນມ),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(ນມ),
						'other' => q({0} ນມ),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(nmi),
						'other' => q({0} nmi),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(nmi),
						'other' => q({0} nmi),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(parsecs),
						'other' => q({0} pc),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(parsecs),
						'other' => q({0} pc),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(ປມ),
						'other' => q({0} ປມ),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(ປມ),
						'other' => q({0} ປມ),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(ຈຸດ),
						'other' => q({0} pt),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(ຈຸດ),
						'other' => q({0} pt),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(ຫລາ),
						'other' => q({0} ຫລາ),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(ຫລາ),
						'other' => q({0} ຫລາ),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(lux),
						'other' => q({0} lx),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(lux),
						'other' => q({0} lx),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(CD),
						'other' => q({0} CD),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(CD),
						'other' => q({0} CD),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(gr),
						'other' => q({0} gr),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(gr),
						'other' => q({0} gr),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(ກຣາມ),
						'other' => q({0} ກຼ),
						'per' => q({0}/g),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(ກຣາມ),
						'other' => q({0} ກຼ),
						'per' => q({0}/g),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(ກິໂລກຣາມ),
						'other' => q({0} ກິໂລ),
						'per' => q({0}/kg),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(ກິໂລກຣາມ),
						'other' => q({0} ກິໂລ),
						'per' => q({0}/kg),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'name' => q(t),
						'other' => q({0} t),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'name' => q(t),
						'other' => q({0} t),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(μg),
						'other' => q({0} μg),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(μg),
						'other' => q({0} μg),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(ມກ),
						'other' => q({0} ມກ),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(ມກ),
						'other' => q({0} ມກ),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(ອອນສ),
						'other' => q({0} ອ),
						'per' => q({0}/ອ),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(ອອນສ),
						'other' => q({0} ອ),
						'per' => q({0}/ອ),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(oz t),
						'other' => q({0} oz t),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(oz t),
						'other' => q({0} oz t),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(ປອນ),
						'other' => q({0} ປ),
						'per' => q({0}/ປ),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(ປອນ),
						'other' => q({0} ປ),
						'per' => q({0}/ປ),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(ຕ),
						'other' => q({0} ຕ),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(ຕ),
						'other' => q({0} ຕ),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(GW),
						'other' => q({0} GW),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(GW),
						'other' => q({0} GW),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(ແຮງມ້າ),
						'other' => q({0} hp),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(ແຮງມ້າ),
						'other' => q({0} hp),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(ກິໂລວັດ),
						'other' => q({0} ກລ. ວັດ),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(ກິໂລວັດ),
						'other' => q({0} ກລ. ວັດ),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(MW),
						'other' => q({0} MW),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(MW),
						'other' => q({0} MW),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(mW),
						'other' => q({0} mW),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(mW),
						'other' => q({0} mW),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(ວັດ),
						'other' => q({0} ວັດ),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(ວັດ),
						'other' => q({0} ວັດ),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(atm),
						'other' => q({0} atm),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(atm),
						'other' => q({0} atm),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(hPA),
						'other' => q({0} hPA),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(hPA),
						'other' => q({0} hPA),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(in Hg),
						'other' => q({0} in Hg),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(in Hg),
						'other' => q({0} in Hg),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(mbar),
						'other' => q({0} mbar),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(mbar),
						'other' => q({0} mbar),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(mm Hg),
						'other' => q({0} mm Hg),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(mm Hg),
						'other' => q({0} mm Hg),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(psi),
						'other' => q({0} psi),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(psi),
						'other' => q({0} psi),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(ກມ/ຊມ),
						'other' => q({0} ກມ/ຊມ),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(ກມ/ຊມ),
						'other' => q({0} ກມ/ຊມ),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(kn),
						'other' => q({0} kn),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(kn),
						'other' => q({0} kn),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(ແມັດ/ນທ.),
						'other' => q({0} ມ/ນທ.),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(ແມັດ/ນທ.),
						'other' => q({0} ມ/ນທ.),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(ໄມລ໌/ຊົ່ວໂມງ),
						'other' => q({0} ມ/ຊມ),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(ໄມລ໌/ຊົ່ວໂມງ),
						'other' => q({0} ມ/ຊມ),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(ອົງ​ສາ ຊ.),
						'other' => q({0} ອົງສາ ຊີ.),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(ອົງ​ສາ ຊ.),
						'other' => q({0} ອົງສາ ຊີ.),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(ອົງ​ສາ ຟ.),
						'other' => q({0} ອົງສາ ຟ.),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(ອົງ​ສາ ຟ.),
						'other' => q({0} ອົງສາ ຟ.),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(ອົງສາ ເຄ.),
						'other' => q({0}°K),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(ອົງສາ ເຄ.),
						'other' => q({0}°K),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(ac ft),
						'other' => q({0} ac ft),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(ac ft),
						'other' => q({0} ac ft),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(cL),
						'other' => q({0} cL),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(cL),
						'other' => q({0} cL),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(ft³),
						'other' => q({0} ft³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(ft³),
						'other' => q({0} ft³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(in³),
						'other' => q({0} in³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(in³),
						'other' => q({0} in³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(ກມ³),
						'other' => q({0} ກມ³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(ກມ³),
						'other' => q({0} ກມ³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(ມ³),
						'other' => q({0} ມ³),
						'per' => q({0}/ມ³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(ມ³),
						'other' => q({0} ມ³),
						'per' => q({0}/ມ³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(mi³),
						'other' => q({0} mi³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(mi³),
						'other' => q({0} mi³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(yd³),
						'other' => q({0} yd³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(yd³),
						'other' => q({0} yd³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(cup),
						'other' => q({0} c),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(cup),
						'other' => q({0} c),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(mcup),
						'other' => q({0} mc),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(mcup),
						'other' => q({0} mc),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(dL),
						'other' => q({0} dL),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(dL),
						'other' => q({0} dL),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(dr fl),
						'other' => q({0} dr fl),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(dr fl),
						'other' => q({0} dr fl),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(ຢອດ),
						'other' => q({0} ຢອດ),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(ຢອດ),
						'other' => q({0} ຢອດ),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(fl oz),
						'other' => q({0} fl oz),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(fl oz),
						'other' => q({0} fl oz),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(ແກລລອນ),
						'other' => q({0} ແກລລອນ),
						'per' => q({0}/ແກລລອນ),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(ແກລລອນ),
						'other' => q({0} ແກລລອນ),
						'per' => q({0}/ແກລລອນ),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(Imp. gal),
						'other' => q({0} gal Imp.),
						'per' => q({0}/gal Imp.),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(Imp. gal),
						'other' => q({0} gal Imp.),
						'per' => q({0}/gal Imp.),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(hL),
						'other' => q({0} hL),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(hL),
						'other' => q({0} hL),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(ລິດ),
						'other' => q({0} L),
						'per' => q({0}/l),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(ລິດ),
						'other' => q({0} L),
						'per' => q({0}/l),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(ML),
						'other' => q({0} ML),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(ML),
						'other' => q({0} ML),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(mL),
						'other' => q({0} mL),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(mL),
						'other' => q({0} mL),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(ຢິບ),
						'other' => q({0} ຢິບ),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(ຢິບ),
						'other' => q({0} ຢິບ),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(pt),
						'other' => q({0} pt),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(pt),
						'other' => q({0} pt),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(mpt),
						'other' => q({0} mpt),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(mpt),
						'other' => q({0} mpt),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(qt),
						'other' => q({0} qt),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(qt),
						'other' => q({0} qt),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(tbsp),
						'other' => q({0} tbsp),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(tbsp),
						'other' => q({0} tbsp),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(tsp),
						'other' => q({0} tsp),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(tsp),
						'other' => q({0} tsp),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'laoo',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q(.),
			'infinity' => q(∞),
			'list' => q(;),
			'nan' => q(ບໍ່​ແມ່ນ​ໂຕ​ເລກ),
			'perMille' => q(‰),
			'percentSign' => q(%),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'other' => '0 ພັນ',
				},
				'10000' => {
					'other' => '00 ພັນ',
				},
				'100000' => {
					'other' => '0 ແສນ',
				},
				'1000000' => {
					'other' => '0 ລ້ານ',
				},
				'10000000' => {
					'other' => '00 ລ້ານ',
				},
				'100000000' => {
					'other' => '000 ລ້ານ',
				},
				'1000000000' => {
					'other' => '0 ຕື້',
				},
				'10000000000' => {
					'other' => '00 ຕື້',
				},
				'100000000000' => {
					'other' => '000 ຕື້',
				},
				'1000000000000' => {
					'other' => '0 ລ້ານລ້ານ',
				},
				'10000000000000' => {
					'other' => '00 ລ້ານລ້ານ',
				},
				'100000000000000' => {
					'other' => '000 ລ້ານລ້ານ',
				},
			},
			'short' => {
				'1000' => {
					'other' => '0 ພັນ',
				},
				'10000' => {
					'other' => '00 ພັນ',
				},
				'100000' => {
					'other' => '000 ກີບ',
				},
				'1000000' => {
					'other' => '0 ລ້ານ',
				},
				'10000000' => {
					'other' => '00 ລ້ານ',
				},
				'100000000' => {
					'other' => '000 ລ້ານ',
				},
				'1000000000' => {
					'other' => '0 ຕື້',
				},
				'10000000000' => {
					'other' => '00 ຕື້',
				},
				'100000000000' => {
					'other' => '000 ຕື້',
				},
				'1000000000000' => {
					'other' => '0 ລ້ານລ້ານ',
				},
				'10000000000000' => {
					'other' => '00ລລ',
				},
				'100000000000000' => {
					'other' => '000ລລ',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '¤-#,##0.00',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'negative' => '¤-#,##0.00',
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(ເປເຊຕາ ອັນໂດລາ),
			},
		},
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(ສະ​ຫະ​ລັດ​ອາ​ຣັບ​ອາ​ມິ​ເຣດ ເດີ​ແຮມ),
				'other' => q(ສະ​ຫະ​ລັດ​ອາ​ຣັບ​ອາ​ມິ​ເຣດ ເດີ​ແຮມ),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(ອັບການິ ອັບການິສະຖານ \(1927–2002\)),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(ອັຟ​ກັນ ອັຟ​ກາ​ນິ),
				'other' => q(ອັຟ​ກັນ ອັຟ​ກາ​ນິ),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(ອັລ​ບາ​ນຽນ ເລກ),
				'other' => q(ອັລ​ບາ​ນຽນ ເລກ),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(ອາ​ເມ​ນຽນ ແດຣມ),
				'other' => q(ອາ​ເມ​ນຽນ ແດຣມ),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(ເນ​ເທີ​ແລນ ແອນ​ຕິ​ລຽນ ກິວ​ເດີ),
				'other' => q(ເນ​ເທີ​ແລນ ແອນ​ຕິ​ລຽນ ກິວ​ເດີ),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(ແອງ​ໂກ​ລັນ ຄວນ​ຊາ),
				'other' => q(ແອງ​ໂກ​ລັນ ຄວນ​ຊາ),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(ກວານຊາ ແອງໂກລາ \(1977–1991\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(ກວານຊາ ແອງໂກລາ ໃໝ່ \(1995–1999\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(ກວານຊາກທີ່ແກ້ໄຂໃໝ່ ແອງກູລາ \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(ອອສຕຣານ ອາກຊັງຕິນ),
			},
		},
		'ARL' => {
			display_name => {
				'currency' => q(ເປໂຊເລ ອາກຊັງຕິນ \(1970–1983\)),
			},
		},
		'ARM' => {
			display_name => {
				'currency' => q(ເປໂຊ ອາກຊັງຕິນ \(1881–1970\)),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(ເປໂຊ ອາກຊັງຕິນ \(1983–1985\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(ອາ​ເຈນ​ທິ​ນາ ເປ​ໂຊ),
				'other' => q(ອາ​ເຈນ​ທິ​ນາ ເປ​ໂຊ),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(ຊິລລິງ ອົດສະຕາລີ),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ອອສ​ເຕຣ​ລຽນ ໂດ​ລ່າ),
				'other' => q(ອອສ​ເຕຣ​ລຽນ ໂດ​ລ່າ),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(ອະຣູແບນ ຟລໍຣິນ),
				'other' => q(ອະຣູແບນ ຟລໍຣິນ),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(ມານັດ ອາແຊກບາຍຊານ \(1993–2006\)),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(ອາ​ເຊີ​ໄບ​ຈາ​ນິ ມາ​ນັດ),
				'other' => q(ອາ​ເຊີ​ໄບ​ຈາ​ນິ ມາ​ນັດ),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(ດີນາ ບອສເນຍ ເຮີເຊໂບວາເນຍ \(1992–1994\)),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(ບອ​ສ​ເນຍ-ເຮີ​ເຊ​ໂກວິ​ນາ ຄອນ​ເວີດ​ຕິ​ໂບ ມາກ),
				'other' => q(ບອ​ສ​ເນຍ-ເຮີ​ເຊ​ໂກວິ​ນາ ຄອນ​ເວີດ​ຕິ​ໂບ ມາກ),
			},
		},
		'BAN' => {
			display_name => {
				'currency' => q(ດີນາໃໝ່ ບອສເນຍ ເຮີເຊໂບວີນາ\(1994–1997\)),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(ໂດລ່າ ບາບາດຽນ),
				'other' => q(ໂດລ່າ ບາບາດຽນ),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(ບັງ​ຄລາ​ເທດ ຕາ​ກາ),
				'other' => q(ບັງ​ຄລາ​ເທດ ຕາ​ກາ),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(ຟຣັງ ບູນກາລີ \(ປ່ຽນແປງໄດ້\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(ຟຣັງ ບູນກາລີ),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(ຟຣັງ ບູນກາລີ \(ການເງິນ\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(ຮາດເລບ ບູນກາລີ),
			},
		},
		'BGM' => {
			display_name => {
				'currency' => q(ເລບ ສັງຄົມບູນກາລີ),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(ບັງ​ກາ​ຣຽນ ເລບ),
				'other' => q(ເລບ ບູນກາຣີ),
			},
		},
		'BGO' => {
			display_name => {
				'currency' => q(ເລບ ບູນກາລີ \(1879–1952\)),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(ບາ​ໄຣ​ນິ ດິ​ນາ),
				'other' => q(ບາ​ໄຣ​ນິ ດິ​ນາ),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(ບຸ​ຣັນ​ດຽນ ຟຣັງ),
				'other' => q(ບຸ​ຣັນ​ດຽນ ຟຣັງ),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(ໂດ​ລ່າ​ເບີ​ມິວ​ດາ),
				'other' => q(ໂດ​ລ່າ​ເບີ​ມິວ​ດາ),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(ບຣູ​ໄນ ໂດ​ລ່າ),
				'other' => q(ບຣູ​ໄນ ໂດ​ລ່າ),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(ໂບ​ລິ​ວຽນ ໂບ​ລິ​ເວຍ​ໂນ),
				'other' => q(ໂບ​ລິ​ວຽນ ໂບ​ລິ​ເວຍ​ໂນ),
			},
		},
		'BOL' => {
			display_name => {
				'currency' => q(ໂລລິເວຍໂນ ໂລລິເວຍ \(1863–1963\)),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(ເປໂຊໂລລິເວຍ),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(ມະດອນ ໂລລິເວຍ),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(ກຣູເຊໂດບາຊິ ໃໝ່ \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(ກຣູຊາໂດບາຊິວ \(1986–1989\)),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(ກຣູເຊໂຣ ບາຊິ ກຣູໂຊ ບາຊິວ \(1993–1994\)),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ບຣາ​ຊິ​ລຽນ ຣຽວ),
				'other' => q(ບຣາ​ຊິ​ລຽນ ຣຽວ),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(ກຣູຊາໂດ ບາຊິວ ໃໝ່ \(1989–1990\)),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(ກຣູເຊໂຣ ບາຊິວ \(1993–1994\)),
			},
		},
		'BRZ' => {
			display_name => {
				'currency' => q(ກຣູເຊໂຣ ບາຊິວ \(1942–1967\)),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(ໂດລ່າ ບາຮາມຽນ),
				'other' => q(ໂດລ່າ ບາຮາມຽນ),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(ພູ​ຖານ ງຸນດຣັມ),
				'other' => q(ພູ​ຖານ ງຸນດຣັມ),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(ຈາດ ພະມ້າ),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(ບອດ​ສະ​ວາ​ນານ ພູ​ລາ),
				'other' => q(ບອດ​ສະ​ວາ​ນານ ພູ​ລາ),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(ຣູໂບ ເບຣາຣຸສ ໃໝ່\(1994–1999\)),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(ເບ​ລາ​ຣຸ​ສ​ຊຽນ ຣູ​ເບິນ),
				'other' => q(ເບ​ລາ​ຣຸ​ສ​ຊຽນ ຣູ​ເບິນ),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(ເບ​ລາ​ຣຸ​ສ​ຊຽນ ຣູ​ເບິນ \(2000–2016\)),
				'other' => q(ເບ​ລາ​ຣຸ​ສ​ຊຽນ ຣູ​ເບິນ \(2000–2016\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(ໂດ​ລ່າ​ເບ​ລີຊ),
				'other' => q(ໂດ​ລ່າ​ເບ​ລີຊ),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(ໂດລ່າແຄນາດາ),
				'other' => q(ໂດລ່າແຄນາດາ),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(ຄອງ​ໂກ​ລີສ ຟຣັງ),
				'other' => q(ຄອງ​ໂກ​ລີສ ຟຣັງ),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(ເອີໂຣ WIR),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(ສະ​ວິ​ສ ຟ​ຣັງ),
				'other' => q(ສະ​ວິ​ສ ຟ​ຣັງ),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(ຟຣັງ WIR),
			},
		},
		'CLE' => {
			display_name => {
				'currency' => q(ເອສກູໂດ ຊິລີ),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍບັນຊີ \(UF\) ຊິລີ),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(ຊິ​ລຽນ ເປ​ໂຊ),
				'other' => q(ຊິ​ລຽນ ເປ​ໂຊ),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(ຢວນຈີນ \(ນອກປະເທດ\)),
				'other' => q(ຢວນຈີນ \(ນອກປະເທດ\)),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(ຈີນ ຢວນ),
				'other' => q(ຈີນ ຢວນ),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(ໂຄ​ລົມ​ບຽນ ເປ​ໂຊ),
				'other' => q(ໂຄ​ລົມ​ບຽນ ເປ​ໂຊ),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍຄ່າຈິງ ໂຄລັມເບຍ),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(ໂຄສຕາ ຣິກັນ ໂຄລອນ),
				'other' => q(ໂຄສຕາ ຣິກັນ ໂຄລອນ),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(ດີນາ ເຊີເບຍ \(2002–2006\)),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(ຮາດໂກຣູນາ ເຊັກໂກສະໂລວັກ),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(ຄິວແບນ ຄອນເວີດຕິໂບ ເປໂຊ),
				'other' => q(ຄິວແບນ ຄອນເວີດຕິໂບ ເປໂຊ),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(ຄິວແບນ ເປໂຊ),
				'other' => q(ຄິວແບນ ເປໂຊ),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(ເຄບ ເວີດ​ດີນ ເອ​ສ​ຄູ​ໂດ),
				'other' => q(ເຄບ ເວີດ​ດີນ ເອ​ສ​ຄູ​ໂດ),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(ປອນ ໄຊປຣັດ),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(ເຊກ ໂຄ​ຣູ​ນາ),
				'other' => q(ເຊກ ໂຄ​ຣູ​ນາ),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(ມາກ ເຢຍລະມັນ ຕາເວັນອອກ),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(ມາກ ເຢຍລະມັນ),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(​ດິ​ບູ​ຈຽນ ຟຣັງ),
				'other' => q(​ດິ​ບູ​ຈຽນ ຟຣັງ),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(ແດນ​ນິ​ຊ ໂຄຣນ),
				'other' => q(ແດນ​ນິ​ຊ ໂຄຣນເນີ),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(ໂດ​ມິ​ນິ​ກັນ ເປ​ໂຊ),
				'other' => q(ໂດ​ມິ​ນິ​ກັນ ເປ​ໂຊ),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(ອັລ​ເຈີ​ຣຽນ ດິ​ນາ),
				'other' => q(ອັລ​ເຈີ​ຣຽນ ດິ​ນາ),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(ຊູເກ ເອກາວາດໍ),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍຄ່າຄົງທີ່ຂອງເອກາວາດໍ),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(ຄຣູນເອສ ໂຕເນຍ),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(ອີ​ຢິບ​ທຽນ ພາວດ໌),
				'other' => q(ອີ​ຢິບ​ທຽນ ພາວດ໌),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(ອິ​ຣິ​ທຣຽນ ແນກ​ຟ​າ),
				'other' => q(ອິ​ຣິ​ທຣຽນ ແນກ​ຟ​າ),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(ເປເຊຕາສະເປັນ \(ບັນຊີ\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(ເປເຊຕາສະເປນ \(ປ່ຽນແປງໄດ້\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(ເປເຊຕາ ສະເປນ),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(ເອ​ທິ​ໂອ​ປຽນ ເບີ​ຣ໌),
				'other' => q(ເອ​ທິ​ໂອ​ປຽນ ເບີ​ຣ໌),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ຢູ​ໂຣ),
				'other' => q(ຢູ​ໂຣ),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(ມາກກາ ຟິນແລນ),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(ຟິ​ຈຽນ ໂດ​ລ່າ),
				'other' => q(ຟິ​ຈຽນ ໂດ​ລ່າ),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(ຟອ​ລ໌ກ​ແລນ ໄອ​ແລນ​ສ໌ ພາວ​ດ໌),
				'other' => q(ຟອ​ລ໌ກ​ແລນ ໄອ​ແລນ​ສ໌ ພາວ​ດ໌),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(ຟຣັງ ຝຣັ່ງ),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ອັງກິດ ປອນ),
				'other' => q(ອັງກິດ ປອນ),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(ກູປອນ ລາຣິທ ຈໍເຈຍ),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(ຈໍ​ຈຽນ ລາ​ຣິ),
				'other' => q(ຈໍ​ຈຽນ ລາ​ຣິ),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(ເຊດີ ການາ \(1979–2007\)),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(ກາ​ນາ​ອຽນ ເຊ​ດິ),
				'other' => q(ກາ​ນາ​ອຽນ ເຊ​ດິ),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(ກິບ​ຣາ​ທາ ພາ​ວດ໌),
				'other' => q(ກິບ​ຣາ​ທາ ພາ​ວດ໌),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(​ແກມ​ບຽນ ດາ​ລາ​ຊິ),
				'other' => q(​ແກມ​ບຽນ ດາ​ລາ​ຊິ),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(ກິ​ນຽນ ຟຣັງ),
				'other' => q(ກິ​ນຽນ ຟຣັງ),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(ໄຊລິ ກີນີ),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(ເອັກເວເລ ອີຄວາຕິຣຽວ ກິນີ),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(ດາກຊະມາ ເກຣັກ),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(ກົວເຕມາລານ ເຄັດຊອນ),
				'other' => q(ເຄັດຊອນ),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(ເອສກູໂດ ກີນີໂປຕູເກດ),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(ເປໂຊກິນີ-ບິສເຊົາ),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(ກາຍ​ຢາ​ນີ​ສ ໂດ​ລ່າ),
				'other' => q(ກາຍ​ຢາ​ນີ​ສ ໂດ​ລ່າ),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(ຮອງ​ກົງ ໂດ​ລ່າ),
				'other' => q(ຮອງ​ກົງ ໂດ​ລ່າ),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(ຮອນດູແຣນ ເລມພິຣາ),
				'other' => q(ຮອນດູແຣນ ເລມພິຣາ),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(ດີນາ ໂຄຣເອເຊຍ),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(ໂຄຣ​ເອ​ທຽນ ຄູ​ນາ),
				'other' => q(ໂຄຣ​ເອ​ທຽນ ຄູ​ນາ),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(ໄຮ​ຕຽນ ກົວ​ເດ),
				'other' => q(ໄຮ​ຕຽນ ກົວ​ເດ),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(ຮັງ​ກາ​ຣຽນ ຟໍ​ຣິນ),
				'other' => q(ຮັງ​ກາ​ຣຽນ ຟໍ​ຣິນ),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(ອິນ​ໂດ​ເນ​ຊຽນ ໂດ​ລ່າ),
				'other' => q(ອິນ​ໂດ​ເນ​ຊຽນ ໂດ​ລ່າ),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(ປອນ ໄອຣິຊ),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(ປອນ ອີສະລາເອວ),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(ອິສ​ຣາ​ເອວ​ລິ ນິວ ເຊ​ເກວ),
				'other' => q(ອິສ​ຣາ​ເອວ​ລິ ນິວ ເຊ​ເກວ),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(ອິນ​ເດຍ ຣູ​ປີ),
				'other' => q(ອິນ​ເດຍ ຣູ​ປີ),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(ອິ​ຣັກ​ກິ ດິ​ນາ),
				'other' => q(ອິ​ຣັກ​ກິ ດິ​ນາ),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(ອິ​ຣາ​ນິ ຣຽວ),
				'other' => q(ອິ​ຣາ​ນິ ຣຽວ),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(ໄອ​ສ໌​ແລນ​ດິກ ໂຄຣ​ນາ),
				'other' => q(ໄອ​ສ໌​ແລນ​ດິກ ໂຄຣ​ນາ),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(ລິຣາ ອີຕາລີ),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(​ຈາ​ໄມ​ກັນ ໂດ​ລ່າ),
				'other' => q(​ຈາ​ໄມ​ກັນ ໂດ​ລ່າ),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(ຈໍ​ແດ​ນຽນ ດິ​ນາ),
				'other' => q(ຈໍ​ແດ​ນຽນ ດິ​ນາ),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(ຍີ່​ປຸ່ນ ເຢນ),
				'other' => q(ຍີ່​ປຸ່ນ ເຢນ),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(ເຄນ​ຢັນ ຊິວ​ລິງ),
				'other' => q(ເຄນ​ຢັນ ຊິວ​ລິງ),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(ຄ​ຣີ​ກິສ​​ຖາ​ນິ ໂຊມ),
				'other' => q(ຄ​ຣີ​ກິສ​​ຖາ​ນິ ໂຊມ),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(ກຳ​ປູ​ເຈຍ ຣຽວ),
				'other' => q(ກຳ​ປູ​ເຈຍ ຣຽວ),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(ໂຄ​ໂມ​ຣຽນ ຟຣັງ),
				'other' => q(ໂຄ​ໂມ​ຣຽນ ຟຣັງ),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(ເກົາ​ຫລີ​ເໜືອ ວອນ),
				'other' => q(ເກົາ​ຫລີ​ເໜືອ ວອນ),
			},
		},
		'KRH' => {
			display_name => {
				'currency' => q(ຮາວານ ເກົາຫຼີເນື້),
			},
		},
		'KRO' => {
			display_name => {
				'currency' => q(ວອນ ເກົາຫຼີໃຕ້ \(1945–1953\)),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(ເກົາ​ຫລີໃຕ້ ວອນ),
				'other' => q(ເກົາ​ຫລີໃຕ້ ວອນ),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(ຄູ​ເວ​ຕິ ດິ​ນາ),
				'other' => q(ຄູ​ເວ​ຕິ ດິ​ນາ),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(ເຄ​ແມນ ໄອ​ແລນ ໂດ​ລ່າ),
				'other' => q(ເຄ​ແມນ ໄອ​ແລນ ໂດ​ລ່າ),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(ຄາ​ຊັກ​ສະ​ຖາ​ນິ ເຕັງ​ເຈ),
				'other' => q(ຄາ​ຊັກ​ສະ​ຖາ​ນິ ເຕັງ​ເຈ),
			},
		},
		'LAK' => {
			symbol => '₭',
			display_name => {
				'currency' => q(ລາວ ກີບ),
				'other' => q(ລາວ ກີບ),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(ເລ​ບາ​ນີ​ສ ພາວດ໌),
				'other' => q(ເລ​ບາ​ນີ​ສ ພາວດ໌),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(ສີ​ລັງ​ກາ ຣູ​ປີ),
				'other' => q(ສີ​ລັງ​ກາ ຣູ​ປີ),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(ລິ​ເບີ​ຣຽນ ໂດ​ລ່າ),
				'other' => q(ລິ​ເບີ​ຣຽນ ໂດ​ລ່າ),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(ໂລຕິ ເລໂຊໂຕ),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(ລິ​ທົວ​ນຽນ ລິ​ທັ​ສ),
				'other' => q(ລິ​ທົວ​ນຽນ ລິ​ທັ​ສ),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(ທາໂລນັສ ລິທົວເນຍ),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(ຟຣັງ ລຸກຊຳບວກ ທີ່ປ່ຽນແປງ),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(ຟຣັງ ລຸກຊຳບວກ),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(ຟຣັງ ລຸກຊຳບວກ ການເງິນ),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(ລັດ​ວຽນ ລັດ​ສ໌),
				'other' => q(ລັດ​ວຽນ ລັດ​ຕິ),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(ຣູໂບ ລາວຽນ),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(ລິບ​ບຽນ ດິ​ນາ),
				'other' => q(ລິບ​ບຽນ ດິ​ນາ),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(ມໍ​ຣັອກ​ແຄນ​ ເດີ​ແຮມ),
				'other' => q(ມໍ​ຣັອກ​ແຄນ​ ເດີ​ແຮມ),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(ຟຣັງ ໂມຣອກໂກ),
			},
		},
		'MCF' => {
			display_name => {
				'currency' => q(ຟຣັງ ໂມດາໂກ),
			},
		},
		'MDC' => {
			display_name => {
				'currency' => q(ບັດປັນສ່ວນ ມອງໂດວາ),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(ມອນ​ໂດ​ແວນ ເລ​ອູ),
				'other' => q(ມອນ​ໂດ​ແວນ ເລ​ອູ),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(ມາ​ລາ​ກາ​ຊີ ອາ​ເຣຍ​ຣີ),
				'other' => q(ມາ​ລາ​ກາ​ຊີ ອາ​ເຣຍ​ຣີ),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(ຟຣັງ ມາດາກັດສະກາ),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(ແມັກ​ເຊ​ໂດ​ນຽນ ເດ​ນາ),
				'other' => q(ແມັກ​ເຊ​ໂດ​ນຽນ ເດ​ນາ),
			},
		},
		'MKN' => {
			display_name => {
				'currency' => q(ດີນາ ມາຊີໂດເນຍ \(1992–1993\)),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(ຟຣັງ ມາລີ),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(ມຽນ​ມາ ຈ໊າດ),
				'other' => q(ມຽນ​ມາ ຈ໊າດ),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(ມອງ​ໂກ​ລຽນ ຕູກຣິກ),
				'other' => q(ມອງ​ໂກ​ລຽນ ຕູກຣິກ),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(ມາ​ເກົ້າ ປາ​​ຕາ​ກາ),
				'other' => q(ມາ​ເກົ້າ ປາ​​ຕາ​ກາ),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(ມົວ​ຣິ​ທາ​ນຽນ ອູ​ກິວ​ຢາ \(1973–2017\)),
				'other' => q(ມົວ​ຣິ​ທາ​ນຽນ ອູ​ກິວ​ຢາ \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(ມົວ​ຣິ​ທາ​ນຽນ ອູ​ກິວ​ຢາ),
				'other' => q(ມົວ​ຣິ​ທາ​ນຽນ ອູ​ກິວ​ຢາ),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(ລິຣາ ມອນຕາ),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(ປອນ ມອນຕາ),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(ເມົາ​ຣິ​ທຽນ ຣູ​ປີ),
				'other' => q(ເມົາ​ຣິ​ທຽນ ຣູ​ປີ),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(ມັ​ລ​ດິ​ວຽນ ຣູ​ຟິ​ຢາ),
				'other' => q(ມັ​ລ​ດິ​ວຽນ ຣູ​ຟິ​ຢາ),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(ມາ​ລາ​ວຽນ ຄວາ​ຊາ),
				'other' => q(ມາ​ລາ​ວຽນ ຄວາ​ຊາ),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(ເມັກຊິກັນ ເປໂຊ),
				'other' => q(ເມັກຊິກັນ ເປໂຊ),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍເງິນ ເປໂຊ ແມັກຊິໂກ\(1861–1992\)),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍການລົງທຶນ ແມັກຊິໂກ),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(ມາ​ເລ​ເຊຍ ຣິງ​ກິດ),
				'other' => q(ມາ​ເລ​ເຊຍ ຣິງ​ກິດ),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(ເອສກູໂດ ໂມຊຳບິກ),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(ເມຕິຄໍ ໂມຊຳບິກ \(1980–2006\)),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(ໂມ​ແຊມ​ບິ​ກັນ ເມ​ທິ​ຄອນ),
				'other' => q(ໂມ​ແຊມ​ບິ​ກັນ ເມ​ທິ​ຄອນ),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(ນາ​ມິ​ບຽນ ໂດ​ລ່າ),
				'other' => q(ນາ​ມິ​ບຽນ ໂດ​ລ່າ),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(ໄນ​ຣາ ​ໄນເຈີ​ຣຽນ),
				'other' => q(ໄນ​ຣາ ​ໄນເຈີ​ຣຽນ),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(ຄໍໂດບາ ນິກາຣາກົວ \(1988–1991\)),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(ນິກາຣາກວນ ໂຄໂດບາ),
				'other' => q(ນິກາຣາກວນ ໂຄໂດບາ),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(ກິລເດີ ເນເທີແລນ),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(ນໍ​ເວ​ຈຽນ ​ໂຄຣນ),
				'other' => q(ນໍ​ເວ​ຈຽນ ​ໂຄຣນ),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(ເນ​ປານ ຣູ​ປີ),
				'other' => q(ເນ​ປານ ຣູ​ປີ),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(ນິວ​ຊີ​ແລນ ໂດ​ລ່າ),
				'other' => q(ນິວ​ຊີ​ແລນ ໂດ​ລ່າ),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(ໂອ​ມາ​ນິ ຣຽວ),
				'other' => q(ໂອ​ມາ​ນິ ຣຽວ),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(ພານາມານຽນ ບອນບົວ),
				'other' => q(ພານາມານຽນ ບອນບົວ),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(ອິນຕິ ເປຣູ),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(ເປ​ຣູ​ວຽນ ໂຊ​ລ໌),
				'other' => q(ເປ​ຣູ​ວຽນ ໂຊ​ລ໌),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(ໂຊນ ເປຣູ \(1863–1965\)),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(ປາ​ປົວ ນິວ ກິ​ນຽນ ກິ​ນາ),
				'other' => q(ປາ​ປົວ ນິວ ກິ​ນຽນ ກິ​ນາ),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(ຟິ​ລິບ​ປິນ ເປ​ໂຊ),
				'other' => q(ຟິ​ລິບ​ປິນ ເປ​ໂຊ),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(ປາ​ກິ​ສຖານ ຣູ​ປີ),
				'other' => q(ປາ​ກິ​ສຖານ ຣູ​ປີ),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(ໂປ​ລິ​ຊ ຊະ​ລໍ​ຕີ),
				'other' => q(ໂປ​ລິ​ຊ ຊະ​ລໍ​ຕີ),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(ຊະລອສຕີ ໂປແລນ \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(ເອສກູໂດ ໂປຕູເກສ),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(ກວາຣານີ ປາຣາກວາຍ),
				'other' => q(ກວາຣານີ ປາຣາກວາຍ),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(ຄາ​ຕາ​ຣິ ຣຽວ),
				'other' => q(ຄາ​ຕາ​ຣິ ຣຽວ),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(ດອນລາ ໂຣດີເຊຍ),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(ລິວ ໂຣມາເນຍເກົ່າ),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(ໂຣ​ມາ​ນຽນ ເລ​ອູ),
				'other' => q(ໂຣ​ມາ​ນຽນ ເລ​ອູ),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(ເຊີ​ບຽນ ດິ​ນາ),
				'other' => q(ເຊີ​ບຽນ ດິ​ນາ),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(ຣັສ​ຊຽນ ຣູ​ເບິນ),
				'other' => q(ຣັສ​ຊຽນ ຣູ​ເບິນ),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(ຣູໂບ ຣັດເຊຍ \(1991–1998\)),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(ຣະ​ວັນ​ດັນ ຟຣັງ),
				'other' => q(ຣະ​ວັນ​ດັນ ຟຣັງ),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(ຊາ​ອູ​ດິ ຣິ​ຢອນ),
				'other' => q(ຊາ​ອູ​ດິ ຣິ​ຢອນ),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(ໂຊ​ໂລມອນ ໄອ​ແລນ ໂດ​ລ່າ),
				'other' => q(ໂຊ​ໂລມອນ ໄອ​ແລນ ໂດ​ລ່າ),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(ເຊ​ເຊວ​ລອຍ​ສ໌ ຣູ​ປີ),
				'other' => q(ເຊ​ເຊວ​ລອຍ​ສ໌ ຣູ​ປີ),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(ດີນາ ຊູດານເກົ່າ),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(ຊູ​ດານ​ນີ​ສ ພາວດ໌),
				'other' => q(ຊູ​ດານ​ນີ​ສ ພາວດ໌),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(ປອນ ຊູດານເກົ່າ),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(ສະ​ວີ​ດິ​ຊ ໂຄຣ​ນາ),
				'other' => q(ສະ​ວີ​ດິ​ຊ ໂຄຣ​ນາ),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(ສິງ​ກະ​ໂປ ໂດ​ລ່າ),
				'other' => q(ສິງ​ກະ​ໂປ ໂດ​ລ່າ),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(ເຊນ ເຮ​ເລ​ນາ ພາວດ໌),
				'other' => q(ເຊນ ເຮ​ເລ​ນາ ພາວດ໌),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(ໂຕລາ ສະໂລວິເນຍ),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(ຄູໂຣນາ ສະໂລວັກ),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(ເຊຍ​ນາ ​ເລໂອ​ນຽນ ເລ​ໂອນ),
				'other' => q(ເຊຍ​ນາ ​ເລໂອ​ນຽນ ເລ​ໂອນ),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(ໂຊ​ມາ​ລິ ຊິວ​ລິງ),
				'other' => q(ໂຊ​ມາ​ລິ ຊິວ​ລິງ),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(ຊູ​ຣິ​ນາ​ມີ​ສ ໂດ​ລ່າ),
				'other' => q(ຊູ​ຣິ​ນາ​ມີ​ສ ໂດ​ລ່າ),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(ກິລເດີ ຊູຣິນາເມ),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(ເຊົາ​ທ໌ ຊູ​ດານ​ນີ​ສ ພາວດ໌),
				'other' => q(ເຊົາ​ທ໌ ຊູ​ດານ​ນີ​ສ ພາວດ໌),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(ເຊົາ ໂທ​ເມ ແອນ ພ​ຣິນ​ຊິ​ປີ ໂດບຣາ \(1977–2017\)),
				'other' => q(ເຊົາ ໂທ​ເມ ແອນ ພ​ຣິນ​ຊິ​ປີ ໂດບຣາ \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'STN',
			display_name => {
				'currency' => q(ເຊົາ ໂທ​ເມ ແອນ ພ​ຣິນ​ຊິ​ປີ ໂດບຣາ),
				'other' => q(ເຊົາ ໂທ​ເມ ແອນ ພ​ຣິນ​ຊິ​ປີ ໂດບຣາ),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(ຣູໂບ ໂຊວຽດ),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(ໂກລອງ ເອກາວາດໍ),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(ຊີ​ຣຽນ ພາວດ໌),
				'other' => q(ຊີ​ຣຽນ ພາວດ໌),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(ສະ​ວາ​ຊິ ລິ​ລັນ​ກິ​ນີ),
				'other' => q(ສະ​ວາ​ຊິ ລິ​ລັນ​ກິ​ນີ),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(ໄທ ບາດ),
				'other' => q(ໄທ ບາດ),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(ຣູໂບ ຕັຈີກິສຖານ),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(ທາ​ຈິ​ກິ​​ຖາ​ນິ ໂຊ​ໂມ​ນິ),
				'other' => q(ທາ​ຈິ​ກິ​​ຖາ​ນິ ໂຊ​ໂມ​ນິ),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(ມານັດ ຕວກເມນິສຖານ \(1966–1987\)),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(ເຕີກ​ເມ​ນິ​ສ​ຖາ​ນິ ມາ​ນັດ),
				'other' => q(ເຕີກ​ເມ​ນິ​ສ​ຖາ​ນິ ມາ​ນັດ),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(ຕູ​ນິ​ຊຽນ ດິ​ນາ),
				'other' => q(ຕູ​ນິ​ຊຽນ ດິ​ນາ),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(ຕອງ​ກັນ ປາ​ອັງ​ກາ),
				'other' => q(ຕອງ​ກັນ ປາ​ອັງ​ກາ),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(ເອສກູໂດ ຕີມໍ),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(ລີຕາ ຕູຣາກີເກົ່າ),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(ເຕີ​ກິ​ຊ ລິ​ຣາ),
				'other' => q(ເຕີ​ກິ​ຊ ລິ​ຣາ),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(ທ​ຣິ​ນິ​ແດດ & ໂທ​ບາ​ໂກ ໂດ​ລ່າ),
				'other' => q(ທ​ຣິ​ນິ​ແດດ & ໂທ​ບາ​ໂກ ໂດ​ລ່າ),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(ນິວ ໄຕ້​ຫວັນ ໂດ​ລ່າ),
				'other' => q(ນິວ ໄຕ້​ຫວັນ ໂດ​ລ່າ),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(ທານ​ຊາ​ນຽນ ຊິວ​ລິງ),
				'other' => q(ທານ​ຊາ​ນຽນ ຊິວ​ລິງ),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(ຢູ​ເຄຣ​ນຽນ ຮະ​ຣີບ​ເນຍ),
				'other' => q(ຢູ​ເຄຣ​ນຽນ ຮະ​ຣີບ​ເນຍ),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(ຄາໂບວາເນດ ອູແກຣນ),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(ຊິນລິງ ອູກັນດາ \(1966–1987\)),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(ອູ​ກັນ​ດັນ ຊິວ​ລິງ),
				'other' => q(ອູ​ກັນ​ດັນ ຊິວ​ລິງ),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(​ໂດ​ລ່າ​ສະ​ຫະ​ລັດຯ),
				'other' => q(​ໂດ​ລ່າ​ສະ​ຫະ​ລັດຯ),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(ດອນລາສະຫະລັດ \(ມື້ຖັດໄປ\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(ດອນລາສະຫະລັດ \(ມື້ດຽວກັນ\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(ເປໂຊອູຣຸກວຍ \(ຫົວໜ່ວຍອິນເດັກ\)),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(ເປໂຊ ອູຣຸກວຍ \(1975–1993\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(ອູ​ຣຸ​ກົວ​ຢານ ເປ​ໂຊ),
				'other' => q(ອູ​ຣຸ​ກົວ​ຢານ ເປ​ໂຊ),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(ອຸສເບກິສຖານິ ໂຊມ),
				'other' => q(ອຸສເບກິສຖານິ ໂຊມ),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(ໂບລີວາ ເວເນຊູເອລາ \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(ເວ​ເນ​ຊູ​ເອ​ລັນ ໂບ​ລິ​ວາ \(2008–2018\)),
				'other' => q(ເວເນຊູເອລັນ ໂບລິວາສ໌),
			},
		},
		'VES' => {
			symbol => 'VES',
			display_name => {
				'currency' => q(ເວ​ເນ​ຊູ​ເອ​ລັນ ໂບ​ລິ​ວາ),
				'other' => q(ເວ​ເນ​ຊູ​ເອ​ລັນ ໂບ​ລິ​ວາ),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ຫວຽດ​ນາມ ດົງ),
				'other' => q(ຫວຽດ​ນາມ ດົງ),
			},
		},
		'VNN' => {
			display_name => {
				'currency' => q(ດົງ ຫວຽດນາມ \(1978–1985\)),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(​ວາ​ນົວ​ຕູ ວາ​ຕູ),
				'other' => q(​ວາ​ນົວ​ຕູ ວາ​ຕູ),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(ຊາ​ໂມນ ທາ​ລາ),
				'other' => q(ຊາ​ໂມນ ທາ​ລາ),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(ສາທາລະນະລັດອາຟຣິກາກາງ),
				'other' => q(ຟຣັງ ເຊຟານ ທະນາຄານລັດອາຟຣິກາກາງ),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(ເງິນ),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(ຄຳ),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍຄອມໂປຊິດ ເອີຣົບ),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍໂມນີແທຣີ ເອີຣົບ),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍບັນຊີເອີຣົບ \(XBC\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍບັນຊີເອີຣົບ \(XBD\)),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(ອີ​ສ ຄາ​ຣິ​ບຽນ ໂດ​ລ່າ),
				'other' => q(ອີ​ສ ຄາ​ຣິ​ບຽນ ໂດ​ລ່າ),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(ສິດທິຖອນເງິນພິເສດ),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍສະກຸນເງິນ ເອີຣົບ),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(ຟຣັງ ຄຳຝຣັ່ງ),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(ຟຣັງ ຢູໄອຊີ ຝຣັ່ງ),
			},
		},
		'XOF' => {
			symbol => 'F CFA',
			display_name => {
				'currency' => q(ຟັງເຊຟານ ອາຟຣິກາຕາເວັນຕົກ),
				'other' => q(ຟັງເຊຟານ ອາຟຣິກາຕາເວັນຕົກ),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(ແພເລດຽມ),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(ຊີ​ເອັບ​ພີ ຟຣັງ),
				'other' => q(ຊີ​ເອັບ​ພີ ຟຣັງ),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(ແພລັດຕິນຳ),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(ກອງທຶນໄຣເນັດ),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(ລະຫັດທົດສອບສະກຸນເງິນ),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(ສະກຸນເງິນທີ່ບໍ່ຮູ້ຈັກ),
				'other' => q(\(ສະກຸນເງິນທີ່ບໍ່ຮູ້ຈັກ\)),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(ດີນາ ເຢເມນ),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(ເຢ​ເມ​ນິ ຣຽວ),
				'other' => q(ເຢ​ເມ​ນິ ຣຽວ),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(ຮາດດີນາ ຢູໂກສະລາວີ),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(ດີນາໃໝ່ ຢູໂກສະລາວີ \(1994–2002\)),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(ດີນາ ທີ່ປ່ຽນສະພາບ ຢູໂກສະລາວີ \(1990–1992\)),
			},
		},
		'YUR' => {
			display_name => {
				'currency' => q(ດີນາ ປະຕິຮູບ ຢູໂກສະລາວີ \(1992–1993\)),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(ແຣນ ອາຟຣິກາໃຕ້ \(ການເງິນ\)),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(ເຊົາທ໌ ອາ​ຟຣິ​ກັນ ແຣນດ໌),
				'other' => q(ເຊົາທ໌ ອາ​ຟຣິ​ກັນ ແຣນດ໌),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(ຄວາຊາ ຊັມເບຍ \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(ແຊມ​ບຽນ ຄວາ​ຊາ),
				'other' => q(ແຊມ​ບຽນ ຄວາ​ຊາ),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(ແຊ ຄອງໂກໃໝ່),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(ແຊຄອງໂກ),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(ດອນລາ ຊິມບັບເວ \(1980–2008\)),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(ດອນລາ ຊິມບັບເວ \(2009\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(ດອນລາ ຊິມບັບເວ \(2008\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'chinese' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
				},
			},
			'coptic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ເທົາ',
							'ບາບາ',
							'ຮາໂຕ',
							'ເຄຍ',
							'ໂທບາ',
							'ອຳເຊີ',
							'ບາລຳຮາດ',
							'ບາລາມູດາ',
							'ບາສຮານ',
							'ເປົານາ',
							'ອີແປບ',
							'ມາສລາ',
							'ນາຊິວ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ເທົາ',
							'ບາບາ',
							'ຮາໂຕ',
							'ເຄຍ',
							'ໂທບາ',
							'ອາເຊີ',
							'ບາລຳຮາດ',
							'ບາລາມູດາ',
							'ບາສຮານ',
							'ເປົານາ',
							'ອີແປບ',
							'ມາສລາ',
							'ນາຊີວ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ເທົາ',
							'ບາບາ',
							'ຮາໂຕ',
							'ເຄຍ',
							'ໂທບາ',
							'ອຳເຊີ',
							'ບາລຳຮາດ',
							'ບາລາມູດາ',
							'ບາສຮານ',
							'ເປົານາ',
							'ອີແປບ',
							'ມາສລາ',
							'ນາຊີວ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ເທົາ',
							'ບາບາ',
							'ຮາໂຕ',
							'ເຄຍ',
							'ໂທບາ',
							'ອຳເຊີ',
							'ບາລຳຮາດ',
							'ບາລາມູດາ',
							'ບາສຮານ',
							'ເປົານາ',
							'ອີແປບ',
							'ມາສລາ',
							'ນາຊີວ'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ແມສເຄີແຣມ',
							'ເຕເກມ',
							'ເຮດາ',
							'ທາຊັສ',
							'ເທີ',
							'ເຍຄາທິດ',
							'ເມກາບິດ',
							'ເມຍເຊຍ',
							'ເຈນບອດ',
							'ເຊເນ',
							'ຮຳເລ',
							'ເນແຮສ໌',
							'ພາກູເມນ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ແມສເຄີແຣມ',
							'ເຕເກມ',
							'ເຮດາ',
							'ທາຊັສ',
							'ເທີ',
							'ເຍຄາທິດ',
							'ເມກາບິດ',
							'ເມຍເຊຍ',
							'ເຈນບອດ',
							'ເຊເນ',
							'ຮຳເລ',
							'ເນແຮສ໌',
							'ພາກູເມນ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ແມສເຄີແຣມ',
							'ເຕເກມ',
							'ເຮດາ',
							'ທາຊັສ',
							'ເທີ',
							'ເຍຄາທິດ',
							'ເມກາບິດ',
							'ເມຍເຊຍ',
							'ເຈນບອດ',
							'ເຊເນ',
							'ຮຳເລ',
							'ເນແຮສ໌',
							'ພາກູເມນ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ແມສເຄີແຣມ',
							'ເຕເກມ',
							'ເຮດາ',
							'ທາຊັສ',
							'ເທີ',
							'ເຍຄາທິດ',
							'ເມກາບິດ',
							'ເມຍເຊຍ',
							'ເຈນບອດ',
							'ເຊເນ',
							'ຮຳເລ',
							'ເນແຮສ໌',
							'ພາກູເມນ'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ມ.ກ.',
							'ກ.ພ.',
							'ມ.ນ.',
							'ມ.ສ.',
							'ພ.ພ.',
							'ມິ.ຖ.',
							'ກ.ລ.',
							'ສ.ຫ.',
							'ກ.ຍ.',
							'ຕ.ລ.',
							'ພ.ຈ.',
							'ທ.ວ.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ມັງກອນ',
							'ກຸມພາ',
							'ມີນາ',
							'ເມສາ',
							'ພຶດສະພາ',
							'ມິຖຸນາ',
							'ກໍລະກົດ',
							'ສິງຫາ',
							'ກັນຍາ',
							'ຕຸລາ',
							'ພະຈິກ',
							'ທັນວາ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ມ.ກ.',
							'ກ.ພ.',
							'ມ.ນ.',
							'ມ.ສ.',
							'ພ.ພ.',
							'ມິ.ຖ.',
							'ກ.ລ.',
							'ສ.ຫ.',
							'ກ.ຍ.',
							'ຕ.ລ.',
							'ພ.ຈ.',
							'ທ.ວ.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ມັງກອນ',
							'ກຸມພາ',
							'ມີນາ',
							'ເມສາ',
							'ພຶດສະພາ',
							'ມິຖຸນາ',
							'ກໍລະກົດ',
							'ສິງຫາ',
							'ກັນຍາ',
							'ຕຸລາ',
							'ພະຈິກ',
							'ທັນວາ'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ທຣິດຣີ',
							'ເຮວານ',
							'ກິດເລບ',
							'ເຕເວດ',
							'ຊີວັດ',
							'ອາດາ I',
							'ອາດາ',
							'ນິດຊານ',
							'ອີຍາຣ',
							'ສີວານ',
							'ຕາມູ',
							'ເອບ',
							'ອີລູ'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
					wide => {
						nonleap => [
							'ທຣິດຣີ',
							'ເຮວານ',
							'ກິດເລບ',
							'ເຕເວດ',
							'ຊີວັດ',
							'ອາດາ I',
							'ອາດາ',
							'ນິດຊານ',
							'ອີຍາຣ',
							'ສີວານ',
							'ຕາມູ',
							'ເອບ',
							'ອີລູ'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ທຣິດຣີ',
							'ເຮວານ',
							'ກິດເລບ',
							'ເຕເວດ',
							'ຊີວັດ',
							'ອາດາ I',
							'ອາດາ',
							'ນິດຊານ',
							'ອີຍາຣ',
							'ສີວານ',
							'ຕາມູ',
							'ເອບ',
							'ອີລູ'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
					wide => {
						nonleap => [
							'ທຣິດຣີ',
							'ເຮວານ',
							'ກິດເລບ',
							'ເຕເວດ',
							'ຊີວັດ',
							'ອາດາ I',
							'ອາດາ',
							'ນິດຊານ',
							'ອີຍາຣ',
							'ສີວານ',
							'ຕາມູ',
							'ເອບ',
							'ອີລູ'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ຈິຕຣາ',
							'ວິສາຂະ',
							'ເຊດຖາ',
							'ອັດສາ',
							'ສາຣາວານາ',
							'ພະຕຣາ',
							'ອັສວິຊາ',
							'ການຕິກາ',
							'ອັກຣາຮາຢານາ',
							'ປຸສາ',
							'ມາຄະ',
							'ຜາລກຸນີ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ຈິຕຣາ',
							'ວິສາຂະ',
							'ເຊດຖາ',
							'ອັດສາ',
							'ສາຣາວານາ',
							'ພະຕຣາ',
							'ອັສວິຊາ',
							'ການຕິກາ',
							'ອັກຣາຮາຢານາ',
							'ປຸສະຍາ',
							'ມາຄະ',
							'ຜາລກຸນີ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ຈິຕຣາ',
							'ວິສາຂະ',
							'ເຊດຖາ',
							'ອັດສາ',
							'ສາຣາວານາ',
							'ພະຕຣາ',
							'ອັສວິຊາ',
							'ການຕິກາ',
							'ອັກຣາຮາຢານາ',
							'ປຸສະຍາ',
							'ມາຄະ',
							'ຜາລກຸນີ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ຈິຕຣາ',
							'ວິສາຂະ',
							'ເຊດຖາ',
							'ອັດສາ',
							'ສາຣາວານາ',
							'ພະຕຣາ',
							'ອັສວິຊາ',
							'ການຕິກາ',
							'ອັກຣາຮາຢານາ',
							'ປຸສະຍາ',
							'ມາຄະ',
							'ຜາລກຸນີ'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ມຸຮັດ',
							'ເຄາະ',
							'ຮອດບີ 1',
							'ຮອກບີ 2',
							'ນຸມາ 1',
							'ນຸມາ 2',
							'ເຮາະ',
							'ຊະອ໌',
							'ເຮາະມະ',
							'ເຊົາ',
							'ຊຸລກິອຸ',
							'ຊຸລຫິຈ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ມຸຣະຮອມ',
							'ຊາຟາຣ',
							'ຮອດບີ 1',
							'ຮອດບີ 2',
							'ຈຸມາດາ 1',
							'ຈຸມາດາ 2',
							'ຮາຈັບ',
							'ຊະບານ',
							'ຮາມາດອນ',
							'ເຊົາວັດ',
							'ດຸອັດກິດະ',
							'ດຸອັດກິຈະ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ມຸຮັດ',
							'ເຄາະ',
							'ຮອກບີ 1',
							'ຮອກບີ 2',
							'ນຸມາ 1',
							'ນຸມາ 2',
							'ເຮາະ',
							'ຊາ',
							'ເຮາະມະ',
							'ເຊົາ',
							'ຊຸລກິອຸ',
							'ຊຸລຫິຈ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ມຸຣະຮອມ',
							'ຊາຟາຣ',
							'ຮອດບີ 1',
							'ຮອດບີ 2',
							'ຈຸມາດາ 1',
							'ຈຸມາດາ 2',
							'ຮາຈັບ',
							'ຊະບານ',
							'ຮາມາດອນ',
							'ເຊົາວັດ',
							'ດຸອັດກິດະ',
							'ດຸອັດກິຈະ'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ຟາຣວາດິນ',
							'ອໍຣດີບີເຫຣດ',
							'ຄໍຣເດດ',
							'ແຕຣ',
							'ມໍຣເດດ',
							'ຊາຣຫິວາ',
							'ເມີ',
							'ອາບານ',
							'ອາຊາ',
							'ດີຣ',
							'ບຣາມານ',
							'ເອສຟານ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ຟຣາວາດິນ',
							'ອໍຣດີບີເຫຣດ',
							'ຄໍຣເດດ',
							'ແຕຣ',
							'ມໍຣເດດ',
							'ຊາຣຫິວາ',
							'ເມີ',
							'ອາບານ',
							'ອາຊາຣ',
							'ດີຣ',
							'ບຣາແມນ',
							'ເອສຟານ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ຟຣາວາດິນ',
							'ອໍຣດີບີເຫຮດ',
							'ຄໍຣເດດ',
							'ແຕຣ',
							'ມໍຣເດດ',
							'ຊາຣລິວາ',
							'ເມີ',
							'ອາບານ',
							'ອາຊາ',
							'ດີຣ',
							'ບຣາມານ',
							'ເອສຟານ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ຟຣາວາດິນ',
							'ອໍຣດີບີເຫຣດ',
							'ຄໍຣເດດ',
							'ແຕຣ',
							'ມໍຣເດດ',
							'ຊາຣຫິວາ',
							'ເມີ',
							'ອາບານ',
							'ອາຊາຣ',
							'ດີຣ',
							'ບຣາແມນ',
							'ເອສຟານ'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ຈັນ',
						tue => 'ອັງຄານ',
						wed => 'ພຸດ',
						thu => 'ພະຫັດ',
						fri => 'ສຸກ',
						sat => 'ເສົາ',
						sun => 'ອາທິດ'
					},
					narrow => {
						mon => 'ຈ',
						tue => 'ອ',
						wed => 'ພ',
						thu => 'ພຫ',
						fri => 'ສຸ',
						sat => 'ສ',
						sun => 'ອາ'
					},
					short => {
						mon => 'ຈ.',
						tue => 'ອ.',
						wed => 'ພ.',
						thu => 'ພຫ.',
						fri => 'ສຸ.',
						sat => 'ສ.',
						sun => 'ອາ.'
					},
					wide => {
						mon => 'ວັນຈັນ',
						tue => 'ວັນອັງຄານ',
						wed => 'ວັນພຸດ',
						thu => 'ວັນພະຫັດ',
						fri => 'ວັນສຸກ',
						sat => 'ວັນເສົາ',
						sun => 'ວັນອາທິດ'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'ຈັນ',
						tue => 'ອັງຄານ',
						wed => 'ພຸດ',
						thu => 'ພະຫັດ',
						fri => 'ສຸກ',
						sat => 'ເສົາ',
						sun => 'ອາທິດ'
					},
					narrow => {
						mon => 'ຈ',
						tue => 'ອ',
						wed => 'ພ',
						thu => 'ພຫ',
						fri => 'ສຸ',
						sat => 'ສ',
						sun => 'ອາ'
					},
					short => {
						mon => 'ຈ.',
						tue => 'ອ.',
						wed => 'ພ.',
						thu => 'ພຫ.',
						fri => 'ສຸ.',
						sat => 'ສ.',
						sun => 'ອາ.'
					},
					wide => {
						mon => 'ວັນຈັນ',
						tue => 'ວັນອັງຄານ',
						wed => 'ວັນພຸດ',
						thu => 'ວັນພະຫັດ',
						fri => 'ວັນສຸກ',
						sat => 'ວັນເສົາ',
						sun => 'ວັນອາທິດ'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ຕມ1',
						1 => 'ຕມ2',
						2 => 'ຕມ3',
						3 => 'ຕມ4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'ໄຕຣມາດ 1',
						1 => 'ໄຕຣມາດ 2',
						2 => 'ໄຕຣມາດ 3',
						3 => 'ໄຕຣມາດ 4'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'ຕ1',
						1 => 'ຕ2',
						2 => 'ຕ3',
						3 => 'ຕ4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'ໄຕຣມາດ 1',
						1 => 'ໄຕຣມາດ 2',
						2 => 'ໄຕຣມາດ 3',
						3 => 'ໄຕຣມາດ 4'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'chinese') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'japanese') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'roc') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2000;
					return 'morning1' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 500;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{ຕອນບ່າຍ},
					'am' => q{ກ່ອນທ່ຽງ},
					'evening1' => q{ຕອນແລງ},
					'midnight' => q{ທ່ຽງຄືນ},
					'morning1' => q{ຕອນເຊົ້າ},
					'night1' => q{ກາງຄືນ},
					'noon' => q{ຕອນທ່ຽງ},
					'pm' => q{ຫຼັງທ່ຽງ},
				},
				'narrow' => {
					'afternoon1' => q{ຕອນທ່ຽງ},
					'evening1' => q{ຕອນແລງ},
					'midnight' => q{ທ່ຽງຄືນ},
					'morning1' => q{ຕອນເຊົ້າ},
					'night1' => q{ກາງຄືນ},
					'noon' => q{ຕອນທ່ຽງ},
				},
				'wide' => {
					'afternoon1' => q{ຕອນບ່າຍ},
					'am' => q{ກ່ອນທ່ຽງ},
					'evening1' => q{ຕອນແລງ},
					'midnight' => q{ທ່ຽງຄືນ},
					'morning1' => q{ຕອນເຊົ້າ},
					'night1' => q{ຕອນກາງຄືນ},
					'noon' => q{ຕອນທ່ຽງ},
					'pm' => q{ຫຼັງທ່ຽງ},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{ສວຍ},
					'am' => q{ກ່ອນທ່ຽງ},
					'evening1' => q{ແລງ},
					'midnight' => q{ທ່ຽງ​ຄືນ},
					'morning1' => q{​ເຊົ້າ},
					'night1' => q{​ກາງ​ຄືນ},
					'noon' => q{ທ່ຽງ},
					'pm' => q{ຫຼັງທ່ຽງ},
				},
				'narrow' => {
					'afternoon1' => q{ສ},
					'evening1' => q{ແລງ},
					'morning1' => q{​ເຊົ້າ},
					'night1' => q{​ກາງ​ຄືນ},
					'noon' => q{ຕອນທ່ຽງ},
				},
				'wide' => {
					'afternoon1' => q{ສວຍ},
					'am' => q{ກ່ອນທ່ຽງ},
					'evening1' => q{ແລງ},
					'midnight' => q{ທ່ຽງຄືນ},
					'morning1' => q{​ເຊົ້າ},
					'night1' => q{​ກາງ​ຄືນ},
					'noon' => q{ຕອນທ່ຽງ},
					'pm' => q{ຫຼັງທ່ຽງ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'ພ.ສ.'
			},
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ກ່ອນ ຄ.ສ.',
				'1' => 'ຄ.ສ.'
			},
			wide => {
				'0' => 'ກ່ອນຄຣິດສັກກະລາດ',
				'1' => 'ຄຣິດສັກກະລາດ'
			},
		},
		'hebrew' => {
			abbreviated => {
				'0' => 'AM'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'ມ.ສ.'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'AH'
			},
		},
		'japanese' => {
			abbreviated => {
				'0' => 'ທະອິກະ (645–650)',
				'1' => 'ຮາກູຊິ (650–671)',
				'2' => 'ຮາກູໂຮ (672–686)',
				'3' => 'ຊູໂຊ (686–701)',
				'4' => 'ທາອິໂຮ (701–704)',
				'5' => 'ເຄອຸງ (704–708)',
				'6' => 'ວະໂດ (708–715)',
				'7' => 'ເຣອິກິ (715–717)',
				'8' => 'ໂຢໂຣ (717–724)',
				'9' => 'ຈິງກິ (724–729)',
				'10' => 'ເທັມປຽວ (729–749)',
				'11' => 'ເທັມປຽວ-ຄໍາໂປ (749–749)',
				'12' => 'ເທັມປຽວ-ໂຊໂຮ (749–757)',
				'13' => 'ເທັມປຽວ-ໂຮຈິ (757–765)',
				'14' => 'ເທັມປຽວ-ຈິງໂງະ (765–767)',
				'15' => 'ຈິງໂງະ-ເຄອຸງ (767–770)',
				'16' => 'ໂຮກິ (770–780)',
				'17' => 'ເທັນ-ໂອ (781–782)',
				'18' => 'ເອັນຣຢາກຸ (782–806)',
				'19' => 'ດາອິໂດ (806–810)',
				'20' => 'ໂກນິນ (810–824)',
				'21' => 'ເທັນໂຊ (824–834)',
				'22' => 'ໂຊວະ (834–848)',
				'23' => 'ກະໂຈ (848–851)',
				'24' => 'ນິນຈູ (851–854)',
				'25' => 'ສະອິໂກະ (854–857)',
				'26' => 'ເທັນນານ (857–859)',
				'27' => 'ໂຈງານ (859–877)',
				'28' => 'ເກັນເກ (877–885)',
				'29' => 'ນິນນາ (885–889)',
				'30' => 'ກໍາປຽວ (889–898)',
				'31' => 'ໂຊຕາອິ (898–901)',
				'32' => 'ເອັນງິ (901–923)',
				'33' => 'ເອັນໂຊ (923–931)',
				'34' => 'ໂຊເຮ (931–938)',
				'35' => 'ເທັນງຽວ (938–947)',
				'36' => 'ເທັນຣຢາກູ (947–957)',
				'37' => 'ເທັນໂຕະກຸ (957–961)',
				'38' => 'ໂອວະ (961–964)',
				'39' => 'ໂກໂຮ (964–968)',
				'40' => 'ອານະ (968–970)',
				'41' => 'ເທັນໂຣະກຸ (970–973)',
				'42' => 'ເທັນ-ເອັນ (973–976)',
				'43' => 'ໂຈເງັນ (976–978)',
				'44' => 'ເທັນເງັນ (978–983)',
				'45' => 'ເອການ (983–985)',
				'46' => 'ການນະ (985–987)',
				'47' => 'ເອ-ເອັນ (987–989)',
				'48' => 'ເອໂຊ (989–990)',
				'49' => 'ໂຊຣຢະກຸ (990–995)',
				'50' => 'ໂຊໂຕະກຸ (995–999)',
				'51' => 'ໂຊໂຮ (999–1004)',
				'52' => 'ການໂກ (1004–1012)',
				'53' => 'ໂຊຫວະ (1012–1017)',
				'54' => 'ການນິງ (1017–1021)',
				'55' => 'ຈິອານ (1021–1024)',
				'56' => 'ມານຈຸ (1024–1028)',
				'57' => 'ໂຊເງັນ (1028–1037)',
				'58' => 'ໂຊເຣຢະກຸ (1037–1040)',
				'59' => 'ໂຊຄິວ (1040–1044)',
				'60' => 'ການໂຕະກຸ (1044–1046)',
				'61' => 'ເອະໂຊ (1046–1053)',
				'62' => 'ເທັນງິ (1053–1058)',
				'63' => 'ໂກເຮ (1058–1065)',
				'64' => 'ຈິເຣຢະກຸ (1065–1069)',
				'65' => 'ເອັນຄິວ (1069–1074)',
				'66' => 'ໂຊະໂຮ (1074–1077)',
				'67' => 'ໂຊະເຣຢະກຸ (1077–1081)',
				'68' => 'ເອໂຊະ (1081–1084)',
				'69' => 'ໂອໂຕະກຸ (1084–1087)',
				'70' => 'ການຈິ (1087–1094)',
				'71' => 'ກາໂຊ (1094–1096)',
				'72' => 'ເອະໂຊະ (1096–1097)',
				'73' => 'ໂຊະໂຕະກຸ (1097–1099)',
				'74' => 'ໂກະວະ (1099–1104)',
				'75' => 'ໂຊະຈິ (1104–1106)',
				'76' => 'ກາໂຊະ (1106–1108)',
				'77' => 'ເທັນນິນ (1108–1110)',
				'78' => 'ເທັນ-ອິ (1110–1113)',
				'79' => 'ເອກິວ (1113–1118)',
				'80' => 'ເຄັນ-ເອ (1118–1120)',
				'81' => 'ໂຮະອານ (1120–1124)',
				'82' => 'ເທັນຈິ (1124–1126)',
				'83' => 'ດາອິຈິ (1126–1131)',
				'84' => 'ເທັນໂຊະ (1131–1132)',
				'85' => 'ໂຊະໂຊະ (1132–1135)',
				'86' => 'ໂຮເອັນ (1135–1141)',
				'87' => 'ເອຈິ (1141–1142)',
				'88' => 'ໂກະຈິ (1142–1144)',
				'89' => 'ເທັນໂຢະ (1144–1145)',
				'90' => 'ຄິວອານ (1145–1151)',
				'91' => 'ນິນເປ (1151–1154)',
				'92' => 'ຄິວຈຸ (1154–1156)',
				'93' => 'ໂຮເຄັນ (1156–1159)',
				'94' => 'ເຮຈິ (1159–1160)',
				'95' => 'ເອເຣຢະກຸ (1160–1161)',
				'96' => 'ໂອໂຊ (1161–1163)',
				'97' => 'ໂຊະການ (1163–1165)',
				'98' => 'ເອມານ (1165–1166)',
				'99' => 'ນິນ-ອານ (1166–1169)',
				'100' => 'ກະໂອ (1169–1171)',
				'101' => 'ໂຊະອານ (1171–1175)',
				'102' => 'ອານເຄັນ (1175–1177)',
				'103' => 'ຈິໂຊະ (1177–1181)',
				'104' => 'ໂຢະວະ (1181–1182)',
				'105' => 'ຈຸເອະ (1182–1184)',
				'106' => 'ເຄັນເຣຢຸກິ (1184–1185)',
				'107' => 'ບັນຈິ (1185–1190)',
				'108' => 'ເກັນຄິວ (1190–1199)',
				'109' => 'ໂຊຈິ (1199–1201)',
				'110' => 'ເກັນນິນ (1201–1204)',
				'111' => 'ເຄັນກິວ (1204–1206)',
				'112' => 'ເກັນ-ເອະ (1206–1207)',
				'113' => 'ໂຊະເຄັນ (1207–1211)',
				'114' => 'ເກັນເຣຢະກຸ (1211–1213)',
				'115' => 'ເກັນໂປະ (1213–1219)',
				'116' => 'ໂຊະກິວ (1219–1222)',
				'117' => 'ໂຈະໂອະ (1222–1224)',
				'118' => 'ເຄັນນິນ (1224–1225)',
				'119' => 'ກາໂຮກຸ (1225–1227)',
				'120' => 'ອານເຕະ (1227–1229)',
				'121' => 'ການກິ (1229–1232)',
				'122' => 'ໂຈະເອະ (1232–1233)',
				'123' => 'ເທັມປຸກຸ (1233–1234)',
				'124' => 'ບັນເຣຢະກຸ (1234–1235)',
				'125' => 'ກາເຕະ (1235–1238)',
				'126' => 'ເຣຢະກຸນິນ (1238–1239)',
				'127' => 'ເອັນ-ໂອ (1239–1240)',
				'128' => 'ນິນຈີ (1240–1243)',
				'129' => 'ຄານເຈນ (1243–1247)',
				'130' => 'ໂຫຈີ (1247–1249)',
				'131' => 'ເຄນໂຊ (1249–1256)',
				'132' => 'ໂຄເຈນ (1256–1257)',
				'133' => 'ໂຊກາ (1257–1259)',
				'134' => 'ໂຊເກນ (1259–1260)',
				'135' => 'ບຸນ-ໂອ (1260–1261)',
				'136' => 'ໂຄໂຊ (1261–1264)',
				'137' => 'ບຸນ-ອີ (1264–1275)',
				'138' => 'ເຄນຈີ (1275–1278)',
				'139' => 'ເຄິນ (1278–1288)',
				'140' => 'ໂຊ (1288–1293)',
				'141' => 'ອິນນິນ (1293–1299)',
				'142' => 'ເຊີນ (1299–1302)',
				'143' => 'ເຄນເຈນ (1302–1303)',
				'144' => 'ຄາເຈນ (1303–1306)',
				'145' => 'ໂຕກູຈິ (1306–1308)',
				'146' => 'ອິນກິ (1308–1311)',
				'147' => 'ໂອໂຊ (1300–1312)',
				'148' => 'ໂຊວາ (1312–1317)',
				'149' => 'ບຸນໂປ (1317–1319)',
				'150' => 'ຈີໂນ (1319–1321)',
				'151' => 'ເຈນກຽວ (1321–1324)',
				'152' => 'ໂຊຊິ (1324–1326)',
				'153' => 'ຄາຣາກິ (1326–1329)',
				'154' => 'ເຈນໂຕກູ (1329–1331)',
				'155' => 'ເຈນໂກ (1331–1334)',
				'156' => 'ເກັມມຸ (1334–1336)',
				'157' => 'ເອັນເຈັນ (1336–1340)',
				'158' => 'ໂກໂກກຸ (1340–1346)',
				'159' => 'ໂຊຊິ (1346–1370)',
				'160' => 'ເຄນໂຕກຸ (1370–1372)',
				'161' => 'ບຸນຊຸ (1372–1375)',
				'162' => 'ເທັນຈຸ (1375–1379)',
				'163' => 'ຄໍຢາກຸ (1379–1381)',
				'164' => 'ໂກວາ (1381–1384)',
				'165' => 'ເຈັນຊຸ (1384–1392)',
				'166' => 'ມີໂຕກຸ (1384–1387)',
				'167' => 'ກາກິ (1387–1389)',
				'168' => 'ຄູ (1389–1390)',
				'169' => 'ມິໂຕກຸ (1390–1394)',
				'170' => 'ໂອອິ (1394–1428)',
				'171' => 'ໂຊໂຊ (1428–1429)',
				'172' => 'ອິກຽວ (1429–1441)',
				'173' => 'ກາກິຊຸ (1441–1444)',
				'174' => 'ບຸນ-ອານ (1444–1449)',
				'175' => 'ໂຫໂຕກຸ (1449–1452)',
				'176' => 'ກຽວໂຕກຸ (1452–1455)',
				'177' => 'ເກໂຊ (1455–1457)',
				'178' => 'ໂຊໂຣກຸ (1457–1460)',
				'179' => 'ຄານໂຊ (1460–1466)',
				'180' => 'ບຸນໂຊ (1466–1467)',
				'181' => 'ໂອນິນ (1467–1469)',
				'182' => 'ບຸນມິ (1469–1487)',
				'183' => 'ໂຊກຽວ (1487–1489)',
				'184' => 'ເອັນໂຕກຸ (1489–1492)',
				'185' => 'ມິໂອ (1492–1501)',
				'186' => 'ບຸນກິ (1501–1504)',
				'187' => 'ອິໂຊ (1504–1521)',
				'188' => 'ໄຕອິ (1521–1528)',
				'189' => 'ກຽວໂຣກຸ (1528–1532)',
				'190' => 'ເທັນມອນ (1532–1555)',
				'191' => 'ໂກຈິ (1555–1558)',
				'192' => 'ອິໂຣກຸ (1558–1570)',
				'193' => 'ເຈັນກິ (1570–1573)',
				'194' => 'ເທັນໂຊ (1573–1592)',
				'195' => 'ບຸນໂຣກຸ (1592–1596)',
				'196' => 'ຄິໂຊ (1596–1615)',
				'197' => 'ເກັນວາ (1615–1624)',
				'198' => 'ຄານ-ອິ (1624–1644)',
				'199' => 'ໂຊໂຊ (1644–1648)',
				'200' => 'ຄຽນ (1648–1652)',
				'201' => 'ຊຸ (1652–1655)',
				'202' => 'ເມຍຢາກຸ (1655–1658)',
				'203' => 'ແມນຈິ (1658–1661)',
				'204' => 'ການບຸນ (1661–1673)',
				'205' => 'ເອັນໂປ (1673–1681)',
				'206' => 'ເທັນວາ (1681–1684)',
				'207' => 'ໂຈກຽວ (1684–1688)',
				'208' => 'ເຈັນໂຣກຸ (1688–1704)',
				'209' => 'ໂຫອິ (1704–1711)',
				'210' => 'ຊຸຕຸກຸ (1711–1716)',
				'211' => 'ກຽວຫຸ (1716–1736)',
				'212' => 'ເຈັນບຸນ (1736–1741)',
				'213' => 'ຄານໂປ (1741–1744)',
				'214' => 'ເອັນກຽວ (1744–1748)',
				'215' => 'ຄານ-ອິນ (1748–1751)',
				'216' => 'ໂຫຢາກຸ (1751–1764)',
				'217' => 'ເມຍວາ (1764–1772)',
				'218' => 'ເອັນ-ອິ (1772–1781)',
				'219' => 'ເທັນມິ (1781–1789)',
				'220' => 'ຄານຊິ (1789–1801)',
				'221' => 'ກຽວວາ (1801–1804)',
				'222' => 'ບຸນກາ (1804–1818)',
				'223' => 'ບຸນຊິ (1818–1830)',
				'224' => 'ເທັນໂປ (1830–1844)',
				'225' => 'ກຸກາ (1844–1848)',
				'226' => 'ກາອິ (1848–1854)',
				'227' => 'ແອັນຊິ (1854–1860)',
				'228' => 'ແມັນ-ເອັນ (1860–1861)',
				'229' => 'ບຸນກຸ (1861–1864)',
				'230' => 'ເຈນຈີ (1864–1865)',
				'231' => 'ຄີໂອ (1865–1868)',
				'232' => 'ມີຈີ',
				'233' => 'ໄຕໂຊ',
				'234' => 'ໂຊວາ',
				'235' => 'ຮີຊີ'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'ປີເປີເຊຍ'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'ກ່ອນ R.O.C.'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
			'full' => q{EEEE, U MMMM dd},
			'long' => q{U MMMM d},
			'medium' => q{U MMM d},
			'short' => q{y-M-d},
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEEທີ d MMMM y G},
			'long' => q{d MMMM y G},
			'medium' => q{d MMM y G},
			'short' => q{d/M/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE ທີ d MMMM G y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{d/M/y},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
			'full' => q{EEEE, y MMMM dd},
			'long' => q{y MMMM d},
			'medium' => q{y MMM d},
			'short' => q{y-MM-dd},
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{H ໂມງ m ນາທີ ss ວິນາທີ zzzz},
			'long' => q{H ໂມງ m ນາທີ ss ວິນາທີ z},
			'medium' => q{H:mm:ss},
			'short' => q{H:mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, MMM d, y G},
			GyMMMd => q{G d MMM y},
			GyMd => q{d/M/GGGGG y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMMd => q{MMMM d},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h ໂມງa},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{G M/y},
			yyyyMEd => q{E, G d/M/y},
			yyyyMMM => q{G MMM y},
			yyyyMMMEd => q{E, G d MMM y},
			yyyyMMMM => q{G MMMM y},
			yyyyMMMd => q{G d MMM y},
			yyyyMd => q{G d/M/y},
			yyyyQQQ => q{G QQQ y},
			yyyyQQQQ => q{G y QQQQ},
		},
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E, d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{MMM, G y},
			GyMMMEd => q{E d MMMM, G y},
			GyMMMd => q{d MMMM, G y},
			GyMd => q{d/M/GGGGG y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMMW => q{ອາທິດທີ່ W ຂອງເດືອນ M},
			MMMMd => q{MMMM d},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h ໂມງa},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{ອາທິດທີ່ w ຂອງປີ Y},
		},
		'islamic' => {
			H => q{H},
			Hm => q{H:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E MMM d},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{ha},
			hm => q{h mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E M/d/y},
			yMMM => q{MMM y},
			yMMMEd => q{E,MMM d,y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			GyM => {
				G => q{GGGGG M/y – GGGGG M/y},
				M => q{GGGGG M/y – M/y},
				y => q{GGGGG M/y – M/y},
			},
			GyMEd => {
				G => q{E, d/M GGGGG y – E, d/M GGGGG y},
				M => q{E, d/M GGGGG y – E, d/M GGGGG y},
				d => q{E, d/M GGGGG y – E, d/M GGGGG y},
			},
			GyMMMEd => {
				G => q{E, d MMM G y – E, d MMM G y},
				M => q{E, d MMM – E, d MMM G y},
				d => q{E, d MMM – E, d MMM G y},
				y => q{E, d MMM G y – E, d MMM G y},
			},
			GyMMMd => {
				G => q{d MMM G y– d MMM G y},
				M => q{d MMM – d MMM G y},
				y => q{d MMM G y– d MMM G y},
			},
			GyMd => {
				G => q{GGGGG d/M/y – GGGGG d/M/y},
				M => q{GGGGG d/M/y – d/M/y},
				d => q{GGGGG d/M/y – d/M/y},
				y => q{GGGGG d/M/y – d/M/y},
			},
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd-MM – E, dd-MM},
				d => q{E, dd-MM – E, dd-MM},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, d-MM – E, d-MM},
				d => q{E, d-MM – E, d-MM},
			},
			MMMd => {
				M => q{d-MM – d-MM},
				d => q{MM-d – d},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{G y–y},
			},
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y GGGGG},
				d => q{E, d/M/y – E, d/M/y GGGGG},
				y => q{E, d/M/y – E, d/M/y GGGGG},
			},
			yMMM => {
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, G dd-MM-y – E, dd-MM-y},
				d => q{E, G dd-MM-y – E, dd-MM-y},
				y => q{E, d MMM y – E, d MMM y G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y G},
				d => q{d–d MMM, y G},
				y => q{d MMM y – d MMM y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y GGGGG},
				d => q{d/M/y – d/M/y GGGGG},
				y => q{d/M/y – d/M/y GGGGG},
			},
		},
		'gregorian' => {
			Gy => {
				G => q{G y – G y},
				y => q{G y–y},
			},
			GyM => {
				G => q{GGGGG MM/y – GGGGG MM/y},
				M => q{GGGGG MM/y – MM/y},
				y => q{GGGGG MM/y – MM/y},
			},
			GyMEd => {
				G => q{GGGGG E, dd/MM/y – GGGGG E, dd/MM/y},
				M => q{GGGGG E, dd/MM/y – E, dd/MM/y},
				d => q{GGGGG E, dd/MM/y – E, dd/MM/y},
				y => q{GGGGG E, dd/MM/y – E, dd/MM/y},
			},
			GyMMM => {
				G => q{G MM/y – G MM/y},
				M => q{G MM/y – MM},
				y => q{G MM/y – MM/y},
			},
			GyMMMEd => {
				G => q{G E, dd/MM/y – G E, dd/MM/y},
				M => q{G E, dd/MM/y – E, dd/MM/y},
				d => q{G E, dd/MM/y – E, dd/MM/y},
				y => q{G E, dd/MM/y – E, dd/MM/y},
			},
			GyMMMd => {
				G => q{G dd/MM/y– G dd/MM/y},
				M => q{G dd/MM/y – dd/MM},
				d => q{G d–d/MM/y},
				y => q{G dd/MM/y – dd/MM/y},
			},
			GyMd => {
				G => q{GGGGG dd/MM/y – GGGGG dd/MM/y},
				M => q{GGGGG dd/MM/y – dd/MM/y},
				d => q{GGGGG dd/MM/y – dd/MM/y},
				y => q{GGGGG dd/MM/y – dd/MM/y},
			},
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd/MM – E, dd/MM},
				d => q{E, dd/MM – E, dd/MM},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{E, d/MM – E, d/MM},
				d => q{E, d/MM – E, d/MM},
			},
			MMMd => {
				M => q{d/MM – d/MM},
				d => q{d/MM – d/MM},
			},
			Md => {
				M => q{dd/MM – dd/MM},
				d => q{dd/MM – dd/MM},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{MM/y – MM/y},
				y => q{y/MM – y/MM},
			},
			yMEd => {
				M => q{E, dd/MM/y – E, dd/MM/y},
				d => q{E, dd/MM/y – E, dd/MM/y},
				y => q{E, dd/MM/y – E, dd/MM/y},
			},
			yMMM => {
				M => q{MM/y – MM/y},
				y => q{MM/y – MM/y},
			},
			yMMMEd => {
				M => q{E, dd/MM/y – E, dd/MM/y},
				d => q{E, dd/MM/y – E, dd/MM/y},
				y => q{E, dd/MM/y – E, dd/MM/y},
			},
			yMMMM => {
				M => q{MM/y – MM},
				y => q{MM/y – MM/y},
			},
			yMMMd => {
				M => q{d/MM/y – d/MM},
				d => q{d/MM/y – d/MM/y},
				y => q{dd/MM/y – dd/MM/y},
			},
			yMd => {
				M => q{dd/MM/y – dd/MM/y},
				d => q{dd/MM/y – dd/MM/y},
				y => q{dd/MM/y – dd/MM/y},
			},
		},
	} },
);

has 'cyclic_name_sets' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
			'dayParts' => {
				'format' => {
					'abbreviated' => {
						0 => q(ຊີ),
						1 => q(ຊູ),
						2 => q(ຢິນ),
						3 => q(ເມົາ),
						4 => q(ເຊັນ),
						5 => q(ຊື່),
						6 => q(ວູ),
						7 => q(ເວີຍ),
						8 => q(ເຊິ່ນ),
						9 => q(ຢູ),
						10 => q(ຊູ່),
						11 => q(ໄຮ),
					},
				},
			},
			'years' => {
				'format' => {
					'abbreviated' => {
						0 => q(ເຈຍ-ຊິ),
						1 => q(ຢີ-ຊູ),
						2 => q(ບິງ-ຢິນ),
						3 => q(ດິງ-ເມົາ),
						4 => q(ວູ-ເຊັນ),
						5 => q(ຈີ-ຊິ),
						6 => q(ແກງ-ວູ),
						7 => q(ຊິນ-ເວີຍ),
						8 => q(ເຣນ-ເຊນ),
						9 => q(ກຸຍ-ຢູ),
						10 => q(ໄຈ-ຊູ),
						11 => q(ຢີ-ໄຮ),
						12 => q(ບິງ-ຊີ),
						13 => q(ດິງ-ຊູ),
						14 => q(ວູ-ຢິນ),
						15 => q(ຈີ-ເມົາ),
						16 => q(ແກງ-ເຊນ),
						17 => q(ຊິນ-ຊິ),
						18 => q(ເຣນ-ວູ),
						19 => q(ກຸຍ-ເວີຍ),
						20 => q(ເຈຍ-ເຊນ),
						21 => q(ຢີ-ຢູ),
						22 => q(ບິງ-ຊູ),
						23 => q(ດິງ-ໄຫ),
						24 => q(ວູ-ຊິ),
						25 => q(ຈີ-ຊູ),
						26 => q(ເກງ-ຢິນ),
						27 => q(ຊິນ-ເມົາ),
						28 => q(ເຣນເຊິ່ນ),
						29 => q(ກຸຍ-ຊິ),
						30 => q(ໄຈ-ວູ),
						31 => q(ຢີ-ເວີຍ),
						32 => q(ບິງ-ເຊນ),
						33 => q(ດິງ-ຢູ),
						34 => q(ວູ-ຊູ),
						35 => q(ຈີ-ໄຫ),
						36 => q(ເກງ-ຊິ),
						37 => q(ຊິນ-ຊູ),
						38 => q(ເຣຍ-ຢິນ),
						39 => q(ກຸຍ-ເມົາ),
						40 => q(ໄຈ-ເຊນ),
						41 => q(ຢີ-ຊິ),
						42 => q(ບິງ-ວູ),
						43 => q(ດິງ-ເວີຍ),
						44 => q(ວູ-ເກນ),
						45 => q(ຈີ-ຢູ),
						46 => q(ເກງ-ຊູ),
						47 => q(ຊິນ-ໄຫ),
						48 => q(ເຣນ-ຊິ),
						49 => q(ກຸຍ-ຊູ),
						50 => q(ເຈຍ-ຢິນ),
						51 => q(ຢິ-ເມົາ),
						52 => q(ບິງເຊິ່ນ),
						53 => q(ດິງ-ຊິ),
						54 => q(ວູ-ວູ),
						55 => q(ຈີ-ເວີຍ),
						56 => q(ເກງ-ເຊນ),
						57 => q(ຊິນ-ຢູ),
						58 => q(ເຣນ-ຊູ),
						59 => q(ກຸຍຮ່າຍ),
					},
				},
			},
			'zodiacs' => {
				'format' => {
					'abbreviated' => {
						0 => q(ໜູ),
						1 => q(ງົວຜູ້),
						2 => q(ເສືອ),
						3 => q(ກະຕ່າຍ),
						4 => q(ມັງກອນ),
						5 => q(ງູ),
						6 => q(ມ້າ),
						7 => q(ແກະ),
						8 => q(ລິງ),
						9 => q(ໄກ່ຜູ້),
						10 => q(ໝາ),
						11 => q(ໝູ),
					},
				},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(ເວລາ {0}),
		regionFormat => q(ເວລາກາງເວັນ {0}),
		regionFormat => q(ເວລາມາດຕະຖານ {0}),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນຂອງອາເກຣ#,
				'generic' => q#ເວລາຂອງອາເກຣ#,
				'standard' => q#ເວລາມາດຕະຖານຂອງອາເກຣ#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#ເວລາ ອັຟການິສຖານ#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#ອາບິດແຈນ#,
		},
		'Africa/Accra' => {
			exemplarCity => q#ອັກຄຣາ#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#ແອດດິສ ອະບາບາ#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#ແອວເຈຍ#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#ອັສມາຣາ#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#ບາມາໂກ#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#ບັງກຸຍ#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#ບານຈູ#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ບິສເຊົາ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ແບລນໄທຣ໌#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ບຣາຊາວິວ#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ບູຈູມບູຣາ#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#ໄຄໂຣ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#ຄາຊາບລັງກາ#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#ຊີວຕາ#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#ໂຄນາຄຣີ#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ດາກາ#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ດາເອສສະລາມ#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ຈີບູຕິ#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ດູອາລາ#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ເອວ ອາຢູນ#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ຟຣີທາວ#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ກາບໍໂຣນ#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ຮາຣາເຣ#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ໂຈຮັນເນດສເບີກ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ຈູບາ#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#ຄຳປາລາ#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ຄາທູມ#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#ຄີກາລີ#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#ກິນຊາຊາ#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ລາໂກສ#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ລິເບຼີວິວ#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ໂລເມ#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ລວນດາ#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ລູບຳບາຊິ#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ລູຊາກາ#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ມາລາໂບ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ມາປູໂຕ#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ມາເຊຣູ#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#ອຳບາບາເນ#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#ໂມກາດີຊູ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#ມອນໂຣເວຍ#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#ໄນໂຣບີ#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ເອນຈາເມນ່າ#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#ນີອາເມ#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#ນູແອກຊອດ#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ອູກາດູກູ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#ປໍໂຕ-ໂນໂວ#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ຊາວໂຕເມ#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ທຣິໂພລິ#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ຕູນິສ#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ວີນຮູດ#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#ເວ​ລາ​ອາ​ຟຣິ​ກາ​ກາງ#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#ເວ​ລາ​ອາ​ຟຣິ​ກາ​ຕາ​ເວັນ​ອອກ#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#ເວ​ລາ​ອາ​ຟຣິ​ກາ​ໃຕ້#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ອາ​ຟຣິ​ກາ​ຕາ​ເວັນ​ຕົກ#,
				'generic' => q#ເວ​ລາ​ອາ​ຟຣິ​ກາ​ຕາ​ເວັນ​ຕົກ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານ​ອາ​ຟຣິ​ກາ​ຕາ​ເວັນ​ຕົກ#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#ເວລາກາງເວັນອະລັສກາ#,
				'generic' => q#ເວລາອະລັສກາ#,
				'standard' => q#ເວລາມາດຕະຖານອະລັສກາ#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນອໍມາຕີ#,
				'generic' => q#ເວລາອໍມາຕີ#,
				'standard' => q#ເວລາມາດຕະຖານອໍມາຕີ#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນອາ​ເມ​ຊອນ#,
				'generic' => q#ເວລາຕາມເຂດອາເມຊອນ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານອາ​ເມ​ຊອນ#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#ອາແດກ#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ແອນເຄີເຣກ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ແອນກິນລາ#,
		},
		'America/Antigua' => {
			exemplarCity => q#ແອນທິກົວ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#ອາຣາກົວນາ#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ລາ ຣິໂອຈາ#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ຣິໂກ ແກວເລກອສ#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#ຊານຕາ#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#ແຊນຮວນ#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#ແຊນລຸຍສ໌#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ຕູຄູແມນ#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ອູຊູເອຍ#,
		},
		'America/Aruba' => {
			exemplarCity => q#ອາຣູບາ#,
		},
		'America/Asuncion' => {
			exemplarCity => q#ອະຊຸນຊິອອງ#,
		},
		'America/Bahia' => {
			exemplarCity => q#ບາເຢຍ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#ບາເຮຍ ແບນເດີຣາສ#,
		},
		'America/Barbados' => {
			exemplarCity => q#ບາເບດອສ#,
		},
		'America/Belem' => {
			exemplarCity => q#ບີເລມ#,
		},
		'America/Belize' => {
			exemplarCity => q#ເບລີຊ#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ບລານ-ຊາບລອນ#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#ບົວ ວິສຕາ#,
		},
		'America/Bogota' => {
			exemplarCity => q#ໂບໂກຕາ#,
		},
		'America/Boise' => {
			exemplarCity => q#ບອຍຊ໌#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ບົວໂນສ ໄອເຣສ#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#ແຄມບຣິດ ເບ#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#ກັງປູຣັງຈີ#,
		},
		'America/Cancun' => {
			exemplarCity => q#ແຄນກຸນ#,
		},
		'America/Caracas' => {
			exemplarCity => q#ຄາຣາກັສ#,
		},
		'America/Catamarca' => {
			exemplarCity => q#ຄາຕາມາກາ#,
		},
		'America/Cayenne' => {
			exemplarCity => q#ຄາເຢນ#,
		},
		'America/Cayman' => {
			exemplarCity => q#ເຄແມນ#,
		},
		'America/Chicago' => {
			exemplarCity => q#ຊິຄາໂກ#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ຊິວາວາ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#ອາທິໂຄຄານ#,
		},
		'America/Cordoba' => {
			exemplarCity => q#ຄໍໂດບາ#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#ຄອສຕາຣິກາ#,
		},
		'America/Creston' => {
			exemplarCity => q#ເຄຣສຕັນ#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#ກຸຢາບາ#,
		},
		'America/Curacao' => {
			exemplarCity => q#ກືຣາເຊົາ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ເດນມາກແຊນ#,
		},
		'America/Dawson' => {
			exemplarCity => q#ດໍສັນ#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ດໍສັນ ຄຣີກ#,
		},
		'America/Denver' => {
			exemplarCity => q#ເດັນເວີ#,
		},
		'America/Detroit' => {
			exemplarCity => q#ດີທຣອຍ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ໂດມິນິກາ#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ເອດມອນຕອນ#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ເອຣຸເນປີ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ເອວ ຊາວາດໍ#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#ຟອດ ເນວສັນ#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ຟໍຕາເລຊາ#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ເກລດເບ#,
		},
		'America/Godthab' => {
			exemplarCity => q#ນູກ#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#ກູສເບ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ແກຣນ ເທີກ#,
		},
		'America/Grenada' => {
			exemplarCity => q#ເກຣນາດາ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ກາວເດລູບ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ກົວເຕມາລາ#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ກົວຢາກິລ#,
		},
		'America/Guyana' => {
			exemplarCity => q#ກູຢານາ#,
		},
		'America/Halifax' => {
			exemplarCity => q#ຮາລິແຟັກ#,
		},
		'America/Havana' => {
			exemplarCity => q#ຮາວານາ#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ເອໂມຊິໂຢ#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ນ໋ອກ, ອິນເດຍນາ#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#ມາເຣນໂກ, ອິນເດຍນາ#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#ປີເຕີສເປີກ, ອິນເດຍນາ#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ເທວ ຊິຕີ, ອິນເດຍນາ#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ວີເວ, ອິນເດຍນາ#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ວິນເຊນເນສ, ອິນເດຍນາ#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ວິນາແມັກ, ອິນເດຍນາ#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ອິນດີເອນາໂພລິສ#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ອີນູວິກ#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ອີກົວລິດ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ຈາໄມກາ#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ຈູຈຸຍ#,
		},
		'America/Juneau' => {
			exemplarCity => q#ຈູໂນ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#ມອນຕີເຊວໂລ, ເຄນທັກກີ#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ຄຣາເລນດິກ#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ລາປາສ#,
		},
		'America/Lima' => {
			exemplarCity => q#ລີມາ#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ລອສແອນເຈລີສ#,
		},
		'America/Louisville' => {
			exemplarCity => q#ຫລຸຍວິວ#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ໂລເວີ ພຣິນຊ໌ ຄວດເຕີ#,
		},
		'America/Maceio' => {
			exemplarCity => q#ມາເຊໂອ#,
		},
		'America/Managua' => {
			exemplarCity => q#ມານາກົວ#,
		},
		'America/Manaus' => {
			exemplarCity => q#ມາເນົາສ໌#,
		},
		'America/Marigot' => {
			exemplarCity => q#ມາຣີໂກດ#,
		},
		'America/Martinique' => {
			exemplarCity => q#ມາທີນິກ#,
		},
		'America/Matamoros' => {
			exemplarCity => q#ມາຕາໂມຣອສ#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#ມາຊາດລານ#,
		},
		'America/Mendoza' => {
			exemplarCity => q#ເມັນໂດຊ່າ#,
		},
		'America/Menominee' => {
			exemplarCity => q#ເມໂນມິນີ#,
		},
		'America/Merida' => {
			exemplarCity => q#ເມີຣິດາ#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#ເມັດລາກັດລາ#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#ເມັກຊິໂກ ຊິຕີ#,
		},
		'America/Miquelon' => {
			exemplarCity => q#ມິກົວລອນ#,
		},
		'America/Moncton' => {
			exemplarCity => q#ມອນຕັນ#,
		},
		'America/Monterrey' => {
			exemplarCity => q#ມອນເຕີເຣຍ#,
		},
		'America/Montevideo' => {
			exemplarCity => q#ມອນເຕວິເດໂອ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#ມອນເຊີຣັດ#,
		},
		'America/Nassau' => {
			exemplarCity => q#ແນສຊໍ#,
		},
		'America/New_York' => {
			exemplarCity => q#ນິວຢອກ#,
		},
		'America/Nipigon' => {
			exemplarCity => q#ນີປີກອນ#,
		},
		'America/Nome' => {
			exemplarCity => q#ນອມ#,
		},
		'America/Noronha' => {
			exemplarCity => q#ນໍຣອນຮາ#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ເບີລາ, ນອດ ດາໂກຕາ#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#ເຊັນເຈີ, ນອດ ດາໂກຕາ#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#ນິວ ຊາເລມ, ນອດ ດາໂກຕາ#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ໂອຈິນາກາ#,
		},
		'America/Panama' => {
			exemplarCity => q#ພານາມາ#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#ແພງເນີດທັງ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#ພາຣາມາຣິໂບ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ຟິນິກ#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#ປໍໂຕແປຣງ#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#ພອດອອບສະເປນ#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#ປໍຕູ ເວວຢູ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#ເປີໂທຣິໂກ#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#ພຸນທາ ອະຣີນາສ໌#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#ເຣນນີ ຣິເວີ#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#ແຣນກິນ ອິນເລັດ#,
		},
		'America/Recife' => {
			exemplarCity => q#ເຣຊິເຟ#,
		},
		'America/Regina' => {
			exemplarCity => q#ເຣຈິນາ#,
		},
		'America/Resolute' => {
			exemplarCity => q#ເຣໂຊລຸດ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ຣິໂອ ບຣັນໂກ#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#ຊານຕາ ອິດຊາເບວ#,
		},
		'America/Santarem' => {
			exemplarCity => q#ຊັນຕາເຣມ#,
		},
		'America/Santiago' => {
			exemplarCity => q#ຊັນຕີອາໂກ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#ຊານໂຕໂດມິນໂກ#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ເຊົາ ເປົາໂລ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ອິໂຕຄໍທົວມິດ#,
		},
		'America/Sitka' => {
			exemplarCity => q#ຊິດກາ#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#ເຊນບາເທເລມີ#,
		},
		'America/St_Johns' => {
			exemplarCity => q#ເຊນ ຈອນ#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#ເຊນ ຄິດສ໌#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#ເຊນ ລູເຊຍ#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#ເຊນ ໂທມັສ#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#ເຊນ ວິນເຊນ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#ສະວິຟ ເຄີເຣນ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ເຕກູຊີການປາ#,
		},
		'America/Thule' => {
			exemplarCity => q#ທູເລ#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#ທັນເດີເບ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ທີຈົວນາ#,
		},
		'America/Toronto' => {
			exemplarCity => q#ໂທຣອນໂຕ#,
		},
		'America/Tortola' => {
			exemplarCity => q#ທໍໂຕລາ#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ແວນຄູເວີ#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ໄວທ໌ຮອສ#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ວິນນີເພກ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ຢາຄູຕັດ#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ເຢໂລໄນຟ໌#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#ເວລາກາງເວັນກາງ#,
				'generic' => q#ເວລາກາງ#,
				'standard' => q#ເວລາມາດຕະຖານກາງ#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#ເວລາກາງເວັນຕາເວັນອອກ#,
				'generic' => q#ເວລາຕາເວັນອອກ#,
				'standard' => q#ເວລາມາດຕະຖານຕາເວັນອອກ#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#ເວລາກາງເວັນແຖບພູເຂົາ#,
				'generic' => q#ເວລາແຖບພູເຂົາ#,
				'standard' => q#ເວລາມາດຕະຖານແຖບພູເຂົາ#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#ເວລາກາງເວັນແປຊິຟິກ#,
				'generic' => q#ເວລາແປຊິຟິກ#,
				'standard' => q#ເວລາມາດຕະຖານແປຊິຟິກ#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#ເຄຊີ#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ດາວີສ#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ດູມອນດີຍູວີວສ໌#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#ແມັກຄົວຣີ#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ເມົາຊັນ#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#ແມັກມົວໂດ#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#ພາມເມີ#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#ໂຣເທຣາ#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#ເຊຍວາ#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ໂທຣລ໌#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ວໍສະຕອກ#,
		},
		'Apia' => {
			long => {
				'daylight' => q#ເວລາກາງເວັນອາເພຍ#,
				'generic' => q#ເວລາເອເພຍ#,
				'standard' => q#ເວລາມາດຕະຖານເອເພຍ#,
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນອັດຕາອູ#,
				'generic' => q#ເວລາອັດຕາອູ#,
				'standard' => q#ເວລາມາດຕະຖານອັດຕາອູ#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນອັດໂຕເບ#,
				'generic' => q#ເວລາອັດໂຕເບ#,
				'standard' => q#ເວລາມາດຕະຖານອັດໂຕເບ#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#ເວລາກາງເວັນອາຣາບຽນ#,
				'generic' => q#ເວ​ລາ​ອາ​ຣາ​ບຽນ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານອາ​ຣາ​ບຽນ#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ລອງເຢຍບຽນ#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#​ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ອາ​ເຈນ​ທິ​ນາ#,
				'generic' => q#ເວ​ລາ​ອາ​ເຈ​ທິ​ນາ#,
				'standard' => q#​ເວ​ລາ​ມາດ​ຕະ​ຖານອາ​ເຈນ​ທິ​ນາ#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນເວ​ສ​ເທິນອາ​ເຈນ​ທິ​ນາ#,
				'generic' => q#ເວ​ລາ​ເວ​ສ​ເທິນອາ​ເຈນ​ທິ​ນາ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານເວ​ສ​ເທິນອາ​ເຈນ​ທິ​ນາ#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນອາເມເນຍ#,
				'generic' => q#ເວລາອາເມເນຍ#,
				'standard' => q#ເວລາມາດຕະຖານອາເມເນຍ#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ເອເດັນ#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#ອໍມາຕີ#,
		},
		'Asia/Amman' => {
			exemplarCity => q#ອຳມານ#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#ອານາດີ#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#ອັດຕາອູ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#ອັດໂທບີ#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#ອາດຊ໌ກາບັດ#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#ອັດທີເຣົາ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#ແບກແດດ#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#ບາເຣນ#,
		},
		'Asia/Baku' => {
			exemplarCity => q#ບາກູ#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ບາງກອກ#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#ບານົວ#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#ເບຣຸດ#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ບິດຊ໌ເຄກ#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ບຣູໄນ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#ໂກລກາຕາ#,
		},
		'Asia/Chita' => {
			exemplarCity => q#ຊີຕ່າ#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ຊອຍບອລຊານ#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#ໂຄລຳໂບ#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ດາມາສຄັສ#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ດາຫ໌ກາ#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ດີລີ#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ດູໄບ#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ດູຊານເບ#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#ຟາມາກັສທາ#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#ກາຊາ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ເຮບຣອນ#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ຮ່ອງກົງ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ຮອບ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ອີຄຸສຄ໌#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ຈາກາຕາ#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ຈາຢາປູຣະ#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#ເຢຣູຊາເລມ#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#ຄາບູ#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#ຄາມຊາດກາ#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#ກາຣາຈີ#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#ຄັດມັນດູ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ແຄນດີກາ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ຄຣັສໂນຢາສຄ໌#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#ກົວລາລຳເປີ#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#ກູຊີງ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#ຄູເວດ#,
		},
		'Asia/Macau' => {
			exemplarCity => q#ມາເກົາ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#ມາກາແດນ#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#ມາກາສຊາ#,
		},
		'Asia/Manila' => {
			exemplarCity => q#ມານີລາ#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#ມາສຄັດ#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#ນິໂຄເຊຍ#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#ໂນໂວຄຸສເນັດ#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#ໂນໂວຊີບີສຄ໌#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ອອມສຄ໌#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ອໍຣໍ#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#ພະນົມເປັນ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#ພອນເທຍນັກ#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ປຽງຢາງ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#ກາຕາຣ໌#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#ຄອສຕາເນ#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ໄຄຊີລໍດາ#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#ຢາງກອນ#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ຣີຢາດ#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ໂຮຈິມິນ#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ຊາຄາລິນ#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#ຊາມາແຄນ#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#ໂຊລ໌#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#ຊ່ຽງໄຮ້#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#ສິງກະໂປ#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#ສຣິລເນັກໂກລີດ#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ໄທເປ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ທາດສ໌ເຄນ#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#ທິບີລີຊີ#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#ເຕຣານ#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#ທິມພູ#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ໂຕກຽວ#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#ທອມສກ໌#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ອູລານບາຕາຣ໌#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ອູຣຸມຊີ#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#ອຸສ ເນຣາ#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ວຽງຈັນ#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ວີລາດິໂວສຕອກ#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ຢາຄຸທຊ໌#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#ເຢຄາເຕີຣິນເບີກ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ເຍເຣວານ#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#ເວລາກາງເວັນຂອງອາແລນຕິກ#,
				'generic' => q#ເວລາຂອງອາແລນຕິກ#,
				'standard' => q#ເວລາມາດຕະຖານຂອງອາແລນຕິກ#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ອາຊໍເຣສ#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ເບີມິວດາ#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#ຄານາຣີ#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#ເຄບເວີດ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ແຟໂຣ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#ມາເດຣາ#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ເຣກຢາວິກ#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#ເຊົາຈໍເຈຍ#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#ເຊນ ເຮເລນາ#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#ສະແຕນເລ#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#ເອດີແລດ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ບຣິສເບນ#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ໂບຣກເຄນ ຮິວ#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ກູຣີ#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ດາວິນ#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ຢູຄລາ#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ໂຮບາດ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#ລິນດີແມນ#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ໂລດໂຮວີ#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ເມວເບິນ#,
		},
		'Australia/Perth' => {
			exemplarCity => q#ເພີດ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#ຊິດນີ#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#ເວ​ລາ​ຕອນ​ທ່ຽງ​ອອສ​ເຕຣ​ເລຍ​ກາງ#,
				'generic' => q#ເວ​ລາອອ​ສ​ເຕຣ​ເລຍ​ກາງ#,
				'standard' => q#ເວ​ລາມາດ​ຕະ​ຖານອອ​ສ​ເຕຣ​ເລຍ​ກ​າງ#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#ເວ​ລາ​ຕອນ​ທ່ຽງ​ອອສ​ເຕຣ​ລຽນ​ກາງ​ຕາ​ເວັນ​ຕົກ#,
				'generic' => q#ເວ​ລາອອສ​ເຕຣ​ລຽນ​ກາງ​ຕາ​ເວັນ​ຕົກ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານອອສ​ເຕຣ​ລຽນ​ກາງ​ຕາ​ເວັນ​ຕົກ#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#ເວ​ລາ​ຕອນ​ທ່ຽງ​ອອສ​ເຕຣ​ລຽນ​ຕາ​ເວັນ​ອອກ#,
				'generic' => q#ເວ​ລາອອສ​ເຕຣ​ລຽນ​ຕາ​ເວັນ​ອອກ#,
				'standard' => q#ເວ​ລາ​ມາດຕະຖານ​​​ອອສ​ເຕຣ​ລຽນ​ຕາ​ເວັນ​ອອກ#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#ເວ​ລາ​ຕອນ​ທ່ຽງ​ອອສ​ເຕຣ​ລຽນ​ຕາ​ເວັນ​ຕົກ#,
				'generic' => q#ເວ​ລາ​ອອສ​ເຕຣ​ເລຍ​ຕາ​ເວັນ​ຕົກ#,
				'standard' => q#ເວ​ລາ​ມາ​ດ​ຕະ​ຖານອອສ​ເຕຣ​ລຽນ​ຕາ​ເວັນ​ຕົກ#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນອັສເຊີໄບຈັນ#,
				'generic' => q#ເວລາອັສເຊີໄບຈັນ#,
				'standard' => q#ເວລາມາດຕະຖານອັສເຊີໄບຈັນ#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນອາ​ໂຊ​ເຣ​ສ#,
				'generic' => q#ເວ​ລາ​ອາ​ໂຊ​ເຣ​ສ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານອາ​ໂຊ​ເຣ​ສ#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#ເວລາ ລະດູຮ້ອນ ບັງກະລາເທດ#,
				'generic' => q#ເວລາ ບັງກະລາເທດ#,
				'standard' => q#ເວລາມາດຕະຖານ ບັງກະລາເທດ#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#ເວ​ລາ​ພູ​ຖານ#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#ເວ​ລາ​ໂບ​ລິ​ເວຍ#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ເວລາຕາມເຂດລະດູຮ້ອນຕາມເຂດບຣາຊີເລຍ#,
				'generic' => q#ເວລາຕາມເຂດບຣາຊິເລຍ#,
				'standard' => q#ເວລາມາດຕາຖານເບຣຊີເລຍ#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#​ເວ​ລາບຣູ​ໄນດາ​ຣຸສ​ຊາ​ລາມ#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ເຄບ​ເວີດ#,
				'generic' => q#ເວ​ລາ​ເຄບ​ເວີດ#,
				'standard' => q#​ເວ​ລາ​ມາດ​ຕະ​ຖານ​ເຄບ​ເວີດ#,
			},
		},
		'Casey' => {
			long => {
				'standard' => q#ເວລາເຄຊີ#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#ເວ​ລາ​ຈາ​ໂມ​ໂຣ#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#ເວ​ລາ​ຕອນ​ທ່ຽງ​ຊາ​ທາມ#,
				'generic' => q#ເວ​ລາ​ຊາ​ທາມ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານ​ຊາ​ທາມ#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນຊິ​ລີ#,
				'generic' => q#ເວ​ລາ​ຊິ​ລີ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານຊິ​ລີ#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#​ເວ​ລາ​ຕອນ​ທ່ຽງ​ຈີນ#,
				'generic' => q#ເວ​ລາ​ຈີນ#,
				'standard' => q#ເວລາມາດຕະຖານຈີນ#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#ເວລາລະ​ດູ​ຮ້ອນໂຊຍບາຊັນ#,
				'generic' => q#ເວ​ລາ​ໂຊຍ​ບາ​ຊັນ#,
				'standard' => q#ເວລາມາດຕະຖານໂຊຍບາຊັນ#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#ເວ​ລາ​ເກາະ​ຄ​ຣິສ​ມາສ#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#ເວລາຫມູ່ເກາະໂກໂກສ#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນໂຄລໍາເບຍ#,
				'generic' => q#ເວລາໂຄລໍາເບຍ#,
				'standard' => q#ເວລາມາດຕະຖານໂຄລຳເບຍ#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#ເວ​ລາ​ເຄິ່ງ​ລະ​ດູ​ຮ້ອນ​ໝູ່​ເກາະ​ຄຸກ#,
				'generic' => q#ເວລາຫມູ່ເກາະຄຸກ#,
				'standard' => q#ເວລາມາດຕະຖານຫມູ່ເກາະຄຸກ#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#ເວລາກາງເວັນຄິວບາ#,
				'generic' => q#ເວລາຄິວບາ#,
				'standard' => q#ເວລາມາດຕະຖານຂອງຄິວບາ#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ເວລາເດວິດ#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ເວລາດູມອງດູວິລ#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#ເວລາຕີມໍຕາເວັນອອກ#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນເກາະ​ອີ​ສ​ເຕີ#,
				'generic' => q#ເວ​ລາ​ເກາະ​ອີ​ສ​ເຕີ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານເກາະ​ອີ​ສ​ເຕີ#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ເວ​ລາ​ເອ​ກົວ​ດໍ#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#ເວລາສາກົນເຊີງພິກັດ#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#ບໍ່ຮູ້ຊື່ເມືອງ#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ອາມສເຕີດຳ#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#ອິນດໍຣາ#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#ອາສຕຣາຄານ#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ເອເທນສ໌#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#ເບວເກຣດ#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#ເບີລິນ#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ບຣາທິສລາວາ#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ບຣັສເຊວ#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ບູຄາເຣສຕ໌#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ບູດາເປສຕ໌#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ບັດຊິນເກນ#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#ຄີຊີເນົາ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#ໂຄເປນເຮເກນ#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ດັບບລິນ#,
			long => {
				'daylight' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານ​ໄອ​ຣິ​ຊ#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ກິບຣອລທາ#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ເກີນຊີ#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ເຮວຊິນກິ#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#ເກາະແມນ#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ອິສຕັນບູລ໌#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ເຈີຊີ#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#ຄາລິນິນກຣາດ#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#ຂຽບ#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#ກິໂຣບ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#ລິສບອນ#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ລູບລີຍານາ#,
		},
		'Europe/London' => {
			exemplarCity => q#ລອນດອນ#,
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ອັງ​ກິດ#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ລັກເຊັມເບີກ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#ມາດຣິດ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#ມອລຕາ#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ມາຣີແຮມນ໌#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#ມິນສກ໌#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#ໂມນາໂຄ#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ມອສໂຄ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ອອສໂລ#,
		},
		'Europe/Paris' => {
			exemplarCity => q#ປາຣີສ#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#ພອດກໍຣີກາ#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ປຣາກ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ຣິກາ#,
		},
		'Europe/Rome' => {
			exemplarCity => q#ໂຣມ#,
		},
		'Europe/Samara' => {
			exemplarCity => q#ຊາມາຣາ#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#ຊານມາຣີໂນ#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#ຊາຣາເຢໂວ#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#ຊາຣາທອບ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#ຊີມເຟໂລໂປ#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#ສະໂກເປຍ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#ໂຊເຟຍ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#ສະຕອກໂຮມ#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ທາລລິນນ໌#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ທິຣານ#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#ອູລີອານອບສຄ໌#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ອັສຊ໌ກໍໂຣດ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ວາດາຊ#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ວາຕິກັນ#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ວຽນນາ#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ວິລນິອຸສ#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ວອລໂກກຣາດ#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ວໍຊໍ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ຊາເກຣບ#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ຊາໂປໂຣຊີ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ຊູຣິກ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#​ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ຢູ​ໂຣບ​ກາງ#,
				'generic' => q#ເວ​ລາ​ຢູ​ໂຣບ​ກາງ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານ​ຢູ​ໂຣບກາງ#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນຢູ​ໂຣບ​ຕາ​ເວັນ​ອອກ#,
				'generic' => q#ເວ​ລາ​ຢູ​ໂຣບ​ຕາ​ເວັນ​ອອກ#,
				'standard' => q#ເວ​ລາ​ມາ​ດ​ຕະ​ຖານ​ຢູ​ໂຣບ​ຕາ​ເວັນ​ອອກ#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#ເວ​ລາ​​ຢູ​ໂຣ​ປຽນ​ຕາ​ເວັນ​ອອກ​ໄກ#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນຢູ​ໂຣບ​ຕາ​ເວັນ​ຕົກ#,
				'generic' => q#ເວ​ລາ​ຢູ​ໂຣບ​ຕາ​ເວັນ​ຕົກ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານຢູ​ໂຣບ​ຕາ​ເວັນ​ຕົກ#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#​ເວ​ລາ​ລະ​ດູ​ຮ້ອນໝູ່​ເກາະ​ຟອ​ລ໌ກ​ແລນ#,
				'generic' => q#​ເວ​ລາ​ໝູ່​ເກາະ​ຟອ​ລ໌ກ​ແລນ#,
				'standard' => q#​ເວ​ລາ​ມາດ​ຕະ​ຖານໝູ່​ເກາະ​ຟອ​ລ໌ກ​ແລນ#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນຟິຈິ#,
				'generic' => q#ເວລາຟິຈິ#,
				'standard' => q#ເວລາມາດຕະຖານຟິຈິ#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#ເວ​ລາ​ເຟ​ຣນ​ຊ໌​ເກຍ​ນາ#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#ເວລາຝຣັ່ງຕອນໃຕ້ ແລະ ແອນຕາກຕິກ#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ເວ​ລາກຣີນ​ວິ​ຊ#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#ເວ​ລາ​ກາ​ລາ​ປາ​ກອ​ສ#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#ເວລາແກມເບຍ#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນຈໍເຈຍ#,
				'generic' => q#ເວລາຈໍເຈຍ#,
				'standard' => q#ເວລາມາດຕະຖານຈໍເຈຍ#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#ເວລາຫມູ່ເກາະກິລເບີດ#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນກຣີນແລນຕາເວັນອອກ#,
				'generic' => q#ເວລາຕາເວັນອອກຂອງກຣີນແລນ#,
				'standard' => q#ເວລາມາດຕະຖານຕາເວັນອອກກຣີນແລນ#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#ເວລາຕອນທ່ຽງກຣີນແລນຕາເວັນຕົກ#,
				'generic' => q#ເວລາກຣີນແລນຕາເວັນຕົກ#,
				'standard' => q#ເວລາມາດຕະຖານກຣີນແລນຕາເວັນຕົກ#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#ເວລາກວມ#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#ເວ​ລາ​ກູ​ລ​໌ຟ#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#ເວລາກາຍອານາ#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#ເວລາຕອນທ່ຽງຮາວາຍ-ເອລູທຽນ#,
				'generic' => q#ເວລາຮາວາຍ-ເອລູທຽນ#,
				'standard' => q#ເວລາມາດຕະຖານຮາວາຍ-ເອລູທຽນ#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#​ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ຮອງ​ກົງ#,
				'generic' => q#ເວ​ລາ​ຮອງ​ກົງ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານ​ຮອງ​ກົງ#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#​ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ຮອບ​ດ໌#,
				'generic' => q#ເວ​ລາ​ຮອບ​ດ໌#,
				'standard' => q#​ເວ​ລາ​ມາດ​ຕະ​ຖານ​ຮອບ​ດ໌#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ເວລາ ອິນເດຍ#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#ອັນຕານານາຣິໂວ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ຊາໂກສ#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ຄຣິດສະມາດ#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#ໂຄໂຄສ#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#ໂຄໂມໂຣ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#ແກເກີເລນ#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ມາເຮ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#ມັລດີຟ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ເມົາຣິທຽສ#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#ມາຢັອດເຕ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ເຣອູນິຢົງ#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#ເວລາຫມະຫາສະຫມຸດອິນເດຍ#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ເວລາອິນດູຈີນ#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#ເວ​ລາ​ອິນ​ໂດ​ເນ​ເຊຍ​ກາງ#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#ເວ​ລາ​ອິນ​ໂດ​ເນ​ເຊຍ​ຕາ​ເວັນ​ອອກ#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#ເວ​ລາ​ອິນ​ໂດ​ເນ​ເຊຍ​ຕາ​ເວັນ​ຕົກ#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ເວ​ລາ​ຕອນ​ທ່ຽງ​ອີ​ຣາ​ນ#,
				'generic' => q#ເວ​ລາ​ອີ​ຣານ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານອີ​ຣານ#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ເວ​ລາລະ​ດູ​ຮ້ອນອີ​ຄຸດ​ສ​ຄ໌#,
				'generic' => q#ເວ​ລ​າອີ​ຄຸດ​ສ​ຄ໌#,
				'standard' => q#ເວ​ລາມາດ​ຕະ​ຖານອີ​ຄຸດ​ສ​ຄ໌#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#ເວລາກາງເວັນອິສຣາເອວ#,
				'generic' => q#ເວ​ລາ​ອິ​ສ​ຣາ​ເອວ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານອິ​ສ​ຣາ​ເອວ#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#ເວ​ລາ​ຕອນ​ທ່ຽງ​ຍີ່​ປຸ່ນ#,
				'generic' => q#ເວ​ລາ​ຍີ່​ປຸ່ນ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານ​ຍີ່​ປຸ່ນ#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#ເວ​ລາ​ຄາ​ຊັກ​ສ​ຖານ​ຕາ​ເວັນ​ອອກ#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#ເວ​ລາ​ຄາ​ຊັກ​ສ​ຖານ​ຕາ​ເວັນ​ຕົກ#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#ເວ​ລາ​ຕອນ​ທ່ຽງ​ເກົາ​ຫລີ#,
				'generic' => q#ເວລາເກົາຫຼີ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານ​ເກົາ​ຫລີ#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#ເວລາຄອສແຣ#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນຄຣັສ​ໂນ​ຢາ​ສ​ຄ໌#,
				'generic' => q#ເວ​ລາ​ຄຣັສ​ໂນ​ຢາ​ສ​ຄ໌#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານຄຣັສ​ໂນ​ຢາ​ສ​ຄ໌#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#ເວລາເຄຍກິສຖານ#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#ເວລາລັງກາ#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#ເວ​ລາ​ໝູ່​ເກາະ​ລາຍ#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#​ເວ​ລ​ສາ​ຕອນ​​ທ່ຽງ​ລອດ​ເຮົາ​#,
				'generic' => q#ເວ​ລາ​ລອດ​ເຮົາ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານ​ລອດ​ເຮົາ#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນມາເກົາ#,
				'generic' => q#ເວລາມາເກົາ#,
				'standard' => q#ເວລາມາດຕະຖານມາເກົາ#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#ເວ​ລາ​ເກາະ​ແມັກ​ຄົວ​ຣີ#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນເມັກກາເດນ#,
				'generic' => q#ເວລາເມັກກາເດນ#,
				'standard' => q#ເວລາມາດຕະຖານເມັກກາເດນ#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#ເວ​ລາ​ມາ​ເລ​ເຊຍ#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#ເວລາມັລດີຟ#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#ເວລາມາເຄີຊັສ#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#ເວ​ລາ​ໝູ່​ເກາະ​ມາ​ແຊວ#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#​ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ເມົາ​ຣິ​ທຽ​ສ#,
				'generic' => q#ເວ​ລາ​ເມົາ​ຣິ​ທຽ​ສ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານເມົາ​ຣິ​ທຽ​ສ#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#ເວລາມໍສັນ#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#ເວລາກາງເວັນເມັກຊິກັນນອດເວສ#,
				'generic' => q#​ເວ​ລາ​ນອດ​ເວ​ສ​ເມັກ​ຊິ​ໂກ#,
				'standard' => q#​ເວ​ລາ​ມາດ​ຕະ​ຖານນອດ​ເວ​ສ​ເມັກ​ຊິ​ໂກ#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#ເວລາກາງເວັນແປຊິຟິກເມັກຊິກັນ#,
				'generic' => q#ເວລາແປຊິຟິກເມັກຊິກັນ#,
				'standard' => q#ເວລາມາດຕະຖານແປຊິຟິກເມັກຊິກັນ#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນອູລານບາເຕີ#,
				'generic' => q#ເວລາ ອູລານບາເຕີ#,
				'standard' => q#ເວລາມາດຕະຖານ ອູລານບາເຕີ#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນມອ​ສ​ໂຄ#,
				'generic' => q#ເວ​ລາ​ມອ​ສ​ໂຄ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານມອ​ສ​ໂຄ#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#ເວລາມຽນມາ#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#ເວ​ລາ​ນາ​ອູ​ຣຸ#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#​ເວ​ລາ​ເນ​ປານ#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນນິວແຄລິໂດເນຍ#,
				'generic' => q#ເວລານິວແຄລິໂດເນຍ#,
				'standard' => q#ເວລາມາດຕະຖານນິວແຄລິໂດເນຍ#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#ເວ​ລາ​ຕອນ​ທ່ຽງ​ນິວ​ຊີ​ແລນ#,
				'generic' => q#ເວ​ລາ​ນິວ​ຊີ​ແລນ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານນິວ​ຊີ​ແລນ#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#ເວລາກາງເວັນນິວຟາວແລນ#,
				'generic' => q#ເວ​ລາ​ນິວ​ຟາວ​ແລນ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານ​ນິວ​ຟາວ​ແລນ#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#ເວລານິອູເອ#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນເກາະ​ນໍ​ຟອ​ລ໌ກ#,
				'generic' => q#ເວ​ລາ​ເກາະ​ນໍ​ຟອ​ລ໌ກ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານເກາະ​ນໍ​ຟອ​ລ໌ກ#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນເຟນັນໂດເດໂນຮອນຮາ#,
				'generic' => q#ເວລາເຟນັນໂດເດໂນຮອນຮາ#,
				'standard' => q#ເວລາມາດຕະຖານເຟນັນໂດເດໂນຮອນຮາ#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#ເວລາຫມູ່ເກາະມາເຣຍນາເຫນືອ#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນໂນ​ໂບ​ຊິ​ບິ​ສ​ຄ໌#,
				'generic' => q#ເວ​ລາ​ໂນ​ໂບ​ຊິ​ບິ​ສ​ຄ໌#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານໂນ​ໂບ​ຊິ​ບິ​ສ​ຄ໌#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນອອມ​ສ​ຄ໌#,
				'generic' => q#​ເວ​ລາອອມ​ສ​ຄ໌#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານອອມ​ສ​ຄ໌#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#ເອປີອາ#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ອັກແລນ#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#ເວລາຕາມເຂດບູນກຽນວິວ#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ແຊແທມ#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ເອສເຕີ#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ເອຟາເຕ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#ເອັນເດີເບີລີ#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ຟາກາວໂຟ#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ຟູຈິ#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ຟູນະຟູຕິ#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ກາລາປາກອສ#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ແກມເບຍ#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ກົວດັລຄະແນລ#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ກວມ#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ໂຮໂນລູລູ#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ຈອນສະໂຕນ#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#ຄີຣິທີມາຕີ#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#ຄໍສແຣ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ຄວາຈາເລນ#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#ມາຈູໂຣ#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#ມາຄິວຊາສ#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#ມິດເວ#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ນາອູຣູ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#ນີອູເອ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#ນໍຟອລ໌ກ#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#ນູເມອາ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#ປາໂກປາໂກ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#ປາເລົາ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#ພິດແຄນ#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#ປົນເປີຍ#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#ພອດ ມໍເຣສບີ#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#ຣາໂຣຕອງກາ#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#ໄຊປານ#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ທາຮີຕິ#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ຕາຣາວາ#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ຕອງກາຕາປູ#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ຈັກ#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ເວກ#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ວາລິດ#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ປາ​ກີ​ສ​ຖານ#,
				'generic' => q#ເວ​ລາ​ປາ​ກີສຖານ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານ​ປາ​ກີສຖານ#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#ເວລາປາເລົາ#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#ເວລາປາປົວກິນີ#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ປາ​ຣາ​ກວຍ#,
				'generic' => q#ເວ​ລາ​ປາ​ຣາ​ກວຍ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານ​ປາ​ຣາ​ກວຍ#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ເປ​ຣູ#,
				'generic' => q#ເວ​ລາ​ເປ​ຣູ#,
				'standard' => q#ເວ​ລາ​​ມາ​ດ​ຕະ​ຖານເປ​ຣູ#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ຟິ​ລິບ​ປິນ#,
				'generic' => q#​ເວ​ລາ​ຟິ​ລິບ​ປິນ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານ​ຟິ​ລິບ​ປິນ#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#ເວລາຫມູ່ເກາະຟີນິກ#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#​ເວ​ລາຕອນ​ທ່ຽງເຊນ​ປີ​ແອ ແລະ​ມິ​ກົວ​ລອນ#,
				'generic' => q#​ເວ​ລາເຊນ​ປີ​ແອ ແລະ​ມິ​ກົວ​ລອນ#,
				'standard' => q#​ເວ​ລາມາດ​ຕະ​ຖານເຊນ​ປີ​ແອ ແລະ​ມິ​ກົວ​ລອນ#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#ເວລາພິດແຄຣ໌ນ#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#ເວລາໂປເນບ#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#ເວລາປຽງຢາງ#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນຄີວລໍດາ#,
				'generic' => q#ເວລາຄີວລໍດາ#,
				'standard' => q#ເວລາມາດຕະຖານຄີວລໍດາ#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#ເວ​ລາ​ເຣ​ອູ​ນິ​ຢົງ#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#ເວລາ ໂຣທີຕາ#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນຊາ​ຮາ​ລິນ#,
				'generic' => q#ເວ​ລາ​ຊາ​ຮາ​ລິນ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານຊາ​ຮາ​ລິນ#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນຊາມົວ#,
				'generic' => q#ເວລາຊາມົວ#,
				'standard' => q#ເວລາມາດຕະຖານຊາມົວ#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#ເວ​ລາ​ເຊ​ເຊ​ລ​ສ໌#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#ເວ​ລາ​ສິງ​ກະ​ໂປ#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#ເວລາຫມູ່ເກາະໂຊໂລມອນ#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#ເວລາຈໍເຈຍໃຕ້#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#ເວ​ລາ​ຊຸ​ຣິ​ນາມ#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#ເວລາ ໂຊວາ#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#ເວລາທາຮິຕິ#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#ເວ​ລາ​ຕອນ​ທ່​ຽງ​ໄທ​ເປ#,
				'generic' => q#ເວ​ລາ​ໄທ​ເປ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານ​ໄທ​ເປ#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#ເວລາທາຈິກິສຖານ#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#ເວລາໂຕເກເລົາ#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນຕອງກາ#,
				'generic' => q#ເວລາຕອງກາ#,
				'standard' => q#ເວລາມາດຕະຖານຕອງກາ#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#ເວລາຊຸກ#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນຕວກເມນິສຖານ#,
				'generic' => q#ເວລາຕວກເມນິສຖານ#,
				'standard' => q#ເວລາມາດຕະຖານຕວກເມນິສຖານ#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#ເວລາຕູວາລູ#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#ເວ​ລາ​ລະ​ດູ​ຮ້ອນ​ອູ​ຣູ​ກວຍ#,
				'generic' => q#​ເວ​ລາ​ອູ​ຣູ​ກວຍ#,
				'standard' => q#ເວ​ລາ​ມາດ​ຕະ​ຖານ​ອູ​ຣູ​ກວຍ#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນອຸສເບກິດສະຖານ#,
				'generic' => q#ເວລາອຸສເບກິດສະຖານ#,
				'standard' => q#ເວລາມາດຕະຖານອຸສເບກິດສະຖານ#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນວານູອາຕູ#,
				'generic' => q#ເວລາວານູອາຕູ#,
				'standard' => q#ເວລາມາດຕະຖານວານູອາຕູ#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#ເວ​ລາ​ເວ​ເນ​ຊູ​ເອ​ລາ#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນລາດີໂວສຕົກ#,
				'generic' => q#ເວລາລາດີໂວສຕົກ#,
				'standard' => q#ເວລາມາດຕະຖານລາດີໂວສຕົກ#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນໂວໂກກຣາດ#,
				'generic' => q#ເວລາໂວໂກກຣາດ#,
				'standard' => q#ເວລາມາດຕະຖານໂວໂກກຣາດ#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ເວລາ ວອສໂຕກ#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ເວລາເກາະເວກ#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#ເວລາວາລລິສ ແລະ ຟູຕູນາ#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນຢາກູດສ#,
				'generic' => q#ເວລາຢາກູດສ#,
				'standard' => q#ເວລາມາດຕະຖານຢາກູດສ#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#ເວລາລະດູຮ້ອນເຢກາເຕລິນເບີກ#,
				'generic' => q#ເວລາເຢກາເຕລິນເບີກ#,
				'standard' => q#ເວລາມາດຕະຖານເຢກາເຕລິນເບີກ#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#ເວລາຢູຄອນ#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
