=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Kk - Package for language Kazakh

=cut

package Locale::CLDR::Locales::Kk;
# This file auto generated from Data\common\main\kk.xml
#	on Wed 28 Feb 12:16:00 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
    is => 'ro',
    isa => ArrayRef,
    init_arg => undef,
    default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal','spellout-ordinal','digits-ordinal' ]},
);

has 'algorithmic_number_format_data' => (
    is => 'ro',
    isa => HashRef,
    init_arg => undef,
    default => sub {
        use bigfloat;
        return {
		'digits-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(−→→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=#,##0=-$(ordinal,many{шы}other{ші})$),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=#,##0=-$(ordinal,many{шы}other{ші})$),
				},
			},
		},
		'fractions' => {
			'private' => {
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(оннан ←%spellout-cardinal←),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(жүзден ←%spellout-cardinal←),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(мыңнан ←%spellout-cardinal←),
				},
				'10000' => {
					base_value => q(10000),
					divisor => q(10000),
					rule => q(он мыңнан ←%spellout-cardinal←),
				},
				'100000' => {
					base_value => q(100000),
					divisor => q(100000),
					rule => q(жүз мыңнан ←%spellout-cardinal←),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(миллионнан ←%spellout-cardinal←),
				},
				'10000000' => {
					base_value => q(10000000),
					divisor => q(10000000),
					rule => q(он миллионнан ←%spellout-cardinal←),
				},
				'100000000' => {
					base_value => q(100000000),
					divisor => q(100000000),
					rule => q(жүз миллионнан ←%spellout-cardinal←),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(миллиардтан ←%spellout-cardinal←),
				},
				'10000000000' => {
					base_value => q(10000000000),
					divisor => q(10000000000),
					rule => q(он миллиардтан ←%spellout-cardinal←),
				},
				'100000000000' => {
					base_value => q(100000000000),
					divisor => q(100000000000),
					rule => q(жүз миллиардтан ←%spellout-cardinal←),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←0←),
				},
				'max' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←0←),
				},
			},
		},
		'ordinal-i-suffix' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(інші),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'ordinal-yeru-suffix' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ыншы),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'spellout-cardinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нөл),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← бүтін →%%fractions→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(бір),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(екі),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(үш),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(төрт),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(бес),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(алты),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(жеті),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(сегіз),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(тоғыз),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(он[ →→]),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(жиырма[ →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(отыз[ →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(қырық[ →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(елу[ →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(алпыс[ →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(жетпіс[ →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(сексен[ →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(тоқсан[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(жүз[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(←← жүз[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(мың[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←← мың[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(миллион[ →→]),
				},
				'2000000' => {
					base_value => q(2000000),
					divisor => q(1000000),
					rule => q(←← миллион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(миллиард[ →→]),
				},
				'2000000000' => {
					base_value => q(2000000000),
					divisor => q(1000000000),
					rule => q(←← миллиард[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(триллион[ →→]),
				},
				'2000000000000' => {
					base_value => q(2000000000000),
					divisor => q(1000000000000),
					rule => q(←← триллион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(квадриллион[ →→]),
				},
				'2000000000000000' => {
					base_value => q(2000000000000000),
					divisor => q(1000000000000000),
					rule => q(←← квадриллион[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
			},
		},
		'spellout-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нөлінші),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← бүтін →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(бірінші),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(екінші),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(үшінші),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(төртінші),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(бесінші),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(алтыншы),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(жетінші),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(сегізінші),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(тоғызыншы),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(оныншы),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(он→%%ordinal-yeru-suffix→),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(жиырмасыншы),
				},
				'21' => {
					base_value => q(21),
					divisor => q(10),
					rule => q(жиырма →→),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(отыз→%%ordinal-yeru-suffix→),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(қырық→%%ordinal-yeru-suffix→),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(елу→%%ordinal-i-suffix→),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(алпыс→%%ordinal-yeru-suffix→),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(жетпіс→%%ordinal-i-suffix→),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(сексен→%%ordinal-i-suffix→),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(тоқсан→%%ordinal-yeru-suffix→),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(жүз→%%ordinal-i-suffix→),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(←%spellout-cardinal← жүз→%%ordinal-i-suffix→),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(мың→%%ordinal-yeru-suffix→),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal← мың→%%ordinal-yeru-suffix→),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(миллион→%%ordinal-yeru-suffix→),
				},
				'2000000' => {
					base_value => q(2000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal← миллион→%%ordinal-yeru-suffix→),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(миллиард→%%ordinal-yeru-suffix→),
				},
				'2000000000' => {
					base_value => q(2000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal← миллиард→%%ordinal-yeru-suffix→),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(триллион→%%ordinal-yeru-suffix→),
				},
				'2000000000000' => {
					base_value => q(2000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal← триллион→%%ordinal-yeru-suffix→),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(квадриллион→%%ordinal-yeru-suffix→),
				},
				'2000000000000000' => {
					base_value => q(2000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal← квадриллион→%%ordinal-yeru-suffix→),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
    } },
);

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'афар тілі',
 				'ab' => 'абхаз тілі',
 				'ace' => 'ачех тілі',
 				'ada' => 'адангме тілі',
 				'ady' => 'адыгей тілі',
 				'af' => 'африкаанс тілі',
 				'agq' => 'агем тілі',
 				'ain' => 'айну тілі',
 				'ak' => 'акан тілі',
 				'ale' => 'алеут тілі',
 				'alt' => 'оңтүстік алтай тілі',
 				'am' => 'амхар тілі',
 				'an' => 'арагон тілі',
 				'ann' => 'оболо тілі',
 				'anp' => 'ангика тілі',
 				'ar' => 'араб тілі',
 				'ar_001' => 'қазіргі стандартты араб тілі',
 				'arn' => 'мапуче тілі',
 				'arp' => 'арапахо тілі',
 				'ars' => 'араб тілі (Неджда)',
 				'as' => 'ассам тілі',
 				'asa' => 'асу тілі',
 				'ast' => 'астурия тілі',
 				'atj' => 'атикамек тілі',
 				'av' => 'авар тілі',
 				'awa' => 'авадхи тілі',
 				'ay' => 'аймара тілі',
 				'az' => 'әзірбайжан тілі',
 				'ba' => 'башқұрт тілі',
 				'ban' => 'бали тілі',
 				'bas' => 'баса тілі',
 				'be' => 'беларусь тілі',
 				'bem' => 'бемба тілі',
 				'bez' => 'бена тілі',
 				'bg' => 'болгар тілі',
 				'bgc' => 'хариани тілі',
 				'bgn' => 'батыс балучи тілі',
 				'bho' => 'бходжпури тілі',
 				'bi' => 'бислама тілі',
 				'bin' => 'бини тілі',
 				'bla' => 'сиксика тілі',
 				'bm' => 'бамбара тілі',
 				'bn' => 'бенгал тілі',
 				'bo' => 'тибет тілі',
 				'br' => 'бретон тілі',
 				'brx' => 'бодо тілі',
 				'bs' => 'босния тілі',
 				'bug' => 'бугис тілі',
 				'byn' => 'блин тілі',
 				'ca' => 'каталан тілі',
 				'cay' => 'кайюга тілі',
 				'ccp' => 'чакма тілі',
 				'ce' => 'шешен тілі',
 				'ceb' => 'себуано тілі',
 				'cgg' => 'кига тілі',
 				'ch' => 'чаморро тілі',
 				'chk' => 'чуук тілі',
 				'chm' => 'мари тілі',
 				'cho' => 'чокто тілі',
 				'chp' => 'чипевайан тілі',
 				'chr' => 'чероки тілі',
 				'chy' => 'шайен тілі',
 				'ckb' => 'сорани тілі',
 				'clc' => 'чилкотин тілі',
 				'co' => 'корсика тілі',
 				'crg' => 'мичиф тілі',
 				'crj' => 'оңтүстік-шығыс кри тілі',
 				'crk' => 'жазықтағы кри тілі',
 				'crl' => 'солтүстік-шығыс кри тілі',
 				'crm' => 'мус кри тілі',
 				'crr' => 'каролиналық алгонкин тілі',
 				'crs' => 'сейшельдік креол тілі',
 				'cs' => 'чех тілі',
 				'csw' => 'батпақты жердің кри тілі',
 				'cu' => 'шіркеулік славян тілі',
 				'cv' => 'чуваш тілі',
 				'cy' => 'валлий тілі',
 				'da' => 'дат тілі',
 				'dak' => 'дакота тілі',
 				'dar' => 'даргин тілі',
 				'dav' => 'таита тілі',
 				'de' => 'неміс тілі',
 				'de_CH' => 'швейцариялық әдеби неміс тілі',
 				'dgr' => 'догриб тілі',
 				'dje' => 'зарма тілі',
 				'doi' => 'догри тілі',
 				'dsb' => 'төменгі лужица тілі',
 				'dua' => 'дуала тілі',
 				'dv' => 'дивехи тілі',
 				'dyo' => 'диола тілі',
 				'dz' => 'дзонг-кэ тілі',
 				'dzg' => 'дазага тілі',
 				'ebu' => 'эмбу тілі',
 				'ee' => 'эве тілі',
 				'efi' => 'эфик тілі',
 				'eka' => 'экаджук тілі',
 				'el' => 'грек тілі',
 				'en' => 'ағылшын тілі',
 				'eo' => 'эсперанто тілі',
 				'es' => 'испан тілі',
 				'et' => 'эстон тілі',
 				'eu' => 'баск тілі',
 				'ewo' => 'эвондо тілі',
 				'fa' => 'парсы тілі',
 				'fa_AF' => 'дари тілі',
 				'ff' => 'фула тілі',
 				'fi' => 'фин тілі',
 				'fil' => 'филиппин тілі',
 				'fj' => 'фиджи тілі',
 				'fo' => 'фарер тілі',
 				'fon' => 'фон тілі',
 				'fr' => 'француз тілі',
 				'frc' => 'каджун тілі (француз)',
 				'frr' => 'солтүстік фриз тілі',
 				'fur' => 'фриуль тілі',
 				'fy' => 'батыс фриз тілі',
 				'ga' => 'ирланд тілі',
 				'gaa' => 'га тілі',
 				'gag' => 'гагауз тілі',
 				'gd' => 'шотландиялық гэль тілі',
 				'gez' => 'геэз тілі',
 				'gil' => 'гильберт тілі',
 				'gl' => 'галисия тілі',
 				'gn' => 'гуарани тілі',
 				'gor' => 'горонтало тілі',
 				'gsw' => 'неміс тілі (Швейцария)',
 				'gu' => 'гуджарати тілі',
 				'guz' => 'гусии тілі',
 				'gv' => 'мэн тілі',
 				'gwi' => 'гвичин тілі',
 				'ha' => 'хауса тілі',
 				'hai' => 'хайда тілі',
 				'haw' => 'гавайи тілі',
 				'hax' => 'оңтүстік хайда тілі',
 				'he' => 'иврит тілі',
 				'hi' => 'хинди тілі',
 				'hi_Latn@alt=variant' => 'хинглиш',
 				'hil' => 'хилигайнон тілі',
 				'hmn' => 'хмонг тілі',
 				'hr' => 'хорват тілі',
 				'hsb' => 'жоғарғы лужица тілі',
 				'ht' => 'гаити тілі',
 				'hu' => 'венгр тілі',
 				'hup' => 'хупа тілі',
 				'hur' => 'халкомелем тілі',
 				'hy' => 'армян тілі',
 				'hz' => 'гереро тілі',
 				'ia' => 'интерлингва тілі',
 				'iba' => 'ибан тілі',
 				'ibb' => 'ибибио тілі',
 				'id' => 'индонезия тілі',
 				'ie' => 'интерлингве тілі',
 				'ig' => 'игбо тілі',
 				'ii' => 'сычуан и тілі',
 				'ikt' => 'батыс канадалық инуктитут тілі',
 				'ilo' => 'илоко тілі',
 				'inh' => 'ингуш тілі',
 				'io' => 'идо тілі',
 				'is' => 'исланд тілі',
 				'it' => 'итальян тілі',
 				'iu' => 'инуктитут тілі',
 				'ja' => 'жапон тілі',
 				'jbo' => 'ложбан тілі',
 				'jgo' => 'нгомба тілі',
 				'jmc' => 'мачаме тілі',
 				'jv' => 'ява тілі',
 				'ka' => 'грузин тілі',
 				'kab' => 'кабил тілі',
 				'kac' => 'качин тілі',
 				'kaj' => 'каджи тілі',
 				'kam' => 'камба тілі',
 				'kbd' => 'кабардин тілі',
 				'kcg' => 'тьяп тілі',
 				'kde' => 'маконде тілі',
 				'kea' => 'кабувердьяну тілі',
 				'kfo' => 'коро тілі',
 				'kgp' => 'кайнганг тілі',
 				'kha' => 'кхаси тілі',
 				'khq' => 'койра чини тілі',
 				'ki' => 'кикуйю тілі',
 				'kj' => 'кваньяма тілі',
 				'kk' => 'қазақ тілі',
 				'kkj' => 'како тілі',
 				'kl' => 'калаалисут тілі',
 				'kln' => 'каленжин тілі',
 				'km' => 'кхмер тілі',
 				'kmb' => 'кимбунду тілі',
 				'kn' => 'каннада тілі',
 				'ko' => 'корей тілі',
 				'koi' => 'коми-пермяк тілі',
 				'kok' => 'конкани тілі',
 				'kpe' => 'кпелле тілі',
 				'kr' => 'канури тілі',
 				'krc' => 'қарашай-балқар тілі',
 				'krl' => 'карель тілі',
 				'kru' => 'курух тілі',
 				'ks' => 'кашмир тілі',
 				'ksb' => 'шамбала тілі',
 				'ksf' => 'бафиа тілі',
 				'ksh' => 'кёльн тілі',
 				'ku' => 'күрд тілі',
 				'kum' => 'құмық тілі',
 				'kv' => 'коми тілі',
 				'kw' => 'корн тілі',
 				'kwk' => 'квакиутль тілі',
 				'ky' => 'қырғыз тілі',
 				'la' => 'латын тілі',
 				'lad' => 'ладино тілі',
 				'lag' => 'ланги тілі',
 				'lb' => 'люксембург тілі',
 				'lez' => 'лезгин тілі',
 				'lg' => 'ганда тілі',
 				'li' => 'лимбург тілі',
 				'lij' => 'лигур тілі',
 				'lil' => 'лиллуэт тілі',
 				'lkt' => 'лакота тілі',
 				'lmo' => 'Ломбард',
 				'ln' => 'лингала тілі',
 				'lo' => 'лаос тілі',
 				'lou' => 'креоль тілі (Луизиана)',
 				'loz' => 'лози тілі',
 				'lrc' => 'солтүстік люри тілі',
 				'lsm' => 'самия тілі',
 				'lt' => 'литва тілі',
 				'lu' => 'луба-катанга тілі',
 				'lua' => 'луба-лулуа тілі',
 				'lun' => 'лунда тілі',
 				'luo' => 'луо тілі',
 				'lus' => 'мизо тілі',
 				'luy' => 'лухиа тілі',
 				'lv' => 'латыш тілі',
 				'mad' => 'мадур тілі',
 				'mag' => 'магахи тілі',
 				'mai' => 'майтхили тілі',
 				'mak' => 'макасар тілі',
 				'mas' => 'масай тілі',
 				'mdf' => 'мокша тілі',
 				'men' => 'менде тілі',
 				'mer' => 'меру тілі',
 				'mfe' => 'морисиен тілі',
 				'mg' => 'малагаси тілі',
 				'mgh' => 'макуа-меетто тілі',
 				'mgo' => 'мета тілі',
 				'mh' => 'маршалл тілі',
 				'mi' => 'маори тілі',
 				'mic' => 'микмак тілі',
 				'min' => 'минангкабау тілі',
 				'mk' => 'македон тілі',
 				'ml' => 'малаялам тілі',
 				'mn' => 'моңғол тілі',
 				'mni' => 'манипури тілі',
 				'moe' => 'инну-аймун тілі',
 				'moh' => 'могавк тілі',
 				'mos' => 'мосси тілі',
 				'mr' => 'маратхи тілі',
 				'ms' => 'малай тілі',
 				'mt' => 'мальта тілі',
 				'mua' => 'мунданг тілі',
 				'mul' => 'бірнеше тіл',
 				'mus' => 'крик тілі',
 				'mwl' => 'миранд тілі',
 				'my' => 'бирма тілі',
 				'myv' => 'эрзя тілі',
 				'mzn' => 'мазандеран тілі',
 				'na' => 'науру тілі',
 				'nap' => 'неаполитан тілі',
 				'naq' => 'нама тілі',
 				'nb' => 'норвегиялық букмол тілі',
 				'nd' => 'солтүстік ндебеле тілі',
 				'nds' => 'төменгі неміс тілі',
 				'nds_NL' => 'төменгі саксон тілі',
 				'ne' => 'непал тілі',
 				'new' => 'невар тілі',
 				'ng' => 'ндонга тілі',
 				'nia' => 'ниас тілі',
 				'niu' => 'ниуэ тілі',
 				'nl' => 'нидерланд тілі',
 				'nl_BE' => 'фламанд тілі',
 				'nmg' => 'квасио тілі',
 				'nn' => 'норвегиялық нюнорск тілі',
 				'nnh' => 'нгиембун тілі',
 				'no' => 'норвег тілі',
 				'nog' => 'ноғай тілі',
 				'nqo' => 'нко тілі',
 				'nr' => 'оңтүстік ндебеле тілі',
 				'nso' => 'солтүстік сото тілі',
 				'nus' => 'нуэр тілі',
 				'nv' => 'навахо тілі',
 				'ny' => 'ньянджа тілі',
 				'nyn' => 'нианколе тілі',
 				'oc' => 'окситан тілі',
 				'ojb' => 'солтүстік-батыс оджибве тілі',
 				'ojc' => 'орталық оджибве тілі',
 				'ojs' => 'оджи-кри тілі',
 				'ojw' => 'батыс оджибве тілі',
 				'oka' => 'оканаган тілі',
 				'om' => 'оромо тілі',
 				'or' => 'ория тілі',
 				'os' => 'осетин тілі',
 				'osa' => 'осейдж тілі',
 				'pa' => 'пенджаб тілі',
 				'pag' => 'пангасинан тілі',
 				'pam' => 'пампанга тілі',
 				'pap' => 'папьяменто тілі',
 				'pau' => 'палау тілі',
 				'pcm' => 'нигериялық пиджин тілі',
 				'pis' => 'пиджин тілі',
 				'pl' => 'поляк тілі',
 				'pqm' => 'малесит-пассамакводди тілі',
 				'prg' => 'пруссия тілі',
 				'ps' => 'пушту тілі',
 				'pt' => 'португал тілі',
 				'pt_BR' => 'бразилиялық португал тілі',
 				'pt_PT' => 'еуропалық португал тілі',
 				'qu' => 'кечуа тілі',
 				'quc' => 'киче тілі',
 				'raj' => 'раджастани тілі',
 				'rap' => 'рапануй тілі',
 				'rar' => 'раротонган тілі',
 				'rhg' => 'рохинджа',
 				'rm' => 'романш тілі',
 				'rn' => 'рунди тілі',
 				'ro' => 'румын тілі',
 				'ro_MD' => 'молдован тілі',
 				'rof' => 'ромбо тілі',
 				'ru' => 'орыс тілі',
 				'rup' => 'арумын тілі',
 				'rw' => 'киньяруанда тілі',
 				'rwk' => 'руа тілі',
 				'sa' => 'санскрит тілі',
 				'sad' => 'сандаве тілі',
 				'sah' => 'саха тілі',
 				'saq' => 'самбуру тілі',
 				'sat' => 'сантали тілі',
 				'sba' => 'нгамбай тілі',
 				'sbp' => 'сангу тілі',
 				'sc' => 'сардин тілі',
 				'scn' => 'сицилия тілі',
 				'sco' => 'шотланд тілі',
 				'sd' => 'синдхи тілі',
 				'sdh' => 'оңтүстік күрд тілі',
 				'se' => 'солтүстік саам тілі',
 				'seh' => 'сена тілі',
 				'ses' => 'койраборо сенни тілі',
 				'sg' => 'санго тілі',
 				'sh' => 'серб-хорват тілі',
 				'shi' => 'ташелхит тілі',
 				'shn' => 'шан тілі',
 				'si' => 'сингал тілі',
 				'sk' => 'словак тілі',
 				'sl' => 'словен тілі',
 				'slh' => 'оңтүстік лушуцид тілі',
 				'sm' => 'самоа тілі',
 				'sma' => 'оңтүстік саам тілі',
 				'smj' => 'луле саам тілі',
 				'smn' => 'инари саам тілі',
 				'sms' => 'колтта саам тілі',
 				'sn' => 'шона тілі',
 				'snk' => 'сонинке тілі',
 				'so' => 'сомали тілі',
 				'sq' => 'албан тілі',
 				'sr' => 'серб тілі',
 				'srn' => 'сранан тонго тілі',
 				'ss' => 'свати тілі',
 				'ssy' => 'сахо тілі',
 				'st' => 'оңтүстік сото тілі',
 				'str' => 'солтүстік стрейтс тілі',
 				'su' => 'сундан тілі',
 				'suk' => 'сукума тілі',
 				'sv' => 'швед тілі',
 				'sw' => 'суахили тілі',
 				'sw_CD' => 'конго суахили тілі',
 				'swb' => 'комор тілі',
 				'syr' => 'сирия тілі',
 				'ta' => 'тамил тілі',
 				'tce' => 'оңтүстік тутчоне тілі',
 				'te' => 'телугу тілі',
 				'tem' => 'темне тілі',
 				'teo' => 'тесо тілі',
 				'tet' => 'тетум тілі',
 				'tg' => 'тәжік тілі',
 				'tgx' => 'тагиш тілі',
 				'th' => 'тай тілі',
 				'tht' => 'тальтан тілі',
 				'ti' => 'тигринья тілі',
 				'tig' => 'тигре тілі',
 				'tk' => 'түрікмен тілі',
 				'tlh' => 'клингон тілі',
 				'tli' => 'тлинкит тілі',
 				'tn' => 'тсвана тілі',
 				'to' => 'тонган тілі',
 				'tok' => 'токипона тілі',
 				'tpi' => 'ток-писин тілі',
 				'tr' => 'түрік тілі',
 				'trv' => 'тароко тілі',
 				'ts' => 'тсонга тілі',
 				'tt' => 'татар тілі',
 				'ttm' => 'солтүстік тутчоне тілі',
 				'tum' => 'тумбука тілі',
 				'tvl' => 'тувалу тілі',
 				'tw' => 'тви тілі',
 				'twq' => 'тасавак тілі',
 				'ty' => 'таити тілі',
 				'tyv' => 'тувин тілі',
 				'tzm' => 'орталық атлас тамазигхт тілі',
 				'udm' => 'удмурт тілі',
 				'ug' => 'ұйғыр тілі',
 				'uk' => 'украин тілі',
 				'umb' => 'умбунду тілі',
 				'und' => 'белгісіз тіл',
 				'ur' => 'урду тілі',
 				'uz' => 'өзбек тілі',
 				'vai' => 'вай тілі',
 				've' => 'венда тілі',
 				'vec' => 'венеция тілі',
 				'vi' => 'вьетнам тілі',
 				'vo' => 'волапюк тілі',
 				'vun' => 'вунджо тілі',
 				'wa' => 'валлон тілі',
 				'wae' => 'вальзер тілі',
 				'wal' => 'волайта тілі',
 				'war' => 'варай тілі',
 				'wbp' => 'вальбири тілі',
 				'wo' => 'волоф тілі',
 				'wuu' => 'қытай тілі (У)',
 				'xal' => 'қалмақ тілі',
 				'xh' => 'кхоса тілі',
 				'xog' => 'сога тілі',
 				'yav' => 'янгбен тілі',
 				'ybb' => 'йемба тілі',
 				'yi' => 'идиш тілі',
 				'yo' => 'йоруба тілі',
 				'yrl' => 'ньенгату тілі',
 				'yue' => 'кантон тілі',
 				'yue@alt=menu' => 'қытай тілі (кантон)',
 				'zgh' => 'марокколық стандартты тамазигхт тілі',
 				'zh' => 'қытай тілі',
 				'zh@alt=menu' => 'қытай тілі (мандарин)',
 				'zh_Hans' => 'жеңілдетілген қытай тілі',
 				'zh_Hans@alt=long' => 'жеңілдетілген қытай тілі (мандарин)',
 				'zh_Hant' => 'дәстүрлі қытай тілі',
 				'zh_Hant@alt=long' => 'дәстүрлі қытай тілі (мандарин)',
 				'zu' => 'зулу тілі',
 				'zun' => 'зуни тілі',
 				'zxx' => 'тілдік мазмұны жоқ',
 				'zza' => 'заза тілі',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'адлам жазуы',
 			'Aghb' => 'агван жазуы',
 			'Ahom' => 'ахом жазуы',
 			'Arab' => 'араб жазуы',
 			'Aran' => 'насталик жазуы',
 			'Armi' => 'арамей жазуы',
 			'Armn' => 'армян жазуы',
 			'Avst' => 'авеста жазуы',
 			'Bali' => 'балий жазуы',
 			'Bamu' => 'бамум жазуы',
 			'Bass' => 'басса жазуы',
 			'Batk' => 'батак жазуы',
 			'Beng' => 'бенгал жазуы',
 			'Bhks' => 'бхайксуки жазуы',
 			'Bopo' => 'бопомофо жазуы',
 			'Brah' => 'брахми жазуы',
 			'Brai' => 'Брайль жазуы',
 			'Bugi' => 'бугий жазуы',
 			'Buhd' => 'бухид жазуы',
 			'Cakm' => 'чакма жазуы',
 			'Cans' => 'канадалық буын жүйелі жазу',
 			'Cari' => 'карий жазуы',
 			'Cham' => 'чам жазуы',
 			'Cher' => 'чероки жазуы',
 			'Chrs' => 'хорезм жазуы',
 			'Copt' => 'копт жазуы',
 			'Cpmn' => 'кипр-миной жазуы',
 			'Cprt' => 'кипр жазуы',
 			'Cyrl' => 'кирилл жазуы',
 			'Deva' => 'деванагари жазуы',
 			'Diak' => 'дивехи акуру жазуы',
 			'Dogr' => 'догри жазуы',
 			'Dsrt' => 'дезерет жазуы',
 			'Dupl' => 'дюплойе жазуы',
 			'Egyp' => 'мысыр жазуы',
 			'Elba' => 'эльбасан жазуы',
 			'Elym' => 'элимай жазуы',
 			'Ethi' => 'эфиопиялық жазу',
 			'Geor' => 'грузин жазуы',
 			'Glag' => 'глаголица',
 			'Gong' => 'гунджала гонди жазуы',
 			'Gonm' => 'масарам гонди жазуы',
 			'Goth' => 'гот жазуы',
 			'Gran' => 'грантха жазуы',
 			'Grek' => 'грек жазуы',
 			'Gujr' => 'гуджарати жазуы',
 			'Guru' => 'гурмукхи жазуы',
 			'Hanb' => 'ханб жазуы',
 			'Hang' => 'хангыл жазуы',
 			'Hani' => 'қытай жазуы',
 			'Hano' => 'хануну жазуы',
 			'Hans' => 'жеңілдетілген жазу',
 			'Hans@alt=stand-alone' => 'жеңілдетілген қытай иероглифы',
 			'Hant' => 'дәстүрлі жазу',
 			'Hant@alt=stand-alone' => 'дәстүрлі қытай иероглифы',
 			'Hatr' => 'хатра жазуы',
 			'Hebr' => 'иврит жазуы',
 			'Hira' => 'хирагана жазуы',
 			'Hluw' => 'Анадолы иероглифтері',
 			'Hmng' => 'пахау жазуы',
 			'Hmnp' => 'ньиакенг пуачуэ хмонг жазуы',
 			'Hrkt' => 'хирагана немесе катакана',
 			'Hung' => 'мажар рунасы',
 			'Ital' => 'ескі италия жазуы',
 			'Jamo' => 'джамо жазуы',
 			'Java' => 'ява жазуы',
 			'Jpan' => 'жапон жазуы',
 			'Kali' => 'кая-ли жазуы',
 			'Kana' => 'катакана жазуы',
 			'Kawi' => 'кави жазуы',
 			'Khar' => 'кхароштхи жазуы',
 			'Khmr' => 'кхмер жазуы',
 			'Khoj' => 'ходжики жазуы',
 			'Kits' => 'шағын кидан жазуы',
 			'Knda' => 'каннада жазуы',
 			'Kore' => 'корей жазуы',
 			'Kthi' => 'кайтхи жазуы',
 			'Lana' => 'ланна жазуы',
 			'Laoo' => 'лаос жазуы',
 			'Latn' => 'латын жазуы',
 			'Lepc' => 'лепча жазуы',
 			'Limb' => 'лимбу жазуы',
 			'Lina' => 'A линиялық жазуы',
 			'Linb' => 'B линиялық жазуы',
 			'Lisu' => 'фрейзер жазуы',
 			'Lyci' => 'ликий жазуы',
 			'Lydi' => 'лидий жазуы',
 			'Mahj' => 'махаджани жазуы',
 			'Maka' => 'макасар жазуы',
 			'Mand' => 'мандей жазуы',
 			'Mani' => 'манихей жазуы',
 			'Marc' => 'марчен жазуы',
 			'Medf' => 'обэри окаимэ жазуы',
 			'Mend' => 'кикакуи жазуы',
 			'Merc' => 'мероит курсив жазуы',
 			'Mero' => 'мероит жазуы',
 			'Mlym' => 'малаялам жазуы',
 			'Modi' => 'моди жазуы',
 			'Mong' => 'моңғол жазуы',
 			'Mroo' => 'мро жазуы',
 			'Mtei' => 'мейтей жазуы',
 			'Mult' => 'мултани жазуы',
 			'Mymr' => 'мьянма жазуы',
 			'Nagm' => 'наг мундари жазуы',
 			'Nand' => 'нандинагари жазуы',
 			'Narb' => 'көне солтүстік араб жазуы',
 			'Nbat' => 'набатей жазуы',
 			'Newa' => 'ньюа жазуы',
 			'Nkoo' => 'нко жазуы',
 			'Nshu' => 'нюй-шу жазуы',
 			'Ogam' => 'огам жазуы',
 			'Olck' => 'ол-чики жазуы',
 			'Orkh' => 'көне түркі жазбалары',
 			'Orya' => 'ория жазуы',
 			'Osge' => 'осейдж жазуы',
 			'Osma' => 'исмания жазуы',
 			'Ougr' => 'көне ұйғыр жазуы',
 			'Palm' => 'палмир жазуы',
 			'Pauc' => 'пау син хау жазуы',
 			'Perm' => 'көне перм жазуы',
 			'Phag' => 'тибет-моңғол жазуы',
 			'Phli' => 'жазба пехлеви',
 			'Phlp' => 'забур пехлеви жазуы',
 			'Phnx' => 'финикия жазуы',
 			'Plrd' => 'поллард фонетикалық жазуы',
 			'Prti' => 'жазба парфия',
 			'Qaag' => 'зоджи жазуы',
 			'Rjng' => 'реджанг жазуы',
 			'Rohg' => 'ханифи жазуы',
 			'Runr' => 'руна',
 			'Samr' => 'самария жазуы',
 			'Sarb' => 'оңтүстік араб жазуы',
 			'Saur' => 'саураштра жазуы',
 			'Sgnw' => 'жазу',
 			'Shaw' => 'шоу жазуы',
 			'Shrd' => 'шарада жазуы',
 			'Sidd' => 'сиддхам жазуы',
 			'Sind' => 'кхудавади жазуы',
 			'Sinh' => 'сингаль жазуы',
 			'Sogd' => 'соғды жазуы',
 			'Sogo' => 'көне соғды жазуы',
 			'Sora' => 'соранг сомпенг жазуы',
 			'Soyo' => 'соёмбо жазуы',
 			'Sund' => 'сунд жазуы',
 			'Sylo' => 'силхет нагари жазуы',
 			'Syrc' => 'сирия жазуы',
 			'Tagb' => 'тагбанва жазуы',
 			'Takr' => 'такри жазуы',
 			'Tale' => 'лы жазуы',
 			'Talu' => 'жаңа лы жазуы',
 			'Taml' => 'тамиль жазуы',
 			'Tang' => 'танғұт жазуы',
 			'Tavt' => 'тай вьет жазуы',
 			'Telu' => 'телугу жазуы',
 			'Tfng' => 'тифинаг жазуы',
 			'Tglg' => 'байбайин жазуы',
 			'Thaa' => 'тана жазуы',
 			'Thai' => 'тай жазуы',
 			'Tibt' => 'тибет жазуы',
 			'Tirh' => 'тирхута жазуы',
 			'Tnsa' => 'тангса жазуы',
 			'Toto' => 'тото жазуы',
 			'Ugar' => 'угарит жазуы',
 			'Vaii' => 'ваи жазуы',
 			'Vith' => 'виткути жазуы',
 			'Wara' => 'варанг кшити жазуы',
 			'Wcho' => 'ванчо жазуы',
 			'Xpeo' => 'көне парсы жазуы',
 			'Xsux' => 'шумер-аккад сына жазуы',
 			'Yezi' => 'езид жазуы',
 			'Yiii' => 'и жазуы',
 			'Zanb' => 'занабазар шаршы жазуы',
 			'Zinh' => 'мұра етілген',
 			'Zmth' => 'математикалық жазу',
 			'Zsye' => 'эмодзи',
 			'Zsym' => 'таңбалар',
 			'Zxxx' => 'жазусыз',
 			'Zyyy' => 'жалпы',
 			'Zzzz' => 'белгісіз жазу',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'әлем',
 			'002' => 'Африка',
 			'003' => 'Солтүстік Америка',
 			'005' => 'Оңтүстік Америка',
 			'009' => 'Океания',
 			'011' => 'Батыс Африка',
 			'013' => 'Орталық Америка',
 			'014' => 'Шығыс Африка',
 			'015' => 'Солтүстік Африка',
 			'017' => 'Орталық Африка',
 			'018' => 'Оңтүстік Африка аймағы',
 			'019' => 'Америка',
 			'021' => 'Солтүстік Америка (аймақ)',
 			'029' => 'Кариб',
 			'030' => 'Шығыс Азия',
 			'034' => 'Оңтүстік Азия',
 			'035' => 'Оңтүстік-Шығыс Азия',
 			'039' => 'Оңтүстік Еуропа',
 			'053' => 'Аустралазия',
 			'054' => 'Меланезия',
 			'057' => 'Микронезия аймағы',
 			'061' => 'Полинезия',
 			'142' => 'Азия',
 			'143' => 'Орталық Азия',
 			'145' => 'Батыс Азия',
 			'150' => 'Еуропа',
 			'151' => 'Шығыс Еуропа',
 			'154' => 'Солтүстік Еуропа',
 			'155' => 'Батыс Еуропа',
 			'202' => 'Субсахаралық Африка',
 			'419' => 'Латын Америкасы',
 			'AC' => 'Әскенжін аралы',
 			'AD' => 'Андорра',
 			'AE' => 'Біріккен Араб Әмірліктері',
 			'AF' => 'Ауғанстан',
 			'AG' => 'Антигуа және Барбуда',
 			'AI' => 'Ангилья',
 			'AL' => 'Албания',
 			'AM' => 'Армения',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктида',
 			'AR' => 'Аргентина',
 			'AS' => 'Америкалық Самоа',
 			'AT' => 'Аустрия',
 			'AU' => 'Аустралия',
 			'AW' => 'Аруба',
 			'AX' => 'Аланд аралдары',
 			'AZ' => 'Әзірбайжан',
 			'BA' => 'Босния және Герцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Бельгия',
 			'BF' => 'Буркина-Фасо',
 			'BG' => 'Болгария',
 			'BH' => 'Бахрейн',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Сен-Бартелеми',
 			'BM' => 'Бермуд аралдары',
 			'BN' => 'Бруней',
 			'BO' => 'Боливия',
 			'BQ' => 'Бонэйр, Синт-Эстатиус және Саба',
 			'BR' => 'Бразилия',
 			'BS' => 'Багам аралдары',
 			'BT' => 'Бутан',
 			'BV' => 'Буве аралы',
 			'BW' => 'Ботсвана',
 			'BY' => 'Беларусь',
 			'BZ' => 'Белиз',
 			'CA' => 'Канада',
 			'CC' => 'Кокос (Килинг) аралдары',
 			'CD' => 'Конго',
 			'CD@alt=variant' => 'Конго Демократиялық Республикасы',
 			'CF' => 'Орталық Африка Республикасы',
 			'CG' => 'Конго-Браззавиль Республикасы',
 			'CG@alt=variant' => 'Конго Республикасы',
 			'CH' => 'Швейцария',
 			'CI' => 'Кот-д’Ивуар',
 			'CK' => 'Кук аралдары',
 			'CL' => 'Чили',
 			'CM' => 'Камерун',
 			'CN' => 'Қытай',
 			'CO' => 'Колумбия',
 			'CP' => 'Клиппертон аралы',
 			'CR' => 'Коста-Рика',
 			'CU' => 'Куба',
 			'CV' => 'Кабо-Верде',
 			'CW' => 'Кюрасао',
 			'CX' => 'Рождество аралы',
 			'CY' => 'Кипр',
 			'CZ' => 'Чехия',
 			'CZ@alt=variant' => 'Чех Республикасы',
 			'DE' => 'Германия',
 			'DG' => 'Диего-Гарсия',
 			'DJ' => 'Джибути',
 			'DK' => 'Дания',
 			'DM' => 'Доминика',
 			'DO' => 'Доминикан Республикасы',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута және Мелилья',
 			'EC' => 'Эквадор',
 			'EE' => 'Эстония',
 			'EG' => 'Мысыр',
 			'EH' => 'Батыс Сахара',
 			'ER' => 'Эритрея',
 			'ES' => 'Испания',
 			'ET' => 'Эфиопия',
 			'EU' => 'Еуропалық Одақ',
 			'EZ' => 'Еуроаймақ',
 			'FI' => 'Финляндия',
 			'FJ' => 'Фиджи',
 			'FK' => 'Фолкленд аралдары',
 			'FK@alt=variant' => 'Фолкленд аралдары (Мальвин аралдары)',
 			'FM' => 'Микронезия',
 			'FO' => 'Фарер аралдары',
 			'FR' => 'Франция',
 			'GA' => 'Габон',
 			'GB' => 'Ұлыбритания',
 			'GD' => 'Гренада',
 			'GE' => 'Грузия',
 			'GF' => 'Француз Гвианасы',
 			'GG' => 'Гернси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренландия',
 			'GM' => 'Гамбия',
 			'GN' => 'Гвинея',
 			'GP' => 'Гваделупа',
 			'GQ' => 'Экваторлық Гвинея',
 			'GR' => 'Грекия',
 			'GS' => 'Оңтүстік Георгия және Оңтүстік Сандвич аралдары',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвинея-Бисау',
 			'GY' => 'Гайана',
 			'HK' => 'Сянган АӘА',
 			'HK@alt=short' => 'Сянган',
 			'HM' => 'Херд аралы және Макдональд аралдары',
 			'HN' => 'Гондурас',
 			'HR' => 'Хорватия',
 			'HT' => 'Гаити',
 			'HU' => 'Венгрия',
 			'IC' => 'Канар аралдары',
 			'ID' => 'Индонезия',
 			'IE' => 'Ирландия',
 			'IL' => 'Израиль',
 			'IM' => 'Мэн аралы',
 			'IN' => 'Үндістан',
 			'IO' => 'Үнді мұхитындағы Британ аймағы',
 			'IO@alt=chagos' => 'Чагос архипелагі',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исландия',
 			'IT' => 'Италия',
 			'JE' => 'Джерси',
 			'JM' => 'Ямайка',
 			'JO' => 'Иордания',
 			'JP' => 'Жапония',
 			'KE' => 'Кения',
 			'KG' => 'Қырғызстан',
 			'KH' => 'Камбоджа',
 			'KI' => 'Кирибати',
 			'KM' => 'Комор аралдары',
 			'KN' => 'Сент-Китс және Невис',
 			'KP' => 'Солтүстік Корея',
 			'KR' => 'Оңтүстік Корея',
 			'KW' => 'Кувейт',
 			'KY' => 'Кайман аралдары',
 			'KZ' => 'Қазақстан',
 			'LA' => 'Лаос',
 			'LB' => 'Ливан',
 			'LC' => 'Сент-Люсия',
 			'LI' => 'Лихтенштейн',
 			'LK' => 'Шри-Ланка',
 			'LR' => 'Либерия',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Люксембург',
 			'LV' => 'Латвия',
 			'LY' => 'Ливия',
 			'MA' => 'Марокко',
 			'MC' => 'Монако',
 			'MD' => 'Молдова',
 			'ME' => 'Черногория',
 			'MF' => 'Сен-Мартен',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршалл аралдары',
 			'MK' => 'Солтүстік Македония',
 			'ML' => 'Мали',
 			'MM' => 'Мьянма (Бирма)',
 			'MN' => 'Моңғолия',
 			'MO' => 'Макао АӘА',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Солтүстік Мариана аралдары',
 			'MQ' => 'Мартиника',
 			'MR' => 'Мавритания',
 			'MS' => 'Монтсеррат',
 			'MT' => 'Мальта',
 			'MU' => 'Маврикий',
 			'MV' => 'Мальдив аралдары',
 			'MW' => 'Малави',
 			'MX' => 'Мексика',
 			'MY' => 'Малайзия',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибия',
 			'NC' => 'Жаңа Каледония',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолк аралы',
 			'NG' => 'Нигерия',
 			'NI' => 'Никарагуа',
 			'NL' => 'Нидерланд',
 			'NO' => 'Норвегия',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуэ',
 			'NZ' => 'Жаңа Зеландия',
 			'NZ@alt=variant' => 'Аотеароа, Жаңа Зеландия',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Француз Полинезиясы',
 			'PG' => 'Папуа — Жаңа Гвинея',
 			'PH' => 'Филиппин аралдары',
 			'PK' => 'Пәкістан',
 			'PL' => 'Польша',
 			'PM' => 'Сен-Пьер және Микелон',
 			'PN' => 'Питкэрн аралдары',
 			'PR' => 'Пуэрто-Рико',
 			'PS' => 'Палестина аймақтары',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португалия',
 			'PW' => 'Палау',
 			'PY' => 'Парагвай',
 			'QA' => 'Катар',
 			'QO' => 'Сыртқы Океания',
 			'RE' => 'Реюньон',
 			'RO' => 'Румыния',
 			'RS' => 'Сербия',
 			'RU' => 'Ресей',
 			'RW' => 'Руанда',
 			'SA' => 'Сауд Арабиясы',
 			'SB' => 'Соломон аралдары',
 			'SC' => 'Сейшель аралдары',
 			'SD' => 'Судан',
 			'SE' => 'Швеция',
 			'SG' => 'Сингапур',
 			'SH' => 'Әулие Елена аралы',
 			'SI' => 'Словения',
 			'SJ' => 'Шпицберген және Ян-Майен',
 			'SK' => 'Словакия',
 			'SL' => 'Сьерра-Леоне',
 			'SM' => 'Сан-Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомали',
 			'SR' => 'Суринам',
 			'SS' => 'Оңтүстік Судан',
 			'ST' => 'Сан-Томе және Принсипи',
 			'SV' => 'Сальвадор',
 			'SX' => 'Синт-Мартен',
 			'SY' => 'Сирия',
 			'SZ' => 'Эсватини',
 			'SZ@alt=variant' => 'Свазиленд',
 			'TA' => 'Тристан-да-Кунья',
 			'TC' => 'Теркс және Кайкос аралдары',
 			'TD' => 'Чад',
 			'TF' => 'Францияның оңтүстік аймақтары',
 			'TG' => 'Того',
 			'TH' => 'Таиланд',
 			'TJ' => 'Тәжікстан',
 			'TK' => 'Токелау',
 			'TL' => 'Тимор-Лесте',
 			'TL@alt=variant' => 'Шығыс Тимор',
 			'TM' => 'Түрікменстан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Түркия',
 			'TT' => 'Тринидад және Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тайвань',
 			'TZ' => 'Танзания',
 			'UA' => 'Украина',
 			'UG' => 'Уганда',
 			'UM' => 'АҚШ-тың сыртқы кіші аралдары',
 			'UN' => 'Біріккен Ұлттар Ұйымы',
 			'UN@alt=short' => 'БҰҰ',
 			'US' => 'Америка Құрама Штаттары',
 			'US@alt=short' => 'АҚШ',
 			'UY' => 'Уругвай',
 			'UZ' => 'Өзбекстан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент-Винсент және Гренадин аралдары',
 			'VE' => 'Венесуэла',
 			'VG' => 'Британдық Виргин аралдары',
 			'VI' => 'АҚШ-тың Виргин аралдары',
 			'VN' => 'Вьетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Уоллис және Футуна',
 			'WS' => 'Самоа',
 			'XA' => 'жалған акцент',
 			'XB' => 'жалған Bidi',
 			'XK' => 'Косово',
 			'YE' => 'Йемен',
 			'YT' => 'Майотта',
 			'ZA' => 'Оңтүстік Африка',
 			'ZM' => 'Замбия',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Белгісіз аймақ',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'1901' => 'Дәстүрлі неміс орфографиясы',
 			'1994' => 'Стандартты резия орфографиясы',
 			'1996' => '1996 жылға дейінгі неміс орфографиясы',
 			'1606NICT' => '1606 жылға дейінгі бергі орта француз тілі',
 			'1694ACAD' => 'Ерте орта француз тілі',
 			'1959ACAD' => 'Академиялық',
 			'ABL1943' => '1943 жылғы орфографияның қалыптасуы',
 			'AKUAPEM' => 'АКУАПЕМ',
 			'ALALC97' => 'ALA-LC романизациясы, 1997 жылғы нұсқа',
 			'ALUKU' => 'Алуку диалектісі',
 			'AO1990' => 'Португал тілінің 1990 жылғы орфографиялық келісімі',
 			'ARANES' => 'АРАН',
 			'AREVELA' => 'Шығыс армян',
 			'AREVMDA' => 'Батыс армян',
 			'ARKAIKA' => 'АРКАИКА',
 			'ASANTE' => 'АШАНТИ',
 			'AUVERN' => 'ОВЕРН',
 			'BAKU1926' => 'Жалпы түрік әліпбиі',
 			'BALANKA' => 'Ании баланка диалектісі',
 			'BARLA' => 'Кабувердиану Барлавенто диалект тобы',
 			'BASICENG' => 'БЕЙСИК-ИНГЛИШ',
 			'BAUDDHA' => 'БАДДА',
 			'BISCAYAN' => 'БИСКАЙ',
 			'BISKE' => 'Сан-Джорджо/Била диалектісі',
 			'BOHORIC' => 'Бохорича әліпбиі',
 			'BOONT' => 'Бунтлинг',
 			'BORNHOLM' => 'Борнхольм',
 			'CISAUP' => 'СИЗАУП',
 			'COLB1945' => '1945 жылғы бразилиялық португал тілі конвенциясы',
 			'CORNU' => 'КОРНУ',
 			'CREISS' => 'КРЕЙС',
 			'DAJNKO' => 'Дайнко әліпбиі',
 			'EKAVSK' => 'Серб тілінің экав айтылымы',
 			'EMODENG' => 'Ерте орта ағылшын тілі',
 			'FONIPA' => 'Халықаралық фонетикалық әліпби',
 			'FONKIRSH' => 'ФОНКИРШ',
 			'FONNAPA' => 'ФОННАПА',
 			'FONUPA' => 'Орал фонетикалық әліпби',
 			'FONXSAMP' => 'ФОНКСАМП',
 			'GALLO' => 'ГАЛЛО',
 			'GASCON' => 'ГАСКОН',
 			'GRCLASS' => 'ГРКЛАСС',
 			'GRITAL' => 'ГРИТАЛ',
 			'GRMISTR' => 'ГРМИСТР',
 			'HEPBURN' => 'Хэпбёрн жүйесі',
 			'HOGNORSK' => 'ХЕГНОРСК',
 			'HSISTEMO' => 'H ЖҮЙЕСІ',
 			'IJEKAVSK' => 'Серб тілінің иекав айтылымы',
 			'ITIHASA' => 'ИТИХАСА',
 			'IVANCHOV' => 'ИВАНЧОВ',
 			'JAUER' => 'ЯУЭР',
 			'JYUTPING' => 'ЮТПХИН',
 			'KKCOR' => 'Жалпы орфография',
 			'KOCIEWIE' => 'КОЧЕВЕ',
 			'KSCOR' => 'Стандартты орфография',
 			'LAUKIKA' => 'ЛАУКИКА',
 			'LEMOSIN' => 'ЛИМУЗЕН',
 			'LENGADOC' => 'ЛАНГЕДОК',
 			'LIPAW' => 'Резия тілінің липоваз диалектісі',
 			'LUNA1918' => 'ЛУНА1918',
 			'METELKO' => 'МЕТЕЛКО',
 			'MONOTON' => 'Монотонды',
 			'NDYUKA' => 'НДЮКА',
 			'NEDIS' => 'Натисон диалектісі',
 			'NEWFOUND' => 'НЬЮФАУНД',
 			'NICARD' => 'НИКАРД',
 			'NJIVA' => 'Гнива/нджива диалектісі',
 			'NULIK' => 'Заманауи волапюк',
 			'OSOJS' => 'Осеакко/осожане диалектісі',
 			'OXENDICT' => 'Ағылшын тілінің Оксфорд сөздігіндегі емлесі',
 			'PAHAWH2' => 'ПАХАВХ2',
 			'PAHAWH3' => 'ПАХАВХ3',
 			'PAHAWH4' => 'ПАХАВХ4',
 			'PAMAKA' => 'Памака диалектісі',
 			'PEANO' => 'ПЕАНО',
 			'PETR1708' => 'ПЕТР1708',
 			'PINYIN' => 'Пинин романизациясы',
 			'POLYTON' => 'Политонды',
 			'POSIX' => 'Компьютер',
 			'PROVENC' => 'ПРОВАНС',
 			'PUTER' => 'ПУТЕР',
 			'REVISED' => 'Қайта қаралған орфография',
 			'RIGIK' => 'Классикалық волапюк',
 			'ROZAJ' => 'Резия',
 			'RUMGR' => 'РУМГР',
 			'SAAHO' => 'Сахо',
 			'SCOTLAND' => 'Шотландияның стандартты ағылшын тілі',
 			'SCOUSE' => 'Скауз',
 			'SIMPLE' => 'ҚАРАПАЙЫМ',
 			'SOLBA' => 'Столвица/солбика диалектісі',
 			'SOTAV' => 'Кабувердьянудың сотавенто диалект тобы',
 			'SPANGLIS' => 'СПАНГЛИШ',
 			'SURMIRAN' => 'СУРМИРАН',
 			'SURSILV' => 'СУРСИЛВ',
 			'SUTSILV' => 'СУТСИЛВ',
 			'SYNNEJYL' => 'СИННЕДЖИЛ',
 			'TARASK' => 'Тарашкевица',
 			'TONGYONG' => 'ТУНЪЮН-ПИНЬИНЬ',
 			'TUNUMIIT' => 'ТУНУМИИТ',
 			'UCCOR' => 'Бірыңғай орфография',
 			'UCRCOR' => 'Бірыңғай қайта қаралған орфография',
 			'ULSTER' => 'ОЛСТЕР',
 			'UNIFON' => 'Юнифон фонетикалық әліпбиі',
 			'VAIDIKA' => 'ВАЙДИКА',
 			'VALENCIA' => 'Валенсия',
 			'VALLADER' => 'ВАЛЛАДЕР',
 			'VECDRUKA' => 'ВЕЧДРУКА',
 			'VIVARAUP' => 'ВИВАРО-АЛЬПІ',
 			'WADEGILE' => 'Уейд-Джайлс жүйесі',
 			'XSISTEMO' => 'X ЖҮЙЕСІ',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'Күнтізбе',
 			'cf' => 'Валюта форматы',
 			'collation' => 'Сұрыптау реті',
 			'currency' => 'Валюта',
 			'hc' => 'Уақыт форматы (12 не 24)',
 			'lb' => 'Жолды тасымалдау стилі',
 			'ms' => 'Өлшемдер жүйесі',
 			'numbers' => 'Сандар',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{Будда күнтізбесі},
 				'chinese' => q{Қытай күнтізбесі},
 				'coptic' => q{Копт күнтізбесі},
 				'dangi' => q{Данги күнтізбесі},
 				'ethiopic' => q{Эфиопия күнтізбесі},
 				'ethiopic-amete-alem' => q{Эфиопияның Амете-Алем күнтізбесі},
 				'gregorian' => q{Грегориандық күнтізбе},
 				'hebrew' => q{Көне еврей күнтізбесі},
 				'indian' => q{Үндістанның ұлттық күнтізбесі},
 				'islamic' => q{Ислам күнтізбесі},
 				'islamic-civil' => q{Ислам күнтізбесі (кестелік, азаматтық дәуір)},
 				'islamic-rgsa' => q{Ислам күнтізбесі (Сауд Арабиясы, жаңа ай)},
 				'islamic-tbla' => q{Ислам күнтізбесі (кестелік, астрономиялық дәуір)},
 				'islamic-umalqura' => q{Ислам күнтізбесі (Умм аль-Кура)},
 				'iso8601' => q{ISO-8601 күнтізбесі},
 				'japanese' => q{Жапон күнтізбесі},
 				'persian' => q{Парсы күнтізбесі},
 				'roc' => q{Мингуо күнтізбесі},
 			},
 			'cf' => {
 				'account' => q{Есептік валюта форматы},
 				'standard' => q{Стандартты валюта форматы},
 			},
 			'collation' => {
 				'big5han' => q{Дәстүрлі қытай тілінің сұрыптау реті - Big5},
 				'compat' => q{Сәйкестікке арналған алдыңғы сұрыптау реті},
 				'dictionary' => q{Сөздік бойынша сұрыптау реті},
 				'ducet' => q{Әдепкі уникод сұрыптау реті},
 				'emoji' => q{Эмоджи сұрыптау реті},
 				'eor' => q{Еуропалық реттеу ережелері},
 				'gb2312han' => q{Жеңілдетілген қытай тілінің сұрыптау реті - GB2312},
 				'phonebook' => q{Телефон кітапшасының сұрыптау реті},
 				'pinyin' => q{Пиньинь сұрыптау реті},
 				'reformed' => q{Қайта қарастырылған сұрыптау реті},
 				'search' => q{Жалпы мақсаттағы іздеу},
 				'searchjl' => q{Корей тілінің бастапқы дауыссызы бойынша іздеу},
 				'standard' => q{Стандартты сұрыптау реті},
 				'stroke' => q{Иероглифтер сызықтарын сұрыптау реті},
 				'traditional' => q{Дәстүрлі сұрыптау реті},
 				'unihan' => q{Иероглифтер сызықтарын түбегейлі сұрыптау реті},
 				'zhuyin' => q{Чжуинь сұрыптау реті},
 			},
 			'hc' => {
 				'h11' => q{12 сағаттық жүйе (0–11)},
 				'h12' => q{12 сағаттық жүйе (1–12)},
 				'h23' => q{24 сағаттық жүйе (0–23)},
 				'h24' => q{24 сағаттық жүйе (1–24)},
 			},
 			'lb' => {
 				'loose' => q{Жолды тасымалдаудың еркін стилі},
 				'normal' => q{Жолды тасымалдаудың қалыпты стилі},
 				'strict' => q{Жолды тасымалдаудың қатаң стилі},
 			},
 			'ms' => {
 				'metric' => q{Метрлік жүйе},
 				'uksystem' => q{Британиялық өлшемдер жүйесі},
 				'ussystem' => q{Америкалық өлшемдер жүйесі},
 			},
 			'numbers' => {
 				'ahom' => q{Ахом цифрлары},
 				'arab' => q{Үнді-араб сандары},
 				'arabext' => q{Үнді-араб сандарының кеңейтілген жүйесі},
 				'armn' => q{Армян сандары},
 				'armnlow' => q{Кіші әріппен берілген армян сандары},
 				'bali' => q{Балий цифрлары},
 				'beng' => q{Бенгал сандары},
 				'brah' => q{Брахми цифрлары},
 				'cakm' => q{Чакма цифрлары},
 				'cham' => q{Чам цифрлары},
 				'cyrl' => q{Кириллица сандары},
 				'deva' => q{Деванагари сандары},
 				'diak' => q{Дивес акуру цифрлары},
 				'ethi' => q{Эфиопия сандары},
 				'fullwide' => q{Толық енді цифрлар},
 				'geor' => q{Грузин сандары},
 				'gong' => q{Гунджала гонди цифрлары},
 				'gonm' => q{Масарама гонди цифрлары},
 				'grek' => q{Грек сандары},
 				'greklow' => q{Кіші әріппен берілген грек сандары},
 				'gujr' => q{Гуджарати сандары},
 				'guru' => q{Гурмукхи сандары},
 				'hanidec' => q{Қытай ондық сандары},
 				'hans' => q{Жеңілдетілген қытай сандары},
 				'hansfin' => q{Қаржы саласындағы жеңілдетілген қытай сандары},
 				'hant' => q{Дәстүрлі қытай сандары},
 				'hantfin' => q{Қаржы саласындағы дәстүрлі қытай сандары},
 				'hebr' => q{Иврит сандары},
 				'hmng' => q{Пахау цифрлары},
 				'hmnp' => q{Ньякенг пуачуэ хмонг цифрлары},
 				'java' => q{Ява цифрлары},
 				'jpan' => q{Жапон сандары},
 				'jpanfin' => q{Қаржы саласындағы жапон сандары},
 				'kali' => q{Кайях ли цифрлары},
 				'kawi' => q{Кави цифрлары},
 				'khmr' => q{Кхмер сандары},
 				'knda' => q{Каннада сандары},
 				'lana' => q{Тай тхам хора цифрдары},
 				'lanatham' => q{Тай тхам тхам цифрдары},
 				'laoo' => q{Лаос сандары},
 				'latn' => q{Батыс сандары},
 				'lepc' => q{Лепча цифрлары},
 				'limb' => q{Лимбу цифрлары},
 				'mathbold' => q{Математикалық қалың қаріпті цифрлар},
 				'mathdbl' => q{Математикалық қос сызықты цифрлар},
 				'mathmono' => q{Ені бекітілген математикалық цифрлар},
 				'mathsanb' => q{Математикалық қалың қаріпті сансериф цифрлары},
 				'mathsans' => q{Математикалық сансериф цифрлары},
 				'mlym' => q{Малаялам сандары},
 				'modi' => q{Моди цифрлары},
 				'mong' => q{Моңғол цифрлары},
 				'mroo' => q{Мро цифрлары},
 				'mtei' => q{Мейтей-майек цифрлары},
 				'mymr' => q{Мьянма сандары},
 				'mymrshan' => q{Мьянма шан цифрлары},
 				'mymrtlng' => q{Мьянма тай лэнг цифрлары},
 				'nagm' => q{Наг мундари цифрлары},
 				'nkoo' => q{Н’ко цифрлары},
 				'olck' => q{Ол-чики цифрлары},
 				'orya' => q{Ория сандары},
 				'osma' => q{Исмания цифрлары},
 				'rohg' => q{Ханифи цифрлары},
 				'roman' => q{Рим сандары},
 				'romanlow' => q{Кіші әріппен берілген рим сандары},
 				'saur' => q{Саураштра цифрлары},
 				'shrd' => q{Шарада цифрлары},
 				'sind' => q{Кхудабади цифрлары},
 				'sinh' => q{Сингала лит цифрлары},
 				'sora' => q{Сора сомпенг цифрлары},
 				'sund' => q{Сунда цифрлары},
 				'takr' => q{Такри цифрлары},
 				'talu' => q{Жаңа лы жазуының цифрлары},
 				'taml' => q{Дәстүрлі тамил сандары},
 				'tamldec' => q{Тамил сандары},
 				'telu' => q{Телугу сандары},
 				'thai' => q{Тай сандары},
 				'tibt' => q{Тибет сандары},
 				'tirh' => q{Тирхута цифрлары},
 				'tnsa' => q{Тангса цифрлары},
 				'vaii' => q{Вай цифрлары},
 				'wara' => q{Варанг сити цифрлары},
 				'wcho' => q{Ванчо цифрлары},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{Метрлік},
 			'UK' => q{Ағылшын},
 			'US' => q{Америкалық},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'Тіл: {0}',
 			'script' => 'Жазу: {0}',
 			'region' => 'Аймақ: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			index => ['А', 'Ә', 'Б', 'В', 'Г', 'Ғ', 'Д', 'Е', 'Ё', 'Ж', 'З', 'И', 'Й', 'К', 'Қ', 'Л', 'М', 'Н', 'Ң', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'У', 'Ұ', 'Ү', 'Ф', 'Х', 'Һ', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'І', 'Ь', 'Э', 'Ю', 'Я'],
			main => qr{[а ә б в г ғ д е ё ж з и й к қ л м н ң о ө п р с т у ұ ү ф х һ ц ч ш щ ъ ы і ь э ю я]},
			numbers => qr{[  \- ‑ , % ‰ + 0 1 2 3 4 5 6 7 8 9]},
			punctuation => qr{[\- ‐‑ – — , ; \: ! ? . … '‘’ "“” « » ( ) \[ \] \{ \} § @ * / \& #]},
		};
	},
EOT
: sub {
		return { index => ['А', 'Ә', 'Б', 'В', 'Г', 'Ғ', 'Д', 'Е', 'Ё', 'Ж', 'З', 'И', 'Й', 'К', 'Қ', 'Л', 'М', 'Н', 'Ң', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'У', 'Ұ', 'Ү', 'Ф', 'Х', 'Һ', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'І', 'Ь', 'Э', 'Ю', 'Я'], };
},
);


has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{«},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{»},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(негізгі бағыт),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(негізгі бағыт),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(киби{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(киби{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(меби{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(меби{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(гиби{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(гиби{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(теби{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(теби{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(пеби{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(пеби{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(эксби{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(эксби{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(зеби{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(зеби{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(йоби{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(йоби{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(деци{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(деци{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(пико{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(пико{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(фемто{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(фемто{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(атто{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(атто{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(санти{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(санти{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(зепто{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(зепто{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(йокто{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(йокто{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(ронто{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(ронто{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(милли{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(милли{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(квекто{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(квекто{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(микро{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(микро{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(нано{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(нано{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(дека{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(дека{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(тера{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(тера{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(пета{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(пета{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(экса{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(экса{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(гекто{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(гекто{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(зетта{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(зетта{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(йотта{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(йотта{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(ронна{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(ронна{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(кило{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(кило{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(кветта{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(кветта{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(мега{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(мега{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(гига{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(гига{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'one' => q({0} гравитациялық күш),
						'other' => q({0} гравитациялық күш),
					},
					# Core Unit Identifier
					'g-force' => {
						'one' => q({0} гравитациялық күш),
						'other' => q({0} гравитациялық күш),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(метр/шаршы секунд),
						'one' => q({0} метр/шаршы секунд),
						'other' => q({0} метр/шаршы секунд),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(метр/шаршы секунд),
						'one' => q({0} метр/шаршы секунд),
						'other' => q({0} метр/шаршы секунд),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(аркминут),
						'one' => q({0} аркминут),
						'other' => q({0} аркминут),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(аркминут),
						'one' => q({0} аркминут),
						'other' => q({0} аркминут),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(арксекунд),
						'one' => q({0} арксекунд),
						'other' => q({0} арксекунд),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(арксекунд),
						'one' => q({0} арксекунд),
						'other' => q({0} арксекунд),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'one' => q({0} радиан),
						'other' => q({0} радиан),
					},
					# Core Unit Identifier
					'radian' => {
						'one' => q({0} радиан),
						'other' => q({0} радиан),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(айналым),
						'one' => q({0} айналым),
						'other' => q({0} айналым),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(айналым),
						'one' => q({0} айналым),
						'other' => q({0} айналым),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'one' => q({0} гектар),
						'other' => q({0} гектар),
					},
					# Core Unit Identifier
					'hectare' => {
						'one' => q({0} гектар),
						'other' => q({0} гектар),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(шаршы сантиметр),
						'one' => q({0} шаршы сантиметр),
						'other' => q({0} шаршы сантиметр),
						'per' => q({0}/шаршы сантиметр),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(шаршы сантиметр),
						'one' => q({0} шаршы сантиметр),
						'other' => q({0} шаршы сантиметр),
						'per' => q({0}/шаршы сантиметр),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'one' => q({0} шаршы фут),
						'other' => q({0} шаршы фут),
					},
					# Core Unit Identifier
					'square-foot' => {
						'one' => q({0} шаршы фут),
						'other' => q({0} шаршы фут),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(шаршы дюйм),
						'one' => q({0} шаршы дюйм),
						'other' => q({0} шаршы дюйм),
						'per' => q({0}/шаршы дюйм),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(шаршы дюйм),
						'one' => q({0} шаршы дюйм),
						'other' => q({0} шаршы дюйм),
						'per' => q({0}/шаршы дюйм),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(шаршы километр),
						'one' => q({0} шаршы километр),
						'other' => q({0} шаршы километр),
						'per' => q({0}/шаршы километр),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(шаршы километр),
						'one' => q({0} шаршы километр),
						'other' => q({0} шаршы километр),
						'per' => q({0}/шаршы километр),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(шаршы метр),
						'one' => q({0} шаршы метр),
						'other' => q({0} шаршы метр),
						'per' => q({0}/шаршы метр),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(шаршы метр),
						'one' => q({0} шаршы метр),
						'other' => q({0} шаршы метр),
						'per' => q({0}/шаршы метр),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'one' => q({0} шаршы миль),
						'other' => q({0} шаршы миль),
						'per' => q({0}/шаршы миль),
					},
					# Core Unit Identifier
					'square-mile' => {
						'one' => q({0} шаршы миль),
						'other' => q({0} шаршы миль),
						'per' => q({0}/шаршы миль),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(шаршы ярд),
						'one' => q({0} шаршы ярд),
						'other' => q({0} шаршы ярд),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(шаршы ярд),
						'one' => q({0} шаршы ярд),
						'other' => q({0} шаршы ярд),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					# Core Unit Identifier
					'karat' => {
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(миллиграмм/децилитр),
						'one' => q({0} миллиграмм/децилитр),
						'other' => q({0} миллиграмм/децилитр),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(миллиграмм/децилитр),
						'one' => q({0} миллиграмм/децилитр),
						'other' => q({0} миллиграмм/децилитр),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(миллимоль/литр),
						'one' => q({0} миллимоль/литр),
						'other' => q({0} миллимоль/литр),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(миллимоль/литр),
						'one' => q({0} миллимоль/литр),
						'other' => q({0} миллимоль/литр),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'one' => q({0} пайыз),
						'other' => q({0} пайыз),
					},
					# Core Unit Identifier
					'percent' => {
						'one' => q({0} пайыз),
						'other' => q({0} пайыз),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'one' => q({0} промилле),
						'other' => q({0} промилле),
					},
					# Core Unit Identifier
					'permille' => {
						'one' => q({0} промилле),
						'other' => q({0} промилле),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(миллиондық үлес),
						'one' => q({0} миллиондық үлес),
						'other' => q({0} миллиондық үлес),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(миллиондық үлес),
						'one' => q({0} миллиондық үлес),
						'other' => q({0} миллиондық үлес),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'one' => q({0} промириад),
						'other' => q({0} промириад),
					},
					# Core Unit Identifier
					'permyriad' => {
						'one' => q({0} промириад),
						'other' => q({0} промириад),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(литр/100 километр),
						'one' => q({0} литр/100 километр),
						'other' => q({0} литр/100 километр),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(литр/100 километр),
						'one' => q({0} литр/100 километр),
						'other' => q({0} литр/100 километр),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(литр/километр),
						'one' => q({0} литр/километр),
						'other' => q({0} литр/километр),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(литр/километр),
						'one' => q({0} литр/километр),
						'other' => q({0} литр/километр),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'one' => q({0} миль/галлон),
						'other' => q({0} миль/галлон),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'one' => q({0} миль/галлон),
						'other' => q({0} миль/галлон),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(миль/имп. галлон),
						'one' => q({0} миль/имп. галлон),
						'other' => q({0} миль/имп. галлон),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(миль/имп. галлон),
						'one' => q({0} миль/имп. галлон),
						'other' => q({0} миль/имп. галлон),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} шығыс),
						'north' => q({0} солтүстік),
						'south' => q({0} оңтүстік),
						'west' => q({0} батыс),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} шығыс),
						'north' => q({0} солтүстік),
						'south' => q({0} оңтүстік),
						'west' => q({0} батыс),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(гигабит),
						'one' => q({0} гигабит),
						'other' => q({0} гигабит),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(гигабит),
						'one' => q({0} гигабит),
						'other' => q({0} гигабит),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(гигабайт),
						'one' => q({0} гигабайт),
						'other' => q({0} гигабайт),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(гигабайт),
						'one' => q({0} гигабайт),
						'other' => q({0} гигабайт),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(килобит),
						'one' => q({0} килобит),
						'other' => q({0} килобит),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(килобит),
						'one' => q({0} килобит),
						'other' => q({0} килобит),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(килобайт),
						'one' => q({0} килобайт),
						'other' => q({0} килобайт),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(килобайт),
						'one' => q({0} килобайт),
						'other' => q({0} килобайт),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(мегабит),
						'one' => q({0} мегабит),
						'other' => q({0} мегабит),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(мегабит),
						'one' => q({0} мегабит),
						'other' => q({0} мегабит),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(мегабайт),
						'one' => q({0} мегабайт),
						'other' => q({0} мегабайт),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(мегабайт),
						'one' => q({0} мегабайт),
						'other' => q({0} мегабайт),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(петабайт),
						'one' => q({0} петабайт),
						'other' => q({0} петабайт),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(петабайт),
						'one' => q({0} петабайт),
						'other' => q({0} петабайт),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(терабит),
						'one' => q({0} терабит),
						'other' => q({0} терабит),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(терабит),
						'one' => q({0} терабит),
						'other' => q({0} терабит),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(терабайт),
						'one' => q({0} терабайт),
						'other' => q({0} терабайт),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(терабайт),
						'one' => q({0} терабайт),
						'other' => q({0} терабайт),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(ғасыр),
						'one' => q({0} ғасыр),
						'other' => q({0} ғасыр),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(ғасыр),
						'one' => q({0} ғасыр),
						'other' => q({0} ғасыр),
					},
					# Long Unit Identifier
					'duration-day' => {
						'per' => q(күніне {0}),
					},
					# Core Unit Identifier
					'day' => {
						'per' => q(күніне {0}),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'one' => q({0} сағат),
						'other' => q({0} сағат),
						'per' => q(сағатына {0}),
					},
					# Core Unit Identifier
					'hour' => {
						'one' => q({0} сағат),
						'other' => q({0} сағат),
						'per' => q(сағатына {0}),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(микросекунд),
						'one' => q({0} микросекунд),
						'other' => q({0} микросекунд),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(микросекунд),
						'one' => q({0} микросекунд),
						'other' => q({0} микросекунд),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(миллисекунд),
						'one' => q({0} миллисекунд),
						'other' => q({0} миллисекунд),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(миллисекунд),
						'one' => q({0} миллисекунд),
						'other' => q({0} миллисекунд),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(минут),
						'one' => q({0} минут),
						'other' => q({0} минут),
						'per' => q(минутына {0}),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(минут),
						'one' => q({0} минут),
						'other' => q({0} минут),
						'per' => q(минутына {0}),
					},
					# Long Unit Identifier
					'duration-month' => {
						'per' => q(айына {0}),
					},
					# Core Unit Identifier
					'month' => {
						'per' => q(айына {0}),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(наносекунд),
						'one' => q({0} наносекунд),
						'other' => q({0} наносекунд),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(наносекунд),
						'one' => q({0} наносекунд),
						'other' => q({0} наносекунд),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(секунд),
						'one' => q({0} секунд),
						'other' => q({0} секунд),
						'per' => q(секундына {0}),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(секунд),
						'one' => q({0} секунд),
						'other' => q({0} секунд),
						'per' => q(секундына {0}),
					},
					# Long Unit Identifier
					'duration-week' => {
						'one' => q({0} апта),
						'other' => q({0} апта),
						'per' => q(аптасына {0}),
					},
					# Core Unit Identifier
					'week' => {
						'one' => q({0} апта),
						'other' => q({0} апта),
						'per' => q(аптасына {0}),
					},
					# Long Unit Identifier
					'duration-year' => {
						'one' => q({0} жыл),
						'other' => q({0} жыл),
						'per' => q(жылына {0}),
					},
					# Core Unit Identifier
					'year' => {
						'one' => q({0} жыл),
						'other' => q({0} жыл),
						'per' => q(жылына {0}),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(ампер),
						'one' => q({0} aмпер),
						'other' => q({0} aмпер),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(ампер),
						'one' => q({0} aмпер),
						'other' => q({0} aмпер),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'one' => q({0} миллиампер),
						'other' => q({0} миллиампер),
					},
					# Core Unit Identifier
					'milliampere' => {
						'one' => q({0} миллиампер),
						'other' => q({0} миллиампер),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'one' => q({0} вольт),
						'other' => q({0} вольт),
					},
					# Core Unit Identifier
					'volt' => {
						'one' => q({0} вольт),
						'other' => q({0} вольт),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(британдық жылу бірлігі),
						'one' => q({0} британдық жылу бірлігі),
						'other' => q({0} британдық жылу бірлігі),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(британдық жылу бірлігі),
						'one' => q({0} британдық жылу бірлігі),
						'other' => q({0} британдық жылу бірлігі),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(калория),
						'one' => q({0} калория),
						'other' => q({0} калория),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(калория),
						'one' => q({0} калория),
						'other' => q({0} калория),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(электронвольт),
						'one' => q({0} электронвольт),
						'other' => q({0} электронвольт),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(электронвольт),
						'one' => q({0} электронвольт),
						'other' => q({0} электронвольт),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(калория),
						'one' => q({0} калория),
						'other' => q({0} калория),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(калория),
						'one' => q({0} калория),
						'other' => q({0} калория),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'one' => q({0} джоуль),
						'other' => q({0} джоуль),
					},
					# Core Unit Identifier
					'joule' => {
						'one' => q({0} джоуль),
						'other' => q({0} джоуль),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(килокалория),
						'one' => q({0} килокалория),
						'other' => q({0} килокалория),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(килокалория),
						'one' => q({0} килокалория),
						'other' => q({0} килокалория),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'one' => q({0} килоджуоль),
						'other' => q({0} килоджоуль),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'one' => q({0} килоджуоль),
						'other' => q({0} килоджоуль),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(киловатт-сағат),
						'one' => q({0} киловатт-сағат),
						'other' => q({0} киловатт-сағат),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(киловатт-сағат),
						'one' => q({0} киловатт-сағат),
						'other' => q({0} киловатт-сағат),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(киловатт-сағат/100 километр),
						'one' => q({0} киловатт-сағат/100 километр),
						'other' => q({0} киловатт-сағат/100 километр),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(киловатт-сағат/100 километр),
						'one' => q({0} киловатт-сағат/100 километр),
						'other' => q({0} киловатт-сағат/100 километр),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(ньютон),
						'one' => q({0} ньютон),
						'other' => q({0} ньютон),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(ньютон),
						'one' => q({0} ньютон),
						'other' => q({0} ньютон),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'one' => q({0} фунт-күш),
						'other' => q({0} фунт-күш),
					},
					# Core Unit Identifier
					'pound-force' => {
						'one' => q({0} фунт-күш),
						'other' => q({0} фунт-күш),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(гигагерц),
						'one' => q({0} гигагерц),
						'other' => q({0} гигагерц),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(гигагерц),
						'one' => q({0} гигагерц),
						'other' => q({0} гигагерц),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(герц),
						'one' => q({0} герц),
						'other' => q({0} герц),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(герц),
						'one' => q({0} герц),
						'other' => q({0} герц),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(килогерц),
						'one' => q({0} килогерц),
						'other' => q({0} килогерц),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(килогерц),
						'one' => q({0} килогерц),
						'other' => q({0} килогерц),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(мегагерц),
						'one' => q({0} мегагерц),
						'other' => q({0} мегагерц),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(мегагерц),
						'one' => q({0} мегагерц),
						'other' => q({0} мегагерц),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(нүкте/сантиметр),
						'one' => q({0} нүкте/сантиметр),
						'other' => q({0} нүкте/сантиметр),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(нүкте/сантиметр),
						'one' => q({0} нүкте/сантиметр),
						'other' => q({0} нүкте/сантиметр),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(типографиялық эм),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(типографиялық эм),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'one' => q({0} мегапиксель),
						'other' => q({0} мегапиксель),
					},
					# Core Unit Identifier
					'megapixel' => {
						'one' => q({0} мегапиксель),
						'other' => q({0} мегапиксель),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(пиксель/сантиметр),
						'one' => q({0} пиксель/сантиметр),
						'other' => q({0} пиксель/сантиметр),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(пиксель/сантиметр),
						'one' => q({0} пиксель/сантиметр),
						'other' => q({0} пиксель/сантиметр),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(астрономиялық бірлік),
						'one' => q({0} астрономиялық бірлік),
						'other' => q({0} астрономиялық бірлік),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(астрономиялық бірлік),
						'one' => q({0} астрономиялық бірлік),
						'other' => q({0} астрономиялық бірлік),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(сантиметр),
						'one' => q({0} сантиметр),
						'other' => q({0} сантиметр),
						'per' => q({0}/сантиметр),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(сантиметр),
						'one' => q({0} сантиметр),
						'other' => q({0} сантиметр),
						'per' => q({0}/сантиметр),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(дециметр),
						'one' => q({0} дециметр),
						'other' => q({0} дециметр),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(дециметр),
						'one' => q({0} дециметр),
						'other' => q({0} дециметр),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(Жер радиусы),
						'one' => q({0} Жер радиусы),
						'other' => q({0} Жер радиусы),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(Жер радиусы),
						'one' => q({0} Жер радиусы),
						'other' => q({0} Жер радиусы),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(километр),
						'one' => q({0} километр),
						'other' => q({0} километр),
						'per' => q({0}/километр),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(километр),
						'one' => q({0} километр),
						'other' => q({0} километр),
						'per' => q({0}/километр),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'one' => q({0} жарық жылы),
						'other' => q({0} жарық жылы),
					},
					# Core Unit Identifier
					'light-year' => {
						'one' => q({0} жарық жылы),
						'other' => q({0} жарық жылы),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(метр),
						'one' => q({0} метр),
						'other' => q({0} метр),
						'per' => q({0}/метр),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(метр),
						'one' => q({0} метр),
						'other' => q({0} метр),
						'per' => q({0}/метр),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(микрометр),
						'one' => q({0} микрометр),
						'other' => q({0} микрометр),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(микрометр),
						'one' => q({0} микрометр),
						'other' => q({0} микрометр),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(скандинавиялық миль),
						'one' => q({0} скандинавиялық миль),
						'other' => q({0} скандинавиялық миль),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(скандинавиялық миль),
						'one' => q({0} скандинавиялық миль),
						'other' => q({0} скандинавиялық миль),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(миллиметр),
						'one' => q({0} миллиметр),
						'other' => q({0} миллиметр),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(миллиметр),
						'one' => q({0} миллиметр),
						'other' => q({0} миллиметр),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(нанометр),
						'one' => q({0} нанометр),
						'other' => q({0} нанометр),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(нанометр),
						'one' => q({0} нанометр),
						'other' => q({0} нанометр),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(теңіз милі),
						'one' => q({0} теңіз милі),
						'other' => q({0} теңіз милі),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(теңіз милі),
						'one' => q({0} теңіз милі),
						'other' => q({0} теңіз милі),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'one' => q({0} парсек),
						'other' => q({0} парсек),
					},
					# Core Unit Identifier
					'parsec' => {
						'one' => q({0} парсек),
						'other' => q({0} парсек),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(пикометр),
						'one' => q({0} пикометр),
						'other' => q({0} пикометр),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(пикометр),
						'one' => q({0} пикометр),
						'other' => q({0} пикометр),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'one' => q({0} Күн радиусы),
						'other' => q({0} Күн радиусы),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'one' => q({0} Күн радиусы),
						'other' => q({0} Күн радиусы),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(кандела),
						'one' => q({0} кандела),
						'other' => q({0} кандела),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(кандела),
						'one' => q({0} кандела),
						'other' => q({0} кандела),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(люмен),
						'one' => q({0} люмен),
						'other' => q({0} люмен),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(люмен),
						'one' => q({0} люмен),
						'other' => q({0} люмен),
					},
					# Long Unit Identifier
					'light-lux' => {
						'one' => q({0} люкс),
						'other' => q({0} люкс),
					},
					# Core Unit Identifier
					'lux' => {
						'one' => q({0} люкс),
						'other' => q({0} люкс),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'one' => q({0} Күн жарықтығы),
						'other' => q({0} Күн жарықтығы),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'one' => q({0} Күн жарықтығы),
						'other' => q({0} Күн жарықтығы),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					# Core Unit Identifier
					'carat' => {
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(дальтон),
						'one' => q({0} дальтон),
						'other' => q({0} дальтон),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(дальтон),
						'one' => q({0} дальтон),
						'other' => q({0} дальтон),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(Жер массасы),
						'one' => q({0} жер массасы),
						'other' => q({0} жер массасы),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(Жер массасы),
						'one' => q({0} жер массасы),
						'other' => q({0} жер массасы),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'one' => q({0} грамм),
						'other' => q({0} грамм),
						'per' => q({0}/грамм),
					},
					# Core Unit Identifier
					'gram' => {
						'one' => q({0} грамм),
						'other' => q({0} грамм),
						'per' => q({0}/грамм),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(килограмм),
						'one' => q({0} килограмм),
						'other' => q({0} килограмм),
						'per' => q({0}/килограмм),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(килограмм),
						'one' => q({0} килограмм),
						'other' => q({0} килограмм),
						'per' => q({0}/килограмм),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(микрограмм),
						'one' => q({0} микрограмм),
						'other' => q({0} микрограмм),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(микрограмм),
						'one' => q({0} микрограмм),
						'other' => q({0} микрограмм),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(миллиграмм),
						'one' => q({0} миллиграмм),
						'other' => q({0} миллиграмм),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(миллиграмм),
						'one' => q({0} миллиграмм),
						'other' => q({0} миллиграмм),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(унция),
						'one' => q({0} унция),
						'other' => q({0} унция),
						'per' => q({0}/унция),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(унция),
						'one' => q({0} унция),
						'other' => q({0} унция),
						'per' => q({0}/унция),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(трой унциясы),
						'one' => q({0} трой унциясы),
						'other' => q({0} трой унциясы),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(трой унциясы),
						'one' => q({0} трой унциясы),
						'other' => q({0} трой унциясы),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'one' => q({0} Күн массасы),
						'other' => q({0} Күн массасы),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'one' => q({0} Күн массасы),
						'other' => q({0} Күн массасы),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'one' => q({0} тонна),
						'other' => q({0} тонна),
					},
					# Core Unit Identifier
					'ton' => {
						'one' => q({0} тонна),
						'other' => q({0} тонна),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(метрлік тонна),
						'one' => q({0} метрлік тонна),
						'other' => q({0} метрлік тонна),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(метрлік тонна),
						'one' => q({0} метрлік тонна),
						'other' => q({0} метрлік тонна),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(гигаватт),
						'one' => q({0} гигаватт),
						'other' => q({0} гигаватт),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(гигаватт),
						'one' => q({0} гигаватт),
						'other' => q({0} гигаватт),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(ат күші),
						'one' => q({0} ат күші),
						'other' => q({0} ат күші),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(ат күші),
						'one' => q({0} ат күші),
						'other' => q({0} ат күші),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(киловатт),
						'one' => q({0} киловатт),
						'other' => q({0} киловатт),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(киловатт),
						'one' => q({0} киловатт),
						'other' => q({0} киловатт),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(мегаватт),
						'one' => q({0} мегаватт),
						'other' => q({0} мегаватт),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(мегаватт),
						'one' => q({0} мегаватт),
						'other' => q({0} мегаватт),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(милливатт),
						'one' => q({0} милливатт),
						'other' => q({0} милливатт),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(милливатт),
						'one' => q({0} милливатт),
						'other' => q({0} милливатт),
					},
					# Long Unit Identifier
					'power-watt' => {
						'one' => q({0} ватт),
						'other' => q({0} ватт),
					},
					# Core Unit Identifier
					'watt' => {
						'one' => q({0} ватт),
						'other' => q({0} ватт),
					},
					# Long Unit Identifier
					'power2' => {
						'one' => q(шаршы {0}),
						'other' => q(шаршы {0}),
					},
					# Core Unit Identifier
					'power2' => {
						'one' => q(шаршы {0}),
						'other' => q(шаршы {0}),
					},
					# Long Unit Identifier
					'power3' => {
						'one' => q(текше {0}),
						'other' => q(текше {0}),
					},
					# Core Unit Identifier
					'power3' => {
						'one' => q(текше {0}),
						'other' => q(текше {0}),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(атмосфера),
						'one' => q({0} атмосфера),
						'other' => q({0} атмосфера),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(атмосфера),
						'one' => q({0} атмосфера),
						'other' => q({0} атмосфера),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(гектопаскаль),
						'one' => q({0} гектопаскаль),
						'other' => q({0} гектопаскаль),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(гектопаскаль),
						'one' => q({0} гектопаскаль),
						'other' => q({0} гектопаскаль),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'one' => q({0} дюйм сынап бағанасы),
						'other' => q({0} дюйм сынап бағанасы),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'one' => q({0} дюйм сынап бағанасы),
						'other' => q({0} дюйм сынап бағанасы),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(килопаскаль),
						'one' => q({0} килопаскаль),
						'other' => q({0} килопаскаль),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(килопаскаль),
						'one' => q({0} килопаскаль),
						'other' => q({0} килопаскаль),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(мегапаскаль),
						'one' => q({0} мегапаскаль),
						'other' => q({0} мегапаскаль),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(мегапаскаль),
						'one' => q({0} мегапаскаль),
						'other' => q({0} мегапаскаль),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(миллибар),
						'one' => q({0} миллибар),
						'other' => q({0} миллибар),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(миллибар),
						'one' => q({0} миллибар),
						'other' => q({0} миллибар),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(миллиметр сынап бағанасы),
						'one' => q({0} миллиметр сынап бағанасы),
						'other' => q({0} миллиметр сынап бағанасы),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(миллиметр сынап бағанасы),
						'one' => q({0} миллиметр сынап бағанасы),
						'other' => q({0} миллиметр сынап бағанасы),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(паскаль),
						'one' => q({0} паскаль),
						'other' => q({0} паскаль),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(паскаль),
						'one' => q({0} паскаль),
						'other' => q({0} паскаль),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(фунт-күш/шаршы дюйм),
						'one' => q({0} фунт-күш/шаршы дюйм),
						'other' => q({0} фунт-күш/шаршы дюйм),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(фунт-күш/шаршы дюйм),
						'one' => q({0} фунт-күш/шаршы дюйм),
						'other' => q({0} фунт-күш/шаршы дюйм),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'name' => q(бофорт),
					},
					# Core Unit Identifier
					'beaufort' => {
						'name' => q(бофорт),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(километр/сағат),
						'one' => q({0} километр/сағат),
						'other' => q({0} километр/сағат),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(километр/сағат),
						'one' => q({0} километр/сағат),
						'other' => q({0} километр/сағат),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(түйін),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(түйін),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'one' => q({0} метр/секунд),
						'other' => q({0} метр/секунд),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'one' => q({0} метр/секунд),
						'other' => q({0} метр/секунд),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'one' => q({0} миль/сағат),
						'other' => q({0} миль/сағат),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'one' => q({0} миль/сағат),
						'other' => q({0} миль/сағат),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'one' => q({0} Цельсий градусы),
						'other' => q({0} Цельсий градусы),
					},
					# Core Unit Identifier
					'celsius' => {
						'one' => q({0} Цельсий градусы),
						'other' => q({0} Цельсий градусы),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(Фаренгейт градусы),
						'one' => q({0} Фаренгейт градусы),
						'other' => q({0} Фаренгейт градусы),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(Фаренгейт градусы),
						'one' => q({0} Фаренгейт градусы),
						'other' => q({0} Фаренгейт градусы),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(температура градусы),
						'one' => q({0} градус),
						'other' => q({0} градус),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(температура градусы),
						'one' => q({0} градус),
						'other' => q({0} градус),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(кельвин),
						'one' => q({0} кельвин),
						'other' => q({0} кельвин),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(кельвин),
						'one' => q({0} кельвин),
						'other' => q({0} кельвин),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(ньютон-метр),
						'one' => q({0} ньютон-метр),
						'other' => q({0} ньютон-метр),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(ньютон-метр),
						'one' => q({0} ньютон-метр),
						'other' => q({0} ньютон-метр),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(фунт-күш-фут),
						'one' => q({0} фунт-фут),
						'other' => q({0} фунт-күш-фут),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(фунт-күш-фут),
						'one' => q({0} фунт-фут),
						'other' => q({0} фунт-күш-фут),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'one' => q({0} бушель),
						'other' => q({0} бушель),
					},
					# Core Unit Identifier
					'bushel' => {
						'one' => q({0} бушель),
						'other' => q({0} бушель),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(сантилитр),
						'one' => q({0} cантилитр),
						'other' => q({0} cантилитр),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(сантилитр),
						'one' => q({0} cантилитр),
						'other' => q({0} cантилитр),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(текше сантиметр),
						'one' => q({0} текше сантиметр),
						'other' => q({0} текше сантиметр),
						'per' => q({0}/текше сантиметр),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(текше сантиметр),
						'one' => q({0} текше сантиметр),
						'other' => q({0} текше сантиметр),
						'per' => q({0}/текше сантиметр),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(текше фут),
						'one' => q({0} текше фут),
						'other' => q({0} текше фут),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(текше фут),
						'one' => q({0} текше фут),
						'other' => q({0} текше фут),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(текше дюйм),
						'one' => q({0} текше дюйм),
						'other' => q({0} текше дюйм),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(текше дюйм),
						'one' => q({0} текше дюйм),
						'other' => q({0} текше дюйм),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(текше километр),
						'one' => q({0} текше километр),
						'other' => q({0} текше километр),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(текше километр),
						'one' => q({0} текше километр),
						'other' => q({0} текше километр),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(текше метр),
						'one' => q({0} текше метр),
						'other' => q({0} текше метр),
						'per' => q({0}/текше метр),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(текше метр),
						'one' => q({0} текше метр),
						'other' => q({0} текше метр),
						'per' => q({0}/текше метр),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(текше миль),
						'one' => q({0} текше миль),
						'other' => q({0} текше миль),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(текше миль),
						'one' => q({0} текше миль),
						'other' => q({0} текше миль),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(текше ярд),
						'one' => q({0} текше ярд),
						'other' => q({0} текше ярд),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(текше ярд),
						'one' => q({0} текше ярд),
						'other' => q({0} текше ярд),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'one' => q({0} кесе),
						'other' => q({0} кесе),
					},
					# Core Unit Identifier
					'cup' => {
						'one' => q({0} кесе),
						'other' => q({0} кесе),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(метрлік кесе),
						'one' => q({0} метрлік кесе),
						'other' => q({0} метрлік кесе),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(метрлік кесе),
						'one' => q({0} метрлік кесе),
						'other' => q({0} метрлік кесе),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(децилитр),
						'one' => q({0} децилитр),
						'other' => q({0} децилитр),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(децилитр),
						'one' => q({0} децилитр),
						'other' => q({0} децилитр),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(десерт қасығы),
						'one' => q({0} десерт қасығы),
						'other' => q({0} десерт қасығы),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(десерт қасығы),
						'one' => q({0} десерт қасығы),
						'other' => q({0} десерт қасығы),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(имп. десерт қасығы),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(имп. десерт қасығы),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(драхма),
						'one' => q({0} драхма),
						'other' => q({0} драхма),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(драхма),
						'one' => q({0} драхма),
						'other' => q({0} драхма),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(сұйық унция),
						'one' => q({0} сұйық унция),
						'other' => q({0} сұйық унция),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(сұйық унция),
						'one' => q({0} сұйық унция),
						'other' => q({0} сұйық унция),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(имп. сұйық унция),
						'one' => q({0} имп. сұйық унция),
						'other' => q({0} имп. сұйық унция),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(имп. сұйық унция),
						'one' => q({0} имп. сұйық унция),
						'other' => q({0} имп. сұйық унция),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(галлон),
						'one' => q({0} галлон),
						'other' => q({0} галлон),
						'per' => q({0}/галлон),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(галлон),
						'one' => q({0} галлон),
						'other' => q({0} галлон),
						'per' => q({0}/галлон),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(гектолитр),
						'one' => q({0} гектолитр),
						'other' => q({0} гектолитр),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(гектолитр),
						'one' => q({0} гектолитр),
						'other' => q({0} гектолитр),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'one' => q({0} литр),
						'other' => q({0} литр),
						'per' => q({0}/литр),
					},
					# Core Unit Identifier
					'liter' => {
						'one' => q({0} литр),
						'other' => q({0} литр),
						'per' => q({0}/литр),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(мегалитр),
						'one' => q({0} мегалитр),
						'other' => q({0} мегалитр),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(мегалитр),
						'one' => q({0} мегалитр),
						'other' => q({0} мегалитр),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(миллилитр),
						'one' => q({0} миллилитр),
						'other' => q({0} миллилитр),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(миллилитр),
						'one' => q({0} миллилитр),
						'other' => q({0} миллилитр),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'one' => q({0} пинта),
						'other' => q({0} пинта),
					},
					# Core Unit Identifier
					'pint' => {
						'one' => q({0} пинта),
						'other' => q({0} пинта),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(метрлік пинта),
						'one' => q({0} метрлік пинта),
						'other' => q({0} метрлік пинта),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(метрлік пинта),
						'one' => q({0} метрлік пинта),
						'other' => q({0} метрлік пинта),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(кварта),
						'one' => q({0} кварта),
						'other' => q({0} кварта),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(кварта),
						'one' => q({0} кварта),
						'other' => q({0} кварта),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'one' => q({0} британдық кварта),
						'other' => q({0} брит. кварта),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'one' => q({0} британдық кварта),
						'other' => q({0} брит. кварта),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(ас қасық),
						'one' => q({0} ас қасық),
						'other' => q({0} ас қасық),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(ас қасық),
						'one' => q({0} ас қасық),
						'other' => q({0} ас қасық),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(шай қасық),
						'one' => q({0} шай қасық),
						'other' => q({0} шай қасық),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(шай қасық),
						'one' => q({0} шай қасық),
						'other' => q({0} шай қасық),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(гр-күш),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(гр-күш),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(м/с²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(м/с²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(рад),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(рад),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(фут²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(фут²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(миль²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(миль²),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(%),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(‰),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(‰),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(л/км),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(л/км),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(миль/гал.),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(миль/гал.),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(Гб),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(Гб),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(ГБ),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(ГБ),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(кб),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(кб),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(кБ),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(кБ),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Мб),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Мб),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(МБ),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(МБ),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(ПБ),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(ПБ),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(ТБ),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(ТБ),
					},
					# Long Unit Identifier
					'duration-day' => {
						'one' => q({0} к.),
						'other' => q({0} к.),
					},
					# Core Unit Identifier
					'day' => {
						'one' => q({0} к.),
						'other' => q({0} к.),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(сағ),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(сағ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ап.),
						'per' => q({0}/апта),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ап.),
						'per' => q({0}/апта),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(ж.),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(ж.),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(мА),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(мА),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(кДж),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(кДж),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'one' => q({0} Ф),
						'other' => q({0} Ф),
					},
					# Core Unit Identifier
					'furlong' => {
						'one' => q({0} Ф),
						'other' => q({0} Ф),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(ж. ж.),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(ж. ж.),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(скандинавиялық миль),
						'one' => q({0} ск. миль),
						'other' => q({0} ск. миль),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(скандинавиялық миль),
						'one' => q({0} ск. миль),
						'other' => q({0} ск. миль),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(теңіз милі),
						'one' => q({0} теңіз милі),
						'other' => q({0} теңіз милі),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(теңіз милі),
						'one' => q({0} теңіз милі),
						'other' => q({0} теңіз милі),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'one' => q({0} унция),
						'other' => q({0} унция),
					},
					# Core Unit Identifier
					'ounce' => {
						'one' => q({0} унция),
						'other' => q({0} унция),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(дюйм с.б.),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(дюйм с.б.),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'one' => q({0} мб),
						'other' => q({0} мб),
					},
					# Core Unit Identifier
					'millibar' => {
						'one' => q({0} мб),
						'other' => q({0} мб),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(түйін),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(түйін),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(м/с),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(м/с),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(миль/сағ),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(миль/сағ),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(°C),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(°C),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(имп. сұй. унц.),
						'one' => q({0} имп. сұй. унц.),
						'other' => q({0} имп. сұй. унц.),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(имп. сұй. унц.),
						'one' => q({0} имп. сұй. унц.),
						'other' => q({0} имп. сұй. унц.),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(бағыт),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(бағыт),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(Ки{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(Ки{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(Ми{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(Ми{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(Ги{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(Ги{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(Ти{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(Ти{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(Пи{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(Пи{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(Эи{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(Эи{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(Зи{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(Зи{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(Йи{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(Йи{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(д{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(д{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(п{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(п{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ф{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ф{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(а{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(а{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(с{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(с{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(з{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(з{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(й{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(й{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(р{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(р{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(м{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(м{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(кв{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(кв{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(мк{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(мк{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(н{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(н{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(да{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(да{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(Т{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(Т{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(П{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(П{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(Э{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(Э{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(г{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(г{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(З{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(З{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(Й{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(Й{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(Р{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(Р{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(к{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(к{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(Кв{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(Кв{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(М{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(М{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(Г{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(Г{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(гравитациялық күш),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(гравитациялық күш),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(метр/сек²),
						'one' => q({0} м/с²),
						'other' => q({0} м/с²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(метр/сек²),
						'one' => q({0} м/с²),
						'other' => q({0} м/с²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(аркмин),
						'one' => q({0} аркмин),
						'other' => q({0} аркмин),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(аркмин),
						'one' => q({0} аркмин),
						'other' => q({0} аркмин),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(арксек),
						'one' => q({0} арксек),
						'other' => q({0} арксек),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(арксек),
						'one' => q({0} арксек),
						'other' => q({0} арксек),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(градус),
						'one' => q({0} градус),
						'other' => q({0} градус),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(градус),
						'one' => q({0} градус),
						'other' => q({0} градус),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(радиан),
						'one' => q({0} рад),
						'other' => q({0} рад),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(радиан),
						'one' => q({0} рад),
						'other' => q({0} рад),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(айн.),
						'one' => q({0} айн.),
						'other' => q({0} айн.),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(айн.),
						'one' => q({0} айн.),
						'other' => q({0} айн.),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(дунам),
						'one' => q({0} дунам),
						'other' => q({0} дунам),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(дунам),
						'one' => q({0} дунам),
						'other' => q({0} дунам),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(гектар),
						'one' => q({0} га),
						'other' => q({0} га),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(гектар),
						'one' => q({0} га),
						'other' => q({0} га),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(cм²),
						'one' => q({0} cм²),
						'other' => q({0} cм²),
						'per' => q({0}/см²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(cм²),
						'one' => q({0} cм²),
						'other' => q({0} cм²),
						'per' => q({0}/см²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(шаршы фут),
						'one' => q({0} фут²),
						'other' => q({0} фут²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(шаршы фут),
						'one' => q({0} фут²),
						'other' => q({0} фут²),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(дюйм²),
						'one' => q({0} дюйм²),
						'other' => q({0} дюйм²),
						'per' => q({0}/дюйм²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(дюйм²),
						'one' => q({0} дюйм²),
						'other' => q({0} дюйм²),
						'per' => q({0}/дюйм²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
						'per' => q({0}/км²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
						'per' => q({0}/км²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(метр²),
						'one' => q({0} м²),
						'other' => q({0} м²),
						'per' => q({0}/м²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(метр²),
						'one' => q({0} м²),
						'other' => q({0} м²),
						'per' => q({0}/м²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(шаршы миль),
						'one' => q({0} миль²),
						'other' => q({0} миль²),
						'per' => q({0}/миль²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(шаршы миль),
						'one' => q({0} миль²),
						'other' => q({0} миль²),
						'per' => q({0}/миль²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(ярд²),
						'one' => q({0} ярд²),
						'other' => q({0} ярд²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(ярд²),
						'one' => q({0} ярд²),
						'other' => q({0} ярд²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(элемент),
						'one' => q({0} элемент),
						'other' => q({0} элемент),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(элемент),
						'one' => q({0} элемент),
						'other' => q({0} элемент),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(карат),
						'one' => q({0} кар.),
						'other' => q({0} кар.),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(карат),
						'one' => q({0} кар.),
						'other' => q({0} кар.),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(мг/дл),
						'one' => q({0} мг/дл),
						'other' => q({0} мг/дл),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(мг/дл),
						'one' => q({0} мг/дл),
						'other' => q({0} мг/дл),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ммоль/л),
						'one' => q({0} ммоль/л),
						'other' => q({0} ммоль/л),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ммоль/л),
						'one' => q({0} ммоль/л),
						'other' => q({0} ммоль/л),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(моль),
						'one' => q({0} моль),
						'other' => q({0} моль),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(моль),
						'one' => q({0} моль),
						'other' => q({0} моль),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(пайыз),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(пайыз),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(промилле),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(промилле),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(промириад),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(промириад),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(л/100 км),
						'one' => q({0} л/100 км),
						'other' => q({0} л/100 км),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(л/100 км),
						'one' => q({0} л/100 км),
						'other' => q({0} л/100 км),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(литр/км),
						'one' => q({0} л/км),
						'other' => q({0} л/км),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(литр/км),
						'one' => q({0} л/км),
						'other' => q({0} л/км),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(миль/галлон),
						'one' => q({0} миль/гал.),
						'other' => q({0} миль/гал.),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(миль/галлон),
						'one' => q({0} миль/гал.),
						'other' => q({0} миль/гал.),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(миль/имп. гал.),
						'one' => q({0} миль/имп. гал.),
						'other' => q({0} миль/имп. гал.),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(миль/имп. гал.),
						'one' => q({0} миль/имп. гал.),
						'other' => q({0} миль/имп. гал.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} Ш),
						'north' => q({0} С),
						'south' => q({0} О),
						'west' => q({0} Б),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} Ш),
						'north' => q({0} С),
						'south' => q({0} О),
						'west' => q({0} Б),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} бит),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} бит),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(байт),
						'one' => q({0} байт),
						'other' => q({0} байт),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(байт),
						'one' => q({0} байт),
						'other' => q({0} байт),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(Гбит),
						'one' => q({0} Гб),
						'other' => q({0} Гб),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(Гбит),
						'one' => q({0} Гб),
						'other' => q({0} Гб),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(Гбайт),
						'one' => q({0} ГБ),
						'other' => q({0} ГБ),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(Гбайт),
						'one' => q({0} ГБ),
						'other' => q({0} ГБ),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(кбит),
						'one' => q({0} кб),
						'other' => q({0} кб),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(кбит),
						'one' => q({0} кб),
						'other' => q({0} кб),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(кбайт),
						'one' => q({0} кБ),
						'other' => q({0} кБ),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(кбайт),
						'one' => q({0} кБ),
						'other' => q({0} кБ),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Мбит),
						'one' => q({0} Mб),
						'other' => q({0} Mб),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Мбит),
						'one' => q({0} Mб),
						'other' => q({0} Mб),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(Мбайт),
						'one' => q({0} MБ),
						'other' => q({0} MБ),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(Мбайт),
						'one' => q({0} MБ),
						'other' => q({0} MБ),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(Пбайт),
						'one' => q({0} ПБ),
						'other' => q({0} ПБ),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(Пбайт),
						'one' => q({0} ПБ),
						'other' => q({0} ПБ),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Тбит),
						'one' => q({0} Tб),
						'other' => q({0} Tб),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Тбит),
						'one' => q({0} Tб),
						'other' => q({0} Tб),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(Тбайт),
						'one' => q({0} TБ),
						'other' => q({0} TБ),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(Тбайт),
						'one' => q({0} TБ),
						'other' => q({0} TБ),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(ғ.),
						'one' => q({0} ғ.),
						'other' => q({0} ғ.),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(ғ.),
						'one' => q({0} ғ.),
						'other' => q({0} ғ.),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(күн),
						'one' => q({0} күн),
						'other' => q({0} күн),
						'per' => q({0}/күн),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(күн),
						'one' => q({0} күн),
						'other' => q({0} күн),
						'per' => q({0}/күн),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(декада),
						'one' => q({0} декада),
						'other' => q({0} декада),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(декада),
						'one' => q({0} декада),
						'other' => q({0} декада),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(сағат),
						'one' => q({0} сағ),
						'other' => q({0} сағ),
						'per' => q({0}/сағ),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(сағат),
						'one' => q({0} сағ),
						'other' => q({0} сағ),
						'per' => q({0}/сағ),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(мкс),
						'one' => q({0} мкс),
						'other' => q({0} мкс),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(мкс),
						'one' => q({0} мкс),
						'other' => q({0} мкс),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(мс),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(мс),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(мин),
						'one' => q({0} мин),
						'other' => q({0} мин),
						'per' => q({0}/мин),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(мин),
						'one' => q({0} мин),
						'other' => q({0} мин),
						'per' => q({0}/мин),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(ай),
						'one' => q({0} ай),
						'other' => q({0} ай),
						'per' => q({0}/ай),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(ай),
						'one' => q({0} ай),
						'other' => q({0} ай),
						'per' => q({0}/ай),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(нс),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(нс),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(тоқсан),
						'one' => q({0} тоқсан),
						'other' => q({0} тоқсан),
						'per' => q({0}/тоқсан),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(тоқсан),
						'one' => q({0} тоқсан),
						'other' => q({0} тоқсан),
						'per' => q({0}/тоқсан),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(с),
						'one' => q({0} с),
						'other' => q({0} с),
						'per' => q({0}/с),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(с),
						'one' => q({0} с),
						'other' => q({0} с),
						'per' => q({0}/с),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(апта),
						'one' => q({0} ап.),
						'other' => q({0} ап.),
						'per' => q({0}/ап.),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(апта),
						'one' => q({0} ап.),
						'other' => q({0} ап.),
						'per' => q({0}/ап.),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(жыл),
						'one' => q({0} ж.),
						'other' => q({0} ж.),
						'per' => q({0}/ж.),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(жыл),
						'one' => q({0} ж.),
						'other' => q({0} ж.),
						'per' => q({0}/ж.),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(А),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(А),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(миллиампер),
						'one' => q({0} мA),
						'other' => q({0} мA),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(миллиампер),
						'one' => q({0} мA),
						'other' => q({0} мA),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(Ом),
						'one' => q({0} Ом),
						'other' => q({0} Ом),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(Ом),
						'one' => q({0} Ом),
						'other' => q({0} Ом),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(вольт),
						'one' => q({0} В),
						'other' => q({0} В),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(вольт),
						'one' => q({0} В),
						'other' => q({0} В),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(эВ),
						'one' => q({0} эВ),
						'other' => q({0} эВ),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(эВ),
						'one' => q({0} эВ),
						'other' => q({0} эВ),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(джоуль),
						'one' => q({0} Дж),
						'other' => q({0} Дж),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(джоуль),
						'one' => q({0} Дж),
						'other' => q({0} Дж),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(ккал),
						'one' => q({0} ккал),
						'other' => q({0} ккал),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(ккал),
						'one' => q({0} ккал),
						'other' => q({0} ккал),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(килоджоуль),
						'one' => q({0} кДж),
						'other' => q({0} кДж),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(килоджоуль),
						'one' => q({0} кДж),
						'other' => q({0} кДж),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(кВт-сағ),
						'one' => q({0} кВт-сағ),
						'other' => q({0} кВт-сағ),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(кВт-сағ),
						'one' => q({0} кВт-сағ),
						'other' => q({0} кВт-сағ),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(АҚШ термі),
						'one' => q({0} АҚШ термі),
						'other' => q({0} АҚШ термі),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(АҚШ термі),
						'one' => q({0} АҚШ термі),
						'other' => q({0} АҚШ термі),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(кВт-сағ/100 км),
						'one' => q({0} кВт-сағ/100 км),
						'other' => q({0} кВт-сағ/100 км),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(кВт-сағ/100 км),
						'one' => q({0} кВт-сағ/100 км),
						'other' => q({0} кВт-сағ/100 км),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(Н),
						'one' => q({0} Н),
						'other' => q({0} Н),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(Н),
						'one' => q({0} Н),
						'other' => q({0} Н),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(фунт-күш),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(фунт-күш),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(ГГц),
						'one' => q({0} ГГц),
						'other' => q({0} ГГц),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(ГГц),
						'one' => q({0} ГГц),
						'other' => q({0} ГГц),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(Гц),
						'one' => q({0} Гц),
						'other' => q({0} Гц),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(Гц),
						'one' => q({0} Гц),
						'other' => q({0} Гц),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(кГц),
						'one' => q({0} кГц),
						'other' => q({0} кГц),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(кГц),
						'one' => q({0} кГц),
						'other' => q({0} кГц),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(МГц),
						'one' => q({0} MГц),
						'other' => q({0} MГц),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(МГц),
						'one' => q({0} MГц),
						'other' => q({0} MГц),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(нүкте),
						'one' => q({0} нүкте),
						'other' => q({0} нүкте),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(нүкте),
						'one' => q({0} нүкте),
						'other' => q({0} нүкте),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(нүкте/см),
						'one' => q({0} нүкте/см),
						'other' => q({0} нүкте/см),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(нүкте/см),
						'one' => q({0} нүкте/см),
						'other' => q({0} нүкте/см),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(нүкте/дюйм),
						'one' => q({0} нүкте/дюйм),
						'other' => q({0} нүкте/дюйм),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(нүкте/дюйм),
						'one' => q({0} нүкте/дюйм),
						'other' => q({0} нүкте/дюйм),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(эм),
						'one' => q({0} эм),
						'other' => q({0} эм),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(эм),
						'one' => q({0} эм),
						'other' => q({0} эм),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(мегапиксель),
						'one' => q({0} Мп),
						'other' => q({0} Мп),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(мегапиксель),
						'one' => q({0} Мп),
						'other' => q({0} Мп),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(пиксель),
						'one' => q({0} пиксель),
						'other' => q({0} пиксель),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(пиксель),
						'one' => q({0} пиксель),
						'other' => q({0} пиксель),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(пиксель/см),
						'one' => q({0} пиксель/см),
						'other' => q({0} пиксель/см),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(пиксель/см),
						'one' => q({0} пиксель/см),
						'other' => q({0} пиксель/см),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(пиксель/дюйм),
						'one' => q({0} пиксель/дюйм),
						'other' => q({0} пиксель/дюйм),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(пиксель/дюйм),
						'one' => q({0} пиксель/дюйм),
						'other' => q({0} пиксель/дюйм),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(а. б.),
						'one' => q({0} а. б.),
						'other' => q({0} а. б.),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(а. б.),
						'one' => q({0} а. б.),
						'other' => q({0} а. б.),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(фатом),
						'one' => q({0} фатом),
						'other' => q({0} фатом),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(фатом),
						'one' => q({0} фатом),
						'other' => q({0} фатом),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(фут),
						'one' => q({0} фут),
						'other' => q({0} фут),
						'per' => q({0}/фут),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(фут),
						'one' => q({0} фут),
						'other' => q({0} фут),
						'per' => q({0}/фут),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(фурлонг),
						'one' => q({0} фурлонг),
						'other' => q({0} фурлонг),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(фурлонг),
						'one' => q({0} фурлонг),
						'other' => q({0} фурлонг),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(дюйм),
						'one' => q({0} дюйм),
						'other' => q({0} дюйм),
						'per' => q({0}/дюйм),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(дюйм),
						'one' => q({0} дюйм),
						'other' => q({0} дюйм),
						'per' => q({0}/дюйм),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(жарық жылы),
						'one' => q({0} ж. ж.),
						'other' => q({0} ж. ж.),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(жарық жылы),
						'one' => q({0} ж. ж.),
						'other' => q({0} ж. ж.),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(м),
						'one' => q({0} м),
						'other' => q({0} м),
						'per' => q({0}/м),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(м),
						'one' => q({0} м),
						'other' => q({0} м),
						'per' => q({0}/м),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(мкм),
						'one' => q({0} мкм),
						'other' => q({0} мкм),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(мкм),
						'one' => q({0} мкм),
						'other' => q({0} мкм),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(миль),
						'one' => q({0} миль),
						'other' => q({0} миль),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(миль),
						'one' => q({0} миль),
						'other' => q({0} миль),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(нм),
						'one' => q({0} нм),
						'other' => q({0} нм),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(нм),
						'one' => q({0} нм),
						'other' => q({0} нм),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(парсек),
						'one' => q({0} пк),
						'other' => q({0} пк),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(парсек),
						'one' => q({0} пк),
						'other' => q({0} пк),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(пункт),
						'one' => q({0} пункт),
						'other' => q({0} пункт),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(пункт),
						'one' => q({0} пункт),
						'other' => q({0} пункт),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(Күн радиусы),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(Күн радиусы),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(кд),
						'one' => q({0} кд),
						'other' => q({0} кд),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(кд),
						'one' => q({0} кд),
						'other' => q({0} кд),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(лм),
						'one' => q({0} лм),
						'other' => q({0} лм),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(лм),
						'one' => q({0} лм),
						'other' => q({0} лм),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(люкс),
						'one' => q({0} лк),
						'other' => q({0} лк),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(люкс),
						'one' => q({0} лк),
						'other' => q({0} лк),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(Күн жарықтығы),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(Күн жарықтығы),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(карат),
						'one' => q({0} кар.),
						'other' => q({0} кар.),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(карат),
						'one' => q({0} кар.),
						'other' => q({0} кар.),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(Да),
						'one' => q({0} Да),
						'other' => q({0} Да),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(Да),
						'one' => q({0} Да),
						'other' => q({0} Да),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(гран),
						'one' => q({0} гран),
						'other' => q({0} гран),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(гран),
						'one' => q({0} гран),
						'other' => q({0} гран),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(грамм),
						'one' => q({0} г),
						'other' => q({0} г),
						'per' => q({0}/г),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(грамм),
						'one' => q({0} г),
						'other' => q({0} г),
						'per' => q({0}/г),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
						'per' => q({0}/кг),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
						'per' => q({0}/кг),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(мкг),
						'one' => q({0} мкг),
						'other' => q({0} мкг),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(мкг),
						'one' => q({0} мкг),
						'other' => q({0} мкг),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(мг),
						'one' => q({0} мг),
						'other' => q({0} мг),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(мг),
						'one' => q({0} мг),
						'other' => q({0} мг),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(унц.),
						'one' => q({0} унц.),
						'other' => q({0} унц.),
						'per' => q({0}/унц.),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(унц.),
						'one' => q({0} унц.),
						'other' => q({0} унц.),
						'per' => q({0}/унц.),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(тр. унц.),
						'one' => q({0} тр. унц.),
						'other' => q({0} тр. унц.),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(тр. унц.),
						'one' => q({0} тр. унц.),
						'other' => q({0} тр. унц.),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(фунт),
						'one' => q({0} фунт),
						'other' => q({0} фунт),
						'per' => q({0}/фунт),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(фунт),
						'one' => q({0} фунт),
						'other' => q({0} фунт),
						'per' => q({0}/фунт),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(Күн массасы),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(Күн массасы),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(стоун),
						'one' => q({0} стоун),
						'other' => q({0} стоун),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(стоун),
						'one' => q({0} стоун),
						'other' => q({0} стоун),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(тонна),
						'one' => q({0} тн),
						'other' => q({0} тн),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(тонна),
						'one' => q({0} тн),
						'other' => q({0} тн),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(т),
						'one' => q({0} т),
						'other' => q({0} т),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(т),
						'one' => q({0} т),
						'other' => q({0} т),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(ГВт),
						'one' => q({0} ГВт),
						'other' => q({0} ГВт),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(ГВт),
						'one' => q({0} ГВт),
						'other' => q({0} ГВт),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(а. к.),
						'one' => q({0} а. к.),
						'other' => q({0} а. к.),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(а. к.),
						'one' => q({0} а. к.),
						'other' => q({0} а. к.),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(кВт),
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(кВт),
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(МВт),
						'one' => q({0} МВт),
						'other' => q({0} МВт),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(МВт),
						'one' => q({0} МВт),
						'other' => q({0} МВт),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(мВт),
						'one' => q({0} мВт),
						'other' => q({0} мВт),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(мВт),
						'one' => q({0} мВт),
						'other' => q({0} мВт),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(ватт),
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(ватт),
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(атм),
						'one' => q({0} атм),
						'other' => q({0} атм),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(атм),
						'one' => q({0} атм),
						'other' => q({0} атм),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(бар),
						'one' => q({0} бар),
						'other' => q({0} бар),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(бар),
						'one' => q({0} бар),
						'other' => q({0} бар),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(гПа),
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(гПа),
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(дюйм сынап бағанасы),
						'one' => q({0} дюйм с.б.),
						'other' => q({0} дюйм с.б.),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(дюйм сынап бағанасы),
						'one' => q({0} дюйм с.б.),
						'other' => q({0} дюйм с.б.),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(кПа),
						'one' => q({0} кПа),
						'other' => q({0} кПа),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(кПа),
						'one' => q({0} кПа),
						'other' => q({0} кПа),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(МПа),
						'one' => q({0} МПа),
						'other' => q({0} МПа),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(МПа),
						'one' => q({0} МПа),
						'other' => q({0} МПа),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(мбар),
						'one' => q({0} мбар),
						'other' => q({0} мбар),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(мбар),
						'one' => q({0} мбар),
						'other' => q({0} мбар),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(мм с.б.),
						'one' => q({0} мм с.б.),
						'other' => q({0} мм с.б.),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(мм с.б.),
						'one' => q({0} мм с.б.),
						'other' => q({0} мм с.б.),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(Па),
						'one' => q({0} Па),
						'other' => q({0} Па),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(Па),
						'one' => q({0} Па),
						'other' => q({0} Па),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'name' => q(бфт),
						'one' => q(бофорт {0}),
						'other' => q(бофорт {0}),
					},
					# Core Unit Identifier
					'beaufort' => {
						'name' => q(бфт),
						'one' => q(бофорт {0}),
						'other' => q(бофорт {0}),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(км/сағ),
						'one' => q({0} км/сағ),
						'other' => q({0} км/сағ),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(км/сағ),
						'one' => q({0} км/сағ),
						'other' => q({0} км/сағ),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(тн),
						'one' => q({0} түйін),
						'other' => q({0} түйін),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(тн),
						'one' => q({0} түйін),
						'other' => q({0} түйін),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(метр/секунд),
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(метр/секунд),
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(миль/сағат),
						'one' => q({0} миль/сағ),
						'other' => q({0} миль/сағ),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(миль/сағат),
						'one' => q({0} миль/сағ),
						'other' => q({0} миль/сағ),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(Цельсий градусы),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(Цельсий градусы),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(F градусы),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(F градусы),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'one' => q({0} К),
						'other' => q({0} К),
					},
					# Core Unit Identifier
					'kelvin' => {
						'one' => q({0} К),
						'other' => q({0} К),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(Н⋅м),
						'one' => q({0} Н⋅м),
						'other' => q({0} Н⋅м),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(Н⋅м),
						'one' => q({0} Н⋅м),
						'other' => q({0} Н⋅м),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(акр-фут),
						'one' => q({0} aкр-фут),
						'other' => q({0} aкр-фут),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(акр-фут),
						'one' => q({0} aкр-фут),
						'other' => q({0} aкр-фут),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(баррель),
						'one' => q({0} баррель),
						'other' => q({0} баррель),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(баррель),
						'one' => q({0} баррель),
						'other' => q({0} баррель),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(бушель),
						'one' => q({0} бш),
						'other' => q({0} бш),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(бушель),
						'one' => q({0} бш),
						'other' => q({0} бш),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(сл),
						'one' => q({0} cл),
						'other' => q({0} cл),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(сл),
						'one' => q({0} cл),
						'other' => q({0} cл),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(cм³),
						'one' => q({0} cм³),
						'other' => q({0} cм³),
						'per' => q({0}/см³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(cм³),
						'one' => q({0} cм³),
						'other' => q({0} cм³),
						'per' => q({0}/см³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(фут³),
						'one' => q({0} фут³),
						'other' => q({0} фут³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(фут³),
						'one' => q({0} фут³),
						'other' => q({0} фут³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(дюйм³),
						'one' => q({0} дюйм³),
						'other' => q({0} дюйм³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(дюйм³),
						'one' => q({0} дюйм³),
						'other' => q({0} дюйм³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(км³),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(км³),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(м³),
						'one' => q({0} м³),
						'other' => q({0} м³),
						'per' => q({0}/м³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(м³),
						'one' => q({0} м³),
						'other' => q({0} м³),
						'per' => q({0}/м³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(миль³),
						'one' => q({0} миль³),
						'other' => q({0} миль³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(миль³),
						'one' => q({0} миль³),
						'other' => q({0} миль³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(ярд³),
						'one' => q({0} ярд³),
						'other' => q({0} ярд³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(ярд³),
						'one' => q({0} ярд³),
						'other' => q({0} ярд³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(кесе),
						'one' => q({0} к.),
						'other' => q({0} к.),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(кесе),
						'one' => q({0} к.),
						'other' => q({0} к.),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(мк),
						'one' => q({0} мк),
						'other' => q({0} мк),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(мк),
						'one' => q({0} мк),
						'other' => q({0} мк),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(дл),
						'one' => q({0} дл),
						'other' => q({0} дл),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(дл),
						'one' => q({0} дл),
						'other' => q({0} дл),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(дес. қас.),
						'one' => q({0} дес. қас.),
						'other' => q({0} дес. қас.),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(дес. қас.),
						'one' => q({0} дес. қас.),
						'other' => q({0} дес. қас.),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(имп. дес. қас.),
						'one' => q({0} имп. дес. қас.),
						'other' => q({0} имп. дес. қас.),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(имп. дес. қас.),
						'one' => q({0} имп. дес. қас.),
						'other' => q({0} имп. дес. қас.),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(сұйық драхма),
						'one' => q({0} сұй. драхма),
						'other' => q({0} сұй. драхма),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(сұйық драхма),
						'one' => q({0} сұй. драхма),
						'other' => q({0} сұй. драхма),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(тамшы),
						'one' => q({0} тамшы),
						'other' => q({0} тамшы),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(тамшы),
						'one' => q({0} тамшы),
						'other' => q({0} тамшы),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(сұй. унц.),
						'one' => q({0} сұй. унц.),
						'other' => q({0} сұй. унц.),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(сұй. унц.),
						'one' => q({0} сұй. унц.),
						'other' => q({0} сұй. унц.),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(имп. сұй. унция),
						'one' => q({0} имп. сұй. унция),
						'other' => q({0} имп. сұй. унция),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(имп. сұй. унция),
						'one' => q({0} имп. сұй. унция),
						'other' => q({0} имп. сұй. унция),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(гал.),
						'one' => q({0} гал.),
						'other' => q({0} гал.),
						'per' => q({0}/гал.),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(гал.),
						'one' => q({0} гал.),
						'other' => q({0} гал.),
						'per' => q({0}/гал.),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(имп. галлон),
						'one' => q({0} имп. галлон),
						'other' => q({0} имп. галлон),
						'per' => q({0}/имп. галлон),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(имп. галлон),
						'one' => q({0} имп. галлон),
						'other' => q({0} имп. галлон),
						'per' => q({0}/имп. галлон),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(гл),
						'one' => q({0} гл),
						'other' => q({0} гл),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(гл),
						'one' => q({0} гл),
						'other' => q({0} гл),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(джиггер),
						'one' => q({0} джиггер),
						'other' => q({0} джиггер),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(джиггер),
						'one' => q({0} джиггер),
						'other' => q({0} джиггер),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(литр),
						'one' => q({0} л),
						'other' => q({0} л),
						'per' => q({0}/л),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(литр),
						'one' => q({0} л),
						'other' => q({0} л),
						'per' => q({0}/л),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(Мл),
						'one' => q({0} Мл),
						'other' => q({0} Мл),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(Мл),
						'one' => q({0} Мл),
						'other' => q({0} Мл),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(мл),
						'one' => q({0} мл),
						'other' => q({0} мл),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(мл),
						'one' => q({0} мл),
						'other' => q({0} мл),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(шөкім),
						'one' => q({0} шөкім),
						'other' => q({0} шөкім),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(шөкім),
						'one' => q({0} шөкім),
						'other' => q({0} шөкім),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(пинта),
						'one' => q({0} пт),
						'other' => q({0} пт),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(пинта),
						'one' => q({0} пт),
						'other' => q({0} пт),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(мпт),
						'one' => q({0} мпт),
						'other' => q({0} мпт),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(мпт),
						'one' => q({0} мпт),
						'other' => q({0} мпт),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(кт),
						'one' => q({0} кт),
						'other' => q({0} кт),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(кт),
						'one' => q({0} кт),
						'other' => q({0} кт),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(брит. кварта),
						'one' => q({0} брит. кварта),
						'other' => q({0} брит. кварта),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(брит. кварта),
						'one' => q({0} брит. кварта),
						'other' => q({0} брит. кварта),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(ас қ.),
						'one' => q({0} ас қ.),
						'other' => q({0} ас қ.),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(ас қ.),
						'one' => q({0} ас қ.),
						'other' => q({0} ас қ.),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(ш. қ.),
						'one' => q({0} ш. қ.),
						'other' => q({0} ш. қ.),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(ш. қ.),
						'one' => q({0} ш. қ.),
						'other' => q({0} ш. қ.),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:иә|и|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:жоқ|ж|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				2 => q({0} және {1}),
		} }
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'group' => q( ),
			'nan' => q(сан емес),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'one' => '0 мың',
					'other' => '0 мың',
				},
				'10000' => {
					'one' => '00 мың',
					'other' => '00 мың',
				},
				'100000' => {
					'one' => '000 мың',
					'other' => '000 мың',
				},
				'1000000' => {
					'one' => '0 миллион',
					'other' => '0 миллион',
				},
				'10000000' => {
					'one' => '00 миллион',
					'other' => '00 миллион',
				},
				'100000000' => {
					'one' => '000 миллион',
					'other' => '000 миллион',
				},
				'1000000000' => {
					'one' => '0 миллиард',
					'other' => '0 миллиард',
				},
				'10000000000' => {
					'one' => '00 миллиард',
					'other' => '00 миллиард',
				},
				'100000000000' => {
					'one' => '000 миллиард',
					'other' => '000 миллиард',
				},
				'1000000000000' => {
					'one' => '0 триллион',
					'other' => '0 триллион',
				},
				'10000000000000' => {
					'one' => '00 триллион',
					'other' => '00 триллион',
				},
				'100000000000000' => {
					'one' => '000 триллион',
					'other' => '000 триллион',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 мың',
					'other' => '0 мың',
				},
				'10000' => {
					'one' => '00 мың',
					'other' => '00 мың',
				},
				'100000' => {
					'one' => '000 м'.'',
					'other' => '000 м'.'',
				},
				'1000000' => {
					'one' => '0 млн',
					'other' => '0 млн',
				},
				'10000000' => {
					'one' => '00 млн',
					'other' => '00 млн',
				},
				'100000000' => {
					'one' => '000 млн',
					'other' => '000 млн',
				},
				'1000000000' => {
					'one' => '0 млрд',
					'other' => '0 млрд',
				},
				'10000000000' => {
					'one' => '00 млрд',
					'other' => '00 млрд',
				},
				'100000000000' => {
					'one' => '000 млрд',
					'other' => '000 млрд',
				},
				'1000000000000' => {
					'one' => '0 трлн',
					'other' => '0 трлн',
				},
				'10000000000000' => {
					'one' => '00 трлн',
					'other' => '00 трлн',
				},
				'100000000000000' => {
					'one' => '000 трлн',
					'other' => '000 трлн',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(#,##0.00)',
						'positive' => '#,##0.00',
					},
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(Біріккен Араб Әмірліктерінің дирхамы),
				'one' => q(БАӘ дирхамы),
				'other' => q(БАӘ дирхамы),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(Ауғанстан афганиі),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(Албания легі),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(Армения драмы),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(Нидерланд антиль гульдені),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(Ангола кванзасы),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(Аргентина песосы),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(Аустралия доллары),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(Аруба флорині),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(Азербайджан манаты \(1993–2006\)),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(Әзірбайжан манаты),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(Босния және Герцеговина айырбасталмалы маркасы),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(Барбадос доллары),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(Бангладеш такасы),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(Болгария леві),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(Бахрейн динары),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(Бурунди франкі),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(Бермуд доллары),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(Бруней доллары),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(Боливия боливианосы),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(Бразилия реалы),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(Багам доллары),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(Бутан нгултрумы),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(Ботсвана пуласы),
			},
		},
		'BYN' => {
			symbol => 'р.',
			display_name => {
				'currency' => q(Беларусь рублі),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(Беларусь рублі \(2000–2016\)),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(Белиз доллары),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(Канада доллары),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(Конго франкі),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(Швейцария франкі),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(Чили песосы),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(Қытай юані \(офшор\)),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(Қытай юані),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(Колумбия песосы),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(Коста-Рика колоны),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(Куба айырбасталмалы песосы),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(Куба песосы),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(Кабо-Верде эскудосы),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(Чехия кронасы),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(Джибути франкі),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(Дат кроны),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(Доминикан песосы),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(Алжир динары),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(Мысыр фунты),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(Эритрея накфасы),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(Эфиопия быры),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(Еуро),
				'one' => q(еуро),
				'other' => q(еуро),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(Фиджи доллары),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(Фолкленд аралдарының фунты),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(Британдық фунт),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(Грузия лариі),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(Гана седиі),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(Гибралтар фунты),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(Гамбия даласиі),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(Гвинея франкі),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(Гватемала кетсалі),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(Гайана доллары),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(Гонконг доллары),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(Гондурас лемпирасы),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(Хорватия кунасы),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(Гаити гурды),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(Венгрия форинті),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(Индонезия рупиясы),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(Израиль жаңа шекелі),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(Үндістан рупиясы),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(Ирак динары),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(Иран риалы),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(Исландия кронасы),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(Ямайка доллары),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(Иордания динары),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(Жапония иенасы),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(Кения шиллингі),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(Қырғызстан сомы),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(Камбоджа риелі),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(Комор аралдары франкі),
				'one' => q(Комор аралдары франкы),
				'other' => q(Комор аралдары франкы),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(Солтүстік Корея воны),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(Оңтүстік Корея воны),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(Кувейт динары),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(Кайман аралдары доллары),
			},
		},
		'KZT' => {
			symbol => '₸',
			display_name => {
				'currency' => q(Қазақстан теңгесі),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(Лаос кипі),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(Ливан фунты),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(Шри-Ланка рупиясы),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(Либерия доллары),
			},
		},
		'LSL' => {
			symbol => 'ЛСЛ',
			display_name => {
				'currency' => q(Лесото лотиі),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(Литва литы),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(Латвия латы),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(Ливия динары),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(Марокко дирхамы),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(Молдова лейі),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(Малагаси ариариі),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(Македония динары),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(Мьянма кьяты),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(Моңғолия тугригі),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(Макао патакасы),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(Мавритания угиясы \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(Мавритания угиясы),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(Маврикий рупиясы),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(Мальдив руфиясы),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(Малави квачасы),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(Мексика песосы),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(Малайзия ринггиті),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(Мозамбик метикалы),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(Намибия доллары),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(Нигерия найрасы),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(Никарагуа кордобасы),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(Норвегия кроны),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(Непал рупиясы),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(Жаңа Зеландия доллары),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(Оман риалы),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(Панама бальбоасы),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(Перу солі),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(Папуа - Жаңа Гвинея кинасы),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(Филиппин песосы),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(Пәкістан рупиясы),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(Польша злотасы),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(Парагвай гуараниі),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(Катар риалы),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(Румыния лейі),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(Сербия динары),
			},
		},
		'RUB' => {
			symbol => '₽',
			display_name => {
				'currency' => q(Ресей рублі),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(Руанда франкі),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(Сауд Арабиясының риалы),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(Соломон аралдары доллары),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(Сейшель рупиясы),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(Судан фунты),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(Швеция кроны),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(Сингапур доллары),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(Әулие Елена аралы фунты),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(Сьерра-Леоне леонесі),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(Сьерра-Леоне леонесі \(1964—2022\)),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(Сомали шиллингі),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(Суринам доллары),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(Оңтүстік Судан фунты),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(Сант-Томе мен Принсипи добрасы \(1977–2017\)),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(Сант-Томе мен Принсипи добрасы),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(Сирия фунты),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(Свазиленд лилангениі),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(Тай баты),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(Тәжікстан сомониі),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(Түрікменстан манаты),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(Тунис динары),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(Тонга паангасы),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(Түрік лирасы),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(Тринидад және Тобаго доллары),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(Жаңа Тайвань доллары),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(Танзания шиллингі),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(Украина гривнасы),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(Уганда шиллингі),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(АҚШ доллары),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(Уругвай песосы),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(Өзбекстан сомы),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(Венесуэла боливары \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(Венесуэла боливары),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(Вьетнам донгі),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(Вануату ватуы),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(Самоа таласы),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(Орталық Африканың КФА франкі),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(Шығыс Кариб доллары),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(Батыс Африканың КФА франкі),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(КФП франкі),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Белгісіз валюта),
				'one' => q(\(белгісіз валюта бірлігі\)),
				'other' => q(\(белгісіз валюта\)),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(Йемен риалы),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(Оңтүстік Африка рэнді),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(Замбия квачасы),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					wide => {
						nonleap => [
							'Тут',
							'Баба',
							'Хатур',
							'Кийяк',
							'Туба',
							'Ашмир',
							'Барамхат',
							'Барамуда',
							'Башанс',
							'Ба’уна',
							'’абиб',
							'Мисра',
							'Наси’'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'қаң.',
							'ақп.',
							'нау.',
							'сәу.',
							'мам.',
							'мау.',
							'шіл.',
							'там.',
							'қыр.',
							'қаз.',
							'қар.',
							'жел.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'қаңтар',
							'ақпан',
							'наурыз',
							'сәуір',
							'мамыр',
							'маусым',
							'шілде',
							'тамыз',
							'қыркүйек',
							'қазан',
							'қараша',
							'желтоқсан'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'Қ',
							'А',
							'Н',
							'С',
							'М',
							'М',
							'Ш',
							'Т',
							'Қ',
							'Қ',
							'Қ',
							'Ж'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Қаңтар',
							'Ақпан',
							'Наурыз',
							'Сәуір',
							'Мамыр',
							'Маусым',
							'Шілде',
							'Тамыз',
							'Қыркүйек',
							'Қазан',
							'Қараша',
							'Желтоқсан'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					wide => {
						nonleap => [
							'Тишрей',
							'Хешван',
							'Кислев',
							'Тевет',
							'Шват',
							'Адар I',
							'Адар',
							'Нисан',
							'Ияр',
							'Сиван',
							'Тамуз',
							'Ав',
							'Элул'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'Чайтра',
							'Вайшакха',
							'Джьештха',
							'Ашадха',
							'Шравана',
							'Бхадрапада',
							'Ашвина',
							'Картика',
							'Маргаширша',
							'Пауша',
							'Магха',
							'Пхальгуна'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'Қаң.',
							'Ақп.',
							'Нау.',
							'Сәу.',
							'Мам.',
							'Jum. II',
							'шіл.',
							'там.',
							'Қыр.',
							'Қаз.',
							'Қар.',
							'Жел.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Мұхаррам',
							'Сафар',
							'Рабиғ әл-әууәл',
							'Рабиғ әс-сәни',
							'Джумада әл-әууәл',
							'Жумад ас-сәни',
							'Раджаб',
							'Шағбан',
							'Рамадан',
							'Шәууәл',
							'Зул-Қағда',
							'Зул-Хиджа'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'Мұх.',
							'Саф.',
							'Раб. І',
							'Раб. ІІ',
							'Жум. І',
							'Жум. ІІ',
							'Радж.',
							'Шағ.',
							'Рам.',
							'Шәу.',
							'Зул-Қ.',
							'Зул-Х.'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					wide => {
						nonleap => [
							'Фарвардин',
							'Ордибехешт',
							'Хордад',
							'Тир',
							'Мордад',
							'Шахривар',
							'Мехр',
							'Абан',
							'Азар',
							'Дей',
							'Бахман',
							'Эсфанд'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'дс',
						tue => 'сс',
						wed => 'ср',
						thu => 'бс',
						fri => 'жм',
						sat => 'сб',
						sun => 'жс'
					},
					wide => {
						mon => 'дүйсенбі',
						tue => 'сейсенбі',
						wed => 'сәрсенбі',
						thu => 'бейсенбі',
						fri => 'жұма',
						sat => 'сенбі',
						sun => 'жексенбі'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'Д',
						tue => 'С',
						wed => 'С',
						thu => 'Б',
						fri => 'Ж',
						sat => 'С',
						sun => 'Ж'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'І тқс.',
						1 => 'ІІ тқс.',
						2 => 'ІІІ тқс.',
						3 => 'IV тқс.'
					},
					wide => {0 => 'І тоқсан',
						1 => 'ІІ тоқсан',
						2 => 'ІІІ тоқсан',
						3 => 'IV тоқсан'
					},
				},
				'stand-alone' => {
					narrow => {0 => 'I',
						1 => 'II',
						2 => 'III',
						3 => 'IV'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{түстен кейінгі},
					'evening1' => q{кешкі},
					'midnight' => q{түн жарымы},
					'morning1' => q{таңғы},
					'night1' => q{түнгі},
					'noon' => q{түскі},
				},
				'narrow' => {
					'afternoon1' => q{түстен кейінгі},
					'evening1' => q{кешкі},
					'midnight' => q{түнгі},
					'morning1' => q{таңғы},
					'night1' => q{түнгі},
					'noon' => q{түскі},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{түстен кейін},
					'evening1' => q{кеш},
					'morning1' => q{таң},
					'night1' => q{түн},
					'noon' => q{талтүс},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'б.з.д.',
				'1' => 'б.з.'
			},
			wide => {
				'0' => 'Біздің заманымызға дейін',
				'1' => 'біздің заманымыз'
			},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'generic' => {
			'full' => q{G y 'ж'. d MMMM, EEEE},
			'long' => q{G y 'ж'. d MMMM},
			'medium' => q{G dd.MM.y},
			'short' => q{GGGGG dd.MM.y},
		},
		'gregorian' => {
			'full' => q{y 'ж'. d MMMM, EEEE},
			'long' => q{y 'ж'. d MMMM},
			'medium' => q{y 'ж'. dd MMM},
			'short' => q{dd.MM.yy},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			EBhm => q{E B h:mm},
			EBhms => q{E B h:mm:ss},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y 'ж'.},
			GyMMM => q{G y 'ж'. MMM},
			GyMMMEd => q{G y 'ж'. d MMM, E},
			GyMMMd => q{G y 'ж'. d MMM},
			GyMd => q{d/M/y GGGGG},
			MEd => q{dd.MM, E},
			MMMEd => q{d MMM, E},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			y => q{G y 'ж'.},
			yyyy => q{G y 'ж'.},
			yyyyM => q{GGGGG MM.y},
			yyyyMEd => q{GGGGG dd.MM.y, E},
			yyyyMMM => q{G y 'ж'. MMM},
			yyyyMMMEd => q{G y 'ж'. d MMM, E},
			yyyyMMMM => q{G y 'ж'. MMMM},
			yyyyMMMd => q{G y 'ж'. d MMM},
			yyyyMd => q{GGGGG dd.MM.y},
			yyyyQQQ => q{G y 'ж'. QQQ},
			yyyyQQQQ => q{G y 'ж'. QQQQ},
		},
		'gregorian' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			EBhm => q{E, B h:mm},
			EBhms => q{E, B h:mm:ss},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y 'ж'.},
			GyMMM => q{G y 'ж'. MMM},
			GyMMMEd => q{G y 'ж'. d MMM, E},
			GyMMMd => q{G y 'ж'. d MMM},
			GyMd => q{dd-MM-GGGGG y},
			MEd => q{dd.MM, E},
			MMMEd => q{d MMM, E},
			MMMMW => q{MMMM 'айының' W-'аптасы'},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			yM => q{MM.y},
			yMEd => q{dd.MM.y, E},
			yMMM => q{y 'ж'. MMM},
			yMMMEd => q{y 'ж'. d MMM, E},
			yMMMM => q{y 'ж'. MMMM},
			yMMMd => q{y 'ж'. d MMM},
			yMd => q{dd.MM.y},
			yQQQ => q{y 'ж'. QQQ},
			yQQQQ => q{y 'ж'. QQQQ},
			yw => q{Y 'жылдың' w-'аптасы'},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => {
				h => q{h – h B},
			},
			Bhm => {
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			GyMMMEd => {
				G => q{G y 'ж'. d MMM, E – G y 'ж'. d MMM, E},
				M => q{G y 'ж'. d MMM, E – d MMM, E},
				d => q{G y 'ж'. d MMM, E – d MMM, E},
				y => q{G y 'ж'. d MMM, E – y 'ж'. d MMM, E},
			},
			GyMMMd => {
				G => q{G y 'ж'. d MMM – G y 'ж'. d MMM},
				M => q{G y 'ж'. d MMM – d MMM},
				d => q{G y 'ж'. d–d MMM},
				y => q{G y 'ж'. d MMM – y 'ж'. d MMM},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{dd.MM, E – dd.MM, E},
				d => q{dd.MM, E – dd.MM, E},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{d MMM, E – d MMM, E},
				d => q{d (E) – d (E) MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{dd.MM – dd.MM},
				d => q{dd.MM – dd.MM},
			},
			fallback => '{0} - {1}',
			h => {
				h => q{h–h a},
			},
			hm => {
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				h => q{h–h a v},
			},
			y => {
				y => q{G y–y 'жж'.},
			},
			yM => {
				M => q{GGGGG MM.y – MM.y},
				y => q{GGGGG MM.y – MM.y},
			},
			yMEd => {
				M => q{GGGGG dd.MM.y, E – dd.MM.y, E},
				d => q{GGGGG dd.MM.y, E – dd.MM.y, E},
				y => q{GGGGG dd.MM.y, E – dd.MM.y, E},
			},
			yMMM => {
				M => q{G y 'ж'. MMM–MMM},
				y => q{G y 'ж'. MMM – y 'ж'. MMM},
			},
			yMMMEd => {
				M => q{G y 'ж'. d MMM, E – d MMM, E},
				d => q{G y 'ж'. d MMM, E – d MMM, E},
				y => q{G y 'ж'. d MMM, E – y 'ж'. d MMM, E},
			},
			yMMMM => {
				M => q{G y 'ж'. MMMM – MMMM},
				y => q{G y 'ж'. MMMM – y 'ж'. MMMM},
			},
			yMMMd => {
				M => q{G y 'ж'. d MMM – d MMM},
				d => q{G y 'ж'. d–d MMM},
				y => q{G y 'ж'. d MMM – y 'ж'. d MMM},
			},
			yMd => {
				M => q{GGGGG dd.MM.y – dd.MM.y},
				d => q{GGGGG dd.MM.y – dd.MM.y},
				y => q{GGGGG dd.MM.y – dd.MM.y},
			},
		},
		'gregorian' => {
			Bh => {
				h => q{h – h B},
			},
			Bhm => {
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			GyMMMEd => {
				G => q{G y 'ж'. d MMM, E – G y 'ж'. d MMM, E},
				M => q{G y 'ж'. d MMM, E – d MMM, E},
				d => q{G y 'ж'. d MMM, E – d MMM, E},
				y => q{G y 'ж'. d MMM, E – y 'ж'. d MMM, E},
			},
			GyMMMd => {
				G => q{G y 'ж'. d MMM – G y 'ж'. d MMM},
				M => q{G y 'ж'. d MMM – d MMM},
				d => q{G y 'ж'. d–d MMM},
				y => q{G y 'ж'. d MMM – y 'ж'. d MMM},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{dd.MM, E – dd.MM, E},
				d => q{dd.MM, E – dd.MM, E},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{d MMM, E – d MMM, E},
				d => q{d MMM, E – d MMM, E},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{dd.MM – dd.MM},
				d => q{dd.MM – dd.MM},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			yM => {
				M => q{MM.y – MM.y},
				y => q{MM.y – MM.y},
			},
			yMEd => {
				M => q{dd.MM.y, E – dd.MM.y, E},
				d => q{dd.MM.y, E – dd.MM.y, E},
				y => q{dd.MM.y, E – dd.MM.y, E},
			},
			yMMM => {
				M => q{y 'ж'. MMM–MMM},
				y => q{y 'ж'. MMM – y 'ж'. MMM},
			},
			yMMMEd => {
				M => q{y 'ж'. d MMM, E – d MMM, E},
				d => q{y 'ж'. d MMM, E – y 'ж'. d MMM, E},
				y => q{y 'ж'. d MMM, E – y 'ж'. d MMM, E},
			},
			yMMMM => {
				M => q{y 'ж'. MMMM – MMMM},
				y => q{y 'ж'. MMMM – y 'ж'. MMMM},
			},
			yMMMd => {
				M => q{y 'ж'. d MMM – d MMM},
				d => q{y 'ж'. d–d MMM},
				y => q{y 'ж'. d MMM – y 'ж'. d MMM},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y},
				d => q{dd.MM.y – dd.MM.y},
				y => q{dd.MM.y – dd.MM.y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		regionFormat => q({0} уақыты),
		regionFormat => q({0} жазғы уақыты),
		regionFormat => q({0} стандартты уақыты),
		'Afghanistan' => {
			long => {
				'standard' => q#Ауғанстан уақыты#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиджан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Аккра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Аддис-Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмара#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Банги#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантайр#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Браззавиль#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Бужумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каир#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Касабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар-эс-Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Джибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Эль-Аюн#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Йоханнесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Джуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Хартум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревиль#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуту#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишо#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровия#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Найроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нджамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Ниамей#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто-Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сан-Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#Орталық Африка уақыты#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#Шығыс Африка уақыты#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#Оңтүстік Африка стандартты уақыты#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#Батыс Африка жазғы уақыты#,
				'generic' => q#Батыс Африка уақыты#,
				'standard' => q#Батыс Африка стандартты уақыты#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#Аляска жазғы уақыты#,
				'generic' => q#Аляска уақыты#,
				'standard' => q#Аляска стандартты уақыты#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#Амазонка жазғы уақыты#,
				'generic' => q#Амазонка уақыты#,
				'standard' => q#Амазонка стандартты уақыты#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Анкоридж#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангилья#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигуа#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагуаина#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла-Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио-Гальегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Сальта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан-Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан-Луис#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуайя#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсьон#,
		},
		'America/Bahia' => {
			exemplarCity => q#Баия#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Баия-де-Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белен#,
		},
		'America/Belize' => {
			exemplarCity => q#Белиз#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Саблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа-Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бойсе#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буэнос-Айрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кембридж-Бей#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампу-Гранди#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кайенна#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кайман аралдары#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чиуауа#,
		},
		'America/Ciudad_Juarez' => {
			exemplarCity => q#Сьюдад-Хуарес#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Атикокан#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордова#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Коста-Рика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куяба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кюрасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмарксхавн#,
		},
		'America/Dawson' => {
			exemplarCity => q#Доусон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Досон-Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детройт#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Эдмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Эйрунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Сальвадор#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#Форт-Нельсон#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глейс-Бей#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нуук#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус-Бей#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд-Терк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гваделупа#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гуаякиль#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гайана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Галифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Гавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Эрмосильо#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индиана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индиана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питерсберг, Индиана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Телл-Сити, Индиана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вивей, Индиана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винсеннес, Индиана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Уинамак, Индиана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Икалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Ямайка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуй#,
		},
		'America/Juneau' => {
			exemplarCity => q#Джуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтиселло, Кентукки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендейк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла-Пас#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос-Анджелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луисвилл#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Лоуэр-Принс-Куотер#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масейо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагуа#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиника#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Масатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоса#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мехико#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтеррей#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсеррат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Нассау#,
		},
		'America/New_York' => {
			exemplarCity => q#Нью-Йорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Норонья#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Бойла, Солтүстік Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Сентер, Солтүстік Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нью Сейлем, Солтүстік Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангниртанг#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Финикс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт-оф-Спейн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порту-Велью#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Пуэрто-Рико#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#Пунта-Аренас#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рейни-Ривер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ранкин-Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифи#,
		},
		'America/Regina' => {
			exemplarCity => q#Реджайна#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резольют#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Риу-Бранку#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Санта-Исабель#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарен#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантьяго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто-Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сан-Паулу#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Иллоккортоормиут#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сен-Бартелеми#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент-Джонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент-Китс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Сент-Люсия#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент-Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент-Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Суифт-Каррент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигальпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Тандер-Бей#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Уайтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Виннипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Якутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Йеллоунайф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#Солтүстік Америка жазғы орталық уақыты#,
				'generic' => q#Солтүстік Америка орталық уақыты#,
				'standard' => q#Солтүстік Америка стандартты орталық уақыты#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#Солтүстік Америка жазғы шығыс уақыты#,
				'generic' => q#Солтүстік Америка шығыс уақыты#,
				'standard' => q#Солтүстік Америка стандартты шығыс уақыты#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#Солтүстік Америка жазғы тау уақыты#,
				'generic' => q#Солтүстік Америка тау уақыты#,
				'standard' => q#Солтүстік Америка стандартты тау уақыты#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#Солтүстік Америка жазғы Тынық мұхиты уақыты#,
				'generic' => q#Солтүстік Америка Тынық мұхиты уақыты#,
				'standard' => q#Солтүстік Америка стандартты Тынық мұхиты уақыты#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кейси#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дэйвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Дюмон-д’Юрвиль#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маккуори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Моусон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Мак-Мердо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Сёва#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Тролль#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q#Апиа жазғы уақыты#,
				'generic' => q#Апиа уақыты#,
				'standard' => q#Апиа стандартты уақыты#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#Сауд Арабиясы жазғы уақыты#,
				'generic' => q#Сауд Арабиясы уақыты#,
				'standard' => q#Сауд Арабиясы стандартты уақыты#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгйир#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#Аргентина жазғы уақыты#,
				'generic' => q#Аргентина уақыты#,
				'standard' => q#Аргентина стандартты уақыты#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#Батыс Аргентина жазғы уақыты#,
				'generic' => q#Батыс Аргентина уақыты#,
				'standard' => q#Батыс Аргентина стандартты уақыты#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#Армения жазғы уақыты#,
				'generic' => q#Армения уақыты#,
				'standard' => q#Армения стандартты уақыты#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алматы#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Амман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадыр#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Ақтау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Ақтөбе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#Атырау#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Бағдат#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахрейн#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#Барнауыл#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бейрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бішкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Бруней#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калькутта#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Чита#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чойбалсан#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дакка#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубай#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#Фамагуста#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеврон#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Гонконг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркутск#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Джакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Джаяпура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Иерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандыга#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Красноярск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала-Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучинг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувейт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макасар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Маскат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никосия#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузнецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосібір#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омбы#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пномпень#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтианак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пхеньян#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#Қостанай#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Қызылорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Янгон#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Эр-Рияд#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хошимин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарқанд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шанхай#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Среднеколымск#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тайбэй#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Тегеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тхимпху#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#Томск#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Ұланбатыр#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Үрімші#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Усть-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Вьентьян#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Якутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Екатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Ереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#Атлантика жазғы уақыты#,
				'generic' => q#Атлантика уақыты#,
				'standard' => q#Атлантика стандартты уақыты#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азор аралдары#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуд аралдары#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канар аралдары#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Кабо-Верде#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарер аралдары#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадейра#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рейкьявик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Оңтүстік Георгия#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Әулие Елена аралы#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стэнли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Брисбен#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен-Хилл#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Керри#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Юкла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд-Хау#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мельбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сидней#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#Аустралия жазғы орталық уақыты#,
				'generic' => q#Орталық Аустралия уақыты#,
				'standard' => q#Аустралия стандартты орталық уақыты#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#Аустралия жазғы орталық-батыс уақыты#,
				'generic' => q#Аустралия орталық-батыс уақыты#,
				'standard' => q#Аустралия стандартты орталық-батыс уақыты#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#Аустралия жазғы шығыс уақыты#,
				'generic' => q#Шығыс Аустралия уақыты#,
				'standard' => q#Аустралия стандартты шығыс уақыты#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#Аустралия жазғы батыс уақыты#,
				'generic' => q#Батыс Аустралия уақыты#,
				'standard' => q#Аустралия стандартты батыс уақыты#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#Әзірбайжан жазғы уақыты#,
				'generic' => q#Әзірбайжан уақыты#,
				'standard' => q#Әзірбайжан стандартты уақыты#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#Азор аралдары жазғы уақыты#,
				'generic' => q#Азор аралдары уақыты#,
				'standard' => q#Азор аралдары стандартты уақыты#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#Бангладеш жазғы уақыты#,
				'generic' => q#Бангладеш уақыты#,
				'standard' => q#Бангладеш стандартты уақыты#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#Бутан уақыты#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#Боливия уақыты#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#Бразилия жазғы уақыты#,
				'generic' => q#Бразилия уақыты#,
				'standard' => q#Бразилия стандартты уақыты#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#Бруней-Даруссалам уақыты#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#Кабо-Верде жазғы уақыты#,
				'generic' => q#Кабо-Верде уақыты#,
				'standard' => q#Кабо-Верде стандартты уақыты#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#Чаморро стандартты уақыты#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#Чатем жазғы уақыты#,
				'generic' => q#Чатем уақыты#,
				'standard' => q#Чатем стандартты уақыты#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#Чили жазғы уақыты#,
				'generic' => q#Чили уақыты#,
				'standard' => q#Чили стандартты уақыты#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#Қытай жазғы уақыты#,
				'generic' => q#Қытай уақыты#,
				'standard' => q#Қытай стандартты уақыты#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#Чойбалсан жазғы уақыты#,
				'generic' => q#Чойбалсан уақыты#,
				'standard' => q#Чойбалсан стандартты уақыты#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#Рождество аралының уақыты#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#Кокос аралдарының уақыты#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#Колумбия жазғы уақыты#,
				'generic' => q#Колумбия уақыты#,
				'standard' => q#Колумбия стандартты уақыты#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#Кук аралдарының жартылай жазғы уақыты#,
				'generic' => q#Кук аралдарының уақыты#,
				'standard' => q#Кук аралдарының стандартты уақыты#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#Куба жазғы уақыты#,
				'generic' => q#Куба уақыты#,
				'standard' => q#Куба стандартты уақыты#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#Дейвис уақыты#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#Дюмон-д’Юрвиль уақыты#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#Шығыс Тимор уақыты#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#Пасха аралы жазғы уақыты#,
				'generic' => q#Пасха аралы уақыты#,
				'standard' => q#Пасха аралы стандартты уақыты#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#Эквадор уақыты#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#Дүниежүзілік үйлестірілген уақыт#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Белгісіз қала#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андорра#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#Астрахан#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Афина#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брюссель#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Бухарест#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будапешт#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бюзинген-ам-Хохрайн#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинев#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенгаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Дублин#,
			long => {
				'daylight' => q#Ирландия стандартты уақыты#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернси#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хельсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Мэн аралы#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Стамбұл#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Джерси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Киев#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#Киров#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лиссабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Любляна#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q#Ұлыбритания жазғы уақыты#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Люксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Мальта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Мариехамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Мәскеу#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париж#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан-Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараево#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#Саратов#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферополь#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопье#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#София#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокгольм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Таллин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#Ульяновск#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуц#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Вена#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вильнюс#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожье#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цюрих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#Орталық Еуропа жазғы уақыты#,
				'generic' => q#Орталық Еуропа уақыты#,
				'standard' => q#Орталық Еуропа стандартты уақыты#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#Шығыс Еуропа жазғы уақыты#,
				'generic' => q#Шығыс Еуропа уақыты#,
				'standard' => q#Шығыс Еуропа стандартты уақыты#,
			},
			short => {
				'daylight' => q#EEST#,
				'generic' => q#EET#,
				'standard' => q#EET#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#Қиыр Шығыс Еуропа уақыты#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#Батыс Еуропа жазғы уақыты#,
				'generic' => q#Батыс Еуропа уақыты#,
				'standard' => q#Батыс Еуропа стандартты уақыты#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#Фолкленд аралдары жазғы уақыты#,
				'generic' => q#Фолкленд аралдары уақыты#,
				'standard' => q#Фолкленд аралдары стандартты уақыты#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#Фиджи жазғы уақыты#,
				'generic' => q#Фиджи уақыты#,
				'standard' => q#Фиджи стандартты уақыты#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#Француз Гвианасы уақыты#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#Францияның оңтүстік аймағы және Антарктика уақыты#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#Гринвич уақыты#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#Галапагос уақыты#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#Гамбье уақыты#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#Грузия жазғы уақыты#,
				'generic' => q#Грузия уақыты#,
				'standard' => q#Грузия стандартты уақыты#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#Гилберт аралдарының уақыты#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#Шығыс Гренландия жазғы уақыты#,
				'generic' => q#Шығыс Гренландия уақыты#,
				'standard' => q#Шығыс Гренландия стандартты уақыты#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#Батыс Гренландия жазғы уақыты#,
				'generic' => q#Батыс Гренландия уақыты#,
				'standard' => q#Батыс Гренландия стандартты уақыты#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#Парсы шығанағы стандартты уақыты#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#Гайана уақыты#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#Гавай және Алеут аралдары жазғы уақыты#,
				'generic' => q#Гавай және Алеут аралдары уақыты#,
				'standard' => q#Гавай және Алеут аралдары стандартты уақыты#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#Гонконг жазғы уақыты#,
				'generic' => q#Гонконг уақыты#,
				'standard' => q#Гонконг стандартты уақыты#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#Ховд жазғы уақыты#,
				'generic' => q#Ховд уақыты#,
				'standard' => q#Ховд стандартты уақыты#,
			},
		},
		'India' => {
			long => {
				'standard' => q#Үндістан стандартты уақыты#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариву#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Рождество аралы#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокос аралдары#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Комор аралдары#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Маэ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Мальдив аралдары#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маврикий#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Майотта#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реюньон#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#Үнді мұхиты уақыты#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#Үндіқытай уақыты#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#Орталық Индонезия уақыты#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#Шығыс Индонезия уақыты#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#Батыс Индонезия уақыты#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#Иран жазғы уақыты#,
				'generic' => q#Иран уақыты#,
				'standard' => q#Иран стандартты уақыты#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#Иркутск жазғы уақыты#,
				'generic' => q#Иркутск уақыты#,
				'standard' => q#Иркутск стандартты уақыты#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#Израиль жазғы уақыты#,
				'generic' => q#Израиль уақыты#,
				'standard' => q#Израиль стандартты уақыты#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#Жапония жазғы уақыты#,
				'generic' => q#Жапония уақыты#,
				'standard' => q#Жапония стандартты уақыты#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#Шығыс Қазақстан уақыты#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#Батыс Қазақстан уақыты#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#Корея жазғы уақыты#,
				'generic' => q#Корея уақыты#,
				'standard' => q#Корея стандартты уақыты#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#Кусаие уақыты#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#Красноярск жазғы уақыты#,
				'generic' => q#Красноярск уақыты#,
				'standard' => q#Красноярск стандартты уақыты#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#Қырғызстан уақыты#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#Лайн аралдары уақыты#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#Лорд-Хау жазғы уақыты#,
				'generic' => q#Лорд-Хау уақыты#,
				'standard' => q#Лорд-Хау стандартты уақыты#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#Маккуори аралы уақыты#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#Магадан жазғы уақыты#,
				'generic' => q#Магадан уақыты#,
				'standard' => q#Магадан стандартты уақыты#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#Малайзия уақыты#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#Мальдив аралдары уақыты#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#Маркиз аралдары уақыты#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#Маршалл аралдары уақыты#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#Маврикий жазғы уақыты#,
				'generic' => q#Маврикий уақыты#,
				'standard' => q#Маврикий стандартты уақыты#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#Моусон уақыты#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#Солтүстік-батыс Мексика жазғы уақыты#,
				'generic' => q#Солтүстік-батыс Мексика уақыты#,
				'standard' => q#Солтүстік-батыс Мексика стандартты уақыты#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#Мексика жазғы Тынық мұхит уақыты#,
				'generic' => q#Мексика Тынық мұхит уақыты#,
				'standard' => q#Мексика стандартты Тынық мұхит уақыты#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#Ұланбатыр жазғы уақыты#,
				'generic' => q#Ұланбатыр уақыты#,
				'standard' => q#Ұланбатыр стандартты уақыты#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#Мәскеу жазғы уақыты#,
				'generic' => q#Мәскеу уақыты#,
				'standard' => q#Мәскеу стандартты уақыты#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#Мьянма уақыты#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#Науру уақыты#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#Непал уақыты#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#Жаңа Каледония жазғы уақыты#,
				'generic' => q#Жаңа Каледония уақыты#,
				'standard' => q#Жаңа Каледония стандартты уақыты#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#Жаңа Зеландия жазғы уақыты#,
				'generic' => q#Жаңа Зеландия уақыты#,
				'standard' => q#Жаңа Зеландия стандартты уақыты#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#Ньюфаундленд жазғы уақыты#,
				'generic' => q#Ньюфаундленд уақыты#,
				'standard' => q#Ньюфаундленд стандартты уақыты#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#Ниуэ уақыты#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#Норфолк аралы жазғы уақыты#,
				'generic' => q#Норфолк аралы уақыты#,
				'standard' => q#Норфолк аралы стандартты уақыты#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#Фернанду-ди-Норонья жазғы уақыты#,
				'generic' => q#Фернанду-ди-Норонья уақыты#,
				'standard' => q#Фернанду-ди-Норонья стандартты уақыты#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#Новосібір жазғы уақыты#,
				'generic' => q#Новосібір уақыты#,
				'standard' => q#Новосібір стандартты уақыты#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#Омбы жазғы уақыты#,
				'generic' => q#Омбы уақыты#,
				'standard' => q#Омбы стандартты уақыты#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апиа#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окленд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Бугенвиль#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатем#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Пасха аралы#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Эфате#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Эндербери#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фиджи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбье#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гуадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Гонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Джонстон#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#Кантон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Кусаие#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваджалейн#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Маджуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркиз аралдары#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидуэй#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуэ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго-Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкэрн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понапе#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт-Морсби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сайпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Таити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Трук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Уэйк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Уоллис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#Пәкістан жазғы уақыты#,
				'generic' => q#Пәкістан уақыты#,
				'standard' => q#Пәкістан стандартты уақыты#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#Палау уақыты#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#Папуа – Жаңа Гвинея уақыты#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#Парагвай жазғы уақыты#,
				'generic' => q#Парагвай уақыты#,
				'standard' => q#Парагвай стандартты уақыты#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#Перу жазғы уақыты#,
				'generic' => q#Перу уақыты#,
				'standard' => q#Перу стандартты уақыты#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#Филиппин аралдары жазғы уақыты#,
				'generic' => q#Филиппин аралдары уақыты#,
				'standard' => q#Филиппин аралдары стандартты уақыты#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#Феникс аралдары уақыты#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#Сен-Пьер және Микелон жазғы уақыты#,
				'generic' => q#Сен-Пьер және Микелон уақыты#,
				'standard' => q#Сен-Пьер және Микелон стандартты уақыты#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#Питкэрн уақыты#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#Понпеи уақыты#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#Пхеньян уақыты#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#Реюньон уақыты#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#Ротера уақыты#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#Сахалин жазғы уақыты#,
				'generic' => q#Сахалин уақыты#,
				'standard' => q#Сахалин стандартты уақыты#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#Самоа жазғы уақыты#,
				'generic' => q#Самоа уақыты#,
				'standard' => q#Самоа стандартты уақыты#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#Сейшель аралдары уақыты#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#Сингапур стандартты уақыты#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#Соломон аралдары уақыты#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#Оңтүстік Георгия уақыты#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#Суринам уақыты#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#Сёва уақыты#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#Таити уақыты#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#Тайбэй жазғы уақыты#,
				'generic' => q#Тайбэй уақыты#,
				'standard' => q#Тайбэй стандартты уақыты#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#Тәжікстан уақыты#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#Токелау уақыты#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#Тонга жазғы уақыты#,
				'generic' => q#Тонга уақыты#,
				'standard' => q#Тонга стандартты уақыты#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#Трук уақыты#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#Түрікменстан жазғы уақыты#,
				'generic' => q#Түрікменстан уақыты#,
				'standard' => q#Түрікменстан стандартты уақыты#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#Тувалу уақыты#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#Уругвай жазғы уақыты#,
				'generic' => q#Уругвай уақыты#,
				'standard' => q#Уругвай стандартты уақыты#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#Өзбекстан жазғы уақыты#,
				'generic' => q#Өзбекстан уақыты#,
				'standard' => q#Өзбекстан стандартты уақыты#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#Вануату жазғы уақыты#,
				'generic' => q#Вануату уақыты#,
				'standard' => q#Вануату стандартты уақыты#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#Венесуэла уақыты#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#Владивосток жазғы уақыты#,
				'generic' => q#Владивосток уақыты#,
				'standard' => q#Владивосток стандартты уақыты#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#Волгоград жазғы уақыты#,
				'generic' => q#Волгоград уақыты#,
				'standard' => q#Волгоград стандартты уақыты#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#Восток уақыты#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#Уэйк аралы уақыты#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#Уоллис және Футуна уақыты#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#Якутск жазғы уақыты#,
				'generic' => q#Якутск уақыты#,
				'standard' => q#Якутск стандартты уақыты#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#Екатеринбург жазғы уақыты#,
				'generic' => q#Екатеринбург уақыты#,
				'standard' => q#Екатеринбург стандартты уақыты#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#Юкон уақыты#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
