=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Fa - Package for language Persian

=cut

package Locale::CLDR::Locales::Fa;
# This file auto generated from Data\common\main\fa.xml
#	on Thu 25 Jan  8:49:00 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
    is => 'ro',
    isa => ArrayRef,
    init_arg => undef,
    default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal' ]},
);

has 'algorithmic_number_format_data' => (
    is => 'ro',
    isa => HashRef,
    init_arg => undef,
    default => sub {
        use bigfloat;
        return {
		'spellout-cardinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(منفی →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(صفر),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← ممیز →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(یک),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(دو),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(سه),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(چهار),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(پنج),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(شش),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(هفت),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(هشت),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(نه),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(ده),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(یازده),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(دوازده),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(سیزده),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(چهارده),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(پانزده),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(شانزده),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(هفده),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(هجده),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(نوزده),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(بیست[ و →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(سی[ و →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(چهل[ و →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(پنجاه[ و →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(شصت[ و →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(هفتاد[ و →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(هشتاد[ و →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(نود[ و →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(صد[ و →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(دویست[ و →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(سیصد[ و →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(چهارصد[ و →→]),
				},
				'500' => {
					base_value => q(500),
					divisor => q(100),
					rule => q(پانصد[ و →→]),
				},
				'600' => {
					base_value => q(600),
					divisor => q(100),
					rule => q(ششصد[ و →→]),
				},
				'700' => {
					base_value => q(700),
					divisor => q(100),
					rule => q(هفتصد[ و →→]),
				},
				'800' => {
					base_value => q(800),
					divisor => q(100),
					rule => q(هشتصد[ و →→]),
				},
				'900' => {
					base_value => q(900),
					divisor => q(100),
					rule => q(نهصد[ و →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←← هزار[ و →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←← میلیون[ و →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←← میلیارد[ و →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←← هزار میلیارد[ و →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
			},
		},
    } },
);

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'آفاری',
 				'ab' => 'آبخازی',
 				'ace' => 'آچئی',
 				'ach' => 'آچولیایی',
 				'ada' => 'آدانگمه‌ای',
 				'ady' => 'آدیجیایی',
 				'ae' => 'اوستایی',
 				'aeb' => 'عربی تونسی',
 				'af' => 'آفریکانس',
 				'afh' => 'آفریهیلی',
 				'agq' => 'آگیم',
 				'ain' => 'آینویی',
 				'ak' => 'آکان',
 				'akk' => 'اکدی',
 				'akz' => 'آلابامایی',
 				'ale' => 'آلئوتی',
 				'alt' => 'آلتایی جنوبی',
 				'am' => 'امهری',
 				'an' => 'آراگونی',
 				'ang' => 'انگلیسی باستان',
 				'ann' => 'اوبولو',
 				'anp' => 'آنگیکا',
 				'ar' => 'عربی',
 				'ar_001' => 'عربی رسمی',
 				'arc' => 'آرامی',
 				'arn' => 'ماپوچه‌ای',
 				'arp' => 'آراپاهویی',
 				'arq' => 'عربی الجزایری',
 				'ars' => 'عربی نجدی',
 				'arw' => 'آراواکی',
 				'ary' => 'عربی مراکشی',
 				'arz' => 'عربی مصری',
 				'as' => 'آسامی',
 				'asa' => 'آسو',
 				'ast' => 'آستوری',
 				'atj' => 'آتیکامکو',
 				'av' => 'آواری',
 				'awa' => 'اودهی',
 				'ay' => 'آیمارایی',
 				'az' => 'ترکی آذربایجانی',
 				'az@alt=short' => 'آذری',
 				'az@alt=variant' => 'آذربایجانی',
 				'az_Arab' => 'ترکی آذری جنوبی',
 				'ba' => 'باشقیری',
 				'bal' => 'بلوچی',
 				'ban' => 'بالیایی',
 				'bar' => 'باواریایی',
 				'bas' => 'باسایی',
 				'bax' => 'بمونی',
 				'be' => 'بلاروسی',
 				'bej' => 'بجایی',
 				'bem' => 'بمبایی',
 				'bez' => 'بنایی',
 				'bg' => 'بلغاری',
 				'bgc' => 'هارایاناوی',
 				'bgn' => 'بلوچی غربی',
 				'bho' => 'بوجپوری',
 				'bi' => 'بیسلاما',
 				'bik' => 'بیکولی',
 				'bin' => 'بینی',
 				'bla' => 'سیکسیکا',
 				'bm' => 'بامبارایی',
 				'bn' => 'بنگالی',
 				'bo' => 'تبتی',
 				'bqi' => 'لری بختیاری',
 				'br' => 'برتون',
 				'bra' => 'براج',
 				'brh' => 'براهویی',
 				'brx' => 'بودویی',
 				'bs' => 'بوسنیایی',
 				'bua' => 'بوریاتی',
 				'bug' => 'بوگینس',
 				'byn' => 'بلین',
 				'ca' => 'کاتالان',
 				'cad' => 'کادویی',
 				'car' => 'کاریبی',
 				'cay' => 'کایوگا',
 				'ccp' => 'چاکما',
 				'ce' => 'چچنی',
 				'ceb' => 'سبویی',
 				'cgg' => 'چیگا',
 				'ch' => 'چامورویی',
 				'chb' => 'چیبچا',
 				'chg' => 'جغتایی',
 				'chk' => 'چوکی',
 				'chm' => 'ماریایی',
 				'cho' => 'چوکتویی',
 				'chp' => 'چیپه‌ویه‌ای',
 				'chr' => 'چروکی',
 				'chy' => 'شایانی',
 				'ckb' => 'کردی مرکزی',
 				'ckb@alt=menu' => 'کردی، مرکزی',
 				'ckb@alt=variant' => 'کردی سورانی',
 				'clc' => 'چیلکوتن',
 				'co' => 'کورسی',
 				'cop' => 'قبطی',
 				'cr' => 'کریایی',
 				'crg' => 'میچیف',
 				'crh' => 'ترکی کریمه',
 				'crj' => 'کری جنوب شرقی',
 				'crk' => 'کری صحرایی',
 				'crl' => 'کری شمال شرقی',
 				'crm' => 'موس کری',
 				'crr' => 'آلگانکوین کارولینا',
 				'crs' => 'سیشل آمیختهٔ فرانسوی',
 				'cs' => 'چکی',
 				'csb' => 'کاشوبی',
 				'csw' => 'کری سوامپی',
 				'cu' => 'اسلاوی کلیسایی',
 				'cv' => 'چوواشی',
 				'cy' => 'ولزی',
 				'da' => 'دانمارکی',
 				'dak' => 'داکوتایی',
 				'dar' => 'دارگوا',
 				'dav' => 'تایتا',
 				'de' => 'آلمانی',
 				'de_AT' => 'آلمانی اتریش',
 				'de_CH' => 'آلمانی معیار سوئیس',
 				'del' => 'دلاواری',
 				'dgr' => 'دوگریب',
 				'din' => 'دینکایی',
 				'dje' => 'زرما',
 				'doi' => 'دوگری',
 				'dsb' => 'صُربی سفلی',
 				'dua' => 'دوآلایی',
 				'dum' => 'هلندی میانه',
 				'dv' => 'دیوهی',
 				'dyo' => 'دیولا فونی',
 				'dyu' => 'دایولایی',
 				'dz' => 'دزونگخا',
 				'dzg' => 'دازاگا',
 				'ebu' => 'امبو',
 				'ee' => 'اوه‌ای',
 				'efi' => 'افیکی',
 				'egy' => 'مصری کهن',
 				'eka' => 'اکاجوک',
 				'el' => 'یونانی',
 				'elx' => 'عیلامی',
 				'en' => 'انگلیسی',
 				'en_AU' => 'انگلیسی استرالیا',
 				'en_CA' => 'انگلیسی کانادا',
 				'en_GB' => 'انگلیسی بریتانیا',
 				'en_US' => 'انگلیسی آمریکا',
 				'enm' => 'انگلیسی میانه',
 				'eo' => 'اسپرانتو',
 				'es' => 'اسپانیایی',
 				'es_419' => 'اسپانیایی امریکای لاتین',
 				'es_ES' => 'اسپانیایی اروپا',
 				'es_MX' => 'اسپانیایی مکزیک',
 				'et' => 'استونیایی',
 				'eu' => 'باسکی',
 				'ewo' => 'اواندو',
 				'fa' => 'فارسی',
 				'fa_AF' => 'دری',
 				'fan' => 'فانگی',
 				'fat' => 'فانتیایی',
 				'ff' => 'فولانی',
 				'fi' => 'فنلاندی',
 				'fil' => 'فیلیپینی',
 				'fj' => 'فیجیایی',
 				'fo' => 'فارویی',
 				'fon' => 'فونی',
 				'fr' => 'فرانسوی',
 				'fr_CA' => 'فرانسوی کانادا',
 				'fr_CH' => 'فرانسوی سوئیس',
 				'frc' => 'فرانسوی کاجون',
 				'frm' => 'فرانسوی میانه',
 				'fro' => 'فرانسوی باستان',
 				'frr' => 'فریزی شمالی',
 				'frs' => 'فریزی شرقی',
 				'fur' => 'فریولیایی',
 				'fy' => 'فریسی غربی',
 				'ga' => 'ایرلندی',
 				'gaa' => 'گایی',
 				'gag' => 'گاگائوزیایی',
 				'gay' => 'گایویی',
 				'gba' => 'گبایایی',
 				'gbz' => 'دری زرتشتی',
 				'gd' => 'گیلی اسکاتلندی',
 				'gez' => 'گی‌ئزی',
 				'gil' => 'گیلبرتی',
 				'gl' => 'گالیسیایی',
 				'glk' => 'گیلکی',
 				'gmh' => 'آلمانی معیار میانه',
 				'gn' => 'گوارانی',
 				'goh' => 'آلمانی علیای باستان',
 				'gon' => 'گوندی',
 				'gor' => 'گورونتالو',
 				'got' => 'گوتی',
 				'grb' => 'گریبویی',
 				'grc' => 'یونانی کهن',
 				'gsw' => 'آلمانی سوئیسی',
 				'gu' => 'گجراتی',
 				'guz' => 'گوسی',
 				'gv' => 'مانی',
 				'gwi' => 'گویچ این',
 				'ha' => 'هوسایی',
 				'hai' => 'هایدایی',
 				'haw' => 'هاوایی',
 				'hax' => 'هایدا جنوبی',
 				'he' => 'عبری',
 				'hi' => 'هندی',
 				'hif' => 'هندی فیجیایی',
 				'hil' => 'هیلی‌گاینونی',
 				'hit' => 'هیتی',
 				'hmn' => 'همونگ',
 				'ho' => 'موتویی هیری',
 				'hr' => 'کروات',
 				'hsb' => 'صُربی علیا',
 				'ht' => 'هائیتیایی',
 				'hu' => 'مجاری',
 				'hup' => 'هوپا',
 				'hur' => 'هالکوملم',
 				'hy' => 'ارمنی',
 				'hz' => 'هریرویی',
 				'ia' => 'اینترلینگوا',
 				'iba' => 'ایبانی',
 				'ibb' => 'ایبیبیو',
 				'id' => 'اندونزیایی',
 				'ie' => 'اکسیدنتال',
 				'ig' => 'ایگبویی',
 				'ii' => 'یی سیچوان',
 				'ik' => 'اینوپیک',
 				'ikt' => 'اینوکتیتوت غرب کانادا',
 				'ilo' => 'ایلوکویی',
 				'inh' => 'اینگوشی',
 				'io' => 'ایدو',
 				'is' => 'ایسلندی',
 				'it' => 'ایتالیایی',
 				'iu' => 'اینوکتیتوت',
 				'ja' => 'ژاپنی',
 				'jbo' => 'لوجبان',
 				'jgo' => 'نگومبا',
 				'jmc' => 'ماچامه‌ای',
 				'jpr' => 'فارسی یهودی',
 				'jrb' => 'عربی یهودی',
 				'jv' => 'جاوه‌ای',
 				'ka' => 'گرجی',
 				'kaa' => 'قره‌قالپاقی',
 				'kab' => 'قبایلی',
 				'kac' => 'کاچینی',
 				'kaj' => 'جو',
 				'kam' => 'کامبایی',
 				'kaw' => 'کاویایی',
 				'kbd' => 'کاباردینی',
 				'kcg' => 'تیاپی',
 				'kde' => 'ماکونده',
 				'kea' => 'کابووردیانو',
 				'kfo' => 'کورو',
 				'kg' => 'کنگویی',
 				'kgp' => 'کاین گنگ',
 				'kha' => 'خاسیایی',
 				'kho' => 'ختنی',
 				'khq' => 'کوجراچینی',
 				'khw' => 'کهوار',
 				'ki' => 'کیکویویی',
 				'kiu' => 'کرمانجی',
 				'kj' => 'کوانیاما',
 				'kk' => 'قزاقی',
 				'kkj' => 'کاکایی',
 				'kl' => 'گرینلندی',
 				'kln' => 'کالنجین',
 				'km' => 'خمری',
 				'kmb' => 'کیمبوندویی',
 				'kn' => 'کانارا',
 				'ko' => 'کره‌ای',
 				'koi' => 'کومی پرمیاک',
 				'kok' => 'کنکانی',
 				'kpe' => 'کپله‌ای',
 				'kr' => 'کانوریایی',
 				'krc' => 'قره‌چایی‐بالکاری',
 				'krl' => 'کاریلیانی',
 				'kru' => 'کوروخی',
 				'ks' => 'کشمیری',
 				'ksb' => 'شامبالا',
 				'ksf' => 'بافیایی',
 				'ksh' => 'کولش',
 				'ku' => 'کردی',
 				'kum' => 'کومیکی',
 				'kut' => 'کوتنی',
 				'kv' => 'کومیایی',
 				'kw' => 'کورنی',
 				'kwk' => 'کواک والا',
 				'ky' => 'قرقیزی',
 				'la' => 'لاتین',
 				'lad' => 'لادینو',
 				'lag' => 'لانگی',
 				'lah' => 'لاهندا',
 				'lam' => 'لامبا',
 				'lb' => 'لوگزامبورگی',
 				'lez' => 'لزگی',
 				'lg' => 'گاندایی',
 				'li' => 'لیمبورگی',
 				'lil' => 'لیلوئت',
 				'lkt' => 'لاکوتا',
 				'lmo' => 'لومبارد',
 				'ln' => 'لینگالا',
 				'lo' => 'لائوسی',
 				'lol' => 'مونگویی',
 				'lou' => 'کرئول لوئیزیانا',
 				'loz' => 'لوزیایی',
 				'lrc' => 'لری شمالی',
 				'lsm' => 'سامیا',
 				'lt' => 'لیتوانیایی',
 				'lu' => 'لوبایی‐کاتانگا',
 				'lua' => 'لوبایی‐لولوا',
 				'lui' => 'لویسنو',
 				'lun' => 'لوندایی',
 				'luo' => 'لوئویی',
 				'lus' => 'میزو',
 				'luy' => 'لویا',
 				'lv' => 'لتونیایی',
 				'lzh' => 'چینی ادبی',
 				'mad' => 'مادورایی',
 				'mag' => 'ماگاهیایی',
 				'mai' => 'مایدیلی',
 				'mak' => 'ماکاسار',
 				'man' => 'ماندینگویی',
 				'mas' => 'ماسایی',
 				'mdf' => 'مکشایی',
 				'mdr' => 'ماندار',
 				'men' => 'منده‌ای',
 				'mer' => 'مرویی',
 				'mfe' => 'موریسین',
 				'mg' => 'مالاگاسی',
 				'mga' => 'ایرلندی میانه',
 				'mgh' => 'ماکوا متو',
 				'mgo' => 'متایی',
 				'mh' => 'مارشالی',
 				'mi' => 'مائوری',
 				'mic' => 'میکماکی',
 				'min' => 'مینانگ‌کابویی',
 				'mk' => 'مقدونی',
 				'ml' => 'مالایالامی',
 				'mn' => 'مغولی',
 				'mnc' => 'مانچویی',
 				'mni' => 'مانیپوری',
 				'moe' => 'اینوآیموم',
 				'moh' => 'موهاکی',
 				'mos' => 'ماسیایی',
 				'mr' => 'مراتی',
 				'ms' => 'مالایی',
 				'mt' => 'مالتی',
 				'mua' => 'ماندانگی',
 				'mul' => 'چندین زبان',
 				'mus' => 'کریکی',
 				'mwl' => 'میراندی',
 				'mwr' => 'مارواری',
 				'my' => 'برمه‌ای',
 				'myv' => 'ارزیایی',
 				'mzn' => 'مازندرانی',
 				'na' => 'نائورویی',
 				'nap' => 'ناپلی',
 				'naq' => 'نامایی',
 				'nb' => 'نروژی بوک‌مُل',
 				'nd' => 'انده‌بله‌ای شمالی',
 				'nds' => 'آلمانی سفلی',
 				'nds_NL' => 'ساکسونی سفلی',
 				'ne' => 'نپالی',
 				'new' => 'نواریایی',
 				'ng' => 'اندونگایی',
 				'nia' => 'نیاسی',
 				'niu' => 'نیویی',
 				'nl' => 'هلندی',
 				'nl_BE' => 'فلمنگی',
 				'nmg' => 'کوازیو',
 				'nn' => 'نروژی نی‌نُشک',
 				'nnh' => 'نیامبون',
 				'no' => 'نروژی',
 				'nog' => 'نغایی',
 				'non' => 'نرس باستان',
 				'nqo' => 'نکو',
 				'nr' => 'انده‌بله‌ای جنوبی',
 				'nso' => 'سوتویی شمالی',
 				'nus' => 'نویر',
 				'nv' => 'ناواهویی',
 				'nwc' => 'نواریایی کلاسیک',
 				'ny' => 'نیانجایی',
 				'nym' => 'نیام‌وزیایی',
 				'nyn' => 'نیانکوله‌ای',
 				'nyo' => 'نیورویی',
 				'nzi' => 'نزیمایی',
 				'oc' => 'اکسیتان',
 				'oj' => 'اوجیبوایی',
 				'ojb' => 'اوجیبوای شمالی',
 				'ojc' => 'اوجیبوای مرکزی',
 				'ojs' => 'اوجی-کری',
 				'ojw' => 'اوجیبوای غربی',
 				'oka' => 'اوکاناگان',
 				'om' => 'اورومویی',
 				'or' => 'اوریه‌ای',
 				'os' => 'آسی',
 				'osa' => 'اوسیجی',
 				'ota' => 'ترکی عثمانی',
 				'pa' => 'پنجابی',
 				'pag' => 'پانگاسینانی',
 				'pal' => 'پهلوی',
 				'pam' => 'پامپانگایی',
 				'pap' => 'پاپیامنتو',
 				'pau' => 'پالائویی',
 				'pcm' => 'نیم‌زبان نیجریه‌ای',
 				'pdc' => 'آلمانی پنسیلوانیایی',
 				'peo' => 'فارسی باستان',
 				'phn' => 'فنیقی',
 				'pi' => 'پالی',
 				'pis' => 'پی‌جین',
 				'pl' => 'لهستانی',
 				'pon' => 'پانپیی',
 				'pqm' => 'ملیسیت - پاسماکودی',
 				'prg' => 'پروسی',
 				'pro' => 'پرووانسی باستان',
 				'ps' => 'پشتو',
 				'ps@alt=variant' => 'پختو',
 				'pt' => 'پرتغالی',
 				'pt_BR' => 'پرتغالی برزیل',
 				'pt_PT' => 'پرتغالی اروپا',
 				'qu' => 'کچوایی',
 				'quc' => 'کیچه‌',
 				'raj' => 'راجستانی',
 				'rap' => 'راپانویی',
 				'rar' => 'راروتونگایی',
 				'rhg' => 'روهینگیا',
 				'rm' => 'رومانش',
 				'rn' => 'روندیایی',
 				'ro' => 'رومانیایی',
 				'ro_MD' => 'مولداویایی',
 				'rof' => 'رومبویی',
 				'rom' => 'رومانویی',
 				'ru' => 'روسی',
 				'rup' => 'آرومانی',
 				'rw' => 'کینیارواندایی',
 				'rwk' => 'روایی',
 				'sa' => 'سانسکریت',
 				'sad' => 'سانداوه‌ای',
 				'sah' => 'یاقوتی',
 				'sam' => 'آرامی سامری',
 				'saq' => 'سامبورو',
 				'sas' => 'ساساکی',
 				'sat' => 'سانتالی',
 				'sba' => 'انگامبایی',
 				'sbp' => 'سانگویی',
 				'sc' => 'ساردینیایی',
 				'scn' => 'سیسیلی',
 				'sco' => 'اسکاتلندی',
 				'sd' => 'سندی',
 				'sdh' => 'کردی جنوبی',
 				'se' => 'سامی شمالی',
 				'seh' => 'سنا',
 				'sel' => 'سلکوپی',
 				'ses' => 'کویرابورا سنی',
 				'sg' => 'سانگو',
 				'sga' => 'ایرلندی باستان',
 				'sh' => 'صرب و کرواتی',
 				'shi' => 'تاچل‌هیت',
 				'shn' => 'شانی',
 				'shu' => 'عربی چادی',
 				'si' => 'سینهالی',
 				'sid' => 'سیدامویی',
 				'sk' => 'اسلواکی',
 				'sl' => 'اسلوونیایی',
 				'slh' => 'لاشوتسید جنوبی',
 				'sli' => 'سیلزیایی سفلی',
 				'sm' => 'ساموآیی',
 				'sma' => 'سامی جنوبی',
 				'smj' => 'لوله سامی',
 				'smn' => 'ایناری سامی',
 				'sms' => 'اسکولت سامی',
 				'sn' => 'شونایی',
 				'snk' => 'سونینکه‌ای',
 				'so' => 'سومالیایی',
 				'sog' => 'سغدی',
 				'sq' => 'آلبانیایی',
 				'sr' => 'صربی',
 				'srn' => 'زبان اسرانان',
 				'srr' => 'سریری',
 				'ss' => 'سوازیایی',
 				'ssy' => 'ساهو',
 				'st' => 'سوتوی جنوبی',
 				'str' => 'سالیش استریتز',
 				'su' => 'سوندایی',
 				'suk' => 'سوکومایی',
 				'sus' => 'سوسویی',
 				'sux' => 'سومری',
 				'sv' => 'سوئدی',
 				'sw' => 'سواحیلی',
 				'sw_CD' => 'سواحیلی کنگو',
 				'swb' => 'کوموری',
 				'syc' => 'سریانی کلاسیک',
 				'syr' => 'سریانی',
 				'szl' => 'سیلزیایی',
 				'ta' => 'تامیلی',
 				'tce' => 'توچون جنوبی',
 				'te' => 'تلوگویی',
 				'tem' => 'تمنه‌ای',
 				'teo' => 'تسویی',
 				'ter' => 'ترنو',
 				'tet' => 'تتومی',
 				'tg' => 'تاجیکی',
 				'tgx' => 'تاگیش',
 				'th' => 'تایلندی',
 				'tht' => 'تالتان',
 				'ti' => 'تیگرینیایی',
 				'tig' => 'تیگره‌ای',
 				'tiv' => 'تیوی',
 				'tk' => 'ترکمنی',
 				'tl' => 'تاگالوگی',
 				'tlh' => 'کلینگون',
 				'tli' => 'تلین‌گیتی',
 				'tmh' => 'تاماشقی',
 				'tn' => 'تسوانایی',
 				'to' => 'تونگایی',
 				'tog' => 'تونگایی نیاسا',
 				'tok' => 'توکی پونا',
 				'tpi' => 'توک‌پیسینی',
 				'tr' => 'ترکی استانبولی',
 				'tr@alt=secondary' => 'ترکی',
 				'trv' => 'تاروکویی',
 				'ts' => 'تسونگایی',
 				'tsi' => 'تسیم‌شیانی',
 				'tt' => 'تاتاری',
 				'ttm' => 'تاچونی شمالی',
 				'tum' => 'تومبوکایی',
 				'tvl' => 'تووالویی',
 				'tw' => 'توی‌یایی',
 				'twq' => 'تسواکی',
 				'ty' => 'تاهیتیایی',
 				'tyv' => 'تووایی',
 				'tzm' => 'آمازیغی اطلس مرکزی',
 				'udm' => 'اودمورتی',
 				'ug' => 'اویغوری',
 				'uga' => 'اوگاریتی',
 				'uk' => 'اوکراینی',
 				'umb' => 'امبوندویی',
 				'und' => 'زبان نامشخص',
 				'ur' => 'اردو',
 				'uz' => 'ازبکی',
 				'vai' => 'ویایی',
 				've' => 'وندایی',
 				'vi' => 'ویتنامی',
 				'vo' => 'ولاپوک',
 				'vot' => 'وتی',
 				'vun' => 'ونجو',
 				'wa' => 'والونی',
 				'wae' => 'والسر',
 				'wal' => 'والامو',
 				'war' => 'وارایی',
 				'was' => 'واشویی',
 				'wbp' => 'وارلپیری',
 				'wo' => 'ولوفی',
 				'wuu' => 'وو چینی',
 				'xal' => 'قلموقی',
 				'xh' => 'خوسایی',
 				'xog' => 'سوگایی',
 				'yao' => 'یائویی',
 				'yap' => 'یاپی',
 				'yav' => 'یانگبنی',
 				'ybb' => 'یمبایی',
 				'yi' => 'یدی',
 				'yo' => 'یوروبایی',
 				'yrl' => 'نهین گاتو',
 				'yue' => 'کانتونی',
 				'yue@alt=menu' => 'چینی کانتونی',
 				'za' => 'چوانگی',
 				'zap' => 'زاپوتکی',
 				'zen' => 'زناگا',
 				'zgh' => 'آمازیغی معیار مراکش',
 				'zh' => 'چینی',
 				'zh@alt=menu' => 'چینی، ماندارین',
 				'zh_Hans' => 'چینی ساده‌شده',
 				'zh_Hans@alt=long' => 'چینی ماندارین ساده‌شده',
 				'zh_Hant' => 'چینی سنتی',
 				'zh_Hant@alt=long' => 'چینی ماندارین سنتی',
 				'zu' => 'زولویی',
 				'zun' => 'زونیایی',
 				'zxx' => 'بدون محتوای زبانی',
 				'zza' => 'زازایی',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'آدلام',
 			'Aghb' => 'آلبانیایی قفقازی',
 			'Arab' => 'عربی',
 			'Arab@alt=variant' => 'فارسی‐عربی',
 			'Aran' => 'آران',
 			'Armi' => 'آرامی هخامنشی',
 			'Armn' => 'ارمنی',
 			'Avst' => 'اوستایی',
 			'Bali' => 'بالیایی',
 			'Batk' => 'باتاکی',
 			'Beng' => 'بنگالی',
 			'Blis' => 'نمادهای بلیس',
 			'Bopo' => 'بوپوموفو',
 			'Brah' => 'براهمی',
 			'Brai' => 'بریل',
 			'Bugi' => 'بوگیایی',
 			'Buhd' => 'بوهید',
 			'Cakm' => 'چاکمایی',
 			'Cans' => 'زبان‌های سیلابی بومی‌های متحد کانادایی',
 			'Cari' => 'کاری',
 			'Cham' => 'چمی',
 			'Cher' => 'چروکی',
 			'Cirt' => 'کرت',
 			'Copt' => 'قبطی',
 			'Cprt' => 'قبرسی',
 			'Cyrl' => 'سیریلی',
 			'Deva' => 'دوناگری',
 			'Dsrt' => 'دیسرتی',
 			'Egyh' => 'کاهنی مصری',
 			'Egyp' => 'هیروگلیف مصری',
 			'Ethi' => 'اتیوپیایی',
 			'Geok' => 'گرجی خوتسوری',
 			'Geor' => 'گرجی',
 			'Glag' => 'گلاگولیتی',
 			'Goth' => 'گوتی',
 			'Grek' => 'یونانی',
 			'Gujr' => 'گجراتی',
 			'Guru' => 'گورومخی',
 			'Hanb' => 'هان با بوموپوفو',
 			'Hang' => 'هانگول',
 			'Hani' => 'هان',
 			'Hano' => 'هانونویی',
 			'Hans' => 'ساده‌شده',
 			'Hans@alt=stand-alone' => 'هان ساده‌شده',
 			'Hant' => 'سنتی',
 			'Hant@alt=stand-alone' => 'هان سنتی',
 			'Hebr' => 'عبری',
 			'Hira' => 'هیراگانا',
 			'Hluw' => 'هیروگلیف آناتولی',
 			'Hrkt' => 'هجانگاری ژاپنی',
 			'Hung' => 'مجاری باستان',
 			'Inds' => 'ایندوس',
 			'Ital' => 'ایتالی باستان',
 			'Jamo' => 'جامو',
 			'Java' => 'جاوه‌ای',
 			'Jpan' => 'ژاپنی',
 			'Kali' => 'کایالی',
 			'Kana' => 'کاتاکانا',
 			'Khmr' => 'خمری',
 			'Khoj' => 'خواجکی',
 			'Knda' => 'کانارا',
 			'Kore' => 'کره‌ای',
 			'Kthi' => 'کثی',
 			'Lana' => 'لانایی',
 			'Laoo' => 'لائوسی',
 			'Latf' => 'لاتینی فراکتور',
 			'Latg' => 'لاتینی گیلی',
 			'Latn' => 'لاتین',
 			'Limb' => 'لیمبایی',
 			'Lina' => 'خطی الف',
 			'Linb' => 'خطی ب',
 			'Lyci' => 'لسیایی',
 			'Lydi' => 'لدیایی',
 			'Mand' => 'منده‌ای',
 			'Mani' => 'مانوی',
 			'Maya' => 'هیروگلیف مایایی',
 			'Mero' => 'مروییتی',
 			'Mlym' => 'مالایالامی',
 			'Mong' => 'مغولی',
 			'Moon' => 'مونی',
 			'Mtei' => 'مایک میتی',
 			'Mymr' => 'میانمار',
 			'Narb' => 'عربی شمالی باستان',
 			'Nbat' => 'نبطی',
 			'Nkoo' => 'اِن کو',
 			'Ogam' => 'اوگامی',
 			'Olck' => 'اول چیکی',
 			'Orkh' => 'اورخونی',
 			'Orya' => 'اودیه',
 			'Palm' => 'پالمیرایی',
 			'Perm' => 'پرمی باستان',
 			'Phli' => 'پهلوی کتیبه‌ای',
 			'Phlp' => 'پهلوی زبوری',
 			'Phlv' => 'پهلوی کتابی',
 			'Phnx' => 'فنیقی',
 			'Prti' => 'پارتی کتیبه‌ای',
 			'Rjng' => 'رجنگی',
 			'Rohg' => 'حنیفی',
 			'Runr' => 'رونی',
 			'Samr' => 'سامری',
 			'Sara' => 'ساراتی',
 			'Sarb' => 'عربی جنوبی باستان',
 			'Saur' => 'سوراشترایی',
 			'Shaw' => 'شاوی',
 			'Sinh' => 'سینهالی',
 			'Sund' => 'سوندانی',
 			'Sylo' => 'سیلوتی نگاری',
 			'Syrc' => 'سریانی',
 			'Syre' => 'سریانی سطرنجیلی',
 			'Syrj' => 'سریانی غربی',
 			'Syrn' => 'سریانی شرقی',
 			'Tagb' => 'تگبنوایی',
 			'Taml' => 'تامیلی',
 			'Telu' => 'تلوگویی',
 			'Teng' => 'تنگوار',
 			'Tfng' => 'تیفیناغی',
 			'Tglg' => 'تاگالوگی',
 			'Thaa' => 'تانا',
 			'Thai' => 'تایلندی',
 			'Tibt' => 'تبتی',
 			'Ugar' => 'اوگاریتی',
 			'Vaii' => 'ویایی',
 			'Visp' => 'گفتار قابل مشاهده',
 			'Xpeo' => 'فارسی باستان',
 			'Xsux' => 'میخی سومری‐اکدی',
 			'Yiii' => 'یی',
 			'Zinh' => 'موروثی',
 			'Zmth' => 'علائم ریاضی',
 			'Zsye' => 'اموجی',
 			'Zsym' => 'علائم',
 			'Zxxx' => 'نانوشته',
 			'Zyyy' => 'مشترک',
 			'Zzzz' => 'خط نامشخص',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'جهان',
 			'002' => 'افریقا',
 			'003' => 'امریکای شمالی',
 			'005' => 'امریکای جنوبی',
 			'009' => 'اقیانوسیه',
 			'011' => 'غرب افریقا',
 			'013' => 'امریکای مرکزی',
 			'014' => 'شرق افریقا',
 			'015' => 'شمال افریقا',
 			'017' => 'مرکز افریقا',
 			'018' => 'جنوب افریقا',
 			'019' => 'امریکا',
 			'021' => 'شمال امریکا',
 			'029' => 'کارائیب',
 			'030' => 'شرق آسیا',
 			'034' => 'جنوب آسیا',
 			'035' => 'جنوب شرق آسیا',
 			'039' => 'جنوب اروپا',
 			'053' => 'استرالزی',
 			'054' => 'ملانزی',
 			'057' => 'ناحیهٔ میکرونزی',
 			'061' => 'پلی‌نزی',
 			'142' => 'آسیا',
 			'143' => 'آسیای مرکزی',
 			'145' => 'غرب آسیا',
 			'150' => 'اروپا',
 			'151' => 'شرق اروپا',
 			'154' => 'شمال اروپا',
 			'155' => 'غرب اروپا',
 			'202' => 'افریقای جنوب صحرا',
 			'419' => 'امریکای لاتین',
 			'AC' => 'جزایر آسنسیون',
 			'AD' => 'آندورا',
 			'AE' => 'امارات متحدهٔ عربی',
 			'AF' => 'افغانستان',
 			'AG' => 'آنتیگوا و باربودا',
 			'AI' => 'آنگویلا',
 			'AL' => 'آلبانی',
 			'AM' => 'ارمنستان',
 			'AO' => 'آنگولا',
 			'AQ' => 'جنوبگان',
 			'AR' => 'آرژانتین',
 			'AS' => 'ساموآی امریکا',
 			'AT' => 'اتریش',
 			'AU' => 'استرالیا',
 			'AW' => 'آروبا',
 			'AX' => 'جزایر آلاند',
 			'AZ' => 'جمهوری آذربایجان',
 			'BA' => 'بوسنی و هرزگوین',
 			'BB' => 'باربادوس',
 			'BD' => 'بنگلادش',
 			'BE' => 'بلژیک',
 			'BF' => 'بورکینافاسو',
 			'BG' => 'بلغارستان',
 			'BH' => 'بحرین',
 			'BI' => 'بوروندی',
 			'BJ' => 'بنین',
 			'BL' => 'سن بارتلمی',
 			'BM' => 'برمودا',
 			'BN' => 'برونئی',
 			'BO' => 'بولیوی',
 			'BQ' => 'جزایر کارائیب هلند',
 			'BR' => 'برزیل',
 			'BS' => 'باهاما',
 			'BT' => 'بوتان',
 			'BV' => 'جزیرهٔ بووه',
 			'BW' => 'بوتسوانا',
 			'BY' => 'بلاروس',
 			'BZ' => 'بلیز',
 			'CA' => 'کانادا',
 			'CC' => 'جزایر کوکوس',
 			'CD' => 'کنگو - کینشاسا',
 			'CD@alt=variant' => 'کنگو (جمهوری دموکراتیک)',
 			'CF' => 'جمهوری افریقای مرکزی',
 			'CG' => 'کنگو - برازویل',
 			'CG@alt=variant' => 'کنگو (جمهوری)',
 			'CH' => 'سوئیس',
 			'CI' => 'ساحل عاج',
 			'CI@alt=variant' => 'ساحل‌عاج',
 			'CK' => 'جزایر کوک',
 			'CL' => 'شیلی',
 			'CM' => 'کامرون',
 			'CN' => 'چین',
 			'CO' => 'کلمبیا',
 			'CP' => 'جزایر کلیپرتون',
 			'CR' => 'کاستاریکا',
 			'CU' => 'کوبا',
 			'CV' => 'کیپ‌ورد',
 			'CW' => 'کوراسائو',
 			'CX' => 'جزیرهٔ کریسمس',
 			'CY' => 'قبرس',
 			'CZ' => 'چک',
 			'CZ@alt=variant' => 'جمهوری چک',
 			'DE' => 'آلمان',
 			'DG' => 'دیه‌گو گارسیا',
 			'DJ' => 'جیبوتی',
 			'DK' => 'دانمارک',
 			'DM' => 'دومینیکا',
 			'DO' => 'جمهوری دومینیکن',
 			'DZ' => 'الجزایر',
 			'EA' => 'سبته و ملیله',
 			'EC' => 'اکوادور',
 			'EE' => 'استونی',
 			'EG' => 'مصر',
 			'EH' => 'صحرای غربی',
 			'ER' => 'اریتره',
 			'ES' => 'اسپانیا',
 			'ET' => 'اتیوپی',
 			'EU' => 'اتحادیهٔ اروپا',
 			'EZ' => 'منطقهٔ یورو',
 			'FI' => 'فنلاند',
 			'FJ' => 'فیجی',
 			'FK' => 'جزایر فالکلند',
 			'FK@alt=variant' => 'جزایر فالکلند (ایسلاس مالویناس)',
 			'FM' => 'میکرونزی',
 			'FO' => 'جزایر فارو',
 			'FR' => 'فرانسه',
 			'GA' => 'گابن',
 			'GB' => 'بریتانیا',
 			'GD' => 'گرنادا',
 			'GE' => 'گرجستان',
 			'GF' => 'گویان فرانسه',
 			'GG' => 'گرنزی',
 			'GH' => 'غنا',
 			'GI' => 'جبل‌الطارق',
 			'GL' => 'گرینلند',
 			'GM' => 'گامبیا',
 			'GN' => 'گینه',
 			'GP' => 'گوادلوپ',
 			'GQ' => 'گینهٔ استوایی',
 			'GR' => 'یونان',
 			'GS' => 'جورجیای جنوبی و جزایر ساندویچ جنوبی',
 			'GT' => 'گواتمالا',
 			'GU' => 'گوام',
 			'GW' => 'گینهٔ بیسائو',
 			'GY' => 'گویان',
 			'HK' => 'هنگ‌کنگ، منطقهٔ ویژهٔ اداری چین',
 			'HK@alt=short' => 'هنگ‌کنگ',
 			'HM' => 'هرد و جزایر مک‌دونالد',
 			'HN' => 'هندوراس',
 			'HR' => 'کرواسی',
 			'HT' => 'هائیتی',
 			'HU' => 'مجارستان',
 			'IC' => 'جزایر قناری',
 			'ID' => 'اندونزی',
 			'IE' => 'ایرلند',
 			'IL' => 'اسرائیل',
 			'IM' => 'جزیرهٔ من',
 			'IN' => 'هند',
 			'IO' => 'قلمرو بریتانیا در اقیانوس هند',
 			'IO@alt=chagos' => 'مجمع‌الجزایر چاگوس',
 			'IQ' => 'عراق',
 			'IR' => 'ایران',
 			'IS' => 'ایسلند',
 			'IT' => 'ایتالیا',
 			'JE' => 'جرزی',
 			'JM' => 'جامائیکا',
 			'JO' => 'اردن',
 			'JP' => 'ژاپن',
 			'KE' => 'کنیا',
 			'KG' => 'قرقیزستان',
 			'KH' => 'کامبوج',
 			'KI' => 'کیریباتی',
 			'KM' => 'کومور',
 			'KN' => 'سنت کیتس و نویس',
 			'KP' => 'کرهٔ شمالی',
 			'KR' => 'کرهٔ جنوبی',
 			'KW' => 'کویت',
 			'KY' => 'جزایر کِیمن',
 			'KZ' => 'قزاقستان',
 			'LA' => 'لائوس',
 			'LB' => 'لبنان',
 			'LC' => 'سنت لوسیا',
 			'LI' => 'لیختن‌اشتاین',
 			'LK' => 'سری‌لانکا',
 			'LR' => 'لیبریا',
 			'LS' => 'لسوتو',
 			'LT' => 'لیتوانی',
 			'LU' => 'لوکزامبورگ',
 			'LV' => 'لتونی',
 			'LY' => 'لیبی',
 			'MA' => 'مراکش',
 			'MC' => 'موناکو',
 			'MD' => 'مولداوی',
 			'ME' => 'مونته‌نگرو',
 			'MF' => 'سنت مارتین',
 			'MG' => 'ماداگاسکار',
 			'MH' => 'جزایر مارشال',
 			'MK' => 'مقدونیهٔ شمالی',
 			'ML' => 'مالی',
 			'MM' => 'میانمار (برمه)',
 			'MN' => 'مغولستان',
 			'MO' => 'ماکائو، منطقهٔ ویژهٔ اداری چین',
 			'MO@alt=short' => 'ماکائو',
 			'MP' => 'جزایر ماریانای شمالی',
 			'MQ' => 'مارتینیک',
 			'MR' => 'موریتانی',
 			'MS' => 'مونت‌سرات',
 			'MT' => 'مالت',
 			'MU' => 'موریس',
 			'MV' => 'مالدیو',
 			'MW' => 'مالاوی',
 			'MX' => 'مکزیک',
 			'MY' => 'مالزی',
 			'MZ' => 'موزامبیک',
 			'NA' => 'نامیبیا',
 			'NC' => 'کالدونیای جدید',
 			'NE' => 'نیجر',
 			'NF' => 'جزیرهٔ نورفولک',
 			'NG' => 'نیجریه',
 			'NI' => 'نیکاراگوئه',
 			'NL' => 'هلند',
 			'NO' => 'نروژ',
 			'NP' => 'نپال',
 			'NR' => 'نائورو',
 			'NU' => 'نیوئه',
 			'NZ' => 'نیوزیلند',
 			'NZ@alt=variant' => 'آتروا نیوزیلند',
 			'OM' => 'عمان',
 			'PA' => 'پاناما',
 			'PE' => 'پرو',
 			'PF' => 'پلی‌نزی فرانسه',
 			'PG' => 'پاپوا گینهٔ نو',
 			'PH' => 'فیلیپین',
 			'PK' => 'پاکستان',
 			'PL' => 'لهستان',
 			'PM' => 'سن پیر و میکلن',
 			'PN' => 'جزایر پیت‌کرن',
 			'PR' => 'پورتوریکو',
 			'PS' => 'سرزمین‌های فلسطینی',
 			'PS@alt=short' => 'فلسطین',
 			'PT' => 'پرتغال',
 			'PW' => 'پالائو',
 			'PY' => 'پاراگوئه',
 			'QA' => 'قطر',
 			'QO' => 'بخش‌های دورافتادهٔ اقیانوسیه',
 			'RE' => 'رئونیون',
 			'RO' => 'رومانی',
 			'RS' => 'صربستان',
 			'RU' => 'روسیه',
 			'RW' => 'رواندا',
 			'SA' => 'عربستان سعودی',
 			'SA@alt=short' => 'عربستان',
 			'SB' => 'جزایر سلیمان',
 			'SC' => 'سیشل',
 			'SD' => 'سودان',
 			'SE' => 'سوئد',
 			'SG' => 'سنگاپور',
 			'SH' => 'سنت هلن',
 			'SI' => 'اسلوونی',
 			'SJ' => 'سوالبارد و یان ماین',
 			'SK' => 'اسلواکی',
 			'SL' => 'سیرالئون',
 			'SM' => 'سان‌مارینو',
 			'SN' => 'سنگال',
 			'SO' => 'سومالی',
 			'SR' => 'سورینام',
 			'SS' => 'سودان جنوبی',
 			'ST' => 'سائوتومه و پرینسیپ',
 			'SV' => 'السالوادور',
 			'SX' => 'سنت مارتن',
 			'SY' => 'سوریه',
 			'SZ' => 'اسواتینی',
 			'SZ@alt=variant' => 'سوازیلند',
 			'TA' => 'تریستان دا کونا',
 			'TC' => 'جزایر تورکس و کایکوس',
 			'TD' => 'چاد',
 			'TF' => 'سرزمین‌های جنوبی فرانسه',
 			'TG' => 'توگو',
 			'TH' => 'تایلند',
 			'TJ' => 'تاجیکستان',
 			'TK' => 'توکلائو',
 			'TL' => 'تیمور-لسته',
 			'TL@alt=variant' => 'تیمور شرقی',
 			'TM' => 'ترکمنستان',
 			'TN' => 'تونس',
 			'TO' => 'تونگا',
 			'TR' => 'ترکیه',
 			'TT' => 'ترینیداد و توباگو',
 			'TV' => 'تووالو',
 			'TW' => 'تایوان',
 			'TZ' => 'تانزانیا',
 			'UA' => 'اوکراین',
 			'UG' => 'اوگاندا',
 			'UM' => 'جزایر دورافتادهٔ ایالات متحده',
 			'UN' => 'سازمان ملل متحد',
 			'UN@alt=short' => 'سازمان ملل',
 			'US' => 'ایالات متحده',
 			'UY' => 'اروگوئه',
 			'UZ' => 'ازبکستان',
 			'VA' => 'واتیکان',
 			'VC' => 'سنت وینسنت و گرنادین',
 			'VE' => 'ونزوئلا',
 			'VG' => 'جزایر ویرجین بریتانیا',
 			'VI' => 'جزایر ویرجین ایالات متحده',
 			'VN' => 'ویتنام',
 			'VU' => 'وانواتو',
 			'WF' => 'والیس و فوتونا',
 			'WS' => 'ساموآ',
 			'XA' => 'انگلیسی با لهجه خارجی',
 			'XB' => 'مجازی - دوجهته',
 			'XK' => 'کوزوو',
 			'YE' => 'یمن',
 			'YT' => 'مایوت',
 			'ZA' => 'افریقای جنوبی',
 			'ZM' => 'زامبیا',
 			'ZW' => 'زیمبابوه',
 			'ZZ' => 'ناحیهٔ نامشخص',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'1901' => 'رسم‌الخط سنتی آلمانی',
 			'1996' => 'رسم‌الخط آلمانی ۱۹۹۶ میلادی',
 			'AREVELA' => 'ارمنی شرقی',
 			'AREVMDA' => 'ارمنی غربی',
 			'COLB1945' => 'کنوانسیون رسم‌الخط پرتغال و برزیل در ۱۹۴۵',
 			'FONIPA' => 'فونتیک IPA',
 			'FONUPA' => 'فونتیک UPA',
 			'KSCOR' => 'رسم‌الخط استاندارد',
 			'OXENDICT' => 'املای فرهنگ انگلیسی آکسفورد',
 			'POSIX' => 'کامپیوتری',
 			'REVISED' => 'رسم‌الخط تجدیدنظرشده',
 			'ROZAJ' => 'روژان',
 			'SAAHO' => 'ساهویی',
 			'SCOTLAND' => 'انگلیسی معیار اسکاتلند',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'تقویم',
 			'cf' => 'قالب واحد پول',
 			'colalternate' => 'نادیده گرفتن مرتب‌سازی نمادها',
 			'colbackwards' => 'مرتب‌سازی معکوس براساس آکسان',
 			'colcasefirst' => 'ترتیب بر اساس حروف کوچک/بزرگ',
 			'colcaselevel' => 'مرتب‌سازی حساس به اندازه حروف',
 			'collation' => 'ترتیب',
 			'colnormalization' => 'مرتب‌سازی معمولی',
 			'colnumeric' => 'مرتب‌سازی عددی',
 			'colstrength' => 'قدرت مرتب‌سازی',
 			'currency' => 'واحد پول',
 			'hc' => 'دور ساعت (۱۲ در مقابل ۲۴)',
 			'lb' => 'شیوهٔ سطرشکنی',
 			'ms' => 'دستگاه اندازه‌گیری',
 			'numbers' => 'اعداد',
 			'timezone' => 'منطقهٔ زمانی',
 			'va' => 'متغیر محلی',
 			'x' => 'استفادهٔ خصوصی',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{تقویم بودایی},
 				'chinese' => q{تقویم چینی},
 				'coptic' => q{تقویم قبطی},
 				'dangi' => q{تقویم دانگی},
 				'ethiopic' => q{تقویم اتیوپیایی},
 				'ethiopic-amete-alem' => q{تقویم اتیوپیایی عامت عالم},
 				'gregorian' => q{تقویم میلادی},
 				'hebrew' => q{تقویم عبری},
 				'indian' => q{تقویم ملی هند},
 				'islamic' => q{تقویم هجری قمری},
 				'islamic-civil' => q{تقویم هجری قمری جدولی مدنی},
 				'islamic-rgsa' => q{قویم هجری قمری هلالی عربستان سعودی},
 				'islamic-tbla' => q{تقویم هجری قمری جدولی نجومی},
 				'islamic-umalqura' => q{تقویم هجری قمری ام‌القری},
 				'iso8601' => q{تقویم ایزو ۸۶۰۱},
 				'japanese' => q{تقویم ژاپنی},
 				'persian' => q{تقویم هجری شمسی},
 				'roc' => q{تقویم جمهوری چین (تایوان)},
 			},
 			'cf' => {
 				'account' => q{قالب حسابداری واحد پول},
 				'standard' => q{قالب استاندارد واحد پول},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{مرتب‌سازی نمادها},
 				'shifted' => q{مرتب‌سازی با نادیده گرفتن نمادها},
 			},
 			'colbackwards' => {
 				'no' => q{مرتب‌سازی آکسان‌ها به صورت معمولی},
 				'yes' => q{مرتب‌سازی معکوس براساس آکسان},
 			},
 			'colcasefirst' => {
 				'lower' => q{ابتدا مرتب‌سازی حروف کوچک},
 				'no' => q{مرتب‌سازی به ترتیب معمولی بزرگ و کوچکی حروف},
 				'upper' => q{مرتب‌سازی بر اساس حرف بزرگ در ابتدا},
 			},
 			'colcaselevel' => {
 				'no' => q{مرتب‌سازی بدون توجه به کوچک و بزرگی حروف},
 				'yes' => q{مرتب‌سازی با حساسیت به اندازه حروف},
 			},
 			'collation' => {
 				'big5han' => q{ترتیب چینی سنتی - Big5},
 				'compat' => q{ترتیب پیشین، برای سازگاری},
 				'dictionary' => q{ترتیب فرهنگ لغت},
 				'ducet' => q{ترتیب پیش‌فرض یونی‌کد},
 				'emoji' => q{ترتیب ایموجی},
 				'eor' => q{قوانین ترتیب اروپایی},
 				'gb2312han' => q{ترتیب چینی ساده‌شده - GB2312},
 				'phonebook' => q{ترتیب دفتر تلفن},
 				'phonetic' => q{مرتب کردن بر اساس آوایی},
 				'pinyin' => q{ترتیب پین‌یین},
 				'reformed' => q{ترتیب اصلاح‌شده},
 				'search' => q{جستجوی عمومی},
 				'searchjl' => q{جستجو با صامت اول هانگول},
 				'standard' => q{ترتیب استاندارد},
 				'stroke' => q{ترتیب حرکتی},
 				'traditional' => q{ترتیب سنتی},
 				'unihan' => q{ترتیب رادیکالی-حرکتی},
 				'zhuyin' => q{ترتیب ژویین},
 			},
 			'colnormalization' => {
 				'no' => q{مرتب‌سازی بدون عادی‌سازی},
 				'yes' => q{مرتب‌سازی یونی‌کد نرمال‌شده},
 			},
 			'colnumeric' => {
 				'no' => q{مرتب‌سازی ارقام بصورت مجزا},
 				'yes' => q{مرتب‌سازی شماره‌ها با سیستم عددی},
 			},
 			'colstrength' => {
 				'identical' => q{مرتب‌سازی همه},
 				'primary' => q{مرتب‌سازی فقط حروف پایه},
 				'quaternary' => q{مرتب‌سازی بر اساس آکسان/اندازه حروف/عرض/کانا},
 				'secondary' => q{مرتب‌سازی آکسان‌ها},
 				'tertiary' => q{مرتب‌سازی بر اساس آکسان/اندازه حرف/عرض},
 			},
 			'd0' => {
 				'fwidth' => q{تمام‌عرض},
 				'hwidth' => q{نیم‌عرض},
 				'npinyin' => q{سیستم اعداد},
 			},
 			'hc' => {
 				'h11' => q{سیستم ۱۲ ساعته (۰ تا ۱۱)},
 				'h12' => q{سیستم ۱۲ ساعته (۱ تا ۱۲)},
 				'h23' => q{سیستم ۲۴ ساعته (۰ تا ۲۳)},
 				'h24' => q{سیستم ۲۴ ساعته (۱ تا ۲۴)},
 			},
 			'lb' => {
 				'loose' => q{شیوهٔ سطرشکنی سهل‌گیرانه},
 				'normal' => q{شیوهٔ سطرشکنی عادی},
 				'strict' => q{شیوهٔ سطرشکنی سخت‌گیرانه},
 			},
 			'm0' => {
 				'bgn' => q{ترانویسی انجمن نام‌های جغرافیایی ایالات متحده},
 				'ungegn' => q{ترانویسی گروه نام‌های جغرافیایی سازمان ملل},
 			},
 			'ms' => {
 				'metric' => q{دستگاه متریک},
 				'uksystem' => q{سیستم اندازه‌گیری انگلیسی},
 				'ussystem' => q{سیستم اندازه‌گیری امریکایی},
 			},
 			'numbers' => {
 				'arab' => q{ارقام عربی},
 				'arabext' => q{ارقام فارسی},
 				'armn' => q{اعداد ارمنی},
 				'armnlow' => q{اعداد ارمنی با حروف کوچک},
 				'bali' => q{ارقام بالیایی},
 				'beng' => q{ارقام بنگالی},
 				'brah' => q{ارقام برهمایی},
 				'cakm' => q{ارقام چاکما},
 				'cyrl' => q{ارقام سیریلیک},
 				'deva' => q{ارقام دوناگری},
 				'ethi' => q{اعداد اتیوپیایی},
 				'finance' => q{سیستم عددی مالی},
 				'fullwide' => q{ارقام تمام‌عرض},
 				'geor' => q{اعداد گرجی},
 				'grek' => q{اعداد یونانی},
 				'greklow' => q{اعداد یونانی با حروف کوچک},
 				'gujr' => q{ارقام گجراتی},
 				'guru' => q{ارقام گورومخی},
 				'hanidec' => q{اعداد دهدهی چینی},
 				'hans' => q{اعداد چینی ساده‌شده},
 				'hansfin' => q{اعداد مالی چینی ساده‌شده},
 				'hant' => q{اعداد چینی سنتی},
 				'hantfin' => q{اعداد مالی چینی سنتی},
 				'hebr' => q{اعداد عبری},
 				'java' => q{ارقام جاوه‌ای},
 				'jpan' => q{اعداد ژاپنی},
 				'jpanfin' => q{اعداد مالی ژاپنی},
 				'khmr' => q{ارقام خمری},
 				'knda' => q{ارقام کاناده‌ای},
 				'laoo' => q{ارقام لائوسی},
 				'latn' => q{ارقام غربی},
 				'mathbold' => q{ارقام ریاضی سیاه},
 				'mathsanb' => q{ارقام ریاضی سیاه بی‌سریف},
 				'mathsans' => q{ارقام ریاضی بی‌سریف},
 				'mlym' => q{ارقام مالایالامی},
 				'mong' => q{ارقام مغولی},
 				'mtei' => q{ارقام میتی مایک},
 				'mymr' => q{ارقام میانماری},
 				'mymrshan' => q{ارقام شان میانماری},
 				'native' => q{ارقام بومی},
 				'olck' => q{ارقام اول چیکی},
 				'orya' => q{ارقام اودیه},
 				'roman' => q{اعداد رومی},
 				'romanlow' => q{اعداد رومی با حروف کوچک},
 				'taml' => q{اعداد سنتی تامیلی},
 				'tamldec' => q{ارقام تامیلی},
 				'telu' => q{ارقام تلوگویی},
 				'thai' => q{ارقام تایلندی},
 				'tibt' => q{ارقام تبتی},
 				'traditional' => q{سیستم اعداد سنتی},
 				'vaii' => q{ارقام وایی},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{متریک},
 			'UK' => q{بریتانیایی},
 			'US' => q{امریکایی},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'زبان: {0}',
 			'script' => 'خط: {0}',
 			'region' => 'ناحیه: {0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { return {
			lines => '',
			characters => 'right-to-left',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[ـ‌‍‎‏ َ ِ ُ ْ ٖ ٰ إ ك ىي]},
			index => ['آ', 'ا', 'ب', 'پ', 'ت', 'ث', 'ج', 'چ', 'ح', 'خ', 'د', 'ذ', 'ر', 'ز', 'ژ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'گ', 'ل', 'م', 'ن', 'و', 'ه', 'ی'],
			main => qr{[ً ٍ ٌ ّ ٔ آ ا ءأؤئ ب پ ت ث ج چ ح خ د ذ ر ز ژ س ش ص ض ط ظ ع غ ف ق ک گ ل م ن و هة ی]},
			numbers => qr{[‎ , ٫ ٬ . % ٪ ‰ ؉ + − 0۰ 1۱ 2۲ 3۳ 4۴ 5۵ 6۶ 7۷ 8۸ 9۹]},
			punctuation => qr{[\- ‐‑ ، ٫ ٬ ؛ \: ! ؟ . … ‹ › « » ( ) \[ \] * / \\]},
		};
	},
EOT
: sub {
		return { index => ['آ', 'ا', 'ب', 'پ', 'ت', 'ث', 'ج', 'چ', 'ح', 'خ', 'د', 'ذ', 'ر', 'ز', 'ژ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'گ', 'ل', 'م', 'ن', 'و', 'ه', 'ی'], };
},
);


has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{؟},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{«},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{»},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‹},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{›},
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(جهت اصلی),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(جهت اصلی),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(سانتی‌{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(سانتی‌{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(میلی‌{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(میلی‌{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'one' => q({0} جی),
						'other' => q({0} جی),
					},
					# Core Unit Identifier
					'g-force' => {
						'one' => q({0} جی),
						'other' => q({0} جی),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(متر بر مجذور ثانیه),
						'one' => q({0} متر بر مجذور ثانیه),
						'other' => q({0} متر بر مجذور ثانیه),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(متر بر مجذور ثانیه),
						'one' => q({0} متر بر مجذور ثانیه),
						'other' => q({0} متر بر مجذور ثانیه),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'one' => q({0} دقیقهٔ قوسی),
						'other' => q({0} دقیقهٔ قوسی),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'one' => q({0} دقیقهٔ قوسی),
						'other' => q({0} دقیقهٔ قوسی),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'one' => q({0} ثانیهٔ قوسی),
						'other' => q({0} ثانیهٔ قوسی),
					},
					# Core Unit Identifier
					'arc-second' => {
						'one' => q({0} ثانیهٔ قوسی),
						'other' => q({0} ثانیهٔ قوسی),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'one' => q({0} هکتار),
						'other' => q({0} هکتار),
					},
					# Core Unit Identifier
					'hectare' => {
						'one' => q({0} هکتار),
						'other' => q({0} هکتار),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(سانتی‌متر مربع),
						'one' => q({0} سانتی‌متر مربع),
						'other' => q({0} سانتی‌متر مربع),
						'per' => q({0} در سانتی‌متر مربع),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(سانتی‌متر مربع),
						'one' => q({0} سانتی‌متر مربع),
						'other' => q({0} سانتی‌متر مربع),
						'per' => q({0} در سانتی‌متر مربع),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'per' => q({0} در اینچ مربع),
					},
					# Core Unit Identifier
					'square-inch' => {
						'per' => q({0} در اینچ مربع),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'one' => q({0} کیلومتر مربع),
						'other' => q({0} کیلومتر مربع),
						'per' => q({0} در کیلومتر مربع),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'one' => q({0} کیلومتر مربع),
						'other' => q({0} کیلومتر مربع),
						'per' => q({0} در کیلومتر مربع),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'one' => q({0} متر مربع),
						'other' => q({0} متر مربع),
						'per' => q({0} در متر مربع),
					},
					# Core Unit Identifier
					'square-meter' => {
						'one' => q({0} متر مربع),
						'other' => q({0} متر مربع),
						'per' => q({0} در متر مربع),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'per' => q({0} در مایل مربع),
					},
					# Core Unit Identifier
					'square-mile' => {
						'per' => q({0} در مایل مربع),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'one' => q({0} میلی‌گرم در دسی‌لیتر),
						'other' => q({0} میلی‌گرم در دسی‌لیتر),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'one' => q({0} میلی‌گرم در دسی‌لیتر),
						'other' => q({0} میلی‌گرم در دسی‌لیتر),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(میلی‌مول در لیتر),
						'one' => q({0} میلی‌مول در لیتر),
						'other' => q({0} میلی‌مول در لیتر),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(میلی‌مول در لیتر),
						'one' => q({0} میلی‌مول در لیتر),
						'other' => q({0} میلی‌مول در لیتر),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'one' => q({0} درصد),
						'other' => q({0} درصد),
					},
					# Core Unit Identifier
					'percent' => {
						'one' => q({0} درصد),
						'other' => q({0} درصد),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'one' => q({0} هزارم),
						'other' => q({0} هزارم),
					},
					# Core Unit Identifier
					'permille' => {
						'one' => q({0} هزارم),
						'other' => q({0} هزارم),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(بخش در میلیون),
						'one' => q({0} بخش در میلیون),
						'other' => q({0} بخش در میلیون),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(بخش در میلیون),
						'one' => q({0} بخش در میلیون),
						'other' => q({0} بخش در میلیون),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'one' => q({0} ده‌هزارم),
						'other' => q({0} ده‌هزارم),
					},
					# Core Unit Identifier
					'permyriad' => {
						'one' => q({0} ده‌هزارم),
						'other' => q({0} ده‌هزارم),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(لیتر در ۱۰۰ کیلومتر),
						'one' => q({0} لیتر در ۱۰۰ کیلومتر),
						'other' => q({0} لیتر در ۱۰۰ کیلومتر),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(لیتر در ۱۰۰ کیلومتر),
						'one' => q({0} لیتر در ۱۰۰ کیلومتر),
						'other' => q({0} لیتر در ۱۰۰ کیلومتر),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(لیتر در کیلومتر),
						'one' => q({0} لیتر در کیلومتر),
						'other' => q({0} لیتر در کیلومتر),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(لیتر در کیلومتر),
						'one' => q({0} لیتر در کیلومتر),
						'other' => q({0} لیتر در کیلومتر),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(مایل در گالن),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(مایل در گالن),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(مایل در امپریال گالن),
						'one' => q({0} مایل در امپریال گالن),
						'other' => q({0} مایل در امپریال گالن),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(مایل در امپریال گالن),
						'one' => q({0} مایل در امپریال گالن),
						'other' => q({0} مایل در امپریال گالن),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'one' => q({0} گیگابیت),
						'other' => q({0} گیگابیت),
					},
					# Core Unit Identifier
					'gigabit' => {
						'one' => q({0} گیگابیت),
						'other' => q({0} گیگابیت),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(گیگابایت),
						'one' => q({0} گیگابایت),
						'other' => q({0} گیگابایت),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(گیگابایت),
						'one' => q({0} گیگابایت),
						'other' => q({0} گیگابایت),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'one' => q({0} کیلوبیت),
						'other' => q({0} کیلوبیت),
					},
					# Core Unit Identifier
					'kilobit' => {
						'one' => q({0} کیلوبیت),
						'other' => q({0} کیلوبیت),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'one' => q({0} کیلوبایت),
						'other' => q({0} کیلوبایت),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'one' => q({0} کیلوبایت),
						'other' => q({0} کیلوبایت),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'one' => q({0} مگابیت),
						'other' => q({0} مگابیت),
					},
					# Core Unit Identifier
					'megabit' => {
						'one' => q({0} مگابیت),
						'other' => q({0} مگابیت),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(مگابایت),
						'one' => q({0} مگابایت),
						'other' => q({0} مگابایت),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(مگابایت),
						'one' => q({0} مگابایت),
						'other' => q({0} مگابایت),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'one' => q({0} پتابایت),
						'other' => q({0} پتابایت),
					},
					# Core Unit Identifier
					'petabyte' => {
						'one' => q({0} پتابایت),
						'other' => q({0} پتابایت),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'one' => q({0} ترابیت),
						'other' => q({0} ترابیت),
					},
					# Core Unit Identifier
					'terabit' => {
						'one' => q({0} ترابیت),
						'other' => q({0} ترابیت),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'one' => q({0} ترابایت),
						'other' => q({0} ترابایت),
					},
					# Core Unit Identifier
					'terabyte' => {
						'one' => q({0} ترابایت),
						'other' => q({0} ترابایت),
					},
					# Long Unit Identifier
					'duration-day' => {
						'per' => q({0} در روز),
					},
					# Core Unit Identifier
					'day' => {
						'per' => q({0} در روز),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'one' => q({0} میکروثانیه),
						'other' => q({0} میکروثانیه),
					},
					# Core Unit Identifier
					'microsecond' => {
						'one' => q({0} میکروثانیه),
						'other' => q({0} میکروثانیه),
					},
					# Long Unit Identifier
					'duration-month' => {
						'per' => q({0} در ماه),
					},
					# Core Unit Identifier
					'month' => {
						'per' => q({0} در ماه),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'one' => q({0} سه‌ماهه),
						'other' => q({0} سه‌ماهه),
						'per' => q({0} در سه‌ماه),
					},
					# Core Unit Identifier
					'quarter' => {
						'one' => q({0} سه‌ماهه),
						'other' => q({0} سه‌ماهه),
						'per' => q({0} در سه‌ماه),
					},
					# Long Unit Identifier
					'duration-week' => {
						'per' => q({0} در هفته),
					},
					# Core Unit Identifier
					'week' => {
						'per' => q({0} در هفته),
					},
					# Long Unit Identifier
					'duration-year' => {
						'per' => q({0} در سال),
					},
					# Core Unit Identifier
					'year' => {
						'per' => q({0} در سال),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(الکترون ولت),
						'one' => q({0} الکترون‌ولت),
						'other' => q({0} الکترون‌ولت),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(الکترون ولت),
						'one' => q({0} الکترون‌ولت),
						'other' => q({0} الکترون‌ولت),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(کیلوکالری),
						'one' => q({0} کیلوکالری),
						'other' => q({0} کیلوکالری),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(کیلوکالری),
						'one' => q({0} کیلوکالری),
						'other' => q({0} کیلوکالری),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(کیلوژول),
						'one' => q({0} کیلوژول),
						'other' => q({0} کیلوژول),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(کیلوژول),
						'one' => q({0} کیلوژول),
						'other' => q({0} کیلوژول),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(کیلووات‌ساعت),
						'one' => q({0} کیلووات‌ساعت),
						'other' => q({0} کیلووات‌ساعت),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(کیلووات‌ساعت),
						'one' => q({0} کیلووات‌ساعت),
						'other' => q({0} کیلووات‌ساعت),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(کیلووات-ساعت در ۱۰۰ کیلومتر),
						'one' => q({0} کیلووات-ساعت در ۱۰۰ کیلومتر),
						'other' => q({0} کیلووات-ساعت در ۱۰۰ کیلومتر),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(کیلووات-ساعت در ۱۰۰ کیلومتر),
						'one' => q({0} کیلووات-ساعت در ۱۰۰ کیلومتر),
						'other' => q({0} کیلووات-ساعت در ۱۰۰ کیلومتر),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(کیلوهرتز),
						'one' => q({0} کیلوهرتز),
						'other' => q({0} کیلوهرتز),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(کیلوهرتز),
						'one' => q({0} کیلوهرتز),
						'other' => q({0} کیلوهرتز),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'one' => q({0}نقطه),
						'other' => q({0}نقطه),
					},
					# Core Unit Identifier
					'dot' => {
						'one' => q({0}نقطه),
						'other' => q({0}نقطه),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(نقطه در سانتی‌متر),
						'one' => q({0} نقطه در سانتی‌متر),
						'other' => q({0} نقطه در سانتی‌متر),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(نقطه در سانتی‌متر),
						'one' => q({0} نقطه در سانتی‌متر),
						'other' => q({0} نقطه در سانتی‌متر),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(نقطه در اینچ),
						'one' => q({0} نقطه در اینچ),
						'other' => q({0} نقطه در اینچ),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(نقطه در اینچ),
						'one' => q({0} نقطه در اینچ),
						'other' => q({0} نقطه در اینچ),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(em تایپوگرافی),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(em تایپوگرافی),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'one' => q({0} مگاپیکسل),
						'other' => q({0} مگاپیکسل),
					},
					# Core Unit Identifier
					'megapixel' => {
						'one' => q({0} مگاپیکسل),
						'other' => q({0} مگاپیکسل),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'one' => q({0} پیکسل),
						'other' => q({0} پیکسل),
					},
					# Core Unit Identifier
					'pixel' => {
						'one' => q({0} پیکسل),
						'other' => q({0} پیکسل),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(پیکسل در سانتی‌متر),
						'one' => q({0} پیکسل در سانتی‌متر),
						'other' => q({0} پیکسل در سانتی‌متر),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(پیکسل در سانتی‌متر),
						'one' => q({0} پیکسل در سانتی‌متر),
						'other' => q({0} پیکسل در سانتی‌متر),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(پیکسل در اینچ),
						'one' => q({0} پیکسل در اینچ),
						'other' => q({0} پیکسل در اینچ),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(پیکسل در اینچ),
						'one' => q({0} پیکسل در اینچ),
						'other' => q({0} پیکسل در اینچ),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(واحد نجومی),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(واحد نجومی),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'per' => q({0} در سانتی‌متر),
					},
					# Core Unit Identifier
					'centimeter' => {
						'per' => q({0} در سانتی‌متر),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(شعاع زمین),
						'one' => q({0} شعاع زمین),
						'other' => q({0} شعاع زمین),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(شعاع زمین),
						'one' => q({0} شعاع زمین),
						'other' => q({0} شعاع زمین),
					},
					# Long Unit Identifier
					'length-foot' => {
						'per' => q({0} در فوت),
					},
					# Core Unit Identifier
					'foot' => {
						'per' => q({0} در فوت),
					},
					# Long Unit Identifier
					'length-inch' => {
						'per' => q({0} در اینچ),
					},
					# Core Unit Identifier
					'inch' => {
						'per' => q({0} در اینچ),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'per' => q({0} در کیلومتر),
					},
					# Core Unit Identifier
					'kilometer' => {
						'per' => q({0} در کیلومتر),
					},
					# Long Unit Identifier
					'length-meter' => {
						'one' => q({0} متر),
						'other' => q({0} متر),
						'per' => q({0} در متر),
					},
					# Core Unit Identifier
					'meter' => {
						'one' => q({0} متر),
						'other' => q({0} متر),
						'per' => q({0} در متر),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'one' => q({0} مایل اسکاندیناوی),
						'other' => q({0} مایل اسکاندیناوی),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'one' => q({0} مایل اسکاندیناوی),
						'other' => q({0} مایل اسکاندیناوی),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(شمع),
						'one' => q({0} شمع),
						'other' => q({0} شمع),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(شمع),
						'one' => q({0} شمع),
						'other' => q({0} شمع),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(لومن),
						'one' => q({0} لومن),
						'other' => q({0} لومن),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(لومن),
						'one' => q({0} لومن),
						'other' => q({0} لومن),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'one' => q({0} تابندگی خورشید),
						'other' => q({0} تابندگی خورشید),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'one' => q({0} تابندگی خورشید),
						'other' => q({0} تابندگی خورشید),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'one' => q({0} جرم زمین),
						'other' => q({0} جرم زمین),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'one' => q({0} جرم زمین),
						'other' => q({0} جرم زمین),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'per' => q({0} در کیلوگرم),
					},
					# Core Unit Identifier
					'kilogram' => {
						'per' => q({0} در کیلوگرم),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(میکروگرم),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(میکروگرم),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(میلی‌گرم),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(میلی‌گرم),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'one' => q({0} جرم خورشید),
						'other' => q({0} جرم خورشید),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'one' => q({0} جرم خورشید),
						'other' => q({0} جرم خورشید),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(تن متریک),
						'one' => q({0} تن متریک),
						'other' => q({0} تن متریک),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(تن متریک),
						'one' => q({0} تن متریک),
						'other' => q({0} تن متریک),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0} در {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0} در {1}),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(کیلووات),
						'one' => q({0} کیلووات),
						'other' => q({0} کیلووات),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(کیلووات),
						'one' => q({0} کیلووات),
						'other' => q({0} کیلووات),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q(مربع {0}),
						'one' => q({0}مربع),
						'other' => q({0}مربع),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q(مربع {0}),
						'one' => q({0}مربع),
						'other' => q({0}مربع),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q(مکعب {0}),
						'one' => q({0} مکعب),
						'other' => q({0} مکعب),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q(مکعب {0}),
						'one' => q({0} مکعب),
						'other' => q({0} مکعب),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(کیلوپاسکال),
						'one' => q({0} کیلوپاسکال),
						'other' => q({0} کیلوپاسکال),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(کیلوپاسکال),
						'one' => q({0} کیلوپاسکال),
						'other' => q({0} کیلوپاسکال),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'one' => q({0} میلی‌متر جیوه),
						'other' => q({0} میلی‌متر جیوه),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'one' => q({0} میلی‌متر جیوه),
						'other' => q({0} میلی‌متر جیوه),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'one' => q({0} پوند در اینچ مربع),
						'other' => q({0} پوند در اینچ مربع),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'one' => q({0} پوند در اینچ مربع),
						'other' => q({0} پوند در اینچ مربع),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'one' => q({0} کیلومتر در ساعت),
						'other' => q({0} کیلومتر در ساعت),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'one' => q({0} کیلومتر در ساعت),
						'other' => q({0} کیلومتر در ساعت),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'one' => q({0} متر در ثانیه),
						'other' => q({0} متر در ثانیه),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'one' => q({0} متر در ثانیه),
						'other' => q({0} متر در ثانیه),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'one' => q({0} مایل در ساعت),
						'other' => q({0} مایل در ساعت),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'one' => q({0} مایل در ساعت),
						'other' => q({0} مایل در ساعت),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'one' => q({0} درجهٔ سلسیوس),
						'other' => q({0} درجهٔ سلسیوس),
					},
					# Core Unit Identifier
					'celsius' => {
						'one' => q({0} درجهٔ سلسیوس),
						'other' => q({0} درجهٔ سلسیوس),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'one' => q({0} درجهٔ فارنهایت),
						'other' => q({0} درجهٔ فارنهایت),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'one' => q({0} درجهٔ فارنهایت),
						'other' => q({0} درجهٔ فارنهایت),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'one' => q({0} درجهٔ کلوین),
						'other' => q({0} درجهٔ کلوین),
					},
					# Core Unit Identifier
					'kelvin' => {
						'one' => q({0} درجهٔ کلوین),
						'other' => q({0} درجهٔ کلوین),
					},
					# Long Unit Identifier
					'times' => {
						'1' => q({0}‌{1}),
					},
					# Core Unit Identifier
					'times' => {
						'1' => q({0}‌{1}),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(سانتی‌لیتر),
						'one' => q({0} سانتی‌لیتر),
						'other' => q({0} سانتی‌لیتر),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(سانتی‌لیتر),
						'one' => q({0} سانتی‌لیتر),
						'other' => q({0} سانتی‌لیتر),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(سانتی‌متر مکعب),
						'one' => q({0} سانتی‌متر مکعب),
						'other' => q({0} سانتی‌متر مکعب),
						'per' => q({0} در سانتی‌متر مکعب),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(سانتی‌متر مکعب),
						'one' => q({0} سانتی‌متر مکعب),
						'other' => q({0} سانتی‌متر مکعب),
						'per' => q({0} در سانتی‌متر مکعب),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'one' => q({0} فوت مکعب),
						'other' => q({0} فوت مکعب),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'one' => q({0} فوت مکعب),
						'other' => q({0} فوت مکعب),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'one' => q({0} اینچ مکعب),
						'other' => q({0} اینچ مکعب),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'one' => q({0} اینچ مکعب),
						'other' => q({0} اینچ مکعب),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'one' => q({0} کیلومتر مکعب),
						'other' => q({0} کیلومتر مکعب),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'one' => q({0} کیلومتر مکعب),
						'other' => q({0} کیلومتر مکعب),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'one' => q({0} متر مکعب),
						'other' => q({0} متر مکعب),
						'per' => q({0} در متر مکعب),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'one' => q({0} متر مکعب),
						'other' => q({0} متر مکعب),
						'per' => q({0} در متر مکعب),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(مایل مکعب),
						'one' => q({0} مایل مکعب),
						'other' => q({0} مایل مکعب),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(مایل مکعب),
						'one' => q({0} مایل مکعب),
						'other' => q({0} مایل مکعب),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'one' => q({0} یارد مکعب),
						'other' => q({0} یارد مکعب),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'one' => q({0} یارد مکعب),
						'other' => q({0} یارد مکعب),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(دسی‌لیتر),
						'one' => q({0} دسی‌لیتر),
						'other' => q({0} دسی‌لیتر),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(دسی‌لیتر),
						'one' => q({0} دسی‌لیتر),
						'other' => q({0} دسی‌لیتر),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'one' => q({0} قاشق دسرخوری),
						'other' => q({0} قاشق دسرخوری),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'one' => q({0} قاشق دسرخوری),
						'other' => q({0} قاشق دسرخوری),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'one' => q({0} قاشق دسرخوری انگلیسی),
						'other' => q({0} قاشق دسرخوری انگلیسی),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'one' => q({0} قاشق دسرخوری انگلیسی),
						'other' => q({0} قاشق دسرخوری انگلیسی),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(درم),
						'one' => q({0} درم),
						'other' => q({0} درم),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(درم),
						'one' => q({0} درم),
						'other' => q({0} درم),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'one' => q({0} اونس سیال),
						'other' => q({0} اونس سیال),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'one' => q({0} اونس سیال),
						'other' => q({0} اونس سیال),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'one' => q({0} اونس سیال انگلیسی),
						'other' => q({0} اونس سیال انگلیسی),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'one' => q({0} اونس سیال انگلیسی),
						'other' => q({0} اونس سیال انگلیسی),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'per' => q({0} در گالن امپریال),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'per' => q({0} در گالن امپریال),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(هکتولیتر),
						'one' => q({0} هکتولیتر),
						'other' => q({0} هکتولیتر),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(هکتولیتر),
						'one' => q({0} هکتولیتر),
						'other' => q({0} هکتولیتر),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'one' => q({0} لیتر),
						'other' => q({0} لیتر),
						'per' => q({0} در لیتر),
					},
					# Core Unit Identifier
					'liter' => {
						'one' => q({0} لیتر),
						'other' => q({0} لیتر),
						'per' => q({0} در لیتر),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'one' => q({0} مگالیتر),
						'other' => q({0} مگالیتر),
					},
					# Core Unit Identifier
					'megaliter' => {
						'one' => q({0} مگالیتر),
						'other' => q({0} مگالیتر),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(قاشق غذاخوری),
						'one' => q({0} قاشق غذاخوری),
						'other' => q({0} قاشق غذاخوری),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(قاشق غذاخوری),
						'one' => q({0} قاشق غذاخوری),
						'other' => q({0} قاشق غذاخوری),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(قاشق چای‌خوری),
						'one' => q({0} قاشق چای‌خوری),
						'other' => q({0} قاشق چای‌خوری),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(قاشق چای‌خوری),
						'one' => q({0} قاشق چای‌خوری),
						'other' => q({0} قاشق چای‌خوری),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(Ki{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(Ki{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(Mi{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(Mi{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(Gi{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(Gi{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(Ti{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(Ti{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(Pi{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(Pi{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(Ei{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(Ei{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(Zi{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(Zi{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(Yi{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(Yi{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(d{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(d{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(p{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(p{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(f{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(f{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(a{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(a{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(c{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(c{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(z{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(z{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(y{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(y{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(r{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(r{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(m{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(m{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(q{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(q{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(μ{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(μ{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(n{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(n{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(da{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(da{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(T{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(T{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(P{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(P{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(E{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(E{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(h{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(h{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(Z{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(Z{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(Y{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(Y{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(R{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(R{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(k{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(k{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(Q{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(Q{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(M{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(M{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(G{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(G{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(نیروی جاذبه),
						'one' => q({0}G),
						'other' => q({0}G),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(نیروی جاذبه),
						'one' => q({0}G),
						'other' => q({0}G),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'area-acre' => {
						'one' => q({0}جریب),
						'other' => q({0} جریب),
					},
					# Core Unit Identifier
					'acre' => {
						'one' => q({0}جریب),
						'other' => q({0} جریب),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'one' => q({0}دونوم),
						'other' => q({0}دونوم),
					},
					# Core Unit Identifier
					'dunam' => {
						'one' => q({0}دونوم),
						'other' => q({0}دونوم),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'one' => q({0}ha),
						'other' => q({0}ha),
					},
					# Core Unit Identifier
					'hectare' => {
						'one' => q({0}ha),
						'other' => q({0}ha),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(ft²),
						'one' => q({0}ft²),
						'other' => q({0}ft²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(ft²),
						'one' => q({0}ft²),
						'other' => q({0}ft²),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(in²),
						'one' => q({0}in²),
						'other' => q({0}in²),
						'per' => q({0}/in²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(in²),
						'one' => q({0}in²),
						'other' => q({0}in²),
						'per' => q({0}/in²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'one' => q({0}km²),
						'other' => q({0}km²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'one' => q({0}km²),
						'other' => q({0}km²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'one' => q({0}m²),
						'other' => q({0}m²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'one' => q({0}m²),
						'other' => q({0}m²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'one' => q({0} mi²),
						'other' => q({0} mi²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'one' => q({0} mi²),
						'other' => q({0} mi²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(yd²),
						'one' => q({0}yd²),
						'other' => q({0}yd²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(yd²),
						'one' => q({0}yd²),
						'other' => q({0}yd²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'one' => q({0}مورد),
						'other' => q({0}مورد),
					},
					# Core Unit Identifier
					'item' => {
						'one' => q({0}مورد),
						'other' => q({0}مورد),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(٪),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(٪),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'one' => q({0}ppm),
						'other' => q({0}ppm),
					},
					# Core Unit Identifier
					'permillion' => {
						'one' => q({0}ppm),
						'other' => q({0}ppm),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'one' => q({0}m/gUK),
						'other' => q({0}m/gUK),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'one' => q({0}m/gUK),
						'other' => q({0}m/gUK),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'one' => q({0}Gb),
						'other' => q({0}Gb),
					},
					# Core Unit Identifier
					'gigabit' => {
						'one' => q({0}Gb),
						'other' => q({0}Gb),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'one' => q({0}GB),
						'other' => q({0}GB),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'one' => q({0}GB),
						'other' => q({0}GB),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'one' => q({0}kb),
						'other' => q({0}kb),
					},
					# Core Unit Identifier
					'kilobit' => {
						'one' => q({0}kb),
						'other' => q({0}kb),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'one' => q({0}kB),
						'other' => q({0}kB),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'one' => q({0}kB),
						'other' => q({0}kB),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'one' => q({0}Mb),
						'other' => q({0}Mb),
					},
					# Core Unit Identifier
					'megabit' => {
						'one' => q({0}Mb),
						'other' => q({0}Mb),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'one' => q({0}MB),
						'other' => q({0}MB),
					},
					# Core Unit Identifier
					'megabyte' => {
						'one' => q({0}MB),
						'other' => q({0}MB),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'one' => q({0}PB),
						'other' => q({0}PB),
					},
					# Core Unit Identifier
					'petabyte' => {
						'one' => q({0}PB),
						'other' => q({0}PB),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'one' => q({0}Tb),
						'other' => q({0}Tb),
					},
					# Core Unit Identifier
					'terabit' => {
						'one' => q({0}Tb),
						'other' => q({0}Tb),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'one' => q({0}TB),
						'other' => q({0}TB),
					},
					# Core Unit Identifier
					'terabyte' => {
						'one' => q({0}TB),
						'other' => q({0}TB),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'one' => q({0}h),
						'other' => q({0}h),
						'per' => q({0}/ساعت),
					},
					# Core Unit Identifier
					'hour' => {
						'one' => q({0}h),
						'other' => q({0}h),
						'per' => q({0}/ساعت),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'one' => q({0}ms),
						'other' => q({0}ms),
					},
					# Core Unit Identifier
					'millisecond' => {
						'one' => q({0}ms),
						'other' => q({0}ms),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'one' => q({0}m),
						'other' => q({0}m),
						'per' => q({0}/دقیقه),
					},
					# Core Unit Identifier
					'minute' => {
						'one' => q({0}m),
						'other' => q({0}m),
						'per' => q({0}/دقیقه),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'one' => q({0}ns),
						'other' => q({0}ns),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'one' => q({0}ns),
						'other' => q({0}ns),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'one' => q({0}فصل),
						'other' => q({0}فصل),
					},
					# Core Unit Identifier
					'quarter' => {
						'one' => q({0}فصل),
						'other' => q({0}فصل),
					},
					# Long Unit Identifier
					'duration-second' => {
						'one' => q({0}s),
						'other' => q({0}s),
						'per' => q({0}/ثانیه),
					},
					# Core Unit Identifier
					'second' => {
						'one' => q({0}s),
						'other' => q({0}s),
						'per' => q({0}/ثانیه),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'one' => q({0}الکترون‌ولت),
						'other' => q({0}الکترون‌ولت),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'one' => q({0}الکترون‌ولت),
						'other' => q({0}الکترون‌ولت),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'one' => q({0}ک.وا.س/۱۰۰ ک.م),
						'other' => q({0} ک.وا.س/۱۰۰ ک.م),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'one' => q({0}ک.وا.س/۱۰۰ ک.م),
						'other' => q({0} ک.وا.س/۱۰۰ ک.م),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(گ‌.هرتز),
						'one' => q({0} گ.هرتز),
						'other' => q({0} گ.هرتز),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(گ‌.هرتز),
						'one' => q({0} گ.هرتز),
						'other' => q({0} گ.هرتز),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'one' => q({0}dpi),
						'other' => q({0}dpi),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'one' => q({0}dpi),
						'other' => q({0}dpi),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'one' => q({0}MP),
						'other' => q({0}MP),
					},
					# Core Unit Identifier
					'megapixel' => {
						'one' => q({0}MP),
						'other' => q({0}MP),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'one' => q({0}px),
						'other' => q({0}px),
					},
					# Core Unit Identifier
					'pixel' => {
						'one' => q({0}px),
						'other' => q({0}px),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'one' => q({0}ppcm),
						'other' => q({0}ppcm),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'one' => q({0}ppcm),
						'other' => q({0}ppcm),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(واحد نجومی),
						'one' => q({0}واحد نجومی),
						'other' => q({0}واحد نجومی),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(واحد نجومی),
						'one' => q({0}واحد نجومی),
						'other' => q({0}واحد نجومی),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(cm),
						'one' => q({0}cm),
						'other' => q({0}cm),
						'per' => q({0}/cm),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(cm),
						'one' => q({0}cm),
						'other' => q({0}cm),
						'per' => q({0}/cm),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(dm),
						'one' => q({0}dm),
						'other' => q({0}dm),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(dm),
						'one' => q({0}dm),
						'other' => q({0}dm),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'one' => q({0}فاتوم),
						'other' => q({0}فاتوم),
					},
					# Core Unit Identifier
					'fathom' => {
						'one' => q({0}فاتوم),
						'other' => q({0}فاتوم),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(ft),
						'one' => q({0}ft),
						'other' => q({0}ft),
						'per' => q({0}/ft),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(ft),
						'one' => q({0}ft),
						'other' => q({0}ft),
						'per' => q({0}/ft),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'one' => q({0}فرلانگ),
						'other' => q({0}فرلانگ),
					},
					# Core Unit Identifier
					'furlong' => {
						'one' => q({0}فرلانگ),
						'other' => q({0}فرلانگ),
					},
					# Long Unit Identifier
					'length-inch' => {
						'one' => q({0}in),
						'other' => q({0}in),
					},
					# Core Unit Identifier
					'inch' => {
						'one' => q({0}in),
						'other' => q({0}in),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(km),
						'one' => q({0}km),
						'other' => q({0}km),
						'per' => q({0}‎/km),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(km),
						'one' => q({0}km),
						'other' => q({0}km),
						'per' => q({0}‎/km),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'one' => q({0}ly),
						'other' => q({0}ly),
					},
					# Core Unit Identifier
					'light-year' => {
						'one' => q({0}ly),
						'other' => q({0}ly),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(m),
						'one' => q({0}m),
						'other' => q({0}m),
						'per' => q({0}‎/m),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(m),
						'one' => q({0}m),
						'other' => q({0}m),
						'per' => q({0}‎/m),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(μm),
						'one' => q({0}μm),
						'other' => q({0}μm),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(μm),
						'one' => q({0}μm),
						'other' => q({0}μm),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(mi),
						'one' => q({0}mi),
						'other' => q({0}mi),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(mi),
						'one' => q({0}mi),
						'other' => q({0}mi),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(mm),
						'one' => q({0}mm),
						'other' => q({0}mm),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(mm),
						'one' => q({0}mm),
						'other' => q({0}mm),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(nm),
						'one' => q({0}nm),
						'other' => q({0}nm),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(nm),
						'one' => q({0}nm),
						'other' => q({0}nm),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'one' => q({0}مایل دریایی),
						'other' => q({0}مایل دریایی),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'one' => q({0}مایل دریایی),
						'other' => q({0}مایل دریایی),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(pm),
						'one' => q({0}pm),
						'other' => q({0}pm),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(pm),
						'one' => q({0}pm),
						'other' => q({0}pm),
					},
					# Long Unit Identifier
					'length-point' => {
						'one' => q({0}پوینت),
						'other' => q({0}پوینت),
					},
					# Core Unit Identifier
					'point' => {
						'one' => q({0}پوینت),
						'other' => q({0}پوینت),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'one' => q({0}شعاع خورشید),
						'other' => q({0}شعاع خورشید),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'one' => q({0}شعاع خورشید),
						'other' => q({0}شعاع خورشید),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(yd),
						'one' => q({0}yd),
						'other' => q({0}yd),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(yd),
						'one' => q({0}yd),
						'other' => q({0}yd),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'one' => q({0}CD),
						'other' => q({0}CD),
					},
					# Core Unit Identifier
					'carat' => {
						'one' => q({0}CD),
						'other' => q({0}CD),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'one' => q({0}Da),
						'other' => q({0}Da),
					},
					# Core Unit Identifier
					'dalton' => {
						'one' => q({0}Da),
						'other' => q({0}Da),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'one' => q({0}M⊕),
						'other' => q({0}M⊕),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'one' => q({0}M⊕),
						'other' => q({0}M⊕),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'one' => q({0}gr),
						'other' => q({0}gr),
					},
					# Core Unit Identifier
					'grain' => {
						'one' => q({0}gr),
						'other' => q({0}gr),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(kg),
						'one' => q({0}kg),
						'other' => q({0}kg),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(kg),
						'one' => q({0}kg),
						'other' => q({0}kg),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(میکروگرم),
						'one' => q({0}μg),
						'other' => q({0}μg),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(میکروگرم),
						'one' => q({0}μg),
						'other' => q({0}μg),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(میلی‌گرم),
						'one' => q({0}mg),
						'other' => q({0}mg),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(میلی‌گرم),
						'one' => q({0}mg),
						'other' => q({0}mg),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'one' => q({0}oz),
						'other' => q({0}oz),
					},
					# Core Unit Identifier
					'ounce' => {
						'one' => q({0}oz),
						'other' => q({0}oz),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'one' => q({0}اونس تروا),
						'other' => q({0}اونس تروا),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'one' => q({0}اونس تروا),
						'other' => q({0}اونس تروا),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'one' => q({0}lb),
						'other' => q({0}lb),
					},
					# Core Unit Identifier
					'pound' => {
						'one' => q({0}lb),
						'other' => q({0}lb),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'one' => q({0}M☉),
						'other' => q({0}M☉),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'one' => q({0}M☉),
						'other' => q({0}M☉),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'one' => q({0}st),
						'other' => q({0}st),
					},
					# Core Unit Identifier
					'stone' => {
						'one' => q({0}st),
						'other' => q({0}st),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'one' => q({0}tn),
						'other' => q({0}tn),
					},
					# Core Unit Identifier
					'ton' => {
						'one' => q({0}tn),
						'other' => q({0}tn),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(تن متریک),
						'one' => q({0} تن),
						'other' => q({0} تن),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(تن متریک),
						'one' => q({0} تن),
						'other' => q({0} تن),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'one' => q({0}hp),
						'other' => q({0}hp),
					},
					# Core Unit Identifier
					'horsepower' => {
						'one' => q({0}hp),
						'other' => q({0}hp),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					# Long Unit Identifier
					'power-watt' => {
						'one' => q({0}W),
						'other' => q({0}W),
					},
					# Core Unit Identifier
					'watt' => {
						'one' => q({0}W),
						'other' => q({0}W),
					},
					# Long Unit Identifier
					'power2' => {
						'one' => q({0}²),
						'other' => q({0}²),
					},
					# Core Unit Identifier
					'power2' => {
						'one' => q({0}²),
						'other' => q({0}²),
					},
					# Long Unit Identifier
					'power3' => {
						'one' => q({0}³),
						'other' => q({0}³),
					},
					# Core Unit Identifier
					'power3' => {
						'one' => q({0}³),
						'other' => q({0}³),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'one' => q({0}اتمسفر),
						'other' => q({0}اتمسفر),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'one' => q({0}اتمسفر),
						'other' => q({0}اتمسفر),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'one' => q({0}hPa),
						'other' => q({0}hPa),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'one' => q({0}hPa),
						'other' => q({0}hPa),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'one' => q({0}inHg),
						'other' => q({0}inHg),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'one' => q({0}inHg),
						'other' => q({0}inHg),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'one' => q({0}mbar),
						'other' => q({0}mbar),
					},
					# Core Unit Identifier
					'millibar' => {
						'one' => q({0}mbar),
						'other' => q({0}mbar),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'one' => q({0}Pa),
						'other' => q({0}Pa),
					},
					# Core Unit Identifier
					'pascal' => {
						'one' => q({0}Pa),
						'other' => q({0}Pa),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'one' => q(B{0}),
						'other' => q({0}بوفورت),
					},
					# Core Unit Identifier
					'beaufort' => {
						'one' => q(B{0}),
						'other' => q({0}بوفورت),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(کیلومتر/ساعت),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(کیلومتر/ساعت),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'one' => q({0}m/s),
						'other' => q({0}m/s),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'one' => q({0}m/s),
						'other' => q({0}m/s),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(‎°C),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(‎°C),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(‎°F),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(‎°F),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'one' => q({0}K),
						'other' => q({0}K),
					},
					# Core Unit Identifier
					'kelvin' => {
						'one' => q({0}K),
						'other' => q({0}K),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'one' => q({0}ac ft),
						'other' => q({0}ac ft),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'one' => q({0}ac ft),
						'other' => q({0}ac ft),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'one' => q({0}bu),
						'other' => q({0}bu),
					},
					# Core Unit Identifier
					'bushel' => {
						'one' => q({0}bu),
						'other' => q({0}bu),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(ft³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(ft³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(in³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(in³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(m³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(m³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(yd³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(yd³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'one' => q({0}c),
						'other' => q({0}c),
					},
					# Core Unit Identifier
					'cup' => {
						'one' => q({0}c),
						'other' => q({0}c),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'one' => q({0}mc),
						'other' => q({0}mc),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'one' => q({0}mc),
						'other' => q({0}mc),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'one' => q({0}fl oz),
						'other' => q({0}fl oz),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'one' => q({0}fl oz),
						'other' => q({0}fl oz),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'one' => q({0}اونس سیال انگلیسی),
						'other' => q({0}اونس سیال انگلیسی),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'one' => q({0}اونس سیال انگلیسی),
						'other' => q({0}اونس سیال انگلیسی),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(ML),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(ML),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(mL),
						'one' => q({0}mL),
						'other' => q({0}mL),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(mL),
						'one' => q({0}mL),
						'other' => q({0}mL),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(pt),
						'one' => q({0}pt),
						'other' => q({0}pt),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(pt),
						'one' => q({0}pt),
						'other' => q({0}pt),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'one' => q({0}mpt),
						'other' => q({0}mpt),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'one' => q({0}mpt),
						'other' => q({0}mpt),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(qt),
						'one' => q({0}qt),
						'other' => q({0}qt),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(qt),
						'one' => q({0}qt),
						'other' => q({0}qt),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'one' => q({0}کوارت انگلیسی),
						'other' => q({0} کورت انگلیسی),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'one' => q({0}کوارت انگلیسی),
						'other' => q({0} کورت انگلیسی),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'one' => q({0}ق.چ.),
						'other' => q({0}ق.چ.),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'one' => q({0}ق.چ.),
						'other' => q({0}ق.چ.),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(جهت),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(جهت),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(کیبی‌{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(کیبی‌{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(مبی‌{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(مبی‌{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(گیبی‌{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(گیبی‌{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(تبی‌{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(تبی‌{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(پبی‌{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(پبی‌{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(اگزبی‌{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(اگزبی‌{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(زبی‌{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(زبی‌{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(یوبی‌{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(یوبی‌{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(دسی‌{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(دسی‌{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(پیکو{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(پیکو{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(فمتو{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(فمتو{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(آتو{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(آتو{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(سانتی{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(سانتی{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(زپتو{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(زپتو{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(یوکتو{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(یوکتو{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(رونتو{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(رونتو{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(میلی{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(میلی{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(کوکتو{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(کوکتو{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(میکرو{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(میکرو{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(نانو{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(نانو{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(دکا{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(دکا{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(ترا{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(ترا{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(پتا{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(پتا{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(اگزا{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(اگزا{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(هکتو{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(هکتو{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(زتا{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(زتا{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(یوتا{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(یوتا{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(رونا{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(رونا{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(کیلو{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(کیلو{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(کتا{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(کتا{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(مگا{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(مگا{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(گیگا{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(گیگا{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(گرانش),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(گرانش),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(متر/مجذور ثانیه),
						'one' => q({0}‎ m/s²),
						'other' => q({0}‎ m/s²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(متر/مجذور ثانیه),
						'one' => q({0}‎ m/s²),
						'other' => q({0}‎ m/s²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(دقیقهٔ قوسی),
						'one' => q({0} د.قوسی),
						'other' => q({0} د.قوسی),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(دقیقهٔ قوسی),
						'one' => q({0} د.قوسی),
						'other' => q({0} د.قوسی),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(ثانیهٔ قوسی),
						'one' => q({0} ث.قوسی),
						'other' => q({0} ث.قوسی),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(ثانیهٔ قوسی),
						'one' => q({0} ث.قوسی),
						'other' => q({0} ث.قوسی),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(درجه),
						'one' => q({0} درجه),
						'other' => q({0} درجه),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(درجه),
						'one' => q({0} درجه),
						'other' => q({0} درجه),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(رادیان),
						'one' => q({0} رادیان),
						'other' => q({0} رادیان),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(رادیان),
						'one' => q({0} رادیان),
						'other' => q({0} رادیان),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(دور),
						'one' => q({0} دور),
						'other' => q({0} دور),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(دور),
						'one' => q({0} دور),
						'other' => q({0} دور),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(جریب),
						'one' => q({0} جریب),
						'other' => q({0} جریب),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(جریب),
						'one' => q({0} جریب),
						'other' => q({0} جریب),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(دونوم),
						'one' => q({0} دونوم),
						'other' => q({0} دونوم),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(دونوم),
						'one' => q({0} دونوم),
						'other' => q({0} دونوم),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(هکتار),
						'one' => q({0} هک),
						'other' => q({0} هک),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(هکتار),
						'one' => q({0} هک),
						'other' => q({0} هک),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'one' => q({0}‎ cm²),
						'other' => q({0}‎ cm²),
						'per' => q({0}‎/cm²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'one' => q({0}‎ cm²),
						'other' => q({0}‎ cm²),
						'per' => q({0}‎/cm²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(فوت مربع),
						'one' => q({0} فوت مربع),
						'other' => q({0} فوت مربع),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(فوت مربع),
						'one' => q({0} فوت مربع),
						'other' => q({0} فوت مربع),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(اینچ مربع),
						'one' => q({0} اینچ مربع),
						'other' => q({0} اینچ مربع),
						'per' => q({0}/اینچ مربع),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(اینچ مربع),
						'one' => q({0} اینچ مربع),
						'other' => q({0} اینچ مربع),
						'per' => q({0}/اینچ مربع),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(کیلومتر مربع),
						'one' => q({0}‎ km²),
						'other' => q({0}‎ km²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(کیلومتر مربع),
						'one' => q({0}‎ km²),
						'other' => q({0}‎ km²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(متر مربع),
						'per' => q({0}‎/m²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(متر مربع),
						'per' => q({0}‎/m²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(مایل مربع),
						'one' => q({0} مایل مربع),
						'other' => q({0} مایل مربع),
						'per' => q({0}‎/mi²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(مایل مربع),
						'one' => q({0} مایل مربع),
						'other' => q({0} مایل مربع),
						'per' => q({0}‎/mi²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(یارد مربع),
						'one' => q({0} یارد مربع),
						'other' => q({0} یارد مربع),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(یارد مربع),
						'one' => q({0} یارد مربع),
						'other' => q({0} یارد مربع),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(مورد),
						'one' => q({0} مورد),
						'other' => q({0} مورد),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(مورد),
						'one' => q({0} مورد),
						'other' => q({0} مورد),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(عیار),
						'one' => q({0} عیار),
						'other' => q({0} عیار),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(عیار),
						'one' => q({0} عیار),
						'other' => q({0} عیار),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(میلی‌گرم در دسی‌لیتر),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(میلی‌گرم در دسی‌لیتر),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(میلی‌مول/لیتر),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(میلی‌مول/لیتر),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(مول),
						'one' => q({0} مول),
						'other' => q({0} مول),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(مول),
						'one' => q({0} مول),
						'other' => q({0} مول),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(درصد),
						'one' => q({0}٪),
						'other' => q({0}٪),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(درصد),
						'one' => q({0}٪),
						'other' => q({0}٪),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(هزارم),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(هزارم),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(بخش/میلیون),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(بخش/میلیون),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(ده‌هزارم),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(ده‌هزارم),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(لیتر/۱۰۰ کیلومتر),
						'one' => q({0} ل./۱۰۰ ک.م.),
						'other' => q({0} ل./۱۰۰ ک.م.),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(لیتر/۱۰۰ کیلومتر),
						'one' => q({0} ل./۱۰۰ ک.م.),
						'other' => q({0} ل./۱۰۰ ک.م.),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(لیتر/کیلومتر),
						'one' => q({0} ل./ک.م.),
						'other' => q({0} ل./ک.م.),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(لیتر/کیلومتر),
						'one' => q({0} ل./ک.م.),
						'other' => q({0} ل./ک.م.),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(مایل/گالن),
						'one' => q({0} مایل در گالن),
						'other' => q({0} مایل در گالن),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(مایل/گالن),
						'one' => q({0} مایل در گالن),
						'other' => q({0} مایل در گالن),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(مایل/امپریال گالن),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(مایل/امپریال گالن),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} شرقی),
						'north' => q({0} شمالی),
						'south' => q({0} جنوبی),
						'west' => q({0} غربی),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} شرقی),
						'north' => q({0} شمالی),
						'south' => q({0} جنوبی),
						'west' => q({0} غربی),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(بیت),
						'one' => q({0} بیت),
						'other' => q({0} بیت),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(بیت),
						'one' => q({0} بیت),
						'other' => q({0} بیت),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(بایت),
						'one' => q({0} بایت),
						'other' => q({0} بایت),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(بایت),
						'one' => q({0} بایت),
						'other' => q({0} بایت),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(گیگابیت),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(گیگابیت),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(کیلوبیت),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(کیلوبیت),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(کیلوبایت),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(کیلوبایت),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(مگابیت),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(مگابیت),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(پتابایت),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(پتابایت),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(ترابیت),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(ترابیت),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(ترابایت),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(ترابایت),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(سده),
						'one' => q({0} سده),
						'other' => q({0} سده),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(سده),
						'one' => q({0} سده),
						'other' => q({0} سده),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(روز),
						'one' => q({0} روز),
						'other' => q({0} روز),
						'per' => q({0}/روز),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(روز),
						'one' => q({0} روز),
						'other' => q({0} روز),
						'per' => q({0}/روز),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(دهه),
						'one' => q({0} دهه),
						'other' => q({0} دهه),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(دهه),
						'one' => q({0} دهه),
						'other' => q({0} دهه),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ساعت),
						'one' => q({0} ساعت),
						'other' => q({0} ساعت),
						'per' => q({0} در ساعت),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ساعت),
						'one' => q({0} ساعت),
						'other' => q({0} ساعت),
						'per' => q({0} در ساعت),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(میکروثانیه),
						'one' => q({0}μs),
						'other' => q({0}μs),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(میکروثانیه),
						'one' => q({0}μs),
						'other' => q({0}μs),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(میلی‌ثانیه),
						'one' => q({0} میلی‌ثانیه),
						'other' => q({0} میلی‌ثانیه),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(میلی‌ثانیه),
						'one' => q({0} میلی‌ثانیه),
						'other' => q({0} میلی‌ثانیه),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(دقیقه),
						'one' => q({0} دقیقه),
						'other' => q({0} دقیقه),
						'per' => q({0} در دقیقه),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(دقیقه),
						'one' => q({0} دقیقه),
						'other' => q({0} دقیقه),
						'per' => q({0} در دقیقه),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(ماه),
						'one' => q({0} ماه),
						'other' => q({0} ماه),
						'per' => q({0}/ماه),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(ماه),
						'one' => q({0} ماه),
						'other' => q({0} ماه),
						'per' => q({0}/ماه),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(نانوثانیه),
						'one' => q({0} نانوثانیه),
						'other' => q({0} نانوثانیه),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(نانوثانیه),
						'one' => q({0} نانوثانیه),
						'other' => q({0} نانوثانیه),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(سه‌ماه),
						'one' => q({0} فصل),
						'other' => q({0} فصل),
						'per' => q({0}/سه‌ماه),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(سه‌ماه),
						'one' => q({0} فصل),
						'other' => q({0} فصل),
						'per' => q({0}/سه‌ماه),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ثانیه),
						'one' => q({0} ثانیه),
						'other' => q({0} ثانیه),
						'per' => q({0} در ثانیه),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ثانیه),
						'one' => q({0} ثانیه),
						'other' => q({0} ثانیه),
						'per' => q({0} در ثانیه),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(هفته),
						'one' => q({0} هفته),
						'other' => q({0} هفته),
						'per' => q({0}/هفته),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(هفته),
						'one' => q({0} هفته),
						'other' => q({0} هفته),
						'per' => q({0}/هفته),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q({0}/سال),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q({0}/سال),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(آمپر),
						'one' => q({0} آمپر),
						'other' => q({0} آمپر),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(آمپر),
						'one' => q({0} آمپر),
						'other' => q({0} آمپر),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(میلی‌آمپر),
						'one' => q({0} میلی‌آمپر),
						'other' => q({0} میلی‌آمپر),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(میلی‌آمپر),
						'one' => q({0} میلی‌آمپر),
						'other' => q({0} میلی‌آمپر),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(اهم),
						'one' => q({0} اهم),
						'other' => q({0} اهم),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(اهم),
						'one' => q({0} اهم),
						'other' => q({0} اهم),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(ولت),
						'one' => q({0} ولت),
						'other' => q({0} ولت),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(ولت),
						'one' => q({0} ولت),
						'other' => q({0} ولت),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(بی‌تی‌یو),
						'one' => q({0} بی‌تی‌یو),
						'other' => q({0} بی‌تی‌یو),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(بی‌تی‌یو),
						'one' => q({0} بی‌تی‌یو),
						'other' => q({0} بی‌تی‌یو),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(کالری),
						'one' => q({0} کالری),
						'other' => q({0} کالری),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(کالری),
						'one' => q({0} کالری),
						'other' => q({0} کالری),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(الکترون‌ولت),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(الکترون‌ولت),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(کالری),
						'one' => q({0} کالری),
						'other' => q({0} کالری),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(کالری),
						'one' => q({0} کالری),
						'other' => q({0} کالری),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(ژول),
						'one' => q({0} ژول),
						'other' => q({0} ژول),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(ژول),
						'one' => q({0} ژول),
						'other' => q({0} ژول),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(ک.کالری),
						'one' => q({0} ک.کالری),
						'other' => q({0} ک.کالری),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(ک.کالری),
						'one' => q({0} ک.کالری),
						'other' => q({0} ک.کالری),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(ک.ژول),
						'one' => q({0} ک.ژول),
						'other' => q({0} ک.ژول),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(ک.ژول),
						'one' => q({0} ک.ژول),
						'other' => q({0} ک.ژول),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(ک.وات‌ساعت),
						'one' => q({0} ک.و.ساعت),
						'other' => q({0} ک.و.ساعت),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(ک.وات‌ساعت),
						'one' => q({0} ک.و.ساعت),
						'other' => q({0} ک.و.ساعت),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(ترم آمریکایی),
						'one' => q({0} ترم آمریکایی),
						'other' => q({0} ترم آمریکایی),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(ترم آمریکایی),
						'one' => q({0} ترم آمریکایی),
						'other' => q({0} ترم آمریکایی),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(ک.وا.س/۱۰۰ ک.م),
						'one' => q({0} ک.وا.س/۱۰۰ ک.م),
						'other' => q({0} ک.وا.س/۱۰۰ ک.م),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(ک.وا.س/۱۰۰ ک.م),
						'one' => q({0} ک.وا.س/۱۰۰ ک.م),
						'other' => q({0} ک.وا.س/۱۰۰ ک.م),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(نیوتن),
						'one' => q({0} نیوتن),
						'other' => q({0} نیوتن),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(نیوتن),
						'one' => q({0} نیوتن),
						'other' => q({0} نیوتن),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(پوند-نیرو),
						'one' => q({0} پوند-نیرو),
						'other' => q({0} پوند-نیرو),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(پوند-نیرو),
						'one' => q({0} پوند-نیرو),
						'other' => q({0} پوند-نیرو),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(گیگاهرتز),
						'one' => q({0} گیگاهرتز),
						'other' => q({0} گیگاهرتز),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(گیگاهرتز),
						'one' => q({0} گیگاهرتز),
						'other' => q({0} گیگاهرتز),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(هرتز),
						'one' => q({0} هرتز),
						'other' => q({0} هرتز),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(هرتز),
						'one' => q({0} هرتز),
						'other' => q({0} هرتز),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(ک.هرتز),
						'one' => q({0} ک.هرتز),
						'other' => q({0} ک.هرتز),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(ک.هرتز),
						'one' => q({0} ک.هرتز),
						'other' => q({0} ک.هرتز),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(مگاهرتز),
						'one' => q({0} مگاهرتز),
						'other' => q({0} مگاهرتز),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(مگاهرتز),
						'one' => q({0} مگاهرتز),
						'other' => q({0} مگاهرتز),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(نقطه),
						'one' => q({0} نقطه),
						'other' => q({0} نقطه),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(نقطه),
						'one' => q({0} نقطه),
						'other' => q({0} نقطه),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0} dpcm),
						'other' => q({0} dpcm),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0} dpcm),
						'other' => q({0} dpcm),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} dpi),
						'other' => q({0} dpi),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} dpi),
						'other' => q({0} dpi),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(مگاپیکسل),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(مگاپیکسل),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(پیکسل),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(پیکسل),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'one' => q({0} واحد نجومی),
						'other' => q({0} واحد نجومی),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'one' => q({0} واحد نجومی),
						'other' => q({0} واحد نجومی),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(سانتی‌متر),
						'one' => q({0} سانتی‌متر),
						'other' => q({0} سانتی‌متر),
						'per' => q({0}/سانتی‌متر),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(سانتی‌متر),
						'one' => q({0} سانتی‌متر),
						'other' => q({0} سانتی‌متر),
						'per' => q({0}/سانتی‌متر),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(دسی‌متر),
						'one' => q({0} دسی‌متر),
						'other' => q({0} دسی‌متر),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(دسی‌متر),
						'one' => q({0} دسی‌متر),
						'other' => q({0} دسی‌متر),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(فاتوم),
						'one' => q({0} فاتوم),
						'other' => q({0} فاتوم),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(فاتوم),
						'one' => q({0} فاتوم),
						'other' => q({0} فاتوم),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(فوت),
						'one' => q({0} فوت),
						'other' => q({0} فوت),
						'per' => q({0}/فوت),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(فوت),
						'one' => q({0} فوت),
						'other' => q({0} فوت),
						'per' => q({0}/فوت),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(فرلانگ),
						'one' => q({0} فرلانگ),
						'other' => q({0} فرلانگ),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(فرلانگ),
						'one' => q({0} فرلانگ),
						'other' => q({0} فرلانگ),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(اینچ),
						'one' => q({0} اینچ),
						'other' => q({0} اینچ),
						'per' => q({0}/اینچ),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(اینچ),
						'one' => q({0} اینچ),
						'other' => q({0} اینچ),
						'per' => q({0}/اینچ),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(کیلومتر),
						'one' => q({0} کیلومتر),
						'other' => q({0} کیلومتر),
						'per' => q({0}/کیلومتر),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(کیلومتر),
						'one' => q({0} کیلومتر),
						'other' => q({0} کیلومتر),
						'per' => q({0}/کیلومتر),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(سال نوری),
						'one' => q({0} سال نوری),
						'other' => q({0} سال نوری),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(سال نوری),
						'one' => q({0} سال نوری),
						'other' => q({0} سال نوری),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(متر),
						'one' => q({0}متر),
						'other' => q({0}متر),
						'per' => q({0}/متر),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(متر),
						'one' => q({0}متر),
						'other' => q({0}متر),
						'per' => q({0}/متر),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(میکرومتر),
						'one' => q({0} میکرومتر),
						'other' => q({0} میکرومتر),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(میکرومتر),
						'one' => q({0} میکرومتر),
						'other' => q({0} میکرومتر),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(مایل),
						'one' => q({0} مایل),
						'other' => q({0} مایل),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(مایل),
						'one' => q({0} مایل),
						'other' => q({0} مایل),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(مایل اسکاندیناوی),
						'one' => q({0}‎ smi),
						'other' => q({0}‎ smi),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(مایل اسکاندیناوی),
						'one' => q({0}‎ smi),
						'other' => q({0}‎ smi),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(میلی‌متر),
						'one' => q({0} میلی‌متر),
						'other' => q({0} میلی‌متر),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(میلی‌متر),
						'one' => q({0} میلی‌متر),
						'other' => q({0} میلی‌متر),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(نانومتر),
						'one' => q({0} نانومتر),
						'other' => q({0} نانومتر),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(نانومتر),
						'one' => q({0} نانومتر),
						'other' => q({0} نانومتر),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(مایل دریایی),
						'one' => q({0} مایل دریایی),
						'other' => q({0} مایل دریایی),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(مایل دریایی),
						'one' => q({0} مایل دریایی),
						'other' => q({0} مایل دریایی),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(پارسک),
						'one' => q({0} پارسک),
						'other' => q({0} پارسک),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(پارسک),
						'one' => q({0} پارسک),
						'other' => q({0} پارسک),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(پیکومتر),
						'one' => q({0} پیکومتر),
						'other' => q({0} پیکومتر),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(پیکومتر),
						'one' => q({0} پیکومتر),
						'other' => q({0} پیکومتر),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(پوینت),
						'one' => q({0} پوینت),
						'other' => q({0} پوینت),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(پوینت),
						'one' => q({0} پوینت),
						'other' => q({0} پوینت),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(شعاع خورشید),
						'one' => q({0} شعاع خورشید),
						'other' => q({0} شعاع خورشید),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(شعاع خورشید),
						'one' => q({0} شعاع خورشید),
						'other' => q({0} شعاع خورشید),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(یارد),
						'one' => q({0} یارد),
						'other' => q({0} یارد),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(یارد),
						'one' => q({0} یارد),
						'other' => q({0} یارد),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(لوکس),
						'one' => q({0} لوکس),
						'other' => q({0} لوکس),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(لوکس),
						'one' => q({0} لوکس),
						'other' => q({0} لوکس),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(تابندگی خورشید),
						'one' => q({0} ☉L),
						'other' => q({0} ☉L),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(تابندگی خورشید),
						'one' => q({0} ☉L),
						'other' => q({0} ☉L),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(قیراط),
						'one' => q({0} قیراط),
						'other' => q({0} قیراط),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(قیراط),
						'one' => q({0} قیراط),
						'other' => q({0} قیراط),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(دالتون),
						'one' => q({0} دالتون),
						'other' => q({0} دالتون),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(دالتون),
						'one' => q({0} دالتون),
						'other' => q({0} دالتون),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(جرم زمین),
						'one' => q({0} M⊕),
						'other' => q({0} ⊕M),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(جرم زمین),
						'one' => q({0} M⊕),
						'other' => q({0} ⊕M),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(دانه),
						'one' => q({0} دانه),
						'other' => q({0} دانه),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(دانه),
						'one' => q({0} دانه),
						'other' => q({0} دانه),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(گرم),
						'one' => q({0} گرم),
						'other' => q({0} گرم),
						'per' => q({0} در گرم),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(گرم),
						'one' => q({0} گرم),
						'other' => q({0} گرم),
						'per' => q({0} در گرم),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(کیلوگرم),
						'one' => q({0} کیلوگرم),
						'other' => q({0} کیلوگرم),
						'per' => q({0}‎/kg),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(کیلوگرم),
						'one' => q({0} کیلوگرم),
						'other' => q({0} کیلوگرم),
						'per' => q({0}‎/kg),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'one' => q({0} میکروگرم),
						'other' => q({0} میکروگرم),
					},
					# Core Unit Identifier
					'microgram' => {
						'one' => q({0} میکروگرم),
						'other' => q({0} میکروگرم),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'one' => q({0} میلی‌گرم),
						'other' => q({0} میلی‌گرم),
					},
					# Core Unit Identifier
					'milligram' => {
						'one' => q({0} میلی‌گرم),
						'other' => q({0} میلی‌گرم),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(اونس),
						'one' => q({0} اونس),
						'other' => q({0} اونس),
						'per' => q({0} در اونس),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(اونس),
						'one' => q({0} اونس),
						'other' => q({0} اونس),
						'per' => q({0} در اونس),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(اونس تروا),
						'one' => q({0} اونس تروا),
						'other' => q({0} اونس تروا),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(اونس تروا),
						'one' => q({0} اونس تروا),
						'other' => q({0} اونس تروا),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(پوند),
						'one' => q({0} پوند),
						'other' => q({0} پوند),
						'per' => q({0} در پوند),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(پوند),
						'one' => q({0} پوند),
						'other' => q({0} پوند),
						'per' => q({0} در پوند),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(جرم خورشید),
						'one' => q({0} ☉M),
						'other' => q({0} ☉M),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(جرم خورشید),
						'one' => q({0} ☉M),
						'other' => q({0} ☉M),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(سنگ),
						'one' => q({0} سنگ),
						'other' => q({0} سنگ),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(سنگ),
						'one' => q({0} سنگ),
						'other' => q({0} سنگ),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(تن),
						'one' => q({0} تن),
						'other' => q({0} تن),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(تن),
						'one' => q({0} تن),
						'other' => q({0} تن),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(گیگاوات),
						'one' => q({0} گیگاوات),
						'other' => q({0} گیگاوات),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(گیگاوات),
						'one' => q({0} گیگاوات),
						'other' => q({0} گیگاوات),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(اسب بخار),
						'one' => q({0} اسب بخار),
						'other' => q({0} اسب بخار),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(اسب بخار),
						'one' => q({0} اسب بخار),
						'other' => q({0} اسب بخار),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(ک.وات),
						'one' => q({0} ک.وات),
						'other' => q({0} ک.وات),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(ک.وات),
						'one' => q({0} ک.وات),
						'other' => q({0} ک.وات),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(مگاوات),
						'one' => q({0} مگاوات),
						'other' => q({0} مگاوات),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(مگاوات),
						'one' => q({0} مگاوات),
						'other' => q({0} مگاوات),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(میلی‌وات),
						'one' => q({0} میلی‌وات),
						'other' => q({0} میلی‌وات),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(میلی‌وات),
						'one' => q({0} میلی‌وات),
						'other' => q({0} میلی‌وات),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(وات),
						'one' => q({0} وات),
						'other' => q({0} وات),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(وات),
						'one' => q({0} وات),
						'other' => q({0} وات),
					},
					# Long Unit Identifier
					'power2' => {
						'one' => q({0}مربع),
						'other' => q({0}مربع),
					},
					# Core Unit Identifier
					'power2' => {
						'one' => q({0}مربع),
						'other' => q({0}مربع),
					},
					# Long Unit Identifier
					'power3' => {
						'one' => q({0}مکعب),
						'other' => q({0}مکعب),
					},
					# Core Unit Identifier
					'power3' => {
						'one' => q({0}مکعب),
						'other' => q({0}مکعب),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(اتمسفر),
						'one' => q({0} اتمسفر),
						'other' => q({0} اتمسفر),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(اتمسفر),
						'one' => q({0} اتمسفر),
						'other' => q({0} اتمسفر),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(بار),
						'one' => q({0} بار),
						'other' => q({0} بار),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(بار),
						'one' => q({0} بار),
						'other' => q({0} بار),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(هکتوپاسکال),
						'one' => q({0} هکتوپاسکال),
						'other' => q({0} هکتوپاسکال),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(هکتوپاسکال),
						'one' => q({0} هکتوپاسکال),
						'other' => q({0} هکتوپاسکال),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(اینچ جیوه),
						'one' => q({0} اینچ جیوه),
						'other' => q({0} اینچ جیوه),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(اینچ جیوه),
						'one' => q({0} اینچ جیوه),
						'other' => q({0} اینچ جیوه),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(ک.پاسکال),
						'one' => q({0} ک.پاسکال),
						'other' => q({0} ک.پاسکال),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(ک.پاسکال),
						'one' => q({0} ک.پاسکال),
						'other' => q({0} ک.پاسکال),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(مگاپاسکال),
						'one' => q({0} مگاپاسکال),
						'other' => q({0} مگاپاسکال),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(مگاپاسکال),
						'one' => q({0} مگاپاسکال),
						'other' => q({0} مگاپاسکال),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(میلی‌بار),
						'one' => q({0} میلی‌بار),
						'other' => q({0} میلی‌بار),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(میلی‌بار),
						'one' => q({0} میلی‌بار),
						'other' => q({0} میلی‌بار),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(میلی‌متر جیوه),
						'one' => q({0} م‌م جیوه),
						'other' => q({0} م‌م جیوه),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(میلی‌متر جیوه),
						'one' => q({0} م‌م جیوه),
						'other' => q({0} م‌م جیوه),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(پاسکال),
						'one' => q({0} پاسکال),
						'other' => q({0} پاسکال),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(پاسکال),
						'one' => q({0} پاسکال),
						'other' => q({0} پاسکال),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(پوند در اینچ مربع),
						'one' => q({0}‎ psi),
						'other' => q({0}‎ psi),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(پوند در اینچ مربع),
						'one' => q({0}‎ psi),
						'other' => q({0}‎ psi),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'name' => q(بوفورت),
						'one' => q({0} بوفورت),
						'other' => q({0} بوفورت),
					},
					# Core Unit Identifier
					'beaufort' => {
						'name' => q(بوفورت),
						'one' => q({0} بوفورت),
						'other' => q({0} بوفورت),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(کیلومتر در ساعت),
						'one' => q({0}‎ km/h),
						'other' => q({0}‎ km/h),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(کیلومتر در ساعت),
						'one' => q({0}‎ km/h),
						'other' => q({0}‎ km/h),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(گره),
						'one' => q({0} گره),
						'other' => q({0} گره),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(گره),
						'one' => q({0} گره),
						'other' => q({0} گره),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(متر در ثانیه),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(متر در ثانیه),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(مایل در ساعت),
						'one' => q({0}‎ mph),
						'other' => q({0}‎ mph),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(مایل در ساعت),
						'one' => q({0}‎ mph),
						'other' => q({0}‎ mph),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(درجهٔ سلسیوس),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(درجهٔ سلسیوس),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(درجهٔ فارنهایت),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(درجهٔ فارنهایت),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(درجهٔ کلوین),
						'one' => q(‎{0} K),
						'other' => q(‎{0} K),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(درجهٔ کلوین),
						'one' => q(‎{0} K),
						'other' => q(‎{0} K),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(نیوتن‌متر),
						'one' => q({0} نیوتن‌متر),
						'other' => q({0} نیوتن‌متر),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(نیوتن‌متر),
						'one' => q({0} نیوتن‌متر),
						'other' => q({0} نیوتن‌متر),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(پوند-فوت),
						'one' => q({0} پوند-فوت),
						'other' => q({0} پوند-فوت),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(پوند-فوت),
						'one' => q({0} پوند-فوت),
						'other' => q({0} پوند-فوت),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(جریب فوت),
						'one' => q({0} جریب فوت),
						'other' => q({0} جریب فوت),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(جریب فوت),
						'one' => q({0} جریب فوت),
						'other' => q({0} جریب فوت),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(بشکه),
						'one' => q({0} بشکه),
						'other' => q({0} بشکه),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(بشکه),
						'one' => q({0} بشکه),
						'other' => q({0} بشکه),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(بوشل),
						'one' => q({0} بوشل),
						'other' => q({0} بوشل),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(بوشل),
						'one' => q({0} بوشل),
						'other' => q({0} بوشل),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'one' => q({0}cL),
						'other' => q({0}cL),
					},
					# Core Unit Identifier
					'centiliter' => {
						'one' => q({0}cL),
						'other' => q({0}cL),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'one' => q({0}‎ cm³),
						'other' => q({0}‎ cm³),
						'per' => q({0}‎ /cm³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'one' => q({0}‎ cm³),
						'other' => q({0}‎ cm³),
						'per' => q({0}‎ /cm³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(فوت مکعب),
						'one' => q({0}ft³),
						'other' => q({0}ft³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(فوت مکعب),
						'one' => q({0}ft³),
						'other' => q({0}ft³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(اینچ مکعب),
						'one' => q({0}in³),
						'other' => q({0}in³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(اینچ مکعب),
						'one' => q({0}in³),
						'other' => q({0}in³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(کیلومتر مکعب),
						'one' => q({0}‎ km³),
						'other' => q({0}‎ km³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(کیلومتر مکعب),
						'one' => q({0}‎ km³),
						'other' => q({0}‎ km³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(متر مکعب),
						'one' => q({0}m³),
						'other' => q({0}m³),
						'per' => q({0}‎/m³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(متر مکعب),
						'one' => q({0}m³),
						'other' => q({0}m³),
						'per' => q({0}‎/m³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(یارد مکعب),
						'one' => q({0}yd³),
						'other' => q({0}yd³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(یارد مکعب),
						'one' => q({0}yd³),
						'other' => q({0}yd³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(پیمانه),
						'one' => q({0} پیمانه),
						'other' => q({0} پیمانه),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(پیمانه),
						'one' => q({0} پیمانه),
						'other' => q({0} پیمانه),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(پیمانهٔ متریک),
						'one' => q({0} پیمانهٔ متریک),
						'other' => q({0} پیمانهٔ متریک),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(پیمانهٔ متریک),
						'one' => q({0} پیمانهٔ متریک),
						'other' => q({0} پیمانهٔ متریک),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'one' => q({0}dL),
						'other' => q({0}dL),
					},
					# Core Unit Identifier
					'deciliter' => {
						'one' => q({0}dL),
						'other' => q({0}dL),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(قاشق دسرخوری),
						'one' => q({0} ق.دس.خ.),
						'other' => q({0} ق.دس.خ.),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(قاشق دسرخوری),
						'one' => q({0} ق.دس.خ.),
						'other' => q({0} ق.دس.خ.),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(قاشق دسرخوری انگلیسی),
						'one' => q({0} ق.دس. انگلیسی),
						'other' => q({0} ق.دس. انگلیسی),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(قاشق دسرخوری انگلیسی),
						'one' => q({0} ق.دس. انگلیسی),
						'other' => q({0} ق.دس. انگلیسی),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(درم سیال),
						'one' => q({0} درم سیال),
						'other' => q({0} درم سیال),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(درم سیال),
						'one' => q({0} درم سیال),
						'other' => q({0} درم سیال),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(قطره),
						'one' => q({0} قطره),
						'other' => q({0} قطره),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(قطره),
						'one' => q({0} قطره),
						'other' => q({0} قطره),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(اونس سیال),
						'one' => q({0}‎ fl oz),
						'other' => q({0}‎ fl oz),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(اونس سیال),
						'one' => q({0}‎ fl oz),
						'other' => q({0}‎ fl oz),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(اونس سیال انگلیسی),
						'one' => q({0} fl oz Imp),
						'other' => q({0} fl oz Imp),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(اونس سیال انگلیسی),
						'one' => q({0} fl oz Imp),
						'other' => q({0} fl oz Imp),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(گالن),
						'one' => q({0} گالن),
						'other' => q({0} گالن),
						'per' => q({0} در گالن),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(گالن),
						'one' => q({0} گالن),
						'other' => q({0} گالن),
						'per' => q({0} در گالن),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(گالن امپریال),
						'one' => q({0} گالن امپریال),
						'other' => q({0} گالن امپریال),
						'per' => q({0}/گالن امپریال),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(گالن امپریال),
						'one' => q({0} گالن امپریال),
						'other' => q({0} گالن امپریال),
						'per' => q({0}/گالن امپریال),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'one' => q({0}hL),
						'other' => q({0}hL),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'one' => q({0}hL),
						'other' => q({0}hL),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(گیلاس),
						'one' => q({0} گیلاس),
						'other' => q({0} گیلاس),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(گیلاس),
						'one' => q({0} گیلاس),
						'other' => q({0} گیلاس),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(لیتر),
						'one' => q({0}L),
						'other' => q({0}L),
						'per' => q({0}‎/L),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(لیتر),
						'one' => q({0}L),
						'other' => q({0}L),
						'per' => q({0}‎/L),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(مگالیتر),
						'one' => q({0}ML),
						'other' => q({0}ML),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(مگالیتر),
						'one' => q({0}ML),
						'other' => q({0}ML),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(میلی‌لیتر),
						'one' => q({0} میلی‌لیتر),
						'other' => q({0} میلی‌لیتر),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(میلی‌لیتر),
						'one' => q({0} میلی‌لیتر),
						'other' => q({0} میلی‌لیتر),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(سرانگشت),
						'one' => q({0} سرانگشت),
						'other' => q({0} سرانگشت),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(سرانگشت),
						'one' => q({0} سرانگشت),
						'other' => q({0} سرانگشت),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(پاینت),
						'one' => q({0} پاینت),
						'other' => q({0} پاینت),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(پاینت),
						'one' => q({0} پاینت),
						'other' => q({0} پاینت),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(پاینت متریک),
						'one' => q({0} پاینت متریک),
						'other' => q({0} پاینت متریک),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(پاینت متریک),
						'one' => q({0} پاینت متریک),
						'other' => q({0} پاینت متریک),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(کوارت),
						'one' => q({0} کوارت),
						'other' => q({0} کوارت),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(کوارت),
						'one' => q({0} کوارت),
						'other' => q({0} کوارت),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(کوارت انگلیسی),
						'one' => q({0} کوارت انگلیسی),
						'other' => q({0} کوارت انگلیسی),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(کوارت انگلیسی),
						'one' => q({0} کوارت انگلیسی),
						'other' => q({0} کوارت انگلیسی),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(قاشق غ.),
						'one' => q({0} ق.غ.خ),
						'other' => q({0} قاشق غ.),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(قاشق غ.),
						'one' => q({0} ق.غ.خ),
						'other' => q({0} قاشق غ.),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(قاشق چ.),
						'one' => q({0} ق.چ.),
						'other' => q({0} ق.چ.),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(قاشق چ.),
						'one' => q({0} ق.چ.),
						'other' => q({0} ق.چ.),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:بله|ب|آری|آ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:نه|ن|خیر|خ|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}،‏ {1}),
				middle => q({0}،‏ {1}),
				end => q({0}، و {1}),
				2 => q({0} و {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arabext',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arabext',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arab' => {
			'percentSign' => q(٪),
		},
		'arabext' => {
			'minusSign' => q(‎−),
			'nan' => q(ناعدد),
			'plusSign' => q(‎+),
			'timeSeparator' => q(:),
		},
		'latn' => {
			'minusSign' => q(‎−),
			'nan' => q(ناعدد),
			'plusSign' => q(‎+),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'one' => '0 هزار',
					'other' => '0 هزار',
				},
				'10000' => {
					'one' => '00 هزار',
					'other' => '00 هزار',
				},
				'100000' => {
					'one' => '000 هزار',
					'other' => '000 هزار',
				},
				'1000000' => {
					'one' => '0 میلیون',
					'other' => '0 میلیون',
				},
				'10000000' => {
					'one' => '00 میلیون',
					'other' => '00 میلیون',
				},
				'100000000' => {
					'one' => '000 میلیون',
					'other' => '000 میلیون',
				},
				'1000000000' => {
					'one' => '0 میلیارد',
					'other' => '0 میلیارد',
				},
				'10000000000' => {
					'one' => '00 میلیارد',
					'other' => '00 میلیارد',
				},
				'100000000000' => {
					'one' => '000 میلیارد',
					'other' => '000 میلیارد',
				},
				'1000000000000' => {
					'one' => '0 هزارمیلیارد',
					'other' => '0 هزارمیلیارد',
				},
				'10000000000000' => {
					'one' => '00 هزارمیلیارد',
					'other' => '00 هزارمیلیارد',
				},
				'100000000000000' => {
					'one' => '000 هزارمیلیارد',
					'other' => '000 هزارمیلیارد',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 هزار',
					'other' => '0 هزار',
				},
				'10000' => {
					'one' => '00 هزار',
					'other' => '00 هزار',
				},
				'100000' => {
					'one' => '000 هزار',
					'other' => '000 هزار',
				},
				'1000000' => {
					'one' => '0 میلیون',
					'other' => '0 میلیون',
				},
				'10000000' => {
					'one' => '00 میلیون',
					'other' => '00 میلیون',
				},
				'100000000' => {
					'one' => '000 میلیون',
					'other' => '000 میلیون',
				},
				'1000000000' => {
					'one' => '0 میلیارد',
					'other' => '0 میلیارد',
				},
				'10000000000' => {
					'one' => '00 میلیارد',
					'other' => '00 میلیارد',
				},
				'100000000000' => {
					'one' => '000 میلیارد',
					'other' => '000 میلیارد',
				},
				'1000000000000' => {
					'one' => '0 تریلیون',
					'other' => '0 تریلیون',
				},
				'10000000000000' => {
					'one' => '00 تریلیون',
					'other' => '00 تریلیون',
				},
				'100000000000000' => {
					'one' => '000 تریلیون',
					'other' => '000 تریلیون',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arab' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '‎¤#,##0.00',
					},
				},
			},
		},
		'arabext' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '‎¤#,##0.00',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '‎(¤ #,##0.00)',
						'positive' => '‎¤ #,##0.00',
					},
					'standard' => {
						'positive' => '‎¤ #,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(پزتای آندورا),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(درهم امارات متحدهٔ عربی),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(افغانی افغانستان \(۱۹۲۷ تا ۲۰۰۲\)),
			},
		},
		'AFN' => {
			symbol => '؋',
			display_name => {
				'currency' => q(افغانی افغانستان),
			},
		},
		'ALK' => {
			display_name => {
				'currency' => q(لک آلبانی \(۱۹۴۶ تا ۱۹۶۵\)),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(لک آلبانی),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(درام ارمنستان),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(گیلدر آنتیل هلند),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(کوانزای آنگولا),
			},
		},
		'ARM' => {
			display_name => {
				'currency' => q(پزوی آرژانتین \(۱۸۸۱ تا ۱۹۷۰\)),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(پزوی آرژانتین \(۱۹۸۳ تا ۱۹۸۵\)‏),
				'one' => q(پزوی آرژانتین \(۱۹۸۳ تا ۱۹۸۵\)),
				'other' => q(پزوی آرژانتین \(۱۹۸۳ تا ۱۹۸۵\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(پزوی آرژانتین),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(شیلینگ اتریش),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(دلار استرالیا),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(فلورین آروبا),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(منات جمهوری آذربایجان \(۱۹۹۳ تا ۲۰۰۶\)),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(منات جمهوری آذربایجان),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(دینار بوسنی و هرزگوین \(۱۹۹۲ تا ۱۹۹۴\)),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(مارک تبدیل‌پذیر بوسنی و هرزگوین),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(دلار باربادوس),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(تاکای بنگلادش),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(فرانک بلژیک),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(فرانک بلژیک \(مالی\)),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(لف بلغارستان),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(دینار بحرین),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(فرانک بوروندی),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(دلار برمودا),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(دلار برونئی),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(بولیویانوی بولیوی),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(پزوی بولیوی),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(رئال برزیل),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(دلار باهاما),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(انگولتروم بوتان),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(پولای بوتسوانا),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(روبل جدید بلاروس \(۱۹۹۴ تا ۱۹۹۹\)),
			},
		},
		'BYN' => {
			symbol => 'р.',
			display_name => {
				'currency' => q(روبل بلاروس),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(روبل بلاروسی \(۲۰۱۶–۲۰۰۰\)),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(دلار بلیز),
			},
		},
		'CAD' => {
			symbol => '$CA',
			display_name => {
				'currency' => q(دلار کانادا),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(فرانک کنگو),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(فرانک سوئیس),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(پزوی شیلی),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(یوآن چین \(برون‌مرزی\)),
			},
		},
		'CNY' => {
			symbol => '¥CN',
			display_name => {
				'currency' => q(یوآن چین),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(پزوی کلمبیا),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(کولون کاستاریکا),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(دینار صربستان \(۲۰۰۲ تا ۲۰۰۶\)),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(پزوی تبدیل‌پذیر کوبا),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(پزوی کوبا),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(اسکودوی کیپ‌ورد),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(پوند قبرس),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(کورونای جمهوری چک),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(مارک آلمان شرقی),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(مارک آلمان),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(فرانک جیبوتی),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(کرون دانمارک),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(پزوی جمهوری دومینیکن),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(دینار الجزایر),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(کرون استونی),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(پوند مصر),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(ناکفای اریتره),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(پزتای اسپانیا),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(بیر اتیوپی),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(یورو),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(دلار فیجی),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(پوند جزایر فالکلند),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(فرانک فرانسه),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(پوند بریتانیا),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(لاری گرجستان),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(سدی غنا),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(پوند جبل‌الطارق),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(دالاسی گامبیا),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(فرانک گینه),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(دراخمای یونان),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(کتزال گواتمالا),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(پزوی گینهٔ بیسائو),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(دلار گویانا),
			},
		},
		'HKD' => {
			symbol => '$HK',
			display_name => {
				'currency' => q(دلار هنگ‌کنگ),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(لمپیرای هندوراس),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(دینار کرواسی),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(کونای کرواسی),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(گورد هائیتی),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(فورینت مجارستان),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(روپیهٔ اندونزی),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(پوند ایرلند),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(پوند اسرائیل),
			},
		},
		'ILR' => {
			display_name => {
				'currency' => q(شقل اسرائیل \(۱۹۸۰ تا ۱۹۸۵\)),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(شقل جدید اسرائیل),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(روپیهٔ هند),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(دینار عراق),
			},
		},
		'IRR' => {
			symbol => 'ریال',
			display_name => {
				'currency' => q(ریال ایران),
			},
		},
		'ISJ' => {
			display_name => {
				'currency' => q(کرونای ایسلند \(۱۹۱۸ تا ۱۹۸۱\)),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(کرونای ایسلند),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(لیرهٔ ایتالیا),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(دلار جامائیکا),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(دینار اردن),
			},
		},
		'JPY' => {
			symbol => '¥',
			display_name => {
				'currency' => q(ین ژاپن),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(شیلینگ کنیا),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(سوم قرقیزستان),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(ری‌یل کامبوج),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(فرانک کومورو),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(وون کرهٔ شمالی),
			},
		},
		'KRO' => {
			display_name => {
				'currency' => q(وون کرهٔ جنوبی \(۱۹۴۵ تا ۱۹۵۳\)),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(وون کرهٔ جنوبی),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(دینار کویت),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(دلار جزایر کِیمن),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(تنگهٔ قزاقستان),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(کیپ لائوس),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(لیرهٔ لبنان),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(روپیهٔ سری‌لانکا),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(دلار لیبریا),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(لوتی لسوتو),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(لیتاس لیتوانی),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(تالوناس لیتوانی),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(فرانک لوکزامبورگ),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(فرانک مالی لوگزامبورگ),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(لاتس لتونی),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(روبل لتونی),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(دینار لیبی),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(درهم مراکش),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(فرانک مراکش),
			},
		},
		'MCF' => {
			display_name => {
				'currency' => q(فرانک موناکو),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(لئوی مولداوی),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(آریاری مالاگاسی),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(فرانک ماداگاسکار),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(دینار مقدونیه),
			},
		},
		'MKN' => {
			display_name => {
				'currency' => q(دینار مقدونیه \(۱۹۹۲ تا ۱۹۹۳\)),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(فرانک مالی),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(کیات میانمار),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(توگریک مغولستان),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(پاتاکای ماکائو),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(اوگوئیای موریتانی \(۱۹۷۳ تا ۲۰۱۷\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(اوگوئیای موریتانی),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(لیرهٔ مالت),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(پوند مالت),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(روپیهٔ موریس),
			},
		},
		'MVP' => {
			display_name => {
				'currency' => q(روپیهٔ مالدیو \(۱۹۴۷ تا ۱۹۸۱\)),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(روپیهٔ مالدیو),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(کواچای مالاوی),
			},
		},
		'MXN' => {
			symbol => '$MX',
			display_name => {
				'currency' => q(پزوی مکزیک),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(پزوی نقرهٔ مکزیک \(۱۸۶۱ تا ۱۹۹۲\)),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(رینگیت مالزی),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(اسکودوی موزامبیک),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(متیکال موزامبیک),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(دلار نامیبیا),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(نایرای نیجریه),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(کوردوبای نیکاراگوئه),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(گیلدر هلند),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(کرون نروژ),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(روپیهٔ نپال),
			},
		},
		'NZD' => {
			symbol => '$NZ',
			display_name => {
				'currency' => q(دلار زلاند نو),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ریال عمان),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(بالبوای پاناما),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(اینتی پرو),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(سول پرو),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(سول پرو \(۱۸۶۳ تا ۱۹۶۵\)),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(کینای پاپوا گینهٔ نو),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(پزوی فیلیپین),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(روپیهٔ پاکستان),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(زواتی لهستان),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(اسکودوی پرتغال),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(گوارانی پاراگوئه),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(ریال قطر),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(دلار رودزیا),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(لئوی رومانی),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(دینار صربستان),
			},
		},
		'RUB' => {
			symbol => '₽',
			display_name => {
				'currency' => q(روبل روسیه),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(روبل روسیه \(۱۹۹۱ تا ۱۹۹۸\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(فرانک رواندا),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(ریال سعودی),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(دلار جزایر سلیمان),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(روپیهٔ سیشل),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(دینار سودان \(۱۹۹۲ تا ۲۰۰۷\)),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(پوند سودان),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(کرون سوئد),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(دلار سنگاپور),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(پوند سنت هلن),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(لئون سیرالئون),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(لئون سیرالئون - 1964-2022),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(شیلینگ سومالی),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(دلار سورینام),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(گیلدر سورینام),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(پوند سودان جنوبی),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(دوبرای سائوتومه و پرنسیپ \(۱۹۷۷ تا ۲۰۱۷\)),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(دوبرای سائوتومه و پرنسیپ),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(روبل شوروی),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(لیرهٔ سوریه),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(لیلانگنی سوازیلند),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(بات تایلند),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(روبل تاجیکستان),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(سامانی تاجیکستان),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(منات ترکمنستان \(۱۹۹۳ تا ۲۰۰۹\)),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(منات ترکمنستان),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(دینار تونس),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(پاآنگای تونگا),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(اسکودوی تیمور),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(لیرهٔ ترکیه \(۱۹۲۲ تا ۲۰۰۵\)),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(لیرهٔ ترکیه),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(دلار ترینیداد و توباگو),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(دلار جدید تایوان),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(شیلینگ تانزانیا),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(هریونیای اوکراین),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(شیلینگ اوگاندا \(۱۹۶۶ تا ۱۹۸۷\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(شیلینگ اوگاندا),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(دلار آمریکا),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(دلار امریکا \(روز بعد\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(دلار امریکا \(همان روز\)),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(پزوی اوروگوئه \(۱۹۷۵ تا ۱۹۹۳\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(پزوی اوروگوئه),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(سوم ازبکستان),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(بولیوار ونزوئلا \(۱۸۷۱ تا ۲۰۰۸\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(بولیوار ونزوئلا \(۲۰۰۸ تا ۲۰۱۸\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(بولیوار ونزوئلا),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(دانگ ویتنام),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(واتوی وانوواتو),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(تالای ساموا),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(فرانک CFA مرکز افریقا),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(نقره),
				'one' => q(اونس تروا نقره),
				'other' => q(اونس تروا نقره),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(طلا),
				'one' => q(اونس تروا طلا),
				'other' => q(اونس تروا طلا),
			},
		},
		'XCD' => {
			symbol => '$EC',
			display_name => {
				'currency' => q(دلار شرق کارائیب),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(فرانک طلای فرانسه),
			},
		},
		'XOF' => {
			symbol => 'فرانک CFA',
			display_name => {
				'currency' => q(فرانک CFA غرب افریقا),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(پالادیم),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(فرانک اقیانوسیه),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(پلاتین),
				'one' => q(اونس تروا پلاتین),
				'other' => q(اونس تروا پلاتین),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(ارز آزمایشی),
				'one' => q(واحد ارز آزمایشی),
				'other' => q(واحد ارز آزمایشی),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(ارز نامشخص),
				'one' => q(\(ارز نامشخص\)),
				'other' => q(\(ارز نامشخص\)),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(دینار یمن),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(ریال یمن),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(راند افریقای جنوبی),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(کواچای زامبیا \(۱۹۶۸ تا ۲۰۱۲\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(کواچای زامبیا),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(دلار زیمبابوه \(۱۹۸۰ تا ۲۰۰۸\)),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(دلار زیمبابوه \(۲۰۰۹\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(دلار زیمبابوه \(۲۰۰۸\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					wide => {
						nonleap => [
							'توت',
							'پاوی',
							'اثور',
							'کواق',
							'طوفی',
							'ماخیر',
							'فامینوث',
							'فرموثی',
							'پاخون',
							'پاونی',
							'افیفی',
							'ماسوری',
							'ماه کوچک'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					wide => {
						nonleap => [
							'مسکرم',
							'تکیمت',
							'هیدار',
							'طه‌ساز',
							'تر',
							'یکوتیت',
							'مگابیت',
							'میازیا',
							'گین‌بوت',
							'سنه',
							'حمله',
							'نحسه',
							'پاگومه'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ژانویه',
							'فوریه',
							'مارس',
							'آوریل',
							'مه',
							'ژوئن',
							'ژوئیه',
							'اوت',
							'سپتامبر',
							'اکتبر',
							'نوامبر',
							'دسامبر'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ژانویهٔ',
							'فوریهٔ',
							'مارس',
							'آوریل',
							'مهٔ',
							'ژوئن',
							'ژوئیهٔ',
							'اوت',
							'سپتامبر',
							'اکتبر',
							'نوامبر',
							'دسامبر'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ژ',
							'ف',
							'م',
							'آ',
							'م',
							'ژ',
							'ژ',
							'ا',
							'س',
							'ا',
							'ن',
							'د'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ژانویه',
							'فوریه',
							'مارس',
							'آوریل',
							'مه',
							'ژوئن',
							'ژوئیه',
							'اوت',
							'سپتامبر',
							'اکتبر',
							'نوامبر',
							'دسامبر'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					wide => {
						nonleap => [
							'تشری',
							'حشوان',
							'کسلو',
							'طوت',
							'شباط',
							'آذار',
							'واذار',
							'نیسان',
							'ایار',
							'سیوان',
							'تموز',
							'آب',
							'ایلول'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ت',
							'ح',
							'ک',
							'ط',
							'ش',
							'آ',
							'و',
							'ن',
							'ا',
							'س',
							'ت',
							'آ',
							'ا'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'چیتره',
							'ویشاکهه',
							'جییشته',
							'آشادهه',
							'شراونه',
							'بهادره',
							'آشوین',
							'کارتیکه',
							'آگرهینه',
							'پاوشه',
							'ماگهه',
							'پهالگونه'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع‌الاول',
							'ربیع‌الثانی',
							'جمادی‌الاول',
							'جمادی‌الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذیقعده',
							'ذیحجه'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع‌الاول',
							'ربیع‌الثانی',
							'جمادی‌الاول',
							'جمادی‌الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذیقعده',
							'ذیحجه'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'م',
							'ص',
							'ر',
							'ر',
							'ج',
							'ج',
							'ر',
							'ش',
							'ر',
							'ش',
							'ذ',
							'ذ'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					wide => {
						nonleap => [
							'فروردین',
							'اردیبهشت',
							'خرداد',
							'تیر',
							'مرداد',
							'شهریور',
							'مهر',
							'آبان',
							'آذر',
							'دی',
							'بهمن',
							'اسفند'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ف',
							'ا',
							'خ',
							'ت',
							'م',
							'ش',
							'م',
							'آ',
							'آ',
							'د',
							'ب',
							'ا'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					short => {
						mon => '۲ش',
						tue => '۳ش',
						wed => '۴ش',
						thu => '۵ش',
						fri => 'ج',
						sat => 'ش',
						sun => '۱ش'
					},
					wide => {
						mon => 'دوشنبه',
						tue => 'سه‌شنبه',
						wed => 'چهارشنبه',
						thu => 'پنجشنبه',
						fri => 'جمعه',
						sat => 'شنبه',
						sun => 'یکشنبه'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'د',
						tue => 'س',
						wed => 'چ',
						thu => 'پ',
						fri => 'ج',
						sat => 'ش',
						sun => 'ی'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'س‌م۱',
						1 => 'س‌م۲',
						2 => 'س‌م۳',
						3 => 'س‌م۴'
					},
					wide => {0 => 'سه‌ماههٔ اول',
						1 => 'سه‌ماههٔ دوم',
						2 => 'سه‌ماههٔ سوم',
						3 => 'سه‌ماههٔ چهارم'
					},
				},
				'stand-alone' => {
					narrow => {0 => '۱',
						1 => '۲',
						2 => '۳',
						3 => '۴'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				last SWITCH;
				}
			if ($_ eq 'chinese') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				last SWITCH;
				}
			if ($_ eq 'japanese') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				last SWITCH;
				}
			if ($_ eq 'roc') {
				if($day_period_type eq 'default') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1300;
					return 'afternoon2' if $time >= 1300
						&& $time < 1900;
					return 'morning1' if $time >= 100
						&& $time < 400;
					return 'morning2' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{ظهر},
					'afternoon2' => q{عصر},
					'am' => q{ق.ظ.},
					'morning1' => q{بامداد},
					'morning2' => q{صبح},
					'night1' => q{شب},
					'night2' => q{نیمه‌شب},
					'pm' => q{ب.ظ.},
				},
				'narrow' => {
					'afternoon1' => q{ظ},
					'afternoon2' => q{ع},
					'am' => q{ق},
					'morning1' => q{ب},
					'morning2' => q{ص},
					'night1' => q{ش},
					'night2' => q{ن},
					'pm' => q{ب},
				},
				'wide' => {
					'afternoon1' => q{بعدازظهر},
					'afternoon2' => q{عصر},
					'am' => q{قبل‌ازظهر},
					'morning1' => q{بامداد},
					'morning2' => q{صبح},
					'night1' => q{شب},
					'night2' => q{نیمه‌شب},
					'pm' => q{بعدازظهر},
				},
			},
			'stand-alone' => {
				'narrow' => {
					'afternoon1' => q{ظ},
					'afternoon2' => q{ع},
					'am' => q{ق},
					'morning1' => q{ب},
					'morning2' => q{ص},
					'night1' => q{ش},
					'night2' => q{ن},
					'pm' => q{ب},
				},
				'wide' => {
					'am' => q{قبل‌ازظهر},
					'pm' => q{بعدازظهر},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'تقویم بودایی'
			},
		},
		'chinese' => {
		},
		'coptic' => {
			abbreviated => {
				'0' => 'قبل از مسیح',
				'1' => 'پس از مسیح'
			},
			narrow => {
				'0' => 'ق.م.',
				'1' => 'ب.م.'
			},
			wide => {
				'0' => 'قبل از حلول مسیح',
				'1' => 'بعد از حلول مسیح'
			},
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ق.م.',
				'1' => 'م.'
			},
			narrow => {
				'0' => 'ق',
				'1' => 'م'
			},
			wide => {
				'0' => 'قبل از میلاد',
				'1' => 'میلادی'
			},
		},
		'hebrew' => {
			abbreviated => {
				'0' => 'تقویم عبری'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'تقویم ساکا'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'ه‍.ق.'
			},
			wide => {
				'0' => 'هجری قمری'
			},
		},
		'japanese' => {
			abbreviated => {
				'235' => 'هیسی',
				'236' => 'ریوا'
			},
			narrow => {
				'235' => 'ه‍',
				'236' => 'ر'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'ه‍.ش.'
			},
			wide => {
				'0' => 'هجری شمسی'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'قبل از R.O.C.',
				'1' => 'تقویم مینگو'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE d MMMM y G},
			'long' => q{d MMMM y G},
			'medium' => q{d MMM y G},
			'short' => q{y/M/d GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE d MMMM y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{y/M/d},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
			'full' => q{EEEE d MMMM y G},
			'long' => q{d MMMM y G},
			'medium' => q{d MMM y G},
			'short' => q{y/M/d G},
		},
		'japanese' => {
		},
		'persian' => {
			'full' => q{y MMMM d, EEEE},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{y/M/d},
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{H:mm:ss (zzzz)},
			'long' => q{H:mm:ss (z)},
			'medium' => q{H:mm:ss},
			'short' => q{H:mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1}، ساعت {0}},
			'long' => q{{1}، ساعت {0}},
			'medium' => q{{1}،‏ {0}},
			'short' => q{{1}،‏ {0}},
		},
		'gregorian' => {
			'full' => q{{1}، ساعت {0}},
			'long' => q{{1}، ساعت {0}},
			'medium' => q{{1}،‏ {0}},
			'short' => q{{1}،‏ {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
			'full' => q{{1}، ساعت {0}},
			'long' => q{{1}، ساعت {0}},
		},
		'japanese' => {
		},
		'persian' => {
			'full' => q{{1}، ساعت {0}},
			'long' => q{{1}، ساعت {0}},
			'medium' => q{{1}،‏ {0}},
			'short' => q{{1}،‏ {0}},
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			EHm => q{E H:mm},
			EHms => q{E H:mm:ss},
			Ed => q{E dم},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E d MMM y G},
			GyMMMd => q{d MMM y G},
			GyMd => q{M/d/y GGGGG},
			H => q{H},
			HHmmZ => q{HH:mm (Z)},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			MEd => q{E M/d},
			MMMEd => q{E d LLL},
			MMMMEd => q{E d LLLL},
			MMMMd => q{d LLLL},
			MMMd => q{d LLL},
			Md => q{M/d},
			ms => q{m:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{y/M GGGGG},
			yyyyMEd => q{E y/M/d GGGGG},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E d MMM y G},
			yyyyMMMM => q{y MMMM G},
			yyyyMMMd => q{d MMM y G},
			yyyyMd => q{y/M/d GGGGG},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			EHm => q{E H:mm},
			EHms => q{E H:mm:ss},
			Ed => q{E d},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E d MMM y G},
			GyMMMd => q{d MMM y G},
			GyMd => q{y/M/d GGGGG},
			H => q{H},
			HHmmZ => q{HH:mm (Z)},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			Hmsv => q{H:mm:ss v},
			Hmv => q{H:mm v},
			MEd => q{E M/d},
			MMMEd => q{E d LLL},
			MMMMEd => q{E d LLLL},
			MMMMW => q{هفتهٔ Wم LLLL},
			MMMMd => q{d LLLL},
			MMMd => q{d LLL},
			Md => q{M/d},
			mmss => q{mm:ss},
			ms => q{m:ss},
			yM => q{y/M},
			yMEd => q{E y/M/d},
			yMMM => q{MMM y},
			yMMMEd => q{E d MMM y},
			yMMMM => q{MMMM y},
			yMMMMEEEEd => q{EEEE d MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{y/M/d},
			yQQQ => q{QQQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{هفتهٔ wم Y},
		},
		'islamic' => {
			HmZ => q{HH:mm (Z)},
			ms => q{mm:ss},
			yM => q{y/M G},
			yMEd => q{E y/M/d G},
			yMMM => q{MMM y},
			yMMMEd => q{E d MMM y},
			yMMMM => q{MMMM y},
			yQQQ => q{QQQ y G},
			yQQQQ => q{QQQQ y G},
			yyyyMMMM => q{MMMM y G},
		},
		'persian' => {
			y => q{y},
			yyyy => q{y},
			yyyyM => q{y/M},
			yyyyMEd => q{E y/M/d},
			yyyyMMM => q{MMM y},
			yyyyMMMEd => q{E d MMM y},
			yyyyMMMM => q{y MMMM},
			yyyyMMMd => q{d MMM y},
			yyyyMd => q{y/M/d},
			yyyyQQQ => q{QQQQ y},
			yyyyQQQQ => q{QQQQ y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'Day-Of-Week' => '{1} {0}',
			'Timezone' => '{0} ({1})',
		},
		'gregorian' => {
			'Day-Of-Week' => '{1} {0}',
			'Timezone' => '{0} ({1})',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => {
				B => q{h B تا h B},
				h => q{h تا h B},
			},
			Bhm => {
				B => q{h:mm B تا h:mm B},
				h => q{h:mm تا h:mm B},
				m => q{h:mm تا h:mm B},
			},
			Gy => {
				G => q{y G تا y G},
				y => q{y تا y G},
			},
			GyM => {
				G => q{y/M GGGGG تا y/M GGGGG},
				M => q{y/M تا y/M GGGGG},
				y => q{y/M تا y/M GGGGG},
			},
			GyMEd => {
				G => q{E y/M/d GGGGG تا E y/M/d GGGGG},
				M => q{E y/M/d تا E y/M/d GGGGG},
				d => q{E y/M/d تا E y/M/d GGGGG},
				y => q{E y/M/d تا E y/M/d GGGGG},
			},
			GyMMM => {
				G => q{MMM y G تا MMM y G},
				M => q{LLL تا MMM y G},
				y => q{MMM y تا MMM y G},
			},
			GyMMMEd => {
				G => q{E d MMM y G تا E d MMM y G},
				M => q{E d LLL تا E d MMM y G},
				d => q{E d LLL تا E d MMM y G},
				y => q{E d MMM y تا E d MMM y G},
			},
			GyMMMd => {
				G => q{d MMM y G تا d MMM y G},
				M => q{d LLL تا d MMM y G},
				d => q{d تا d MMM y G},
				y => q{d MMM y تا d MMM y G},
			},
			GyMd => {
				G => q{y/M/d GGGGG تا y/M/d GGGGG},
				M => q{y/M/d تا y/M/d GGGGG},
				d => q{y/M/d تا y/M/d GGGGG},
				y => q{y/M/d تا y/M/d GGGGG},
			},
			H => {
				H => q{H تا H},
			},
			Hm => {
				H => q{H:mm تا H:mm},
				m => q{H:mm تا H:mm},
			},
			Hmv => {
				H => q{H:mm تا H:mm (v)},
				m => q{H:mm تا H:mm (v)},
			},
			Hv => {
				H => q{H تا H (v)},
			},
			M => {
				M => q{M تا M},
			},
			MEd => {
				M => q{E M/d تا E M/d},
				d => q{E M/d تا E M/d},
			},
			MMM => {
				M => q{LLL تا LLL},
			},
			MMMEd => {
				M => q{E d LLL تا E d LLL},
				d => q{E d LLL تا E d LLL},
			},
			MMMd => {
				M => q{d LLL تا d LLL},
				d => q{d تا d LLL},
			},
			Md => {
				M => q{M/d تا M/d},
				d => q{M/d تا M/d},
			},
			d => {
				d => q{d تا d},
			},
			fallback => '{0} تا {1}',
			h => {
				a => q{h a تا h a},
				h => q{h تا h a},
			},
			hm => {
				a => q{h:mm a تا h:mm a},
				h => q{h:mm تا h:mm a},
				m => q{h:mm تا h:mm a},
			},
			hmv => {
				a => q{h:mm a تا h:mm a (v)},
				h => q{h:mm تا h:mm a (v)},
				m => q{h:mm تا h:mm a (v)},
			},
			hv => {
				a => q{h a تا h a (v)},
				h => q{h تا h a (v)},
			},
			y => {
				y => q{y تا y G},
			},
			yM => {
				M => q{y/M تا y/M GGGGG},
				y => q{y/M تا y/M GGGGG},
			},
			yMEd => {
				M => q{E y/M/d تا E y/M/d GGGGG},
				d => q{E y/M/d تا E y/M/d GGGGG},
				y => q{E y/M/d تا E y/M/d GGGGG},
			},
			yMMM => {
				M => q{LLL تا MMM y G},
				y => q{MMM y تا MMM y G},
			},
			yMMMEd => {
				M => q{E d LLL تا E d MMM y G},
				d => q{E d LLL تا E d MMM y G},
				y => q{E d MMM y تا E d MMM y G},
			},
			yMMMM => {
				M => q{LLLL تا MMMM y G},
				y => q{MMMM y تا MMMM y G},
			},
			yMMMd => {
				M => q{d LLL تا d MMM y G},
				d => q{d تا d MMM y G},
				y => q{d MMM y تا d MMM y G},
			},
			yMd => {
				M => q{y/M/d تا y/M/d GGGGG},
				d => q{y/M/d تا y/M/d GGGGG},
				y => q{y/M/d تا y/M/d GGGGG},
			},
		},
		'gregorian' => {
			Bh => {
				B => q{h B تا h B},
				h => q{h تا h B},
			},
			Bhm => {
				B => q{h:mm B تا h:mm B},
				h => q{h:mm تا h:mm B},
				m => q{h:mm تا h:mm B},
			},
			Gy => {
				G => q{y G تا y G},
				y => q{y تا y G},
			},
			GyM => {
				G => q{y/M GGGGG تا y/M GGGGG},
				M => q{y/M تا y/M GGGGG},
				y => q{y/M تا y/M GGGGG},
			},
			GyMEd => {
				G => q{E y/M/d GGGGG تا E y/M/d GGGGG},
				M => q{E y/M/d تا E y/M/d GGGGG},
				d => q{E y/M/d تا E y/M/d GGGGG},
				y => q{E y/M/d تا E y/M/d GGGGG},
			},
			GyMMM => {
				G => q{MMM y G تا MMM y G},
				M => q{LLL تا MMM y G},
				y => q{MMM y تا MMM y G},
			},
			GyMMMEd => {
				G => q{E d MMM y G تا E d MMM y G},
				M => q{E d LLL تا E d MMM y G},
				d => q{E d LLL تا E d MMM y G},
				y => q{E d MMM y تا E d MMM y G},
			},
			GyMMMd => {
				G => q{d MMM y G تا d MMM y G},
				M => q{d LLL تا d MMM y G},
				d => q{d تا d MMM y G},
				y => q{d MMM y تا d MMM y G},
			},
			GyMd => {
				G => q{y/M/d GGGGG تا y/M/d GGGGG},
				M => q{y/M/d تا y/M/d GGGGG},
				d => q{y/M/d تا y/M/d GGGGG},
				y => q{y/M/d تا y/M/d GGGGG},
			},
			H => {
				H => q{H تا H},
			},
			Hm => {
				H => q{H:mm تا H:mm},
				m => q{H:mm تا H:mm},
			},
			Hmv => {
				H => q{H:mm تا H:mm v},
				m => q{H:mm تا H:mm v},
			},
			Hv => {
				H => q{H تا H v},
			},
			M => {
				M => q{M تا M},
			},
			MEd => {
				M => q{E M/d تا E M/d},
				d => q{E M/d تا E M/d},
			},
			MMM => {
				M => q{LLL تا LLL},
			},
			MMMEd => {
				M => q{E d LLL تا E d LLL},
				d => q{E d LLL تا E d LLL},
			},
			MMMd => {
				M => q{d LLL تا d LLL},
				d => q{d تا d LLL},
			},
			Md => {
				M => q{M/d تا M/d},
				d => q{M/d تا M/d},
			},
			d => {
				d => q{d تا d},
			},
			fallback => '{0} تا {1}',
			h => {
				a => q{h a تا h a},
				h => q{h تا h a},
			},
			hm => {
				a => q{h:mm a تا h:mm a},
				h => q{h:mm تا h:mm a},
				m => q{h:mm تا h:mm a},
			},
			hmv => {
				a => q{h:mm a تا h:mm a v},
				h => q{h:mm تا h:mm a v},
				m => q{h:mm تا h:mm a v},
			},
			hv => {
				a => q{h a تا h a v},
				h => q{h تا h a v},
			},
			y => {
				y => q{y تا y},
			},
			yM => {
				M => q{y/M تا y/M},
				y => q{y/M تا y/M},
			},
			yMEd => {
				M => q{E y/M/d تا E y/M/d},
				d => q{E y/M/d تا E y/M/d},
				y => q{E y/M/d تا E y/M/d},
			},
			yMMM => {
				M => q{LLL تا MMM y},
				y => q{MMM y تا MMM y},
			},
			yMMMEd => {
				M => q{E d LLL تا E d MMM y},
				d => q{E d LLL تا E d MMM y},
				y => q{E d MMM y تا E d MMM y},
			},
			yMMMM => {
				M => q{LLLL تا MMMM y},
				y => q{MMMM y تا MMMM y},
			},
			yMMMd => {
				M => q{d LLL تا d MMM y},
				d => q{d تا d MMM y},
				y => q{d MMM y تا d MMM y},
			},
			yMd => {
				M => q{y/M/d تا y/M/d},
				d => q{y/M/d تا y/M/d},
				y => q{y/M/d تا y/M/d},
			},
		},
		'persian' => {
			y => {
				y => q{y تا y},
			},
			yM => {
				M => q{y/M تا y/M},
				y => q{y/M تا y/M},
			},
			yMEd => {
				M => q{E y/M/d تا E y/M/d},
				d => q{E y/M/d تا E y/M/d},
				y => q{E y/M/d تا E y/M/d},
			},
			yMMM => {
				M => q{LLL تا MMM y},
				y => q{MMM y تا MMM y},
			},
			yMMMEd => {
				M => q{E d LLL تا E d MMM y},
				d => q{E d LLL تا E d MMM y},
				y => q{E d MMM y تا E d MMM y},
			},
			yMMMM => {
				M => q{LLLL تا MMMM y},
				y => q{MMMM y تا MMMM y},
			},
			yMMMd => {
				M => q{d LLL تا d MMM y},
				d => q{d تا d MMM y},
				y => q{d MMM y تا d MMM y},
			},
			yMd => {
				M => q{y/M/d تا y/M/d},
				d => q{y/M/d تا y/M/d},
				y => q{y/M/d تا y/M/d},
			},
		},
	} },
);

has 'cyclic_name_sets' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
			'zodiacs' => {
				'format' => {
					'abbreviated' => {
						0 => q(موش),
						1 => q(گاو),
						2 => q(ببر),
						3 => q(خرگوش),
						4 => q(اژدها),
						5 => q(مار),
						6 => q(اسب),
						7 => q(بز),
						8 => q(میمون),
						9 => q(خروس),
						10 => q(سگ),
						11 => q(خوک),
					},
				},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(‎+HH:mm;‎−HH:mm),
		gmtFormat => q({0} گرینویچ),
		gmtZeroFormat => q(گرینویچ),
		regionFormat => q(وقت {0}),
		regionFormat => q(وقت تابستانی {0}),
		regionFormat => q(وقت عادی {0}),
		'Afghanistan' => {
			long => {
				'standard' => q#وقت افغانستان#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#آبیجان#,
		},
		'Africa/Accra' => {
			exemplarCity => q#اکرا#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#آدیس آبابا#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#الجزیره#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#اسمره#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#باماکو#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#بانگی#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#بانجول#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#بیسائو#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#بلانتیره#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#برازویل#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#بوجومبورا#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#قاهره#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#کازابلانکا#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#سبته#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#کوناکری#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#داکار#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#دارالسلام#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#جیبوتی#,
		},
		'Africa/Douala' => {
			exemplarCity => q#دوآلا#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#العیون#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#فری‌تاون#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#گابورون#,
		},
		'Africa/Harare' => {
			exemplarCity => q#هراره#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ژوهانسبورگ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#جوبا#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#کامپالا#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#خارطوم#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#کیگالی#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#کینشاسا#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#لاگوس#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#لیبرویل#,
		},
		'Africa/Lome' => {
			exemplarCity => q#لومه#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#لواندا#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#لوبومباشی#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#لوزاکا#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#مالابو#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ماپوتو#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ماسرو#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#مبابانه#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#موگادیشو#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#مونروویا#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#نایروبی#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#انجامنا#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#نیامی#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#نوآکشوت#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#اوآگادوگو#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#پورتو نووو#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#سائوتومه#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#طرابلس#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#تونس#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ویندهوک#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#وقت مرکز آفریقا#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#وقت شرق افریقا#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#وقت عادی جنوب افریقا#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#وقت تابستانی غرب افریقا#,
				'generic' => q#وقت غرب افریقا#,
				'standard' => q#وقت عادی غرب افریقا#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#وقت تابستانی آلاسکا#,
				'generic' => q#وقت آلاسکا#,
				'standard' => q#وقت عادی آلاسکا#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#وقت تابستانی آلماآتا#,
				'generic' => q#وقت آلماآتا#,
				'standard' => q#وقت عادی آلماآتا#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#وقت تابستانی آمازون#,
				'generic' => q#وقت آمازون#,
				'standard' => q#وقت عادی آمازون#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#ایدک#,
		},
		'America/Anchorage' => {
			exemplarCity => q#انکوریج#,
		},
		'America/Anguilla' => {
			exemplarCity => q#آنگوئیلا#,
		},
		'America/Antigua' => {
			exemplarCity => q#آنتیگوا#,
		},
		'America/Araguaina' => {
			exemplarCity => q#آراگواینا#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#لاریوخا#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ریوگالگوس#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#سالتا#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#سن‌خوان#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#سن‌لوئیس#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#توکومن#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#اوشوایا#,
		},
		'America/Aruba' => {
			exemplarCity => q#اروبا#,
		},
		'America/Asuncion' => {
			exemplarCity => q#آسونسیون#,
		},
		'America/Bahia' => {
			exemplarCity => q#بایا#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#باهیا باندراس#,
		},
		'America/Barbados' => {
			exemplarCity => q#باربادوس#,
		},
		'America/Belem' => {
			exemplarCity => q#بلم#,
		},
		'America/Belize' => {
			exemplarCity => q#بلیز#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#بلان‐سابلون#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#بوئاویستا#,
		},
		'America/Bogota' => {
			exemplarCity => q#بوگوتا#,
		},
		'America/Boise' => {
			exemplarCity => q#بویسی#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#بوئنوس‌آیرس#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#کمبریج‌بی#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#کمپو گرانده#,
		},
		'America/Cancun' => {
			exemplarCity => q#کانکون#,
		},
		'America/Caracas' => {
			exemplarCity => q#کاراکاس#,
		},
		'America/Catamarca' => {
			exemplarCity => q#کاتامارکا#,
		},
		'America/Cayenne' => {
			exemplarCity => q#کاین#,
		},
		'America/Cayman' => {
			exemplarCity => q#کیمن#,
		},
		'America/Chicago' => {
			exemplarCity => q#شیکاگو#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#چیواوا#,
		},
		'America/Ciudad_Juarez' => {
			exemplarCity => q#سیوداد خوارز#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#اتکوکان#,
		},
		'America/Cordoba' => {
			exemplarCity => q#کوردووا#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#کاستاریکا#,
		},
		'America/Creston' => {
			exemplarCity => q#کرستون#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#کویاوا#,
		},
		'America/Curacao' => {
			exemplarCity => q#کوراسائو#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#دانمارکس‌هاون#,
		},
		'America/Dawson' => {
			exemplarCity => q#داوسن#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#داوسن کریک#,
		},
		'America/Denver' => {
			exemplarCity => q#دنور#,
		},
		'America/Detroit' => {
			exemplarCity => q#دیترویت#,
		},
		'America/Dominica' => {
			exemplarCity => q#دومینیکا#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ادمونتون#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ایرونپه#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#السالوادور#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#فورت نلسون#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#فورتالزا#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#گلیس‌بی#,
		},
		'America/Godthab' => {
			exemplarCity => q#نووک#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#گوس‌بی#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#گراند تورک#,
		},
		'America/Grenada' => {
			exemplarCity => q#گرنادا#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#گوادلوپ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#گواتمالا#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#گوایاکیل#,
		},
		'America/Guyana' => {
			exemplarCity => q#گویان#,
		},
		'America/Halifax' => {
			exemplarCity => q#هلیفکس#,
		},
		'America/Havana' => {
			exemplarCity => q#هاوانا#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ارموسیو#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ناکس، ایندیانا#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#مارنگو، ایندیانا#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#پیترزبرگ، ایندیانا#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#تل‌سیتی، ایندیانا#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ویوی، ایندیانا#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#وینسنس، اندیانا#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ویناماک، ایندیانا#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ایندیاناپولیس#,
		},
		'America/Inuvik' => {
			exemplarCity => q#اینوویک#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ایکلوئت#,
		},
		'America/Jamaica' => {
			exemplarCity => q#جامائیکا#,
		},
		'America/Jujuy' => {
			exemplarCity => q#خوخوی#,
		},
		'America/Juneau' => {
			exemplarCity => q#جونو#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#مانتیسلو، کنتاکی#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#کرالندیک#,
		},
		'America/La_Paz' => {
			exemplarCity => q#لاپاز#,
		},
		'America/Lima' => {
			exemplarCity => q#لیما#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#لوس‌آنجلس#,
		},
		'America/Louisville' => {
			exemplarCity => q#لوئیزویل#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#بخش شاهزاده‌‌نشین پایین#,
		},
		'America/Maceio' => {
			exemplarCity => q#ماسیو#,
		},
		'America/Managua' => {
			exemplarCity => q#ماناگوا#,
		},
		'America/Manaus' => {
			exemplarCity => q#ماناوس#,
		},
		'America/Marigot' => {
			exemplarCity => q#ماریگات#,
		},
		'America/Martinique' => {
			exemplarCity => q#مارتینیک#,
		},
		'America/Matamoros' => {
			exemplarCity => q#ماتاموروس#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#ماساتلان#,
		},
		'America/Mendoza' => {
			exemplarCity => q#مندوسا#,
		},
		'America/Menominee' => {
			exemplarCity => q#منامینی#,
		},
		'America/Merida' => {
			exemplarCity => q#مریدا#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#متالاکاتلا#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#مکزیکوسیتی#,
		},
		'America/Miquelon' => {
			exemplarCity => q#میکلون#,
		},
		'America/Moncton' => {
			exemplarCity => q#مانکتون#,
		},
		'America/Monterrey' => {
			exemplarCity => q#مونتری#,
		},
		'America/Montevideo' => {
			exemplarCity => q#مونته‌ویدئو#,
		},
		'America/Montserrat' => {
			exemplarCity => q#مونتسرات#,
		},
		'America/Nassau' => {
			exemplarCity => q#ناسائو#,
		},
		'America/New_York' => {
			exemplarCity => q#نیویورک#,
		},
		'America/Nipigon' => {
			exemplarCity => q#نیپیگان#,
		},
		'America/Nome' => {
			exemplarCity => q#نوم#,
		},
		'America/Noronha' => {
			exemplarCity => q#نورونیا#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#بیولا، داکوتای شمالی#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#سنتر، داکوتای شمالی#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#نیوسالم، داکوتای شمالی#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#اخیناگا#,
		},
		'America/Panama' => {
			exemplarCity => q#پاناما#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#پانگنیرتونگ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#پاراماریبو#,
		},
		'America/Phoenix' => {
			exemplarCity => q#فینکس#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#پورتوپرنس#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#پورت‌آواسپین#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#پورتوولیو#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#پورتوریکو#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#پونتا آرناس#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#رینی‌ریور#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#خلیجک رنکین#,
		},
		'America/Recife' => {
			exemplarCity => q#ریسیفی#,
		},
		'America/Regina' => {
			exemplarCity => q#رجاینا#,
		},
		'America/Resolute' => {
			exemplarCity => q#رزولوت#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ریوبرانکو#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#سانتا ایزابل#,
		},
		'America/Santarem' => {
			exemplarCity => q#سنتارم#,
		},
		'America/Santiago' => {
			exemplarCity => q#سانتیاگو#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#سانتو دومینگو#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#سائوپائولو#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#اسکورسبیسوند#,
		},
		'America/Sitka' => {
			exemplarCity => q#سیتکا#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#سنت بارتلمی#,
		},
		'America/St_Johns' => {
			exemplarCity => q#سنت جان#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#سنت کیتس#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#سنت لوسیا#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#سنت توماس#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#سنت وینسنت#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#سویفت‌کارنت#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#تگوسیگالپا#,
		},
		'America/Thule' => {
			exemplarCity => q#تول#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#تاندربی#,
		},
		'America/Tijuana' => {
			exemplarCity => q#تیخوانا#,
		},
		'America/Toronto' => {
			exemplarCity => q#تورنتو#,
		},
		'America/Tortola' => {
			exemplarCity => q#تورتولا#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ونکوور#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#وایت‌هورس#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#وینیپگ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#یاکوتات#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#یلونایف#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#وقت تابستانی مرکز امریکا#,
				'generic' => q#وقت مرکز امریکا#,
				'standard' => q#وقت عادی مرکز امریکا#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#وقت تابستانی شرق امریکا#,
				'generic' => q#وقت شرق امریکا#,
				'standard' => q#وقت عادی شرق امریکا#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#وقت تابستانی کوهستانی امریکا#,
				'generic' => q#وقت کوهستانی امریکا#,
				'standard' => q#وقت عادی کوهستانی امریکا#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#وقت تابستانی غرب امریکا#,
				'generic' => q#وقت غرب امریکا#,
				'standard' => q#وقت عادی غرب امریکا#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#وقت تابستانی آنادیر#,
				'generic' => q#وقت آنادیر#,
				'standard' => q#وقت عادی آنادیر#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#کیسی#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#دیویس#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#دومون دورویل#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#مکواری#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ماوسون#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#مک‌موردو#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#پالمر#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#روترا#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#شووا#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ترول#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#وستوک#,
		},
		'Apia' => {
			long => {
				'daylight' => q#وقت تابستانی آپیا#,
				'generic' => q#وقت آپیا#,
				'standard' => q#وقت عادی آپیا#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#وقت تابستانی عربستان#,
				'generic' => q#وقت عربستان#,
				'standard' => q#وقت عادی عربستان#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#لانگ‌یربین#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#وقت تابستانی آرژانتین#,
				'generic' => q#وقت آرژانتین#,
				'standard' => q#وقت عادی آرژانتین#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#وقت تابستانی غرب آرژانتین#,
				'generic' => q#وقت غرب آرژانتین#,
				'standard' => q#وقت عادی غرب آرژانتین#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#وقت تابستانی ارمنستان#,
				'generic' => q#وقت ارمنستان#,
				'standard' => q#وقت عادی ارمنستان#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#عدن#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#آلماتی#,
		},
		'Asia/Amman' => {
			exemplarCity => q#عَمان#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#آنادیر#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#آقتاو#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#آقتوبه#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#عشق‌آباد#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#آتیراو#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#بغداد#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#بحرین#,
		},
		'Asia/Baku' => {
			exemplarCity => q#باکو#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#بانکوک#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#بارنائول#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#بیروت#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#بیشکک#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#برونئی#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#کلکته#,
		},
		'Asia/Chita' => {
			exemplarCity => q#چیتا#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#چویبالسان#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#کلمبو#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#دمشق#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#داکا#,
		},
		'Asia/Dili' => {
			exemplarCity => q#دیلی#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#دبی#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#دوشنبه#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#فاماگوستا#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#غزه#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#الخلیل#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#هنگ‌کنگ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#خوود#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ایرکوتسک#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#جاکارتا#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#جایاپورا#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#اورشلیم#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#کابل#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#کامچاتکا#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#کراچی#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#کاتماندو#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#خاندیگا#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#کراسنویارسک#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#کوالالامپور#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#کوچینگ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#کویت#,
		},
		'Asia/Macau' => {
			exemplarCity => q#ماکائو#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#ماگادان#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#ماکاسار#,
		},
		'Asia/Manila' => {
			exemplarCity => q#مانیل#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#مسقط#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#نیکوزیا#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#نوووکوزنتسک#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#نووسیبیریسک#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#اومسک#,
		},
		'Asia/Oral' => {
			exemplarCity => q#اورال#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#پنوم‌پن#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#پونتیاناک#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#پیونگ‌یانگ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#قطر#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#قوستانای#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#قیزیل‌اوردا#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#یانگون#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ریاض#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#هوشی‌مین‌سیتی#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ساخالین#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#سمرقند#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#سئول#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#شانگهای#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#سنگاپور#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#اسردنکولیمسک#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#تایپه#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#تاشکند#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#تفلیس#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#تهران#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#تیمفو#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#توکیو#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#تومسک#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#اولان‌باتور#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ارومچی#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#اوست نرا#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#وینتیان#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ولادی‌وستوک#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#یاکوتسک#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#یکاترینبرگ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ایروان#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#وقت تابستانی آتلانتیک#,
				'generic' => q#وقت آتلانتیک#,
				'standard' => q#وقت عادی آتلانتیک#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#آزور#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#برمودا#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#قناری#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#کیپ‌ورد#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#فارو#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#مادیرا#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ریکیاویک#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#جورجیای جنوبی#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#سنت هلنا#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#استانلی#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#آدلاید#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#بریسبین#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#بروکن‌هیل#,
		},
		'Australia/Currie' => {
			exemplarCity => q#کوری#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#داروین#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#اوکلا#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#هوبارت#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#لیندمن#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#لردهاو#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ملبورن#,
		},
		'Australia/Perth' => {
			exemplarCity => q#پرت#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#سیدنی#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#وقت تابستانی مرکز استرالیا#,
				'generic' => q#وقت مرکز استرالیا#,
				'standard' => q#وقت عادی مرکز استرالیا#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#وقت تابستانی مرکز-غرب استرالیا#,
				'generic' => q#وقت مرکز-غرب استرالیا#,
				'standard' => q#وقت عادی مرکز-غرب استرالیا#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#وقت تابستانی شرق استرالیا#,
				'generic' => q#وقت شرق استرالیا#,
				'standard' => q#وقت عادی شرق استرالیا#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#وقت تابستانی غرب استرالیا#,
				'generic' => q#وقت غرب استرالیا#,
				'standard' => q#وقت عادی غرب استرالیا#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#وقت تابستانی جمهوری آذربایجان#,
				'generic' => q#وقت جمهوری آذربایجان#,
				'standard' => q#وقت عادی جمهوری آذربایجان#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#وقت تابستانی آزور#,
				'generic' => q#وقت آزور#,
				'standard' => q#وقت عادی آزور#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#وقت تابستانی بنگلادش#,
				'generic' => q#وقت بنگلادش#,
				'standard' => q#وقت عادی بنگلادش#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#وقت بوتان#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#وقت بولیوی#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#وقت تابستانی برازیلیا#,
				'generic' => q#وقت برازیلیا#,
				'standard' => q#وقت عادی برازیلیا#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#وقت برونئی دارالسلام#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#وقت تابستانی کیپ‌ورد#,
				'generic' => q#وقت کیپ‌ورد#,
				'standard' => q#وقت عادی کیپ‌ورد#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#وقت عادی چامورو#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#وقت تابستانی چت‌هام#,
				'generic' => q#وقت چت‌هام#,
				'standard' => q#وقت عادی چت‌هام#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#وقت تابستانی شیلی#,
				'generic' => q#وقت شیلی#,
				'standard' => q#وقت عادی شیلی#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#وقت تابستانی چین#,
				'generic' => q#وقت چین#,
				'standard' => q#وقت عادی چین#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#وقت تابستانی چویبالسان#,
				'generic' => q#وقت چویبالسان#,
				'standard' => q#وقت عادی چویبالسان#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#وقت جزیرهٔ کریسمس#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#وقت جزایر کوکوس#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#وقت تابستانی کلمبیا#,
				'generic' => q#وقت کلمبیا#,
				'standard' => q#وقت عادی کلمبیا#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#وقت تابستانی جزایر کوک#,
				'generic' => q#وقت جزایر کوک#,
				'standard' => q#وقت عادی جزایر کوک#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#وقت تابستانی کوبا#,
				'generic' => q#وقت کوبا#,
				'standard' => q#وقت عادی کوبا#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#وقت دیویس#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#وقت دومون دورویل#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#وقت تیمور شرقی#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#وقت تابستانی جزیرهٔ ایستر#,
				'generic' => q#وقت جزیرهٔ ایستر#,
				'standard' => q#وقت عادی جزیرهٔ ایستر#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#وقت اکوادور#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#زمان هماهنگ جهانی#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#شهر نامشخص#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#آمستردام#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#آندورا#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#آستراخان#,
		},
		'Europe/Athens' => {
			exemplarCity => q#آتن#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#بلگراد#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#برلین#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#براتیسلاوا#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#بروکسل#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#بخارست#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#بوداپست#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#بازنگن#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#کیشیناو#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#کپنهاگ#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#دوبلین#,
			long => {
				'daylight' => q#وقت عادی ایرلند#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#جبل‌الطارق#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#گرنزی#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#هلسینکی#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#جزیرهٔ من#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#استانبول#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#جرزی#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#کالینینگراد#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#کیف#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#کیروف#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#لیسبون#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#لیوبلیانا#,
		},
		'Europe/London' => {
			exemplarCity => q#لندن#,
			long => {
				'daylight' => q#وقت تابستانی بریتانیا#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#لوکزامبورگ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#مادرید#,
		},
		'Europe/Malta' => {
			exemplarCity => q#مالت#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ماریه‌هامن#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#مینسک#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#موناکو#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#مسکو#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#اسلو#,
		},
		'Europe/Paris' => {
			exemplarCity => q#پاریس#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#پادگاریتسا#,
		},
		'Europe/Prague' => {
			exemplarCity => q#پراگ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ریگا#,
		},
		'Europe/Rome' => {
			exemplarCity => q#رم#,
		},
		'Europe/Samara' => {
			exemplarCity => q#سامارا#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#سان‌مارینو#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#سارایوو#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#ساراتوف#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#سیمفروپل#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#اسکوپیه#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#صوفیه#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#استکهلم#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#تالین#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#تیرانا#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#اولیانوفسک#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#اوژگورود#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#فادوتس#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#واتیکان#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#وین#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ویلنیوس#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ولگاگراد#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ورشو#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#زاگرب#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#زاپوروژیا#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#زوریخ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#وقت تابستانی مرکز اروپا#,
				'generic' => q#وقت مرکز اروپا#,
				'standard' => q#وقت عادی مرکز اروپا#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#وقت تابستانی شرق اروپا#,
				'generic' => q#وقت شرق اروپا#,
				'standard' => q#وقت عادی شرق اروپا#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#وقت تابستانی مکان‌های دیگر شرق اروپا#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#وقت تابستانی غرب اروپا#,
				'generic' => q#وقت غرب اروپا#,
				'standard' => q#وقت عادی غرب اروپا#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#وقت تابستانی جزایر فالکلند#,
				'generic' => q#وقت جزایر فالکلند#,
				'standard' => q#وقت عادی جزایر فالکلند#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#وقت تابستانی فیجی#,
				'generic' => q#وقت فیجی#,
				'standard' => q#وقت عادی فیجی#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#وقت گویان فرانسه#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#وقت سرزمین‌های جنوبی و جنوبگان فرانسه#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#وقت گرینویچ#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#وقت گالاپاگوس#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#وقت گامبیه#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#وقت تابستانی گرجستان#,
				'generic' => q#وقت گرجستان#,
				'standard' => q#وقت عادی گرجستان#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#وقت جزایر گیلبرت#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#وقت تابستانی شرق گرینلند#,
				'generic' => q#وقت شرق گرینلند#,
				'standard' => q#وقت عادی شرق گرینلند#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#وقت تابستانی غرب گرینلند#,
				'generic' => q#وقت غرب گرینلند#,
				'standard' => q#وقت عادی غرب گرینلند#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#وقت عادی گوام#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#وقت عادی خلیج فارس#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#وقت گویان#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#وقت تابستانی هاوایی‐الوشن#,
				'generic' => q#وقت هاوایی‐الوشن#,
				'standard' => q#وقت عادی هاوایی‐الوشن#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#وقت تابستانی هنگ‌کنگ#,
				'generic' => q#وقت هنگ‌کنگ#,
				'standard' => q#وقت عادی هنگ‌کنگ#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#وقت تابستانی خوود#,
				'generic' => q#وقت خوود#,
				'standard' => q#وقت عادی خوود#,
			},
		},
		'India' => {
			long => {
				'standard' => q#وقت هند#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#آنتاناناریوو#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#شاگوس#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#کریسمس#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#کوکوس#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#کومورو#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#کرگولن#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ماهه#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#مالدیو#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#موریس#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#مایوت#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#رئونیون#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#وقت اقیانوس هند#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#وقت هندوچین#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#وقت مرکز اندونزی#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#وقت شرق اندونزی#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#وقت غرب اندونزی#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#وقت تابستانی ایران#,
				'generic' => q#وقت ایران#,
				'standard' => q#وقت عادی ایران#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#وقت تابستانی ایرکوتسک#,
				'generic' => q#وقت ایرکوتسک#,
				'standard' => q#وقت عادی ایرکوتسک#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#وقت تابستانی اسرائیل#,
				'generic' => q#وقت اسرائیل#,
				'standard' => q#وقت عادی اسرائیل#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#وقت تابستانی ژاپن#,
				'generic' => q#وقت ژاپن#,
				'standard' => q#وقت عادی ژاپن#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#وقت تابستانی پتروپاولوسک‐کامچاتسکی#,
				'generic' => q#وقت پتروپاولوسک‐کامچاتسکی#,
				'standard' => q#وقت عادی پتروپاولوسک‐کامچاتسکی#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#وقت شرق قزاقستان#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#وقت غرب قزاقستان#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#وقت تابستانی کره#,
				'generic' => q#وقت کره#,
				'standard' => q#وقت عادی کره#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#وقت کوسرای#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#وقت تابستانی کراسنویارسک#,
				'generic' => q#وقت کراسنویارسک#,
				'standard' => q#وقت عادی کراسنویارسک#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#وقت قرقیزستان#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#وقت لانکا#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#وقت جزایر لاین#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#وقت تابستانی لردهو#,
				'generic' => q#وقت لردهو#,
				'standard' => q#وقت عادی لردهو#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#وقت تابستانی ماکائو#,
				'generic' => q#وقت ماکائو#,
				'standard' => q#وقت عادی ماکائو#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#وقت جزیرهٔ مکواری#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#وقت تابستانی ماگادان#,
				'generic' => q#وقت ماگادان#,
				'standard' => q#وقت عادی ماگادان#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#وقت مالزی#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#وقت مالدیو#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#وقت مارکوئز#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#وقت جزایر مارشال#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#وقت تابستانی موریس#,
				'generic' => q#وقت موریس#,
				'standard' => q#وقت عادی موریس#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#وقت ماوسون#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#وقت تابستانی شمال غرب مکزیک#,
				'generic' => q#وقت شمال غرب مکزیک#,
				'standard' => q#وقت عادی شمال غرب مکزیک#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#وقت تابستانی شرق مکزیک#,
				'generic' => q#وقت شرق مکزیک#,
				'standard' => q#وقت عادی شرق مکزیک#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#وقت تابستانی اولان‌باتور#,
				'generic' => q#وقت اولان‌باتور#,
				'standard' => q#وقت عادی اولان‌باتور#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#وقت تابستانی مسکو#,
				'generic' => q#وقت مسکو#,
				'standard' => q#وقت عادی مسکو#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#وقت میانمار#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#وقت نائورو#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#وقت نپال#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#وقت تابستانی کالدونیای جدید#,
				'generic' => q#وقت کالدونیای جدید#,
				'standard' => q#وقت عادی کالدونیای جدید#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#وقت تابستانی نیوزیلند#,
				'generic' => q#وقت نیوزیلند#,
				'standard' => q#وقت عادی نیوزیلند#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#وقت تابستانی نیوفاندلند#,
				'generic' => q#وقت نیوفاندلند#,
				'standard' => q#وقت عادی نیوفاندلند#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#وقت نیوئه#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#وقت تابستانی جزیرهٔ نورفولک#,
				'generic' => q#وقت جزیرهٔ نورفولک#,
				'standard' => q#وقت عادی جزیرهٔ نورفولک#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#وقت تابستانی فرناندو دی نورونیا#,
				'generic' => q#وقت فرناندو دی نورونیا#,
				'standard' => q#وقت عادی فرناندو دی نورونیا#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#وقت جزایر ماریانای شمالی#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#وقت تابستانی نووسیبیرسک#,
				'generic' => q#وقت نووسیبیرسک#,
				'standard' => q#وقت عادی نووسیبیرسک#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#وقت تابستانی اومسک#,
				'generic' => q#وقت اومسک#,
				'standard' => q#وقت عادی اومسک#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#آپیا#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#اوکلند#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#بوگنویل#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#چتم#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ایستر#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#افاته#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#اندربری#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#فاکائوفو#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#فیجی#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#فونافوتی#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#گالاپاگوس#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#گامبیر#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#گوادال‌کانال#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#گوام#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#هونولولو#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#جانستون#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#کانتون#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#کریتیماتی#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#کوسرای#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#کواجیلین#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#ماجورو#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#مارکوزه#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#میدوی#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#نائورو#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#نیوئه#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#نورفولک#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#نومئا#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#پاگوپاگو#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#پالائو#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#پیت‌کرن#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#پانپی#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#پورت‌مورزبی#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#راروتونگا#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#سایپان#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#تاهیتی#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#تاراوا#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#تونگاتاپو#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#چوک#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ویک#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#والیس#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#وقت تابستانی پاکستان#,
				'generic' => q#وقت پاکستان#,
				'standard' => q#وقت عادی پاکستان#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#وقت پالائو#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#وقت پاپوا گینهٔ نو#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#وقت تابستانی پاراگوئه#,
				'generic' => q#وقت پاراگوئه#,
				'standard' => q#وقت عادی پاراگوئه#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#وقت تابستانی پرو#,
				'generic' => q#وقت پرو#,
				'standard' => q#وقت عادی پرو#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#وقت تابستانی فیلیپین#,
				'generic' => q#وقت فیلیپین#,
				'standard' => q#وقت عادی فیلیپین#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#وقت جزایر فونیکس#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#وقت تابستانی سنت‌پیر و میکلون#,
				'generic' => q#وقت سنت‌پیر و میکلون#,
				'standard' => q#وقت عادی سنت‌پیر و میکلون#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#وقت پیتکایرن#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#وقت پوناپه#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#وقت پیونگ‌یانگ#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#وقت تابستانی قیزیل‌اوردا#,
				'generic' => q#وقت قیزیل‌اوردا#,
				'standard' => q#وقت عادی قیزیل‌اوردا#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#وقت رئونیون#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#وقت روترا#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#وقت تابستانی ساخالین#,
				'generic' => q#وقت ساخالین#,
				'standard' => q#وقت عادی ساخالین#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#وقت تابستانی سامارا#,
				'generic' => q#وقت سامارا#,
				'standard' => q#وقت عادی سامارا#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#وقت تابستانی ساموا#,
				'generic' => q#وقت ساموا#,
				'standard' => q#وقت عادی ساموا#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#وقت سیشل#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#وقت سنگاپور#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#وقت جزایر سلیمان#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#وقت جورجیای جنوبی#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#وقت سورینام#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#وقت شووا#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#وقت تاهیتی#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#وقت تابستانی تایپه#,
				'generic' => q#وقت تایپه#,
				'standard' => q#وقت عادی تایپه#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#وقت تاجیکستان#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#وقت توکلائو#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#وقت تابستانی تونگا#,
				'generic' => q#وقت تونگا#,
				'standard' => q#وقت عادی تونگا#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#وقت چوئوک#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#وقت تابستانی ترکمنستان#,
				'generic' => q#وقت ترکمنستان#,
				'standard' => q#وقت عادی ترکمنستان#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#وقت تووالو#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#وقت تابستانی اروگوئه#,
				'generic' => q#وقت اروگوئه#,
				'standard' => q#وقت عادی اروگوئه#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#وقت تابستانی ازبکستان#,
				'generic' => q#وقت ازبکستان#,
				'standard' => q#وقت عادی ازبکستان#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#وقت تابستانی واناتو#,
				'generic' => q#وقت واناتو#,
				'standard' => q#وقت عادی واناتو#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#وقت ونزوئلا#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#وقت تابستانی ولادی‌وستوک#,
				'generic' => q#وقت ولادی‌وستوک#,
				'standard' => q#وقت عادی ولادی‌وستوک#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#وقت تابستانی ولگاگراد#,
				'generic' => q#وقت ولگاگراد#,
				'standard' => q#وقت عادی ولگاگراد#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#وقت وستوک#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#وقت جزیرهٔ ویک#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#وقت والیس و فوتونا#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#وقت تابستانی یاکوتسک#,
				'generic' => q#وقت یاکوتسک#,
				'standard' => q#وقت عادی یاکوتسک#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#وقت تابستانی یکاترینبورگ#,
				'generic' => q#وقت یکاترینبورگ#,
				'standard' => q#وقت عادی یکاترینبورگ#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#وقت یوکان#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
