#!/usr/bin/perl
# Do not normalise this test file. It has deliberately unnormalised characters in it.
use v5.10;
use strict;
use warnings;
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Test::More tests => 25;
use Test::Exception;

use ok 'Locale::CLDR';

my $locale = Locale::CLDR->new('cy_GB');
my $other_locale = Locale::CLDR->new('en_US');

is($locale->locale_name(), 'Cymraeg (Y Deyrnas Unedig)', 'Locale name from current locale');
is($locale->locale_name('fr_CA'), 'Ffrangeg Canada', 'Locale name from string');
is($locale->locale_name($other_locale), 'Saesneg America', 'Locale name from other locale object');

is($locale->language_name(), 'Cymraeg', 'Language name from current locale');
is($locale->language_name('en'), 'Saesneg', 'Language name from string');
is($locale->language_name($other_locale), 'Saesneg', 'Language name from other locale object');

my $all_languages = {
	'aa' => 'Affareg',
	'ab' => 'Abchaseg',
	'ace' => 'Acehneg',
	'ach' => 'Acoli',
	'ada' => 'Adangmeg',
	'ady' => 'Circaseg Gorllewinol',
	'ae' => 'Afestaneg',
	'aeb' => 'Arabeg Tunisia',
	'af' => 'Affricâneg',
	'afh' => 'Affrihili',
	'agq' => 'Aghemeg',
	'ain' => 'Ainŵeg',
	'ak' => 'Acaneg',
	'akk' => 'Acadeg',
	'akz' => 'Alabamäeg',
	'ale' => 'Alewteg',
	'aln' => 'Ghegeg Albania',
	'alt' => 'Altäeg Deheuol',
	'am' => 'Amhareg',
	'an' => 'Aragoneg',
	'ang' => 'Hen Saesneg',
	'anp' => 'Angika',
	'ar' => 'Arabeg',
	'ar_001' => 'Arabeg Modern Safonol',
	'arc' => 'Aramaeg',
	'arn' => 'Arawcaneg',
	'aro' => 'Araonaeg',
	'arp' => 'Arapaho',
	'arq' => 'Arabeg Algeria',
	'arw' => 'Arawaceg',
	'ary' => 'Arabeg Moroco',
	'arz' => 'Arabeg yr Aifft',
	'as' => 'Asameg',
	'asa' => 'Asw',
	'ase' => 'Iaith Arwyddion America',
	'ast' => 'Astwrianeg',
	'av' => 'Afareg',
	'awa' => 'Awadhi',
	'ay' => 'Aymareg',
	'az' => 'Aserbaijaneg',
	'az@alt=short' => 'Aseri',
	'az_Arab' => 'Aserbaijaneg Deheuol',
	'ba' => 'Bashcorteg',
	'bal' => 'Balwtsi',
	'ban' => 'Balïeg',
	'bas' => 'Basâeg',
	'bax' => 'Bamwmeg',
	'be' => 'Belarwseg',
	'bej' => 'Bejäeg',
	'bem' => 'Bembeg',
	'bez' => 'Bena',
	'bfd' => 'Baffwteg',
	'bfq' => 'Badaga',
	'bg' => 'Bwlgareg',
	'bgn' => 'Balochi Gorllewinol',
	'bho' => 'Bhojpuri',
	'bi' => 'Bislama',
	'bin' => 'Bini',
	'bkm' => 'Comeg',
	'bla' => 'Siksika',
	'bm' => 'Bambareg',
	'bn' => 'Bengaleg',
	'bo' => 'Tibeteg',
	'br' => 'Llydaweg',
	'brh' => 'Brahui',
	'brx' => 'Bodo',
	'bs' => 'Bosnieg',
	'bss' => 'Acwseg',
	'bua' => 'Bwriateg',
	'bug' => 'Bwginaeg',
	'bum' => 'Bwlw',
	'byn' => 'Blin',
	'ca' => 'Catalaneg',
	'cad' => 'Cado',
	'car' => 'Caribeg',
	'cch' => 'Atsameg',
	'ccp' => 'Tsiacma',
	'ce' => 'Tsietsieneg',
	'ceb' => 'Cebuano',
	'cgg' => 'Tsiga',
	'ch' => 'Tsiamorro',
	'chk' => 'Chuukaeg',
	'chm' => 'Marieg',
	'cho' => 'Siocto',
	'chr' => 'Tsierocî',
	'chy' => 'Cheyenne',
	'ckb' => 'Cwrdeg Sorani',
	'co' => 'Corseg',
	'cop' => 'Copteg',
	'cr' => 'Cri',
	'crh' => 'Tyrceg y Crimea',
	'crs' => 'Ffrangeg Seselwa Creole',
	'cs' => 'Tsieceg',
	'cu' => 'Hen Slafoneg',
	'cv' => 'Tshwfasheg',
	'cy' => 'Cymraeg',
	'da' => 'Daneg',
	'dak' => 'Dacotaeg',
	'dar' => 'Dargwa',
	'dav' => 'Taita',
	'de' => 'Almaeneg',
	'de_AT' => 'Almaeneg Awstria',
	'de_CH' => 'Almaeneg Safonol y Swistir',
	'dgr' => 'Dogrib',
	'din' => 'Dinca',
	'dje' => 'Sarmaeg',
	'doi' => 'Dogri',
	'dsb' => 'Sorbeg Isaf',
	'dua' => 'Diwaleg',
	'dum' => 'Iseldireg Canol',
	'dv' => 'Difehi',
	'dyo' => 'Jola-Fonyi',
	'dz' => 'Dzongkha',
	'dzg' => 'Dazaga',
	'ebu' => 'Embw',
	'ee' => 'Ewe',
	'efi' => 'Efik',
	'egy' => 'Hen Eiffteg',
	'eka' => 'Ekajuk',
	'el' => 'Groeg',
	'elx' => 'Elameg',
	'en' => 'Saesneg',
	'en_AU' => 'Saesneg Awstralia',
	'en_CA' => 'Saesneg Canada',
	'en_GB' => 'Saesneg Prydain',
	'en_US' => 'Saesneg America',
	'enm' => 'Saesneg Canol',
	'eo' => 'Esperanto',
	'es' => 'Sbaeneg',
	'es_419' => 'Sbaeneg America Ladin',
	'es_ES' => 'Sbaeneg Ewrop',
	'es_MX' => 'Sbaeneg Mecsico',
	'et' => 'Estoneg',
	'eu' => 'Basgeg',
	'ewo' => 'Ewondo',
	'ext' => 'Extremadureg',
	'fa' => 'Perseg',
	'fa_AF' => 'Dari',
	'fat' => 'Ffanti',
	'ff' => 'Ffwla',
	'fi' => 'Ffinneg',
	'fil' => 'Ffilipineg',
	'fit' => 'Ffinneg Tornedal',
	'fj' => 'Ffijïeg',
	'fo' => 'Ffaröeg',
	'fon' => 'Fon',
	'fr' => 'Ffrangeg',
	'fr_CA' => 'Ffrangeg Canada',
	'fr_CH' => 'Ffrangeg y Swistir',
	'frc' => 'Ffrangeg Cajwn',
	'frm' => 'Ffrangeg Canol',
	'fro' => 'Hen Ffrangeg',
	'frp' => 'Arpitaneg',
	'frr' => 'Ffriseg Gogleddol',
	'frs' => 'Ffriseg y Dwyrain',
	'fur' => 'Ffriwleg',
	'fy' => 'Ffriseg y Gorllewin',
	'ga' => 'Gwyddeleg',
	'gaa' => 'Ga',
	'gag' => 'Gagauz',
	'gay' => 'Gaio',
	'gba' => 'Gbaia',
	'gbz' => 'Dareg y Zoroastriaid',
	'gez' => 'Geez',
	'gd' => 'Gaeleg yr Alban',
	'gil' => 'Gilberteg',
	'gl' => 'Galisieg',
	'gmh' => 'Almaeneg Uchel Canol',
	'gn' => 'Guaraní',
	'goh' => 'Hen Almaeneg Uchel',
	'gor' => 'Gorontalo',
	'got' => 'Gotheg',
	'grc' => 'Hen Roeg',
	'gsw' => 'Almaeneg y Swistir',
	'gu' => 'Gwjarati',
	'guz' => 'Gusii',
	'gv' => 'Manaweg',
	'gwi' => 'Gwichʼin',
	'ha' => 'Hawsa',
	'hai' => 'Haida',
	'haw' => 'Hawäieg',
	'he' => 'Hebraeg',
	'hi' => 'Hindi',
	'hil' => 'Hiligaynon',
	'hit' => 'Hetheg',
	'hmn' => 'Hmongeg',
	'hr' => 'Croateg',
	'hsb' => 'Sorbeg Uchaf',
	'ht' => 'Creol Haiti',
	'hu' => 'Hwngareg',
	'hup' => 'Hupa',
	'hy' => 'Armeneg',
	'hz' => 'Herero',
	'ia' => 'Interlingua',
	'iba' => 'Ibaneg',
	'ibb' => 'Ibibio',
	'id' => 'Indoneseg',
	'ie' => 'Interlingue',
	'ig' => 'Igbo',
	'ii' => 'Nwosw',
	'ik' => 'Inwpiaceg',
	'ilo' => 'Ilocaneg',
	'inh' => 'Ingwsieg',
	'io' => 'Ido',
	'is' => 'Islandeg',
	'it' => 'Eidaleg',
	'iu' => 'Inwctitwt',
	'ja' => 'Japaneeg',
	'jbo' => 'Lojban',
	'jgo' => 'Ngomba',
	'jmc' => 'Matsiame',
	'jpr' => 'Iddew-Bersieg',
	'jrb' => 'Iddew-Arabeg',
	'jv' => 'Jafanaeg',
	'ka' => 'Georgeg',
	'kaa' => 'Cara-Calpaceg',
	'kab' => 'Cabileg',
	'kac' => 'Kachin',
	'kaj' => 'Jju',
	'kam' => 'Camba',
	'kbd' => 'Cabardieg',
	'kcg' => 'Tyapeg',
	'kde' => 'Macondeg',
	'kea' => 'Caboferdianeg',
	'kfo' => 'Koro',
	'kg' => 'Congo',
	'kha' => 'Càseg',
	'khq' => 'Koyra Chiini',
	'khw' => 'Chowareg',
	'ki' => 'Kikuyu',
	'kj' => 'Kuanyama',
	'kk' => 'Casacheg',
	'kkj' => 'Kako',
	'kl' => 'Kalaallisut',
	'kln' => 'Kalenjin',
	'km' => 'Chmereg',
	'kmb' => 'Kimbundu',
	'kn' => 'Kannada',
	'ko' => 'Coreeg',
	'koi' => 'Komi-Permyak',
	'kok' => 'Concani',
	'kpe' => 'Kpelle',
	'kr' => 'Canwri',
	'krc' => 'Karachay-Balkar',
	'krl' => 'Careleg',
	'kru' => 'Kurukh',
	'ks' => 'Cashmireg',
	'ksb' => 'Shambala',
	'ksf' => 'Baffia',
	'ksh' => 'Cwleneg',
	'ku' => 'Cwrdeg',
	'kum' => 'Cwmiceg',
	'kv' => 'Comi',
	'kw' => 'Cernyweg',
	'ky' => 'Cirgiseg',
	'la' => 'Lladin',
	'lad' => 'Iddew-Sbaeneg',
	'lag' => 'Langi',
	'lah' => 'Lahnda',
	'lam' => 'Lamba',
	'lb' => 'Lwcsembwrgeg',
	'lez' => 'Lezgheg',
	'lg' => 'Ganda',
	'li' => 'Limbwrgeg',
	'lkt' => 'Lakota',
	'lmo' => 'Lombardeg',
	'ln' => 'Lingala',
	'lo' => 'Laoeg',
	'lol' => 'Mongo',
	'loz' => 'Lozi',
	'lrc' => 'Luri Gogleddol',
	'lt' => 'Lithwaneg',
	'ltg' => 'Latgaleg',
	'lu' => 'Luba-Katanga',
	'lua' => 'Luba-Lulua',
	'lun' => 'Lwnda',
	'luo' => 'Lŵo',
	'lus' => 'Lwshaieg',
	'luy' => 'Lwyia',
	'lv' => 'Latfieg',
	'mad' => 'Madwreg',
	'mag' => 'Magahi',
	'mai' => 'Maithili',
	'mak' => 'Macasareg',
	'man' => 'Mandingo',
	'mas' => 'Masai',
	'mdf' => 'Mocsia',
	'mdr' => 'Mandareg',
	'men' => 'Mendeg',
	'mer' => 'Mêrw',
	'mfe' => 'Morisyen',
	'mg' => 'Malagaseg',
	'mga' => 'Gwyddeleg Canol',
	'mgh' => 'Makhuwa-Meetto',
	'mgo' => 'Meta',
	'mh' => 'Marsialeg',
	'mi' => 'Māori',
	'mic' => 'Micmaceg',
	'min' => 'Minangkabau',
	'mk' => 'Macedoneg',
	'ml' => 'Malayalam',
	'mn' => 'Mongoleg',
	'mnc' => 'Manshw',
	'mni' => 'Manipwri',
	'moh' => 'Mohoceg',
	'mos' => 'Mosi',
	'mr' => 'Marathi',
	'mrj' => 'Mari Gorllewinol',
	'ms' => 'Maleieg',
	'mt' => 'Malteg',
	'mua' => 'Mundang',
	'mul' => 'Mwy nag un iaith',
	'mus' => 'Creek',
	'mwl' => 'Mirandeg',
	'mwr' => 'Marwari',
	'my' => 'Byrmaneg',
	'myv' => 'Erzya',
	'mzn' => 'Masanderani',
	'na' => 'Nawrŵeg',
	'nap' => 'Naplieg',
	'naq' => 'Nama',
	'nb' => 'Norwyeg Bokmål',
	'nd' => 'Ndebele Gogleddol',
	'nds' => 'Almaeneg Isel',
	'nds_NL' => 'Sacsoneg Isel',
	'ne' => 'Nepaleg',
	'new' => 'Newaeg',
	'ng' => 'Ndonga',
	'nia' => 'Nias',
	'niu' => 'Niuean',
	'njo' => 'Ao Naga',
	'nl' => 'Iseldireg',
	'nl_BE' => 'Fflemeg',
	'nmg' => 'Kwasio',
	'nn' => 'Norwyeg Nynorsk',
	'nnh' => 'Ngiemboon',
	'no' => 'Norwyeg',
	'nog' => 'Nogai',
	'non' => 'Hen Norseg',
	'nqo' => 'N’Ko',
	'nr' => 'Ndebele Deheuol',
	'nso' => 'Sotho Gogleddol',
	'nus' => 'Nŵereg',
	'nv' => 'Nafaho',
	'nwc' => 'Hen Newari',
	'ny' => 'Nianja',
	'nym' => 'Niamwezi',
	'nyn' => 'Niancole',
	'nyo' => 'Nioro',
	'nzi' => 'Nzimeg',
	'oc' => 'Ocsitaneg',
	'oj' => 'Ojibwa',
	'om' => 'Oromo',
	'or' => 'Odia',
	'os' => 'Oseteg',
	'osa' => 'Osageg',
	'ota' => 'Tyrceg Otoman',
	'pa' => 'Pwnjabeg',
	'pag' => 'Pangasineg',
	'pal' => 'Pahlafi',
	'pam' => 'Pampanga',
	'pap' => 'Papiamento',
	'pau' => 'Palawan',
	'pcd' => 'Picardeg',
	'pcm' => 'Pidgin Nigeria',
	'pdc' => 'Almaeneg Pensylfania',
	'peo' => 'Hen Bersieg',
	'pfl' => 'Almaeneg Palatin',
	'phn' => 'Phoeniceg',
	'pi' => 'Pali',
	'pl' => 'Pwyleg',
	'pms' => 'Piedmonteg',
	'pnt' => 'Ponteg',
	'pon' => 'Pohnpeianeg',
	'prg' => 'Prwseg',
	'pro' => 'Hen Brofensaleg',
	'ps' => 'Pashto',
	'pt' => 'Portiwgaleg',
	'pt_BR' => 'Portiwgaleg Brasil',
	'pt_PT' => 'Portiwgaleg Ewrop',
	'qu' => 'Quechua',
	'quc' => 'K’iche’',
	'raj' => 'Rajasthaneg',
	'rap' => 'Rapanŵi',
	'rar' => 'Raratongeg',
	'rhg' => 'Rohingya',
	'rm' => 'Románsh',
	'rn' => 'Rwndi',
	'ro' => 'Rwmaneg',
	'ro_MD' => 'Moldofeg',
	'rof' => 'Rombo',
	'rom' => 'Romani',
	'rtm' => 'Rotumaneg',
	'ru' => 'Rwseg',
	'rup' => 'Aromaneg',
	'rw' => 'Ciniarŵandeg',
	'rwk' => 'Rwa',
	'sa' => 'Sansgrit',
	'sad' => 'Sandäweg',
	'sah' => 'Sakha',
	'sam' => 'Aramaeg Samaria',
	'saq' => 'Sambŵrw',
	'sas' => 'Sasaceg',
	'sat' => 'Santali',
	'sba' => 'Ngambeieg',
	'sbp' => 'Sangw',
	'sc' => 'Sardeg',
	'scn' => 'Sisileg',
	'sco' => 'Sgoteg',
	'sd' => 'Sindhi',
	'sdc' => 'Sasareseg Sardinia',
	'sdh' => 'Cwrdeg Deheuol',
	'se' => 'Sami Gogleddol',
	'see' => 'Seneca',
	'seh' => 'Sena',
	'sei' => 'Seri',
	'sel' => 'Selcypeg',
	'ses' => 'Koyraboro Senni',
	'sg' => 'Sango',
	'sga' => 'Hen Wyddeleg',
	'sgs' => 'Samogiteg',
	'sh' => 'Serbo-Croateg',
	'shi' => 'Tachelhit',
	'shn' => 'Shan',
	'shu' => 'Arabeg Chad',
	'si' => 'Sinhaleg',
	'sid' => 'Sidamo',
	'sk' => 'Slofaceg',
	'sl' => 'Slofeneg',
	'sli' => 'Is-silesieg',
	'sm' => 'Samöeg',
	'sma' => 'Sami Deheuol',
	'smj' => 'Sami Lwle',
	'smn' => 'Inari Sami',
	'sms' => 'Sami Scolt',
	'sn' => 'Shona',
	'snk' => 'Soninceg',
	'so' => 'Somaleg',
	'sog' => 'Sogdeg',
	'sq' => 'Albaneg',
	'sr' => 'Serbeg',
	'srn' => 'Sranan Tongo',
	'srr' => 'Serereg',
	'ss' => 'Swati',
	'ssy' => 'Saho',
	'st' => 'Sesotheg Deheuol',
	'stq' => 'Ffriseg Saterland',
	'su' => 'Swndaneg',
	'suk' => 'Swcwma',
	'sus' => 'Swsŵeg',
	'sux' => 'Swmereg',
	'sv' => 'Swedeg',
	'sw' => 'Swahili',
	'sw_CD' => 'Swahili’r Congo',
	'swb' => 'Comoreg',
	'syc' => 'Hen Syrieg',
	'syr' => 'Syrieg',
	'szl' => 'Silesieg',
	'ta' => 'Tamileg',
	'tcy' => 'Tulu',
	'te' => 'Telugu',
	'tem' => 'Timneg',
	'teo' => 'Teso',
	'ter' => 'Terena',
	'tet' => 'Tetumeg',
	'tg' => 'Tajiceg',
	'th' => 'Thai',
	'ti' => 'Tigrinya',
	'tig' => 'Tigreg',
	'tiv' => 'Tifeg',
	'tk' => 'Tyrcmeneg',
	'tkl' => 'Tocelaweg',
	'tkr' => 'Tsakhureg',
	'tl' => 'Tagalog',
	'tlh' => 'Klingon',
	'tli' => 'Llingit',
	'tly' => 'Talysheg',
	'tmh' => 'Tamasheceg',
	'tn' => 'Tswana',
	'to' => 'Tongeg',
	'tpi' => 'Tok Pisin',
	'tr' => 'Tyrceg',
	'trv' => 'Taroko',
	'ts' => 'Tsongaeg',
	'tsd' => 'Tsaconeg',
	'tt' => 'Tatareg',
	'tum' => 'Twmbwca',
	'tvl' => 'Twfalweg',
	'tw' => 'Twi',
	'twq' => 'Tasawaq',
	'ty' => 'Tahitïeg',
	'tyv' => 'Twfwnieg',
	'tzm' => 'Tamazight Canol yr Atlas',
	'udm' => 'Fotiaceg',
	'ug' => 'Uighur',
	'uga' => 'Wgariteg',
	'uk' => 'Wcreineg',
	'umb' => 'Umbundu',
	'und' => 'Iaith anhysbys',
	'ur' => 'Wrdw',
	'uz' => 'Wsbeceg',
	'vai' => 'Faieg',
	've' => 'Fendeg',
	'vec' => 'Feniseg',
	'vep' => 'Feps',
	'vi' => 'Fietnameg',
	'vls' => 'Fflemeg Gorllewinol',
	'vo' => 'Folapük',
	'vot' => 'Foteg',
	'vun' => 'Funjo',
	'wa' => 'Walwneg',
	'wae' => 'Walsereg',
	'wal' => 'Walamo',
	'war' => 'Winarayeg',
	'was' => 'Washo',
	'wbp' => 'Warlpiri',
	'wo' => 'Woloff',
	'xal' => 'Calmyceg',
	'xh' => 'Xhosa',
	'xog' => 'Soga',
	'yav' => 'Iangben',
	'ybb' => 'Iembaeg',
	'yi' => 'Iddew-Almaeneg',
	'yo' => 'Iorwba',
	'yue' => 'Cantoneeg',
	'yue@alt=menu' => 'Tsieinëeg, Cantoneg',
	'zap' => 'Zapoteceg',
	'zbl' => 'Blisssymbols',
	'zea' => 'Zêlandeg',
	'zgh' => 'Tamaseit Moroco Safonol',
	'zh' => 'Tsieinëeg',
	'zh@alt=menu' => 'Tsieinëeg, Mandarin',
	'zh_Hans' => 'Tsieinëeg Symledig',
	'zh_Hans@alt=long' => 'Tsieinëeg Mandarin Symledig',
	'zh_Hant' => 'Tsieinëeg Traddodiadol',
 	'zh_Hant@alt=long' => 'Tsieinëeg Mandarin Traddodiadol',
	'zu' => 'Swlw',
	'zun' => 'Swni',
	'zxx' => 'Dim cynnwys ieithyddol',
	'zza' => 'Sasäeg',
};

is_deeply($locale->all_languages, $all_languages, 'All languages');

is($locale->script_name(), '', 'Script name from current locale');
is($locale->script_name('latn'), 'Lladin', 'Script name from string');
is($locale->script_name($other_locale), '', 'Script name from other locale object');

my $all_scripts = {
	'Arab' => 'Arabaidd',
	'Armn' => 'Armenaidd',
	'Beng' => 'Bangla',
	'Bopo' => 'Bopomofo',
	'Brai' => 'Braille',
	'Cyrl' => 'Cyrilig',
	'Deva' => 'Devanagari',
	'Ethi' => 'Ethiopig',
	'Geor' => 'Georgaidd',
	'Grek' => 'Groegaidd',
	'Gujr' => 'Gwjarataidd',
	'Guru' => 'Gwrmwci',
	'Hanb' => 'Han gyda Bopomofo',
	'Hang' => 'Hangul',
	'Hani' => 'Han',
	'Hans' => 'Symledig',
	'Hans@alt=stand-alone' => 'Han symledig',
	'Hant' => 'Traddodiadol',
	'Hant@alt=stand-alone' => 'Han traddodiadol',
	'Hebr' => 'Hebreig',
	'Hira' => 'Hiragana',
	'Hrkt' => 'Syllwyddor Japaneaidd',
	'Jamo' => 'Jamo',
	'Jpan' => 'Japaneaidd',
	'Kana' => 'Catacana',
	'Khmr' => 'Chmeraidd',
	'Knda' => 'Canaraidd',
	'Kore' => 'Coreaidd',
	'Laoo' => 'Laoaidd',
	'Latn' => 'Lladin',
	'Mlym' => 'Malayalamaidd',
	'Mong' => 'Mongolaidd',
	'Mymr' => 'Myanmaraidd',
	'Orya' => 'Orïaidd',
	'Sinh' => 'Sinhanaidd',
	'Taml' => 'Tamilaidd',
	'Telu' => 'Telugu',
	'Thaa' => 'Thaana',
	'Thai' => 'Tai',
	'Tibt' => 'Tibetaidd',
	'Zmth' => 'Nodiant Mathemategol',
	'Zsye' => 'Emoji',
	'Zsym' => 'Symbolau',
	'Zxxx' => 'Anysgrifenedig',
	'Zyyy' => 'Cyffredin',
	'Zzzz' => 'Sgript anhysbys',
};

is_deeply($locale->all_scripts, $all_scripts, 'All scripts');

is($locale->region_name(), 'Y Deyrnas Unedig', 'Region name from current locale');
is($locale->region_name('GB'), 'Y Deyrnas Unedig', 'Region name from string');
is($locale->region_name($other_locale), 'Yr Unol Daleithiau', 'Region name from other locale object');

my $all_regions = {
	'001' => 'Y Byd',
	'002' => 'Affrica',
	'003' => 'Gogledd America',
	'005' => 'De America',
	'009' => 'Oceania',
	'011' => 'Gorllewin Affrica',
	'013' => 'Canolbarth America',
	'014' => 'Dwyrain Affrica',
	'015' => 'Gogledd Affrica',
	'017' => 'Canol Affrica',
	'018' => 'Deheudir Affrica',
	'019' => 'Yr Amerig',
	'021' => 'America i’r Gogledd o Fecsico',
	'029' => 'Y Caribî',
	'030' => 'Dwyrain Asia',
	'034' => 'De Asia',
	'035' => 'De-Ddwyrain Asia',
	'039' => 'De Ewrop',
	'053' => 'Awstralasia',
	'054' => 'Melanesia',
	'057' => 'Rhanbarth Micronesia',
	'061' => 'Polynesia',
	'142' => 'Asia',
	'143' => 'Canol Asia',
	'145' => 'Gorllewin Asia',
	'150' => 'Ewrop',
	'151' => 'Dwyrain Ewrop',
	'154' => 'Gogledd Ewrop',
	'155' => 'Gorllewin Ewrop',
	'419' => 'America Ladin',
	'202' => 'Affrica Is-Sahara',
	'AC' => 'Ynys Ascension',
	'AD' => 'Andorra',
	'AE' => 'Emiradau Arabaidd Unedig',
	'AF' => 'Afghanistan',
	'AG' => 'Antigua a Barbuda',
	'AI' => 'Anguilla',
	'AL' => 'Albania',
	'AM' => 'Armenia',
	'AO' => 'Angola',
	'AQ' => 'Antarctica',
	'AR' => 'Yr Ariannin',
	'AS' => 'Samoa America',
	'AT' => 'Awstria',
	'AU' => 'Awstralia',
	'AW' => 'Aruba',
	'AX' => 'Ynysoedd Åland',
	'AZ' => 'Aserbaijan',
	'BA' => 'Bosnia a Herzegovina',
	'BB' => 'Barbados',
	'BD' => 'Bangladesh',
	'BE' => 'Gwlad Belg',
	'BF' => 'Burkina Faso',
	'BG' => 'Bwlgaria',
	'BH' => 'Bahrain',
	'BI' => 'Burundi',
	'BJ' => 'Benin',
	'BL' => 'Saint Barthélemy',
	'BM' => 'Bermuda',
	'BN' => 'Brunei',
	'BO' => 'Bolifia',
	'BQ' => 'Antilles yr Iseldiroedd',
	'BR' => 'Brasil',
	'BS' => 'Y Bahamas',
	'BT' => 'Bhutan',
	'BV' => 'Ynys Bouvet',
	'BW' => 'Botswana',
	'BY' => 'Belarws',
	'BZ' => 'Belize',
	'CA' => 'Canada',
	'CC' => 'Ynysoedd Cocos (Keeling)',
	'CD' => 'Y Congo - Kinshasa',
	'CD@alt=variant' => 'Y Congo (G.Dd.C.)',
	'CF' => 'Gweriniaeth Canolbarth Affrica',
	'CG' => 'Y Congo - Brazzaville',
	'CG@alt=variant' => 'Y Congo (Gweriniaeth)',
	'CH' => 'Y Swistir',
	'CI' => 'Côte d’Ivoire',
	'CI@alt=variant' => 'Arfordir Ifori',
	'CK' => 'Ynysoedd Cook',
	'CL' => 'Chile',
	'CM' => 'Camerŵn',
	'CN' => 'Tsieina',
	'CO' => 'Colombia',
	'CP' => 'Ynys Clipperton',
	'CR' => 'Costa Rica',
	'CU' => 'Ciwba',
	'CV' => 'Cabo Verde',
	'CW' => 'Curaçao',
	'CX' => 'Ynys y Nadolig',
	'CY' => 'Cyprus',
	'CZ' => 'Tsiecia',
	'CZ@alt=variant' => 'Gweriniaeth Tsiec',
	'DE' => 'Yr Almaen',
	'DG' => 'Diego Garcia',
	'DJ' => 'Djibouti',
	'DK' => 'Denmarc',
	'DM' => 'Dominica',
	'DO' => 'Gweriniaeth Dominica',
	'DZ' => 'Algeria',
	'EA' => 'Ceuta a Melilla',
	'EC' => 'Ecuador',
	'EE' => 'Estonia',
	'EG' => 'Yr Aifft',
	'EH' => 'Gorllewin Sahara',
	'ER' => 'Eritrea',
	'ES' => 'Sbaen',
	'ET' => 'Ethiopia',
	'EU' => 'Yr Undeb Ewropeaidd',
	'EZ' => 'Ardal yr Ewro',
	'FI' => 'Y Ffindir',
	'FJ' => 'Fiji',
	'FK' => 'Ynysoedd y Falkland/Malvinas',
	'FK@alt=variant' => 'Ynysoedd y Falkland (Ynysoedd y Malfinas)',
	'FM' => 'Micronesia',
	'FO' => 'Ynysoedd Ffaro',
	'FR' => 'Ffrainc',
	'GA' => 'Gabon',
	'GB' => 'Y Deyrnas Unedig',
	'GB@alt=short' => 'DU',
	'GD' => 'Grenada',
	'GE' => 'Georgia',
	'GF' => 'Guyane Ffrengig',
	'GG' => 'Ynys y Garn',
	'GH' => 'Ghana',
	'GI' => 'Gibraltar',
	'GL' => 'Yr Ynys Las',
	'GM' => 'Gambia',
	'GN' => 'Gini',
	'GP' => 'Guadeloupe',
	'GQ' => 'Gini Gyhydeddol',
	'GR' => 'Gwlad Groeg',
	'GS' => 'De Georgia ac Ynysoedd Sandwich y De',
	'GT' => 'Guatemala',
	'GU' => 'Guam',
	'GW' => 'Guiné-Bissau',
	'GY' => 'Guyana',
	'HK' => 'Hong Kong SAR Tsieina',
	'HK@alt=short' => 'Hong Kong',
	'HM' => 'Ynys Heard ac Ynysoedd McDonald',
	'HN' => 'Honduras',
	'HR' => 'Croatia',
	'HT' => 'Haiti',
	'HU' => 'Hwngari',
	'IC' => 'Yr Ynysoedd Dedwydd',
	'ID' => 'Indonesia',
	'IE' => 'Iwerddon',
	'IL' => 'Israel',
	'IM' => 'Ynys Manaw',
	'IN' => 'India',
	'IO' => 'Tiriogaeth Brydeinig Cefnfor India',
	'IQ' => 'Irac',
	'IR' => 'Iran',
	'IS' => 'Gwlad yr Iâ',
	'IT' => 'Yr Eidal',
	'JE' => 'Jersey',
	'JM' => 'Jamaica',
	'JO' => 'Gwlad Iorddonen',
	'JP' => 'Japan',
	'KE' => 'Kenya',
	'KG' => 'Kyrgyzstan',
	'KH' => 'Cambodia',
	'KI' => 'Kiribati',
	'KM' => 'Comoros',
	'KN' => 'Saint Kitts a Nevis',
	'KP' => 'Gogledd Corea',
	'KR' => 'De Corea',
	'KW' => 'Kuwait',
	'KY' => 'Ynysoedd Cayman',
	'KZ' => 'Kazakhstan',
	'LA' => 'Laos',
	'LB' => 'Libanus',
	'LC' => 'Saint Lucia',
	'LI' => 'Liechtenstein',
	'LK' => 'Sri Lanka',
	'LR' => 'Liberia',
	'LS' => 'Lesotho',
	'LT' => 'Lithwania',
	'LU' => 'Lwcsembwrg',
	'LV' => 'Latfia',
	'LY' => 'Libya',
	'MA' => 'Moroco',
	'MC' => 'Monaco',
	'MD' => 'Moldofa',
	'ME' => 'Montenegro',
	'MF' => 'Saint Martin',
	'MG' => 'Madagascar',
	'MH' => 'Ynysoedd Marshall',
	'MK' => 'Gogledd Macedonia',
	'ML' => 'Mali',
	'MM' => 'Myanmar (Burma)',
	'MN' => 'Mongolia',
	'MO' => 'Macau SAR Tsieina',
	'MO@alt=short' => 'Macau',
	'MP' => 'Ynysoedd Gogledd Mariana',
	'MQ' => 'Martinique',
	'MR' => 'Mauritania',
	'MS' => 'Montserrat',
	'MT' => 'Malta',
	'MU' => 'Mauritius',
	'MV' => 'Y Maldives',
	'MW' => 'Malawi',
	'MX' => 'Mecsico',
	'MY' => 'Malaysia',
	'MZ' => 'Mozambique',
	'NA' => 'Namibia',
	'NC' => 'Caledonia Newydd',
	'NE' => 'Niger',
	'NF' => 'Ynys Norfolk',
	'NG' => 'Nigeria',
	'NI' => 'Nicaragua',
	'NL' => 'Yr Iseldiroedd',
	'NO' => 'Norwy',
	'NP' => 'Nepal',
	'NR' => 'Nauru',
	'NU' => 'Niue',
	'NZ' => 'Seland Newydd',
	'OM' => 'Oman',
	'PA' => 'Panama',
	'PE' => 'Periw',
	'PF' => 'Polynesia Ffrengig',
	'PG' => 'Papua Guinea Newydd',
	'PH' => 'Y Philipinau',
	'PK' => 'Pakistan',
	'PL' => 'Gwlad Pwyl',
	'PM' => 'Saint-Pierre-et-Miquelon',
	'PN' => 'Ynysoedd Pitcairn',
	'PR' => 'Puerto Rico',
	'PS' => 'Tiriogaethau Palesteinaidd',
	'PS@alt=short' => 'Palesteina',
	'PT' => 'Portiwgal',
	'PW' => 'Palau',
	'PY' => 'Paraguay',
	'QA' => 'Qatar',
	'QO' => 'Oceania Bellennig',
	'RE' => 'Réunion',
	'RO' => 'Rwmania',
	'RS' => 'Serbia',
	'RU' => 'Rwsia',
	'RW' => 'Rwanda',
	'SA' => 'Saudi Arabia',
	'SB' => 'Ynysoedd Solomon',
	'SC' => 'Seychelles',
	'SD' => 'Swdan',
	'SE' => 'Sweden',
	'SG' => 'Singapore',
	'SH' => 'Saint Helena',
	'SI' => 'Slofenia',
	'SJ' => 'Svalbard a Jan Mayen',
	'SK' => 'Slofacia',
	'SL' => 'Sierra Leone',
	'SM' => 'San Marino',
	'SN' => 'Senegal',
	'SO' => 'Somalia',
	'SR' => 'Suriname',
	'SS' => 'De Swdan',
	'ST' => 'São Tomé a Príncipe',
	'SV' => 'El Salvador',
	'SX' => 'Sint Maarten',
	'SY' => 'Syria',
	'SZ' => 'Eswatini',
	'SZ@alt=variant' => 'Gwlad Swazi',
	'TA' => 'Tristan da Cunha',
	'TC' => 'Ynysoedd Turks a Caicos',
	'TD' => 'Tsiad',
	'TF' => 'Tiroedd Deheuol ac Antarctig Ffrainc',
	'TG' => 'Togo',
	'TH' => 'Gwlad Thai',
	'TJ' => 'Tajicistan',
	'TK' => 'Tokelau',
	'TL' => 'Timor-Leste',
	'TL@alt=variant' => 'Dwyrain Timor',
	'TM' => 'Tyrcmenistan',
	'TN' => 'Tiwnisia',
	'TO' => 'Tonga',
	'TR' => 'Twrci',
	'TT' => 'Trinidad a Tobago',
	'TV' => 'Tuvalu',
	'TW' => 'Taiwan',
	'TZ' => 'Tanzania',
	'UA' => 'Wcráin',
	'UG' => 'Uganda',
	'UM' => 'Ynysoedd Pellennig UDA',
	'UN' => 'y Cenhedloedd Unedig',
	'UN@alt=short' => 'UN',
	'US' => 'Yr Unol Daleithiau',
	'US@alt=short' => 'UDA',
	'UY' => 'Uruguay',
	'UZ' => 'Uzbekistan',
	'VA' => 'Y Fatican',
	'VC' => 'Saint Vincent a’r Grenadines',
	'VE' => 'Venezuela',
	'VG' => 'Ynysoedd Gwyryf Prydain',
	'VI' => 'Ynysoedd Gwyryf yr Unol Daleithiau',
	'VN' => 'Fietnam',
	'VU' => 'Vanuatu',
	'WF' => 'Wallis a Futuna',
	'WS' => 'Samoa',
	'XA' => 'Acenion Ffug',
	'XB' => 'Bidi Ffug',
	'XK' => 'Kosovo',
	'YE' => 'Yemen',
	'YT' => 'Mayotte',
	'ZA' => 'De Affrica',
	'ZM' => 'Zambia',
	'ZW' => 'Zimbabwe',
	'ZZ' => 'Rhanbarth Anhysbys',
};

is_deeply($locale->all_regions(), $all_regions, 'All Regions');

is($locale->variant_name(), '', 'Variant name from current locale');
is($locale->variant_name('BOHORIC'), 'Gwyddor Bohorič', 'Variant name from string');
is($locale->variant_name($other_locale), '', 'Variant name from other locale object');

is($locale->key_name('collation'), 'Trefn', 'Key name from string');

is($locale->type_name(numbers => 'hant'), 'Rhifolion Tsieineaidd Traddodiadol', 'Type name from string');

is($locale->measurement_system_name('metric'), 'Metrig', 'Measurement system name Welsh Metric');
is($locale->measurement_system_name('us'), 'UDA', 'Measurement system name Welsh US');
is($locale->measurement_system_name('uk'), 'DU', 'Measurement system name Welsh UK');

is($locale->transform_name('Numeric'), '', 'Transform name from string');