=encoding utf8

=head1 NAME

Locale::CLDR::Locales::As - Package for language Assamese

=cut

package Locale::CLDR::Locales::As;
# This file auto generated from Data\common\main\as.xml
#	on Wed  3 Jan 11:17:34 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.40.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'আফাৰ',
 				'ab' => 'আবখাজিয়ান',
 				'ace' => 'আচিনিজ',
 				'ada' => 'আদাংমে',
 				'ady' => 'আদিগে',
 				'af' => 'আফ্ৰিকানছ্',
 				'agq' => 'আঘেম',
 				'ain' => 'আইনু',
 				'ak' => 'আকান',
 				'ale' => 'আলেউট',
 				'alt' => 'দাক্ষিণাত্য আল্টাই',
 				'am' => 'আমহাৰিক',
 				'an' => 'আৰ্গোনিজ',
 				'anp' => 'আঙ্গিকা',
 				'ar' => 'আৰবী',
 				'ar_001' => 'আধুনিক মানক আৰবী',
 				'arn' => 'মাপুচে',
 				'arp' => 'আৰাপাহো',
 				'as' => 'অসমীয়া',
 				'asa' => 'আছু',
 				'ast' => 'এষ্টুৰীয়',
 				'av' => 'আভেৰিক',
 				'awa' => 'আৱাধি',
 				'ay' => 'আয়মাৰা',
 				'az' => 'আজেৰবাইজানী',
 				'az@alt=short' => 'আজেৰি',
 				'ba' => 'বাছখিৰ',
 				'ban' => 'বালিনীজ',
 				'bas' => 'বাছা',
 				'be' => 'বেলাৰুছীয়',
 				'bem' => 'বেম্বা',
 				'bez' => 'বেনা',
 				'bg' => 'বুলগেৰীয়',
 				'bho' => 'ভোজপুৰী',
 				'bi' => 'বিছলামা',
 				'bin' => 'বিনি',
 				'bla' => 'ছিক্সিকা',
 				'bm' => 'বামবাৰা',
 				'bn' => 'বাংলা',
 				'bo' => 'তিব্বতী',
 				'br' => 'ব্ৰেটন',
 				'brx' => 'বড়ো',
 				'bs' => 'বছনীয়',
 				'bug' => 'বগিনীজ',
 				'byn' => 'ব্লিন',
 				'ca' => 'কাতালান',
 				'ccp' => 'চাক্‌মা',
 				'ce' => 'চেচেন',
 				'ceb' => 'চিবুৱানো',
 				'cgg' => 'চিগা',
 				'ch' => 'চামোৰো',
 				'chk' => 'চুকিজ',
 				'chm' => 'মাৰি',
 				'cho' => 'চোক্টাউ',
 				'chr' => 'চেৰোকি',
 				'chy' => 'চাইয়েন',
 				'ckb' => 'চেণ্ট্ৰেল কুৰ্ডিচ',
 				'co' => 'কোৰ্ছিকান',
 				'crs' => 'ছেছেলৱা ক্ৰিওল ফ্ৰেন্স',
 				'cs' => 'চেক',
 				'cu' => 'চাৰ্চ শ্লেভিক',
 				'cv' => 'চুভাচ',
 				'cy' => 'ৱেলচ',
 				'da' => 'ডেনিচ',
 				'dak' => 'ডাকোটা',
 				'dar' => 'দাৰ্গৱা',
 				'dav' => 'তেইতা',
 				'de' => 'জাৰ্মান',
 				'de_AT' => 'অষ্ট্ৰেলিয়ান জাৰ্মান',
 				'de_CH' => 'ছুইচ হাই জাৰ্মান',
 				'dgr' => 'ডোগ্ৰিব',
 				'dje' => 'ঝাৰ্মা',
 				'doi' => 'ডোগ্ৰী',
 				'dsb' => 'ল’ৱাৰ ছোৰ্বিয়ান',
 				'dua' => 'ডুৱালা',
 				'dv' => 'দিবেহি',
 				'dyo' => 'জোলা-ফ’নি',
 				'dz' => 'জোংখা',
 				'dzg' => 'দাজাগা',
 				'ebu' => 'এম্বু',
 				'ee' => 'ইৱে',
 				'efi' => 'এফিক',
 				'eka' => 'একাজুক',
 				'el' => 'গ্ৰীক',
 				'en' => 'ইংৰাজী',
 				'en_AU' => 'অষ্ট্ৰেলিয়ান ইংৰাজী',
 				'en_CA' => 'কানাডিয়ান ইংৰাজী',
 				'en_GB' => 'ব্ৰিটিছ ইংৰাজী',
 				'en_GB@alt=short' => 'ইউ. কে. ইংৰাজী',
 				'en_US' => 'আমেৰিকান ইংৰাজী',
 				'en_US@alt=short' => 'ইউ. এছ. ইংৰাজী',
 				'eo' => 'এস্পেৰান্তো',
 				'es' => 'স্পেনিচ',
 				'es_419' => 'লেটিন আমেৰিকান স্পেনিচ',
 				'es_ES' => 'ইউৰোপীয়ান স্পেনিচ',
 				'es_MX' => 'মেক্সিকান স্পেনিচ',
 				'et' => 'এষ্টোনিয়',
 				'eu' => 'বাস্ক',
 				'ewo' => 'ইওন্দো',
 				'fa' => 'ফাৰ্ছী',
 				'fa_AF' => 'দাৰি',
 				'ff' => 'ফুলাহ',
 				'fi' => 'ফিনিচ',
 				'fil' => 'ফিলিপিনো',
 				'fj' => 'ফিজিয়ান',
 				'fo' => 'ফাৰোইজ',
 				'fon' => 'ফ’ন',
 				'fr' => 'ফ্ৰেন্স',
 				'fr_CA' => 'কানাডিয়ান ফ্ৰেন্স',
 				'fr_CH' => 'ছুইচ ফ্ৰেন্স',
 				'fur' => 'ফ্ৰিউলিয়ান',
 				'fy' => 'ৱেষ্টাৰ্ণ ফ্ৰিছিয়ান',
 				'ga' => 'আইৰিচ',
 				'gaa' => 'গা',
 				'gd' => 'স্কটিচ গেইলিক',
 				'gez' => 'গীজ',
 				'gil' => 'গিলবাৰ্টিছ',
 				'gl' => 'গেলিচিয়ান',
 				'gn' => 'গুৱাৰাণী',
 				'gor' => 'গোৰোন্তালো',
 				'gsw' => 'ছুইচ জাৰ্মান',
 				'gu' => 'গুজৰাটী',
 				'guz' => 'গুছি',
 				'gv' => 'মেংক্স',
 				'gwi' => 'জিউইচিন',
 				'ha' => 'হাউছা',
 				'haw' => 'হাৱাই',
 				'he' => 'হিব্ৰু',
 				'hi' => 'হিন্দী',
 				'hil' => 'হিলিগায়নোন',
 				'hmn' => 'হমং',
 				'hr' => 'ক্ৰোৱেচিয়ান',
 				'hsb' => 'আপাৰ ছোৰ্বিয়ান',
 				'ht' => 'হেইটিয়ান ক্ৰিয়ল',
 				'hu' => 'হাঙ্গেৰিয়ান',
 				'hup' => 'হুপা',
 				'hy' => 'আৰ্মেনীয়',
 				'hz' => 'হেৰেৰো',
 				'ia' => 'ইণ্টাৰলিংগুৱা',
 				'iba' => 'ইবান',
 				'ibb' => 'ইবিবিও',
 				'id' => 'ইণ্ডোনেচিয়',
 				'ie' => 'উপস্থাপন ভাষা',
 				'ig' => 'ইগ্বো',
 				'ii' => 'ছিচুৱান ই',
 				'ilo' => 'ইলোকো',
 				'inh' => 'ইংগুচ',
 				'io' => 'ইডো',
 				'is' => 'আইচলেণ্ডিক',
 				'it' => 'ইটালিয়ান',
 				'iu' => 'ইনুক্টিটুট',
 				'ja' => 'জাপানী',
 				'jbo' => 'লোজ্বান',
 				'jgo' => 'নগোম্বা',
 				'jmc' => 'মেকহেম',
 				'jv' => 'জাভানী',
 				'ka' => 'জৰ্জিয়ান',
 				'kab' => 'কাবাইল',
 				'kac' => 'কাচিন',
 				'kaj' => 'জজু',
 				'kam' => 'কাম্বা',
 				'kbd' => 'কাবাৰ্ডিয়ান',
 				'kcg' => 'ত্যাপ',
 				'kde' => 'মাকোণ্ড',
 				'kea' => 'কাবুভেৰ্ডিয়ানু',
 				'kfo' => 'কোৰো',
 				'kha' => 'খাচি',
 				'khq' => 'কোয়াৰ চিনি',
 				'ki' => 'কিকুয়ু',
 				'kj' => 'কুয়ানিয়ামা',
 				'kk' => 'কাজাখ',
 				'kkj' => 'কাকো',
 				'kl' => 'কালালিছুট',
 				'kln' => 'কালেনজিন',
 				'km' => 'খমেৰ',
 				'kmb' => 'কিম্বুন্দু',
 				'kn' => 'কানাড়া',
 				'ko' => 'কোৰিয়ান',
 				'kok' => 'কোংকণী',
 				'kpe' => 'কেপেল',
 				'kr' => 'কানুৰি',
 				'krc' => 'কাৰাচে-বাল্কাৰ',
 				'krl' => 'কেৰেলিয়ান',
 				'kru' => 'কুৰুখ',
 				'ks' => 'কাশ্মিৰী',
 				'ksb' => 'চাম্বালা',
 				'ksf' => 'বাফিয়া',
 				'ksh' => 'কোলোগনিয়ান',
 				'ku' => 'কুৰ্ডিচ',
 				'kum' => 'কুমিক',
 				'kv' => 'কোমি',
 				'kw' => 'কোৰ্নিচ',
 				'ky' => 'কিৰ্গিজ',
 				'la' => 'লেটিন',
 				'lad' => 'লাডিনো',
 				'lag' => 'লাংগি',
 				'lb' => 'লাক্সেমবাৰ্গিচ',
 				'lez' => 'লেজঘিয়ান',
 				'lg' => 'গান্দা',
 				'li' => 'লিম্বুৰ্গিচ',
 				'lkt' => 'লাকোটা',
 				'ln' => 'লিংগালা',
 				'lo' => 'লাও',
 				'loz' => 'লোজি',
 				'lrc' => 'উদীচ্য লুৰি',
 				'lt' => 'লিথুৱানিয়ান',
 				'lu' => 'লুবা-কাটাংগা',
 				'lua' => 'লুবা-লুলুৱা',
 				'lun' => 'লুণ্ডা',
 				'luo' => 'লুও',
 				'lus' => 'মিজো',
 				'luy' => 'লুইয়া',
 				'lv' => 'লাটভিয়ান',
 				'mad' => 'মাদুৰেছে',
 				'mag' => 'মাগাহি',
 				'mai' => 'মৈথিলী',
 				'mak' => 'মাকাছাৰ',
 				'mas' => 'মাছাই',
 				'mdf' => 'মোক্সা',
 				'men' => 'মেণ্ডে',
 				'mer' => 'মেৰু',
 				'mfe' => 'মৰিছিয়ান',
 				'mg' => 'মালাগাছী',
 				'mgh' => 'মাখুৱা-মিট্টো',
 				'mgo' => 'মেটা',
 				'mh' => 'মাৰ্চলিজ',
 				'mi' => 'মাওৰি',
 				'mic' => 'মিকমেক',
 				'min' => 'মিনাংকাবাউ',
 				'mk' => 'মেচিডোনীয়',
 				'ml' => 'মালায়ালম',
 				'mn' => 'মংগোলীয়',
 				'mni' => 'মণিপুৰী',
 				'moh' => 'মোহোক',
 				'mos' => 'মোছি',
 				'mr' => 'মাৰাঠী',
 				'ms' => 'মালয়',
 				'mt' => 'মাল্টিজ',
 				'mua' => 'মুণ্ডাং',
 				'mul' => 'একাধিক ভাষা',
 				'mus' => 'ক্ৰীক',
 				'mwl' => 'মিৰাণ্ডিজ',
 				'my' => 'বাৰ্মীজ',
 				'myv' => 'এৰজিয়া',
 				'mzn' => 'মাজেন্দাৰানি',
 				'na' => 'নাউৰু',
 				'nap' => 'নিয়াপোলিটেন',
 				'naq' => 'নামা',
 				'nb' => 'নৰৱেজিয়ান বোকমাল',
 				'nd' => 'উত্তৰ নিবেবেলে',
 				'nds' => 'ল’ জাৰ্মান',
 				'ne' => 'নেপালী',
 				'new' => 'নেৱাৰি',
 				'ng' => 'এন্দোঙ্গা',
 				'nia' => 'নিয়াছ',
 				'niu' => 'নিয়ুৱান',
 				'nl' => 'ডাচ',
 				'nl_BE' => 'ফ্লেমিচ',
 				'nmg' => 'কোৱাছিঅ’',
 				'nn' => 'নৰৱেজিয়ান নায়নোৰ্স্ক',
 				'nnh' => 'নিয়েম্বোন',
 				'no' => 'নৰৱেজিয়ান',
 				'nog' => 'নোগাই',
 				'nqo' => 'এন্কো',
 				'nr' => 'দক্ষিণ দেবেল',
 				'nso' => 'উদীচ্য ছোথো',
 				'nus' => 'নুয়েৰ',
 				'nv' => 'নাভাজো',
 				'ny' => 'ন্যাঞ্জা',
 				'nyn' => 'ন্যানকোল',
 				'oc' => 'অ’চিটান',
 				'om' => 'ওৰোমো',
 				'or' => 'ওড়িয়া',
 				'os' => 'ওছেটিক',
 				'pa' => 'পাঞ্জাবী',
 				'pag' => 'পংগাছিনান',
 				'pam' => 'পাম্পান্গা',
 				'pap' => 'পাপিয়ামেণ্টো',
 				'pau' => 'পালাউৱান',
 				'pcm' => 'নাইজেৰিয়ান পিজিন',
 				'pl' => 'প’লিচ',
 				'prg' => 'প্ৰুছিয়ান',
 				'ps' => 'পুস্ত',
 				'pt' => 'পৰ্তুগীজ',
 				'pt_BR' => 'ব্ৰাজিলিয়ান পৰ্তুগীজ',
 				'pt_PT' => 'ইউৰোপীয়ান পৰ্তুগীজ',
 				'qu' => 'কুৱেচুৱা',
 				'quc' => 'কিচিয়ে',
 				'rap' => 'ৰাপানুই',
 				'rar' => 'ৰাৰোতোঙ্গন',
 				'rhg' => 'ৰোহিঙ্গিয়া',
 				'rm' => 'ৰোমানচ',
 				'rn' => 'ৰুন্দি',
 				'ro' => 'ৰোমানীয়',
 				'ro_MD' => 'মোল্ডাভিয়ান',
 				'rof' => 'ৰোম্বো',
 				'ru' => 'ৰাছিয়ান',
 				'rup' => 'আৰোমানীয়',
 				'rw' => 'কিনয়াৰোৱাণ্ডা',
 				'rwk' => 'ৰৱা',
 				'sa' => 'সংস্কৃত',
 				'sad' => 'ছান্দাৱে',
 				'sah' => 'ছাখা',
 				'saq' => 'ছাম্বুৰু',
 				'sat' => 'চাওতালি',
 				'sba' => 'নাংম্বে',
 				'sbp' => 'ছাঙ্গু',
 				'sc' => 'ছাৰ্ডিনিয়ান',
 				'scn' => 'ছিচিলিয়ান',
 				'sco' => 'স্কটছ',
 				'sd' => 'সিন্ধী',
 				'se' => 'উদীচ্য ছামি',
 				'seh' => 'ছেনা',
 				'ses' => 'কোইৰাবোৰো চেন্নি',
 				'sg' => 'ছাঙ্গো',
 				'shi' => 'তাচেলহিট',
 				'shn' => 'চান',
 				'si' => 'সিংহলা',
 				'sk' => 'শ্লোভাক',
 				'sl' => 'শ্লোভেনিয়ান',
 				'sm' => 'ছামোন',
 				'sma' => 'দাক্ষিণাত্য ছামি',
 				'smj' => 'লুলে ছামি',
 				'smn' => 'ইনাৰি ছামি',
 				'sms' => 'স্কোল্ট ছামি',
 				'sn' => 'চোনা',
 				'snk' => 'ছোনিনকে',
 				'so' => 'ছোমালি',
 				'sq' => 'আলবেনীয়',
 				'sr' => 'ছাৰ্বিয়ান',
 				'srn' => 'স্ৰানান টোঙ্গো',
 				'ss' => 'স্বাতি',
 				'ssy' => 'ছাহো',
 				'st' => 'দাক্ষিণাত্য ছোথো',
 				'su' => 'ছুণ্ডানীজ',
 				'suk' => 'ছুকুমা',
 				'sv' => 'ছুইডিচ',
 				'sw' => 'স্বাহিলি',
 				'sw_CD' => 'কঙ্গো স্বাহিলি',
 				'swb' => 'কোমোৰিয়ান',
 				'syr' => 'চিৰিয়াক',
 				'ta' => 'তামিল',
 				'te' => 'তেলুগু',
 				'tem' => 'টিম্নে',
 				'teo' => 'তেছো',
 				'tet' => 'তেতুম',
 				'tg' => 'তাজিক',
 				'th' => 'থাই',
 				'ti' => 'টিগৰিনিয়া',
 				'tig' => 'তাইগ্ৰে',
 				'tk' => 'তুৰ্কমেন',
 				'tlh' => 'ক্লিংগন',
 				'tn' => 'ছোৱানা',
 				'to' => 'টোঙ্গান',
 				'tpi' => 'টোক পিছিন',
 				'tr' => 'তুৰ্কী',
 				'trv' => 'তাৰোকো',
 				'ts' => 'ছোঙ্গা',
 				'tt' => 'তাতাৰ',
 				'tum' => 'তুম্বুকা',
 				'tvl' => 'টুভালু',
 				'twq' => 'টাছাৱাক',
 				'ty' => 'তাহিতিয়ান',
 				'tyv' => 'তুভিনিয়ান',
 				'tzm' => 'চেণ্ট্ৰেল এটলাছ টামাজাইট',
 				'udm' => 'উদমুৰ্ত',
 				'ug' => 'উইঘুৰ',
 				'uk' => 'ইউক্ৰেইনীয়',
 				'umb' => 'উম্বুন্দু',
 				'und' => 'অজ্ঞাত ভাষা',
 				'ur' => 'উৰ্দু',
 				'uz' => 'উজবেক',
 				'vai' => 'ভাই',
 				've' => 'ভেণ্ডা',
 				'vi' => 'ভিয়েটনামী',
 				'vo' => 'ভোলাপুক',
 				'vun' => 'ভুঞ্জু',
 				'wa' => 'ৱালুন',
 				'wae' => 'ৱালছেৰ',
 				'wal' => 'ওলেইটা',
 				'war' => 'ৱাৰে',
 				'wo' => 'ৱোলাফ',
 				'xal' => 'কাল্মিক',
 				'xh' => 'হোছা',
 				'xog' => 'ছোগা',
 				'yav' => 'য়াংবেন',
 				'ybb' => 'য়েম্বা',
 				'yi' => 'ইদ্দিছ',
 				'yo' => 'ইউৰুবা',
 				'yue' => 'কেণ্টোনীজ',
 				'yue@alt=menu' => 'চাইনিজ, কেণ্টোনীজ',
 				'zgh' => 'ষ্টেণ্ডাৰ্ড মোৰোক্কান তামাজাইট',
 				'zh' => 'চীনা',
 				'zh@alt=menu' => 'চীনা, মেণ্ডাৰিন',
 				'zh_Hans' => 'সৰলীকৃত চীনা',
 				'zh_Hans@alt=long' => 'সৰলীকৃত মেণ্ডাৰিন চীনা',
 				'zh_Hant' => 'পৰম্পৰাগত চীনা',
 				'zh_Hant@alt=long' => 'পৰম্পৰাগত মেণ্ডাৰিন চীনা',
 				'zu' => 'ঝুলু',
 				'zun' => 'ঝুনি',
 				'zxx' => 'কোনো ভাষা সমল নাই',
 				'zza' => 'ঝাঝা',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'আৰবী',
 			'Armn' => 'আৰ্মেনীয়',
 			'Beng' => 'বাংলা',
 			'Bopo' => 'বোপোমোফো',
 			'Brai' => 'ব্ৰেইল',
 			'Cyrl' => 'চিৰিলিক',
 			'Deva' => 'দেৱনাগৰী',
 			'Ethi' => 'ইথিঅ’পিক',
 			'Geor' => 'জৰ্জিয়ান',
 			'Grek' => 'গ্ৰীক',
 			'Gujr' => 'গুজৰাটী',
 			'Guru' => 'গুৰুমুখী',
 			'Hanb' => 'বোপোমোফোৰ সৈতে হান',
 			'Hang' => 'হেঙ্গুল',
 			'Hani' => 'হান',
 			'Hans' => 'সৰলীকৃত',
 			'Hans@alt=stand-alone' => 'সৰলীকৃত হান',
 			'Hant' => 'পৰম্পৰাগত',
 			'Hant@alt=stand-alone' => 'পৰম্পৰাগত হান',
 			'Hebr' => 'হিব্ৰু',
 			'Hira' => 'হিৰাগানা',
 			'Hrkt' => 'জাপানী ছিলেবেৰিজ',
 			'Jamo' => 'জামো',
 			'Jpan' => 'জাপানী',
 			'Kana' => 'কাটাকানা',
 			'Khmr' => 'খমেৰ',
 			'Knda' => 'কানাড়া',
 			'Kore' => 'কোৰিয়ান',
 			'Laoo' => 'লাও',
 			'Latn' => 'লেটিন',
 			'Mlym' => 'মালায়ালম',
 			'Mong' => 'মঙ্গোলিয়',
 			'Mymr' => 'ম্যানমাৰ',
 			'Orya' => 'ওড়িয়া',
 			'Sinh' => 'সিংহলী',
 			'Taml' => 'তামিল',
 			'Telu' => 'তেলুগু',
 			'Thaa' => 'থানা',
 			'Thai' => 'থাই',
 			'Tibt' => 'তিব্বতী',
 			'Zmth' => 'গাণিতিক চিহ্ন',
 			'Zsye' => 'ইম’জি',
 			'Zsym' => 'প্ৰতীক',
 			'Zxxx' => 'অলিখিত',
 			'Zyyy' => 'কোমোন',
 			'Zzzz' => 'অজ্ঞাত লিপি',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'বিশ্ব',
 			'002' => 'আফ্ৰিকা',
 			'003' => 'উত্তৰ আমেৰিকা',
 			'005' => 'দক্ষিণ আমেৰিকা',
 			'009' => 'অ’চেনীয়া',
 			'011' => 'পাশ্চাত্য আফ্ৰিকা',
 			'013' => 'মধ্য আমেৰিকা',
 			'014' => 'প্ৰাচ্য আফ্ৰিকা',
 			'015' => 'উদীচ্য আফ্ৰিকা',
 			'017' => 'মধ্য আফ্ৰিকা',
 			'018' => 'দাক্ষিণাত্য আফ্ৰিকা',
 			'019' => 'আমেৰিকাছ্',
 			'021' => 'উদীচ্য আমেৰিকা',
 			'029' => 'কেৰিবিয়ান',
 			'030' => 'প্ৰাচ্য এছিয়া',
 			'034' => 'দাক্ষিণাত্য এছিয়া',
 			'035' => 'দক্ষিণ-পূব এছিয়া',
 			'039' => 'দাক্ষিণাত্য ইউৰোপ',
 			'053' => 'অষ্ট্ৰেলেছিয়া',
 			'054' => 'মেলানেছিয়া',
 			'057' => 'মাইক্ৰোনেচিয় ক্ষেত্ৰ',
 			'061' => 'পলিনেচিয়া',
 			'142' => 'এছিয়া',
 			'143' => 'মধ্য এছিয়া',
 			'145' => 'পাশ্চাত্য এছিয়া',
 			'150' => 'ইউৰোপ',
 			'151' => 'প্ৰাচ্য ইউৰোপ',
 			'154' => 'উদীচ্য ইউৰোপ',
 			'155' => 'পাশ্চাত্য ইউৰোপ',
 			'202' => 'উপ-ছাহাৰান আফ্ৰিকা',
 			'419' => 'লেটিন আমেৰিকা',
 			'AC' => 'এচেনচিয়ন দ্বীপ',
 			'AD' => 'আন্দোৰা',
 			'AE' => 'সংযুক্ত আৰব আমিৰাত',
 			'AF' => 'আফগানিস্তান',
 			'AG' => 'এণ্টিগুৱা আৰু বাৰ্বুডা',
 			'AI' => 'এনগুইলা',
 			'AL' => 'আলবেনিয়া',
 			'AM' => 'আৰ্মেনিয়া',
 			'AO' => 'এংগোলা',
 			'AQ' => 'এণ্টাৰ্কটিকা',
 			'AR' => 'আৰ্জেণ্টিনা',
 			'AS' => 'আমেৰিকান চামোৱা',
 			'AT' => 'অষ্ট্ৰিয়া',
 			'AU' => 'অষ্ট্ৰেলিয়া',
 			'AW' => 'আৰুবা',
 			'AX' => 'আলণ্ড দ্বীপপুঞ্জ',
 			'AZ' => 'আজাৰবেইজান',
 			'BA' => 'ব’ছনিয়া আৰু হাৰ্জেগ’ভিনা',
 			'BB' => 'বাৰ্বাডোচ',
 			'BD' => 'বাংলাদেশ',
 			'BE' => 'বেলজিয়াম',
 			'BF' => 'বুৰকিনা ফাচো',
 			'BG' => 'বুলগেৰিয়া',
 			'BH' => 'বাহৰেইন',
 			'BI' => 'বুৰুণ্ডি',
 			'BJ' => 'বেনিন',
 			'BL' => 'ছেইণ্ট বাৰ্থলেমে',
 			'BM' => 'বাৰ্মুডা',
 			'BN' => 'ব্ৰুনেই',
 			'BO' => 'বলিভিয়া',
 			'BQ' => 'কেৰিবিয়ান নেদাৰলেণ্ডছ',
 			'BR' => 'ব্ৰাজিল',
 			'BS' => 'বাহামাছ',
 			'BT' => 'ভুটান',
 			'BV' => 'বুভে দ্বীপ',
 			'BW' => 'ব’টচোৱানা',
 			'BY' => 'বেলাৰুছ',
 			'BZ' => 'বেলিজ',
 			'CA' => 'কানাডা',
 			'CC' => 'কোকোচ (কীলিং) দ্বীপপুঞ্জ',
 			'CD' => 'কঙ্গো - কিনচাছা',
 			'CD@alt=variant' => 'কঙ্গো (DRC)',
 			'CF' => 'মধ্য আফ্রিকান প্রজাতন্ত্র',
 			'CG' => 'কঙ্গো - ব্রাজাভিল',
 			'CG@alt=variant' => 'কঙ্গো (প্রজাতন্ত্র)',
 			'CH' => 'চুইজাৰলেণ্ড',
 			'CI' => 'কোটে ডি আইভৰ',
 			'CI@alt=variant' => 'আইভৰী কোষ্ট',
 			'CK' => 'কুক দ্বীপপুঞ্জ',
 			'CL' => 'চিলি',
 			'CM' => 'কেমেৰুণ',
 			'CN' => 'চীন',
 			'CO' => 'কলম্বিয়া',
 			'CP' => 'ক্লিপাৰটোন দ্বীপ',
 			'CR' => 'কোষ্টা ৰিকা',
 			'CU' => 'কিউবা',
 			'CV' => 'কেপ ভার্দে',
 			'CW' => 'কুৰাকাও',
 			'CX' => 'খ্ৰীষ্টমাছ দ্বীপ',
 			'CY' => 'চাইপ্ৰাছ',
 			'CZ' => 'চিজেচিয়া',
 			'CZ@alt=variant' => 'চেক প্রজাতন্ত্র',
 			'DE' => 'জাৰ্মানী',
 			'DG' => 'ডিয়েগো গাৰ্চিয়া',
 			'DJ' => 'জিবুটি',
 			'DK' => 'ডেনমাৰ্ক',
 			'DM' => 'ড’মিনিকা',
 			'DO' => 'ড’মিনিকান ৰিপাব্লিক',
 			'DZ' => 'আলজেৰিয়া',
 			'EA' => 'চেউটা আৰু মেলিলা',
 			'EC' => 'ইকুৱেডৰ',
 			'EE' => 'ইষ্টোনিয়া',
 			'EG' => 'ইজিপ্ত',
 			'EH' => 'পশ্চিমীয় ছাহাৰা',
 			'ER' => 'এৰিত্ৰিয়া',
 			'ES' => 'স্পেইন',
 			'ET' => 'ইথিঅ’পিয়া',
 			'EU' => 'ইউৰোপীয় সংঘ',
 			'EZ' => 'ইউৰোজ’ন',
 			'FI' => 'ফিনলেণ্ড',
 			'FJ' => 'ফিজি',
 			'FK' => 'ফকলেণ্ড দ্বীপপুঞ্জ',
 			'FK@alt=variant' => 'ফকলেণ্ড দ্বীপপুঞ্জ (আইলেছ মালভিনাছ)',
 			'FM' => 'মাইক্ৰোনেচিয়া',
 			'FO' => 'ফাৰো দ্বীপপুঞ্জ',
 			'FR' => 'ফ্ৰান্স',
 			'GA' => 'গেবন',
 			'GB' => 'সংযুক্ত ৰাজ্য',
 			'GB@alt=short' => 'ইউ. কে.',
 			'GD' => 'গ্ৰেনাডা',
 			'GE' => 'জৰ্জিয়া',
 			'GF' => 'ফ্ৰান্স গয়ানা',
 			'GG' => 'গোৰেনচি',
 			'GH' => 'ঘানা',
 			'GI' => 'জিব্ৰাল্টৰ',
 			'GL' => 'গ্ৰীণলেণ্ড',
 			'GM' => 'গাম্বিয়া',
 			'GN' => 'গিনি',
 			'GP' => 'গুৱাডেলুপ',
 			'GQ' => 'ইকুৱেটৰিয়েল গিনি',
 			'GR' => 'গ্ৰীচ',
 			'GS' => 'দক্ষিণ জৰ্জিয়া আৰু দক্ষিণ চেণ্ডৱিচ দ্বীপপুঞ্জ',
 			'GT' => 'গুৱাটেমালা',
 			'GU' => 'গুৱাম',
 			'GW' => 'গিনি-বিছাও',
 			'GY' => 'গায়ানা',
 			'HK' => 'হং কং এছ. এ. আৰ. চীন',
 			'HK@alt=short' => 'হং কং',
 			'HM' => 'হাৰ্ড দ্বীপ আৰু মেকডোনাল্ড দ্বীপপুঞ্জ',
 			'HN' => 'হন্দুৰাছ',
 			'HR' => 'ক্ৰোৱেছিয়া',
 			'HT' => 'হাইটি',
 			'HU' => 'হাংগেৰী',
 			'IC' => 'কেনেৰী দ্বীপপুঞ্জ',
 			'ID' => 'ইণ্ডোনেচিয়া',
 			'IE' => 'আয়াৰলেণ্ড',
 			'IL' => 'ইজৰাইল',
 			'IM' => 'আইল অফ মেন',
 			'IN' => 'ভাৰত',
 			'IO' => 'ব্ৰিটিছ ইণ্ডিয়ান অ’চন টেৰিট’ৰি',
 			'IQ' => 'ইৰাক',
 			'IR' => 'ইৰান',
 			'IS' => 'আইচলেণ্ড',
 			'IT' => 'ইটালি',
 			'JE' => 'জাৰ্চি',
 			'JM' => 'জামাইকা',
 			'JO' => 'জৰ্ডান',
 			'JP' => 'জাপান',
 			'KE' => 'কেনিয়া',
 			'KG' => 'কিৰ্গিজস্তান',
 			'KH' => 'কম্বোডিয়া',
 			'KI' => 'কিৰিবাটি',
 			'KM' => 'কোমোৰোজ',
 			'KN' => 'ছেইণ্ট কিটছ আৰু নেভিছ',
 			'KP' => 'উত্তৰ কোৰিয়া',
 			'KR' => 'দক্ষিণ কোৰিয়া',
 			'KW' => 'কুৱেইট',
 			'KY' => 'কেইমেন দ্বীপপুঞ্জ',
 			'KZ' => 'কাজাখাস্তান',
 			'LA' => 'লাওচ',
 			'LB' => 'লেবানন',
 			'LC' => 'ছেইণ্ট লুচিয়া',
 			'LI' => 'লিচটেনষ্টেইন',
 			'LK' => 'শ্রীলংকা',
 			'LR' => 'লিবেৰিয়া',
 			'LS' => 'লেছ’থ’',
 			'LT' => 'লিথুৱানিয়া',
 			'LU' => 'লাক্সেমবাৰ্গ',
 			'LV' => 'লাটভিয়া',
 			'LY' => 'লিবিয়া',
 			'MA' => 'মৰক্কো',
 			'MC' => 'মোনাকো',
 			'MD' => 'মোলডোভা',
 			'ME' => 'মণ্টেনেগ্ৰু',
 			'MF' => 'ছেইণ্ট মাৰ্টিন',
 			'MG' => 'মাদাগাস্কাৰ',
 			'MH' => 'মাৰ্শ্বাল দ্বীপপুঞ্জ',
 			'MK' => 'উত্তৰ মেচিডোনীয়া',
 			'ML' => 'মালি',
 			'MM' => 'ম্যানমাৰ (বাৰ্মা)',
 			'MN' => 'মঙ্গোলিয়া',
 			'MO' => 'মাকাও এছ. এ. আৰ. চীন',
 			'MO@alt=short' => 'মাকাও',
 			'MP' => 'উত্তৰ মাৰিয়ানা দ্বীপপুঞ্জ',
 			'MQ' => 'মাৰ্টিনিক',
 			'MR' => 'মাউৰিটানিয়া',
 			'MS' => 'ম’ণ্টছেৰাট',
 			'MT' => 'মাল্টা',
 			'MU' => 'মৰিছাছ',
 			'MV' => 'মালদ্বীপ',
 			'MW' => 'মালাৱি',
 			'MX' => 'মেক্সিকো',
 			'MY' => 'মালয়েচিয়া',
 			'MZ' => 'ম’জামবিক',
 			'NA' => 'নামিবিয়া',
 			'NC' => 'নিউ কেলিডোনিয়া',
 			'NE' => 'নাইজাৰ',
 			'NF' => 'ন’ৰফ’ক দ্বীপ',
 			'NG' => 'নাইজেৰিয়া',
 			'NI' => 'নিকাৰাগুৱা',
 			'NL' => 'নেডাৰলেণ্ড',
 			'NO' => 'নৰৱে',
 			'NP' => 'নেপাল',
 			'NR' => 'নাউৰু',
 			'NU' => 'নিউ',
 			'NZ' => 'নিউজিলেণ্ড',
 			'OM' => 'ওমান',
 			'PA' => 'পানামা',
 			'PE' => 'পেৰু',
 			'PF' => 'ফ্ৰান্স পোলেনচিয়া',
 			'PG' => 'পাপুৱা নিউ গিনি',
 			'PH' => 'ফিলিপাইনছ',
 			'PK' => 'পাকিস্তান',
 			'PL' => 'পোলেণ্ড',
 			'PM' => 'ছেইণ্ট পিয়েৰে আৰু মিকিউৱেলন',
 			'PN' => 'পিটকেইৰ্ণ দ্বীপপুঞ্জ',
 			'PR' => 'পুৱেৰ্টো ৰিকো',
 			'PS' => 'ফিলিস্তিন অঞ্চল',
 			'PS@alt=short' => 'ফিলিস্তিন',
 			'PT' => 'পৰ্তুগাল',
 			'PW' => 'পালাউ',
 			'PY' => 'পাৰাগুৱে',
 			'QA' => 'কাটাৰ',
 			'QO' => 'আউটলায়িং অ’চিয়ানিয়া',
 			'RE' => 'ৰিইউনিয়ন',
 			'RO' => 'ৰোমানিয়া',
 			'RS' => 'ছাৰ্বিয়া',
 			'RU' => 'ৰাছিয়া',
 			'RW' => 'ৰোৱাণ্ডা',
 			'SA' => 'চৌডি আৰবিয়া',
 			'SB' => 'চোলোমোন দ্বীপপুঞ্জ',
 			'SC' => 'ছিচিলিছ',
 			'SD' => 'চুডান',
 			'SE' => 'চুইডেন',
 			'SG' => 'ছিংগাপুৰ',
 			'SH' => 'ছেইণ্ট হেলেনা',
 			'SI' => 'শ্লোভেনিয়া',
 			'SJ' => 'চাভালবাৰ্ড আৰু জন মেয়ন',
 			'SK' => 'শ্লোভাকিয়া',
 			'SL' => 'চিয়েৰা লিঅ’ন',
 			'SM' => 'চান মাৰিনো',
 			'SN' => 'চেনেগাল',
 			'SO' => 'চোমালিয়া',
 			'SR' => 'ছুৰিনাম',
 			'SS' => 'দক্ষিণ চুডান',
 			'ST' => 'চাও টোমে আৰু প্ৰিনচিপে',
 			'SV' => 'এল ছেলভেড’ৰ',
 			'SX' => 'চিণ্ট মাৰ্টেন',
 			'SY' => 'চিৰিয়া',
 			'SZ' => 'ইচ্চুটিনি',
 			'SZ@alt=variant' => 'স্বাজিলেণ্ড',
 			'TA' => 'ত্ৰিস্তান দ্যা কুনহা',
 			'TC' => 'টাৰ্কছ অৰু কেইক’ছ দ্বীপপুঞ্জ',
 			'TD' => 'চাড',
 			'TF' => 'দক্ষিণ ফ্ৰান্সৰ অঞ্চল',
 			'TG' => 'টোগো',
 			'TH' => 'থাইলেণ্ড',
 			'TJ' => 'তাজিকিস্তান',
 			'TK' => 'টোকেলাউ',
 			'TL' => 'টিমোৰ-লেচটে',
 			'TL@alt=variant' => 'পূৱ টিমোৰ',
 			'TM' => 'তুৰ্কমেনিস্তান',
 			'TN' => 'টুনিচিয়া',
 			'TO' => 'টংগা',
 			'TR' => 'তুৰ্কি',
 			'TT' => 'ট্ৰিনিডাড আৰু টোবাগো',
 			'TV' => 'টুভালু',
 			'TW' => 'টাইৱান',
 			'TZ' => 'তাঞ্জানিয়া',
 			'UA' => 'ইউক্ৰেইন',
 			'UG' => 'উগাণ্ডা',
 			'UM' => 'ইউ. এছ. আউটলায়িং দ্বীপপুঞ্জ',
 			'UN' => 'ৰাষ্ট্ৰসংঘ',
 			'US' => 'মাৰ্কিন যুক্তৰাষ্ট্ৰ',
 			'US@alt=short' => 'মা. যু.',
 			'UY' => 'উৰুগুৱে',
 			'UZ' => 'উজবেকিস্তান',
 			'VA' => 'ভেটিকান চিটি',
 			'VC' => 'ছেইণ্ট ভিনচেণ্ট আৰু গ্ৰীণাডাইনছ',
 			'VE' => 'ভেনিজুৱেলা',
 			'VG' => 'ব্ৰিটিছ ভাৰ্জিন দ্বীপপুঞ্জ',
 			'VI' => 'ইউ. এছ. ভাৰ্জিন দ্বীপপুঞ্জ',
 			'VN' => 'ভিয়েটনাম',
 			'VU' => 'ভানাটু',
 			'WF' => 'ৱালিছ আৰু ফুটুনা',
 			'WS' => 'চামোৱা',
 			'XA' => 'ছুডু-একচেণ্ট',
 			'XB' => 'ছুডু-বিডি',
 			'XK' => 'কচ’ভ’',
 			'YE' => 'য়েমেন',
 			'YT' => 'মায়োট্টে',
 			'ZA' => 'দক্ষিণ আফ্রিকা',
 			'ZM' => 'জাম্বিয়া',
 			'ZW' => 'জিম্বাবৱে',
 			'ZZ' => 'অজ্ঞাত ক্ষেত্ৰ',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'কেলেণ্ডাৰ',
 			'cf' => 'মুদ্ৰা সজ্জা',
 			'collation' => 'সজোৱা ক্ৰম',
 			'currency' => 'মুদ্ৰা',
 			'hc' => 'ঘণ্টীয়া চক্ৰ (১২ বনাম ২৪)',
 			'lb' => 'পংক্তি বিচ্ছেদ শৈলী',
 			'ms' => 'জোখ-মাখৰ প্ৰণালী',
 			'numbers' => 'সংখ্যা',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{বৌদ্ধ কেলেণ্ডাৰ},
 				'chinese' => q{চীনা কেলেণ্ডাৰ},
 				'dangi' => q{দাংগি কেলেণ্ডাৰ},
 				'ethiopic' => q{ইথিঅ’পিক কেলেণ্ডাৰ},
 				'gregorian' => q{গ্ৰেগোৰিয়ান কেলেণ্ডাৰ},
 				'hebrew' => q{হিব্ৰু কেলেণ্ডাৰ},
 				'indian' => q{ভাৰতীয় ৰাষ্ট্ৰীয় পঞ্জিকা},
 				'islamic' => q{ইছলামী কেলেণ্ডাৰ},
 				'islamic-civil' => q{ইচলামী-নাগৰিকৰ পঞ্জিকা},
 				'iso8601' => q{আই. এছ. অ’.-৮৬০১ কেলেণ্ডাৰ},
 				'japanese' => q{জাপানী কেলেণ্ডাৰ},
 				'persian' => q{ফাৰ্চী কেলেণ্ডাৰ},
 				'roc' => q{চীনা প্ৰজাতন্ত্ৰৰ কেলেণ্ডাৰ},
 			},
 			'cf' => {
 				'account' => q{গাণনিক মুদ্ৰা সজ্জা},
 				'standard' => q{মান্য মুদ্ৰা সজ্জা},
 			},
 			'collation' => {
 				'big5han' => q{পৰম্পৰাগত চীনা শৃঙ্খলাবদ্ধ কৰাৰ ক্ৰম - Big5},
 				'ducet' => q{ডিফ’ল্ট ইউনিকোড সজোৱা ক্ৰম},
 				'gb2312han' => q{সৰল চীনা শৃঙ্খলাবদ্ধ কৰাৰ ক্ৰম - GB2312},
 				'phonebook' => q{টেলিফোন বহিৰ মতেশৃঙ্খলাবদ্ধ কৰাৰ ক্ৰম},
 				'pinyin' => q{পিন্‌য়িন শৃঙ্খলাবদ্ধ কৰাৰ ক্ৰম},
 				'search' => q{সাধাৰণ উদ্দেশ্যে অনুসন্ধান},
 				'standard' => q{মান্য সজোৱা ক্ৰম},
 				'stroke' => q{স্ট্ৰোক শৃঙ্খলাবদ্ধ কৰাৰ ক্ৰম},
 				'traditional' => q{পৰম্পৰাগতভাবে শৃঙ্খলাবদ্ধ কৰাৰ ক্ৰম},
 			},
 			'hc' => {
 				'h11' => q{১২ ঘণ্টীয়া প্ৰণালী (০–১১)},
 				'h12' => q{১২ ঘণ্টীয়া প্ৰণালী (১–১২)},
 				'h23' => q{২৪ ঘণ্টীয়া প্ৰণালী (০–২৩)},
 				'h24' => q{২৪ ঘণ্টীয়া প্ৰণালী (১–২৪)},
 			},
 			'lb' => {
 				'loose' => q{ঢিলা পংক্তি বিচ্ছেদ শৈলী},
 				'normal' => q{সাধাৰণ পংক্তি বিচ্ছেদ শৈলী},
 				'strict' => q{কঠোৰ পংক্তি বিচ্ছেদ শৈলী},
 			},
 			'ms' => {
 				'metric' => q{মেট্ৰিক প্ৰণালী},
 				'uksystem' => q{ইম্পেৰিয়েল জোখ-মাখৰ প্ৰণালী},
 				'ussystem' => q{মাৰ্কিন যুক্তৰাষ্ট্ৰৰ জোখ-মাখৰ প্ৰণালী},
 			},
 			'numbers' => {
 				'arab' => q{আৰবী-ভাৰতীয় অংক},
 				'arabext' => q{বিস্তাৰিত আৰবী-ভাৰতীয় অংক},
 				'armn' => q{আৰ্মেনীয় সংখ্যা},
 				'armnlow' => q{আৰ্মেনীয় সৰুফলা সংখ্যা},
 				'beng' => q{বাংলা অংক},
 				'deva' => q{দেৱনাগৰী অংক},
 				'ethi' => q{ইথিঅ’পিক সংখ্যা},
 				'fullwide' => q{পূৰ্ণ-প্ৰস্থৰ অংক},
 				'geor' => q{জৰ্জীয়ান সংখ্যা},
 				'grek' => q{গ্ৰীক সংখ্যা},
 				'greklow' => q{গ্ৰীক সৰুফলা সংখ্যা},
 				'gujr' => q{গুজৰাটী অংক},
 				'guru' => q{গুৰুমুখী অংক},
 				'hanidec' => q{চীনা দশমিক সংখ্যা},
 				'hans' => q{সৰলীকৃত চীনা সংখ্যা},
 				'hansfin' => q{সৰলীকৃত চীনা বিত্তীয় সংখ্যা},
 				'hant' => q{পৰম্পৰাগত চীনা সংখ্যা},
 				'hantfin' => q{পৰম্পৰাগত চীনা বিত্তীয় সংখ্যা},
 				'hebr' => q{হিব্ৰু সংখ্যা},
 				'jpan' => q{জাপানী সংখ্যা},
 				'jpanfin' => q{জাপানী বিত্তীয় সংখ্যা},
 				'khmr' => q{খমেৰ অংক},
 				'knda' => q{কানাড়া অংক},
 				'laoo' => q{লাও অংক},
 				'latn' => q{পশ্চিমীয়া অংক},
 				'mlym' => q{মালায়ালম অংক},
 				'mymr' => q{ম্যানমাৰ অংক},
 				'orya' => q{ওড়িয়া অংক},
 				'roman' => q{ৰোমান সংখ্যা},
 				'romanlow' => q{ৰোমান সৰুফলা সংখ্যা},
 				'taml' => q{পৰম্পৰাগত তামিল সংখ্যা},
 				'tamldec' => q{তামিল অংক},
 				'telu' => q{তেলুগু অংক},
 				'thai' => q{থাই অংক},
 				'tibt' => q{তিব্বতী অংক},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{মেট্ৰিক},
 			'UK' => q{ইউ. কে.},
 			'US' => q{ইউ. এছ.},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'ভাষা: {0}',
 			'script' => 'লিপি: {0}',
 			'region' => 'ক্ষেত্ৰ: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[‌‍ ৲ ৎ র]},
			index => ['\u09BC', 'অ', 'আ', 'ই', 'ঈ', 'উ', 'ঊ', 'ঋ', 'এ', 'ঐ', 'ও', 'ঔ', 'ং', 'ঃ', 'ক', 'খ', 'গ', 'ঘ', 'ঙ', 'চ', 'ছ', 'জ', 'ঝ', 'ঞ', 'ট', 'ঠ', 'ড', 'ঢ', 'ণ', 'ৎ', 'ত', 'থ', 'দ', 'ধ', 'ন', 'প', 'ফ', 'ব', 'ভ', 'ম', 'য', 'ৰ', 'ল', 'ৱ', 'শ', 'ষ', 'স', 'হ', '\u09CD'],
			main => qr{[় অ আ ই ঈ উ ঊ ঋ এ ঐ ও ঔ ং ঁ ঃ ক খ গ ঘ ঙ চ ছ জ ঝ ঞ ট ঠ ড {ড়} ঢ {ঢ়} ণ ত থ দ ধ ন প ফ ব ভ ম য {য়} ৰ ল ৱ শ ষ স হ {ক্ষ} া ি ী ু ূ ৃ ে ৈ ো ৌ ্]},
			numbers => qr{[\- ‑ , . % ‰ + 0০ 1১ 2২ 3৩ 4৪ 5৫ 6৬ 7৭ 8৮ 9৯]},
			punctuation => qr{[\- ‐ ‑ – — , ; \: ! ? . … । ' ‘ ’ " “ ” ( ) \[ \] § @ * / \& # † ‡ ′ ″]},
		};
	},
EOT
: sub {
		return { index => ['\u09BC', 'অ', 'আ', 'ই', 'ঈ', 'উ', 'ঊ', 'ঋ', 'এ', 'ঐ', 'ও', 'ঔ', 'ং', 'ঃ', 'ক', 'খ', 'গ', 'ঘ', 'ঙ', 'চ', 'ছ', 'জ', 'ঝ', 'ঞ', 'ট', 'ঠ', 'ড', 'ঢ', 'ণ', 'ৎ', 'ত', 'থ', 'দ', 'ধ', 'ন', 'প', 'ফ', 'ব', 'ভ', 'ম', 'য', 'ৰ', 'ল', 'ৱ', 'শ', 'ষ', 'স', 'হ', '\u09CD'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(প্ৰধান দিক্-নিৰ্দেশনা),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(প্ৰধান দিক্-নিৰ্দেশনা),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(কিবি{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(কিবি{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(মেবি{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(মেবি{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(গিবি{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(গিবি{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(টেবি{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(টেবি{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(পেবি{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(পেবি{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(এক্সবি{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(এক্সবি{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(জেবি{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(জেবি{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(য়োবে{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(য়োবে{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(ডেচি{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(ডেচি{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(পিকো{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(পিকো{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ফেমটো{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ফেমটো{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(অটো{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(অটো{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(চেণ্টি{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(চেণ্টি{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(জেপ্টো{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(জেপ্টো{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(য়ক্টো{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(য়ক্টো{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(মিলি{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(মিলি{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(মাইক্ৰ’{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(মাইক্ৰ’{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(নেনো{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(নেনো{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ডেকা{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ডেকা{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(টেৰা{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(টেৰা{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(পেটা{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(পেটা{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(এক্সা{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(এক্সা{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(হেক্টো{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(হেক্টো{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(জেতা{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(জেতা{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(য়োটা{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(য়োটা{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(কিলো{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(কিলো{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(মেগা{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(মেগা{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(গিগা{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(গিগা{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(জি-বল),
						'one' => q({0} জি-বল),
						'other' => q({0} জি-বল),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(জি-বল),
						'one' => q({0} জি-বল),
						'other' => q({0} জি-বল),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(মিটাৰ প্ৰতি বৰ্গ ছেকেণ্ড),
						'one' => q({0} মিটাৰ প্ৰতি বৰ্গ ছেকেণ্ড),
						'other' => q({0} মিটাৰ প্ৰতি বৰ্গ ছেকেণ্ড),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(মিটাৰ প্ৰতি বৰ্গ ছেকেণ্ড),
						'one' => q({0} মিটাৰ প্ৰতি বৰ্গ ছেকেণ্ড),
						'other' => q({0} মিটাৰ প্ৰতি বৰ্গ ছেকেণ্ড),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(আৰ্কমিনিট),
						'one' => q({0} আৰ্কমিনিট),
						'other' => q({0} আৰ্কমিনিট),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(আৰ্কমিনিট),
						'one' => q({0} আৰ্কমিনিট),
						'other' => q({0} আৰ্কমিনিট),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(আৰ্কছেকেণ্ড),
						'one' => q({0} আৰ্কছেকেণ্ড),
						'other' => q({0} আৰ্কছেকেণ্ড),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(আৰ্কছেকেণ্ড),
						'one' => q({0} আৰ্কছেকেণ্ড),
						'other' => q({0} আৰ্কছেকেণ্ড),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(ডিগ্ৰী),
						'one' => q({0} ডিগ্ৰী),
						'other' => q({0} ডিগ্ৰী),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(ডিগ্ৰী),
						'one' => q({0} ডিগ্ৰী),
						'other' => q({0} ডিগ্ৰী),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(ৰেডিয়েন),
						'one' => q({0} ৰেডিয়েন),
						'other' => q({0} ৰেডিয়েন),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(ৰেডিয়েন),
						'one' => q({0} ৰেডিয়েন),
						'other' => q({0} ৰেডিয়েন),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(ঘূৰ্ণন),
						'one' => q({0} ঘূৰ্ণন),
						'other' => q({0} ঘূৰ্ণন),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(ঘূৰ্ণন),
						'one' => q({0} ঘূৰ্ণন),
						'other' => q({0} ঘূৰ্ণন),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(একৰ),
						'one' => q({0} একৰ),
						'other' => q({0} একৰ),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(একৰ),
						'one' => q({0} একৰ),
						'other' => q({0} একৰ),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(ডুনাম),
						'one' => q({0} ডুনাম),
						'other' => q({0} ডুনাম),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(ডুনাম),
						'one' => q({0} ডুনাম),
						'other' => q({0} ডুনাম),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(হেক্টৰ),
						'one' => q({0} হেক্টৰ),
						'other' => q({0} হেক্টৰ),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(হেক্টৰ),
						'one' => q({0} হেক্টৰ),
						'other' => q({0} হেক্টৰ),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(বৰ্গ ছেণ্টিমিটাৰ),
						'one' => q({0} বৰ্গ ছেণ্টিমিটাৰ),
						'other' => q({0} বৰ্গ ছেণ্টিমিটাৰ),
						'per' => q({0} বৰ্গ ছেণ্টিমিটাৰ),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(বৰ্গ ছেণ্টিমিটাৰ),
						'one' => q({0} বৰ্গ ছেণ্টিমিটাৰ),
						'other' => q({0} বৰ্গ ছেণ্টিমিটাৰ),
						'per' => q({0} বৰ্গ ছেণ্টিমিটাৰ),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(বৰ্গ ফুট),
						'one' => q({0} বৰ্গ ফুট),
						'other' => q({0} বৰ্গ ফুট),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(বৰ্গ ফুট),
						'one' => q({0} বৰ্গ ফুট),
						'other' => q({0} বৰ্গ ফুট),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(বৰ্গ ইঞ্চি),
						'one' => q({0} বৰ্গ ইঞ্চি),
						'other' => q({0} বৰ্গ ইঞ্চি),
						'per' => q({0} প্ৰতি বৰ্গ ইঞ্চি),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(বৰ্গ ইঞ্চি),
						'one' => q({0} বৰ্গ ইঞ্চি),
						'other' => q({0} বৰ্গ ইঞ্চি),
						'per' => q({0} প্ৰতি বৰ্গ ইঞ্চি),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(বৰ্গ কিলোমিটাৰ),
						'one' => q({0} বৰ্গ কিলোমিটাৰ),
						'other' => q({0} বৰ্গ কিলোমিটাৰ),
						'per' => q({0} প্ৰতি বৰ্গ কিলোমিটাৰ),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(বৰ্গ কিলোমিটাৰ),
						'one' => q({0} বৰ্গ কিলোমিটাৰ),
						'other' => q({0} বৰ্গ কিলোমিটাৰ),
						'per' => q({0} প্ৰতি বৰ্গ কিলোমিটাৰ),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(বৰ্গ মিটাৰ),
						'one' => q({0} বৰ্গ মিটাৰ),
						'other' => q({0} বৰ্গ মিটাৰ),
						'per' => q({0} বৰ্গ মিটাৰ),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(বৰ্গ মিটাৰ),
						'one' => q({0} বৰ্গ মিটাৰ),
						'other' => q({0} বৰ্গ মিটাৰ),
						'per' => q({0} বৰ্গ মিটাৰ),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(বৰ্গ মাইল),
						'one' => q({0} বৰ্গ মাইল),
						'other' => q({0} বৰ্গ মাইল),
						'per' => q({0} প্ৰতি বৰ্গ মাইল),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(বৰ্গ মাইল),
						'one' => q({0} বৰ্গ মাইল),
						'other' => q({0} বৰ্গ মাইল),
						'per' => q({0} প্ৰতি বৰ্গ মাইল),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(বৰ্গ গজ),
						'one' => q({0} বৰ্গ গজ),
						'other' => q({0} বৰ্গ গজ),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(বৰ্গ গজ),
						'one' => q({0} বৰ্গ গজ),
						'other' => q({0} বৰ্গ গজ),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(আইটেমসমূহ),
						'one' => q({0} টা আইটেম),
						'other' => q({0} টা আইটেম),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(আইটেমসমূহ),
						'one' => q({0} টা আইটেম),
						'other' => q({0} টা আইটেম),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(কেৰেট),
						'one' => q({0} কেৰেট),
						'other' => q({0} কেৰেট),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(কেৰেট),
						'one' => q({0} কেৰেট),
						'other' => q({0} কেৰেট),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(প্ৰতি ডেচিলিটাৰত মিলিগ্ৰাম),
						'one' => q(প্ৰতি ডেচিলিটাৰত {0} মিলিগ্ৰাম),
						'other' => q(প্ৰতি ডেচিলিটাৰত {0} মিলিগ্ৰাম),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(প্ৰতি ডেচিলিটাৰত মিলিগ্ৰাম),
						'one' => q(প্ৰতি ডেচিলিটাৰত {0} মিলিগ্ৰাম),
						'other' => q(প্ৰতি ডেচিলিটাৰত {0} মিলিগ্ৰাম),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(প্ৰতি লিটাৰত মিলিমোল),
						'one' => q(প্ৰতি লিটাৰত {0} মিলিমোল),
						'other' => q(প্ৰতি লিটাৰত {0} মিলিমোল),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(প্ৰতি লিটাৰত মিলিমোল),
						'one' => q(প্ৰতি লিটাৰত {0} মিলিমোল),
						'other' => q(প্ৰতি লিটাৰত {0} মিলিমোল),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(ম’ল),
						'one' => q({0} ম’ল),
						'other' => q({0} ম’ল),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(ম’ল),
						'one' => q({0} ম’ল),
						'other' => q({0} ম’ল),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(%),
						'one' => q({0} শতাংশ),
						'other' => q({0} শতাংশ),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(%),
						'one' => q({0} শতাংশ),
						'other' => q({0} শতাংশ),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(প্ৰতিমাইল),
						'one' => q({0} প্ৰতিমাইল),
						'other' => q({0} প্ৰতিমাইল),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(প্ৰতিমাইল),
						'one' => q({0} প্ৰতিমাইল),
						'other' => q({0} প্ৰতিমাইল),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(প্ৰতি মিলিয়নত ভাগ),
						'one' => q(প্ৰতি মিলিয়নত {0} ভাগ),
						'other' => q(প্ৰতি মিলিয়নত {0} ভাগ),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(প্ৰতি মিলিয়নত ভাগ),
						'one' => q(প্ৰতি মিলিয়নত {0} ভাগ),
						'other' => q(প্ৰতি মিলিয়নত {0} ভাগ),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(পাৰমিৰেইড),
						'one' => q({0} পাৰমিৰেইড),
						'other' => q({0} পাৰমিৰেইড),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(পাৰমিৰেইড),
						'one' => q({0} পাৰমিৰেইড),
						'other' => q({0} পাৰমিৰেইড),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(প্ৰতি ১০০ কিলোমিটাৰত লিটাৰ),
						'one' => q(প্ৰতি ১০০ কিলোমিটাৰত {0} লিটাৰ),
						'other' => q(প্ৰতি ১০০ কিলোমিটাৰত {0} লিটাৰ),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(প্ৰতি ১০০ কিলোমিটাৰত লিটাৰ),
						'one' => q(প্ৰতি ১০০ কিলোমিটাৰত {0} লিটাৰ),
						'other' => q(প্ৰতি ১০০ কিলোমিটাৰত {0} লিটাৰ),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(প্ৰতি কিলোমিটাৰত লিটাৰ),
						'one' => q(প্ৰতি কিলোমিটাৰত {0} লিটাৰ),
						'other' => q(প্ৰতি কিলোমিটাৰত {0} লিটাৰ),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(প্ৰতি কিলোমিটাৰত লিটাৰ),
						'one' => q(প্ৰতি কিলোমিটাৰত {0} লিটাৰ),
						'other' => q(প্ৰতি কিলোমিটাৰত {0} লিটাৰ),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(প্ৰতি গেলনত মাইল),
						'one' => q(প্ৰতি গেলনত {0} মাইল),
						'other' => q(প্ৰতি গেলনত {0} মাইল),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(প্ৰতি গেলনত মাইল),
						'one' => q(প্ৰতি গেলনত {0} মাইল),
						'other' => q(প্ৰতি গেলনত {0} মাইল),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(প্ৰতি ইম্পেৰিয়াল গেলনত মাইল),
						'one' => q(প্ৰতি ইম্পেৰিয়াল গেলনত {0} মাইল),
						'other' => q(প্ৰতি ইম্পেৰিয়াল গেলনত {0} মাইল),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(প্ৰতি ইম্পেৰিয়াল গেলনত মাইল),
						'one' => q(প্ৰতি ইম্পেৰিয়াল গেলনত {0} মাইল),
						'other' => q(প্ৰতি ইম্পেৰিয়াল গেলনত {0} মাইল),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} পূব),
						'north' => q({0} উত্তৰ),
						'south' => q({0} দক্ষিণ),
						'west' => q({0} পশ্চিম),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} পূব),
						'north' => q({0} উত্তৰ),
						'south' => q({0} দক্ষিণ),
						'west' => q({0} পশ্চিম),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(বিট),
						'one' => q({0} বিট),
						'other' => q({0} বিট),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(বিট),
						'one' => q({0} বিট),
						'other' => q({0} বিট),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(বাইট),
						'one' => q({0} বাইট),
						'other' => q({0} বাইট),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(বাইট),
						'one' => q({0} বাইট),
						'other' => q({0} বাইট),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(গিগাবিট),
						'one' => q({0} গিগাবিট),
						'other' => q({0} গিগাবিট),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(গিগাবিট),
						'one' => q({0} গিগাবিট),
						'other' => q({0} গিগাবিট),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(গিগাবাইট),
						'one' => q({0} গিগাবাইট),
						'other' => q({0} গিগাবাইট),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(গিগাবাইট),
						'one' => q({0} গিগাবাইট),
						'other' => q({0} গিগাবাইট),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(কিলোবিট),
						'one' => q({0} কিলোবিট),
						'other' => q({0} কিলোবিট),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(কিলোবিট),
						'one' => q({0} কিলোবিট),
						'other' => q({0} কিলোবিট),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(কিলোবাইট),
						'one' => q({0} কিলোবাইট),
						'other' => q({0} কিলোবাইট),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(কিলোবাইট),
						'one' => q({0} কিলোবাইট),
						'other' => q({0} কিলোবাইট),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(মেগাবিট),
						'one' => q({0} মেগাবিট),
						'other' => q({0} মেগাবিট),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(মেগাবিট),
						'one' => q({0} মেগাবিট),
						'other' => q({0} মেগাবিট),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(মেগাবাইট),
						'one' => q({0} মেগাবাইট),
						'other' => q({0} মেগাবাইট),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(মেগাবাইট),
						'one' => q({0} মেগাবাইট),
						'other' => q({0} মেগাবাইট),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(পেটাবাইট),
						'one' => q({0} পেটাবাইট),
						'other' => q({0} পেটাবাইট),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(পেটাবাইট),
						'one' => q({0} পেটাবাইট),
						'other' => q({0} পেটাবাইট),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(টেৰাবিট),
						'one' => q({0} টেৰাবিট),
						'other' => q({0} টেৰাবিট),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(টেৰাবিট),
						'one' => q({0} টেৰাবিট),
						'other' => q({0} টেৰাবিট),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(টেৰাবাইট),
						'one' => q({0} টেৰাবাইট),
						'other' => q({0} টেৰাবাইট),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(টেৰাবাইট),
						'one' => q({0} টেৰাবাইট),
						'other' => q({0} টেৰাবাইট),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(শতাব্দী),
						'one' => q({0} শতাব্দী),
						'other' => q({0} শতাব্দী),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(শতাব্দী),
						'one' => q({0} শতাব্দী),
						'other' => q({0} শতাব্দী),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(দিন),
						'one' => q({0} দিন),
						'other' => q({0} দিন),
						'per' => q({0} প্ৰতি দিন),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(দিন),
						'one' => q({0} দিন),
						'other' => q({0} দিন),
						'per' => q({0} প্ৰতি দিন),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(দশক),
						'one' => q({0} দশক),
						'other' => q({0} দশক),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(দশক),
						'one' => q({0} দশক),
						'other' => q({0} দশক),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ঘণ্টা),
						'one' => q({0} ঘণ্টা),
						'other' => q({0} ঘণ্টা),
						'per' => q({0} প্ৰতি ঘণ্টা),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ঘণ্টা),
						'one' => q({0} ঘণ্টা),
						'other' => q({0} ঘণ্টা),
						'per' => q({0} প্ৰতি ঘণ্টা),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(মাইক্ৰছেকেণ্ড),
						'one' => q({0} মাইক্ৰছেকেণ্ড),
						'other' => q({0} মাইক্ৰছেকেণ্ড),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(মাইক্ৰছেকেণ্ড),
						'one' => q({0} মাইক্ৰছেকেণ্ড),
						'other' => q({0} মাইক্ৰছেকেণ্ড),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(মিলিছেকেণ্ড),
						'one' => q({0} মিলিছেকেণ্ড),
						'other' => q({0} মিলিছেকেণ্ড),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(মিলিছেকেণ্ড),
						'one' => q({0} মিলিছেকেণ্ড),
						'other' => q({0} মিলিছেকেণ্ড),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(মিনিট),
						'one' => q({0} মিনিট),
						'other' => q({0} মিনিট),
						'per' => q({0} প্ৰতি মিনিট),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(মিনিট),
						'one' => q({0} মিনিট),
						'other' => q({0} মিনিট),
						'per' => q({0} প্ৰতি মিনিট),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(মাহ),
						'one' => q({0} মাহ),
						'other' => q({0} মাহ),
						'per' => q({0} প্ৰতি মাহ),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(মাহ),
						'one' => q({0} মাহ),
						'other' => q({0} মাহ),
						'per' => q({0} প্ৰতি মাহ),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(নেনোছেকেণ্ড),
						'one' => q({0} নেনোছেকেণ্ড),
						'other' => q({0} নেনোছেকেণ্ড),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(নেনোছেকেণ্ড),
						'one' => q({0} নেনোছেকেণ্ড),
						'other' => q({0} নেনোছেকেণ্ড),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ছেকেণ্ড),
						'one' => q({0} ছেকেণ্ড),
						'other' => q({0} ছেকেণ্ড),
						'per' => q({0} প্ৰতি ছেকেণ্ড),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ছেকেণ্ড),
						'one' => q({0} ছেকেণ্ড),
						'other' => q({0} ছেকেণ্ড),
						'per' => q({0} প্ৰতি ছেকেণ্ড),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(সপ্তাহ),
						'one' => q({0} সপ্তাহ),
						'other' => q({0} সপ্তাহ),
						'per' => q({0} প্ৰতি সপ্তাহ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(সপ্তাহ),
						'one' => q({0} সপ্তাহ),
						'other' => q({0} সপ্তাহ),
						'per' => q({0} প্ৰতি সপ্তাহ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(বছৰ),
						'one' => q({0} বছৰ),
						'other' => q({0} বছৰ),
						'per' => q({0} প্ৰতি বছৰ),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(বছৰ),
						'one' => q({0} বছৰ),
						'other' => q({0} বছৰ),
						'per' => q({0} প্ৰতি বছৰ),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(এম্পিয়াৰ),
						'one' => q({0} এম্পিয়াৰ),
						'other' => q({0} এম্পিয়াৰ),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(এম্পিয়াৰ),
						'one' => q({0} এম্পিয়াৰ),
						'other' => q({0} এম্পিয়াৰ),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(মিলিএম্পিয়াৰ),
						'one' => q({0} মিলিএম্পিয়াৰ),
						'other' => q({0} মিলিএম্পিয়াৰ),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(মিলিএম্পিয়াৰ),
						'one' => q({0} মিলিএম্পিয়াৰ),
						'other' => q({0} মিলিএম্পিয়াৰ),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(ওম),
						'one' => q({0} ওম),
						'other' => q({0} ওম),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(ওম),
						'one' => q({0} ওম),
						'other' => q({0} ওম),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(ভল্ট),
						'one' => q({0} ভল্ট),
						'other' => q({0} ভল্ট),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(ভল্ট),
						'one' => q({0} ভল্ট),
						'other' => q({0} ভল্ট),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(ব্ৰিটিশ্ব থাৰ্মেল ইউনিট),
						'one' => q({0} ব্ৰিটিশ্ব থাৰ্মেল ইউনিট),
						'other' => q({0} ব্ৰিটিশ্ব থাৰ্মেল ইউনিট),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(ব্ৰিটিশ্ব থাৰ্মেল ইউনিট),
						'one' => q({0} ব্ৰিটিশ্ব থাৰ্মেল ইউনিট),
						'other' => q({0} ব্ৰিটিশ্ব থাৰ্মেল ইউনিট),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(কেলৰি),
						'one' => q({0} কেলৰি),
						'other' => q({0} কেলৰি),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(কেলৰি),
						'one' => q({0} কেলৰি),
						'other' => q({0} কেলৰি),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(ইলেক্ট্ৰ’নভ’ল্ট),
						'one' => q({0} ইলেক্ট্ৰ’নভ’ল্ট),
						'other' => q({0} ইলেক্ট্ৰ’নভ’ল্ট),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(ইলেক্ট্ৰ’নভ’ল্ট),
						'one' => q({0} ইলেক্ট্ৰ’নভ’ল্ট),
						'other' => q({0} ইলেক্ট্ৰ’নভ’ল্ট),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(কেলৰি),
						'one' => q({0} কেলৰি),
						'other' => q({0} কেলৰি),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(কেলৰি),
						'one' => q({0} কেলৰি),
						'other' => q({0} কেলৰি),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(জুল),
						'one' => q({0} জুল),
						'other' => q({0} জুল),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(জুল),
						'one' => q({0} জুল),
						'other' => q({0} জুল),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(কিলোকেলৰি),
						'one' => q({0} কিলোকেলৰি),
						'other' => q({0} কিলোকেলৰি),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(কিলোকেলৰি),
						'one' => q({0} কিলোকেলৰি),
						'other' => q({0} কিলোকেলৰি),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(কিলোজুল),
						'one' => q({0} কিলোজুল),
						'other' => q({0} কিলোজুল),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(কিলোজুল),
						'one' => q({0} কিলোজুল),
						'other' => q({0} কিলোজুল),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(কিলোৱাট-ঘণ্টা),
						'one' => q({0} কিলোৱাট ঘণ্টা),
						'other' => q({0} কিলোৱাট ঘণ্টা),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(কিলোৱাট-ঘণ্টা),
						'one' => q({0} কিলোৱাট ঘণ্টা),
						'other' => q({0} কিলোৱাট ঘণ্টা),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(ইউ এচ থাৰ্ণ),
						'one' => q({0} ইউ এচ থাৰ্ণ),
						'other' => q({0} ইউ এচ থাৰ্ণ),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(ইউ এচ থাৰ্ণ),
						'one' => q({0} ইউ এচ থাৰ্ণ),
						'other' => q({0} ইউ এচ থাৰ্ণ),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(প্ৰতি 100 কিলোমিটাৰত কিলোৱাট-ঘণ্টা),
						'one' => q(প্ৰতি 100 কিলোমিটাৰত {0} কিলোৱাট-ঘণ্টা),
						'other' => q(প্ৰতি 100 কিলোমিটাৰত {0} কিলোৱাট-ঘণ্টা),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(প্ৰতি 100 কিলোমিটাৰত কিলোৱাট-ঘণ্টা),
						'one' => q(প্ৰতি 100 কিলোমিটাৰত {0} কিলোৱাট-ঘণ্টা),
						'other' => q(প্ৰতি 100 কিলোমিটাৰত {0} কিলোৱাট-ঘণ্টা),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(নিউটন),
						'one' => q({0} নিউটন),
						'other' => q({0} নিউটন),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(নিউটন),
						'one' => q({0} নিউটন),
						'other' => q({0} নিউটন),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(পাউণ্ড-বল),
						'one' => q({0} পাউণ্ড-বল),
						'other' => q({0} পাউণ্ড-বল),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(পাউণ্ড-বল),
						'one' => q({0} পাউণ্ড-বল),
						'other' => q({0} পাউণ্ড-বল),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(গিগাহাৰ্টজ),
						'one' => q({0} গিগাহাৰ্টজ),
						'other' => q({0} গিগাহাৰ্টজ),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(গিগাহাৰ্টজ),
						'one' => q({0} গিগাহাৰ্টজ),
						'other' => q({0} গিগাহাৰ্টজ),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(হাৰ্টজ),
						'one' => q({0} হাৰ্টজ),
						'other' => q({0} হাৰ্টজ),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(হাৰ্টজ),
						'one' => q({0} হাৰ্টজ),
						'other' => q({0} হাৰ্টজ),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(কিলোহাৰ্টজ),
						'one' => q({0} কিলোহাৰ্টজ),
						'other' => q({0} কিলোহাৰ্টজ),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(কিলোহাৰ্টজ),
						'one' => q({0} কিলোহাৰ্টজ),
						'other' => q({0} কিলোহাৰ্টজ),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(মেগাহাৰ্টজ),
						'one' => q({0} মেগাহাৰ্টজ),
						'other' => q({0} মেগাহাৰ্টজ),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(মেগাহাৰ্টজ),
						'one' => q({0} মেগাহাৰ্টজ),
						'other' => q({0} মেগাহাৰ্টজ),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(জ্যোতিৰ্বিজ্ঞান একক),
						'one' => q({0} জ্যোতিৰ্বিজ্ঞান একক),
						'other' => q({0} জ্যোতিৰ্বিজ্ঞান একক),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(জ্যোতিৰ্বিজ্ঞান একক),
						'one' => q({0} জ্যোতিৰ্বিজ্ঞান একক),
						'other' => q({0} জ্যোতিৰ্বিজ্ঞান একক),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(ছেণ্টিমিটাৰ),
						'one' => q({0} ছেণ্টিমিটাৰ),
						'other' => q({0} ছেণ্টিমিটাৰ),
						'per' => q({0} প্ৰতি ছেণ্টিমিটাৰ),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(ছেণ্টিমিটাৰ),
						'one' => q({0} ছেণ্টিমিটাৰ),
						'other' => q({0} ছেণ্টিমিটাৰ),
						'per' => q({0} প্ৰতি ছেণ্টিমিটাৰ),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(ডেচিমিটাৰ),
						'one' => q({0} ডেচিমিটাৰ),
						'other' => q({0} ডেচিমিটাৰ),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(ডেচিমিটাৰ),
						'one' => q({0} ডেচিমিটাৰ),
						'other' => q({0} ডেচিমিটাৰ),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(পৃথিৱীৰ ব্যাসাৰ্ধ),
						'one' => q({0} পৃথিৱীৰ ব্যাসাৰ্ধ),
						'other' => q({0} পৃথিৱীৰ ব্যাসাৰ্ধ),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(পৃথিৱীৰ ব্যাসাৰ্ধ),
						'one' => q({0} পৃথিৱীৰ ব্যাসাৰ্ধ),
						'other' => q({0} পৃথিৱীৰ ব্যাসাৰ্ধ),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(ফাথম),
						'one' => q({0} ফাথম),
						'other' => q({0} ফাথম),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(ফাথম),
						'one' => q({0} ফাথম),
						'other' => q({0} ফাথম),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(ফুট),
						'one' => q({0} ফুট),
						'other' => q({0} ফুট),
						'per' => q({0} প্ৰতি ফুট),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(ফুট),
						'one' => q({0} ফুট),
						'other' => q({0} ফুট),
						'per' => q({0} প্ৰতি ফুট),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(ফাৰ্লং),
						'one' => q({0} ফাৰ্লং),
						'other' => q({0} ফাৰ্লং),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(ফাৰ্লং),
						'one' => q({0} ফাৰ্লং),
						'other' => q({0} ফাৰ্লং),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(ইঞ্চি),
						'one' => q({0} ইঞ্চি),
						'other' => q({0} ইঞ্চি),
						'per' => q({0} প্ৰতি ইঞ্চি),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(ইঞ্চি),
						'one' => q({0} ইঞ্চি),
						'other' => q({0} ইঞ্চি),
						'per' => q({0} প্ৰতি ইঞ্চি),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(কিলোমিটাৰ),
						'one' => q({0} কিলোমিটাৰ),
						'other' => q({0} কিলোমিটাৰ),
						'per' => q({0} প্ৰতি কিলোমিটাৰ),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(কিলোমিটাৰ),
						'one' => q({0} কিলোমিটাৰ),
						'other' => q({0} কিলোমিটাৰ),
						'per' => q({0} প্ৰতি কিলোমিটাৰ),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(আলোকবৰ্ষ),
						'one' => q({0} আলোকবৰ্ষ),
						'other' => q({0} আলোকবৰ্ষ),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(আলোকবৰ্ষ),
						'one' => q({0} আলোকবৰ্ষ),
						'other' => q({0} আলোকবৰ্ষ),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(মিটাৰ),
						'one' => q({0} মিটাৰ),
						'other' => q({0} মিটাৰ),
						'per' => q({0} প্ৰতি মিটাৰ),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(মিটাৰ),
						'one' => q({0} মিটাৰ),
						'other' => q({0} মিটাৰ),
						'per' => q({0} প্ৰতি মিটাৰ),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(মাইক্ৰ’মিটাৰ),
						'one' => q({0} মাইক্ৰ’মিটাৰ),
						'other' => q({0} মাইক্ৰ’মিটাৰ),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(মাইক্ৰ’মিটাৰ),
						'one' => q({0} মাইক্ৰ’মিটাৰ),
						'other' => q({0} মাইক্ৰ’মিটাৰ),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(মাইল),
						'one' => q({0} মাইল),
						'other' => q({0} মাইল),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(মাইল),
						'one' => q({0} মাইল),
						'other' => q({0} মাইল),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(মাইল-স্কেণ্ডিনেভিয়ান),
						'one' => q({0} মাইল-স্কেণ্ডিনেভিয়ান),
						'other' => q({0} মাইল-স্কেণ্ডিনেভিয়ান),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(মাইল-স্কেণ্ডিনেভিয়ান),
						'one' => q({0} মাইল-স্কেণ্ডিনেভিয়ান),
						'other' => q({0} মাইল-স্কেণ্ডিনেভিয়ান),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(মিলিমিটাৰ),
						'one' => q({0} মিলিমিটাৰ),
						'other' => q({0} মিলিমিটাৰ),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(মিলিমিটাৰ),
						'one' => q({0} মিলিমিটাৰ),
						'other' => q({0} মিলিমিটাৰ),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(নেনোমিটাৰ),
						'one' => q({0} নেনোমিটাৰ),
						'other' => q({0} নেনোমিটাৰ),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(নেনোমিটাৰ),
						'one' => q({0} নেনোমিটাৰ),
						'other' => q({0} নেনোমিটাৰ),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(ন’টিকেল মাইল),
						'one' => q({0} ন’টিকেল মাইল),
						'other' => q({0} ন’টিকেল মাইল),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(ন’টিকেল মাইল),
						'one' => q({0} ন’টিকেল মাইল),
						'other' => q({0} ন’টিকেল মাইল),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(পাৰ্ছেক),
						'one' => q({0} পাৰ্ছেক),
						'other' => q({0} পাৰ্ছেক),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(পাৰ্ছেক),
						'one' => q({0} পাৰ্ছেক),
						'other' => q({0} পাৰ্ছেক),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(পিকোমিটাৰ),
						'one' => q({0} পিকোমিটাৰ),
						'other' => q({0} পিকোমিটাৰ),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(পিকোমিটাৰ),
						'one' => q({0} পিকোমিটাৰ),
						'other' => q({0} পিকোমিটাৰ),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(পইণ্ট),
						'one' => q({0} পইণ্ট),
						'other' => q({0} পইণ্ট),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(পইণ্ট),
						'one' => q({0} পইণ্ট),
						'other' => q({0} পইণ্ট),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(সৌৰ ৰেডিয়াছ),
						'one' => q({0} সৌৰ ৰেডিয়াছ),
						'other' => q({0} সৌৰ ৰেডিয়াছ),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(সৌৰ ৰেডিয়াছ),
						'one' => q({0} সৌৰ ৰেডিয়াছ),
						'other' => q({0} সৌৰ ৰেডিয়াছ),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(গজ),
						'one' => q({0} গজ),
						'other' => q({0} গজ),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(গজ),
						'one' => q({0} গজ),
						'other' => q({0} গজ),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(কেণ্ডেলা),
						'one' => q({0} কেণ্ডেলা),
						'other' => q({0} কেণ্ডেলা),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(কেণ্ডেলা),
						'one' => q({0} কেণ্ডেলা),
						'other' => q({0} কেণ্ডেলা),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(লুমেন),
						'one' => q({0} লুমেন),
						'other' => q({0} লুমেন),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(লুমেন),
						'one' => q({0} লুমেন),
						'other' => q({0} লুমেন),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(লাক্স),
						'one' => q({0} লাক্স),
						'other' => q({0} লাক্স),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(লাক্স),
						'one' => q({0} লাক্স),
						'other' => q({0} লাক্স),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(ছ’লাৰ লুমিন’ছিটী),
						'one' => q({0} ছ’লাৰ লুমিন’ছিটী),
						'other' => q({0} ছ’লাৰ লুমিন’ছিটী),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(ছ’লাৰ লুমিন’ছিটী),
						'one' => q({0} ছ’লাৰ লুমিন’ছিটী),
						'other' => q({0} ছ’লাৰ লুমিন’ছিটী),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(কেৰেট),
						'one' => q({0} কেৰেট),
						'other' => q({0} কেৰেট),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(কেৰেট),
						'one' => q({0} কেৰেট),
						'other' => q({0} কেৰেট),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(ডলট’ন),
						'one' => q({0} ডলট’ন),
						'other' => q({0} ডলট’ন),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(ডলট’ন),
						'one' => q({0} ডলট’ন),
						'other' => q({0} ডলট’ন),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(আৰ্থ মাছ),
						'one' => q({0} আৰ্থ মাছ),
						'other' => q({0} আৰ্থ মাছ),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(আৰ্থ মাছ),
						'one' => q({0} আৰ্থ মাছ),
						'other' => q({0} আৰ্থ মাছ),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(গ্ৰেইন),
						'one' => q({0} গ্ৰেইন),
						'other' => q({0} গ্ৰেইন),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(গ্ৰেইন),
						'one' => q({0} গ্ৰেইন),
						'other' => q({0} গ্ৰেইন),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(গ্ৰাম),
						'one' => q({0} গ্ৰাম),
						'other' => q({0} গ্ৰাম),
						'per' => q({0} প্ৰতি গ্ৰাম),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(গ্ৰাম),
						'one' => q({0} গ্ৰাম),
						'other' => q({0} গ্ৰাম),
						'per' => q({0} প্ৰতি গ্ৰাম),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(কিলোগ্রাম),
						'one' => q({0} কিলোগ্ৰাম),
						'other' => q({0} কিলোগ্ৰাম),
						'per' => q({0} প্ৰতি কিলোগ্ৰাম),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(কিলোগ্রাম),
						'one' => q({0} কিলোগ্ৰাম),
						'other' => q({0} কিলোগ্ৰাম),
						'per' => q({0} প্ৰতি কিলোগ্ৰাম),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'name' => q(মেট্রিক টন),
						'one' => q({0} মেট্রিক টন),
						'other' => q({0} মেট্ৰিক টন),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'name' => q(মেট্রিক টন),
						'one' => q({0} মেট্রিক টন),
						'other' => q({0} মেট্ৰিক টন),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(মাইক্ৰোগ্ৰাম),
						'one' => q({0} মাইক্ৰোগ্ৰাম),
						'other' => q({0} মাইক্ৰোগ্ৰাম),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(মাইক্ৰোগ্ৰাম),
						'one' => q({0} মাইক্ৰোগ্ৰাম),
						'other' => q({0} মাইক্ৰোগ্ৰাম),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(মিলিগ্ৰাম),
						'one' => q({0} মিলিগ্ৰাম),
						'other' => q({0} মিলিগ্ৰাম),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(মিলিগ্ৰাম),
						'one' => q({0} মিলিগ্ৰাম),
						'other' => q({0} মিলিগ্ৰাম),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(আউন্স),
						'one' => q({0} আউন্স),
						'other' => q({0} আউন্স),
						'per' => q({0} প্ৰতি আউন্স),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(আউন্স),
						'one' => q({0} আউন্স),
						'other' => q({0} আউন্স),
						'per' => q({0} প্ৰতি আউন্স),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(ট্ৰয় আউন্স),
						'one' => q({0} ট্ৰয় আউন্স),
						'other' => q({0} ট্ৰয় আউন্স),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(ট্ৰয় আউন্স),
						'one' => q({0} ট্ৰয় আউন্স),
						'other' => q({0} ট্ৰয় আউন্স),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(পাউণ্ড),
						'one' => q({0} পাউণ্ড),
						'other' => q({0} পাউণ্ড),
						'per' => q({0} প্ৰতি পাউণ্ড),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(পাউণ্ড),
						'one' => q({0} পাউণ্ড),
						'other' => q({0} পাউণ্ড),
						'per' => q({0} প্ৰতি পাউণ্ড),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(সৌৰ ভৰ),
						'one' => q({0} সৌৰ ভৰ),
						'other' => q({0} সৌৰ ভৰ),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(সৌৰ ভৰ),
						'one' => q({0} সৌৰ ভৰ),
						'other' => q({0} সৌৰ ভৰ),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(ষ্ট’ন),
						'one' => q({0} ষ্ট'ন),
						'other' => q({0} ষ্ট'ন),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(ষ্ট’ন),
						'one' => q({0} ষ্ট'ন),
						'other' => q({0} ষ্ট'ন),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(টন),
						'one' => q({0} টন),
						'other' => q({0} টন),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(টন),
						'one' => q({0} টন),
						'other' => q({0} টন),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q(প্ৰতি {1}ত {0}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q(প্ৰতি {1}ত {0}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(গিগাৱাট),
						'one' => q({0} গিগাৱাট),
						'other' => q({0} গিগাৱাট),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(গিগাৱাট),
						'one' => q({0} গিগাৱাট),
						'other' => q({0} গিগাৱাট),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(অশ্বক্ষমতা),
						'one' => q({0} অশ্বক্ষমতা),
						'other' => q({0} অশ্বক্ষমতা),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(অশ্বক্ষমতা),
						'one' => q({0} অশ্বক্ষমতা),
						'other' => q({0} অশ্বক্ষমতা),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(কিলোৱাট),
						'one' => q({0} কিলোৱাট),
						'other' => q({0} কিলোৱাট),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(কিলোৱাট),
						'one' => q({0} কিলোৱাট),
						'other' => q({0} কিলোৱাট),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(মেগাৱাট),
						'one' => q({0} মেগাৱাট),
						'other' => q({0} মেগাৱাট),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(মেগাৱাট),
						'one' => q({0} মেগাৱাট),
						'other' => q({0} মেগাৱাট),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(মিলিৱাট),
						'one' => q({0} মিলিৱাট),
						'other' => q({0} মিলিৱাট),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(মিলিৱাট),
						'one' => q({0} মিলিৱাট),
						'other' => q({0} মিলিৱাট),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(ৱাট),
						'one' => q({0} ৱাট),
						'other' => q({0} ৱাট),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(ৱাট),
						'one' => q({0} ৱাট),
						'other' => q({0} ৱাট),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q(বৰ্গ {0}),
						'one' => q(বৰ্গ {0}),
						'other' => q(বৰ্গ {0}),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q(বৰ্গ {0}),
						'one' => q(বৰ্গ {0}),
						'other' => q(বৰ্গ {0}),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q(ঘন {0}),
						'one' => q(ঘন {0}),
						'other' => q(ঘন {0}),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q(ঘন {0}),
						'one' => q(ঘন {0}),
						'other' => q(ঘন {0}),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(বতৰ),
						'one' => q({0} বতৰ),
						'other' => q({0} atm),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(বতৰ),
						'one' => q({0} বতৰ),
						'other' => q({0} atm),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(হেক্টোপাছকল),
						'one' => q({0} হেক্টোপাছকল),
						'other' => q({0} হেক্টোপাছকল),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(হেক্টোপাছকল),
						'one' => q({0} হেক্টোপাছকল),
						'other' => q({0} হেক্টোপাছকল),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(ইঞ্চি মাৰ্কিউৰী),
						'one' => q({0} ইঞ্চি মাৰ্কিউৰী),
						'other' => q({0} ইঞ্চি মাৰ্কিউৰী),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(ইঞ্চি মাৰ্কিউৰী),
						'one' => q({0} ইঞ্চি মাৰ্কিউৰী),
						'other' => q({0} ইঞ্চি মাৰ্কিউৰী),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(কিল’পাস্কেল),
						'one' => q({0} কিল’পাস্কেল),
						'other' => q({0} কি. পা.),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(কিল’পাস্কেল),
						'one' => q({0} কিল’পাস্কেল),
						'other' => q({0} কি. পা.),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(মেগাপাস্কেল),
						'one' => q({0} মেগাপাস্কেল),
						'other' => q({0} মেগাপাস্কেল),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(মেগাপাস্কেল),
						'one' => q({0} মেগাপাস্কেল),
						'other' => q({0} মেগাপাস্কেল),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(মিলিবাৰ),
						'one' => q({0} মিলিবাৰ),
						'other' => q({0} মিলিবাৰ),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(মিলিবাৰ),
						'one' => q({0} মিলিবাৰ),
						'other' => q({0} মিলিবাৰ),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(মিলিমিটাৰ মাৰ্কিউৰী),
						'one' => q({0} মিলিমিটাৰ মাৰ্কিউৰী),
						'other' => q({0} মিলিমিটাৰ মাৰ্কিউৰী),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(মিলিমিটাৰ মাৰ্কিউৰী),
						'one' => q({0} মিলিমিটাৰ মাৰ্কিউৰী),
						'other' => q({0} মিলিমিটাৰ মাৰ্কিউৰী),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(প্ৰতি বৰ্গ ইঞ্চিত পাউণ্ড),
						'one' => q({0} প্ৰতি বৰ্গ ইঞ্চিত পাউণ্ড),
						'other' => q({0} প্ৰতি বৰ্গ ইঞ্চিত পাউণ্ড),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(প্ৰতি বৰ্গ ইঞ্চিত পাউণ্ড),
						'one' => q({0} প্ৰতি বৰ্গ ইঞ্চিত পাউণ্ড),
						'other' => q({0} প্ৰতি বৰ্গ ইঞ্চিত পাউণ্ড),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(ঘণ্টা প্ৰতি কিলোমিটাৰ),
						'one' => q({0} ঘণ্টা প্ৰতি কিলোমিটাৰ),
						'other' => q({0} ঘণ্টা প্ৰতি কিলোমিটাৰ),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(ঘণ্টা প্ৰতি কিলোমিটাৰ),
						'one' => q({0} ঘণ্টা প্ৰতি কিলোমিটাৰ),
						'other' => q({0} ঘণ্টা প্ৰতি কিলোমিটাৰ),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(নট),
						'one' => q({0} নট),
						'other' => q({0} নট),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(নট),
						'one' => q({0} নট),
						'other' => q({0} নট),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(মিটাৰ প্ৰতি ছেকেণ্ড),
						'one' => q({0} মিটাৰ প্ৰতি ছেকেণ্ড),
						'other' => q({0} মিটাৰ প্ৰতি ছেকেণ্ড),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(মিটাৰ প্ৰতি ছেকেণ্ড),
						'one' => q({0} মিটাৰ প্ৰতি ছেকেণ্ড),
						'other' => q({0} মিটাৰ প্ৰতি ছেকেণ্ড),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(মাইল প্ৰতি ঘণ্টা),
						'one' => q({0} মাইল প্ৰতি ঘণ্টা),
						'other' => q({0} মাইল প্ৰতি ঘণ্টা),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(মাইল প্ৰতি ঘণ্টা),
						'one' => q({0} মাইল প্ৰতি ঘণ্টা),
						'other' => q({0} মাইল প্ৰতি ঘণ্টা),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(ডিগ্ৰী চেলচিয়াছ),
						'one' => q({0} ডিগ্ৰী চেলচিয়াছ),
						'other' => q({0} ডিগ্ৰী চেলচিয়াছ),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(ডিগ্ৰী চেলচিয়াছ),
						'one' => q({0} ডিগ্ৰী চেলচিয়াছ),
						'other' => q({0} ডিগ্ৰী চেলচিয়াছ),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(ডিগ্ৰী ফাৰেনহাইট),
						'one' => q({0} ডিগ্ৰী ফাৰেনহাইট),
						'other' => q({0} ডিগ্ৰী ফাৰেনহাইট),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(ডিগ্ৰী ফাৰেনহাইট),
						'one' => q({0} ডিগ্ৰী ফাৰেনহাইট),
						'other' => q({0} ডিগ্ৰী ফাৰেনহাইট),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(কেলভিন),
						'one' => q({0} কেলভিন),
						'other' => q({0} কেলভিন),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(কেলভিন),
						'one' => q({0} কেলভিন),
						'other' => q({0} কেলভিন),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(নিউটন-মিটাৰ),
						'one' => q({0} নিউটন-মিটাৰ),
						'other' => q({0} নিউটন-মিটাৰ),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(নিউটন-মিটাৰ),
						'one' => q({0} নিউটন-মিটাৰ),
						'other' => q({0} নিউটন-মিটাৰ),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(পাউণ্ড-ফুট),
						'one' => q({0} পাউণ্ড-ফুট),
						'other' => q({0} পাউণ্ড-ফুট),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(পাউণ্ড-ফুট),
						'one' => q({0} পাউণ্ড-ফুট),
						'other' => q({0} পাউণ্ড-ফুট),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(একৰ-ফুট),
						'one' => q({0} একৰ-ফুট),
						'other' => q({0} একৰ-ফুট),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(একৰ-ফুট),
						'one' => q({0} একৰ-ফুট),
						'other' => q({0} একৰ-ফুট),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(বেৰেল),
						'one' => q({0} বেৰেল),
						'other' => q({0} বেৰেল),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(বেৰেল),
						'one' => q({0} বেৰেল),
						'other' => q({0} বেৰেল),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(বুশ্বেল),
						'one' => q({0} বুশ্লেল),
						'other' => q({0} বুশ্বেল),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(বুশ্বেল),
						'one' => q({0} বুশ্লেল),
						'other' => q({0} বুশ্বেল),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(ছেণ্টিলিটাৰ),
						'one' => q({0} ছেণ্টিলিটাৰ),
						'other' => q({0} ছেণ্টিলিটাৰ),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(ছেণ্টিলিটাৰ),
						'one' => q({0} ছেণ্টিলিটাৰ),
						'other' => q({0} ছেণ্টিলিটাৰ),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(ঘন ছেণ্টিমিটাৰ),
						'one' => q({0} ঘন ছেণ্টিমিটাৰ),
						'other' => q({0} ঘন ছেণ্টিমিটাৰ),
						'per' => q({0} প্ৰতি ঘন ছেণ্টিমিটাৰ),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(ঘন ছেণ্টিমিটাৰ),
						'one' => q({0} ঘন ছেণ্টিমিটাৰ),
						'other' => q({0} ঘন ছেণ্টিমিটাৰ),
						'per' => q({0} প্ৰতি ঘন ছেণ্টিমিটাৰ),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(ঘন ফুট),
						'one' => q({0} ঘন ফুট),
						'other' => q({0} ঘন ফুট),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(ঘন ফুট),
						'one' => q({0} ঘন ফুট),
						'other' => q({0} ঘন ফুট),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(ঘন ইঞ্চি),
						'one' => q({0} ঘন ইঞ্চি),
						'other' => q({0} ঘন ইঞ্চি),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(ঘন ইঞ্চি),
						'one' => q({0} ঘন ইঞ্চি),
						'other' => q({0} ঘন ইঞ্চি),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(ঘন কিলোমিটাৰ),
						'one' => q({0} ঘন কিলোমিটাৰ),
						'other' => q({0} ঘন কিলোমিটাৰ),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(ঘন কিলোমিটাৰ),
						'one' => q({0} ঘন কিলোমিটাৰ),
						'other' => q({0} ঘন কিলোমিটাৰ),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(ঘন মিটাৰ),
						'one' => q({0} ঘন মিটাৰ),
						'other' => q({0} ঘন মিটাৰ),
						'per' => q({0} প্ৰতি ঘন মিটাৰ),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(ঘন মিটাৰ),
						'one' => q({0} ঘন মিটাৰ),
						'other' => q({0} ঘন মিটাৰ),
						'per' => q({0} প্ৰতি ঘন মিটাৰ),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(ঘন মাইল),
						'one' => q({0} ঘন মাইল),
						'other' => q({0} ঘন মাইল),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(ঘন মাইল),
						'one' => q({0} ঘন মাইল),
						'other' => q({0} ঘন মাইল),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(ঘন গজ),
						'one' => q({0} ঘন গজ),
						'other' => q({0} ঘন গজ),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(ঘন গজ),
						'one' => q({0} ঘন গজ),
						'other' => q({0} ঘন গজ),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(কাপ),
						'one' => q({0} কাপ),
						'other' => q({0} কাপ),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(কাপ),
						'one' => q({0} কাপ),
						'other' => q({0} কাপ),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(মেট্ৰিক কাপ),
						'one' => q({0} মেট্ৰিক কাপ),
						'other' => q({0} মেট্ৰিক কাপ),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(মেট্ৰিক কাপ),
						'one' => q({0} মেট্ৰিক কাপ),
						'other' => q({0} মেট্ৰিক কাপ),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(ডেচিলিটাৰ),
						'one' => q({0} ডেচিলিটাৰ),
						'other' => q({0} ডেচিলিটাৰ),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(ডেচিলিটাৰ),
						'one' => q({0} ডেচিলিটাৰ),
						'other' => q({0} ডেচিলিটাৰ),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(ডেজাৰ্ট চামুচ),
						'one' => q({0} ডেজাৰ্ট চামুচ),
						'other' => q({0} ডেজাৰ্ট চামুচ),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(ডেজাৰ্ট চামুচ),
						'one' => q({0} ডেজাৰ্ট চামুচ),
						'other' => q({0} ডেজাৰ্ট চামুচ),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(ইম্পেৰিয়েল ডেজাৰ্ট চামুচ),
						'one' => q({0} ইম্পেৰিয়েল ডেজাৰ্ট চামুচ),
						'other' => q({0} ইম্পেৰিয়েল ডেজাৰ্ট চামুচ),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(ইম্পেৰিয়েল ডেজাৰ্ট চামুচ),
						'one' => q({0} ইম্পেৰিয়েল ডেজাৰ্ট চামুচ),
						'other' => q({0} ইম্পেৰিয়েল ডেজাৰ্ট চামুচ),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ড্ৰাম),
						'one' => q({0} ড্ৰাম),
						'other' => q({0} ড্ৰাম),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ড্ৰাম),
						'one' => q({0} ড্ৰাম),
						'other' => q({0} ড্ৰাম),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(ড্ৰপ),
						'one' => q({0} ড্ৰপ),
						'other' => q({0} ড্ৰপ),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(ড্ৰপ),
						'one' => q({0} ড্ৰপ),
						'other' => q({0} ড্ৰপ),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(ফ্লুইড আউন্স),
						'one' => q({0} ফ্লুইড আউন্স),
						'other' => q({0} ফ্লুইড আউন্স),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(ফ্লুইড আউন্স),
						'one' => q({0} ফ্লুইড আউন্স),
						'other' => q({0} ফ্লুইড আউন্স),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(ইম্পেৰিয়েল ফ্লুইড আউন্স),
						'one' => q({0} ইম্পেৰিয়েল ফ্লুইড আউন্স),
						'other' => q({0} ইম্পেৰিয়েল ফ্লুইড আউন্স),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(ইম্পেৰিয়েল ফ্লুইড আউন্স),
						'one' => q({0} ইম্পেৰিয়েল ফ্লুইড আউন্স),
						'other' => q({0} ইম্পেৰিয়েল ফ্লুইড আউন্স),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(গেলন),
						'one' => q({0} গেলন),
						'other' => q({0} গেলন),
						'per' => q({0} প্ৰতি গেলন),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(গেলন),
						'one' => q({0} গেলন),
						'other' => q({0} গেলন),
						'per' => q({0} প্ৰতি গেলন),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(ইম্পেৰিয়াল গেলন),
						'one' => q({0} ইম্পেৰিয়াল গেলন),
						'other' => q({0} ইম্পেৰিয়াল গেলন),
						'per' => q({0} প্ৰতি ইম্পেৰিয়াল গেলন),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(ইম্পেৰিয়াল গেলন),
						'one' => q({0} ইম্পেৰিয়াল গেলন),
						'other' => q({0} ইম্পেৰিয়াল গেলন),
						'per' => q({0} প্ৰতি ইম্পেৰিয়াল গেলন),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(হেক্টোলিটাৰ),
						'one' => q({0} হেক্টোলিটাৰ),
						'other' => q({0} হেক্টোলিটাৰ),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(হেক্টোলিটাৰ),
						'one' => q({0} হেক্টোলিটাৰ),
						'other' => q({0} হেক্টোলিটাৰ),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(জিগাৰ),
						'one' => q({0} জিগাৰ),
						'other' => q({0} জিগাৰ),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(জিগাৰ),
						'one' => q({0} জিগাৰ),
						'other' => q({0} জিগাৰ),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(লিটাৰ),
						'one' => q({0} লিটাৰ),
						'other' => q({0} লিটাৰ),
						'per' => q({0} প্ৰতি লিটাৰ),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(লিটাৰ),
						'one' => q({0} লিটাৰ),
						'other' => q({0} লিটাৰ),
						'per' => q({0} প্ৰতি লিটাৰ),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(মেগালিটাৰ),
						'one' => q({0} মেগালিটাৰ),
						'other' => q({0} মেগালিটাৰ),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(মেগালিটাৰ),
						'one' => q({0} মেগালিটাৰ),
						'other' => q({0} মেগালিটাৰ),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(মিলিলিটাৰ),
						'one' => q({0} মিলিলিটাৰ),
						'other' => q({0} মিলিলিটাৰ),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(মিলিলিটাৰ),
						'one' => q({0} মিলিলিটাৰ),
						'other' => q({0} মিলিলিটাৰ),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(পিঞ্চ),
						'one' => q({0} পিঞ্চ),
						'other' => q({0} পিঞ্চ),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(পিঞ্চ),
						'one' => q({0} পিঞ্চ),
						'other' => q({0} পিঞ্চ),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(পিণ্ট),
						'one' => q({0} পিণ্ট),
						'other' => q({0} পিণ্ট),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(পিণ্ট),
						'one' => q({0} পিণ্ট),
						'other' => q({0} পিণ্ট),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(মেট্ৰিক পিণ্ট),
						'one' => q({0} মেট্ৰিক পিণ্ট),
						'other' => q({0} মেট্ৰিক পিণ্ট),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(মেট্ৰিক পিণ্ট),
						'one' => q({0} মেট্ৰিক পিণ্ট),
						'other' => q({0} মেট্ৰিক পিণ্ট),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(কোৱাৰ্ট),
						'one' => q({0} কোৱাৰ্ট),
						'other' => q({0} কোৱাৰ্ট),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(কোৱাৰ্ট),
						'one' => q({0} কোৱাৰ্ট),
						'other' => q({0} কোৱাৰ্ট),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(ইম্পেৰিয়েল কুৱাৰ্ট),
						'one' => q({0} ইম্পেৰিয়েল কুৱাৰ্ট),
						'other' => q({0} ইম্পেৰিয়েল কুৱাৰ্ট),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(ইম্পেৰিয়েল কুৱাৰ্ট),
						'one' => q({0} ইম্পেৰিয়েল কুৱাৰ্ট),
						'other' => q({0} ইম্পেৰিয়েল কুৱাৰ্ট),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(টেব’লস্পুন),
						'one' => q({0} টেব’লস্পুন),
						'other' => q({0} টেব’লস্পুন),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(টেব’লস্পুন),
						'one' => q({0} টেব’লস্পুন),
						'other' => q({0} টেব’লস্পুন),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(চাহচামোছ),
						'one' => q({0} চাহচামোছ),
						'other' => q({0} চাহচামোছ),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(চাহচামোছ),
						'one' => q({0} চাহচামোছ),
						'other' => q({0} চাহচামোছ),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'' => {
						'name' => q(দিক্-নিৰ্দেশনা),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(দিক্-নিৰ্দেশনা),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(কি{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(কি{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(মি{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(মি{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(গি{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(গি{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(টে{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(টে{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(পে{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(পে{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(এক্স{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(এক্স{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(জে{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(জে{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(য়ো{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(য়ো{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(ডেচি{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(ডেচি{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(পিকো{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(পিকো{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ফেমটো{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ফেমটো{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(অটো{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(অটো{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(চেণ্টি{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(চেণ্টি{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(জেপ্টো{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(জেপ্টো{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(য়ক্টো{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(য়ক্টো{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(মিলি{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(মিলি{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(μ{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(μ{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(নেনো{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(নেনো{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ডেকা{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ডেকা{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(টেৰা{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(টেৰা{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(পেটা{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(পেটা{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(এক্সা{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(এক্সা{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(হেক্টো{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(হেক্টো{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(জেতা{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(জেতা{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(য়োটা{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(য়োটা{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(কিলো{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(কিলো{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(মেগা{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(মেগা{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(গিগা{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(গিগা{0}),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(আইটেম),
						'one' => q({0} টা আইটেম),
						'other' => q({0} টা আইটেম),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(আইটেম),
						'one' => q({0} টা আইটেম),
						'other' => q({0} টা আইটেম),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ppm),
						'one' => q({0}ppm),
						'other' => q({0}ppm),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ppm),
						'one' => q({0}ppm),
						'other' => q({0}ppm),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ল/১০০ ক.ম.),
						'one' => q({0} ল/১০০ ক.ম.),
						'other' => q({0} ল/১০০ ক.ম.),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ল/১০০ ক.ম.),
						'one' => q({0} ল/১০০ ক.ম.),
						'other' => q({0} ল/১০০ ক.ম.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} পূঃ),
						'north' => q({0} উঃ),
						'south' => q({0} দঃ),
						'west' => q({0} পঃ),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} পূঃ),
						'north' => q({0} উঃ),
						'south' => q({0} দঃ),
						'west' => q({0} পঃ),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(দিন),
						'one' => q({0} দিন),
						'other' => q({0} দিন),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(দিন),
						'one' => q({0} দিন),
						'other' => q({0} দিন),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ঘণ্টা),
						'one' => q({0} ঘণ্টা),
						'other' => q({0} ঘণ্টা),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ঘণ্টা),
						'one' => q({0} ঘণ্টা),
						'other' => q({0} ঘণ্টা),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(মিলিছেকেণ্ড),
						'one' => q({0} মিঃ ছেঃ),
						'other' => q({0} মিঃ ছেঃ),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(মিলিছেকেণ্ড),
						'one' => q({0} মিঃ ছেঃ),
						'other' => q({0} মিঃ ছেঃ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(মিনিট),
						'one' => q({0} মিনিট),
						'other' => q({0} মিনিট),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(মিনিট),
						'one' => q({0} মিনিট),
						'other' => q({0} মিনিট),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(মাহ),
						'one' => q({0} মাহ),
						'other' => q({0} মাহ),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(মাহ),
						'one' => q({0} মাহ),
						'other' => q({0} মাহ),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ছেকেণ্ড),
						'one' => q({0} ছেকেণ্ড),
						'other' => q({0} ছেকেণ্ড),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ছেকেণ্ড),
						'one' => q({0} ছেকেণ্ড),
						'other' => q({0} ছেকেণ্ড),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(সপ্তাহ),
						'one' => q({0} সপ্তাহ),
						'other' => q({0} সপ্তাহ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(সপ্তাহ),
						'one' => q({0} সপ্তাহ),
						'other' => q({0} সপ্তাহ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(বছৰ),
						'one' => q({0} বছৰ),
						'other' => q({0} বছৰ),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(বছৰ),
						'one' => q({0} বছৰ),
						'other' => q({0} বছৰ),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(ছেঃ মিঃ),
						'one' => q({0} ছেঃ মিঃ),
						'other' => q({0} ছেঃ মিঃ),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(ছেঃ মিঃ),
						'one' => q({0} ছেঃ মিঃ),
						'other' => q({0} ছেঃ মিঃ),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(কিঃ মিঃ),
						'one' => q({0} কিঃ মিঃ),
						'other' => q({0} কিঃ মিঃ),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(কিঃ মিঃ),
						'one' => q({0} কিঃ মিঃ),
						'other' => q({0} কিঃ মিঃ),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(মিঃ),
						'one' => q({0} মিঃ),
						'other' => q({0} মিঃ),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(মিঃ),
						'one' => q({0} মিঃ),
						'other' => q({0} মিঃ),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(মিঃ মিঃ),
						'one' => q({0} মিঃ মিঃ),
						'other' => q({0} মিঃ মিঃ),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(মিঃ মিঃ),
						'one' => q({0} মিঃ মিঃ),
						'other' => q({0} মিঃ মিঃ),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(গ্ৰাম),
						'one' => q({0} গ্ৰাঃ),
						'other' => q({0} গ্ৰাঃ),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(গ্ৰাম),
						'one' => q({0} গ্ৰাঃ),
						'other' => q({0} গ্ৰাঃ),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(কিঃ গ্ৰাঃ),
						'one' => q({0} কিঃ গ্ৰাঃ),
						'other' => q({0} কিঃ গ্ৰাঃ),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(কিঃ গ্ৰাঃ),
						'one' => q({0} কিঃ গ্ৰাঃ),
						'other' => q({0} কিঃ গ্ৰাঃ),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(কিঃ মিঃ/ঘঃ),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(কিঃ মিঃ/ঘঃ),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(°চেঃ),
						'one' => q({0}°চেঃ),
						'other' => q({0}°চেঃ),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(°চেঃ),
						'one' => q({0}°চেঃ),
						'other' => q({0}°চেঃ),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(লিটাৰ),
						'one' => q({0} লিঃ),
						'other' => q({0} লিঃ),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(লিটাৰ),
						'one' => q({0} লিঃ),
						'other' => q({0} লিঃ),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(দিক্-নিৰ্দেশনা),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(দিক্-নিৰ্দেশনা),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(কি{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(কি{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(মি{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(মি{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(গিঃ{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(গিঃ{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(টেঃ{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(টেঃ{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(পেঃ{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(পেঃ{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(এক্স{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(এক্স{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(জেঃ{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(জেঃ{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(য়োঃ{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(য়োঃ{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(ডেঃ{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(ডেঃ{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(পি.{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(পি.{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ফেম.{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ফেম.{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(অ.{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(অ.{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(চেঃ{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(চেঃ{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(জে.{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(জে.{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(য়.{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(য়.{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(মিঃ{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(মিঃ{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(নে.{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(নে.{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ডে.{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ডে.{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(টে.{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(টে.{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(পে.{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(পে.{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(এ.{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(এ.{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(হে.{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(হে.{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(জ.{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(জ.{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(য়ো.{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(য়ো.{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(কিঃ{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(কিঃ{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(মে.{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(মে.{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(গি.{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(গি.{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(জি-বল),
						'one' => q({0} জি),
						'other' => q({0} জি),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(জি-বল),
						'one' => q({0} জি),
						'other' => q({0} জি),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(মিটাৰ/বৰ্গ ছেকেণ্ড),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(মিটাৰ/বৰ্গ ছেকেণ্ড),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(আৰ্কমিনিট),
						'one' => q({0} আৰ্কমিনিট),
						'other' => q({0} আৰ্কমিনিট),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(আৰ্কমিনিট),
						'one' => q({0} আৰ্কমিনিট),
						'other' => q({0} আৰ্কমিনিট),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(আৰ্কছেকেণ্ড),
						'one' => q({0} আৰ্কছেকেণ্ড),
						'other' => q({0} আৰ্কছেকেণ্ড),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(আৰ্কছেকেণ্ড),
						'one' => q({0} আৰ্কছেকেণ্ড),
						'other' => q({0} আৰ্কছেকেণ্ড),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(ডিগ্ৰী),
						'one' => q({0} ডিগ্ৰী),
						'other' => q({0} ডিগ্ৰী),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(ডিগ্ৰী),
						'one' => q({0} ডিগ্ৰী),
						'other' => q({0} ডিগ্ৰী),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(ৰেডিয়েন),
						'one' => q({0} ৰেডিয়েন),
						'other' => q({0} ৰেডিয়েন),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(ৰেডিয়েন),
						'one' => q({0} ৰেডিয়েন),
						'other' => q({0} ৰেডিয়েন),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(ঘূৰ্ণন),
						'one' => q({0} ঘূৰ্ণন),
						'other' => q({0} ঘূৰ্ণন),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(ঘূৰ্ণন),
						'one' => q({0} ঘূৰ্ণন),
						'other' => q({0} ঘূৰ্ণন),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(একৰ),
						'one' => q({0} একৰ),
						'other' => q({0} একৰ),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(একৰ),
						'one' => q({0} একৰ),
						'other' => q({0} একৰ),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(ডুনাম),
						'one' => q({0} ডুনাম),
						'other' => q({0} ডুনাম),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(ডুনাম),
						'one' => q({0} ডুনাম),
						'other' => q({0} ডুনাম),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(হেক্টৰ),
						'one' => q({0} হেক্টৰ),
						'other' => q({0} হেক্টৰ),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(হেক্টৰ),
						'one' => q({0} হেক্টৰ),
						'other' => q({0} হেক্টৰ),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(cm²),
						'one' => q({0} cm²),
						'other' => q({0} cm²),
						'per' => q({0}/cm²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(cm²),
						'one' => q({0} cm²),
						'other' => q({0} cm²),
						'per' => q({0}/cm²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(বৰ্গ ফুট),
						'one' => q({0} বৰ্গ ফুট),
						'other' => q({0} বৰ্গ ফুট),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(বৰ্গ ফুট),
						'one' => q({0} বৰ্গ ফুট),
						'other' => q({0} বৰ্গ ফুট),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(বৰ্গ ইঞ্চি),
						'one' => q({0} in²),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(বৰ্গ ইঞ্চি),
						'one' => q({0} in²),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(বৰ্গ কিলোমিটাৰ),
						'one' => q({0} km²),
						'other' => q({0} km²),
						'per' => q({0}/km²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(বৰ্গ কিলোমিটাৰ),
						'one' => q({0} km²),
						'other' => q({0} km²),
						'per' => q({0}/km²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(বৰ্গ মিটাৰ),
						'one' => q({0} m²),
						'other' => q({0} m²),
						'per' => q({0}/m²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(বৰ্গ মিটাৰ),
						'one' => q({0} m²),
						'other' => q({0} m²),
						'per' => q({0}/m²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(বৰ্গ মাইল),
						'one' => q({0} বৰ্গ মাইল),
						'other' => q({0} বৰ্গ মাইল),
						'per' => q({0}/mi²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(বৰ্গ মাইল),
						'one' => q({0} বৰ্গ মাইল),
						'other' => q({0} বৰ্গ মাইল),
						'per' => q({0}/mi²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(বৰ্গ গজ),
						'one' => q({0} yd²),
						'other' => q({0} yd²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(বৰ্গ গজ),
						'one' => q({0} yd²),
						'other' => q({0} yd²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(আইটেম),
						'one' => q({0} টা আইটেম),
						'other' => q({0} টা আইটেম),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(আইটেম),
						'one' => q({0} টা আইটেম),
						'other' => q({0} টা আইটেম),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(কেৰেট),
						'one' => q({0} কেৰেট),
						'other' => q({0} কেৰেট),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(কেৰেট),
						'one' => q({0} কেৰেট),
						'other' => q({0} কেৰেট),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(মিঃ গ্ৰাঃ/ডেঃ লিঃ),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(মিঃ গ্ৰাঃ/ডেঃ লিঃ),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(মিলিমোল/লিটাৰ),
						'one' => q({0} mmol/L),
						'other' => q({0} mmol/L),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(মিলিমোল/লিটাৰ),
						'one' => q({0} mmol/L),
						'other' => q({0} mmol/L),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(ম’ল),
						'one' => q({0} ম’ল),
						'other' => q({0} ম’ল),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(ম’ল),
						'one' => q({0} ম’ল),
						'other' => q({0} ম’ল),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(শতাংশ),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(শতাংশ),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(প্ৰতিমাইল),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(প্ৰতিমাইল),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ভাগ/মিলিয়ন),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ভাগ/মিলিয়ন),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(পাৰমিৰেইড),
						'one' => q({0}‱),
						'other' => q({0}‱),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(পাৰমিৰেইড),
						'one' => q({0}‱),
						'other' => q({0}‱),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(লিঃ/১০০ কিঃ মিঃ),
						'one' => q({0} ল/১০০ ক.ম.),
						'other' => q({0} ল/১০০ ক.ম.),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(লিঃ/১০০ কিঃ মিঃ),
						'one' => q({0} ল/১০০ ক.ম.),
						'other' => q({0} ল/১০০ ক.ম.),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(লিটাৰ/কিঃ মিঃ),
						'one' => q({0} লিঃ/কিঃ মিঃ),
						'other' => q({0} লিঃ/কিঃ মিঃ),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(লিটাৰ/কিঃ মিঃ),
						'one' => q({0} লিঃ/কিঃ মিঃ),
						'other' => q({0} লিঃ/কিঃ মিঃ),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(মাইল/গেলন),
						'one' => q({0} mpg US),
						'other' => q({0} mpg US),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(মাইল/গেলন),
						'one' => q({0} mpg US),
						'other' => q({0} mpg US),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(mpg Imp.),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(mpg Imp.),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} পূঃ),
						'north' => q({0} উঃ),
						'south' => q({0} দঃ),
						'west' => q({0} পঃ),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} পূঃ),
						'north' => q({0} উঃ),
						'south' => q({0} দঃ),
						'west' => q({0} পঃ),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(বিট),
						'one' => q({0} বিট),
						'other' => q({0} বিট),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(বিট),
						'one' => q({0} বিট),
						'other' => q({0} বিট),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(বাইট),
						'one' => q({0} বাইট),
						'other' => q({0} বাইট),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(বাইট),
						'one' => q({0} বাইট),
						'other' => q({0} বাইট),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(গিগাবিট),
						'one' => q({0} গিঃ বিঃ),
						'other' => q({0} গিঃ বিঃ),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(গিগাবিট),
						'one' => q({0} গিঃ বিঃ),
						'other' => q({0} গিঃ বিঃ),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(গিগাবাইট),
						'one' => q({0} গিঃ বাঃ),
						'other' => q({0} গিঃ বাঃ),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(গিগাবাইট),
						'one' => q({0} গিঃ বাঃ),
						'other' => q({0} গিঃ বাঃ),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(কিলোবিট),
						'one' => q({0} কিঃ বিঃ),
						'other' => q({0} কিঃ বিঃ),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(কিলোবিট),
						'one' => q({0} কিঃ বিঃ),
						'other' => q({0} কিঃ বিঃ),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(কিলোবাইট),
						'one' => q({0} কিঃ বাঃ),
						'other' => q({0} কিঃ বাঃ),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(কিলোবাইট),
						'one' => q({0} কিঃ বাঃ),
						'other' => q({0} কিঃ বাঃ),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(মেগাবিট),
						'one' => q({0} মেঃ বিঃ),
						'other' => q({0} মেঃ বিঃ),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(মেগাবিট),
						'one' => q({0} মেঃ বিঃ),
						'other' => q({0} মেঃ বিঃ),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(মেগাবাইট),
						'one' => q({0} মেঃ বাঃ),
						'other' => q({0} মেঃ বাঃ),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(মেগাবাইট),
						'one' => q({0} মেঃ বাঃ),
						'other' => q({0} মেঃ বাঃ),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(PByte),
						'one' => q({0} PB),
						'other' => q({0} PB),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(PByte),
						'one' => q({0} PB),
						'other' => q({0} PB),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(টেৰাবিট),
						'one' => q({0} টেঃ বিঃ),
						'other' => q({0} টেঃ বিঃ),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(টেৰাবিট),
						'one' => q({0} টেঃ বিঃ),
						'other' => q({0} টেঃ বিঃ),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(টেৰাবাইট),
						'one' => q({0} টেঃ বাঃ),
						'other' => q({0} টেঃ বাঃ),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(টেৰাবাইট),
						'one' => q({0} টেঃ বাঃ),
						'other' => q({0} টেঃ বাঃ),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(শতিকা),
						'one' => q({0} শতিকা),
						'other' => q({0} শতিকা),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(শতিকা),
						'one' => q({0} শতিকা),
						'other' => q({0} শতিকা),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(দিন),
						'one' => q({0} দিন),
						'other' => q({0} দিন),
						'per' => q({0}/দিন),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(দিন),
						'one' => q({0} দিন),
						'other' => q({0} দিন),
						'per' => q({0}/দিন),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(দশ.),
						'one' => q({0} দশ.),
						'other' => q({0} দশ.),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(দশ.),
						'one' => q({0} দশ.),
						'other' => q({0} দশ.),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ঘণ্টা),
						'one' => q({0} ঘণ্টা),
						'other' => q({0} ঘণ্টা),
						'per' => q({0}/ঘণ্টা),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ঘণ্টা),
						'one' => q({0} ঘণ্টা),
						'other' => q({0} ঘণ্টা),
						'per' => q({0}/ঘণ্টা),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(মাইক্ৰছেকেণ্ড),
						'one' => q({0} মাঃ ছেঃ),
						'other' => q({0} মাঃ ছেঃ),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(মাইক্ৰছেকেণ্ড),
						'one' => q({0} মাঃ ছেঃ),
						'other' => q({0} মাঃ ছেঃ),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(মিলিছেকেণ্ড),
						'one' => q({0} মিঃ ছেঃ),
						'other' => q({0} মিঃ ছেঃ),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(মিলিছেকেণ্ড),
						'one' => q({0} মিঃ ছেঃ),
						'other' => q({0} মিঃ ছেঃ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(মিনিট),
						'one' => q({0} মিনিট),
						'other' => q({0} মিনিট),
						'per' => q({0}/মিনিট),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(মিনিট),
						'one' => q({0} মিনিট),
						'other' => q({0} মিনিট),
						'per' => q({0}/মিনিট),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(মাহ),
						'one' => q({0} মাহ),
						'other' => q({0} মাহ),
						'per' => q({0}/মাহ),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(মাহ),
						'one' => q({0} মাহ),
						'other' => q({0} মাহ),
						'per' => q({0}/মাহ),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(নেনোছেকেণ্ড),
						'one' => q({0} নেঃ ছেঃ),
						'other' => q({0} নেঃ ছেঃ),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(নেনোছেকেণ্ড),
						'one' => q({0} নেঃ ছেঃ),
						'other' => q({0} নেঃ ছেঃ),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ছেকেণ্ড),
						'one' => q({0} ছেকেণ্ড),
						'other' => q({0} ছেকেণ্ড),
						'per' => q({0}/ছেকেণ্ড),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ছেকেণ্ড),
						'one' => q({0} ছেকেণ্ড),
						'other' => q({0} ছেকেণ্ড),
						'per' => q({0}/ছেকেণ্ড),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(সপ্তাহ),
						'one' => q({0} সপ্তাহ),
						'other' => q({0} সপ্তাহ),
						'per' => q({0}/সপ্তাহ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(সপ্তাহ),
						'one' => q({0} সপ্তাহ),
						'other' => q({0} সপ্তাহ),
						'per' => q({0}/সপ্তাহ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(বছৰ),
						'one' => q({0} বছৰ),
						'other' => q({0} বছৰ),
						'per' => q({0}/বছৰ),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(বছৰ),
						'one' => q({0} বছৰ),
						'other' => q({0} বছৰ),
						'per' => q({0}/বছৰ),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(এম্পিয়াৰ),
						'one' => q({0} এঃ),
						'other' => q({0} এঃ),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(এম্পিয়াৰ),
						'one' => q({0} এঃ),
						'other' => q({0} এঃ),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(মিলিএম্পিয়াৰ),
						'one' => q({0} মিঃ এঃ),
						'other' => q({0} মিঃ এঃ),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(মিলিএম্পিয়াৰ),
						'one' => q({0} মিঃ এঃ),
						'other' => q({0} মিঃ এঃ),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(ওম),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(ওম),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(ভল্ট),
						'one' => q({0} ভঃ),
						'other' => q({0} ভঃ),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(ভল্ট),
						'one' => q({0} ভঃ),
						'other' => q({0} ভঃ),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(BTU),
						'one' => q({0} Btu),
						'other' => q({0} Btu),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(BTU),
						'one' => q({0} Btu),
						'other' => q({0} Btu),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(কেলৰি),
						'one' => q({0} কেলৰি),
						'other' => q({0} কেলৰি),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(কেলৰি),
						'one' => q({0} কেলৰি),
						'other' => q({0} কেলৰি),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(ইলেক্ট্ৰ’নভ’ল্ট),
						'one' => q({0} eV),
						'other' => q({0} eV),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(ইলেক্ট্ৰ’নভ’ল্ট),
						'one' => q({0} eV),
						'other' => q({0} eV),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(কেলৰি),
						'one' => q({0} কেলৰি),
						'other' => q({0} কেলৰি),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(কেলৰি),
						'one' => q({0} কেলৰি),
						'other' => q({0} কেলৰি),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(জুল),
						'one' => q({0} জুল),
						'other' => q({0} জুল),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(জুল),
						'one' => q({0} জুল),
						'other' => q({0} জুল),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(কিলোকেলৰি),
						'one' => q({0} কিঃ কেলঃ),
						'other' => q({0} কিঃ কেলঃ),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(কিলোকেলৰি),
						'one' => q({0} কিঃ কেলঃ),
						'other' => q({0} কিঃ কেলঃ),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(কিলোজুল),
						'one' => q({0} কিঃ জুঃ),
						'other' => q({0} কিঃ জুঃ),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(কিলোজুল),
						'one' => q({0} কিঃ জুঃ),
						'other' => q({0} কিঃ জুঃ),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(কিঃ ৱাঃ-ঘঃ),
						'one' => q({0} কিঃ ৱাঃ-ঘঃ),
						'other' => q({0} কিঃ ৱাঃ-ঘঃ),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(কিঃ ৱাঃ-ঘঃ),
						'one' => q({0} কিঃ ৱাঃ-ঘঃ),
						'other' => q({0} কিঃ ৱাঃ-ঘঃ),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(ইউ এচ থাৰ্ণ),
						'one' => q({0} ইউ এচ থাৰ্ণ),
						'other' => q({0} ইউ এচ থাৰ্ণ),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(ইউ এচ থাৰ্ণ),
						'one' => q({0} ইউ এচ থাৰ্ণ),
						'other' => q({0} ইউ এচ থাৰ্ণ),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(kWh/100km),
						'one' => q({0} kWh/100km),
						'other' => q({0} kWh/100km),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(kWh/100km),
						'one' => q({0} kWh/100km),
						'other' => q({0} kWh/100km),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(নিউটন),
						'one' => q({0} N),
						'other' => q({0} N),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(নিউটন),
						'one' => q({0} N),
						'other' => q({0} N),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(পাউণ্ড-বল),
						'one' => q({0} lbf),
						'other' => q({0} lbf),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(পাউণ্ড-বল),
						'one' => q({0} lbf),
						'other' => q({0} lbf),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(গিগাহাৰ্টজ),
						'one' => q({0} গিগাহাৰ্টজ),
						'other' => q({0} গিগাহাৰ্টজ),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(গিগাহাৰ্টজ),
						'one' => q({0} গিগাহাৰ্টজ),
						'other' => q({0} গিগাহাৰ্টজ),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(হাৰ্টজ),
						'one' => q({0} হাৰ্টজ),
						'other' => q({0} হাৰ্টজ),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(হাৰ্টজ),
						'one' => q({0} হাৰ্টজ),
						'other' => q({0} হাৰ্টজ),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(কিলোহাৰ্টজ),
						'one' => q({0} কিঃ হাঃ),
						'other' => q({0} কিঃ হাঃ),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(কিলোহাৰ্টজ),
						'one' => q({0} কিঃ হাঃ),
						'other' => q({0} কিঃ হাঃ),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(মেগাহাৰ্টজ),
						'one' => q({0} মেঃ হাঃ),
						'other' => q({0} মেঃ হাঃ),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(মেগাহাৰ্টজ),
						'one' => q({0} মেঃ হাঃ),
						'other' => q({0} মেঃ হাঃ),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(জ্যোঃ এঃ),
						'one' => q({0} জ্যোঃ এঃ),
						'other' => q({0} জ্যোঃ এঃ),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(জ্যোঃ এঃ),
						'one' => q({0} জ্যোঃ এঃ),
						'other' => q({0} জ্যোঃ এঃ),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(ছেঃ মিঃ),
						'one' => q({0} ছেঃ মিঃ),
						'other' => q({0} ছেঃ মিঃ),
						'per' => q({0}/ছেঃ মিঃ),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(ছেঃ মিঃ),
						'one' => q({0} ছেঃ মিঃ),
						'other' => q({0} ছেঃ মিঃ),
						'per' => q({0}/ছেঃ মিঃ),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(ডেঃ মিঃ),
						'one' => q({0} ডেঃ মিঃ),
						'other' => q({0} ডেঃ মিঃ),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(ডেঃ মিঃ),
						'one' => q({0} ডেঃ মিঃ),
						'other' => q({0} ডেঃ মিঃ),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(ফাথম),
						'one' => q({0} ফাথম),
						'other' => q({0} ফাথম),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(ফাথম),
						'one' => q({0} ফাথম),
						'other' => q({0} ফাথম),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(ফুট),
						'one' => q({0} ফুঃ),
						'other' => q({0} ফুঃ),
						'per' => q({0}/ফুঃ),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(ফুট),
						'one' => q({0} ফুঃ),
						'other' => q({0} ফুঃ),
						'per' => q({0}/ফুঃ),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(ফাৰ্লং),
						'one' => q({0} ফাৰ্লং),
						'other' => q({0} ফাৰ্লং),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(ফাৰ্লং),
						'one' => q({0} ফাৰ্লং),
						'other' => q({0} ফাৰ্লং),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(ইঞ্চি),
						'one' => q({0} ইঃ),
						'other' => q({0} ইঃ),
						'per' => q({0}/ইঃ),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(ইঞ্চি),
						'one' => q({0} ইঃ),
						'other' => q({0} ইঃ),
						'per' => q({0}/ইঃ),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(কিঃ মিঃ),
						'one' => q({0} কিঃ মিঃ),
						'other' => q({0} কিঃ মিঃ),
						'per' => q({0}/কিঃ মিঃ),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(কিঃ মিঃ),
						'one' => q({0} কিঃ মিঃ),
						'other' => q({0} কিঃ মিঃ),
						'per' => q({0}/কিঃ মিঃ),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(আলোকবৰ্ষ),
						'one' => q({0} আঃ বঃ),
						'other' => q({0} আঃ বঃ),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(আলোকবৰ্ষ),
						'one' => q({0} আঃ বঃ),
						'other' => q({0} আঃ বঃ),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(মিটাৰ),
						'one' => q({0} মিঃ),
						'other' => q({0} মিঃ),
						'per' => q({0}/মিঃ),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(মিটাৰ),
						'one' => q({0} মিঃ),
						'other' => q({0} মিঃ),
						'per' => q({0}/মিঃ),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(মাইক্ৰ’মিটাৰ),
						'one' => q({0} মাঃ মিঃ),
						'other' => q({0} মাঃ মিঃ),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(মাইক্ৰ’মিটাৰ),
						'one' => q({0} মাঃ মিঃ),
						'other' => q({0} মাঃ মিঃ),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(মাইল),
						'one' => q({0} মাঃ),
						'other' => q({0} মাঃ),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(মাইল),
						'one' => q({0} মাঃ),
						'other' => q({0} মাঃ),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(মাঃ-স্কেঃ),
						'one' => q({0} মাঃ-স্কেঃ),
						'other' => q({0} মাঃ-স্কেঃ),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(মাঃ-স্কেঃ),
						'one' => q({0} মাঃ-স্কেঃ),
						'other' => q({0} মাঃ-স্কেঃ),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(মিঃ মিঃ),
						'one' => q({0} মিঃ মিঃ),
						'other' => q({0} মিঃ মিঃ),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(মিঃ মিঃ),
						'one' => q({0} মিঃ মিঃ),
						'other' => q({0} মিঃ মিঃ),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(নেঃ মিঃ),
						'one' => q({0} নেঃ মিঃ),
						'other' => q({0} নেঃ মিঃ),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(নেঃ মিঃ),
						'one' => q({0} নেঃ মিঃ),
						'other' => q({0} নেঃ মিঃ),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(ন’টিঃ মাঃ),
						'one' => q({0} ন’টিঃ মাঃ),
						'other' => q({0} ন’টিঃ মাঃ),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(ন’টিঃ মাঃ),
						'one' => q({0} ন’টিঃ মাঃ),
						'other' => q({0} ন’টিঃ মাঃ),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(পাৰ্ছেক),
						'one' => q({0} পাৰ্ছেক),
						'other' => q({0} পাৰ্ছেক),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(পাৰ্ছেক),
						'one' => q({0} পাৰ্ছেক),
						'other' => q({0} পাৰ্ছেক),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(পিঃ মিঃ),
						'one' => q({0} পিঃ মিঃ),
						'other' => q({0} পিঃ মিঃ),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(পিঃ মিঃ),
						'one' => q({0} পিঃ মিঃ),
						'other' => q({0} পিঃ মিঃ),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(পইণ্ট),
						'one' => q({0} পইণ্ট),
						'other' => q({0} পইণ্ট),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(পইণ্ট),
						'one' => q({0} পইণ্ট),
						'other' => q({0} পইণ্ট),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(সৌৰ ৰেডিয়াছ),
						'one' => q({0} R☉),
						'other' => q({0} R☉),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(সৌৰ ৰেডিয়াছ),
						'one' => q({0} R☉),
						'other' => q({0} R☉),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(গজ),
						'one' => q({0} গজ),
						'other' => q({0} গজ),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(গজ),
						'one' => q({0} গজ),
						'other' => q({0} গজ),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(লাক্স),
						'one' => q({0} লাক্স),
						'other' => q({0} লাক্স),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(লাক্স),
						'one' => q({0} লাক্স),
						'other' => q({0} লাক্স),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(ছ’লাৰ লুমিন’ছিটী),
						'one' => q({0} L☉),
						'other' => q({0} L☉),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(ছ’লাৰ লুমিন’ছিটী),
						'one' => q({0} L☉),
						'other' => q({0} L☉),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(কেৰেট),
						'one' => q({0} কেৰেট),
						'other' => q({0} কেৰেট),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(কেৰেট),
						'one' => q({0} কেৰেট),
						'other' => q({0} কেৰেট),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(ডলট’ন),
						'one' => q({0} ডলট’ন),
						'other' => q({0} ডলট’ন),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(ডলট’ন),
						'one' => q({0} ডলট’ন),
						'other' => q({0} ডলট’ন),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(আৰ্থ মাছ),
						'one' => q({0} M⊕),
						'other' => q({0} M⊕),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(আৰ্থ মাছ),
						'one' => q({0} M⊕),
						'other' => q({0} M⊕),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(গ্ৰেইন),
						'one' => q({0} গ্ৰেইন),
						'other' => q({0} গ্ৰেইন),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(গ্ৰেইন),
						'one' => q({0} গ্ৰেইন),
						'other' => q({0} গ্ৰেইন),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(গ্ৰাম),
						'one' => q({0} গ্ৰাঃ),
						'other' => q({0} গ্ৰাঃ),
						'per' => q({0}/গ্ৰাঃ),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(গ্ৰাম),
						'one' => q({0} গ্ৰাঃ),
						'other' => q({0} গ্ৰাঃ),
						'per' => q({0}/গ্ৰাঃ),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(কিঃ গ্ৰাঃ),
						'one' => q({0} কিঃ গ্ৰাঃ),
						'other' => q({0} কিঃ গ্ৰাঃ),
						'per' => q({0}/কিঃ গ্ৰাঃ),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(কিঃ গ্ৰাঃ),
						'one' => q({0} কিঃ গ্ৰাঃ),
						'other' => q({0} কিঃ গ্ৰাঃ),
						'per' => q({0}/কিঃ গ্ৰাঃ),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'name' => q(ট),
						'one' => q({0} ট),
						'other' => q({0} ট),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'name' => q(ট),
						'one' => q({0} ট),
						'other' => q({0} ট),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(মাঃ গ্ৰাঃ),
						'one' => q({0} মাঃ গ্ৰাঃ),
						'other' => q({0} মাঃ গ্ৰাঃ),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(মাঃ গ্ৰাঃ),
						'one' => q({0} মাঃ গ্ৰাঃ),
						'other' => q({0} মাঃ গ্ৰাঃ),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(মিঃ গ্ৰাঃ),
						'one' => q({0} মিঃ গ্ৰাঃ),
						'other' => q({0} মিঃ গ্ৰাঃ),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(মিঃ গ্ৰাঃ),
						'one' => q({0} মিঃ গ্ৰাঃ),
						'other' => q({0} মিঃ গ্ৰাঃ),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(আউন্স),
						'one' => q({0} আউন্স),
						'other' => q({0} আউন্স),
						'per' => q({0}/আউন্স),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(আউন্স),
						'one' => q({0} আউন্স),
						'other' => q({0} আউন্স),
						'per' => q({0}/আউন্স),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(ট্ৰয় আউন্স),
						'one' => q({0} ট্ৰঃ আঃ),
						'other' => q({0} ট্ৰঃ আঃ),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(ট্ৰয় আউন্স),
						'one' => q({0} ট্ৰঃ আঃ),
						'other' => q({0} ট্ৰঃ আঃ),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(পাউণ্ড),
						'one' => q({0} পাউণ্ড),
						'other' => q({0} পাউণ্ড),
						'per' => q({0}/পাউণ্ড),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(পাউণ্ড),
						'one' => q({0} পাউণ্ড),
						'other' => q({0} পাউণ্ড),
						'per' => q({0}/পাউণ্ড),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(সৌৰ ভৰ),
						'one' => q({0} M☉),
						'other' => q({0} M☉),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(সৌৰ ভৰ),
						'one' => q({0} M☉),
						'other' => q({0} M☉),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(ষ্ট’ন),
						'one' => q({0} ষ্ট'ন),
						'other' => q({0} ষ্ট'ন),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(ষ্ট’ন),
						'one' => q({0} ষ্ট'ন),
						'other' => q({0} ষ্ট'ন),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(টন),
						'one' => q({0} টন),
						'other' => q({0} টন),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(টন),
						'one' => q({0} টন),
						'other' => q({0} টন),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(গিঃ ৱাঃ),
						'one' => q({0} গিঃ ৱাঃ),
						'other' => q({0} গিঃ ৱাঃ),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(গিঃ ৱাঃ),
						'one' => q({0} গিঃ ৱাঃ),
						'other' => q({0} গিঃ ৱাঃ),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(অশ্বক্ষমতা),
						'one' => q({0} অশ্বক্ষমতা),
						'other' => q({0} অশ্বক্ষমতা),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(অশ্বক্ষমতা),
						'one' => q({0} অশ্বক্ষমতা),
						'other' => q({0} অশ্বক্ষমতা),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(কিঃ ৱাঃ),
						'one' => q({0} কিঃ ৱাঃ),
						'other' => q({0} কিঃ ৱাঃ),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(কিঃ ৱাঃ),
						'one' => q({0} কিঃ ৱাঃ),
						'other' => q({0} কিঃ ৱাঃ),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(মেঃ ৱাঃ),
						'one' => q({0} মেঃ ৱাঃ),
						'other' => q({0} মেঃ ৱাঃ),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(মেঃ ৱাঃ),
						'one' => q({0} মেঃ ৱাঃ),
						'other' => q({0} মেঃ ৱাঃ),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(মিঃ ৱাঃ),
						'one' => q({0} মিঃ ৱাঃ),
						'other' => q({0} মিঃ ৱাঃ),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(মিঃ ৱাঃ),
						'one' => q({0} মিঃ ৱাঃ),
						'other' => q({0} মিঃ ৱাঃ),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(ৱাট),
						'one' => q({0} ৱাট),
						'other' => q({0} ৱাট),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(ৱাট),
						'one' => q({0} ৱাট),
						'other' => q({0} ৱাট),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(atm),
						'one' => q({0} atm),
						'other' => q({0} atm),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(atm),
						'one' => q({0} atm),
						'other' => q({0} atm),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(কি. পা.),
						'one' => q({0} কি. পা.),
						'other' => q({0} কি. পা.),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(কি. পা.),
						'one' => q({0} কি. পা.),
						'other' => q({0} কি. পা.),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(মেগাপাস্কেল),
						'one' => q({0} মে. পা.),
						'other' => q({0} মে. পা.),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(মেগাপাস্কেল),
						'one' => q({0} মে. পা.),
						'other' => q({0} মে. পা.),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(mmHg),
						'one' => q({0} mmHg),
						'other' => q({0} mmHg),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(mmHg),
						'one' => q({0} mmHg),
						'other' => q({0} mmHg),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(কিঃ মিঃ/ঘঃ),
						'one' => q({0} কিঃ মিঃ/ঘঃ),
						'other' => q({0} কিঃ মিঃ/ঘঃ),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(কিঃ মিঃ/ঘঃ),
						'one' => q({0} কিঃ মিঃ/ঘঃ),
						'other' => q({0} কিঃ মিঃ/ঘঃ),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(নট),
						'one' => q({0} নট),
						'other' => q({0} নট),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(নট),
						'one' => q({0} নট),
						'other' => q({0} নট),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(মিটাৰ/ছেকেণ্ড),
						'one' => q({0} মিঃ/ছেঃ),
						'other' => q({0} মিঃ/ছেঃ),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(মিটাৰ/ছেকেণ্ড),
						'one' => q({0} মিঃ/ছেঃ),
						'other' => q({0} মিঃ/ছেঃ),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(মাইল/ঘণ্টা),
						'one' => q({0} মাঃ/ঘঃ),
						'other' => q({0} মাঃ/ঘঃ),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(মাইল/ঘণ্টা),
						'one' => q({0} মাঃ/ঘঃ),
						'other' => q({0} মাঃ/ঘঃ),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(ডিগ্ৰীঃ চেঃ),
						'one' => q({0}°চেঃ),
						'other' => q({0}°চেঃ),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(ডিগ্ৰীঃ চেঃ),
						'one' => q({0}°চেঃ),
						'other' => q({0}°চেঃ),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(ডিঃ ফাঃ),
						'one' => q({0}°ফাঃ),
						'other' => q({0}°ফাঃ),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(ডিঃ ফাঃ),
						'one' => q({0}°ফাঃ),
						'other' => q({0}°ফাঃ),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(কেলভিন),
						'one' => q({0} কেলভিন),
						'other' => q({0} কেলভিন),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(কেলভিন),
						'one' => q({0} কেলভিন),
						'other' => q({0} কেলভিন),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(নি. মি.),
						'one' => q({0} নি. মি.),
						'other' => q({0} নি. মি.),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(নি. মি.),
						'one' => q({0} নি. মি.),
						'other' => q({0} নি. মি.),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(lbf⋅ft),
						'one' => q({0} lbf⋅ft),
						'other' => q({0} lbf⋅ft),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(lbf⋅ft),
						'one' => q({0} lbf⋅ft),
						'other' => q({0} lbf⋅ft),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(একৰ-ফুট),
						'one' => q({0} এঃ-ফুঃ),
						'other' => q({0} এঃ-ফুঃ),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(একৰ-ফুট),
						'one' => q({0} এঃ-ফুঃ),
						'other' => q({0} এঃ-ফুঃ),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(বেৰেল),
						'one' => q({0} bbl),
						'other' => q({0} bbl),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(বেৰেল),
						'one' => q({0} bbl),
						'other' => q({0} bbl),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(বুশ্বেল),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(বুশ্বেল),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(ছেঃ লিঃ),
						'one' => q({0} ছেঃ লিঃ),
						'other' => q({0} ছেঃ লিঃ),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(ছেঃ লিঃ),
						'one' => q({0} ছেঃ লিঃ),
						'other' => q({0} ছেঃ লিঃ),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(ঘন ছেণ্টিমিটাৰ),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(ঘন ছেণ্টিমিটাৰ),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(ঘন ফুট),
						'one' => q({0} ft³),
						'other' => q({0} ft³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(ঘন ফুট),
						'one' => q({0} ft³),
						'other' => q({0} ft³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(ঘন ইঞ্চি),
						'one' => q({0} in³),
						'other' => q({0} in³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(ঘন ইঞ্চি),
						'one' => q({0} in³),
						'other' => q({0} in³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(ঘন কিলোমিটাৰ),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(ঘন কিলোমিটাৰ),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(ঘন মিটাৰ),
						'one' => q({0} m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(ঘন মিটাৰ),
						'one' => q({0} m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(ঘন মাইল),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(ঘন মাইল),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(ঘন গজ),
						'one' => q({0} yd³),
						'other' => q({0} yd³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(ঘন গজ),
						'one' => q({0} yd³),
						'other' => q({0} yd³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(কাপ),
						'one' => q({0} কাপ),
						'other' => q({0} কাপ),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(কাপ),
						'one' => q({0} কাপ),
						'other' => q({0} কাপ),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(মেঃ কাঃ),
						'one' => q({0} মেঃ কাঃ),
						'other' => q({0} মেঃ কাঃ),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(মেঃ কাঃ),
						'one' => q({0} মেঃ কাঃ),
						'other' => q({0} মেঃ কাঃ),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(ডেঃ লিঃ),
						'one' => q({0} ডেঃ লিঃ),
						'other' => q({0} ডেঃ লিঃ),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(ডেঃ লিঃ),
						'one' => q({0} ডেঃ লিঃ),
						'other' => q({0} ডেঃ লিঃ),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ড্ৰাম তৰল পদাৰ্থ),
						'one' => q({0} ড্ৰাম তৰল পদাৰ্থ),
						'other' => q({0} ড্ৰাম তৰল পদাৰ্থ),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ড্ৰাম তৰল পদাৰ্থ),
						'one' => q({0} ড্ৰাম তৰল পদাৰ্থ),
						'other' => q({0} ড্ৰাম তৰল পদাৰ্থ),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(ড্ৰপ),
						'one' => q({0} ড্ৰপ),
						'other' => q({0} ড্ৰপ),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(ড্ৰপ),
						'one' => q({0} ড্ৰপ),
						'other' => q({0} ড্ৰপ),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(ফ্লুঃ আঃ),
						'one' => q({0} ফ্লুঃ আঃ),
						'other' => q({0} ফ্লুঃ আঃ),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(ফ্লুঃ আঃ),
						'one' => q({0} ফ্লুঃ আঃ),
						'other' => q({0} ফ্লুঃ আঃ),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(ইম্পে. ফ্লু. আ.),
						'one' => q({0} ইম্পে. ফ্লু. আ.),
						'other' => q({0} ইম্পে. ফ্লু. আ.),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(ইম্পে. ফ্লু. আ.),
						'one' => q({0} ইম্পে. ফ্লু. আ.),
						'other' => q({0} ইম্পে. ফ্লু. আ.),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(গেলন),
						'one' => q({0} গেলন),
						'other' => q({0} গেলন),
						'per' => q({0}/গেলন),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(গেলন),
						'one' => q({0} গেলন),
						'other' => q({0} গেলন),
						'per' => q({0}/গেলন),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(ইম্পেঃ গেঃ),
						'one' => q({0} ইম্পেঃ গেঃ),
						'other' => q({0} ইম্পেঃ গেঃ),
						'per' => q({0}/ইম্পেঃ গেঃ),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(ইম্পেঃ গেঃ),
						'one' => q({0} ইম্পেঃ গেঃ),
						'other' => q({0} ইম্পেঃ গেঃ),
						'per' => q({0}/ইম্পেঃ গেঃ),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(হেঃ লিঃ),
						'one' => q({0} হেঃ লিঃ),
						'other' => q({0} হেঃ লিঃ),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(হেঃ লিঃ),
						'one' => q({0} হেঃ লিঃ),
						'other' => q({0} হেঃ লিঃ),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(জিগাৰ),
						'one' => q({0} জিগাৰ),
						'other' => q({0} জিগাৰ),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(জিগাৰ),
						'one' => q({0} জিগাৰ),
						'other' => q({0} জিগাৰ),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(লিটাৰ),
						'one' => q({0} লিঃ),
						'other' => q({0} লিঃ),
						'per' => q({0}/লিঃ),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(লিটাৰ),
						'one' => q({0} লিঃ),
						'other' => q({0} লিঃ),
						'per' => q({0}/লিঃ),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(মেঃ লিঃ),
						'one' => q({0} মেঃ লিঃ),
						'other' => q({0} মেঃ লিঃ),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(মেঃ লিঃ),
						'one' => q({0} মেঃ লিঃ),
						'other' => q({0} মেঃ লিঃ),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(মিঃ লিঃ),
						'one' => q({0} মিঃ লিঃ),
						'other' => q({0} মিঃ লিঃ),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(মিঃ লিঃ),
						'one' => q({0} মিঃ লিঃ),
						'other' => q({0} মিঃ লিঃ),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(পিঞ্চ),
						'one' => q({0} পিঞ্চ),
						'other' => q({0} পিঞ্চ),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(পিঞ্চ),
						'one' => q({0} পিঞ্চ),
						'other' => q({0} পিঞ্চ),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(পিণ্ট),
						'one' => q({0} পিণ্ট),
						'other' => q({0} পিণ্ট),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(পিণ্ট),
						'one' => q({0} পিণ্ট),
						'other' => q({0} পিণ্ট),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(মেঃ পিঃ),
						'one' => q({0} মেঃ পিঃ),
						'other' => q({0} মেঃ পিঃ),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(মেঃ পিঃ),
						'one' => q({0} মেঃ পিঃ),
						'other' => q({0} মেঃ পিঃ),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(কোৱাৰ্ট),
						'one' => q({0} কোৱাৰ্ট),
						'other' => q({0} কোৱাৰ্ট),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(কোৱাৰ্ট),
						'one' => q({0} কোৱাৰ্ট),
						'other' => q({0} কোৱাৰ্ট),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(টেব’লস্পুন),
						'one' => q({0} টেব’লস্পুন),
						'other' => q({0} টেব’লস্পুন),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(টেব’লস্পুন),
						'one' => q({0} টেব’লস্পুন),
						'other' => q({0} টেব’লস্পুন),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(চাহঃ চাঃ),
						'one' => q({0} চাহঃ চাঃ),
						'other' => q({0} চাহঃ চাঃ),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(চাহঃ চাঃ),
						'one' => q({0} চাহঃ চাঃ),
						'other' => q({0} চাহঃ চাঃ),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:হয়|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:নহয়|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'beng',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'beng',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'beng' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 হাজাৰ',
					'other' => '0 হাজাৰ',
				},
				'10000' => {
					'one' => '00 হাজাৰ',
					'other' => '00 হাজাৰ',
				},
				'100000' => {
					'one' => '0 লাখ',
					'other' => '0 লাখ',
				},
				'1000000' => {
					'one' => '0 নিযুত',
					'other' => '0 নিযুত',
				},
				'10000000' => {
					'one' => '00 নিযুত',
					'other' => '00 নিযুত',
				},
				'100000000' => {
					'one' => '000 নিঃ',
					'other' => '000 নিঃ',
				},
				'1000000000' => {
					'one' => '0 শঃ কোঃ',
					'other' => '0 শঃ কোঃ',
				},
				'10000000000' => {
					'one' => '00 শঃ কোঃ',
					'other' => '00 শঃ কোঃ',
				},
				'100000000000' => {
					'one' => '000 শঃ কঃ',
					'other' => '000 শঃ কঃ',
				},
				'1000000000000' => {
					'one' => '0 শঃ পঃ',
					'other' => '0 শঃ পঃ',
				},
				'10000000000000' => {
					'one' => '00 শঃ পঃ',
					'other' => '00 শঃ পঃ',
				},
				'100000000000000' => {
					'one' => '000 শঃ পঃ',
					'other' => '000 শঃ পঃ',
				},
				'standard' => {
					'default' => '#,##,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 হাজাৰ',
					'other' => '0 হাজাৰ',
				},
				'10000' => {
					'one' => '00 হাজাৰ',
					'other' => '00 হাজাৰ',
				},
				'100000' => {
					'one' => '0 লাখ',
					'other' => '0 লাখ',
				},
				'1000000' => {
					'one' => '0 নিযুত',
					'other' => '0 নিযুত',
				},
				'10000000' => {
					'one' => '00 নিযুত',
					'other' => '00 নিযুত',
				},
				'100000000' => {
					'one' => '000 নিযুত',
					'other' => '000 নিযুত',
				},
				'1000000000' => {
					'one' => '0 শত কোটি',
					'other' => '0 শত কোটি',
				},
				'10000000000' => {
					'one' => '00 শত কোটি',
					'other' => '00 শত কোটি',
				},
				'100000000000' => {
					'one' => '000 শত কোটি',
					'other' => '000 শত কোটি',
				},
				'1000000000000' => {
					'one' => '0 শত পৰাৰ্দ্ধ',
					'other' => '0 শত পৰাৰ্দ্ধ',
				},
				'10000000000000' => {
					'one' => '00 শত পৰাৰ্দ্ধ',
					'other' => '00 শত পৰাৰ্দ্ধ',
				},
				'100000000000000' => {
					'one' => '000 শত পৰাৰ্দ্ধ',
					'other' => '000 শত পৰাৰ্দ্ধ',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 হাজাৰ',
					'other' => '0 হাজাৰ',
				},
				'10000' => {
					'one' => '00 হাজাৰ',
					'other' => '00 হাজাৰ',
				},
				'100000' => {
					'one' => '0 লাখ',
					'other' => '0 লাখ',
				},
				'1000000' => {
					'one' => '0 নিযুত',
					'other' => '0 নিযুত',
				},
				'10000000' => {
					'one' => '00 নিযুত',
					'other' => '00 নিযুত',
				},
				'100000000' => {
					'one' => '000 নিঃ',
					'other' => '000 নিঃ',
				},
				'1000000000' => {
					'one' => '0 শঃ কোঃ',
					'other' => '0 শঃ কোঃ',
				},
				'10000000000' => {
					'one' => '00 শঃ কোঃ',
					'other' => '00 শঃ কোঃ',
				},
				'100000000000' => {
					'one' => '000 শঃ কঃ',
					'other' => '000 শঃ কঃ',
				},
				'1000000000000' => {
					'one' => '0 শঃ পঃ',
					'other' => '0 শঃ পঃ',
				},
				'10000000000000' => {
					'one' => '00 শঃ পঃ',
					'other' => '00 শঃ পঃ',
				},
				'100000000000000' => {
					'one' => '000 শঃ পঃ',
					'other' => '000 শঃ পঃ',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'beng' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '¤ #,##,##0.00',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '¤ #,##,##0.00',
					},
					'standard' => {
						'positive' => '¤ #,##,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(সংযুক্ত আৰব আমিৰাত ডিৰহেম),
				'one' => q(UAE ডিৰহেম),
				'other' => q(UAE ডিৰহেম),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(আফগান আফগানী),
				'one' => q(আফগান আফগানী),
				'other' => q(আফগান আফগানী),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(আলবেনীয় লেক),
				'one' => q(আলবেনীয় লেক),
				'other' => q(আলবেনীয় লেক),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(আৰ্মেনিয়ান ড্ৰাম),
				'one' => q(আৰ্মেনিয়ান ড্ৰাম),
				'other' => q(আৰ্মেনিয়ান ড্ৰাম),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(নেডাৰলেণ্ডছ এণ্টিলিয়েন গিল্ডাৰ),
				'one' => q(নেডাৰলেণ্ডছ এণ্টিলিয়েন গিল্ডাৰ),
				'other' => q(নেডাৰলেণ্ডছ এণ্টিলিয়েন গিল্ডাৰ),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(এংগোলান কোৱাঞ্জা),
				'one' => q(এংগোলান কোৱাঞ্জা),
				'other' => q(এংগোলান কোৱাঞ্জা),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(আৰ্জেণ্টাইন পেছো),
				'one' => q(আৰ্জেণ্টাইন পেছো),
				'other' => q(আৰ্জেণ্টাইন পেছো),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(অষ্ট্ৰেলিয়ান ডলাৰ),
				'one' => q(অষ্ট্ৰেলিয়ান ডলাৰ),
				'other' => q(অষ্ট্ৰেলিয়ান ডলাৰ),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(আৰুবান ফ্ল’ৰিন),
				'one' => q(আৰুবান ফ্ল’ৰিন),
				'other' => q(আৰুবান ফ্ল’ৰিন),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(আজেৰবাইজানী মানাত),
				'one' => q(আজেৰবাইজানী মানাত),
				'other' => q(আজেৰবাইজানী মানাত),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(ব’ছনিয়া আৰু হাৰ্জেগ’ভিনা কনভাৰ্টিব্‌ল মাৰ্ক),
				'one' => q(ব’ছনিয়া আৰু হাৰ্জেগ’ভিনা কনভাৰ্টিব্‌ল মাৰ্ক),
				'other' => q(ব’ছনিয়া আৰু হাৰ্জেগ’ভিনা কনভাৰ্টিব্‌ল মাৰ্ক),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(বাৰ্বাডিয়ান ডলাৰ),
				'one' => q(বাৰ্বাডিয়ান ডলাৰ),
				'other' => q(বাৰ্বাডিয়ান ডলাৰ),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(বাংলাদেশী টাকা),
				'one' => q(বাংলাদেশী টাকা),
				'other' => q(বাংলাদেশী টাকা),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(বুলগেৰীয় লেভ),
				'one' => q(বুলগেৰীয় লেভ),
				'other' => q(বুলগেৰীয় লেভ),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(বাহৰেইনী ডিনাৰ),
				'one' => q(বাহৰেইনী ডিনাৰ),
				'other' => q(বাহৰেইনী ডিনাৰ),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(বুৰুণ্ডিয়ান ফ্ৰেংক),
				'one' => q(বুৰুণ্ডিয়ান ফ্ৰেংক),
				'other' => q(বুৰুণ্ডিয়ান ফ্ৰেংক),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(বাৰ্মুডান ডলাৰ),
				'one' => q(বাৰ্মুডান ডলাৰ),
				'other' => q(বাৰ্মুডান ডলাৰ),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(ব্ৰুনেই ডলাৰ),
				'one' => q(ব্ৰুনেই ডলাৰ),
				'other' => q(ব্ৰুনেই ডলাৰ),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(বলিভিয়ান বলিভিয়ানো),
				'one' => q(বলিভিয়ান বলিভিয়ানো),
				'other' => q(বলিভিয়ান বলিভিয়ানো),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ব্ৰাজিলিয়ান ৰিয়েল),
				'one' => q(ব্ৰাজিলিয়ান ৰিয়েল),
				'other' => q(ব্ৰাজিলিয়ান ৰিয়েল),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(বাহামিয়ান ডলাৰ),
				'one' => q(বাহামিয়ান ডলাৰ),
				'other' => q(বাহামিয়ান ডলাৰ),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(ভুটানী নংগলট্ৰাম),
				'one' => q(ভুটানী নংগলট্ৰাম),
				'other' => q(ভুটানী নংগলট্ৰাম),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(ব’টচোৱানান পুলা),
				'one' => q(ব’টচোৱানান পুলা),
				'other' => q(ব’টচোৱানান পুলা),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(বেলাৰুছীয় ৰুবেল),
				'one' => q(বেলাৰুছীয় ৰুবেল),
				'other' => q(বেলাৰুছীয় ৰুবেল),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(বেলিজ ডলাৰ),
				'one' => q(বেলিজ ডলাৰ),
				'other' => q(বেলিজ ডলাৰ),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(কানাডিয়ান ডলাৰ),
				'one' => q(কানাডিয়ান ডলাৰ),
				'other' => q(কানাডিয়ান ডলাৰ),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(কংগো ফ্ৰেংক),
				'one' => q(কংগো ফ্ৰেংক),
				'other' => q(কংগো ফ্ৰেংক),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(চুইছ ফ্ৰেংক),
				'one' => q(চুইছ ফ্ৰেংক),
				'other' => q(চুইছ ফ্ৰেংক),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(চিলিয়ান পেছো),
				'one' => q(চিলিয়ান পেছো),
				'other' => q(চিলিয়ান পেছো),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(চীনা ইউৱান \(অফশ্ব’ৰ\)),
				'one' => q(চীনা ইউৱান \(অফশ্ব’ৰ\)),
				'other' => q(চীনা ইউৱান \(অফশ্ব’ৰ\)),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(চীনা ইউৱান),
				'one' => q(চীনা ইউৱান),
				'other' => q(চীনা ইউৱান),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(কলম্বিয়ান পেছো),
				'one' => q(কলম্বিয়ান পেছো),
				'other' => q(কলম্বিয়ান পেছো),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(কোষ্টা ৰিকান কোলন),
				'one' => q(কোষ্টা ৰিকান কোলন),
				'other' => q(কোষ্টা ৰিকান কোলন),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(কিউবান ৰূপান্তৰযোগ্য পেছো),
				'one' => q(কিউবান ৰূপান্তৰযোগ্য পেছো),
				'other' => q(কিউবান ৰূপান্তৰযোগ্য পেছো),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(কিউবান পেছো),
				'one' => q(কিউবান পেছো),
				'other' => q(কিউবান পেছো),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(কেপ ভাৰ্দে এছকুডো),
				'one' => q(কেপ ভাৰ্দে এছকুডো),
				'other' => q(কেপ ভাৰ্দে এছকুডো),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(চেক কোৰুনা),
				'one' => q(চেক কোৰুনা),
				'other' => q(চেক কোৰুনা),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(জিবুটি ফ্ৰেংক),
				'one' => q(জিবুটি ফ্ৰেংক),
				'other' => q(জিবুটি ফ্ৰেংক),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(ডেনিচ ক্ৰোন),
				'one' => q(ডেনিচ ক্ৰোন),
				'other' => q(ডেনিচ ক্ৰোন),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(ড’মিনিকান পেছো),
				'one' => q(ড’মিনিকান পেছো),
				'other' => q(ড’মিনিকান পেছো),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(আলজেৰীয় ডিনাৰ),
				'one' => q(আলজেৰীয় ডিনাৰ),
				'other' => q(আলজেৰীয় ডিনাৰ),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(ইজিপ্তৰ পাউণ্ড),
				'one' => q(ইজিপ্তৰ পাউণ্ড),
				'other' => q(ইজিপ্তৰ পাউণ্ড),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(এৰিট্ৰিয়ন নাক্‌ফা),
				'one' => q(এৰিট্ৰিয়ন নাক্‌ফা),
				'other' => q(এৰিট্ৰিয়ন নাক্‌ফা),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(ইথিঅ’পিয়ান বিৰ),
				'one' => q(ইথিঅ’পিয়ান বিৰ),
				'other' => q(ইথিঅ’পিয়ান বিৰ),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ইউৰো),
				'one' => q(ইউৰো),
				'other' => q(ইউৰো),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(ফিজিয়ান ডলাৰ),
				'one' => q(ফিজিয়ান ডলাৰ),
				'other' => q(ফিজিয়ান ডলাৰ),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(ফকলেণ্ড দ্বীপপুঞ্জৰ পাউণ্ড),
				'one' => q(ফকলেণ্ড দ্বীপপুঞ্জৰ পাউণ্ড),
				'other' => q(ফকলেণ্ড দ্বীপপুঞ্জৰ পাউণ্ড),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ব্ৰিটিছ পাউণ্ড),
				'one' => q(ব্ৰিটিছ পাউণ্ড),
				'other' => q(ব্ৰিটিছ পাউণ্ড),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(জৰ্জিয়ান লাৰি),
				'one' => q(জৰ্জিয়ান লাৰি),
				'other' => q(জৰ্জিয়ান লাৰি),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(ঘানাৰ চেডি),
				'one' => q(ঘানাৰ চেডি),
				'other' => q(ঘানাৰ চেডি),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(জিব্ৰাল্টৰ পাউণ্ড),
				'one' => q(জিব্ৰাল্টৰ পাউণ্ড),
				'other' => q(জিব্ৰাল্টৰ পাউণ্ড),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(গাম্বিয়া ডালাছি),
				'one' => q(গাম্বিয়া ডালাছি),
				'other' => q(গাম্বিয়া ডালাছি),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(গিনি ফ্ৰেংক),
				'one' => q(গিনি ফ্ৰেংক),
				'other' => q(গিনি ফ্ৰেংক),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(গুৱাটেমালা কুৱেৎজাল),
				'one' => q(গুৱাটেমালা কুৱেৎজাল),
				'other' => q(গুৱাটেমালা কুৱেৎজাল),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(গায়ানিজ ডলাৰ),
				'one' => q(গায়ানিজ ডলাৰ),
				'other' => q(গায়ানিজ ডলাৰ),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(হং কং ডলাৰ),
				'one' => q(হং কং ডলাৰ),
				'other' => q(হং কং ডলাৰ),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(হোন্দুৰান লেম্পিৰা),
				'one' => q(হোন্দুৰান লেম্পিৰা),
				'other' => q(হোন্দুৰান লেম্পিৰা),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(ক্ৰোৱেছিয়ান কুনা),
				'one' => q(ক্ৰোৱেছিয়ান কুনা),
				'other' => q(ক্ৰোৱেছিয়ান কুনা),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(হাইটিয়ান গৌৰ্ড),
				'one' => q(হাইটিয়ান গৌৰ্ড),
				'other' => q(হাইটিয়ান গৌৰ্ড),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(হাংগেৰীয়ান ফ’ৰিণ্ট),
				'one' => q(হাংগেৰীয়ান ফ’ৰিণ্ট),
				'other' => q(হাংগেৰীয়ান ফ’ৰিণ্ট),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(ইণ্ডোনেচিয়ান ৰুপিয়াহ),
				'one' => q(ইণ্ডোনেচিয়ান ৰুপিয়াহ),
				'other' => q(ইণ্ডোনেচিয়ান ৰুপিয়াহ),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(ইজৰাইলী নিউ শ্বেকেল),
				'one' => q(ইজৰাইলী নিউ শ্বেকেল),
				'other' => q(ইজৰাইলী নিউ শ্বেকেল),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(ভাৰতীয় ৰুপী),
				'one' => q(ভাৰতীয় ৰুপী),
				'other' => q(ভাৰতীয় ৰুপী),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(ইৰাকী ডিনাৰ),
				'one' => q(ইৰাকী ডিনাৰ),
				'other' => q(ইৰাকী ডিনাৰ),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(ইৰানীয়ান ৰিয়েল),
				'one' => q(ইৰানীয়ান ৰিয়েল),
				'other' => q(ইৰানীয়ান ৰিয়েল),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(আইচলেণ্ডিক ক্ৰোনা),
				'one' => q(আইচলেণ্ডিক ক্ৰোনা),
				'other' => q(আইচলেণ্ডিক ক্ৰোনাৰ),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(জামাইকান ডলাৰ),
				'one' => q(জামাইকান ডলাৰ),
				'other' => q(জামাইকান ডলাৰ),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(জৰ্ডানিয়ান ডিনাৰ),
				'one' => q(জৰ্ডানিয়ান ডিনাৰ),
				'other' => q(জৰ্ডানিয়ান ডিনাৰ),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(জাপানী য়েন),
				'one' => q(জাপানী য়েন),
				'other' => q(জাপানী য়েন),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(কেনিয়ান শ্বিলিং),
				'one' => q(কেনিয়ান শ্বিলিং),
				'other' => q(কেনিয়ান শ্বিলিং),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(কিৰ্গিস্তানী ছোম),
				'one' => q(কিৰ্গিস্তানী ছোম),
				'other' => q(কিৰ্গিস্তানী ছোম),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(কেম্ব’ডিয়ান ৰিয়েল),
				'one' => q(কেম্ব’ডিয়ান ৰিয়েল),
				'other' => q(কেম্ব’ডিয়ান ৰিয়েল),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(ক’মোৰিয়ান ফ্ৰেংক),
				'one' => q(ক’মোৰিয়ান ফ্ৰেংক),
				'other' => q(ক’মোৰিয়ান ফ্ৰেংক),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(উত্তৰ কোৰিয়াৰ ওৱান),
				'one' => q(উত্তৰ কোৰিয়াৰ ওৱান),
				'other' => q(উত্তৰ কোৰিয়াৰ ওৱান),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(দক্ষিণ কোৰিয়াৰ ওৱান),
				'one' => q(দক্ষিণ কোৰিয়াৰ ওৱান),
				'other' => q(দক্ষিণ কোৰিয়াৰ ওৱান),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(কুৱেইটি ডিনাৰ),
				'one' => q(কুৱেইটি ডিনাৰ),
				'other' => q(কুৱেইটি ডিনাৰ),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(কেইমেন দ্বীপপুঞ্জৰ ডলাৰ),
				'one' => q(কেইমেন দ্বীপপুঞ্জৰ ডলাৰ),
				'other' => q(কেইমেন দ্বীপপুঞ্জৰ ডলাৰ),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(কাজাখস্তানী তেঞ্জ),
				'one' => q(কাজাখস্তানী তেঞ্জ),
				'other' => q(কাজাখস্তানী তেঞ্জ),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(লাওচিয়ান কিপ),
				'one' => q(লাওচিয়ান কিপ),
				'other' => q(লাওচিয়ান কিপ),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(লেবানীজ পাউণ্ড),
				'one' => q(লেবানীজ পাউণ্ড),
				'other' => q(লেবানীজ পাউণ্ড),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(শ্ৰীলংকান ৰুপী),
				'one' => q(শ্ৰীলংকান ৰুপী),
				'other' => q(শ্ৰীলংকান ৰুপী),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(লাইবেৰিয়ান ডলাৰ),
				'one' => q(লাইবেৰিয়ান ডলাৰ),
				'other' => q(লাইবেৰিয়ান ডলাৰ),
			},
		},
		'LSL' => {
			symbol => 'LSL',
			display_name => {
				'currency' => q(লেচোথো লোটি),
				'one' => q(লেচোথো লোটি),
				'other' => q(লেচোথো লোটিচ),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(লিবিয়ান ডিনাৰ),
				'one' => q(লিবিয়ান ডিনাৰ),
				'other' => q(লিবিয়ান ডিনাৰ),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(মৰোক্কান ডিৰহাম),
				'one' => q(মৰোক্কান ডিৰহাম),
				'other' => q(মৰোক্কান ডিৰহাম),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(মোলডোভান লেউ),
				'one' => q(মোলডোভান লেউ),
				'other' => q(মোলডোভান লেই),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(মালাগাছী এৰিয়াৰী),
				'one' => q(মালাগাছী এৰিয়াৰী),
				'other' => q(মালাগাছী এৰিয়াৰী),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(মেচিডোনীয় ডেনাৰ),
				'one' => q(মেচিডোনীয় ডেনাৰ),
				'other' => q(মেচিডোনীয় ডেনাৰ),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(ম্যানমাৰ কিয়াট),
				'one' => q(ম্যানমাৰ কিয়াট),
				'other' => q(ম্যানমাৰ কিয়াট),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(মঙ্গোলিয়ান টুৰ্গিক),
				'one' => q(মঙ্গোলিয়ান টুৰ্গিক),
				'other' => q(মঙ্গোলিয়ান টুৰ্গিক),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(মেকানীজ পাটাকা),
				'one' => q(মেকানীজ পাটাকা),
				'other' => q(মেকানীজ পাটাকা),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(ম’ৰিটেনিয়ান ঔগুইয়া \(1973–2017\)),
				'one' => q(ম’ৰিটেনিয়ান ঔগুইয়া \(1973–2017\)),
				'other' => q(ম’ৰিটেনিয়ান ঔগুইয়া \(1973–2017\)),
			},
		},
		'MRU' => {
			symbol => 'MRU',
			display_name => {
				'currency' => q(ম’ৰিটেনিয়ান ঔগুইয়া),
				'one' => q(ম’ৰিটেনিয়ান ঔগুইয়া),
				'other' => q(ম’ৰিটেনিয়ান ঔগুইয়া),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(মৰিচিয়ান ৰুপী),
				'one' => q(মৰিচিয়ান ৰুপী),
				'other' => q(মৰিচিয়ান ৰুপী),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(মালডিভিয়ান ৰুফিয়া),
				'one' => q(মালডিভিয়ান ৰুফিয়া),
				'other' => q(মালডিভিয়ান ৰুফিয়া),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(মালাউইয়ান কোৱাচা),
				'one' => q(মালাউইয়ান কোৱাচা),
				'other' => q(মালাউইয়ান কোৱাচা),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(মেক্সিকান পেছো),
				'one' => q(মেক্সিকান পেছো),
				'other' => q(মেক্সিকান পেছো),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(মালায়েচিয়ান ৰিংগিট),
				'one' => q(মালায়েচিয়ান ৰিংগিট),
				'other' => q(মালায়েচিয়ান ৰিংগিট),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(মোজাম্বিকান মেটিকল),
				'one' => q(মোজাম্বিকান মেটিকল),
				'other' => q(মোজাম্বিকান মেটিকল),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(নামিবিয়ান ডলাৰ),
				'one' => q(নামিবিয়ান ডলাৰ),
				'other' => q(নামিবিয়ান ডলাৰ),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(নাইজেৰিয়ান নাইৰা),
				'one' => q(নাইজেৰিয়ান নাইৰা),
				'other' => q(নাইজেৰিয়ান নাইৰা),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(নিকাৰাগুৱান কোৰ্ডোবা),
				'one' => q(নিকাৰাগুৱান কোৰ্ডোবা),
				'other' => q(নিকাৰাগুৱান কোৰ্ডোবা),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(নৰৱেজিয়ান ক্ৰোন),
				'one' => q(নৰৱেজিয়ান ক্ৰোন),
				'other' => q(নৰৱেজিয়ান ক্ৰোনাৰ),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(নেপালী ৰুপী),
				'one' => q(নেপালী ৰুপী),
				'other' => q(নেপালী ৰুপী),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(নিউজিলেণ্ড ডলাৰ),
				'one' => q(নিউজিলেণ্ড ডলাৰ),
				'other' => q(নিউজিলেণ্ড ডলাৰ),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(ওমানি ৰিয়েল),
				'one' => q(ওমানি ৰিয়েল),
				'other' => q(ওমানি ৰিয়েল),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(পানামেনিয়ান বাল্বোৱা),
				'one' => q(পানামেনিয়ান বাল্বোৱা),
				'other' => q(পানামেনিয়ান বাল্বোৱা),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(পেৰুভিয়ান ছ’ল),
				'one' => q(পেৰুভিয়ান ছ’ল),
				'other' => q(পেৰুভিয়ান ছ’ল),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(পাপুৱা নিউ গিনি কিনা),
				'one' => q(পাপুৱা নিউ গিনি কিনা),
				'other' => q(পাপুৱা নিউ গিনি কিনা),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(ফিলিপিন পেইছ’),
				'one' => q(ফিলিপিন পেইছ’),
				'other' => q(ফিলিপিন পেইছ’),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(পাকিস্তানী ৰুপী),
				'one' => q(পাকিস্তানী ৰুপী),
				'other' => q(পাকিস্তানী ৰুপী),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(প’লিচ জোল্টী),
				'one' => q(প’লিচ জোল্টী),
				'other' => q(প’লিচ জোল্টী),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(পাৰাগুয়ান গুৱাৰানি),
				'one' => q(পাৰাগুয়ান গুৱাৰানি),
				'other' => q(পাৰাগুয়ান গুৱাৰানি),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(কাটাৰি ৰিয়েল),
				'one' => q(কাটাৰি ৰিয়েল),
				'other' => q(কাটাৰি ৰিয়েল),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(ৰোমানীয় লেউ),
				'one' => q(ৰোমানীয় লেউ),
				'other' => q(ৰোমানীয় লেউ),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(চাৰ্বিয়ান ডিনাৰ),
				'one' => q(চাৰ্বিয়ান ডিনাৰ),
				'other' => q(চাৰ্বিয়ান ডিনাৰ),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(ৰাছিয়ান ৰুব্‌ল),
				'one' => q(ৰাছিয়ান ৰুব্‌ল),
				'other' => q(ৰাছিয়ান ৰুব্‌ল),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(ৰোৱান্দান ফ্ৰেংক),
				'one' => q(ৰোৱান্দান ফ্ৰেংক),
				'other' => q(ৰোৱান্দান ফ্ৰেংক),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(চৌডি ৰিয়েল),
				'one' => q(চৌডি ৰিয়েল),
				'other' => q(চৌডি ৰিয়েল),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(চোলোমোন দ্বীপপুঞ্জৰ ডলাৰ),
				'one' => q(চোলোমোন দ্বীপপুঞ্জৰ ডলাৰ),
				'other' => q(চোলোমোন দ্বীপপুঞ্জৰ ডলাৰ),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(ছেচেলৱা ৰুপী),
				'one' => q(ছেচেলৱা ৰুপী),
				'other' => q(ছেচেলৱা ৰুপী),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(চুডানী পাউণ্ড),
				'one' => q(চুডানী পাউণ্ড),
				'other' => q(চুডানী পাউণ্ড),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(চুইডিছ ক্ৰোনা),
				'one' => q(চুইডিছ ক্ৰোনা),
				'other' => q(চুইডিছ ক্ৰোনোৰ),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(ছিংগাপুৰ ডলাৰ),
				'one' => q(ছিংগাপুৰ ডলাৰ),
				'other' => q(ছিংগাপুৰ ডলাৰ),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(ছেইণ্ট হেলেনা পাউণ্ড),
				'one' => q(ছেইণ্ট হেলেনা পাউণ্ড),
				'other' => q(ছেইণ্ট হেলেনা পাউণ্ড),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(চিয়েৰা লিঅ’নৰ লিঅ’ন),
				'one' => q(চিয়েৰা লিঅ’নৰ লিঅ’ন),
				'other' => q(চিয়েৰা লিঅ’নৰ লিঅ’ন),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(চোমালি শ্বিলিং),
				'one' => q(চোমালি শ্বিলিং),
				'other' => q(চোমালি শ্বিলিং),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(ছুৰিনামী ডলাৰ),
				'one' => q(ছুৰিনামী ডলাৰ),
				'other' => q(ছুৰিনামী ডলাৰ),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(দক্ষিণ চুডানীজ পাউণ্ড),
				'one' => q(দক্ষিণ চুডানীজ পাউণ্ড),
				'other' => q(দক্ষিণ চুডানীজ পাউণ্ড),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(চাও টোমে আৰু প্ৰিনচিপে ডোব্‌ৰা \(1977–2017\)),
				'one' => q(চাও টোমে আৰু প্ৰিনচিপে ডোব্‌ৰা \(1977–2017\)),
				'other' => q(চাও টোমে আৰু প্ৰিনচিপে ডোব্‌ৰা \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'STN',
			display_name => {
				'currency' => q(চাও টোমে আৰু প্ৰিনচিপে ডোব্‌ৰা),
				'one' => q(চাও টোমে আৰু প্ৰিনচিপে ডোব্‌ৰা),
				'other' => q(চাও টোমে আৰু প্ৰিনচিপে ডোব্‌ৰা),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(চিৰিয়ান পাউণ্ড),
				'one' => q(চিৰিয়ান পাউণ্ড),
				'other' => q(চিৰিয়ান পাউণ্ড),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(স্বাজি লিলেংগেনি),
				'one' => q(স্বাজি লিলেংগেনি),
				'other' => q(স্বাজি এমেলানজেনি),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(থাই বাত),
				'one' => q(থাই বাত),
				'other' => q(থাই বাত),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(তাজিকিস্তানী ছোমনি),
				'one' => q(তাজিকিস্তানী ছোমনি),
				'other' => q(তাজিকিস্তানী ছোমনি),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(তুৰ্কমেনিস্তানী মানাত),
				'one' => q(তুৰ্কমেনিস্তানী মানাত),
				'other' => q(তুৰ্কমেনিস্তানী মানাত),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(টুনিচিয়ান ডিনাৰ),
				'one' => q(টুনিচিয়ান ডিনাৰ),
				'other' => q(টুনিচিয়ান ডিনাৰ),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(টংগান পাআংগা),
				'one' => q(টংগান পাআংগা),
				'other' => q(টংগান পাআংগা),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(তুৰ্কীৰ লিৰা),
				'one' => q(তুৰ্কীৰ লিৰা),
				'other' => q(তুৰ্কীৰ লিৰা),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(ট্ৰিনিডাড আৰু টোবাগো ডলাৰ),
				'one' => q(ট্ৰিনিডাড আৰু টোবাগো ডলাৰ),
				'other' => q(ট্ৰিনিডাড আৰু টোবাগো ডলাৰ),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(নিউ টাইৱান ডলাৰ),
				'one' => q(নিউ টাইৱান ডলাৰ),
				'other' => q(নিউ টাইৱান ডলাৰ),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(টানজানিয়ান শ্বিলিং),
				'one' => q(টানজানিয়ান শ্বিলিং),
				'other' => q(টানজানিয়ান শ্বিলিং),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(ইউক্ৰেইনীয় হৃভনিয়া),
				'one' => q(ইউক্ৰেইনীয় হৃভনিয়া),
				'other' => q(ইউক্ৰেইনীয় হৃভনিয়া),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(উগাণ্ডান শ্বিলিং),
				'one' => q(উগাণ্ডান শ্বিলিং),
				'other' => q(উগাণ্ডান শ্বিলিং),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(ইউ. এছ. ডলাৰ),
				'one' => q(ইউ. এছ. ডলাৰ),
				'other' => q(ইউ. এছ. ডলাৰ),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(উৰুগুৱেয়ান পেছো),
				'one' => q(উৰুগুৱেয়ান পেছো),
				'other' => q(উৰুগুৱেয়ান পেছো),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(উজবেকিস্তানী ছোম),
				'one' => q(উজবেকিস্তানী ছোম),
				'other' => q(উজবেকিস্তানী ছোম),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(ভেনিজুৱেলান বলিভাৰ \(1871–2008\)),
				'one' => q(ভেনিজুৱেলান বলিভাৰ \(1871–2008\)),
				'other' => q(ভেনিজুৱেলান বলিভাৰ \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(ভেনিজুৱেলান বলিভাৰ \(2008–2018\)),
				'one' => q(ভেনিজুৱেলান বলিভাৰ \(2008–2018\)),
				'other' => q(ভেনিজুৱেলান বলিভাৰ \(2008–2018\)),
			},
		},
		'VES' => {
			symbol => 'VES',
			display_name => {
				'currency' => q(ভেনিজুৱেলান বলিভাৰ),
				'one' => q(ভেনিজুৱেলান ব’লিভাৰ),
				'other' => q(ভেনিজুৱেলান ব’লিভাৰছ্),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ভিয়েটনামীজ ডং),
				'one' => q(ভিয়েটনামীজ ডং),
				'other' => q(ভিয়েটনামীজ ডং),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(ভানাটুৰ ভাটু),
				'one' => q(ভানাটুৰ ভাটু),
				'other' => q(ভানাটুৰ ভাটু),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(ছামোৱান টালা),
				'one' => q(ছামোৱান টালা),
				'other' => q(ছামোৱান টালা),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(মধ্য আফ্ৰিকান CFA ফ্ৰেংক),
				'one' => q(মধ্য আফ্ৰিকান CFA ফ্ৰেংক),
				'other' => q(মধ্য আফ্ৰিকান CFA ফ্ৰেংক),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(ইষ্ট কেৰিবিয়ান ডলাৰ),
				'one' => q(ইষ্ট কেৰিবিয়ান ডলাৰ),
				'other' => q(ইষ্ট কেৰিবিয়ান ডলাৰ),
			},
		},
		'XOF' => {
			symbol => 'F CFA',
			display_name => {
				'currency' => q(পশ্চিম আফ্ৰিকান CFA ফ্ৰেংক),
				'one' => q(পশ্চিম আফ্ৰিকান CFA ফ্ৰেংক),
				'other' => q(পশ্চিম আফ্ৰিকান CFA ফ্ৰেংক),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP ফ্ৰেংক),
				'one' => q(CFP ফ্ৰেংক),
				'other' => q(CFP ফ্ৰেংক),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(অজ্ঞাত মুদ্ৰা),
				'one' => q(\(মুদ্ৰাৰ একক অজ্ঞাত\)),
				'other' => q(\(অজ্ঞাত মুদ্ৰা\)),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(য়েমেনী ৰিয়েল),
				'one' => q(য়েমেনী ৰিয়েল),
				'other' => q(য়েমেনী ৰিয়েল),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(দক্ষিণ আফ্ৰিকাৰ ৰাণ্ড),
				'one' => q(দক্ষিণ আফ্ৰিকাৰ ৰাণ্ড),
				'other' => q(দক্ষিণ আফ্ৰিকাৰ ৰাণ্ড),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(জাম্বিয়ান কোৱাচা),
				'one' => q(জাম্বিয়ান কোৱাচা),
				'other' => q(জাম্বিয়ান কোৱাচা),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'জানু',
							'ফেব্ৰু',
							'মাৰ্চ',
							'এপ্ৰিল',
							'মে’',
							'জুন',
							'জুলাই',
							'আগ',
							'ছেপ্তে',
							'অক্টো',
							'নৱে',
							'ডিচে'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'জ',
							'ফ',
							'ম',
							'এ',
							'ম',
							'জ',
							'জ',
							'আ',
							'ছ',
							'অ',
							'ন',
							'ড'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'জানুৱাৰী',
							'ফেব্ৰুৱাৰী',
							'মাৰ্চ',
							'এপ্ৰিল',
							'মে’',
							'জুন',
							'জুলাই',
							'আগষ্ট',
							'ছেপ্তেম্বৰ',
							'অক্টোবৰ',
							'নৱেম্বৰ',
							'ডিচেম্বৰ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'জানু',
							'ফেব্ৰু',
							'মাৰ্চ',
							'এপ্ৰিল',
							'মে’',
							'জুন',
							'জুলাই',
							'আগ',
							'ছেপ্তে',
							'অক্টো',
							'নৱে',
							'ডিচে'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'জ',
							'ফ',
							'ম',
							'এ',
							'ম',
							'জ',
							'জ',
							'আ',
							'ছ',
							'অ',
							'ন',
							'ড'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'জানুৱাৰী',
							'ফেব্ৰুৱাৰী',
							'মাৰ্চ',
							'এপ্ৰিল',
							'মে’',
							'জুন',
							'জুলাই',
							'আগষ্ট',
							'ছেপ্তেম্বৰ',
							'অক্টোবৰ',
							'নৱেম্বৰ',
							'ডিচেম্বৰ'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'সোম',
						tue => 'মঙ্গল',
						wed => 'বুধ',
						thu => 'বৃহ',
						fri => 'শুক্ৰ',
						sat => 'শনি',
						sun => 'দেও'
					},
					narrow => {
						mon => 'স',
						tue => 'ম',
						wed => 'ব',
						thu => 'ব',
						fri => 'শ',
						sat => 'শ',
						sun => 'দ'
					},
					short => {
						mon => 'সোম',
						tue => 'মঙ্গল',
						wed => 'বুধ',
						thu => 'বৃহ',
						fri => 'শুক্ৰ',
						sat => 'শনি',
						sun => 'দেও'
					},
					wide => {
						mon => 'সোমবাৰ',
						tue => 'মঙ্গলবাৰ',
						wed => 'বুধবাৰ',
						thu => 'বৃহস্পতিবাৰ',
						fri => 'শুক্ৰবাৰ',
						sat => 'শনিবাৰ',
						sun => 'দেওবাৰ'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'সোম',
						tue => 'মঙ্গল',
						wed => 'বুধ',
						thu => 'বৃহ',
						fri => 'শুক্ৰ',
						sat => 'শনি',
						sun => 'দেও'
					},
					narrow => {
						mon => 'স',
						tue => 'ম',
						wed => 'ব',
						thu => 'ব',
						fri => 'শ',
						sat => 'শ',
						sun => 'দ'
					},
					short => {
						mon => 'সোম',
						tue => 'মঙ্গল',
						wed => 'বুধ',
						thu => 'বৃহ',
						fri => 'শুক্ৰ',
						sat => 'শনি',
						sun => 'দেও'
					},
					wide => {
						mon => 'সোমবাৰ',
						tue => 'মঙ্গলবাৰ',
						wed => 'বুধবাৰ',
						thu => 'বৃহস্পতিবাৰ',
						fri => 'শুক্ৰবাৰ',
						sat => 'শনিবাৰ',
						sun => 'দেওবাৰ'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '১মঃ তিঃ',
						1 => '২য়ঃ তিঃ',
						2 => '৩য়ঃ তিঃ',
						3 => '৪ৰ্থঃ তিঃ'
					},
					narrow => {0 => '১',
						1 => '২',
						2 => '৩',
						3 => '৪'
					},
					wide => {0 => 'প্ৰথম তিনিমাহ',
						1 => 'দ্বিতীয় তিনিমাহ',
						2 => 'তৃতীয় তিনিমাহ',
						3 => 'চতুৰ্থ তিনিমাহ'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => '১মঃ তিঃ',
						1 => '২য়ঃ তিঃ',
						2 => '৩য়ঃ তিঃ',
						3 => '৪ৰ্থঃ তিঃ'
					},
					narrow => {0 => '১',
						1 => '২',
						2 => '৩',
						3 => '৪'
					},
					wide => {0 => 'প্ৰথম তিনিমাহ',
						1 => 'দ্বিতীয় তিনিমাহ',
						2 => 'তৃতীয় তিনিমাহ',
						3 => 'চতুৰ্থ তিনিমাহ'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'am' => q{পূৰ্বাহ্ন},
					'pm' => q{অপৰাহ্ন},
				},
				'narrow' => {
					'am' => q{পূৰ্বাহ্ন},
					'pm' => q{অপৰাহ্ন},
				},
				'wide' => {
					'am' => q{পূৰ্বাহ্ন},
					'pm' => q{অপৰাহ্ন},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'am' => q{পূৰ্বাহ্ন},
					'pm' => q{অপৰাহ্ন},
				},
				'narrow' => {
					'am' => q{পূৰ্বাহ্ন},
					'pm' => q{অপৰাহ্ন},
				},
				'wide' => {
					'am' => q{পূৰ্বাহ্ন},
					'pm' => q{অপৰাহ্ন},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'খ্ৰীঃ পূঃ',
				'1' => 'খ্ৰীঃ'
			},
			wide => {
				'0' => 'খ্ৰীষ্টপূৰ্ব',
				'1' => 'খ্ৰীষ্টাব্দ'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{G y MMMM d, EEEE},
			'long' => q{G y MMMM d},
			'medium' => q{G y MMM d},
			'short' => q{GGGGG y-MM-dd},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM, y},
			'long' => q{d MMMM, y},
			'medium' => q{dd-MM-y},
			'short' => q{d-M-y},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{a h.mm.ss zzzz},
			'long' => q{a h.mm.ss z},
			'medium' => q{a h.mm.ss},
			'short' => q{a h.mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0} বজাত},
			'long' => q{{1} {0} বজাত},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			E => q{ccc},
			EBhm => q{E B h:mm},
			EBhms => q{E, B h:mm:ss},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, E},
			Ehm => q{E, a h:mm},
			Ehms => q{E, a h:mm:ss},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			GyMd => q{d/M/y GGGGG},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{MM-dd, E},
			MMM => q{LLL},
			MMMEd => q{MMM d, E},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			Md => q{MM-dd},
			d => q{d},
			h => q{a h},
			hm => q{a h:mm},
			hms => q{a h:mm:ss},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{MM-y GGGGG},
			yyyyMEd => q{E, dd-MM-y GGGGG},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d MMM y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM y G},
			yyyyMd => q{dd-MM-y GGGGG},
			yyyyQQQ => q{G y QQQ},
			yyyyQQQQ => q{G y QQQQ},
		},
		'gregorian' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			E => q{ccc},
			EBhm => q{E B h:mm},
			EBhms => q{E B h:mm:ss},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E d},
			Ehm => q{E a h:mm},
			Ehms => q{E a h:mm:ss},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			GyMd => q{d/M/y GGGGG},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E, dd-MM},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMW => q{MMMMৰ সপ্তাহ W},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd-MM},
			d => q{d},
			h => q{a h},
			hm => q{a h:mm},
			hms => q{a h:mm:ss},
			hmsv => q{a h:mm:ss v},
			hmv => q{a h:mm v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{MM-y},
			yMEd => q{E, dd-MM-y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{dd-MM-y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{Yৰ সপ্তাহ w},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => {
				B => q{h B – h B},
				h => q{h – h B},
			},
			Bhm => {
				B => q{h:mm B – h:mm B},
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			GyM => {
				G => q{GGGGG M/y – GGGGG M/y},
				M => q{GGGGG M/y – M/y},
				y => q{GGGGG M/y – M/y},
			},
			GyMEd => {
				G => q{GGGGG E, d/M/y – GGGGG E, d/M/y},
				M => q{GGGGG E, d/M/y – E, d/M/y},
				d => q{GGGGG E, d/M/y – E, d/M/y},
				y => q{GGGGG E, d/M/y – E, d/M/y},
			},
			GyMMM => {
				G => q{G MMM y – G MMM y},
				M => q{G MMM – MMM y},
				y => q{G MMM y – MMM y},
			},
			GyMMMEd => {
				G => q{G E, d MMM, y – G E, d MMM, y},
				M => q{G E, d MMM – E, d MMM, y},
				d => q{G E, d MMM – E, d MMM, y},
				y => q{G E, d MMM, y – E, d MMM, y},
			},
			GyMMMd => {
				G => q{G d MMM, y – G d MMM, y},
				M => q{G d MMM – d MMM, y},
				d => q{G d – d MMM, y},
				y => q{G d MMM, y – d MMM, y},
			},
			GyMd => {
				G => q{GGGGG d/M/y – GGGGG d/M/y},
				M => q{GGGGG d/M/y – d/M/y},
				d => q{GGGGG d/M/y – d/M/y},
				y => q{GGGGG d/M/y – d/M/y},
			},
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{MM-dd, E – MM-dd, E},
				d => q{MM-dd, E – MM-dd, E},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{MMM d, E – MMM d, E},
				d => q{MMM d, E – MMM d, E},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d–d},
			},
			Md => {
				M => q{MM-dd – MM-dd},
				d => q{MM-dd – MM-dd},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			y => {
				y => q{G y–y},
			},
			yM => {
				M => q{GGGGG y-MM – y-MM},
				y => q{GGGGG y-MM – y-MM},
			},
			yMEd => {
				M => q{GGGGG y-MM-dd, E – y-MM-dd, E},
				d => q{GGGGG y-MM-dd, E – y-MM-dd, E},
				y => q{GGGGG y-MM-dd, E – y-MM-dd, E},
			},
			yMMM => {
				M => q{G y MMM–MMM},
				y => q{G y MMM – y MMM},
			},
			yMMMEd => {
				M => q{G y MMM d, E – MMM d, E},
				d => q{G y MMM d, E – MMM d, E},
				y => q{G y MMM d, E – y MMM d, E},
			},
			yMMMM => {
				M => q{G y MMMM–MMMM},
				y => q{G y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{G y MMM d – MMM d},
				d => q{G y MMM d–d},
				y => q{G y MMM d – y MMM d},
			},
			yMd => {
				M => q{GGGGG y-MM-dd – y-MM-dd},
				d => q{GGGGG y-MM-dd – y-MM-dd},
				y => q{GGGGG y-MM-dd – y-MM-dd},
			},
		},
		'gregorian' => {
			Bh => {
				B => q{h B – h B},
				h => q{h – h B},
			},
			Bhm => {
				B => q{h:mm B – h:mm B},
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			Gy => {
				G => q{G y – G y},
				y => q{G y – y},
			},
			GyM => {
				G => q{GGGGG M/y – GGGGG M/y},
				M => q{GGGGG M/y – M/y},
				y => q{GGGGG M/y – M/y},
			},
			GyMEd => {
				G => q{GGGGG E, d/M/y – GGGGG E, d/M/y},
				M => q{GGGGG E, d/M/y – E, d/M/y},
				d => q{GGGGG E, d/M/y – E, d/M/y},
				y => q{GGGGG E, d/M/y – E, d/M/y},
			},
			GyMMM => {
				G => q{G MMM y – G MMM y},
				M => q{G MMM – MMM y},
				y => q{G MMM y – MMM y},
			},
			GyMMMEd => {
				G => q{G E, d MMM, y – G E, d MMM, y},
				M => q{G E, d MMM – E, d MMM, y},
				d => q{G E, d MMM – E, d MMM, y},
				y => q{G E, d MMM, y – E, d MMM, y},
			},
			GyMMMd => {
				G => q{G d MMM, y – G d MMM, y},
				M => q{G d MMM – d MMM, y},
				d => q{G d – d MMM, y},
				y => q{G d MMM, y – d MMM, y},
			},
			GyMd => {
				G => q{GGGGG d/M/y – GGGGG d/M/y},
				M => q{GGGGG d/M/y – d/M/y},
				d => q{GGGGG d/M/y – d/M/y},
				y => q{GGGGG d/M/y – d/M/y},
			},
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{E, dd-MM – E, dd-MM},
				d => q{E, dd-MM – E, dd-MM},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{dd-MM – dd-MM},
				d => q{dd-MM – dd-MM},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{a h – a h},
				h => q{a h–h},
			},
			hm => {
				a => q{a h:mm – a h:mm},
				h => q{a h:mm–h:mm},
				m => q{a h:mm–h:mm},
			},
			hmv => {
				a => q{a h:mm – a h:mm v},
				h => q{a h:mm–h:mm v},
				m => q{a h:mm–h:mm v},
			},
			hv => {
				a => q{a h – a h v},
				h => q{a h–h v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{MM-y – MM-y},
				y => q{MM-y – MM-y},
			},
			yMEd => {
				M => q{dd-MM-y, E – dd-MM-y},
				d => q{dd-MM-y, E – dd-MM-y},
				y => q{dd-MM-y, E – dd-MM-y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM y – E, d MMM},
				d => q{E, d MMM y – E, d MMM},
				y => q{E, d MMM y – d MMM y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM y – d MMM},
				d => q{d–d MMM y},
				y => q{d MMM y – d MMM y},
			},
			yMd => {
				M => q{dd-MM-y – dd-MM-y},
				d => q{dd-MM-y – dd-MM-y},
				y => q{dd-MM-y – dd-MM-y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} সময়),
		regionFormat => q({0} (+1) ডেলাইট সময়),
		regionFormat => q({0} (+0) মান সময়),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#আফগানিস্তানৰ সময়#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#আবিডজান#,
		},
		'Africa/Accra' => {
			exemplarCity => q#এক্ৰা#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#আদ্দিছ আবাবা#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#আলজিয়াৰ্ছ#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#আস্মাৰা#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#বামাকো#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#বাংগুই#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#বেঞ্জুল#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#বিছাউ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ব্লাণ্টায়াৰ#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ব্ৰাজাভিলে#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#বুজুম্বুৰা#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#কাইৰো#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#কাছাব্লাংকা#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#চেউটা#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#কোনাক্ৰী#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ডাকাৰ#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ডাৰ এছ ছালাম#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#জিবুটি#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ডুৱালা#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#এল আইয়ুন#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ফ্ৰিটাউন#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#গাবোৰোণ#,
		},
		'Africa/Harare' => {
			exemplarCity => q#হাৰাৰে#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#জোহান্সবাৰ্গ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#জুবা#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#কাম্পালা#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#খাৰ্টুম#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#কিগালী#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#কিংচাছা#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#লাগোছ#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#লিব্ৰিভিলে#,
		},
		'Africa/Lome' => {
			exemplarCity => q#লোম#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#লুৱাণ্ডা#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#লুবুম্বাচি#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#লুছাকা#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#মালাবো#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#মাপুটো#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#মাছেৰু#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#এম্বাবেন#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#মোগাদিচু#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#মোনৰোভিয়া#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#নাইৰোবি#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#নেদজামেনা#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#নিয়ামী#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#নৌআকচোট#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ঔগাডোগো#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#পোৰ্টো-নোভো#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#চাও টোমে#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ত্ৰিপোলি#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#টুনিছ#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ৱিণ্ডহোক#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#মধ্য আফ্ৰিকাৰ সময়#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#পূব আফ্ৰিকাৰ সময়#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#দক্ষিণ আফ্ৰিকাৰ মান সময়#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#পশ্চিম আফ্ৰিকাৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#পশ্চিম আফ্ৰিকাৰ সময়#,
				'standard' => q#পশ্চিম আফ্ৰিকাৰ মান সময়#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#আলাস্কাৰ ডেলাইট সময়#,
				'generic' => q#আলাস্কাৰ সময়#,
				'standard' => q#আলাস্কাৰ মান সময়#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#আমাজনৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#আমাজনৰ সময়#,
				'standard' => q#আমাজনৰ মান সময়#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#আডাক#,
		},
		'America/Anchorage' => {
			exemplarCity => q#এংকোৰেজ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#এনগুইলা#,
		},
		'America/Antigua' => {
			exemplarCity => q#এণ্টিগুৱা#,
		},
		'America/Araguaina' => {
			exemplarCity => q#আৰাগায়েনা#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#লা ৰিওজা#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ৰিঅ’ গালেগোছ#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#ছাল্টা#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#ছেন জুৱান#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#ছেন লুইচ#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#টুকুমন#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#উচুআইয়া#,
		},
		'America/Aruba' => {
			exemplarCity => q#আৰুবা#,
		},
		'America/Asuncion' => {
			exemplarCity => q#আছুনচিয়ন#,
		},
		'America/Bahia' => {
			exemplarCity => q#বাহিয়া#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#বাহিয়া বান্দেৰাছ#,
		},
		'America/Barbados' => {
			exemplarCity => q#বাৰ্বাডোচ#,
		},
		'America/Belem' => {
			exemplarCity => q#বেলেম#,
		},
		'America/Belize' => {
			exemplarCity => q#বেলিজ#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ব্লাংক-ছেবলোন#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#বোৱা ভিষ্টা#,
		},
		'America/Bogota' => {
			exemplarCity => q#বোগোটা#,
		},
		'America/Boise' => {
			exemplarCity => q#ব’ইজে#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#বুনছ আয়াৰ্ছ#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#কেমব্ৰিজ উপসাগৰ#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#কেম্পো গ্ৰেণ্ডে#,
		},
		'America/Cancun' => {
			exemplarCity => q#কেনকুন#,
		},
		'America/Caracas' => {
			exemplarCity => q#কাৰাকাছ#,
		},
		'America/Catamarca' => {
			exemplarCity => q#কাটামাৰ্কা#,
		},
		'America/Cayenne' => {
			exemplarCity => q#কেয়েন#,
		},
		'America/Cayman' => {
			exemplarCity => q#কেইমেন#,
		},
		'America/Chicago' => {
			exemplarCity => q#চিকাগো#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#চিহুআহুৱা#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#আটিকোকান#,
		},
		'America/Cordoba' => {
			exemplarCity => q#কোৰ্ডোবা#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#কোষ্টা ৰিকা#,
		},
		'America/Creston' => {
			exemplarCity => q#ক্ৰেষ্টন#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#কুইআবা#,
		},
		'America/Curacao' => {
			exemplarCity => q#কুৰাকাও#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ডেনমাৰ্কশ্বন#,
		},
		'America/Dawson' => {
			exemplarCity => q#ডাওছন#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ডাওছন ক্ৰীক#,
		},
		'America/Denver' => {
			exemplarCity => q#ডেনভাৰ#,
		},
		'America/Detroit' => {
			exemplarCity => q#ডেট্ৰোইট#,
		},
		'America/Dominica' => {
			exemplarCity => q#ডমিনিকা#,
		},
		'America/Edmonton' => {
			exemplarCity => q#এডমণ্টন#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ইৰুনেপে#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#এল ছেলভেড’ৰ#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#ফ’ৰ্ট নেলছন#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ফোৰ্টালেজা#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#গ্লেচ উপসাগৰ#,
		},
		'America/Godthab' => {
			exemplarCity => q#নুক#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#গুছ উপসাগৰ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#গ্ৰেণ্ড টাৰ্ক#,
		},
		'America/Grenada' => {
			exemplarCity => q#গ্ৰেনাডা#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#গুৱাডেলুপ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#গুৱাটেমালা#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#গায়াকুইল#,
		},
		'America/Guyana' => {
			exemplarCity => q#গায়ানা#,
		},
		'America/Halifax' => {
			exemplarCity => q#হেলিফেক্স#,
		},
		'America/Havana' => {
			exemplarCity => q#হাভানা#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#হাৰ্মোছিল্লো#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#নক্স, ইণ্ডিয়ানা#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#মাৰেংগো, ইণ্ডিয়ানা#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#পিটাৰ্ছবাৰ্গ, ইণ্ডিয়ানা#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#টেল চিটী, ইণ্ডিয়ানা#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ভেভে, ইণ্ডিয়ানা#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ভিনচেনেছ, ইণ্ডিয়ানা#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#উইনামেক, ইণ্ডিয়ানা#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ইণ্ডিয়ানাপ’লিছ#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ইনুভিক#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ইকালুইট#,
		},
		'America/Jamaica' => {
			exemplarCity => q#জামাইকা#,
		},
		'America/Jujuy' => {
			exemplarCity => q#জুজুই#,
		},
		'America/Juneau' => {
			exemplarCity => q#জুনেউ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#মণ্টিচেলো, কেণ্টুকী#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ক্ৰালেণ্ডিজিক#,
		},
		'America/La_Paz' => {
			exemplarCity => q#লা পাজ#,
		},
		'America/Lima' => {
			exemplarCity => q#লিমা#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#লছ এঞ্জেলছ্#,
		},
		'America/Louisville' => {
			exemplarCity => q#লুইছভিলে#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ল’ৱাৰ প্ৰিন্সেছ কোৱাৰ্টাৰ#,
		},
		'America/Maceio' => {
			exemplarCity => q#মেচিও#,
		},
		'America/Managua' => {
			exemplarCity => q#মানাগুৱা#,
		},
		'America/Manaus' => {
			exemplarCity => q#মানাছ#,
		},
		'America/Marigot' => {
			exemplarCity => q#মেৰিগোট#,
		},
		'America/Martinique' => {
			exemplarCity => q#মাৰ্টিনিক#,
		},
		'America/Matamoros' => {
			exemplarCity => q#মাটামোৰোছ#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#মাজাট্‌লান#,
		},
		'America/Mendoza' => {
			exemplarCity => q#মেণ্ডোজা#,
		},
		'America/Menominee' => {
			exemplarCity => q#মেনোমিনী#,
		},
		'America/Merida' => {
			exemplarCity => q#মেৰিডা#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#মেটলাকাট্‌লা#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#মেক্সিকো চিটী#,
		},
		'America/Miquelon' => {
			exemplarCity => q#মিকিউৱেলন#,
		},
		'America/Moncton' => {
			exemplarCity => q#মন্‌কটন#,
		},
		'America/Monterrey' => {
			exemplarCity => q#মণ্টেৰেৰী#,
		},
		'America/Montevideo' => {
			exemplarCity => q#মণ্টেভিডিঅ’#,
		},
		'America/Montserrat' => {
			exemplarCity => q#মণ্টছেৰাট#,
		},
		'America/Nassau' => {
			exemplarCity => q#নাছাউ#,
		},
		'America/New_York' => {
			exemplarCity => q#নিউ ইয়ৰ্ক#,
		},
		'America/Nipigon' => {
			exemplarCity => q#নিপিগন#,
		},
		'America/Nome' => {
			exemplarCity => q#নোম#,
		},
		'America/Noronha' => {
			exemplarCity => q#নোৰোন্‌হা#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#বেউলাহ, উত্তৰ ডাকোটা#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#চেণ্টাৰ, উত্তৰ ডাকোটা#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#নিউ ছালেম, উত্তৰ ডাকোটা#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#অ’জিনাগা#,
		},
		'America/Panama' => {
			exemplarCity => q#পানামা#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#পাংনিৰ্টুংগ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#পাৰামাৰিবো#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ফিনিক্স#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#প’ৰ্ট-ঔ-প্ৰিন্স#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#প’ৰ্ট অৱ স্পেইন#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#পোৰ্টো ভেল্‌হো#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#পুৱেৰ্টো ৰিকো#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#পুণ্টা এৰিনাছ#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#ৰেইনী নদী#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#ৰেংকিন ইনলেট#,
		},
		'America/Recife' => {
			exemplarCity => q#ৰেচাইফ#,
		},
		'America/Regina' => {
			exemplarCity => q#ৰেজিনা#,
		},
		'America/Resolute' => {
			exemplarCity => q#ৰিজ’লিউট#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ৰিঅ’ ব্ৰাংকো#,
		},
		'America/Santarem' => {
			exemplarCity => q#ছেণ্টাৰেম#,
		},
		'America/Santiago' => {
			exemplarCity => q#ছেণ্টিয়াগো#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#ছাণ্টো ডোমিংগো#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ছাও পাউলো#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ইটোকোৰ্টোৰমিট#,
		},
		'America/Sitka' => {
			exemplarCity => q#ছিট্‌‌কা#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#ছেইণ্ট বাৰ্থলেমে#,
		},
		'America/St_Johns' => {
			exemplarCity => q#ছেইণ্ট জনচ্#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#ছেইণ্ট কিটছ#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#ছেইণ্ট লুচিয়া#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#ছেইণ্ট থমাছ#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#ছেইণ্ট ভিনচেণ্ট#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#ছুইফ্ট কাৰেণ্ট#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#টেগুচিগাল্পা#,
		},
		'America/Thule' => {
			exemplarCity => q#থ্যুলে#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#থাণ্ডাৰ উপসাগৰ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#তিজুৱানা#,
		},
		'America/Toronto' => {
			exemplarCity => q#ট’ৰ’ণ্টো#,
		},
		'America/Tortola' => {
			exemplarCity => q#টোৰ্টোলা#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ভেনকুভেৰ#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#হোৱাইটহৰ্চ#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ৱিনিপেগ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#য়াকুটাট#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#য়েল্লোনাইফ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#উত্তৰ আমেৰিকাৰ কেন্দ্ৰীয় ডেলাইট সময়#,
				'generic' => q#উত্তৰ আমেৰিকাৰ কেন্দ্ৰীয় সময়#,
				'standard' => q#উত্তৰ আমেৰিকাৰ কেন্দ্ৰীয় মান সময়#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#উত্তৰ আমেৰিকাৰ প্ৰাচ্য ডেলাইট সময়#,
				'generic' => q#উত্তৰ আমেৰিকাৰ প্ৰাচ্য সময়#,
				'standard' => q#উত্তৰ আমেৰিকাৰ প্ৰাচ্য মান সময়#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#উত্তৰ আমেৰিকাৰ পৰ্ব্বতীয় ডেলাইট সময়#,
				'generic' => q#উত্তৰ আমেৰিকাৰ পৰ্ব্বতীয় সময়#,
				'standard' => q#উত্তৰ আমেৰিকাৰ পৰ্ব্বতীয় মান সময়#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#উত্তৰ আমেৰিকাৰ ডেলাইট সময়#,
				'generic' => q#উত্তৰ আমেৰিকাৰ প্ৰশান্ত সময়#,
				'standard' => q#উত্তৰ আমেৰিকাৰ প্ৰশান্ত মান সময়#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#কেছী#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ডেভিছ#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ডুমোণ্ট ডি আৰ্ভিলৰ#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#মেক্‌কুৱেৰী#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#মাউছন#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#মেকমুৰ্ডু#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#পামৰ#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#ৰোথেৰা#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#স্বোৱা#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ট্ৰোল#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ভোষ্টক#,
		},
		'Apia' => {
			long => {
				'daylight' => q#আপিয়াৰ ডেলাইট সময়#,
				'generic' => q#আপিয়াৰ সময়#,
				'standard' => q#আপিয়াৰ মান সময়#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#আৰবীয় ডেলাইট সময়#,
				'generic' => q#আৰবীয় সময়#,
				'standard' => q#আৰবীয় মান সময়#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#লংগেইৰবায়েন#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#আৰ্জেণ্টিনাৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#আৰ্জেণ্টিনাৰ সময়#,
				'standard' => q#আৰ্জেণ্টিনাৰ মান সময়#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#পাশ্চাত্য আৰ্জেণ্টিনাৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#পাশ্চাত্য আৰ্জেণ্টিনাৰ সময়#,
				'standard' => q#পাশ্চাত্য আৰ্জেণ্টিনাৰ মান সময়#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#আৰ্মেনিয়াৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#আৰ্মেনিয়াৰ সময়#,
				'standard' => q#আৰ্মেনিয়াৰ মান সময়#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#আদেন#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#আলমাটি#,
		},
		'Asia/Amman' => {
			exemplarCity => q#আম্মান#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#আনাডিৰ#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#এক্যোট্যাও#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#এক্যোটব#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#আশ্ব্গা‌বাট#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#এটৰাউ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#বাগদাদ#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#বাহৰেইন#,
		},
		'Asia/Baku' => {
			exemplarCity => q#বাকু#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#বেংকক#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#বাৰ্নুল#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#বেইৰুট#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#বিশ্ব্‌কেক#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ব্ৰুনেই#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#কলকাতা#,
		},
		'Asia/Chita' => {
			exemplarCity => q#চিটা#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#কোইবাল্ছন#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#কলম্বো#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ডামাস্কাছ#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ঢাকা#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ডিলি#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ডুবাই#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ডুছানবে#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#ফামাগুস্তা#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#গাজা#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#হেব্ৰোন#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#হং কং#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#হোভ্‌ড#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ইৰ্কুত্স্ক#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#জাকাৰ্টা#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#জায়াপুৰা#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#জেৰুজালেম#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#কাবুল#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#কামচত্কা#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#কৰাচী#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#কাঠমাণ্ডু#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#খাণ্ডিগা#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ক্ৰাছনোয়াৰ্স্ক#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#কুৱালালুমপুৰ#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#কুচিং#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#কুৱেইট#,
		},
		'Asia/Macau' => {
			exemplarCity => q#মাকাও#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#মাগাদান#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#মাকাছাৰ#,
		},
		'Asia/Manila' => {
			exemplarCity => q#মানিলা#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#মুস্কেট#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#নিকোছিয়া#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#নোভোকুজনেত্স্ক#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#নোভোছিবিৰ্স্ক#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ওমস্ক#,
		},
		'Asia/Oral' => {
			exemplarCity => q#অ’ৰেল#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#নোম পেন্‌হ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#পোণ্টিয়াংক#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#প্যংয়াং#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#কাটাৰ#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#ক’ষ্টেনী#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#কেজিলোৰ্ডা#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#য়াঙোন#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ৰিয়াধ#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#হো চি মিন চিটী#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ছাখালিন#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#ছামাৰকাণ্ড#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#ছিউল#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#ছাংহাই#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#ছিংগাপুৰ#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#স্ৰেডনিকোলিমস্ক#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#টাইপেই#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#তাছকেণ্ট#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#টিবলিচি#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#তেহৰান#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#থিম্ফু#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#টকিঅ’#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#তোম্‌স্ক#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#উলানবাটাৰ#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#উৰুম্‌কি#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#উষ্ট-নেৰা#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ভিয়েণ্টিয়ান#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ভ্লাডিভোষ্টক#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#য়াকুত্স্ক#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#য়েকাটেৰিণবাৰ্গ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#য়েৰেভান#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#আটলাণ্টিক ডেলাইট সময়#,
				'generic' => q#আটলাণ্টিক সময়#,
				'standard' => q#আটলাণ্টিক মান সময়#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#এজোৰেছ#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#বাৰ্মুডা#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#কেনেৰী#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#কেপ ভাৰ্দে#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ফাৰো#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#মাডেৰা#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ৰেইকজাভিক#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#দক্ষিণ জৰ্জিয়া#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#ছেইণ্ট হেলেনা#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#ষ্টেন্‌লী#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#এডিলেইড#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ব্ৰিচবেন#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ব্ৰোকেন হিল#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ক্যুৰি#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ডাৰউইন#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ইউক্লা#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#হোবাৰ্ট#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#লিণ্ডমান#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#লৰ্ড হাও#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#মেলব’ৰ্ণ#,
		},
		'Australia/Perth' => {
			exemplarCity => q#পাৰ্থ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#চিডনী#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় ডেলাইট সময়#,
				'generic' => q#মধ্য অষ্ট্ৰেলিয়াৰ সময়#,
				'standard' => q#অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় মান সময়#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় পাশ্চাত্য ডেলাইট সময়#,
				'generic' => q#অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় পাশ্চাত্য সময়#,
				'standard' => q#অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় পাশ্চাত্য মান সময়#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#অষ্ট্ৰেলিয়াৰ প্ৰাচ্য ডেলাইট সময়#,
				'generic' => q#প্ৰাচ্য অষ্ট্ৰেলিয়াৰ সময়#,
				'standard' => q#অষ্ট্ৰেলিয়াৰ প্ৰাচ্য মান সময়#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#অষ্ট্ৰেলিয়াৰ পাশ্চাত্য ডেলাইট সময়#,
				'generic' => q#পাশ্চাত্য অষ্ট্ৰেলিয়াৰ সময়#,
				'standard' => q#অষ্ট্ৰেলিয়াৰ পাশ্চাত্য মান সময়#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#আজেৰবাইজানৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#আজেৰবাইজানৰ সময়#,
				'standard' => q#আজেৰবাইজানৰ মান সময়#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#আজোৰেছৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#আজোৰেছ সময়#,
				'standard' => q#আজোৰেছৰ মান সময়#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#বাংলাদেশৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#বাংলাদেশৰ সময়#,
				'standard' => q#বাংলাদেশৰ মান সময়#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#ভুটানৰ সময়#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#বলিভিয়াৰ সময়#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ব্ৰাজিলিয়াৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#ব্ৰাজিলিয়াৰ সময়#,
				'standard' => q#ব্ৰাজিলিয়াৰ মান সময়#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#ব্ৰুনেই ডাৰুছালেমৰ সময়#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#কেপ ভাৰ্দেৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#কেপ ভাৰ্দেৰ সময়#,
				'standard' => q#কেপ ভাৰ্দেৰ মান সময়#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#চামোৰোৰ মান সময়#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#চাথামৰ ডেলাইট সময়#,
				'generic' => q#চাথামৰ সময়#,
				'standard' => q#চাথামৰ মান সময়#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#চিলিৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#চিলিৰ সময়#,
				'standard' => q#চিলিৰ মান সময়#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#চীনৰ ডেলাইট সময়#,
				'generic' => q#চীনৰ সময়#,
				'standard' => q#চীনৰ মান সময়#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#কোইবাল্ছনৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#কোইবাল্ছনৰ সময়#,
				'standard' => q#কোইবাল্ছনৰ মান সময়#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#খ্ৰীষ্টমাছ দ্বীপৰ সময়#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#কোকোছ দ্বীপপুঞ্জৰ সময়#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#কলম্বিয়াৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#কলম্বিয়াৰ সময়#,
				'standard' => q#কলম্বিয়াৰ মান সময়#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#কুক দ্বীপপুঞ্জৰ অৰ্ধ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#কুক দ্বীপপুঞ্জৰ সময়#,
				'standard' => q#কুক দ্বীপপুঞ্জৰ মান সময়#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#কিউবাৰ ডেলাইট সময়#,
				'generic' => q#কিউবাৰ সময়#,
				'standard' => q#কিউবাৰ মান সময়#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ডেভিছৰ সময়#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ডুমোণ্ট-ডি আৰ্ভিলৰ সময়#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#পূব তিমোৰৰ সময়#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ইষ্টাৰ দ্বীপৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#ইষ্টাৰ দ্বীপৰ সময়#,
				'standard' => q#ইষ্টাৰ দ্বীপৰ মান সময়#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ইকুৱেডৰৰ সময়#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#সমন্বিত সাৰ্বজনীন সময়#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#অজ্ঞাত চহৰ#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#আমষ্টাৰডাম#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#আন্দোৰা#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#আষ্ট্ৰাখান#,
		},
		'Europe/Athens' => {
			exemplarCity => q#এথেন্স#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#বেলগ্ৰেড#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#বাৰ্লিন#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ব্ৰাটিছলাভা#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ব্ৰুছলেছ#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#বুচাৰেষ্ট#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#বুডাপেষ্ট#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#বুছিনজেন#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#চিছিনাউ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#কোপেনহাগেন#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ডাবলিন#,
			long => {
				'daylight' => q#আইৰিচ মান সময়#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#জিব্ৰাল্টৰ#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#গোৰেনচি#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#হেলছিংকি#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#আইল অফ মেন#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ইস্তানবুল#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#জাৰ্চি#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#কালিনিনগ্ৰাড#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#কিভ#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#কিৰোভ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#লিছবন#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ল্যুবেলজানা#,
		},
		'Europe/London' => {
			exemplarCity => q#লণ্ডন#,
			long => {
				'daylight' => q#ব্ৰিটিছ গ্ৰীষ্মকালীন সময়#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#লাক্সেমবাৰ্গ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#মাদ্ৰিদ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#মাল্টা#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#মাৰিয়াহেম#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#মিংস্ক#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#মোনাকো#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#মস্কো#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ওস্লো#,
		},
		'Europe/Paris' => {
			exemplarCity => q#পেৰিছ#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#পোডগোৰিকা#,
		},
		'Europe/Prague' => {
			exemplarCity => q#প্ৰাগ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ৰিগা#,
		},
		'Europe/Rome' => {
			exemplarCity => q#ৰোম#,
		},
		'Europe/Samara' => {
			exemplarCity => q#ছামাৰা#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#চান মাৰিনো#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#ছাৰাজেভো#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#ছাৰাটোভ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#ছিম্ফেৰোপোল#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#স্কোপ্জে#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#ছোফিয়া#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#ষ্টকহোম#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#তেলিন#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#টাইৰেন#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#উল্যানোভ্‌স্ক#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#উজ্গোৰোড#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ভাদুজ#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ভেটিকান#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ভিয়েনা#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ভিলনিয়াছ#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ভোল্গোগ্ৰাড#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ৱাৰছাও#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#জাগ্ৰেব#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#জাপোৰোজাই#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#জুৰিখ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#মধ্য ইউৰোপীয় গ্ৰীষ্মকালীন সময়#,
				'generic' => q#মধ্য ইউৰোপীয় সময়#,
				'standard' => q#মধ্য ইউৰোপীয় মান সময়#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#প্ৰাচ্য ইউৰোপীয় গ্ৰীষ্মকালীন সময়#,
				'generic' => q#প্ৰাচ্য ইউৰোপীয় সময়#,
				'standard' => q#প্ৰাচ্য ইউৰোপীয় মান সময়#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#অগ্ৰ-প্ৰাচ্য ইউৰোপীয় সময়#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#পাশ্চাত্য ইউৰোপীয় গ্ৰীষ্মকালীন সময়#,
				'generic' => q#পাশ্চাত্য ইউৰোপীয় সময়#,
				'standard' => q#পাশ্চাত্য ইউৰোপীয় মান সময়#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#ফকলেণ্ড দ্বীপপুঞ্জৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#ফকলেণ্ড দ্বীপপুঞ্জৰ সময়#,
				'standard' => q#ফকলেণ্ড দ্বীপপুঞ্জৰ মান সময়#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#ফিজিৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#ফিজিৰ সময়#,
				'standard' => q#ফিজিৰ মান সময়#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#ফ্ৰান্স গয়ানাৰ সময়#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#দক্ষিণ ফ্ৰান্স আৰু এণ্টাৰ্কটিক সময়#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#গ্ৰীণউইচ মান সময়#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#গালাপাগোছৰ সময়#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#গেম্বিয়াৰ সময়#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#জৰ্জিয়াৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#জৰ্জিয়াৰ সময়#,
				'standard' => q#জৰ্জিয়াৰ মান সময়#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#গিলবাৰ্ট দ্বীপপুঞ্জৰ সময়#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#পূব গ্ৰীণলেণ্ডৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#পূব গ্ৰীণলেণ্ডৰ সময়#,
				'standard' => q#পূব গ্ৰীণলেণ্ডৰ মান সময়#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#পশ্চিম গ্ৰীণলেণ্ডৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#পশ্চিম গ্ৰীণলেণ্ডৰ সময়#,
				'standard' => q#পশ্চিম গ্ৰীণলেণ্ডৰ মান সময়#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#উপসাগৰীয় মান সময়#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#গায়ানাৰ সময়#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#হাৱাই-এলিউশ্বনৰ ডেলাইট সময়#,
				'generic' => q#হাৱাই-এলিউশ্বনৰ সময়#,
				'standard' => q#হাৱাই-এলিউশ্বনৰ মান সময়#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#হং কঙৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#হং কঙৰ সময়#,
				'standard' => q#হং কঙৰ মান সময়#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#হোভ্‌ডৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#হোভ্‌ডৰ সময়#,
				'standard' => q#হোভ্‌ডৰ মান সময়#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ভাৰতীয় মান সময়#,
			},
			short => {
				'standard' => q#ভা. স.#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#এণ্টানানাৰিভো#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#চাগোছ#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#খ্ৰীষ্টমাছ#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#কোকোছ#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#কোমোৰো#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#কেৰগুলেন#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#মাহে#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#মালদ্বীপ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#মৰিছাছ#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#মায়োট্টে#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ৰিইউনিয়ন#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#ভাৰত মহাসাগৰীয় সময়#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ইণ্ডোচাইনাৰ সময়#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#মধ্য ইণ্ডোনেচিয়াৰ সময়#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#প্ৰাচ্য ইণ্ডোনেচিয়াৰ সময়#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#পাশ্চাত্য ইণ্ডোনেচিয়াৰ সময়#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ইৰানৰ ডেলাইট সময়#,
				'generic' => q#ইৰানৰ সময়#,
				'standard' => q#ইৰানৰ মান সময়#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ইৰ্কুটস্কৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#ইৰ্কুটস্কৰ সময়#,
				'standard' => q#ইৰ্কুটস্কৰ মান সময়#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#ইজৰাইলৰ ডেলাইট সময়#,
				'generic' => q#ইজৰাইলৰ সময়#,
				'standard' => q#ইজৰাইলৰ মান সময়#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#জাপানৰ ডেলাইট সময়#,
				'generic' => q#জাপানৰ সময়#,
				'standard' => q#জাপানৰ মান সময়#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#পূব কাজাখস্তানৰ সময়#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#পশ্চিম কাজাখস্তানৰ সময়#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#কোৰিয়াৰ ডেলাইট সময়#,
				'generic' => q#কোৰিয়াৰ সময়#,
				'standard' => q#কোৰিয়াৰ মান সময়#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#কোছৰায়ে সময়#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#ক্ৰাছনোয়াৰ্স্ক গ্ৰীষ্মকালীন সময়#,
				'generic' => q#ক্ৰাছনোয়াৰ্স্কৰ সময়#,
				'standard' => q#ক্ৰাছনোয়াৰ্স্কৰ মান সময়#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#কিৰ্গিজস্তানৰ সময়#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#লাইন দ্বীপপুঞ্জৰ সময়#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#লৰ্ড হাওৰ ডেলাইট সময়#,
				'generic' => q#লৰ্ড হাওৰ সময়#,
				'standard' => q#লৰ্ড হাওৰ মান সময়#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#মেক্‌কুৱেৰী দ্বীপৰ সময়#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#মাগাদানৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#মাগাদানৰ সময়#,
				'standard' => q#মাগাদানৰ মান সময়#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#মালয়েচিয়াৰ সময়#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#মালদ্বীপৰ সময়#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#মাৰ্কছেছৰ সময়#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#মাৰ্শ্বাল দ্বীপপুঞ্জৰ সময়#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#মৰিছাছৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#মৰিছাছৰ সময়#,
				'standard' => q#মৰিছাছৰ মান সময়#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#মাউছনৰ সময়#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#উত্তৰ-পশ্চিম মেক্সিকোৰ ডেলাইট সময়#,
				'generic' => q#উত্তৰ-পশ্চিম মেক্সিকোৰ সময়#,
				'standard' => q#উত্তৰ-পশ্চিম মেক্সিকোৰ মান সময়#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#মেক্সিকোৰ প্ৰশান্ত ডেলাইট সময়#,
				'generic' => q#মেক্সিকোৰ প্ৰশান্ত সময়#,
				'standard' => q#মেক্সিকোৰ প্ৰশান্ত মান সময়#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#উলানবাটাৰৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#উলানবাটাৰৰ সময়#,
				'standard' => q#উলানবাটাৰৰ মান সময়#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#মস্কোৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#মস্কোৰ সময়#,
				'standard' => q#মস্কোৰ মান সময়#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#ম্যানমাৰৰ সময়#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#নাউৰুৰ সময়#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#নেপালৰ সময়#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#নিউ কেলিডোনিয়াৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#নিউ কেলিডোনিয়াৰ সময়#,
				'standard' => q#নিউ কেলিডোনিয়াৰ মান সময়#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#নিউজিলেণ্ডৰ ডেলাইট সময়#,
				'generic' => q#নিউজিলেণ্ডৰ সময়#,
				'standard' => q#নিউজিলেণ্ডৰ মান সময়#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#নিউফাউণ্ডলেণ্ডৰ ডেলাইট সময়#,
				'generic' => q#নিউফাউণ্ডলেণ্ডৰ সময়#,
				'standard' => q#নিউফাউণ্ডলেণ্ডৰ মান সময়#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#নিয়ুৰ সময়#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#ন’ৰফ’ক দ্বীপৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#ন’ৰফ’ক দ্বীপৰ সময়#,
				'standard' => q#ন’ৰফ’ক দ্বীপৰ মান্য সময়#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#ফাৰ্নাণ্ডো ডে নোৰোন্‌হাৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#ফাৰ্নাণ্ডো ডে নোৰোন্‌হাৰ সময়#,
				'standard' => q#ফাৰ্নাণ্ডো ডে নোৰোন্‌হাৰ মান সময়#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#নভোছিবিৰ্স্কৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#নভোছিবিৰ্স্কৰ সময়#,
				'standard' => q#নভোছিবিৰ্স্কৰ মান সময়#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ওমস্কৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#ওমস্কৰ সময়#,
				'standard' => q#ওমস্কৰ মান সময়#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#আপিয়া#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#অকলেণ্ড#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#বোগেইনভিলে#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#চাথাম#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ইষ্টাৰ#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#এফেট#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#এণ্ডৰবাৰী#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ফাকাওফো#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ফিজি#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ফুনাফুটি#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#গালাপাগোছ#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#গেম্বিয়াৰ#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#গুৱাডলকানাল#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#গুৱাম#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#জনষ্টন#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#কিৰিটিমাটি#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#কোছৰায়ে#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#কোৱাজালিন#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#মাজুৰো#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#মাৰ্কছাছ#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#মিডৱে#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#নাৰু#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#নিয়ো#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#ন’ৰফ’ক#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#নউমিয়া#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#পাগো পাগো#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#পালাউ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#পিটকেইৰ্ণ#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#পোনপেই#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#প’ৰ্ট মোৰেছ্‌বি#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#ৰাৰোটোঙ্গা#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#ছাইপান#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#তাহিতি#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#তাৰাৱা#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#টংগাটাপু#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#চ্চুক#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ৱেক#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ৱালিছ#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#পাকিস্তানৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#পাকিস্তানৰ সময়#,
				'standard' => q#পাকিস্তানৰ মান সময়#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#পালাউৰ সময়#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#পাপুৱা নিউ গিনিৰ সময়#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#পাৰাগুৱেৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#পাৰাগুৱেৰ সময়#,
				'standard' => q#পাৰাগুৱেৰ মান সময়#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#পেৰুৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#পেৰুৰ সময়#,
				'standard' => q#পেৰুৰ মান সময়#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#ফিলিপাইনৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#ফিলিপাইনৰ সময়#,
				'standard' => q#ফিলিপাইনৰ মান সময়#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#ফিনিক্স দ্বীপপুঞ্জৰ সময়#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#ছেইণ্ট পিয়েৰে আৰু মিকিউৱেলনৰ ডেলাইট সময়#,
				'generic' => q#ছেইণ্ট পিয়েৰে আৰু মিকিউৱেলনৰ সময়#,
				'standard' => q#ছেইণ্ট পিয়েৰে আৰু মিকিউৱেলনৰ মান সময়#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#পিটকেইৰ্ণৰ সময়#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#পোনাপেৰ সময়#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#প্যংয়াংৰ সময়#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#ৰিইউনিয়নৰ সময়#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#ৰোথেৰাৰ সময়#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#ছাখালিনৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#ছাখালিনৰ সময়#,
				'standard' => q#ছাখালিনৰ মান সময়#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#ছামোৱাৰ ডেলাইট সময়#,
				'generic' => q#ছামোৱাৰ সময়#,
				'standard' => q#ছামোৱাৰ মান সময়#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#ছিচিলিছৰ সময়#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#ছিংগাপুৰৰ মান সময়#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#চোলোমোন দ্বীপপুঞ্জৰ সময়#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#দক্ষিণ জৰ্জিয়াৰ সময়#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#ছুৰিনামৰ সময়#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#স্বোৱা সময়#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#তাহিতিৰ সময়#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#টাইপেইৰ ডেলাইট সময়#,
				'generic' => q#টাইপেইৰ সময়#,
				'standard' => q#টাইপেইৰ মান সময়#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#তাজিকিস্তানৰ সময়#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#টোকেলাউৰ সময়#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#টংগাৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#টংগাৰ সময়#,
				'standard' => q#টংগাৰ মান সময়#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#চ্চুকৰ সময়#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#তুৰ্কমেনিস্তানৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#তুৰ্কমেনিস্তানৰ সময়#,
				'standard' => q#তুৰ্কমেনিস্তানৰ মান সময়#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#টুভালাউৰ সময়#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#উৰুগুৱেৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#উৰুগুৱেৰ সময়#,
				'standard' => q#উৰুগুৱেৰ মান সময়#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#উজবেকিস্তানৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#উজবেকিস্তানৰ সময়#,
				'standard' => q#উজবেকিস্তানৰ মান সময়#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#ভানাটুৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#ভানাটুৰ সময়#,
				'standard' => q#ভানাটুৰ মান সময়#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#ভেনিজুৱেলাৰ সময়#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ভ্লাডিভোষ্টোকৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#ভ্লাডিভোষ্টোকৰ সময়#,
				'standard' => q#ভ্লাডিভোষ্টোকৰ মান সময়#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#ভোল্গোগ্ৰাডৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#ভোল্গোগ্ৰাডৰ সময়#,
				'standard' => q#ভোল্গোগ্ৰাডৰ মান সময়#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ভোষ্টকৰ সময়#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ৱেক দ্বীপৰ সময়#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#ৱালিছ আৰু ফুটুনাৰ সময়#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#য়াকুত্স্কৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#য়াকুত্স্কৰ সময়#,
				'standard' => q#য়াকুত্স্কৰ মান সময়#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#য়েকাটেৰিণবাৰ্গৰ গ্ৰীষ্মকালীন সময়#,
				'generic' => q#য়েকাটেৰিণবাৰ্গৰ সময়#,
				'standard' => q#য়েকাটেৰিণবাৰ্গৰ মান সময়#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#য়ুকোন সময়#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
