#!/usr/local/bin/perl
# Test Geo::Ellipsoid range
use Test::More tests => 1220;
use Test::Number::Delta relative => 1e-6;
use Geo::Ellipsoid;
use blib;
use strict;
use warnings;

my $e_meter = Geo::Ellipsoid->new(units=>'degrees');
my $e_kilo = Geo::Ellipsoid->new(units=>'degrees',distance=>'kilo');
my $e_mile = Geo::Ellipsoid->new(units=>'degrees',distance=>'mile');
my $e_foot = Geo::Ellipsoid->new(units=>'degrees',distance=>'foot');
my $e_nm = Geo::Ellipsoid->new(units=>'degrees',distance=>'nm');
my( $r1,$r2,$r3,$r4,$r5);

$r1 = $e_meter->range(-88.000000,1.000000,-88.000000,1.000000);
$r2 = $e_kilo->range(-88.000000,1.000000,-88.000000,1.000000);
$r3 = $e_mile->range(-88.000000,1.000000,-88.000000,1.000000);
$r4 = $e_foot->range(-88.000000,1.000000,-88.000000,1.000000);
$r5 = $e_nm->range(-88.000000,1.000000,-88.000000,1.000000);
delta_within( $r1, 0, 1.0 );
delta_within( $r2, 0, 1.0 );
delta_within( $r3, 0, 1.0 );
delta_within( $r4, 0, 1.0 );
delta_within( $r5, 0, 1.0 );

$r1 = $e_meter->range(-88.000000,1.000000,-88.000000,90.000000);
$r2 = $e_kilo->range(-88.000000,1.000000,-88.000000,90.000000);
$r3 = $e_mile->range(-88.000000,1.000000,-88.000000,90.000000);
$r4 = $e_foot->range(-88.000000,1.000000,-88.000000,90.000000);
$r5 = $e_nm->range(-88.000000,1.000000,-88.000000,90.000000);
delta_within( $r1, 313115.736403696, 1.0 );
delta_within( $r2, 313.115736403696, 1.0 );
delta_within( $r3, 194.561098437435, 1.0 );
delta_within( $r4, 1027282.59974966, 1.0 );
delta_within( $r5, 169.068972140224, 1.0 );

$r1 = $e_meter->range(-88.000000,1.000000,-88.000000,179.000000);
$r2 = $e_kilo->range(-88.000000,1.000000,-88.000000,179.000000);
$r3 = $e_mile->range(-88.000000,1.000000,-88.000000,179.000000);
$r4 = $e_foot->range(-88.000000,1.000000,-88.000000,179.000000);
$r5 = $e_nm->range(-88.000000,1.000000,-88.000000,179.000000);
delta_within( $r1, 446706.01076052, 1.0 );
delta_within( $r2, 446.70601076052, 1.0 );
delta_within( $r3, 277.570246485848, 1.0 );
delta_within( $r4, 1465570.90144528, 1.0 );
delta_within( $r5, 241.201949654708, 1.0 );

$r1 = $e_meter->range(-88.000000,1.000000,-88.000000,268.000000);
$r2 = $e_kilo->range(-88.000000,1.000000,-88.000000,268.000000);
$r3 = $e_mile->range(-88.000000,1.000000,-88.000000,268.000000);
$r4 = $e_foot->range(-88.000000,1.000000,-88.000000,268.000000);
$r5 = $e_nm->range(-88.000000,1.000000,-88.000000,268.000000);
delta_within( $r1, 324047.278966276, 1.0 );
delta_within( $r2, 324.047278966276, 1.0 );
delta_within( $r3, 201.353644072539, 1.0 );
delta_within( $r4, 1063147.240703, 1.0 );
delta_within( $r5, 174.971532919155, 1.0 );

$r1 = $e_meter->range(-88.000000,1.000000,0.000000,1.000000);
$r2 = $e_kilo->range(-88.000000,1.000000,0.000000,1.000000);
$r3 = $e_mile->range(-88.000000,1.000000,0.000000,1.000000);
$r4 = $e_foot->range(-88.000000,1.000000,0.000000,1.000000);
$r5 = $e_nm->range(-88.000000,1.000000,0.000000,1.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(-88.000000,1.000000,0.000000,90.000000);
$r2 = $e_kilo->range(-88.000000,1.000000,0.000000,90.000000);
$r3 = $e_mile->range(-88.000000,1.000000,0.000000,90.000000);
$r4 = $e_foot->range(-88.000000,1.000000,0.000000,90.000000);
$r5 = $e_nm->range(-88.000000,1.000000,0.000000,90.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(-88.000000,1.000000,0.000000,179.000000);
$r2 = $e_kilo->range(-88.000000,1.000000,0.000000,179.000000);
$r3 = $e_mile->range(-88.000000,1.000000,0.000000,179.000000);
$r4 = $e_foot->range(-88.000000,1.000000,0.000000,179.000000);
$r5 = $e_nm->range(-88.000000,1.000000,0.000000,179.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234002, 1.0 );

$r1 = $e_meter->range(-88.000000,1.000000,0.000000,268.000000);
$r2 = $e_kilo->range(-88.000000,1.000000,0.000000,268.000000);
$r3 = $e_mile->range(-88.000000,1.000000,0.000000,268.000000);
$r4 = $e_foot->range(-88.000000,1.000000,0.000000,268.000000);
$r5 = $e_nm->range(-88.000000,1.000000,0.000000,268.000000);
delta_within( $r1, 10013675.0566307, 1.0 );
delta_within( $r2, 10013.6750566307, 1.0 );
delta_within( $r3, 6222.20920861587, 1.0 );
delta_within( $r4, 32853264.6214918, 1.0 );
delta_within( $r5, 5406.95197442262, 1.0 );

$r1 = $e_meter->range(-88.000000,1.000000,88.000000,1.000000);
$r2 = $e_kilo->range(-88.000000,1.000000,88.000000,1.000000);
$r3 = $e_mile->range(-88.000000,1.000000,88.000000,1.000000);
$r4 = $e_foot->range(-88.000000,1.000000,88.000000,1.000000);
$r5 = $e_nm->range(-88.000000,1.000000,88.000000,1.000000);
delta_within( $r1, 19557157.3743612, 1.0 );
delta_within( $r2, 19557.1573743612, 1.0 );
delta_within( $r3, 12152.25419448, 1.0 );
delta_within( $r4, 64163902.1468542, 1.0 );
delta_within( $r5, 10560.0201805406, 1.0 );

$r1 = $e_meter->range(-88.000000,1.000000,88.000000,90.000000);
$r2 = $e_kilo->range(-88.000000,1.000000,88.000000,90.000000);
$r3 = $e_mile->range(-88.000000,1.000000,88.000000,90.000000);
$r4 = $e_foot->range(-88.000000,1.000000,88.000000,90.000000);
$r5 = $e_nm->range(-88.000000,1.000000,88.000000,90.000000);
delta_within( $r1, 19685321.6740635, 1.0 );
delta_within( $r2, 19685.3216740635, 1.0 );
delta_within( $r3, 12231.8917981883, 1.0 );
delta_within( $r4, 64584388.6944341, 1.0 );
delta_within( $r5, 10629.223366125, 1.0 );

$r1 = $e_meter->range(-88.000000,1.000000,88.000000,179.000000);
$r2 = $e_kilo->range(-88.000000,1.000000,88.000000,179.000000);
$r3 = $e_mile->range(-88.000000,1.000000,88.000000,179.000000);
$r4 = $e_foot->range(-88.000000,1.000000,88.000000,179.000000);
$r5 = $e_nm->range(-88.000000,1.000000,88.000000,179.000000);
delta_within( $r1, 19996176.9000454, 1.0 );
delta_within( $r2, 19996.1769000454, 1.0 );
delta_within( $r3, 12425.0482805698, 1.0 );
delta_within( $r4, 65604254.9214087, 1.0 );
delta_within( $r5, 10797.0717602837, 1.0 );

$r1 = $e_meter->range(-88.000000,1.000000,88.000000,268.000000);
$r2 = $e_kilo->range(-88.000000,1.000000,88.000000,268.000000);
$r3 = $e_mile->range(-88.000000,1.000000,88.000000,268.000000);
$r4 = $e_foot->range(-88.000000,1.000000,88.000000,268.000000);
$r5 = $e_nm->range(-88.000000,1.000000,88.000000,268.000000);
delta_within( $r1, 19696447.0104273, 1.0 );
delta_within( $r2, 19696.4470104273, 1.0 );
delta_within( $r3, 12238.8047617087, 1.0 );
delta_within( $r4, 64620889.1418219, 1.0 );
delta_within( $r5, 10635.2305671854, 1.0 );

$r1 = $e_meter->range(-88.000000,90.000000,-88.000000,1.000000);
$r2 = $e_kilo->range(-88.000000,90.000000,-88.000000,1.000000);
$r3 = $e_mile->range(-88.000000,90.000000,-88.000000,1.000000);
$r4 = $e_foot->range(-88.000000,90.000000,-88.000000,1.000000);
$r5 = $e_nm->range(-88.000000,90.000000,-88.000000,1.000000);
delta_within( $r1, 313115.736403696, 1.0 );
delta_within( $r2, 313.115736403696, 1.0 );
delta_within( $r3, 194.561098437435, 1.0 );
delta_within( $r4, 1027282.59974966, 1.0 );
delta_within( $r5, 169.068972140224, 1.0 );

$r1 = $e_meter->range(-88.000000,90.000000,-88.000000,90.000000);
$r2 = $e_kilo->range(-88.000000,90.000000,-88.000000,90.000000);
$r3 = $e_mile->range(-88.000000,90.000000,-88.000000,90.000000);
$r4 = $e_foot->range(-88.000000,90.000000,-88.000000,90.000000);
$r5 = $e_nm->range(-88.000000,90.000000,-88.000000,90.000000);
delta_within( $r1, 0, 1.0 );
delta_within( $r2, 0, 1.0 );
delta_within( $r3, 0, 1.0 );
delta_within( $r4, 0, 1.0 );
delta_within( $r5, 0, 1.0 );

$r1 = $e_meter->range(-88.000000,90.000000,-88.000000,179.000000);
$r2 = $e_kilo->range(-88.000000,90.000000,-88.000000,179.000000);
$r3 = $e_mile->range(-88.000000,90.000000,-88.000000,179.000000);
$r4 = $e_foot->range(-88.000000,90.000000,-88.000000,179.000000);
$r5 = $e_nm->range(-88.000000,90.000000,-88.000000,179.000000);
delta_within( $r1, 313115.736403696, 1.0 );
delta_within( $r2, 313.115736403696, 1.0 );
delta_within( $r3, 194.561098437435, 1.0 );
delta_within( $r4, 1027282.59974966, 1.0 );
delta_within( $r5, 169.068972140225, 1.0 );

$r1 = $e_meter->range(-88.000000,90.000000,-88.000000,268.000000);
$r2 = $e_kilo->range(-88.000000,90.000000,-88.000000,268.000000);
$r3 = $e_mile->range(-88.000000,90.000000,-88.000000,268.000000);
$r4 = $e_foot->range(-88.000000,90.000000,-88.000000,268.000000);
$r5 = $e_nm->range(-88.000000,90.000000,-88.000000,268.000000);
delta_within( $r1, 446706.01076052, 1.0 );
delta_within( $r2, 446.70601076052, 1.0 );
delta_within( $r3, 277.570246485848, 1.0 );
delta_within( $r4, 1465570.90144528, 1.0 );
delta_within( $r5, 241.201949654708, 1.0 );

$r1 = $e_meter->range(-88.000000,90.000000,0.000000,1.000000);
$r2 = $e_kilo->range(-88.000000,90.000000,0.000000,1.000000);
$r3 = $e_mile->range(-88.000000,90.000000,0.000000,1.000000);
$r4 = $e_foot->range(-88.000000,90.000000,0.000000,1.000000);
$r5 = $e_nm->range(-88.000000,90.000000,0.000000,1.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(-88.000000,90.000000,0.000000,90.000000);
$r2 = $e_kilo->range(-88.000000,90.000000,0.000000,90.000000);
$r3 = $e_mile->range(-88.000000,90.000000,0.000000,90.000000);
$r4 = $e_foot->range(-88.000000,90.000000,0.000000,90.000000);
$r5 = $e_nm->range(-88.000000,90.000000,0.000000,90.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(-88.000000,90.000000,0.000000,179.000000);
$r2 = $e_kilo->range(-88.000000,90.000000,0.000000,179.000000);
$r3 = $e_mile->range(-88.000000,90.000000,0.000000,179.000000);
$r4 = $e_foot->range(-88.000000,90.000000,0.000000,179.000000);
$r5 = $e_nm->range(-88.000000,90.000000,0.000000,179.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(-88.000000,90.000000,0.000000,268.000000);
$r2 = $e_kilo->range(-88.000000,90.000000,0.000000,268.000000);
$r3 = $e_mile->range(-88.000000,90.000000,0.000000,268.000000);
$r4 = $e_foot->range(-88.000000,90.000000,0.000000,268.000000);
$r5 = $e_nm->range(-88.000000,90.000000,0.000000,268.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234002, 1.0 );

$r1 = $e_meter->range(-88.000000,90.000000,88.000000,1.000000);
$r2 = $e_kilo->range(-88.000000,90.000000,88.000000,1.000000);
$r3 = $e_mile->range(-88.000000,90.000000,88.000000,1.000000);
$r4 = $e_foot->range(-88.000000,90.000000,88.000000,1.000000);
$r5 = $e_nm->range(-88.000000,90.000000,88.000000,1.000000);
delta_within( $r1, 19685321.6740635, 1.0 );
delta_within( $r2, 19685.3216740635, 1.0 );
delta_within( $r3, 12231.8917981883, 1.0 );
delta_within( $r4, 64584388.6944341, 1.0 );
delta_within( $r5, 10629.223366125, 1.0 );

$r1 = $e_meter->range(-88.000000,90.000000,88.000000,90.000000);
$r2 = $e_kilo->range(-88.000000,90.000000,88.000000,90.000000);
$r3 = $e_mile->range(-88.000000,90.000000,88.000000,90.000000);
$r4 = $e_foot->range(-88.000000,90.000000,88.000000,90.000000);
$r5 = $e_nm->range(-88.000000,90.000000,88.000000,90.000000);
delta_within( $r1, 19557157.3743612, 1.0 );
delta_within( $r2, 19557.1573743612, 1.0 );
delta_within( $r3, 12152.25419448, 1.0 );
delta_within( $r4, 64163902.1468542, 1.0 );
delta_within( $r5, 10560.0201805406, 1.0 );

$r1 = $e_meter->range(-88.000000,90.000000,88.000000,179.000000);
$r2 = $e_kilo->range(-88.000000,90.000000,88.000000,179.000000);
$r3 = $e_mile->range(-88.000000,90.000000,88.000000,179.000000);
$r4 = $e_foot->range(-88.000000,90.000000,88.000000,179.000000);
$r5 = $e_nm->range(-88.000000,90.000000,88.000000,179.000000);
delta_within( $r1, 19685321.6740635, 1.0 );
delta_within( $r2, 19685.3216740635, 1.0 );
delta_within( $r3, 12231.8917981883, 1.0 );
delta_within( $r4, 64584388.6944341, 1.0 );
delta_within( $r5, 10629.223366125, 1.0 );

$r1 = $e_meter->range(-88.000000,90.000000,88.000000,268.000000);
$r2 = $e_kilo->range(-88.000000,90.000000,88.000000,268.000000);
$r3 = $e_mile->range(-88.000000,90.000000,88.000000,268.000000);
$r4 = $e_foot->range(-88.000000,90.000000,88.000000,268.000000);
$r5 = $e_nm->range(-88.000000,90.000000,88.000000,268.000000);
delta_within( $r1, 19996176.9000454, 1.0 );
delta_within( $r2, 19996.1769000454, 1.0 );
delta_within( $r3, 12425.0482805698, 1.0 );
delta_within( $r4, 65604254.9214087, 1.0 );
delta_within( $r5, 10797.0717602837, 1.0 );

$r1 = $e_meter->range(-88.000000,179.000000,-88.000000,1.000000);
$r2 = $e_kilo->range(-88.000000,179.000000,-88.000000,1.000000);
$r3 = $e_mile->range(-88.000000,179.000000,-88.000000,1.000000);
$r4 = $e_foot->range(-88.000000,179.000000,-88.000000,1.000000);
$r5 = $e_nm->range(-88.000000,179.000000,-88.000000,1.000000);
delta_within( $r1, 446706.01076052, 1.0 );
delta_within( $r2, 446.70601076052, 1.0 );
delta_within( $r3, 277.570246485848, 1.0 );
delta_within( $r4, 1465570.90144528, 1.0 );
delta_within( $r5, 241.201949654708, 1.0 );

$r1 = $e_meter->range(-88.000000,179.000000,-88.000000,90.000000);
$r2 = $e_kilo->range(-88.000000,179.000000,-88.000000,90.000000);
$r3 = $e_mile->range(-88.000000,179.000000,-88.000000,90.000000);
$r4 = $e_foot->range(-88.000000,179.000000,-88.000000,90.000000);
$r5 = $e_nm->range(-88.000000,179.000000,-88.000000,90.000000);
delta_within( $r1, 313115.736403696, 1.0 );
delta_within( $r2, 313.115736403696, 1.0 );
delta_within( $r3, 194.561098437435, 1.0 );
delta_within( $r4, 1027282.59974966, 1.0 );
delta_within( $r5, 169.068972140225, 1.0 );

$r1 = $e_meter->range(-88.000000,179.000000,-88.000000,179.000000);
$r2 = $e_kilo->range(-88.000000,179.000000,-88.000000,179.000000);
$r3 = $e_mile->range(-88.000000,179.000000,-88.000000,179.000000);
$r4 = $e_foot->range(-88.000000,179.000000,-88.000000,179.000000);
$r5 = $e_nm->range(-88.000000,179.000000,-88.000000,179.000000);
delta_within( $r1, 0, 1.0 );
delta_within( $r2, 0, 1.0 );
delta_within( $r3, 0, 1.0 );
delta_within( $r4, 0, 1.0 );
delta_within( $r5, 0, 1.0 );

$r1 = $e_meter->range(-88.000000,179.000000,-88.000000,268.000000);
$r2 = $e_kilo->range(-88.000000,179.000000,-88.000000,268.000000);
$r3 = $e_mile->range(-88.000000,179.000000,-88.000000,268.000000);
$r4 = $e_foot->range(-88.000000,179.000000,-88.000000,268.000000);
$r5 = $e_nm->range(-88.000000,179.000000,-88.000000,268.000000);
delta_within( $r1, 313115.736403696, 1.0 );
delta_within( $r2, 313.115736403696, 1.0 );
delta_within( $r3, 194.561098437435, 1.0 );
delta_within( $r4, 1027282.59974966, 1.0 );
delta_within( $r5, 169.068972140225, 1.0 );

$r1 = $e_meter->range(-88.000000,179.000000,0.000000,1.000000);
$r2 = $e_kilo->range(-88.000000,179.000000,0.000000,1.000000);
$r3 = $e_mile->range(-88.000000,179.000000,0.000000,1.000000);
$r4 = $e_foot->range(-88.000000,179.000000,0.000000,1.000000);
$r5 = $e_nm->range(-88.000000,179.000000,0.000000,1.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234002, 1.0 );

$r1 = $e_meter->range(-88.000000,179.000000,0.000000,90.000000);
$r2 = $e_kilo->range(-88.000000,179.000000,0.000000,90.000000);
$r3 = $e_mile->range(-88.000000,179.000000,0.000000,90.000000);
$r4 = $e_foot->range(-88.000000,179.000000,0.000000,90.000000);
$r5 = $e_nm->range(-88.000000,179.000000,0.000000,90.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(-88.000000,179.000000,0.000000,179.000000);
$r2 = $e_kilo->range(-88.000000,179.000000,0.000000,179.000000);
$r3 = $e_mile->range(-88.000000,179.000000,0.000000,179.000000);
$r4 = $e_foot->range(-88.000000,179.000000,0.000000,179.000000);
$r5 = $e_nm->range(-88.000000,179.000000,0.000000,179.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(-88.000000,179.000000,0.000000,268.000000);
$r2 = $e_kilo->range(-88.000000,179.000000,0.000000,268.000000);
$r3 = $e_mile->range(-88.000000,179.000000,0.000000,268.000000);
$r4 = $e_foot->range(-88.000000,179.000000,0.000000,268.000000);
$r5 = $e_nm->range(-88.000000,179.000000,0.000000,268.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(-88.000000,179.000000,88.000000,1.000000);
$r2 = $e_kilo->range(-88.000000,179.000000,88.000000,1.000000);
$r3 = $e_mile->range(-88.000000,179.000000,88.000000,1.000000);
$r4 = $e_foot->range(-88.000000,179.000000,88.000000,1.000000);
$r5 = $e_nm->range(-88.000000,179.000000,88.000000,1.000000);
delta_within( $r1, 19996176.9000454, 1.0 );
delta_within( $r2, 19996.1769000454, 1.0 );
delta_within( $r3, 12425.0482805698, 1.0 );
delta_within( $r4, 65604254.9214087, 1.0 );
delta_within( $r5, 10797.0717602837, 1.0 );

$r1 = $e_meter->range(-88.000000,179.000000,88.000000,90.000000);
$r2 = $e_kilo->range(-88.000000,179.000000,88.000000,90.000000);
$r3 = $e_mile->range(-88.000000,179.000000,88.000000,90.000000);
$r4 = $e_foot->range(-88.000000,179.000000,88.000000,90.000000);
$r5 = $e_nm->range(-88.000000,179.000000,88.000000,90.000000);
delta_within( $r1, 19685321.6740635, 1.0 );
delta_within( $r2, 19685.3216740635, 1.0 );
delta_within( $r3, 12231.8917981883, 1.0 );
delta_within( $r4, 64584388.6944341, 1.0 );
delta_within( $r5, 10629.223366125, 1.0 );

$r1 = $e_meter->range(-88.000000,179.000000,88.000000,179.000000);
$r2 = $e_kilo->range(-88.000000,179.000000,88.000000,179.000000);
$r3 = $e_mile->range(-88.000000,179.000000,88.000000,179.000000);
$r4 = $e_foot->range(-88.000000,179.000000,88.000000,179.000000);
$r5 = $e_nm->range(-88.000000,179.000000,88.000000,179.000000);
delta_within( $r1, 19557157.3743612, 1.0 );
delta_within( $r2, 19557.1573743612, 1.0 );
delta_within( $r3, 12152.25419448, 1.0 );
delta_within( $r4, 64163902.1468542, 1.0 );
delta_within( $r5, 10560.0201805406, 1.0 );

$r1 = $e_meter->range(-88.000000,179.000000,88.000000,268.000000);
$r2 = $e_kilo->range(-88.000000,179.000000,88.000000,268.000000);
$r3 = $e_mile->range(-88.000000,179.000000,88.000000,268.000000);
$r4 = $e_foot->range(-88.000000,179.000000,88.000000,268.000000);
$r5 = $e_nm->range(-88.000000,179.000000,88.000000,268.000000);
delta_within( $r1, 19685321.6740635, 1.0 );
delta_within( $r2, 19685.3216740635, 1.0 );
delta_within( $r3, 12231.8917981883, 1.0 );
delta_within( $r4, 64584388.6944341, 1.0 );
delta_within( $r5, 10629.223366125, 1.0 );

$r1 = $e_meter->range(-88.000000,268.000000,-88.000000,1.000000);
$r2 = $e_kilo->range(-88.000000,268.000000,-88.000000,1.000000);
$r3 = $e_mile->range(-88.000000,268.000000,-88.000000,1.000000);
$r4 = $e_foot->range(-88.000000,268.000000,-88.000000,1.000000);
$r5 = $e_nm->range(-88.000000,268.000000,-88.000000,1.000000);
delta_within( $r1, 324047.278966276, 1.0 );
delta_within( $r2, 324.047278966276, 1.0 );
delta_within( $r3, 201.353644072539, 1.0 );
delta_within( $r4, 1063147.240703, 1.0 );
delta_within( $r5, 174.971532919155, 1.0 );

$r1 = $e_meter->range(-88.000000,268.000000,-88.000000,90.000000);
$r2 = $e_kilo->range(-88.000000,268.000000,-88.000000,90.000000);
$r3 = $e_mile->range(-88.000000,268.000000,-88.000000,90.000000);
$r4 = $e_foot->range(-88.000000,268.000000,-88.000000,90.000000);
$r5 = $e_nm->range(-88.000000,268.000000,-88.000000,90.000000);
delta_within( $r1, 446706.01076052, 1.0 );
delta_within( $r2, 446.70601076052, 1.0 );
delta_within( $r3, 277.570246485848, 1.0 );
delta_within( $r4, 1465570.90144528, 1.0 );
delta_within( $r5, 241.201949654708, 1.0 );

$r1 = $e_meter->range(-88.000000,268.000000,-88.000000,179.000000);
$r2 = $e_kilo->range(-88.000000,268.000000,-88.000000,179.000000);
$r3 = $e_mile->range(-88.000000,268.000000,-88.000000,179.000000);
$r4 = $e_foot->range(-88.000000,268.000000,-88.000000,179.000000);
$r5 = $e_nm->range(-88.000000,268.000000,-88.000000,179.000000);
delta_within( $r1, 313115.736403696, 1.0 );
delta_within( $r2, 313.115736403696, 1.0 );
delta_within( $r3, 194.561098437435, 1.0 );
delta_within( $r4, 1027282.59974966, 1.0 );
delta_within( $r5, 169.068972140225, 1.0 );

$r1 = $e_meter->range(-88.000000,268.000000,-88.000000,268.000000);
$r2 = $e_kilo->range(-88.000000,268.000000,-88.000000,268.000000);
$r3 = $e_mile->range(-88.000000,268.000000,-88.000000,268.000000);
$r4 = $e_foot->range(-88.000000,268.000000,-88.000000,268.000000);
$r5 = $e_nm->range(-88.000000,268.000000,-88.000000,268.000000);
delta_within( $r1, 0, 1.0 );
delta_within( $r2, 0, 1.0 );
delta_within( $r3, 0, 1.0 );
delta_within( $r4, 0, 1.0 );
delta_within( $r5, 0, 1.0 );

$r1 = $e_meter->range(-88.000000,268.000000,0.000000,1.000000);
$r2 = $e_kilo->range(-88.000000,268.000000,0.000000,1.000000);
$r3 = $e_mile->range(-88.000000,268.000000,0.000000,1.000000);
$r4 = $e_foot->range(-88.000000,268.000000,0.000000,1.000000);
$r5 = $e_nm->range(-88.000000,268.000000,0.000000,1.000000);
delta_within( $r1, 10013675.0566307, 1.0 );
delta_within( $r2, 10013.6750566307, 1.0 );
delta_within( $r3, 6222.20920861587, 1.0 );
delta_within( $r4, 32853264.6214918, 1.0 );
delta_within( $r5, 5406.95197442262, 1.0 );

$r1 = $e_meter->range(-88.000000,268.000000,0.000000,90.000000);
$r2 = $e_kilo->range(-88.000000,268.000000,0.000000,90.000000);
$r3 = $e_mile->range(-88.000000,268.000000,0.000000,90.000000);
$r4 = $e_foot->range(-88.000000,268.000000,0.000000,90.000000);
$r5 = $e_nm->range(-88.000000,268.000000,0.000000,90.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234002, 1.0 );

$r1 = $e_meter->range(-88.000000,268.000000,0.000000,179.000000);
$r2 = $e_kilo->range(-88.000000,268.000000,0.000000,179.000000);
$r3 = $e_mile->range(-88.000000,268.000000,0.000000,179.000000);
$r4 = $e_foot->range(-88.000000,268.000000,0.000000,179.000000);
$r5 = $e_nm->range(-88.000000,268.000000,0.000000,179.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(-88.000000,268.000000,0.000000,268.000000);
$r2 = $e_kilo->range(-88.000000,268.000000,0.000000,268.000000);
$r3 = $e_mile->range(-88.000000,268.000000,0.000000,268.000000);
$r4 = $e_foot->range(-88.000000,268.000000,0.000000,268.000000);
$r5 = $e_nm->range(-88.000000,268.000000,0.000000,268.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(-88.000000,268.000000,88.000000,1.000000);
$r2 = $e_kilo->range(-88.000000,268.000000,88.000000,1.000000);
$r3 = $e_mile->range(-88.000000,268.000000,88.000000,1.000000);
$r4 = $e_foot->range(-88.000000,268.000000,88.000000,1.000000);
$r5 = $e_nm->range(-88.000000,268.000000,88.000000,1.000000);
delta_within( $r1, 19696447.0104273, 1.0 );
delta_within( $r2, 19696.4470104273, 1.0 );
delta_within( $r3, 12238.8047617087, 1.0 );
delta_within( $r4, 64620889.1418219, 1.0 );
delta_within( $r5, 10635.2305671854, 1.0 );

$r1 = $e_meter->range(-88.000000,268.000000,88.000000,90.000000);
$r2 = $e_kilo->range(-88.000000,268.000000,88.000000,90.000000);
$r3 = $e_mile->range(-88.000000,268.000000,88.000000,90.000000);
$r4 = $e_foot->range(-88.000000,268.000000,88.000000,90.000000);
$r5 = $e_nm->range(-88.000000,268.000000,88.000000,90.000000);
delta_within( $r1, 19996176.9000454, 1.0 );
delta_within( $r2, 19996.1769000454, 1.0 );
delta_within( $r3, 12425.0482805698, 1.0 );
delta_within( $r4, 65604254.9214087, 1.0 );
delta_within( $r5, 10797.0717602837, 1.0 );

$r1 = $e_meter->range(-88.000000,268.000000,88.000000,179.000000);
$r2 = $e_kilo->range(-88.000000,268.000000,88.000000,179.000000);
$r3 = $e_mile->range(-88.000000,268.000000,88.000000,179.000000);
$r4 = $e_foot->range(-88.000000,268.000000,88.000000,179.000000);
$r5 = $e_nm->range(-88.000000,268.000000,88.000000,179.000000);
delta_within( $r1, 19685321.6740635, 1.0 );
delta_within( $r2, 19685.3216740635, 1.0 );
delta_within( $r3, 12231.8917981883, 1.0 );
delta_within( $r4, 64584388.6944341, 1.0 );
delta_within( $r5, 10629.223366125, 1.0 );

$r1 = $e_meter->range(-88.000000,268.000000,88.000000,268.000000);
$r2 = $e_kilo->range(-88.000000,268.000000,88.000000,268.000000);
$r3 = $e_mile->range(-88.000000,268.000000,88.000000,268.000000);
$r4 = $e_foot->range(-88.000000,268.000000,88.000000,268.000000);
$r5 = $e_nm->range(-88.000000,268.000000,88.000000,268.000000);
delta_within( $r1, 19557157.3743612, 1.0 );
delta_within( $r2, 19557.1573743612, 1.0 );
delta_within( $r3, 12152.25419448, 1.0 );
delta_within( $r4, 64163902.1468542, 1.0 );
delta_within( $r5, 10560.0201805406, 1.0 );

$r1 = $e_meter->range(0.000000,1.000000,-88.000000,1.000000);
$r2 = $e_kilo->range(0.000000,1.000000,-88.000000,1.000000);
$r3 = $e_mile->range(0.000000,1.000000,-88.000000,1.000000);
$r4 = $e_foot->range(0.000000,1.000000,-88.000000,1.000000);
$r5 = $e_nm->range(0.000000,1.000000,-88.000000,1.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(0.000000,1.000000,-88.000000,90.000000);
$r2 = $e_kilo->range(0.000000,1.000000,-88.000000,90.000000);
$r3 = $e_mile->range(0.000000,1.000000,-88.000000,90.000000);
$r4 = $e_foot->range(0.000000,1.000000,-88.000000,90.000000);
$r5 = $e_nm->range(0.000000,1.000000,-88.000000,90.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(0.000000,1.000000,-88.000000,179.000000);
$r2 = $e_kilo->range(0.000000,1.000000,-88.000000,179.000000);
$r3 = $e_mile->range(0.000000,1.000000,-88.000000,179.000000);
$r4 = $e_foot->range(0.000000,1.000000,-88.000000,179.000000);
$r5 = $e_nm->range(0.000000,1.000000,-88.000000,179.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234002, 1.0 );

$r1 = $e_meter->range(0.000000,1.000000,-88.000000,268.000000);
$r2 = $e_kilo->range(0.000000,1.000000,-88.000000,268.000000);
$r3 = $e_mile->range(0.000000,1.000000,-88.000000,268.000000);
$r4 = $e_foot->range(0.000000,1.000000,-88.000000,268.000000);
$r5 = $e_nm->range(0.000000,1.000000,-88.000000,268.000000);
delta_within( $r1, 10013675.0566307, 1.0 );
delta_within( $r2, 10013.6750566307, 1.0 );
delta_within( $r3, 6222.20920861587, 1.0 );
delta_within( $r4, 32853264.6214918, 1.0 );
delta_within( $r5, 5406.95197442262, 1.0 );

$r1 = $e_meter->range(0.000000,1.000000,0.000000,1.000000);
$r2 = $e_kilo->range(0.000000,1.000000,0.000000,1.000000);
$r3 = $e_mile->range(0.000000,1.000000,0.000000,1.000000);
$r4 = $e_foot->range(0.000000,1.000000,0.000000,1.000000);
$r5 = $e_nm->range(0.000000,1.000000,0.000000,1.000000);
delta_within( $r1, 0, 1.0 );
delta_within( $r2, 0, 1.0 );
delta_within( $r3, 0, 1.0 );
delta_within( $r4, 0, 1.0 );
delta_within( $r5, 0, 1.0 );

$r1 = $e_meter->range(0.000000,1.000000,0.000000,90.000000);
$r2 = $e_kilo->range(0.000000,1.000000,0.000000,90.000000);
$r3 = $e_mile->range(0.000000,1.000000,0.000000,90.000000);
$r4 = $e_foot->range(0.000000,1.000000,0.000000,90.000000);
$r5 = $e_nm->range(0.000000,1.000000,0.000000,90.000000);
delta_within( $r1, 9907434.68060135, 1.0 );
delta_within( $r2, 9907.43468060135, 1.0 );
delta_within( $r3, 6156.19449949877, 1.0 );
delta_within( $r4, 32504706.9573535, 1.0 );
delta_within( $r5, 5349.58676058388, 1.0 );

$r1 = $e_meter->range(0.000000,1.000000,0.000000,179.000000);
$r2 = $e_kilo->range(0.000000,1.000000,0.000000,179.000000);
$r3 = $e_mile->range(0.000000,1.000000,0.000000,179.000000);
$r4 = $e_foot->range(0.000000,1.000000,0.000000,179.000000);
$r5 = $e_nm->range(0.000000,1.000000,0.000000,179.000000);
delta_within( $r1, 19814869.3612027, 1.0 );
delta_within( $r2, 19814.8693612027, 1.0 );
delta_within( $r3, 12312.3889989975, 1.0 );
delta_within( $r4, 65009413.914707, 1.0 );
delta_within( $r5, 10699.1735211678, 1.0 );

$r1 = $e_meter->range(0.000000,1.000000,0.000000,268.000000);
$r2 = $e_kilo->range(0.000000,1.000000,0.000000,268.000000);
$r3 = $e_mile->range(0.000000,1.000000,0.000000,268.000000);
$r4 = $e_foot->range(0.000000,1.000000,0.000000,268.000000);
$r5 = $e_nm->range(0.000000,1.000000,0.000000,268.000000);
delta_within( $r1, 10352712.6437744, 1.0 );
delta_within( $r2, 10352.7126437744, 1.0 );
delta_within( $r3, 6432.87739835265, 1.0 );
delta_within( $r4, 33965592.663302, 1.0 );
delta_within( $r5, 5590.0176262281, 1.0 );

$r1 = $e_meter->range(0.000000,1.000000,88.000000,1.000000);
$r2 = $e_kilo->range(0.000000,1.000000,88.000000,1.000000);
$r3 = $e_mile->range(0.000000,1.000000,88.000000,1.000000);
$r4 = $e_foot->range(0.000000,1.000000,88.000000,1.000000);
$r5 = $e_nm->range(0.000000,1.000000,88.000000,1.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(0.000000,1.000000,88.000000,90.000000);
$r2 = $e_kilo->range(0.000000,1.000000,88.000000,90.000000);
$r3 = $e_mile->range(0.000000,1.000000,88.000000,90.000000);
$r4 = $e_foot->range(0.000000,1.000000,88.000000,90.000000);
$r5 = $e_nm->range(0.000000,1.000000,88.000000,90.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(0.000000,1.000000,88.000000,179.000000);
$r2 = $e_kilo->range(0.000000,1.000000,88.000000,179.000000);
$r3 = $e_mile->range(0.000000,1.000000,88.000000,179.000000);
$r4 = $e_foot->range(0.000000,1.000000,88.000000,179.000000);
$r5 = $e_nm->range(0.000000,1.000000,88.000000,179.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234003, 1.0 );

$r1 = $e_meter->range(0.000000,1.000000,88.000000,268.000000);
$r2 = $e_kilo->range(0.000000,1.000000,88.000000,268.000000);
$r3 = $e_mile->range(0.000000,1.000000,88.000000,268.000000);
$r4 = $e_foot->range(0.000000,1.000000,88.000000,268.000000);
$r5 = $e_nm->range(0.000000,1.000000,88.000000,268.000000);
delta_within( $r1, 10013675.0566307, 1.0 );
delta_within( $r2, 10013.6750566307, 1.0 );
delta_within( $r3, 6222.20920861587, 1.0 );
delta_within( $r4, 32853264.6214918, 1.0 );
delta_within( $r5, 5406.95197442262, 1.0 );

$r1 = $e_meter->range(0.000000,90.000000,-88.000000,1.000000);
$r2 = $e_kilo->range(0.000000,90.000000,-88.000000,1.000000);
$r3 = $e_mile->range(0.000000,90.000000,-88.000000,1.000000);
$r4 = $e_foot->range(0.000000,90.000000,-88.000000,1.000000);
$r5 = $e_nm->range(0.000000,90.000000,-88.000000,1.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(0.000000,90.000000,-88.000000,90.000000);
$r2 = $e_kilo->range(0.000000,90.000000,-88.000000,90.000000);
$r3 = $e_mile->range(0.000000,90.000000,-88.000000,90.000000);
$r4 = $e_foot->range(0.000000,90.000000,-88.000000,90.000000);
$r5 = $e_nm->range(0.000000,90.000000,-88.000000,90.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(0.000000,90.000000,-88.000000,179.000000);
$r2 = $e_kilo->range(0.000000,90.000000,-88.000000,179.000000);
$r3 = $e_mile->range(0.000000,90.000000,-88.000000,179.000000);
$r4 = $e_foot->range(0.000000,90.000000,-88.000000,179.000000);
$r5 = $e_nm->range(0.000000,90.000000,-88.000000,179.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(0.000000,90.000000,-88.000000,268.000000);
$r2 = $e_kilo->range(0.000000,90.000000,-88.000000,268.000000);
$r3 = $e_mile->range(0.000000,90.000000,-88.000000,268.000000);
$r4 = $e_foot->range(0.000000,90.000000,-88.000000,268.000000);
$r5 = $e_nm->range(0.000000,90.000000,-88.000000,268.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234002, 1.0 );

$r1 = $e_meter->range(0.000000,90.000000,0.000000,1.000000);
$r2 = $e_kilo->range(0.000000,90.000000,0.000000,1.000000);
$r3 = $e_mile->range(0.000000,90.000000,0.000000,1.000000);
$r4 = $e_foot->range(0.000000,90.000000,0.000000,1.000000);
$r5 = $e_nm->range(0.000000,90.000000,0.000000,1.000000);
delta_within( $r1, 9907434.68060135, 1.0 );
delta_within( $r2, 9907.43468060135, 1.0 );
delta_within( $r3, 6156.19449949877, 1.0 );
delta_within( $r4, 32504706.9573535, 1.0 );
delta_within( $r5, 5349.58676058388, 1.0 );

$r1 = $e_meter->range(0.000000,90.000000,0.000000,90.000000);
$r2 = $e_kilo->range(0.000000,90.000000,0.000000,90.000000);
$r3 = $e_mile->range(0.000000,90.000000,0.000000,90.000000);
$r4 = $e_foot->range(0.000000,90.000000,0.000000,90.000000);
$r5 = $e_nm->range(0.000000,90.000000,0.000000,90.000000);
delta_within( $r1, 0, 1.0 );
delta_within( $r2, 0, 1.0 );
delta_within( $r3, 0, 1.0 );
delta_within( $r4, 0, 1.0 );
delta_within( $r5, 0, 1.0 );

$r1 = $e_meter->range(0.000000,90.000000,0.000000,179.000000);
$r2 = $e_kilo->range(0.000000,90.000000,0.000000,179.000000);
$r3 = $e_mile->range(0.000000,90.000000,0.000000,179.000000);
$r4 = $e_foot->range(0.000000,90.000000,0.000000,179.000000);
$r5 = $e_nm->range(0.000000,90.000000,0.000000,179.000000);
delta_within( $r1, 9907434.68060135, 1.0 );
delta_within( $r2, 9907.43468060135, 1.0 );
delta_within( $r3, 6156.19449949877, 1.0 );
delta_within( $r4, 32504706.9573535, 1.0 );
delta_within( $r5, 5349.58676058388, 1.0 );

$r1 = $e_meter->range(0.000000,90.000000,0.000000,268.000000);
$r2 = $e_kilo->range(0.000000,90.000000,0.000000,268.000000);
$r3 = $e_mile->range(0.000000,90.000000,0.000000,268.000000);
$r4 = $e_foot->range(0.000000,90.000000,0.000000,268.000000);
$r5 = $e_nm->range(0.000000,90.000000,0.000000,268.000000);
delta_within( $r1, 19814869.3612027, 1.0 );
delta_within( $r2, 19814.8693612027, 1.0 );
delta_within( $r3, 12312.3889989975, 1.0 );
delta_within( $r4, 65009413.914707, 1.0 );
delta_within( $r5, 10699.1735211678, 1.0 );

$r1 = $e_meter->range(0.000000,90.000000,88.000000,1.000000);
$r2 = $e_kilo->range(0.000000,90.000000,88.000000,1.000000);
$r3 = $e_mile->range(0.000000,90.000000,88.000000,1.000000);
$r4 = $e_foot->range(0.000000,90.000000,88.000000,1.000000);
$r5 = $e_nm->range(0.000000,90.000000,88.000000,1.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(0.000000,90.000000,88.000000,90.000000);
$r2 = $e_kilo->range(0.000000,90.000000,88.000000,90.000000);
$r3 = $e_mile->range(0.000000,90.000000,88.000000,90.000000);
$r4 = $e_foot->range(0.000000,90.000000,88.000000,90.000000);
$r5 = $e_nm->range(0.000000,90.000000,88.000000,90.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(0.000000,90.000000,88.000000,179.000000);
$r2 = $e_kilo->range(0.000000,90.000000,88.000000,179.000000);
$r3 = $e_mile->range(0.000000,90.000000,88.000000,179.000000);
$r4 = $e_foot->range(0.000000,90.000000,88.000000,179.000000);
$r5 = $e_nm->range(0.000000,90.000000,88.000000,179.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(0.000000,90.000000,88.000000,268.000000);
$r2 = $e_kilo->range(0.000000,90.000000,88.000000,268.000000);
$r3 = $e_mile->range(0.000000,90.000000,88.000000,268.000000);
$r4 = $e_foot->range(0.000000,90.000000,88.000000,268.000000);
$r5 = $e_nm->range(0.000000,90.000000,88.000000,268.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234003, 1.0 );

$r1 = $e_meter->range(0.000000,179.000000,-88.000000,1.000000);
$r2 = $e_kilo->range(0.000000,179.000000,-88.000000,1.000000);
$r3 = $e_mile->range(0.000000,179.000000,-88.000000,1.000000);
$r4 = $e_foot->range(0.000000,179.000000,-88.000000,1.000000);
$r5 = $e_nm->range(0.000000,179.000000,-88.000000,1.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234002, 1.0 );

$r1 = $e_meter->range(0.000000,179.000000,-88.000000,90.000000);
$r2 = $e_kilo->range(0.000000,179.000000,-88.000000,90.000000);
$r3 = $e_mile->range(0.000000,179.000000,-88.000000,90.000000);
$r4 = $e_foot->range(0.000000,179.000000,-88.000000,90.000000);
$r5 = $e_nm->range(0.000000,179.000000,-88.000000,90.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(0.000000,179.000000,-88.000000,179.000000);
$r2 = $e_kilo->range(0.000000,179.000000,-88.000000,179.000000);
$r3 = $e_mile->range(0.000000,179.000000,-88.000000,179.000000);
$r4 = $e_foot->range(0.000000,179.000000,-88.000000,179.000000);
$r5 = $e_nm->range(0.000000,179.000000,-88.000000,179.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(0.000000,179.000000,-88.000000,268.000000);
$r2 = $e_kilo->range(0.000000,179.000000,-88.000000,268.000000);
$r3 = $e_mile->range(0.000000,179.000000,-88.000000,268.000000);
$r4 = $e_foot->range(0.000000,179.000000,-88.000000,268.000000);
$r5 = $e_nm->range(0.000000,179.000000,-88.000000,268.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(0.000000,179.000000,0.000000,1.000000);
$r2 = $e_kilo->range(0.000000,179.000000,0.000000,1.000000);
$r3 = $e_mile->range(0.000000,179.000000,0.000000,1.000000);
$r4 = $e_foot->range(0.000000,179.000000,0.000000,1.000000);
$r5 = $e_nm->range(0.000000,179.000000,0.000000,1.000000);
delta_within( $r1, 19814869.3612027, 1.0 );
delta_within( $r2, 19814.8693612027, 1.0 );
delta_within( $r3, 12312.3889989975, 1.0 );
delta_within( $r4, 65009413.914707, 1.0 );
delta_within( $r5, 10699.1735211678, 1.0 );

$r1 = $e_meter->range(0.000000,179.000000,0.000000,90.000000);
$r2 = $e_kilo->range(0.000000,179.000000,0.000000,90.000000);
$r3 = $e_mile->range(0.000000,179.000000,0.000000,90.000000);
$r4 = $e_foot->range(0.000000,179.000000,0.000000,90.000000);
$r5 = $e_nm->range(0.000000,179.000000,0.000000,90.000000);
delta_within( $r1, 9907434.68060135, 1.0 );
delta_within( $r2, 9907.43468060135, 1.0 );
delta_within( $r3, 6156.19449949877, 1.0 );
delta_within( $r4, 32504706.9573535, 1.0 );
delta_within( $r5, 5349.58676058388, 1.0 );

$r1 = $e_meter->range(0.000000,179.000000,0.000000,179.000000);
$r2 = $e_kilo->range(0.000000,179.000000,0.000000,179.000000);
$r3 = $e_mile->range(0.000000,179.000000,0.000000,179.000000);
$r4 = $e_foot->range(0.000000,179.000000,0.000000,179.000000);
$r5 = $e_nm->range(0.000000,179.000000,0.000000,179.000000);
delta_within( $r1, 0, 1.0 );
delta_within( $r2, 0, 1.0 );
delta_within( $r3, 0, 1.0 );
delta_within( $r4, 0, 1.0 );
delta_within( $r5, 0, 1.0 );

$r1 = $e_meter->range(0.000000,179.000000,0.000000,268.000000);
$r2 = $e_kilo->range(0.000000,179.000000,0.000000,268.000000);
$r3 = $e_mile->range(0.000000,179.000000,0.000000,268.000000);
$r4 = $e_foot->range(0.000000,179.000000,0.000000,268.000000);
$r5 = $e_nm->range(0.000000,179.000000,0.000000,268.000000);
delta_within( $r1, 9907434.68060135, 1.0 );
delta_within( $r2, 9907.43468060135, 1.0 );
delta_within( $r3, 6156.19449949877, 1.0 );
delta_within( $r4, 32504706.9573535, 1.0 );
delta_within( $r5, 5349.58676058388, 1.0 );

$r1 = $e_meter->range(0.000000,179.000000,88.000000,1.000000);
$r2 = $e_kilo->range(0.000000,179.000000,88.000000,1.000000);
$r3 = $e_mile->range(0.000000,179.000000,88.000000,1.000000);
$r4 = $e_foot->range(0.000000,179.000000,88.000000,1.000000);
$r5 = $e_nm->range(0.000000,179.000000,88.000000,1.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234003, 1.0 );

$r1 = $e_meter->range(0.000000,179.000000,88.000000,90.000000);
$r2 = $e_kilo->range(0.000000,179.000000,88.000000,90.000000);
$r3 = $e_mile->range(0.000000,179.000000,88.000000,90.000000);
$r4 = $e_foot->range(0.000000,179.000000,88.000000,90.000000);
$r5 = $e_nm->range(0.000000,179.000000,88.000000,90.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(0.000000,179.000000,88.000000,179.000000);
$r2 = $e_kilo->range(0.000000,179.000000,88.000000,179.000000);
$r3 = $e_mile->range(0.000000,179.000000,88.000000,179.000000);
$r4 = $e_foot->range(0.000000,179.000000,88.000000,179.000000);
$r5 = $e_nm->range(0.000000,179.000000,88.000000,179.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(0.000000,179.000000,88.000000,268.000000);
$r2 = $e_kilo->range(0.000000,179.000000,88.000000,268.000000);
$r3 = $e_mile->range(0.000000,179.000000,88.000000,268.000000);
$r4 = $e_foot->range(0.000000,179.000000,88.000000,268.000000);
$r5 = $e_nm->range(0.000000,179.000000,88.000000,268.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(0.000000,268.000000,-88.000000,1.000000);
$r2 = $e_kilo->range(0.000000,268.000000,-88.000000,1.000000);
$r3 = $e_mile->range(0.000000,268.000000,-88.000000,1.000000);
$r4 = $e_foot->range(0.000000,268.000000,-88.000000,1.000000);
$r5 = $e_nm->range(0.000000,268.000000,-88.000000,1.000000);
delta_within( $r1, 10013675.0566307, 1.0 );
delta_within( $r2, 10013.6750566307, 1.0 );
delta_within( $r3, 6222.20920861587, 1.0 );
delta_within( $r4, 32853264.6214918, 1.0 );
delta_within( $r5, 5406.95197442262, 1.0 );

$r1 = $e_meter->range(0.000000,268.000000,-88.000000,90.000000);
$r2 = $e_kilo->range(0.000000,268.000000,-88.000000,90.000000);
$r3 = $e_mile->range(0.000000,268.000000,-88.000000,90.000000);
$r4 = $e_foot->range(0.000000,268.000000,-88.000000,90.000000);
$r5 = $e_nm->range(0.000000,268.000000,-88.000000,90.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234002, 1.0 );

$r1 = $e_meter->range(0.000000,268.000000,-88.000000,179.000000);
$r2 = $e_kilo->range(0.000000,268.000000,-88.000000,179.000000);
$r3 = $e_mile->range(0.000000,268.000000,-88.000000,179.000000);
$r4 = $e_foot->range(0.000000,268.000000,-88.000000,179.000000);
$r5 = $e_nm->range(0.000000,268.000000,-88.000000,179.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(0.000000,268.000000,-88.000000,268.000000);
$r2 = $e_kilo->range(0.000000,268.000000,-88.000000,268.000000);
$r3 = $e_mile->range(0.000000,268.000000,-88.000000,268.000000);
$r4 = $e_foot->range(0.000000,268.000000,-88.000000,268.000000);
$r5 = $e_nm->range(0.000000,268.000000,-88.000000,268.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(0.000000,268.000000,0.000000,1.000000);
$r2 = $e_kilo->range(0.000000,268.000000,0.000000,1.000000);
$r3 = $e_mile->range(0.000000,268.000000,0.000000,1.000000);
$r4 = $e_foot->range(0.000000,268.000000,0.000000,1.000000);
$r5 = $e_nm->range(0.000000,268.000000,0.000000,1.000000);
delta_within( $r1, 10352712.6437744, 1.0 );
delta_within( $r2, 10352.7126437744, 1.0 );
delta_within( $r3, 6432.87739835265, 1.0 );
delta_within( $r4, 33965592.663302, 1.0 );
delta_within( $r5, 5590.0176262281, 1.0 );

$r1 = $e_meter->range(0.000000,268.000000,0.000000,90.000000);
$r2 = $e_kilo->range(0.000000,268.000000,0.000000,90.000000);
$r3 = $e_mile->range(0.000000,268.000000,0.000000,90.000000);
$r4 = $e_foot->range(0.000000,268.000000,0.000000,90.000000);
$r5 = $e_nm->range(0.000000,268.000000,0.000000,90.000000);
delta_within( $r1, 19814869.3612027, 1.0 );
delta_within( $r2, 19814.8693612027, 1.0 );
delta_within( $r3, 12312.3889989975, 1.0 );
delta_within( $r4, 65009413.914707, 1.0 );
delta_within( $r5, 10699.1735211678, 1.0 );

$r1 = $e_meter->range(0.000000,268.000000,0.000000,179.000000);
$r2 = $e_kilo->range(0.000000,268.000000,0.000000,179.000000);
$r3 = $e_mile->range(0.000000,268.000000,0.000000,179.000000);
$r4 = $e_foot->range(0.000000,268.000000,0.000000,179.000000);
$r5 = $e_nm->range(0.000000,268.000000,0.000000,179.000000);
delta_within( $r1, 9907434.68060135, 1.0 );
delta_within( $r2, 9907.43468060135, 1.0 );
delta_within( $r3, 6156.19449949877, 1.0 );
delta_within( $r4, 32504706.9573535, 1.0 );
delta_within( $r5, 5349.58676058388, 1.0 );

$r1 = $e_meter->range(0.000000,268.000000,0.000000,268.000000);
$r2 = $e_kilo->range(0.000000,268.000000,0.000000,268.000000);
$r3 = $e_mile->range(0.000000,268.000000,0.000000,268.000000);
$r4 = $e_foot->range(0.000000,268.000000,0.000000,268.000000);
$r5 = $e_nm->range(0.000000,268.000000,0.000000,268.000000);
delta_within( $r1, 0, 1.0 );
delta_within( $r2, 0, 1.0 );
delta_within( $r3, 0, 1.0 );
delta_within( $r4, 0, 1.0 );
delta_within( $r5, 0, 1.0 );

$r1 = $e_meter->range(0.000000,268.000000,88.000000,1.000000);
$r2 = $e_kilo->range(0.000000,268.000000,88.000000,1.000000);
$r3 = $e_mile->range(0.000000,268.000000,88.000000,1.000000);
$r4 = $e_foot->range(0.000000,268.000000,88.000000,1.000000);
$r5 = $e_nm->range(0.000000,268.000000,88.000000,1.000000);
delta_within( $r1, 10013675.0566307, 1.0 );
delta_within( $r2, 10013.6750566307, 1.0 );
delta_within( $r3, 6222.20920861587, 1.0 );
delta_within( $r4, 32853264.6214918, 1.0 );
delta_within( $r5, 5406.95197442262, 1.0 );

$r1 = $e_meter->range(0.000000,268.000000,88.000000,90.000000);
$r2 = $e_kilo->range(0.000000,268.000000,88.000000,90.000000);
$r3 = $e_mile->range(0.000000,268.000000,88.000000,90.000000);
$r4 = $e_foot->range(0.000000,268.000000,88.000000,90.000000);
$r5 = $e_nm->range(0.000000,268.000000,88.000000,90.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234003, 1.0 );

$r1 = $e_meter->range(0.000000,268.000000,88.000000,179.000000);
$r2 = $e_kilo->range(0.000000,268.000000,88.000000,179.000000);
$r3 = $e_mile->range(0.000000,268.000000,88.000000,179.000000);
$r4 = $e_foot->range(0.000000,268.000000,88.000000,179.000000);
$r5 = $e_nm->range(0.000000,268.000000,88.000000,179.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(0.000000,268.000000,88.000000,268.000000);
$r2 = $e_kilo->range(0.000000,268.000000,88.000000,268.000000);
$r3 = $e_mile->range(0.000000,268.000000,88.000000,268.000000);
$r4 = $e_foot->range(0.000000,268.000000,88.000000,268.000000);
$r5 = $e_nm->range(0.000000,268.000000,88.000000,268.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(88.000000,1.000000,-88.000000,1.000000);
$r2 = $e_kilo->range(88.000000,1.000000,-88.000000,1.000000);
$r3 = $e_mile->range(88.000000,1.000000,-88.000000,1.000000);
$r4 = $e_foot->range(88.000000,1.000000,-88.000000,1.000000);
$r5 = $e_nm->range(88.000000,1.000000,-88.000000,1.000000);
delta_within( $r1, 19557157.3743612, 1.0 );
delta_within( $r2, 19557.1573743612, 1.0 );
delta_within( $r3, 12152.25419448, 1.0 );
delta_within( $r4, 64163902.1468542, 1.0 );
delta_within( $r5, 10560.0201805406, 1.0 );

$r1 = $e_meter->range(88.000000,1.000000,-88.000000,90.000000);
$r2 = $e_kilo->range(88.000000,1.000000,-88.000000,90.000000);
$r3 = $e_mile->range(88.000000,1.000000,-88.000000,90.000000);
$r4 = $e_foot->range(88.000000,1.000000,-88.000000,90.000000);
$r5 = $e_nm->range(88.000000,1.000000,-88.000000,90.000000);
delta_within( $r1, 19685321.6740635, 1.0 );
delta_within( $r2, 19685.3216740635, 1.0 );
delta_within( $r3, 12231.8917981883, 1.0 );
delta_within( $r4, 64584388.6944341, 1.0 );
delta_within( $r5, 10629.223366125, 1.0 );

$r1 = $e_meter->range(88.000000,1.000000,-88.000000,179.000000);
$r2 = $e_kilo->range(88.000000,1.000000,-88.000000,179.000000);
$r3 = $e_mile->range(88.000000,1.000000,-88.000000,179.000000);
$r4 = $e_foot->range(88.000000,1.000000,-88.000000,179.000000);
$r5 = $e_nm->range(88.000000,1.000000,-88.000000,179.000000);
delta_within( $r1, 19996176.9000454, 1.0 );
delta_within( $r2, 19996.1769000454, 1.0 );
delta_within( $r3, 12425.0482805698, 1.0 );
delta_within( $r4, 65604254.9214087, 1.0 );
delta_within( $r5, 10797.0717602837, 1.0 );

$r1 = $e_meter->range(88.000000,1.000000,-88.000000,268.000000);
$r2 = $e_kilo->range(88.000000,1.000000,-88.000000,268.000000);
$r3 = $e_mile->range(88.000000,1.000000,-88.000000,268.000000);
$r4 = $e_foot->range(88.000000,1.000000,-88.000000,268.000000);
$r5 = $e_nm->range(88.000000,1.000000,-88.000000,268.000000);
delta_within( $r1, 19696447.0104273, 1.0 );
delta_within( $r2, 19696.4470104273, 1.0 );
delta_within( $r3, 12238.8047617087, 1.0 );
delta_within( $r4, 64620889.1418219, 1.0 );
delta_within( $r5, 10635.2305671854, 1.0 );

$r1 = $e_meter->range(88.000000,1.000000,0.000000,1.000000);
$r2 = $e_kilo->range(88.000000,1.000000,0.000000,1.000000);
$r3 = $e_mile->range(88.000000,1.000000,0.000000,1.000000);
$r4 = $e_foot->range(88.000000,1.000000,0.000000,1.000000);
$r5 = $e_nm->range(88.000000,1.000000,0.000000,1.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(88.000000,1.000000,0.000000,90.000000);
$r2 = $e_kilo->range(88.000000,1.000000,0.000000,90.000000);
$r3 = $e_mile->range(88.000000,1.000000,0.000000,90.000000);
$r4 = $e_foot->range(88.000000,1.000000,0.000000,90.000000);
$r5 = $e_nm->range(88.000000,1.000000,0.000000,90.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(88.000000,1.000000,0.000000,179.000000);
$r2 = $e_kilo->range(88.000000,1.000000,0.000000,179.000000);
$r3 = $e_mile->range(88.000000,1.000000,0.000000,179.000000);
$r4 = $e_foot->range(88.000000,1.000000,0.000000,179.000000);
$r5 = $e_nm->range(88.000000,1.000000,0.000000,179.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234003, 1.0 );

$r1 = $e_meter->range(88.000000,1.000000,0.000000,268.000000);
$r2 = $e_kilo->range(88.000000,1.000000,0.000000,268.000000);
$r3 = $e_mile->range(88.000000,1.000000,0.000000,268.000000);
$r4 = $e_foot->range(88.000000,1.000000,0.000000,268.000000);
$r5 = $e_nm->range(88.000000,1.000000,0.000000,268.000000);
delta_within( $r1, 10013675.0566307, 1.0 );
delta_within( $r2, 10013.6750566307, 1.0 );
delta_within( $r3, 6222.20920861587, 1.0 );
delta_within( $r4, 32853264.6214918, 1.0 );
delta_within( $r5, 5406.95197442262, 1.0 );

$r1 = $e_meter->range(88.000000,1.000000,88.000000,1.000000);
$r2 = $e_kilo->range(88.000000,1.000000,88.000000,1.000000);
$r3 = $e_mile->range(88.000000,1.000000,88.000000,1.000000);
$r4 = $e_foot->range(88.000000,1.000000,88.000000,1.000000);
$r5 = $e_nm->range(88.000000,1.000000,88.000000,1.000000);
delta_within( $r1, 0, 1.0 );
delta_within( $r2, 0, 1.0 );
delta_within( $r3, 0, 1.0 );
delta_within( $r4, 0, 1.0 );
delta_within( $r5, 0, 1.0 );

$r1 = $e_meter->range(88.000000,1.000000,88.000000,90.000000);
$r2 = $e_kilo->range(88.000000,1.000000,88.000000,90.000000);
$r3 = $e_mile->range(88.000000,1.000000,88.000000,90.000000);
$r4 = $e_foot->range(88.000000,1.000000,88.000000,90.000000);
$r5 = $e_nm->range(88.000000,1.000000,88.000000,90.000000);
delta_within( $r1, 313115.736403702, 1.0 );
delta_within( $r2, 313.115736403702, 1.0 );
delta_within( $r3, 194.561098437439, 1.0 );
delta_within( $r4, 1027282.59974968, 1.0 );
delta_within( $r5, 169.068972140228, 1.0 );

$r1 = $e_meter->range(88.000000,1.000000,88.000000,179.000000);
$r2 = $e_kilo->range(88.000000,1.000000,88.000000,179.000000);
$r3 = $e_mile->range(88.000000,1.000000,88.000000,179.000000);
$r4 = $e_foot->range(88.000000,1.000000,88.000000,179.000000);
$r5 = $e_nm->range(88.000000,1.000000,88.000000,179.000000);
delta_within( $r1, 446706.010760529, 1.0 );
delta_within( $r2, 446.706010760529, 1.0 );
delta_within( $r3, 277.570246485853, 1.0 );
delta_within( $r4, 1465570.9014453, 1.0 );
delta_within( $r5, 241.201949654713, 1.0 );

$r1 = $e_meter->range(88.000000,1.000000,88.000000,268.000000);
$r2 = $e_kilo->range(88.000000,1.000000,88.000000,268.000000);
$r3 = $e_mile->range(88.000000,1.000000,88.000000,268.000000);
$r4 = $e_foot->range(88.000000,1.000000,88.000000,268.000000);
$r5 = $e_nm->range(88.000000,1.000000,88.000000,268.000000);
delta_within( $r1, 324047.278966282, 1.0 );
delta_within( $r2, 324.047278966282, 1.0 );
delta_within( $r3, 201.353644072543, 1.0 );
delta_within( $r4, 1063147.24070303, 1.0 );
delta_within( $r5, 174.971532919159, 1.0 );

$r1 = $e_meter->range(88.000000,90.000000,-88.000000,1.000000);
$r2 = $e_kilo->range(88.000000,90.000000,-88.000000,1.000000);
$r3 = $e_mile->range(88.000000,90.000000,-88.000000,1.000000);
$r4 = $e_foot->range(88.000000,90.000000,-88.000000,1.000000);
$r5 = $e_nm->range(88.000000,90.000000,-88.000000,1.000000);
delta_within( $r1, 19685321.6740635, 1.0 );
delta_within( $r2, 19685.3216740635, 1.0 );
delta_within( $r3, 12231.8917981883, 1.0 );
delta_within( $r4, 64584388.6944341, 1.0 );
delta_within( $r5, 10629.223366125, 1.0 );

$r1 = $e_meter->range(88.000000,90.000000,-88.000000,90.000000);
$r2 = $e_kilo->range(88.000000,90.000000,-88.000000,90.000000);
$r3 = $e_mile->range(88.000000,90.000000,-88.000000,90.000000);
$r4 = $e_foot->range(88.000000,90.000000,-88.000000,90.000000);
$r5 = $e_nm->range(88.000000,90.000000,-88.000000,90.000000);
delta_within( $r1, 19557157.3743612, 1.0 );
delta_within( $r2, 19557.1573743612, 1.0 );
delta_within( $r3, 12152.25419448, 1.0 );
delta_within( $r4, 64163902.1468542, 1.0 );
delta_within( $r5, 10560.0201805406, 1.0 );

$r1 = $e_meter->range(88.000000,90.000000,-88.000000,179.000000);
$r2 = $e_kilo->range(88.000000,90.000000,-88.000000,179.000000);
$r3 = $e_mile->range(88.000000,90.000000,-88.000000,179.000000);
$r4 = $e_foot->range(88.000000,90.000000,-88.000000,179.000000);
$r5 = $e_nm->range(88.000000,90.000000,-88.000000,179.000000);
delta_within( $r1, 19685321.6740635, 1.0 );
delta_within( $r2, 19685.3216740635, 1.0 );
delta_within( $r3, 12231.8917981883, 1.0 );
delta_within( $r4, 64584388.6944341, 1.0 );
delta_within( $r5, 10629.223366125, 1.0 );

$r1 = $e_meter->range(88.000000,90.000000,-88.000000,268.000000);
$r2 = $e_kilo->range(88.000000,90.000000,-88.000000,268.000000);
$r3 = $e_mile->range(88.000000,90.000000,-88.000000,268.000000);
$r4 = $e_foot->range(88.000000,90.000000,-88.000000,268.000000);
$r5 = $e_nm->range(88.000000,90.000000,-88.000000,268.000000);
delta_within( $r1, 19996176.9000454, 1.0 );
delta_within( $r2, 19996.1769000454, 1.0 );
delta_within( $r3, 12425.0482805698, 1.0 );
delta_within( $r4, 65604254.9214087, 1.0 );
delta_within( $r5, 10797.0717602837, 1.0 );

$r1 = $e_meter->range(88.000000,90.000000,0.000000,1.000000);
$r2 = $e_kilo->range(88.000000,90.000000,0.000000,1.000000);
$r3 = $e_mile->range(88.000000,90.000000,0.000000,1.000000);
$r4 = $e_foot->range(88.000000,90.000000,0.000000,1.000000);
$r5 = $e_nm->range(88.000000,90.000000,0.000000,1.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(88.000000,90.000000,0.000000,90.000000);
$r2 = $e_kilo->range(88.000000,90.000000,0.000000,90.000000);
$r3 = $e_mile->range(88.000000,90.000000,0.000000,90.000000);
$r4 = $e_foot->range(88.000000,90.000000,0.000000,90.000000);
$r5 = $e_nm->range(88.000000,90.000000,0.000000,90.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(88.000000,90.000000,0.000000,179.000000);
$r2 = $e_kilo->range(88.000000,90.000000,0.000000,179.000000);
$r3 = $e_mile->range(88.000000,90.000000,0.000000,179.000000);
$r4 = $e_foot->range(88.000000,90.000000,0.000000,179.000000);
$r5 = $e_nm->range(88.000000,90.000000,0.000000,179.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(88.000000,90.000000,0.000000,268.000000);
$r2 = $e_kilo->range(88.000000,90.000000,0.000000,268.000000);
$r3 = $e_mile->range(88.000000,90.000000,0.000000,268.000000);
$r4 = $e_foot->range(88.000000,90.000000,0.000000,268.000000);
$r5 = $e_nm->range(88.000000,90.000000,0.000000,268.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234003, 1.0 );

$r1 = $e_meter->range(88.000000,90.000000,88.000000,1.000000);
$r2 = $e_kilo->range(88.000000,90.000000,88.000000,1.000000);
$r3 = $e_mile->range(88.000000,90.000000,88.000000,1.000000);
$r4 = $e_foot->range(88.000000,90.000000,88.000000,1.000000);
$r5 = $e_nm->range(88.000000,90.000000,88.000000,1.000000);
delta_within( $r1, 313115.736403702, 1.0 );
delta_within( $r2, 313.115736403702, 1.0 );
delta_within( $r3, 194.561098437439, 1.0 );
delta_within( $r4, 1027282.59974968, 1.0 );
delta_within( $r5, 169.068972140228, 1.0 );

$r1 = $e_meter->range(88.000000,90.000000,88.000000,90.000000);
$r2 = $e_kilo->range(88.000000,90.000000,88.000000,90.000000);
$r3 = $e_mile->range(88.000000,90.000000,88.000000,90.000000);
$r4 = $e_foot->range(88.000000,90.000000,88.000000,90.000000);
$r5 = $e_nm->range(88.000000,90.000000,88.000000,90.000000);
delta_within( $r1, 0, 1.0 );
delta_within( $r2, 0, 1.0 );
delta_within( $r3, 0, 1.0 );
delta_within( $r4, 0, 1.0 );
delta_within( $r5, 0, 1.0 );

$r1 = $e_meter->range(88.000000,90.000000,88.000000,179.000000);
$r2 = $e_kilo->range(88.000000,90.000000,88.000000,179.000000);
$r3 = $e_mile->range(88.000000,90.000000,88.000000,179.000000);
$r4 = $e_foot->range(88.000000,90.000000,88.000000,179.000000);
$r5 = $e_nm->range(88.000000,90.000000,88.000000,179.000000);
delta_within( $r1, 313115.736403702, 1.0 );
delta_within( $r2, 313.115736403702, 1.0 );
delta_within( $r3, 194.561098437439, 1.0 );
delta_within( $r4, 1027282.59974968, 1.0 );
delta_within( $r5, 169.068972140228, 1.0 );

$r1 = $e_meter->range(88.000000,90.000000,88.000000,268.000000);
$r2 = $e_kilo->range(88.000000,90.000000,88.000000,268.000000);
$r3 = $e_mile->range(88.000000,90.000000,88.000000,268.000000);
$r4 = $e_foot->range(88.000000,90.000000,88.000000,268.000000);
$r5 = $e_nm->range(88.000000,90.000000,88.000000,268.000000);
delta_within( $r1, 446706.010760529, 1.0 );
delta_within( $r2, 446.706010760529, 1.0 );
delta_within( $r3, 277.570246485853, 1.0 );
delta_within( $r4, 1465570.9014453, 1.0 );
delta_within( $r5, 241.201949654713, 1.0 );

$r1 = $e_meter->range(88.000000,179.000000,-88.000000,1.000000);
$r2 = $e_kilo->range(88.000000,179.000000,-88.000000,1.000000);
$r3 = $e_mile->range(88.000000,179.000000,-88.000000,1.000000);
$r4 = $e_foot->range(88.000000,179.000000,-88.000000,1.000000);
$r5 = $e_nm->range(88.000000,179.000000,-88.000000,1.000000);
delta_within( $r1, 19996176.9000454, 1.0 );
delta_within( $r2, 19996.1769000454, 1.0 );
delta_within( $r3, 12425.0482805698, 1.0 );
delta_within( $r4, 65604254.9214087, 1.0 );
delta_within( $r5, 10797.0717602837, 1.0 );

$r1 = $e_meter->range(88.000000,179.000000,-88.000000,90.000000);
$r2 = $e_kilo->range(88.000000,179.000000,-88.000000,90.000000);
$r3 = $e_mile->range(88.000000,179.000000,-88.000000,90.000000);
$r4 = $e_foot->range(88.000000,179.000000,-88.000000,90.000000);
$r5 = $e_nm->range(88.000000,179.000000,-88.000000,90.000000);
delta_within( $r1, 19685321.6740635, 1.0 );
delta_within( $r2, 19685.3216740635, 1.0 );
delta_within( $r3, 12231.8917981883, 1.0 );
delta_within( $r4, 64584388.6944341, 1.0 );
delta_within( $r5, 10629.223366125, 1.0 );

$r1 = $e_meter->range(88.000000,179.000000,-88.000000,179.000000);
$r2 = $e_kilo->range(88.000000,179.000000,-88.000000,179.000000);
$r3 = $e_mile->range(88.000000,179.000000,-88.000000,179.000000);
$r4 = $e_foot->range(88.000000,179.000000,-88.000000,179.000000);
$r5 = $e_nm->range(88.000000,179.000000,-88.000000,179.000000);
delta_within( $r1, 19557157.3743612, 1.0 );
delta_within( $r2, 19557.1573743612, 1.0 );
delta_within( $r3, 12152.25419448, 1.0 );
delta_within( $r4, 64163902.1468542, 1.0 );
delta_within( $r5, 10560.0201805406, 1.0 );

$r1 = $e_meter->range(88.000000,179.000000,-88.000000,268.000000);
$r2 = $e_kilo->range(88.000000,179.000000,-88.000000,268.000000);
$r3 = $e_mile->range(88.000000,179.000000,-88.000000,268.000000);
$r4 = $e_foot->range(88.000000,179.000000,-88.000000,268.000000);
$r5 = $e_nm->range(88.000000,179.000000,-88.000000,268.000000);
delta_within( $r1, 19685321.6740635, 1.0 );
delta_within( $r2, 19685.3216740635, 1.0 );
delta_within( $r3, 12231.8917981883, 1.0 );
delta_within( $r4, 64584388.6944341, 1.0 );
delta_within( $r5, 10629.223366125, 1.0 );

$r1 = $e_meter->range(88.000000,179.000000,0.000000,1.000000);
$r2 = $e_kilo->range(88.000000,179.000000,0.000000,1.000000);
$r3 = $e_mile->range(88.000000,179.000000,0.000000,1.000000);
$r4 = $e_foot->range(88.000000,179.000000,0.000000,1.000000);
$r5 = $e_nm->range(88.000000,179.000000,0.000000,1.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234003, 1.0 );

$r1 = $e_meter->range(88.000000,179.000000,0.000000,90.000000);
$r2 = $e_kilo->range(88.000000,179.000000,0.000000,90.000000);
$r3 = $e_mile->range(88.000000,179.000000,0.000000,90.000000);
$r4 = $e_foot->range(88.000000,179.000000,0.000000,90.000000);
$r5 = $e_nm->range(88.000000,179.000000,0.000000,90.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(88.000000,179.000000,0.000000,179.000000);
$r2 = $e_kilo->range(88.000000,179.000000,0.000000,179.000000);
$r3 = $e_mile->range(88.000000,179.000000,0.000000,179.000000);
$r4 = $e_foot->range(88.000000,179.000000,0.000000,179.000000);
$r5 = $e_nm->range(88.000000,179.000000,0.000000,179.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(88.000000,179.000000,0.000000,268.000000);
$r2 = $e_kilo->range(88.000000,179.000000,0.000000,268.000000);
$r3 = $e_mile->range(88.000000,179.000000,0.000000,268.000000);
$r4 = $e_foot->range(88.000000,179.000000,0.000000,268.000000);
$r5 = $e_nm->range(88.000000,179.000000,0.000000,268.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(88.000000,179.000000,88.000000,1.000000);
$r2 = $e_kilo->range(88.000000,179.000000,88.000000,1.000000);
$r3 = $e_mile->range(88.000000,179.000000,88.000000,1.000000);
$r4 = $e_foot->range(88.000000,179.000000,88.000000,1.000000);
$r5 = $e_nm->range(88.000000,179.000000,88.000000,1.000000);
delta_within( $r1, 446706.010760529, 1.0 );
delta_within( $r2, 446.706010760529, 1.0 );
delta_within( $r3, 277.570246485853, 1.0 );
delta_within( $r4, 1465570.9014453, 1.0 );
delta_within( $r5, 241.201949654713, 1.0 );

$r1 = $e_meter->range(88.000000,179.000000,88.000000,90.000000);
$r2 = $e_kilo->range(88.000000,179.000000,88.000000,90.000000);
$r3 = $e_mile->range(88.000000,179.000000,88.000000,90.000000);
$r4 = $e_foot->range(88.000000,179.000000,88.000000,90.000000);
$r5 = $e_nm->range(88.000000,179.000000,88.000000,90.000000);
delta_within( $r1, 313115.736403702, 1.0 );
delta_within( $r2, 313.115736403702, 1.0 );
delta_within( $r3, 194.561098437439, 1.0 );
delta_within( $r4, 1027282.59974968, 1.0 );
delta_within( $r5, 169.068972140228, 1.0 );

$r1 = $e_meter->range(88.000000,179.000000,88.000000,179.000000);
$r2 = $e_kilo->range(88.000000,179.000000,88.000000,179.000000);
$r3 = $e_mile->range(88.000000,179.000000,88.000000,179.000000);
$r4 = $e_foot->range(88.000000,179.000000,88.000000,179.000000);
$r5 = $e_nm->range(88.000000,179.000000,88.000000,179.000000);
delta_within( $r1, 0, 1.0 );
delta_within( $r2, 0, 1.0 );
delta_within( $r3, 0, 1.0 );
delta_within( $r4, 0, 1.0 );
delta_within( $r5, 0, 1.0 );

$r1 = $e_meter->range(88.000000,179.000000,88.000000,268.000000);
$r2 = $e_kilo->range(88.000000,179.000000,88.000000,268.000000);
$r3 = $e_mile->range(88.000000,179.000000,88.000000,268.000000);
$r4 = $e_foot->range(88.000000,179.000000,88.000000,268.000000);
$r5 = $e_nm->range(88.000000,179.000000,88.000000,268.000000);
delta_within( $r1, 313115.736403702, 1.0 );
delta_within( $r2, 313.115736403702, 1.0 );
delta_within( $r3, 194.561098437439, 1.0 );
delta_within( $r4, 1027282.59974968, 1.0 );
delta_within( $r5, 169.068972140228, 1.0 );

$r1 = $e_meter->range(88.000000,268.000000,-88.000000,1.000000);
$r2 = $e_kilo->range(88.000000,268.000000,-88.000000,1.000000);
$r3 = $e_mile->range(88.000000,268.000000,-88.000000,1.000000);
$r4 = $e_foot->range(88.000000,268.000000,-88.000000,1.000000);
$r5 = $e_nm->range(88.000000,268.000000,-88.000000,1.000000);
delta_within( $r1, 19696447.0104273, 1.0 );
delta_within( $r2, 19696.4470104273, 1.0 );
delta_within( $r3, 12238.8047617087, 1.0 );
delta_within( $r4, 64620889.1418219, 1.0 );
delta_within( $r5, 10635.2305671854, 1.0 );

$r1 = $e_meter->range(88.000000,268.000000,-88.000000,90.000000);
$r2 = $e_kilo->range(88.000000,268.000000,-88.000000,90.000000);
$r3 = $e_mile->range(88.000000,268.000000,-88.000000,90.000000);
$r4 = $e_foot->range(88.000000,268.000000,-88.000000,90.000000);
$r5 = $e_nm->range(88.000000,268.000000,-88.000000,90.000000);
delta_within( $r1, 19996176.9000454, 1.0 );
delta_within( $r2, 19996.1769000454, 1.0 );
delta_within( $r3, 12425.0482805698, 1.0 );
delta_within( $r4, 65604254.9214087, 1.0 );
delta_within( $r5, 10797.0717602837, 1.0 );

$r1 = $e_meter->range(88.000000,268.000000,-88.000000,179.000000);
$r2 = $e_kilo->range(88.000000,268.000000,-88.000000,179.000000);
$r3 = $e_mile->range(88.000000,268.000000,-88.000000,179.000000);
$r4 = $e_foot->range(88.000000,268.000000,-88.000000,179.000000);
$r5 = $e_nm->range(88.000000,268.000000,-88.000000,179.000000);
delta_within( $r1, 19685321.6740635, 1.0 );
delta_within( $r2, 19685.3216740635, 1.0 );
delta_within( $r3, 12231.8917981883, 1.0 );
delta_within( $r4, 64584388.6944341, 1.0 );
delta_within( $r5, 10629.223366125, 1.0 );

$r1 = $e_meter->range(88.000000,268.000000,-88.000000,268.000000);
$r2 = $e_kilo->range(88.000000,268.000000,-88.000000,268.000000);
$r3 = $e_mile->range(88.000000,268.000000,-88.000000,268.000000);
$r4 = $e_foot->range(88.000000,268.000000,-88.000000,268.000000);
$r5 = $e_nm->range(88.000000,268.000000,-88.000000,268.000000);
delta_within( $r1, 19557157.3743612, 1.0 );
delta_within( $r2, 19557.1573743612, 1.0 );
delta_within( $r3, 12152.25419448, 1.0 );
delta_within( $r4, 64163902.1468542, 1.0 );
delta_within( $r5, 10560.0201805406, 1.0 );

$r1 = $e_meter->range(88.000000,268.000000,0.000000,1.000000);
$r2 = $e_kilo->range(88.000000,268.000000,0.000000,1.000000);
$r3 = $e_mile->range(88.000000,268.000000,0.000000,1.000000);
$r4 = $e_foot->range(88.000000,268.000000,0.000000,1.000000);
$r5 = $e_nm->range(88.000000,268.000000,0.000000,1.000000);
delta_within( $r1, 10013675.0566307, 1.0 );
delta_within( $r2, 10013.6750566307, 1.0 );
delta_within( $r3, 6222.20920861587, 1.0 );
delta_within( $r4, 32853264.6214918, 1.0 );
delta_within( $r5, 5406.95197442262, 1.0 );

$r1 = $e_meter->range(88.000000,268.000000,0.000000,90.000000);
$r2 = $e_kilo->range(88.000000,268.000000,0.000000,90.000000);
$r3 = $e_mile->range(88.000000,268.000000,0.000000,90.000000);
$r4 = $e_foot->range(88.000000,268.000000,0.000000,90.000000);
$r5 = $e_nm->range(88.000000,268.000000,0.000000,90.000000);
delta_within( $r1, 10225216.6599337, 1.0 );
delta_within( $r2, 10225.2166599337, 1.0 );
delta_within( $r3, 6353.65506686807, 1.0 );
delta_within( $r4, 33547298.7530634, 1.0 );
delta_within( $r5, 5521.17530234003, 1.0 );

$r1 = $e_meter->range(88.000000,268.000000,0.000000,179.000000);
$r2 = $e_kilo->range(88.000000,268.000000,0.000000,179.000000);
$r3 = $e_mile->range(88.000000,268.000000,0.000000,179.000000);
$r4 = $e_foot->range(88.000000,268.000000,0.000000,179.000000);
$r5 = $e_nm->range(88.000000,268.000000,0.000000,179.000000);
delta_within( $r1, 9998088.45002268, 1.0 );
delta_within( $r2, 9998.08845002268, 1.0 );
delta_within( $r3, 6212.52414028491, 1.0 );
delta_within( $r4, 32802127.4607043, 1.0 );
delta_within( $r5, 5398.53588014184, 1.0 );

$r1 = $e_meter->range(88.000000,268.000000,0.000000,268.000000);
$r2 = $e_kilo->range(88.000000,268.000000,0.000000,268.000000);
$r3 = $e_mile->range(88.000000,268.000000,0.000000,268.000000);
$r4 = $e_foot->range(88.000000,268.000000,0.000000,268.000000);
$r5 = $e_nm->range(88.000000,268.000000,0.000000,268.000000);
delta_within( $r1, 9778578.68718058, 1.0 );
delta_within( $r2, 9778.57868718058, 1.0 );
delta_within( $r3, 6076.12709723998, 1.0 );
delta_within( $r4, 32081951.0734271, 1.0 );
delta_within( $r5, 5280.01009027029, 1.0 );

$r1 = $e_meter->range(88.000000,268.000000,88.000000,1.000000);
$r2 = $e_kilo->range(88.000000,268.000000,88.000000,1.000000);
$r3 = $e_mile->range(88.000000,268.000000,88.000000,1.000000);
$r4 = $e_foot->range(88.000000,268.000000,88.000000,1.000000);
$r5 = $e_nm->range(88.000000,268.000000,88.000000,1.000000);
delta_within( $r1, 324047.278966282, 1.0 );
delta_within( $r2, 324.047278966282, 1.0 );
delta_within( $r3, 201.353644072543, 1.0 );
delta_within( $r4, 1063147.24070303, 1.0 );
delta_within( $r5, 174.971532919159, 1.0 );

$r1 = $e_meter->range(88.000000,268.000000,88.000000,90.000000);
$r2 = $e_kilo->range(88.000000,268.000000,88.000000,90.000000);
$r3 = $e_mile->range(88.000000,268.000000,88.000000,90.000000);
$r4 = $e_foot->range(88.000000,268.000000,88.000000,90.000000);
$r5 = $e_nm->range(88.000000,268.000000,88.000000,90.000000);
delta_within( $r1, 446706.010760529, 1.0 );
delta_within( $r2, 446.706010760529, 1.0 );
delta_within( $r3, 277.570246485853, 1.0 );
delta_within( $r4, 1465570.9014453, 1.0 );
delta_within( $r5, 241.201949654713, 1.0 );

$r1 = $e_meter->range(88.000000,268.000000,88.000000,179.000000);
$r2 = $e_kilo->range(88.000000,268.000000,88.000000,179.000000);
$r3 = $e_mile->range(88.000000,268.000000,88.000000,179.000000);
$r4 = $e_foot->range(88.000000,268.000000,88.000000,179.000000);
$r5 = $e_nm->range(88.000000,268.000000,88.000000,179.000000);
delta_within( $r1, 313115.736403702, 1.0 );
delta_within( $r2, 313.115736403702, 1.0 );
delta_within( $r3, 194.561098437439, 1.0 );
delta_within( $r4, 1027282.59974968, 1.0 );
delta_within( $r5, 169.068972140228, 1.0 );

$r1 = $e_meter->range(88.000000,268.000000,88.000000,268.000000);
$r2 = $e_kilo->range(88.000000,268.000000,88.000000,268.000000);
$r3 = $e_mile->range(88.000000,268.000000,88.000000,268.000000);
$r4 = $e_foot->range(88.000000,268.000000,88.000000,268.000000);
$r5 = $e_nm->range(88.000000,268.000000,88.000000,268.000000);
delta_within( $r1, 0, 1.0 );
delta_within( $r2, 0, 1.0 );
delta_within( $r3, 0, 1.0 );
delta_within( $r4, 0, 1.0 );
delta_within( $r5, 0, 1.0 );

$r1 = $e_meter->range(-57.934266,269.464909,-71.038589,313.367482);
$r2 = $e_kilo->range(-57.934266,269.464909,-71.038589,313.367482);
$r3 = $e_mile->range(-57.934266,269.464909,-71.038589,313.367482);
$r4 = $e_foot->range(-57.934266,269.464909,-71.038589,313.367482);
$r5 = $e_nm->range(-57.934266,269.464909,-71.038589,313.367482);
delta_within( $r1, 2478983.26981422, 1.0 );
delta_within( $r2, 2478.98326981422, 1.0 );
delta_within( $r3, 1540.36878990087, 1.0 );
delta_within( $r4, 8133147.21067658, 1.0 );
delta_within( $r5, 1338.54388218911, 1.0 );

$r1 = $e_meter->range(13.605417,282.316135,33.826171,132.755857);
$r2 = $e_kilo->range(13.605417,282.316135,33.826171,132.755857);
$r3 = $e_mile->range(13.605417,282.316135,33.826171,132.755857);
$r4 = $e_foot->range(13.605417,282.316135,33.826171,132.755857);
$r5 = $e_nm->range(13.605417,282.316135,33.826171,132.755857);
delta_within( $r1, 13850451.7048934, 1.0 );
delta_within( $r2, 13850.4517048934, 1.0 );
delta_within( $r3, 8606.2716888952, 1.0 );
delta_within( $r4, 45441114.5173666, 1.0 );
delta_within( $r5, 7478.64562899209, 1.0 );

$r1 = $e_meter->range(65.807118,267.744045,-9.495920,127.342153);
$r2 = $e_kilo->range(65.807118,267.744045,-9.495920,127.342153);
$r3 = $e_mile->range(65.807118,267.744045,-9.495920,127.342153);
$r4 = $e_foot->range(65.807118,267.744045,-9.495920,127.342153);
$r5 = $e_nm->range(65.807118,267.744045,-9.495920,127.342153);
delta_within( $r1, 13064794.3870629, 1.0 );
delta_within( $r2, 13064.7943870629, 1.0 );
delta_within( $r3, 8118.08686462493, 1.0 );
delta_within( $r4, 42863498.6452196, 1.0 );
delta_within( $r5, 7054.42461504479, 1.0 );

$r1 = $e_meter->range(40.923455,94.159476,-18.604296,279.644382);
$r2 = $e_kilo->range(40.923455,94.159476,-18.604296,279.644382);
$r3 = $e_mile->range(40.923455,94.159476,-18.604296,279.644382);
$r4 = $e_foot->range(40.923455,94.159476,-18.604296,279.644382);
$r5 = $e_nm->range(40.923455,94.159476,-18.604296,279.644382);
delta_within( $r1, 17475952.9859877, 1.0 );
delta_within( $r2, 17475.9529859877, 1.0 );
delta_within( $r3, 10859.0537423868, 1.0 );
delta_within( $r4, 57335803.7598023, 1.0 );
delta_within( $r5, 9436.25971165644, 1.0 );

$r1 = $e_meter->range(60.726184,207.132176,37.934793,29.881529);
$r2 = $e_kilo->range(60.726184,207.132176,37.934793,29.881529);
$r3 = $e_mile->range(60.726184,207.132176,37.934793,29.881529);
$r4 = $e_foot->range(60.726184,207.132176,37.934793,29.881529);
$r5 = $e_nm->range(60.726184,207.132176,37.934793,29.881529);
delta_within( $r1, 9065819.55603936, 1.0 );
delta_within( $r2, 9065.81955603936, 1.0 );
delta_within( $r3, 5633.23910614471, 1.0 );
delta_within( $r4, 29743502.4804441, 1.0 );
delta_within( $r5, 4895.1509481854, 1.0 );

$r1 = $e_meter->range(-7.774777,40.360959,7.960132,140.647165);
$r2 = $e_kilo->range(-7.774777,40.360959,7.960132,140.647165);
$r3 = $e_mile->range(-7.774777,40.360959,7.960132,140.647165);
$r4 = $e_foot->range(-7.774777,40.360959,7.960132,140.647165);
$r5 = $e_nm->range(-7.774777,40.360959,7.960132,140.647165);
delta_within( $r1, 11262132.6431769, 1.0 );
delta_within( $r2, 11262.1326431769, 1.0 );
delta_within( $r3, 6997.96478762582, 1.0 );
delta_within( $r4, 36949254.0786643, 1.0 );
delta_within( $r5, 6081.06514210415, 1.0 );

$r1 = $e_meter->range(12.071034,344.345789,64.718561,58.748224);
$r2 = $e_kilo->range(12.071034,344.345789,64.718561,58.748224);
$r3 = $e_mile->range(12.071034,344.345789,64.718561,58.748224);
$r4 = $e_foot->range(12.071034,344.345789,64.718561,58.748224);
$r5 = $e_nm->range(12.071034,344.345789,64.718561,58.748224);
delta_within( $r1, 8059002.00518262, 1.0 );
delta_within( $r2, 8059.00200518262, 1.0 );
delta_within( $r3, 5007.63168420339, 1.0 );
delta_within( $r4, 26440295.2925939, 1.0 );
delta_within( $r5, 4351.51296176168, 1.0 );

$r1 = $e_meter->range(-39.510429,94.209272,74.640675,156.932149);
$r2 = $e_kilo->range(-39.510429,94.209272,74.640675,156.932149);
$r3 = $e_mile->range(-39.510429,94.209272,74.640675,156.932149);
$r4 = $e_foot->range(-39.510429,94.209272,74.640675,156.932149);
$r5 = $e_nm->range(-39.510429,94.209272,74.640675,156.932149);
delta_within( $r1, 13463843.6928142, 1.0 );
delta_within( $r2, 13463.8436928142, 1.0 );
delta_within( $r3, 8366.04460750105, 1.0 );
delta_within( $r4, 44172715.5276056, 1.0 );
delta_within( $r5, 7269.89400259945, 1.0 );

$r1 = $e_meter->range(50.945112,46.686892,-73.531799,338.631126);
$r2 = $e_kilo->range(50.945112,46.686892,-73.531799,338.631126);
$r3 = $e_mile->range(50.945112,46.686892,-73.531799,338.631126);
$r4 = $e_foot->range(50.945112,46.686892,-73.531799,338.631126);
$r5 = $e_nm->range(50.945112,46.686892,-73.531799,338.631126);
delta_within( $r1, 14726732.6094757, 1.0 );
delta_within( $r2, 14726.7326094757, 1.0 );
delta_within( $r3, 9150.76739931033, 1.0 );
delta_within( $r4, 48316051.8683585, 1.0 );
delta_within( $r5, 7951.79946515966, 1.0 );

$r1 = $e_meter->range(-83.498813,56.207513,-20.735893,55.705212);
$r2 = $e_kilo->range(-83.498813,56.207513,-20.735893,55.705212);
$r3 = $e_mile->range(-83.498813,56.207513,-20.735893,55.705212);
$r4 = $e_foot->range(-83.498813,56.207513,-20.735893,55.705212);
$r5 = $e_nm->range(-83.498813,56.207513,-20.735893,55.705212);
delta_within( $r1, 6982046.80533502, 1.0 );
delta_within( $r2, 6982.04680533502, 1.0 );
delta_within( $r3, 4338.44274768789, 1.0 );
delta_within( $r4, 22906977.707792, 1.0 );
delta_within( $r5, 3770.00367458694, 1.0 );

$r1 = $e_meter->range(5.162682,314.911760,-12.212387,95.006241);
$r2 = $e_kilo->range(5.162682,314.911760,-12.212387,95.006241);
$r3 = $e_mile->range(5.162682,314.911760,-12.212387,95.006241);
$r4 = $e_foot->range(5.162682,314.911760,-12.212387,95.006241);
$r5 = $e_nm->range(5.162682,314.911760,-12.212387,95.006241);
delta_within( $r1, 15580306.134578, 1.0 );
delta_within( $r2, 15580.306134578, 1.0 );
delta_within( $r3, 9681.15339826537, 1.0 );
delta_within( $r4, 51116489.9428412, 1.0 );
delta_within( $r5, 8412.69229728833, 1.0 );

$r1 = $e_meter->range(-32.807368,276.692824,-69.099205,277.575212);
$r2 = $e_kilo->range(-32.807368,276.692824,-69.099205,277.575212);
$r3 = $e_mile->range(-32.807368,276.692824,-69.099205,277.575212);
$r4 = $e_foot->range(-32.807368,276.692824,-69.099205,277.575212);
$r5 = $e_nm->range(-32.807368,276.692824,-69.099205,277.575212);
delta_within( $r1, 4037491.56639158, 1.0 );
delta_within( $r2, 4037.49156639158, 1.0 );
delta_within( $r3, 2508.78094825692, 1.0 );
delta_within( $r4, 13246363.4067965, 1.0 );
delta_within( $r5, 2180.07104016824, 1.0 );

$r1 = $e_meter->range(36.114418,79.272998,46.075743,148.216696);
$r2 = $e_kilo->range(36.114418,79.272998,46.075743,148.216696);
$r3 = $e_mile->range(36.114418,79.272998,46.075743,148.216696);
$r4 = $e_foot->range(36.114418,79.272998,46.075743,148.216696);
$r5 = $e_nm->range(36.114418,79.272998,46.075743,148.216696);
delta_within( $r1, 5712966.86704551, 1.0 );
delta_within( $r2, 5712.96686704551, 1.0 );
delta_within( $r3, 3549.87303338846, 1.0 );
delta_within( $r4, 18743329.6162911, 1.0 );
delta_within( $r5, 3084.75532777835, 1.0 );

$r1 = $e_meter->range(26.193521,333.924339,0.425668,247.478645);
$r2 = $e_kilo->range(26.193521,333.924339,0.425668,247.478645);
$r3 = $e_mile->range(26.193521,333.924339,0.425668,247.478645);
$r4 = $e_foot->range(26.193521,333.924339,0.425668,247.478645);
$r5 = $e_nm->range(26.193521,333.924339,0.425668,247.478645);
delta_within( $r1, 9639530.83300946, 1.0 );
delta_within( $r2, 9639.53083300946, 1.0 );
delta_within( $r3, 5989.72676631563, 1.0 );
delta_within( $r4, 31625757.3261465, 1.0 );
delta_within( $r5, 5204.93025540467, 1.0 );

$r1 = $e_meter->range(-11.247993,218.771725,13.474320,227.743816);
$r2 = $e_kilo->range(-11.247993,218.771725,13.474320,227.743816);
$r3 = $e_mile->range(-11.247993,218.771725,13.474320,227.743816);
$r4 = $e_foot->range(-11.247993,218.771725,13.474320,227.743816);
$r5 = $e_nm->range(-11.247993,218.771725,13.474320,227.743816);
delta_within( $r1, 2908081.0984665, 1.0 );
delta_within( $r2, 2908.0810984665, 1.0 );
delta_within( $r3, 1806.99781927698, 1.0 );
delta_within( $r4, 9540948.48578247, 1.0 );
delta_within( $r5, 1570.23817411798, 1.0 );

$r1 = $e_meter->range(-6.437086,227.343277,-63.660092,345.874110);
$r2 = $e_kilo->range(-6.437086,227.343277,-63.660092,345.874110);
$r3 = $e_mile->range(-6.437086,227.343277,-63.660092,345.874110);
$r4 = $e_foot->range(-6.437086,227.343277,-63.660092,345.874110);
$r5 = $e_nm->range(-6.437086,227.343277,-63.660092,345.874110);
delta_within( $r1, 10716663.132942, 1.0 );
delta_within( $r2, 10716.663132942, 1.0 );
delta_within( $r3, 6659.02574772207, 1.0 );
delta_within( $r4, 35159655.9479726, 1.0 );
delta_within( $r5, 5786.53516897518, 1.0 );

$r1 = $e_meter->range(-62.590000,160.912539,-30.873135,342.930268);
$r2 = $e_kilo->range(-62.590000,160.912539,-30.873135,342.930268);
$r3 = $e_mile->range(-62.590000,160.912539,-30.873135,342.930268);
$r4 = $e_foot->range(-62.590000,160.912539,-30.873135,342.930268);
$r5 = $e_nm->range(-62.590000,160.912539,-30.873135,342.930268);
delta_within( $r1, 9642768.30471071, 1.0 );
delta_within( $r2, 9642.76830471071, 1.0 );
delta_within( $r3, 5991.73843796647, 1.0 );
delta_within( $r4, 31636378.9524629, 1.0 );
delta_within( $r5, 5206.67835027576, 1.0 );

$r1 = $e_meter->range(-24.959632,143.558544,-70.174449,343.830865);
$r2 = $e_kilo->range(-24.959632,143.558544,-70.174449,343.830865);
$r3 = $e_mile->range(-24.959632,143.558544,-70.174449,343.830865);
$r4 = $e_foot->range(-24.959632,143.558544,-70.174449,343.830865);
$r5 = $e_nm->range(-24.959632,143.558544,-70.174449,343.830865);
delta_within( $r1, 9331596.49998794, 1.0 );
delta_within( $r2, 9331.59649998794, 1.0 );
delta_within( $r3, 5798.38524267524, 1.0 );
delta_within( $r4, 30615474.0813253, 1.0 );
delta_within( $r5, 5038.65901727211, 1.0 );

$r1 = $e_meter->range(85.292583,207.197289,64.400817,53.955321);
$r2 = $e_kilo->range(85.292583,207.197289,64.400817,53.955321);
$r3 = $e_mile->range(85.292583,207.197289,64.400817,53.955321);
$r4 = $e_foot->range(85.292583,207.197289,64.400817,53.955321);
$r5 = $e_nm->range(85.292583,207.197289,64.400817,53.955321);
delta_within( $r1, 3334743.62344139, 1.0 );
delta_within( $r2, 3334.74362344139, 1.0 );
delta_within( $r3, 2072.11362110362, 1.0 );
delta_within( $r4, 10940759.9194271, 1.0 );
delta_within( $r5, 1800.61750725777, 1.0 );

$r1 = $e_meter->range(72.010476,234.148398,-76.760490,343.799779);
$r2 = $e_kilo->range(72.010476,234.148398,-76.760490,343.799779);
$r3 = $e_mile->range(72.010476,234.148398,-76.760490,343.799779);
$r4 = $e_foot->range(72.010476,234.148398,-76.760490,343.799779);
$r5 = $e_nm->range(72.010476,234.148398,-76.760490,343.799779);
delta_within( $r1, 17966012.0923903, 1.0 );
delta_within( $r2, 17966.0120923903, 1.0 );
delta_within( $r3, 11163.5623535989, 1.0 );
delta_within( $r4, 58943609.2270023, 1.0 );
delta_within( $r5, 9700.87046025395, 1.0 );

$r1 = $e_meter->range(82.062247,282.224532,53.709008,205.651325);
$r2 = $e_kilo->range(82.062247,282.224532,53.709008,205.651325);
$r3 = $e_mile->range(82.062247,282.224532,53.709008,205.651325);
$r4 = $e_foot->range(82.062247,282.224532,53.709008,205.651325);
$r5 = $e_nm->range(82.062247,282.224532,53.709008,205.651325);
delta_within( $r1, 3925232.39059218, 1.0 );
delta_within( $r2, 3925.23239059218, 1.0 );
delta_within( $r3, 2439.02633035086, 1.0 );
delta_within( $r4, 12878059.0242526, 1.0 );
delta_within( $r5, 2119.45593444502, 1.0 );

$r1 = $e_meter->range(-38.264913,345.593277,13.987962,157.269106);
$r2 = $e_kilo->range(-38.264913,345.593277,13.987962,157.269106);
$r3 = $e_mile->range(-38.264913,345.593277,13.987962,157.269106);
$r4 = $e_foot->range(-38.264913,345.593277,13.987962,157.269106);
$r5 = $e_nm->range(-38.264913,345.593277,13.987962,157.269106);
delta_within( $r1, 17193609.7687517, 1.0 );
delta_within( $r2, 17193.6097687517, 1.0 );
delta_within( $r3, 10683.6138008727, 1.0 );
delta_within( $r4, 56409480.868608, 1.0 );
delta_within( $r5, 9283.80657060028, 1.0 );

$r1 = $e_meter->range(-21.923233,331.579924,-82.948909,276.789592);
$r2 = $e_kilo->range(-21.923233,331.579924,-82.948909,276.789592);
$r3 = $e_mile->range(-21.923233,331.579924,-82.948909,276.789592);
$r4 = $e_foot->range(-21.923233,331.579924,-82.948909,276.789592);
$r5 = $e_nm->range(-21.923233,331.579924,-82.948909,276.789592);
delta_within( $r1, 7136933.98147936, 1.0 );
delta_within( $r2, 7136.93398147936, 1.0 );
delta_within( $r3, 4434.68517699097, 1.0 );
delta_within( $r4, 23415137.7345123, 1.0 );
delta_within( $r5, 3853.63605911413, 1.0 );

$r1 = $e_meter->range(39.266792,212.567027,-13.043617,231.171501);
$r2 = $e_kilo->range(39.266792,212.567027,-13.043617,231.171501);
$r3 = $e_mile->range(39.266792,212.567027,-13.043617,231.171501);
$r4 = $e_foot->range(39.266792,212.567027,-13.043617,231.171501);
$r5 = $e_nm->range(39.266792,212.567027,-13.043617,231.171501);
delta_within( $r1, 6104433.98020838, 1.0 );
delta_within( $r2, 6104.43398020838, 1.0 );
delta_within( $r3, 3793.11942021617, 1.0 );
delta_within( $r4, 20027670.5387414, 1.0 );
delta_within( $r5, 3296.13065885982, 1.0 );

$r1 = $e_meter->range(43.430240,25.708641,-78.620089,278.752912);
$r2 = $e_kilo->range(43.430240,25.708641,-78.620089,278.752912);
$r3 = $e_mile->range(43.430240,25.708641,-78.620089,278.752912);
$r4 = $e_foot->range(43.430240,25.708641,-78.620089,278.752912);
$r5 = $e_nm->range(43.430240,25.708641,-78.620089,278.752912);
delta_within( $r1, 15067414.5790259, 1.0 );
delta_within( $r2, 15067.4145790259, 1.0 );
delta_within( $r3, 9362.45736090351, 1.0 );
delta_within( $r4, 49433774.8655706, 1.0 );
delta_within( $r5, 8135.75301243299, 1.0 );

$r1 = $e_meter->range(35.816613,44.413390,-34.595103,26.822827);
$r2 = $e_kilo->range(35.816613,44.413390,-34.595103,26.822827);
$r3 = $e_mile->range(35.816613,44.413390,-34.595103,26.822827);
$r4 = $e_foot->range(35.816613,44.413390,-34.595103,26.822827);
$r5 = $e_nm->range(35.816613,44.413390,-34.595103,26.822827);
delta_within( $r1, 8006275.94631107, 1.0 );
delta_within( $r2, 8006.27594631107, 1.0 );
delta_within( $r3, 4974.8692301404, 1.0 );
delta_within( $r4, 26267309.5351413, 1.0 );
delta_within( $r5, 4323.04316755457, 1.0 );

$r1 = $e_meter->range(33.063322,131.654287,40.382161,70.051002);
$r2 = $e_kilo->range(33.063322,131.654287,40.382161,70.051002);
$r3 = $e_mile->range(33.063322,131.654287,40.382161,70.051002);
$r4 = $e_foot->range(33.063322,131.654287,40.382161,70.051002);
$r5 = $e_nm->range(33.063322,131.654287,40.382161,70.051002);
delta_within( $r1, 5452116.89026308, 1.0 );
delta_within( $r2, 5452.11689026308, 1.0 );
delta_within( $r3, 3387.78837232007, 1.0 );
delta_within( $r4, 17887522.60585, 1.0 );
delta_within( $r5, 2943.90760813341, 1.0 );

$r1 = $e_meter->range(-60.791775,58.921675,58.472988,198.337306);
$r2 = $e_kilo->range(-60.791775,58.921675,58.472988,198.337306);
$r3 = $e_mile->range(-60.791775,58.921675,58.472988,198.337306);
$r4 = $e_foot->range(-60.791775,58.921675,58.472988,198.337306);
$r5 = $e_nm->range(-60.791775,58.921675,58.472988,198.337306);
delta_within( $r1, 17744632.7153385, 1.0 );
delta_within( $r2, 17744.6327153385, 1.0 );
delta_within( $r3, 11026.0035861435, 1.0 );
delta_within( $r4, 58217298.9348376, 1.0 );
delta_within( $r5, 9581.33515947003, 1.0 );

$r1 = $e_meter->range(-32.182827,189.929621,-11.752936,76.924247);
$r2 = $e_kilo->range(-32.182827,189.929621,-11.752936,76.924247);
$r3 = $e_mile->range(-32.182827,189.929621,-11.752936,76.924247);
$r4 = $e_foot->range(-32.182827,189.929621,-11.752936,76.924247);
$r5 = $e_nm->range(-32.182827,189.929621,-11.752936,76.924247);
delta_within( $r1, 11405061.5799716, 1.0 );
delta_within( $r2, 11405.0615799716, 1.0 );
delta_within( $r3, 7086.77671148718, 1.0 );
delta_within( $r4, 37418181.0366523, 1.0 );
delta_within( $r5, 6158.24059393716, 1.0 );

$r1 = $e_meter->range(40.410413,1.490210,15.171991,171.877678);
$r2 = $e_kilo->range(40.410413,1.490210,15.171991,171.877678);
$r3 = $e_mile->range(40.410413,1.490210,15.171991,171.877678);
$r4 = $e_foot->range(40.410413,1.490210,15.171991,171.877678);
$r5 = $e_nm->range(40.410413,1.490210,15.171991,171.877678);
delta_within( $r1, 13771611.4326195, 1.0 );
delta_within( $r2, 13771.6114326195, 1.0 );
delta_within( $r3, 8557.28261491609, 1.0 );
delta_within( $r4, 45182452.2067569, 1.0 );
delta_within( $r5, 7436.07528759153, 1.0 );

$r1 = $e_meter->range(77.415003,273.852765,-65.518823,5.320166);
$r2 = $e_kilo->range(77.415003,273.852765,-65.518823,5.320166);
$r3 = $e_mile->range(77.415003,273.852765,-65.518823,5.320166);
$r4 = $e_foot->range(77.415003,273.852765,-65.518823,5.320166);
$r5 = $e_nm->range(77.415003,273.852765,-65.518823,5.320166);
delta_within( $r1, 16984526.9730499, 1.0 );
delta_within( $r2, 16984.5269730499, 1.0 );
delta_within( $r3, 10553.6957748312, 1.0 );
delta_within( $r4, 55723513.6911087, 1.0 );
delta_within( $r5, 9170.91089257556, 1.0 );

$r1 = $e_meter->range(-0.001169,303.428210,61.978146,32.763058);
$r2 = $e_kilo->range(-0.001169,303.428210,61.978146,32.763058);
$r3 = $e_mile->range(-0.001169,303.428210,61.978146,32.763058);
$r4 = $e_foot->range(-0.001169,303.428210,61.978146,32.763058);
$r5 = $e_nm->range(-0.001169,303.428210,61.978146,32.763058);
delta_within( $r1, 9970926.02740749, 1.0 );
delta_within( $r2, 9970.92602740749, 1.0 );
delta_within( $r3, 6195.64619336046, 1.0 );
delta_within( $r4, 32713011.9009432, 1.0 );
delta_within( $r5, 5383.86934525243, 1.0 );

$r1 = $e_meter->range(62.964471,283.438450,13.811810,35.816077);
$r2 = $e_kilo->range(62.964471,283.438450,13.811810,35.816077);
$r3 = $e_mile->range(62.964471,283.438450,13.811810,35.816077);
$r4 = $e_foot->range(62.964471,283.438450,13.811810,35.816077);
$r5 = $e_nm->range(62.964471,283.438450,13.811810,35.816077);
delta_within( $r1, 9733041.79438803, 1.0 );
delta_within( $r2, 9733.04179438803, 1.0 );
delta_within( $r3, 6047.83178387469, 1.0 );
delta_within( $r4, 31932551.8188584, 1.0 );
delta_within( $r5, 5255.42213519872, 1.0 );

$r1 = $e_meter->range(57.757522,268.496370,71.873398,184.371272);
$r2 = $e_kilo->range(57.757522,268.496370,71.873398,184.371272);
$r3 = $e_mile->range(57.757522,268.496370,71.873398,184.371272);
$r4 = $e_foot->range(57.757522,268.496370,71.873398,184.371272);
$r5 = $e_nm->range(57.757522,268.496370,71.873398,184.371272);
delta_within( $r1, 3887427.27158255, 1.0 );
delta_within( $r2, 3887.42727158255, 1.0 );
delta_within( $r3, 2415.53531847917, 1.0 );
delta_within( $r4, 12754026.48157, 1.0 );
delta_within( $r5, 2099.04280323032, 1.0 );

$r1 = $e_meter->range(67.683592,345.377181,11.705901,170.600523);
$r2 = $e_kilo->range(67.683592,345.377181,11.705901,170.600523);
$r3 = $e_mile->range(67.683592,345.377181,11.705901,170.600523);
$r4 = $e_foot->range(67.683592,345.377181,11.705901,170.600523);
$r5 = $e_nm->range(67.683592,345.377181,11.705901,170.600523);
delta_within( $r1, 11188758.804159, 1.0 );
delta_within( $r2, 11188.758804159, 1.0 );
delta_within( $r3, 6952.37239779623, 1.0 );
delta_within( $r4, 36708526.2603641, 1.0 );
delta_within( $r5, 6041.44643853076, 1.0 );

$r1 = $e_meter->range(-14.509993,233.823561,66.915477,210.936486);
$r2 = $e_kilo->range(-14.509993,233.823561,66.915477,210.936486);
$r3 = $e_mile->range(-14.509993,233.823561,66.915477,210.936486);
$r4 = $e_foot->range(-14.509993,233.823561,66.915477,210.936486);
$r5 = $e_nm->range(-14.509993,233.823561,66.915477,210.936486);
delta_within( $r1, 9223027.54994791, 1.0 );
delta_within( $r2, 9223.02754994791, 1.0 );
delta_within( $r3, 5730.92362474891, 1.0 );
delta_within( $r4, 30259276.7386742, 1.0 );
delta_within( $r5, 4980.03647405395, 1.0 );

$r1 = $e_meter->range(-48.837869,358.766092,-59.984409,250.415053);
$r2 = $e_kilo->range(-48.837869,358.766092,-59.984409,250.415053);
$r3 = $e_mile->range(-48.837869,358.766092,-59.984409,250.415053);
$r4 = $e_foot->range(-48.837869,358.766092,-59.984409,250.415053);
$r5 = $e_nm->range(-48.837869,358.766092,-59.984409,250.415053);
delta_within( $r1, 6331138.72714117, 1.0 );
delta_within( $r2, 6331.13872714117, 1.0 );
delta_within( $r3, 3933.98721910367, 1.0 );
delta_within( $r4, 20771452.5168674, 1.0 );
delta_within( $r5, 3418.54142934188, 1.0 );

$r1 = $e_meter->range(35.469166,354.061624,26.153177,235.757036);
$r2 = $e_kilo->range(35.469166,354.061624,26.153177,235.757036);
$r3 = $e_mile->range(35.469166,354.061624,26.153177,235.757036);
$r4 = $e_foot->range(35.469166,354.061624,26.153177,235.757036);
$r5 = $e_nm->range(35.469166,354.061624,26.153177,235.757036);
delta_within( $r1, 10606793.2549714, 1.0 );
delta_within( $r2, 10606.7932549714, 1.0 );
delta_within( $r3, 6590.75577065649, 1.0 );
delta_within( $r4, 34799190.4690663, 1.0 );
delta_within( $r5, 5727.21018087009, 1.0 );

$r1 = $e_meter->range(60.579911,245.073600,82.746095,119.397052);
$r2 = $e_kilo->range(60.579911,245.073600,82.746095,119.397052);
$r3 = $e_mile->range(60.579911,245.073600,82.746095,119.397052);
$r4 = $e_foot->range(60.579911,245.073600,82.746095,119.397052);
$r5 = $e_nm->range(60.579911,245.073600,82.746095,119.397052);
delta_within( $r1, 3807870.32524918, 1.0 );
delta_within( $r2, 3807.87032524918, 1.0 );
delta_within( $r3, 2366.10092388525, 1.0 );
delta_within( $r4, 12493012.8781141, 1.0 );
delta_within( $r5, 2056.08548879545, 1.0 );

$r1 = $e_meter->range(52.814462,58.052386,63.937125,216.992405);
$r2 = $e_kilo->range(52.814462,58.052386,63.937125,216.992405);
$r3 = $e_mile->range(52.814462,58.052386,63.937125,216.992405);
$r4 = $e_foot->range(52.814462,58.052386,63.937125,216.992405);
$r5 = $e_nm->range(52.814462,58.052386,63.937125,216.992405);
delta_within( $r1, 6929484.96260079, 1.0 );
delta_within( $r2, 6929.48496260079, 1.0 );
delta_within( $r3, 4305.78233280193, 1.0 );
delta_within( $r4, 22734530.7171942, 1.0 );
delta_within( $r5, 3741.62255000043, 1.0 );

$r1 = $e_meter->range(-14.087235,352.325834,64.925852,167.053343);
$r2 = $e_kilo->range(-14.087235,352.325834,64.925852,167.053343);
$r3 = $e_mile->range(-14.087235,352.325834,64.925852,167.053343);
$r4 = $e_foot->range(-14.087235,352.325834,64.925852,167.053343);
$r5 = $e_nm->range(-14.087235,352.325834,64.925852,167.053343);
delta_within( $r1, 14344572.4591005, 1.0 );
delta_within( $r2, 14344.5724591005, 1.0 );
delta_within( $r3, 8913.30409104613, 1.0 );
delta_within( $r4, 47062245.6007236, 1.0 );
delta_within( $r5, 7745.44949195494, 1.0 );

$r1 = $e_meter->range(-44.555528,303.380598,60.410717,265.142366);
$r2 = $e_kilo->range(-44.555528,303.380598,60.410717,265.142366);
$r3 = $e_mile->range(-44.555528,303.380598,60.410717,265.142366);
$r4 = $e_foot->range(-44.555528,303.380598,60.410717,265.142366);
$r5 = $e_nm->range(-44.555528,303.380598,60.410717,265.142366);
delta_within( $r1, 12142365.0295713, 1.0 );
delta_within( $r2, 12142.3650295713, 1.0 );
delta_within( $r3, 7544.91583500565, 1.0 );
delta_within( $r4, 39837155.6088298, 1.0 );
delta_within( $r5, 6556.3526077599, 1.0 );

$r1 = $e_meter->range(-64.733717,171.696178,50.043309,179.133361);
$r2 = $e_kilo->range(-64.733717,171.696178,50.043309,179.133361);
$r3 = $e_mile->range(-64.733717,171.696178,50.043309,179.133361);
$r4 = $e_foot->range(-64.733717,171.696178,50.043309,179.133361);
$r5 = $e_nm->range(-64.733717,171.696178,50.043309,179.133361);
delta_within( $r1, 12743611.5768642, 1.0 );
delta_within( $r2, 12743.6115768642, 1.0 );
delta_within( $r3, 7918.51311892559, 1.0 );
delta_within( $r4, 41809749.2679271, 1.0 );
delta_within( $r5, 6880.99977152493, 1.0 );

$r1 = $e_meter->range(12.112040,159.973637,-81.799749,119.465377);
$r2 = $e_kilo->range(12.112040,159.973637,-81.799749,119.465377);
$r3 = $e_mile->range(12.112040,159.973637,-81.799749,119.465377);
$r4 = $e_foot->range(12.112040,159.973637,-81.799749,119.465377);
$r5 = $e_nm->range(12.112040,159.973637,-81.799749,119.465377);
delta_within( $r1, 10640434.6234949, 1.0 );
delta_within( $r2, 10640.4346234949, 1.0 );
delta_within( $r3, 6611.65954792444, 1.0 );
delta_within( $r4, 34909562.413041, 1.0 );
delta_within( $r5, 5745.37506668192, 1.0 );

$r1 = $e_meter->range(-12.913136,209.560123,-72.500921,242.959763);
$r2 = $e_kilo->range(-12.913136,209.560123,-72.500921,242.959763);
$r3 = $e_mile->range(-12.913136,209.560123,-72.500921,242.959763);
$r4 = $e_foot->range(-12.913136,209.560123,-72.500921,242.959763);
$r5 = $e_nm->range(-12.913136,209.560123,-72.500921,242.959763);
delta_within( $r1, 6973908.49631601, 1.0 );
delta_within( $r2, 6973.90849631601, 1.0 );
delta_within( $r3, 4333.38583690995, 1.0 );
delta_within( $r4, 22880277.2188845, 1.0 );
delta_within( $r5, 3765.6093392635, 1.0 );

$r1 = $e_meter->range(15.388763,85.383404,43.057681,345.007357);
$r2 = $e_kilo->range(15.388763,85.383404,43.057681,345.007357);
$r3 = $e_mile->range(15.388763,85.383404,43.057681,345.007357);
$r4 = $e_foot->range(15.388763,85.383404,43.057681,345.007357);
$r5 = $e_nm->range(15.388763,85.383404,43.057681,345.007357);
delta_within( $r1, 9674590.63953447, 1.0 );
delta_within( $r2, 9674.59063953447, 1.0 );
delta_within( $r3, 6011.51192009568, 1.0 );
delta_within( $r4, 31740782.9381052, 1.0 );
delta_within( $r5, 5223.86103646569, 1.0 );

$r1 = $e_meter->range(64.108958,27.645978,7.006558,137.813405);
$r2 = $e_kilo->range(64.108958,27.645978,7.006558,137.813405);
$r3 = $e_mile->range(64.108958,27.645978,7.006558,137.813405);
$r4 = $e_foot->range(64.108958,27.645978,7.006558,137.813405);
$r5 = $e_nm->range(64.108958,27.645978,7.006558,137.813405);
delta_within( $r1, 10265664.1927237, 1.0 );
delta_within( $r2, 10265.6641927237, 1.0 );
delta_within( $r3, 6378.78799854086, 1.0 );
delta_within( $r4, 33680000.6322957, 1.0 );
delta_within( $r5, 5543.01522285299, 1.0 );

$r1 = $e_meter->range(-87.675134,257.547959,-78.556203,7.576067);
$r2 = $e_kilo->range(-87.675134,257.547959,-78.556203,7.576067);
$r3 = $e_mile->range(-87.675134,257.547959,-78.556203,7.576067);
$r4 = $e_foot->range(-87.675134,257.547959,-78.556203,7.576067);
$r5 = $e_nm->range(-87.675134,257.547959,-78.556203,7.576067);
delta_within( $r1, 1388279.96503049, 1.0 );
delta_within( $r2, 1388.27996503049, 1.0 );
delta_within( $r3, 862.637177030198, 1.0 );
delta_within( $r4, 4554724.29471945, 1.0 );
delta_within( $r5, 749.611212219486, 1.0 );

$r1 = $e_meter->range(45.506762,226.167856,75.858502,197.258652);
$r2 = $e_kilo->range(45.506762,226.167856,75.858502,197.258652);
$r3 = $e_mile->range(45.506762,226.167856,75.858502,197.258652);
$r4 = $e_foot->range(45.506762,226.167856,75.858502,197.258652);
$r5 = $e_nm->range(45.506762,226.167856,75.858502,197.258652);
delta_within( $r1, 3642825.04801401, 1.0 );
delta_within( $r2, 3642.82504801401, 1.0 );
delta_within( $r3, 2263.54654319649, 1.0 );
delta_within( $r4, 11951525.7480774, 1.0 );
delta_within( $r5, 1966.96816847408, 1.0 );

$r1 = $e_meter->range(-15.130062,141.680058,-53.226032,110.910346);
$r2 = $e_kilo->range(-15.130062,141.680058,-53.226032,110.910346);
$r3 = $e_mile->range(-15.130062,141.680058,-53.226032,110.910346);
$r4 = $e_foot->range(-15.130062,141.680058,-53.226032,110.910346);
$r5 = $e_nm->range(-15.130062,141.680058,-53.226032,110.910346);
delta_within( $r1, 5012011.5716539, 1.0 );
delta_within( $r2, 5012.0115716539, 1.0 );
delta_within( $r3, 3114.3196057859, 1.0 );
delta_within( $r4, 16443607.5185495, 1.0 );
delta_within( $r5, 2706.26974711334, 1.0 );

$r1 = $e_meter->range(-51.171998,219.770710,-22.538592,57.834091);
$r2 = $e_kilo->range(-51.171998,219.770710,-22.538592,57.834091);
$r3 = $e_mile->range(-51.171998,219.770710,-22.538592,57.834091);
$r4 = $e_foot->range(-51.171998,219.770710,-22.538592,57.834091);
$r5 = $e_nm->range(-51.171998,219.770710,-22.538592,57.834091);
delta_within( $r1, 11650461.6034958, 1.0 );
delta_within( $r2, 11650.4616034958, 1.0 );
delta_within( $r3, 7239.26121667946, 1.0 );
delta_within( $r4, 38223299.2240676, 1.0 );
delta_within( $r5, 6290.74600620723, 1.0 );

$r1 = $e_meter->range(-7.000668,288.466856,-55.716970,258.457540);
$r2 = $e_kilo->range(-7.000668,288.466856,-55.716970,258.457540);
$r3 = $e_mile->range(-7.000668,288.466856,-55.716970,258.457540);
$r4 = $e_foot->range(-7.000668,288.466856,-55.716970,258.457540);
$r5 = $e_nm->range(-7.000668,288.466856,-55.716970,258.457540);
delta_within( $r1, 6017359.40295353, 1.0 );
delta_within( $r2, 6017.35940295353, 1.0 );
delta_within( $r3, 3739.01378633377, 1.0 );
delta_within( $r4, 19741992.7918423, 1.0 );
delta_within( $r5, 3249.11414846303, 1.0 );

$r1 = $e_meter->range(-4.103181,51.748045,23.523933,87.322753);
$r2 = $e_kilo->range(-4.103181,51.748045,23.523933,87.322753);
$r3 = $e_mile->range(-4.103181,51.748045,23.523933,87.322753);
$r4 = $e_foot->range(-4.103181,51.748045,23.523933,87.322753);
$r5 = $e_nm->range(-4.103181,51.748045,23.523933,87.322753);
delta_within( $r1, 4923654.59463329, 1.0 );
delta_within( $r2, 4923.65459463329, 1.0 );
delta_within( $r3, 3059.41712563211, 1.0 );
delta_within( $r4, 16153722.4233376, 1.0 );
delta_within( $r5, 2658.56079623828, 1.0 );

$r1 = $e_meter->range(-66.149558,312.989638,-69.799797,271.586522);
$r2 = $e_kilo->range(-66.149558,312.989638,-69.799797,271.586522);
$r3 = $e_mile->range(-66.149558,312.989638,-69.799797,271.586522);
$r4 = $e_foot->range(-66.149558,312.989638,-69.799797,271.586522);
$r5 = $e_nm->range(-66.149558,312.989638,-69.799797,271.586522);
delta_within( $r1, 1743562.46751605, 1.0 );
delta_within( $r2, 1743.56246751605, 1.0 );
delta_within( $r3, 1083.39948918072, 1.0 );
delta_within( $r4, 5720349.30287419, 1.0 );
delta_within( $r5, 941.448416585341, 1.0 );

$r1 = $e_meter->range(-21.017857,200.311309,-74.230046,135.855002);
$r2 = $e_kilo->range(-21.017857,200.311309,-74.230046,135.855002);
$r3 = $e_mile->range(-21.017857,200.311309,-74.230046,135.855002);
$r4 = $e_foot->range(-21.017857,200.311309,-74.230046,135.855002);
$r5 = $e_nm->range(-21.017857,200.311309,-74.230046,135.855002);
delta_within( $r1, 7005716.26957978, 1.0 );
delta_within( $r2, 7005.71626957978, 1.0 );
delta_within( $r3, 4353.15027090528, 1.0 );
delta_within( $r4, 22984633.4303799, 1.0 );
delta_within( $r5, 3782.78416284005, 1.0 );

$r1 = $e_meter->range(22.032424,283.684581,-13.840647,296.727744);
$r2 = $e_kilo->range(22.032424,283.684581,-13.840647,296.727744);
$r3 = $e_mile->range(22.032424,283.684581,-13.840647,296.727744);
$r4 = $e_foot->range(22.032424,283.684581,-13.840647,296.727744);
$r5 = $e_nm->range(22.032424,283.684581,-13.840647,296.727744);
delta_within( $r1, 4215876.49472136, 1.0 );
delta_within( $r2, 4215.87649472136, 1.0 );
delta_within( $r3, 2619.62420385037, 1.0 );
delta_within( $r4, 13831615.7963299, 1.0 );
delta_within( $r5, 2276.39119585387, 1.0 );

$r1 = $e_meter->range(9.137311,261.695802,-1.968743,94.386354);
$r2 = $e_kilo->range(9.137311,261.695802,-1.968743,94.386354);
$r3 = $e_mile->range(9.137311,261.695802,-1.968743,94.386354);
$r4 = $e_foot->range(9.137311,261.695802,-1.968743,94.386354);
$r5 = $e_nm->range(9.137311,261.695802,-1.968743,94.386354);
delta_within( $r1, 18415518.434645, 1.0 );
delta_within( $r2, 18415.518434645, 1.0 );
delta_within( $r3, 11442.872645404, 1.0 );
delta_within( $r4, 60418367.5677329, 1.0 );
delta_within( $r5, 9943.58446795085, 1.0 );

$r1 = $e_meter->range(-0.367684,176.265124,-1.495746,305.845852);
$r2 = $e_kilo->range(-0.367684,176.265124,-1.495746,305.845852);
$r3 = $e_mile->range(-0.367684,176.265124,-1.495746,305.845852);
$r4 = $e_foot->range(-0.367684,176.265124,-1.495746,305.845852);
$r5 = $e_nm->range(-0.367684,176.265124,-1.495746,305.845852);
delta_within( $r1, 14421564.897997, 1.0 );
delta_within( $r2, 14421.564897997, 1.0 );
delta_within( $r3, 8961.14497459645, 1.0 );
delta_within( $r4, 47314845.4658693, 1.0 );
delta_within( $r5, 7787.02208315171, 1.0 );

$r1 = $e_meter->range(73.726080,130.581316,8.059198,217.631502);
$r2 = $e_kilo->range(73.726080,130.581316,8.059198,217.631502);
$r3 = $e_mile->range(73.726080,130.581316,8.059198,217.631502);
$r4 = $e_foot->range(73.726080,130.581316,8.059198,217.631502);
$r5 = $e_nm->range(73.726080,130.581316,8.059198,217.631502);
delta_within( $r1, 9055964.88324431, 1.0 );
delta_within( $r2, 9055.96488324431, 1.0 );
delta_within( $r3, 5627.11569636095, 1.0 );
delta_within( $r4, 29711170.8767858, 1.0 );
delta_within( $r5, 4889.82985056388, 1.0 );

$r1 = $e_meter->range(19.299877,158.813658,36.382896,77.814439);
$r2 = $e_kilo->range(19.299877,158.813658,36.382896,77.814439);
$r3 = $e_mile->range(19.299877,158.813658,36.382896,77.814439);
$r4 = $e_foot->range(19.299877,158.813658,36.382896,77.814439);
$r5 = $e_nm->range(19.299877,158.813658,36.382896,77.814439);
delta_within( $r1, 7978668.24478752, 1.0 );
delta_within( $r2, 7978.66824478752, 1.0 );
delta_within( $r3, 4957.71459972978, 1.0 );
delta_within( $r4, 26176733.0865732, 1.0 );
delta_within( $r5, 4308.13620128916, 1.0 );

$r1 = $e_meter->range(46.759530,110.686586,50.379077,32.324924);
$r2 = $e_kilo->range(46.759530,110.686586,50.379077,32.324924);
$r3 = $e_mile->range(46.759530,110.686586,50.379077,32.324924);
$r4 = $e_foot->range(46.759530,110.686586,50.379077,32.324924);
$r5 = $e_nm->range(46.759530,110.686586,50.379077,32.324924);
delta_within( $r1, 5522070.40672904, 1.0 );
delta_within( $r2, 5522.07040672904, 1.0 );
delta_within( $r3, 3431.25547224772, 1.0 );
delta_within( $r4, 18117028.893468, 1.0 );
delta_within( $r5, 2981.67948527486, 1.0 );

$r1 = $e_meter->range(70.152840,335.224848,82.259265,222.676574);
$r2 = $e_kilo->range(70.152840,335.224848,82.259265,222.676574);
$r3 = $e_mile->range(70.152840,335.224848,82.259265,222.676574);
$r4 = $e_foot->range(70.152840,335.224848,82.259265,222.676574);
$r5 = $e_nm->range(70.152840,335.224848,82.259265,222.676574);
delta_within( $r1, 2664806.26132369, 1.0 );
delta_within( $r2, 2664.80626132369, 1.0 );
delta_within( $r3, 1655.83384368022, 1.0 );
delta_within( $r4, 8742802.69463154, 1.0 );
delta_within( $r5, 1438.88027069314, 1.0 );

$r1 = $e_meter->range(-76.222244,41.464968,22.995327,26.717480);
$r2 = $e_kilo->range(-76.222244,41.464968,22.995327,26.717480);
$r3 = $e_mile->range(-76.222244,41.464968,22.995327,26.717480);
$r4 = $e_foot->range(-76.222244,41.464968,22.995327,26.717480);
$r5 = $e_nm->range(-76.222244,41.464968,22.995327,26.717480);
delta_within( $r1, 11054300.8320442, 1.0 );
delta_within( $r2, 11054.3008320442, 1.0 );
delta_within( $r3, 6868.82408735747, 1.0 );
delta_within( $r4, 36267391.1812474, 1.0 );
delta_within( $r5, 5968.84494170854, 1.0 );

$r1 = $e_meter->range(10.103669,84.844998,19.705372,336.438821);
$r2 = $e_kilo->range(10.103669,84.844998,19.705372,336.438821);
$r3 = $e_mile->range(10.103669,84.844998,19.705372,336.438821);
$r4 = $e_foot->range(10.103669,84.844998,19.705372,336.438821);
$r5 = $e_nm->range(10.103669,84.844998,19.705372,336.438821);
delta_within( $r1, 11523412.006604, 1.0 );
delta_within( $r2, 11523.412006604, 1.0 );
delta_within( $r3, 7160.31625718551, 1.0 );
delta_within( $r4, 37806469.8379395, 1.0 );
delta_within( $r5, 6222.14471198918, 1.0 );

$r1 = $e_meter->range(12.619602,206.584638,-6.260003,43.507509);
$r2 = $e_kilo->range(12.619602,206.584638,-6.260003,43.507509);
$r3 = $e_mile->range(12.619602,206.584638,-6.260003,43.507509);
$r4 = $e_foot->range(12.619602,206.584638,-6.260003,43.507509);
$r5 = $e_nm->range(12.619602,206.584638,-6.260003,43.507509);
delta_within( $r1, 18046314.1453549, 1.0 );
delta_within( $r2, 18046.3141453549, 1.0 );
delta_within( $r3, 11213.4597359886, 1.0 );
delta_within( $r4, 59207067.4060199, 1.0 );
delta_within( $r5, 9744.23010008363, 1.0 );

$r1 = $e_meter->range(-46.431748,358.501506,10.070717,310.960507);
$r2 = $e_kilo->range(-46.431748,358.501506,10.070717,310.960507);
$r3 = $e_mile->range(-46.431748,358.501506,10.070717,310.960507);
$r4 = $e_foot->range(-46.431748,358.501506,10.070717,310.960507);
$r5 = $e_nm->range(-46.431748,358.501506,10.070717,310.960507);
delta_within( $r1, 7840004.49282381, 1.0 );
delta_within( $r2, 7840.00449282381, 1.0 );
delta_within( $r3, 4871.55293885198, 1.0 );
delta_within( $r4, 25721799.5171385, 1.0 );
delta_within( $r5, 4233.26376502365, 1.0 );

$r1 = $e_meter->range(-37.466916,262.319964,56.541387,175.943954);
$r2 = $e_kilo->range(-37.466916,262.319964,56.541387,175.943954);
$r3 = $e_mile->range(-37.466916,262.319964,56.541387,175.943954);
$r4 = $e_foot->range(-37.466916,262.319964,56.541387,175.943954);
$r5 = $e_nm->range(-37.466916,262.319964,56.541387,175.943954);
delta_within( $r1, 13175801.2840537, 1.0 );
delta_within( $r2, 13175.8012840537, 1.0 );
delta_within( $r3, 8187.06335255465, 1.0 );
delta_within( $r4, 43227694.5014886, 1.0 );
delta_within( $r5, 7114.36354430546, 1.0 );

$r1 = $e_meter->range(16.376357,41.153536,-60.139286,251.664078);
$r2 = $e_kilo->range(16.376357,41.153536,-60.139286,251.664078);
$r3 = $e_mile->range(16.376357,41.153536,-60.139286,251.664078);
$r4 = $e_foot->range(16.376357,41.153536,-60.139286,251.664078);
$r5 = $e_nm->range(16.376357,41.153536,-60.139286,251.664078);
delta_within( $r1, 14563419.7032954, 1.0 );
delta_within( $r2, 14563.4197032954, 1.0 );
delta_within( $r3, 9049.28946408937, 1.0 );
delta_within( $r4, 47780248.3703919, 1.0 );
delta_within( $r5, 7863.61755037551, 1.0 );

$r1 = $e_meter->range(16.688504,317.111550,-12.125937,75.628131);
$r2 = $e_kilo->range(16.688504,317.111550,-12.125937,75.628131);
$r3 = $e_mile->range(16.688504,317.111550,-12.125937,75.628131);
$r4 = $e_foot->range(16.688504,317.111550,-12.125937,75.628131);
$r5 = $e_nm->range(16.688504,317.111550,-12.125937,75.628131);
delta_within( $r1, 13409094.6209134, 1.0 );
delta_within( $r2, 13409.0946209134, 1.0 );
delta_within( $r3, 8332.02511142016, 1.0 );
delta_within( $r4, 43993092.5882985, 1.0 );
delta_within( $r5, 7240.33186874372, 1.0 );

$r1 = $e_meter->range(-55.936936,247.119658,-49.609989,95.206424);
$r2 = $e_kilo->range(-55.936936,247.119658,-49.609989,95.206424);
$r3 = $e_mile->range(-55.936936,247.119658,-49.609989,95.206424);
$r4 = $e_foot->range(-55.936936,247.119658,-49.609989,95.206424);
$r5 = $e_nm->range(-55.936936,247.119658,-49.609989,95.206424);
delta_within( $r1, 8019595.70546293, 1.0 );
delta_within( $r2, 8019.59570546293, 1.0 );
delta_within( $r3, 4983.14574476491, 1.0 );
delta_within( $r4, 26311009.5323587, 1.0 );
delta_within( $r5, 4330.23526212901, 1.0 );

$r1 = $e_meter->range(-48.734356,177.370827,-40.864142,160.579825);
$r2 = $e_kilo->range(-48.734356,177.370827,-40.864142,160.579825);
$r3 = $e_mile->range(-48.734356,177.370827,-40.864142,160.579825);
$r4 = $e_foot->range(-48.734356,177.370827,-40.864142,160.579825);
$r5 = $e_nm->range(-48.734356,177.370827,-40.864142,160.579825);
delta_within( $r1, 1585126.11176859, 1.0 );
delta_within( $r2, 1585.12611176859, 1.0 );
delta_within( $r3, 984.951701916177, 1.0 );
delta_within( $r4, 5200544.98611741, 1.0 );
delta_within( $r5, 855.899628384767, 1.0 );

$r1 = $e_meter->range(-46.420266,107.250326,26.510982,269.915143);
$r2 = $e_kilo->range(-46.420266,107.250326,26.510982,269.915143);
$r3 = $e_mile->range(-46.420266,107.250326,26.510982,269.915143);
$r4 = $e_foot->range(-46.420266,107.250326,26.510982,269.915143);
$r5 = $e_nm->range(-46.420266,107.250326,26.510982,269.915143);
delta_within( $r1, 17322878.3638282, 1.0 );
delta_within( $r2, 17322.8783638282, 1.0 );
delta_within( $r3, 10763.9375819142, 1.0 );
delta_within( $r4, 56833590.4325071, 1.0 );
delta_within( $r5, 9353.60602798496, 1.0 );

$r1 = $e_meter->range(33.895806,153.110909,45.681845,143.422437);
$r2 = $e_kilo->range(33.895806,153.110909,45.681845,143.422437);
$r3 = $e_mile->range(33.895806,153.110909,45.681845,143.422437);
$r4 = $e_foot->range(33.895806,153.110909,45.681845,143.422437);
$r5 = $e_nm->range(33.895806,153.110909,45.681845,143.422437);
delta_within( $r1, 1546932.16434011, 1.0 );
delta_within( $r2, 1546.93216434011, 1.0 );
delta_within( $r3, 961.219083266293, 1.0 );
delta_within( $r4, 5075236.75964602, 1.0 );
delta_within( $r5, 835.276546619929, 1.0 );

$r1 = $e_meter->range(-22.177541,230.512649,5.952076,323.707746);
$r2 = $e_kilo->range(-22.177541,230.512649,5.952076,323.707746);
$r3 = $e_mile->range(-22.177541,230.512649,5.952076,323.707746);
$r4 = $e_foot->range(-22.177541,230.512649,5.952076,323.707746);
$r5 = $e_nm->range(-22.177541,230.512649,5.952076,323.707746);
delta_within( $r1, 10591953.1790129, 1.0 );
delta_within( $r2, 10591.9531790129, 1.0 );
delta_within( $r3, 6581.53457496525, 1.0 );
delta_within( $r4, 34750502.5558165, 1.0 );
delta_within( $r5, 5719.19718089248, 1.0 );

$r1 = $e_meter->range(27.348830,334.178805,-86.270375,62.080991);
$r2 = $e_kilo->range(27.348830,334.178805,-86.270375,62.080991);
$r3 = $e_mile->range(27.348830,334.178805,-86.270375,62.080991);
$r4 = $e_foot->range(27.348830,334.178805,-86.270375,62.080991);
$r5 = $e_nm->range(27.348830,334.178805,-86.270375,62.080991);
delta_within( $r1, 13006113.218666, 1.0 );
delta_within( $r2, 13006.113218666, 1.0 );
delta_within( $r3, 8081.62407705625, 1.0 );
delta_within( $r4, 42670975.126857, 1.0 );
delta_within( $r5, 7022.73931893413, 1.0 );

$r1 = $e_meter->range(25.235341,275.242036,31.035045,277.375893);
$r2 = $e_kilo->range(25.235341,275.242036,31.035045,277.375893);
$r3 = $e_mile->range(25.235341,275.242036,31.035045,277.375893);
$r4 = $e_foot->range(25.235341,275.242036,31.035045,277.375893);
$r5 = $e_nm->range(25.235341,275.242036,31.035045,277.375893);
delta_within( $r1, 676004.612711586, 1.0 );
delta_within( $r2, 676.004612711586, 1.0 );
delta_within( $r3, 420.049792158535, 1.0 );
delta_within( $r4, 2217862.90259707, 1.0 );
delta_within( $r5, 365.013289801072, 1.0 );

$r1 = $e_meter->range(44.964609,321.744934,-49.665325,229.175856);
$r2 = $e_kilo->range(44.964609,321.744934,-49.665325,229.175856);
$r3 = $e_mile->range(44.964609,321.744934,-49.665325,229.175856);
$r4 = $e_foot->range(44.964609,321.744934,-49.665325,229.175856);
$r5 = $e_nm->range(44.964609,321.744934,-49.665325,229.175856);
delta_within( $r1, 13769363.5529944, 1.0 );
delta_within( $r2, 13769.3635529944, 1.0 );
delta_within( $r3, 8555.8858472734, 1.0 );
delta_within( $r4, 45175077.2736035, 1.0 );
delta_within( $r5, 7434.86152969458, 1.0 );

$r1 = $e_meter->range(17.105270,223.789909,-23.725503,25.530801);
$r2 = $e_kilo->range(17.105270,223.789909,-23.725503,25.530801);
$r3 = $e_mile->range(17.105270,223.789909,-23.725503,25.530801);
$r4 = $e_foot->range(17.105270,223.789909,-23.725503,25.530801);
$r5 = $e_nm->range(17.105270,223.789909,-23.725503,25.530801);
delta_within( $r1, 17989959.0909754, 1.0 );
delta_within( $r2, 17989.9590909754, 1.0 );
delta_within( $r3, 11178.4423286603, 1.0 );
delta_within( $r4, 59022175.4953263, 1.0 );
delta_within( $r5, 9713.80080506233, 1.0 );

$r1 = $e_meter->range(-43.562030,130.274241,-2.881152,181.334105);
$r2 = $e_kilo->range(-43.562030,130.274241,-2.881152,181.334105);
$r3 = $e_mile->range(-43.562030,130.274241,-2.881152,181.334105);
$r4 = $e_foot->range(-43.562030,130.274241,-2.881152,181.334105);
$r5 = $e_nm->range(-43.562030,130.274241,-2.881152,181.334105);
delta_within( $r1, 6743615.83724109, 1.0 );
delta_within( $r2, 6743.61583724109, 1.0 );
delta_within( $r3, 4190.28861277706, 1.0 );
delta_within( $r4, 22124723.8754629, 1.0 );
delta_within( $r5, 3641.26125121009, 1.0 );

$r1 = $e_meter->range(-36.975702,86.458774,28.597533,323.170028);
$r2 = $e_kilo->range(-36.975702,86.458774,28.597533,323.170028);
$r3 = $e_mile->range(-36.975702,86.458774,28.597533,323.170028);
$r4 = $e_foot->range(-36.975702,86.458774,28.597533,323.170028);
$r5 = $e_nm->range(-36.975702,86.458774,28.597533,323.170028);
delta_within( $r1, 14709618.4240825, 1.0 );
delta_within( $r2, 14709.6184240825, 1.0 );
delta_within( $r3, 9140.13313752838, 1.0 );
delta_within( $r4, 48259902.9661499, 1.0 );
delta_within( $r5, 7942.55854432099, 1.0 );

$r1 = $e_meter->range(30.175209,16.459075,59.419522,205.929510);
$r2 = $e_kilo->range(30.175209,16.459075,59.419522,205.929510);
$r3 = $e_mile->range(30.175209,16.459075,59.419522,205.929510);
$r4 = $e_foot->range(30.175209,16.459075,59.419522,205.929510);
$r5 = $e_nm->range(30.175209,16.459075,59.419522,205.929510);
delta_within( $r1, 10036719.5388652, 1.0 );
delta_within( $r2, 10036.7195388652, 1.0 );
delta_within( $r3, 6236.52838601642, 1.0 );
delta_within( $r4, 32928869.8781667, 1.0 );
delta_within( $r5, 5419.39499938726, 1.0 );

$r1 = $e_meter->range(-55.644950,10.465550,-4.344329,202.739897);
$r2 = $e_kilo->range(-55.644950,10.465550,-4.344329,202.739897);
$r3 = $e_mile->range(-55.644950,10.465550,-4.344329,202.739897);
$r4 = $e_foot->range(-55.644950,10.465550,-4.344329,202.739897);
$r5 = $e_nm->range(-55.644950,10.465550,-4.344329,202.739897);
delta_within( $r1, 13260281.1799076, 1.0 );
delta_within( $r2, 13260.2811799076, 1.0 );
delta_within( $r3, 8239.55672616147, 1.0 );
delta_within( $r4, 43504859.5141326, 1.0 );
delta_within( $r5, 7159.979038827, 1.0 );

$r1 = $e_meter->range(-58.450106,219.537369,25.011231,110.301202);
$r2 = $e_kilo->range(-58.450106,219.537369,25.011231,110.301202);
$r3 = $e_mile->range(-58.450106,219.537369,25.011231,110.301202);
$r4 = $e_foot->range(-58.450106,219.537369,25.011231,110.301202);
$r5 = $e_nm->range(-58.450106,219.537369,25.011231,110.301202);
delta_within( $r1, 13454859.3055112, 1.0 );
delta_within( $r2, 13454.8593055112, 1.0 );
delta_within( $r3, 8360.46196805106, 1.0 );
delta_within( $r4, 44143239.1913096, 1.0 );
delta_within( $r5, 7265.04282155031, 1.0 );

$r1 = $e_meter->range(80.393984,275.211192,23.935568,24.731901);
$r2 = $e_kilo->range(80.393984,275.211192,23.935568,24.731901);
$r3 = $e_mile->range(80.393984,275.211192,23.935568,24.731901);
$r4 = $e_foot->range(80.393984,275.211192,23.935568,24.731901);
$r5 = $e_nm->range(80.393984,275.211192,23.935568,24.731901);
delta_within( $r1, 7745665.22175974, 1.0 );
delta_within( $r2, 7745.66522175974, 1.0 );
delta_within( $r3, 4812.9332335161, 1.0 );
delta_within( $r4, 25412287.472965, 1.0 );
delta_within( $r5, 4182.32463377956, 1.0 );

$r1 = $e_meter->range(-65.005040,272.050479,-3.463969,257.290127);
$r2 = $e_kilo->range(-65.005040,272.050479,-3.463969,257.290127);
$r3 = $e_mile->range(-65.005040,272.050479,-3.463969,257.290127);
$r4 = $e_foot->range(-65.005040,272.050479,-3.463969,257.290127);
$r5 = $e_nm->range(-65.005040,272.050479,-3.463969,257.290127);
delta_within( $r1, 6929926.85789333, 1.0 );
delta_within( $r2, 6929.92685789333, 1.0 );
delta_within( $r3, 4306.0569138067, 1.0 );
delta_within( $r4, 22735980.5048994, 1.0 );
delta_within( $r5, 3741.86115437005, 1.0 );

$r1 = $e_meter->range(-67.713271,230.359203,-17.890516,254.265464);
$r2 = $e_kilo->range(-67.713271,230.359203,-17.890516,254.265464);
$r3 = $e_mile->range(-67.713271,230.359203,-17.890516,254.265464);
$r4 = $e_foot->range(-67.713271,230.359203,-17.890516,254.265464);
$r5 = $e_nm->range(-67.713271,230.359203,-17.890516,254.265464);
delta_within( $r1, 5790460.28705559, 1.0 );
delta_within( $r2, 5790.46028705559, 1.0 );
delta_within( $r3, 3598.02521217067, 1.0 );
delta_within( $r4, 18997573.1202611, 1.0 );
delta_within( $r5, 3126.59842713585, 1.0 );

$r1 = $e_meter->range(49.977476,253.413450,-40.736808,280.971459);
$r2 = $e_kilo->range(49.977476,253.413450,-40.736808,280.971459);
$r3 = $e_mile->range(49.977476,253.413450,-40.736808,280.971459);
$r4 = $e_foot->range(49.977476,253.413450,-40.736808,280.971459);
$r5 = $e_nm->range(49.977476,253.413450,-40.736808,280.971459);
delta_within( $r1, 10404674.0369978, 1.0 );
delta_within( $r2, 10404.6740369978, 1.0 );
delta_within( $r3, 6465.16471121013, 1.0 );
delta_within( $r4, 34136069.6751895, 1.0 );
delta_within( $r5, 5618.07453401607, 1.0 );

$r1 = $e_meter->range(-64.390959,100.137796,-73.699237,76.773535);
$r2 = $e_kilo->range(-64.390959,100.137796,-73.699237,76.773535);
$r3 = $e_mile->range(-64.390959,100.137796,-73.699237,76.773535);
$r4 = $e_foot->range(-64.390959,100.137796,-73.699237,76.773535);
$r5 = $e_nm->range(-64.390959,100.137796,-73.699237,76.773535);
delta_within( $r1, 1377371.39603648, 1.0 );
delta_within( $r2, 1377.37139603649, 1.0 );
delta_within( $r3, 855.858906508792, 1.0 );
delta_within( $r4, 4518935.02636642, 1.0 );
delta_within( $r5, 743.721056175208, 1.0 );

$r1 = $e_meter->range(-53.488147,222.676284,18.783198,197.750208);
$r2 = $e_kilo->range(-53.488147,222.676284,18.783198,197.750208);
$r3 = $e_mile->range(-53.488147,222.676284,18.783198,197.750208);
$r4 = $e_foot->range(-53.488147,222.676284,18.783198,197.750208);
$r5 = $e_nm->range(-53.488147,222.676284,18.783198,197.750208);
delta_within( $r1, 8357066.17548392, 1.0 );
delta_within( $r2, 8357.06617548392, 1.0 );
delta_within( $r3, 5192.84017306674, 1.0 );
delta_within( $r4, 27418196.1137924, 1.0 );
delta_within( $r5, 4512.45473838225, 1.0 );

$r1 = $e_meter->range(11.886353,45.880034,-75.325990,317.821511);
$r2 = $e_kilo->range(11.886353,45.880034,-75.325990,317.821511);
$r3 = $e_mile->range(11.886353,45.880034,-75.325990,317.821511);
$r4 = $e_foot->range(11.886353,45.880034,-75.325990,317.821511);
$r5 = $e_nm->range(11.886353,45.880034,-75.325990,317.821511);
delta_within( $r1, 11219022.8120392, 1.0 );
delta_within( $r2, 11219.0228120392, 1.0 );
delta_within( $r3, 6971.17758045464, 1.0 );
delta_within( $r4, 36807817.6248005, 1.0 );
delta_within( $r5, 6057.78769548552, 1.0 );

$r1 = $e_meter->range(-61.023376,203.548199,-32.274576,120.526333);
$r2 = $e_kilo->range(-61.023376,203.548199,-32.274576,120.526333);
$r3 = $e_mile->range(-61.023376,203.548199,-32.274576,120.526333);
$r4 = $e_foot->range(-61.023376,203.548199,-32.274576,120.526333);
$r5 = $e_nm->range(-61.023376,203.548199,-32.274576,120.526333);
delta_within( $r1, 6560175.49592739, 1.0 );
delta_within( $r2, 6560.17549592739, 1.0 );
delta_within( $r3, 4076.30406919055, 1.0 );
delta_within( $r4, 21522885.4853261, 1.0 );
delta_within( $r5, 3542.21139088952, 1.0 );

$r1 = $e_meter->range(-51.815775,243.103403,-81.006002,15.254084);
$r2 = $e_kilo->range(-51.815775,243.103403,-81.006002,15.254084);
$r3 = $e_mile->range(-51.815775,243.103403,-81.006002,15.254084);
$r4 = $e_foot->range(-51.815775,243.103403,-81.006002,15.254084);
$r5 = $e_nm->range(-51.815775,243.103403,-81.006002,15.254084);
delta_within( $r1, 4980459.53607217, 1.0 );
delta_within( $r2, 4980.45953607217, 1.0 );
delta_within( $r3, 3094.71407981896, 1.0 );
delta_within( $r4, 16340090.3414441, 1.0 );
delta_within( $r5, 2689.23301083811, 1.0 );

$r1 = $e_meter->range(55.609307,24.137667,36.573196,147.424699);
$r2 = $e_kilo->range(55.609307,24.137667,36.573196,147.424699);
$r3 = $e_mile->range(55.609307,24.137667,36.573196,147.424699);
$r4 = $e_foot->range(55.609307,24.137667,36.573196,147.424699);
$r5 = $e_nm->range(55.609307,24.137667,36.573196,147.424699);
delta_within( $r1, 8467114.65823862, 1.0 );
delta_within( $r2, 8467.11465823862, 1.0 );
delta_within( $r3, 5261.22112999994, 1.0 );
delta_within( $r4, 27779247.5663997, 1.0 );
delta_within( $r5, 4571.87616535563, 1.0 );

$r1 = $e_meter->range(68.261410,337.404883,-87.468266,126.278650);
$r2 = $e_kilo->range(68.261410,337.404883,-87.468266,126.278650);
$r3 = $e_mile->range(68.261410,337.404883,-87.468266,126.278650);
$r4 = $e_foot->range(68.261410,337.404883,-87.468266,126.278650);
$r5 = $e_nm->range(68.261410,337.404883,-87.468266,126.278650);
delta_within( $r1, 17814444.0832232, 1.0 );
delta_within( $r2, 17814.4440832232, 1.0 );
delta_within( $r3, 11069.3823590377, 1.0 );
delta_within( $r4, 58446338.8557192, 1.0 );
delta_within( $r5, 9619.03028251793, 1.0 );

$r1 = $e_meter->range(77.163243,355.929440,-24.865636,351.624329);
$r2 = $e_kilo->range(77.163243,355.929440,-24.865636,351.624329);
$r3 = $e_mile->range(77.163243,355.929440,-24.865636,351.624329);
$r4 = $e_foot->range(77.163243,355.929440,-24.865636,351.624329);
$r5 = $e_nm->range(77.163243,355.929440,-24.865636,351.624329);
delta_within( $r1, 11323314.1064423, 1.0 );
delta_within( $r2, 11323.3141064423, 1.0 );
delta_within( $r3, 7035.98118639788, 1.0 );
delta_within( $r4, 37149980.6641808, 1.0 );
delta_within( $r5, 6114.10048943969, 1.0 );

$r1 = $e_meter->range(-83.363412,123.109687,60.930467,157.757983);
$r2 = $e_kilo->range(-83.363412,123.109687,60.930467,157.757983);
$r3 = $e_mile->range(-83.363412,123.109687,60.930467,157.757983);
$r4 = $e_foot->range(-83.363412,123.109687,60.930467,157.757983);
$r5 = $e_nm->range(-83.363412,123.109687,60.930467,157.757983);
delta_within( $r1, 16129090.5382028, 1.0 );
delta_within( $r2, 16129.0905382028, 1.0 );
delta_within( $r3, 10022.152217427, 1.0 );
delta_within( $r4, 52916963.7080145, 1.0 );
delta_within( $r5, 8709.01216965595, 1.0 );

$r1 = $e_meter->range(35.819668,205.275583,-69.790147,65.110415);
$r2 = $e_kilo->range(35.819668,205.275583,-69.790147,65.110415);
$r3 = $e_mile->range(35.819668,205.275583,-69.790147,65.110415);
$r4 = $e_foot->range(35.819668,205.275583,-69.790147,65.110415);
$r5 = $e_nm->range(35.819668,205.275583,-69.790147,65.110415);
delta_within( $r1, 15535352.6980755, 1.0 );
delta_within( $r2, 15535.3526980755, 1.0 );
delta_within( $r3, 9653.22062783065, 1.0 );
delta_within( $r4, 50969004.9149458, 1.0 );
delta_within( $r5, 8388.41938341009, 1.0 );

$r1 = $e_meter->range(-45.720757,245.961448,85.378805,184.898940);
$r2 = $e_kilo->range(-45.720757,245.961448,85.378805,184.898940);
$r3 = $e_mile->range(-45.720757,245.961448,85.378805,184.898940);
$r4 = $e_foot->range(-45.720757,245.961448,85.378805,184.898940);
$r5 = $e_nm->range(-45.720757,245.961448,85.378805,184.898940);
delta_within( $r1, 14801887.1990009, 1.0 );
delta_within( $r2, 14801.8871990009, 1.0 );
delta_within( $r3, 9197.46629620569, 1.0 );
delta_within( $r4, 48562622.0439661, 1.0 );
delta_within( $r5, 7992.3796970847, 1.0 );

$r1 = $e_meter->range(70.557651,168.120919,-4.512946,146.711647);
$r2 = $e_kilo->range(70.557651,168.120919,-4.512946,146.711647);
$r3 = $e_mile->range(70.557651,168.120919,-4.512946,146.711647);
$r4 = $e_foot->range(70.557651,168.120919,-4.512946,146.711647);
$r5 = $e_nm->range(70.557651,168.120919,-4.512946,146.711647);
delta_within( $r1, 8481627.39707062, 1.0 );
delta_within( $r2, 8481.62739707062, 1.0 );
delta_within( $r3, 5270.23892783061, 1.0 );
delta_within( $r4, 27826861.5389456, 1.0 );
delta_within( $r5, 4579.71241742474, 1.0 );

$r1 = $e_meter->range(45.494490,42.178744,-62.327500,251.688039);
$r2 = $e_kilo->range(45.494490,42.178744,-62.327500,251.688039);
$r3 = $e_mile->range(45.494490,42.178744,-62.327500,251.688039);
$r4 = $e_foot->range(45.494490,42.178744,-62.327500,251.688039);
$r5 = $e_nm->range(45.494490,42.178744,-62.327500,251.688039);
delta_within( $r1, 17356605.1087735, 1.0 );
delta_within( $r2, 17356.6051087735, 1.0 );
delta_within( $r3, 10784.8944096312, 1.0 );
delta_within( $r4, 56944242.4828528, 1.0 );
delta_within( $r5, 9371.81701337664, 1.0 );

