# Module for locating marpaWrapper, based on ICU module.
#
# Cutomizable variables:
#   MARPAWRAPPER_ROOT_DIR
#     This variable points to the marpaWrapper root directory. On Windows the
#     library location typically will have to be provided explicitly using the
#     -D command-line option. Alternatively, an environment variable can be set.
#
# Read-Only variables:
#   MARPAWRAPPER_FOUND
#     Indicates whether the library has been found.
#
#   MARPAWRAPPER_INCLUDE_DIRS
#     Points to the marpaWrapper include directory.
#
#   MARPAWRAPPER_LIBRARIES
#     Points to the marpaWrapper libraries that should be passed to
#     target_link_libraries in dynamic mode.
#
#   MARPAWRAPPER_LIBRARIES_STATIC
#     Points to the marpaWrapper libraries static that should be passed to
#     target_link_libraries in static mode.
#
#   MARPAWRAPPER_LINK_FLAGS
#     Linker flags when building linking against marpaWrapper. Defaults to "libmarpaWrapper". Take care, this is a list.
#
#   MARPAWRAPPER_STATIC_LINK_FLAGS
#     Linker flags when building linking against static marpaWrapper. Defaults to "libmarpaWrapper_static". Take care, this is a list.
#
#   MARPAWRAPPER_LDFLAGS
#     Stringified version of MARPAWRAPPER_LINK_FLAGS
#
#   MARPAWRAPPER_STATIC_LDFLAGS
#     Stringified version of MARPAWRAPPER_STATIC_LINK_FLAGS
#
INCLUDE (CMakeParseArguments)
INCLUDE (FindPackageHandleStandardArgs)

SET (_PF86 "ProgramFiles(x86)")
SET (_MARPAWRAPPER_POSSIBLE_DIRS
  ${MARPAWRAPPER_ROOT_DIR}
  "$ENV{MARPAWRAPPER_ROOT_DIR}"
  "C:/marpaWrapper"
  "$ENV{PROGRAMFILES}/marpaWrapper"
  "$ENV{${_PF86}}/marpaWrapper")

SET (_MARPAWRAPPER_POSSIBLE_INCLUDE_SUFFIXES include)

IF (CMAKE_SIZEOF_VOID_P EQUAL 8)
  SET (_MARPAWRAPPER_POSSIBLE_LIB_SUFFIXES lib64)
  SET (_MARPAWRAPPER_POSSIBLE_BIN_SUFFIXES bin64)

  IF (NOT WIN32)
    LIST (APPEND _MARPAWRAPPER_POSSIBLE_LIB_SUFFIXES lib)
    LIST (APPEND _MARPAWRAPPER_POSSIBLE_BIN_SUFFIXES bin)
  ENDIF (NOT WIN32)
ELSE (CMAKE_SIZEOF_VOID_P EQUAL 8)
  SET (_MARPAWRAPPER_POSSIBLE_LIB_SUFFIXES lib)
  SET (_MARPAWRAPPER_POSSIBLE_BIN_SUFFIXES bin)
ENDIF (CMAKE_SIZEOF_VOID_P EQUAL 8)

FIND_PATH (MARPAWRAPPER_ROOT_DIR
  NAMES include/marpaWrapper.h
  PATHS ${_MARPAWRAPPER_POSSIBLE_DIRS}
  DOC "marpaWrapper root directory")

IF (MARPAWRAPPER_ROOT_DIR)
  # Re-use the previous path:
  FIND_PATH (MARPAWRAPPER_INCLUDE_DIR
    NAMES marpaWrapper.h
    PATHS ${MARPAWRAPPER_ROOT_DIR}
    PATH_SUFFIXES ${_MARPAWRAPPER_POSSIBLE_INCLUDE_SUFFIXES}
    DOC "marpaWrapper include directory"
    # NO_DEFAULT_PATH
    )
ELSE (MARPAWRAPPER_ROOT_DIR)
  # Use default path search
  FIND_PATH (MARPAWRAPPER_INCLUDE_DIR
    NAMES marpaWrapper.h
    DOC "marpaWrapper include directory"
    )
ENDIF (MARPAWRAPPER_ROOT_DIR)

IF (NOT MARPAWRAPPER_FIND_COMPONENTS)
  SET (MARPAWRAPPER_FIND_COMPONENTS marpaWrapper)
ENDIF (NOT MARPAWRAPPER_FIND_COMPONENTS)

IF (MARPAWRAPPER_INCLUDE_DIR)
  # Loop over each components
  FOREACH (_MARPAWRAPPER_COMPONENT ${MARPAWRAPPER_FIND_COMPONENTS})
    SET (_MARPAWRAPPER_COMPONENT_BASE ${_MARPAWRAPPER_COMPONENT})
    SET (_MARPAWRAPPER_COMPONENT_POSSIBLE_DEBUG_NAMES ${_MARPAWRAPPER_COMPONENT_BASE}d)
    SET (_MARPAWRAPPER_COMPONENT_POSSIBLE_RELEASE_NAMES ${_MARPAWRAPPER_COMPONENT_BASE})

    SET (_MARPAWRAPPER_STATIC_COMPONENT_BASE "${_MARPAWRAPPER_COMPONENT}_static")
    SET (_MARPAWRAPPER_STATIC_COMPONENT_POSSIBLE_DEBUG_NAMES ${_MARPAWRAPPER_STATIC_COMPONENT_BASE}d)
    SET (_MARPAWRAPPER_STATIC_COMPONENT_POSSIBLE_RELEASE_NAMES ${_MARPAWRAPPER_STATIC_COMPONENT_BASE})

    STRING (TOUPPER ${_MARPAWRAPPER_COMPONENT} _MARPAWRAPPER_COMPONENT_UPPER)
    SET (_MARPAWRAPPER_LIBRARY_BASE MARPAWRAPPER_${_MARPAWRAPPER_COMPONENT_UPPER}_LIBRARY)
    SET (_MARPAWRAPPER_STATIC_LIBRARY_BASE MARPAWRAPPER_STATIC_${_MARPAWRAPPER_COMPONENT_UPPER}_LIBRARY)

    IF (MARPAWRAPPER_ROOT_DIR)
      FIND_LIBRARY (${_MARPAWRAPPER_LIBRARY_BASE}_DEBUG
	NAMES ${_MARPAWRAPPER_COMPONENT_POSSIBLE_DEBUG_NAMES}
	PATHS ${MARPAWRAPPER_ROOT_DIR} PATH_SUFFIXES ${_MARPAWRAPPER_POSSIBLE_LIB_SUFFIXES}
	# NO_DEFAULT_PATH
	)
      FIND_LIBRARY (${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_DEBUG
	NAMES ${_MARPAWRAPPER_STATIC_COMPONENT_POSSIBLE_DEBUG_NAMES}
	PATHS ${MARPAWRAPPER_ROOT_DIR} PATH_SUFFIXES ${_MARPAWRAPPER_POSSIBLE_LIB_SUFFIXES}
	# NO_DEFAULT_PATH
	)
    ELSE (MARPAWRAPPER_ROOT_DIR)
      FIND_LIBRARY (${_MARPAWRAPPER_LIBRARY_BASE}_DEBUG
	NAMES ${_MARPAWRAPPER_COMPONENT_POSSIBLE_DEBUG_NAMES}
	PATH_SUFFIXES ${_MARPAWRAPPER_POSSIBLE_LIB_SUFFIXES}
	)
      FIND_LIBRARY (${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_DEBUG
	NAMES ${_MARPAWRAPPER_COMPONENT_STATIC_POSSIBLE_DEBUG_NAMES}
	PATH_SUFFIXES ${_MARPAWRAPPER_POSSIBLE_LIB_SUFFIXES}
	)
    ENDIF (MARPAWRAPPER_ROOT_DIR)

    IF (MARPAWRAPPER_ROOT_DIR)
      FIND_LIBRARY (${_MARPAWRAPPER_LIBRARY_BASE}_RELEASE
	NAMES ${_MARPAWRAPPER_COMPONENT_POSSIBLE_RELEASE_NAMES}
	PATHS ${MARPAWRAPPER_ROOT_DIR} PATH_SUFFIXES ${_MARPAWRAPPER_POSSIBLE_LIB_SUFFIXES}
	# NO_DEFAULT_PATH
	)
      FIND_LIBRARY (${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_RELEASE
	NAMES ${_MARPAWRAPPER_STATIC_COMPONENT_POSSIBLE_RELEASE_NAMES}
	PATHS ${MARPAWRAPPER_ROOT_DIR} PATH_SUFFIXES ${_MARPAWRAPPER_POSSIBLE_LIB_SUFFIXES}
	# NO_DEFAULT_PATH
	)
    ELSE (ICU_ROOT_DIR)
      FIND_LIBRARY (${_MARPAWRAPPER_LIBRARY_BASE}_RELEASE
	NAMES ${_MARPAWRAPPER_COMPONENT_POSSIBLE_RELEASE_NAMES}
	PATH_SUFFIXES ${_MARPAWRAPPER_POSSIBLE_LIB_SUFFIXES}
	)
      FIND_LIBRARY (${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_RELEASE
	NAMES ${_MARPAWRAPPER_STATIC_COMPONENT_POSSIBLE_RELEASE_NAMES}
	PATH_SUFFIXES ${_MARPAWRAPPER_POSSIBLE_LIB_SUFFIXES}
	)
    ENDIF (MARPAWRAPPER_ROOT_DIR)

    SET (MARPAWRAPPER_${_MARPAWRAPPER_COMPONENT_UPPER}_FOUND TRUE)

    # Debug and release
    IF (${_MARPAWRAPPER_LIBRARY_BASE}_DEBUG AND ${_MARPAWRAPPER_LIBRARY_BASE}_RELEASE)
      SET (${_MARPAWRAPPER_LIBRARY_BASE}
        debug ${${_MARPAWRAPPER_LIBRARY_BASE}_DEBUG}
        optimized ${${_MARPAWRAPPER_LIBRARY_BASE}_RELEASE})
      # Debug only
    ELSEIF (${_MARPAWRAPPER_LIBRARY_BASE}_DEBUG)
      SET (${_MARPAWRAPPER_LIBRARY_BASE} ${${_MARPAWRAPPER_LIBRARY_BASE}_DEBUG})
      # Release only
    ELSEIF (${_MARPAWRAPPER_LIBRARY_BASE}_RELEASE)
      SET (${_MARPAWRAPPER_LIBRARY_BASE} ${${_MARPAWRAPPER_LIBRARY_BASE}_RELEASE})
    ELSE (${_MARPAWRAPPER_LIBRARY_BASE}_DEBUG AND ${_MARPAWRAPPER_LIBRARY_BASE}_RELEASE)
      # Component missing: record it for a later report
      LIST (APPEND _MARPAWRAPPER_MISSING_COMPONENTS ${_MARPAWRAPPER_COMPONENT})
      SET (MARPAWRAPPER_${__COMPONENT_UPPER}_FOUND FALSE)
    ENDIF (${_MARPAWRAPPER_LIBRARY_BASE}_DEBUG AND ${_MARPAWRAPPER_LIBRARY_BASE}_RELEASE)

    IF (${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_DEBUG AND ${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_RELEASE)
      SET (${_MARPAWRAPPER_STATIC_LIBRARY_BASE}
        debug ${${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_DEBUG}
        optimized ${${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_RELEASE})
      # Debug only
    ELSEIF (${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_DEBUG)
      SET (${_MARPAWRAPPER_STATIC_LIBRARY_BASE} ${${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_DEBUG})
      # Release only
    ELSEIF (${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_RELEASE)
      SET (${_MARPAWRAPPER_STATIC_LIBRARY_BASE} ${${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_RELEASE})
    ELSE (${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_DEBUG AND ${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_RELEASE)
      # Component missing: record it for a later report
      LIST (APPEND _MARPAWRAPPER_STATIC_MISSING_COMPONENTS ${_MARPAWRAPPER_COMPONENT})
      SET (MARPAWRAPPER_STATIC_${__COMPONENT_UPPER}_FOUND FALSE)
    ENDIF (${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_DEBUG AND ${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_RELEASE)

    MARK_AS_ADVANCED (${_MARPAWRAPPER_LIBRARY_BASE}_DEBUG ${_MARPAWRAPPER_LIBRARY_BASE}_RELEASE)
    MARK_AS_ADVANCED (${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_DEBUG ${_MARPAWRAPPER_STATIC_LIBRARY_BASE}_RELEASE)

    # Make sure only libraries that have been actually found are registered
    IF (${_MARPAWRAPPER_LIBRARY_BASE})
      LIST (APPEND _MARPAWRAPPER_LIBRARIES ${${_MARPAWRAPPER_LIBRARY_BASE}})
    ENDIF (${_MARPAWRAPPER_LIBRARY_BASE})

    IF (${_MARPAWRAPPER_STATIC_LIBRARY_BASE})
      LIST (APPEND _MARPAWRAPPER_STATIC_LIBRARIES ${${_MARPAWRAPPER_STATIC_LIBRARY_BASE}})
    ENDIF (${_MARPAWRAPPER_STATIC_LIBRARY_BASE})

  ENDFOREACH (_MARPAWRAPPER_COMPONENT)

  IF (NOT DEFINED _MARPAWRAPPER_MISSING_COMPONENTS AND NOT DEFINED _MARPAWRAPPER_STATIC_MISSING_COMPONENTS)
    # Success: all components were found
    SET (MARPAWRAPPER_INCLUDE_DIRS "${MARPAWRAPPER_INCLUDE_DIR}")
    SET (MARPAWRAPPER_LIBRARIES ${_MARPAWRAPPER_LIBRARIES})
    SET (MARPAWRAPPER_STATIC_LIBRARIES ${_MARPAWRAPPER_STATIC_LIBRARIES})
  ELSE ()
    MESSAGE (STATUS "Several MARPAWRAPPER components were not found:")

    # Display missing components indented, each on a separate line
    FOREACH (_MARPAWRAPPER_MISSING_COMPONENT ${_MARPAWRAPPER_MISSING_COMPONENTS})
      MESSAGE (STATUS "  " ${_MARPAWRAPPER_MISSING_COMPONENT})
    ENDFOREACH ()
    FOREACH (_MARPAWRAPPER_STATIC_MISSING_COMPONENT ${_MARPAWRAPPER_STATIC_MISSING_COMPONENTS})
      MESSAGE (STATUS "  " ${_MARPAWRAPPER_STATIC_MISSING_COMPONENT})
    ENDFOREACH ()
  ENDIF ()

  #
  # Simulate hopefully correct flags based on heuristic discovery
  #
  IF (NOT _MARPAWRAPPER_C_FLAGS_SHARED)
    SET (_MARPAWRAPPER_C_FLAGS_SHARED "${CMAKE_SHARED_LIBRARY_C_FLAGS}")
  ENDIF ()

  IF (NOT _MARPAWRAPPER_CXX_FLAGS_SHARED)
    SET (_MARPAWRAPPER_CXX_FLAGS_SHARED "${CMAKE_SHARED_LIBRARY_CXX_FLAGS}")
  ENDIF ()

  IF (NOT _MARPAWRAPPER_LINK_FLAGS)
    SET (_MARPAWRAPPER_LINK_FLAGS ${MARPAWRAPPER_LIBRARIES})
  ENDIF ()

  IF (NOT _MARPAWRAPPER_STATIC_LINK_FLAGS)
    SET (_MARPAWRAPPER_STATIC_LINK_FLAGS ${MARPAWRAPPER_STATIC_LIBRARIES})
  ENDIF ()

ENDIF (MARPAWRAPPER_INCLUDE_DIR)

SET (_MARPAWRAPPER_LDFLAGS " ")
FOREACH (_marpawrapper_link_flag ${_MARPAWRAPPER_LINK_FLAGS})
  SET (_MARPAWRAPPER_LDFLAGS "${_MARPAWRAPPER_LDFLAGS} ${_marpawrapper_link_flag}")
ENDFOREACH ()

SET (_MARPAWRAPPER_STATIC_LDFLAGS " ")
FOREACH (_marpawrapper_static_link_flag ${_MARPAWRAPPER_STATIC_LINK_FLAGS})
  SET (_MARPAWRAPPER_STATIC_LDFLAGS "${_MARPAWRAPPER_STATIC_LDFLAGS} ${_marpawrapper_static_link_flag}")
ENDFOREACH ()

MARK_AS_ADVANCED (MARPAWRAPPER_ROOT_DIR MARPAWRAPPER_INCLUDE_DIR)

FIND_PACKAGE_HANDLE_STANDARD_ARGS (MARPAWRAPPER
  REQUIRED_VARS
  MARPAWRAPPER_INCLUDE_DIR
  MARPAWRAPPER_LIBRARIES)

IF (_MARPAWRAPPER_LINK_FLAGS AND _MARPAWRAPPER_STATIC_LINK_FLAGS)
  SET (MARPAWRAPPER_FOUND 1 CACHE STRING "MARPAWRAPPER is found")
ENDIF ()

SET (MARPAWRAPPER_C_FLAGS_SHARED    "${_MARPAWRAPPER_C_FLAGS_SHARED}"    CACHE STRING "C flags when compiling against shared MARPAWRAPPER")
SET (MARPAWRAPPER_CXX_FLAGS_SHARED  "${_MARPAWRAPPER_CXX_FLAGS_SHARED}"  CACHE STRING "C flags when compiling against shared MARPAWRAPPER")
SET (MARPAWRAPPER_LINK_FLAGS        "${_MARPAWRAPPER_LINK_FLAGS}"        CACHE STRING "Linker flags when linking against MARPAWRAPPER")
SET (MARPAWRAPPER_LDFLAGS           "${_MARPAWRAPPER_LDFLAGS}"           CACHE STRING "Stringified version of MARPAWRAPPER_LINK_FLAGS")
SET (MARPAWRAPPER_STATIC_LINK_FLAGS "${_MARPAWRAPPER_STATIC_LINK_FLAGS}" CACHE STRING "Linker flags when linking against static MARPAWRAPPER")
SET (MARPAWRAPPER_STATIC_LDFLAGS    "${_MARPAWRAPPER_STATIC_LDFLAGS}"    CACHE STRING "Stringified version of MARPAWRAPPER_STATIC_LINK_FLAGS")

IF(MARPAWRAPPER_FOUND)
  MESSAGE(STATUS "-----------------------------------------")
  MESSAGE(STATUS "Setup MARPAWRAPPER:")
  MESSAGE(STATUS "")
  MESSAGE(STATUS "           ROOT_DIR: ${MARPAWRAPPER_ROOT_DIR}")
  MESSAGE(STATUS "     C_FLAGS_SHARED: ${MARPAWRAPPER_C_FLAGS_SHARED}")
  MESSAGE(STATUS "   CXX_FLAGS_SHARED: ${MARPAWRAPPER_CXX_FLAGS_SHARED}")
  MESSAGE(STATUS "        INCLUDE_DIR: ${MARPAWRAPPER_INCLUDE_DIR}")
  MESSAGE(STATUS "          LIBRARIES: ${MARPAWRAPPER_LIBRARIES}")
  MESSAGE(STATUS "   STATIC LIBRARIES: ${MARPAWRAPPER_STATIC_LIBRARIES}")
  MESSAGE(STATUS "         LINK_FLAGS: ${MARPAWRAPPER_LINK_FLAGS}")
  MESSAGE(STATUS "  STATIC LINK_FLAGS: ${MARPAWRAPPER_STATIC_LINK_FLAGS}")
  MESSAGE(STATUS "            LDFLAGS: ${MARPAWRAPPER_LDFLAGS}")
  MESSAGE(STATUS "     STATIC LDFLAGS: ${MARPAWRAPPER_STATIC_LDFLAGS}")
  MESSAGE(STATUS "-----------------------------------------")
ENDIF()

MARK_AS_ADVANCED (
  MARPAWRAPPER_FOUND
  MARPAWRAPPER_C_FLAGS_SHARED
  MARPAWRAPPER_CXX_FLAGS_SHARED
  MARPAWRAPPER_LINK_FLAGS
  MARPAWRAPPER_LDFLAGS
  MARPAWRAPPER_STATIC_LINK_FLAGS
  MARPAWRAPPER_STATIC_LDFLAGS
  )
