package CGI::Kwiki::New;
$VERSION = '0.10';
use strict;
use Config;
use File::Path;

sub new {
    my ($class, $subclass) = @_;
    my $self;
    if (defined $subclass) {
        my $full_subclass = "CGI::Kwiki::New::$subclass";
        eval qq{ require $full_subclass }; die $@ if $@;
        $self = $full_subclass->new;
    }
    else {
        $self = bless {}, $class;
    }
    return $self;
}

sub create_kwiki {
    my ($self) = @_;
    $self->create_config_file;
    $self->create_database;
    $self->create_cgi;
    $self->create_pages;
    print "Kwiki software installed! Point your browser at this location.\n";
}

sub create_config_file {
    my ($self) = @_;
    my $class = ref $self;
    my $date = localtime;
    my $config_file = 'config.yaml';
    return if -e $config_file;
    open CONFIG, '>', $config_file;
    print CONFIG <<CONFIG;
# Kwiki Configuration File originally generated by $class
# on $date
# 
# This config file uses the YAML data format. (http://www.yaml.org)
#
config_class:    CGI::Kwiki::Config
driver_class:    CGI::Kwiki::Driver
cgi_class:       CGI::Kwiki::CGI
database_class:  CGI::Kwiki::Database
display_class:   CGI::Kwiki::Display
edit_class:      CGI::Kwiki::Edit
formatter_class: CGI::Kwiki::Formatter
template_class:  CGI::Kwiki::Template
search_class:    CGI::Kwiki::Search
changes_class:   CGI::Kwiki::Changes
prefs_class:     CGI::Kwiki::Prefs
pages_class:     CGI::Kwiki::Pages

top_page:      HomePage
kwiki_image:
title_prefix:  A Kwiki

CONFIG
    close CONFIG;
}

sub create_database {
    my ($self) = @_;
    my $database = 'database';
    return if -d $database;
    umask 0000;
    mkdir $database, 0777;
}

sub create_cgi {
    my ($self) = @_;
    unlink('index.cgi');
    require File::Copy;
    File::Copy::copy($0, 'index.cgi')
      or die "Can't copy $0 to ./index.cgi\n";
    umask 0000;
    chmod(0755, 'index.cgi') or die $!;
}

sub create_pages {
    my ($self) = @_;
    require CGI::Kwiki::Config;
    my $config = CGI::Kwiki::Config->new;
    my $driver_class = $config->driver_class
      or die "driver_class not defined in configuration";
    eval qq{ require $driver_class }; die $@ if $@;
    my $driver = $driver_class->new($config);
    $driver->load_class('pages');
    $driver->pages->default_pages;
}
    
1;

=head1 NAME 

CGI::Kwiki::New - Default New Wiki Generator for CGI::Kwiki

=head1 DESCRIPTION

See installed kwiki pages for more information.

=head1 AUTHOR

Brian Ingerson <INGY@cpan.org>

=head1 COPYRIGHT

Copyright (c) 2003. Brian Ingerson. All rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

See http://www.perl.com/perl/misc/Artistic.html

=cut
