
use strict;
use warnings;

use 5.006;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Framework for building portable, auto-validating and self-documenting APIs",
  "AUTHOR" => "Ido Perlmuter <ido\@ido50.net>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "McBain",
  "EXE_FILES" => [
    "bin/mcbain2pod"
  ],
  "LICENSE" => "perl",
  "NAME" => "McBain",
  "PREREQ_PM" => {
    "Brannigan" => 0,
    "Carp" => 0,
    "File::Spec" => 0,
    "Getopt::Compact" => 0,
    "IO::Handle" => 0,
    "Module::Load" => 0,
    "Scalar::Util" => 0,
    "Try::Tiny" => 0,
    "parent" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Test::Exception" => 0,
    "Test::More" => 0,
    "lib" => 0
  },
  "VERSION" => "1.000000",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Brannigan" => 0,
  "Carp" => 0,
  "File::Spec" => 0,
  "Getopt::Compact" => 0,
  "IO::Handle" => 0,
  "Module::Load" => 0,
  "Scalar::Util" => 0,
  "Test::Exception" => 0,
  "Test::More" => 0,
  "Try::Tiny" => 0,
  "lib" => 0,
  "parent" => 0,
  "strict" => 0,
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



