/*
 * Decompiled with CFR 0.152.
 */
package cybervillains.ca;

import cybervillains.ca.KeyStoreManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.x509.X509V2CRLGenerator;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;

public class Generator {
    private static final String NEW_CERTS_DIR_NAME = "new_certs";
    private static final String OPENSSL_CMD_DEC_TO_PEM = "openssl crl -inform der -in new_certs/blank_crl.dec -out new_certs/blank_crl.pem";

    public static void main(String[] args) {
        File newCertsDir = new File(NEW_CERTS_DIR_NAME);
        newCertsDir.mkdirs();
        KeyStoreManager mgr = new KeyStoreManager(newCertsDir, "blank_crl.pem");
        X509V2CRLGenerator crlGen = new X509V2CRLGenerator();
        Date now = new Date();
        X509Certificate caCrlCert = null;
        try {
            caCrlCert = mgr.getSigningCert();
            PrivateKey caCrlPrivateKey = mgr.getSigningPrivateKey();
            crlGen.setIssuerDN(mgr.getSigningCert().getSubjectX500Principal());
            crlGen.setThisUpdate(now);
            crlGen.setNextUpdate(mgr.getSigningCert().getNotAfter());
            crlGen.setSignatureAlgorithm(mgr.getSigningCert().getSigAlgName());
            crlGen.addExtension((DERObjectIdentifier)X509Extensions.AuthorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifierStructure(caCrlCert));
            crlGen.addExtension((DERObjectIdentifier)X509Extensions.CRLNumber, false, (ASN1Encodable)new CRLNumber(BigInteger.ONE));
            X509CRL crl = crlGen.generate(caCrlPrivateKey);
            File certRevoc = new File(newCertsDir, "blank_crl.dec");
            FileOutputStream cerOut = new FileOutputStream(certRevoc);
            byte[] buf = crl.getEncoded();
            cerOut.write(buf);
            cerOut.flush();
            cerOut.close();
            Process p = Runtime.getRuntime().exec(OPENSSL_CMD_DEC_TO_PEM);
            p.waitFor();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CertificateParsingException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        catch (CRLException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

