#!/usr/local/bin/perl -w
use 5.008;
use strict;
use warnings;

use Test::More tests => 35;

BEGIN {
    use_ok( 'CGI::Cookie::Jam' );
};

########################################################################
# function enjam(%param)

my @text = <DATA>;
@text = split /\n<hr \/>\n/, join '', @text;
my $text = $text[0];
my $expected = $text[1];
my @expected = split /\n/, $expected;

my @param = (
    name   => 'Masanori HATA'           ,
    mail   => 'lovewing@geocities.co.jp',
    sex    => 'male'                    ,
    birth  => '2003-04-09'              ,
    nation => 'Japan'                   ,
    pref   => 'Saitama'                 ,
    city   => 'Kawaguchi'               ,
    tel    => '+81-48-2XX-XXXX'         ,
    fax    => '+81-48-2XX-XXXX'         ,
    job    => 'student'                 ,
    role   => 'president'               ,
    hobby  => 'exaggeration'            ,
    text   => $text
    );

my @got = enjam('jammed_cookies', 4096, @param);

for (my $i = 0; $i <= $#expected; $i++) {
    my $message = 'function enjam(%param) ' . ($i + 1) . '/' . ($#expected + 1);
    is($got[$i], $expected[$i], $message);
}

########################################################################
# function enjam(%param) without size limitation

$expected =~ s/\n//g;
$expected =~ s/jammed_cookies_\d\d=//g;
$expected = 'jammed_cookie=' . $expected;

my $got = enjam('jammed_cookie', 0, @param);

is($got, $expected, 'function enjam(%param) without size limitation');

########################################################################
# function dejam($cookie)

my %expected = @param;

my %param = dejam $expected;

my $i = 0;
foreach my $name (keys %expected) {
    my $message = 'function dejam($cookie) ' . ($i++ + 1) . '/' . (($#param + 1) / 2);
    is($param{$name}, $expected{$name}, $message);
}

########################################################################
# function encryptjam()

chomp(my $expected_crypt = $text[2]);

my $cryptjam = encryptjam('cryptjam', 0, 4, @param);

is($cryptjam, $expected_crypt, 'function encryptjam()');

########################################################################
# function decryptjam()

%param = ();
%param = decryptjam($expected_crypt, 4);

$i = 0;
foreach my $name (keys %expected) {
    my $message = 'function decryptjam() ' . ($i++ + 1) . '/' . (($#param + 1) / 2);
    is($param{$name}, $expected{$name}, $message);
}

########################################################################
__END__
<h1>PERSISTENT CLIENT STATE HTTP COOKIES</h1>
<h2>Preliminary Specification - Use with caution</h2>

<h2>INTRODUCTION</h2>
<p>Cookies are a general mechanism which server side connections (such as CGI scripts) can use to both store and retrieve information on the client side of the connection. The addition of a simple, persistent, client-side state significantly extends the capabilities of Web-based client/server applications.</p>

<h2>OVERVIEW</h2>
<p>A server, when returning an HTTP object to a client, may also send a piece of state information which the client will store.  Included in that state object is a description of the range of URLs for which that state is valid.  Any future HTTP requests made by the client which fall in that range will include a transmittal of the current value of the state object from the client back to the server.  The state object is called a <strong>cookie</strong>, for no compelling reason. </p>
<p>This simple mechanism provides a powerful new tool which enables a host of new types of applications to be written for web-based environments. Shopping applications can now store information about the currently selected items, for fee services can send back registration information and free the client from retyping a user-id on next connection, sites can store per-user preferences on the client, and have the client supply
those preferences every time that site is connected to.</p>

<h2>SPECIFICATION</h2>
<p>A cookie is introduced to the client by including a <strong>Set-Cookie</strong> header as part of an HTTP response, typically this will be generated by a CGI script.</p>

<h2>Syntax of the Set-Cookie HTTP Response Header</h2>
<p>This is the format a CGI script would use to add to the HTTP headers a new piece of data which is to be stored by the client for later retrieval.</p>
<pre>
Set-Cookie: <em>NAME</em>=<em>VALUE</em>; expires=<em>DATE</em>;
path=<em>PATH</em>; domain=<em>DOMAIN_NAME</em>; secure
</pre>
<dl>
<dt><em>NAME</em>=<em>VALUE</em></dt><dd>This string is a sequence of characters excluding semi-colon, comma and white space.  If there is a need to place such data in the name or value, some encoding method such as URL style %XX encoding is recommended, though no encoding is defined or required. <p>  This is the only required attribute on the <strong>Set-Cookie</strong> header. </dd>
<dt><strong>expires</strong>=<em>DATE</em></dt><dd>The <strong>expires</strong> attribute specifies a date string that defines the valid life time of that cookie.  Once the expiration date has been reached, the cookie will no longer be stored or given out. <br />
The date string is formatted as:
<blockquote><code>Wdy, DD-Mon-YYYY HH:MM:SS GMT</code></blockquote>
This is based on
<a href="http://ds.internic.net/rfc/rfc822.txt">RFC 822</a>, <a href="http://ds.internic.net/rfc/rfc850.txt">RFC 850</a>, <a href="http://www.w3.org/hypertext/WWW/Protocols/rfc1036/rfc1036.html#z6">RFC 1036</a>, and <a href="http://ds1.internic.net/rfc/rfc1123.txt">RFC 1123</a>, with the variations that the only legal time zone is <strong>GMT</strong> and the separators between the elements of the date must be dashes.<br />
<strong>expires</strong> is an optional attribute.  If not specified, the cookie will expire when the user's session ends. <br />
<strong>Note:</strong> There is a bug in Netscape Navigator version 1.1 and earlier. Only cookies whose <strong>path</strong> attribute is set explicitly to "/" will be properly saved between sessions if they have an <strong>expires</strong> attribute.</dd>
<dt><strong>domain</strong>=<em>DOMAIN_NAME</em></dt><dd>When searching the cookie list for valid cookies, a comparison of the <strong>domain</strong> attributes of the cookie is made with the Internet domain name of the host from which the URL will be fetched.  If there is a tail match, then the cookie will go through <strong>path</strong> matching to see if it should be sent.  "Tail matching" means that <strong>domain</strong> attribute is matched against the tail of the fully qualified domain name of the host.  A <strong>domain</strong> attribute of "acme.com" would match host names "anvil.acme.com" as well as "shipping.crate.acme.com". <br />
Only hosts within the specified domain can set a cookie for a domain and domains must have at least two (2)
or three (3) periods in them to prevent domains of the form: ".com", ".edu", and "va.us".  Any domain that fails within one of the seven special top level domains listed below only require two periods.  Any other domain requires at least three.  The seven special top level domains are: "COM", "EDU", "NET", "ORG", "GOV", "MIL", and "INT".<br />
The default value of <strong>domain</strong> is the host name of the server which generated the cookie response. </dd>
<dt><strong>path</strong>=<em>PATH</em></dt><dd>The <strong>path</strong> attribute is used to specify the subset of URLs in a domain for which the cookie is valid.  If a cookie has already passed <strong>domain</strong> matching, then the pathname component of the URL is compared with the path attribute, and if there is a match, the cookie is considered valid and is sent along with the URL request. The path "/foo" would match "/foobar" and "/foo/bar.html".  The path "/" is the most general path. <p>
If the <strong>path</strong> is not specified, it as assumed to be the same path as the document being described by the header which contains the cookie.</dd>
<dt><strong>secure</strong></dt><dd>If a cookie is marked <strong>secure</strong>, it will only be transmitted if the communications channel with the host is a secure one.  Currently this means that secure cookies will only be sent to HTTPS (HTTP over SSL) servers. <br />
If <strong>secure</strong> is not specified, a cookie is considered safe to be sent in the clear over unsecured channels.</dd>
</dl>

<h2>Syntax of the Cookie HTTP Request Header</h2>
<p>When requesting a URL from an HTTP server, the browser will match the URL against all cookies and if any of them match, a line containing the name/value pairs of all matching cookies will be included in the HTTP request.  Here is the format of that line:</p>
<pre>
Cookie: <em>NAME1=OPAQUE_STRING1</em>; <em>NAME2=OPAQUE_STRING2 ...</em>
</pre>

<h2>Additional Notes</h2>
<ul>
<li>Multiple <strong>Set-Cookie</strong> headers can be issued in a single server response.</li>
<li>Instances of the same path and name will overwrite each other, with the latest instance taking precedence.  Instances of the same path but different names will add additional mappings.</li>
<li>Setting the path to a higher-level value does not override other more specific path mappings.  If there are multiple matches for a given cookie name, but with separate paths, all the matching cookies will be sent. (See examples below.)</li>
<li>The expires header lets the client know when it is safe to purge the mapping but the client is not required to do so.  A client may also delete a cookie before it's expiration date arrives if the number of cookies exceeds its internal limits.</li>
<li>When sending cookies to a server, all cookies with a more specific path mapping should be sent before cookies with less specific path mappings.  For example, a cookie "name1=foo" with a path mapping of "/" should be sent after a cookie "name1=foo2" with a path mapping of "/bar" if they are both to be sent.</li>
<li>There are limitations on the number of cookies that a client can store at any one time.  This is a specification of the minimum number of cookies that a client should be prepared to receive and store.
    <ul>
    <li>300 total cookies</li>
    <li>4 kilobytes per cookie, where the name and the OPAQUE_STRING combine to form the 4 kilobyte limit.</li>
    <li>20 cookies per server or domain.  (note that completely specified hosts and domains are treated as separate entities and have a 20 cookie limitation for each, not combined)</li>
    </ul>
Servers should not expect clients to be able to exceed these limits. When the 300 cookie limit or the 20 cookie per server limit is exceeded, clients should delete the least recently used cookie. When a cookie larger than 4 kilobytes is encountered the cookie should be trimmed to fit, but the name should remain intact as long as it is less than 4 kilobytes.</li>
<li>If a CGI script wishes to delete a cookie, it can do so by returning a cookie with the same name, and an <strong>expires</strong> time which is in the past.  The path and name must match exactly in order for the expiring cookie to replace the valid cookie. This requirement makes it difficult for anyone but the originator of a cookie to delete a cookie.</li>
<li>When caching HTTP, as a proxy server might do, the <strong>Set-cookie</strong> response header should never be cached.</li>
<li>If a proxy server receives a response which contains a <strong>Set-cookie</strong> header, it should propagate the <strong>Set-cookie</strong> header to the client, regardless of whether the response was 304
(Not Modified) or 200 (OK).</li>
<li>Similarly, if a client request contains a Cookie: header, it should be forwarded through a proxy, even if the conditional If-modified-since request is being made.</li>
</ul>

<h2>EXAMPLES</h2>
<p>Here are some sample exchanges which are designed to illustrate the use of cookies.</p>
<h3>First Example transaction sequence:</h3>
<dl>
<dt>Client requests a document, and receives in the response:</dt><dd>
<pre>
Set-Cookie: CUSTOMER=WILE_E_COYOTE; path=/; expires=Wednesday, 09-Nov-99 23:12:40 GMT</pre></dd>
<dt>When client requests a URL in path "/" on this server, it sends:</dt><dd>
<pre>Cookie: CUSTOMER=WILE_E_COYOTE</pre></dd>
<dt>Client requests a document, and receives in the response:</dt><dd>
<pre>Set-Cookie: PART_NUMBER=ROCKET_LAUNCHER_0001; path=/</pre></dd>
<dt>When client requests a URL in path "/" on this server, it sends:</dt><dd>
<pre>Cookie: CUSTOMER=WILE_E_COYOTE; PART_NUMBER=ROCKET_LAUNCHER_0001</pre></dd>
<dt>Client receives:</dt><dd>
<pre>Set-Cookie: SHIPPING=FEDEX; path=/foo</pre></dd>
<dt>When client requests a URL in path "/" on this server, it sends:</dt><dd>
<pre>Cookie: CUSTOMER=WILE_E_COYOTE; PART_NUMBER=ROCKET_LAUNCHER_0001</pre></dd>
<dt>When client requests a URL in path "/foo" on this server, it sends:</dt><dd>
<pre>Cookie: CUSTOMER=WILE_E_COYOTE; PART_NUMBER=ROCKET_LAUNCHER_0001; SHIPPING=FEDEX</pre></dd>
</dl>
<h3>Second Example transaction sequence:</h3>
<dl>
<dt>Assume all mappings from above have been cleared.</dt><dd></dd>
<dt>Client receives:</dt><dd>
<pre>Set-Cookie: PART_NUMBER=ROCKET_LAUNCHER_0001; path=/</pre></dd>
<dt>When client requests a URL in path "/" on this server, it sends:</dt><dd>
<pre>Cookie: PART_NUMBER=ROCKET_LAUNCHER_0001</pre></dd>
<dt>Client receives:</dt><dd>
<pre>Set-Cookie: PART_NUMBER=RIDING_ROCKET_0023; path=/ammo</pre></dd>
<dt>When client requests a URL in path "/ammo" on this server, it sends:</dt><dd>
<pre>Cookie: PART_NUMBER=RIDING_ROCKET_0023; PART_NUMBER=ROCKET_LAUNCHER_0001</pre></dd>
<dt></dt><dd>NOTE: There are two name/value pairs named "PART_NUMBER" due to the inheritance of the "/" mapping in addition to the "/ammo" mapping.</dd>
</dl>
<hr />
jammed_cookies_00=name%3DMasanori%2520HATA%26mail%3Dlovewing%2540geocities.co.jp%26sex%3Dmale%26birth%3D2003-04-09%26nation%3DJapan%26pref%3DSaitama%26city%3DKawaguchi%26tel%3D%252B81-48-2XX-XXXX%26fax%3D%252B81-48-2XX-XXXX%26job%3Dstudent%26role%3Dpresident%26hobby%3Dexaggeration%26text%3D%253Ch1%253EPERSISTENT%2520CLIENT%2520STATE%2520HTTP%2520COOKIES%253C%252Fh1%253E%250A%253Ch2%253EPreliminary%2520Specification%2520-%2520Use%2520with%2520caution%253C%252Fh2%253E%250A%250A%253Ch2%253EINTRODUCTION%253C%252Fh2%253E%250A%253Cp%253ECookies%2520are%2520a%2520general%2520mechanism%2520which%2520server%2520side%2520connections%2520(such%2520as%2520CGI%2520scripts)%2520can%2520use%2520to%2520both%2520store%2520and%2520retrieve%2520information%2520on%2520the%2520client%2520side%2520of%2520the%2520connection.%2520The%2520addition%2520of%2520a%2520simple%252C%2520persistent%252C%2520client-side%2520state%2520significantly%2520extends%2520the%2520capabilities%2520of%2520Web-based%2520client%252Fserver%2520applications.%253C%252Fp%253E%250A%250A%253Ch2%253EOVERVIEW%253C%252Fh2%253E%250A%253Cp%253EA%2520server%252C%2520when%2520returning%2520an%2520HTTP%2520object%2520to%2520a%2520client%252C%2520may%2520also%2520send%2520a%2520piece%2520of%2520state%2520information%2520which%2520the%2520client%2520will%2520store.%2520%2520Included%2520in%2520that%2520state%2520object%2520is%2520a%2520description%2520of%2520the%2520range%2520of%2520URLs%2520for%2520which%2520that%2520state%2520is%2520valid.%2520%2520Any%2520future%2520HTTP%2520requests%2520made%2520by%2520the%2520client%2520which%2520fall%2520in%2520that%2520range%2520will%2520include%2520a%2520transmittal%2520of%2520the%2520current%2520value%2520of%2520the%2520state%2520object%2520from%2520the%2520client%2520back%2520to%2520the%2520server.%2520%2520The%2520state%2520object%2520is%2520called%2520a%2520%253Cstrong%253Ecookie%253C%252Fstrong%253E%252C%2520for%2520no%2520compelling%2520reason.%2520%253C%252Fp%253E%250A%253Cp%253EThis%2520simple%2520mechanism%2520provides%2520a%2520powerful%2520new%2520tool%2520which%2520enables%2520a%2520host%2520of%2520new%2520types%2520of%2520applications%2520to%2520be%2520written%2520for%2520web-based%2520environments.%2520Shopping%2520applications%2520can%2520now%2520store%2520information%2520about%2520the%2520currently%2520selected%2520items%252C%2520for%2520fee%2520services%2520can%2520send%2520back%2520registration%2520information%2520and%2520free%2520the%2520client%2520from%2520retyping%2520a%2520user-id%2520on%2520next%2520connection%252C%2520sites%2520can%2520store%2520per-user%2520preferences%2520on%2520the%2520client%252C%2520and%2520have%2520the%2520client%2520supply%250Athose%2520preferences%2520every%2520time%2520that%2520site%2520is%2520connected%2520to.%253C%252Fp%253E%250A%250A%253Ch2%253ESPECIFICATION%253C%252Fh2%253E%250A%253Cp%253EA%2520cookie%2520is%2520introduced%2520to%2520the%2520client%2520by%2520including%2520a%2520%253Cstrong%253ESet-Cookie%253C%252Fstrong%253E%2520header%2520as%2520part%2520of%2520an%2520HTTP%2520response%252C%2520typically%2520this%2520will%2520be%2520generated%2520by%2520a%2520CGI%2520script.%253C%252Fp%253E%250A%250A%253Ch2%253ESyntax%2520of%2520the%2520Set-Cookie%2520HTTP%2520Response%2520Header%253C%252Fh2%253E%250A%253Cp%253EThis%2520is%2520the%2520format%2520a%2520CGI%2520script%2520would%2520use%2520to%2520add%2520to%2520the%2520HTTP%2520headers%2520a%2520new%2520piece%2520of%2520data%2520which%2520is%2520to%2520be%2520stored%2520by%2520the%2520client%2520for%2520later%2520retrieval.%253C%252Fp%253E%250A%253Cpre%253E%250ASet-Cookie%253A%2520%253Cem%253ENAME%253C%252Fem%253E%253D%253Cem%253EVALUE%253C%252Fem%253E%253B%2520expires%253D%253Cem%253EDATE%253C%252Fem%253E%253B%250Apath%253D%253Cem%253EPATH%253C%252Fem%253E%253B%2520domain%253D%253Cem%253EDOMAIN_NAME%253C%252Fem%253E%253B%2520secure%250A%253C%252Fpre%253E%250A%253Cdl%253E%250A%253Cdt%253E%253Cem%253ENAME%253C%252Fem%253E%253D%253Cem%253EVALUE%253C%252Fem%253E%253C%252Fdt%253E%253Cdd%253EThis%2520string%2520is%2520a%2520sequence%2520of%252
jammed_cookies_01=0characters%2520excluding%2520semi-colon%252C%2520comma%2520and%2520white%2520space.%2520%2520If%2520there%2520is%2520a%2520need%2520to%2520place%2520such%2520data%2520in%2520the%2520name%2520or%2520value%252C%2520some%2520encoding%2520method%2520such%2520as%2520URL%2520style%2520%2525XX%2520encoding%2520is%2520recommended%252C%2520though%2520no%2520encoding%2520is%2520defined%2520or%2520required.%2520%253Cp%253E%2520%2520This%2520is%2520the%2520only%2520required%2520attribute%2520on%2520the%2520%253Cstrong%253ESet-Cookie%253C%252Fstrong%253E%2520header.%2520%253C%252Fdd%253E%250A%253Cdt%253E%253Cstrong%253Eexpires%253C%252Fstrong%253E%253D%253Cem%253EDATE%253C%252Fem%253E%253C%252Fdt%253E%253Cdd%253EThe%2520%253Cstrong%253Eexpires%253C%252Fstrong%253E%2520attribute%2520specifies%2520a%2520date%2520string%2520that%2520defines%2520the%2520valid%2520life%2520time%2520of%2520that%2520cookie.%2520%2520Once%2520the%2520expiration%2520date%2520has%2520been%2520reached%252C%2520the%2520cookie%2520will%2520no%2520longer%2520be%2520stored%2520or%2520given%2520out.%2520%253Cbr%2520%252F%253E%250AThe%2520date%2520string%2520is%2520formatted%2520as%253A%250A%253Cblockquote%253E%253Ccode%253EWdy%252C%2520DD-Mon-YYYY%2520HH%253AMM%253ASS%2520GMT%253C%252Fcode%253E%253C%252Fblockquote%253E%250AThis%2520is%2520based%2520on%250A%253Ca%2520href%253D%2522http%253A%252F%252Fds.internic.net%252Frfc%252Frfc822.txt%2522%253ERFC%2520822%253C%252Fa%253E%252C%2520%253Ca%2520href%253D%2522http%253A%252F%252Fds.internic.net%252Frfc%252Frfc850.txt%2522%253ERFC%2520850%253C%252Fa%253E%252C%2520%253Ca%2520href%253D%2522http%253A%252F%252Fwww.w3.org%252Fhypertext%252FWWW%252FProtocols%252Frfc1036%252Frfc1036.html%2523z6%2522%253ERFC%25201036%253C%252Fa%253E%252C%2520and%2520%253Ca%2520href%253D%2522http%253A%252F%252Fds1.internic.net%252Frfc%252Frfc1123.txt%2522%253ERFC%25201123%253C%252Fa%253E%252C%2520with%2520the%2520variations%2520that%2520the%2520only%2520legal%2520time%2520zone%2520is%2520%253Cstrong%253EGMT%253C%252Fstrong%253E%2520and%2520the%2520separators%2520between%2520the%2520elements%2520of%2520the%2520date%2520must%2520be%2520dashes.%253Cbr%2520%252F%253E%250A%253Cstrong%253Eexpires%253C%252Fstrong%253E%2520is%2520an%2520optional%2520attribute.%2520%2520If%2520not%2520specified%252C%2520the%2520cookie%2520will%2520expire%2520when%2520the%2520user's%2520session%2520ends.%2520%253Cbr%2520%252F%253E%250A%253Cstrong%253ENote%253A%253C%252Fstrong%253E%2520There%2520is%2520a%2520bug%2520in%2520Netscape%2520Navigator%2520version%25201.1%2520and%2520earlier.%2520Only%2520cookies%2520whose%2520%253Cstrong%253Epath%253C%252Fstrong%253E%2520attribute%2520is%2520set%2520explicitly%2520to%2520%2522%252F%2522%2520will%2520be%2520properly%2520saved%2520between%2520sessions%2520if%2520they%2520have%2520an%2520%253Cstrong%253Eexpires%253C%252Fstrong%253E%2520attribute.%253C%252Fdd%253E%250A%253Cdt%253E%253Cstrong%253Edomain%253C%252Fstrong%253E%253D%253Cem%253EDOMAIN_NAME%253C%252Fem%253E%253C%252Fdt%253E%253Cdd%253EWhen%2520searching%2520the%2520cookie%2520list%2520for%2520valid%2520cookies%252C%2520a%2520comparison%2520of%2520the%2520%253Cstrong%253Edomain%253C%252Fstrong%253E%2520attributes%2520of%2520the%2520cookie%2520is%2520made%2520with%2520the%2520Internet%2520domain%2520name%2520of%2520the%2520host%2520from%2520which%2520the%2520URL%2520will%2520be%2520fetched.%2520%2520If%2520there%2520is%2520a%2520tail%2520match%252C%2520then%2520the%2520cookie%2520will%2520go%2520through%2520%253Cstrong%253Epath%253C%252Fstrong%253E%2520matching%2520to%2520see%2520if%2520it%2520should%2520be%2520sent.%2520%2520%2522Tail%2520matching%2522%2520means%2520that%2520%253Cstrong%253Edomain%253C%252Fstrong%253E%2520attribute%2520is%2520matched%2520against%2520the%2520tail%2520of%2520the%2520fully%2520qualified%2520domain%2520name%2520of%2520the%2520host.%2520%2520A%2520%253Cstrong%253Edomain%253C%252Fstrong%253E%2520attribute%2520of%2520%2522acme.com%2522%2520would%2520match%2520host%2520names%2520%2522anvil.acme.com%2522%2520as%2520well%2520as%2520
jammed_cookies_02=%2522shipping.crate.acme.com%2522.%2520%253Cbr%2520%252F%253E%250AOnly%2520hosts%2520within%2520the%2520specified%2520domain%2520can%2520set%2520a%2520cookie%2520for%2520a%2520domain%2520and%2520domains%2520must%2520have%2520at%2520least%2520two%2520(2)%250Aor%2520three%2520(3)%2520periods%2520in%2520them%2520to%2520prevent%2520domains%2520of%2520the%2520form%253A%2520%2522.com%2522%252C%2520%2522.edu%2522%252C%2520and%2520%2522va.us%2522.%2520%2520Any%2520domain%2520that%2520fails%2520within%2520one%2520of%2520the%2520seven%2520special%2520top%2520level%2520domains%2520listed%2520below%2520only%2520require%2520two%2520periods.%2520%2520Any%2520other%2520domain%2520requires%2520at%2520least%2520three.%2520%2520The%2520seven%2520special%2520top%2520level%2520domains%2520are%253A%2520%2522COM%2522%252C%2520%2522EDU%2522%252C%2520%2522NET%2522%252C%2520%2522ORG%2522%252C%2520%2522GOV%2522%252C%2520%2522MIL%2522%252C%2520and%2520%2522INT%2522.%253Cbr%2520%252F%253E%250AThe%2520default%2520value%2520of%2520%253Cstrong%253Edomain%253C%252Fstrong%253E%2520is%2520the%2520host%2520name%2520of%2520the%2520server%2520which%2520generated%2520the%2520cookie%2520response.%2520%253C%252Fdd%253E%250A%253Cdt%253E%253Cstrong%253Epath%253C%252Fstrong%253E%253D%253Cem%253EPATH%253C%252Fem%253E%253C%252Fdt%253E%253Cdd%253EThe%2520%253Cstrong%253Epath%253C%252Fstrong%253E%2520attribute%2520is%2520used%2520to%2520specify%2520the%2520subset%2520of%2520URLs%2520in%2520a%2520domain%2520for%2520which%2520the%2520cookie%2520is%2520valid.%2520%2520If%2520a%2520cookie%2520has%2520already%2520passed%2520%253Cstrong%253Edomain%253C%252Fstrong%253E%2520matching%252C%2520then%2520the%2520pathname%2520component%2520of%2520the%2520URL%2520is%2520compared%2520with%2520the%2520path%2520attribute%252C%2520and%2520if%2520there%2520is%2520a%2520match%252C%2520the%2520cookie%2520is%2520considered%2520valid%2520and%2520is%2520sent%2520along%2520with%2520the%2520URL%2520request.%2520The%2520path%2520%2522%252Ffoo%2522%2520would%2520match%2520%2522%252Ffoobar%2522%2520and%2520%2522%252Ffoo%252Fbar.html%2522.%2520%2520The%2520path%2520%2522%252F%2522%2520is%2520the%2520most%2520general%2520path.%2520%253Cp%253E%250AIf%2520the%2520%253Cstrong%253Epath%253C%252Fstrong%253E%2520is%2520not%2520specified%252C%2520it%2520as%2520assumed%2520to%2520be%2520the%2520same%2520path%2520as%2520the%2520document%2520being%2520described%2520by%2520the%2520header%2520which%2520contains%2520the%2520cookie.%253C%252Fdd%253E%250A%253Cdt%253E%253Cstrong%253Esecure%253C%252Fstrong%253E%253C%252Fdt%253E%253Cdd%253EIf%2520a%2520cookie%2520is%2520marked%2520%253Cstrong%253Esecure%253C%252Fstrong%253E%252C%2520it%2520will%2520only%2520be%2520transmitted%2520if%2520the%2520communications%2520channel%2520with%2520the%2520host%2520is%2520a%2520secure%2520one.%2520%2520Currently%2520this%2520means%2520that%2520secure%2520cookies%2520will%2520only%2520be%2520sent%2520to%2520HTTPS%2520(HTTP%2520over%2520SSL)%2520servers.%2520%253Cbr%2520%252F%253E%250AIf%2520%253Cstrong%253Esecure%253C%252Fstrong%253E%2520is%2520not%2520specified%252C%2520a%2520cookie%2520is%2520considered%2520safe%2520to%2520be%2520sent%2520in%2520the%2520clear%2520over%2520unsecured%2520channels.%253C%252Fdd%253E%250A%253C%252Fdl%253E%250A%250A%253Ch2%253ESyntax%2520of%2520the%2520Cookie%2520HTTP%2520Request%2520Header%253C%252Fh2%253E%250A%253Cp%253EWhen%2520requesting%2520a%2520URL%2520from%2520an%2520HTTP%2520server%252C%2520the%2520browser%2520will%2520match%2520the%2520URL%2520against%2520all%2520cookies%2520and%2520if%2520any%2520of%2520them%2520match%252C%2520a%2520line%2520containing%2520the%2520name%252Fvalue%2520pairs%2520of%2520all%2520matching%2520cookies%2520will%2520be%2520included%2520in%2520the%2520HTTP%2520request.%2520%2520Here%2520is%2520the%2520format%2520of%2520that%2520line%253A%253C%252Fp%253E%250A%253Cpre%253E%250ACookie%253A%2520%253Cem%253ENAME1%253DOPAQUE_STRING1%253C%252Fem%253E%253B%2520%253Cem%253ENAME2%253DOPAQUE_STRING2%2520...%253C%252Fem%253E%250A%253C%252Fpre%253E%250A%250A%253
jammed_cookies_03=Ch2%253EAdditional%2520Notes%253C%252Fh2%253E%250A%253Cul%253E%250A%253Cli%253EMultiple%2520%253Cstrong%253ESet-Cookie%253C%252Fstrong%253E%2520headers%2520can%2520be%2520issued%2520in%2520a%2520single%2520server%2520response.%253C%252Fli%253E%250A%253Cli%253EInstances%2520of%2520the%2520same%2520path%2520and%2520name%2520will%2520overwrite%2520each%2520other%252C%2520with%2520the%2520latest%2520instance%2520taking%2520precedence.%2520%2520Instances%2520of%2520the%2520same%2520path%2520but%2520different%2520names%2520will%2520add%2520additional%2520mappings.%253C%252Fli%253E%250A%253Cli%253ESetting%2520the%2520path%2520to%2520a%2520higher-level%2520value%2520does%2520not%2520override%2520other%2520more%2520specific%2520path%2520mappings.%2520%2520If%2520there%2520are%2520multiple%2520matches%2520for%2520a%2520given%2520cookie%2520name%252C%2520but%2520with%2520separate%2520paths%252C%2520all%2520the%2520matching%2520cookies%2520will%2520be%2520sent.%2520(See%2520examples%2520below.)%253C%252Fli%253E%250A%253Cli%253EThe%2520expires%2520header%2520lets%2520the%2520client%2520know%2520when%2520it%2520is%2520safe%2520to%2520purge%2520the%2520mapping%2520but%2520the%2520client%2520is%2520not%2520required%2520to%2520do%2520so.%2520%2520A%2520client%2520may%2520also%2520delete%2520a%2520cookie%2520before%2520it's%2520expiration%2520date%2520arrives%2520if%2520the%2520number%2520of%2520cookies%2520exceeds%2520its%2520internal%2520limits.%253C%252Fli%253E%250A%253Cli%253EWhen%2520sending%2520cookies%2520to%2520a%2520server%252C%2520all%2520cookies%2520with%2520a%2520more%2520specific%2520path%2520mapping%2520should%2520be%2520sent%2520before%2520cookies%2520with%2520less%2520specific%2520path%2520mappings.%2520%2520For%2520example%252C%2520a%2520cookie%2520%2522name1%253Dfoo%2522%2520with%2520a%2520path%2520mapping%2520of%2520%2522%252F%2522%2520should%2520be%2520sent%2520after%2520a%2520cookie%2520%2522name1%253Dfoo2%2522%2520with%2520a%2520path%2520mapping%2520of%2520%2522%252Fbar%2522%2520if%2520they%2520are%2520both%2520to%2520be%2520sent.%253C%252Fli%253E%250A%253Cli%253EThere%2520are%2520limitations%2520on%2520the%2520number%2520of%2520cookies%2520that%2520a%2520client%2520can%2520store%2520at%2520any%2520one%2520time.%2520%2520This%2520is%2520a%2520specification%2520of%2520the%2520minimum%2520number%2520of%2520cookies%2520that%2520a%2520client%2520should%2520be%2520prepared%2520to%2520receive%2520and%2520store.%250A%2520%2520%2520%2520%253Cul%253E%250A%2520%2520%2520%2520%253Cli%253E300%2520total%2520cookies%253C%252Fli%253E%250A%2520%2520%2520%2520%253Cli%253E4%2520kilobytes%2520per%2520cookie%252C%2520where%2520the%2520name%2520and%2520the%2520OPAQUE_STRING%2520combine%2520to%2520form%2520the%25204%2520kilobyte%2520limit.%253C%252Fli%253E%250A%2520%2520%2520%2520%253Cli%253E20%2520cookies%2520per%2520server%2520or%2520domain.%2520%2520(note%2520that%2520completely%2520specified%2520hosts%2520and%2520domains%2520are%2520treated%2520as%2520separate%2520entities%2520and%2520have%2520a%252020%2520cookie%2520limitation%2520for%2520each%252C%2520not%2520combined)%253C%252Fli%253E%250A%2520%2520%2520%2520%253C%252Ful%253E%250AServers%2520should%2520not%2520expect%2520clients%2520to%2520be%2520able%2520to%2520exceed%2520these%2520limits.%2520When%2520the%2520300%2520cookie%2520limit%2520or%2520the%252020%2520cookie%2520per%2520server%2520limit%2520is%2520exceeded%252C%2520clients%2520should%2520delete%2520the%2520least%2520recently%2520used%2520cookie.%2520When%2520a%2520cookie%2520larger%2520than%25204%2520kilobytes%2520is%2520encountered%2520the%2520cookie%2520should%2520be%2520trimmed%2520to%2520fit%252C%2520but%2520the%2520name%2520should%2520remain%2520intact%2520as%2520long%2520as%2520it%2520is%2520less%2520than%25204%2520kilobytes.%253C%252Fli%253E%250A%253Cli%253EIf%2520a%2520CGI%2520script%2520wishes%2520to%2520delete%2520a%2520cookie%252C%2520it%2520can%2520do%2520so%2520by%2520returning%2520a%2520cookie%2520with%2520the%2520same%2520name%252C%2520and%2520an%2520%253Cstrong%253Eexpires%253C%252Fstrong
jammed_cookies_04=%253E%2520time%2520which%2520is%2520in%2520the%2520past.%2520%2520The%2520path%2520and%2520name%2520must%2520match%2520exactly%2520in%2520order%2520for%2520the%2520expiring%2520cookie%2520to%2520replace%2520the%2520valid%2520cookie.%2520This%2520requirement%2520makes%2520it%2520difficult%2520for%2520anyone%2520but%2520the%2520originator%2520of%2520a%2520cookie%2520to%2520delete%2520a%2520cookie.%253C%252Fli%253E%250A%253Cli%253EWhen%2520caching%2520HTTP%252C%2520as%2520a%2520proxy%2520server%2520might%2520do%252C%2520the%2520%253Cstrong%253ESet-cookie%253C%252Fstrong%253E%2520response%2520header%2520should%2520never%2520be%2520cached.%253C%252Fli%253E%250A%253Cli%253EIf%2520a%2520proxy%2520server%2520receives%2520a%2520response%2520which%2520contains%2520a%2520%253Cstrong%253ESet-cookie%253C%252Fstrong%253E%2520header%252C%2520it%2520should%2520propagate%2520the%2520%253Cstrong%253ESet-cookie%253C%252Fstrong%253E%2520header%2520to%2520the%2520client%252C%2520regardless%2520of%2520whether%2520the%2520response%2520was%2520304%250A(Not%2520Modified)%2520or%2520200%2520(OK).%253C%252Fli%253E%250A%253Cli%253ESimilarly%252C%2520if%2520a%2520client%2520request%2520contains%2520a%2520Cookie%253A%2520header%252C%2520it%2520should%2520be%2520forwarded%2520through%2520a%2520proxy%252C%2520even%2520if%2520the%2520conditional%2520If-modified-since%2520request%2520is%2520being%2520made.%253C%252Fli%253E%250A%253C%252Ful%253E%250A%250A%253Ch2%253EEXAMPLES%253C%252Fh2%253E%250A%253Cp%253EHere%2520are%2520some%2520sample%2520exchanges%2520which%2520are%2520designed%2520to%2520illustrate%2520the%2520use%2520of%2520cookies.%253C%252Fp%253E%250A%253Ch3%253EFirst%2520Example%2520transaction%2520sequence%253A%253C%252Fh3%253E%250A%253Cdl%253E%250A%253Cdt%253EClient%2520requests%2520a%2520document%252C%2520and%2520receives%2520in%2520the%2520response%253A%253C%252Fdt%253E%253Cdd%253E%250A%253Cpre%253E%250ASet-Cookie%253A%2520CUSTOMER%253DWILE_E_COYOTE%253B%2520path%253D%252F%253B%2520expires%253DWednesday%252C%252009-Nov-99%252023%253A12%253A40%2520GMT%253C%252Fpre%253E%253C%252Fdd%253E%250A%253Cdt%253EWhen%2520client%2520requests%2520a%2520URL%2520in%2520path%2520%2522%252F%2522%2520on%2520this%2520server%252C%2520it%2520sends%253A%253C%252Fdt%253E%253Cdd%253E%250A%253Cpre%253ECookie%253A%2520CUSTOMER%253DWILE_E_COYOTE%253C%252Fpre%253E%253C%252Fdd%253E%250A%253Cdt%253EClient%2520requests%2520a%2520document%252C%2520and%2520receives%2520in%2520the%2520response%253A%253C%252Fdt%253E%253Cdd%253E%250A%253Cpre%253ESet-Cookie%253A%2520PART_NUMBER%253DROCKET_LAUNCHER_0001%253B%2520path%253D%252F%253C%252Fpre%253E%253C%252Fdd%253E%250A%253Cdt%253EWhen%2520client%2520requests%2520a%2520URL%2520in%2520path%2520%2522%252F%2522%2520on%2520this%2520server%252C%2520it%2520sends%253A%253C%252Fdt%253E%253Cdd%253E%250A%253Cpre%253ECookie%253A%2520CUSTOMER%253DWILE_E_COYOTE%253B%2520PART_NUMBER%253DROCKET_LAUNCHER_0001%253C%252Fpre%253E%253C%252Fdd%253E%250A%253Cdt%253EClient%2520receives%253A%253C%252Fdt%253E%253Cdd%253E%250A%253Cpre%253ESet-Cookie%253A%2520SHIPPING%253DFEDEX%253B%2520path%253D%252Ffoo%253C%252Fpre%253E%253C%252Fdd%253E%250A%253Cdt%253EWhen%2520client%2520requests%2520a%2520URL%2520in%2520path%2520%2522%252F%2522%2520on%2520this%2520server%252C%2520it%2520sends%253A%253C%252Fdt%253E%253Cdd%253E%250A%253Cpre%253ECookie%253A%2520CUSTOMER%253DWILE_E_COYOTE%253B%2520PART_NUMBER%253DROCKET_LAUNCHER_0001%253C%252Fpre%253E%253C%252Fdd%253E%250A%253Cdt%253EWhen%2520client%2520requests%2520a%2520URL%2520in%2520path%2520%2522%252Ffoo%2522%2520on%2520this%2520server%252C%2520it%2520sends%253A%253C%252Fdt%253E%253Cdd%253E%250A%253Cpre%253ECookie%253A%2520CUSTOMER%253DWILE_E_COYOTE%253B%2520PART_NUMBER%253DROCKET_LAUNCHER_0001%253B%2520SHIPPING%253DFEDEX%253C%252Fpre%253E%253C%252Fdd%253E%250A%253C%252Fdl%253E%250A%253Ch3%253ESecond%2520Example%2520transaction%2520sequence%253A%253C%252Fh3%253E%250A%253Cdl%253E%250A%253Cdt%253EAssume%2520all%2520mappings%2520from%2520above%2520have%2520been%2520cleared.%253C%252Fdt%253E%253Cdd%253E%253C
jammed_cookies_05=%252Fdd%253E%250A%253Cdt%253EClient%2520receives%253A%253C%252Fdt%253E%253Cdd%253E%250A%253Cpre%253ESet-Cookie%253A%2520PART_NUMBER%253DROCKET_LAUNCHER_0001%253B%2520path%253D%252F%253C%252Fpre%253E%253C%252Fdd%253E%250A%253Cdt%253EWhen%2520client%2520requests%2520a%2520URL%2520in%2520path%2520%2522%252F%2522%2520on%2520this%2520server%252C%2520it%2520sends%253A%253C%252Fdt%253E%253Cdd%253E%250A%253Cpre%253ECookie%253A%2520PART_NUMBER%253DROCKET_LAUNCHER_0001%253C%252Fpre%253E%253C%252Fdd%253E%250A%253Cdt%253EClient%2520receives%253A%253C%252Fdt%253E%253Cdd%253E%250A%253Cpre%253ESet-Cookie%253A%2520PART_NUMBER%253DRIDING_ROCKET_0023%253B%2520path%253D%252Fammo%253C%252Fpre%253E%253C%252Fdd%253E%250A%253Cdt%253EWhen%2520client%2520requests%2520a%2520URL%2520in%2520path%2520%2522%252Fammo%2522%2520on%2520this%2520server%252C%2520it%2520sends%253A%253C%252Fdt%253E%253Cdd%253E%250A%253Cpre%253ECookie%253A%2520PART_NUMBER%253DRIDING_ROCKET_0023%253B%2520PART_NUMBER%253DROCKET_LAUNCHER_0001%253C%252Fpre%253E%253C%252Fdd%253E%250A%253Cdt%253E%253C%252Fdt%253E%253Cdd%253ENOTE%253A%2520There%2520are%2520two%2520name%252Fvalue%2520pairs%2520named%2520%2522PART_NUMBER%2522%2520due%2520to%2520the%2520inheritance%2520of%2520the%2520%2522%252F%2522%2520mapping%2520in%2520addition%2520to%2520the%2520%2522%252Fammo%2522%2520mapping.%253C%252Fdd%253E%250A%253C%252Fdl%253E
<hr />
cryptjam=m%1C%5D%5CWY%1C%3E%1Cm%7D.%1DT%26%06%09%18J%18d%5D%1C%1DMWM%7Dn%5C~%1Dm%7CTF%06%7C%5C%7D%3C%1DN%1D%5C%3Ee%3C%7De-%0Ed%3E%5C%0FW%5D%1CM%5Cd%2C%1D.N%0DW%26%06%066U%06FU%06%17dm%1CN%1D%7DmW)%1C%0E%1Cmd%0E.%5ClW%3A%1C%1DN%1C%5D%1Cd%3C%1DN%1FW9%1C~%1C%7C%5E%3C%0D%1DdN%5CMWT%26(%07%16UF%07U%26%0B%0BU%0B%0B%0B%0Bdl%1C%0FWT%26(%07%16UF%07U%26%0B%0BU%0B%0B%0B%0Bd-%7D%2CW%3EN%5EL%5CmNd.%7DM%5CW%0E.%5C%3E%1DL%5CmNd%0D%7D%2C%2C%1FW%5C%0F%1C%7C%7C%5C.%1CN%1D%7DmdN%5C%0FNWT68%0D%16T6X%0AX*%3A%19%3AJXiJT%26%068I%19XiJT%26%06%3AJ%18JXT%26%06%09JJ%0AT%26%068yy9%19X%3AT68T%26h%0D%16T6XT%06%18T68%0D%26T6X%0A.%5CM%1D%5D%1Dm%1C.%1FT%26%06%3A%0E%5C%3C%1Dl%1D%3C%1CN%1D%7DmT%26%06UT%26%06Z%3E%5CT%26%06~%1DN%0DT%26%06%3C%1C%5EN%1D%7DmT68T%26h%0D%26T6XT%06%18T%06%18T68%0D%26T6X%19iJ*yHZ8J%19yiT68T%26h%0D%26T6XT%06%18T68%0ET6X8%7D%7D%3D%1D%5C%3ET%26%06%1C.%5CT%26%06%1CT%26%06%7C%5Cm%5C.%1CMT%26%06%5D%5C%3C%0D%1Cm%1D%3E%5DT%26%06~%0D%1D%3C%0DT%26%06%3E%5C.n%5C.T%26%06%3E%1DL%5CT%26%06%3C%7Dmm%5C%3CN%1D%7Dm%3ET%26%06%05%3E%5E%3C%0DT%26%06%1C%3ET%26%068x%19T%26%06%3E%3C.%1D%0EN%3E%15T%26%06%3C%1CmT%26%06%5E%3E%5CT%26%06N%7DT%26%06%2C%7DN%0DT%26%06%3EN%7D.%5CT%26%06%1CmLT%26%06.%5CN.%1D%5Cn%5CT%26%06%1Dml%7D.%5D%1CN%1D%7DmT%26%06%7DmT%26%06N%0D%5CT%26%06%3CM%1D%5CmNT%26%06%3E%1DL%5CT%26%06%7DlT%26%06N%0D%5CT%26%06%3C%7Dmm%5C%3CN%1D%7DmeT%26%06J%0D%5CT%26%06%1CLL%1DN%1D%7DmT%26%06%7DlT%26%06%1CT%26%06%3E%1D%5D%0EM%5CT%268T%26%06%0E%5C.%3E%1D%3EN%5CmNT%268T%26%06%3CM%1D%5CmNU%3E%1DL%5CT%26%06%3EN%1CN%5CT%26%06%3E%1D%7Cm%1Dl%1D%3C%1CmNM%1FT%26%06%5C%0FN%5CmL%3ET%26%06N%0D%5CT%26%06%3C%1C%0E%1C%2C%1DM%1DN%1D%5C%3ET%26%06%7DlT%26%06z%5C%2CU%2C%1C%3E%5CLT%26%06%3CM%1D%5CmNT%26h%3E%5C.n%5C.T%26%06%1C%0E%0EM%1D%3C%1CN%1D%7Dm%3EeT68T%26h%0ET6XT%06%18T%06%18T68%0D%26T6XyjX*j%19XzT68T%26h%0D%26T6XT%06%18T68%0ET6X%18T%26%06%3E%5C.n%5C.T%268T%26%06~%0D%5CmT%26%06.%5CN%5E.m%1Dm%7CT%26%06%1CmT%26%06%09JJ%0AT%26%06%7D%2C-%5C%3CNT%26%06N%7DT%26%06%1CT%26%06%3CM%1D%5CmNT%268T%26%06%5D%1C%1FT%26%06%1CM%3E%7DT%26%06%3E%5CmLT%26%06%1CT%26%06%0E%1D%5C%3C%5CT%26%06%7DlT%26%06%3EN%1CN%5CT%26%06%1Dml%7D.%5D%1CN%1D%7DmT%26%06~%0D%1D%3C%0DT%26%06N%0D%5CT%26%06%3CM%1D%5CmNT%26%06~%1DMMT%26%06%3EN%7D.%5CeT%26%06T%26%06%19m%3CM%5EL%5CLT%26%06%1DmT%26%06N%0D%1CNT%26%06%3EN%1CN%5CT%26%06%7D%2C-%5C%3CNT%26%06%1D%3ET%26%06%1CT%26%06L%5C%3E%3C.%1D%0EN%1D%7DmT%26%06%7DlT%26%06N%0D%5CT%26%06.%1Cm%7C%5CT%26%06%7DlT%26%06Z*I%3ET%26%06l%7D.T%26%06~%0D%1D%3C%0DT%26%06N%0D%1CNT%26%06%3EN%1CN%5CT%26%06%1D%3ET%26%06n%1CM%1DLeT%26%06T%26%06%18m%1FT%26%06l%5EN%5E.%5CT%26%06%09JJ%0AT%26%06.%5C%1E%5E%5C%3EN%3ET%26%06%5D%1CL%5CT%26%06%2C%1FT%26%06N%0D%5CT%26%06%3CM%1D%5CmNT%26%06~%0D%1D%3C%0DT%26%06l%1CMMT%26%06%1DmT%26%06N%0D%1CNT%26%06.%1Cm%7C%5CT%26%06~%1DMMT%26%06%1Dm%3CM%5EL%5CT%26%06%1CT%26%06N.%1Cm%3E%5D%1DNN%1CMT%26%06%7DlT%26%06N%0D%5CT%26%06%3C%5E..%5CmNT%26%06n%1CM%5E%5CT%26%06%7DlT%26%06N%0D%5CT%26%06%3EN%1CN%5CT%26%06%7D%2C-%5C%3CNT%26%06l.%7D%5DT%26%06N%0D%5CT%26%06%3CM%1D%5CmNT%26%06%2C%1C%3C%3DT%26%06N%7DT%26%06N%0D%5CT%26%06%3E%5C.n%5C.eT%26%06T%26%06J%0D%5CT%26%06%3EN%1CN%5CT%26%06%7D%2C-%5C%3CNT%26%06%1D%3ET%26%06%3C%1CMM%5CLT%26%06%1CT%26%06T68%3EN.%7Dm%7CT6X%3C%7D%7D%3D%1D%5CT68T%26h%3EN.%7Dm%7CT6XT%268T%26%06l%7D.T%26%06m%7DT%26%06%3C%7D%5D%0E%5CMM%1Dm%7CT%26%06.%5C%1C%3E%7DmeT%26%06T68T%26h%0ET6XT%06%18T68%0ET6XJ%0D%1D%3ET%26%06%3E%1D%5D%0EM%5CT%26%06%5D%5C%3C%0D%1Cm%1D%3E%5DT%26%06%0E.%7Dn%1DL%5C%3ET%26%06%1CT%26%06%0E%7D~%5C.l%5EMT%26%06m%5C~T%26%06N%7D%7DMT%26%06~%0D%1D%3C%0DT%26%06%5Cm%1C%2CM%5C%3ET%26%06%1CT%26%06%0D%7D%3ENT%26%06%7DlT%26%06m%5C~T%26%06N%1F%0E%5C%3ET%26%06%7DlT%26%06%1C%0E%0EM%1D%3C%1CN%1D%7Dm%3ET%26%06N%7DT%26%06%2C%5CT%26%06~.%1DNN%5CmT%26%06l%7D.T%26%06~%5C%2CU%2C%1C%3E%5CLT%26%06%5Cmn%1D.%7Dm%5D%5CmN%3EeT%26%06%3A%0D%7D%0E%0E%1Dm%7CT%26%06%1C%0E%0EM%1D%3C%1CN%1D%7Dm%3ET%26%06%3C%1CmT%26%06m%7D~T%26%06%3EN%7D.%5CT%26%06%1Dml%7D.%5D%1CN%1D%7DmT%26%06%1C%2C%7D%5ENT%26%06N%0D%5CT%26%06%3C%5E..%5CmNM%1FT%26%06%3E%5CM%5C%3CN%5CLT%26%06%1DN%5C%5D%3ET%268T%26%06l%7D.T%26%06l%5C%5CT%26%06%3E%5C.n%1D%3C%5C%3ET%26%06%3C%1CmT%26%06%3E%5CmLT%26%06%2C%1C%3C%3DT%26%06.%5C%7C%1D%3EN.%1CN%1D%7DmT%26%06%1Dml%7D.%5D%1CN%1D%7DmT%26%06%1CmLT%26%06l.%5C%5CT%26%06N%0D%5CT%26%06%3CM%1D%5CmNT%26%06l.%7D%5DT%26%06.%5CN%1F%0E%1Dm%7CT%26%06%1CT%26%06%5E%3E%5C.U%1DLT%26%06%7DmT%26%06m%5C%0FNT%26%06%3C%7Dmm%5C%3CN%1D%7DmT%268T%26%06%3E%1DN%5C%3ET%26%06%3C%1CmT%26%06%3EN%7D.%5CT%26%06%0E%5C.U%5E%3E%5C.T%26%06%0E.%5Cl%5C.%5Cm%3C%5C%3ET%26%06%7DmT%26%06N%0D%5CT%26%06%3CM%1D%5CmNT%268T%26%06%1CmLT%26%06%0D%1Cn%5CT%26%06N%0D%5CT%26%06%3CM%1D%5CmNT%26%06%3E%5E%0E%0EM%1FT%06%18N%0D%7D%3E%5CT%26%06%0E.%5Cl%5C.%5Cm%3C%5C%3ET%26%06%5Cn%5C.%1FT%26%06N%1D%5D%5CT%26%06N%0D%1CNT%26%06%3E%1DN%5CT%26%06%1D%3ET%26%06%3C%7Dmm%5C%3CN%5CLT%26%06N%7DeT68T%26h%0ET6XT%06%18T%06%18T68%0D%26T6X%3A%0AX8%19h%198%18J%19yiT68T%26h%0D%26T6XT%06%18T68%0ET6X%18T%26%06%3C%7D%7D%3D%1D%5CT%26%06%1D%3ET%26%06%1DmN.%7DL%5E%3C%5CLT%26%06N%7DT%26%06N%0D%5CT%26%06%3CM%1D%5CmNT%26%06%2C%1FT%26%06%1Dm%3CM%5EL%1Dm%7CT%26%06%1CT%26%06T68%3EN.%7Dm%7CT6X%3A%5CNU8%7D%7D%3D%1D%5CT68T%26h%3EN.%7Dm%7CT6XT%26%06%0D%5C%1CL%5C.T%26%06%1C%3ET%26%06%0E%1C.NT%26%06%7DlT%26%06%1CmT%26%06%09JJ%0AT%26%06.%5C%3E%0E%7Dm%3E%5CT%268T%26%06N%1F%0E%1D%3C%1CMM%1FT%26%06N%0D%1D%3ET%26%06~%1DMMT%26%06%2C%5CT%26%06%7C%5Cm%5C.%1CN%5CLT%26%06%2C%1FT%26%06%1CT%26%068x%19T%26%06%3E%3C.%1D%0ENeT68T%26h%0ET6XT%06%18T%06%18T68%0D%26T6X%3A%1FmN%1C%0FT%26%06%7DlT%26%06N%0D%5CT%26%06%3A%5CNU8%7D%7D%3D%1D%5CT%26%06%09JJ%0AT%26%06*%5C%3E%0E%7Dm%3E%5CT%26%06%09%5C%1CL%5C.T68T%26h%0D%26T6XT%06%18T68%0ET6XJ%0D%1D%3ET%26%06%1D%3ET%26%06N%0D%5CT%26%06l%7D.%5D%1CNT%26%06%1CT%26%068x%19T%26%06%3E%3C.%1D%0ENT%26%06~%7D%5EMLT%26%06%5E%3E%5CT%26%06N%7DT%26%06%1CLLT%26%06N%7DT%26%06N%0D%5CT%26%06%09JJ%0AT%26%06%0D%5C%1CL%5C.%3ET%26%06%1CT%26%06m%5C~T%26%06%0E%1D%5C%3C%5CT%26%06%7DlT%26%06L%1CN%1CT%26%06~%0D%1D%3C%0DT%26%06%1D%3ET%26%06N%7DT%26%06%2C%5CT%26%06%3EN%7D.%5CLT%26%06%2C%1FT%26%06N%0D%5CT%26%06%3CM%1D%5CmNT%26%06l%7D.T%26%06M%1CN%5C.T%26%06.%5CN.%1D%5Cn%1CMeT68T%26h%0ET6XT%06%18T68%0E.%5CT6XT%06%18%3A%5CNU8%7D%7D%3D%1D%5CT6%18T%26%06T68%5C%5DT6Xi%18YXT68T%26h%5C%5DT6XT6HT68%5C%5DT6Xj%18IZXT68T%26h%5C%5DT6XT6(T%26%06%5C%0F%0E%1D.%5C%3ET6HT68%5C%5DT6XH%18JXT68T%26h%5C%5DT6XT6(T%06%18%0E%1CN%0DT6HT68%5C%5DT6X%0A%18J%09T68T%26h%5C%5DT6XT6(T%26%06L%7D%5D%1C%1DmT6HT68%5C%5DT6XHyY%18%19i%7Bi%18YXT68T%26h%5C%5DT6XT6(T%26%06%3E%5C%3C%5E.%5CT%06%18T68T%26h%0E.%5CT6XT%06%18T68LMT6XT%06%18T68LNT6XT68%5C%5DT6Xi%18YXT68T%26h%5C%5DT6XT6HT68%5C%5DT6Xj%18IZXT68T%26h%5C%5DT6XT68T%26hLNT6XT68LLT6XJ%0D%1D%3ET%26%06%3EN.%1Dm%7CT%26%06%1D%3ET%26%06%1CT%26%06%3E%5C%1E%5E%5Cm%3C%5CT%26%06%7DlT%26%06%3C%0D%1C.%1C%3CN%5C.%3ET%26%06%5C%0F%3CM%5EL%1Dm%7CT%26%06%3E%5C%5D%1DU%3C%7DM%7DmT%268T%26%06%3C%7D%5D%5D%1CT%26%06%1CmLT%26%06~%0D%1DN%5CT%26%06%3E%0E%1C%3C%5CeT%26%06T%26%06%19lT%26%06N%0D%5C.%5CT%26%06%1D%3ET%26%06%1CT%26%06m%5C%5CLT%26%06N%7DT%26%06%0EM%1C%3C%5CT%26%06%3E%5E%3C%0DT%26%06L%1CN%1CT%26%06%1DmT%26%06N%0D%5CT%26%06m%1C%5D%5CT%26%06%7D.T%26%06n%1CM%5E%5CT%268T%26%06%3E%7D%5D%5CT%26%06%5Cm%3C%7DL%1Dm%7CT%26%06%5D%5CN%0D%7DLT%26%06%3E%5E%3C%0DT%26%06%1C%3ET%26%06Z*IT%26%06%3EN%1FM%5CT%26%06T%26V%0B%0BT%26%06%5Cm%3C%7DL%1Dm%7CT%26%06%1D%3ET%26%06.%5C%3C%7D%5D%5D%5CmL%5CLT%268T%26%06N%0D%7D%5E%7C%0DT%26%06m%7DT%26%06%5Cm%3C%7DL%1Dm%7CT%26%06%1D%3ET%26%06L%5Cl%1Dm%5CLT%26%06%7D.T%26%06.%5C%1E%5E%1D.%5CLeT%26%06T68%0ET6XT%26%06T%26%06J%0D%1D%3ET%26%06%1D%3ET%26%06N%0D%5CT%26%06%7DmM%1FT%26%06.%5C%1E%5E%1D.%5CLT%26%06%1CNN.%1D%2C%5EN%5CT%26%06%7DmT%26%06N%0D%5CT%26%06T68%3EN.%7Dm%7CT6X%3A%5CNU8%7D%7D%3D%1D%5CT68T%26h%3EN.%7Dm%7CT6XT%26%06%0D%5C%1CL%5C.eT%26%06T68T%26hLLT6XT%06%18T68LNT6XT68%3EN.%7Dm%7CT6X%5C%0F%0E%1D.%5C%3ET68T%26h%3EN.%7Dm%7CT6XT6HT68%5C%5DT6XH%18JXT68T%26h%5C%5DT6XT68T%26hLNT6XT68LLT6XJ%0D%5CT%26%06T68%3EN.%7Dm%7CT6X%5C%0F%0E%1D.%5C%3ET68T%26h%3EN.%7Dm%7CT6XT%26%06%1CNN.%1D%2C%5EN%5CT%26%06%3E%0E%5C%3C%1Dl%1D%5C%3ET%26%06%1CT%26%06L%1CN%5CT%26%06%3EN.%1Dm%7CT%26%06N%0D%1CNT%26%06L%5Cl%1Dm%5C%3ET%26%06N%0D%5CT%26%06n%1CM%1DLT%26%06M%1Dl%5CT%26%06N%1D%5D%5CT%26%06%7DlT%26%06N%0D%1CNT%26%06%3C%7D%7D%3D%1D%5CeT%26%06T%26%06ym%3C%5CT%26%06N%0D%5CT%26%06%5C%0F%0E%1D.%1CN%1D%7DmT%26%06L%1CN%5CT%26%06%0D%1C%3ET%26%06%2C%5C%5CmT%26%06.%5C%1C%3C%0D%5CLT%268T%26%06N%0D%5CT%26%06%3C%7D%7D%3D%1D%5CT%26%06~%1DMMT%26%06m%7DT%26%06M%7Dm%7C%5C.T%26%06%2C%5CT%26%06%3EN%7D.%5CLT%26%06%7D.T%26%06%7C%1Dn%5CmT%26%06%7D%5ENeT%26%06T68%2C.T%26%06T%26hT6XT%06%18J%0D%5CT%26%06L%1CN%5CT%26%06%3EN.%1Dm%7CT%26%06%1D%3ET%26%06l%7D.%5D%1CNN%5CLT%26%06%1C%3ET6%18T%06%18T68%2CM%7D%3C%3D%1E%5E%7DN%5CT6XT68%3C%7DL%5CT6XzL%1FT%268T%26%06HHUY%7DmU%1B%1B%1B%1BT%26%06%09%09T6%18YYT6%18%3A%3AT%26%06xYJT68T%26h%3C%7DL%5CT6XT68T%26h%2CM%7D%3C%3D%1E%5E%7DN%5CT6XT%06%18J%0D%1D%3ET%26%06%1D%3ET%26%06%2C%1C%3E%5CLT%26%06%7DmT%06%18T68%1CT%26%06%0D.%5ClT6HT%26%26%0DNN%0ET6%18T%26hT%26hL%3Ee%1DmN%5C.m%1D%3Cem%5CNT%26h.l%3CT%26h.l%3C%07%26%26eN%0FNT%26%26T6X*h8T%26%06%07%26%26T68T%26h%1CT6XT%268T%26%06T68%1CT%26%06%0D.%5ClT6HT%26%26%0DNN%0ET6%18T%26hT%26hL%3Ee%1DmN%5C.m%1D%3Cem%5CNT%26h.l%3CT%26h.l%3C%07V%06eN%0FNT%26%26T6X*h8T%26%06%07V%06T68T%26h%1CT6XT%268T%26%06T68%1CT%26%06%0D.%5ClT6HT%26%26%0DNN%0ET6%18T%26hT%26h~~~e~6e%7D.%7CT%26h%0D%1F%0E%5C.N%5C%0FNT%26hzzzT%26h%0A.%7DN%7D%3C%7DM%3ET%26h.l%3C%16%066fT%26h.l%3C%16%066fe%0DN%5DMT%266%2FfT%26%26T6X*h8T%26%06%16%066fT68T%26h%1CT6XT%268T%26%06%1CmLT%26%06T68%1CT%26%06%0D.%5ClT6HT%26%26%0DNN%0ET6%18T%26hT%26hL%3E%16e%1DmN%5C.m%1D%3Cem%5CNT%26h.l%3CT%26h.l%3C%16%16%266eN%0FNT%26%26T6X*h8T%26%06%16%16%266T68T%26h%1CT6XT%268T%26%06~%1DN%0DT%26%06N%0D%5CT%26%06n%1C.%1D%1CN%1D%7Dm%3ET%26%06N%0D%1CNT%26%06N%0D%5CT%26%06%7DmM%1FT%26%06M%5C%7C%1CMT%26%06N%1D%5D%5CT%26%06%2F%7Dm%5CT%26%06%1D%3ET%26%06T68%3EN.%7Dm%7CT6XxYJT68T%26h%3EN.%7Dm%7CT6XT%26%06%1CmLT%26%06N%0D%5CT%26%06%3E%5C%0E%1C.%1CN%7D.%3ET%26%06%2C%5CN~%5C%5CmT%26%06N%0D%5CT%26%06%5CM%5C%5D%5CmN%3ET%26%06%7DlT%26%06N%0D%5CT%26%06L%1CN%5CT%26%06%5D%5E%3ENT%26%06%2C%5CT%26%06L%1C%3E%0D%5C%3EeT68%2C.T%26%06T%26hT6XT%06%18T68%3EN.%7Dm%7CT6X%5C%0F%0E%1D.%5C%3ET68T%26h%3EN.%7Dm%7CT6XT%26%06%1D%3ET%26%06%1CmT%26%06%7D%0EN%1D%7Dm%1CMT%26%06%1CNN.%1D%2C%5EN%5CeT%26%06T%26%06%19lT%26%06m%7DNT%26%06%3E%0E%5C%3C%1Dl%1D%5CLT%268T%26%06N%0D%5CT%26%06%3C%7D%7D%3D%1D%5CT%26%06~%1DMMT%26%06%5C%0F%0E%1D.%5CT%26%06~%0D%5CmT%26%06N%0D%5CT%26%06%5E%3E%5C.t%3ET%26%06%3E%5C%3E%3E%1D%7DmT%26%06%5CmL%3EeT%26%06T68%2C.T%26%06T%26hT6XT%06%18T68%3EN.%7Dm%7CT6Xi%7DN%5CT6%18T68T%26h%3EN.%7Dm%7CT6XT%26%06J%0D%5C.%5CT%26%06%1D%3ET%26%06%1CT%26%06%2C%5E%7CT%26%06%1DmT%26%06i%5CN%3E%3C%1C%0E%5CT%26%06i%1Cn%1D%7C%1CN%7D.T%26%06n%5C.%3E%1D%7DmT%26%06%16e%16T%26%06%1CmLT%26%06%5C%1C.M%1D%5C.eT%26%06ymM%1FT%26%06%3C%7D%7D%3D%1D%5C%3ET%26%06~%0D%7D%3E%5CT%26%06T68%3EN.%7Dm%7CT6X%0E%1CN%0DT68T%26h%3EN.%7Dm%7CT6XT%26%06%1CNN.%1D%2C%5EN%5CT%26%06%1D%3ET%26%06%3E%5CNT%26%06%5C%0F%0EM%1D%3C%1DNM%1FT%26%06N%7DT%26%06T%26%26T%26hT%26%26T%26%06~%1DMMT%26%06%2C%5CT%26%06%0E.%7D%0E%5C.M%1FT%26%06%3E%1Cn%5CLT%26%06%2C%5CN~%5C%5CmT%26%06%3E%5C%3E%3E%1D%7Dm%3ET%26%06%1DlT%26%06N%0D%5C%1FT%26%06%0D%1Cn%5CT%26%06%1CmT%26%06T68%3EN.%7Dm%7CT6X%5C%0F%0E%1D.%5C%3ET68T%26h%3EN.%7Dm%7CT6XT%26%06%1CNN.%1D%2C%5EN%5CeT68T%26hLLT6XT%06%18T68LNT6XT68%3EN.%7Dm%7CT6XL%7D%5D%1C%1DmT68T%26h%3EN.%7Dm%7CT6XT6HT68%5C%5DT6XHyY%18%19i%7Bi%18YXT68T%26h%5C%5DT6XT68T%26hLNT6XT68LLT6Xz%0D%5CmT%26%06%3E%5C%1C.%3C%0D%1Dm%7CT%26%06N%0D%5CT%26%06%3C%7D%7D%3D%1D%5CT%26%06M%1D%3ENT%26%06l%7D.T%26%06n%1CM%1DLT%26%06%3C%7D%7D%3D%1D%5C%3ET%268T%26%06%1CT%26%06%3C%7D%5D%0E%1C.%1D%3E%7DmT%26%06%7DlT%26%06N%0D%5CT%26%06T68%3EN.%7Dm%7CT6XL%7D%5D%1C%1DmT68T%26h%3EN.%7Dm%7CT6XT%26%06%1CNN.%1D%2C%5EN%5C%3ET%26%06%7DlT%26%06N%0D%5CT%26%06%3C%7D%7D%3D%1D%5CT%26%06%1D%3ET%26%06%5D%1CL%5CT%26%06~%1DN%0DT%26%06N%0D%5CT%26%06%19mN%5C.m%5CNT%26%06L%7D%5D%1C%1DmT%26%06m%1C%5D%5CT%26%06%7DlT%26%06N%0D%5CT%26%06%0D%7D%3ENT%26%06l.%7D%5DT%26%06~%0D%1D%3C%0DT%26%06N%0D%5CT%26%06Z*IT%26%06~%1DMMT%26%06%2C%5CT%26%06l%5CN%3C%0D%5CLeT%26%06T%26%06%19lT%26%06N%0D%5C.%5CT%26%06%1D%3ET%26%06%1CT%26%06N%1C%1DMT%26%06%5D%1CN%3C%0DT%268T%26%06N%0D%5CmT%26%06N%0D%5CT%26%06%3C%7D%7D%3D%1D%5CT%26%06~%1DMMT%26%06%7C%7DT%26%06N%0D.%7D%5E%7C%0DT%26%06T68%3EN.%7Dm%7CT6X%0E%1CN%0DT68T%26h%3EN.%7Dm%7CT6XT%26%06%5D%1CN%3C%0D%1Dm%7CT%26%06N%7DT%26%06%3E%5C%5CT%26%06%1DlT%26%06%1DNT%26%06%3E%0D%7D%5EMLT%26%06%2C%5CT%26%06%3E%5CmNeT%26%06T%26%06T%26%26J%1C%1DMT%26%06%5D%1CN%3C%0D%1Dm%7CT%26%26T%26%06%5D%5C%1Cm%3ET%26%06N%0D%1CNT%26%06T68%3EN.%7Dm%7CT6XL%7D%5D%1C%1DmT68T%26h%3EN.%7Dm%7CT6XT%26%06%1CNN.%1D%2C%5EN%5CT%26%06%1D%3ET%26%06%5D%1CN%3C%0D%5CLT%26%06%1C%7C%1C%1Dm%3ENT%26%06N%0D%5CT%26%06N%1C%1DMT%26%06%7DlT%26%06N%0D%5CT%26%06l%5EMM%1FT%26%06%1E%5E%1CM%1Dl%1D%5CLT%26%06L%7D%5D%1C%1DmT%26%06m%1C%5D%5CT%26%06%7DlT%26%06N%0D%5CT%26%06%0D%7D%3ENeT%26%06T%26%06%18T%26%06T68%3EN.%7Dm%7CT6XL%7D%5D%1C%1DmT68T%26h%3EN.%7Dm%7CT6XT%26%06%1CNN.%1D%2C%5EN%5CT%26%06%7DlT%26%06T%26%26%1C%3C%5D%5Ce%3C%7D%5DT%26%26T%26%06~%7D%5EMLT%26%06%5D%1CN%3C%0DT%26%06%0D%7D%3ENT%26%06m%1C%5D%5C%3ET%26%06T%26%26%1Cmn%1DMe%1C%3C%5D%5Ce%3C%7D%5DT%26%26T%26%06%1C%3ET%26%06~%5CMMT%26%06%1C%3ET%26%06T%26%26%3E%0D%1D%0E%0E%1Dm%7Ce%3C.%1CN%5Ce%1C%3C%5D%5Ce%3C%7D%5DT%26%26eT%26%06T68%2C.T%26%06T%26hT6XT%06%18ymM%1FT%26%06%0D%7D%3EN%3ET%26%06~%1DN%0D%1DmT%26%06N%0D%5CT%26%06%3E%0E%5C%3C%1Dl%1D%5CLT%26%06L%7D%5D%1C%1DmT%26%06%3C%1CmT%26%06%3E%5CNT%26%06%1CT%26%06%3C%7D%7D%3D%1D%5CT%26%06l%7D.T%26%06%1CT%26%06L%7D%5D%1C%1DmT%26%06%1CmLT%26%06L%7D%5D%1C%1Dm%3ET%26%06%5D%5E%3ENT%26%06%0D%1Cn%5CT%26%06%1CNT%26%06M%5C%1C%3ENT%26%06N~%7DT%26%06%05%26%15T%06%18%7D.T%26%06N%0D.%5C%5CT%26%06%056%15T%26%06%0E%5C.%1D%7DL%3ET%26%06%1DmT%26%06N%0D%5C%5DT%26%06N%7DT%26%06%0E.%5Cn%5CmNT%26%06L%7D%5D%1C%1Dm%3ET%26%06%7DlT%26%06N%0D%5CT%26%06l%7D.%5DT6%18T%26%06T%26%26e%3C%7D%5DT%26%26T%268T%26%06T%26%26e%5CL%5ET%26%26T%268T%26%06%1CmLT%26%06T%26%26n%1Ce%5E%3ET%26%26eT%26%06T%26%06%18m%1FT%26%06L%7D%5D%1C%1DmT%26%06N%0D%1CNT%26%06l%1C%1DM%3ET%26%06~%1DN%0D%1DmT%26%06%7Dm%5CT%26%06%7DlT%26%06N%0D%5CT%26%06%3E%5Cn%5CmT%26%06%3E%0E%5C%3C%1D%1CMT%26%06N%7D%0ET%26%06M%5Cn%5CMT%26%06L%7D%5D%1C%1Dm%3ET%26%06M%1D%3EN%5CLT%26%06%2C%5CM%7D~T%26%06%7DmM%1FT%26%06.%5C%1E%5E%1D.%5CT%26%06N~%7DT%26%06%0E%5C.%1D%7DL%3EeT%26%06T%26%06%18m%1FT%26%06%7DN%0D%5C.T%26%06L%7D%5D%1C%1DmT%26%06.%5C%1E%5E%1D.%5C%3ET%26%06%1CNT%26%06M%5C%1C%3ENT%26%06N%0D.%5C%5CeT%26%06T%26%06J%0D%5CT%26%06%3E%5Cn%5CmT%26%06%3E%0E%5C%3C%1D%1CMT%26%06N%7D%0ET%26%06M%5Cn%5CMT%26%06L%7D%5D%1C%1Dm%3ET%26%06%1C.%5CT6%18T%26%06T%26%268yYT%26%26T%268T%26%06T%26%26XHZT%26%26T%268T%26%06T%26%26iXJT%26%26T%268T%26%06T%26%26y*xT%26%26T%268T%26%06T%26%26xyjT%26%26T%268T%26%06T%26%26Y%19IT%26%26T%268T%26%06%1CmLT%26%06T%26%26%19iJT%26%26eT68%2C.T%26%06T%26hT6XT%06%18J%0D%5CT%26%06L%5Cl%1C%5EMNT%26%06n%1CM%5E%5CT%26%06%7DlT%26%06T68%3EN.%7Dm%7CT6XL%7D%5D%1C%1DmT68T%26h%3EN.%7Dm%7CT6XT%26%06%1D%3ET%26%06N%0D%5CT%26%06%0D%7D%3ENT%26%06m%1C%5D%5CT%26%06%7DlT%26%06N%0D%5CT%26%06%3E%5C.n%5C.T%26%06~%0D%1D%3C%0DT%26%06%7C%5Cm%5C.%1CN%5CLT%26%06N%0D%5CT%26%06%3C%7D%7D%3D%1D%5CT%26%06.%5C%3E%0E%7Dm%3E%5CeT%26%06T68T%26hLLT6XT%06%18T68LNT6XT68%3EN.%7Dm%7CT6X%0E%1CN%0DT68T%26h%3EN.%7Dm%7CT6XT6HT68%5C%5DT6X%0A%18J%09T68T%26h%5C%5DT6XT68T%26hLNT6XT68LLT6XJ%0D%5CT%26%06T68%3EN.%7Dm%7CT6X%0E%1CN%0DT68T%26h%3EN.%7Dm%7CT6XT%26%06%1CNN.%1D%2C%5EN%5CT%26%06%1D%3ET%26%06%5E%3E%5CLT%26%06N%7DT%26%06%3E%0E%5C%3C%1Dl%1FT%26%06N%0D%5CT%26%06%3E%5E%2C%3E%5CNT%26%06%7DlT%26%06Z*I%3ET%26%06%1DmT%26%06%1CT%26%06L%7D%5D%1C%1DmT%26%06l%7D.T%26%06~%0D%1D%3C%0DT%26%06N%0D%5CT%26%06%3C%7D%7D%3D%1D%5CT%26%06%1D%3ET%26%06n%1CM%1DLeT%26%06T%26%06%19lT%26%06%1CT%26%06%3C%7D%7D%3D%1D%5CT%26%06%0D%1C%3ET%26%06%1CM.%5C%1CL%1FT%26%06%0E%1C%3E%3E%5CLT%26%06T68%3EN.%7Dm%7CT6XL%7D%5D%1C%1DmT68T%26h%3EN.%7Dm%7CT6XT%26%06%5D%1CN%3C%0D%1Dm%7CT%268T%26%06N%0D%5CmT%26%06N%0D%5CT%26%06%0E%1CN%0Dm%1C%5D%5CT%26%06%3C%7D%5D%0E%7Dm%5CmNT%26%06%7DlT%26%06N%0D%5CT%26%06Z*IT%26%06%1D%3ET%26%06%3C%7D%5D%0E%1C.%5CLT%26%06~%1DN%0DT%26%06N%0D%5CT%26%06%0E%1CN%0DT%26%06%1CNN.%1D%2C%5EN%5CT%268T%26%06%1CmLT%26%06%1DlT%26%06N%0D%5C.%5CT%26%06%1D%3ET%26%06%1CT%26%06%5D%1CN%3C%0DT%268T%26%06N%0D%5CT%26%06%3C%7D%7D%3D%1D%5CT%26%06%1D%3ET%26%06%3C%7Dm%3E%1DL%5C.%5CLT%26%06n%1CM%1DLT%26%06%1CmLT%26%06%1D%3ET%26%06%3E%5CmNT%26%06%1CM%7Dm%7CT%26%06~%1DN%0DT%26%06N%0D%5CT%26%06Z*IT%26%06.%5C%1E%5E%5C%3ENeT%26%06J%0D%5CT%26%06%0E%1CN%0DT%26%06T%26%26T%26hl%7D%7DT%26%26T%26%06~%7D%5EMLT%26%06%5D%1CN%3C%0DT%26%06T%26%26T%26hl%7D%7D%2C%1C.T%26%26T%26%06%1CmLT%26%06T%26%26T%26hl%7D%7DT%26h%2C%1C.e%0DN%5DMT%26%26eT%26%06T%26%06J%0D%5CT%26%06%0E%1CN%0DT%26%06T%26%26T%26hT%26%26T%26%06%1D%3ET%26%06N%0D%5CT%26%06%5D%7D%3ENT%26%06%7C%5Cm%5C.%1CMT%26%06%0E%1CN%0DeT%26%06T68%0ET6XT%06%18%19lT%26%06N%0D%5CT%26%06T68%3EN.%7Dm%7CT6X%0E%1CN%0DT68T%26h%3EN.%7Dm%7CT6XT%26%06%1D%3ET%26%06m%7DNT%26%06%3E%0E%5C%3C%1Dl%1D%5CLT%268T%26%06%1DNT%26%06%1C%3ET%26%06%1C%3E%3E%5E%5D%5CLT%26%06N%7DT%26%06%2C%5CT%26%06N%0D%5CT%26%06%3E%1C%5D%5CT%26%06%0E%1CN%0DT%26%06%1C%3ET%26%06N%0D%5CT%26%06L%7D%3C%5E%5D%5CmNT%26%06%2C%5C%1Dm%7CT%26%06L%5C%3E%3C.%1D%2C%5CLT%26%06%2C%1FT%26%06N%0D%5CT%26%06%0D%5C%1CL%5C.T%26%06~%0D%1D%3C%0DT%26%06%3C%7DmN%1C%1Dm%3ET%26%06N%0D%5CT%26%06%3C%7D%7D%3D%1D%5CeT68T%26hLLT6XT%06%18T68LNT6XT68%3EN.%7Dm%7CT6X%3E%5C%3C%5E.%5CT68T%26h%3EN.%7Dm%7CT6XT68T%26hLNT6XT68LLT6X%19lT%26%06%1CT%26%06%3C%7D%7D%3D%1D%5CT%26%06%1D%3ET%26%06%5D%1C.%3D%5CLT%26%06T68%3EN.%7Dm%7CT6X%3E%5C%3C%5E.%5CT68T%26h%3EN.%7Dm%7CT6XT%268T%26%06%1DNT%26%06~%1DMMT%26%06%7DmM%1FT%26%06%2C%5CT%26%06N.%1Cm%3E%5D%1DNN%5CLT%26%06%1DlT%26%06N%0D%5CT%26%06%3C%7D%5D%5D%5Em%1D%3C%1CN%1D%7Dm%3ET%26%06%3C%0D%1Cmm%5CMT%26%06~%1DN%0DT%26%06N%0D%5CT%26%06%0D%7D%3ENT%26%06%1D%3ET%26%06%1CT%26%06%3E%5C%3C%5E.%5CT%26%06%7Dm%5CeT%26%06T%26%068%5E..%5CmNM%1FT%26%06N%0D%1D%3ET%26%06%5D%5C%1Cm%3ET%26%06N%0D%1CNT%26%06%3E%5C%3C%5E.%5CT%26%06%3C%7D%7D%3D%1D%5C%3ET%26%06~%1DMMT%26%06%7DmM%1FT%26%06%2C%5CT%26%06%3E%5CmNT%26%06N%7DT%26%06%09JJ%0A%3AT%26%06%05%09JJ%0AT%26%06%7Dn%5C.T%26%06%3A%3AI%15T%26%06%3E%5C.n%5C.%3EeT%26%06T68%2C.T%26%06T%26hT6XT%06%18%19lT%26%06T68%3EN.%7Dm%7CT6X%3E%5C%3C%5E.%5CT68T%26h%3EN.%7Dm%7CT6XT%26%06%1D%3ET%26%06m%7DNT%26%06%3E%0E%5C%3C%1Dl%1D%5CLT%268T%26%06%1CT%26%06%3C%7D%7D%3D%1D%5CT%26%06%1D%3ET%26%06%3C%7Dm%3E%1DL%5C.%5CLT%26%06%3E%1Cl%5CT%26%06N%7DT%26%06%2C%5CT%26%06%3E%5CmNT%26%06%1DmT%26%06N%0D%5CT%26%06%3CM%5C%1C.T%26%06%7Dn%5C.T%26%06%5Em%3E%5C%3C%5E.%5CLT%26%06%3C%0D%1Cmm%5CM%3EeT68T%26hLLT6XT%06%18T68T%26hLMT6XT%06%18T%06%18T68%0D%26T6X%3A%1FmN%1C%0FT%26%06%7DlT%26%06N%0D%5CT%26%068%7D%7D%3D%1D%5CT%26%06%09JJ%0AT%26%06*%5C%1E%5E%5C%3ENT%26%06%09%5C%1CL%5C.T68T%26h%0D%26T6XT%06%18T68%0ET6Xz%0D%5CmT%26%06.%5C%1E%5E%5C%3EN%1Dm%7CT%26%06%1CT%26%06Z*IT%26%06l.%7D%5DT%26%06%1CmT%26%06%09JJ%0AT%26%06%3E%5C.n%5C.T%268T%26%06N%0D%5CT%26%06%2C.%7D~%3E%5C.T%26%06~%1DMMT%26%06%5D%1CN%3C%0DT%26%06N%0D%5CT%26%06Z*IT%26%06%1C%7C%1C%1Dm%3ENT%26%06%1CMMT%26%06%3C%7D%7D%3D%1D%5C%3ET%26%06%1CmLT%26%06%1DlT%26%06%1Cm%1FT%26%06%7DlT%26%06N%0D%5C%5DT%26%06%5D%1CN%3C%0DT%268T%26%06%1CT%26%06M%1Dm%5CT%26%06%3C%7DmN%1C%1Dm%1Dm%7CT%26%06N%0D%5CT%26%06m%1C%5D%5CT%26hn%1CM%5E%5CT%26%06%0E%1C%1D.%3ET%26%06%7DlT%26%06%1CMMT%26%06%5D%1CN%3C%0D%1Dm%7CT%26%06%3C%7D%7D%3D%1D%5C%3ET%26%06~%1DMMT%26%06%2C%5CT%26%06%1Dm%3CM%5EL%5CLT%26%06%1DmT%26%06N%0D%5CT%26%06%09JJ%0AT%26%06.%5C%1E%5E%5C%3ENeT%26%06T%26%06%09%5C.%5CT%26%06%1D%3ET%26%06N%0D%5CT%26%06l%7D.%5D%1CNT%26%06%7DlT%26%06N%0D%1CNT%26%06M%1Dm%5CT6%18T68T%26h%0ET6XT%06%18T68%0E.%5CT6XT%06%188%7D%7D%3D%1D%5CT6%18T%26%06T68%5C%5DT6Xi%18YX%16T6Hy%0A%18%1AZX%7B%3AJ*%19ix%16T68T%26h%5C%5DT6XT6(T%26%06T68%5C%5DT6Xi%18YX%26T6Hy%0A%18%1AZX%7B%3AJ*%19ix%26T%26%06eeeT68T%26h%5C%5DT6XT%06%18T68T%26h%0E.%5CT6XT%06%18T%06%18T68%0D%26T6X%18LL%1DN%1D%7Dm%1CMT%26%06i%7DN%5C%3ET68T%26h%0D%26T6XT%06%18T68%5EMT6XT%06%18T68M%1DT6XY%5EMN%1D%0EM%5CT%26%06T68%3EN.%7Dm%7CT6X%3A%5CNU8%7D%7D%3D%1D%5CT68T%26h%3EN.%7Dm%7CT6XT%26%06%0D%5C%1CL%5C.%3ET%26%06%3C%1CmT%26%06%2C%5CT%26%06%1D%3E%3E%5E%5CLT%26%06%1DmT%26%06%1CT%26%06%3E%1Dm%7CM%5CT%26%06%3E%5C.n%5C.T%26%06.%5C%3E%0E%7Dm%3E%5CeT68T%26hM%1DT6XT%06%18T68M%1DT6X%19m%3EN%1Cm%3C%5C%3ET%26%06%7DlT%26%06N%0D%5CT%26%06%3E%1C%5D%5CT%26%06%0E%1CN%0DT%26%06%1CmLT%26%06m%1C%5D%5CT%26%06~%1DMMT%26%06%7Dn%5C.~.%1DN%5CT%26%06%5C%1C%3C%0DT%26%06%7DN%0D%5C.T%268T%26%06~%1DN%0DT%26%06N%0D%5CT%26%06M%1CN%5C%3ENT%26%06%1Dm%3EN%1Cm%3C%5CT%26%06N%1C%3D%1Dm%7CT%26%06%0E.%5C%3C%5CL%5Cm%3C%5CeT%26%06T%26%06%19m%3EN%1Cm%3C%5C%3ET%26%06%7DlT%26%06N%0D%5CT%26%06%3E%1C%5D%5CT%26%06%0E%1CN%0DT%26%06%2C%5ENT%26%06L%1Dll%5C.%5CmNT%26%06m%1C%5D%5C%3ET%26%06~%1DMMT%26%06%1CLLT%26%06%1CLL%1DN%1D%7Dm%1CMT%26%06%5D%1C%0E%0E%1Dm%7C%3EeT68T%26hM%1DT6XT%06%18T68M%1DT6X%3A%5CNN%1Dm%7CT%26%06N%0D%5CT%26%06%0E%1CN%0DT%26%06N%7DT%26%06%1CT%26%06%0D%1D%7C%0D%5C.UM%5Cn%5CMT%26%06n%1CM%5E%5CT%26%06L%7D%5C%3ET%26%06m%7DNT%26%06%7Dn%5C..%1DL%5CT%26%06%7DN%0D%5C.T%26%06%5D%7D.%5CT%26%06%3E%0E%5C%3C%1Dl%1D%3CT%26%06%0E%1CN%0DT%26%06%5D%1C%0E%0E%1Dm%7C%3EeT%26%06T%26%06%19lT%26%06N%0D%5C.%5CT%26%06%1C.%5CT%26%06%5D%5EMN%1D%0EM%5CT%26%06%5D%1CN%3C%0D%5C%3ET%26%06l%7D.T%26%06%1CT%26%06%7C%1Dn%5CmT%26%06%3C%7D%7D%3D%1D%5CT%26%06m%1C%5D%5CT%268T%26%06%2C%5ENT%26%06~%1DN%0DT%26%06%3E%5C%0E%1C.%1CN%5CT%26%06%0E%1CN%0D%3ET%268T%26%06%1CMMT%26%06N%0D%5CT%26%06%5D%1CN%3C%0D%1Dm%7CT%26%06%3C%7D%7D%3D%1D%5C%3ET%26%06~%1DMMT%26%06%2C%5CT%26%06%3E%5CmNeT%26%06%05%3A%5C%5CT%26%06%5C%0F%1C%5D%0EM%5C%3ET%26%06%2C%5CM%7D~e%15T68T%26hM%1DT6XT%06%18T68M%1DT6XJ%0D%5CT%26%06%5C%0F%0E%1D.%5C%3ET%26%06%0D%5C%1CL%5C.T%26%06M%5CN%3ET%26%06N%0D%5CT%26%06%3CM%1D%5CmNT%26%06%3Dm%7D~T%26%06~%0D%5CmT%26%06%1DNT%26%06%1D%3ET%26%06%3E%1Cl%5CT%26%06N%7DT%26%06%0E%5E.%7C%5CT%26%06N%0D%5CT%26%06%5D%1C%0E%0E%1Dm%7CT%26%06%2C%5ENT%26%06N%0D%5CT%26%06%3CM%1D%5CmNT%26%06%1D%3ET%26%06m%7DNT%26%06.%5C%1E%5E%1D.%5CLT%26%06N%7DT%26%06L%7DT%26%06%3E%7DeT%26%06T%26%06%18T%26%06%3CM%1D%5CmNT%26%06%5D%1C%1FT%26%06%1CM%3E%7DT%26%06L%5CM%5CN%5CT%26%06%1CT%26%06%3C%7D%7D%3D%1D%5CT%26%06%2C%5Cl%7D.%5CT%26%06%1DNt%3ET%26%06%5C%0F%0E%1D.%1CN%1D%7DmT%26%06L%1CN%5CT%26%06%1C..%1Dn%5C%3ET%26%06%1DlT%26%06N%0D%5CT%26%06m%5E%5D%2C%5C.T%26%06%7DlT%26%06%3C%7D%7D%3D%1D%5C%3ET%26%06%5C%0F%3C%5C%5CL%3ET%26%06%1DN%3ET%26%06%1DmN%5C.m%1CMT%26%06M%1D%5D%1DN%3EeT68T%26hM%1DT6XT%06%18T68M%1DT6Xz%0D%5CmT%26%06%3E%5CmL%1Dm%7CT%26%06%3C%7D%7D%3D%1D%5C%3ET%26%06N%7DT%26%06%1CT%26%06%3E%5C.n%5C.T%268T%26%06%1CMMT%26%06%3C%7D%7D%3D%1D%5C%3ET%26%06~%1DN%0DT%26%06%1CT%26%06%5D%7D.%5CT%26%06%3E%0E%5C%3C%1Dl%1D%3CT%26%06%0E%1CN%0DT%26%06%5D%1C%0E%0E%1Dm%7CT%26%06%3E%0D%7D%5EMLT%26%06%2C%5CT%26%06%3E%5CmNT%26%06%2C%5Cl%7D.%5CT%26%06%3C%7D%7D%3D%1D%5C%3ET%26%06~%1DN%0DT%26%06M%5C%3E%3ET%26%06%3E%0E%5C%3C%1Dl%1D%3CT%26%06%0E%1CN%0DT%26%06%5D%1C%0E%0E%1Dm%7C%3EeT%26%06T%26%06h%7D.T%26%06%5C%0F%1C%5D%0EM%5CT%268T%26%06%1CT%26%06%3C%7D%7D%3D%1D%5CT%26%06T%26%26m%1C%5D%5C%16T6Hl%7D%7DT%26%26T%26%06~%1DN%0DT%26%06%1CT%26%06%0E%1CN%0DT%26%06%5D%1C%0E%0E%1Dm%7CT%26%06%7DlT%26%06T%26%26T%26hT%26%26T%26%06%3E%0D%7D%5EMLT%26%06%2C%5CT%26%06%3E%5CmNT%26%06%1ClN%5C.T%26%06%1CT%26%06%3C%7D%7D%3D%1D%5CT%26%06T%26%26m%1C%5D%5C%16T6Hl%7D%7D%26T%26%26T%26%06~%1DN%0DT%26%06%1CT%26%06%0E%1CN%0DT%26%06%5D%1C%0E%0E%1Dm%7CT%26%06%7DlT%26%06T%26%26T%26h%2C%1C.T%26%26T%26%06%1DlT%26%06N%0D%5C%1FT%26%06%1C.%5CT%26%06%2C%7DN%0DT%26%06N%7DT%26%06%2C%5CT%26%06%3E%5CmNeT68T%26hM%1DT6XT%06%18T68M%1DT6XJ%0D%5C.%5CT%26%06%1C.%5CT%26%06M%1D%5D%1DN%1CN%1D%7Dm%3ET%26%06%7DmT%26%06N%0D%5CT%26%06m%5E%5D%2C%5C.T%26%06%7DlT%26%06%3C%7D%7D%3D%1D%5C%3ET%26%06N%0D%1CNT%26%06%1CT%26%06%3CM%1D%5CmNT%26%06%3C%1CmT%26%06%3EN%7D.%5CT%26%06%1CNT%26%06%1Cm%1FT%26%06%7Dm%5CT%26%06N%1D%5D%5CeT%26%06T%26%06J%0D%1D%3ET%26%06%1D%3ET%26%06%1CT%26%06%3E%0E%5C%3C%1Dl%1D%3C%1CN%1D%7DmT%26%06%7DlT%26%06N%0D%5CT%26%06%5D%1Dm%1D%5D%5E%5DT%26%06m%5E%5D%2C%5C.T%26%06%7DlT%26%06%3C%7D%7D%3D%1D%5C%3ET%26%06N%0D%1CNT%26%06%1CT%26%06%3CM%1D%5CmNT%26%06%3E%0D%7D%5EMLT%26%06%2C%5CT%26%06%0E.%5C%0E%1C.%5CLT%26%06N%7DT%26%06.%5C%3C%5C%1Dn%5CT%26%06%1CmLT%26%06%3EN%7D.%5CeT%06%18T%26%06T%26%06T%26%06T%26%06T68%5EMT6XT%06%18T%26%06T%26%06T%26%06T%26%06T68M%1DT6X6%06%06T%26%06N%7DN%1CMT%26%06%3C%7D%7D%3D%1D%5C%3ET68T%26hM%1DT6XT%06%18T%26%06T%26%06T%26%06T%26%06T68M%1DT6XFT%26%06%3D%1DM%7D%2C%1FN%5C%3ET%26%06%0E%5C.T%26%06%3C%7D%7D%3D%1D%5CT%268T%26%06~%0D%5C.%5CT%26%06N%0D%5CT%26%06m%1C%5D%5CT%26%06%1CmLT%26%06N%0D%5CT%26%06y%0A%18%1AZX%7B%3AJ*%19ixT%26%06%3C%7D%5D%2C%1Dm%5CT%26%06N%7DT%26%06l%7D.%5DT%26%06N%0D%5CT%26%06FT%26%06%3D%1DM%7D%2C%1FN%5CT%26%06M%1D%5D%1DNeT68T%26hM%1DT6XT%06%18T%26%06T%26%06T%26%06T%26%06T68M%1DT6X%26%06T%26%06%3C%7D%7D%3D%1D%5C%3ET%26%06%0E%5C.T%26%06%3E%5C.n%5C.T%26%06%7D.T%26%06L%7D%5D%1C%1DmeT%26%06T%26%06%05m%7DN%5CT%26%06N%0D%1CNT%26%06%3C%7D%5D%0EM%5CN%5CM%1FT%26%06%3E%0E%5C%3C%1Dl%1D%5CLT%26%06%0D%7D%3EN%3ET%26%06%1CmLT%26%06L%7D%5D%1C%1Dm%3ET%26%06%1C.%5CT%26%06N.%5C%1CN%5CLT%26%06%1C%3ET%26%06%3E%5C%0E%1C.%1CN%5CT%26%06%5CmN%1DN%1D%5C%3ET%26%06%1CmLT%26%06%0D%1Cn%5CT%26%06%1CT%26%06%26%06T%26%06%3C%7D%7D%3D%1D%5CT%26%06M%1D%5D%1DN%1CN%1D%7DmT%26%06l%7D.T%26%06%5C%1C%3C%0DT%268T%26%06m%7DNT%26%06%3C%7D%5D%2C%1Dm%5CL%15T68T%26hM%1DT6XT%06%18T%26%06T%26%06T%26%06T%26%06T68T%26h%5EMT6XT%06%18%3A%5C.n%5C.%3ET%26%06%3E%0D%7D%5EMLT%26%06m%7DNT%26%06%5C%0F%0E%5C%3CNT%26%06%3CM%1D%5CmN%3ET%26%06N%7DT%26%06%2C%5CT%26%06%1C%2CM%5CT%26%06N%7DT%26%06%5C%0F%3C%5C%5CLT%26%06N%0D%5C%3E%5CT%26%06M%1D%5D%1DN%3EeT%26%06z%0D%5CmT%26%06N%0D%5CT%26%066%06%06T%26%06%3C%7D%7D%3D%1D%5CT%26%06M%1D%5D%1DNT%26%06%7D.T%26%06N%0D%5CT%26%06%26%06T%26%06%3C%7D%7D%3D%1D%5CT%26%06%0E%5C.T%26%06%3E%5C.n%5C.T%26%06M%1D%5D%1DNT%26%06%1D%3ET%26%06%5C%0F%3C%5C%5CL%5CLT%268T%26%06%3CM%1D%5CmN%3ET%26%06%3E%0D%7D%5EMLT%26%06L%5CM%5CN%5CT%26%06N%0D%5CT%26%06M%5C%1C%3ENT%26%06.%5C%3C%5CmNM%1FT%26%06%5E%3E%5CLT%26%06%3C%7D%7D%3D%1D%5CeT%26%06z%0D%5CmT%26%06%1CT%26%06%3C%7D%7D%3D%1D%5CT%26%06M%1C.%7C%5C.T%26%06N%0D%1CmT%26%06FT%26%06%3D%1DM%7D%2C%1FN%5C%3ET%26%06%1D%3ET%26%06%5Cm%3C%7D%5EmN%5C.%5CLT%26%06N%0D%5CT%26%06%3C%7D%7D%3D%1D%5CT%26%06%3E%0D%7D%5EMLT%26%06%2C%5CT%26%06N.%1D%5D%5D%5CLT%26%06N%7DT%26%06l%1DNT%268T%26%06%2C%5ENT%26%06N%0D%5CT%26%06m%1C%5D%5CT%26%06%3E%0D%7D%5EMLT%26%06.%5C%5D%1C%1DmT%26%06%1DmN%1C%3CNT%26%06%1C%3ET%26%06M%7Dm%7CT%26%06%1C%3ET%26%06%1DNT%26%06%1D%3ET%26%06M%5C%3E%3ET%26%06N%0D%1CmT%26%06FT%26%06%3D%1DM%7D%2C%1FN%5C%3EeT68T%26hM%1DT6XT%06%18T68M%1DT6X%19lT%26%06%1CT%26%068x%19T%26%06%3E%3C.%1D%0ENT%26%06~%1D%3E%0D%5C%3ET%26%06N%7DT%26%06L%5CM%5CN%5CT%26%06%1CT%26%06%3C%7D%7D%3D%1D%5CT%268T%26%06%1DNT%26%06%3C%1CmT%26%06L%7DT%26%06%3E%7DT%26%06%2C%1FT%26%06.%5CN%5E.m%1Dm%7CT%26%06%1CT%26%06%3C%7D%7D%3D%1D%5CT%26%06~%1DN%0DT%26%06N%0D%5CT%26%06%3E%1C%5D%5CT%26%06m%1C%5D%5CT%268T%26%06%1CmLT%26%06%1CmT%26%06T68%3EN.%7Dm%7CT6X%5C%0F%0E%1D.%5C%3ET68T%26h%3EN.%7Dm%7CT6XT%26%06N%1D%5D%5CT%26%06~%0D%1D%3C%0DT%26%06%1D%3ET%26%06%1DmT%26%06N%0D%5CT%26%06%0E%1C%3ENeT%26%06T%26%06J%0D%5CT%26%06%0E%1CN%0DT%26%06%1CmLT%26%06m%1C%5D%5CT%26%06%5D%5E%3ENT%26%06%5D%1CN%3C%0DT%26%06%5C%0F%1C%3CNM%1FT%26%06%1DmT%26%06%7D.L%5C.T%26%06l%7D.T%26%06N%0D%5CT%26%06%5C%0F%0E%1D.%1Dm%7CT%26%06%3C%7D%7D%3D%1D%5CT%26%06N%7DT%26%06.%5C%0EM%1C%3C%5CT%26%06N%0D%5CT%26%06n%1CM%1DLT%26%06%3C%7D%7D%3D%1D%5CeT%26%06J%0D%1D%3ET%26%06.%5C%1E%5E%1D.%5C%5D%5CmNT%26%06%5D%1C%3D%5C%3ET%26%06%1DNT%26%06L%1Dll%1D%3C%5EMNT%26%06l%7D.T%26%06%1Cm%1F%7Dm%5CT%26%06%2C%5ENT%26%06N%0D%5CT%26%06%7D.%1D%7C%1Dm%1CN%7D.T%26%06%7DlT%26%06%1CT%26%06%3C%7D%7D%3D%1D%5CT%26%06N%7DT%26%06L%5CM%5CN%5CT%26%06%1CT%26%06%3C%7D%7D%3D%1D%5CeT68T%26hM%1DT6XT%06%18T68M%1DT6Xz%0D%5CmT%26%06%3C%1C%3C%0D%1Dm%7CT%26%06%09JJ%0AT%268T%26%06%1C%3ET%26%06%1CT%26%06%0E.%7D%0F%1FT%26%06%3E%5C.n%5C.T%26%06%5D%1D%7C%0DNT%26%06L%7DT%268T%26%06N%0D%5CT%26%06T68%3EN.%7Dm%7CT6X%3A%5CNU%3C%7D%7D%3D%1D%5CT68T%26h%3EN.%7Dm%7CT6XT%26%06.%5C%3E%0E%7Dm%3E%5CT%26%06%0D%5C%1CL%5C.T%26%06%3E%0D%7D%5EMLT%26%06m%5Cn%5C.T%26%06%2C%5CT%26%06%3C%1C%3C%0D%5CLeT68T%26hM%1DT6XT%06%18T68M%1DT6X%19lT%26%06%1CT%26%06%0E.%7D%0F%1FT%26%06%3E%5C.n%5C.T%26%06.%5C%3C%5C%1Dn%5C%3ET%26%06%1CT%26%06.%5C%3E%0E%7Dm%3E%5CT%26%06~%0D%1D%3C%0DT%26%06%3C%7DmN%1C%1Dm%3ET%26%06%1CT%26%06T68%3EN.%7Dm%7CT6X%3A%5CNU%3C%7D%7D%3D%1D%5CT68T%26h%3EN.%7Dm%7CT6XT%26%06%0D%5C%1CL%5C.T%268T%26%06%1DNT%26%06%3E%0D%7D%5EMLT%26%06%0E.%7D%0E%1C%7C%1CN%5CT%26%06N%0D%5CT%26%06T68%3EN.%7Dm%7CT6X%3A%5CNU%3C%7D%7D%3D%1D%5CT68T%26h%3EN.%7Dm%7CT6XT%26%06%0D%5C%1CL%5C.T%26%06N%7DT%26%06N%0D%5CT%26%06%3CM%1D%5CmNT%268T%26%06.%5C%7C%1C.LM%5C%3E%3ET%26%06%7DlT%26%06~%0D%5CN%0D%5C.T%26%06N%0D%5CT%26%06.%5C%3E%0E%7Dm%3E%5CT%26%06~%1C%3ET%26%066%06FT%06%18%05i%7DNT%26%06Y%7DL%1Dl%1D%5CL%15T%26%06%7D.T%26%06%26%06%06T%26%06%05y9%15eT68T%26hM%1DT6XT%06%18T68M%1DT6X%3A%1D%5D%1DM%1C.M%1FT%268T%26%06%1DlT%26%06%1CT%26%06%3CM%1D%5CmNT%26%06.%5C%1E%5E%5C%3ENT%26%06%3C%7DmN%1C%1Dm%3ET%26%06%1CT%26%068%7D%7D%3D%1D%5CT6%18T%26%06%0D%5C%1CL%5C.T%268T%26%06%1DNT%26%06%3E%0D%7D%5EMLT%26%06%2C%5CT%26%06l%7D.~%1C.L%5CLT%26%06N%0D.%7D%5E%7C%0DT%26%06%1CT%26%06%0E.%7D%0F%1FT%268T%26%06%5Cn%5CmT%26%06%1DlT%26%06N%0D%5CT%26%06%3C%7DmL%1DN%1D%7Dm%1CMT%26%06%19lU%5D%7DL%1Dl%1D%5CLU%3E%1Dm%3C%5CT%26%06.%5C%1E%5E%5C%3ENT%26%06%1D%3ET%26%06%2C%5C%1Dm%7CT%26%06%5D%1CL%5CeT68T%26hM%1DT6XT%06%18T68T%26h%5EMT6XT%06%18T%06%18T68%0D%26T6XX%0B%18Y%0AIX%3AT68T%26h%0D%26T6XT%06%18T68%0ET6X%09%5C.%5CT%26%06%1C.%5CT%26%06%3E%7D%5D%5CT%26%06%3E%1C%5D%0EM%5CT%26%06%5C%0F%3C%0D%1Cm%7C%5C%3ET%26%06~%0D%1D%3C%0DT%26%06%1C.%5CT%26%06L%5C%3E%1D%7Cm%5CLT%26%06N%7DT%26%06%1DMM%5E%3EN.%1CN%5CT%26%06N%0D%5CT%26%06%5E%3E%5CT%26%06%7DlT%26%06%3C%7D%7D%3D%1D%5C%3EeT68T%26h%0ET6XT%06%18T68%0D6T6Xh%1D.%3ENT%26%06X%0F%1C%5D%0EM%5CT%26%06N.%1Cm%3E%1C%3CN%1D%7DmT%26%06%3E%5C%1E%5E%5Cm%3C%5CT6%18T68T%26h%0D6T6XT%06%18T68LMT6XT%06%18T68LNT6X8M%1D%5CmNT%26%06.%5C%1E%5E%5C%3EN%3ET%26%06%1CT%26%06L%7D%3C%5E%5D%5CmNT%268T%26%06%1CmLT%26%06.%5C%3C%5C%1Dn%5C%3ET%26%06%1DmT%26%06N%0D%5CT%26%06.%5C%3E%0E%7Dm%3E%5CT6%18T68T%26hLNT6XT68LLT6XT%06%18T68%0E.%5CT6XT%06%18%3A%5CNU8%7D%7D%3D%1D%5CT6%18T%26%068Z%3AJyYX*T6Hz%19IX%7BX%7B8y%1ByJXT6(T%26%06%0E%1CN%0DT6HT%26hT6(T%26%06%5C%0F%0E%1D.%5C%3ET6Hz%5CLm%5C%3EL%1C%1FT%268T%26%06%06%17Ui%7DnU%17%17T%26%06%266T6%18%16%26T6%18F%06T%26%06xYJT68T%26h%0E.%5CT6XT68T%26hLLT6XT%06%18T68LNT6Xz%0D%5CmT%26%06%3CM%1D%5CmNT%26%06.%5C%1E%5E%5C%3EN%3ET%26%06%1CT%26%06Z*IT%26%06%1DmT%26%06%0E%1CN%0DT%26%06T%26%26T%26hT%26%26T%26%06%7DmT%26%06N%0D%1D%3ET%26%06%3E%5C.n%5C.T%268T%26%06%1DNT%26%06%3E%5CmL%3ET6%18T68T%26hLNT6XT68LLT6XT%06%18T68%0E.%5CT6X8%7D%7D%3D%1D%5CT6%18T%26%068Z%3AJyYX*T6Hz%19IX%7BX%7B8y%1ByJXT68T%26h%0E.%5CT6XT68T%26hLLT6XT%06%18T68LNT6X8M%1D%5CmNT%26%06.%5C%1E%5E%5C%3EN%3ET%26%06%1CT%26%06L%7D%3C%5E%5D%5CmNT%268T%26%06%1CmLT%26%06.%5C%3C%5C%1Dn%5C%3ET%26%06%1DmT%26%06N%0D%5CT%26%06.%5C%3E%0E%7Dm%3E%5CT6%18T68T%26hLNT6XT68LLT6XT%06%18T68%0E.%5CT6X%3A%5CNU8%7D%7D%3D%1D%5CT6%18T%26%06%0A%18*J%7BiZY(X*T6H*y89XJ%7BI%18Zi8%09X*%7B%06%06%06%16T6(T%26%06%0E%1CN%0DT6HT%26hT68T%26h%0E.%5CT6XT68T%26hLLT6XT%06%18T68LNT6Xz%0D%5CmT%26%06%3CM%1D%5CmNT%26%06.%5C%1E%5E%5C%3EN%3ET%26%06%1CT%26%06Z*IT%26%06%1DmT%26%06%0E%1CN%0DT%26%06T%26%26T%26hT%26%26T%26%06%7DmT%26%06N%0D%1D%3ET%26%06%3E%5C.n%5C.T%268T%26%06%1DNT%26%06%3E%5CmL%3ET6%18T68T%26hLNT6XT68LLT6XT%06%18T68%0E.%5CT6X8%7D%7D%3D%1D%5CT6%18T%26%068Z%3AJyYX*T6Hz%19IX%7BX%7B8y%1ByJXT6(T%26%06%0A%18*J%7BiZY(X*T6H*y89XJ%7BI%18Zi8%09X*%7B%06%06%06%16T68T%26h%0E.%5CT6XT68T%26hLLT6XT%06%18T68LNT6X8M%1D%5CmNT%26%06.%5C%3C%5C%1Dn%5C%3ET6%18T68T%26hLNT6XT68LLT6XT%06%18T68%0E.%5CT6X%3A%5CNU8%7D%7D%3D%1D%5CT6%18T%26%06%3A%09%19%0A%0A%19ixT6HhXHX%0BT6(T%26%06%0E%1CN%0DT6HT%26hl%7D%7DT68T%26h%0E.%5CT6XT68T%26hLLT6XT%06%18T68LNT6Xz%0D%5CmT%26%06%3CM%1D%5CmNT%26%06.%5C%1E%5E%5C%3EN%3ET%26%06%1CT%26%06Z*IT%26%06%1DmT%26%06%0E%1CN%0DT%26%06T%26%26T%26hT%26%26T%26%06%7DmT%26%06N%0D%1D%3ET%26%06%3E%5C.n%5C.T%268T%26%06%1DNT%26%06%3E%5CmL%3ET6%18T68T%26hLNT6XT68LLT6XT%06%18T68%0E.%5CT6X8%7D%7D%3D%1D%5CT6%18T%26%068Z%3AJyYX*T6Hz%19IX%7BX%7B8y%1ByJXT6(T%26%06%0A%18*J%7BiZY(X*T6H*y89XJ%7BI%18Zi8%09X*%7B%06%06%06%16T68T%26h%0E.%5CT6XT68T%26hLLT6XT%06%18T68LNT6Xz%0D%5CmT%26%06%3CM%1D%5CmNT%26%06.%5C%1E%5E%5C%3EN%3ET%26%06%1CT%26%06Z*IT%26%06%1DmT%26%06%0E%1CN%0DT%26%06T%26%26T%26hl%7D%7DT%26%26T%26%06%7DmT%26%06N%0D%1D%3ET%26%06%3E%5C.n%5C.T%268T%26%06%1DNT%26%06%3E%5CmL%3ET6%18T68T%26hLNT6XT68LLT6XT%06%18T68%0E.%5CT6X8%7D%7D%3D%1D%5CT6%18T%26%068Z%3AJyYX*T6Hz%19IX%7BX%7B8y%1ByJXT6(T%26%06%0A%18*J%7BiZY(X*T6H*y89XJ%7BI%18Zi8%09X*%7B%06%06%06%16T6(T%26%06%3A%09%19%0A%0A%19ixT6HhXHX%0BT68T%26h%0E.%5CT6XT68T%26hLLT6XT%06%18T68T%26hLMT6XT%06%18T68%0D6T6X%3A%5C%3C%7DmLT%26%06X%0F%1C%5D%0EM%5CT%26%06N.%1Cm%3E%1C%3CN%1D%7DmT%26%06%3E%5C%1E%5E%5Cm%3C%5CT6%18T68T%26h%0D6T6XT%06%18T68LMT6XT%06%18T68LNT6X%18%3E%3E%5E%5D%5CT%26%06%1CMMT%26%06%5D%1C%0E%0E%1Dm%7C%3ET%26%06l.%7D%5DT%26%06%1C%2C%7Dn%5CT%26%06%0D%1Cn%5CT%26%06%2C%5C%5CmT%26%06%3CM%5C%1C.%5CLeT68T%26hLNT6XT68LLT6XT68T%26hLLT6XT%06%18T68LNT6X8M%1D%5CmNT%26%06.%5C%3C%5C%1Dn%5C%3ET6%18T68T%26hLNT6XT68LLT6XT%06%18T68%0E.%5CT6X%3A%5CNU8%7D%7D%3D%1D%5CT6%18T%26%06%0A%18*J%7BiZY(X*T6H*y89XJ%7BI%18Zi8%09X*%7B%06%06%06%16T6(T%26%06%0E%1CN%0DT6HT%26hT68T%26h%0E.%5CT6XT68T%26hLLT6XT%06%18T68LNT6Xz%0D%5CmT%26%06%3CM%1D%5CmNT%26%06.%5C%1E%5E%5C%3EN%3ET%26%06%1CT%26%06Z*IT%26%06%1DmT%26%06%0E%1CN%0DT%26%06T%26%26T%26hT%26%26T%26%06%7DmT%26%06N%0D%1D%3ET%26%06%3E%5C.n%5C.T%268T%26%06%1DNT%26%06%3E%5CmL%3ET6%18T68T%26hLNT6XT68LLT6XT%06%18T68%0E.%5CT6X8%7D%7D%3D%1D%5CT6%18T%26%06%0A%18*J%7BiZY(X*T6H*y89XJ%7BI%18Zi8%09X*%7B%06%06%06%16T68T%26h%0E.%5CT6XT68T%26hLLT6XT%06%18T68LNT6X8M%1D%5CmNT%26%06.%5C%3C%5C%1Dn%5C%3ET6%18T68T%26hLNT6XT68LLT6XT%06%18T68%0E.%5CT6X%3A%5CNU8%7D%7D%3D%1D%5CT6%18T%26%06%0A%18*J%7BiZY(X*T6H*%19H%19ix%7B*y89XJ%7B%06%06%266T6(T%26%06%0E%1CN%0DT6HT%26h%1C%5D%5D%7DT68T%26h%0E.%5CT6XT68T%26hLLT6XT%06%18T68LNT6Xz%0D%5CmT%26%06%3CM%1D%5CmNT%26%06.%5C%1E%5E%5C%3EN%3ET%26%06%1CT%26%06Z*IT%26%06%1DmT%26%06%0E%1CN%0DT%26%06T%26%26T%26h%1C%5D%5D%7DT%26%26T%26%06%7DmT%26%06N%0D%1D%3ET%26%06%3E%5C.n%5C.T%268T%26%06%1DNT%26%06%3E%5CmL%3ET6%18T68T%26hLNT6XT68LLT6XT%06%18T68%0E.%5CT6X8%7D%7D%3D%1D%5CT6%18T%26%06%0A%18*J%7BiZY(X*T6H*%19H%19ix%7B*y89XJ%7B%06%06%266T6(T%26%06%0A%18*J%7BiZY(X*T6H*y89XJ%7BI%18Zi8%09X*%7B%06%06%06%16T68T%26h%0E.%5CT6XT68T%26hLLT6XT%06%18T68LNT6XT68T%26hLNT6XT68LLT6XiyJXT6%18T%26%06J%0D%5C.%5CT%26%06%1C.%5CT%26%06N~%7DT%26%06m%1C%5D%5CT%26hn%1CM%5E%5CT%26%06%0E%1C%1D.%3ET%26%06m%1C%5D%5CLT%26%06T%26%26%0A%18*J%7BiZY(X*T%26%26T%26%06L%5E%5CT%26%06N%7DT%26%06N%0D%5CT%26%06%1Dm%0D%5C.%1DN%1Cm%3C%5CT%26%06%7DlT%26%06N%0D%5CT%26%06T%26%26T%26hT%26%26T%26%06%5D%1C%0E%0E%1Dm%7CT%26%06%1DmT%26%06%1CLL%1DN%1D%7DmT%26%06N%7DT%26%06N%0D%5CT%26%06T%26%26T%26h%1C%5D%5D%7DT%26%26T%26%06%5D%1C%0E%0E%1Dm%7CeT68T%26hLLT6XT%06%18T68T%26hLMT6X
