#! /usr/bin/perl
# Performs some well-formedness checks on the raw input for the
# Kln-Bonn tube map. Outputs some error messages (if bnecessary) and
# a (tab-separated) CSV file with basic statistics on stations.
#
# Gisbert W. Selke, TapirSoft Selke & Selke GbR, Jan 2015

use Modern::Perl;

my $line = '??';
my %stations;

while (<>) {
  chomp;
  s/^\s+//;
  s/\s+$//;
  s/\s+/ /g;
  next if /^\s*$/;
  if (/^#(.+)/) {
    $line = $1;
    next;
  }
  $stations{$_} //= { };
  if ( $stations{$_}{$line} ) {
    say "Station $_ names line $line more than once";
    next;
  }
  $stations{$_}{$line}++;
}

for ( sort { lc($a) cmp lc($b) } keys %stations ) {
  say join( "\t", $_, scalar( keys %{ $stations{$_} } ), sort keys %{ $stations{$_} } );
}

