use lib 't';
use ExtUtils::testlib;
use Storable::AMF0 qw(ref_lost_memory ref_destroy);
use Scalar::Util qw(refaddr);
use GrianUtils;
use strict;
no warnings 'once';
eval 'use Test::More tests => 6+6;';
use warnings;
no warnings 'once';
our $msg;
sub tt(&);
sub tt(&){
    my $sub = shift;
    my $s = ref_mem_safe( $sub );
    $msg = $s;
    return ($s)if $s;
    return undef;
}

my $a1 = [];
ok(! ref_lost_memory([]));
ok(! ref_lost_memory([[]]));
ok(! ref_lost_memory([{}]));
ok(! ref_lost_memory([$a1, $a1]));

my $a2 = []; @$a2=$a2;

ok( ref_lost_memory($a2));

ref_destroy($a2);
ref_destroy("");
ref_destroy(1);
ref_destroy({});
ref_destroy([]);

my $addr;
my %c;
for (1..20)
{
    my $a3 = [];
    @$a3= $a3;
    $addr = refaddr $a3;
    ref_destroy($a3);
    #say STDERR refaddr($a3) unless $c{refaddr $a3}++;
}

{
    my $a3 = [];
    @$a3= $a3;
    is($addr, refaddr $a3);
    $addr = refaddr $a3;
}

use GrianUtils qw(ref_mem_safe);

ok(tt {}     , "a $msg " );
ok(tt { {};} , "a $msg "  );
ok(tt { [];} , "a $msg " );
ok(tt { [{a=>1}, [123, qw(123)]];} , "a $msg " );
ok(tt { my $a = { bbb=>123, adf=>[], }; } , "a $msg " );
ok(! tt { my @a; @a=(\@a, \@a); 0} , "self ref $msg");
#ok(tt { my $a = { bbb=>123, adf=>[], }; return [{a=>1}, [123, qw(123), $a], a=>$a];},  );

no warnings;
