package App::Manoc::DB::Search::Result::MacAddr;
#ABSTRACT:  Mac address search result

use Moose;

our $VERSION = '2.99.3'; ##TRIAL VERSION

extends 'App::Manoc::DB::Search::Result::Item';
with 'App::Manoc::DB::Search::Result::Group';

has address => (
    is         => 'ro',
    isa        => 'Str',
    lazy_build => 1,
    builder    => '_build_address'
);

sub _build_address { $_[0]->match }

no Moose;
__PACKAGE__->meta->make_immutable;

__END__

=pod

=head1 NAME

App::Manoc::DB::Search::Result::MacAddr - Mac address search result

=head1 VERSION

version 2.99.3

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
