package App::Manoc::Search::Item;
#ABSTRACT: A search result item

use Moose;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use namespace::autoclean;

with 'App::Manoc::Search::Widget::ApplyRole';


has 'item_type' => (
    is       => 'ro',
    isa      => 'Str',
    required => 1
);


has 'timestamp' => (
    is      => 'ro',
    isa     => 'Int',
    default => 0,
);


has 'match' => (
    is       => 'ro',
    isa      => 'Str',
    required => 1,
);


has 'key' => (
    is      => 'ro',
    lazy    => 1,
    builder => '_build_key',
);


has 'text' => (
    is       => 'ro',
    isa      => 'Str',
    required => 0,
);

sub _build_key { $_[0]->match }


has widget => (
    is      => 'ro',
    isa     => 'Str',
    lazy    => 1,
    default => sub { [ split( /::/, ref( $_[0] ) ) ]->[-1] }
);


sub load_widgets {
    my $self = shift;

    $self->apply_widget_role( $self, $self->widget );
}

no Moose;
__PACKAGE__->meta->make_immutable;

__END__

=pod

=head1 NAME

App::Manoc::Search::Item - A search result item

=head1 VERSION

version 2.99.2

=head1 ATTRIBUTES

=head2 item_type

=head2 timestamp

unixtime

=head2 match

=head2 key

used for sorting, defaults to match

=head2 text

=head2 widget

Name of the widget to render this item.

=head1 METHODS

=head2 load_widgets

Load the widget and apply its role

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
