use strict;
use warnings;
use inc::Module::Install;

all_from 'lib/Text/Xslate.pm';

use_ppport 3.19;
cc_warnings;

requires 'Mouse'                => '0.55';
requires 'MouseX::NativeTraits' => '0.002';

test_requires 'Test::More' => 0.88; # done_testing()
test_requires 'Test::Requires';
test_requires 'Test::LeakTrace';

tests_recursive 't';

cc_src_paths qw(xs);

auto_set_repository() if -d '.git';

postamble <<'M';
# xslate_ops.h is automatically generated by xs/Text-Xslate.xs
xslate_ops.h :: xs/Text-Xslate.xs tool/opcode.pl pm_to_blib
	$(PERLRUNINST) tool/opcode.pl xs/Text-Xslate.xs >xslate_ops.h
M

clean_files qw(
    Text-Xslate-* *.stackdump
    *.gcda *.gcno *.gcov
    nytprof *.out
    cover_db
);

WriteAll(check_nmake => 0);

