package Lingua::EN::Opinion::Emotion;
$Lingua::EN::Opinion::Emotion::VERSION = '0.04';
our $AUTHORITY = 'cpan:GENE';

use Moo;
use strictures 2;
use namespace::clean;


has wordlist => (
    is      => 'ro',
    builder => 1,
);

sub _build_wordlist {
    my %wordlist = (
        aback => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abacus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        abandon => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        abandoned => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        abandonment => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        abate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abatement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abba => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        abbot => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        abbreviate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abbreviation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abdomen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abdominal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abduction => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        aberrant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aberration => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abeyance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abhor => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abhorrent => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abide => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ability => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        abject => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ablation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ablaze => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abnormal => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aboard => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abode => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abolish => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abolition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abominable => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abomination => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aboriginal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abort => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abortion => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        abortive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        abound => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abovementioned => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        abrasion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abroad => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abrogate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abrupt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        abruptly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abscess => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        absence => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        absent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        absentee => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        absenteeism => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        absinthe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        absolute => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        absolution => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        absorbed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        absorbent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        absorbing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        absorption => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abstain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abstention => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abstinence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abstract => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abstraction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        absurd => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        absurdity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abundance => { anger => 0, anticipation => 1, disgust => 1, fear => 0, joy => 1, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        abundant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        abuse => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        abutment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aby => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        abysmal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        abyss => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        academic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        academy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        accede => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accelerate => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acceleration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accentuate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accept => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acceptable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        acceptance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        access => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accessible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        accession => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accessory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accident => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        accidental => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        accidentally => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        accolade => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        accommodate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accommodation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        accompaniment => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        accompany => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accompanying => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accomplice => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accomplish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        accomplished => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        accomplishment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        accord => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        accordance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accordion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        account => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        accountability => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        accountable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        accountant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        accounting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accounts => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        accredited => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        accretion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accrue => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accueil => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        accumulate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accumulation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accuracy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accurate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        accursed => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        accusation => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accusative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accused => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accuser => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accusing => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        accustomed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ace => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        acetic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ache => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        achieve => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        achievement => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        aching => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        acid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acidity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acknowledge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acknowledged => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acknowledgment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        acme => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acoustic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acoustics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acquaint => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acquaintance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acquainted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acquiescence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acquire => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        acquiring => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        acquisition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acquisitions => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acreage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acres => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acrobat => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        act => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        action => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        actionable => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        active => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        activity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        actor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        actual => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        actuality => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        actuary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acuity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        acumen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        acupuncture => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        acutely => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adamant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adapt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        adaptable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        add => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        added => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        addendum => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adder => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        addiction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        addition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        additional => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        additive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        address => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        addressee => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        addresses => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        adept => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        adequacy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        adequate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adhere => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adherence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adherent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adhering => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        adhesion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adhesive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adieu => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adipose => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adjacency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adjacent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adjective => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adjoining => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adjourn => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adjournment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adjudicate => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adjudication => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adjunct => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        adjust => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adjustment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adjuvant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        administer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        administration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        administrative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        admirable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        admiral => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        admiralty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        admiration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        admire => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        admirer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        admissibility => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        admissible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        admission => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        admit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        admittance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        admitted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        admitting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        admixture => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        admonition => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ado => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adobe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adolescence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adolescent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adopt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adoption => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adorable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        adoration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        adore => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        adorn => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adornment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adrift => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        adult => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adulterated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adultery => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        advance => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        advanced => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        advancement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        advancing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        advantage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        advantageous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        advent => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        adventure => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        adventurer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adventurous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        adversary => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adverse => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        adversity => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        advertise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        advertisement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        advice => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        advisable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        advise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        advised => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        advisement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        adviser => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        advocacy => { anger => 1, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        advocate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        aegis => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aeration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aerial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aerodrome => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aerodynamics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aeronautics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aeroplane => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aesthetic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        aesthetics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        aetiology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        afar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        affable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        affair => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        affecting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        affection => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        affections => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        affiche => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        affidavit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        affiliated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        affiliation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        affinity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        affirm => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        affirmation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        affirmative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        affirmatively => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        affix => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        afflict => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        afflicted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        affliction => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        affluence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        affluent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        afford => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        affront => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        afield => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        afore => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aforementioned => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aforesaid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        afraid => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        afresh => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aft => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aftermath => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        afternoon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aftertaste => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        afterthought => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aga => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        agate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        age => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aged => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        agency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        agent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        agglomeration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aggravated => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aggravating => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        aggravation => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aggregate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aggregation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aggression => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aggressive => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aggressor => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aghast => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        agile => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        agility => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        agitated => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        agitation => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        agnostic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ago => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        agonizing => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        agony => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        agree => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        agreeable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        agreed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        agreeing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        agreement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        agricultural => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        agriculture => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        aground => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        agua => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ahead => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        aid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        aiding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        ail => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        ailing => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        ailment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aim => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aimless => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        air => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        airbag => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        airlift => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        airline => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        airman => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        airplane => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        airport => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        airs => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        airship => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aisle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ait => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ajar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        akin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        alabaster => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        alarm => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        alarming => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        alb => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        album => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alchemy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alcohol => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alcoholism => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        alcove => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alert => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alertness => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        alerts => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        alfalfa => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        algebra => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        algebraic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        algorithm => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alibi => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alien => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alienate => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alienated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        alienation => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        alight => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aligned => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alignment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alike => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alimentation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        alimony => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aliquot => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alive => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        alkali => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alkaloids => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        allay => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        allegation => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        allege => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alleged => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        allegiance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        allegorical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        allegory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        allegro => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        alleviate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        alleviation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        alley => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alliance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        allied => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        alligator => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        allocate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        allocation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        allot => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        allotment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        allowable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        allowance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        allowed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alloy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        allure => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        alluring => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        allusion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alluvial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ally => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        almanac => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        almighty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        aloft => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aloha => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        alongside => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aloof => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aloud => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alphabet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alphabetical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        altar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alteration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        altercation => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        altered => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alternate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alternative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        altitude => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alto => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        altogether => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alumnus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        alveolar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amalgam => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amalgamation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amass => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amateur => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amaze => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        amazement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amazingly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        ambassador => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        amber => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ambient => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ambiguity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ambiguous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ambit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ambition => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        ambitious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ambulance => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        ambush => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        ameliorate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        amen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        amenable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        amend => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        amendment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amends => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        amenity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        amethyst => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amiable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        amicable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        amid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amidst => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ammonia => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ammunition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amnesia => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amnesty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        amorphous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amortization => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        amount => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amour => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        ampersand => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amphetamines => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amphibian => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amphibious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amphitheater => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amplification => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amplify => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amplitude => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amply => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amputation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amulet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        amuse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        amused => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        amusement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        amusing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        ana => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anaconda => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anaesthesia => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anaesthetic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        analgesic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        analogous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        analogue => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        analogy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        analysis => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        analyst => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        analytic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        analyze => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        analyzer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anarchism => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anarchist => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anarchy => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anastomosis => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anathema => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        anatomic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anatomy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ancestor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ancestral => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        ancestry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anchor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        anchorage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 1, surprise => 0, trust => 0 },
        ancient => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ancillary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        androgen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anemone => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anew => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        angel => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        angelic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        anger => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        angina => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        angiography => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        angle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        angling => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        angry => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anguish => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        angular => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anhydrous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        animal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        animate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        animated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        animation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        animosity => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        animus => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ankle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        annals => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        annex => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        annexation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        annexe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        annihilate => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        annihilated => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        annihilation => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        annotate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        annotation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        announce => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        announcement => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        annoy => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        annoyance => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        annoying => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        annuity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        annul => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        annular => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        annulment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        annulus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anointing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anomalous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anomaly => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        anon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anonymous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        answer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        answerable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        answering => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antagonism => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antagonist => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antagonistic => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ante => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antecedent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antelope => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antenna => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anterior => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anthem => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anthology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anthrax => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        anthropology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antibiotic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antibiotics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        antichrist => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anticipation => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anticipatory => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antidote => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        antifungal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        antimony => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antipathy => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antiquarian => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antiquated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antique => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        antiquity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antiseptic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        antisocial => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        antithesis => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antithetical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antiviral => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        antler => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anvil => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        anxiety => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        anxious => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aorta => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apace => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apache => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apartment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apathetic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        apathy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        ape => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aperture => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apex => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aphid => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apiece => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aplomb => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        apocalyptic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apologetic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        apologist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apologize => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 1, surprise => 0, trust => 1 },
        apology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        apostasy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apostate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apostle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        apostolic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        apostrophe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appalling => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apparatus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apparel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apparently => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apparition => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        appeal => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appearance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appease => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appellant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        append => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appendage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appendicitis => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        appendix => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appetite => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appetizer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        applause => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        apple => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appliance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appliances => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        applicability => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        applicable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        applicant => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        application => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apply => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appoint => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appointment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appointments => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apportion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apportionment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appraise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appreciable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appreciation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        apprehend => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apprehension => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apprehensive => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apprentice => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        apprenticeship => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        approach => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        approaching => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        approbation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        appropriation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        approval => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        approve => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        approving => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        approximate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        approximately => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        approximating => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        approximation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        appurtenances => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apron => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        apt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        aptitude => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        aqua => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aquamarine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aquarium => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aquatic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aqueduct => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aqueous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arbiter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        arbitrate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arbitration => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arbitrator => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        arbor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arc => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arcade => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        archaeological => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        archaeologist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        archaeology => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        archaic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        archbishop => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arched => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        archer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        archery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        archetype => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        archipelago => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        architect => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        architecture => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        archive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arctic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ardent => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        ardor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        arduous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        area => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arena => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        areola => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        argent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        argue => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        argument => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        argumentation => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        argumentative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arguments => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        aristocracy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        aristocrat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aristocratic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        arithmetic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ark => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arm => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        armada => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        armament => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        armaments => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        armature => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        armed => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        armor => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        armored => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        armory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        arms => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        army => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aroma => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        arousal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arouse => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        arraignment => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        arrange => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arranged => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arrangement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        array => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        arrears => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arrest => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arrival => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arrive => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arrogance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arrogant => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arrow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arsenal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arsenic => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        arson => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        art => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 1, surprise => 1, trust => 0 },
        artery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        artful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        arthropod => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        artichoke => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        article => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        articles => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        articulate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        articulation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        artifice => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        artillery => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        artisan => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        artist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        artiste => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        artistic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        artists => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ascend => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ascendancy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        ascension => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ascent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        ascertain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ascertained => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ascetic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ash => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ashamed => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        ashes => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        asleep => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        asp => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aspartame => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aspect => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aspects => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        asphalt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aspiration => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        aspire => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        aspiring => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        ass => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assail => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        assailant => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        assassin => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        assassinate => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assassination => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        assault => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assay => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assemblage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assemble => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assembled => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assembly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        assent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        assert => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        asserting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        assertion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assess => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assessment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 1 },
        assessor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        assets => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        asshole => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assign => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assignee => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        assignment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assimilate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assimilation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        assistance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        assistant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        associate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        association => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        assorted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assortment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assuage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        assumed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assuming => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assumption => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        assurance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        assure => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        assured => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        assuredly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        asterisk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        asteroids => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        astigmatism => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        astonishingly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        astonishment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        astral => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        astray => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        astringent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        astrologer => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        astrology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        astronaut => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        astronomer => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        astronomy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        astute => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        asunder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        asylum => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        asymmetric => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        asymmetry => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        asymptotic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        atelier => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        atheism => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        atheist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        atheistic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        atherosclerosis => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        athlete => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        athletic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        athleticism => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        athletics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        atlas => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        atmosphere => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        atmospheric => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        atoll => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        atom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        atomic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        atone => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        atonement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        atrium => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        atrocious => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        atrocity => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        atrophy => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        attach => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        attachment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        attack => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        attacking => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        attain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        attainable => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        attainment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        attempt => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        attendance => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        attendant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        attention => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        attentive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        attenuate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        attenuated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        attenuation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        attest => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        attestation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        attic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        attire => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        attitude => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        attorney => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        attraction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        attractiveness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        attributable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        attribute => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        attribution => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        attrition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        auburn => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        auction => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        auctioneer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        audacious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        audacity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        audible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        audience => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        audit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        audition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        auditor => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        auditorium => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        auditory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aught => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        augment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        augmentation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        august => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        aunt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        aura => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        aurora => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        auspices => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        auspicious => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        austere => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        austerity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        authentic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        authenticate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        authentication => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        authenticity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        author => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        authoritative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        authority => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        authorization => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        authorize => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        authorized => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        authorship => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        auto => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        autobiography => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        autocratic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        autograph => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        automatic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        automobile => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        autonomy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        autopsy => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        autumn => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        auxiliary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        avail => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        avalanche => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        avarice => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        avatar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        avenger => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        avenue => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aver => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        average => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        averse => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aversion => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        avert => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aviary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aviation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        aviator => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        avid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        avocado => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        avoid => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        avoidance => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        avoiding => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        await => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        awake => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        awaken => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        award => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        awe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        awful => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        awkwardness => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        awning => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        awry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        axial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        axiom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        axiomatic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        axis => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        axle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ay => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        aye => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        azimuth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        azure => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        babble => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        babbling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        baboon => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        baby => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        babysitter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        baccalaureate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        baccarat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bachelor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        back => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        backbone => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        backer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        backfire => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        backgammon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        background => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        backhoe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        backpacker => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        backtrack => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        backward => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        backwards => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        backwater => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bacteria => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bacterium => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bad => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        badge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        badger => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        badly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        badness => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        baffle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bag => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        baggage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        baggy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bagpipes => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bail => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bailiff => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        bait => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        bake => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bakery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        baking => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        balance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        balanced => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        balcony => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bald => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bale => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        balk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ball => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ballad => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        ballast => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ballet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        balloon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ballot => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        ballroom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        balm => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        balmy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        balsam => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        balsamic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ban => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        banana => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        band => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bandage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bandit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bandwagon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bane => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bang => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        banger => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        banish => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        banished => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        banishment => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        banjo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bank => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        banker => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        bankrupt => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bankruptcy => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        banner => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        banquet => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        banshee => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        banter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        baptism => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        baptismal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barb => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barbarian => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barbaric => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barbarism => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barbecue => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barbed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bard => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bareback => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barefoot => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barely => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barf => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bargain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        barge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        baritone => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bark => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barn => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barney => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barometer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        baron => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        baroque => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barrack => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barred => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barrel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barren => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        barricade => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barrier => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barring => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barrister => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        barrow => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bartender => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        barter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        base => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        baseball => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        baseboard => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        baseless => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        basement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        basilica => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        basin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        basis => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bask => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        basket => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        basketball => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bass => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        basso => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bassoon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bastard => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bastion => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        batch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        batching => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bath => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bathe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bathroom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bathymetry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        baton => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        battalion => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        batter => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        battered => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        battery => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        battle => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        battled => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        battlefield => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bawdy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bay => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bayonet => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bayou => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bazaar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beach => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beacon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bead => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beading => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beads => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beagle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beak => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beaker => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beam => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        beaming => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bear => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beard => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bearded => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bearer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bearing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bearings => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bearish => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beast => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beastly => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beating => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        beau => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beautification => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        beautiful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        beautify => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        beauty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        beck => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beckon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bedding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bedrock => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        bedroom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bedtime => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bee => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beef => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beehive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        beeswax => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beetle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        befall => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        befitting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        befriend => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        beg => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        beggar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        begging => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        begin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beginner => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beginning => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        begun => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        behavior => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        behemoth => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        behest => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        behold => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beholden => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beholder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        belated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        belay => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        belief => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        believed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        believer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        believing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        belittle => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bell => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        belligerent => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bellow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bellows => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        belly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        belongings => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        belt => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bemused => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bench => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bend => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bender => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bending => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beneath => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        benefactor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        beneficial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        beneficiary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        benefit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        benevolence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        benign => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        benzene => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bequeath => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bequest => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        bereaved => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bereavement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bereft => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bergamot => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        berlin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        berserk => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        berth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        beseech => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beset => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bestial => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bestow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        betray => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        betrayal => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        betrothed => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        betterment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        betting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        betty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bevel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beverage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bevy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        beware => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bewildered => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        bewilderment => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        bias => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        biased => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bib => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        biblical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bibliography => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bickering => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bicolor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bicycle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bidder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bidding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        biennial => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bier => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bifurcation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        big => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bigot => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bigoted => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bike => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bilateral => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bilayer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bile => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bilge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bilingual => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bill => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        billet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        billiards => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        billion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        billy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bimonthly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        binary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bind => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bindery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        binding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        binocular => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        binoculars => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        binomial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        biogenesis => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        biographer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        biography => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        biology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        biopsy => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        biosphere => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bipartite => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        birch => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bird => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        birth => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        birthday => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        birthplace => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        birthright => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bis => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bisexual => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bishop => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bison => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bitch => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bite => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bitterly => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bitterness => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bitumen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        biweekly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bizarre => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        black => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        blackberry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blackboard => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blackjack => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blackmail => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blackness => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        blacksmith => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bladder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blade => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blame => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blameless => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bland => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blank => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blanket => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        blasphemous => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blasphemy => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blast => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        blatant => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blather => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blaze => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blazing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bleach => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bleak => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bleeding => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        blemish => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        blend => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blending => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bless => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        blessed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        blessing => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        blessings => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        blight => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        blighted => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        blind => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blinded => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blindfold => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        blindfolded => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blindly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        blindness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        blink => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bliss => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        blissful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        blister => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blitz => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        blizzard => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bloated => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blob => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        block => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blockade => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        blond => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blood => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bloodhound => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bloodless => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bloodshed => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        bloodthirsty => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bloody => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bloom => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        blossom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        blot => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blouse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blower => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blowing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blown => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blowout => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blue => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        blues => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bluff => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bluish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blunder => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        blunt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blur => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blurred => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blush => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        blushing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boa => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        board => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boarder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boarding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boards => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boast => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        boasting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boating => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bobbin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bode => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bodice => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bodily => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        body => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bodyguard => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        bog => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bogus => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boil => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boiler => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boilerplate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boiling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boisterous => { anger => 1, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bold => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        boldness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bolster => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bolt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bolus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bomb => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        bombard => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bombardment => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bombed => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bomber => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bonanza => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bond => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bondage => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bonds => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bone => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boner => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bones => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bonfire => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bonne => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bonnet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bonus => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        bony => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boob => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        booby => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        book => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bookcase => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        booking => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bookish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bookkeeper => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bookkeeping => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        booklet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        books => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bookseller => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bookshop => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bookstore => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bookworm => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        boomerang => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        booming => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        boost => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        booster => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boot => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        booth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boots => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        booty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        booze => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        border => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bordering => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bore => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boreal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boredom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        borer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boring => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        borough => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        borrow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        borrower => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bosom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boss => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boston => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        botanical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        botanist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        botany => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bother => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bothering => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bottle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bottom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bottomless => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boulder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bounce => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bound => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boundary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boundless => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bounds => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bountiful => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bounty => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        bouquet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        bourgeois => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bourgeoisie => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bourse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bout => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bovine => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bowed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bowels => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bowl => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bowls => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        box => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boxer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boxing => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boy => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boycott => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boyhood => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        boyish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brace => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bracelet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        braces => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brachial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bracket => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brackets => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brackish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brad => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brag => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        braid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brains => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        brainstorm => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brake => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bran => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        branch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        branching => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brandy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brass => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bravado => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bravery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        brawl => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brazen => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        breach => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bread => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        breadth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        break => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        breakable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        breakdown => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        breaker => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        breakers => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        breakfast => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        breakneck => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        breakup => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        breath => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        breech => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        breeches => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        breed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        breeder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        breeding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        breeze => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        breezy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brethren => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        breve => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brevity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brew => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brewing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bribe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bribery => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brick => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bridal => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        bride => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        bridegroom => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        bridesmaid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        bridge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bridle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        briefly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brig => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brigade => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brighten => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        brightness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        brilliant => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        brim => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brimming => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brimstone => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bring => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brink => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brisk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bristle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brittle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        broadcast => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        broadside => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brocade => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        brochure => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        broil => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        broke => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        broken => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        broker => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brokerage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bronco => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bronze => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brood => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brooding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brook => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        broom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        broth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brothel => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brother => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        brotherhood => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        brotherly => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        brow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brown => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bruise => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brunette => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brunt => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brush => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brutal => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brutality => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        brute => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bubble => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bubbling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        buck => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        bucket => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        buckle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        buckled => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bud => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        buddy => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        budge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        budget => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        buffalo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        buffer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        buffet => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bug => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bugaboo => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        buggy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bugle => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        build => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        builder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        building => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        buildings => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bulb => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bulbous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bulge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bulk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bulkhead => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bulky => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bull => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bulldog => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bulldozer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bullet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bulletin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bulletproof => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bullock => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bully => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bulwark => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bum => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bummer => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bump => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bun => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bunch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bundle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bungalow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bunk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bunker => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bunt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        buoy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        buoyancy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bur => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        burden => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        burdensome => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bureau => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bureaucracy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        bureaucrat => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        burglar => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        burglary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        burial => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        buried => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        burke => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        burlap => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        burlesque => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        burly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        burn => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        burner => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        burning => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        burnished => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        burnout => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        burnt => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        burr => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        burrow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bursary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        bury => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        bus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bush => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bushel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bushy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        business => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        buss => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        bust => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        busted => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bustle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bustling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        busy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        butane => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        butcher => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        butler => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        butt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        butter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        butterfly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        buttery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        buttock => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        button => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        buttress => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        buxom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        buy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        buyer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        buying => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        buzz => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        buzzed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        buzzer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bye => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bygone => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        bylaw => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        bystander => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        byte => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cab => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cabal => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cabbage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cabin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cabinet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        cabriolet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cache => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cacophony => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cad => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cadaver => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        caddy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cadence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cadet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cafe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cairn => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cake => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calamity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        calcareous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calculate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calculated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calculating => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calculation => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calculator => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        calculus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calendar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calender => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calf => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        caliber => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calibrate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calico => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calipers => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        call => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calligraphy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        callous => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calls => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        calm => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        calmness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caloric => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calorie => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        calorimeter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cam => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        camber => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        camel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cameo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cameraman => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        camisole => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        camouflage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        camouflaged => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        camp => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        campaign => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        campaigner => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        campaigning => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        campus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cancel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        canceling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cancellation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cancer => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        candid => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        candidacy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        candidate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        candied => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        candle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        candlelight => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        candlestick => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        candor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        candy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cane => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canister => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canker => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cannibal => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cannibalism => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canning => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cannon => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canoe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canonical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canons => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        canopy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canteen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canterbury => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cantilever => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canto => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canton => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canvas => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        canvass => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cap => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        capability => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        capable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        capacity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cape => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caper => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        capillary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        capital => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        capitalist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        capitals => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        capitation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        capitol => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        capitulation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caprice => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        capricious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caps => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        capsule => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        captain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        caption => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        captivate => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        captivating => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        captive => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        captivity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        captor => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        capture => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        car => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caramel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caravan => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carbon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carcass => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        carcinoma => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        card => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cardigan => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cardinal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cardiomyopathy => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cards => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        care => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        career => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        careful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        carefully => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        carelessness => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caress => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        caret => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caretaker => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cargo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caribou => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caricature => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caries => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carnage => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        carnal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carnation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carnivorous => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carol => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        carousel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carpenter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carriage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carried => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carrier => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carrying => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cart => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cartel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cartilage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cartographic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cartography => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cartoon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cartouche => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cartridge => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carve => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carver => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        carving => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cascade => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        case => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        casein => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cash => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cashier => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        cashmere => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        casing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        casino => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cask => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        casket => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cast => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caste => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caster => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        castle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        castor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        casual => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        casually => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        casualty => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        catabolism => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        catalog => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        catalogue => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        catalysis => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        catalytic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        catamaran => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        catapult => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cataract => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        catastrophe => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        catch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        catching => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        catechism => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        categorical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        category => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cater => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        caterer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caterpillar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cates => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cathartic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cathedral => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        catheter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        catholic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        catnip => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cattle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caucus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caudal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caulk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        causal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        causality => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        causation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caused => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        causeway => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caution => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cautionary => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cautious => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cautiously => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cavalry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cave => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        caveat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cavern => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cavernous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cavity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cayenne => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cease => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ceaseless => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cede => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ceiling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        celebrant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        celebrated => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        celebrating => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        celebration => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        celebrity => { anger => 1, anticipation => 1, disgust => 1, fear => 0, joy => 1, negative => 1, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        celestial => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        celibacy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cell => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cellar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cellular => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        celluloid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cement => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        cemented => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cemetery => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        censor => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        censure => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        census => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        centenary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        centennial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        center => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        centimeter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        central => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        centrality => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        centralization => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        centralize => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        centrally => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        centrifugal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        centrifuge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        centurion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        century => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ceramics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cereal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cereals => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cerebral => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        ceremonial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ceremony => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        certainty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        certificate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        certify => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        cess => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cessation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chaff => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chafing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chagrin => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        chain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chair => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chairman => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        chairperson => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chairwoman => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        chaise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chalet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chalice => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chalk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        challenge => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chamber => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chambers => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chameleon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        champagne => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        champion => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        chance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        chancellor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        chandelier => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chandler => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        change => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        changeable => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        changed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        changer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        changing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        channel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chant => { anger => 1, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        chaos => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        chaotic => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chap => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chapel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chaplain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        chapman => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chaps => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chapter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        char => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        character => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        characteristic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        characterize => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        charade => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        charcoal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        charge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chargeable => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        charger => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        chariot => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        charitable => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        charity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        charm => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        charmed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        charmer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        charming => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        chart => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        charter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chartered => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chase => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chasm => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chastisement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chastity => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        chat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chateau => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chatter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chattering => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        chatty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chauffeur => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cheap => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cheat => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        check => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        checker => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        checkered => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        checkers => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        checklist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cheek => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cheeks => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cheep => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cheer => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        cheerful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        cheerfulness => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cheering => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cheery => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cheesecake => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cheetah => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chemise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chemist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        chemistry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cheque => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cherish => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        cherry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        chess => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chest => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chestnut => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chevron => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chew => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chicane => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 1 },
        chicken => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chief => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chiefly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chieftain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        child => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        childbirth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        childhood => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        childish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chill => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chilly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chime => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chimera => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        chimes => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chimney => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        china => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chinook => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chip => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chipping => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chirp => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        chisel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        chit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chivalry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        chloroform => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chocolate => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        choice => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        choir => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        choke => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cholera => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        choose => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        choosing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chop => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chopping => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chops => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        choral => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        chords => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chore => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chorus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        chosen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        chowder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        christening => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chromatic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chromatography => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chromosome => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chronic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        chronicle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        chronograph => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chronological => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chuck => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chuckle => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        chunk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chunky => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        church => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        churchyard => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        churn => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chute => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        chutney => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ciao => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cider => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cigar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cigarette => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cinch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cinder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cinema => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cinematographer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cinematography => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cinnamon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cipher => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        circle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        circling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        circuit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        circular => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        circulate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        circulation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        circumcision => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        circumference => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        circumferential => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        circumscribed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        circumstance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        circumstantial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        circumvention => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        circus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cirrus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cistern => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        citadel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        citation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        citizen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        citrine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        city => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        civic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        civil => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        civilian => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        civility => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        civilization => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        civilized => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        clad => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        claim => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        claimant => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clairvoyant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        clam => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clamor => { anger => 1, anticipation => 1, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        clamp => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clan => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        clandestine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clap => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        clarify => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        clarinet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clarion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clarity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clash => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clashing => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clasp => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        class => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        classic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        classical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        classics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        classification => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        classify => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        classmate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clatter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clause => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clauses => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        claw => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        claws => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clay => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clean => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cleaning => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cleanliness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cleanly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cleanse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cleansing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        clearance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        clearing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clearness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cleavage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cleave => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clef => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cleft => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clemency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clergy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clergyman => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clerical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        clerk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clerkship => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clever => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cleverness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        click => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        client => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clientele => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cliff => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        climate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        climatology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        climax => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        climb => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clip => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clipper => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clipping => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clique => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cloak => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clock => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clockwork => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clog => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cloister => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        close => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        closed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        closeness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        closet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        closure => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 1, surprise => 0, trust => 0 },
        clot => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cloth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clothe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        clothes => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clothesline => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clothing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cloud => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clouded => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cloudiness => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cloudy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        clover => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cloves => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clown => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        club => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clubhouse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clubs => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clue => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clump => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clumsy => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cluster => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clutch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clutches => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        clutter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coach => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        coagulation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coalesce => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        coalition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        coast => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        coastal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coaster => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coating => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coax => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        cobalt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cobble => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cobbler => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cobra => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cocaine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cock => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cockpit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cocktail => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cocoa => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cocoon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cod => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        code => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        codex => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        codification => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        codify => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coefficient => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coerce => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coercion => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        coercive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coexist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        coexistence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coexisting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        coffee => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coffin => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cog => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cogent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cognate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cognition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cognitive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cohabitation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coherence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        coherent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cohesion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        cohesive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cohort => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coil => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coiled => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coinage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coincide => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coincidence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        coincident => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coinciding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coke => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cold => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coldly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coldness => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        colic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        collaborator => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        collapse => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        collar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        collate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        collateral => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        collation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        colleague => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        collect => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        collected => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        collection => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        collective => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        collectively => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        collector => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        college => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        collegiate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        collide => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        collie => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        collision => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        collocation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        colloquial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        collusion => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        colon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        colonel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        colonial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        colony => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        colophon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        color => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coloration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        colored => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coloring => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        colorless => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        colors => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        colossal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        colt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        column => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        columnar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coma => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        comatose => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        comb => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        combat => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        combatant => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        combative => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        combination => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        combinatorial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        combine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        combined => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        combustible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        combustion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comedy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comfort => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        comforter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coming => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comma => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        command => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        commandant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        commander => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        commanding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        commemorate => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 1, surprise => 0, trust => 0 },
        commemoration => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        commemorative => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        commence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        commend => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        commendable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        commensurate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        commentary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        commentator => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        commerce => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        commercial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        commissary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        commission => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        commissioner => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        commit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        committal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        committed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        committee => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        commodity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        commodore => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        common => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        commonly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        commonplace => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        commons => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        commonwealth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        commotion => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        commune => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        communicable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        communicate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        communication => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        communicative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        communion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        communism => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        communist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        community => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        commutation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        commutative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        commute => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        commuter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compact => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        compaction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compactness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        companion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        companionship => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        company => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comparable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comparative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comparatively => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comparison => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compartment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compass => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        compassion => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        compassionate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        compatibility => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        compatible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        compel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compelled => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compelling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        compendium => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compensate => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        compensation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compensatory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        competence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        competency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        competent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        competition => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        competitive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        competitor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compilation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compile => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        complacency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        complacent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        complain => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        complaint => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        complement => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        complementary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        completed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        completely => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        completeness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        completing => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        completion => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        complex => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        complexed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        complexion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        complexity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compliance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        compliant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        complicate => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        complicated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        complication => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        complicity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        compliment => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        comply => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        complying => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        component => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compose => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        composed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        composer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        composite => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        composition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compost => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        composure => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        compound => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comprehend => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        comprehension => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comprehensive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        compress => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compressed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compressible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compression => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comprise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compromise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comptroller => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        compulsion => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compulsory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        computable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        computation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        compute => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        computer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        comrade => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        con => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concatenation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concave => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conceal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        concealed => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        concealment => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conceit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conceited => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conceivable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concentrate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concentration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concentric => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        conception => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concern => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concerned => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        concert => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concession => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concessional => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concierge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conciliation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        concise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conclave => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conclude => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concluding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        conclusion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concoction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concomitant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concord => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        concordance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        concours => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concourse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concrete => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concurrence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concurrent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concurring => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        concussion => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        condemn => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        condemnation => { anger => 1, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        condensation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        condensed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        condescending => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        condescension => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        condiment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        condition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conditional => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conditionally => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conditioned => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conditions => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        condolence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 1, surprise => 0, trust => 0 },
        condone => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        conducive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        conduct => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conduction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conductivity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        conductor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conduit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cone => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        confederate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        confederation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        confer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conference => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        confess => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        confession => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        confessional => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        confessions => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        confide => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        confidence => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        confident => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        confidential => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        confidentially => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        configuration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        confine => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        confined => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        confinement => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        confines => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        confirm => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        confirmation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        confirmatory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        confirmed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        confiscate => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        confiscation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conflagration => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conflict => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        conflicting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        confluence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conformance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        conformation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conformity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        confound => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        confounded => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        confront => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        confuse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        confusion => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        congenial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        congenital => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        congestion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conglomerate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        conglomeration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        congratulatory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        congregate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        congregation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        congress => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        congressional => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        congressman => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        congruence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        conic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conjecture => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conjugal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conjugate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conjugation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conjunction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conjunctive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conjure => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        conjuring => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        connect => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        connected => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        connection => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        connective => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        connoisseur => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        conquer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conqueror => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conquest => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conscience => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        conscientious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        consciousness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        conscription => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consecration => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 1, surprise => 0, trust => 1 },
        consecutive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consenting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consequence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consequent => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conservation => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        conservatism => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conservative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conservatory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conserve => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        considerable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        considerate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        consignee => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consignment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consistency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        consistent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consolation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        console => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 1, surprise => 0, trust => 0 },
        consolidate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consolidation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consonant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        consort => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        conspicuous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conspiracy => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conspirator => { anger => 1, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conspire => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        constable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        constancy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        constant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        constantly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        constellation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consternation => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        constipation => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        constituent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        constituents => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        constitute => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        constitution => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        constitutional => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        constitutionality => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        constrain => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        constrained => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        constraint => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        construct => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        construction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        construe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consul => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        consult => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        consultation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consume => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consuming => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consummate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        consummation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        consumption => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contact => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        contagion => { anger => 0, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contagious => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        containment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contaminate => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contaminated => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        contamination => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contemplate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contemplation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        contemplative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contemporaneous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contemporary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contempt => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contemptible => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contemptuous => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contending => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        content => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        contention => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contentious => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contents => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        context => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contiguous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        continence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        continent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        continental => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contingency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contingent => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        continual => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        continually => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        continuance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        continuation => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        continue => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        continued => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        continuing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        continuity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        continuous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        continuously => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contour => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        contraband => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contract => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contracted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contractile => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contracting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contraction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contradict => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contradiction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contradictory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contrary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contrast => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contrasted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contravene => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contravention => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        contribute => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        contributor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        contrived => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        control => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        controversial => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        controversy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conundrum => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convalescent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convection => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convene => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convenience => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        conveniences => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convenient => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        convent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        convention => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        conventional => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        converge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convergence => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convergent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conversant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        conversation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conversational => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        converse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conversing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conversion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convert => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        converted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convertible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convex => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convexity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convey => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conveyance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        conveyancing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        convict => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        conviction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convince => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        convinced => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        convincing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        convocation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convoluted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convolution => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        convoy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cook => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cookery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cooking => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cool => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cooler => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cooling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coolness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        coop => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cooperate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cooperating => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cooperation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cooperative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        coordinate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cop => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        copious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        copper => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        copy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        copycat => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        copying => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        copyright => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coral => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cord => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cordon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corduroy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        core => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cork => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corkscrew => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corn => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cornea => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corner => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cornet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cornice => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cornstarch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corollary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corona => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coronation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        coroner => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corporal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corporate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corporation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        corporeal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        corps => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corpse => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        corpus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corral => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        correction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corrective => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        correctness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        correlation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        correlative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        correspond => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        correspondence => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        correspondent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corridor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corroborate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        corroboration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        corrosion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corrosive => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corrupt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corrupting => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        corruption => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        corset => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cortex => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cortical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        corvette => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cosmetic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cosmetics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cosmic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cosmology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cosmopolitan => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cosmos => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cost => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        costly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        costume => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cosy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cot => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cote => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cottage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cotton => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        couch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cougar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cough => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        council => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        counsel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        counsellor => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        counselor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        count => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        countdown => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        countenance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        counter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        counteract => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        counterbalance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        counterclaim => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        counterpart => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        countess => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        countless => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        country => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        countryman => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        counts => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        county => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        coup => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        couple => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coupled => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coupon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        courage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        courageous => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        courier => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        courses => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coursing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        court => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        courteous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        courtesy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        courthouse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        courts => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        courtship => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        courtyard => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cove => { anger => 0, anticipation => 1, disgust => 1, fear => 1, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        covenant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cover => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        covered => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        covering => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        covert => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        covet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coward => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cowardice => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cowardly => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cowboy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cowhide => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cowl => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coworker => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coy => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        coyote => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crab => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crabby => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crack => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cracked => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cracker => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cracking => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crackle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cradle => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        craft => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        craftsman => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        crafty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        craig => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crammed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cramp => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cramped => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crane => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cranium => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crank => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cranky => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crap => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        craps => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crash => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        crate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crater => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crave => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        craving => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crawfish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crawl => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crayons => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        craze => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crazed => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crazy => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        creaking => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cream => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        creamer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        creamy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crease => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        create => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        creation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        creative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        creator => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        creature => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        credence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        credential => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        credentials => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        credibility => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        credible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        credit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        creditable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        credited => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        crediting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        creditor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        creed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        creek => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        creep => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        creeping => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cremation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        creole => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crescendo => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        crescent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crevice => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crew => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        crib => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cricket => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crime => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        criminal => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        criminality => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crimp => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crimson => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cringe => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cripple => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        crippled => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        crisis => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crisp => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        criterion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        critic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        criticism => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        criticize => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        critique => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        critter => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        croak => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crock => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crockery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crocodile => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        croft => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crook => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crop => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        croquet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cross => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        crossbow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crossed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crossing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crotch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crouch => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crouched => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crouching => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        croupier => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crowd => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crowded => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crown => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crowning => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        crucial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cruciate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crucifix => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crucifixion => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        crude => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cruel => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cruelly => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cruelty => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cruise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cruiser => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crumb => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crumbling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        crunch => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crusade => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crush => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crushed => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        crushing => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crust => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crusty => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crutch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crux => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        crying => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        crypt => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cryptic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cryptography => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crystal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        crystalline => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        crystallization => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cub => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cube => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        cubicle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cuckold => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cuckoo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cuddle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cue => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cuff => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cuisine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        culinary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cull => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        culminate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        culmination => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        culpability => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        culpable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        culprit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cult => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cultivate => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        cultivated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cultivation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        culture => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        culvert => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cumbersome => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cumulus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cunning => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cup => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cupboard => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cupping => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cur => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        curate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curator => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curb => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curd => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curfew => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curiosity => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        curl => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        curling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        currency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        current => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curriculum => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curse => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cursed => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cursing => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cursory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curtail => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curtailment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curtain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curvature => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curve => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curved => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        curvilinear => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cushion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cusp => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cussed => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        custodian => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        custody => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        custom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        customary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        customer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cut => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cutaneous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cute => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cuticle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cutlery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cutter => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cutters => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        cutthroat => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cutting => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cuttings => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cwt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cyanide => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cycle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cyclical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cyclist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cyclone => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        cylinder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cylindrical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cymbal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cynic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cyst => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cystic => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        cytomegalovirus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        cytoplasm => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        czar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dab => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dabble => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dabbling => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dad => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dado => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        daemon => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        daft => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dagger => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        daily => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dainty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dairy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dak => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dale => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dam => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        damage => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        damages => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dame => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        damn => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        damnation => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        damned => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        damp => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dampened => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        damper => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        damsel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        dancer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dandruff => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dandy => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        danger => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dangerous => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dangle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dank => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dapper => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dare => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        daring => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dark => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        darken => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        darkened => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        darkly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        darkness => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        darling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        darn => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dart => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dash => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dashboard => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dashed => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dashing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dastardly => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        data => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        database => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        date => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        daughter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dawn => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        day => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        daybreak => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        daydreaming => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        daze => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dazed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dazzling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deacon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        deactivate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deadlock => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deadly => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deaf => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deafening => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deafness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deal => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        dealer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dealing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dealings => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        dean => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dear => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dearth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        death => { anger => 1, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        debacle => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        debatable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        debate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        debauchery => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        debenture => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        debit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        debris => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        debt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        debtor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        debut => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decade => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decanter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decay => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        decayed => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deceased => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deceit => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        deceitful => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deceive => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deceived => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deceiving => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        decency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        decent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        deception => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deceptive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decidedly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deciduous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decimal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decipher => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decision => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decisive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deck => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        declaration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        declaratory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        declare => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        declination => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decline => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        declining => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decompose => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decomposed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        decomposition => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        decorate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decoration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decorum => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decoy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        decrease => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decreased => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decreasing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decree => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decrement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decrepit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        decry => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dedication => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        deduce => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deduct => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deduction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        deepen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        defamation => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        defamatory => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        default => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        defeat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        defeated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        defect => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        defection => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        defective => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        defend => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        defendant => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        defended => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        defender => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        defending => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        defense => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        defenseless => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        defensible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        defensive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        defer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deference => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        deferral => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deferring => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        defiance => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        defiant => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deficiency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deficit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        define => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        defined => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        definition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        definitive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        deflate => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deflation => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deflect => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deflection => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        defloration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deform => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deformed => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deformity => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        defraud => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        defray => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deft => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        defunct => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        defy => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        degeneracy => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        degenerate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        degeneration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        degradation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        degrade => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        degrading => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        degree => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dehydrated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        delay => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        delayed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        delectable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        delegate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        delegation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deleterious => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deletion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deliberate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        deliberation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deliberative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        delicacy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        delicious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        delight => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        delighted => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        delightful => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        delineate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        delineation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        delinquency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        delinquent => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        delirious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        delirium => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deliverance => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        delivery => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dell => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        delta => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deluge => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        delusion => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        delusional => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        delve => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        demand => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        demanding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        demeanor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        demented => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dementia => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        demise => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        democracy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        democrat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        demolish => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        demolition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        demon => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        demonic => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        demonstrable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        demonstrate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        demonstrated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        demonstrating => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        demonstration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        demonstrative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 1, surprise => 0, trust => 0 },
        demonstrator => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        demoralized => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        demos => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        den => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        denial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        denied => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        denomination => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        denominational => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        denominator => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        denote => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        denounce => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dense => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        density => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dentistry => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        denunciation => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deny => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        denying => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deodorant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        depart => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        departed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        department => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        departure => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        depend => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        dependant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dependence => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dependency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dependent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        depict => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        depicting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        depletion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deplorable => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deplore => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deploy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deport => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deportation => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deposit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        depositary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deposition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        depository => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        depot => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        depraved => { anger => 1, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        depravity => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        depreciate => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        depreciated => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        depreciation => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        depress => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        depressed => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        depressing => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        depression => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        depressive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deprivation => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        depth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        deputy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        derail => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deranged => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        derelict => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        derision => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        derivation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        derivative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        derive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dermal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dermatologist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        dermatology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        derogation => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        derogatory => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        descend => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        descendant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        descendent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        descending => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        descent => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        describe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        description => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        descriptive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        desecration => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        desert => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deserted => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        desertion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deserve => { anger => 1, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        deserved => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        deserving => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        design => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        designate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        designation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        designed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        designer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        designing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        desirability => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        desirable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        desiring => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        desirous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        desist => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        desk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        desolation => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        despair => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        despairing => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        despatch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        desperate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        desperation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        despicable => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        despise => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        despotic => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        despotism => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dessert => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        destination => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 1, negative => 0, positive => 1, sadness => 1, surprise => 1, trust => 0 },
        destined => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        destiny => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        destitute => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        destroyed => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        destroyer => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        destroying => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        destruction => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        destructive => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detach => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detached => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detachment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detail => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        details => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detainee => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        detect => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        detectable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detection => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        detective => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detector => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detention => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detergent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deteriorate => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deteriorated => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        deterioration => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        determinable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        determinate => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        determination => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        determined => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        detest => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detonate => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        detonation => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detour => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detract => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detriment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detrimental => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        detritus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deuce => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        devastate => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        devastating => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 1 },
        devastation => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        develop => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        developing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        development => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deviate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deviating => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        deviation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        device => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        devil => { anger => 1, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        devilish => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        devious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        devise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        devoid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        devolution => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        devolve => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        devote => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        devotee => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        devotional => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        devour => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        devout => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        dew => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dexter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dexterity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dextrose => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diabolical => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diagnosis => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        diagnostic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diagnostics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diagram => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dialect => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dialectic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dialogue => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diameter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diamond => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        diamonds => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diaper => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diaphragm => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diarrhoea => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        diatribe => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dice => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dichotomous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dichotomy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dictate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dictation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dictator => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dictatorial => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dictatorship => { anger => 1, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        diction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dictionary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        dictum => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        didactic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        die => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        diet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dietary => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        differ => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        difference => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        differences => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        differential => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        differentiation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        differently => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        differing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        difficult => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        difficulties => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        difficulty => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        diffuse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diffusion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dig => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        digest => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        digestion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        digit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        dignified => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dignity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        digress => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        digs => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dike => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dilapidated => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dilatation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dilation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dilemma => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diligence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        diligent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diluent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dilute => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diluted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dilution => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dime => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dimension => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diminish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        diminished => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diminution => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diminutive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        din => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diner => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dinner => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dinosaur => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dint => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diocesan => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diocese => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diorama => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dip => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diploma => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diplomacy => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        diplomat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diplomatic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        dire => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        directed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        direction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        directly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        director => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        directory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dirt => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dirty => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disability => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disable => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disabled => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disadvantage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disaffected => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disagree => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disagreeable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disagreeing => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disagreement => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disallow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disallowed => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disappear => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disappearance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disappearing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disappoint => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disappointed => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disappointing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disappointment => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disapproval => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disapprove => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disapproved => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disapproving => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disarm => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disarray => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disaster => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        disastrous => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disband => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disbelief => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disbelieve => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disburse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disbursement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disc => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discarded => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discards => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discern => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discernible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discerning => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discernment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discharge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disciple => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        discipline => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disclaim => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        disclaimer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disclose => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disclosed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        disclosure => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discoloration => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discolored => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        discomfort => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disconnect => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disconnected => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disconnection => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discontent => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        discontinuance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discontinue => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discontinuity => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        discontinuous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discord => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discount => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discounted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discourage => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        discouraged => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discouragement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discourse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discover => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discovery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        discredit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discreet => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        discrepancy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discrete => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discretion => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        discretionary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        discriminate => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        discriminating => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discrimination => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        discus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discuss => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        discussion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        disdain => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disease => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        diseased => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disembodied => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disengage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disengagement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disfigured => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disgrace => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disgraced => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disgraceful => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disgruntled => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disguise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disguised => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disgust => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disgusting => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disheartened => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disheartening => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dishonest => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dishonesty => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dishonor => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disillusionment => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disinfect => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disinfectant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disinfection => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        disinformation => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disingenuous => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disintegrate => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disintegration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disinterested => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disjoint => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disjointed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disjunctive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diskette => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dislike => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disliked => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dislocated => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dislocation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dislodge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dismal => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dismay => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        dismemberment => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dismiss => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dismissal => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        dismount => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disobedience => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disobedient => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disobey => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disorder => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disorderly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disorganized => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disparage => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disparaging => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disparate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disparity => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dispassionate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dispatch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dispel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dispensation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dispense => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disperse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dispersed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dispersion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        displace => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        displaced => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        displacement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        display => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        displeased => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        displeasure => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disposal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dispose => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disposed => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        disposition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dispossessed => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disprove => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dispute => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disqualification => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disqualified => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disqualify => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disregard => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disregarded => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disreputable => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disrepute => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disrespect => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disrespectful => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disruption => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        dissatisfaction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dissatisfied => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dissect => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dissection => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disseminate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dissemination => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dissension => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dissent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dissenting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dissertation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disservice => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dissident => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dissimilar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dissipate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dissipated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dissociation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dissolution => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        dissolve => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dissonance => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dissuade => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distaste => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distasteful => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distillate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distillation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        distinction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        distinctive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distinguish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distinguishable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distinguished => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distinguishing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distorted => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distortion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distract => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distracted => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distracting => { anger => 1, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distraction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distraught => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        distress => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        distressed => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distressing => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distribute => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distribution => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        district => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        distrust => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disturbance => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        disturbed => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        disuse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        disused => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ditch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ditto => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ditty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        diurnal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        divan => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        dive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diver => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diverge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        divergence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        divergent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        diverging => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        divers => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diverse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        diversified => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        diversify => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diversion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        diversity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        divert => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        diverting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        divest => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        divested => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        divestment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        divide => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        divided => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dividend => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        divination => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        divine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        divinity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        divisible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        division => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        divisor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        divorce => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 1 },
        divulge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dizziness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dizzy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        docile => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dock => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        docked => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        docket => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doctor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        doctrinal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doctrine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        document => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        documentary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dodge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dodging => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dog => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dogged => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dogma => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        dogmatic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doings => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doldrums => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dole => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        doll => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dollar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dolor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dolphin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        domain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dome => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        domestic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        domesticated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        domestication => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        domicile => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        domiciled => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dominance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dominant => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dominate => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dominating => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        domination => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dominion => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        domino => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        don => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        donation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        donkey => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        donor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doodle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doom => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doomed => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        doomsday => { anger => 1, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        door => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doorbell => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doorway => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dormant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dormitory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dorsal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dose => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dot => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        double => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doubled => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doublet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doubling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doubt => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 1 },
        doubtful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doubting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doubtless => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        douche => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dough => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doughnut => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dour => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dove => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        downcast => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        downfall => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        downhill => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        downpour => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        downright => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        downy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dowry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        doze => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dozen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drab => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        draft => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drag => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dragon => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drainage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drained => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drake => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drama => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dramatic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drape => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drapery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drastic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        draught => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        draw => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drawback => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drawer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drawers => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drawing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dread => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dreadful => { anger => 1, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dreadfully => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        dream => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dreamer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dreaming => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dreamy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dreary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dredge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drenched => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dresser => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dribble => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dried => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drier => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drift => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drifted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drill => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drink => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drinking => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drip => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dripping => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drivel => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        driver => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        driveway => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drizzle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        droll => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drone => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drool => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drooping => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drop => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        droplet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drought => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drove => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drown => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        drowsiness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drowsy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drudgery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drug => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drugged => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        drugstore => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        druid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drum => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drummer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drumming => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drunken => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        drunkenness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dryness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dual => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dualism => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        duality => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dub => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dubious => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        ducking => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        duct => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ductile => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        duds => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        due => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        duel => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dues => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        duet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dugout => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        duke => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        dull => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dumb => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dummy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dump => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dumps => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dun => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dune => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dung => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dungeon => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        duo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dupe => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        duplex => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        duplicate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        duplication => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        duplicity => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        durability => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        durable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        duration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        duress => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dusk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dusky => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dust => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        duster => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dusty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dutiful => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        dwarf => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dwarfed => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dwell => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dweller => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dwelling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dye => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dying => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dyke => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dynamic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        dynamical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dynamics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dynamite => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dynasty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        dysentery => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        dyspepsia => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eager => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        eagerness => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        eagle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        ear => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        earl => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        earlier => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        early => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        earn => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        earnest => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        earnestly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        earnestness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        earnings => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        earring => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        earshot => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        earth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        earthenware => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        earthly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        earthquake => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        earthy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ease => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        easel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        easement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        easily => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        easy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        easygoing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        eat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        eating => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eavesdropping => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ebb => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ebony => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eccentric => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eccentricity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ecclesiastical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        echo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eclectic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eclipse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ecliptic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        economical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        economics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        economy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        ecstasy => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        ecstatic => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        ecumenical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eddy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        edge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        edging => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        edible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        edict => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        edification => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        edifice => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        edit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        edition => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        editor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        editorial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        educate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        educated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        education => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        educational => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        eel => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        effect => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        effective => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        effects => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        effectual => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        effectually => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        effectuate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        effeminate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        efficacious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        efficacy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        efficiency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        efficient => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        effigy => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        effort => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        effusion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        egg => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ego => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        egotistical => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        egregious => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        egress => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eighth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eighty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ejaculate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ejaculation => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        eject => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ejection => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elaborate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elaboration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        elan => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elapse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elapsed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elastic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elasticity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        elbow => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eld => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        elderly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elders => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        eldest => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elect => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        election => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elector => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        electorate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        electric => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        electricity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        elegance => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        elegant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        element => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elementary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elements => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elephant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elevate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elevation => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        elevator => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eleven => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eleventh => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elf => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elicit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eligible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        elimination => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        elite => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        elk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ell => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ellipse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ellipsis => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ellipsoid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elliptic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elliptical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elongate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elongation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eloquence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        eloquent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        elucidate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        elucidation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elude => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        elusive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        emaciated => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        emanate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emancipation => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        embankment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embargo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embark => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embarrass => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        embarrassing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embarrassment => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        embassy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embellish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embellishment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embers => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embezzlement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emblem => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emblematic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embodiment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embolism => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        embossed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embrace => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        embroidered => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embroidery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embroiled => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embryo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        embryonic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emerald => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emerge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emergence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emergency => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        emeritus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        emigrate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emigration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eminence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        eminent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        eminently => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        emir => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        emission => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emotion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emotional => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emotive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        empathy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        emperor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emphasis => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emphasize => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        emphatic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        empire => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        empirical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        empiricism => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        employ => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        employer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        employment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emporium => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        empower => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        empress => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emptiness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        emption => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        empty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        emulate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        emulsion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        enablement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        enact => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enactment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enamel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        encampment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enchant => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        enchanted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        enchanting => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        enchantment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        encircle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        encircling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enclave => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enclose => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        encode => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        encompass => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        encore => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        encounter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        encourage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        encouragement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        encroach => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        encroachment => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        encrypt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        encumbrance => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        encyclopedia => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        end => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        endanger => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        endangered => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        endeavor => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        ended => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        endemic => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        ending => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        endless => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 1, negative => 1, positive => 1, sadness => 1, surprise => 0, trust => 1 },
        endocarditis => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        endorsement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        endow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        endowed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        endowment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        endpapers => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        endpoint => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        endurance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        endure => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        enema => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enemy => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        energetic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        energy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enforce => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        enforcement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        engage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        engaged => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        engagement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        engaging => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        engender => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        engine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        engineer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        engineering => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        engrave => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        engraved => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        engraver => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        engraving => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        engrossed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        engrossing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        engulf => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enhance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        enigma => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enigmatic => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enjoin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enjoy => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        enjoying => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        enlarged => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enlargement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enlighten => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        enlightenment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        enlist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enliven => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        enmity => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        enormity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enormous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enormously => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enrich => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        enroll => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        ensemble => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        ensign => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        enslave => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enslaved => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        enslavement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ensue => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ensure => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        entail => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        entangled => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        entanglement => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enterprise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enterprising => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        entertain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        entertained => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        entertaining => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        entertainment => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        enthusiasm => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        enthusiast => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        entice => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        entire => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        entirety => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        entitle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        entity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        entomology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        entrails => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        entrance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        entreat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        entree => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        entrepreneur => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        entrust => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        entry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enumerate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        enumeration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        envelope => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        envious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        environ => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        environment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        environs => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        envision => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        envoy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ephemeral => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ephemeris => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        epic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        epidemic => { anger => 1, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        epidermis => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        epilepsy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        epilogue => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        episcopal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        episode => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        episodic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        epistle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        epitaph => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        epithet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        epitome => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        epoch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equality => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        equalization => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equalize => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equally => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        equate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equator => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equatorial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equestrian => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equidistant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equilibration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equilibrium => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        equip => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equipment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equitable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        equivalence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equivalent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        equivocal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        era => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eradicate => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eradication => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        erase => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        erasure => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ere => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        erect => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        erection => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ergo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        erode => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        erosion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        erotic => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 1, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        err => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        errand => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        errant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        erratic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        erratum => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        erroneous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        error => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        erst => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        erudite => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        erupt => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        eruption => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        escalade => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        escalate => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        escalator => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        escape => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        escaped => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        escarpment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eschew => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        escort => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        esoteric => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        especial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        espionage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        espouse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        esprit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        essay => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        essayist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        essence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        essential => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        essentially => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        establish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        established => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        establishment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        estate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        esteem => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 1, surprise => 0, trust => 1 },
        esthetic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        estimate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        estimation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        estoppel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        estranged => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        estrogen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        estuary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        etch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        etching => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eternal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eternity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ethanol => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ether => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ethereal => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ethical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        ethics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        ethnography => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        etiology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        etiquette => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        etymology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        euchre => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eugenics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eulogy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        euphemism => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        euthanasia => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        evacuate => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        evacuation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        evade => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        evaluate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        evanescence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        evangelical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        evangelist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        evangelistic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        evaporation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        evasion => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        eve => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        evening => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        event => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eventful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eventual => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eventuality => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        evergreen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        everlasting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        evermore => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        everyday => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        evict => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        eviction => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        evidence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        evident => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        evil => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        evoke => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        evolution => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        evolve => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ewe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exacerbate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exacerbation => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exacting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exaggerate => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exaggerated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exaggeration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exalt => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        exaltation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        exalted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        exam => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        examination => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        examine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        examiner => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exasperation => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        excavate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        excavation => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        excavator => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exceed => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        exceeding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        excel => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        excellence => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        excellent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        excepting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exception => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        excerpt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        excess => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        excessive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        excessively => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exchange => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        excise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        excision => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        excitability => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        excitable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        excitation => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        excite => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        excited => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        excitement => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        exciting => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        exclaim => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        excluded => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        excluding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        exclusion => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        excrement => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        excretion => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        excruciating => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        excursion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        excuse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        execute => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        execution => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 1 },
        executioner => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        executive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        executor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        exegesis => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exemplar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exemplary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        exemplify => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exempt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exemption => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        exercise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exert => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exertion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exhale => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exhaust => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exhausted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        exhaustion => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        exhaustive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        exhibit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exhibition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exhilaration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        exhort => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        exhortation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        exigent => { anger => 0, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        exile => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        exist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        existence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        existent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        existing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exodus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exorbitant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exorcism => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        exorcist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exotic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        expand => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expanded => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expanse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expansion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expansive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expatriate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expect => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        expectancy => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expectant => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expectation => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        expected => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expecting => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expediency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expedient => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        expedite => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expedition => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        expeditious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expel => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        expenditure => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expense => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expenses => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expensive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        experience => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        experienced => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        experiences => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        experiment => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        experimental => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        experimenter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expert => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        expertise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        expiration => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expire => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        expired => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expiry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        explain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        explanation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        explanatory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expletive => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        explication => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        explode => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        exploit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        explore => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        explorer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        explosion => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        explosive => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        exponent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exponential => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        export => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exportation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expose => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exposed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exposition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expository => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exposure => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expound => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        express => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expression => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expressive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expropriation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        expulsion => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        exquisite => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        exquisitely => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        extant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extend => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        extendable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extended => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extension => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extensive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        extent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exterior => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exterminate => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        extermination => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        external => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        externally => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extinct => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        extinguish => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extra => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        extract => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extracting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extraction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extractor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extradition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extrajudicial => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extramural => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extraneous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extraordinary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        extravaganza => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extreme => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extremely => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extremity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extricate => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        extrinsic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        extrusion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        exuberance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        exude => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eye => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eyeglass => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eyelet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eyepiece => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eyesight => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        eyewitness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        fable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fabric => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fabricate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fabricated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fabrication => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        facade => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        face => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        facet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        facile => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        facilitate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        facility => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        facing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        facsimile => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fact => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        faction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        factor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        factory => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        facts => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        faculties => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        faculty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        fad => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fade => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        faded => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        faeces => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        failing => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        failure => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fain => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        fainting => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        fair => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fairly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        fairway => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fairy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        faith => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        faithful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        faithless => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fake => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fall => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fallacious => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fallacy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fallible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        falling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fallow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        falsehood => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        falsely => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        falsification => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        falsified => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        falsify => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        falsity => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        falter => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fame => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        famed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        familiar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        familiarity => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        familiarize => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        famine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        famous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        famously => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fan => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fanatic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fanaticism => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fanciful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fancy => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fandango => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fanfare => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        fang => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fangs => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fanning => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fantasia => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fantasy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        farce => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        farcical => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fare => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        farewell => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        farm => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        farmer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        farmhouse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        farming => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        faro => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        farther => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fascia => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fascinating => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fascination => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fashion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fashionable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fasten => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fastener => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fastening => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fasting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fat => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fatal => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fatality => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fate => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        father => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        fathom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fatigue => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fatigued => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fatty => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fault => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        faultless => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        faulty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fauna => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        favor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        favorable => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        favorite => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        favoritism => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fawn => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fear => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fearful => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fearfully => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        fearing => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fearless => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        feasibility => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        feasible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        feat => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        feather => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        feature => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        features => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        febrile => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fecal => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        feces => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fecundity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        federal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        federation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fee => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        feeble => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        feed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        feeder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        feel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        feeling => { anger => 1, anticipation => 1, disgust => 1, fear => 1, joy => 1, negative => 1, positive => 1, sadness => 1, surprise => 1, trust => 1 },
        feet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        feigned => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        felicity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        feline => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fell => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fellow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        fellowship => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        felon => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        felony => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        felt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        female => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        feminine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        femininity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        feminist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fenced => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fend => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fender => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        fennel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ferment => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fermentation => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fern => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ferocious => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ferocity => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ferry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fertile => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fertilize => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fervent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fervor => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        festival => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        festive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fetch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fete => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        fetish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        feud => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        feudal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        feudalism => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fever => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        feverish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fiancee => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fiasco => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fiat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fib => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fiber => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fibrous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fickle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fiction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fictitious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fiddle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fiddler => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fidelity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        fiduciary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        field => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fiend => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fierce => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fiesta => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        fight => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fighter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fighting => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        figment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        figurative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        figure => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        figurine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        filament => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        filamentous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        file => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        filibuster => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        filigree => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        filing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        filings => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fill => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        fillet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        filling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        filly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        film => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        filmy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        filter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        filth => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        filthy => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        final => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        finale => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        finality => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        finally => { anger => 0, anticipation => 1, disgust => 1, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        finance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        financial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        financier => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        finch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        find => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        finding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        finery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        finesse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        finger => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fingerprint => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        finish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        finite => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fink => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fire => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        firearms => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fireball => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        firefly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fireman => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        fireplace => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fireproof => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fireside => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        firewood => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        firework => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        firing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        firm => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        firmament => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        firmly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        firmness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        firstborn => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        fiscal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fisherman => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fishery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fishing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fishy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fissile => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fission => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fissure => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fistula => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fitness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fits => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fitted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fitting => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        fittings => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fix => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fixation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fixed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        fixture => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fixtures => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fizz => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flabby => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flaccid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        flagging => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flagrant => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flagship => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        flake => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flaky => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flame => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flaming => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flange => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        flank => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flanked => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flanking => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flannel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flap => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flapping => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flare => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flaring => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flash => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flashback => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flashing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flashlight => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flashy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flask => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flatness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flatten => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flattering => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        flattery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flatulence => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flaunt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flavor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flaw => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        flea => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fled => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flee => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fleece => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fleet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fleeting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flesh => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fleshy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flex => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flexibility => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        flexible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flexion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flicker => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flickering => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flier => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flight => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flinch => { anger => 0, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        fling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flint => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flipper => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flirt => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 1, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        flirting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        float => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flock => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flog => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        flood => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        floor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flop => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        flora => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        floral => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        florist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        floss => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flounder => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        flour => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        flowering => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flowery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        flu => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fluctuate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fluctuating => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fluctuation => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flue => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fluency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fluff => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fluffy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fluid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fluidity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fluke => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        fluorescence => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fluorescent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flurry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flush => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        flustered => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flute => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fluted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fluvial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flux => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flyer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        flying => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        flywheel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foam => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foaming => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foamy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fob => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        focal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        focus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fodder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foe => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fog => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foggy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foil => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foiled => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fold => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        folded => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foliage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        folio => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        folk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        folklore => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        follicle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        follicular => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        follow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        follower => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        folly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fondling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fondness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        font => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        food => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        fool => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fooling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foolish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foolishness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foot => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        football => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        footbridge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        footing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        footpath => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        footprint => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fop => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foray => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forbearance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        forbid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        forbidding => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        force => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forced => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forceps => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forcibly => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ford => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fore => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        forearm => { anger => 1, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foreboding => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forecast => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        forecaster => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foreclose => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        forefathers => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        forefinger => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forego => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foregoing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        foregone => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foreground => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forehead => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foreign => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foreigner => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foreman => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        forensic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forerunner => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        foresee => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        foreseen => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        foresight => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        forest => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forethought => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forewarned => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foreword => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forfeit => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        forfeited => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forfeiture => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        forge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        forgery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forget => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forgetful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forgetfulness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forgive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        forgiven => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        forgiving => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        forgotten => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fork => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forked => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forking => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forlorn => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        form => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        formalism => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        formality => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        formation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        formative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        formed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        formidable => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forming => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        formless => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        formula => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        formulary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        formulate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fornication => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forsake => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        forsaken => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        forsooth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fort => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        forte => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        forthcoming => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        forthwith => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fortification => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fortify => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fortitude => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        fortnightly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fortress => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 1, surprise => 0, trust => 1 },
        fortuitous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fortunate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fortune => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        forty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forum => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        forward => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fossil => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fossils => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foul => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        found => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        foundation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        founder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foundry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fountain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fourfold => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fourth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fowl => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fox => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        foxy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fraction => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fractional => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fracture => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fragile => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fragility => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fragment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fragmentary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fragrance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fragrant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        frailty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        framework => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        franchise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frank => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        frankness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        frantic => { anger => 0, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        fraternal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        fraternity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fraud => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fraudulent => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fraught => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fray => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frayed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        freak => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        freakish => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        freedom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        freehold => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        freelance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        freely => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        freeway => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        freeze => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        freezer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        freezing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        freight => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frenetic => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        frenzied => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frenzy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frequency => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frequent => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frequently => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fresco => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        freshman => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fret => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        friction => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        friend => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        friendliness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        friendly => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        friendship => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        frigate => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fright => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        frighten => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        frightened => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        frightful => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        frigid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fringe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fringed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frisky => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        frivolous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frock => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frog => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frolic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        front => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frontage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frontal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frontier => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fronting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frontispiece => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frost => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frostbite => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frosted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frosty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        froth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frothy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frown => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        frowning => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        frozen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frugal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fruit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fruitful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fruition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fruitless => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        frustrate => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        frustrated => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        frustration => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fudge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fuel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fugitive => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 1 },
        fulcrum => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fulfill => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fulfillment => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        full => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fullness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fully => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        fumble => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fume => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fumigation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fuming => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fun => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        function => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        functional => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fund => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fundamental => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        fundamentally => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        funds => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        funeral => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fungus => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        funk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        funnel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fur => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        furious => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        furiously => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        furlough => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        furnace => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        furnish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        furniture => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        furor => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        furrow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        furtherance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fury => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fuse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        fusion => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        fuss => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        fussy => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        futile => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        futility => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        future => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fuzz => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        fuzzy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gaby => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gag => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        gaggle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gain => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gainful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gaining => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gait => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gala => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        galaxy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gale => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gall => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gallant => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gallantry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gallery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        galley => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gallop => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        galloping => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gallows => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        galore => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        galvanic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gamble => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gambler => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        gambling => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        game => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gaming => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gammon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gamut => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gander => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gang => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gaol => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gap => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gape => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        gaping => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        garage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        garb => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        garbage => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        garbled => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        garden => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gardener => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gardening => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        garish => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        garlic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        garment => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        garner => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        garnet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        garnish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        garrison => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        garter => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gas => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gaseous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gash => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gasification => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gasoline => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gasp => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        gasping => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gastric => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gastronomy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        gateway => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        gather => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gatherer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gathering => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gauche => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gauge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gauging => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        gaunt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gauntlet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gauze => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gavel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gawk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        gaze => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gazebo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gazelle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gazette => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        gazetteer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gear => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gelatin => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        geld => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gelding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gem => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gemini => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gender => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        genealogy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        general => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        generality => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        generalization => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        generally => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        generate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        generation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        generative => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        generator => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        generic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        generosity => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        generous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        genesis => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        genetic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        genetics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        genial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        genital => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        genius => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        genre => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gent => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        genteel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gentleman => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        gentleness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gentry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        genuine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        genus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        geography => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        geology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        geometry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        geranium => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        geriatric => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        germ => { anger => 0, anticipation => 1, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        german => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        germane => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        germinate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        germination => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gestation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gesture => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ghastly => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ghetto => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        ghost => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ghostly => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        giant => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gibberish => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gift => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        gifted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gig => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gigantic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        giggle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gill => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gills => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gilt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gimp => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ginger => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gingerbread => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gingerly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        giraffe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        girder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        girdle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        girl => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        girth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        giving => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        glabrous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glacial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glacier => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glad => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        glade => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gladiator => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gladness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        glance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glare => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glaring => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glass => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glasses => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glassware => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glaze => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gleam => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glean => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glee => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        glen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glib => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glide => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        glimmer => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        glimpse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glint => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glitter => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 1, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glittering => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        globe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        globular => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gloom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        gloomy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        glorification => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        glorify => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        glory => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        gloss => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        glossary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glossy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glove => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glow => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        glowing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        glucose => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glue => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glum => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        glut => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gluten => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gluttony => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        glycerin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gnat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gnome => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        goat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        goatee => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gob => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gobble => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        goblet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        goblin => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        god => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        goddess => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        godfather => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        godless => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        godly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        godsend => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        goggle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        goggles => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gold => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        golden => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        golf => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gondola => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gong => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gonorrhea => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        goo => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        good => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        goodbye => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        goodly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        goodness => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        goods => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        goodwill => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        goody => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gooey => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        goose => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gopher => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gore => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        gorge => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gorgeous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gorilla => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gory => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        gospel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        gossip => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gouge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gourmet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gout => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        govern => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        governess => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        governing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        government => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        governor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        gown => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grab => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grace => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        graceful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gracious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        graciously => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gradation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grade => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grader => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gradient => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gradual => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gradually => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        graduation => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        grain => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gram => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grammar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        grand => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grandchildren => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        grandeur => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        grandfather => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        grandiose => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grandmother => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        grange => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        granite => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grant => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        granted => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        grantee => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grantor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        granular => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        granule => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grapes => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        graphics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grapple => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grasp => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grasping => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grass => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grasshopper => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grassy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grated => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grateful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gratify => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        grating => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gratis => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gratitude => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gratuitous => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gratuity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grave => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        gravel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        graver => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gravitate => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gravitation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gravity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gravy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gray => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        graze => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grease => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        greasy => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        greater => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        greatest => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        greatly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        greatness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        greed => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        greedy => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        green => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        greenhouse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        greenish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        greenwood => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        greet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        greeting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        gregarious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        grenade => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grey => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        greyhound => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gridiron => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grief => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        grievance => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        grieve => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        grievous => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        griffin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grill => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grille => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grim => { anger => 1, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        grime => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grimy => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grin => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        grind => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grinder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grinding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grip => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grisly => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        grit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        gritty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grizzly => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        groan => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        grocer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        groceries => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grocery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        groggy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        groin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        groom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        groove => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grope => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gross => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grotesque => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grotto => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ground => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        grounded => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        groundless => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grounds => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        groundwork => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        group => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grouping => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grouse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grout => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grove => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grow => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        growl => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        growling => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        growth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        grub => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grudge => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grudgingly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gruesome => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gruff => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grumble => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        grumpy => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        grunt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        guarantee => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        guaranty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        guard => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        guarded => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        guardian => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        guardianship => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        guards => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gubernatorial => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        guerilla => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        guess => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        guesswork => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        guest => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        guidance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        guide => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        guidebook => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        guild => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        guile => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        guillotine => { anger => 1, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        guilt => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        guilty => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        guinea => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        guise => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        guitar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gules => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gulf => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gull => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gullible => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 1 },
        gully => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gulp => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        gum => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gummy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gun => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gunner => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gunpowder => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        guru => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        gush => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 1, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gusset => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        gust => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gusty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gut => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        guts => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gutter => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        guy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        guzzling => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gymnasium => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gymnast => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        gymnastic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gymnastics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gynecology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gypsy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        gyroscope => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        habit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        habitat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        habitation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        habitual => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        habitually => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hacienda => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hag => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        haggard => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        haggle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hail => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        hair => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hairy => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hale => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        half => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        halfway => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hall => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hallowed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hallucination => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        halo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        halt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        halter => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        halting => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        halve => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        halving => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ham => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hamlet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hammer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hammering => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hammock => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hamper => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hamstring => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hand => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        handbook => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        handful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        handicap => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        handicraft => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        handiwork => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        handkerchief => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        handle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        handsome => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        handwriting => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        handy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        hang => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hangar => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hanging => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hangman => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hangout => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hank => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hankering => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hap => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        haphazard => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        happen => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        happening => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        happily => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        happiness => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        happy => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        harass => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        harassing => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        harbinger => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        harbor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        harden => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hardened => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hardening => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hardness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hardship => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hardware => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hardy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        hare => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        harem => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        harlot => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        harm => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        harmful => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        harmonica => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        harmonics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        harmoniously => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        harmonize => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        harmony => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        harness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        harper => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        harpsichord => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        harrowing => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        harry => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        harshness => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hart => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        harvest => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        hash => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hashish => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        haste => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hasten => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hastily => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hasty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hatch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hatchet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hate => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hateful => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hating => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hatred => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        haughty => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        haul => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        haulage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        haunt => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        haunted => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        haven => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        havoc => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        haw => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hawk => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hawking => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hazard => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hazardous => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        haze => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hazy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        head => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        headache => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        headdress => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        header => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        headgear => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heading => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        headland => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        headlight => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        headline => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        headlong => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        headquarters => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        headstone => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        headway => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        heady => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        healing => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        health => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        healthful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        healthy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        heap => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hear => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hearer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hearing => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hearsay => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hearse => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        heart => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heartache => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        heartburn => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heartfelt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 1, surprise => 0, trust => 1 },
        hearth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        heartily => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        heartless => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hearts => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heartworm => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heat => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heated => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heater => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heath => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heathen => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heather => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heating => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heave => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heavenly => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        heavens => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        heavily => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heaviness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heaving => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hectares => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hectic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hedge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hedgehog => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hedonism => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 1, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        heed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heels => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heft => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        hegemonic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heifer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        height => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heighten => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heinous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heir => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heiress => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heirloom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heirs => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        helical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        helix => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hell => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hellish => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        helm => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        helmet => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        helper => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        helpful => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        helpless => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        helplessness => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hem => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hematite => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hemi => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hemisphere => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hemispheric => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hemlock => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hemorrhage => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hemorrhoids => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hemp => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        henceforth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        herald => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heraldry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        herb => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        herbaceous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        herbal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        herbarium => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        herd => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hereditary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heredity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heresy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heretic => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heretical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heretofore => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hereunto => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        herewith => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heritage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        hermaphrodite => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        hermeneutics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hermit => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 1 },
        hernia => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hero => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        heroic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        heroics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        heroin => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heroine => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        heroism => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        herpes => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        herpesvirus => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hesitating => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hesitation => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heterogeneity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hew => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hexagon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        heyday => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        hiatus => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hibernate => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hibernation => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hiccup => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hidden => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hide => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hideous => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hiding => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hierarchical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        high => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        higher => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        highest => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 1, negative => 1, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        highland => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        highlands => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hight => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        highway => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hiker => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hilarious => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 0 },
        hilarity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        hill => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hilly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hilt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hind => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hindering => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hindrance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hinge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hint => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hinterland => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hip => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hippie => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hire => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        hirsute => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hiss => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hissing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        histology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        historian => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        historic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        historiography => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        history => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hit => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hitherto => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hive => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hoard => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hoarse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hoary => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hoax => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        hob => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hobby => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        hobo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hockey => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hoe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hog => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hoist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hold => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        holder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        holding => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hole => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        holiday => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        holiness => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        hollow => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        holocaust => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        holy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        homage => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        homeless => { anger => 1, anticipation => 1, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        homeopathic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        homeopathy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        homesick => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        homestead => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        homework => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        homicidal => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        homicide => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        homily => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        homogeneity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        homogeneous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        homologous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        homologue => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        homology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        homosexual => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        homosexuality => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hone => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        honest => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 1, negative => 0, positive => 1, sadness => 1, surprise => 0, trust => 1 },
        honesty => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        honey => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        honeycomb => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        honeymoon => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        honeysuckle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        honor => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        honorable => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        honorarium => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hood => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hooded => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hoof => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hook => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hooked => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hooker => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hoop => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hoot => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hop => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hope => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        hopeful => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        hopeless => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hopelessness => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hopes => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hoping => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hopper => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        horde => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        horizon => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        horizontal => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        horizontally => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        horn => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hornet => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        horny => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        horoscope => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        horrible => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        horribly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        horrid => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        horrific => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        horrified => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        horrifying => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        horror => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        horrors => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        horse => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 1 },
        horseman => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        horseshoe => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        horticultural => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        horticulture => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hose => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hosiery => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hospice => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hospital => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 1, surprise => 0, trust => 1 },
        hospitality => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        hostage => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hostel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hostile => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hostilities => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hostility => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hot => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hotbed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hotel => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hour => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hourglass => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hourly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        house => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        household => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        householder => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        housekeeper => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        housekeeping => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        housewife => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        housing => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hovercraft => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        howl => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 1, trust => 0 },
        howsoever => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hoy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hub => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        huddle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hue => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        huff => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hug => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        huge => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hulk => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hull => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hum => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        human => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        humane => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        humanitarian => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 1, trust => 1 },
        humanities => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        humanity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        humble => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 1, sadness => 1, surprise => 0, trust => 0 },
        humbled => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 1, surprise => 0, trust => 0 },
        humbly => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        humbug => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        humid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        humidity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        humiliate => { anger => 1, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        humiliating => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        humiliation => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        humility => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        hummer => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hummingbird => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        humongous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        humorist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        humorous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        hump => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hunch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hundred => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hundredth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hunger => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hungry => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hunk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hunks => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hunt => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hunter => { anger => 0, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hunting => { anger => 1, anticipation => 1, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hurl => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hurrah => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        hurricane => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hurried => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hurry => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hurt => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hurtful => { anger => 1, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hurting => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        husbandry => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 1 },
        hush => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        hushed => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        husk => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        husky => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hustle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hustler => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hut => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 1, surprise => 0, trust => 0 },
        hutch => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hyacinth => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hybrid => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hydra => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hydraulics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hydrocephalus => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        hydrodynamics => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hydrogen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hydrographic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hydrology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hygiene => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hygienic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        hymn => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 1, negative => 0, positive => 1, sadness => 1, surprise => 0, trust => 1 },
        hype => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hyperbole => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hypertrophy => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        hyphen => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hypnotic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hypnotized => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hypocrisy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hypocrite => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hypocritical => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hypothesis => { anger => 0, anticipation => 1, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 1, trust => 0 },
        hypothetical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hysteria => { anger => 0, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        hysterical => { anger => 1, anticipation => 0, disgust => 0, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ice => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        iceberg => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        icon => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        iconic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        iconography => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        icy => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        idea => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        idealism => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        idealist => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        identical => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        identically => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        identification => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        identify => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        identity => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ideology => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        idiocy => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 1, surprise => 0, trust => 0 },
        idiom => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        idiomatic => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        idiot => { anger => 0, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        idiotic => { anger => 1, anticipation => 0, disgust => 1, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        idle => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        idleness => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        idler => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        idol => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 1, sadness => 0, surprise => 0, trust => 0 },
        idolatry => { anger => 0, anticipation => 0, disgust => 1, fear => 1, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        igloo => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        igneous => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ignite => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ignition => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 0, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ignorance => { anger => 0, anticipation => 0, disgust => 0, fear => 0, joy => 0, negative => 1, positive => 0, sadness => 0, surprise => 0, trust => 0 },
        ignorant => { anger => 0, anticipatio